/* valamarkupreader.c generated by valac, the Vala compiler
 * generated from valamarkupreader.vala, do not modify */

/* valamarkupreader.vala
 *
 * Copyright (C) 2008-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_MARKUP_READER (vala_markup_reader_get_type ())
#define VALA_MARKUP_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MARKUP_READER, ValaMarkupReader))
#define VALA_MARKUP_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MARKUP_READER, ValaMarkupReaderClass))
#define VALA_IS_MARKUP_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MARKUP_READER))
#define VALA_IS_MARKUP_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MARKUP_READER))
#define VALA_MARKUP_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MARKUP_READER, ValaMarkupReaderClass))

typedef struct _ValaMarkupReader ValaMarkupReader;
typedef struct _ValaMarkupReaderClass ValaMarkupReaderClass;
typedef struct _ValaMarkupReaderPrivate ValaMarkupReaderPrivate;
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

#define VALA_TYPE_SOURCE_LOCATION (vala_source_location_get_type ())
typedef struct _ValaSourceLocation ValaSourceLocation;

#define VALA_TYPE_MARKUP_TOKEN_TYPE (vala_markup_token_type_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMarkupReader {
	GObject parent_instance;
	ValaMarkupReaderPrivate * priv;
};

struct _ValaMarkupReaderClass {
	GObjectClass parent_class;
};

struct _ValaMarkupReaderPrivate {
	gchar* _filename;
	gchar* _name;
	gchar* _content;
	GMappedFile* mapped_file;
	gchar* begin;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	ValaMap* attributes;
	gboolean empty_element;
};

struct _ValaSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

typedef enum  {
	VALA_MARKUP_TOKEN_TYPE_NONE,
	VALA_MARKUP_TOKEN_TYPE_START_ELEMENT,
	VALA_MARKUP_TOKEN_TYPE_END_ELEMENT,
	VALA_MARKUP_TOKEN_TYPE_TEXT,
	VALA_MARKUP_TOKEN_TYPE_EOF
} ValaMarkupTokenType;


static gpointer vala_markup_reader_parent_class = NULL;

GType vala_markup_reader_get_type (void) G_GNUC_CONST;
#define VALA_MARKUP_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_MARKUP_READER, ValaMarkupReaderPrivate))
enum  {
	VALA_MARKUP_READER_DUMMY_PROPERTY,
	VALA_MARKUP_READER_FILENAME,
	VALA_MARKUP_READER_NAME,
	VALA_MARKUP_READER_CONTENT
};
ValaMarkupReader* vala_markup_reader_new (const gchar* filename);
ValaMarkupReader* vala_markup_reader_construct (GType object_type, const gchar* filename);
static void vala_markup_reader_set_filename (ValaMarkupReader* self, const gchar* value);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
void vala_report_error (ValaSourceReference* source, const gchar* message);
gchar* vala_markup_reader_get_attribute (ValaMarkupReader* self, const gchar* attr);
ValaMap* vala_markup_reader_get_attributes (ValaMarkupReader* self);
static gchar* vala_markup_reader_read_name (ValaMarkupReader* self);
GType vala_source_location_get_type (void) G_GNUC_CONST;
ValaSourceLocation* vala_source_location_dup (const ValaSourceLocation* self);
void vala_source_location_free (ValaSourceLocation* self);
GType vala_markup_token_type_get_type (void) G_GNUC_CONST;
ValaMarkupTokenType vala_markup_reader_read_token (ValaMarkupReader* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
void vala_source_location_init (ValaSourceLocation *self, gchar* _pos, gint _line, gint _column);
static void vala_markup_reader_space (ValaMarkupReader* self);
static void vala_markup_reader_set_name (ValaMarkupReader* self, const gchar* value);
static gchar* vala_markup_reader_text (ValaMarkupReader* self, gchar end_char, gboolean rm_trailing_whitespace);
static void vala_markup_reader_set_content (ValaMarkupReader* self, const gchar* value);
const gchar* vala_markup_reader_get_filename (ValaMarkupReader* self);
const gchar* vala_markup_reader_get_name (ValaMarkupReader* self);
const gchar* vala_markup_reader_get_content (ValaMarkupReader* self);
static void vala_markup_reader_finalize (GObject * obj);
static void _vala_vala_markup_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_vala_markup_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
const gchar* vala_markup_token_type_to_string (ValaMarkupTokenType self);


ValaMarkupReader* vala_markup_reader_construct (GType object_type, const gchar* filename) {
	ValaMarkupReader * self = NULL;
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (ValaMarkupReader*) g_object_new (object_type, NULL);
	_tmp0_ = filename;
	vala_markup_reader_set_filename (self, _tmp0_);
	{
		GMappedFile* _tmp1_;
		const gchar* _tmp2_;
		GMappedFile* _tmp3_;
		GMappedFile* _tmp4_;
		GMappedFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GMappedFile* _tmp8_;
		gsize _tmp9_;
		gchar* _tmp10_;
		_tmp2_ = filename;
		_tmp3_ = g_mapped_file_new (_tmp2_, FALSE, &_inner_error_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch11_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_mapped_file_unref0 (self->priv->mapped_file);
		self->priv->mapped_file = _tmp4_;
		_tmp5_ = self->priv->mapped_file;
		_tmp6_ = g_mapped_file_get_contents (_tmp5_);
		self->priv->begin = _tmp6_;
		_tmp7_ = self->priv->begin;
		_tmp8_ = self->priv->mapped_file;
		_tmp9_ = g_mapped_file_get_length (_tmp8_);
		self->priv->end = _tmp7_ + _tmp9_;
		_tmp10_ = self->priv->begin;
		self->priv->current = _tmp10_;
		self->priv->line = 1;
		self->priv->column = 1;
		_g_mapped_file_unref0 (_tmp1_);
	}
	goto __finally11;
	__catch11_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = filename;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		_tmp14_ = g_strdup_printf ("Unable to map file `%s': %s", _tmp11_, _tmp13_);
		_tmp15_ = _tmp14_;
		vala_report_error (NULL, _tmp15_);
		g_free (_tmp15_);
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


ValaMarkupReader* vala_markup_reader_new (const gchar* filename) {
	return vala_markup_reader_construct (VALA_TYPE_MARKUP_READER, filename);
}


gchar* vala_markup_reader_get_attribute (ValaMarkupReader* self, const gchar* attr) {
	gchar* result = NULL;
	ValaMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attr != NULL, NULL);
	_tmp0_ = self->priv->attributes;
	_tmp1_ = attr;
	_tmp2_ = vala_map_get (_tmp0_, _tmp1_);
	result = (gchar*) _tmp2_;
	return result;
}


ValaMap* vala_markup_reader_get_attributes (ValaMarkupReader* self) {
	ValaMap* result = NULL;
	ValaHashMap* _result_;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp0_, _tmp1_, _tmp2_);
	_result_ = _tmp3_;
	{
		ValaIterator* _key_it;
		ValaMap* _tmp4_;
		ValaSet* _tmp5_;
		ValaSet* _tmp6_;
		ValaIterator* _tmp7_;
		ValaIterator* _tmp8_;
		_tmp4_ = self->priv->attributes;
		_tmp5_ = vala_map_get_keys (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_iterable_iterator ((ValaIterable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_vala_iterable_unref0 (_tmp6_);
		_key_it = _tmp8_;
		while (TRUE) {
			ValaIterator* _tmp9_;
			gboolean _tmp10_;
			gchar* key;
			ValaIterator* _tmp11_;
			gpointer _tmp12_;
			ValaHashMap* _tmp13_;
			const gchar* _tmp14_;
			ValaMap* _tmp15_;
			const gchar* _tmp16_;
			gpointer _tmp17_;
			gchar* _tmp18_;
			_tmp9_ = _key_it;
			_tmp10_ = vala_iterator_next (_tmp9_);
			if (!_tmp10_) {
				break;
			}
			_tmp11_ = _key_it;
			_tmp12_ = vala_iterator_get (_tmp11_);
			key = (gchar*) _tmp12_;
			_tmp13_ = _result_;
			_tmp14_ = key;
			_tmp15_ = self->priv->attributes;
			_tmp16_ = key;
			_tmp17_ = vala_map_get (_tmp15_, _tmp16_);
			_tmp18_ = (gchar*) _tmp17_;
			vala_map_set ((ValaMap*) _tmp13_, _tmp14_, _tmp18_);
			g_free (_tmp18_);
			g_free (key);
		}
		_vala_iterator_unref0 (_key_it);
	}
	result = (ValaMap*) _result_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* vala_markup_reader_read_name (ValaMarkupReader* self) {
	gchar* result = NULL;
	gchar* begin;
	gchar* _tmp0_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	while (TRUE) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gchar* _tmp8_;
		gchar _tmp9_;
		gunichar u;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gunichar _tmp23_;
		gunichar _tmp24_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (!(_tmp1_ < _tmp2_)) {
			break;
		}
		_tmp8_ = self->priv->current;
		_tmp9_ = _tmp8_[0];
		if (_tmp9_ == ' ') {
			_tmp7_ = TRUE;
		} else {
			gchar* _tmp10_;
			gchar _tmp11_;
			_tmp10_ = self->priv->current;
			_tmp11_ = _tmp10_[0];
			_tmp7_ = _tmp11_ == '\t';
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			gchar* _tmp12_;
			gchar _tmp13_;
			_tmp12_ = self->priv->current;
			_tmp13_ = _tmp12_[0];
			_tmp6_ = _tmp13_ == '>';
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			gchar* _tmp14_;
			gchar _tmp15_;
			_tmp14_ = self->priv->current;
			_tmp15_ = _tmp14_[0];
			_tmp5_ = _tmp15_ == '/';
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			gchar* _tmp16_;
			gchar _tmp17_;
			_tmp16_ = self->priv->current;
			_tmp17_ = _tmp16_[0];
			_tmp4_ = _tmp17_ == '=';
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			gchar* _tmp18_;
			gchar _tmp19_;
			_tmp18_ = self->priv->current;
			_tmp19_ = _tmp18_[0];
			_tmp3_ = _tmp19_ == '\n';
		}
		if (_tmp3_) {
			break;
		}
		_tmp20_ = self->priv->current;
		_tmp21_ = self->priv->end;
		_tmp22_ = self->priv->current;
		_tmp23_ = g_utf8_get_char_validated ((const gchar*) _tmp20_, (gssize) ((glong) (_tmp21_ - _tmp22_)));
		u = _tmp23_;
		_tmp24_ = u;
		if (_tmp24_ != ((gunichar) -1)) {
			gchar* _tmp25_;
			gunichar _tmp26_;
			gint _tmp27_;
			_tmp25_ = self->priv->current;
			_tmp26_ = u;
			_tmp27_ = g_unichar_to_utf8 (_tmp26_, NULL);
			self->priv->current = _tmp25_ + _tmp27_;
		} else {
			vala_report_error (NULL, "invalid UTF-8 character");
		}
	}
	_tmp28_ = self->priv->current;
	_tmp29_ = begin;
	if (_tmp28_ == _tmp29_) {
	}
	_tmp30_ = begin;
	_tmp31_ = self->priv->current;
	_tmp32_ = begin;
	_tmp33_ = string_substring ((const gchar*) _tmp30_, (glong) 0, (glong) ((gint) (_tmp31_ - _tmp32_)));
	result = _tmp33_;
	return result;
}


ValaMarkupTokenType vala_markup_reader_read_token (ValaMarkupReader* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaMarkupTokenType result = 0;
	ValaMap* _tmp0_;
	gboolean _tmp1_;
	ValaMarkupTokenType type;
	gchar* begin;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp118_;
	gint _tmp119_;
	gint _tmp120_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->attributes;
	vala_map_clear (_tmp0_);
	_tmp1_ = self->priv->empty_element;
	if (_tmp1_) {
		gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		self->priv->empty_element = FALSE;
		_tmp2_ = self->priv->begin;
		_tmp3_ = self->priv->line;
		_tmp4_ = self->priv->column;
		vala_source_location_init (&_vala_token_begin, _tmp2_, _tmp3_, _tmp4_);
		_tmp5_ = self->priv->begin;
		_tmp6_ = self->priv->line;
		_tmp7_ = self->priv->column;
		vala_source_location_init (&_vala_token_end, _tmp5_, _tmp6_, _tmp7_);
		result = VALA_MARKUP_TOKEN_TYPE_END_ELEMENT;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	}
	vala_markup_reader_space (self);
	type = VALA_MARKUP_TOKEN_TYPE_NONE;
	_tmp8_ = self->priv->current;
	begin = _tmp8_;
	_tmp9_ = begin;
	_tmp10_ = self->priv->line;
	_tmp11_ = self->priv->column;
	vala_source_location_init (&_vala_token_begin, _tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = self->priv->current;
	_tmp13_ = self->priv->end;
	if (_tmp12_ >= _tmp13_) {
		type = VALA_MARKUP_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp14_;
		gchar _tmp15_;
		_tmp14_ = self->priv->current;
		_tmp15_ = _tmp14_[0];
		if (_tmp15_ == '<') {
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp16_ = self->priv->current;
			self->priv->current = _tmp16_ + 1;
			_tmp17_ = self->priv->current;
			_tmp18_ = self->priv->end;
			if (_tmp17_ >= _tmp18_) {
			} else {
				gchar* _tmp19_;
				gchar _tmp20_;
				_tmp19_ = self->priv->current;
				_tmp20_ = _tmp19_[0];
				if (_tmp20_ == '?') {
				} else {
					gchar* _tmp21_;
					gchar _tmp22_;
					_tmp21_ = self->priv->current;
					_tmp22_ = _tmp21_[0];
					if (_tmp22_ == '!') {
						gchar* _tmp23_;
						gboolean _tmp24_ = FALSE;
						gboolean _tmp25_ = FALSE;
						gchar* _tmp26_;
						gchar* _tmp27_;
						_tmp23_ = self->priv->current;
						self->priv->current = _tmp23_ + 1;
						_tmp26_ = self->priv->current;
						_tmp27_ = self->priv->end;
						if (_tmp26_ < (_tmp27_ - 1)) {
							gchar* _tmp28_;
							gchar _tmp29_;
							_tmp28_ = self->priv->current;
							_tmp29_ = _tmp28_[0];
							_tmp25_ = _tmp29_ == '-';
						} else {
							_tmp25_ = FALSE;
						}
						if (_tmp25_) {
							gchar* _tmp30_;
							gchar _tmp31_;
							_tmp30_ = self->priv->current;
							_tmp31_ = _tmp30_[1];
							_tmp24_ = _tmp31_ == '-';
						} else {
							_tmp24_ = FALSE;
						}
						if (_tmp24_) {
							gchar* _tmp32_;
							ValaSourceLocation _tmp48_ = {0};
							ValaSourceLocation _tmp49_ = {0};
							ValaMarkupTokenType _tmp50_;
							_tmp32_ = self->priv->current;
							self->priv->current = _tmp32_ + 2;
							while (TRUE) {
								gchar* _tmp33_;
								gchar* _tmp34_;
								gboolean _tmp35_ = FALSE;
								gboolean _tmp36_ = FALSE;
								gchar* _tmp37_;
								gchar _tmp38_;
								gchar* _tmp47_;
								_tmp33_ = self->priv->current;
								_tmp34_ = self->priv->end;
								if (!(_tmp33_ < (_tmp34_ - 2))) {
									break;
								}
								_tmp37_ = self->priv->current;
								_tmp38_ = _tmp37_[0];
								if (_tmp38_ == '-') {
									gchar* _tmp39_;
									gchar _tmp40_;
									_tmp39_ = self->priv->current;
									_tmp40_ = _tmp39_[1];
									_tmp36_ = _tmp40_ == '-';
								} else {
									_tmp36_ = FALSE;
								}
								if (_tmp36_) {
									gchar* _tmp41_;
									gchar _tmp42_;
									_tmp41_ = self->priv->current;
									_tmp42_ = _tmp41_[2];
									_tmp35_ = _tmp42_ == '>';
								} else {
									_tmp35_ = FALSE;
								}
								if (_tmp35_) {
									gchar* _tmp43_;
									_tmp43_ = self->priv->current;
									self->priv->current = _tmp43_ + 3;
									break;
								} else {
									gchar* _tmp44_;
									gchar _tmp45_;
									_tmp44_ = self->priv->current;
									_tmp45_ = _tmp44_[0];
									if (_tmp45_ == '\n') {
										gint _tmp46_;
										_tmp46_ = self->priv->line;
										self->priv->line = _tmp46_ + 1;
										self->priv->column = 0;
									}
								}
								_tmp47_ = self->priv->current;
								self->priv->current = _tmp47_ + 1;
							}
							_tmp50_ = vala_markup_reader_read_token (self, &_tmp48_, &_tmp49_);
							_vala_token_begin = _tmp48_;
							_vala_token_end = _tmp49_;
							result = _tmp50_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					} else {
						gchar* _tmp51_;
						gchar _tmp52_;
						_tmp51_ = self->priv->current;
						_tmp52_ = _tmp51_[0];
						if (_tmp52_ == '/') {
							gchar* _tmp53_;
							gchar* _tmp54_;
							gchar* _tmp55_;
							gboolean _tmp56_ = FALSE;
							gchar* _tmp57_;
							gchar* _tmp58_;
							gchar* _tmp61_;
							type = VALA_MARKUP_TOKEN_TYPE_END_ELEMENT;
							_tmp53_ = self->priv->current;
							self->priv->current = _tmp53_ + 1;
							_tmp54_ = vala_markup_reader_read_name (self);
							_tmp55_ = _tmp54_;
							vala_markup_reader_set_name (self, _tmp55_);
							g_free (_tmp55_);
							_tmp57_ = self->priv->current;
							_tmp58_ = self->priv->end;
							if (_tmp57_ >= _tmp58_) {
								_tmp56_ = TRUE;
							} else {
								gchar* _tmp59_;
								gchar _tmp60_;
								_tmp59_ = self->priv->current;
								_tmp60_ = _tmp59_[0];
								_tmp56_ = _tmp60_ != '>';
							}
							if (_tmp56_) {
							}
							_tmp61_ = self->priv->current;
							self->priv->current = _tmp61_ + 1;
						} else {
							gchar* _tmp62_;
							gchar* _tmp63_;
							gchar* _tmp102_;
							gchar _tmp103_;
							gboolean _tmp105_ = FALSE;
							gchar* _tmp106_;
							gchar* _tmp107_;
							gchar* _tmp110_;
							type = VALA_MARKUP_TOKEN_TYPE_START_ELEMENT;
							_tmp62_ = vala_markup_reader_read_name (self);
							_tmp63_ = _tmp62_;
							vala_markup_reader_set_name (self, _tmp63_);
							g_free (_tmp63_);
							vala_markup_reader_space (self);
							while (TRUE) {
								gboolean _tmp64_ = FALSE;
								gboolean _tmp65_ = FALSE;
								gchar* _tmp66_;
								gchar* _tmp67_;
								gchar* attr_name;
								gchar* _tmp72_;
								gboolean _tmp73_ = FALSE;
								gchar* _tmp74_;
								gchar* _tmp75_;
								gchar* _tmp78_;
								gboolean _tmp79_ = FALSE;
								gboolean _tmp80_ = FALSE;
								gchar* _tmp81_;
								gchar* _tmp82_;
								gchar quote;
								gchar* _tmp87_;
								gchar _tmp88_;
								gchar* _tmp89_;
								gchar* attr_value;
								gchar _tmp90_;
								gchar* _tmp91_;
								gboolean _tmp92_ = FALSE;
								gchar* _tmp93_;
								gchar* _tmp94_;
								gchar* _tmp98_;
								ValaMap* _tmp99_;
								const gchar* _tmp100_;
								const gchar* _tmp101_;
								_tmp66_ = self->priv->current;
								_tmp67_ = self->priv->end;
								if (_tmp66_ < _tmp67_) {
									gchar* _tmp68_;
									gchar _tmp69_;
									_tmp68_ = self->priv->current;
									_tmp69_ = _tmp68_[0];
									_tmp65_ = _tmp69_ != '>';
								} else {
									_tmp65_ = FALSE;
								}
								if (_tmp65_) {
									gchar* _tmp70_;
									gchar _tmp71_;
									_tmp70_ = self->priv->current;
									_tmp71_ = _tmp70_[0];
									_tmp64_ = _tmp71_ != '/';
								} else {
									_tmp64_ = FALSE;
								}
								if (!_tmp64_) {
									break;
								}
								_tmp72_ = vala_markup_reader_read_name (self);
								attr_name = _tmp72_;
								_tmp74_ = self->priv->current;
								_tmp75_ = self->priv->end;
								if (_tmp74_ >= _tmp75_) {
									_tmp73_ = TRUE;
								} else {
									gchar* _tmp76_;
									gchar _tmp77_;
									_tmp76_ = self->priv->current;
									_tmp77_ = _tmp76_[0];
									_tmp73_ = _tmp77_ != '=';
								}
								if (_tmp73_) {
								}
								_tmp78_ = self->priv->current;
								self->priv->current = _tmp78_ + 1;
								_tmp81_ = self->priv->current;
								_tmp82_ = self->priv->end;
								if (_tmp81_ >= _tmp82_) {
									_tmp80_ = TRUE;
								} else {
									gchar* _tmp83_;
									gchar _tmp84_;
									_tmp83_ = self->priv->current;
									_tmp84_ = _tmp83_[0];
									_tmp80_ = _tmp84_ != '"';
								}
								if (_tmp80_) {
									_tmp79_ = TRUE;
								} else {
									gchar* _tmp85_;
									gchar _tmp86_;
									_tmp85_ = self->priv->current;
									_tmp86_ = _tmp85_[0];
									_tmp79_ = _tmp86_ != '\'';
								}
								if (_tmp79_) {
								}
								_tmp87_ = self->priv->current;
								_tmp88_ = _tmp87_[0];
								quote = _tmp88_;
								_tmp89_ = self->priv->current;
								self->priv->current = _tmp89_ + 1;
								_tmp90_ = quote;
								_tmp91_ = vala_markup_reader_text (self, _tmp90_, FALSE);
								attr_value = _tmp91_;
								_tmp93_ = self->priv->current;
								_tmp94_ = self->priv->end;
								if (_tmp93_ >= _tmp94_) {
									_tmp92_ = TRUE;
								} else {
									gchar* _tmp95_;
									gchar _tmp96_;
									gchar _tmp97_;
									_tmp95_ = self->priv->current;
									_tmp96_ = _tmp95_[0];
									_tmp97_ = quote;
									_tmp92_ = _tmp96_ != _tmp97_;
								}
								if (_tmp92_) {
								}
								_tmp98_ = self->priv->current;
								self->priv->current = _tmp98_ + 1;
								_tmp99_ = self->priv->attributes;
								_tmp100_ = attr_name;
								_tmp101_ = attr_value;
								vala_map_set (_tmp99_, _tmp100_, _tmp101_);
								vala_markup_reader_space (self);
								g_free (attr_value);
								g_free (attr_name);
							}
							_tmp102_ = self->priv->current;
							_tmp103_ = _tmp102_[0];
							if (_tmp103_ == '/') {
								gchar* _tmp104_;
								self->priv->empty_element = TRUE;
								_tmp104_ = self->priv->current;
								self->priv->current = _tmp104_ + 1;
								vala_markup_reader_space (self);
							} else {
								self->priv->empty_element = FALSE;
							}
							_tmp106_ = self->priv->current;
							_tmp107_ = self->priv->end;
							if (_tmp106_ >= _tmp107_) {
								_tmp105_ = TRUE;
							} else {
								gchar* _tmp108_;
								gchar _tmp109_;
								_tmp108_ = self->priv->current;
								_tmp109_ = _tmp108_[0];
								_tmp105_ = _tmp109_ != '>';
							}
							if (_tmp105_) {
							}
							_tmp110_ = self->priv->current;
							self->priv->current = _tmp110_ + 1;
						}
					}
				}
			}
		} else {
			gchar* _tmp111_;
			gchar _tmp112_;
			vala_markup_reader_space (self);
			_tmp111_ = self->priv->current;
			_tmp112_ = _tmp111_[0];
			if (_tmp112_ != '<') {
				gchar* _tmp113_;
				gchar* _tmp114_;
				_tmp113_ = vala_markup_reader_text (self, '<', TRUE);
				_tmp114_ = _tmp113_;
				vala_markup_reader_set_content (self, _tmp114_);
				g_free (_tmp114_);
			} else {
				ValaSourceLocation _tmp115_ = {0};
				ValaSourceLocation _tmp116_ = {0};
				ValaMarkupTokenType _tmp117_;
				_tmp117_ = vala_markup_reader_read_token (self, &_tmp115_, &_tmp116_);
				_vala_token_begin = _tmp115_;
				_vala_token_end = _tmp116_;
				result = _tmp117_;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
			type = VALA_MARKUP_TOKEN_TYPE_TEXT;
		}
	}
	_tmp118_ = self->priv->current;
	_tmp119_ = self->priv->line;
	_tmp120_ = self->priv->column;
	vala_source_location_init (&_vala_token_end, _tmp118_, _tmp119_, _tmp120_ - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


static gchar* vala_markup_reader_text (ValaMarkupReader* self, gchar end_char, gboolean rm_trailing_whitespace) {
	gchar* result = NULL;
	GString* content;
	GString* _tmp0_;
	gchar* text_begin;
	gchar* _tmp1_;
	gchar* last_linebreak;
	gchar* _tmp2_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gint _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gboolean _tmp94_;
	GString* _tmp113_;
	const gchar* _tmp114_;
	gchar* _tmp115_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	content = _tmp0_;
	_tmp1_ = self->priv->current;
	text_begin = _tmp1_;
	_tmp2_ = self->priv->current;
	last_linebreak = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gunichar u;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gunichar _tmp12_;
		gunichar _tmp13_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		if (_tmp4_ < _tmp5_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			gchar _tmp8_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp8_ = end_char;
			_tmp3_ = _tmp7_ != _tmp8_;
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp9_ = self->priv->current;
		_tmp10_ = self->priv->end;
		_tmp11_ = self->priv->current;
		_tmp12_ = g_utf8_get_char_validated ((const gchar*) _tmp9_, (gssize) ((glong) (_tmp10_ - _tmp11_)));
		u = _tmp12_;
		_tmp13_ = u;
		if (_tmp13_ == ((gunichar) -1)) {
			vala_report_error (NULL, "invalid UTF-8 character");
		} else {
			gunichar _tmp14_;
			_tmp14_ = u;
			if (_tmp14_ == ((gunichar) '&')) {
				gchar* next_pos;
				gchar* _tmp15_;
				gunichar _tmp16_;
				gint _tmp17_;
				gchar* _tmp18_;
				gboolean _tmp19_;
				_tmp15_ = self->priv->current;
				_tmp16_ = u;
				_tmp17_ = g_unichar_to_utf8 (_tmp16_, NULL);
				next_pos = _tmp15_ + _tmp17_;
				_tmp18_ = next_pos;
				_tmp19_ = g_str_has_prefix ((const gchar*) _tmp18_, "amp;");
				if (_tmp19_) {
					GString* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					GString* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					_tmp20_ = content;
					_tmp21_ = text_begin;
					_tmp22_ = self->priv->current;
					_tmp23_ = text_begin;
					_tmp24_ = string_substring ((const gchar*) _tmp21_, (glong) 0, (glong) ((gint) (_tmp22_ - _tmp23_)));
					_tmp25_ = _tmp24_;
					g_string_append (_tmp20_, _tmp25_);
					g_free (_tmp25_);
					_tmp26_ = content;
					g_string_append_c (_tmp26_, '&');
					_tmp27_ = self->priv->current;
					self->priv->current = _tmp27_ + 5;
					_tmp28_ = self->priv->current;
					text_begin = _tmp28_;
				} else {
					gchar* _tmp29_;
					gboolean _tmp30_;
					_tmp29_ = next_pos;
					_tmp30_ = g_str_has_prefix ((const gchar*) _tmp29_, "quot;");
					if (_tmp30_) {
						GString* _tmp31_;
						gchar* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						GString* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						_tmp31_ = content;
						_tmp32_ = text_begin;
						_tmp33_ = self->priv->current;
						_tmp34_ = text_begin;
						_tmp35_ = string_substring ((const gchar*) _tmp32_, (glong) 0, (glong) ((gint) (_tmp33_ - _tmp34_)));
						_tmp36_ = _tmp35_;
						g_string_append (_tmp31_, _tmp36_);
						g_free (_tmp36_);
						_tmp37_ = content;
						g_string_append_c (_tmp37_, '"');
						_tmp38_ = self->priv->current;
						self->priv->current = _tmp38_ + 6;
						_tmp39_ = self->priv->current;
						text_begin = _tmp39_;
					} else {
						gchar* _tmp40_;
						gboolean _tmp41_;
						_tmp40_ = next_pos;
						_tmp41_ = g_str_has_prefix ((const gchar*) _tmp40_, "apos;");
						if (_tmp41_) {
							GString* _tmp42_;
							gchar* _tmp43_;
							gchar* _tmp44_;
							gchar* _tmp45_;
							gchar* _tmp46_;
							gchar* _tmp47_;
							GString* _tmp48_;
							gchar* _tmp49_;
							gchar* _tmp50_;
							_tmp42_ = content;
							_tmp43_ = text_begin;
							_tmp44_ = self->priv->current;
							_tmp45_ = text_begin;
							_tmp46_ = string_substring ((const gchar*) _tmp43_, (glong) 0, (glong) ((gint) (_tmp44_ - _tmp45_)));
							_tmp47_ = _tmp46_;
							g_string_append (_tmp42_, _tmp47_);
							g_free (_tmp47_);
							_tmp48_ = content;
							g_string_append_c (_tmp48_, '\'');
							_tmp49_ = self->priv->current;
							self->priv->current = _tmp49_ + 6;
							_tmp50_ = self->priv->current;
							text_begin = _tmp50_;
						} else {
							gchar* _tmp51_;
							gboolean _tmp52_;
							_tmp51_ = next_pos;
							_tmp52_ = g_str_has_prefix ((const gchar*) _tmp51_, "lt;");
							if (_tmp52_) {
								GString* _tmp53_;
								gchar* _tmp54_;
								gchar* _tmp55_;
								gchar* _tmp56_;
								gchar* _tmp57_;
								gchar* _tmp58_;
								GString* _tmp59_;
								gchar* _tmp60_;
								gchar* _tmp61_;
								_tmp53_ = content;
								_tmp54_ = text_begin;
								_tmp55_ = self->priv->current;
								_tmp56_ = text_begin;
								_tmp57_ = string_substring ((const gchar*) _tmp54_, (glong) 0, (glong) ((gint) (_tmp55_ - _tmp56_)));
								_tmp58_ = _tmp57_;
								g_string_append (_tmp53_, _tmp58_);
								g_free (_tmp58_);
								_tmp59_ = content;
								g_string_append_c (_tmp59_, '<');
								_tmp60_ = self->priv->current;
								self->priv->current = _tmp60_ + 4;
								_tmp61_ = self->priv->current;
								text_begin = _tmp61_;
							} else {
								gchar* _tmp62_;
								gboolean _tmp63_;
								_tmp62_ = next_pos;
								_tmp63_ = g_str_has_prefix ((const gchar*) _tmp62_, "gt;");
								if (_tmp63_) {
									GString* _tmp64_;
									gchar* _tmp65_;
									gchar* _tmp66_;
									gchar* _tmp67_;
									gchar* _tmp68_;
									gchar* _tmp69_;
									GString* _tmp70_;
									gchar* _tmp71_;
									gchar* _tmp72_;
									_tmp64_ = content;
									_tmp65_ = text_begin;
									_tmp66_ = self->priv->current;
									_tmp67_ = text_begin;
									_tmp68_ = string_substring ((const gchar*) _tmp65_, (glong) 0, (glong) ((gint) (_tmp66_ - _tmp67_)));
									_tmp69_ = _tmp68_;
									g_string_append (_tmp64_, _tmp69_);
									g_free (_tmp69_);
									_tmp70_ = content;
									g_string_append_c (_tmp70_, '>');
									_tmp71_ = self->priv->current;
									self->priv->current = _tmp71_ + 4;
									_tmp72_ = self->priv->current;
									text_begin = _tmp72_;
								} else {
									gchar* _tmp73_;
									gunichar _tmp74_;
									gint _tmp75_;
									_tmp73_ = self->priv->current;
									_tmp74_ = u;
									_tmp75_ = g_unichar_to_utf8 (_tmp74_, NULL);
									self->priv->current = _tmp73_ + _tmp75_;
								}
							}
						}
					}
				}
			} else {
				gunichar _tmp76_;
				gchar* _tmp79_;
				gunichar _tmp80_;
				gint _tmp81_;
				gint _tmp82_;
				_tmp76_ = u;
				if (_tmp76_ == ((gunichar) '\n')) {
					gint _tmp77_;
					gchar* _tmp78_;
					_tmp77_ = self->priv->line;
					self->priv->line = _tmp77_ + 1;
					self->priv->column = 0;
					_tmp78_ = self->priv->current;
					last_linebreak = _tmp78_;
				}
				_tmp79_ = self->priv->current;
				_tmp80_ = u;
				_tmp81_ = g_unichar_to_utf8 (_tmp80_, NULL);
				self->priv->current = _tmp79_ + _tmp81_;
				_tmp82_ = self->priv->column;
				self->priv->column = _tmp82_ + 1;
			}
		}
	}
	_tmp83_ = text_begin;
	_tmp84_ = self->priv->current;
	if (_tmp83_ != _tmp84_) {
		GString* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		_tmp85_ = content;
		_tmp86_ = text_begin;
		_tmp87_ = self->priv->current;
		_tmp88_ = text_begin;
		_tmp89_ = string_substring ((const gchar*) _tmp86_, (glong) 0, (glong) ((gint) (_tmp87_ - _tmp88_)));
		_tmp90_ = _tmp89_;
		g_string_append (_tmp85_, _tmp90_);
		g_free (_tmp90_);
	}
	_tmp91_ = self->priv->column;
	_tmp92_ = self->priv->current;
	_tmp93_ = last_linebreak;
	self->priv->column = _tmp91_ + ((gint) (_tmp92_ - _tmp93_));
	_tmp94_ = rm_trailing_whitespace;
	if (_tmp94_) {
		gchar* str_pos;
		GString* _tmp95_;
		const gchar* _tmp96_;
		GString* _tmp97_;
		gssize _tmp98_;
		GString* _tmp109_;
		gchar* _tmp110_;
		GString* _tmp111_;
		const gchar* _tmp112_;
		_tmp95_ = content;
		_tmp96_ = _tmp95_->str;
		_tmp97_ = content;
		_tmp98_ = _tmp97_->len;
		str_pos = ((gchar*) _tmp96_) + _tmp98_;
		{
			gchar* _tmp99_;
			gboolean _tmp100_;
			_tmp99_ = str_pos;
			str_pos = _tmp99_ - 1;
			_tmp100_ = TRUE;
			while (TRUE) {
				gboolean _tmp102_ = FALSE;
				gchar* _tmp103_;
				GString* _tmp104_;
				const gchar* _tmp105_;
				if (!_tmp100_) {
					gchar* _tmp101_;
					_tmp101_ = str_pos;
					str_pos = _tmp101_ - 1;
				}
				_tmp100_ = FALSE;
				_tmp103_ = str_pos;
				_tmp104_ = content;
				_tmp105_ = _tmp104_->str;
				if (_tmp103_ > ((gchar*) _tmp105_)) {
					gchar* _tmp106_;
					gchar _tmp107_;
					gboolean _tmp108_;
					_tmp106_ = str_pos;
					_tmp107_ = _tmp106_[0];
					_tmp108_ = g_ascii_isspace (_tmp107_);
					_tmp102_ = _tmp108_;
				} else {
					_tmp102_ = FALSE;
				}
				if (!_tmp102_) {
					break;
				}
			}
		}
		_tmp109_ = content;
		_tmp110_ = str_pos;
		_tmp111_ = content;
		_tmp112_ = _tmp111_->str;
		g_string_erase (_tmp109_, (gssize) ((_tmp110_ - ((gchar*) _tmp112_)) + 1), (gssize) -1);
	}
	_tmp113_ = content;
	_tmp114_ = _tmp113_->str;
	_tmp115_ = g_strdup (_tmp114_);
	result = _tmp115_;
	_g_string_free0 (content);
	return result;
}


static void vala_markup_reader_space (ValaMarkupReader* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp6_;
		gchar _tmp7_;
		gchar* _tmp9_;
		gint _tmp10_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			gboolean _tmp5_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp5_ = g_ascii_isspace (_tmp4_);
			_tmp0_ = _tmp5_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		if (_tmp7_ == '\n') {
			gint _tmp8_;
			_tmp8_ = self->priv->line;
			self->priv->line = _tmp8_ + 1;
			self->priv->column = 0;
		}
		_tmp9_ = self->priv->current;
		self->priv->current = _tmp9_ + 1;
		_tmp10_ = self->priv->column;
		self->priv->column = _tmp10_ + 1;
	}
}


const gchar* vala_markup_reader_get_filename (ValaMarkupReader* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}


static void vala_markup_reader_set_filename (ValaMarkupReader* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, vala_markup_reader_get_filename (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		g_free (self->priv->_filename);
		self->priv->_filename = _tmp1_;
		g_object_notify ((GObject *) self, "filename");
	}
}


const gchar* vala_markup_reader_get_name (ValaMarkupReader* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void vala_markup_reader_set_name (ValaMarkupReader* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, vala_markup_reader_get_name (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		g_free (self->priv->_name);
		self->priv->_name = _tmp1_;
		g_object_notify ((GObject *) self, "name");
	}
}


const gchar* vala_markup_reader_get_content (ValaMarkupReader* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_content;
	result = _tmp0_;
	return result;
}


static void vala_markup_reader_set_content (ValaMarkupReader* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, vala_markup_reader_get_content (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		g_free (self->priv->_content);
		self->priv->_content = _tmp1_;
		g_object_notify ((GObject *) self, "content");
	}
}


static void vala_markup_reader_class_init (ValaMarkupReaderClass * klass) {
	vala_markup_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaMarkupReaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_vala_markup_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_vala_markup_reader_set_property;
	G_OBJECT_CLASS (klass)->finalize = vala_markup_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_MARKUP_READER_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_MARKUP_READER_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_MARKUP_READER_CONTENT, g_param_spec_string ("content", "content", "content", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void vala_markup_reader_instance_init (ValaMarkupReader * self) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	self->priv = VALA_MARKUP_READER_GET_PRIVATE (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp0_, _tmp1_, _tmp2_);
	self->priv->attributes = (ValaMap*) _tmp3_;
}


static void vala_markup_reader_finalize (GObject * obj) {
	ValaMarkupReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MARKUP_READER, ValaMarkupReader);
	g_free (self->priv->_filename);
	g_free (self->priv->_name);
	g_free (self->priv->_content);
	_g_mapped_file_unref0 (self->priv->mapped_file);
	_vala_map_unref0 (self->priv->attributes);
	G_OBJECT_CLASS (vala_markup_reader_parent_class)->finalize (obj);
}


/**
 * Simple reader for a subset of XML.
 */
GType vala_markup_reader_get_type (void) {
	static volatile gsize vala_markup_reader_type_id__volatile = 0;
	if (g_once_init_enter (&vala_markup_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMarkupReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_markup_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMarkupReader), 0, (GInstanceInitFunc) vala_markup_reader_instance_init, NULL };
		GType vala_markup_reader_type_id;
		vala_markup_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaMarkupReader", &g_define_type_info, 0);
		g_once_init_leave (&vala_markup_reader_type_id__volatile, vala_markup_reader_type_id);
	}
	return vala_markup_reader_type_id__volatile;
}


static void _vala_vala_markup_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaMarkupReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALA_TYPE_MARKUP_READER, ValaMarkupReader);
	switch (property_id) {
		case VALA_MARKUP_READER_FILENAME:
		g_value_set_string (value, vala_markup_reader_get_filename (self));
		break;
		case VALA_MARKUP_READER_NAME:
		g_value_set_string (value, vala_markup_reader_get_name (self));
		break;
		case VALA_MARKUP_READER_CONTENT:
		g_value_set_string (value, vala_markup_reader_get_content (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_vala_markup_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaMarkupReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALA_TYPE_MARKUP_READER, ValaMarkupReader);
	switch (property_id) {
		case VALA_MARKUP_READER_FILENAME:
		vala_markup_reader_set_filename (self, g_value_get_string (value));
		break;
		case VALA_MARKUP_READER_NAME:
		vala_markup_reader_set_name (self, g_value_get_string (value));
		break;
		case VALA_MARKUP_READER_CONTENT:
		vala_markup_reader_set_content (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


const gchar* vala_markup_token_type_to_string (ValaMarkupTokenType self) {
	const gchar* result = NULL;
	switch (self) {
		case VALA_MARKUP_TOKEN_TYPE_START_ELEMENT:
		{
			result = "start element";
			return result;
		}
		case VALA_MARKUP_TOKEN_TYPE_END_ELEMENT:
		{
			result = "end element";
			return result;
		}
		case VALA_MARKUP_TOKEN_TYPE_TEXT:
		{
			result = "text";
			return result;
		}
		case VALA_MARKUP_TOKEN_TYPE_EOF:
		{
			result = "end of file";
			return result;
		}
		default:
		{
			result = "unknown token type";
			return result;
		}
	}
}


GType vala_markup_token_type_get_type (void) {
	static volatile gsize vala_markup_token_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_markup_token_type_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_MARKUP_TOKEN_TYPE_NONE, "VALA_MARKUP_TOKEN_TYPE_NONE", "none"}, {VALA_MARKUP_TOKEN_TYPE_START_ELEMENT, "VALA_MARKUP_TOKEN_TYPE_START_ELEMENT", "start-element"}, {VALA_MARKUP_TOKEN_TYPE_END_ELEMENT, "VALA_MARKUP_TOKEN_TYPE_END_ELEMENT", "end-element"}, {VALA_MARKUP_TOKEN_TYPE_TEXT, "VALA_MARKUP_TOKEN_TYPE_TEXT", "text"}, {VALA_MARKUP_TOKEN_TYPE_EOF, "VALA_MARKUP_TOKEN_TYPE_EOF", "eof"}, {0, NULL, NULL}};
		GType vala_markup_token_type_type_id;
		vala_markup_token_type_type_id = g_enum_register_static ("ValaMarkupTokenType", values);
		g_once_init_leave (&vala_markup_token_type_type_id__volatile, vala_markup_token_type_type_id);
	}
	return vala_markup_token_type_type_id__volatile;
}



