/* math-buttons.c generated by valac 0.34.2, the Vala compiler
 * generated from math-buttons.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "libcalculator.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksource.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define TYPE_BUTTON_MODE (button_mode_get_type ())

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
typedef struct _MathButtonsPrivate MathButtonsPrivate;

#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MATH_VARIABLE_POPOVER (math_variable_popover_get_type ())
#define MATH_VARIABLE_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_VARIABLE_POPOVER, MathVariablePopover))
#define MATH_VARIABLE_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_VARIABLE_POPOVER, MathVariablePopoverClass))
#define IS_MATH_VARIABLE_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_VARIABLE_POPOVER))
#define IS_MATH_VARIABLE_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_VARIABLE_POPOVER))
#define MATH_VARIABLE_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_VARIABLE_POPOVER, MathVariablePopoverClass))

typedef struct _MathVariablePopover MathVariablePopover;
typedef struct _MathVariablePopoverClass MathVariablePopoverClass;

#define TYPE_MATH_FUNCTION_POPOVER (math_function_popover_get_type ())
#define MATH_FUNCTION_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopover))
#define MATH_FUNCTION_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopoverClass))
#define IS_MATH_FUNCTION_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_FUNCTION_POPOVER))
#define IS_MATH_FUNCTION_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_FUNCTION_POPOVER))
#define MATH_FUNCTION_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopoverClass))

typedef struct _MathFunctionPopover MathFunctionPopover;
typedef struct _MathFunctionPopoverClass MathFunctionPopoverClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING,
	BUTTON_MODE_KEYBOARD
} ButtonMode;

struct _MathButtons {
	GtkBox parent_instance;
	MathButtonsPrivate * priv;
};

struct _MathButtonsClass {
	GtkBoxClass parent_class;
};

struct _MathButtonsPrivate {
	MathEquation* equation;
	ButtonMode _mode;
	gint _programming_base;
	MathConverter* converter;
	GtkBuilder* basic_ui;
	GtkBuilder* advanced_ui;
	GtkBuilder* financial_ui;
	GtkBuilder* programming_ui;
	GtkWidget* bas_panel;
	GtkWidget* adv_panel;
	GtkWidget* fin_panel;
	GtkWidget* prog_panel;
	GtkWidget* active_panel;
	GtkComboBox* base_combo;
	GtkLabel* base_label;
	GtkWidget* bit_panel;
	GList* toggle_bit_buttons;
	GtkDialog* character_code_dialog;
	GtkEntry* character_code_entry;
	GSimpleActionGroup* action_group;
};


static gpointer math_buttons_parent_class = NULL;

GType button_mode_get_type (void) G_GNUC_CONST;
GType math_buttons_get_type (void) G_GNUC_CONST;
GType math_converter_get_type (void) G_GNUC_CONST;
#define MATH_BUTTONS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_BUTTONS, MathButtonsPrivate))
enum  {
	MATH_BUTTONS_DUMMY_PROPERTY,
	MATH_BUTTONS_MODE,
	MATH_BUTTONS_PROGRAMMING_BASE
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void math_buttons_on_insert (MathButtons* self, GSimpleAction* action, GVariant* param);
static void _math_buttons_on_insert_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_buttons_on_insert_digit (MathButtons* self, GSimpleAction* action, GVariant* param);
static void _math_buttons_on_insert_digit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_buttons_on_subtract (MathButtons* self, GSimpleAction* action, GVariant* param);
static void _math_buttons_on_subtract_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_buttons_on_square (MathButtons* self, GSimpleAction* action, GVariant* param);
static void _math_buttons_on_square_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_buttons_on_undo (MathButtons* self, GSimpleAction* action, GVariant* param);
static void _math_buttons_on_undo_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_buttons_on_solve (MathButtons* self, GSimpleAction* action, GVariant* param);
static void _math_buttons_on_solve_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_buttons_on_clear (MathButtons* self, GSimpleAction* action, GVariant* param);
static void _math_buttons_on_clear_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_buttons_on_factorize (MathButtons* self, GSimpleAction* action, GVariant* param);
static void _math_buttons_on_factorize_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_buttons_on_insert_exponent (MathButtons* self, GSimpleAction* action, GVariant* param);
static void _math_buttons_on_insert_exponent_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_buttons_on_bitshift (MathButtons* self, GSimpleAction* action, GVariant* param);
static void _math_buttons_on_bitshift_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_buttons_on_toggle_bit (MathButtons* self, GSimpleAction* action, GVariant* param);
static void _math_buttons_on_toggle_bit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_buttons_on_insert_character (MathButtons* self, GSimpleAction* action, GVariant* param);
static void _math_buttons_on_insert_character_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_buttons_on_insert_numeric_point (MathButtons* self, GSimpleAction* action, GVariant* param);
static void _math_buttons_on_insert_numeric_point_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_buttons_on_set_number_mode (MathButtons* self, GSimpleAction* action, GVariant* param);
static void _math_buttons_on_set_number_mode_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_buttons_on_launch_finc_dialog (MathButtons* self, GSimpleAction* action, GVariant* param);
static void _math_buttons_on_launch_finc_dialog_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
MathButtons* math_buttons_new (MathEquation* equation);
MathButtons* math_buttons_construct (GType object_type, MathEquation* equation);
static void math_buttons_load_buttons (MathButtons* self);
static void _math_buttons_load_buttons_gtk_widget_show (GtkWidget* _sender, gpointer self);
static void __lambda21_ (MathButtons* self, GParamSpec* pspec);
static void math_buttons_update_bit_panel (MathButtons* self);
static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda22_ (MathButtons* self, GParamSpec* pspec);
static void math_buttons_number_mode_changed_cb (MathButtons* self);
static void ___lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda23_ (MathButtons* self, GParamSpec* pspec);
static void ___lambda23__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda24_ (MathButtons* self, GParamSpec* pspec);
static void ___lambda24__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void math_buttons_load_finc_dialogs (MathButtons* self);
static void math_buttons_load_finc_dialog (MathButtons* self, const gchar* name, gchar** entry_names, int entry_names_length1, FinancialDialog function);
static void math_buttons_finc_response_cb (MathButtons* self, GtkWidget* widget, gint response_id);
static void _math_buttons_finc_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void math_buttons_finc_activate_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_finc_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void math_buttons_base_combobox_changed_cb (MathButtons* self, GtkComboBox* combo);
void math_buttons_set_programming_base (MathButtons* self, gint value);
static void math_buttons_base_changed_cb (MathButtons* self);
ButtonMode math_buttons_get_mode (MathButtons* self);
static GtkWidget* math_buttons_load_mode (MathButtons* self, ButtonMode mode);
static GMenu* math_buttons_create_shift_menu (MathButtons* self, gboolean shift_left);
MathVariablePopover* math_variable_popover_new (MathEquation* equation);
MathVariablePopover* math_variable_popover_construct (GType object_type, MathEquation* equation);
GType math_variable_popover_get_type (void) G_GNUC_CONST;
MathFunctionPopover* math_function_popover_new (MathEquation* equation);
MathFunctionPopover* math_function_popover_construct (GType object_type, MathEquation* equation);
GType math_function_popover_get_type (void) G_GNUC_CONST;
static void math_buttons_character_code_dialog_response_cb (MathButtons* self, GtkWidget* dialog, gint response_id);
static void _math_buttons_character_code_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean math_buttons_character_code_dialog_delete_cb (MathButtons* self, GtkWidget* dialog, GdkEventAny* event);
static gboolean _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void math_buttons_character_code_dialog_activate_cb (MathButtons* self, GtkWidget* entry);
static void _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void ___lambda20_ (MathButtons* self, GParamSpec* pspec);
static void ____lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void math_buttons_converter_changed_cb (MathButtons* self);
void math_converter_get_conversion (MathConverter* self, Unit** from_unit, Unit** to_unit);
MathConverter* math_converter_new (MathEquation* equation);
MathConverter* math_converter_construct (GType object_type, MathEquation* equation);
static void _math_buttons_converter_changed_cb_math_converter_changed (MathConverter* _sender, gpointer self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gchar** _vala_array_dup6 (gchar** self, int length);
static gchar** _vala_array_dup7 (gchar** self, int length);
static gchar** _vala_array_dup8 (gchar** self, int length);
static gchar** _vala_array_dup9 (gchar** self, int length);
static gchar** _vala_array_dup10 (gchar** self, int length);
static GVariant* _variant_new2 (const gchar* value);
static GVariant* _variant_new3 (const gchar* value);
static GVariant* _variant_new4 (const gchar* value);
void math_buttons_set_mode (MathButtons* self, ButtonMode value);
void math_converter_set_category (MathConverter* self, const gchar* category);
void math_converter_set_conversion (MathConverter* self, const gchar* unit_a, const gchar* unit_b);
gint math_buttons_get_programming_base (MathButtons* self);
static void math_buttons_finalize (GObject* obj);
static void _vala_math_buttons_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_math_buttons_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* MATH_BUTTONS_ctrm_entries[3] = {"ctrm_pint", "ctrm_fv", "ctrm_pv"};
static const gchar* MATH_BUTTONS_ddb_entries[3] = {"ddb_cost", "ddb_life", "ddb_period"};
static const gchar* MATH_BUTTONS_fv_entries[3] = {"fv_pmt", "fv_pint", "fv_n"};
static const gchar* MATH_BUTTONS_gpm_entries[2] = {"gpm_cost", "gpm_margin"};
static const gchar* MATH_BUTTONS_pmt_entries[3] = {"pmt_prin", "pmt_pint", "pmt_n"};
static const gchar* MATH_BUTTONS_pv_entries[3] = {"pv_pmt", "pv_pint", "pv_n"};
static const gchar* MATH_BUTTONS_rate_entries[3] = {"rate_fv", "rate_pv", "rate_n"};
static const gchar* MATH_BUTTONS_sln_entries[3] = {"sln_cost", "sln_salvage", "sln_life"};
static const gchar* MATH_BUTTONS_syd_entries[4] = {"syd_cost", "syd_salvage", "syd_life", "syd_period"};
static const gchar* MATH_BUTTONS_term_entries[3] = {"term_pmt", "term_fv", "term_pint"};
static const GActionEntry MATH_BUTTONS_action_entries[15] = {{"insert-general", _math_buttons_on_insert_gsimple_action_activate_callback, "s"}, {"insert-digit", _math_buttons_on_insert_digit_gsimple_action_activate_callback, "i"}, {"subtract", _math_buttons_on_subtract_gsimple_action_activate_callback}, {"square", _math_buttons_on_square_gsimple_action_activate_callback}, {"undo", _math_buttons_on_undo_gsimple_action_activate_callback}, {"solve", _math_buttons_on_solve_gsimple_action_activate_callback}, {"clear", _math_buttons_on_clear_gsimple_action_activate_callback}, {"factorize", _math_buttons_on_factorize_gsimple_action_activate_callback}, {"insert-exponent", _math_buttons_on_insert_exponent_gsimple_action_activate_callback}, {"bitshift", _math_buttons_on_bitshift_gsimple_action_activate_callback, "i"}, {"toggle-bit", _math_buttons_on_toggle_bit_gsimple_action_activate_callback, "i"}, {"insert-character", _math_buttons_on_insert_character_gsimple_action_activate_callback}, {"insert-numeric-point", _math_buttons_on_insert_numeric_point_gsimple_action_activate_callback}, {"set-number-mode", _math_buttons_on_set_number_mode_gsimple_action_activate_callback, "s", "'normal'"}, {"launch-finc-dialog", _math_buttons_on_launch_finc_dialog_gsimple_action_activate_callback, "s"}};

GType button_mode_get_type (void) {
	static volatile gsize button_mode_type_id__volatile = 0;
	if (g_once_init_enter (&button_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{BUTTON_MODE_BASIC, "BUTTON_MODE_BASIC", "basic"}, {BUTTON_MODE_ADVANCED, "BUTTON_MODE_ADVANCED", "advanced"}, {BUTTON_MODE_FINANCIAL, "BUTTON_MODE_FINANCIAL", "financial"}, {BUTTON_MODE_PROGRAMMING, "BUTTON_MODE_PROGRAMMING", "programming"}, {BUTTON_MODE_KEYBOARD, "BUTTON_MODE_KEYBOARD", "keyboard"}, {0, NULL, NULL}};
		GType button_mode_type_id;
		button_mode_type_id = g_enum_register_static ("ButtonMode", values);
		g_once_init_leave (&button_mode_type_id__volatile, button_mode_type_id);
	}
	return button_mode_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _math_buttons_on_insert_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_buttons_on_insert ((MathButtons*) self, action, parameter);
}


static void _math_buttons_on_insert_digit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_buttons_on_insert_digit ((MathButtons*) self, action, parameter);
}


static void _math_buttons_on_subtract_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_buttons_on_subtract ((MathButtons*) self, action, parameter);
}


static void _math_buttons_on_square_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_buttons_on_square ((MathButtons*) self, action, parameter);
}


static void _math_buttons_on_undo_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_buttons_on_undo ((MathButtons*) self, action, parameter);
}


static void _math_buttons_on_solve_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_buttons_on_solve ((MathButtons*) self, action, parameter);
}


static void _math_buttons_on_clear_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_buttons_on_clear ((MathButtons*) self, action, parameter);
}


static void _math_buttons_on_factorize_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_buttons_on_factorize ((MathButtons*) self, action, parameter);
}


static void _math_buttons_on_insert_exponent_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_buttons_on_insert_exponent ((MathButtons*) self, action, parameter);
}


static void _math_buttons_on_bitshift_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_buttons_on_bitshift ((MathButtons*) self, action, parameter);
}


static void _math_buttons_on_toggle_bit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_buttons_on_toggle_bit ((MathButtons*) self, action, parameter);
}


static void _math_buttons_on_insert_character_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_buttons_on_insert_character ((MathButtons*) self, action, parameter);
}


static void _math_buttons_on_insert_numeric_point_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_buttons_on_insert_numeric_point ((MathButtons*) self, action, parameter);
}


static void _math_buttons_on_set_number_mode_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_buttons_on_set_number_mode ((MathButtons*) self, action, parameter);
}


static void _math_buttons_on_launch_finc_dialog_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_buttons_on_launch_finc_dialog ((MathButtons*) self, action, parameter);
}


static void _math_buttons_load_buttons_gtk_widget_show (GtkWidget* _sender, gpointer self) {
	math_buttons_load_buttons ((MathButtons*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda21_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda21_ ((MathButtons*) self, pspec);
}


static void __lambda22_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_number_mode_changed_cb (self);
}


static void ___lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda22_ ((MathButtons*) self, pspec);
}


static void __lambda23_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void ___lambda23__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda23_ ((MathButtons*) self, pspec);
}


static void __lambda24_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void ___lambda24__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda24_ ((MathButtons*) self, pspec);
}


MathButtons* math_buttons_construct (GType object_type, MathEquation* equation) {
	MathButtons * self = NULL;
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	GSimpleActionGroup* _tmp2_ = NULL;
	GSimpleActionGroup* _tmp3_ = NULL;
	MathEquation* _tmp4_ = NULL;
	MathEquation* _tmp5_ = NULL;
	MathEquation* _tmp6_ = NULL;
	MathEquation* _tmp7_ = NULL;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathButtons*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "vexpand-set", TRUE, NULL);
	gtk_box_set_spacing ((GtkBox*) self, 6);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) _math_buttons_load_buttons_gtk_widget_show, self, 0);
	_tmp0_ = equation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->equation);
	self->priv->equation = _tmp1_;
	_tmp2_ = self->priv->action_group;
	g_action_map_add_action_entries ((GActionMap*) _tmp2_, MATH_BUTTONS_action_entries, G_N_ELEMENTS (MATH_BUTTONS_action_entries), self);
	_tmp3_ = self->priv->action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "cal", (GActionGroup*) _tmp3_);
	_tmp4_ = equation;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::display", (GCallback) ___lambda21__g_object_notify, self, 0);
	_tmp5_ = equation;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::number-mode", (GCallback) ___lambda22__g_object_notify, self, 0);
	_tmp6_ = equation;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::angle-units", (GCallback) ___lambda23__g_object_notify, self, 0);
	_tmp7_ = equation;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::number-format", (GCallback) ___lambda24__g_object_notify, self, 0);
	math_buttons_number_mode_changed_cb (self);
	math_buttons_update_bit_panel (self);
	return self;
}


MathButtons* math_buttons_new (MathEquation* equation) {
	return math_buttons_construct (TYPE_MATH_BUTTONS, equation);
}


static void math_buttons_load_finc_dialogs (MathButtons* self) {
	g_return_if_fail (self != NULL);
	math_buttons_load_finc_dialog (self, "ctrm_dialog", MATH_BUTTONS_ctrm_entries, G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries), FINANCIAL_DIALOG_CTRM_DIALOG);
	math_buttons_load_finc_dialog (self, "ddb_dialog", MATH_BUTTONS_ddb_entries, G_N_ELEMENTS (MATH_BUTTONS_ddb_entries), FINANCIAL_DIALOG_DDB_DIALOG);
	math_buttons_load_finc_dialog (self, "fv_dialog", MATH_BUTTONS_fv_entries, G_N_ELEMENTS (MATH_BUTTONS_fv_entries), FINANCIAL_DIALOG_FV_DIALOG);
	math_buttons_load_finc_dialog (self, "gpm_dialog", MATH_BUTTONS_gpm_entries, G_N_ELEMENTS (MATH_BUTTONS_gpm_entries), FINANCIAL_DIALOG_GPM_DIALOG);
	math_buttons_load_finc_dialog (self, "pmt_dialog", MATH_BUTTONS_pmt_entries, G_N_ELEMENTS (MATH_BUTTONS_pmt_entries), FINANCIAL_DIALOG_PMT_DIALOG);
	math_buttons_load_finc_dialog (self, "pv_dialog", MATH_BUTTONS_pv_entries, G_N_ELEMENTS (MATH_BUTTONS_pv_entries), FINANCIAL_DIALOG_PV_DIALOG);
	math_buttons_load_finc_dialog (self, "rate_dialog", MATH_BUTTONS_rate_entries, G_N_ELEMENTS (MATH_BUTTONS_rate_entries), FINANCIAL_DIALOG_RATE_DIALOG);
	math_buttons_load_finc_dialog (self, "sln_dialog", MATH_BUTTONS_sln_entries, G_N_ELEMENTS (MATH_BUTTONS_sln_entries), FINANCIAL_DIALOG_SLN_DIALOG);
	math_buttons_load_finc_dialog (self, "syd_dialog", MATH_BUTTONS_syd_entries, G_N_ELEMENTS (MATH_BUTTONS_syd_entries), FINANCIAL_DIALOG_SYD_DIALOG);
	math_buttons_load_finc_dialog (self, "term_dialog", MATH_BUTTONS_term_entries, G_N_ELEMENTS (MATH_BUTTONS_term_entries), FINANCIAL_DIALOG_TERM_DIALOG);
}


static void _math_buttons_finc_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	math_buttons_finc_response_cb ((MathButtons*) self, _sender, response_id);
}


static void _math_buttons_finc_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	math_buttons_finc_activate_cb ((MathButtons*) self, _sender);
}


static void math_buttons_load_finc_dialog (MathButtons* self, const gchar* name, gchar** entry_names, int entry_names_length1, FinancialDialog function) {
	GtkDialog* dialog = NULL;
	GtkBuilder* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	GtkDialog* _tmp3_ = NULL;
	GtkDialog* _tmp4_ = NULL;
	FinancialDialog _tmp5_ = 0;
	GtkDialog* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->financial_ui;
	_tmp1_ = name;
	_tmp2_ = gtk_builder_get_object (_tmp0_, _tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp2_) : NULL);
	dialog = _tmp3_;
	_tmp4_ = dialog;
	_tmp5_ = function;
	g_object_set_data_full ((GObject*) _tmp4_, "finc-function", (gpointer) ((gintptr) ((gint) _tmp5_)), NULL);
	_tmp6_ = dialog;
	g_signal_connect_object (_tmp6_, "response", (GCallback) _math_buttons_finc_response_cb_gtk_dialog_response, self, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				GtkEntry* entry = NULL;
				GtkBuilder* _tmp11_ = NULL;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gint _tmp13_ = 0;
				const gchar* _tmp14_ = NULL;
				GObject* _tmp15_ = NULL;
				GtkEntry* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				gchar** _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				GtkEntry* _tmp26_ = NULL;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = entry_names;
				_tmp10__length1 = entry_names_length1;
				if (!(_tmp9_ < _tmp10__length1)) {
					break;
				}
				_tmp11_ = self->priv->financial_ui;
				_tmp12_ = entry_names;
				_tmp12__length1 = entry_names_length1;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_];
				_tmp15_ = gtk_builder_get_object (_tmp11_, _tmp14_);
				_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp15_) : NULL);
				entry = _tmp16_;
				_tmp17_ = i;
				_tmp18_ = entry_names;
				_tmp18__length1 = entry_names_length1;
				if (_tmp17_ != (_tmp18__length1 - 1)) {
					GtkEntry* _tmp19_ = NULL;
					GtkBuilder* _tmp20_ = NULL;
					gchar** _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					gint _tmp22_ = 0;
					const gchar* _tmp23_ = NULL;
					GObject* _tmp24_ = NULL;
					GtkEntry* _tmp25_ = NULL;
					_tmp19_ = entry;
					_tmp20_ = self->priv->financial_ui;
					_tmp21_ = entry_names;
					_tmp21__length1 = entry_names_length1;
					_tmp22_ = i;
					_tmp23_ = _tmp21_[_tmp22_ + 1];
					_tmp24_ = gtk_builder_get_object (_tmp20_, _tmp23_);
					_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp24_) : NULL);
					g_object_set_data_full ((GObject*) _tmp19_, "next-entry", _tmp25_, g_object_unref);
				}
				_tmp26_ = entry;
				g_signal_connect_object (_tmp26_, "activate", (GCallback) _math_buttons_finc_activate_cb_gtk_entry_activate, self, 0);
				_g_object_unref0 (entry);
			}
		}
	}
	_g_object_unref0 (dialog);
}


static void math_buttons_on_insert (MathButtons* self, GSimpleAction* action, GVariant* param) {
	MathEquation* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = param;
	_tmp2_ = g_variant_get_string (_tmp1_, NULL);
	math_equation_insert (_tmp0_, _tmp2_);
}


static void math_buttons_on_insert_digit (MathButtons* self, GSimpleAction* action, GVariant* param) {
	MathEquation* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	gint32 _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = param;
	_tmp2_ = g_variant_get_int32 (_tmp1_);
	math_equation_insert_digit (_tmp0_, (guint) _tmp2_);
}


static void math_buttons_on_subtract (MathButtons* self, GSimpleAction* action, GVariant* param) {
	MathEquation* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_insert_subtract (_tmp0_);
}


static void math_buttons_on_square (MathButtons* self, GSimpleAction* action, GVariant* param) {
	MathEquation* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_insert_square (_tmp0_);
}


static void math_buttons_on_undo (MathButtons* self, GSimpleAction* action, GVariant* param) {
	MathEquation* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	gtk_source_buffer_undo ((GtkSourceBuffer*) _tmp0_);
}


static void math_buttons_on_solve (MathButtons* self, GSimpleAction* action, GVariant* param) {
	MathEquation* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_solve (_tmp0_);
}


static void math_buttons_on_clear (MathButtons* self, GSimpleAction* action, GVariant* param) {
	MathEquation* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_clear (_tmp0_);
}


static void math_buttons_on_factorize (MathButtons* self, GSimpleAction* action, GVariant* param) {
	MathEquation* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_factorize (_tmp0_);
}


static void math_buttons_on_insert_exponent (MathButtons* self, GSimpleAction* action, GVariant* param) {
	MathEquation* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_insert_exponent (_tmp0_);
}


static void math_buttons_on_bitshift (MathButtons* self, GSimpleAction* action, GVariant* param) {
	MathEquation* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	gint32 _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = param;
	_tmp2_ = g_variant_get_int32 (_tmp1_);
	math_equation_shift (_tmp0_, (gint) _tmp2_);
}


static void math_buttons_on_insert_numeric_point (MathButtons* self, GSimpleAction* action, GVariant* param) {
	MathEquation* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_insert_numeric_point (_tmp0_);
}


static void math_buttons_update_bit_panel (MathButtons* self) {
	GtkWidget* _tmp0_ = NULL;
	Number* x = NULL;
	MathEquation* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	guint64 bits = 0ULL;
	gboolean enabled = FALSE;
	Number* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GtkWidget* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	GtkLabel* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gint i = 0;
	GList* _tmp25_ = NULL;
	gint number_base = 0;
	MathEquation* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gchar* label = NULL;
	gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp44_ = 0;
	gint _tmp53_ = 0;
	GtkLabel* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bit_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->equation;
	_tmp2_ = math_equation_get_number (_tmp1_);
	_tmp3_ = _tmp2_;
	x = _tmp3_;
	bits = (guint64) 0;
	_tmp4_ = x;
	enabled = _tmp4_ != NULL;
	_tmp5_ = enabled;
	if (_tmp5_) {
		Number* max = NULL;
		Number* _tmp6_ = NULL;
		Number* fraction = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		Number* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		_tmp6_ = number_new_unsigned_integer (G_MAXUINT64, (guint64) 0);
		max = _tmp6_;
		_tmp7_ = x;
		_tmp8_ = number_fractional_part (_tmp7_);
		fraction = _tmp8_;
		_tmp11_ = x;
		_tmp12_ = number_is_negative (_tmp11_);
		if (_tmp12_) {
			_tmp10_ = TRUE;
		} else {
			Number* _tmp13_ = NULL;
			Number* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			_tmp13_ = x;
			_tmp14_ = max;
			_tmp15_ = number_compare (_tmp13_, _tmp14_);
			_tmp10_ = _tmp15_ > 0;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			Number* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			_tmp16_ = fraction;
			_tmp17_ = number_is_zero (_tmp16_);
			_tmp9_ = !_tmp17_;
		}
		if (_tmp9_) {
			enabled = FALSE;
		} else {
			Number* _tmp18_ = NULL;
			guint64 _tmp19_ = 0ULL;
			_tmp18_ = x;
			_tmp19_ = number_to_unsigned_integer (_tmp18_);
			bits = _tmp19_;
		}
		_g_object_unref0 (fraction);
		_g_object_unref0 (max);
	}
	_tmp20_ = self->priv->bit_panel;
	_tmp21_ = enabled;
	gtk_widget_set_sensitive (_tmp20_, _tmp21_);
	_tmp22_ = self->priv->base_label;
	_tmp23_ = enabled;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp22_, _tmp23_);
	_tmp24_ = enabled;
	if (!_tmp24_) {
		_g_object_unref0 (x);
		return;
	}
	i = 0;
	_tmp25_ = self->priv->toggle_bit_buttons;
	{
		GList* button_collection = NULL;
		GList* button_it = NULL;
		button_collection = _tmp25_;
		for (button_it = button_collection; button_it != NULL; button_it = button_it->next) {
			GtkButton* _tmp26_ = NULL;
			GtkButton* button = NULL;
			_tmp26_ = _g_object_ref0 ((GtkButton*) button_it->data);
			button = _tmp26_;
			{
				gchar* text = NULL;
				gchar* _tmp27_ = NULL;
				guint64 _tmp28_ = 0ULL;
				gint _tmp29_ = 0;
				GtkButton* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				_tmp27_ = g_strdup ("0");
				text = _tmp27_;
				_tmp28_ = bits;
				_tmp29_ = i;
				if ((_tmp28_ & (1ULL << _tmp29_)) != ((guint64) 0)) {
					gchar* _tmp30_ = NULL;
					_tmp30_ = g_strdup ("1");
					_g_free0 (text);
					text = _tmp30_;
				}
				_tmp31_ = button;
				_tmp32_ = text;
				gtk_button_set_label (_tmp31_, _tmp32_);
				_tmp33_ = i;
				i = _tmp33_ + 1;
				_g_free0 (text);
				_g_object_unref0 (button);
			}
		}
	}
	_tmp34_ = self->priv->equation;
	_tmp35_ = math_equation_get_number_base (_tmp34_);
	_tmp36_ = _tmp35_;
	number_base = _tmp36_;
	_tmp37_ = g_strdup ("");
	label = _tmp37_;
	_tmp38_ = number_base;
	if (_tmp38_ != 8) {
		const gchar* _tmp39_ = NULL;
		guint64 _tmp40_ = 0ULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		_tmp39_ = label;
		_tmp40_ = bits;
		_tmp41_ = g_strdup_printf ("%llo₈", _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_strconcat (_tmp39_, _tmp42_, NULL);
		_g_free0 (label);
		label = _tmp43_;
		_g_free0 (_tmp42_);
	}
	_tmp44_ = number_base;
	if (_tmp44_ != 10) {
		const gchar* _tmp45_ = NULL;
		const gchar* _tmp48_ = NULL;
		guint64 _tmp49_ = 0ULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		_tmp45_ = label;
		if (g_strcmp0 (_tmp45_, "") != 0) {
			const gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
			_tmp46_ = label;
			_tmp47_ = g_strconcat (_tmp46_, " = ", NULL);
			_g_free0 (label);
			label = _tmp47_;
		}
		_tmp48_ = label;
		_tmp49_ = bits;
		_tmp50_ = g_strdup_printf ("%llu₁₀", _tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_strconcat (_tmp48_, _tmp51_, NULL);
		_g_free0 (label);
		label = _tmp52_;
		_g_free0 (_tmp51_);
	}
	_tmp53_ = number_base;
	if (_tmp53_ != 16) {
		const gchar* _tmp54_ = NULL;
		const gchar* _tmp57_ = NULL;
		guint64 _tmp58_ = 0ULL;
		gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		_tmp54_ = label;
		if (g_strcmp0 (_tmp54_, "") != 0) {
			const gchar* _tmp55_ = NULL;
			gchar* _tmp56_ = NULL;
			_tmp55_ = label;
			_tmp56_ = g_strconcat (_tmp55_, " = ", NULL);
			_g_free0 (label);
			label = _tmp56_;
		}
		_tmp57_ = label;
		_tmp58_ = bits;
		_tmp59_ = g_strdup_printf ("%llX₁₆", _tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = g_strconcat (_tmp57_, _tmp60_, NULL);
		_g_free0 (label);
		label = _tmp61_;
		_g_free0 (_tmp60_);
	}
	_tmp62_ = self->priv->base_label;
	_tmp63_ = label;
	gtk_label_set_text (_tmp62_, _tmp63_);
	_g_free0 (label);
	_g_object_unref0 (x);
}


static void math_buttons_base_combobox_changed_cb (MathButtons* self, GtkComboBox* combo) {
	GtkComboBox* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp1_ = gtk_combo_box_get_active_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = atoi (_tmp2_);
	math_buttons_set_programming_base (self, _tmp3_);
}


static void math_buttons_base_changed_cb (MathButtons* self) {
	ButtonMode _tmp0_ = 0;
	ButtonMode _tmp1_ = 0;
	MathEquation* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GtkComboBox* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_buttons_get_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != BUTTON_MODE_PROGRAMMING) {
		return;
	}
	_tmp2_ = self->priv->equation;
	_tmp3_ = math_equation_get_number_base (_tmp2_);
	_tmp4_ = _tmp3_;
	self->priv->_programming_base = _tmp4_;
	_tmp5_ = self->priv->base_combo;
	_tmp6_ = self->priv->_programming_base;
	_tmp7_ = g_strdup_printf ("%i", _tmp6_);
	_tmp8_ = _tmp7_;
	gtk_combo_box_set_active_id (_tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	math_buttons_update_bit_panel (self);
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static void _math_buttons_character_code_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	math_buttons_character_code_dialog_response_cb ((MathButtons*) self, _sender, response_id);
}


static gboolean _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = math_buttons_character_code_dialog_delete_cb ((MathButtons*) self, _sender, event);
	return result;
}


static void _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	math_buttons_character_code_dialog_activate_cb ((MathButtons*) self, _sender);
}


static void _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	math_buttons_base_combobox_changed_cb ((MathButtons*) self, _sender);
}


static void ___lambda20_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_base_changed_cb (self);
}


static void ____lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda20_ ((MathButtons*) self, pspec);
}


static GtkWidget* math_buttons_load_mode (MathButtons* self, ButtonMode mode) {
	GtkWidget* result = NULL;
	GtkBuilder* builder = NULL;
	gchar* builder_resource = NULL;
	ButtonMode _tmp0_ = 0;
	GtkWidget* panel = NULL;
	GtkBuilder* _tmp34_ = NULL;
	GObject* _tmp35_ = NULL;
	GtkWidget* _tmp36_ = NULL;
	GtkWidget* _tmp37_ = NULL;
	ButtonMode _tmp38_ = 0;
	GtkButton* button = NULL;
	GtkBuilder* _tmp47_ = NULL;
	GObject* _tmp48_ = NULL;
	GtkButton* _tmp49_ = NULL;
	GtkButton* _tmp50_ = NULL;
	GtkMenuButton* menu_button = NULL;
	GtkBuilder* _tmp58_ = NULL;
	GObject* _tmp59_ = NULL;
	GtkMenuButton* _tmp60_ = NULL;
	GtkMenuButton* _tmp61_ = NULL;
	GtkBuilder* _tmp65_ = NULL;
	GObject* _tmp66_ = NULL;
	GtkMenuButton* _tmp67_ = NULL;
	GtkMenuButton* _tmp68_ = NULL;
	GtkBuilder* _tmp72_ = NULL;
	GObject* _tmp73_ = NULL;
	GtkMenuButton* _tmp74_ = NULL;
	GtkMenuButton* _tmp75_ = NULL;
	GtkBuilder* _tmp80_ = NULL;
	GObject* _tmp81_ = NULL;
	GtkMenuButton* _tmp82_ = NULL;
	GtkMenuButton* _tmp83_ = NULL;
	ButtonMode _tmp88_ = 0;
	ButtonMode _tmp119_ = 0;
	GtkBuilder* _tmp120_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = mode;
	switch (_tmp0_) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkWidget* _tmp1_ = NULL;
			GtkBuilder* _tmp4_ = NULL;
			GtkBuilder* _tmp5_ = NULL;
			GtkBuilder* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			_tmp1_ = self->priv->bas_panel;
			if (_tmp1_ != NULL) {
				GtkWidget* _tmp2_ = NULL;
				GtkWidget* _tmp3_ = NULL;
				_tmp2_ = self->priv->bas_panel;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				result = _tmp3_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp4_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->basic_ui);
			self->priv->basic_ui = _tmp4_;
			_tmp5_ = self->priv->basic_ui;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			_g_object_unref0 (builder);
			builder = _tmp6_;
			_tmp7_ = g_strdup ("buttons-basic.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp7_;
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkWidget* _tmp8_ = NULL;
			GtkBuilder* _tmp11_ = NULL;
			GtkBuilder* _tmp12_ = NULL;
			GtkBuilder* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			_tmp8_ = self->priv->adv_panel;
			if (_tmp8_ != NULL) {
				GtkWidget* _tmp9_ = NULL;
				GtkWidget* _tmp10_ = NULL;
				_tmp9_ = self->priv->adv_panel;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				result = _tmp10_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp11_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->advanced_ui);
			self->priv->advanced_ui = _tmp11_;
			_tmp12_ = self->priv->advanced_ui;
			_tmp13_ = _g_object_ref0 (_tmp12_);
			_g_object_unref0 (builder);
			builder = _tmp13_;
			_tmp14_ = g_strdup ("buttons-advanced.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp14_;
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkWidget* _tmp15_ = NULL;
			GtkBuilder* _tmp18_ = NULL;
			GtkBuilder* _tmp19_ = NULL;
			GtkBuilder* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			_tmp15_ = self->priv->fin_panel;
			if (_tmp15_ != NULL) {
				GtkWidget* _tmp16_ = NULL;
				GtkWidget* _tmp17_ = NULL;
				_tmp16_ = self->priv->fin_panel;
				_tmp17_ = _g_object_ref0 (_tmp16_);
				result = _tmp17_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp18_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->financial_ui);
			self->priv->financial_ui = _tmp18_;
			_tmp19_ = self->priv->financial_ui;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_g_object_unref0 (builder);
			builder = _tmp20_;
			_tmp21_ = g_strdup ("buttons-financial.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp21_;
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkWidget* _tmp22_ = NULL;
			GtkBuilder* _tmp25_ = NULL;
			GtkBuilder* _tmp26_ = NULL;
			GtkBuilder* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			_tmp22_ = self->priv->prog_panel;
			if (_tmp22_ != NULL) {
				GtkWidget* _tmp23_ = NULL;
				GtkWidget* _tmp24_ = NULL;
				_tmp23_ = self->priv->prog_panel;
				_tmp24_ = _g_object_ref0 (_tmp23_);
				result = _tmp24_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp25_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->programming_ui);
			self->priv->programming_ui = _tmp25_;
			_tmp26_ = self->priv->programming_ui;
			_tmp27_ = _g_object_ref0 (_tmp26_);
			_g_object_unref0 (builder);
			builder = _tmp27_;
			_tmp28_ = g_strdup ("buttons-programming.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp28_;
			break;
		}
	}
	{
		GtkBuilder* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		_tmp29_ = builder;
		_tmp30_ = builder_resource;
		_tmp31_ = g_strdup_printf ("/org/gnome/calculator/%s", _tmp30_);
		_tmp32_ = _tmp31_;
		gtk_builder_add_from_resource (_tmp29_, _tmp32_, &_inner_error_);
		_g_free0 (_tmp32_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp33_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp33_ = e->message;
		g_error ("math-buttons.vala:320: Error loading button UI: %s", _tmp33_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (builder_resource);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp34_ = builder;
	_tmp35_ = gtk_builder_get_object (_tmp34_, "button_panel");
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp35_) : NULL);
	panel = _tmp36_;
	_tmp37_ = panel;
	gtk_box_pack_end ((GtkBox*) self, _tmp37_, TRUE, TRUE, (guint) 0);
	_tmp38_ = mode;
	switch (_tmp38_) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkWidget* _tmp39_ = NULL;
			GtkWidget* _tmp40_ = NULL;
			_tmp39_ = panel;
			_tmp40_ = _g_object_ref0 (_tmp39_);
			_g_object_unref0 (self->priv->bas_panel);
			self->priv->bas_panel = _tmp40_;
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkWidget* _tmp41_ = NULL;
			GtkWidget* _tmp42_ = NULL;
			_tmp41_ = panel;
			_tmp42_ = _g_object_ref0 (_tmp41_);
			_g_object_unref0 (self->priv->adv_panel);
			self->priv->adv_panel = _tmp42_;
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkWidget* _tmp43_ = NULL;
			GtkWidget* _tmp44_ = NULL;
			_tmp43_ = panel;
			_tmp44_ = _g_object_ref0 (_tmp43_);
			_g_object_unref0 (self->priv->fin_panel);
			self->priv->fin_panel = _tmp44_;
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkWidget* _tmp45_ = NULL;
			GtkWidget* _tmp46_ = NULL;
			_tmp45_ = panel;
			_tmp46_ = _g_object_ref0 (_tmp45_);
			_g_object_unref0 (self->priv->prog_panel);
			self->priv->prog_panel = _tmp46_;
			break;
		}
	}
	_tmp47_ = builder;
	_tmp48_ = gtk_builder_get_object (_tmp47_, "calc_numeric_point_button");
	_tmp49_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, gtk_button_get_type ()) ? ((GtkButton*) _tmp48_) : NULL);
	button = _tmp49_;
	_tmp50_ = button;
	if (_tmp50_ != NULL) {
		GtkButton* _tmp51_ = NULL;
		MathEquation* _tmp52_ = NULL;
		Serializer* _tmp53_ = NULL;
		Serializer* _tmp54_ = NULL;
		gunichar _tmp55_ = 0U;
		gchar* _tmp56_ = NULL;
		gchar* _tmp57_ = NULL;
		_tmp51_ = button;
		_tmp52_ = self->priv->equation;
		_tmp53_ = math_equation_get_serializer (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = serializer_get_radix (_tmp54_);
		_tmp56_ = g_unichar_to_string (_tmp55_);
		_tmp57_ = _tmp56_;
		gtk_button_set_label (_tmp51_, _tmp57_);
		_g_free0 (_tmp57_);
	}
	_tmp58_ = builder;
	_tmp59_ = gtk_builder_get_object (_tmp58_, "calc_shift_left_button");
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp59_, gtk_menu_button_get_type ()) ? ((GtkMenuButton*) _tmp59_) : NULL);
	menu_button = _tmp60_;
	_tmp61_ = menu_button;
	if (_tmp61_ != NULL) {
		GtkMenuButton* _tmp62_ = NULL;
		GMenu* _tmp63_ = NULL;
		GMenu* _tmp64_ = NULL;
		_tmp62_ = menu_button;
		_tmp63_ = math_buttons_create_shift_menu (self, TRUE);
		_tmp64_ = _tmp63_;
		gtk_menu_button_set_menu_model (_tmp62_, (GMenuModel*) _tmp64_);
		_g_object_unref0 (_tmp64_);
	}
	_tmp65_ = builder;
	_tmp66_ = gtk_builder_get_object (_tmp65_, "calc_shift_right_button");
	_tmp67_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp66_, gtk_menu_button_get_type ()) ? ((GtkMenuButton*) _tmp66_) : NULL);
	_g_object_unref0 (menu_button);
	menu_button = _tmp67_;
	_tmp68_ = menu_button;
	if (_tmp68_ != NULL) {
		GtkMenuButton* _tmp69_ = NULL;
		GMenu* _tmp70_ = NULL;
		GMenu* _tmp71_ = NULL;
		_tmp69_ = menu_button;
		_tmp70_ = math_buttons_create_shift_menu (self, FALSE);
		_tmp71_ = _tmp70_;
		gtk_menu_button_set_menu_model (_tmp69_, (GMenuModel*) _tmp71_);
		_g_object_unref0 (_tmp71_);
	}
	_tmp72_ = builder;
	_tmp73_ = gtk_builder_get_object (_tmp72_, "calc_memory_button");
	_tmp74_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp73_, gtk_menu_button_get_type ()) ? ((GtkMenuButton*) _tmp73_) : NULL);
	_g_object_unref0 (menu_button);
	menu_button = _tmp74_;
	_tmp75_ = menu_button;
	if (_tmp75_ != NULL) {
		GtkMenuButton* _tmp76_ = NULL;
		MathEquation* _tmp77_ = NULL;
		MathVariablePopover* _tmp78_ = NULL;
		MathVariablePopover* _tmp79_ = NULL;
		_tmp76_ = menu_button;
		_tmp77_ = self->priv->equation;
		_tmp78_ = math_variable_popover_new (_tmp77_);
		g_object_ref_sink (_tmp78_);
		_tmp79_ = _tmp78_;
		gtk_menu_button_set_popover (_tmp76_, (GtkPopover*) _tmp79_);
		_g_object_unref0 (_tmp79_);
	}
	_tmp80_ = builder;
	_tmp81_ = gtk_builder_get_object (_tmp80_, "calc_function_button");
	_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp81_, gtk_menu_button_get_type ()) ? ((GtkMenuButton*) _tmp81_) : NULL);
	_g_object_unref0 (menu_button);
	menu_button = _tmp82_;
	_tmp83_ = menu_button;
	if (_tmp83_ != NULL) {
		GtkMenuButton* _tmp84_ = NULL;
		MathEquation* _tmp85_ = NULL;
		MathFunctionPopover* _tmp86_ = NULL;
		MathFunctionPopover* _tmp87_ = NULL;
		_tmp84_ = menu_button;
		_tmp85_ = self->priv->equation;
		_tmp86_ = math_function_popover_new (_tmp85_);
		g_object_ref_sink (_tmp86_);
		_tmp87_ = _tmp86_;
		gtk_menu_button_set_popover (_tmp84_, (GtkPopover*) _tmp87_);
		_g_object_unref0 (_tmp87_);
	}
	_tmp88_ = mode;
	if (_tmp88_ == BUTTON_MODE_PROGRAMMING) {
		GtkBuilder* _tmp89_ = NULL;
		GObject* _tmp90_ = NULL;
		GtkLabel* _tmp91_ = NULL;
		GtkBuilder* _tmp92_ = NULL;
		GObject* _tmp93_ = NULL;
		GtkDialog* _tmp94_ = NULL;
		GtkDialog* _tmp95_ = NULL;
		GtkDialog* _tmp96_ = NULL;
		GtkBuilder* _tmp97_ = NULL;
		GObject* _tmp98_ = NULL;
		GtkEntry* _tmp99_ = NULL;
		GtkEntry* _tmp100_ = NULL;
		GtkBuilder* _tmp101_ = NULL;
		GObject* _tmp102_ = NULL;
		GtkWidget* _tmp103_ = NULL;
		gint i = 0;
		GtkBuilder* _tmp114_ = NULL;
		GObject* _tmp115_ = NULL;
		GtkComboBox* _tmp116_ = NULL;
		GtkComboBox* _tmp117_ = NULL;
		MathEquation* _tmp118_ = NULL;
		_tmp89_ = builder;
		_tmp90_ = gtk_builder_get_object (_tmp89_, "base_label");
		_tmp91_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp90_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp90_) : NULL);
		_g_object_unref0 (self->priv->base_label);
		self->priv->base_label = _tmp91_;
		_tmp92_ = builder;
		_tmp93_ = gtk_builder_get_object (_tmp92_, "character_code_dialog");
		_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp93_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp93_) : NULL);
		_g_object_unref0 (self->priv->character_code_dialog);
		self->priv->character_code_dialog = _tmp94_;
		_tmp95_ = self->priv->character_code_dialog;
		g_signal_connect_object (_tmp95_, "response", (GCallback) _math_buttons_character_code_dialog_response_cb_gtk_dialog_response, self, 0);
		_tmp96_ = self->priv->character_code_dialog;
		g_signal_connect_object ((GtkWidget*) _tmp96_, "delete-event", (GCallback) _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event, self, 0);
		_tmp97_ = builder;
		_tmp98_ = gtk_builder_get_object (_tmp97_, "character_code_entry");
		_tmp99_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp98_) : NULL);
		_g_object_unref0 (self->priv->character_code_entry);
		self->priv->character_code_entry = _tmp99_;
		_tmp100_ = self->priv->character_code_entry;
		g_signal_connect_object (_tmp100_, "activate", (GCallback) _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate, self, 0);
		_tmp101_ = builder;
		_tmp102_ = gtk_builder_get_object (_tmp101_, "bit_table");
		_tmp103_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp102_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp102_) : NULL);
		_g_object_unref0 (self->priv->bit_panel);
		self->priv->bit_panel = _tmp103_;
		__g_list_free__g_object_unref0_0 (self->priv->toggle_bit_buttons);
		self->priv->toggle_bit_buttons = NULL;
		i = 0;
		while (TRUE) {
			gchar* name = NULL;
			gint _tmp104_ = 0;
			gchar* _tmp105_ = NULL;
			GtkButton* toggle_bit_button = NULL;
			GtkBuilder* _tmp106_ = NULL;
			const gchar* _tmp107_ = NULL;
			GObject* _tmp108_ = NULL;
			GtkButton* _tmp109_ = NULL;
			GtkButton* _tmp110_ = NULL;
			GtkButton* _tmp111_ = NULL;
			GtkButton* _tmp112_ = NULL;
			gint _tmp113_ = 0;
			_tmp104_ = i;
			_tmp105_ = g_strdup_printf ("toggle_bit_%d_button", _tmp104_);
			name = _tmp105_;
			_tmp106_ = builder;
			_tmp107_ = name;
			_tmp108_ = gtk_builder_get_object (_tmp106_, _tmp107_);
			_tmp109_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, gtk_button_get_type ()) ? ((GtkButton*) _tmp108_) : NULL);
			toggle_bit_button = _tmp109_;
			_tmp110_ = toggle_bit_button;
			if (_tmp110_ == NULL) {
				_g_object_unref0 (toggle_bit_button);
				_g_free0 (name);
				break;
			}
			_tmp111_ = toggle_bit_button;
			_tmp112_ = _g_object_ref0 (_tmp111_);
			self->priv->toggle_bit_buttons = g_list_append (self->priv->toggle_bit_buttons, _tmp112_);
			_tmp113_ = i;
			i = _tmp113_ + 1;
			_g_object_unref0 (toggle_bit_button);
			_g_free0 (name);
		}
		self->priv->toggle_bit_buttons = g_list_reverse (self->priv->toggle_bit_buttons);
		_tmp114_ = builder;
		_tmp115_ = gtk_builder_get_object (_tmp114_, "base_combo");
		_tmp116_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp115_, gtk_combo_box_get_type ()) ? ((GtkComboBox*) _tmp115_) : NULL);
		_g_object_unref0 (self->priv->base_combo);
		self->priv->base_combo = _tmp116_;
		_tmp117_ = self->priv->base_combo;
		g_signal_connect_object (_tmp117_, "changed", (GCallback) _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed, self, 0);
		_tmp118_ = self->priv->equation;
		g_signal_connect_object ((GObject*) _tmp118_, "notify::number-base", (GCallback) ____lambda20__g_object_notify, self, 0);
		math_buttons_base_changed_cb (self);
	}
	_tmp119_ = mode;
	if (_tmp119_ == BUTTON_MODE_FINANCIAL) {
		math_buttons_load_finc_dialogs (self);
	}
	_tmp120_ = builder;
	gtk_builder_connect_signals (_tmp120_, self);
	math_buttons_update_bit_panel (self);
	result = panel;
	_g_object_unref0 (menu_button);
	_g_object_unref0 (button);
	_g_free0 (builder_resource);
	_g_object_unref0 (builder);
	return result;
}


static void math_buttons_converter_changed_cb (MathButtons* self) {
	Unit* from_unit = NULL;
	Unit* to_unit = NULL;
	MathConverter* _tmp0_ = NULL;
	Unit* _tmp1_ = NULL;
	Unit* _tmp2_ = NULL;
	ButtonMode _tmp3_ = 0;
	ButtonMode _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->converter;
	math_converter_get_conversion (_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (from_unit);
	from_unit = _tmp1_;
	_g_object_unref0 (to_unit);
	to_unit = _tmp2_;
	_tmp3_ = math_buttons_get_mode (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_FINANCIAL) {
		MathEquation* _tmp5_ = NULL;
		Unit* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		MathEquation* _tmp10_ = NULL;
		Unit* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp5_ = self->priv->equation;
		_tmp6_ = from_unit;
		_tmp7_ = unit_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		math_equation_set_source_currency (_tmp5_, _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = self->priv->equation;
		_tmp11_ = to_unit;
		_tmp12_ = unit_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		math_equation_set_target_currency (_tmp10_, _tmp14_);
		_g_free0 (_tmp14_);
	} else {
		MathEquation* _tmp15_ = NULL;
		Unit* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		MathEquation* _tmp20_ = NULL;
		Unit* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		_tmp15_ = self->priv->equation;
		_tmp16_ = from_unit;
		_tmp17_ = unit_get_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		math_equation_set_source_units (_tmp15_, _tmp19_);
		_g_free0 (_tmp19_);
		_tmp20_ = self->priv->equation;
		_tmp21_ = to_unit;
		_tmp22_ = unit_get_name (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		math_equation_set_target_units (_tmp20_, _tmp24_);
		_g_free0 (_tmp24_);
	}
	_g_object_unref0 (to_unit);
	_g_object_unref0 (from_unit);
}


static void _math_buttons_converter_changed_cb_math_converter_changed (MathConverter* _sender, gpointer self) {
	math_buttons_converter_changed_cb ((MathButtons*) self);
}


static void math_buttons_load_buttons (MathButtons* self) {
	gboolean _tmp0_ = FALSE;
	MathConverter* _tmp1_ = NULL;
	GtkWidget* panel = NULL;
	ButtonMode _tmp6_ = 0;
	ButtonMode _tmp7_ = 0;
	GtkWidget* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkWidget* _tmp11_ = NULL;
	GtkWidget* _tmp13_ = NULL;
	GtkWidget* _tmp14_ = NULL;
	GtkWidget* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->converter;
	if (_tmp1_ == NULL) {
		MathEquation* _tmp2_ = NULL;
		MathConverter* _tmp3_ = NULL;
		MathConverter* _tmp4_ = NULL;
		MathConverter* _tmp5_ = NULL;
		_tmp2_ = self->priv->equation;
		_tmp3_ = math_converter_new (_tmp2_);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->converter);
		self->priv->converter = _tmp3_;
		_tmp4_ = self->priv->converter;
		g_signal_connect_object (_tmp4_, "changed", (GCallback) _math_buttons_converter_changed_cb_math_converter_changed, self, 0);
		_tmp5_ = self->priv->converter;
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp5_, FALSE, TRUE, (guint) 0);
	}
	_tmp6_ = math_buttons_get_mode (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = math_buttons_load_mode (self, _tmp7_);
	panel = _tmp8_;
	_tmp9_ = self->priv->active_panel;
	_tmp10_ = panel;
	if (_tmp9_ == _tmp10_) {
		_g_object_unref0 (panel);
		return;
	}
	_tmp11_ = self->priv->active_panel;
	if (_tmp11_ != NULL) {
		GtkWidget* _tmp12_ = NULL;
		_tmp12_ = self->priv->active_panel;
		gtk_widget_hide (_tmp12_);
	}
	_tmp13_ = panel;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_g_object_unref0 (self->priv->active_panel);
	self->priv->active_panel = _tmp14_;
	_tmp15_ = panel;
	if (_tmp15_ != NULL) {
		GtkWidget* _tmp16_ = NULL;
		_tmp16_ = panel;
		gtk_widget_show (_tmp16_);
	}
	_g_object_unref0 (panel);
}


static GMenu* math_buttons_create_shift_menu (MathButtons* self, gboolean shift_left) {
	GMenu* result = NULL;
	GMenu* shift_menu = NULL;
	GMenu* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_menu_new ();
	shift_menu = _tmp0_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				gchar* format = NULL;
				gint _tmp4_ = 0;
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp10_ = 0;
				gboolean _tmp11_ = FALSE;
				gint positions = 0;
				GMenu* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				if (!(_tmp3_ < 16)) {
					break;
				}
				_tmp4_ = i;
				_tmp5_ = ngettext ("%d place", "%d places", (gulong) _tmp4_);
				_tmp6_ = g_strdup (_tmp5_);
				format = _tmp6_;
				_tmp7_ = i;
				if (_tmp7_ < 10) {
					const gchar* _tmp8_ = NULL;
					gchar* _tmp9_ = NULL;
					_tmp8_ = format;
					_tmp9_ = g_strconcat ("_", _tmp8_, NULL);
					_g_free0 (format);
					format = _tmp9_;
				}
				_tmp11_ = shift_left;
				if (_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = i;
					_tmp10_ = _tmp12_;
				} else {
					gint _tmp13_ = 0;
					_tmp13_ = i;
					_tmp10_ = -_tmp13_;
				}
				positions = _tmp10_;
				_tmp14_ = shift_menu;
				_tmp15_ = format;
				_tmp16_ = i;
				_tmp17_ = g_strdup_printf (_tmp15_, _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = positions;
				_tmp20_ = g_strdup_printf ("cal.bitshift(%d)", _tmp19_);
				_tmp21_ = _tmp20_;
				g_menu_append (_tmp14_, _tmp18_, _tmp21_);
				_g_free0 (_tmp21_);
				_g_free0 (_tmp18_);
				_g_free0 (format);
			}
		}
	}
	result = shift_menu;
	return result;
}


static void math_buttons_on_launch_finc_dialog (MathButtons* self, GSimpleAction* action, GVariant* param) {
	gchar* name = NULL;
	GVariant* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GtkDialog* dialog = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkDialog* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = param;
	_tmp1_ = g_variant_get_string (_tmp0_, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = self->priv->financial_ui;
	_tmp4_ = gtk_builder_get_object (_tmp3_, name);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp4_) : NULL);
	dialog = _tmp5_;
	gtk_dialog_run (dialog);
	gtk_widget_hide ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
	_g_free0 (name);
}


static void math_buttons_on_insert_character (MathButtons* self, GSimpleAction* action, GVariant* param) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->character_code_dialog;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


static void math_buttons_finc_activate_cb (MathButtons* self, GtkWidget* widget) {
	GtkEntry* next_entry = NULL;
	GtkWidget* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GtkEntry* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "next-entry");
	_tmp2_ = _g_object_ref0 ((GtkEntry*) _tmp1_);
	next_entry = _tmp2_;
	_tmp3_ = next_entry;
	if (_tmp3_ == NULL) {
		GtkDialog* dialog = NULL;
		GtkWidget* _tmp4_ = NULL;
		GtkWidget* _tmp5_ = NULL;
		GtkDialog* _tmp6_ = NULL;
		GtkDialog* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp4_ = widget;
		_tmp5_ = gtk_widget_get_toplevel (_tmp4_);
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp5_) : NULL);
		dialog = _tmp6_;
		_tmp7_ = dialog;
		_tmp8_ = gtk_widget_is_toplevel ((GtkWidget*) _tmp7_);
		if (_tmp8_) {
			GtkDialog* _tmp9_ = NULL;
			_tmp9_ = dialog;
			gtk_dialog_response (_tmp9_, (gint) GTK_RESPONSE_OK);
			_g_object_unref0 (dialog);
			_g_object_unref0 (next_entry);
			return;
		}
		_g_object_unref0 (dialog);
	} else {
		GtkEntry* _tmp10_ = NULL;
		_tmp10_ = next_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
	}
	_g_object_unref0 (next_entry);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup9 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup10 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void math_buttons_finc_response_cb (MathButtons* self, GtkWidget* widget, gint response_id) {
	gint _tmp0_ = 0;
	FinancialDialog function = 0;
	GtkWidget* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gchar** entries = NULL;
	gchar** _tmp3_ = NULL;
	gint entries_length1 = 0;
	gint _entries_size_ = 0;
	FinancialDialog _tmp4_ = 0;
	Number* arg[4] = {0};
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	Number* _tmp18_ = NULL;
	Number* _tmp19_[4] = {0};
	GtkEntry* first_entry = NULL;
	GtkBuilder* _tmp36_ = NULL;
	gchar** _tmp37_ = NULL;
	gint _tmp37__length1 = 0;
	const gchar* _tmp38_ = NULL;
	GObject* _tmp39_ = NULL;
	GtkEntry* _tmp40_ = NULL;
	GtkEntry* _tmp41_ = NULL;
	MathEquation* _tmp42_ = NULL;
	FinancialDialog _tmp43_ = 0;
	Number* _tmp44_ = NULL;
	Number* _tmp45_ = NULL;
	Number* _tmp46_ = NULL;
	Number* _tmp47_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = response_id;
	if (_tmp0_ != ((gint) GTK_RESPONSE_OK)) {
		return;
	}
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "finc-function");
	function = (FinancialDialog) ((gint) ((gintptr) _tmp2_));
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	entries = _tmp3_;
	entries_length1 = 0;
	_entries_size_ = entries_length1;
	_tmp4_ = function;
	switch (_tmp4_) {
		case FINANCIAL_DIALOG_CTRM_DIALOG:
		{
			gchar** _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
			_tmp5_ = (MATH_BUTTONS_ctrm_entries != NULL) ? _vala_array_dup1 (MATH_BUTTONS_ctrm_entries, G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries)) : ((gpointer) MATH_BUTTONS_ctrm_entries);
			_tmp5__length1 = G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp5_;
			entries_length1 = _tmp5__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_DDB_DIALOG:
		{
			gchar** _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			_tmp6_ = (MATH_BUTTONS_ddb_entries != NULL) ? _vala_array_dup2 (MATH_BUTTONS_ddb_entries, G_N_ELEMENTS (MATH_BUTTONS_ddb_entries)) : ((gpointer) MATH_BUTTONS_ddb_entries);
			_tmp6__length1 = G_N_ELEMENTS (MATH_BUTTONS_ddb_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp6_;
			entries_length1 = _tmp6__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_FV_DIALOG:
		{
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			_tmp7_ = (MATH_BUTTONS_fv_entries != NULL) ? _vala_array_dup3 (MATH_BUTTONS_fv_entries, G_N_ELEMENTS (MATH_BUTTONS_fv_entries)) : ((gpointer) MATH_BUTTONS_fv_entries);
			_tmp7__length1 = G_N_ELEMENTS (MATH_BUTTONS_fv_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp7_;
			entries_length1 = _tmp7__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_GPM_DIALOG:
		{
			gchar** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			_tmp8_ = (MATH_BUTTONS_gpm_entries != NULL) ? _vala_array_dup4 (MATH_BUTTONS_gpm_entries, G_N_ELEMENTS (MATH_BUTTONS_gpm_entries)) : ((gpointer) MATH_BUTTONS_gpm_entries);
			_tmp8__length1 = G_N_ELEMENTS (MATH_BUTTONS_gpm_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp8_;
			entries_length1 = _tmp8__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_PMT_DIALOG:
		{
			gchar** _tmp9_ = NULL;
			gint _tmp9__length1 = 0;
			_tmp9_ = (MATH_BUTTONS_pmt_entries != NULL) ? _vala_array_dup5 (MATH_BUTTONS_pmt_entries, G_N_ELEMENTS (MATH_BUTTONS_pmt_entries)) : ((gpointer) MATH_BUTTONS_pmt_entries);
			_tmp9__length1 = G_N_ELEMENTS (MATH_BUTTONS_pmt_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp9_;
			entries_length1 = _tmp9__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_PV_DIALOG:
		{
			gchar** _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			_tmp10_ = (MATH_BUTTONS_pv_entries != NULL) ? _vala_array_dup6 (MATH_BUTTONS_pv_entries, G_N_ELEMENTS (MATH_BUTTONS_pv_entries)) : ((gpointer) MATH_BUTTONS_pv_entries);
			_tmp10__length1 = G_N_ELEMENTS (MATH_BUTTONS_pv_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp10_;
			entries_length1 = _tmp10__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_RATE_DIALOG:
		{
			gchar** _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
			_tmp11_ = (MATH_BUTTONS_rate_entries != NULL) ? _vala_array_dup7 (MATH_BUTTONS_rate_entries, G_N_ELEMENTS (MATH_BUTTONS_rate_entries)) : ((gpointer) MATH_BUTTONS_rate_entries);
			_tmp11__length1 = G_N_ELEMENTS (MATH_BUTTONS_rate_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp11_;
			entries_length1 = _tmp11__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_SLN_DIALOG:
		{
			gchar** _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			_tmp12_ = (MATH_BUTTONS_sln_entries != NULL) ? _vala_array_dup8 (MATH_BUTTONS_sln_entries, G_N_ELEMENTS (MATH_BUTTONS_sln_entries)) : ((gpointer) MATH_BUTTONS_sln_entries);
			_tmp12__length1 = G_N_ELEMENTS (MATH_BUTTONS_sln_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp12_;
			entries_length1 = _tmp12__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_SYD_DIALOG:
		{
			gchar** _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			_tmp13_ = (MATH_BUTTONS_syd_entries != NULL) ? _vala_array_dup9 (MATH_BUTTONS_syd_entries, G_N_ELEMENTS (MATH_BUTTONS_syd_entries)) : ((gpointer) MATH_BUTTONS_syd_entries);
			_tmp13__length1 = G_N_ELEMENTS (MATH_BUTTONS_syd_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp13_;
			entries_length1 = _tmp13__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_TERM_DIALOG:
		{
			gchar** _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			_tmp14_ = (MATH_BUTTONS_term_entries != NULL) ? _vala_array_dup10 (MATH_BUTTONS_term_entries, G_N_ELEMENTS (MATH_BUTTONS_term_entries)) : ((gpointer) MATH_BUTTONS_term_entries);
			_tmp14__length1 = G_N_ELEMENTS (MATH_BUTTONS_term_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp14_;
			entries_length1 = _tmp14__length1;
			_entries_size_ = entries_length1;
			break;
		}
		default:
		break;
	}
	_tmp15_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp16_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp17_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp18_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp19_[0] = _tmp15_;
	_tmp19_[1] = _tmp16_;
	_tmp19_[2] = _tmp17_;
	_tmp19_[3] = _tmp18_;
	memcpy (arg, _tmp19_, 4 * sizeof (Number*));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				gint _tmp22_ = 0;
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				GtkEntry* entry = NULL;
				GtkBuilder* _tmp24_ = NULL;
				gchar** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				gint _tmp26_ = 0;
				const gchar* _tmp27_ = NULL;
				GObject* _tmp28_ = NULL;
				GtkEntry* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				GtkEntry* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				Number* _tmp33_ = NULL;
				Number* _tmp34_ = NULL;
				GtkEntry* _tmp35_ = NULL;
				if (!_tmp20_) {
					gint _tmp21_ = 0;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp22_ = i;
				_tmp23_ = entries;
				_tmp23__length1 = entries_length1;
				if (!(_tmp22_ < _tmp23__length1)) {
					break;
				}
				_tmp24_ = self->priv->financial_ui;
				_tmp25_ = entries;
				_tmp25__length1 = entries_length1;
				_tmp26_ = i;
				_tmp27_ = _tmp25_[_tmp26_];
				_tmp28_ = gtk_builder_get_object (_tmp24_, _tmp27_);
				_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp28_) : NULL);
				entry = _tmp29_;
				_tmp30_ = i;
				_tmp31_ = entry;
				_tmp32_ = gtk_entry_get_text (_tmp31_);
				_tmp33_ = mp_set_from_string (_tmp32_, 10);
				_g_object_unref0 (arg[_tmp30_]);
				arg[_tmp30_] = _tmp33_;
				_tmp34_ = arg[_tmp30_];
				_tmp35_ = entry;
				gtk_entry_set_text (_tmp35_, "0");
				_g_object_unref0 (entry);
			}
		}
	}
	_tmp36_ = self->priv->financial_ui;
	_tmp37_ = entries;
	_tmp37__length1 = entries_length1;
	_tmp38_ = _tmp37_[0];
	_tmp39_ = gtk_builder_get_object (_tmp36_, _tmp38_);
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp39_) : NULL);
	first_entry = _tmp40_;
	_tmp41_ = first_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp41_);
	_tmp42_ = self->priv->equation;
	_tmp43_ = function;
	_tmp44_ = arg[0];
	_tmp45_ = arg[1];
	_tmp46_ = arg[2];
	_tmp47_ = arg[3];
	do_finc_expression (_tmp42_, _tmp43_, _tmp44_, _tmp45_, _tmp46_, _tmp47_);
	_g_object_unref0 (first_entry);
	_vala_array_destroy (arg, 4, (GDestroyNotify) g_object_unref);
	entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void math_buttons_character_code_dialog_response_cb (MathButtons* self, GtkWidget* dialog, gint response_id) {
	gchar* text = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkWidget* _tmp21_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_tmp0_ = self->priv->character_code_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	text = _tmp2_;
	_tmp3_ = response_id;
	if (_tmp3_ == ((gint) GTK_RESPONSE_OK)) {
		Number* x = NULL;
		Number* _tmp4_ = NULL;
		MathEquation* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		_tmp4_ = number_new_integer ((gint64) 0, (gint64) 0);
		x = _tmp4_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					const gchar* _tmp7_ = NULL;
					gint _tmp8_ = 0;
					gchar _tmp9_ = '\0';
					Number* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					gchar _tmp13_ = '\0';
					Number* _tmp14_ = NULL;
					Number* _tmp15_ = NULL;
					Number* _tmp16_ = NULL;
					Number* _tmp17_ = NULL;
					Number* _tmp18_ = NULL;
					if (!_tmp5_) {
						gint _tmp6_ = 0;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = text;
					_tmp8_ = i;
					_tmp9_ = string_get (_tmp7_, (glong) _tmp8_);
					if (!(_tmp9_ != '\0')) {
						break;
					}
					_tmp10_ = x;
					_tmp11_ = text;
					_tmp12_ = i;
					_tmp13_ = string_get (_tmp11_, (glong) _tmp12_);
					_tmp14_ = number_new_integer ((gint64) _tmp13_, (gint64) 0);
					_tmp15_ = _tmp14_;
					_tmp16_ = number_add (_tmp10_, _tmp15_);
					_g_object_unref0 (x);
					x = _tmp16_;
					_g_object_unref0 (_tmp15_);
					_tmp17_ = x;
					_tmp18_ = number_shift (_tmp17_, 8);
					_g_object_unref0 (x);
					x = _tmp18_;
				}
			}
		}
		_tmp19_ = self->priv->equation;
		_tmp20_ = x;
		math_equation_insert_number (_tmp19_, _tmp20_);
		_g_object_unref0 (x);
	}
	_tmp21_ = dialog;
	gtk_widget_hide (_tmp21_);
	_g_free0 (text);
}


static void math_buttons_character_code_dialog_activate_cb (MathButtons* self, GtkWidget* entry) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = self->priv->character_code_dialog;
	math_buttons_character_code_dialog_response_cb (self, (GtkWidget*) _tmp0_, (gint) GTK_RESPONSE_OK);
}


static gboolean math_buttons_character_code_dialog_delete_cb (MathButtons* self, GtkWidget* dialog, GdkEventAny* event) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dialog != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = dialog;
	math_buttons_character_code_dialog_response_cb (self, _tmp0_, (gint) GTK_RESPONSE_CANCEL);
	result = TRUE;
	return result;
}


static void math_buttons_on_toggle_bit (MathButtons* self, GSimpleAction* action, GVariant* param) {
	MathEquation* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	gint32 _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = param;
	_tmp2_ = g_variant_get_int32 (_tmp1_);
	math_equation_toggle_bit (_tmp0_, (guint) _tmp2_);
}


static void math_buttons_on_set_number_mode (MathButtons* self, GSimpleAction* action, GVariant* param) {
	GVariant* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = param;
	_tmp1_ = g_variant_get_string (_tmp0_, NULL);
	_tmp2_ = action;
	_tmp3_ = g_action_get_state ((GAction*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_get_string (_tmp5_, NULL);
	_tmp7_ = g_strcmp0 (_tmp1_, _tmp6_) == 0;
	_g_variant_unref0 (_tmp5_);
	if (_tmp7_) {
		MathEquation* _tmp8_ = NULL;
		_tmp8_ = self->priv->equation;
		math_equation_set_number_mode (_tmp8_, NUMBER_MODE_NORMAL);
	} else {
		GVariant* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp9_ = param;
		_tmp10_ = g_variant_get_string (_tmp9_, NULL);
		if (g_strcmp0 (_tmp10_, "superscript") == 0) {
			MathEquation* _tmp11_ = NULL;
			MathEquation* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			_tmp11_ = self->priv->equation;
			math_equation_set_number_mode (_tmp11_, NUMBER_MODE_SUPERSCRIPT);
			_tmp12_ = self->priv->equation;
			_tmp13_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp12_);
			_tmp14_ = _tmp13_;
			if (!_tmp14_) {
				MathEquation* _tmp15_ = NULL;
				_tmp15_ = self->priv->equation;
				math_equation_remove_trailing_spaces (_tmp15_);
			}
		} else {
			GVariant* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			_tmp16_ = param;
			_tmp17_ = g_variant_get_string (_tmp16_, NULL);
			if (g_strcmp0 (_tmp17_, "subscript") == 0) {
				MathEquation* _tmp18_ = NULL;
				MathEquation* _tmp19_ = NULL;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				_tmp18_ = self->priv->equation;
				math_equation_set_number_mode (_tmp18_, NUMBER_MODE_SUBSCRIPT);
				_tmp19_ = self->priv->equation;
				_tmp20_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp19_);
				_tmp21_ = _tmp20_;
				if (!_tmp21_) {
					MathEquation* _tmp22_ = NULL;
					_tmp22_ = self->priv->equation;
					math_equation_remove_trailing_spaces (_tmp22_);
				}
			}
		}
	}
}


static GVariant* _variant_new2 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new3 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new4 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static void math_buttons_number_mode_changed_cb (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	NumberMode _tmp1_ = 0;
	NumberMode _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_equation_get_number_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NUMBER_MODE_SUPERSCRIPT) {
		GSimpleActionGroup* _tmp3_ = NULL;
		GVariant* _tmp4_ = NULL;
		_tmp3_ = self->priv->action_group;
		_tmp4_ = _variant_new2 ("superscript");
		g_action_group_change_action_state ((GActionGroup*) _tmp3_, "set-number-mode", _tmp4_);
		_g_variant_unref0 (_tmp4_);
	} else {
		MathEquation* _tmp5_ = NULL;
		NumberMode _tmp6_ = 0;
		NumberMode _tmp7_ = 0;
		_tmp5_ = self->priv->equation;
		_tmp6_ = math_equation_get_number_mode (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == NUMBER_MODE_SUBSCRIPT) {
			GSimpleActionGroup* _tmp8_ = NULL;
			GVariant* _tmp9_ = NULL;
			_tmp8_ = self->priv->action_group;
			_tmp9_ = _variant_new3 ("subscript");
			g_action_group_change_action_state ((GActionGroup*) _tmp8_, "set-number-mode", _tmp9_);
			_g_variant_unref0 (_tmp9_);
		} else {
			GSimpleActionGroup* _tmp10_ = NULL;
			GVariant* _tmp11_ = NULL;
			_tmp10_ = self->priv->action_group;
			_tmp11_ = _variant_new4 ("normal");
			g_action_group_change_action_state ((GActionGroup*) _tmp10_, "set-number-mode", _tmp11_);
			_g_variant_unref0 (_tmp11_);
		}
	}
}


ButtonMode math_buttons_get_mode (MathButtons* self) {
	ButtonMode result;
	ButtonMode _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_mode;
	result = _tmp0_;
	return result;
}


void math_buttons_set_mode (MathButtons* self, ButtonMode value) {
	ButtonMode _tmp0_ = 0;
	ButtonMode _tmp1_ = 0;
	ButtonMode _tmp2_ = 0;
	ButtonMode _tmp3_ = 0;
	ButtonMode _tmp4_ = 0;
	gboolean _tmp8_ = FALSE;
	ButtonMode _tmp9_ = 0;
	ButtonMode _tmp10_ = 0;
	MathConverter* _tmp13_ = NULL;
	ButtonMode _tmp14_ = 0;
	ButtonMode _tmp15_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_mode;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->_mode = _tmp2_;
	_tmp3_ = math_buttons_get_mode (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_PROGRAMMING) {
		MathEquation* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp5_ = self->priv->equation;
		_tmp6_ = self->priv->_programming_base;
		math_equation_set_number_base (_tmp5_, _tmp6_);
	} else {
		MathEquation* _tmp7_ = NULL;
		_tmp7_ = self->priv->equation;
		math_equation_set_number_base (_tmp7_, 10);
	}
	math_buttons_load_buttons (self);
	_tmp9_ = math_buttons_get_mode (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == BUTTON_MODE_ADVANCED) {
		_tmp8_ = TRUE;
	} else {
		ButtonMode _tmp11_ = 0;
		ButtonMode _tmp12_ = 0;
		_tmp11_ = math_buttons_get_mode (self);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_ == BUTTON_MODE_FINANCIAL;
	}
	_tmp13_ = self->priv->converter;
	gtk_widget_set_visible ((GtkWidget*) _tmp13_, _tmp8_);
	_tmp14_ = math_buttons_get_mode (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == BUTTON_MODE_ADVANCED) {
		MathConverter* _tmp16_ = NULL;
		MathConverter* _tmp17_ = NULL;
		MathEquation* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		MathEquation* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		_tmp16_ = self->priv->converter;
		math_converter_set_category (_tmp16_, NULL);
		_tmp17_ = self->priv->converter;
		_tmp18_ = self->priv->equation;
		_tmp19_ = math_equation_get_source_units (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->equation;
		_tmp23_ = math_equation_get_target_units (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_;
		math_converter_set_conversion (_tmp17_, _tmp21_, _tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp21_);
	} else {
		ButtonMode _tmp26_ = 0;
		ButtonMode _tmp27_ = 0;
		_tmp26_ = math_buttons_get_mode (self);
		_tmp27_ = _tmp26_;
		if (_tmp27_ == BUTTON_MODE_FINANCIAL) {
			MathConverter* _tmp28_ = NULL;
			MathConverter* _tmp29_ = NULL;
			MathEquation* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			MathEquation* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			_tmp28_ = self->priv->converter;
			math_converter_set_category (_tmp28_, "currency");
			_tmp29_ = self->priv->converter;
			_tmp30_ = self->priv->equation;
			_tmp31_ = math_equation_get_source_currency (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = _tmp32_;
			_tmp34_ = self->priv->equation;
			_tmp35_ = math_equation_get_target_currency (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _tmp36_;
			math_converter_set_conversion (_tmp29_, _tmp33_, _tmp37_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp33_);
		}
	}
	g_object_notify ((GObject *) self, "mode");
}


gint math_buttons_get_programming_base (MathButtons* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_programming_base;
	result = _tmp0_;
	return result;
}


void math_buttons_set_programming_base (MathButtons* self, gint value) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ButtonMode _tmp3_ = 0;
	ButtonMode _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_programming_base;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->_programming_base = _tmp2_;
	_tmp3_ = math_buttons_get_mode (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_PROGRAMMING) {
		MathEquation* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp5_ = self->priv->equation;
		_tmp6_ = value;
		math_equation_set_number_base (_tmp5_, _tmp6_);
	}
	g_object_notify ((GObject *) self, "programming-base");
}


static void math_buttons_class_init (MathButtonsClass * klass) {
	math_buttons_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathButtonsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_math_buttons_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_buttons_set_property;
	G_OBJECT_CLASS (klass)->finalize = math_buttons_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_MODE, g_param_spec_enum ("mode", "mode", "mode", TYPE_BUTTON_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_PROGRAMMING_BASE, g_param_spec_int ("programming-base", "programming-base", "programming-base", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void math_buttons_instance_init (MathButtons * self) {
	GSimpleActionGroup* _tmp0_ = NULL;
	self->priv = MATH_BUTTONS_GET_PRIVATE (self);
	self->priv->_programming_base = 10;
	self->priv->active_panel = NULL;
	_tmp0_ = g_simple_action_group_new ();
	self->priv->action_group = _tmp0_;
}


static void math_buttons_finalize (GObject* obj) {
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_BUTTONS, MathButtons);
	_g_object_unref0 (self->priv->equation);
	_g_object_unref0 (self->priv->converter);
	_g_object_unref0 (self->priv->basic_ui);
	_g_object_unref0 (self->priv->advanced_ui);
	_g_object_unref0 (self->priv->financial_ui);
	_g_object_unref0 (self->priv->programming_ui);
	_g_object_unref0 (self->priv->bas_panel);
	_g_object_unref0 (self->priv->adv_panel);
	_g_object_unref0 (self->priv->fin_panel);
	_g_object_unref0 (self->priv->prog_panel);
	_g_object_unref0 (self->priv->active_panel);
	_g_object_unref0 (self->priv->base_combo);
	_g_object_unref0 (self->priv->base_label);
	_g_object_unref0 (self->priv->bit_panel);
	__g_list_free__g_object_unref0_0 (self->priv->toggle_bit_buttons);
	_g_object_unref0 (self->priv->character_code_dialog);
	_g_object_unref0 (self->priv->character_code_entry);
	_g_object_unref0 (self->priv->action_group);
	G_OBJECT_CLASS (math_buttons_parent_class)->finalize (obj);
}


GType math_buttons_get_type (void) {
	static volatile gsize math_buttons_type_id__volatile = 0;
	if (g_once_init_enter (&math_buttons_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathButtonsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_buttons_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathButtons), 0, (GInstanceInitFunc) math_buttons_instance_init, NULL };
		GType math_buttons_type_id;
		math_buttons_type_id = g_type_register_static (gtk_box_get_type (), "MathButtons", &g_define_type_info, 0);
		g_once_init_leave (&math_buttons_type_id__volatile, math_buttons_type_id);
	}
	return math_buttons_type_id__volatile;
}


static void _vala_math_buttons_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
	switch (property_id) {
		case MATH_BUTTONS_MODE:
		g_value_set_enum (value, math_buttons_get_mode (self));
		break;
		case MATH_BUTTONS_PROGRAMMING_BASE:
		g_value_set_int (value, math_buttons_get_programming_base (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_math_buttons_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
	switch (property_id) {
		case MATH_BUTTONS_MODE:
		math_buttons_set_mode (self, g_value_get_enum (value));
		break;
		case MATH_BUTTONS_PROGRAMMING_BASE:
		math_buttons_set_programming_base (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



