/* spice-display.c generated by valac 0.34.2, the Vala compiler
 * generated from spice-display.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libcommon.h>
#include <stdlib.h>
#include <string.h>
#include <spice-client.h>
#include <spice-widget.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <libusb.h>
#include <libxml/uri.h>


#define BOXES_TYPE_IPROPERTIES_PROVIDER (boxes_iproperties_provider_get_type ())
#define BOXES_IPROPERTIES_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER, BoxesIPropertiesProvider))
#define BOXES_IS_IPROPERTIES_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER))
#define BOXES_IPROPERTIES_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER, BoxesIPropertiesProviderIface))

typedef struct _BoxesIPropertiesProvider BoxesIPropertiesProvider;
typedef struct _BoxesIPropertiesProviderIface BoxesIPropertiesProviderIface;

#define BOXES_TYPE_PROPERTIES_PAGE (boxes_properties_page_get_type ())

#define BOXES_TYPE_PROPERTY (boxes_property_get_type ())
#define BOXES_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_PROPERTY, BoxesProperty))
#define BOXES_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_PROPERTY, BoxesPropertyClass))
#define BOXES_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_PROPERTY))
#define BOXES_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_PROPERTY))
#define BOXES_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_PROPERTY, BoxesPropertyClass))

typedef struct _BoxesProperty BoxesProperty;
typedef struct _BoxesPropertyClass BoxesPropertyClass;

#define BOXES_TYPE_DISPLAY (boxes_display_get_type ())
#define BOXES_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DISPLAY, BoxesDisplay))
#define BOXES_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DISPLAY, BoxesDisplayClass))
#define BOXES_IS_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DISPLAY))
#define BOXES_IS_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DISPLAY))
#define BOXES_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DISPLAY, BoxesDisplayClass))

typedef struct _BoxesDisplay BoxesDisplay;
typedef struct _BoxesDisplayClass BoxesDisplayClass;
typedef struct _BoxesDisplayPrivate BoxesDisplayPrivate;

#define BOXES_TYPE_SPICE_DISPLAY (boxes_spice_display_get_type ())
#define BOXES_SPICE_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay))
#define BOXES_SPICE_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplayClass))
#define BOXES_IS_SPICE_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SPICE_DISPLAY))
#define BOXES_IS_SPICE_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SPICE_DISPLAY))
#define BOXES_SPICE_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplayClass))

typedef struct _BoxesSpiceDisplay BoxesSpiceDisplay;
typedef struct _BoxesSpiceDisplayClass BoxesSpiceDisplayClass;
typedef struct _BoxesSpiceDisplayPrivate BoxesSpiceDisplayPrivate;

#define BOXES_TYPE_COLLECTION_ITEM (boxes_collection_item_get_type ())
#define BOXES_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem))
#define BOXES_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))
#define BOXES_IS_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_IS_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_COLLECTION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))

typedef struct _BoxesCollectionItem BoxesCollectionItem;
typedef struct _BoxesCollectionItemClass BoxesCollectionItemClass;

#define BOXES_TYPE_MACHINE (boxes_machine_get_type ())
#define BOXES_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_MACHINE, BoxesMachine))
#define BOXES_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_MACHINE, BoxesMachineClass))
#define BOXES_IS_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_MACHINE))
#define BOXES_IS_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_MACHINE))
#define BOXES_MACHINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_MACHINE, BoxesMachineClass))

typedef struct _BoxesMachine BoxesMachine;
typedef struct _BoxesMachineClass BoxesMachineClass;

#define BOXES_TYPE_SPICE_CHANNEL_HANDLER (boxes_spice_channel_handler_get_type ())
#define BOXES_SPICE_CHANNEL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SPICE_CHANNEL_HANDLER, BoxesSpiceChannelHandler))
#define BOXES_SPICE_CHANNEL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SPICE_CHANNEL_HANDLER, BoxesSpiceChannelHandlerClass))
#define BOXES_IS_SPICE_CHANNEL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SPICE_CHANNEL_HANDLER))
#define BOXES_IS_SPICE_CHANNEL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SPICE_CHANNEL_HANDLER))
#define BOXES_SPICE_CHANNEL_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SPICE_CHANNEL_HANDLER, BoxesSpiceChannelHandlerClass))

typedef struct _BoxesSpiceChannelHandler BoxesSpiceChannelHandler;
typedef struct _BoxesSpiceChannelHandlerClass BoxesSpiceChannelHandlerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define BOXES_TYPE_UI (boxes_ui_get_type ())
#define BOXES_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UI, BoxesUI))
#define BOXES_IS_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UI))
#define BOXES_UI_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_UI, BoxesUIIface))

typedef struct _BoxesUI BoxesUI;
typedef struct _BoxesUIIface BoxesUIIface;

#define BOXES_TYPE_UI_STATE (boxes_ui_state_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_SpiceUsbDevice_free0(var) ((var == NULL) ? NULL : (var = (_vala_SpiceUsbDevice_free (var), NULL)))
typedef struct _Block78Data Block78Data;
typedef struct _Block79Data Block79Data;
typedef struct _Block80Data Block80Data;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _libusb_unref_device0(var) ((var == NULL) ? NULL : (var = (libusb_unref_device (var), NULL)))
#define _libusb_free_config_descriptor0(var) ((var == NULL) ? NULL : (var = (libusb_free_config_descriptor (var), NULL)))
typedef struct _BoxesSpiceChannelHandlerPrivate BoxesSpiceChannelHandlerPrivate;
#define _xmlFreeURI0(var) ((var == NULL) ? NULL : (var = (xmlFreeURI (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	BOXES_PROPERTIES_PAGE_GENERAL,
	BOXES_PROPERTIES_PAGE_SYSTEM,
	BOXES_PROPERTIES_PAGE_DEVICES,
	BOXES_PROPERTIES_PAGE_SNAPSHOTS,
	BOXES_PROPERTIES_PAGE_LAST
} BoxesPropertiesPage;

struct _BoxesIPropertiesProviderIface {
	GTypeInterface parent_iface;
	GList* (*get_properties) (BoxesIPropertiesProvider* self, BoxesPropertiesPage page);
};

typedef gint (*BoxesDisplayOpenFDFunc) (void* user_data);
struct _BoxesDisplay {
	GObject parent_instance;
	BoxesDisplayPrivate * priv;
	gboolean connected;
	GHashTable* displays;
};

struct _BoxesDisplayClass {
	GObjectClass parent_class;
	GtkWidget* (*get_display) (BoxesDisplay* self, gint n);
	GdkPixbuf* (*get_pixbuf) (BoxesDisplay* self, gint n, GError** error);
	void (*set_enable_audio) (BoxesDisplay* self, gboolean enable);
	gboolean (*should_keep_alive) (BoxesDisplay* self);
	void (*connect_it) (BoxesDisplay* self, BoxesDisplayOpenFDFunc open_fd, void* open_fd_target, GDestroyNotify open_fd_target_destroy_notify, GError** error);
	void (*disconnect_it) (BoxesDisplay* self);
	void (*collect_logs) (BoxesDisplay* self, GString* builder);
	void (*send_keys) (BoxesDisplay* self, guint* keyvals, int keyvals_length1);
	GList* (*get_properties) (BoxesDisplay* self, BoxesPropertiesPage page);
	const gchar* (*get_protocol) (BoxesDisplay* self);
	gchar* (*get_uri) (BoxesDisplay* self);
};

struct _BoxesSpiceDisplay {
	BoxesDisplay parent_instance;
	BoxesSpiceDisplayPrivate * priv;
};

struct _BoxesSpiceDisplayClass {
	BoxesDisplayClass parent_class;
};

struct _BoxesSpiceDisplayPrivate {
	BoxesMachine* machine;
	SpiceSession* session;
	SpiceGtkSession* gtk_session;
	SpiceAudio* audio;
	gulong channel_new_id;
	gulong channel_destroy_id;
	BoxesBoxConfigSavedProperty* display_saved_properties;
	gint display_saved_properties_length1;
	gint _display_saved_properties_size_;
	BoxesBoxConfigSavedProperty* gtk_session_saved_properties;
	gint gtk_session_saved_properties_length1;
	gint _gtk_session_saved_properties_size_;
	gboolean closed;
	GHashTable* channel_handlers;
	BoxesDisplayOpenFDFunc open_fd;
	gpointer open_fd_target;
	GDestroyNotify open_fd_target_destroy_notify;
	SpiceMainChannel* _main_channel;
	gulong main_event_id;
	gulong main_mouse_mode_id;
};

typedef enum  {
	BOXES_UI_STATE_NONE,
	BOXES_UI_STATE_COLLECTION,
	BOXES_UI_STATE_CREDS,
	BOXES_UI_STATE_DISPLAY,
	BOXES_UI_STATE_WIZARD,
	BOXES_UI_STATE_PROPERTIES
} BoxesUIState;

struct _BoxesUIIface {
	GTypeInterface parent_iface;
	BoxesUIState (*get_previous_ui_state) (BoxesUI* self);
	void (*set_previous_ui_state) (BoxesUI* self, BoxesUIState value);
	BoxesUIState (*get_ui_state) (BoxesUI* self);
	void (*set_ui_state) (BoxesUI* self, BoxesUIState value);
};

struct _Block78Data {
	int _ref_count_;
	BoxesSpiceDisplay* self;
	SpiceUsbDeviceManager* manager;
	BoxesProperty* usb_property;
};

struct _Block79Data {
	int _ref_count_;
	GPtrArray* self;
	GCompareFunc compare_func;
};

struct _Block80Data {
	int _ref_count_;
	Block78Data * _data78_;
	SpiceUsbDevice* dev;
	GtkSwitch* dev_toggle;
};

struct _BoxesSpiceChannelHandler {
	GObject parent_instance;
	BoxesSpiceChannelHandlerPrivate * priv;
};

struct _BoxesSpiceChannelHandlerClass {
	GObjectClass parent_class;
};

struct _BoxesSpiceChannelHandlerPrivate {
	BoxesSpiceDisplay* display;
	SpiceChannel* channel;
	BoxesDisplayOpenFDFunc open_fd;
	gpointer open_fd_target;
	GDestroyNotify open_fd_target_destroy_notify;
};


static gpointer boxes_spice_display_parent_class = NULL;
static gpointer boxes_spice_channel_handler_parent_class = NULL;

GType boxes_properties_page_get_type (void) G_GNUC_CONST;
GType boxes_property_get_type (void) G_GNUC_CONST;
GType boxes_iproperties_provider_get_type (void) G_GNUC_CONST;
GType boxes_display_get_type (void) G_GNUC_CONST;
GType boxes_spice_display_get_type (void) G_GNUC_CONST;
GType boxes_collection_item_get_type (void) G_GNUC_CONST;
GType boxes_machine_get_type (void) G_GNUC_CONST;
GType boxes_spice_channel_handler_get_type (void) G_GNUC_CONST;
#define BOXES_SPICE_DISPLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplayPrivate))
enum  {
	BOXES_SPICE_DISPLAY_DUMMY_PROPERTY,
	BOXES_SPICE_DISPLAY_PROTOCOL,
	BOXES_SPICE_DISPLAY_URI,
	BOXES_SPICE_DISPLAY_CA_CERT,
	BOXES_SPICE_DISPLAY_MAIN_CHANNEL
};
static void boxes_spice_display_main_cleanup (BoxesSpiceDisplay* self);
static void _vala_BoxesBoxConfigSavedProperty_array_free (BoxesBoxConfigSavedProperty* array, gint array_length);
static void boxes_spice_display_ui_state_changed (BoxesSpiceDisplay* self);
GType boxes_ui_state_get_type (void) G_GNUC_CONST;
GType boxes_ui_get_type (void) G_GNUC_CONST;
BoxesUIState boxes_ui_get_ui_state (BoxesUI* self);
GtkWidget* boxes_display_get_display (BoxesDisplay* self, gint n);
static gchar* boxes_spice_display_get_box_name (BoxesSpiceDisplay* self);
BoxesBoxConfig* boxes_display_get_config (BoxesDisplay* self);
SpiceMainChannel* boxes_spice_display_get_main_channel (BoxesSpiceDisplay* self);
void boxes_spice_display_set_main_channel (BoxesSpiceDisplay* self, SpiceMainChannel* value);
BoxesSpiceDisplay* boxes_spice_display_new (BoxesMachine* machine, BoxesBoxConfig* config, const gchar* host, gint port, gint tls_port, const gchar* host_subject);
BoxesSpiceDisplay* boxes_spice_display_construct (GType object_type, BoxesMachine* machine, BoxesBoxConfig* config, const gchar* host, gint port, gint tls_port, const gchar* host_subject);
BoxesDisplay* boxes_display_construct (GType object_type);
static void _boxes_spice_display_ui_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void boxes_display_set_config (BoxesDisplay* self, BoxesBoxConfig* value);
BoxesSpiceDisplay* boxes_spice_display_new_with_uri (BoxesMachine* machine, BoxesBoxConfig* config, const gchar* uri);
BoxesSpiceDisplay* boxes_spice_display_construct_with_uri (GType object_type, BoxesMachine* machine, BoxesBoxConfig* config, const gchar* uri);
BoxesSpiceDisplay* boxes_spice_display_new_priv (BoxesMachine* machine, BoxesBoxConfig* config);
BoxesSpiceDisplay* boxes_spice_display_construct_priv (GType object_type, BoxesMachine* machine, BoxesBoxConfig* config);
static GtkWidget* boxes_spice_display_real_get_display (BoxesDisplay* base, gint n);
static void ___lambda70_ (BoxesSpiceDisplay* self, gint status);
void boxes_display_set_mouse_grabbed (BoxesDisplay* self, gboolean value);
static void ____lambda70__spice_display_mouse_grab (SpiceDisplay* _sender, gint status, gpointer self);
static void ___lambda71_ (BoxesSpiceDisplay* self, gint status);
void boxes_display_set_keyboard_grabbed (BoxesDisplay* self, gboolean value);
static void ____lambda71__spice_display_keyboard_grab (SpiceDisplay* _sender, gint status, gpointer self);
static gboolean boxes_spice_display_real_should_keep_alive (BoxesDisplay* base);
static GPtrArray* boxes_spice_display_get_usb_devices (BoxesSpiceDisplay* self, SpiceUsbDeviceManager* manager);
static void boxes_spice_display_real_set_enable_audio (BoxesDisplay* base, gboolean enable);
static GdkPixbuf* boxes_spice_display_real_get_pixbuf (BoxesDisplay* base, gint n, GError** error);
static void boxes_spice_display_real_collect_logs (BoxesDisplay* base, GString* builder);
gchar* boxes_display_get_uri (BoxesDisplay* self);
static SpiceUsbDevice* _vala_SpiceUsbDevice_copy (SpiceUsbDevice* self);
static void _vala_SpiceUsbDevice_free (SpiceUsbDevice* self);
static void boxes_spice_display_real_connect_it (BoxesDisplay* base, BoxesDisplayOpenFDFunc open_fd, void* open_fd_target, GDestroyNotify open_fd_target_destroy_notify, GError** error);
static void _g_object_unref0_ (gpointer var);
static void boxes_spice_display_on_channel_new (BoxesSpiceDisplay* self, SpiceSession* session, SpiceChannel* channel);
static void _boxes_spice_display_on_channel_new_spice_session_channel_new (SpiceSession* _sender, SpiceChannel* channel, gpointer self);
static void boxes_spice_display_on_channel_destroy (BoxesSpiceDisplay* self, SpiceSession* session, SpiceChannel* channel);
static void _boxes_spice_display_on_channel_destroy_spice_session_channel_destroy (SpiceSession* _sender, SpiceChannel* channel, gpointer self);
const gchar* boxes_display_get_password (BoxesDisplay* self);
static void boxes_spice_display_real_disconnect_it (BoxesDisplay* base);
BoxesSpiceChannelHandler* boxes_spice_channel_handler_new (BoxesSpiceDisplay* display, SpiceChannel* channel, BoxesDisplayOpenFDFunc open_fd, void* open_fd_target, GDestroyNotify open_fd_target_destroy_notify);
BoxesSpiceChannelHandler* boxes_spice_channel_handler_construct (GType object_type, BoxesSpiceDisplay* display, SpiceChannel* channel, BoxesDisplayOpenFDFunc open_fd, void* open_fd_target, GDestroyNotify open_fd_target_destroy_notify);
void boxes_display_access_start (BoxesDisplay* self);
void boxes_display_access_finish (BoxesDisplay* self);
static void boxes_spice_display_main_event (BoxesSpiceDisplay* self, SpiceChannelEvent event);
void boxes_display_set_need_password (BoxesDisplay* self, gboolean value);
static GList* boxes_spice_display_real_get_properties (BoxesDisplay* base, BoxesPropertiesPage page);
BoxesProperty* boxes_iproperties_provider_add_property (BoxesIPropertiesProvider* self, GList** list, const gchar* name, GtkWidget* widget, GtkWidget* extra_widget);
static Block78Data* block78_data_ref (Block78Data* _data78_);
static void block78_data_unref (void * _userdata_);
static Block79Data* block79_data_ref (Block79Data* _data79_);
static void block79_data_unref (void * _userdata_);
static gint ___lambda1__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gint ____lambda72_ (SpiceUsbDevice* a, SpiceUsbDevice* b);
static gint _____lambda72__gcompare_func (gconstpointer a, gconstpointer b);
static Block80Data* block80_data_ref (Block80Data* _data80_);
static void block80_data_unref (void * _userdata_);
static void _______lambda73_ (Block80Data* _data80_);
static void ___lambda74_ (Block80Data* _data80_, GObject* obj, GAsyncResult* res);
static void ____lambda74__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ________lambda73__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ____lambda75_ (Block78Data* _data78_, SpiceUsbDeviceManager* manager, SpiceUsbDevice* dev);
static void _____lambda75__spice_usb_device_manager_device_added (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, gpointer self);
static void ____lambda76_ (Block78Data* _data78_, SpiceUsbDeviceManager* manager, SpiceUsbDevice* dev);
static void _____lambda76__spice_usb_device_manager_device_removed (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, gpointer self);
static void _g_list_free__g_object_unref0_ (GList* self);
static void boxes_spice_display_real_send_keys (BoxesDisplay* base, guint* keyvals, int keyvals_length1);
static void __vala_SpiceUsbDevice_free0_ (gpointer var);
static gboolean boxes_spice_display_is_usb_kbd_or_mouse (BoxesSpiceDisplay* self, guint8 class, guint8 subclass, guint8 protocol);
GByteArray* boxes_spice_display_get_ca_cert (BoxesSpiceDisplay* self);
void boxes_spice_display_set_ca_cert (BoxesSpiceDisplay* self, GByteArray* value);
static void _boxes_spice_display_main_event_spice_channel_channel_event (SpiceChannel* _sender, SpiceChannelEvent event, gpointer self);
static void _boxes_spice_display_main_channel___lambda69_ (BoxesSpiceDisplay* self);
void boxes_display_set_can_grab_mouse (BoxesDisplay* self, gboolean value);
static void __boxes_spice_display_main_channel___lambda69__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static GObject * boxes_spice_display_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _boxes_spice_display____lambda77_ (BoxesSpiceDisplay* self, SpiceUsbDevice* dev, GError* err);
static void __boxes_spice_display____lambda77__spice_usb_device_manager_device_error (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, GError* _error_, gpointer self);
static void boxes_spice_display_finalize (GObject* obj);
const gchar* boxes_display_get_protocol (BoxesDisplay* self);
static void _vala_boxes_spice_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_boxes_spice_display_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define BOXES_SPICE_CHANNEL_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_SPICE_CHANNEL_HANDLER, BoxesSpiceChannelHandlerPrivate))
enum  {
	BOXES_SPICE_CHANNEL_HANDLER_DUMMY_PROPERTY
};
static void boxes_spice_channel_handler_on_open_fd (BoxesSpiceChannelHandler* self, SpiceChannel* channel, gint with_tls);
static void _boxes_spice_channel_handler_on_open_fd_spice_channel_open_fd (SpiceChannel* _sender, gint with_tls, gpointer self);
static void boxes_spice_channel_handler_on_display_ready (BoxesSpiceChannelHandler* self, GObject* object, GParamSpec* param_spec);
static void _boxes_spice_channel_handler_on_display_ready_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void boxes_spice_channel_handler_finalize (GObject* obj);
void spice_validate_uri (const gchar* uri_as_text, gint** port, gint** tls_port, GError** error);
static gint* _int_dup (gint* self);


static void _vala_BoxesBoxConfigSavedProperty_array_free (BoxesBoxConfigSavedProperty* array, gint array_length) {
#line 25 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (array != NULL) {
#line 365 "spice-display.c"
		int i;
#line 25 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 25 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			boxes_box_config_saved_property_destroy (&array[i]);
#line 371 "spice-display.c"
		}
	}
#line 25 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_free (array);
#line 376 "spice-display.c"
}


static void boxes_spice_display_ui_state_changed (BoxesSpiceDisplay* self) {
	BoxesMachine* _tmp0_ = NULL;
	BoxesUIState _tmp1_ = 0;
	BoxesUIState _tmp2_ = 0;
#line 32 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 34 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->machine;
#line 34 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = boxes_ui_get_ui_state ((BoxesUI*) _tmp0_);
#line 34 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 34 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp2_ == BOXES_UI_STATE_DISPLAY) {
#line 394 "spice-display.c"
		SpiceDisplay* display = NULL;
		GtkWidget* _tmp3_ = NULL;
		SpiceDisplay* _tmp4_ = NULL;
		SpiceDisplay* _tmp5_ = NULL;
#line 36 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp3_ = boxes_display_get_display ((BoxesDisplay*) self, 0);
#line 36 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp3_) : NULL;
#line 36 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		if (_tmp4_ == NULL) {
#line 36 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (_tmp3_);
#line 407 "spice-display.c"
		}
#line 36 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		display = _tmp4_;
#line 37 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp5_ = display;
#line 37 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp5_, "resize-guest", TRUE, NULL);
#line 34 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (display);
#line 417 "spice-display.c"
	}
}


static gchar* boxes_spice_display_get_box_name (BoxesSpiceDisplay* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	BoxesBoxConfig* _tmp1_ = NULL;
	BoxesBoxConfig* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp7_ = NULL;
#line 41 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 43 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = boxes_display_get_config ((BoxesDisplay*) self);
#line 43 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 43 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = boxes_box_config_get_last_seen_name (_tmp2_);
#line 43 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp4_ = _tmp3_;
#line 43 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = _tmp4_;
#line 43 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp0_ == NULL) {
#line 444 "spice-display.c"
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 43 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp5_ = _ ("Unknown");
#line 43 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 43 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp0_);
#line 43 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp0_ = _tmp6_;
#line 455 "spice-display.c"
	}
#line 43 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp7_ = _tmp0_;
#line 43 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = NULL;
#line 43 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	result = _tmp7_;
#line 43 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_free0 (_tmp0_);
#line 43 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return result;
#line 467 "spice-display.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 94 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return self ? g_object_ref (self) : NULL;
#line 474 "spice-display.c"
}


static void boxes_spice_display_main_cleanup (BoxesSpiceDisplay* self) {
	SpiceMainChannel* _tmp0_ = NULL;
	SpiceMainChannel* _tmp1_ = NULL;
	GObject* o = NULL;
	SpiceMainChannel* _tmp2_ = NULL;
	SpiceMainChannel* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	gulong _tmp6_ = 0UL;
	GObject* _tmp7_ = NULL;
	gulong _tmp8_ = 0UL;
#line 90 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 91 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = boxes_spice_display_get_main_channel (self);
#line 91 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = _tmp0_;
#line 91 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp1_ == NULL) {
#line 92 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		return;
#line 499 "spice-display.c"
	}
#line 94 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = boxes_spice_display_get_main_channel (self);
#line 94 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = _tmp2_;
#line 94 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, G_TYPE_OBJECT) ? ((GObject*) _tmp3_) : NULL);
#line 94 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	o = _tmp4_;
#line 95 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp5_ = o;
#line 95 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp6_ = self->priv->main_event_id;
#line 95 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_signal_handler_disconnect (_tmp5_, _tmp6_);
#line 96 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->main_event_id = (gulong) 0;
#line 97 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp7_ = o;
#line 97 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp8_ = self->priv->main_mouse_mode_id;
#line 97 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_signal_handler_disconnect (_tmp7_, _tmp8_);
#line 98 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->main_mouse_mode_id = (gulong) 0;
#line 99 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_set_main_channel (self, NULL);
#line 90 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (o);
#line 529 "spice-display.c"
}


static void _boxes_spice_display_ui_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 109 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_ui_state_changed ((BoxesSpiceDisplay*) self);
#line 536 "spice-display.c"
}


BoxesSpiceDisplay* boxes_spice_display_construct (GType object_type, BoxesMachine* machine, BoxesBoxConfig* config, const gchar* host, gint port, gint tls_port, const gchar* host_subject) {
	BoxesSpiceDisplay * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	BoxesMachine* _tmp2_ = NULL;
	BoxesMachine* _tmp3_ = NULL;
	BoxesBoxConfig* _tmp4_ = NULL;
	SpiceSession* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp12_ = 0;
	const gchar* _tmp17_ = NULL;
	BoxesBoxConfig* _tmp22_ = NULL;
	SpiceGtkSession* _tmp23_ = NULL;
	BoxesBoxConfigSavedProperty* _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
#line 106 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (machine != NULL, NULL);
#line 106 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (config != NULL, NULL);
#line 106 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (host != NULL, NULL);
#line 106 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = port;
#line 106 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = tls_port;
#line 106 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_vala_return_val_if_fail ((_tmp0_ != 0) || (_tmp1_ != 0), "port != 0 || tls_port != 0", NULL);
#line 106 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) boxes_display_construct (object_type);
#line 108 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = machine;
#line 108 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->machine = _tmp2_;
#line 109 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = machine;
#line 109 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_signal_connect_object ((GObject*) _tmp3_, "notify::ui-state", (GCallback) _boxes_spice_display_ui_state_changed_g_object_notify, self, 0);
#line 111 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp4_ = config;
#line 111 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_display_set_config ((BoxesDisplay*) self, _tmp4_);
#line 113 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp5_ = self->priv->session;
#line 113 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp6_ = host;
#line 113 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_set (_tmp5_, "host", _tmp6_, NULL);
#line 114 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp7_ = port;
#line 114 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp7_ != 0) {
#line 592 "spice-display.c"
		SpiceSession* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 115 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp8_ = self->priv->session;
#line 115 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp9_ = port;
#line 115 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp10_ = g_strdup_printf ("%i", _tmp9_);
#line 115 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp11_ = _tmp10_;
#line 115 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp8_, "port", _tmp11_, NULL);
#line 115 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp11_);
#line 609 "spice-display.c"
	}
#line 117 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp12_ = tls_port;
#line 117 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp12_ != 0) {
#line 615 "spice-display.c"
		SpiceSession* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
#line 118 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp13_ = self->priv->session;
#line 118 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp14_ = tls_port;
#line 118 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp15_ = g_strdup_printf ("%i", _tmp14_);
#line 118 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp16_ = _tmp15_;
#line 118 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp13_, "tls-port", _tmp16_, NULL);
#line 118 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp16_);
#line 632 "spice-display.c"
	}
#line 124 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp17_ = host_subject;
#line 124 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp17_ != NULL) {
#line 638 "spice-display.c"
		SpiceSession* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 125 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp18_ = self->priv->session;
#line 125 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp19_ = host_subject;
#line 125 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp18_, "cert-subject", _tmp19_, NULL);
#line 647 "spice-display.c"
	} else {
		SpiceSession* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
#line 127 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp20_ = self->priv->session;
#line 127 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp21_ = g_getenv ("BOXES_SPICE_HOST_SUBJECT");
#line 127 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp20_, "cert-subject", _tmp21_, NULL);
#line 657 "spice-display.c"
	}
#line 129 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp22_ = config;
#line 129 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp23_ = self->priv->gtk_session;
#line 129 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp24_ = self->priv->gtk_session_saved_properties;
#line 129 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp24__length1 = self->priv->gtk_session_saved_properties_length1;
#line 129 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_box_config_save_properties (_tmp22_, (GObject*) _tmp23_, _tmp24_, _tmp24__length1);
#line 106 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return self;
#line 671 "spice-display.c"
}


BoxesSpiceDisplay* boxes_spice_display_new (BoxesMachine* machine, BoxesBoxConfig* config, const gchar* host, gint port, gint tls_port, const gchar* host_subject) {
#line 106 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return boxes_spice_display_construct (BOXES_TYPE_SPICE_DISPLAY, machine, config, host, port, tls_port, host_subject);
#line 678 "spice-display.c"
}


BoxesSpiceDisplay* boxes_spice_display_construct_with_uri (GType object_type, BoxesMachine* machine, BoxesBoxConfig* config, const gchar* uri) {
	BoxesSpiceDisplay * self = NULL;
	BoxesMachine* _tmp0_ = NULL;
	BoxesMachine* _tmp1_ = NULL;
	BoxesBoxConfig* _tmp2_ = NULL;
	SpiceSession* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	BoxesBoxConfig* _tmp5_ = NULL;
	SpiceGtkSession* _tmp6_ = NULL;
	BoxesBoxConfigSavedProperty* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 132 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (machine != NULL, NULL);
#line 132 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (config != NULL, NULL);
#line 132 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 132 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) boxes_display_construct (object_type);
#line 133 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = machine;
#line 133 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->machine = _tmp0_;
#line 134 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = machine;
#line 134 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_signal_connect_object ((GObject*) _tmp1_, "notify::ui-state", (GCallback) _boxes_spice_display_ui_state_changed_g_object_notify, self, 0);
#line 136 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = config;
#line 136 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_display_set_config ((BoxesDisplay*) self, _tmp2_);
#line 138 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = self->priv->session;
#line 138 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp4_ = uri;
#line 138 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_set (_tmp3_, "uri", _tmp4_, NULL);
#line 140 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp5_ = config;
#line 140 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp6_ = self->priv->gtk_session;
#line 140 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp7_ = self->priv->gtk_session_saved_properties;
#line 140 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp7__length1 = self->priv->gtk_session_saved_properties_length1;
#line 140 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_box_config_save_properties (_tmp5_, (GObject*) _tmp6_, _tmp7_, _tmp7__length1);
#line 132 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return self;
#line 731 "spice-display.c"
}


BoxesSpiceDisplay* boxes_spice_display_new_with_uri (BoxesMachine* machine, BoxesBoxConfig* config, const gchar* uri) {
#line 132 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return boxes_spice_display_construct_with_uri (BOXES_TYPE_SPICE_DISPLAY, machine, config, uri);
#line 738 "spice-display.c"
}


BoxesSpiceDisplay* boxes_spice_display_construct_priv (GType object_type, BoxesMachine* machine, BoxesBoxConfig* config) {
	BoxesSpiceDisplay * self = NULL;
	BoxesMachine* _tmp0_ = NULL;
	BoxesMachine* _tmp1_ = NULL;
	BoxesBoxConfig* _tmp2_ = NULL;
	BoxesBoxConfig* _tmp3_ = NULL;
	SpiceGtkSession* _tmp4_ = NULL;
	BoxesBoxConfigSavedProperty* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
#line 143 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (machine != NULL, NULL);
#line 143 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (config != NULL, NULL);
#line 143 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) boxes_display_construct (object_type);
#line 144 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = machine;
#line 144 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->machine = _tmp0_;
#line 145 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = machine;
#line 145 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_signal_connect_object ((GObject*) _tmp1_, "notify::ui-state", (GCallback) _boxes_spice_display_ui_state_changed_g_object_notify, self, 0);
#line 147 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = config;
#line 147 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_display_set_config ((BoxesDisplay*) self, _tmp2_);
#line 149 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = config;
#line 149 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp4_ = self->priv->gtk_session;
#line 149 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp5_ = self->priv->gtk_session_saved_properties;
#line 149 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp5__length1 = self->priv->gtk_session_saved_properties_length1;
#line 149 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_box_config_save_properties (_tmp3_, (GObject*) _tmp4_, _tmp5_, _tmp5__length1);
#line 143 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return self;
#line 781 "spice-display.c"
}


BoxesSpiceDisplay* boxes_spice_display_new_priv (BoxesMachine* machine, BoxesBoxConfig* config) {
#line 143 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return boxes_spice_display_construct_priv (BOXES_TYPE_SPICE_DISPLAY, machine, config);
#line 788 "spice-display.c"
}


static void ___lambda70_ (BoxesSpiceDisplay* self, gint status) {
	gint _tmp0_ = 0;
#line 159 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = status;
#line 159 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_display_set_mouse_grabbed ((BoxesDisplay*) self, _tmp0_ != 0);
#line 798 "spice-display.c"
}


static void ____lambda70__spice_display_mouse_grab (SpiceDisplay* _sender, gint status, gpointer self) {
#line 158 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	___lambda70_ ((BoxesSpiceDisplay*) self, status);
#line 805 "spice-display.c"
}


static void ___lambda71_ (BoxesSpiceDisplay* self, gint status) {
	gint _tmp0_ = 0;
#line 162 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = status;
#line 162 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_display_set_keyboard_grabbed ((BoxesDisplay*) self, _tmp0_ != 0);
#line 815 "spice-display.c"
}


static void ____lambda71__spice_display_keyboard_grab (SpiceDisplay* _sender, gint status, gpointer self) {
#line 161 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	___lambda71_ ((BoxesSpiceDisplay*) self, status);
#line 822 "spice-display.c"
}


static GtkWidget* boxes_spice_display_real_get_display (BoxesDisplay* base, gint n) {
	BoxesSpiceDisplay * self;
	GtkWidget* result = NULL;
	SpiceDisplay* display = NULL;
	GHashTable* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gconstpointer _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	SpiceDisplay* _tmp4_ = NULL;
	SpiceDisplay* _tmp5_ = NULL;
#line 152 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 153 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = ((BoxesDisplay*) self)->displays;
#line 153 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = n;
#line 153 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, (gpointer) ((gintptr) _tmp1_));
#line 153 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = (GtkWidget*) _tmp2_;
#line 153 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp3_) : NULL);
#line 153 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	display = _tmp4_;
#line 155 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp5_ = display;
#line 155 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp5_ == NULL) {
#line 854 "spice-display.c"
		SpiceSession* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		SpiceDisplay* _tmp8_ = NULL;
		SpiceDisplay* _tmp9_ = NULL;
		SpiceDisplay* _tmp10_ = NULL;
		BoxesBoxConfig* _tmp11_ = NULL;
		BoxesBoxConfig* _tmp12_ = NULL;
		BoxesBoxConfigSavedProperty* _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		SpiceDisplay* _tmp14_ = NULL;
		GHashTable* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		SpiceDisplay* _tmp17_ = NULL;
		GtkWidget* _tmp18_ = NULL;
#line 156 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp6_ = self->priv->session;
#line 156 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp7_ = n;
#line 156 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp8_ = spice_display_new (_tmp6_, _tmp7_);
#line 156 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_object_ref_sink (_tmp8_);
#line 156 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (display);
#line 156 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		display = _tmp8_;
#line 158 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp9_ = display;
#line 158 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_signal_connect_object (_tmp9_, "mouse-grab", (GCallback) ____lambda70__spice_display_mouse_grab, self, 0);
#line 161 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp10_ = display;
#line 161 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_signal_connect_object (_tmp10_, "keyboard-grab", (GCallback) ____lambda71__spice_display_keyboard_grab, self, 0);
#line 164 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp11_ = boxes_display_get_config ((BoxesDisplay*) self);
#line 164 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp12_ = _tmp11_;
#line 164 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp13_ = self->priv->display_saved_properties;
#line 164 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp13__length1 = self->priv->display_saved_properties_length1;
#line 164 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		boxes_box_config_save_properties (_tmp12_, (GObject*) self, _tmp13_, _tmp13__length1);
#line 165 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp14_ = display;
#line 165 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp14_, "scaling", TRUE, NULL);
#line 167 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp15_ = ((BoxesDisplay*) self)->displays;
#line 167 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp16_ = n;
#line 167 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp17_ = display;
#line 167 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp18_ = _g_object_ref0 ((GtkWidget*) _tmp17_);
#line 167 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_hash_table_replace (_tmp15_, (gpointer) ((gintptr) _tmp16_), _tmp18_);
#line 913 "spice-display.c"
	}
#line 170 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	result = (GtkWidget*) display;
#line 170 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return result;
#line 919 "spice-display.c"
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
#line 4858 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 4858 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = self->len;
#line 4858 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = (gint) _tmp0_;
#line 4858 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 934 "spice-display.c"
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
#line 4859 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 4859 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = value;
#line 4859 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_ptr_array_set_size (self, _tmp0_);
#line 946 "spice-display.c"
}


static gboolean boxes_spice_display_real_should_keep_alive (BoxesDisplay* base) {
	BoxesSpiceDisplay * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 173 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 956 "spice-display.c"
	{
		SpiceUsbDeviceManager* manager = NULL;
		SpiceSession* _tmp0_ = NULL;
		SpiceUsbDeviceManager* _tmp1_ = NULL;
		SpiceUsbDeviceManager* _tmp2_ = NULL;
		GPtrArray* devs = NULL;
		GPtrArray* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 175 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp0_ = self->priv->session;
#line 175 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp1_ = spice_usb_device_manager_get (_tmp0_, &_inner_error_);
#line 175 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 175 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		manager = _tmp2_;
#line 175 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 976 "spice-display.c"
			goto __catch74_g_error;
		}
#line 176 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp3_ = boxes_spice_display_get_usb_devices (self, manager);
#line 176 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		devs = _tmp3_;
#line 178 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp5_ = self->priv->closed;
#line 178 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		if (!_tmp5_) {
#line 987 "spice-display.c"
			GPtrArray* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
#line 178 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp6_ = devs;
#line 178 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp7_ = g_ptr_array_get_length (_tmp6_);
#line 178 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp8_ = _tmp7_;
#line 178 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp4_ = _tmp8_ > 0;
#line 999 "spice-display.c"
		} else {
#line 178 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp4_ = FALSE;
#line 1003 "spice-display.c"
		}
#line 178 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		result = _tmp4_;
#line 178 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_ptr_array_unref0 (devs);
#line 178 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (manager);
#line 178 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		return result;
#line 1013 "spice-display.c"
	}
	goto __finally74;
	__catch74_g_error:
	{
		GError* _error_ = NULL;
#line 174 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_error_ = _inner_error_;
#line 174 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_inner_error_ = NULL;
#line 180 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		result = FALSE;
#line 180 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_error_free0 (_error_);
#line 180 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		return result;
#line 1029 "spice-display.c"
	}
	__finally74:
#line 174 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 174 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_clear_error (&_inner_error_);
#line 174 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return FALSE;
#line 1038 "spice-display.c"
}


static void boxes_spice_display_real_set_enable_audio (BoxesDisplay* base, gboolean enable) {
	BoxesSpiceDisplay * self;
	SpiceSession* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 184 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 185 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->session;
#line 185 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = enable;
#line 185 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_set (_tmp0_, "enable-audio", _tmp1_, NULL);
#line 1054 "spice-display.c"
}


static GdkPixbuf* boxes_spice_display_real_get_pixbuf (BoxesDisplay* base, gint n, GError** error) {
	BoxesSpiceDisplay * self;
	GdkPixbuf* result = NULL;
	SpiceDisplay* display = NULL;
	gint _tmp0_ = 0;
	GtkWidget* _tmp1_ = NULL;
	SpiceDisplay* _tmp2_ = NULL;
	SpiceDisplay* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	SpiceDisplay* _tmp6_ = NULL;
	GdkPixbuf* _tmp7_ = NULL;
#line 188 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 189 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = n;
#line 189 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = boxes_display_get_display ((BoxesDisplay*) self, _tmp0_);
#line 189 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp1_) : NULL;
#line 189 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp2_ == NULL) {
#line 189 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (_tmp1_);
#line 1082 "spice-display.c"
	}
#line 189 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	display = _tmp2_;
#line 191 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = display;
#line 191 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp3_, "ready", &_tmp4_, NULL);
#line 191 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp5_ = _tmp4_;
#line 191 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (!_tmp5_) {
#line 192 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		result = NULL;
#line 192 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (display);
#line 192 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		return result;
#line 1100 "spice-display.c"
	}
#line 194 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp6_ = display;
#line 194 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp7_ = spice_display_get_pixbuf (_tmp6_);
#line 194 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	result = _tmp7_;
#line 194 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (display);
#line 194 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return result;
#line 1112 "spice-display.c"
}


static SpiceUsbDevice* _vala_SpiceUsbDevice_copy (SpiceUsbDevice* self) {
#line 212 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return g_boxed_copy (spice_usb_device_get_type (), self);
#line 1119 "spice-display.c"
}


static gpointer __vala_SpiceUsbDevice_copy0 (gpointer self) {
#line 212 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return self ? _vala_SpiceUsbDevice_copy (self) : NULL;
#line 1126 "spice-display.c"
}


static void _vala_SpiceUsbDevice_free (SpiceUsbDevice* self) {
#line 211 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_boxed_free (spice_usb_device_get_type (), self);
#line 1133 "spice-display.c"
}


static void boxes_spice_display_real_collect_logs (BoxesDisplay* base, GString* builder) {
	BoxesSpiceDisplay * self;
	GString* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	SpiceGtkSession* _tmp4_ = NULL;
	SpiceMainChannel* _tmp10_ = NULL;
	SpiceMainChannel* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
#line 197 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 197 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (builder != NULL);
#line 198 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = builder;
#line 198 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = boxes_display_get_uri ((BoxesDisplay*) self);
#line 198 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 198 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = _tmp2_;
#line 198 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_string_append_printf (_tmp0_, "URL: %s\n", _tmp3_);
#line 198 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_free0 (_tmp3_);
#line 199 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp4_ = self->priv->gtk_session;
#line 199 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp4_ != NULL) {
#line 1167 "spice-display.c"
		const gchar* _tmp5_ = NULL;
		SpiceGtkSession* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		GString* _tmp9_ = NULL;
#line 200 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp6_ = self->priv->gtk_session;
#line 200 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp6_, "auto-clipboard", &_tmp7_, NULL);
#line 200 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp8_ = _tmp7_;
#line 200 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		if (_tmp8_) {
#line 200 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp5_ = "yes";
#line 1183 "spice-display.c"
		} else {
#line 200 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp5_ = "no";
#line 1187 "spice-display.c"
		}
#line 200 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp9_ = builder;
#line 200 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_string_append_printf (_tmp9_, "Auto clipboard sync: %s\n", _tmp5_);
#line 1193 "spice-display.c"
	}
#line 202 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp10_ = boxes_spice_display_get_main_channel (self);
#line 202 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp11_ = _tmp10_;
#line 202 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp11_ != NULL) {
#line 1201 "spice-display.c"
		GString* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		SpiceMainChannel* _tmp15_ = NULL;
		SpiceMainChannel* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		GString* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		SpiceMainChannel* _tmp21_ = NULL;
		SpiceMainChannel* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		GString* _tmp25_ = NULL;
#line 203 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp12_ = builder;
#line 203 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp13_ = spice_util_get_version_string ();
#line 203 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_string_append_printf (_tmp12_, "Spice-gtk version %s\n", _tmp13_);
#line 204 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp15_ = boxes_spice_display_get_main_channel (self);
#line 204 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp16_ = _tmp15_;
#line 204 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp16_, "mouse-mode", &_tmp17_, NULL);
#line 204 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp18_ = _tmp17_;
#line 204 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		if (_tmp18_ == 1) {
#line 204 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp14_ = "server";
#line 1234 "spice-display.c"
		} else {
#line 204 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp14_ = "client";
#line 1238 "spice-display.c"
		}
#line 204 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp19_ = builder;
#line 204 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_string_append_printf (_tmp19_, "Mouse mode: %s\n", _tmp14_);
#line 205 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp21_ = boxes_spice_display_get_main_channel (self);
#line 205 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp22_ = _tmp21_;
#line 205 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp22_, "agent-connected", &_tmp23_, NULL);
#line 205 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp24_ = _tmp23_;
#line 205 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		if (_tmp24_) {
#line 205 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp20_ = "connected";
#line 1256 "spice-display.c"
		} else {
#line 205 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp20_ = "disconnected";
#line 1260 "spice-display.c"
		}
#line 205 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp25_ = builder;
#line 205 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_string_append_printf (_tmp25_, "Agent: %s\n", _tmp20_);
#line 1266 "spice-display.c"
	}
	{
		SpiceUsbDeviceManager* manager = NULL;
		SpiceSession* _tmp26_ = NULL;
		SpiceUsbDeviceManager* _tmp27_ = NULL;
		SpiceUsbDeviceManager* _tmp28_ = NULL;
		GPtrArray* devs = NULL;
		SpiceUsbDeviceManager* _tmp29_ = NULL;
		GPtrArray* _tmp30_ = NULL;
#line 209 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp26_ = self->priv->session;
#line 209 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp27_ = spice_usb_device_manager_get (_tmp26_, &_inner_error_);
#line 209 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp28_ = _g_object_ref0 (_tmp27_);
#line 209 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		manager = _tmp28_;
#line 209 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1286 "spice-display.c"
			goto __catch75_g_error;
		}
#line 210 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp29_ = manager;
#line 210 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp30_ = spice_usb_device_manager_get_devices (_tmp29_);
#line 210 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		devs = _tmp30_;
#line 1295 "spice-display.c"
		{
			gint i = 0;
#line 211 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			i = 0;
#line 1300 "spice-display.c"
			{
				gboolean _tmp31_ = FALSE;
#line 211 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp31_ = TRUE;
#line 211 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				while (TRUE) {
#line 1307 "spice-display.c"
					gint _tmp33_ = 0;
					GPtrArray* _tmp34_ = NULL;
					gint _tmp35_ = 0;
					gint _tmp36_ = 0;
					SpiceUsbDevice* dev = NULL;
					GPtrArray* _tmp37_ = NULL;
					gint _tmp38_ = 0;
					gconstpointer _tmp39_ = NULL;
					SpiceUsbDevice* _tmp40_ = NULL;
					SpiceUsbDeviceManager* _tmp41_ = NULL;
					SpiceUsbDevice* _tmp42_ = NULL;
					gboolean _tmp43_ = FALSE;
#line 211 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					if (!_tmp31_) {
#line 1322 "spice-display.c"
						gint _tmp32_ = 0;
#line 211 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_tmp32_ = i;
#line 211 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						i = _tmp32_ + 1;
#line 1328 "spice-display.c"
					}
#line 211 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp31_ = FALSE;
#line 211 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp33_ = i;
#line 211 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp34_ = devs;
#line 211 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp35_ = g_ptr_array_get_length (_tmp34_);
#line 211 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp36_ = _tmp35_;
#line 211 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					if (!(_tmp33_ < _tmp36_)) {
#line 211 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						break;
#line 1344 "spice-display.c"
					}
#line 212 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp37_ = devs;
#line 212 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp38_ = i;
#line 212 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp39_ = g_ptr_array_index (_tmp37_, (guint) _tmp38_);
#line 212 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp40_ = __vala_SpiceUsbDevice_copy0 ((SpiceUsbDevice*) _tmp39_);
#line 212 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					dev = _tmp40_;
#line 213 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp41_ = manager;
#line 213 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp42_ = dev;
#line 213 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp43_ = spice_usb_device_manager_is_device_connected (_tmp41_, _tmp42_);
#line 213 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					if (_tmp43_) {
#line 1364 "spice-display.c"
						GString* _tmp44_ = NULL;
						SpiceUsbDevice* _tmp45_ = NULL;
						gchar* _tmp46_ = NULL;
						gchar* _tmp47_ = NULL;
#line 214 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_tmp44_ = builder;
#line 214 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_tmp45_ = dev;
#line 214 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_tmp46_ = spice_usb_device_get_description (_tmp45_, "%s %s %s at %d-%d");
#line 214 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_tmp47_ = _tmp46_;
#line 214 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						g_string_append_printf (_tmp44_, "USB device redirected: %s\n", _tmp47_);
#line 214 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_g_free0 (_tmp47_);
#line 1381 "spice-display.c"
					}
#line 211 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					__vala_SpiceUsbDevice_free0 (dev);
#line 1385 "spice-display.c"
				}
			}
		}
#line 208 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_ptr_array_unref0 (devs);
#line 208 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (manager);
#line 1393 "spice-display.c"
	}
	goto __finally75;
	__catch75_g_error:
	{
		GError* _error_ = NULL;
#line 208 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_error_ = _inner_error_;
#line 208 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_inner_error_ = NULL;
#line 208 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_error_free0 (_error_);
#line 1405 "spice-display.c"
	}
	__finally75:
#line 208 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 208 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 208 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_clear_error (&_inner_error_);
#line 208 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		return;
#line 1416 "spice-display.c"
	}
}


static void _g_object_unref0_ (gpointer var) {
#line 228 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1424 "spice-display.c"
}


static void _boxes_spice_display_on_channel_new_spice_session_channel_new (SpiceSession* _sender, SpiceChannel* channel, gpointer self) {
#line 232 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_on_channel_new ((BoxesSpiceDisplay*) self, _sender, channel);
#line 1431 "spice-display.c"
}


static void _boxes_spice_display_on_channel_destroy_spice_session_channel_destroy (SpiceSession* _sender, SpiceChannel* channel, gpointer self) {
#line 234 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_on_channel_destroy ((BoxesSpiceDisplay*) self, _sender, channel);
#line 1438 "spice-display.c"
}


static void boxes_spice_display_real_connect_it (BoxesDisplay* base, BoxesDisplayOpenFDFunc open_fd, void* open_fd_target, GDestroyNotify open_fd_target_destroy_notify, GError** error) {
	BoxesSpiceDisplay * self;
	gboolean _tmp0_ = FALSE;
	BoxesDisplayOpenFDFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	GDestroyNotify _tmp1__target_destroy_notify = NULL;
	GHashFunc _tmp2_ = NULL;
	GEqualFunc _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	gulong _tmp5_ = 0UL;
	gulong _tmp8_ = 0UL;
	SpiceSession* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	BoxesDisplayOpenFDFunc _tmp14_ = NULL;
	void* _tmp14__target = NULL;
#line 220 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 222 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = ((BoxesDisplay*) self)->connected;
#line 222 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp0_) {
#line 223 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		(open_fd_target_destroy_notify == NULL) ? NULL : (open_fd_target_destroy_notify (open_fd_target), NULL);
#line 223 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		open_fd = NULL;
#line 223 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		open_fd_target = NULL;
#line 223 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		open_fd_target_destroy_notify = NULL;
#line 223 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		return;
#line 1474 "spice-display.c"
	}
#line 224 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	((BoxesDisplay*) self)->connected = TRUE;
#line 225 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = open_fd;
#line 225 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1__target = open_fd_target;
#line 225 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1__target_destroy_notify = open_fd_target_destroy_notify;
#line 225 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	open_fd_target_destroy_notify = NULL;
#line 225 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	(self->priv->open_fd_target_destroy_notify == NULL) ? NULL : (self->priv->open_fd_target_destroy_notify (self->priv->open_fd_target), NULL);
#line 225 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd = NULL;
#line 225 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target = NULL;
#line 225 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = NULL;
#line 225 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd = _tmp1_;
#line 225 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target = _tmp1__target;
#line 225 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = _tmp1__target_destroy_notify;
#line 227 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_main_cleanup (self);
#line 228 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = g_direct_hash;
#line 228 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = g_direct_equal;
#line 228 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_object_unref0_, _g_object_unref0_);
#line 228 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_hash_table_unref0 (self->priv->channel_handlers);
#line 228 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->channel_handlers = _tmp4_;
#line 231 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp5_ = self->priv->channel_new_id;
#line 231 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp5_ == ((gulong) 0)) {
#line 1516 "spice-display.c"
		SpiceSession* _tmp6_ = NULL;
		gulong _tmp7_ = 0UL;
#line 232 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp6_ = self->priv->session;
#line 232 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp7_ = g_signal_connect_object (_tmp6_, "channel-new", (GCallback) _boxes_spice_display_on_channel_new_spice_session_channel_new, self, 0);
#line 232 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		self->priv->channel_new_id = _tmp7_;
#line 1525 "spice-display.c"
	}
#line 233 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp8_ = self->priv->channel_destroy_id;
#line 233 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp8_ == ((gulong) 0)) {
#line 1531 "spice-display.c"
		SpiceSession* _tmp9_ = NULL;
		gulong _tmp10_ = 0UL;
#line 234 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp9_ = self->priv->session;
#line 234 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp10_ = g_signal_connect_object (_tmp9_, "channel-destroy", (GCallback) _boxes_spice_display_on_channel_destroy_spice_session_channel_destroy, self, 0);
#line 234 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		self->priv->channel_destroy_id = _tmp10_;
#line 1540 "spice-display.c"
	}
#line 236 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp11_ = self->priv->session;
#line 236 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp12_ = boxes_display_get_password ((BoxesDisplay*) self);
#line 236 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp13_ = _tmp12_;
#line 236 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_set (_tmp11_, "password", _tmp13_, NULL);
#line 237 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp14_ = open_fd;
#line 237 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp14__target = open_fd_target;
#line 237 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp14_ != NULL) {
#line 1556 "spice-display.c"
		SpiceSession* _tmp15_ = NULL;
#line 238 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp15_ = self->priv->session;
#line 238 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		spice_session_open_fd (_tmp15_, -1);
#line 1562 "spice-display.c"
	} else {
		SpiceSession* _tmp16_ = NULL;
#line 240 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp16_ = self->priv->session;
#line 240 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		spice_session_connect (_tmp16_);
#line 1569 "spice-display.c"
	}
#line 220 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	(open_fd_target_destroy_notify == NULL) ? NULL : (open_fd_target_destroy_notify (open_fd_target), NULL);
#line 220 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	open_fd = NULL;
#line 220 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	open_fd_target = NULL;
#line 220 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	open_fd_target_destroy_notify = NULL;
#line 1579 "spice-display.c"
}


static void boxes_spice_display_real_disconnect_it (BoxesDisplay* base) {
	BoxesSpiceDisplay * self;
	gulong _tmp0_ = 0UL;
	gulong _tmp3_ = 0UL;
	SpiceSession* _tmp6_ = NULL;
	GHashTable* _tmp7_ = NULL;
#line 243 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 244 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->channel_new_id;
#line 244 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp0_ > ((gulong) 0)) {
#line 1595 "spice-display.c"
		SpiceSession* _tmp1_ = NULL;
		gulong _tmp2_ = 0UL;
#line 245 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp1_ = self->priv->session;
#line 245 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp2_ = self->priv->channel_new_id;
#line 245 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, G_TYPE_OBJECT) ? ((GObject*) _tmp1_) : NULL, _tmp2_);
#line 246 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		self->priv->channel_new_id = (gulong) 0;
#line 1606 "spice-display.c"
	}
#line 248 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = self->priv->channel_destroy_id;
#line 248 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp3_ > ((gulong) 0)) {
#line 1612 "spice-display.c"
		SpiceSession* _tmp4_ = NULL;
		gulong _tmp5_ = 0UL;
#line 249 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp4_ = self->priv->session;
#line 249 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp5_ = self->priv->channel_destroy_id;
#line 249 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, G_TYPE_OBJECT) ? ((GObject*) _tmp4_) : NULL, _tmp5_);
#line 250 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		self->priv->channel_destroy_id = (gulong) 0;
#line 1623 "spice-display.c"
	}
#line 252 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp6_ = self->priv->session;
#line 252 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	spice_session_disconnect (_tmp6_);
#line 253 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_main_cleanup (self);
#line 254 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_hash_table_unref0 (self->priv->channel_handlers);
#line 254 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->channel_handlers = NULL;
#line 255 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	(self->priv->open_fd_target_destroy_notify == NULL) ? NULL : (self->priv->open_fd_target_destroy_notify (self->priv->open_fd_target), NULL);
#line 255 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd = NULL;
#line 255 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target = NULL;
#line 255 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = NULL;
#line 255 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd = NULL;
#line 255 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target = NULL;
#line 255 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = NULL;
#line 256 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp7_ = ((BoxesDisplay*) self)->displays;
#line 256 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_hash_table_remove_all (_tmp7_);
#line 1653 "spice-display.c"
}


static void boxes_spice_display_on_channel_new (BoxesSpiceDisplay* self, SpiceSession* session, SpiceChannel* channel) {
	BoxesSpiceChannelHandler* handler = NULL;
	SpiceChannel* _tmp0_ = NULL;
	BoxesDisplayOpenFDFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	GDestroyNotify _tmp1__target_destroy_notify = NULL;
	BoxesSpiceChannelHandler* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	SpiceChannel* _tmp4_ = NULL;
	SpiceChannel* _tmp5_ = NULL;
	BoxesSpiceChannelHandler* _tmp6_ = NULL;
	BoxesSpiceChannelHandler* _tmp7_ = NULL;
	SpiceChannel* _tmp8_ = NULL;
#line 259 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 259 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (session != NULL);
#line 259 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (channel != NULL);
#line 260 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = channel;
#line 260 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = self->priv->open_fd;
#line 260 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1__target = self->priv->open_fd_target;
#line 260 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1__target_destroy_notify = self->priv->open_fd_target_destroy_notify;
#line 260 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = NULL;
#line 260 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = boxes_spice_channel_handler_new (self, _tmp0_, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify);
#line 260 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	handler = _tmp2_;
#line 261 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = self->priv->channel_handlers;
#line 261 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp4_ = channel;
#line 261 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 261 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp6_ = handler;
#line 261 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 261 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_hash_table_insert (_tmp3_, _tmp5_, _tmp7_);
#line 263 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp8_ = channel;
#line 263 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, spice_display_channel_get_type ())) {
#line 1706 "spice-display.c"
		SpiceChannel* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 264 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp9_ = channel;
#line 264 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp9_, "channel-id", &_tmp10_, NULL);
#line 264 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp11_ = _tmp10_;
#line 264 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		if (_tmp11_ != 0) {
#line 265 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (handler);
#line 265 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			return;
#line 1722 "spice-display.c"
		}
#line 267 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		boxes_display_access_start ((BoxesDisplay*) self);
#line 1726 "spice-display.c"
	}
#line 259 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (handler);
#line 1730 "spice-display.c"
}


static void boxes_spice_display_on_channel_destroy (BoxesSpiceDisplay* self, SpiceSession* session, SpiceChannel* channel) {
	SpiceChannel* _tmp0_ = NULL;
	SpiceDisplayChannel* display = NULL;
	SpiceChannel* _tmp1_ = NULL;
	SpiceDisplayChannel* _tmp2_ = NULL;
	SpiceDisplayChannel* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 271 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 271 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (session != NULL);
#line 271 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (channel != NULL);
#line 272 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = channel;
#line 272 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, spice_display_channel_get_type ())) {
#line 273 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		return;
#line 1754 "spice-display.c"
	}
#line 275 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = channel;
#line 275 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, spice_display_channel_get_type ()) ? ((SpiceDisplayChannel*) _tmp1_) : NULL);
#line 275 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	display = _tmp2_;
#line 276 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = display;
#line 276 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_get ((SpiceChannel*) _tmp3_, "channel-id", &_tmp4_, NULL);
#line 276 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp5_ = _tmp4_;
#line 276 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_signal_emit_by_name ((BoxesDisplay*) self, "hide", _tmp5_);
#line 277 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_display_access_finish ((BoxesDisplay*) self);
#line 271 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (display);
#line 1774 "spice-display.c"
}


static void boxes_spice_display_main_event (BoxesSpiceDisplay* self, SpiceChannelEvent event) {
	SpiceChannelEvent _tmp0_ = 0;
#line 280 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 281 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = event;
#line 281 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	switch (_tmp0_) {
#line 281 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_CLOSED:
#line 1788 "spice-display.c"
		{
#line 283 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			self->priv->closed = TRUE;
#line 284 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			g_signal_emit_by_name ((BoxesDisplay*) self, "disconnected", FALSE);
#line 285 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			break;
#line 1796 "spice-display.c"
		}
#line 281 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_ERROR_AUTH:
#line 1800 "spice-display.c"
		{
#line 288 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			boxes_display_set_need_password ((BoxesDisplay*) self, TRUE);
#line 289 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			break;
#line 1806 "spice-display.c"
		}
#line 281 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_ERROR_CONNECT:
#line 281 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_ERROR_TLS:
#line 281 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_ERROR_LINK:
#line 281 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_ERROR_IO:
#line 1816 "spice-display.c"
		{
			SpiceChannelEvent _tmp1_ = 0;
#line 295 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp1_ = event;
#line 295 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			g_debug ("spice-display.vala:295: main SPICE channel error: %d", (gint) _tmp1_);
#line 296 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			self->priv->closed = TRUE;
#line 297 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			g_signal_emit_by_name ((BoxesDisplay*) self, "disconnected", TRUE);
#line 298 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			break;
#line 1829 "spice-display.c"
		}
#line 281 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_OPENED:
#line 1833 "spice-display.c"
		{
#line 301 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			break;
#line 1837 "spice-display.c"
		}
		default:
		{
			SpiceChannelEvent _tmp2_ = 0;
#line 304 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp2_ = event;
#line 304 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			g_debug ("spice-display.vala:304: unhandled main SPICE channel event: %d", (gint) _tmp2_);
#line 305 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			break;
#line 1848 "spice-display.c"
		}
	}
}


static Block78Data* block78_data_ref (Block78Data* _data78_) {
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_atomic_int_inc (&_data78_->_ref_count_);
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return _data78_;
#line 1859 "spice-display.c"
}


static void block78_data_unref (void * _userdata_) {
	Block78Data* _data78_;
	_data78_ = (Block78Data*) _userdata_;
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (g_atomic_int_dec_and_test (&_data78_->_ref_count_)) {
#line 1868 "spice-display.c"
		BoxesSpiceDisplay* self;
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		self = _data78_->self;
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (_data78_->usb_property);
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (_data78_->manager);
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (self);
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_slice_free (Block78Data, _data78_);
#line 1880 "spice-display.c"
	}
}


static Block79Data* block79_data_ref (Block79Data* _data79_) {
#line 4842 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_atomic_int_inc (&_data79_->_ref_count_);
#line 4842 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return _data79_;
#line 1890 "spice-display.c"
}


static void block79_data_unref (void * _userdata_) {
	Block79Data* _data79_;
	_data79_ = (Block79Data*) _userdata_;
#line 4842 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (g_atomic_int_dec_and_test (&_data79_->_ref_count_)) {
#line 1899 "spice-display.c"
		GPtrArray* self;
#line 4842 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		self = _data79_->self;
#line 4842 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_ptr_array_unref0 (self);
#line 4842 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_slice_free (Block79Data, _data79_);
#line 1907 "spice-display.c"
	}
}


static gint __lambda1_ (Block79Data* _data79_, gconstpointer** a, gconstpointer** b) {
	GPtrArray* self;
	gint result = 0;
	GCompareFunc _tmp0_ = NULL;
	gconstpointer** _tmp1_ = NULL;
	gconstpointer** _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 4843 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	self = _data79_->self;
#line 4844 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = _data79_->compare_func;
#line 4844 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = a;
#line 4844 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = b;
#line 4844 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_ ((gconstpointer**) (*_tmp1_), (gconstpointer**) (*_tmp2_));
#line 4844 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp3_;
#line 4844 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 1933 "spice-display.c"
}


static gint ___lambda1__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda1_ (self, a, b);
#line 4843 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 1942 "spice-display.c"
}


static void vala_g_ptr_array_sort (GPtrArray* self, GCompareFunc compare_func) {
	Block79Data* _data79_;
	GCompareFunc _tmp0_ = NULL;
#line 4842 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 4842 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_data79_ = g_slice_new0 (Block79Data);
#line 4842 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_data79_->_ref_count_ = 1;
#line 4842 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_data79_->self = g_ptr_array_ref (self);
#line 4842 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = compare_func;
#line 4842 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_data79_->compare_func = _tmp0_;
#line 4843 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_ptr_array_sort_with_data (self, ___lambda1__gcompare_data_func, _data79_);
#line 4842 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	block79_data_unref (_data79_);
#line 4842 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_data79_ = NULL;
#line 1967 "spice-display.c"
}


static gint ____lambda72_ (SpiceUsbDevice* a, SpiceUsbDevice* b) {
	gint result = 0;
	gchar* str_a = NULL;
	SpiceUsbDevice* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* str_b = NULL;
	SpiceUsbDevice* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GCompareFunc _tmp4_ = NULL;
	gint _tmp5_ = 0;
#line 346 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 346 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 347 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = a;
#line 347 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = spice_usb_device_get_description (_tmp0_, "    %1$s %2$s");
#line 347 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	str_a = _tmp1_;
#line 348 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = b;
#line 348 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = spice_usb_device_get_description (_tmp2_, "    %1$s %2$s");
#line 348 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	str_b = _tmp3_;
#line 350 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp4_ = g_strcmp0;
#line 350 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp5_ = _tmp4_ (str_a, str_b);
#line 350 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	result = _tmp5_;
#line 350 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_free0 (str_b);
#line 350 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_free0 (str_a);
#line 350 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return result;
#line 2009 "spice-display.c"
}


static gint _____lambda72__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = ____lambda72_ ((SpiceUsbDevice*) a, (SpiceUsbDevice*) b);
#line 346 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return result;
#line 2018 "spice-display.c"
}


static Block80Data* block80_data_ref (Block80Data* _data80_) {
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_atomic_int_inc (&_data80_->_ref_count_);
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return _data80_;
#line 2027 "spice-display.c"
}


static void block80_data_unref (void * _userdata_) {
	Block80Data* _data80_;
	_data80_ = (Block80Data*) _userdata_;
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (g_atomic_int_dec_and_test (&_data80_->_ref_count_)) {
#line 2036 "spice-display.c"
		BoxesSpiceDisplay* self;
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		self = _data80_->_data78_->self;
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (_data80_->dev_toggle);
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		__vala_SpiceUsbDevice_free0 (_data80_->dev);
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		block78_data_unref (_data80_->_data78_);
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_data80_->_data78_ = NULL;
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_slice_free (Block80Data, _data80_);
#line 2050 "spice-display.c"
	}
}


static void ___lambda74_ (Block80Data* _data80_, GObject* obj, GAsyncResult* res) {
	Block78Data* _data78_;
	BoxesSpiceDisplay* self;
	GError * _inner_error_ = NULL;
#line 378 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_data78_ = _data80_->_data78_;
#line 378 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = _data78_->self;
#line 378 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (res != NULL);
#line 2065 "spice-display.c"
	{
		SpiceUsbDeviceManager* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
#line 380 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp0_ = _data78_->manager;
#line 380 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp1_ = res;
#line 380 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		spice_usb_device_manager_connect_device_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 380 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2077 "spice-display.c"
			goto __catch77_g_error;
		}
	}
	goto __finally77;
	__catch77_g_error:
	{
		GError* err = NULL;
		GtkSwitch* _tmp2_ = NULL;
		gchar* device_desc = NULL;
		SpiceUsbDevice* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* box_name = NULL;
		gchar* _tmp5_ = NULL;
		gchar* msg = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 379 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		err = _inner_error_;
#line 379 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_inner_error_ = NULL;
#line 382 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp2_ = _data80_->dev_toggle;
#line 382 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		gtk_switch_set_active (_tmp2_, FALSE);
#line 383 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp3_ = _data80_->dev;
#line 383 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp4_ = spice_usb_device_get_description (_tmp3_, "%1$s %2$s");
#line 383 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		device_desc = _tmp4_;
#line 384 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp5_ = boxes_spice_display_get_box_name (self);
#line 384 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		box_name = _tmp5_;
#line 385 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp6_ = _ ("Redirection of USB device '%s' for '%s' failed");
#line 385 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 385 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		msg = _tmp7_;
#line 386 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp8_ = msg;
#line 386 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp9_ = device_desc;
#line 386 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp10_ = box_name;
#line 386 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp11_ = g_strdup_printf (_tmp8_, _tmp9_, _tmp10_);
#line 386 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp12_ = _tmp11_;
#line 386 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_signal_emit_by_name ((BoxesDisplay*) self, "got-error", _tmp12_);
#line 386 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp12_);
#line 387 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp13_ = device_desc;
#line 387 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp14_ = box_name;
#line 387 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp15_ = err;
#line 387 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp16_ = _tmp15_->message;
#line 387 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_debug ("spice-display.vala:387: Error connecting %s to %s: %s", _tmp13_, _tmp14_, _tmp16_);
#line 379 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_free0 (msg);
#line 379 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_free0 (box_name);
#line 379 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_free0 (device_desc);
#line 379 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_error_free0 (err);
#line 2159 "spice-display.c"
	}
	__finally77:
#line 379 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 379 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 379 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_clear_error (&_inner_error_);
#line 379 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		return;
#line 2170 "spice-display.c"
	}
}


static void ____lambda74__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 378 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	___lambda74_ (self, source_object, res);
#line 378 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	block80_data_unref (self);
#line 2180 "spice-display.c"
}


static void _______lambda73_ (Block80Data* _data80_) {
	Block78Data* _data78_;
	BoxesSpiceDisplay* self;
	GtkSwitch* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 376 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_data78_ = _data80_->_data78_;
#line 376 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = _data78_->self;
#line 377 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = _data80_->dev_toggle;
#line 377 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = gtk_switch_get_active (_tmp0_);
#line 377 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 377 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp2_) {
#line 2202 "spice-display.c"
		SpiceUsbDeviceManager* _tmp3_ = NULL;
		SpiceUsbDevice* _tmp4_ = NULL;
#line 378 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp3_ = _data78_->manager;
#line 378 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp4_ = _data80_->dev;
#line 378 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		spice_usb_device_manager_connect_device_async (_tmp3_, _tmp4_, NULL, ____lambda74__gasync_ready_callback, block80_data_ref (_data80_));
#line 2211 "spice-display.c"
	} else {
		SpiceUsbDeviceManager* _tmp5_ = NULL;
		SpiceUsbDevice* _tmp6_ = NULL;
#line 393 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp5_ = _data78_->manager;
#line 393 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp6_ = _data80_->dev;
#line 393 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		spice_usb_device_manager_disconnect_device (_tmp5_, _tmp6_);
#line 2221 "spice-display.c"
	}
}


static void ________lambda73__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 376 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_______lambda73_ (self);
#line 2229 "spice-display.c"
}


static void ____lambda75_ (Block78Data* _data78_, SpiceUsbDeviceManager* manager, SpiceUsbDevice* dev) {
	BoxesSpiceDisplay* self;
	BoxesProperty* _tmp0_ = NULL;
#line 400 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = _data78_->self;
#line 400 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (manager != NULL);
#line 400 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (dev != NULL);
#line 401 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = _data78_->usb_property;
#line 401 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_signal_emit_by_name (_tmp0_, "refresh-properties");
#line 2246 "spice-display.c"
}


static void _____lambda75__spice_usb_device_manager_device_added (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, gpointer self) {
#line 400 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	____lambda75_ (self, _sender, device);
#line 2253 "spice-display.c"
}


static void ____lambda76_ (Block78Data* _data78_, SpiceUsbDeviceManager* manager, SpiceUsbDevice* dev) {
	BoxesSpiceDisplay* self;
	BoxesProperty* _tmp0_ = NULL;
#line 403 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = _data78_->self;
#line 403 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (manager != NULL);
#line 403 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (dev != NULL);
#line 404 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = _data78_->usb_property;
#line 404 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_signal_emit_by_name (_tmp0_, "refresh-properties");
#line 2270 "spice-display.c"
}


static void _____lambda76__spice_usb_device_manager_device_removed (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, gpointer self) {
#line 403 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	____lambda76_ (self, _sender, device);
#line 2277 "spice-display.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_list_free (self);
#line 2286 "spice-display.c"
}


static GList* boxes_spice_display_real_get_properties (BoxesDisplay* base, BoxesPropertiesPage page) {
	BoxesSpiceDisplay * self;
	GList* result = NULL;
	GList* list = NULL;
	BoxesPropertiesPage _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 309 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 310 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	list = NULL;
#line 312 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = page;
#line 312 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	switch (_tmp0_) {
#line 312 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		case BOXES_PROPERTIES_PAGE_GENERAL:
#line 2306 "spice-display.c"
		{
			GtkSwitch* toggle = NULL;
			GtkSwitch* _tmp1_ = NULL;
			SpiceGtkSession* _tmp2_ = NULL;
			GtkSwitch* _tmp3_ = NULL;
			GtkSwitch* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			GtkSwitch* _tmp6_ = NULL;
			BoxesProperty* _tmp7_ = NULL;
			BoxesProperty* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gchar* message = NULL;
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			GtkLabel* label = NULL;
			const gchar* _tmp17_ = NULL;
			GtkLabel* _tmp18_ = NULL;
			GtkLabel* _tmp19_ = NULL;
			GtkLabel* _tmp20_ = NULL;
			GtkLabel* _tmp21_ = NULL;
			GtkLabel* _tmp22_ = NULL;
			GtkLabel* _tmp23_ = NULL;
			GtkLabel* _tmp24_ = NULL;
			GtkStyleContext* _tmp25_ = NULL;
			GtkLabel* _tmp26_ = NULL;
			BoxesProperty* _tmp27_ = NULL;
			BoxesProperty* _tmp28_ = NULL;
#line 314 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp1_ = (GtkSwitch*) gtk_switch_new ();
#line 314 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			g_object_ref_sink (_tmp1_);
#line 314 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			toggle = _tmp1_;
#line 315 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp2_ = self->priv->gtk_session;
#line 315 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp3_ = toggle;
#line 315 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			g_object_bind_property_with_closures ((GObject*) _tmp2_, "auto-clipboard", (GObject*) _tmp3_, "active", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 317 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp4_ = toggle;
#line 317 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
#line 318 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp5_ = _ ("Share Clipboard");
#line 318 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp6_ = toggle;
#line 318 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp7_ = boxes_iproperties_provider_add_property ((BoxesIPropertiesProvider*) self, &list, _tmp5_, (GtkWidget*) _tmp6_, NULL);
#line 318 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp8_ = _tmp7_;
#line 318 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (_tmp8_);
#line 320 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp10_ = ((BoxesDisplay*) self)->connected;
#line 320 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			if (!_tmp10_) {
#line 320 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp9_ = TRUE;
#line 2367 "spice-display.c"
			} else {
				SpiceMainChannel* _tmp11_ = NULL;
				SpiceMainChannel* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
#line 320 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp11_ = boxes_spice_display_get_main_channel (self);
#line 320 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp12_ = _tmp11_;
#line 320 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				g_object_get (_tmp12_, "agent-connected", &_tmp13_, NULL);
#line 320 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp14_ = _tmp13_;
#line 320 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp9_ = _tmp14_;
#line 2383 "spice-display.c"
			}
#line 320 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			if (_tmp9_) {
#line 321 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_g_object_unref0 (toggle);
#line 321 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				break;
#line 2391 "spice-display.c"
			}
#line 323 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp15_ = _ ("SPICE guest tools are not installed. These tools improve user experien" \
"ce and enable host and box interactions, such as copy&amp;paste. Pleas" \
"e visit <a href=\"http://www.spice-space.org/download.html\">http://ww" \
"w.spice-space.org/download.html</a> to download and install these tool" \
"s from within the box.");
#line 323 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp16_ = g_strdup (_tmp15_);
#line 323 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			message = _tmp16_;
#line 324 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp17_ = message;
#line 324 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp18_ = (GtkLabel*) gtk_label_new (_tmp17_);
#line 324 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			g_object_ref_sink (_tmp18_);
#line 324 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			label = _tmp18_;
#line 325 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp19_ = label;
#line 325 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			gtk_widget_set_vexpand ((GtkWidget*) _tmp19_, TRUE);
#line 326 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp20_ = label;
#line 326 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			gtk_widget_set_valign ((GtkWidget*) _tmp20_, GTK_ALIGN_END);
#line 327 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp21_ = label;
#line 327 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			g_object_set (_tmp21_, "wrap", TRUE, NULL);
#line 328 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp22_ = label;
#line 328 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			gtk_label_set_max_width_chars (_tmp22_, 80);
#line 329 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp23_ = label;
#line 329 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			gtk_label_set_use_markup (_tmp23_, TRUE);
#line 330 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp24_ = label;
#line 330 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp25_ = gtk_widget_get_style_context ((GtkWidget*) _tmp24_);
#line 330 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			gtk_style_context_add_class (_tmp25_, "boxes-spice-tools-notice-label");
#line 332 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp26_ = label;
#line 332 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp27_ = boxes_iproperties_provider_add_property ((BoxesIPropertiesProvider*) self, &list, NULL, (GtkWidget*) _tmp26_, NULL);
#line 332 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp28_ = _tmp27_;
#line 332 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (_tmp28_);
#line 333 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (label);
#line 333 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_g_free0 (message);
#line 333 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (toggle);
#line 333 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			break;
#line 2449 "spice-display.c"
		}
#line 312 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		case BOXES_PROPERTIES_PAGE_DEVICES:
#line 2453 "spice-display.c"
		{
			gboolean _tmp29_ = FALSE;
#line 336 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp29_ = ((BoxesDisplay*) self)->connected;
#line 336 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			if (!_tmp29_) {
#line 337 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				break;
#line 2462 "spice-display.c"
			}
			{
				Block78Data* _data78_;
				SpiceSession* _tmp30_ = NULL;
				SpiceUsbDeviceManager* _tmp31_ = NULL;
				SpiceUsbDeviceManager* _tmp32_ = NULL;
				GPtrArray* devs = NULL;
				SpiceUsbDeviceManager* _tmp33_ = NULL;
				GPtrArray* _tmp34_ = NULL;
				GPtrArray* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				GPtrArray* _tmp38_ = NULL;
				GtkFrame* frame = NULL;
				GtkFrame* _tmp39_ = NULL;
				GtkListBox* listbox = NULL;
				GtkListBox* _tmp40_ = NULL;
				GtkListBox* _tmp41_ = NULL;
				GtkFrame* _tmp42_ = NULL;
				GtkListBox* _tmp43_ = NULL;
				const gchar* _tmp78_ = NULL;
				GtkLabel* _tmp79_ = NULL;
				GtkLabel* _tmp80_ = NULL;
				GtkFrame* _tmp81_ = NULL;
				BoxesProperty* _tmp82_ = NULL;
				BoxesProperty* _tmp83_ = NULL;
				SpiceUsbDeviceManager* _tmp84_ = NULL;
				SpiceUsbDeviceManager* _tmp85_ = NULL;
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_data78_ = g_slice_new0 (Block78Data);
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_data78_->_ref_count_ = 1;
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_data78_->self = g_object_ref (self);
#line 340 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp30_ = self->priv->session;
#line 340 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp31_ = spice_usb_device_manager_get (_tmp30_, &_inner_error_);
#line 340 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp32_ = _g_object_ref0 (_tmp31_);
#line 340 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_data78_->manager = _tmp32_;
#line 340 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 340 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					block78_data_unref (_data78_);
#line 340 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_data78_ = NULL;
#line 2511 "spice-display.c"
					goto __catch76_g_error;
				}
#line 341 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp33_ = _data78_->manager;
#line 341 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp34_ = boxes_spice_display_get_usb_devices (self, _tmp33_);
#line 341 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				devs = _tmp34_;
#line 343 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp35_ = devs;
#line 343 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp36_ = g_ptr_array_get_length (_tmp35_);
#line 343 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp37_ = _tmp36_;
#line 343 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				if (_tmp37_ <= 0) {
#line 344 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					result = list;
#line 344 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_g_ptr_array_unref0 (devs);
#line 344 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					block78_data_unref (_data78_);
#line 344 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_data78_ = NULL;
#line 344 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					return result;
#line 2538 "spice-display.c"
				}
#line 346 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp38_ = devs;
#line 346 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				vala_g_ptr_array_sort (_tmp38_, _____lambda72__gcompare_func);
#line 353 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp39_ = (GtkFrame*) gtk_frame_new (NULL);
#line 353 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				g_object_ref_sink (_tmp39_);
#line 353 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				frame = _tmp39_;
#line 354 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp40_ = (GtkListBox*) gtk_list_box_new ();
#line 354 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				g_object_ref_sink (_tmp40_);
#line 354 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				listbox = _tmp40_;
#line 355 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp41_ = listbox;
#line 355 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				gtk_widget_set_hexpand ((GtkWidget*) _tmp41_, TRUE);
#line 356 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp42_ = frame;
#line 356 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp43_ = listbox;
#line 356 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) _tmp43_);
#line 2566 "spice-display.c"
				{
					gint i = 0;
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					i = 0;
#line 2571 "spice-display.c"
					{
						gboolean _tmp44_ = FALSE;
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_tmp44_ = TRUE;
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						while (TRUE) {
#line 2578 "spice-display.c"
							Block80Data* _data80_;
							gint _tmp46_ = 0;
							GPtrArray* _tmp47_ = NULL;
							gint _tmp48_ = 0;
							gint _tmp49_ = 0;
							GPtrArray* _tmp50_ = NULL;
							gint _tmp51_ = 0;
							gconstpointer _tmp52_ = NULL;
							SpiceUsbDevice* _tmp53_ = NULL;
							GtkBox* hbox = NULL;
							GtkBox* _tmp54_ = NULL;
							GtkBox* _tmp55_ = NULL;
							GtkBox* _tmp56_ = NULL;
							GtkBox* _tmp57_ = NULL;
							GtkBox* _tmp58_ = NULL;
							GtkLabel* label = NULL;
							SpiceUsbDevice* _tmp59_ = NULL;
							gchar* _tmp60_ = NULL;
							gchar* _tmp61_ = NULL;
							GtkLabel* _tmp62_ = NULL;
							GtkLabel* _tmp63_ = NULL;
							GtkLabel* _tmp64_ = NULL;
							GtkBox* _tmp65_ = NULL;
							GtkLabel* _tmp66_ = NULL;
							GtkSwitch* _tmp67_ = NULL;
							GtkSwitch* _tmp68_ = NULL;
							GtkBox* _tmp69_ = NULL;
							GtkSwitch* _tmp70_ = NULL;
							GtkListBox* _tmp71_ = NULL;
							GtkBox* _tmp72_ = NULL;
							GtkSwitch* _tmp73_ = NULL;
							SpiceUsbDeviceManager* _tmp74_ = NULL;
							SpiceUsbDevice* _tmp75_ = NULL;
							gboolean _tmp76_ = FALSE;
							GtkSwitch* _tmp77_ = NULL;
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_data80_ = g_slice_new0 (Block80Data);
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_data80_->_ref_count_ = 1;
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_data80_->_data78_ = block78_data_ref (_data78_);
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							if (!_tmp44_) {
#line 2622 "spice-display.c"
								gint _tmp45_ = 0;
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
								_tmp45_ = i;
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
								i = _tmp45_ + 1;
#line 2628 "spice-display.c"
							}
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp44_ = FALSE;
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp46_ = i;
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp47_ = devs;
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp48_ = g_ptr_array_get_length (_tmp47_);
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp49_ = _tmp48_;
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							if (!(_tmp46_ < _tmp49_)) {
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
								block80_data_unref (_data80_);
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
								_data80_ = NULL;
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
								break;
#line 2648 "spice-display.c"
							}
#line 359 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp50_ = devs;
#line 359 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp51_ = i;
#line 359 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp52_ = g_ptr_array_index (_tmp50_, (guint) _tmp51_);
#line 359 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp53_ = __vala_SpiceUsbDevice_copy0 ((SpiceUsbDevice*) _tmp52_);
#line 359 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_data80_->dev = _tmp53_;
#line 361 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp54_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 361 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							g_object_ref_sink (_tmp54_);
#line 361 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							hbox = _tmp54_;
#line 362 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp55_ = hbox;
#line 362 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							gtk_widget_set_margin_start ((GtkWidget*) _tmp55_, 12);
#line 363 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp56_ = hbox;
#line 363 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							gtk_widget_set_margin_end ((GtkWidget*) _tmp56_, 12);
#line 364 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp57_ = hbox;
#line 364 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							gtk_widget_set_margin_top ((GtkWidget*) _tmp57_, 6);
#line 365 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp58_ = hbox;
#line 365 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							gtk_widget_set_margin_bottom ((GtkWidget*) _tmp58_, 6);
#line 366 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp59_ = _data80_->dev;
#line 366 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp60_ = spice_usb_device_get_description (_tmp59_, "%1$s %2$s");
#line 366 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp61_ = _tmp60_;
#line 366 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp62_ = (GtkLabel*) gtk_label_new (_tmp61_);
#line 366 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							g_object_ref_sink (_tmp62_);
#line 366 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp63_ = _tmp62_;
#line 366 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_g_free0 (_tmp61_);
#line 366 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							label = _tmp63_;
#line 367 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp64_ = label;
#line 367 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							gtk_widget_set_halign ((GtkWidget*) _tmp64_, GTK_ALIGN_START);
#line 368 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp65_ = hbox;
#line 368 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp66_ = label;
#line 368 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							gtk_box_pack_start (_tmp65_, (GtkWidget*) _tmp66_, TRUE, TRUE, (guint) 0);
#line 369 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp67_ = (GtkSwitch*) gtk_switch_new ();
#line 369 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							g_object_ref_sink (_tmp67_);
#line 369 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_data80_->dev_toggle = _tmp67_;
#line 370 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp68_ = _data80_->dev_toggle;
#line 370 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							gtk_widget_set_halign ((GtkWidget*) _tmp68_, GTK_ALIGN_END);
#line 371 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp69_ = hbox;
#line 371 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp70_ = _data80_->dev_toggle;
#line 371 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							gtk_box_pack_start (_tmp69_, (GtkWidget*) _tmp70_, TRUE, TRUE, (guint) 0);
#line 372 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp71_ = listbox;
#line 372 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp72_ = hbox;
#line 372 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							gtk_list_box_prepend (_tmp71_, (GtkWidget*) _tmp72_);
#line 374 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp73_ = _data80_->dev_toggle;
#line 374 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp74_ = _data78_->manager;
#line 374 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp75_ = _data80_->dev;
#line 374 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp76_ = spice_usb_device_manager_is_device_connected (_tmp74_, _tmp75_);
#line 374 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							gtk_switch_set_active (_tmp73_, _tmp76_);
#line 376 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp77_ = _data80_->dev_toggle;
#line 376 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							g_signal_connect_data ((GObject*) _tmp77_, "notify::active", (GCallback) ________lambda73__g_object_notify, block80_data_ref (_data80_), (GClosureNotify) block80_data_unref, 0);
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_g_object_unref0 (label);
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_g_object_unref0 (hbox);
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							block80_data_unref (_data80_);
#line 358 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_data80_ = NULL;
#line 2752 "spice-display.c"
						}
					}
				}
#line 398 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp78_ = _ ("USB devices");
#line 398 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp79_ = (GtkLabel*) gtk_label_new ("");
#line 398 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				g_object_ref_sink (_tmp79_);
#line 398 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp80_ = _tmp79_;
#line 398 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp81_ = frame;
#line 398 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp82_ = boxes_iproperties_provider_add_property ((BoxesIPropertiesProvider*) self, &list, _tmp78_, (GtkWidget*) _tmp80_, (GtkWidget*) _tmp81_);
#line 398 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp83_ = _tmp82_;
#line 398 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_g_object_unref0 (_tmp80_);
#line 398 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_data78_->usb_property = _tmp83_;
#line 400 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp84_ = _data78_->manager;
#line 400 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				g_signal_connect_data (_tmp84_, "device-added", (GCallback) _____lambda75__spice_usb_device_manager_device_added, block78_data_ref (_data78_), (GClosureNotify) block78_data_unref, 0);
#line 403 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp85_ = _data78_->manager;
#line 403 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				g_signal_connect_data (_tmp85_, "device-removed", (GCallback) _____lambda76__spice_usb_device_manager_device_removed, block78_data_ref (_data78_), (GClosureNotify) block78_data_unref, 0);
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_g_object_unref0 (listbox);
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_g_object_unref0 (frame);
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_g_ptr_array_unref0 (devs);
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				block78_data_unref (_data78_);
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_data78_ = NULL;
#line 2792 "spice-display.c"
			}
			goto __finally76;
			__catch76_g_error:
			{
				GError* _error_ = NULL;
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_error_ = _inner_error_;
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_inner_error_ = NULL;
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_g_error_free0 (_error_);
#line 2804 "spice-display.c"
			}
			__finally76:
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				__g_list_free__g_object_unref0_0 (list);
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				g_clear_error (&_inner_error_);
#line 339 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				return NULL;
#line 2817 "spice-display.c"
			}
#line 408 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			break;
#line 2821 "spice-display.c"
		}
		default:
#line 312 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		break;
#line 2826 "spice-display.c"
	}
#line 411 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	result = list;
#line 411 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return result;
#line 2832 "spice-display.c"
}


static void boxes_spice_display_real_send_keys (BoxesDisplay* base, guint* keyvals, int keyvals_length1) {
	BoxesSpiceDisplay * self;
	SpiceDisplay* display = NULL;
	GtkWidget* _tmp0_ = NULL;
	SpiceDisplay* _tmp1_ = NULL;
	guint* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 414 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 416 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = boxes_display_get_display ((BoxesDisplay*) self, 0);
#line 416 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp0_) : NULL;
#line 416 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp1_ == NULL) {
#line 416 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (_tmp0_);
#line 2853 "spice-display.c"
	}
#line 416 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	display = _tmp1_;
#line 418 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = keyvals;
#line 418 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2__length1 = keyvals_length1;
#line 418 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	spice_display_send_keys (display, _tmp2_, _tmp2__length1, SPICE_DISPLAY_KEY_EVENT_CLICK);
#line 414 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (display);
#line 2865 "spice-display.c"
}


static void __vala_SpiceUsbDevice_free0_ (gpointer var) {
#line 422 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	(var == NULL) ? NULL : (var = (_vala_SpiceUsbDevice_free (var), NULL));
#line 2872 "spice-display.c"
}


static gpointer _libusb_ref_device0 (gpointer self) {
#line 427 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return self ? libusb_ref_device (self) : NULL;
#line 2879 "spice-display.c"
}


static GPtrArray* boxes_spice_display_get_usb_devices (BoxesSpiceDisplay* self, SpiceUsbDeviceManager* manager) {
	GPtrArray* result = NULL;
	GPtrArray* ret = NULL;
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* devs = NULL;
	SpiceUsbDeviceManager* _tmp1_ = NULL;
	GPtrArray* _tmp2_ = NULL;
#line 421 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 421 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (manager != NULL, NULL);
#line 422 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = g_ptr_array_new_full ((guint) 0, __vala_SpiceUsbDevice_free0_);
#line 422 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	ret = _tmp0_;
#line 423 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = manager;
#line 423 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = spice_usb_device_manager_get_devices (_tmp1_);
#line 423 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	devs = _tmp2_;
#line 2904 "spice-display.c"
	{
		gint i = 0;
#line 425 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		i = 0;
#line 2909 "spice-display.c"
		{
			gboolean _tmp3_ = FALSE;
#line 425 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp3_ = TRUE;
#line 425 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			while (TRUE) {
#line 2916 "spice-display.c"
				gint _tmp5_ = 0;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				SpiceUsbDevice* dev = NULL;
				GPtrArray* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gconstpointer _tmp11_ = NULL;
				SpiceUsbDevice* _tmp12_ = NULL;
				libusb_device* libusb_dev = NULL;
				SpiceUsbDevice* _tmp13_ = NULL;
				void* _tmp14_ = NULL;
				libusb_device* _tmp15_ = NULL;
				struct libusb_device_descriptor desc = {0};
				libusb_device* _tmp16_ = NULL;
				struct libusb_device_descriptor _tmp17_ = {0};
				gint _tmp18_ = 0;
				struct libusb_device_descriptor _tmp19_ = {0};
				guint8 _tmp20_ = 0U;
				struct libusb_device_descriptor _tmp21_ = {0};
				guint8 _tmp22_ = 0U;
				struct libusb_device_descriptor _tmp23_ = {0};
				guint8 _tmp24_ = 0U;
				gboolean _tmp25_ = FALSE;
				struct libusb_device_descriptor _tmp26_ = {0};
				guint8 _tmp27_ = 0U;
				GPtrArray* _tmp77_ = NULL;
				SpiceUsbDevice* _tmp78_ = NULL;
				SpiceUsbDevice* _tmp79_ = NULL;
#line 425 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				if (!_tmp3_) {
#line 2948 "spice-display.c"
					gint _tmp4_ = 0;
#line 425 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp4_ = i;
#line 425 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					i = _tmp4_ + 1;
#line 2954 "spice-display.c"
				}
#line 425 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp3_ = FALSE;
#line 425 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp5_ = i;
#line 425 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp6_ = devs;
#line 425 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp7_ = g_ptr_array_get_length (_tmp6_);
#line 425 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp8_ = _tmp7_;
#line 425 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				if (!(_tmp5_ < _tmp8_)) {
#line 425 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					break;
#line 2970 "spice-display.c"
				}
#line 426 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp9_ = devs;
#line 426 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp10_ = i;
#line 426 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp11_ = g_ptr_array_index (_tmp9_, (guint) _tmp10_);
#line 426 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp12_ = __vala_SpiceUsbDevice_copy0 ((SpiceUsbDevice*) _tmp11_);
#line 426 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				dev = _tmp12_;
#line 427 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp13_ = dev;
#line 427 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp14_ = spice_usb_device_get_libusb_device (_tmp13_);
#line 427 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp15_ = _libusb_ref_device0 ((libusb_device*) _tmp14_);
#line 427 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				libusb_dev = _tmp15_;
#line 431 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp16_ = libusb_dev;
#line 431 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp18_ = libusb_get_device_descriptor (_tmp16_, &_tmp17_);
#line 431 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				desc = _tmp17_;
#line 431 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				if (_tmp18_ != 0) {
#line 432 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_libusb_unref_device0 (libusb_dev);
#line 432 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					__vala_SpiceUsbDevice_free0 (dev);
#line 432 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					continue;
#line 3004 "spice-display.c"
				}
#line 434 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp19_ = desc;
#line 434 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp20_ = _tmp19_.bDeviceClass;
#line 434 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp21_ = desc;
#line 434 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp22_ = _tmp21_.bDeviceSubClass;
#line 434 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp23_ = desc;
#line 434 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp24_ = _tmp23_.bDeviceProtocol;
#line 434 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp25_ = boxes_spice_display_is_usb_kbd_or_mouse (self, _tmp20_, _tmp22_, _tmp24_);
#line 434 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				if (_tmp25_) {
#line 435 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_libusb_unref_device0 (libusb_dev);
#line 435 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					__vala_SpiceUsbDevice_free0 (dev);
#line 435 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					continue;
#line 3028 "spice-display.c"
				}
#line 438 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp26_ = desc;
#line 438 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp27_ = _tmp26_.bDeviceClass;
#line 438 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				if (_tmp27_ == LIBUSB_CLASS_PER_INTERFACE) {
#line 3036 "spice-display.c"
					struct libusb_config_descriptor* config = NULL;
					libusb_device* _tmp28_ = NULL;
					struct libusb_config_descriptor* _tmp29_ = NULL;
					gint _tmp30_ = 0;
					gboolean kbd_or_mouse = FALSE;
					gboolean _tmp76_ = FALSE;
#line 440 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp28_ = libusb_dev;
#line 440 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp30_ = libusb_get_active_config_descriptor (_tmp28_, &_tmp29_);
#line 440 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_libusb_free_config_descriptor0 (config);
#line 440 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					config = _tmp29_;
#line 440 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					if (_tmp30_ != 0) {
#line 441 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_libusb_free_config_descriptor0 (config);
#line 441 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_libusb_unref_device0 (libusb_dev);
#line 441 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						__vala_SpiceUsbDevice_free0 (dev);
#line 441 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						continue;
#line 3061 "spice-display.c"
					}
#line 443 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					kbd_or_mouse = FALSE;
#line 3065 "spice-display.c"
					{
						gint j = 0;
#line 444 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						j = 0;
#line 3070 "spice-display.c"
						{
							gboolean _tmp31_ = FALSE;
#line 444 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							_tmp31_ = TRUE;
#line 444 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
							while (TRUE) {
#line 3077 "spice-display.c"
								gboolean _tmp33_ = FALSE;
								gint _tmp34_ = 0;
								struct libusb_config_descriptor* _tmp35_ = NULL;
								struct libusb_interface* _tmp36_ = NULL;
								gint _tmp36__length1 = 0;
#line 444 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
								if (!_tmp31_) {
#line 3085 "spice-display.c"
									gint _tmp32_ = 0;
#line 444 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
									_tmp32_ = j;
#line 444 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
									j = _tmp32_ + 1;
#line 3091 "spice-display.c"
								}
#line 444 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
								_tmp31_ = FALSE;
#line 444 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
								_tmp34_ = j;
#line 444 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
								_tmp35_ = config;
#line 444 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
								_tmp36_ = _tmp35_->interface;
#line 444 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
								_tmp36__length1 = _tmp35_->bNumInterfaces;
#line 444 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
								if (_tmp34_ < _tmp36__length1) {
#line 3105 "spice-display.c"
									gboolean _tmp37_ = FALSE;
#line 444 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
									_tmp37_ = kbd_or_mouse;
#line 444 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
									_tmp33_ = !_tmp37_;
#line 3111 "spice-display.c"
								} else {
#line 444 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
									_tmp33_ = FALSE;
#line 3115 "spice-display.c"
								}
#line 444 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
								if (!_tmp33_) {
#line 444 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
									break;
#line 3121 "spice-display.c"
								}
								{
									gint k = 0;
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
									k = 0;
#line 3127 "spice-display.c"
									{
										gboolean _tmp38_ = FALSE;
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
										_tmp38_ = TRUE;
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
										while (TRUE) {
#line 3134 "spice-display.c"
											gboolean _tmp40_ = FALSE;
											gint _tmp41_ = 0;
											struct libusb_config_descriptor* _tmp42_ = NULL;
											struct libusb_interface* _tmp43_ = NULL;
											gint _tmp43__length1 = 0;
											gint _tmp44_ = 0;
											struct libusb_interface _tmp45_ = {0};
											struct libusb_interface_descriptor* _tmp46_ = NULL;
											gint _tmp46__length1 = 0;
											guint8 class = 0U;
											struct libusb_config_descriptor* _tmp48_ = NULL;
											struct libusb_interface* _tmp49_ = NULL;
											gint _tmp49__length1 = 0;
											gint _tmp50_ = 0;
											struct libusb_interface _tmp51_ = {0};
											struct libusb_interface_descriptor* _tmp52_ = NULL;
											gint _tmp52__length1 = 0;
											gint _tmp53_ = 0;
											struct libusb_interface_descriptor _tmp54_ = {0};
											guint8 _tmp55_ = 0U;
											guint8 subclass = 0U;
											struct libusb_config_descriptor* _tmp56_ = NULL;
											struct libusb_interface* _tmp57_ = NULL;
											gint _tmp57__length1 = 0;
											gint _tmp58_ = 0;
											struct libusb_interface _tmp59_ = {0};
											struct libusb_interface_descriptor* _tmp60_ = NULL;
											gint _tmp60__length1 = 0;
											gint _tmp61_ = 0;
											struct libusb_interface_descriptor _tmp62_ = {0};
											guint8 _tmp63_ = 0U;
											guint8 protocol = 0U;
											struct libusb_config_descriptor* _tmp64_ = NULL;
											struct libusb_interface* _tmp65_ = NULL;
											gint _tmp65__length1 = 0;
											gint _tmp66_ = 0;
											struct libusb_interface _tmp67_ = {0};
											struct libusb_interface_descriptor* _tmp68_ = NULL;
											gint _tmp68__length1 = 0;
											gint _tmp69_ = 0;
											struct libusb_interface_descriptor _tmp70_ = {0};
											guint8 _tmp71_ = 0U;
											guint8 _tmp72_ = 0U;
											guint8 _tmp73_ = 0U;
											guint8 _tmp74_ = 0U;
											gboolean _tmp75_ = FALSE;
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											if (!_tmp38_) {
#line 3183 "spice-display.c"
												gint _tmp39_ = 0;
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
												_tmp39_ = k;
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
												k = _tmp39_ + 1;
#line 3189 "spice-display.c"
											}
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp38_ = FALSE;
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp41_ = k;
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp42_ = config;
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp43_ = _tmp42_->interface;
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp43__length1 = _tmp42_->bNumInterfaces;
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp44_ = j;
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp45_ = _tmp43_[_tmp44_];
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp46_ = _tmp45_.altsetting;
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp46__length1 = _tmp45_.num_altsetting;
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											if (_tmp41_ < _tmp46__length1) {
#line 3211 "spice-display.c"
												gboolean _tmp47_ = FALSE;
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
												_tmp47_ = kbd_or_mouse;
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
												_tmp40_ = !_tmp47_;
#line 3217 "spice-display.c"
											} else {
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
												_tmp40_ = FALSE;
#line 3221 "spice-display.c"
											}
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											if (!_tmp40_) {
#line 445 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
												break;
#line 3227 "spice-display.c"
											}
#line 446 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp48_ = config;
#line 446 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp49_ = _tmp48_->interface;
#line 446 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp49__length1 = _tmp48_->bNumInterfaces;
#line 446 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp50_ = j;
#line 446 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp51_ = _tmp49_[_tmp50_];
#line 446 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp52_ = _tmp51_.altsetting;
#line 446 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp52__length1 = _tmp51_.num_altsetting;
#line 446 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp53_ = k;
#line 446 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp54_ = _tmp52_[_tmp53_];
#line 446 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp55_ = _tmp54_.bInterfaceClass;
#line 446 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											class = _tmp55_;
#line 447 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp56_ = config;
#line 447 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp57_ = _tmp56_->interface;
#line 447 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp57__length1 = _tmp56_->bNumInterfaces;
#line 447 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp58_ = j;
#line 447 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp59_ = _tmp57_[_tmp58_];
#line 447 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp60_ = _tmp59_.altsetting;
#line 447 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp60__length1 = _tmp59_.num_altsetting;
#line 447 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp61_ = k;
#line 447 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp62_ = _tmp60_[_tmp61_];
#line 447 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp63_ = _tmp62_.bInterfaceSubClass;
#line 447 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											subclass = _tmp63_;
#line 448 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp64_ = config;
#line 448 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp65_ = _tmp64_->interface;
#line 448 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp65__length1 = _tmp64_->bNumInterfaces;
#line 448 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp66_ = j;
#line 448 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp67_ = _tmp65_[_tmp66_];
#line 448 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp68_ = _tmp67_.altsetting;
#line 448 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp68__length1 = _tmp67_.num_altsetting;
#line 448 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp69_ = k;
#line 448 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp70_ = _tmp68_[_tmp69_];
#line 448 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp71_ = _tmp70_.bInterfaceProtocol;
#line 448 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											protocol = _tmp71_;
#line 450 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp72_ = class;
#line 450 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp73_ = subclass;
#line 450 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp74_ = protocol;
#line 450 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											_tmp75_ = boxes_spice_display_is_usb_kbd_or_mouse (self, _tmp72_, _tmp73_, _tmp74_);
#line 450 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
											kbd_or_mouse = _tmp75_;
#line 3305 "spice-display.c"
										}
									}
								}
							}
						}
					}
#line 454 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp76_ = kbd_or_mouse;
#line 454 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					if (_tmp76_) {
#line 455 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_libusb_free_config_descriptor0 (config);
#line 455 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_libusb_unref_device0 (libusb_dev);
#line 455 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						__vala_SpiceUsbDevice_free0 (dev);
#line 455 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						continue;
#line 3324 "spice-display.c"
					}
#line 438 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_libusb_free_config_descriptor0 (config);
#line 3328 "spice-display.c"
				}
#line 458 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp77_ = ret;
#line 458 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp78_ = dev;
#line 458 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp79_ = __vala_SpiceUsbDevice_copy0 (_tmp78_);
#line 458 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				g_ptr_array_add (_tmp77_, _tmp79_);
#line 425 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_libusb_unref_device0 (libusb_dev);
#line 425 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				__vala_SpiceUsbDevice_free0 (dev);
#line 3342 "spice-display.c"
			}
		}
	}
#line 461 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	result = ret;
#line 461 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_ptr_array_unref0 (devs);
#line 461 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return result;
#line 3352 "spice-display.c"
}


static gboolean boxes_spice_display_is_usb_kbd_or_mouse (BoxesSpiceDisplay* self, guint8 class, guint8 subclass, guint8 protocol) {
	gboolean result = FALSE;
	gboolean ret = FALSE;
	guint8 _tmp0_ = 0U;
#line 464 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 465 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	ret = FALSE;
#line 467 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = class;
#line 467 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp0_ == LIBUSB_CLASS_HID) {
#line 3368 "spice-display.c"
		guint8 _tmp1_ = 0U;
#line 468 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp1_ = subclass;
#line 468 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		switch (_tmp1_) {
#line 468 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			case 0x00:
#line 3376 "spice-display.c"
			{
#line 470 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				break;
#line 3380 "spice-display.c"
			}
#line 468 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			case 0x01:
#line 3384 "spice-display.c"
			{
				guint8 _tmp2_ = 0U;
#line 472 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp2_ = protocol;
#line 472 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				switch (_tmp2_) {
#line 472 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					case 0x00:
#line 3393 "spice-display.c"
					{
#line 474 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						break;
#line 3397 "spice-display.c"
					}
#line 472 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					case 0x01:
#line 472 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					case 0x02:
#line 3403 "spice-display.c"
					{
#line 477 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						ret = TRUE;
#line 478 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						break;
#line 3409 "spice-display.c"
					}
					default:
					{
#line 480 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						break;
#line 3415 "spice-display.c"
					}
				}
#line 482 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				break;
#line 3420 "spice-display.c"
			}
			default:
			{
#line 484 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				break;
#line 3426 "spice-display.c"
			}
		}
	}
#line 488 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	result = ret;
#line 488 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return result;
#line 3434 "spice-display.c"
}


static const gchar* boxes_spice_display_real_get_protocol (BoxesDisplay* base) {
	const gchar* result;
	BoxesSpiceDisplay* self;
#line 7 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 7 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	result = "SPICE";
#line 7 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return result;
#line 3447 "spice-display.c"
}


static gchar* boxes_spice_display_real_get_uri (BoxesDisplay* base) {
	gchar* result;
	BoxesSpiceDisplay* self;
	gboolean _tmp0_ = FALSE;
	SpiceSession* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SpiceSession* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
#line 9 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 10 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = self->priv->session;
#line 10 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp1_, "port", &_tmp2_, NULL);
#line 10 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = _tmp2_;
#line 10 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp4_ = _tmp3_;
#line 10 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp5_ = _tmp4_ == NULL;
#line 10 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_free0 (_tmp4_);
#line 10 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp5_) {
#line 3479 "spice-display.c"
		SpiceSession* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 10 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp6_ = self->priv->session;
#line 10 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp6_, "tls-port", &_tmp7_, NULL);
#line 10 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp8_ = _tmp7_;
#line 10 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp9_ = _tmp8_;
#line 10 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp0_ = _tmp9_ == NULL;
#line 10 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp9_);
#line 3496 "spice-display.c"
	} else {
#line 10 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp0_ = FALSE;
#line 3500 "spice-display.c"
	}
#line 10 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp0_) {
#line 11 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		result = NULL;
#line 11 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		return result;
#line 3508 "spice-display.c"
	}
#line 13 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp10_ = self->priv->session;
#line 13 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp10_, "uri", &_tmp11_, NULL);
#line 13 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp12_ = _tmp11_;
#line 13 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	result = _tmp12_;
#line 13 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return result;
#line 3520 "spice-display.c"
}


GByteArray* boxes_spice_display_get_ca_cert (BoxesSpiceDisplay* self) {
	GByteArray* result;
	SpiceSession* _tmp0_ = NULL;
	GByteArray* _tmp1_ = NULL;
	GByteArray* _tmp2_ = NULL;
#line 16 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 16 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->session;
#line 16 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp0_, "ca", &_tmp1_, NULL);
#line 16 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 16 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	result = _tmp2_;
#line 16 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return result;
#line 3541 "spice-display.c"
}


void boxes_spice_display_set_ca_cert (BoxesSpiceDisplay* self, GByteArray* value) {
	SpiceSession* _tmp0_ = NULL;
	GByteArray* _tmp1_ = NULL;
#line 16 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 16 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->session;
#line 16 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = value;
#line 16 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_set (_tmp0_, "ca", _tmp1_, NULL);
#line 16 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_notify ((GObject *) self, "ca-cert");
#line 3558 "spice-display.c"
}


SpiceMainChannel* boxes_spice_display_get_main_channel (BoxesSpiceDisplay* self) {
	SpiceMainChannel* result;
	SpiceMainChannel* _tmp0_ = NULL;
#line 70 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 71 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->_main_channel;
#line 71 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	result = _tmp0_;
#line 71 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return result;
#line 3573 "spice-display.c"
}


static void _boxes_spice_display_main_event_spice_channel_channel_event (SpiceChannel* _sender, SpiceChannelEvent event, gpointer self) {
#line 79 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_main_event ((BoxesSpiceDisplay*) self, event);
#line 3580 "spice-display.c"
}


static void _boxes_spice_display_main_channel___lambda69_ (BoxesSpiceDisplay* self) {
	SpiceMainChannel* _tmp0_ = NULL;
	SpiceMainChannel* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 81 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = boxes_spice_display_get_main_channel (self);
#line 81 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = _tmp0_;
#line 81 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp1_, "mouse-mode", &_tmp2_, NULL);
#line 81 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = _tmp2_;
#line 81 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_display_set_can_grab_mouse ((BoxesDisplay*) self, _tmp3_ != 2);
#line 3599 "spice-display.c"
}


static void __boxes_spice_display_main_channel___lambda69__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 80 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_boxes_spice_display_main_channel___lambda69_ ((BoxesSpiceDisplay*) self);
#line 3606 "spice-display.c"
}


void boxes_spice_display_set_main_channel (BoxesSpiceDisplay* self, SpiceMainChannel* value) {
	SpiceMainChannel* _tmp0_ = NULL;
	SpiceMainChannel* _tmp1_ = NULL;
	SpiceMainChannel* _tmp2_ = NULL;
	SpiceMainChannel* _tmp3_ = NULL;
	SpiceMainChannel* _tmp4_ = NULL;
	gulong _tmp5_ = 0UL;
	SpiceMainChannel* _tmp6_ = NULL;
	SpiceMainChannel* _tmp7_ = NULL;
	gulong _tmp8_ = 0UL;
	SpiceMainChannel* _tmp9_ = NULL;
	SpiceMainChannel* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
#line 74 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 75 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = value;
#line 75 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 75 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (self->priv->_main_channel);
#line 75 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->_main_channel = _tmp1_;
#line 76 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = self->priv->_main_channel;
#line 76 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp2_ == NULL) {
#line 77 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		return;
#line 3640 "spice-display.c"
	}
#line 79 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = boxes_spice_display_get_main_channel (self);
#line 79 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp4_ = _tmp3_;
#line 79 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp5_ = g_signal_connect_object ((SpiceChannel*) _tmp4_, "channel-event", (GCallback) _boxes_spice_display_main_event_spice_channel_channel_event, self, 0);
#line 79 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->main_event_id = _tmp5_;
#line 80 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp6_ = boxes_spice_display_get_main_channel (self);
#line 80 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp7_ = _tmp6_;
#line 80 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp8_ = g_signal_connect_object ((GObject*) _tmp7_, "notify::mouse-mode", (GCallback) __boxes_spice_display_main_channel___lambda69__g_object_notify, self, 0);
#line 80 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->main_mouse_mode_id = _tmp8_;
#line 84 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp9_ = boxes_spice_display_get_main_channel (self);
#line 84 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp10_ = _tmp9_;
#line 84 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp10_, "mouse-mode", &_tmp11_, NULL);
#line 84 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp12_ = _tmp11_;
#line 84 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_display_set_can_grab_mouse ((BoxesDisplay*) self, _tmp12_ != 2);
#line 74 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_notify ((GObject *) self, "main-channel");
#line 3670 "spice-display.c"
}


static void _boxes_spice_display____lambda77_ (BoxesSpiceDisplay* self, SpiceUsbDevice* dev, GError* err) {
	gchar* device_description = NULL;
	SpiceUsbDevice* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* box_name = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GError* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
#line 58 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (dev != NULL);
#line 59 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = dev;
#line 59 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = spice_usb_device_get_description (_tmp0_, "%1$s %2$s");
#line 59 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	device_description = _tmp1_;
#line 60 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = boxes_spice_display_get_box_name (self);
#line 60 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	box_name = _tmp2_;
#line 61 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = _ ("Redirection of USB device '%s' for '%s' failed");
#line 61 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp4_ = device_description;
#line 61 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp5_ = box_name;
#line 61 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp6_ = g_strdup_printf (_tmp3_, _tmp4_, _tmp5_);
#line 61 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp7_ = _tmp6_;
#line 61 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_signal_emit_by_name ((BoxesDisplay*) self, "got-error", _tmp7_);
#line 61 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_free0 (_tmp7_);
#line 62 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp8_ = device_description;
#line 62 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp9_ = box_name;
#line 62 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp10_ = err;
#line 62 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp11_ = _tmp10_->message;
#line 62 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_debug ("spice-display.vala:62: Error connecting %s to %s: %s", _tmp8_, _tmp9_, _tmp11_);
#line 58 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_free0 (box_name);
#line 58 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_free0 (device_description);
#line 3729 "spice-display.c"
}


static void __boxes_spice_display____lambda77__spice_usb_device_manager_device_error (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, GError* _error_, gpointer self) {
#line 58 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_boxes_spice_display____lambda77_ ((BoxesSpiceDisplay*) self, device, _error_);
#line 3736 "spice-display.c"
}


static GObject * boxes_spice_display_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	BoxesSpiceDisplay * self;
	gchar* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	BoxesBoxConfigSavedProperty _tmp2_ = {0};
	BoxesBoxConfigSavedProperty* _tmp3_ = NULL;
	SpiceSession* _tmp4_ = NULL;
	SpiceSession* _tmp5_ = NULL;
	SpiceAudio* _tmp6_ = NULL;
	SpiceSession* _tmp7_ = NULL;
	SpiceGtkSession* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
#line 46 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	parent_class = G_OBJECT_CLASS (boxes_spice_display_parent_class);
#line 46 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 46 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay);
#line 47 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = g_strdup ("auto-clipboard");
#line 47 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_value_init (&_tmp1_, G_TYPE_BOOLEAN);
#line 47 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_value_set_boolean (&_tmp1_, TRUE);
#line 47 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	memset (&_tmp2_, 0, sizeof (BoxesBoxConfigSavedProperty));
#line 47 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_free0 (_tmp2_.name);
#line 47 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_.name = _tmp0_;
#line 47 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	G_IS_VALUE (&_tmp2_.default_value) ? (g_value_unset (&_tmp2_.default_value), NULL) : NULL;
#line 47 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_.default_value = _tmp1_;
#line 47 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = g_new0 (BoxesBoxConfigSavedProperty, 1);
#line 47 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_[0] = _tmp2_;
#line 47 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->gtk_session_saved_properties = (_vala_BoxesBoxConfigSavedProperty_array_free (self->priv->gtk_session_saved_properties, self->priv->gtk_session_saved_properties_length1), NULL);
#line 47 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->gtk_session_saved_properties = _tmp3_;
#line 47 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->gtk_session_saved_properties_length1 = 1;
#line 47 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->_gtk_session_saved_properties_size_ = self->priv->gtk_session_saved_properties_length1;
#line 51 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_display_set_need_password ((BoxesDisplay*) self, FALSE);
#line 52 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp4_ = spice_session_new ();
#line 52 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (self->priv->session);
#line 52 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->session = _tmp4_;
#line 53 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp5_ = self->priv->session;
#line 53 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp6_ = spice_audio_get (_tmp5_, NULL);
#line 53 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->audio = _tmp6_;
#line 54 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp7_ = self->priv->session;
#line 54 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp8_ = spice_gtk_session_get (_tmp7_);
#line 54 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->gtk_session = _tmp8_;
#line 3808 "spice-display.c"
	{
		SpiceUsbDeviceManager* manager = NULL;
		SpiceSession* _tmp9_ = NULL;
		SpiceUsbDeviceManager* _tmp10_ = NULL;
		SpiceUsbDeviceManager* _tmp11_ = NULL;
		SpiceUsbDeviceManager* _tmp12_ = NULL;
#line 56 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp9_ = self->priv->session;
#line 56 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp10_ = spice_usb_device_manager_get (_tmp9_, &_inner_error_);
#line 56 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp11_ = _g_object_ref0 (_tmp10_);
#line 56 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		manager = _tmp11_;
#line 56 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3825 "spice-display.c"
			goto __catch78_g_error;
		}
#line 58 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp12_ = manager;
#line 58 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_signal_connect_object (_tmp12_, "device-error", (GCallback) __boxes_spice_display____lambda77__spice_usb_device_manager_device_error, self, 0);
#line 55 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (manager);
#line 3834 "spice-display.c"
	}
	goto __finally78;
	__catch78_g_error:
	{
		GError* _error_ = NULL;
#line 55 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_error_ = _inner_error_;
#line 55 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_inner_error_ = NULL;
#line 55 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_error_free0 (_error_);
#line 3846 "spice-display.c"
	}
	__finally78:
#line 55 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 55 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 55 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_clear_error (&_inner_error_);
#line 3855 "spice-display.c"
	}
#line 46 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return obj;
#line 3859 "spice-display.c"
}


static void boxes_spice_display_class_init (BoxesSpiceDisplayClass * klass) {
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_parent_class = g_type_class_peek_parent (klass);
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_type_class_add_private (klass, sizeof (BoxesSpiceDisplayPrivate));
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->get_display = boxes_spice_display_real_get_display;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->should_keep_alive = boxes_spice_display_real_should_keep_alive;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->set_enable_audio = boxes_spice_display_real_set_enable_audio;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->get_pixbuf = boxes_spice_display_real_get_pixbuf;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->collect_logs = boxes_spice_display_real_collect_logs;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->connect_it = boxes_spice_display_real_connect_it;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->disconnect_it = boxes_spice_display_real_disconnect_it;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->get_properties = boxes_spice_display_real_get_properties;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->send_keys = boxes_spice_display_real_send_keys;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	BOXES_DISPLAY_CLASS (klass)->get_protocol = boxes_spice_display_real_get_protocol;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	BOXES_DISPLAY_CLASS (klass)->get_uri = boxes_spice_display_real_get_uri;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_spice_display_get_property;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_spice_display_set_property;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (klass)->constructor = boxes_spice_display_constructor;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (klass)->finalize = boxes_spice_display_finalize;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SPICE_DISPLAY_PROTOCOL, g_param_spec_string ("protocol", "protocol", "protocol", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SPICE_DISPLAY_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SPICE_DISPLAY_CA_CERT, g_param_spec_boxed ("ca-cert", "ca-cert", "ca-cert", G_TYPE_BYTE_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SPICE_DISPLAY_MAIN_CHANNEL, g_param_spec_object ("main-channel", "main-channel", "main-channel", spice_main_channel_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3906 "spice-display.c"
}


static void boxes_spice_display_instance_init (BoxesSpiceDisplay * self) {
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv = BOXES_SPICE_DISPLAY_GET_PRIVATE (self);
#line 3913 "spice-display.c"
}


static void boxes_spice_display_finalize (GObject* obj) {
	BoxesSpiceDisplay * self;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay);
#line 103 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_main_cleanup (self);
#line 20 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (self->priv->session);
#line 25 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->display_saved_properties = (_vala_BoxesBoxConfigSavedProperty_array_free (self->priv->display_saved_properties, self->priv->display_saved_properties_length1), NULL);
#line 26 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->gtk_session_saved_properties = (_vala_BoxesBoxConfigSavedProperty_array_free (self->priv->gtk_session_saved_properties, self->priv->gtk_session_saved_properties_length1), NULL);
#line 29 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_hash_table_unref0 (self->priv->channel_handlers);
#line 30 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	(self->priv->open_fd_target_destroy_notify == NULL) ? NULL : (self->priv->open_fd_target_destroy_notify (self->priv->open_fd_target), NULL);
#line 30 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd = NULL;
#line 30 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target = NULL;
#line 30 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = NULL;
#line 68 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (self->priv->_main_channel);
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (boxes_spice_display_parent_class)->finalize (obj);
#line 3943 "spice-display.c"
}


GType boxes_spice_display_get_type (void) {
	static volatile gsize boxes_spice_display_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_spice_display_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesSpiceDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_spice_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesSpiceDisplay), 0, (GInstanceInitFunc) boxes_spice_display_instance_init, NULL };
		GType boxes_spice_display_type_id;
		boxes_spice_display_type_id = g_type_register_static (BOXES_TYPE_DISPLAY, "BoxesSpiceDisplay", &g_define_type_info, 0);
		g_once_init_leave (&boxes_spice_display_type_id__volatile, boxes_spice_display_type_id);
	}
	return boxes_spice_display_type_id__volatile;
}


static void _vala_boxes_spice_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BoxesSpiceDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay);
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	switch (property_id) {
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_PROTOCOL:
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_value_set_string (value, boxes_display_get_protocol ((BoxesDisplay*) self));
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		break;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_URI:
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_value_take_string (value, boxes_display_get_uri ((BoxesDisplay*) self));
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		break;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_CA_CERT:
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_value_take_boxed (value, boxes_spice_display_get_ca_cert (self));
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		break;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_MAIN_CHANNEL:
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_value_set_object (value, boxes_spice_display_get_main_channel (self));
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		break;
#line 3988 "spice-display.c"
		default:
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		break;
#line 3994 "spice-display.c"
	}
}


static void _vala_boxes_spice_display_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BoxesSpiceDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay);
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	switch (property_id) {
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_CA_CERT:
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		boxes_spice_display_set_ca_cert (self, g_value_get_boxed (value));
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		break;
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_MAIN_CHANNEL:
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		boxes_spice_display_set_main_channel (self, g_value_get_object (value));
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		break;
#line 4016 "spice-display.c"
		default:
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 6 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		break;
#line 4022 "spice-display.c"
	}
}


static void _boxes_spice_channel_handler_on_open_fd_spice_channel_open_fd (SpiceChannel* _sender, gint with_tls, gpointer self) {
#line 504 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_spice_channel_handler_on_open_fd ((BoxesSpiceChannelHandler*) self, _sender, with_tls);
#line 4030 "spice-display.c"
}


static void _boxes_spice_channel_handler_on_display_ready_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 514 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_spice_channel_handler_on_display_ready ((BoxesSpiceChannelHandler*) self, _sender, pspec);
#line 4037 "spice-display.c"
}


BoxesSpiceChannelHandler* boxes_spice_channel_handler_construct (GType object_type, BoxesSpiceDisplay* display, SpiceChannel* channel, BoxesDisplayOpenFDFunc open_fd, void* open_fd_target, GDestroyNotify open_fd_target_destroy_notify) {
	BoxesSpiceChannelHandler * self = NULL;
	BoxesSpiceDisplay* _tmp0_ = NULL;
	SpiceChannel* _tmp1_ = NULL;
	SpiceChannel* _tmp2_ = NULL;
	BoxesDisplayOpenFDFunc _tmp3_ = NULL;
	void* _tmp3__target = NULL;
	GDestroyNotify _tmp3__target_destroy_notify = NULL;
	gint id = 0;
	SpiceChannel* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	BoxesDisplayOpenFDFunc _tmp7_ = NULL;
	void* _tmp7__target = NULL;
	SpiceChannel* _tmp9_ = NULL;
	SpiceChannel* _tmp12_ = NULL;
#line 497 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (display != NULL, NULL);
#line 497 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (channel != NULL, NULL);
#line 497 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceChannelHandler*) g_object_new (object_type, NULL);
#line 498 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = display;
#line 498 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->display = _tmp0_;
#line 499 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = channel;
#line 499 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 499 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (self->priv->channel);
#line 499 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->channel = _tmp2_;
#line 500 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3_ = open_fd;
#line 500 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3__target = open_fd_target;
#line 500 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp3__target_destroy_notify = open_fd_target_destroy_notify;
#line 500 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	open_fd_target_destroy_notify = NULL;
#line 500 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	(self->priv->open_fd_target_destroy_notify == NULL) ? NULL : (self->priv->open_fd_target_destroy_notify (self->priv->open_fd_target), NULL);
#line 500 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd = NULL;
#line 500 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target = NULL;
#line 500 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = NULL;
#line 500 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd = _tmp3_;
#line 500 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target = _tmp3__target;
#line 500 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = _tmp3__target_destroy_notify;
#line 501 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp4_ = channel;
#line 501 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp4_, "channel-id", &_tmp5_, NULL);
#line 501 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp6_ = _tmp5_;
#line 501 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	id = _tmp6_;
#line 503 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp7_ = open_fd;
#line 503 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp7__target = open_fd_target;
#line 503 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp7_ != NULL) {
#line 4111 "spice-display.c"
		SpiceChannel* _tmp8_ = NULL;
#line 504 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp8_ = channel;
#line 504 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_signal_connect_object (_tmp8_, "open-fd", (GCallback) _boxes_spice_channel_handler_on_open_fd_spice_channel_open_fd, self, 0);
#line 4117 "spice-display.c"
	}
#line 506 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp9_ = channel;
#line 506 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, spice_main_channel_get_type ())) {
#line 4123 "spice-display.c"
		BoxesSpiceDisplay* _tmp10_ = NULL;
		SpiceChannel* _tmp11_ = NULL;
#line 507 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp10_ = display;
#line 507 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp11_ = channel;
#line 507 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		boxes_spice_display_set_main_channel (_tmp10_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, spice_main_channel_get_type ()) ? ((SpiceMainChannel*) _tmp11_) : NULL);
#line 4132 "spice-display.c"
	}
#line 509 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp12_ = channel;
#line 509 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, spice_display_channel_get_type ())) {
#line 4138 "spice-display.c"
		gint _tmp13_ = 0;
		SpiceDisplay* spice_display = NULL;
		BoxesSpiceDisplay* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		GtkWidget* _tmp16_ = NULL;
		SpiceDisplay* _tmp17_ = NULL;
		SpiceDisplay* _tmp18_ = NULL;
#line 510 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp13_ = id;
#line 510 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		if (_tmp13_ != 0) {
#line 511 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			(open_fd_target_destroy_notify == NULL) ? NULL : (open_fd_target_destroy_notify (open_fd_target), NULL);
#line 511 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			open_fd = NULL;
#line 511 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			open_fd_target = NULL;
#line 511 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			open_fd_target_destroy_notify = NULL;
#line 511 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			return self;
#line 4160 "spice-display.c"
		}
#line 513 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp14_ = display;
#line 513 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp15_ = id;
#line 513 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp16_ = boxes_display_get_display ((BoxesDisplay*) _tmp14_, _tmp15_);
#line 513 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp17_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp16_) : NULL;
#line 513 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		if (_tmp17_ == NULL) {
#line 513 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (_tmp16_);
#line 4174 "spice-display.c"
		}
#line 513 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		spice_display = _tmp17_;
#line 514 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp18_ = spice_display;
#line 514 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_signal_connect_object ((GObject*) _tmp18_, "notify::ready", (GCallback) _boxes_spice_channel_handler_on_display_ready_g_object_notify, self, 0);
#line 509 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (spice_display);
#line 4184 "spice-display.c"
	}
#line 497 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	(open_fd_target_destroy_notify == NULL) ? NULL : (open_fd_target_destroy_notify (open_fd_target), NULL);
#line 497 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	open_fd = NULL;
#line 497 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	open_fd_target = NULL;
#line 497 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	open_fd_target_destroy_notify = NULL;
#line 497 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return self;
#line 4196 "spice-display.c"
}


BoxesSpiceChannelHandler* boxes_spice_channel_handler_new (BoxesSpiceDisplay* display, SpiceChannel* channel, BoxesDisplayOpenFDFunc open_fd, void* open_fd_target, GDestroyNotify open_fd_target_destroy_notify) {
#line 497 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return boxes_spice_channel_handler_construct (BOXES_TYPE_SPICE_CHANNEL_HANDLER, display, channel, open_fd, open_fd_target, open_fd_target_destroy_notify);
#line 4203 "spice-display.c"
}


static void boxes_spice_channel_handler_on_display_ready (BoxesSpiceChannelHandler* self, GObject* object, GParamSpec* param_spec) {
	SpiceDisplay* spice_display = NULL;
	GObject* _tmp0_ = NULL;
	SpiceDisplay* _tmp1_ = NULL;
	SpiceDisplay* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 518 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 518 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (object != NULL);
#line 518 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (param_spec != NULL);
#line 519 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = object;
#line 519 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp0_) : NULL);
#line 519 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	spice_display = _tmp1_;
#line 520 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = spice_display;
#line 520 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp2_, "ready", &_tmp3_, NULL);
#line 520 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp4_ = _tmp3_;
#line 520 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp4_) {
#line 4234 "spice-display.c"
		BoxesSpiceDisplay* _tmp5_ = NULL;
		SpiceDisplay* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 521 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp5_ = self->priv->display;
#line 521 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp6_ = spice_display;
#line 521 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp6_, "channel-id", &_tmp7_, NULL);
#line 521 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp8_ = _tmp7_;
#line 521 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_signal_emit_by_name ((BoxesDisplay*) _tmp5_, "show", _tmp8_);
#line 4249 "spice-display.c"
	} else {
		BoxesSpiceDisplay* _tmp9_ = NULL;
		SpiceDisplay* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
#line 523 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp9_ = self->priv->display;
#line 523 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp10_ = spice_display;
#line 523 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp10_, "channel-id", &_tmp11_, NULL);
#line 523 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp12_ = _tmp11_;
#line 523 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		g_signal_emit_by_name ((BoxesDisplay*) _tmp9_, "hide", _tmp12_);
#line 4265 "spice-display.c"
	}
#line 518 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (spice_display);
#line 4269 "spice-display.c"
}


static void boxes_spice_channel_handler_on_open_fd (BoxesSpiceChannelHandler* self, SpiceChannel* channel, gint with_tls) {
	gint fd = 0;
	BoxesDisplayOpenFDFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gint _tmp1_ = 0;
	SpiceChannel* _tmp2_ = NULL;
#line 526 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 526 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (channel != NULL);
#line 529 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->open_fd;
#line 529 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0__target = self->priv->open_fd_target;
#line 529 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = _tmp0_ (_tmp0__target);
#line 529 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	fd = _tmp1_;
#line 530 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = channel;
#line 530 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	spice_channel_open_fd (_tmp2_, fd);
#line 4295 "spice-display.c"
}


static void boxes_spice_channel_handler_class_init (BoxesSpiceChannelHandlerClass * klass) {
#line 492 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	boxes_spice_channel_handler_parent_class = g_type_class_peek_parent (klass);
#line 492 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_type_class_add_private (klass, sizeof (BoxesSpiceChannelHandlerPrivate));
#line 492 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (klass)->finalize = boxes_spice_channel_handler_finalize;
#line 4306 "spice-display.c"
}


static void boxes_spice_channel_handler_instance_init (BoxesSpiceChannelHandler * self) {
#line 492 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv = BOXES_SPICE_CHANNEL_HANDLER_GET_PRIVATE (self);
#line 4313 "spice-display.c"
}


static void boxes_spice_channel_handler_finalize (GObject* obj) {
	BoxesSpiceChannelHandler * self;
#line 492 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_SPICE_CHANNEL_HANDLER, BoxesSpiceChannelHandler);
#line 494 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (self->priv->channel);
#line 495 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	(self->priv->open_fd_target_destroy_notify == NULL) ? NULL : (self->priv->open_fd_target_destroy_notify (self->priv->open_fd_target), NULL);
#line 495 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd = NULL;
#line 495 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target = NULL;
#line 495 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = NULL;
#line 492 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (boxes_spice_channel_handler_parent_class)->finalize (obj);
#line 4333 "spice-display.c"
}


GType boxes_spice_channel_handler_get_type (void) {
	static volatile gsize boxes_spice_channel_handler_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_spice_channel_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesSpiceChannelHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_spice_channel_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesSpiceChannelHandler), 0, (GInstanceInitFunc) boxes_spice_channel_handler_instance_init, NULL };
		GType boxes_spice_channel_handler_type_id;
		boxes_spice_channel_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesSpiceChannelHandler", &g_define_type_info, 0);
		g_once_init_leave (&boxes_spice_channel_handler_type_id__volatile, boxes_spice_channel_handler_type_id);
	}
	return boxes_spice_channel_handler_type_id__volatile;
}


static gint* _int_dup (gint* self) {
	gint* dup;
#line 543 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	dup = g_new0 (gint, 1);
#line 543 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	memcpy (dup, self, sizeof (gint));
#line 543 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return dup;
#line 4357 "spice-display.c"
}


static gpointer __int_dup0 (gpointer self) {
#line 543 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	return self ? _int_dup (self) : NULL;
#line 4364 "spice-display.c"
}


void spice_validate_uri (const gchar* uri_as_text, gint** port, gint** tls_port, GError** error) {
	gint* _vala_port = NULL;
	gint* _vala_tls_port = NULL;
	xmlURI* uri = NULL;
	const gchar* _tmp0_ = NULL;
	xmlURI* _tmp1_ = NULL;
	xmlURI* _tmp2_ = NULL;
	gint _tmp5_ = 0;
	gint* _tmp6_ = NULL;
	xmlURI* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	xmlURI* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* query_str = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	xmlURI* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	GQuark _tmp44_ = 0U;
#line 559 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	static GQuark _tmp43_label0 = 0;
#line 559 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	static GQuark _tmp43_label1 = 0;
#line 4394 "spice-display.c"
	GError * _inner_error_ = NULL;
#line 535 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (uri_as_text != NULL);
#line 538 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp0_ = uri_as_text;
#line 538 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp1_ = xmlParseURI (_tmp0_);
#line 538 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	uri = _tmp1_;
#line 540 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp2_ = uri;
#line 540 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp2_ == NULL) {
#line 4408 "spice-display.c"
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
#line 541 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp3_ = _ ("Invalid URL");
#line 541 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp4_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, _tmp3_);
#line 541 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_inner_error_ = _tmp4_;
#line 541 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		if (_inner_error_->domain == BOXES_ERROR) {
#line 541 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			g_propagate_error (error, _inner_error_);
#line 541 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_xmlFreeURI0 (uri);
#line 541 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			return;
#line 4425 "spice-display.c"
		} else {
#line 541 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_xmlFreeURI0 (uri);
#line 541 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 541 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			g_clear_error (&_inner_error_);
#line 541 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			return;
#line 4435 "spice-display.c"
		}
	}
#line 543 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp5_ = 0;
#line 543 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp6_ = __int_dup0 (&_tmp5_);
#line 543 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_free0 (_vala_tls_port);
#line 543 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_vala_tls_port = _tmp6_;
#line 544 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp7_ = uri;
#line 544 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp8_ = _tmp7_->port;
#line 544 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp9_ = __int_dup0 (&_tmp8_);
#line 544 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_free0 (_vala_port);
#line 544 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_vala_port = _tmp9_;
#line 545 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp11_ = uri;
#line 545 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp12_ = _tmp11_->query_raw;
#line 545 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp10_ = _tmp12_;
#line 545 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp10_ == NULL) {
#line 4464 "spice-display.c"
		xmlURI* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 545 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp13_ = uri;
#line 545 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp14_ = _tmp13_->query;
#line 545 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp10_ = _tmp14_;
#line 4473 "spice-display.c"
	}
#line 545 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp15_ = g_strdup (_tmp10_);
#line 545 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	query_str = _tmp15_;
#line 547 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp16_ = query_str;
#line 547 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp16_ != NULL) {
#line 4483 "spice-display.c"
		BoxesQuery* query = NULL;
		const gchar* _tmp17_ = NULL;
		BoxesQuery* _tmp18_ = NULL;
		BoxesQuery* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		BoxesQuery* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
#line 548 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp17_ = query_str;
#line 548 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp18_ = boxes_query_new (_tmp17_);
#line 548 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		query = _tmp18_;
#line 549 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp19_ = query;
#line 549 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp20_ = boxes_query_get (_tmp19_, "port");
#line 549 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp21_ = _tmp20_;
#line 549 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp22_ = _tmp21_ != NULL;
#line 549 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp21_);
#line 549 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		if (_tmp22_) {
#line 4513 "spice-display.c"
			gint* _tmp23_ = NULL;
			BoxesQuery* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			gint* _tmp30_ = NULL;
#line 550 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp23_ = _vala_port;
#line 550 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			if ((*_tmp23_) > 0) {
#line 4524 "spice-display.c"
				const gchar* _tmp24_ = NULL;
				GError* _tmp25_ = NULL;
#line 551 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp24_ = _ ("The port must be specified once");
#line 551 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp25_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, _tmp24_);
#line 551 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_inner_error_ = _tmp25_;
#line 551 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				if (_inner_error_->domain == BOXES_ERROR) {
#line 551 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					g_propagate_error (error, _inner_error_);
#line 551 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_g_object_unref0 (query);
#line 551 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_g_free0 (query_str);
#line 551 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_xmlFreeURI0 (uri);
#line 551 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					return;
#line 4545 "spice-display.c"
				} else {
#line 551 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_g_object_unref0 (query);
#line 551 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_g_free0 (query_str);
#line 551 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_xmlFreeURI0 (uri);
#line 551 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 551 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					g_clear_error (&_inner_error_);
#line 551 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					return;
#line 4559 "spice-display.c"
				}
			}
#line 552 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp26_ = query;
#line 552 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp27_ = boxes_query_get (_tmp26_, "port");
#line 552 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp28_ = _tmp27_;
#line 552 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp29_ = atoi (_tmp28_);
#line 552 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp30_ = __int_dup0 (&_tmp29_);
#line 552 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_g_free0 (_vala_port);
#line 552 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_vala_port = _tmp30_;
#line 552 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_g_free0 (_tmp28_);
#line 4578 "spice-display.c"
		}
#line 555 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp31_ = query;
#line 555 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp32_ = boxes_query_get (_tmp31_, "tls-port");
#line 555 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp33_ = _tmp32_;
#line 555 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_tmp34_ = _tmp33_ != NULL;
#line 555 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp33_);
#line 555 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		if (_tmp34_) {
#line 4592 "spice-display.c"
			BoxesQuery* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			gint _tmp38_ = 0;
			gint* _tmp39_ = NULL;
#line 556 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp35_ = query;
#line 556 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp36_ = boxes_query_get (_tmp35_, "tls-port");
#line 556 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp37_ = _tmp36_;
#line 556 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp38_ = atoi (_tmp37_);
#line 556 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_tmp39_ = __int_dup0 (&_tmp38_);
#line 556 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_g_free0 (_vala_tls_port);
#line 556 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_vala_tls_port = _tmp39_;
#line 556 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
			_g_free0 (_tmp37_);
#line 4614 "spice-display.c"
		}
#line 547 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (query);
#line 4618 "spice-display.c"
	}
#line 559 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp40_ = uri;
#line 559 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp41_ = _tmp40_->scheme;
#line 559 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp42_ = _tmp41_;
#line 559 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_tmp44_ = (NULL == _tmp42_) ? 0 : g_quark_from_string (_tmp42_);
#line 559 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (_tmp44_ == ((0 != _tmp43_label0) ? _tmp43_label0 : (_tmp43_label0 = g_quark_from_static_string ("spice")))) {
#line 559 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		switch (0) {
#line 4632 "spice-display.c"
			default:
			{
				gboolean _tmp45_ = FALSE;
				gint* _tmp46_ = NULL;
#line 561 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp46_ = _vala_port;
#line 561 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				if ((*_tmp46_) <= 0) {
#line 4641 "spice-display.c"
					gint* _tmp47_ = NULL;
#line 561 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp47_ = _vala_tls_port;
#line 561 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp45_ = (*_tmp47_) <= 0;
#line 4647 "spice-display.c"
				} else {
#line 561 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp45_ = FALSE;
#line 4651 "spice-display.c"
				}
#line 561 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				if (_tmp45_) {
#line 4655 "spice-display.c"
					const gchar* _tmp48_ = NULL;
					GError* _tmp49_ = NULL;
#line 562 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp48_ = _ ("Missing port in Spice URL");
#line 562 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp49_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, _tmp48_);
#line 562 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_inner_error_ = _tmp49_;
#line 562 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					if (_inner_error_->domain == BOXES_ERROR) {
#line 562 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						g_propagate_error (error, _inner_error_);
#line 562 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_g_free0 (query_str);
#line 562 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_xmlFreeURI0 (uri);
#line 562 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						return;
#line 4674 "spice-display.c"
					} else {
#line 562 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_g_free0 (query_str);
#line 562 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_xmlFreeURI0 (uri);
#line 562 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 562 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						g_clear_error (&_inner_error_);
#line 562 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						return;
#line 4686 "spice-display.c"
					}
				}
#line 563 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				break;
#line 4691 "spice-display.c"
			}
		}
	} else if (_tmp44_ == ((0 != _tmp43_label1) ? _tmp43_label1 : (_tmp43_label1 = g_quark_from_static_string ("spice+unix")))) {
#line 559 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		switch (0) {
#line 4697 "spice-display.c"
			default:
			{
				gboolean _tmp50_ = FALSE;
				gboolean _tmp51_ = FALSE;
				gint* _tmp52_ = NULL;
#line 565 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp52_ = _vala_port;
#line 565 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				if ((*_tmp52_) > 0) {
#line 565 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp51_ = TRUE;
#line 4709 "spice-display.c"
				} else {
					xmlURI* _tmp53_ = NULL;
					const gchar* _tmp54_ = NULL;
#line 565 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp53_ = uri;
#line 565 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp54_ = _tmp53_->query_raw;
#line 565 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp51_ = _tmp54_ != NULL;
#line 4719 "spice-display.c"
				}
#line 565 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				if (_tmp51_) {
#line 565 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp50_ = TRUE;
#line 4725 "spice-display.c"
				} else {
					xmlURI* _tmp55_ = NULL;
					const gchar* _tmp56_ = NULL;
#line 565 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp55_ = uri;
#line 565 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp56_ = _tmp55_->query;
#line 565 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp50_ = _tmp56_ != NULL;
#line 4735 "spice-display.c"
				}
#line 565 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				if (_tmp50_) {
#line 4739 "spice-display.c"
					const gchar* _tmp57_ = NULL;
					GError* _tmp58_ = NULL;
#line 566 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp57_ = _ ("Invalid URL");
#line 566 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_tmp58_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, _tmp57_);
#line 566 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_inner_error_ = _tmp58_;
#line 566 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					if (_inner_error_->domain == BOXES_ERROR) {
#line 566 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						g_propagate_error (error, _inner_error_);
#line 566 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_g_free0 (query_str);
#line 566 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_xmlFreeURI0 (uri);
#line 566 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						return;
#line 4758 "spice-display.c"
					} else {
#line 566 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_g_free0 (query_str);
#line 566 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						_xmlFreeURI0 (uri);
#line 566 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 566 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						g_clear_error (&_inner_error_);
#line 566 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
						return;
#line 4770 "spice-display.c"
					}
				}
#line 567 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				break;
#line 4775 "spice-display.c"
			}
		}
	} else {
#line 559 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		switch (0) {
#line 4781 "spice-display.c"
			default:
			{
				const gchar* _tmp59_ = NULL;
				GError* _tmp60_ = NULL;
#line 569 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp59_ = _ ("Invalid URL");
#line 569 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_tmp60_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, _tmp59_);
#line 569 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				_inner_error_ = _tmp60_;
#line 569 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
				if (_inner_error_->domain == BOXES_ERROR) {
#line 569 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					g_propagate_error (error, _inner_error_);
#line 569 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_g_free0 (query_str);
#line 569 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_xmlFreeURI0 (uri);
#line 569 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					return;
#line 4802 "spice-display.c"
				} else {
#line 569 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_g_free0 (query_str);
#line 569 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					_xmlFreeURI0 (uri);
#line 569 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 569 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					g_clear_error (&_inner_error_);
#line 569 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
					return;
#line 4814 "spice-display.c"
				}
			}
		}
	}
#line 535 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_g_free0 (query_str);
#line 535 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	_xmlFreeURI0 (uri);
#line 535 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (port) {
#line 535 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		*port = _vala_port;
#line 4827 "spice-display.c"
	} else {
#line 535 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_free0 (_vala_port);
#line 4831 "spice-display.c"
	}
#line 535 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
	if (tls_port) {
#line 535 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		*tls_port = _vala_tls_port;
#line 4837 "spice-display.c"
	} else {
#line 535 "/home/rishi/devel/gnome-boxes/git/gnome-boxes/src/spice-display.vala"
		_g_free0 (_vala_tls_port);
#line 4841 "spice-display.c"
	}
}



