/* function-manager.c generated by valac 0.27.2.2-e6bbc, the Vala compiler
 * generated from function-manager.vala, do not modify */

/*
 * Copyright (C) 2013 Garima Joshi
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>


#define TYPE_FUNCTION_MANAGER (function_manager_get_type ())
#define FUNCTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_MANAGER, FunctionManager))
#define FUNCTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_MANAGER, FunctionManagerClass))
#define IS_FUNCTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_MANAGER))
#define IS_FUNCTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_MANAGER))
#define FUNCTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_MANAGER, FunctionManagerClass))

typedef struct _FunctionManager FunctionManager;
typedef struct _FunctionManagerClass FunctionManagerClass;
typedef struct _FunctionManagerPrivate FunctionManagerPrivate;

#define TYPE_MATH_FUNCTION (math_function_get_type ())
#define MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_FUNCTION, MathFunction))
#define MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_FUNCTION, MathFunctionClass))
#define IS_MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_FUNCTION))
#define IS_MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_FUNCTION))
#define MATH_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_FUNCTION, MathFunctionClass))

typedef struct _MathFunction MathFunction;
typedef struct _MathFunctionClass MathFunctionClass;

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

#define TYPE_BUILT_IN_MATH_FUNCTION (built_in_math_function_get_type ())
#define BUILT_IN_MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILT_IN_MATH_FUNCTION, BuiltInMathFunction))
#define BUILT_IN_MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILT_IN_MATH_FUNCTION, BuiltInMathFunctionClass))
#define IS_BUILT_IN_MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILT_IN_MATH_FUNCTION))
#define IS_BUILT_IN_MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILT_IN_MATH_FUNCTION))
#define BUILT_IN_MATH_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILT_IN_MATH_FUNCTION, BuiltInMathFunctionClass))

typedef struct _BuiltInMathFunction BuiltInMathFunction;
typedef struct _BuiltInMathFunctionClass BuiltInMathFunctionClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_PARSER (parser_get_type ())
#define PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PARSER, Parser))
#define PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PARSER, ParserClass))
#define IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PARSER))
#define IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PARSER))
#define PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PARSER, ParserClass))

typedef struct _Parser Parser;
typedef struct _ParserClass ParserClass;

#define TYPE_ERROR_CODE (error_code_get_type ())

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;

struct _FunctionManager {
	GObject parent_instance;
	FunctionManagerPrivate * priv;
};

struct _FunctionManagerClass {
	GObjectClass parent_class;
};

struct _FunctionManagerPrivate {
	gchar* file_name;
	GHashTable* functions;
	Serializer* serializer;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;


extern FunctionManager* default_function_manager;
FunctionManager* default_function_manager = NULL;
static gpointer function_manager_parent_class = NULL;

GType function_manager_get_type (void) G_GNUC_CONST;
GType math_function_get_type (void) G_GNUC_CONST;
GType serializer_get_type (void) G_GNUC_CONST;
#define FUNCTION_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_FUNCTION_MANAGER, FunctionManagerPrivate))
enum  {
	FUNCTION_MANAGER_DUMMY_PROPERTY
};
FunctionManager* function_manager_new (void);
FunctionManager* function_manager_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
GType display_format_get_type (void) G_GNUC_CONST;
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
void serializer_set_radix (Serializer* self, gunichar radix);
static void function_manager_reload_functions (FunctionManager* self);
FunctionManager* function_manager_get_default_function_manager (void);
static void function_manager_reload_custom_functions (FunctionManager* self);
static void function_manager_reload_builtin_functions (FunctionManager* self);
static gboolean function_manager_add (FunctionManager* self, MathFunction* new_function);
BuiltInMathFunction* built_in_math_function_new (const gchar* function_name, const gchar* description);
BuiltInMathFunction* built_in_math_function_construct (GType object_type, const gchar* function_name, const gchar* description);
GType built_in_math_function_get_type (void) G_GNUC_CONST;
static MathFunction* function_manager_parse_function_from_string (FunctionManager* self, const gchar* data);
const gchar* math_function_get_name (MathFunction* self);
MathFunction* math_function_new (const gchar* function_name, gchar** arguments, int arguments_length1, const gchar* expression, const gchar* description);
MathFunction* math_function_construct (GType object_type, const gchar* function_name, gchar** arguments, int arguments_length1, const gchar* expression, const gchar* description);
static void function_manager_save (FunctionManager* self);
gboolean math_function_is_custom_function (MathFunction* self);
gchar** math_function_get_arguments (MathFunction* self, int* result_length1);
const gchar* math_function_get_expression (MathFunction* self);
const gchar* math_function_get_description (MathFunction* self);
static gchar** function_manager_array_sort_string (FunctionManager* self, gchar** array, int array_length1, int* result_length1);
static gchar** _vala_array_dup16 (gchar** self, int length);
gchar** function_manager_get_names (FunctionManager* self, int* result_length1);
MathFunction* function_manager_get (FunctionManager* self, const gchar* name);
gpointer parser_ref (gpointer instance);
void parser_unref (gpointer instance);
GParamSpec* param_spec_parser (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_parser (GValue* value, gpointer v_object);
void value_take_parser (GValue* value, gpointer v_object);
gpointer value_get_parser (const GValue* value);
GType parser_get_type (void) G_GNUC_CONST;
gboolean function_manager_add_function_with_properties (FunctionManager* self, const gchar* name, const gchar* arguments, const gchar* description, Parser* root_parser);
gboolean math_function_validate (MathFunction* self, Parser* root_parser);
GType error_code_get_type (void) G_GNUC_CONST;
void parser_set_error (Parser* self, ErrorCode errorno, const gchar* token, guint token_start, guint token_end);
void function_manager_delete (FunctionManager* self, const gchar* name);
gboolean function_manager_is_function_defined (FunctionManager* self, const gchar* name);
gint sub_atoi (const gchar* data);
GType number_get_type (void) G_GNUC_CONST;
Number* function_manager_evaluate_function (FunctionManager* self, const gchar* name, Number** arguments, int arguments_length1, Parser* parser);
static Number** _vala_array_dup17 (Number** self, int length);
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
static void _vala_array_add4 (Number*** array, int* length, int* size, Number* value);
Number* math_function_evaluate (MathFunction* self, Number** args, int args_length1, Parser* root_parser);
static MathFunction** function_manager_array_sort_math_function (FunctionManager* self, MathFunction** array, int array_length1, int* result_length1);
static MathFunction** _vala_array_dup18 (MathFunction** self, int length);
MathFunction** function_manager_functions_eligible_for_autocompletion_for_text (FunctionManager* self, const gchar* display_text, int* result_length1);
static void _vala_array_add5 (MathFunction*** array, int* length, int* size, MathFunction* value);
static void function_manager_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _g_free0_ (gpointer var) {
#line 21 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	var = (g_free (var), NULL);
#line 199 "function-manager.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 21 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 206 "function-manager.c"
}


FunctionManager* function_manager_construct (GType object_type) {
	FunctionManager * self = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	Serializer* _tmp5_ = NULL;
	Serializer* _tmp6_ = NULL;
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	self = (FunctionManager*) g_object_new (object_type, NULL);
#line 21 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp0_ = g_str_hash;
#line 21 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp1_ = g_str_equal;
#line 21 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
#line 21 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_hash_table_unref0 (self->priv->functions);
#line 21 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	self->priv->functions = _tmp2_;
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp3_ = g_get_user_data_dir ();
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp4_ = g_build_filename (_tmp3_, "gnome-calculator", "custom-functions", NULL);
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (self->priv->file_name);
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	self->priv->file_name = _tmp4_;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp5_ = serializer_new (DISPLAY_FORMAT_SCIENTIFIC, 10, 50);
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (self->priv->serializer);
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	self->priv->serializer = _tmp5_;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp6_ = self->priv->serializer;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	serializer_set_radix (_tmp6_, (gunichar) '.');
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_reload_functions (self);
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	return self;
#line 253 "function-manager.c"
}


FunctionManager* function_manager_new (void) {
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	return function_manager_construct (TYPE_FUNCTION_MANAGER);
#line 260 "function-manager.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	return self ? g_object_ref (self) : NULL;
#line 267 "function-manager.c"
}


FunctionManager* function_manager_get_default_function_manager (void) {
	FunctionManager* result = NULL;
	FunctionManager* _tmp0_ = NULL;
	FunctionManager* _tmp2_ = NULL;
	FunctionManager* _tmp3_ = NULL;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp0_ = default_function_manager;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp0_ == NULL) {
#line 280 "function-manager.c"
		FunctionManager* _tmp1_ = NULL;
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp1_ = function_manager_new ();
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_object_unref0 (default_function_manager);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		default_function_manager = _tmp1_;
#line 288 "function-manager.c"
	}
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp2_ = default_function_manager;
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	result = _tmp3_;
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	return result;
#line 298 "function-manager.c"
}


static void function_manager_reload_functions (FunctionManager* self) {
	GHashTable* _tmp0_ = NULL;
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_if_fail (self != NULL);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp0_ = self->priv->functions;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_hash_table_remove_all (_tmp0_);
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_reload_custom_functions (self);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_reload_builtin_functions (self);
#line 314 "function-manager.c"
}


static void function_manager_reload_builtin_functions (FunctionManager* self) {
	BuiltInMathFunction* _tmp0_ = NULL;
	BuiltInMathFunction* _tmp1_ = NULL;
	BuiltInMathFunction* _tmp2_ = NULL;
	BuiltInMathFunction* _tmp3_ = NULL;
	BuiltInMathFunction* _tmp4_ = NULL;
	BuiltInMathFunction* _tmp5_ = NULL;
	BuiltInMathFunction* _tmp6_ = NULL;
	BuiltInMathFunction* _tmp7_ = NULL;
	BuiltInMathFunction* _tmp8_ = NULL;
	BuiltInMathFunction* _tmp9_ = NULL;
	BuiltInMathFunction* _tmp10_ = NULL;
	BuiltInMathFunction* _tmp11_ = NULL;
	BuiltInMathFunction* _tmp12_ = NULL;
	BuiltInMathFunction* _tmp13_ = NULL;
	BuiltInMathFunction* _tmp14_ = NULL;
	BuiltInMathFunction* _tmp15_ = NULL;
	BuiltInMathFunction* _tmp16_ = NULL;
	BuiltInMathFunction* _tmp17_ = NULL;
	BuiltInMathFunction* _tmp18_ = NULL;
	BuiltInMathFunction* _tmp19_ = NULL;
	BuiltInMathFunction* _tmp20_ = NULL;
	BuiltInMathFunction* _tmp21_ = NULL;
	BuiltInMathFunction* _tmp22_ = NULL;
	BuiltInMathFunction* _tmp23_ = NULL;
	BuiltInMathFunction* _tmp24_ = NULL;
	BuiltInMathFunction* _tmp25_ = NULL;
	BuiltInMathFunction* _tmp26_ = NULL;
	BuiltInMathFunction* _tmp27_ = NULL;
	BuiltInMathFunction* _tmp28_ = NULL;
	BuiltInMathFunction* _tmp29_ = NULL;
	BuiltInMathFunction* _tmp30_ = NULL;
	BuiltInMathFunction* _tmp31_ = NULL;
	BuiltInMathFunction* _tmp32_ = NULL;
	BuiltInMathFunction* _tmp33_ = NULL;
	BuiltInMathFunction* _tmp34_ = NULL;
	BuiltInMathFunction* _tmp35_ = NULL;
	BuiltInMathFunction* _tmp36_ = NULL;
	BuiltInMathFunction* _tmp37_ = NULL;
	BuiltInMathFunction* _tmp38_ = NULL;
	BuiltInMathFunction* _tmp39_ = NULL;
	BuiltInMathFunction* _tmp40_ = NULL;
	BuiltInMathFunction* _tmp41_ = NULL;
	BuiltInMathFunction* _tmp42_ = NULL;
	BuiltInMathFunction* _tmp43_ = NULL;
	BuiltInMathFunction* _tmp44_ = NULL;
	BuiltInMathFunction* _tmp45_ = NULL;
	BuiltInMathFunction* _tmp46_ = NULL;
	BuiltInMathFunction* _tmp47_ = NULL;
	BuiltInMathFunction* _tmp48_ = NULL;
	BuiltInMathFunction* _tmp49_ = NULL;
	BuiltInMathFunction* _tmp50_ = NULL;
	BuiltInMathFunction* _tmp51_ = NULL;
	BuiltInMathFunction* _tmp52_ = NULL;
	BuiltInMathFunction* _tmp53_ = NULL;
	BuiltInMathFunction* _tmp54_ = NULL;
	BuiltInMathFunction* _tmp55_ = NULL;
	BuiltInMathFunction* _tmp56_ = NULL;
	BuiltInMathFunction* _tmp57_ = NULL;
	BuiltInMathFunction* _tmp58_ = NULL;
	BuiltInMathFunction* _tmp59_ = NULL;
	BuiltInMathFunction* _tmp60_ = NULL;
	BuiltInMathFunction* _tmp61_ = NULL;
	BuiltInMathFunction* _tmp62_ = NULL;
	BuiltInMathFunction* _tmp63_ = NULL;
	BuiltInMathFunction* _tmp64_ = NULL;
	BuiltInMathFunction* _tmp65_ = NULL;
	BuiltInMathFunction* _tmp66_ = NULL;
	BuiltInMathFunction* _tmp67_ = NULL;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp0_ = built_in_math_function_new ("log", "Logarithm");
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp1_ = _tmp0_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp1_);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp1_);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp2_ = built_in_math_function_new ("ln", "Natural logarithm");
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp3_ = _tmp2_;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp3_);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp3_);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp4_ = built_in_math_function_new ("sqrt", "Square root");
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp5_ = _tmp4_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp5_);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp5_);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp6_ = built_in_math_function_new ("abs", "Absolute value");
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp7_ = _tmp6_;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp7_);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp7_);
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp8_ = built_in_math_function_new ("sgn", "Signum");
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp9_ = _tmp8_;
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp9_);
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp9_);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp10_ = built_in_math_function_new ("arg", "Argument");
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp11_ = _tmp10_;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp11_);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp11_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp12_ = built_in_math_function_new ("conj", "Conjugate");
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp13_ = _tmp12_;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp13_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp13_);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp14_ = built_in_math_function_new ("int", "Integer");
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp15_ = _tmp14_;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp15_);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp15_);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp16_ = built_in_math_function_new ("frac", "Fraction");
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp17_ = _tmp16_;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp17_);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp17_);
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp18_ = built_in_math_function_new ("floor", "Floor");
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp19_ = _tmp18_;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp19_);
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp19_);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp20_ = built_in_math_function_new ("ceil", "Ceiling");
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp21_ = _tmp20_;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp21_);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp21_);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp22_ = built_in_math_function_new ("round", "Round");
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp23_ = _tmp22_;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp23_);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp23_);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp24_ = built_in_math_function_new ("re", "Real");
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp25_ = _tmp24_;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp25_);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp25_);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp26_ = built_in_math_function_new ("im", "Imaginary");
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp27_ = _tmp26_;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp27_);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp27_);
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp28_ = built_in_math_function_new ("sin", "Sine");
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp29_ = _tmp28_;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp29_);
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp29_);
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp30_ = built_in_math_function_new ("cos", "Cosine");
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp31_ = _tmp30_;
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp31_);
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp31_);
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp32_ = built_in_math_function_new ("tan", "Tangent");
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp33_ = _tmp32_;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp33_);
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp33_);
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp34_ = built_in_math_function_new ("asin", "Arc sine");
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp35_ = _tmp34_;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp35_);
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp35_);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp36_ = built_in_math_function_new ("acos", "Arc cosine");
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp37_ = _tmp36_;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp37_);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp37_);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp38_ = built_in_math_function_new ("atan", "Arc tangent");
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp39_ = _tmp38_;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp39_);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp39_);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp40_ = built_in_math_function_new ("sin⁻¹", "Inverse sine");
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp41_ = _tmp40_;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp41_);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp41_);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp42_ = built_in_math_function_new ("cos⁻¹", "Inverse cosine");
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp43_ = _tmp42_;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp43_);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp43_);
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp44_ = built_in_math_function_new ("tan⁻¹", "Inverse tangent");
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp45_ = _tmp44_;
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp45_);
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp45_);
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp46_ = built_in_math_function_new ("sinh", "Hyperbolic sine");
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp47_ = _tmp46_;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp47_);
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp47_);
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp48_ = built_in_math_function_new ("cosh", "Hyperbolic cosine");
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp49_ = _tmp48_;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp49_);
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp49_);
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp50_ = built_in_math_function_new ("tanh", "Hyperbolic tangent");
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp51_ = _tmp50_;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp51_);
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp51_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp52_ = built_in_math_function_new ("sinh⁻¹", "Hyperbolic arcsine");
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp53_ = _tmp52_;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp53_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp53_);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp54_ = built_in_math_function_new ("cosh⁻¹", "Hyperbolic arccosine");
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp55_ = _tmp54_;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp55_);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp55_);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp56_ = built_in_math_function_new ("tanh⁻¹", "Hyperbolic arctangent");
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp57_ = _tmp56_;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp57_);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp57_);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp58_ = built_in_math_function_new ("asinh", "Inverse hyperbolic sine");
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp59_ = _tmp58_;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp59_);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp59_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp60_ = built_in_math_function_new ("acosh", "Inverse hyperbolic cosine");
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp61_ = _tmp60_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp61_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp61_);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp62_ = built_in_math_function_new ("atanh", "Inverse hyperbolic tangent");
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp63_ = _tmp62_;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp63_);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp63_);
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp64_ = built_in_math_function_new ("ones", "One's complement");
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp65_ = _tmp64_;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp65_);
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp65_);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp66_ = built_in_math_function_new ("twos", "Two's complement");
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp67_ = _tmp66_;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_add (self, (MathFunction*) _tmp67_);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (_tmp67_);
#line 661 "function-manager.c"
}


static void function_manager_reload_custom_functions (FunctionManager* self) {
	gchar* data = NULL;
	gchar** lines = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GError * _inner_error_ = NULL;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_if_fail (self != NULL);
#line 678 "function-manager.c"
	{
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp0_ = self->priv->file_name;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error_);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (data);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		data = _tmp1_;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 694 "function-manager.c"
				goto __catch14_g_file_error;
			}
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			_g_free0 (data);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			g_clear_error (&_inner_error_);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			return;
#line 705 "function-manager.c"
		}
	}
	goto __finally14;
	__catch14_g_file_error:
	{
		GError* e = NULL;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		e = _inner_error_;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_inner_error_ = NULL;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_error_free0 (e);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (data);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		return;
#line 722 "function-manager.c"
	}
	__finally14:
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (data);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		g_clear_error (&_inner_error_);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		return;
#line 735 "function-manager.c"
	}
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp2_ = data;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "\n", 0);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	lines = _tmp4_;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	lines_length1 = _vala_array_length (_tmp3_);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_lines_size_ = lines_length1;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp5_ = lines;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp5__length1 = lines_length1;
#line 751 "function-manager.c"
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		line_collection = _tmp5_;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		line_collection_length1 = _tmp5__length1;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		for (line_it = 0; line_it < _tmp5__length1; line_it = line_it + 1) {
#line 763 "function-manager.c"
			gchar* _tmp6_ = NULL;
			gchar* line = NULL;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			_tmp6_ = g_strdup (line_collection[line_it]);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			line = _tmp6_;
#line 770 "function-manager.c"
			{
				MathFunction* function = NULL;
				const gchar* _tmp7_ = NULL;
				MathFunction* _tmp8_ = NULL;
				MathFunction* _tmp9_ = NULL;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
				_tmp7_ = line;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
				_tmp8_ = function_manager_parse_function_from_string (self, _tmp7_);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
				function = _tmp8_;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
				_tmp9_ = function;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
				if (_tmp9_ != NULL) {
#line 786 "function-manager.c"
					GHashTable* _tmp10_ = NULL;
					MathFunction* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					MathFunction* _tmp15_ = NULL;
					MathFunction* _tmp16_ = NULL;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp10_ = self->priv->functions;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp11_ = function;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp12_ = math_function_get_name (_tmp11_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp13_ = _tmp12_;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp14_ = g_strdup (_tmp13_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp15_ = function;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp16_ = _g_object_ref0 (_tmp15_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					g_hash_table_insert (_tmp10_, _tmp14_, _tmp16_);
#line 810 "function-manager.c"
				}
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
				_g_object_unref0 (function);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
				_g_free0 (line);
#line 816 "function-manager.c"
			}
		}
	}
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (data);
#line 824 "function-manager.c"
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 920 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 921 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 921 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 921 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 921 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 923 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 923 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 849 "function-manager.c"
		gchar* _tmp4_ = NULL;
#line 924 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 924 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 924 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 857 "function-manager.c"
	} else {
#line 926 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = -1;
#line 926 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 863 "function-manager.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 887 "function-manager.c"
		glong _tmp4_ = 0L;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 895 "function-manager.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 907 "function-manager.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 931 "function-manager.c"
		glong _tmp2_ = 0L;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 937 "function-manager.c"
	} else {
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 941 "function-manager.c"
	}
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 945 "function-manager.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 957 "function-manager.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 967 "function-manager.c"
	}
#line 1217 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 973 "function-manager.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 987 "function-manager.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 997 "function-manager.c"
	}
#line 1223 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 1003 "function-manager.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 1012 "function-manager.c"
	}
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 1032 "function-manager.c"
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 1055 "function-manager.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1068 "function-manager.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1099 "function-manager.c"
				goto __catch15_g_regex_error;
			}
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 1108 "function-manager.c"
		}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1124 "function-manager.c"
				goto __catch15_g_regex_error;
			}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 1135 "function-manager.c"
		}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1149 "function-manager.c"
	}
	goto __finally15;
	__catch15_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1163 "function-manager.c"
	}
	__finally15:
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return NULL;
#line 1174 "function-manager.c"
	}
}


static MathFunction* function_manager_parse_function_from_string (FunctionManager* self, const gchar* data) {
	MathFunction* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint i = 0;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* left = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* right = NULL;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_ = NULL;
	gchar* expression = NULL;
	gchar* _tmp19_ = NULL;
	gchar* description = NULL;
	gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	const gchar* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	gchar* name = NULL;
	const gchar* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* argument_list = NULL;
	const gchar* _tmp46_ = NULL;
	gint _tmp47_ = 0;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gboolean _tmp52_ = FALSE;
	const gchar* _tmp53_ = NULL;
	const gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gchar** arguments = NULL;
	const gchar* _tmp57_ = NULL;
	gchar** _tmp58_ = NULL;
	gchar** _tmp59_ = NULL;
	gint arguments_length1 = 0;
	gint _arguments_size_ = 0;
	const gchar* _tmp60_ = NULL;
	gchar** _tmp61_ = NULL;
	gint _tmp61__length1 = 0;
	const gchar* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
	MathFunction* _tmp64_ = NULL;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp0_ = data;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp0_ == NULL) {
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		result = NULL;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		return result;
#line 1253 "function-manager.c"
	}
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp1_ = data;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp2_ = string_index_of_char (_tmp1_, (gunichar) '=', 0);
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	i = _tmp2_;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp3_ = i;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp3_ < 0) {
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		result = NULL;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		return result;
#line 1269 "function-manager.c"
	}
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp4_ = data;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp5_ = i;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp6_ = string_substring (_tmp4_, (glong) 0, (glong) _tmp5_);
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp7_ = _tmp6_;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp8_ = string_strip (_tmp7_);
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp9_ = _tmp8_;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (_tmp7_);
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	left = _tmp9_;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp10_ = data;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp11_ = i;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp12_ = string_substring (_tmp10_, (glong) (_tmp11_ + 1), (glong) (-1));
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp13_ = _tmp12_;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp14_ = string_strip (_tmp13_);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp15_ = _tmp14_;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (_tmp13_);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	right = _tmp15_;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp17_ = left;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp17_ == NULL) {
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp16_ = TRUE;
#line 1309 "function-manager.c"
	} else {
		const gchar* _tmp18_ = NULL;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp18_ = right;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp16_ = _tmp18_ == NULL;
#line 1316 "function-manager.c"
	}
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp16_) {
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		result = NULL;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (right);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (left);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		return result;
#line 1328 "function-manager.c"
	}
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp19_ = g_strdup ("");
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	expression = _tmp19_;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp20_ = g_strdup ("");
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	description = _tmp20_;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp21_ = right;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp22_ = string_index_of_char (_tmp21_, (gunichar) '@', 0);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	i = _tmp22_;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp23_ = i;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp23_ < 0) {
#line 1348 "function-manager.c"
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp24_ = right;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp25_ = g_strdup (_tmp24_);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (expression);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		expression = _tmp25_;
#line 1359 "function-manager.c"
	} else {
		const gchar* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp26_ = right;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp27_ = i;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp28_ = string_substring (_tmp26_, (glong) 0, (glong) _tmp27_);
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp29_ = _tmp28_;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp30_ = string_strip (_tmp29_);
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (expression);
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		expression = _tmp30_;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (_tmp29_);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp31_ = right;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp32_ = i;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp33_ = string_substring (_tmp31_, (glong) (_tmp32_ + 1), (glong) (-1));
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp34_ = _tmp33_;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp35_ = string_strip (_tmp34_);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (description);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		description = _tmp35_;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (_tmp34_);
#line 1403 "function-manager.c"
	}
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp36_ = expression;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp36_ == NULL) {
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		result = NULL;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (description);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (expression);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (right);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (left);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		return result;
#line 1421 "function-manager.c"
	}
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp37_ = left;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp38_ = string_index_of_char (_tmp37_, (gunichar) '(', 0);
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	i = _tmp38_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp39_ = i;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp39_ < 0) {
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		result = NULL;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (description);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (expression);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (right);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (left);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		return result;
#line 1445 "function-manager.c"
	}
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp40_ = left;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp41_ = i;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp42_ = string_substring (_tmp40_, (glong) 0, (glong) _tmp41_);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp43_ = _tmp42_;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp44_ = string_strip (_tmp43_);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp45_ = _tmp44_;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (_tmp43_);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	name = _tmp45_;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp46_ = left;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp47_ = i;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp48_ = string_substring (_tmp46_, (glong) (_tmp47_ + 1), (glong) (-1));
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp49_ = _tmp48_;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp50_ = string_strip (_tmp49_);
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp51_ = _tmp50_;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (_tmp49_);
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	argument_list = _tmp51_;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp53_ = name;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp53_ == NULL) {
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp52_ = TRUE;
#line 1485 "function-manager.c"
	} else {
		const gchar* _tmp54_ = NULL;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp54_ = argument_list;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp52_ = _tmp54_ == NULL;
#line 1492 "function-manager.c"
	}
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp52_) {
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		result = NULL;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (argument_list);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (name);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (description);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (expression);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (right);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (left);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		return result;
#line 1512 "function-manager.c"
	}
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp55_ = argument_list;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp56_ = string_replace (_tmp55_, ")", "");
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (argument_list);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	argument_list = _tmp56_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp57_ = argument_list;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp59_ = _tmp58_ = g_strsplit_set (_tmp57_, ";", 0);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	arguments = _tmp59_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	arguments_length1 = _vala_array_length (_tmp58_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_arguments_size_ = arguments_length1;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp60_ = name;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp61_ = arguments;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp61__length1 = arguments_length1;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp62_ = expression;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp63_ = description;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp64_ = math_function_new (_tmp60_, _tmp61_, _tmp61__length1, _tmp62_, _tmp63_);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	result = _tmp64_;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (argument_list);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (name);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (description);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (expression);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (right);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (left);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	return result;
#line 1562 "function-manager.c"
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 964 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = separator;
#line 964 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_ == NULL) {
#line 965 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		separator = "";
#line 1579 "function-manager.c"
	}
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = str_array;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3__length1 = str_array_length1;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = TRUE;
#line 1589 "function-manager.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = str_array;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4__length1 = str_array_length1;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp4__length1 > 0;
#line 1599 "function-manager.c"
	}
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp2_) {
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1605 "function-manager.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str_array;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6__length1 = str_array_length1;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_tmp6__length1 == (-1)) {
#line 1616 "function-manager.c"
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp7_ = str_array;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp7__length1 = str_array_length1;
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp8_ = _tmp7_[0];
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp5_ = _tmp8_ != NULL;
#line 1628 "function-manager.c"
		} else {
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 1632 "function-manager.c"
		}
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = _tmp5_;
#line 1636 "function-manager.c"
	}
#line 967 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 1640 "function-manager.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
#line 969 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 1663 "function-manager.c"
		{
			gboolean _tmp9_ = FALSE;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			i = 0;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp9_ = TRUE;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 1672 "function-manager.c"
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!_tmp9_) {
#line 1685 "function-manager.c"
					gint _tmp10_ = 0;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp10_ = i;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					i = _tmp10_ + 1;
#line 1691 "function-manager.c"
				}
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp9_ = FALSE;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp13_ = str_array;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp13__length1 = str_array_length1;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp13__length1 != (-1)) {
#line 1701 "function-manager.c"
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp14_ = i;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp15_ = str_array;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp15__length1 = str_array_length1;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp14_ < _tmp15__length1;
#line 1713 "function-manager.c"
				} else {
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp12_ = FALSE;
#line 1717 "function-manager.c"
				}
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp12_) {
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp11_ = TRUE;
#line 1723 "function-manager.c"
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp17_ = str_array;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp17__length1 = str_array_length1;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					if (_tmp17__length1 == (-1)) {
#line 1734 "function-manager.c"
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp18_ = str_array;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp18__length1 = str_array_length1;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp19_ = i;
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp20_ = _tmp18_[_tmp19_];
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp16_ = _tmp20_ != NULL;
#line 1749 "function-manager.c"
					} else {
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp16_ = FALSE;
#line 1753 "function-manager.c"
					}
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp11_ = _tmp16_;
#line 1757 "function-manager.c"
				}
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!_tmp11_) {
#line 970 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					break;
#line 1763 "function-manager.c"
				}
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp22_ = str_array;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp22__length1 = str_array_length1;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp23_ = i;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp24_ = _tmp22_[_tmp23_];
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp24_ != NULL) {
#line 1775 "function-manager.c"
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp25_ = str_array;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp25__length1 = str_array_length1;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp26_ = i;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp27_ = _tmp25_[_tmp26_];
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp28_ = strlen ((const gchar*) _tmp27_);
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp29_ = _tmp28_;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp21_ = _tmp29_;
#line 1796 "function-manager.c"
				} else {
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp21_ = 0;
#line 1800 "function-manager.c"
				}
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp30_ = len;
#line 971 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				len = _tmp30_ + _tmp21_;
#line 1806 "function-manager.c"
			}
		}
#line 973 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp31_ = i;
#line 973 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_tmp31_ == 0) {
#line 1813 "function-manager.c"
			gchar* _tmp32_ = NULL;
#line 974 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp32_ = g_strdup ("");
#line 974 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			result = _tmp32_;
#line 974 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return result;
#line 1821 "function-manager.c"
		}
#line 976 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp33_ = i;
#line 976 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp33_;
#line 976 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp34_ = str_array_length1;
#line 977 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp35_ = len;
#line 977 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp36_ = separator;
#line 977 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp37_ = strlen ((const gchar*) _tmp36_);
#line 977 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp38_ = _tmp37_;
#line 977 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp39_ = i;
#line 977 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
#line 979 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp40_ = len;
#line 979 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp41_ = g_malloc (_tmp40_);
#line 979 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		res = _tmp41_;
#line 980 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp42_ = res;
#line 980 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp43_ = str_array;
#line 980 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp43__length1 = str_array_length1;
#line 980 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp44_ = _tmp43_[0];
#line 980 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
#line 980 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		ptr = _tmp45_;
#line 1859 "function-manager.c"
		{
			gboolean _tmp46_ = FALSE;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			i = 1;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp46_ = TRUE;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 1868 "function-manager.c"
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!_tmp46_) {
#line 1884 "function-manager.c"
					gint _tmp47_ = 0;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp47_ = i;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					i = _tmp47_ + 1;
#line 1890 "function-manager.c"
				}
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp46_ = FALSE;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp48_ = i;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp49_ = str_array;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp49__length1 = str_array_length1;
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!(_tmp48_ < _tmp49__length1)) {
#line 981 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					break;
#line 1904 "function-manager.c"
				}
#line 982 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp50_ = ptr;
#line 982 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp51_ = separator;
#line 982 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
#line 982 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				ptr = _tmp52_;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp54_ = str_array;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp54__length1 = str_array_length1;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp55_ = i;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp56_ = _tmp54_[_tmp55_];
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp56_ != NULL) {
#line 1924 "function-manager.c"
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp57_ = str_array;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp57__length1 = str_array_length1;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp58_ = i;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp59_ = _tmp57_[_tmp58_];
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp53_ = (const gchar*) _tmp59_;
#line 1939 "function-manager.c"
				} else {
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp53_ = "";
#line 1943 "function-manager.c"
				}
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp60_ = ptr;
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
#line 983 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				ptr = _tmp61_;
#line 1951 "function-manager.c"
			}
		}
#line 986 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp62_ = res;
#line 986 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		res = NULL;
#line 986 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp62_;
#line 986 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1962 "function-manager.c"
	} else {
		gchar* _tmp63_ = NULL;
#line 988 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp63_ = g_strdup ("");
#line 988 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp63_;
#line 988 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1971 "function-manager.c"
	}
}


static void function_manager_save (FunctionManager* self) {
	gchar* data = NULL;
	gchar* _tmp0_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp1_ = NULL;
	gchar* name = NULL;
	MathFunction* math_function = NULL;
	gchar* dir = NULL;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	GError * _inner_error_ = NULL;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_if_fail (self != NULL);
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp0_ = g_strdup ("");
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	data = _tmp0_;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp1_ = self->priv->functions;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_hash_table_iter_init (&iter, _tmp1_);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	while (TRUE) {
#line 1999 "function-manager.c"
		gconstpointer _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gchar* _tmp5_ = NULL;
		MathFunction* _tmp6_ = NULL;
		MathFunction* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp9_ = NULL;
		MathFunction* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		MathFunction* _tmp13_ = NULL;
		gchar** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		gchar** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		MathFunction* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		MathFunction* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp4_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp2_), (gpointer*) (&_tmp3_));
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (name);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp5_ = g_strdup (_tmp2_);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		name = _tmp5_;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_object_unref0 (math_function);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp6_ = _g_object_ref0 (_tmp3_);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		math_function = _tmp6_;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		if (!_tmp4_) {
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			break;
#line 2045 "function-manager.c"
		}
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp7_ = math_function;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp8_ = math_function_is_custom_function (_tmp7_);
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		if (!_tmp8_) {
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			continue;
#line 2055 "function-manager.c"
		}
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp9_ = data;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp10_ = math_function;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp11_ = math_function_get_name (_tmp10_);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp12_ = _tmp11_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp13_ = math_function;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp14_ = math_function_get_arguments (_tmp13_, &_tmp14__length1);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp15_ = _tmp14_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp15__length1 = _tmp14__length1;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp16_ = _vala_g_strjoinv (";", _tmp15_, _tmp15__length1);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp17_ = _tmp16_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp18_ = math_function;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp19_ = math_function_get_expression (_tmp18_);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp20_ = _tmp19_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp21_ = math_function;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp22_ = math_function_get_description (_tmp21_);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp23_ = _tmp22_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp24_ = g_strdup_printf ("%s(%s)=%s@%s\n", _tmp12_, _tmp17_, _tmp20_, _tmp23_);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp25_ = _tmp24_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp26_ = g_strconcat (_tmp9_, _tmp25_, NULL);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (data);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		data = _tmp26_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (_tmp25_);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (_tmp17_);
#line 2103 "function-manager.c"
	}
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp27_ = self->priv->file_name;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp28_ = g_path_get_dirname (_tmp27_);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	dir = _tmp28_;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_mkdir_with_parents (dir, 0700);
#line 2113 "function-manager.c"
	{
		const gchar* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp29_ = self->priv->file_name;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp30_ = data;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		g_file_set_contents (_tmp29_, _tmp30_, (gssize) (-1), &_inner_error_);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 2127 "function-manager.c"
				goto __catch16_g_file_error;
			}
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			_g_free0 (dir);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			_g_object_unref0 (math_function);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			_g_free0 (name);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			_g_free0 (data);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			g_clear_error (&_inner_error_);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			return;
#line 2144 "function-manager.c"
		}
	}
	goto __finally16;
	__catch16_g_file_error:
	{
		GError* e = NULL;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		e = _inner_error_;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_inner_error_ = NULL;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_error_free0 (e);
#line 2157 "function-manager.c"
	}
	__finally16:
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (dir);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_object_unref0 (math_function);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (name);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (data);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		g_clear_error (&_inner_error_);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		return;
#line 2176 "function-manager.c"
	}
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (dir);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (math_function);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (name);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (data);
#line 2186 "function-manager.c"
}


static gchar** _vala_array_dup16 (gchar** self, int length) {
	gchar** result;
	int i;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	result = g_new0 (gchar*, length + 1);
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	for (i = 0; i < length; i++) {
#line 2197 "function-manager.c"
		gchar* _tmp0_ = NULL;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp0_ = g_strdup (self[i]);
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		result[i] = _tmp0_;
#line 2203 "function-manager.c"
	}
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	return result;
#line 2207 "function-manager.c"
}


static gchar** function_manager_array_sort_string (FunctionManager* self, gchar** array, int array_length1, int* result_length1) {
	gchar** result = NULL;
	gboolean swapped = FALSE;
	gint _tmp0_ = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	const gchar* _tmp3_ = NULL;
	gint j = 0;
	gchar* tmp = NULL;
	gchar** _tmp33_ = NULL;
	gint _tmp33__length1 = 0;
	gchar** _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	gchar** _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	swapped = TRUE;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp1_ = array;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp1__length1 = array_length1;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp2_ = array;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp2__length1 = array_length1;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp3_ = _tmp1_[_tmp2__length1 - 1];
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp3_ == NULL) {
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp0_ = 1;
#line 2246 "function-manager.c"
	} else {
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp0_ = 0;
#line 2250 "function-manager.c"
	}
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	j = _tmp0_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	while (TRUE) {
#line 2256 "function-manager.c"
		gboolean _tmp4_ = FALSE;
		gint _tmp5_ = 0;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp4_ = swapped;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		if (!_tmp4_) {
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			break;
#line 2265 "function-manager.c"
		}
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		swapped = FALSE;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp5_ = j;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		j = _tmp5_ + 1;
#line 2273 "function-manager.c"
		{
			gint i = 0;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			i = 0;
#line 2278 "function-manager.c"
			{
				gboolean _tmp6_ = FALSE;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
				_tmp6_ = TRUE;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
				while (TRUE) {
#line 2285 "function-manager.c"
					gint _tmp8_ = 0;
					gchar** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					gchar** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					gint _tmp12_ = 0;
					const gchar* _tmp13_ = NULL;
					gchar** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gint _tmp15_ = 0;
					const gchar* _tmp16_ = NULL;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					if (!_tmp6_) {
#line 2300 "function-manager.c"
						gint _tmp7_ = 0;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp7_ = i;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						i = _tmp7_ + 1;
#line 2306 "function-manager.c"
					}
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp6_ = FALSE;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp8_ = i;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp9_ = array;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp9__length1 = array_length1;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp10_ = j;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					if (!(_tmp8_ < (_tmp9__length1 - _tmp10_))) {
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						break;
#line 2322 "function-manager.c"
					}
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp11_ = array;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp11__length1 = array_length1;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp12_ = i;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp13_ = _tmp11_[_tmp12_];
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp14_ = array;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp14__length1 = array_length1;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp15_ = i;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp16_ = _tmp14_[_tmp15_ + 1];
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					if (g_strcmp0 (_tmp13_, _tmp16_) < 0) {
#line 2342 "function-manager.c"
						gchar** _tmp17_ = NULL;
						gint _tmp17__length1 = 0;
						gint _tmp18_ = 0;
						const gchar* _tmp19_ = NULL;
						gchar* _tmp20_ = NULL;
						gchar** _tmp21_ = NULL;
						gint _tmp21__length1 = 0;
						gint _tmp22_ = 0;
						gchar** _tmp23_ = NULL;
						gint _tmp23__length1 = 0;
						gint _tmp24_ = 0;
						const gchar* _tmp25_ = NULL;
						gchar* _tmp26_ = NULL;
						gchar* _tmp27_ = NULL;
						gchar** _tmp28_ = NULL;
						gint _tmp28__length1 = 0;
						gint _tmp29_ = 0;
						const gchar* _tmp30_ = NULL;
						gchar* _tmp31_ = NULL;
						gchar* _tmp32_ = NULL;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp17_ = array;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp17__length1 = array_length1;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp18_ = i;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp19_ = _tmp17_[_tmp18_];
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp20_ = g_strdup (_tmp19_);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_g_free0 (tmp);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						tmp = _tmp20_;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp21_ = array;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp21__length1 = array_length1;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp22_ = i;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp23_ = array;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp23__length1 = array_length1;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp24_ = i;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp25_ = _tmp23_[_tmp24_ + 1];
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp26_ = g_strdup (_tmp25_);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_g_free0 (_tmp21_[_tmp22_]);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp21_[_tmp22_] = _tmp26_;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp27_ = _tmp21_[_tmp22_];
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp28_ = array;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp28__length1 = array_length1;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp29_ = i;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp30_ = tmp;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp31_ = g_strdup (_tmp30_);
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_g_free0 (_tmp28_[_tmp29_ + 1]);
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp28_[_tmp29_ + 1] = _tmp31_;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp32_ = _tmp28_[_tmp29_ + 1];
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						swapped = TRUE;
#line 2417 "function-manager.c"
					}
				}
			}
		}
	}
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp33_ = array;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp33__length1 = array_length1;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp34_ = (_tmp33_ != NULL) ? _vala_array_dup16 (_tmp33_, _tmp33__length1) : ((gpointer) _tmp33_);
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp34__length1 = _tmp33__length1;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp35_ = _tmp34_;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp35__length1 = _tmp34__length1;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (result_length1) {
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		*result_length1 = _tmp35__length1;
#line 2439 "function-manager.c"
	}
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	result = _tmp35_;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (tmp);
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	return result;
#line 2447 "function-manager.c"
}


gchar** function_manager_get_names (FunctionManager* self, int* result_length1) {
	gchar** result = NULL;
	gchar** names = NULL;
	GHashTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gchar** _tmp2_ = NULL;
	gint names_length1 = 0;
	gint _names_size_ = 0;
	GHashTableIter iter = {0};
	GHashTable* _tmp3_ = NULL;
	gint i = 0;
	gchar* name = NULL;
	MathFunction* definition = NULL;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gint _tmp16_ = 0;
	gchar* _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint _tmp19_ = 0;
	gchar** _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp0_ = self->priv->functions;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp1_ = g_hash_table_size (_tmp0_);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp2_ = g_new0 (gchar*, (_tmp1_ + 1) + 1);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	names = _tmp2_;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	names_length1 = _tmp1_ + 1;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_names_size_ = names_length1;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp3_ = self->priv->functions;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_hash_table_iter_init (&iter, _tmp3_);
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	i = 0;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	while (TRUE) {
#line 2496 "function-manager.c"
		gconstpointer _tmp4_ = NULL;
		gconstpointer _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gchar* _tmp7_ = NULL;
		MathFunction* _tmp8_ = NULL;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		gint _tmp10_ = 0;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp6_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp4_), (gpointer*) (&_tmp5_));
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (name);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp7_ = g_strdup (_tmp4_);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		name = _tmp7_;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_object_unref0 (definition);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp8_ = _g_object_ref0 (_tmp5_);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		definition = _tmp8_;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		if (!_tmp6_) {
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			break;
#line 2527 "function-manager.c"
		}
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp9_ = names;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp9__length1 = names_length1;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp10_ = i;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp11_ = name;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp12_ = g_strdup (_tmp11_);
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (_tmp9_[_tmp10_]);
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp9_[_tmp10_] = _tmp12_;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp13_ = _tmp9_[_tmp10_];
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp14_ = i;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		i = _tmp14_ + 1;
#line 2549 "function-manager.c"
	}
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp15_ = names;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp15__length1 = names_length1;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp16_ = i;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (_tmp15_[_tmp16_]);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp15_[_tmp16_] = NULL;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp17_ = _tmp15_[_tmp16_];
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp18_ = names;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp18__length1 = names_length1;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp20_ = function_manager_array_sort_string (self, _tmp18_, _tmp18__length1, &_tmp19_);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp21_ = _tmp20_;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp21__length1 = _tmp19_;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (result_length1) {
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		*result_length1 = _tmp21__length1;
#line 2577 "function-manager.c"
	}
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	result = _tmp21_;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (definition);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (name);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	return result;
#line 2589 "function-manager.c"
}


static gboolean function_manager_add (FunctionManager* self, MathFunction* new_function) {
	gboolean result = FALSE;
	MathFunction* existing_function = NULL;
	MathFunction* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	MathFunction* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	MathFunction* _tmp5_ = NULL;
	MathFunction* _tmp8_ = NULL;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (new_function != NULL, FALSE);
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp0_ = new_function;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp1_ = math_function_get_name (_tmp0_);
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp2_ = _tmp1_;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp3_ = function_manager_get (self, _tmp2_);
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	existing_function = _tmp3_;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp5_ = existing_function;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp5_ != NULL) {
#line 2621 "function-manager.c"
		MathFunction* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp6_ = existing_function;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp7_ = math_function_is_custom_function (_tmp6_);
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp4_ = !_tmp7_;
#line 2630 "function-manager.c"
	} else {
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp4_ = FALSE;
#line 2634 "function-manager.c"
	}
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp4_) {
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		result = FALSE;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_object_unref0 (existing_function);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		return result;
#line 2644 "function-manager.c"
	}
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp8_ = existing_function;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp8_ != NULL) {
#line 2650 "function-manager.c"
		GHashTable* _tmp9_ = NULL;
		MathFunction* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		MathFunction* _tmp14_ = NULL;
		MathFunction* _tmp15_ = NULL;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp9_ = self->priv->functions;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp10_ = new_function;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp11_ = math_function_get_name (_tmp10_);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp12_ = _tmp11_;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp13_ = g_strdup (_tmp12_);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp14_ = new_function;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp15_ = _g_object_ref0 (_tmp14_);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		g_hash_table_replace (_tmp9_, _tmp13_, _tmp15_);
#line 2674 "function-manager.c"
	} else {
		GHashTable* _tmp16_ = NULL;
		MathFunction* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		MathFunction* _tmp21_ = NULL;
		MathFunction* _tmp22_ = NULL;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp16_ = self->priv->functions;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp17_ = new_function;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp18_ = math_function_get_name (_tmp17_);
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp19_ = _tmp18_;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp20_ = g_strdup (_tmp19_);
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp21_ = new_function;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp22_ = _g_object_ref0 (_tmp21_);
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		g_hash_table_insert (_tmp16_, _tmp20_, _tmp22_);
#line 2699 "function-manager.c"
	}
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	result = TRUE;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (existing_function);
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	return result;
#line 2707 "function-manager.c"
}


gboolean function_manager_add_function_with_properties (FunctionManager* self, const gchar* name, const gchar* arguments, const gchar* description, Parser* root_parser) {
	gboolean result = FALSE;
	gchar* function_string = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	MathFunction* new_function = NULL;
	const gchar* _tmp11_ = NULL;
	MathFunction* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	MathFunction* _tmp14_ = NULL;
	gboolean is_function_added = FALSE;
	MathFunction* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (arguments != NULL, FALSE);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (description != NULL, FALSE);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp0_ = name;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp1_ = g_strconcat (_tmp0_, "(", NULL);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp2_ = _tmp1_;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp3_ = arguments;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp5_ = _tmp4_;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp6_ = g_strconcat (_tmp5_, ")=", NULL);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp7_ = _tmp6_;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp8_ = description;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp10_ = _tmp9_;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (_tmp7_);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (_tmp5_);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (_tmp2_);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_string = _tmp10_;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp11_ = function_string;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp12_ = function_manager_parse_function_from_string (self, _tmp11_);
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	new_function = _tmp12_;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp14_ = new_function;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp14_ == NULL) {
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp13_ = TRUE;
#line 2784 "function-manager.c"
	} else {
		MathFunction* _tmp15_ = NULL;
		Parser* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp15_ = new_function;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp16_ = root_parser;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp17_ = math_function_validate (_tmp15_, _tmp16_);
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp13_ = _tmp17_ == FALSE;
#line 2797 "function-manager.c"
	}
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp13_) {
#line 2801 "function-manager.c"
		Parser* _tmp18_ = NULL;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp18_ = root_parser;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		parser_set_error (_tmp18_, ERROR_CODE_INVALID, NULL, (guint) 0, (guint) 0);
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		result = FALSE;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_object_unref0 (new_function);
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (function_string);
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		return result;
#line 2815 "function-manager.c"
	}
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp19_ = new_function;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp20_ = function_manager_add (self, _tmp19_);
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	is_function_added = _tmp20_;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp21_ = is_function_added;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp21_) {
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		function_manager_save (self);
#line 2829 "function-manager.c"
	}
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	result = is_function_added;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (new_function);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (function_string);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	return result;
#line 2839 "function-manager.c"
}


MathFunction* function_manager_get (FunctionManager* self, const gchar* name) {
	MathFunction* result = NULL;
	MathFunction* function = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	MathFunction* _tmp3_ = NULL;
	MathFunction* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gconstpointer _tmp9_ = NULL;
	MathFunction* _tmp10_ = NULL;
	MathFunction* _tmp11_ = NULL;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp0_ = self->priv->functions;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp1_ = name;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp3_ = _g_object_ref0 ((MathFunction*) _tmp2_);
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function = _tmp3_;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp4_ = function;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp4_ != NULL) {
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		result = function;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		return result;
#line 2880 "function-manager.c"
	}
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp5_ = self->priv->functions;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp6_ = name;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) (-1));
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp8_ = _tmp7_;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp9_ = g_hash_table_lookup (_tmp5_, _tmp8_);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp10_ = _g_object_ref0 ((MathFunction*) _tmp9_);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp11_ = _tmp10_;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (_tmp8_);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	result = _tmp11_;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (function);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	return result;
#line 2904 "function-manager.c"
}


void function_manager_delete (FunctionManager* self, const gchar* name) {
	MathFunction* function = NULL;
	const gchar* _tmp0_ = NULL;
	MathFunction* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	MathFunction* _tmp3_ = NULL;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_if_fail (self != NULL);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_if_fail (name != NULL);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp0_ = name;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp1_ = function_manager_get (self, _tmp0_);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function = _tmp1_;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp3_ = function;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp3_ != NULL) {
#line 2928 "function-manager.c"
		MathFunction* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp4_ = function;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp5_ = math_function_is_custom_function (_tmp4_);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp2_ = _tmp5_;
#line 2937 "function-manager.c"
	} else {
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp2_ = FALSE;
#line 2941 "function-manager.c"
	}
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp2_) {
#line 2945 "function-manager.c"
		GHashTable* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp6_ = self->priv->functions;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp7_ = name;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		g_hash_table_remove (_tmp6_, _tmp7_);
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		function_manager_save (self);
#line 2956 "function-manager.c"
	}
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (function);
#line 2960 "function-manager.c"
}


gboolean function_manager_is_function_defined (FunctionManager* self, const gchar* name) {
	gboolean result = FALSE;
	gchar* lower_name = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GHashTable* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp0_ = name;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) (-1));
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	lower_name = _tmp1_;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp3_ = lower_name;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp4_ = g_str_has_prefix (_tmp3_, "log");
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp4_) {
#line 2992 "function-manager.c"
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp5_ = lower_name;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp6_ = string_substring (_tmp5_, (glong) 3, (glong) (-1));
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp7_ = _tmp6_;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp8_ = sub_atoi (_tmp7_);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp2_ = _tmp8_ >= 0;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (_tmp7_);
#line 3009 "function-manager.c"
	} else {
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp2_ = FALSE;
#line 3013 "function-manager.c"
	}
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp2_) {
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		result = TRUE;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (lower_name);
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		return result;
#line 3023 "function-manager.c"
	}
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp10_ = self->priv->functions;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp11_ = name;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp12_ = g_hash_table_contains (_tmp10_, _tmp11_);
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp12_) {
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp9_ = TRUE;
#line 3035 "function-manager.c"
	} else {
		GHashTable* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp13_ = self->priv->functions;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp14_ = lower_name;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp15_ = g_hash_table_contains (_tmp13_, _tmp14_);
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp9_ = _tmp15_;
#line 3048 "function-manager.c"
	}
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	result = _tmp9_;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (lower_name);
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	return result;
#line 3056 "function-manager.c"
}


static Number** _vala_array_dup17 (Number** self, int length) {
	Number** result;
	int i;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	result = g_new0 (Number*, length + 1);
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	for (i = 0; i < length; i++) {
#line 3067 "function-manager.c"
		Number* _tmp0_ = NULL;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp0_ = _g_object_ref0 (self[i]);
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		result[i] = _tmp0_;
#line 3073 "function-manager.c"
	}
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	return result;
#line 3077 "function-manager.c"
}


static void _vala_array_add4 (Number*** array, int* length, int* size, Number* value) {
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if ((*length) == (*size)) {
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		*array = g_renew (Number*, *array, (*size) + 1);
#line 3088 "function-manager.c"
	}
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	(*array)[(*length)++] = value;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	(*array)[*length] = NULL;
#line 3094 "function-manager.c"
}


Number* function_manager_evaluate_function (FunctionManager* self, const gchar* name, Number** arguments, int arguments_length1, Parser* parser) {
	Number* result = NULL;
	gchar* lower_name = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	Number** args = NULL;
	Number** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	Number** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	MathFunction* function = NULL;
	const gchar* _tmp20_ = NULL;
	MathFunction* _tmp21_ = NULL;
	MathFunction* _tmp22_ = NULL;
	MathFunction* _tmp24_ = NULL;
	Number** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	Parser* _tmp26_ = NULL;
	Number* _tmp27_ = NULL;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (parser != NULL, NULL);
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp0_ = name;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) (-1));
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	lower_name = _tmp1_;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp2_ = arguments;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp2__length1 = arguments_length1;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup17 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp3__length1 = _tmp2__length1;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	args = _tmp3_;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	args_length1 = _tmp3__length1;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_args_size_ = args_length1;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp5_ = lower_name;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp6_ = g_str_has_prefix (_tmp5_, "log");
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp6_) {
#line 3154 "function-manager.c"
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp7_ = lower_name;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp8_ = string_substring (_tmp7_, (glong) 3, (glong) (-1));
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp9_ = _tmp8_;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp10_ = sub_atoi (_tmp9_);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp4_ = _tmp10_ > 0;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (_tmp9_);
#line 3171 "function-manager.c"
	} else {
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp4_ = FALSE;
#line 3175 "function-manager.c"
	}
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp4_) {
#line 3179 "function-manager.c"
		Number* log_base = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp11_ = lower_name;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp12_ = string_substring (_tmp11_, (glong) 3, (glong) (-1));
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp13_ = _tmp12_;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp14_ = sub_atoi (_tmp13_);
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp15_ = number_new_integer ((gint64) _tmp14_);
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp16_ = _tmp15_;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (_tmp13_);
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		log_base = _tmp16_;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp17_ = args;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp17__length1 = args_length1;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp18_ = log_base;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp19_ = _g_object_ref0 (_tmp18_);
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_vala_array_add4 (&args, &args_length1, &_args_size_, _tmp19_);
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		name = "log";
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_object_unref0 (log_base);
#line 3221 "function-manager.c"
	}
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp20_ = name;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp21_ = function_manager_get (self, _tmp20_);
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function = _tmp21_;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp22_ = function;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp22_ == NULL) {
#line 3233 "function-manager.c"
		Parser* _tmp23_ = NULL;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp23_ = parser;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		parser_set_error (_tmp23_, ERROR_CODE_UNKNOWN_FUNCTION, NULL, (guint) 0, (guint) 0);
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		result = NULL;
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_object_unref0 (function);
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (lower_name);
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		return result;
#line 3249 "function-manager.c"
	}
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp24_ = function;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp25_ = args;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp25__length1 = args_length1;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp26_ = parser;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp27_ = math_function_evaluate (_tmp24_, _tmp25_, _tmp25__length1, _tmp26_);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	result = _tmp27_;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (function);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (lower_name);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	return result;
#line 3271 "function-manager.c"
}


static MathFunction** _vala_array_dup18 (MathFunction** self, int length) {
	MathFunction** result;
	int i;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	result = g_new0 (MathFunction*, length + 1);
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	for (i = 0; i < length; i++) {
#line 3282 "function-manager.c"
		MathFunction* _tmp0_ = NULL;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp0_ = _g_object_ref0 (self[i]);
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		result[i] = _tmp0_;
#line 3288 "function-manager.c"
	}
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	return result;
#line 3292 "function-manager.c"
}


static MathFunction** function_manager_array_sort_math_function (FunctionManager* self, MathFunction** array, int array_length1, int* result_length1) {
	MathFunction** result = NULL;
	gboolean swapped = FALSE;
	gint _tmp0_ = 0;
	MathFunction** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	MathFunction** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	MathFunction* _tmp3_ = NULL;
	gint j = 0;
	MathFunction* tmp = NULL;
	MathFunction** _tmp37_ = NULL;
	gint _tmp37__length1 = 0;
	MathFunction** _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	MathFunction** _tmp39_ = NULL;
	gint _tmp39__length1 = 0;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	swapped = TRUE;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp1_ = array;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp1__length1 = array_length1;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp2_ = array;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp2__length1 = array_length1;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp3_ = _tmp1_[_tmp2__length1 - 1];
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp3_ == NULL) {
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp0_ = 1;
#line 3331 "function-manager.c"
	} else {
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp0_ = 0;
#line 3335 "function-manager.c"
	}
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	j = _tmp0_;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	while (TRUE) {
#line 3341 "function-manager.c"
		gboolean _tmp4_ = FALSE;
		gint _tmp5_ = 0;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp4_ = swapped;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		if (!_tmp4_) {
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			break;
#line 3350 "function-manager.c"
		}
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		swapped = FALSE;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp5_ = j;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		j = _tmp5_ + 1;
#line 3358 "function-manager.c"
		{
			gint i = 0;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			i = 0;
#line 3363 "function-manager.c"
			{
				gboolean _tmp6_ = FALSE;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
				_tmp6_ = TRUE;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
				while (TRUE) {
#line 3370 "function-manager.c"
					gint _tmp8_ = 0;
					MathFunction** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					MathFunction** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					gint _tmp12_ = 0;
					MathFunction* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					MathFunction** _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gint _tmp17_ = 0;
					MathFunction* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					if (!_tmp6_) {
#line 3389 "function-manager.c"
						gint _tmp7_ = 0;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp7_ = i;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						i = _tmp7_ + 1;
#line 3395 "function-manager.c"
					}
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp6_ = FALSE;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp8_ = i;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp9_ = array;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp9__length1 = array_length1;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp10_ = j;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					if (!(_tmp8_ < (_tmp9__length1 - _tmp10_))) {
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						break;
#line 3411 "function-manager.c"
					}
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp11_ = array;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp11__length1 = array_length1;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp12_ = i;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp13_ = _tmp11_[_tmp12_];
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp14_ = math_function_get_name (_tmp13_);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp15_ = _tmp14_;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp16_ = array;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp16__length1 = array_length1;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp17_ = i;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp18_ = _tmp16_[_tmp17_ + 1];
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp19_ = math_function_get_name (_tmp18_);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					_tmp20_ = _tmp19_;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
					if (g_strcmp0 (_tmp15_, _tmp20_) > 0) {
#line 3439 "function-manager.c"
						MathFunction** _tmp21_ = NULL;
						gint _tmp21__length1 = 0;
						gint _tmp22_ = 0;
						MathFunction* _tmp23_ = NULL;
						MathFunction* _tmp24_ = NULL;
						MathFunction** _tmp25_ = NULL;
						gint _tmp25__length1 = 0;
						gint _tmp26_ = 0;
						MathFunction** _tmp27_ = NULL;
						gint _tmp27__length1 = 0;
						gint _tmp28_ = 0;
						MathFunction* _tmp29_ = NULL;
						MathFunction* _tmp30_ = NULL;
						MathFunction* _tmp31_ = NULL;
						MathFunction** _tmp32_ = NULL;
						gint _tmp32__length1 = 0;
						gint _tmp33_ = 0;
						MathFunction* _tmp34_ = NULL;
						MathFunction* _tmp35_ = NULL;
						MathFunction* _tmp36_ = NULL;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp21_ = array;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp21__length1 = array_length1;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp22_ = i;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp23_ = _tmp21_[_tmp22_];
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp24_ = _g_object_ref0 (_tmp23_);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_g_object_unref0 (tmp);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						tmp = _tmp24_;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp25_ = array;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp25__length1 = array_length1;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp26_ = i;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp27_ = array;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp27__length1 = array_length1;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp28_ = i;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp29_ = _tmp27_[_tmp28_ + 1];
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp30_ = _g_object_ref0 (_tmp29_);
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_g_object_unref0 (_tmp25_[_tmp26_]);
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp25_[_tmp26_] = _tmp30_;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp31_ = _tmp25_[_tmp26_];
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp32_ = array;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp32__length1 = array_length1;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp33_ = i;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp34_ = tmp;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp35_ = _g_object_ref0 (_tmp34_);
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_g_object_unref0 (_tmp32_[_tmp33_ + 1]);
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp32_[_tmp33_ + 1] = _tmp35_;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						_tmp36_ = _tmp32_[_tmp33_ + 1];
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
						swapped = TRUE;
#line 3514 "function-manager.c"
					}
				}
			}
		}
	}
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp37_ = array;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp37__length1 = array_length1;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp38_ = (_tmp37_ != NULL) ? _vala_array_dup18 (_tmp37_, _tmp37__length1) : ((gpointer) _tmp37_);
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp38__length1 = _tmp37__length1;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp39_ = _tmp38_;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp39__length1 = _tmp38__length1;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (result_length1) {
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		*result_length1 = _tmp39__length1;
#line 3536 "function-manager.c"
	}
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	result = _tmp39_;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (tmp);
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	return result;
#line 3544 "function-manager.c"
}


static void _vala_array_add5 (MathFunction*** array, int* length, int* size, MathFunction* value) {
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if ((*length) == (*size)) {
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		*array = g_renew (MathFunction*, *array, (*size) + 1);
#line 3555 "function-manager.c"
	}
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	(*array)[(*length)++] = value;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	(*array)[*length] = NULL;
#line 3561 "function-manager.c"
}


MathFunction** function_manager_functions_eligible_for_autocompletion_for_text (FunctionManager* self, const gchar* display_text, int* result_length1) {
	MathFunction** result = NULL;
	MathFunction** eligible_functions = NULL;
	MathFunction** _tmp0_ = NULL;
	gint eligible_functions_length1 = 0;
	gint _eligible_functions_size_ = 0;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* display_text_case_insensitive = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp7_ = NULL;
	gchar* function_name = NULL;
	MathFunction* function = NULL;
	MathFunction** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp22_ = 0;
	MathFunction** _tmp23_ = NULL;
	MathFunction** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_return_val_if_fail (display_text != NULL, NULL);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp0_ = g_new0 (MathFunction*, 0 + 1);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	eligible_functions = _tmp0_;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	eligible_functions_length1 = 0;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_eligible_functions_size_ = eligible_functions_length1;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp1_ = display_text;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp2_ = strlen (_tmp1_);
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp3_ = _tmp2_;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (_tmp3_ <= 1) {
#line 3607 "function-manager.c"
		MathFunction** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp4_ = eligible_functions;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp4__length1 = eligible_functions_length1;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		if (result_length1) {
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			*result_length1 = _tmp4__length1;
#line 3618 "function-manager.c"
		}
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		result = _tmp4_;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		return result;
#line 3624 "function-manager.c"
	}
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp5_ = display_text;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) (-1));
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	display_text_case_insensitive = _tmp6_;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp7_ = self->priv->functions;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_hash_table_iter_init (&iter, _tmp7_);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	while (TRUE) {
#line 3638 "function-manager.c"
		gconstpointer _tmp8_ = NULL;
		gconstpointer _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gchar* _tmp11_ = NULL;
		MathFunction* _tmp12_ = NULL;
		gchar* function_name_case_insensitive = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp10_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp8_), (gpointer*) (&_tmp9_));
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (function_name);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp11_ = g_strdup (_tmp8_);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		function_name = _tmp11_;
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_object_unref0 (function);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp12_ = _g_object_ref0 (_tmp9_);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		function = _tmp12_;
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		if (!_tmp10_) {
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			break;
#line 3668 "function-manager.c"
		}
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp13_ = function_name;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) (-1));
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		function_name_case_insensitive = _tmp14_;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp15_ = function_name_case_insensitive;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp16_ = display_text_case_insensitive;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_tmp17_ = g_str_has_prefix (_tmp15_, _tmp16_);
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		if (_tmp17_) {
#line 3684 "function-manager.c"
			MathFunction** _tmp18_ = NULL;
			gint _tmp18__length1 = 0;
			MathFunction* _tmp19_ = NULL;
			MathFunction* _tmp20_ = NULL;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			_tmp18_ = eligible_functions;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			_tmp18__length1 = eligible_functions_length1;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			_tmp19_ = function;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			_tmp20_ = _g_object_ref0 (_tmp19_);
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
			_vala_array_add5 (&eligible_functions, &eligible_functions_length1, &_eligible_functions_size_, _tmp20_);
#line 3699 "function-manager.c"
		}
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		_g_free0 (function_name_case_insensitive);
#line 3703 "function-manager.c"
	}
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp21_ = eligible_functions;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp21__length1 = eligible_functions_length1;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp23_ = function_manager_array_sort_math_function (self, _tmp21_, _tmp21__length1, &_tmp22_);
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp24_ = _tmp23_;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_tmp24__length1 = _tmp22_;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	if (result_length1) {
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
		*result_length1 = _tmp24__length1;
#line 3719 "function-manager.c"
	}
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	result = _tmp24_;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (function);
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (function_name);
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (display_text_case_insensitive);
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	eligible_functions = (_vala_array_free (eligible_functions, eligible_functions_length1, (GDestroyNotify) g_object_unref), NULL);
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	return result;
#line 3733 "function-manager.c"
}


static void function_manager_class_init (FunctionManagerClass * klass) {
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	function_manager_parent_class = g_type_class_peek_parent (klass);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	g_type_class_add_private (klass, sizeof (FunctionManagerPrivate));
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	G_OBJECT_CLASS (klass)->finalize = function_manager_finalize;
#line 3744 "function-manager.c"
}


static void function_manager_instance_init (FunctionManager * self) {
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	self->priv = FUNCTION_MANAGER_GET_PRIVATE (self);
#line 3751 "function-manager.c"
}


static void function_manager_finalize (GObject* obj) {
	FunctionManager * self;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FUNCTION_MANAGER, FunctionManager);
#line 15 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_free0 (self->priv->file_name);
#line 16 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_hash_table_unref0 (self->priv->functions);
#line 17 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	_g_object_unref0 (self->priv->serializer);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/function-manager.vala"
	G_OBJECT_CLASS (function_manager_parent_class)->finalize (obj);
#line 3767 "function-manager.c"
}


GType function_manager_get_type (void) {
	static volatile gsize function_manager_type_id__volatile = 0;
	if (g_once_init_enter (&function_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionManager), 0, (GInstanceInitFunc) function_manager_instance_init, NULL };
		GType function_manager_type_id;
		function_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "FunctionManager", &g_define_type_info, 0);
		g_once_init_leave (&function_manager_type_id__volatile, function_manager_type_id);
	}
	return function_manager_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



