/* baobab-cellrenderers.c generated by valac 0.23.3, the Vala compiler
 * generated from baobab-cellrenderers.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Ryan Lortie <desrt@desrt.ca>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>


#define BAOBAB_TYPE_CELL_RENDERER_NAME (baobab_cell_renderer_name_get_type ())
#define BAOBAB_CELL_RENDERER_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CELL_RENDERER_NAME, BaobabCellRendererName))
#define BAOBAB_CELL_RENDERER_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CELL_RENDERER_NAME, BaobabCellRendererNameClass))
#define BAOBAB_IS_CELL_RENDERER_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CELL_RENDERER_NAME))
#define BAOBAB_IS_CELL_RENDERER_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CELL_RENDERER_NAME))
#define BAOBAB_CELL_RENDERER_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CELL_RENDERER_NAME, BaobabCellRendererNameClass))

typedef struct _BaobabCellRendererName BaobabCellRendererName;
typedef struct _BaobabCellRendererNameClass BaobabCellRendererNameClass;
typedef struct _BaobabCellRendererNamePrivate BaobabCellRendererNamePrivate;

#define BAOBAB_SCANNER_TYPE_STATE (baobab_scanner_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BAOBAB_TYPE_CELL_RENDERER_SIZE (baobab_cell_renderer_size_get_type ())
#define BAOBAB_CELL_RENDERER_SIZE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CELL_RENDERER_SIZE, BaobabCellRendererSize))
#define BAOBAB_CELL_RENDERER_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CELL_RENDERER_SIZE, BaobabCellRendererSizeClass))
#define BAOBAB_IS_CELL_RENDERER_SIZE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CELL_RENDERER_SIZE))
#define BAOBAB_IS_CELL_RENDERER_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CELL_RENDERER_SIZE))
#define BAOBAB_CELL_RENDERER_SIZE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CELL_RENDERER_SIZE, BaobabCellRendererSizeClass))

typedef struct _BaobabCellRendererSize BaobabCellRendererSize;
typedef struct _BaobabCellRendererSizeClass BaobabCellRendererSizeClass;
typedef struct _BaobabCellRendererSizePrivate BaobabCellRendererSizePrivate;

#define BAOBAB_TYPE_CELL_RENDERER_ITEMS (baobab_cell_renderer_items_get_type ())
#define BAOBAB_CELL_RENDERER_ITEMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CELL_RENDERER_ITEMS, BaobabCellRendererItems))
#define BAOBAB_CELL_RENDERER_ITEMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CELL_RENDERER_ITEMS, BaobabCellRendererItemsClass))
#define BAOBAB_IS_CELL_RENDERER_ITEMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CELL_RENDERER_ITEMS))
#define BAOBAB_IS_CELL_RENDERER_ITEMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CELL_RENDERER_ITEMS))
#define BAOBAB_CELL_RENDERER_ITEMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CELL_RENDERER_ITEMS, BaobabCellRendererItemsClass))

typedef struct _BaobabCellRendererItems BaobabCellRendererItems;
typedef struct _BaobabCellRendererItemsClass BaobabCellRendererItemsClass;
typedef struct _BaobabCellRendererItemsPrivate BaobabCellRendererItemsPrivate;

#define BAOBAB_TYPE_CELL_RENDERER_TIME (baobab_cell_renderer_time_get_type ())
#define BAOBAB_CELL_RENDERER_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CELL_RENDERER_TIME, BaobabCellRendererTime))
#define BAOBAB_CELL_RENDERER_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CELL_RENDERER_TIME, BaobabCellRendererTimeClass))
#define BAOBAB_IS_CELL_RENDERER_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CELL_RENDERER_TIME))
#define BAOBAB_IS_CELL_RENDERER_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CELL_RENDERER_TIME))
#define BAOBAB_CELL_RENDERER_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CELL_RENDERER_TIME, BaobabCellRendererTimeClass))

typedef struct _BaobabCellRendererTime BaobabCellRendererTime;
typedef struct _BaobabCellRendererTimeClass BaobabCellRendererTimeClass;
typedef struct _BaobabCellRendererTimePrivate BaobabCellRendererTimePrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define BAOBAB_TYPE_CELL_RENDERER_PROGRESS (baobab_cell_renderer_progress_get_type ())
#define BAOBAB_CELL_RENDERER_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CELL_RENDERER_PROGRESS, BaobabCellRendererProgress))
#define BAOBAB_CELL_RENDERER_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CELL_RENDERER_PROGRESS, BaobabCellRendererProgressClass))
#define BAOBAB_IS_CELL_RENDERER_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CELL_RENDERER_PROGRESS))
#define BAOBAB_IS_CELL_RENDERER_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CELL_RENDERER_PROGRESS))
#define BAOBAB_CELL_RENDERER_PROGRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CELL_RENDERER_PROGRESS, BaobabCellRendererProgressClass))

typedef struct _BaobabCellRendererProgress BaobabCellRendererProgress;
typedef struct _BaobabCellRendererProgressClass BaobabCellRendererProgressClass;
typedef struct _BaobabCellRendererProgressPrivate BaobabCellRendererProgressPrivate;

struct _BaobabCellRendererName {
	GtkCellRendererText parent_instance;
	BaobabCellRendererNamePrivate * priv;
};

struct _BaobabCellRendererNameClass {
	GtkCellRendererTextClass parent_class;
};

typedef enum  {
	BAOBAB_SCANNER_STATE_SCANNING,
	BAOBAB_SCANNER_STATE_CANCELLED,
	BAOBAB_SCANNER_STATE_NEED_PERCENT,
	BAOBAB_SCANNER_STATE_ERROR,
	BAOBAB_SCANNER_STATE_CHILD_ERROR,
	BAOBAB_SCANNER_STATE_DONE
} BaobabScannerState;

struct _BaobabCellRendererNamePrivate {
	BaobabScannerState _state;
};

struct _BaobabCellRendererSize {
	GtkCellRendererText parent_instance;
	BaobabCellRendererSizePrivate * priv;
};

struct _BaobabCellRendererSizeClass {
	GtkCellRendererTextClass parent_class;
};

struct _BaobabCellRendererSizePrivate {
	BaobabScannerState _state;
	gboolean _show_allocated_size;
};

struct _BaobabCellRendererItems {
	GtkCellRendererText parent_instance;
	BaobabCellRendererItemsPrivate * priv;
};

struct _BaobabCellRendererItemsClass {
	GtkCellRendererTextClass parent_class;
};

struct _BaobabCellRendererItemsPrivate {
	BaobabScannerState _state;
};

struct _BaobabCellRendererTime {
	GtkCellRendererText parent_instance;
	BaobabCellRendererTimePrivate * priv;
};

struct _BaobabCellRendererTimeClass {
	GtkCellRendererTextClass parent_class;
};

struct _BaobabCellRendererProgress {
	GtkCellRendererProgress parent_instance;
	BaobabCellRendererProgressPrivate * priv;
};

struct _BaobabCellRendererProgressClass {
	GtkCellRendererProgressClass parent_class;
};

struct _BaobabCellRendererProgressPrivate {
	BaobabScannerState _state;
};


static gpointer baobab_cell_renderer_name_parent_class = NULL;
static gpointer baobab_cell_renderer_size_parent_class = NULL;
static gpointer baobab_cell_renderer_items_parent_class = NULL;
static gpointer baobab_cell_renderer_time_parent_class = NULL;
static gpointer baobab_cell_renderer_progress_parent_class = NULL;

GType baobab_cell_renderer_name_get_type (void) G_GNUC_CONST;
GType baobab_scanner_state_get_type (void) G_GNUC_CONST;
#define BAOBAB_CELL_RENDERER_NAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_CELL_RENDERER_NAME, BaobabCellRendererNamePrivate))
enum  {
	BAOBAB_CELL_RENDERER_NAME_DUMMY_PROPERTY,
	BAOBAB_CELL_RENDERER_NAME_STATE,
	BAOBAB_CELL_RENDERER_NAME_NAME
};
static void baobab_cell_renderer_name_real_render (GtkCellRenderer* base, cairo_t* cr, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags);
BaobabScannerState baobab_cell_renderer_name_get_state (BaobabCellRendererName* self);
BaobabCellRendererName* baobab_cell_renderer_name_new (void);
BaobabCellRendererName* baobab_cell_renderer_name_construct (GType object_type);
void baobab_cell_renderer_name_set_state (BaobabCellRendererName* self, BaobabScannerState value);
void baobab_cell_renderer_name_set_name (BaobabCellRendererName* self, const gchar* value);
static void baobab_cell_renderer_name_finalize (GObject* obj);
static void _vala_baobab_cell_renderer_name_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_baobab_cell_renderer_name_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType baobab_cell_renderer_size_get_type (void) G_GNUC_CONST;
#define BAOBAB_CELL_RENDERER_SIZE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_CELL_RENDERER_SIZE, BaobabCellRendererSizePrivate))
enum  {
	BAOBAB_CELL_RENDERER_SIZE_DUMMY_PROPERTY,
	BAOBAB_CELL_RENDERER_SIZE_STATE,
	BAOBAB_CELL_RENDERER_SIZE_SIZE,
	BAOBAB_CELL_RENDERER_SIZE_ALLOC_SIZE,
	BAOBAB_CELL_RENDERER_SIZE_SHOW_ALLOCATED_SIZE
};
BaobabCellRendererSize* baobab_cell_renderer_size_new (void);
BaobabCellRendererSize* baobab_cell_renderer_size_construct (GType object_type);
BaobabScannerState baobab_cell_renderer_size_get_state (BaobabCellRendererSize* self);
void baobab_cell_renderer_size_set_state (BaobabCellRendererSize* self, BaobabScannerState value);
void baobab_cell_renderer_size_set_size (BaobabCellRendererSize* self, guint64 value);
static gboolean baobab_cell_renderer_size_get_show_allocated_size (BaobabCellRendererSize* self);
void baobab_cell_renderer_size_set_alloc_size (BaobabCellRendererSize* self, guint64 value);
void baobab_cell_renderer_size_set_show_allocated_size (BaobabCellRendererSize* self, gboolean value);
static void baobab_cell_renderer_size_finalize (GObject* obj);
static void _vala_baobab_cell_renderer_size_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_baobab_cell_renderer_size_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType baobab_cell_renderer_items_get_type (void) G_GNUC_CONST;
#define BAOBAB_CELL_RENDERER_ITEMS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_CELL_RENDERER_ITEMS, BaobabCellRendererItemsPrivate))
enum  {
	BAOBAB_CELL_RENDERER_ITEMS_DUMMY_PROPERTY,
	BAOBAB_CELL_RENDERER_ITEMS_STATE,
	BAOBAB_CELL_RENDERER_ITEMS_ITEMS
};
BaobabCellRendererItems* baobab_cell_renderer_items_new (void);
BaobabCellRendererItems* baobab_cell_renderer_items_construct (GType object_type);
BaobabScannerState baobab_cell_renderer_items_get_state (BaobabCellRendererItems* self);
void baobab_cell_renderer_items_set_state (BaobabCellRendererItems* self, BaobabScannerState value);
void baobab_cell_renderer_items_set_items (BaobabCellRendererItems* self, gint value);
static void baobab_cell_renderer_items_finalize (GObject* obj);
static void _vala_baobab_cell_renderer_items_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_baobab_cell_renderer_items_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType baobab_cell_renderer_time_get_type (void) G_GNUC_CONST;
enum  {
	BAOBAB_CELL_RENDERER_TIME_DUMMY_PROPERTY,
	BAOBAB_CELL_RENDERER_TIME_TIME
};
BaobabCellRendererTime* baobab_cell_renderer_time_new (void);
BaobabCellRendererTime* baobab_cell_renderer_time_construct (GType object_type);
void baobab_cell_renderer_time_set_time (BaobabCellRendererTime* self, guint64 value);
static void _vala_baobab_cell_renderer_time_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType baobab_cell_renderer_progress_get_type (void) G_GNUC_CONST;
#define BAOBAB_CELL_RENDERER_PROGRESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_CELL_RENDERER_PROGRESS, BaobabCellRendererProgressPrivate))
enum  {
	BAOBAB_CELL_RENDERER_PROGRESS_DUMMY_PROPERTY,
	BAOBAB_CELL_RENDERER_PROGRESS_STATE
};
static void baobab_cell_renderer_progress_real_render (GtkCellRenderer* base, cairo_t* cr, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags);
BaobabScannerState baobab_cell_renderer_progress_get_state (BaobabCellRendererProgress* self);
BaobabCellRendererProgress* baobab_cell_renderer_progress_new (void);
BaobabCellRendererProgress* baobab_cell_renderer_progress_construct (GType object_type);
void baobab_cell_renderer_progress_set_state (BaobabCellRendererProgress* self, BaobabScannerState value);
static void baobab_cell_renderer_progress_finalize (GObject* obj);
static void _vala_baobab_cell_renderer_progress_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_baobab_cell_renderer_progress_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void baobab_cell_renderer_name_real_render (GtkCellRenderer* base, cairo_t* cr, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags) {
	BaobabCellRendererName * self;
	GtkStyleContext* context = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GtkStyleContext* _tmp3_ = NULL;
	BaobabScannerState _tmp4_ = 0;
	cairo_t* _tmp7_ = NULL;
	GtkWidget* _tmp8_ = NULL;
	GdkRectangle _tmp9_ = {0};
	GdkRectangle _tmp10_ = {0};
	GtkCellRendererState _tmp11_ = 0;
	GtkStyleContext* _tmp12_ = NULL;
	self = (BaobabCellRendererName*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell_area != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_widget_get_style_context (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	context = _tmp2_;
	_tmp3_ = context;
	gtk_style_context_save (_tmp3_);
	_tmp4_ = self->priv->_state;
	switch (_tmp4_) {
		case BAOBAB_SCANNER_STATE_ERROR:
		{
			GtkStyleContext* _tmp5_ = NULL;
			_tmp5_ = context;
			gtk_style_context_add_class (_tmp5_, "baobab-cell-error");
			break;
		}
		case BAOBAB_SCANNER_STATE_CHILD_ERROR:
		{
			GtkStyleContext* _tmp6_ = NULL;
			_tmp6_ = context;
			gtk_style_context_add_class (_tmp6_, "baobab-cell-warning");
			break;
		}
		default:
		break;
	}
	_tmp7_ = cr;
	_tmp8_ = widget;
	_tmp9_ = *background_area;
	_tmp10_ = *cell_area;
	_tmp11_ = flags;
	GTK_CELL_RENDERER_CLASS (baobab_cell_renderer_name_parent_class)->render ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_CELL_RENDERER_TEXT, GtkCellRendererText), _tmp7_, _tmp8_, &_tmp9_, &_tmp10_, _tmp11_);
	_tmp12_ = context;
	gtk_style_context_restore (_tmp12_);
	_g_object_unref0 (context);
}


BaobabCellRendererName* baobab_cell_renderer_name_construct (GType object_type) {
	BaobabCellRendererName * self = NULL;
	self = (BaobabCellRendererName*) g_object_new (object_type, NULL);
	return self;
}


BaobabCellRendererName* baobab_cell_renderer_name_new (void) {
	return baobab_cell_renderer_name_construct (BAOBAB_TYPE_CELL_RENDERER_NAME);
}


BaobabScannerState baobab_cell_renderer_name_get_state (BaobabCellRendererName* self) {
	BaobabScannerState result;
	BaobabScannerState _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_state;
	result = _tmp0_;
	return result;
}


void baobab_cell_renderer_name_set_state (BaobabCellRendererName* self, BaobabScannerState value) {
	BaobabScannerState _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_state = _tmp0_;
	g_object_notify ((GObject *) self, "state");
}


void baobab_cell_renderer_name_set_name (BaobabCellRendererName* self, const gchar* value) {
	gchar* escaped = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	BaobabScannerState _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_markup_escape_text (_tmp0_, (gssize) (-1));
	escaped = _tmp1_;
	_tmp2_ = self->priv->_state;
	switch (_tmp2_) {
		case BAOBAB_SCANNER_STATE_ERROR:
		{
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			_tmp3_ = escaped;
			_tmp4_ = g_strdup_printf ("<b>%s</b>", _tmp3_);
			_tmp5_ = _tmp4_;
			g_object_set ((GtkCellRendererText*) self, "markup", _tmp5_, NULL);
			_g_free0 (_tmp5_);
			break;
		}
		case BAOBAB_SCANNER_STATE_CHILD_ERROR:
		{
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			_tmp6_ = escaped;
			_tmp7_ = g_strdup_printf ("<b>%s</b>", _tmp6_);
			_tmp8_ = _tmp7_;
			g_object_set ((GtkCellRendererText*) self, "markup", _tmp8_, NULL);
			_g_free0 (_tmp8_);
			break;
		}
		default:
		{
			const gchar* _tmp9_ = NULL;
			_tmp9_ = escaped;
			g_object_set ((GtkCellRendererText*) self, "markup", _tmp9_, NULL);
			break;
		}
	}
	_g_free0 (escaped);
	g_object_notify ((GObject *) self, "name");
}


static void baobab_cell_renderer_name_class_init (BaobabCellRendererNameClass * klass) {
	baobab_cell_renderer_name_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabCellRendererNamePrivate));
	GTK_CELL_RENDERER_CLASS (klass)->render = baobab_cell_renderer_name_real_render;
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_cell_renderer_name_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_cell_renderer_name_set_property;
	G_OBJECT_CLASS (klass)->finalize = baobab_cell_renderer_name_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_NAME_STATE, g_param_spec_enum ("state", "state", "state", BAOBAB_SCANNER_TYPE_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_NAME_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
}


static void baobab_cell_renderer_name_instance_init (BaobabCellRendererName * self) {
	self->priv = BAOBAB_CELL_RENDERER_NAME_GET_PRIVATE (self);
}


static void baobab_cell_renderer_name_finalize (GObject* obj) {
	BaobabCellRendererName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_CELL_RENDERER_NAME, BaobabCellRendererName);
	G_OBJECT_CLASS (baobab_cell_renderer_name_parent_class)->finalize (obj);
}


GType baobab_cell_renderer_name_get_type (void) {
	static volatile gsize baobab_cell_renderer_name_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_cell_renderer_name_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabCellRendererNameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_cell_renderer_name_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabCellRendererName), 0, (GInstanceInitFunc) baobab_cell_renderer_name_instance_init, NULL };
		GType baobab_cell_renderer_name_type_id;
		baobab_cell_renderer_name_type_id = g_type_register_static (GTK_TYPE_CELL_RENDERER_TEXT, "BaobabCellRendererName", &g_define_type_info, 0);
		g_once_init_leave (&baobab_cell_renderer_name_type_id__volatile, baobab_cell_renderer_name_type_id);
	}
	return baobab_cell_renderer_name_type_id__volatile;
}


static void _vala_baobab_cell_renderer_name_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BaobabCellRendererName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CELL_RENDERER_NAME, BaobabCellRendererName);
	switch (property_id) {
		case BAOBAB_CELL_RENDERER_NAME_STATE:
		g_value_set_enum (value, baobab_cell_renderer_name_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_baobab_cell_renderer_name_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BaobabCellRendererName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CELL_RENDERER_NAME, BaobabCellRendererName);
	switch (property_id) {
		case BAOBAB_CELL_RENDERER_NAME_STATE:
		baobab_cell_renderer_name_set_state (self, g_value_get_enum (value));
		break;
		case BAOBAB_CELL_RENDERER_NAME_NAME:
		baobab_cell_renderer_name_set_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


BaobabCellRendererSize* baobab_cell_renderer_size_construct (GType object_type) {
	BaobabCellRendererSize * self = NULL;
	self = (BaobabCellRendererSize*) g_object_new (object_type, NULL);
	return self;
}


BaobabCellRendererSize* baobab_cell_renderer_size_new (void) {
	return baobab_cell_renderer_size_construct (BAOBAB_TYPE_CELL_RENDERER_SIZE);
}


BaobabScannerState baobab_cell_renderer_size_get_state (BaobabCellRendererSize* self) {
	BaobabScannerState result;
	BaobabScannerState _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_state;
	result = _tmp0_;
	return result;
}


void baobab_cell_renderer_size_set_state (BaobabCellRendererSize* self, BaobabScannerState value) {
	BaobabScannerState _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_state = _tmp0_;
	g_object_notify ((GObject *) self, "state");
}


void baobab_cell_renderer_size_set_size (BaobabCellRendererSize* self, guint64 value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_show_allocated_size;
	if (!_tmp0_) {
		gchar* _tmp1_ = NULL;
		BaobabScannerState _tmp2_ = 0;
		_tmp2_ = self->priv->_state;
		if (_tmp2_ != BAOBAB_SCANNER_STATE_ERROR) {
			guint64 _tmp3_ = 0ULL;
			gchar* _tmp4_ = NULL;
			_tmp3_ = value;
			_tmp4_ = g_format_size_full (_tmp3_, G_FORMAT_SIZE_DEFAULT);
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp4_;
		} else {
			gchar* _tmp5_ = NULL;
			_tmp5_ = g_strdup ("");
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp5_;
		}
		g_object_set ((GtkCellRendererText*) self, "text", _tmp1_, NULL);
		_g_free0 (_tmp1_);
	}
	g_object_notify ((GObject *) self, "size");
}


void baobab_cell_renderer_size_set_alloc_size (BaobabCellRendererSize* self, guint64 value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_show_allocated_size;
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		BaobabScannerState _tmp2_ = 0;
		_tmp2_ = self->priv->_state;
		if (_tmp2_ != BAOBAB_SCANNER_STATE_ERROR) {
			guint64 _tmp3_ = 0ULL;
			gchar* _tmp4_ = NULL;
			_tmp3_ = value;
			_tmp4_ = g_format_size_full (_tmp3_, G_FORMAT_SIZE_DEFAULT);
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp4_;
		} else {
			gchar* _tmp5_ = NULL;
			_tmp5_ = g_strdup ("");
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp5_;
		}
		g_object_set ((GtkCellRendererText*) self, "text", _tmp1_, NULL);
		_g_free0 (_tmp1_);
	}
	g_object_notify ((GObject *) self, "alloc-size");
}


static gboolean baobab_cell_renderer_size_get_show_allocated_size (BaobabCellRendererSize* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_allocated_size;
	result = _tmp0_;
	return result;
}


void baobab_cell_renderer_size_set_show_allocated_size (BaobabCellRendererSize* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_allocated_size = _tmp0_;
	g_object_notify ((GObject *) self, "show-allocated-size");
}


static void baobab_cell_renderer_size_class_init (BaobabCellRendererSizeClass * klass) {
	baobab_cell_renderer_size_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabCellRendererSizePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_cell_renderer_size_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_cell_renderer_size_set_property;
	G_OBJECT_CLASS (klass)->finalize = baobab_cell_renderer_size_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_SIZE_STATE, g_param_spec_enum ("state", "state", "state", BAOBAB_SCANNER_TYPE_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_SIZE_SIZE, g_param_spec_uint64 ("size", "size", "size", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_SIZE_ALLOC_SIZE, g_param_spec_uint64 ("alloc-size", "alloc-size", "alloc-size", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_SIZE_SHOW_ALLOCATED_SIZE, g_param_spec_boolean ("show-allocated-size", "show-allocated-size", "show-allocated-size", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
}


static void baobab_cell_renderer_size_instance_init (BaobabCellRendererSize * self) {
	self->priv = BAOBAB_CELL_RENDERER_SIZE_GET_PRIVATE (self);
}


static void baobab_cell_renderer_size_finalize (GObject* obj) {
	BaobabCellRendererSize * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_CELL_RENDERER_SIZE, BaobabCellRendererSize);
	G_OBJECT_CLASS (baobab_cell_renderer_size_parent_class)->finalize (obj);
}


GType baobab_cell_renderer_size_get_type (void) {
	static volatile gsize baobab_cell_renderer_size_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_cell_renderer_size_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabCellRendererSizeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_cell_renderer_size_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabCellRendererSize), 0, (GInstanceInitFunc) baobab_cell_renderer_size_instance_init, NULL };
		GType baobab_cell_renderer_size_type_id;
		baobab_cell_renderer_size_type_id = g_type_register_static (GTK_TYPE_CELL_RENDERER_TEXT, "BaobabCellRendererSize", &g_define_type_info, 0);
		g_once_init_leave (&baobab_cell_renderer_size_type_id__volatile, baobab_cell_renderer_size_type_id);
	}
	return baobab_cell_renderer_size_type_id__volatile;
}


static void _vala_baobab_cell_renderer_size_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BaobabCellRendererSize * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CELL_RENDERER_SIZE, BaobabCellRendererSize);
	switch (property_id) {
		case BAOBAB_CELL_RENDERER_SIZE_STATE:
		g_value_set_enum (value, baobab_cell_renderer_size_get_state (self));
		break;
		case BAOBAB_CELL_RENDERER_SIZE_SHOW_ALLOCATED_SIZE:
		g_value_set_boolean (value, baobab_cell_renderer_size_get_show_allocated_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_baobab_cell_renderer_size_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BaobabCellRendererSize * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CELL_RENDERER_SIZE, BaobabCellRendererSize);
	switch (property_id) {
		case BAOBAB_CELL_RENDERER_SIZE_STATE:
		baobab_cell_renderer_size_set_state (self, g_value_get_enum (value));
		break;
		case BAOBAB_CELL_RENDERER_SIZE_SIZE:
		baobab_cell_renderer_size_set_size (self, g_value_get_uint64 (value));
		break;
		case BAOBAB_CELL_RENDERER_SIZE_ALLOC_SIZE:
		baobab_cell_renderer_size_set_alloc_size (self, g_value_get_uint64 (value));
		break;
		case BAOBAB_CELL_RENDERER_SIZE_SHOW_ALLOCATED_SIZE:
		baobab_cell_renderer_size_set_show_allocated_size (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


BaobabCellRendererItems* baobab_cell_renderer_items_construct (GType object_type) {
	BaobabCellRendererItems * self = NULL;
	self = (BaobabCellRendererItems*) g_object_new (object_type, NULL);
	return self;
}


BaobabCellRendererItems* baobab_cell_renderer_items_new (void) {
	return baobab_cell_renderer_items_construct (BAOBAB_TYPE_CELL_RENDERER_ITEMS);
}


BaobabScannerState baobab_cell_renderer_items_get_state (BaobabCellRendererItems* self) {
	BaobabScannerState result;
	BaobabScannerState _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_state;
	result = _tmp0_;
	return result;
}


void baobab_cell_renderer_items_set_state (BaobabCellRendererItems* self, BaobabScannerState value) {
	BaobabScannerState _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_state = _tmp0_;
	g_object_notify ((GObject *) self, "state");
}


void baobab_cell_renderer_items_set_items (BaobabCellRendererItems* self, gint value) {
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp2_ = value;
	if (_tmp2_ >= 0) {
		BaobabScannerState _tmp3_ = 0;
		_tmp3_ = self->priv->_state;
		_tmp1_ = _tmp3_ != BAOBAB_SCANNER_STATE_ERROR;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp4_ = 0;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gchar* _tmp7_ = NULL;
		_tmp4_ = value;
		_tmp5_ = ngettext ("%d item", "%d items", (gulong) _tmp4_);
		_tmp6_ = value;
		_tmp7_ = g_strdup_printf (_tmp5_, _tmp6_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp7_;
	} else {
		gchar* _tmp8_ = NULL;
		_tmp8_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp8_;
	}
	g_object_set ((GtkCellRendererText*) self, "text", _tmp0_, NULL);
	_g_free0 (_tmp0_);
	g_object_notify ((GObject *) self, "items");
}


static void baobab_cell_renderer_items_class_init (BaobabCellRendererItemsClass * klass) {
	baobab_cell_renderer_items_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabCellRendererItemsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_cell_renderer_items_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_cell_renderer_items_set_property;
	G_OBJECT_CLASS (klass)->finalize = baobab_cell_renderer_items_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_ITEMS_STATE, g_param_spec_enum ("state", "state", "state", BAOBAB_SCANNER_TYPE_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_ITEMS_ITEMS, g_param_spec_int ("items", "items", "items", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
}


static void baobab_cell_renderer_items_instance_init (BaobabCellRendererItems * self) {
	self->priv = BAOBAB_CELL_RENDERER_ITEMS_GET_PRIVATE (self);
}


static void baobab_cell_renderer_items_finalize (GObject* obj) {
	BaobabCellRendererItems * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_CELL_RENDERER_ITEMS, BaobabCellRendererItems);
	G_OBJECT_CLASS (baobab_cell_renderer_items_parent_class)->finalize (obj);
}


GType baobab_cell_renderer_items_get_type (void) {
	static volatile gsize baobab_cell_renderer_items_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_cell_renderer_items_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabCellRendererItemsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_cell_renderer_items_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabCellRendererItems), 0, (GInstanceInitFunc) baobab_cell_renderer_items_instance_init, NULL };
		GType baobab_cell_renderer_items_type_id;
		baobab_cell_renderer_items_type_id = g_type_register_static (GTK_TYPE_CELL_RENDERER_TEXT, "BaobabCellRendererItems", &g_define_type_info, 0);
		g_once_init_leave (&baobab_cell_renderer_items_type_id__volatile, baobab_cell_renderer_items_type_id);
	}
	return baobab_cell_renderer_items_type_id__volatile;
}


static void _vala_baobab_cell_renderer_items_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BaobabCellRendererItems * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CELL_RENDERER_ITEMS, BaobabCellRendererItems);
	switch (property_id) {
		case BAOBAB_CELL_RENDERER_ITEMS_STATE:
		g_value_set_enum (value, baobab_cell_renderer_items_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_baobab_cell_renderer_items_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BaobabCellRendererItems * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CELL_RENDERER_ITEMS, BaobabCellRendererItems);
	switch (property_id) {
		case BAOBAB_CELL_RENDERER_ITEMS_STATE:
		baobab_cell_renderer_items_set_state (self, g_value_get_enum (value));
		break;
		case BAOBAB_CELL_RENDERER_ITEMS_ITEMS:
		baobab_cell_renderer_items_set_items (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


BaobabCellRendererTime* baobab_cell_renderer_time_construct (GType object_type) {
	BaobabCellRendererTime * self = NULL;
	self = (BaobabCellRendererTime*) g_object_new (object_type, NULL);
	return self;
}


BaobabCellRendererTime* baobab_cell_renderer_time_new (void) {
	return baobab_cell_renderer_time_construct (BAOBAB_TYPE_CELL_RENDERER_TIME);
}


void baobab_cell_renderer_time_set_time (BaobabCellRendererTime* self, guint64 value) {
	guint64 _tmp0_ = 0ULL;
	GDateTime* dt = NULL;
	guint64 _tmp2_ = 0ULL;
	GDateTime* _tmp3_ = NULL;
	GDateTime* now = NULL;
	GDateTime* _tmp4_ = NULL;
	GTimeSpan ts = 0LL;
	GDateTime* _tmp5_ = NULL;
	GDateTime* _tmp6_ = NULL;
	GTimeSpan _tmp7_ = 0LL;
	GTimeSpan _tmp8_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	if (_tmp0_ == ((guint64) 0)) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("Unknown");
		g_object_set ((GtkCellRendererText*) self, "text", _tmp1_, NULL);
		return;
	}
	_tmp2_ = value;
	_tmp3_ = g_date_time_new_from_unix_local ((gint64) _tmp2_);
	dt = _tmp3_;
	_tmp4_ = g_date_time_new_now_local ();
	now = _tmp4_;
	_tmp5_ = now;
	_tmp6_ = dt;
	_tmp7_ = g_date_time_difference (_tmp5_, _tmp6_);
	ts = _tmp7_;
	_tmp8_ = ts;
	if (_tmp8_ < G_TIME_SPAN_DAY) {
		const gchar* _tmp9_ = NULL;
		_tmp9_ = _ ("Today");
		g_object_set ((GtkCellRendererText*) self, "text", _tmp9_, NULL);
	} else {
		GTimeSpan _tmp10_ = 0LL;
		_tmp10_ = ts;
		if (_tmp10_ < (31 * G_TIME_SPAN_DAY)) {
			gulong days = 0UL;
			GTimeSpan _tmp11_ = 0LL;
			gulong _tmp12_ = 0UL;
			const gchar* _tmp13_ = NULL;
			gulong _tmp14_ = 0UL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			_tmp11_ = ts;
			days = (gulong) (_tmp11_ / G_TIME_SPAN_DAY);
			_tmp12_ = days;
			_tmp13_ = ngettext ("%d day", "%d days", _tmp12_);
			_tmp14_ = days;
			_tmp15_ = g_strdup_printf (_tmp13_, _tmp14_);
			_tmp16_ = _tmp15_;
			g_object_set ((GtkCellRendererText*) self, "text", _tmp16_, NULL);
			_g_free0 (_tmp16_);
		} else {
			GTimeSpan _tmp17_ = 0LL;
			_tmp17_ = ts;
			if (_tmp17_ < (365 * G_TIME_SPAN_DAY)) {
				gulong months = 0UL;
				GTimeSpan _tmp18_ = 0LL;
				gulong _tmp19_ = 0UL;
				const gchar* _tmp20_ = NULL;
				gulong _tmp21_ = 0UL;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				_tmp18_ = ts;
				months = (gulong) (_tmp18_ / (31 * G_TIME_SPAN_DAY));
				_tmp19_ = months;
				_tmp20_ = ngettext ("%d month", "%d months", _tmp19_);
				_tmp21_ = months;
				_tmp22_ = g_strdup_printf (_tmp20_, _tmp21_);
				_tmp23_ = _tmp22_;
				g_object_set ((GtkCellRendererText*) self, "text", _tmp23_, NULL);
				_g_free0 (_tmp23_);
			} else {
				gulong years = 0UL;
				GTimeSpan _tmp24_ = 0LL;
				gulong _tmp25_ = 0UL;
				const gchar* _tmp26_ = NULL;
				gulong _tmp27_ = 0UL;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				_tmp24_ = ts;
				years = (gulong) (_tmp24_ / (365 * G_TIME_SPAN_DAY));
				_tmp25_ = years;
				_tmp26_ = ngettext ("%d year", "%d years", _tmp25_);
				_tmp27_ = years;
				_tmp28_ = g_strdup_printf (_tmp26_, _tmp27_);
				_tmp29_ = _tmp28_;
				g_object_set ((GtkCellRendererText*) self, "text", _tmp29_, NULL);
				_g_free0 (_tmp29_);
			}
		}
	}
	_g_date_time_unref0 (now);
	_g_date_time_unref0 (dt);
	g_object_notify ((GObject *) self, "time");
}


static void baobab_cell_renderer_time_class_init (BaobabCellRendererTimeClass * klass) {
	baobab_cell_renderer_time_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_cell_renderer_time_set_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_TIME_TIME, g_param_spec_uint64 ("time", "time", "time", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
}


static void baobab_cell_renderer_time_instance_init (BaobabCellRendererTime * self) {
}


GType baobab_cell_renderer_time_get_type (void) {
	static volatile gsize baobab_cell_renderer_time_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_cell_renderer_time_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabCellRendererTimeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_cell_renderer_time_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabCellRendererTime), 0, (GInstanceInitFunc) baobab_cell_renderer_time_instance_init, NULL };
		GType baobab_cell_renderer_time_type_id;
		baobab_cell_renderer_time_type_id = g_type_register_static (GTK_TYPE_CELL_RENDERER_TEXT, "BaobabCellRendererTime", &g_define_type_info, 0);
		g_once_init_leave (&baobab_cell_renderer_time_type_id__volatile, baobab_cell_renderer_time_type_id);
	}
	return baobab_cell_renderer_time_type_id__volatile;
}


static void _vala_baobab_cell_renderer_time_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BaobabCellRendererTime * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CELL_RENDERER_TIME, BaobabCellRendererTime);
	switch (property_id) {
		case BAOBAB_CELL_RENDERER_TIME_TIME:
		baobab_cell_renderer_time_set_time (self, g_value_get_uint64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void baobab_cell_renderer_progress_real_render (GtkCellRenderer* base, cairo_t* cr, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags) {
	BaobabCellRendererProgress * self;
	BaobabScannerState _tmp0_ = 0;
	gint xpad = 0;
	gint ypad = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint x = 0;
	GdkRectangle _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint y = 0;
	GdkRectangle _tmp6_ = {0};
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint w = 0;
	GdkRectangle _tmp9_ = {0};
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint h = 0;
	GdkRectangle _tmp12_ = {0};
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	GtkStyleContext* context = NULL;
	GtkWidget* _tmp15_ = NULL;
	GtkStyleContext* _tmp16_ = NULL;
	GtkStyleContext* _tmp17_ = NULL;
	GtkStyleContext* _tmp18_ = NULL;
	GtkStyleContext* _tmp19_ = NULL;
	GtkStyleContext* _tmp20_ = NULL;
	cairo_t* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	GtkStyleContext* _tmp26_ = NULL;
	cairo_t* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	GtkBorder border = {0};
	GtkStyleContext* _tmp32_ = NULL;
	GtkBorder _tmp33_ = {0};
	gint _tmp34_ = 0;
	GtkBorder _tmp35_ = {0};
	gint16 _tmp36_ = 0;
	gint _tmp37_ = 0;
	GtkBorder _tmp38_ = {0};
	gint16 _tmp39_ = 0;
	gint _tmp40_ = 0;
	GtkBorder _tmp41_ = {0};
	gint16 _tmp42_ = 0;
	GtkBorder _tmp43_ = {0};
	gint16 _tmp44_ = 0;
	gint _tmp45_ = 0;
	GtkBorder _tmp46_ = {0};
	gint16 _tmp47_ = 0;
	GtkBorder _tmp48_ = {0};
	gint16 _tmp49_ = 0;
	gint percent = 0;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	gint perc_w = 0;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	gint x_bar = 0;
	gint _tmp54_ = 0;
	GtkWidget* _tmp55_ = NULL;
	GtkTextDirection _tmp56_ = 0;
	GtkStyleContext* _tmp60_ = NULL;
	gint _tmp61_ = 0;
	GtkStyleContext* _tmp65_ = NULL;
	cairo_t* _tmp66_ = NULL;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	gint _tmp69_ = 0;
	gint _tmp70_ = 0;
	GtkStyleContext* _tmp71_ = NULL;
	self = (BaobabCellRendererProgress*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell_area != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == BAOBAB_SCANNER_STATE_ERROR) {
		return;
	}
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp1_, &_tmp2_);
	xpad = _tmp1_;
	ypad = _tmp2_;
	_tmp3_ = *cell_area;
	_tmp4_ = _tmp3_.x;
	_tmp5_ = xpad;
	x = _tmp4_ + _tmp5_;
	_tmp6_ = *cell_area;
	_tmp7_ = _tmp6_.y;
	_tmp8_ = ypad;
	y = _tmp7_ + _tmp8_;
	_tmp9_ = *cell_area;
	_tmp10_ = _tmp9_.width;
	_tmp11_ = xpad;
	w = _tmp10_ - (_tmp11_ * 2);
	_tmp12_ = *cell_area;
	_tmp13_ = _tmp12_.height;
	_tmp14_ = ypad;
	h = _tmp13_ - (_tmp14_ * 2);
	_tmp15_ = widget;
	_tmp16_ = gtk_widget_get_style_context (_tmp15_);
	_tmp17_ = _g_object_ref0 (_tmp16_);
	context = _tmp17_;
	_tmp18_ = context;
	gtk_style_context_save (_tmp18_);
	_tmp19_ = context;
	gtk_style_context_add_class (_tmp19_, "baobab-level-cell");
	_tmp20_ = context;
	_tmp21_ = cr;
	_tmp22_ = x;
	_tmp23_ = y;
	_tmp24_ = w;
	_tmp25_ = h;
	gtk_render_background (_tmp20_, _tmp21_, (gdouble) _tmp22_, (gdouble) _tmp23_, (gdouble) _tmp24_, (gdouble) _tmp25_);
	_tmp26_ = context;
	_tmp27_ = cr;
	_tmp28_ = x;
	_tmp29_ = y;
	_tmp30_ = w;
	_tmp31_ = h;
	gtk_render_frame (_tmp26_, _tmp27_, (gdouble) _tmp28_, (gdouble) _tmp29_, (gdouble) _tmp30_, (gdouble) _tmp31_);
	_tmp32_ = context;
	gtk_style_context_get_border (_tmp32_, GTK_STATE_FLAG_NORMAL, &_tmp33_);
	border = _tmp33_;
	_tmp34_ = x;
	_tmp35_ = border;
	_tmp36_ = _tmp35_.left;
	x = _tmp34_ + _tmp36_;
	_tmp37_ = y;
	_tmp38_ = border;
	_tmp39_ = _tmp38_.top;
	y = _tmp37_ + _tmp39_;
	_tmp40_ = w;
	_tmp41_ = border;
	_tmp42_ = _tmp41_.left;
	_tmp43_ = border;
	_tmp44_ = _tmp43_.right;
	w = _tmp40_ - (_tmp42_ + _tmp44_);
	_tmp45_ = h;
	_tmp46_ = border;
	_tmp47_ = _tmp46_.top;
	_tmp48_ = border;
	_tmp49_ = _tmp48_.bottom;
	h = _tmp45_ - (_tmp47_ + _tmp49_);
	g_object_get ((GtkCellRendererProgress*) self, "value", &_tmp50_, NULL);
	_tmp51_ = _tmp50_;
	percent = _tmp51_;
	_tmp52_ = w;
	_tmp53_ = percent;
	perc_w = (_tmp52_ * _tmp53_) / 100;
	_tmp54_ = x;
	x_bar = _tmp54_;
	_tmp55_ = widget;
	_tmp56_ = gtk_widget_get_direction (_tmp55_);
	if (_tmp56_ == GTK_TEXT_DIR_RTL) {
		gint _tmp57_ = 0;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
		_tmp57_ = x_bar;
		_tmp58_ = w;
		_tmp59_ = perc_w;
		x_bar = _tmp57_ + (_tmp58_ - _tmp59_);
	}
	_tmp60_ = context;
	gtk_style_context_add_class (_tmp60_, "fill-block");
	_tmp61_ = percent;
	if (_tmp61_ <= 33) {
		GtkStyleContext* _tmp62_ = NULL;
		_tmp62_ = context;
		gtk_style_context_add_class (_tmp62_, "level-low");
	} else {
		gint _tmp63_ = 0;
		_tmp63_ = percent;
		if (_tmp63_ > 66) {
			GtkStyleContext* _tmp64_ = NULL;
			_tmp64_ = context;
			gtk_style_context_add_class (_tmp64_, "level-high");
		}
	}
	_tmp65_ = context;
	_tmp66_ = cr;
	_tmp67_ = x_bar;
	_tmp68_ = y;
	_tmp69_ = perc_w;
	_tmp70_ = h;
	gtk_render_background (_tmp65_, _tmp66_, (gdouble) _tmp67_, (gdouble) _tmp68_, (gdouble) _tmp69_, (gdouble) _tmp70_);
	_tmp71_ = context;
	gtk_style_context_restore (_tmp71_);
	_g_object_unref0 (context);
}


BaobabCellRendererProgress* baobab_cell_renderer_progress_construct (GType object_type) {
	BaobabCellRendererProgress * self = NULL;
	self = (BaobabCellRendererProgress*) g_object_new (object_type, NULL);
	return self;
}


BaobabCellRendererProgress* baobab_cell_renderer_progress_new (void) {
	return baobab_cell_renderer_progress_construct (BAOBAB_TYPE_CELL_RENDERER_PROGRESS);
}


BaobabScannerState baobab_cell_renderer_progress_get_state (BaobabCellRendererProgress* self) {
	BaobabScannerState result;
	BaobabScannerState _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_state;
	result = _tmp0_;
	return result;
}


void baobab_cell_renderer_progress_set_state (BaobabCellRendererProgress* self, BaobabScannerState value) {
	BaobabScannerState _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_state = _tmp0_;
	g_object_notify ((GObject *) self, "state");
}


static void baobab_cell_renderer_progress_class_init (BaobabCellRendererProgressClass * klass) {
	baobab_cell_renderer_progress_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabCellRendererProgressPrivate));
	GTK_CELL_RENDERER_CLASS (klass)->render = baobab_cell_renderer_progress_real_render;
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_cell_renderer_progress_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_cell_renderer_progress_set_property;
	G_OBJECT_CLASS (klass)->finalize = baobab_cell_renderer_progress_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_PROGRESS_STATE, g_param_spec_enum ("state", "state", "state", BAOBAB_SCANNER_TYPE_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void baobab_cell_renderer_progress_instance_init (BaobabCellRendererProgress * self) {
	self->priv = BAOBAB_CELL_RENDERER_PROGRESS_GET_PRIVATE (self);
}


static void baobab_cell_renderer_progress_finalize (GObject* obj) {
	BaobabCellRendererProgress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_CELL_RENDERER_PROGRESS, BaobabCellRendererProgress);
	G_OBJECT_CLASS (baobab_cell_renderer_progress_parent_class)->finalize (obj);
}


GType baobab_cell_renderer_progress_get_type (void) {
	static volatile gsize baobab_cell_renderer_progress_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_cell_renderer_progress_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabCellRendererProgressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_cell_renderer_progress_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabCellRendererProgress), 0, (GInstanceInitFunc) baobab_cell_renderer_progress_instance_init, NULL };
		GType baobab_cell_renderer_progress_type_id;
		baobab_cell_renderer_progress_type_id = g_type_register_static (GTK_TYPE_CELL_RENDERER_PROGRESS, "BaobabCellRendererProgress", &g_define_type_info, 0);
		g_once_init_leave (&baobab_cell_renderer_progress_type_id__volatile, baobab_cell_renderer_progress_type_id);
	}
	return baobab_cell_renderer_progress_type_id__volatile;
}


static void _vala_baobab_cell_renderer_progress_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BaobabCellRendererProgress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CELL_RENDERER_PROGRESS, BaobabCellRendererProgress);
	switch (property_id) {
		case BAOBAB_CELL_RENDERER_PROGRESS_STATE:
		g_value_set_enum (value, baobab_cell_renderer_progress_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_baobab_cell_renderer_progress_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BaobabCellRendererProgress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CELL_RENDERER_PROGRESS, BaobabCellRendererProgress);
	switch (property_id) {
		case BAOBAB_CELL_RENDERER_PROGRESS_STATE:
		baobab_cell_renderer_progress_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



