// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_SETTINGSBACKEND_H
#define _GIOMM_SETTINGSBACKEND_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/interface.h>
#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GSettingsBackendClass GSettingsBackendClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GSettingsBackend GSettingsBackend;
typedef struct _GSettingsBackendClass GSettingsBackendClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class SettingsBackend_Class; } // namespace Gio
namespace Gio
{

/** TODO
 */

class SettingsBackend : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SettingsBackend CppObjectType;
  typedef SettingsBackend_Class CppClassType;
  typedef GSettingsBackend BaseObjectType;
  typedef GSettingsBackendClass BaseClassType;

private:
  friend class SettingsBackend_Class;
  static CppClassType settingsbackend_class_;

  // noncopyable
  SettingsBackend(const SettingsBackend&);
  SettingsBackend& operator=(const SettingsBackend&);

protected:
  SettingsBackend(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit SettingsBackend(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit SettingsBackend(GSettingsBackend* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SettingsBackend();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GSettingsBackend*       gobj()       { return reinterpret_cast<GSettingsBackend*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GSettingsBackend* gobj() const { return reinterpret_cast<GSettingsBackend*>(gobject_); }

private:


public:

  
  /** Signals that a single key has possibly changed.  Backend
   * implementations should call this if a key has possibly changed its
   * value.
   * 
   *  @a key must be a valid key (ie starting with a slash, not containing
   * '//', and not ending with a slash).
   * 
   * The implementation must call this function during any call to
   * Glib::settings_backend_write(), before the call returns (except in the
   * case that no keys are actually changed and it cares to detect this
   * fact).  It may not rely on the existence of a mainloop for
   * dispatching the signal later.
   * 
   * The implementation may call this function at any other time it likes
   * in response to other events (such as changes occuring outside of the
   * program).  These calls may originate from a mainloop or may originate
   * in response to any other action (including from calls to
   * Glib::settings_backend_write()).
   * 
   * In the case that this call is in response to a call to
   * Glib::settings_backend_write() then @a origin_tag must be set to the same
   * value that was passed to that call.
   * 
   * @newin{2,26}
   * @param key The name of the key.
   * @param origin_tag The origin tag.
   */
  void backend_changed(const Glib::ustring& key, gpointer origin_tag);
  
  /** Signals that all keys below a given path may have possibly changed.
   * Backend implementations should call this if an entire path of keys
   * have possibly changed their values.
   * 
   *  @a path must be a valid path (ie starting and ending with a slash and
   * not containing '//').
   * 
   * The meaning of this signal is that any of the key which has a name
   * starting with @a path may have changed.
   * 
   * The same rules for when notifications must occur apply as per
   * g_settings_backend_changed().  This call might be an appropriate
   * reasponse to a 'reset' call but implementations are also free to
   * explicitly list the keys that were affected by that call if they can
   * easily do so.
   * 
   * For efficiency reasons, the implementation should strive for @a path to
   * be as long as possible (ie: the longest common prefix of all of the
   * keys that were changed) but this is not strictly required.  As an
   * example, if this function is called with the path of "/" then every
   * single key in the application will be notified of a possible change.
   * 
   * @newin{2,26}
   * @param path The path containing the changes.
   * @param origin_tag The origin tag.
   */
  void path_changed(const Glib::ustring& path, gpointer origin_tag);

  //TODO: Use an ArrayHandle?
  //_WRAP_METHOD(void keys_changed(const Glib::ustring& path, gchar const * const *items, gpointer origin_tag), g_settings_backend_keys_changed)

  
  /** Signals that the writability of all keys below a given path may have
   * changed.
   * 
   * Since GSettings performs no locking operations for itself, this call
   * will always be made in response to external events.
   * 
   * @newin{2,26}
   * @param path The name of the path.
   */
  void path_writable_changed(const Glib::ustring& path);
  
  /** Signals that the writability of a single key has possibly changed.
   * 
   * Since GSettings performs no locking operations for itself, this call
   * will always be made in response to external events.
   * 
   * @newin{2,26}
   * @param key The name of the key.
   */
  void writable_changed(const Glib::ustring& key);

  //TODO: Use the glibmm wrapper of GTree:
  
  /** This call is a convenience wrapper.  It gets the list of changes from
   *  @a tree, computes the longest common prefix and calls
   * g_settings_backend_changed().
   * 
   * @newin{2,26}
   * @param tree A Tree containing the changes.
   * @param origin_tag The origin tag.
   */
  void changed_tree(GTree *tree, gpointer origin_tag);

    //TODO: Vfuncs?


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::SettingsBackend
   */
  Glib::RefPtr<Gio::SettingsBackend> wrap(GSettingsBackend* object, bool take_copy = false);

} // namespace Glib


#endif /* _GIOMM_SETTINGSBACKEND_H */

