// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_DBUSPROXY_H
#define _GIOMM_DBUSPROXY_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <giomm/initable.h>
#include <giomm/asyncinitable.h>
#include <giomm/dbusconnection.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GDBusProxy GDBusProxy;
typedef struct _GDBusProxyClass GDBusProxyClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class DBusProxy_Class; } // namespace Gio
namespace Gio
{

/** @addtogroup giommEnums giomm Enums and Flags */

/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%DBusProxyFlags operator|(DBusProxyFlags, DBusProxyFlags)</tt><br>
 * <tt>%DBusProxyFlags operator&(DBusProxyFlags, DBusProxyFlags)</tt><br>
 * <tt>%DBusProxyFlags operator^(DBusProxyFlags, DBusProxyFlags)</tt><br>
 * <tt>%DBusProxyFlags operator~(DBusProxyFlags)</tt><br>
 * <tt>%DBusProxyFlags& operator|=(DBusProxyFlags&, DBusProxyFlags)</tt><br>
 * <tt>%DBusProxyFlags& operator&=(DBusProxyFlags&, DBusProxyFlags)</tt><br>
 * <tt>%DBusProxyFlags& operator^=(DBusProxyFlags&, DBusProxyFlags)</tt><br>
 */
enum DBusProxyFlags
{
  DBUS_PROXY_FLAGS_NONE = 0x0,
  DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES = (1<<0),
  DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS = (1<<1),
  DBUS_PROXY_FLAGS_DO_NOT_AUTO_START = (1<<2)
};

/** @ingroup giommEnums */
inline DBusProxyFlags operator|(DBusProxyFlags lhs, DBusProxyFlags rhs)
  { return static_cast<DBusProxyFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusProxyFlags operator&(DBusProxyFlags lhs, DBusProxyFlags rhs)
  { return static_cast<DBusProxyFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusProxyFlags operator^(DBusProxyFlags lhs, DBusProxyFlags rhs)
  { return static_cast<DBusProxyFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusProxyFlags operator~(DBusProxyFlags flags)
  { return static_cast<DBusProxyFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline DBusProxyFlags& operator|=(DBusProxyFlags& lhs, DBusProxyFlags rhs)
  { return (lhs = static_cast<DBusProxyFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusProxyFlags& operator&=(DBusProxyFlags& lhs, DBusProxyFlags rhs)
  { return (lhs = static_cast<DBusProxyFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusProxyFlags& operator^=(DBusProxyFlags& lhs, DBusProxyFlags rhs)
  { return (lhs = static_cast<DBusProxyFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


class AsyncResult;
class DBusConnection;
class DBusInterfaceInfo;

/** DBusProxy - Client-side proxies.
 * DBusProxy is a base class used for proxies to access a D-Bus interface on
 * a remote object. A DBusProxy can be constructed for both well-known and
 * unique names.
 *
 * By default, DBusProxy will cache all properties (and listen to changes) of
 * the remote object, and proxy all signals that gets emitted. This behaviour
 * can be changed by passing suitable DBusProxyFlags when the proxy is
 * created. If the proxy is for a well-known name, the property cache is
 * flushed when the name owner vanishes and reloaded when a name owner
 * appears.
 *
 * If a DBusProxy is used for a well-known name, the owner of the name is
 * tracked and can be read from property_g_name_owner(). Connect to the
 * signal_notify() signal to get notified of changes. Additionally, only
 * signals and property changes emitted from the current name owner are
 * considered. This avoids a number of race conditions when the name is lost
 * by one owner and claimed by another.
 *
 * The generic signal_g_properties_changed() and signal_g_signal() signals are
 * not very convenient to work with. Therefore, the recommended way of working
 * with proxies is to subclass DBusProxy, and have more natural properties and
 * signals in your derived class.
 *
 * The C API docs has more information and an example.
 *
 * @newin{2,26}
 */

class DBusProxy
: public Glib::Object,
  public Initable,
  public AsyncInitable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DBusProxy CppObjectType;
  typedef DBusProxy_Class CppClassType;
  typedef GDBusProxy BaseObjectType;
  typedef GDBusProxyClass BaseClassType;

private:  friend class DBusProxy_Class;
  static CppClassType dbusproxy_class_;

private:
  // noncopyable
  DBusProxy(const DBusProxy&);
  DBusProxy& operator=(const DBusProxy&);

protected:
  explicit DBusProxy(const Glib::ConstructParams& construct_params);
  explicit DBusProxy(GDBusProxy* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DBusProxy();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GDBusProxy*       gobj()       { return reinterpret_cast<GDBusProxy*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GDBusProxy* gobj() const { return reinterpret_cast<GDBusProxy*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusProxy* gobj_copy();

private:


protected:
  DBusProxy(const Glib::RefPtr<DBusConnection>& connection,
    DBusProxyFlags flags, const Glib::RefPtr<DBusInterfaceInfo>& info,
    const Glib::ustring& name, const Glib::ustring& object_path,
    const Glib::ustring& interface_name, const SlotAsyncReady& slot,
    const Glib::RefPtr<Cancellable>& cancellable);

  DBusProxy(const Glib::RefPtr<DBusConnection>& connection,
    DBusProxyFlags flags, const Glib::RefPtr<DBusInterfaceInfo>& info,
    const Glib::ustring& name, const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const Glib::RefPtr<Cancellable>& cancellable);

  DBusProxy(BusType bus_type, DBusProxyFlags flags,
    const Glib::RefPtr<DBusInterfaceInfo>& info, const Glib::ustring& name,
    const Glib::ustring& object_path, const Glib::ustring& interface_name,
    const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable);

  DBusProxy(BusType bus_type, DBusProxyFlags flags,
    const Glib::RefPtr<DBusInterfaceInfo>& info, const Glib::ustring& name,
    const Glib::ustring& object_path, const Glib::ustring& interface_name,
    const Glib::RefPtr<Cancellable>& cancellable);

public:

  
  /** Creates a proxy for accessing @a interface_name on the remote object
   * at @a object_path owned by @a name at @a connection and asynchronously
   * loads D-Bus properties unless the
   * DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES flag is used. Connect to
   * the DBusProxy::g-properties-changed signal to get notified about
   * property changes.
   * 
   * If the DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS flag is not set, also sets up
   * match rules for signals. Connect to the DBusProxy::g-signal signal
   * to handle signals from the remote object.
   * 
   * If @a name is a well-known name and the
   * DBUS_PROXY_FLAGS_DO_NOT_AUTO_START flag isn't set and no name
   * owner currently exists, the message bus will be requested to launch
   * a name owner for the name.
   * 
   * This is a failable asynchronous constructor - when the proxy is
   * ready, @a callback will be invoked and you can use
   * g_dbus_proxy_new_finish() to get the result.
   * 
   * See g_dbus_proxy_new_sync() and for a synchronous version of this constructor.
   * 
   * See <xref linkend="gdbus-wellknown-proxy"/> for an example of how DBusProxy can be used.
   * 
   * @newin{2,26}
   * @param connection A DBusConnection.
   * @param flags Flags used when constructing the proxy.
   * @param info A DBusInterfaceInfo specifying the minimal interface that @a proxy conforms to or <tt>0</tt>.
   * @param name A bus name (well-known or unique) or <tt>0</tt> if @a connection is not a message bus connection.
   * @param object_path An object path.
   * @param interface_name A D-Bus interface name.
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @param callback Callback function to invoke when the proxy is ready.
   * @param user_data User data to pass to @a callback.
   */

  static void create(const Glib::RefPtr<DBusConnection>& connection,
    DBusProxyFlags flags, const Glib::RefPtr<DBusInterfaceInfo>& info,
    const Glib::ustring& name, const Glib::ustring& object_path,
    const Glib::ustring& interface_name,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<Cancellable>& cancellable = Glib::RefPtr<Cancellable>());

  
  /** @throw Glib::Error.
   */
  static Glib::RefPtr<DBusProxy> create_finish(const Glib::RefPtr<AsyncResult>& result);

  
  /** Creates a proxy for accessing @a interface_name on the remote object
   * at @a object_path owned by @a name at @a connection and synchronously
   * loads D-Bus properties unless the
   * DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES flag is used.
   * 
   * If the DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS flag is not set, also sets up
   * match rules for signals. Connect to the DBusProxy::g-signal signal
   * to handle signals from the remote object.
   * 
   * If @a name is a well-known name and the
   * DBUS_PROXY_FLAGS_DO_NOT_AUTO_START flag isn't set and no name
   * owner currently exists, the message bus will be requested to launch
   * a name owner for the name.
   * 
   * This is a synchronous failable constructor. See g_dbus_proxy_new()
   * and g_dbus_proxy_new_finish() for the asynchronous version.
   * 
   * See <xref linkend="gdbus-wellknown-proxy"/> for an example of how DBusProxy can be used.
   * 
   * @newin{2,26}
   * @param connection A DBusConnection.
   * @param flags Flags used when constructing the proxy.
   * @param info A DBusInterfaceInfo specifying the minimal interface that @a proxy conforms to or <tt>0</tt>.
   * @param name A bus name (well-known or unique) or <tt>0</tt> if @a connection is not a message bus connection.
   * @param object_path An object path.
   * @param interface_name A D-Bus interface name.
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @return A DBusProxy or <tt>0</tt> if error is set. Free with Glib::object_unref().
   */

  static Glib::RefPtr<DBusProxy>
  create(const Glib::RefPtr<DBusConnection>& connection, DBusProxyFlags flags,
    const Glib::RefPtr<DBusInterfaceInfo>& info, const Glib::ustring& name,
    const Glib::ustring& object_path, const Glib::ustring& interface_name,
    const Glib::RefPtr<Cancellable>& cancellable = Glib::RefPtr<Cancellable>());

  
  /** Like g_dbus_proxy_new() but takes a BusType instead of a DBusConnection.
   * 
   * See <xref linkend="gdbus-wellknown-proxy"/> for an example of how DBusProxy can be used.
   * 
   * @newin{2,26}
   * @param bus_type A BusType.
   * @param flags Flags used when constructing the proxy.
   * @param info A DBusInterfaceInfo specifying the minimal interface that @a proxy conforms to or <tt>0</tt>.
   * @param name A bus name (well-known or unique).
   * @param object_path An object path.
   * @param interface_name A D-Bus interface name.
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @param callback Callback function to invoke when the proxy is ready.
   * @param user_data User data to pass to @a callback.
   */

  static void create_for_bus(BusType bus_type, DBusProxyFlags flags,
    const Glib::RefPtr<DBusInterfaceInfo>& info, const Glib::ustring& name,
    const Glib::ustring& object_path, const Glib::ustring& interface_name,
    const SlotAsyncReady& slot,
    const Glib::RefPtr<Cancellable>& cancellable = Glib::RefPtr<Cancellable>());

  
  /** @throw Glib::Error.
   */
  static Glib::RefPtr<DBusProxy> create_for_bus_finish(const Glib::RefPtr<AsyncResult>& result);

  
  /** Like g_dbus_proxy_new_sync() but takes a BusType instead of a DBusConnection.
   * 
   * See <xref linkend="gdbus-wellknown-proxy"/> for an example of how DBusProxy can be used.
   * 
   * @newin{2,26}
   * @param bus_type A BusType.
   * @param flags Flags used when constructing the proxy.
   * @param info A DBusInterfaceInfo specifying the minimal interface that @a proxy conforms to or <tt>0</tt>.
   * @param name A bus name (well-known or unique).
   * @param object_path An object path.
   * @param interface_name A D-Bus interface name.
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @return A DBusProxy or <tt>0</tt> if error is set. Free with Glib::object_unref().
   */

  static Glib::RefPtr<DBusProxy>
  create_for_bus(BusType bus_type, DBusProxyFlags flags,
    const Glib::RefPtr<DBusInterfaceInfo>& info, const Glib::ustring& name,
    const Glib::ustring& object_path, const Glib::ustring& interface_name,
    const Glib::RefPtr<Cancellable>& cancellable = Glib::RefPtr<Cancellable>());

  
  /** Gets the flags that @a proxy was constructed with.
   * 
   * @newin{2,26}
   * @return Flags from the DBusProxyFlags enumeration.
   */
  DBusProxyFlags get_flags() const;

  
  /** Gets the connection @a proxy is for.
   * 
   * @newin{2,26}
   * @return A DBusConnection owned by @a proxy. Do not free.
   */
  Glib::RefPtr<DBusConnection> get_connection();
  
  /** Gets the connection @a proxy is for.
   * 
   * @newin{2,26}
   * @return A DBusConnection owned by @a proxy. Do not free.
   */
  Glib::RefPtr<const DBusConnection> get_connection() const;

  
  /** Gets the name that @a proxy was constructed for.
   * 
   * @newin{2,26}
   * @return A string owned by @a proxy. Do not free.
   */
  Glib::ustring get_name() const;
  
  /** The unique name that owns the name that @a proxy is for or <tt>0</tt> if
   * no-one currently owns that name. You may connect to the
   * Object::notify signal to track changes to the
   * DBusProxy:g-name-owner property.
   * 
   * @newin{2,26}
   * @return The name owner or <tt>0</tt> if no name owner exists. Free with Glib::free().
   */
  Glib::ustring get_name_owner() const;
  
  /** Gets the object path @a proxy is for.
   * 
   * @newin{2,26}
   * @return A string owned by @a proxy. Do not free.
   */
  Glib::ustring get_object_path() const;
  
  /** Gets the D-Bus interface name @a proxy is for.
   * 
   * @newin{2,26}
   * @return A string owned by @a proxy. Do not free.
   */
  Glib::ustring get_interface_name() const;

  
  /** Gets the timeout to use if -1 (specifying default timeout) is
   * passed as @a timeout_msec in the g_dbus_proxy_call() and
   * g_dbus_proxy_call_sync() functions.
   * 
   * See the DBusProxy:g-default-timeout property for more details.
   * 
   * @newin{2,26}
   * @return Timeout to use for @a proxy.
   */
  int get_default_timeout() const;
  
  /** Sets the timeout to use if -1 (specifying default timeout) is
   * passed as @a timeout_msec in the g_dbus_proxy_call() and
   * g_dbus_proxy_call_sync() functions.
   * 
   * See the DBusProxy:g-default-timeout property for more details.
   * 
   * @newin{2,26}
   * @param timeout_msec Timeout in milliseconds.
   */
  void set_default_timeout(int timeout_msec);

  /** Looks up the value for a property from the cache. This call does no
   * blocking IO.
   *
   * If proxy has an expected interface (see property_g_interface_info()),
   * then @a property_name (for existence) is checked against it.
   *
   * @param property An output parameter in which to hold to the variant
   * instance that holds the value for @a property_name.
   * @param property_name Property name.
   *
   * @newin{2,26}
   */
  void get_cached_property(Glib::VariantBase& property,
    const Glib::ustring& property_name) const;
  

  /** If @a value is not <tt>0</tt>, sets the cached value for the property with
   * name @a property_name to the value in @a value.
   * 
   * If @a value is <tt>0</tt>, then the cached value is removed from the
   * property cache.
   * 
   * If @a proxy has an expected interface (see
   * DBusProxy:g-interface-info), then @a property_name (for existence)
   * and @a value (for the type) is checked against it.
   * 
   * If the @a value Variant is floating, it is consumed. This allows
   * convenient 'inline' use of Glib::variant_new(), e.g.
   * |[
   * g_dbus_proxy_set_cached_property (proxy,
   * "SomeProperty",
   * g_variant_new ("(si)",
   * "A String",
   * 42));
   * ]|
   * 
   * Normally you will not need to use this method since @a proxy is
   * tracking changes using the
   * <literal>org.freedesktop.DBus.Properties.PropertiesChanged</literal>
   * D-Bus signal. However, for performance reasons an object may decide
   * to not use this signal for some properties and instead use a
   * proprietary out-of-band mechanism to transmit changes.
   * 
   * As a concrete example, consider an object with a property
   * <literal>ChatroomParticipants</literal> which is an array of
   * strings. Instead of transmitting the same (long) array every time
   * the property changes, it is more efficient to only transmit the
   * delta using e.g. signals <literal>ChatroomParticipantJoined(String
   * name)</literal> and <literal>ChatroomParticipantParted(String
   * name)</literal>.
   * 
   * @newin{2,26}
   * @param property_name Property name.
   * @param value Value for the property or <tt>0</tt> to remove it from the cache.
   */
  void set_cached_property(const Glib::ustring& property_name, const Glib::VariantBase& value);

 
  /** Gets the names of all cached properties on @a proxy.
   * 
   * @newin{2,26}
   * @return A <tt>0</tt>-terminated array of strings or <tt>0</tt> if @a proxy has
   * no cached properties. Free the returned array with Glib::strfreev().
   */
  Glib::StringArrayHandle get_cached_property_names() const;

  
  /** Ensure that interactions with @a proxy conform to the given
   * interface.  For example, when completing a method call, if the type
   * signature of the message isn't what's expected, the given Error
   * is set.  Signals that have a type signature mismatch are simply
   * dropped.
   * 
   * See the DBusProxy:g-interface-info property for more details.
   * 
   * @newin{2,26}
   * @param info Minimum interface this proxy conforms to or <tt>0</tt> to unset.
   */
  void set_interface_info(const Glib::RefPtr<DBusInterfaceInfo>& info);
  
  /** Returns the DBusInterfaceInfo, if any, specifying the minimal
   * interface that @a proxy conforms to.
   * 
   * See the DBusProxy:g-interface-info property for more details.
   * 
   * @newin{2,26}
   * @return A DBusInterfaceInfo or <tt>0</tt>. Do not unref the returned
   * object, it is owned by @a proxy.
   */
  Glib::RefPtr<DBusInterfaceInfo> get_interface_info();
  
  /** Returns the DBusInterfaceInfo, if any, specifying the minimal
   * interface that @a proxy conforms to.
   * 
   * See the DBusProxy:g-interface-info property for more details.
   * 
   * @newin{2,26}
   * @return A DBusInterfaceInfo or <tt>0</tt>. Do not unref the returned
   * object, it is owned by @a proxy.
   */
  Glib::RefPtr<const DBusInterfaceInfo> get_interface_info() const;

  
  /** Asynchronously invokes the @a method_name method on @a proxy.
   * 
   * If @a method_name contains any dots, then @a name is split into interface and
   * method name parts. This allows using @a proxy for invoking methods on
   * other interfaces.
   * 
   * If the DBusConnection associated with @a proxy is closed then
   * the operation will fail with IO_ERROR_CLOSED. If
   *  @a cancellable is canceled, the operation will fail with
   * IO_ERROR_CANCELLED. If @parameters contains a value not
   * compatible with the D-Bus protocol, the operation fails with
   * IO_ERROR_INVALID_ARGUMENT.
   * 
   * If the @parameters Variant is floating, it is consumed. This allows
   * convenient 'inline' use of Glib::variant_new(), e.g.:
   * |[
   * g_dbus_proxy_call (proxy,
   * "TwoStrings",
   * g_variant_new ("(ss)",
   * "Thing One",
   * "Thing Two"),
   * G_DBUS_CALL_FLAGS_NONE,
   * -1,
   * <tt>0</tt>,
   * (GAsyncReadyCallback) two_strings_done,
   * &data);
   * ]|
   * 
   * This is an asynchronous method. When the operation is finished,
   *  @a callback will be invoked in the
   * <link linkend="g-main-context-push-thread-default">thread-default
   * main loop</link> of the thread you are calling this method from.
   * You can then call g_dbus_proxy_call_finish() to get the result of
   * the operation. See g_dbus_proxy_call_sync() for the synchronous
   * version of this method.
   * 
   * @newin{2,26}
   * @param method_name Name of method to invoke.
   * @param parameters A Variant tuple with parameters for the signal or <tt>0</tt> if not passing parameters.
   * @param flags Flags from the DBusCallFlags enumeration.
   * @param timeout_msec The timeout in milliseconds or -1 to use the proxy default timeout.
   * @param cancellable A Cancellable or <tt>0</tt>.
   * @param callback A AsyncReadyCallback to call when the request is satisfied or <tt>0</tt> if you don't
   * care about the result of the method invocation.
   * @param user_data The data to pass to @a callback.
   */

  void call(const Glib::ustring& method_name,
    int timeout_msec, const SlotAsyncReady& slot,
    DBusCallFlags flags = Gio::DBUS_CALL_FLAGS_NONE,
    const Glib::VariantBase& parameters = Glib::VariantBase(),
    const Glib::RefPtr<Cancellable>& cancellable = Glib::RefPtr<Cancellable>());

  /** Finishes an operation started with call().
   *
   * @param ret An output variable in which to store the return.
   * @param res An AsyncResult obtained from the SlotAsyncReady passed to
   * call().
   *
   * @throw Glib::Error.
   */
  void call_finish(Glib::VariantBase& ret, const Glib::RefPtr<AsyncResult>& res);
  

  /** Synchronously invokes the method_name method on proxy.
   * See call(), the asynchronous version of this method for more information.
   *
   * @param result An output parameter in which to store the return.
   * @param method_name Name of method to invoke.
   * @param timeout_msec The timeout in milliseconds or -1 to use the proxy
   * default timeout.
   * @param flags Flags from the DBusCallFlags enumeration.
   * @param parameters A Glib::VariantBase tuple with parameters for the
   * signal.
   * @param cancellable A Cancellable.
   *
   * @throw Glib::Error.
   */
  void call_sync(Glib::VariantBase& result, const Glib::ustring& method_name,
    int timeout_msec,
    DBusCallFlags flags = Gio::DBUS_CALL_FLAGS_NONE,
    const Glib::VariantBase& parameters = Glib::VariantBase(),
    const Glib::RefPtr<Cancellable>& cancellable = Glib::RefPtr<Cancellable>());
  

 //gtkmmproc error: g-bus-type : attempt to wrap write-only and construct-only property.
 #ifdef GLIBMM_PROPERTIES_ENABLED
/** The connection the proxy is for.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DBusConnection> > property_g_connection() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


 #ifdef GLIBMM_PROPERTIES_ENABLED
/** Timeout for remote method invocation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_g_default_timeout() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Timeout for remote method invocation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_g_default_timeout() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

 #ifdef GLIBMM_PROPERTIES_ENABLED
/** Flags for the proxy.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<DBusProxyFlags> property_g_flags() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


 #ifdef GLIBMM_PROPERTIES_ENABLED
/** Interface Information.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<DBusInterfaceInfo> > property_g_interface_info() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Interface Information.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DBusInterfaceInfo> > property_g_interface_info() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

 #ifdef GLIBMM_PROPERTIES_ENABLED
/** The D-Bus interface name the proxy is for.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_g_interface_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


 #ifdef GLIBMM_PROPERTIES_ENABLED
/** The well-known or unique name that the proxy is for.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_g_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


 #ifdef GLIBMM_PROPERTIES_ENABLED
/** The unique name for the owner.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_g_name_owner() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


 #ifdef GLIBMM_PROPERTIES_ENABLED
/** The object path the proxy is for.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_g_object_path() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  //TODO: It's difficult to figure out conversions from/to GStrv (gchar**)
  //to/from std::vector<Glib::ustring>
 //_WRAP_SIGNAL(void properties_changed(const Glib::VariantBase& changed_properties, const std::vector<Glib::ustring>& invalidated_properties), g-properties-changed)

 
  /**
   * @par Prototype:
   * <tt>void on_my_%signal(const Glib::ustring& sender_name, const Glib::ustring& signal_name, const Glib::VariantBase& parameters)</tt>
   */

  Glib::SignalProxy3< void,const Glib::ustring&,const Glib::ustring&,const Glib::VariantBase& > signal_signal();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_signal(const Glib::ustring& sender_name, const Glib::ustring& signal_name, const Glib::VariantBase& parameters);


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBusProxy
   */
  Glib::RefPtr<Gio::DBusProxy> wrap(GDBusProxy* object, bool take_copy = false);
}


#endif /* _GIOMM_DBUSPROXY_H */

