/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif
	
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_TargetEntry_newTargetEntry(JNIEnv *env, jclass cls, jstring name, jint flags, jint id) 
{
	GtkTargetEntry *targetEntry = 
            (GtkTargetEntry *)g_malloc(sizeof(GtkTargetEntry));
	targetEntry->target = 
            (gchar *) (*env)->GetStringUTFChars( env, name, NULL );
	targetEntry->flags = (guint) flags;
	targetEntry->info = (guint) id;

	return getHandleFromPointer(env, targetEntry);
}
	
#ifdef __cplusplus
}

#endif
