/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * The VPaned widget is a container widget with two children arranged
 * vertically.  The division between the two panes is adjustable by
 * the user by dragging a handle.
 * 
 * @see Paned
 */
public class VPaned extends Paned {
	/**
	 * Construct a new VPaned object.
	 */
	public VPaned() {
		super(gtk_vpaned_new());
	}
	
	/**
	 * Construct a new VPaned from a handle to a native resource.
	 */
	public VPaned(int handle) {
	    super(handle);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_vpaned_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_vpaned_get_type();
	native static final protected int gtk_vpaned_new();
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
