AC_DEFUN([JG_COMMON],[

dnl dependencies needed by most projects

dnl check to see if the user wants to generate javadoc
AC_ARG_WITH(javadocs,[  --without-javadocs    Do not build the javadocs for the bindings],
        javadocs="no", javadocs="yes")
AM_CONDITIONAL(BUILD_JAVADOC, test $javadocs = "yes")

AC_ARG_WITH([jardir], AS_HELP_STRING([--with-jardir],
		      [where to install jar files]),
            [jardir="$with_jardir"], [jardir="${datadir}/java"])
AC_SUBST(jardir)

dnl Checks for programs.
AC_PROG_CC
AC_PROG_INSTALL
AM_PATH_DOCBOOK
AC_PROG_JAVAC
if test $javadocs = "yes"; then
	AC_PROG_JAVADOC
fi
AC_PROG_JAR
 
JG_CHECK_NATIVECOMPILE

dnl Checks for libraries.
dnl Replace `main' with a function in -libs:
AC_CHECK_LIB(ibs, main)

dnl Check for GTK >= 2.0 and GNOME >= 1.0
PKG_CHECK_MODULES(GTK, gtk+-2.0 >= 2.4.0)
AC_SUBST(GTK_CFLAGS)
AC_SUBST(GTK_LIBS)

AC_SUBST(TOPLEVEL_TARGETS)
AC_SUBST(INSTALL_TARGETS)
AC_SUBST(UNINSTALL_TARGETS)
AC_SUBST(MACRO_FLAG)

dnl Checks for header files.
dnl Fails at this stage
dnl AC_CHECK_FILE(jni.h)

dnl Checks for typedefs, structures, and compiler characteristics.
AC_C_CONST

dnl Checks for library functions.
AC_FUNC_ALLOCA

])
