/*
 * Java-Gnome Bindings Library
 *
 * * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

import org.gnu.gtk.Widget;

/**
 * @author Tom Ball
 *
 * This event is fired when container-specific changes are made, such
 * as adding a child widget to a container.
 * 
 * @see ContainerListener
 */
public class ContainerEvent extends GtkEvent {

	private Widget child;

	public static class Type extends GtkEventType {
		private Type(int id, String name) {
			super(id, name);
		}

		/**
		 * This event indicates that a child widget has been
		 * added to the container.
		 */
		public static final Type ADD = new Type(1, "ADD");

		/**
		 * This event indicates that ...
		 */
		public static final Type CHECK_RESIZE = new Type(2, "CHECK_RESIZE");

		/**
		 * This event indicates that a child widget has been
		 * removed to the container.
		 */
		public static final Type REMOVE = new Type(1, "REMOVE");

		/**
		 * This event indicates that a child widget has been
		 * given focus.
		 */
		public static final Type SET_FOCUS_CHILD = new Type(1, "SET_FOCUS_CHILD");
	}

	/**
	 * Construct a ContainerEvent object.
	 */
	public ContainerEvent(Object source, ContainerEvent.Type type) {
		this(source, type, null);
	}

	/**
	 * Construct a ContainerEvent object with a specified child.
	 */
	public ContainerEvent(Object source, ContainerEvent.Type type, Widget child) {
		super(source, type);
		this.child = child;
	}

	/**
	 * Return the child widget associated with this ContainerEvent, or
	 * null if no child is involved.  The CHECK_RESIZE event does not
	 * have an associated child widget.
	 */
	public Widget getChild() {
		return child;
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(ContainerEvent.Type aType) {
		return (type.getID() == aType.getID());
	}
}
