/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-01 07:00:33 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <string.h>
#include <gdk/gdk.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_render_threshold_alpha
     * Signature: (IIIIIIIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1render_1threshold_1alpha (JNIEnv 
        *env, jclass cls, jint pixbuf, jint bitmap, jint srcX, jint srcY, jint destX, jint destY, 
        jint width, jint height, jint alphaThreshold) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        GdkBitmap *bitmap_g = (GdkBitmap *)bitmap;
        gint32 srcX_g = (gint32) srcX;
        gint32 srcY_g = (gint32) srcY;
        gint32 destX_g = (gint32) destX;
        gint32 destY_g = (gint32) destY;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        gint32 alphaThreshold_g = (gint32) alphaThreshold;
        {
            gdk_pixbuf_render_threshold_alpha (pixbuf_g, bitmap_g, srcX_g, srcY_g, destX_g, 
                destY_g, width_g, height_g, alphaThreshold_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_render_to_drawable
     * Signature: (IIIIIIIIIIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1render_1to_1drawable (JNIEnv *env, 
        jclass cls, jint pixbuf, jint drawable, jint gc, jint srcX, jint srcY, jint destX, jint 
        destY, jint width, jint height, jint dither, jint xDither, jint yDither) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        GdkDrawable *drawable_g = (GdkDrawable *)drawable;
        GdkGC *gc_g = (GdkGC *)gc;
        gint32 srcX_g = (gint32) srcX;
        gint32 srcY_g = (gint32) srcY;
        gint32 destX_g = (gint32) destX;
        gint32 destY_g = (gint32) destY;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        GdkRgbDither dither_g = (GdkRgbDither) dither;
        gint32 xDither_g = (gint32) xDither;
        gint32 yDither_g = (gint32) yDither;
        {
            gdk_pixbuf_render_to_drawable (pixbuf_g, drawable_g, gc_g, srcX_g, srcY_g, destX_g, 
                destY_g, width_g, height_g, dither_g, xDither_g, yDither_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_render_to_drawable_alpha
     * Signature: (IIIIIIIIIIIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1render_1to_1drawable_1alpha (JNIEnv 
        *env, jclass cls, jint pixbuf, jint drawable, jint srcX, jint srcY, jint destX, jint destY, 
        jint width, jint height, jint alphaMode, jint alphaThreshold, jint dither, jint xDither, 
        jint yDither) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        GdkDrawable *drawable_g = (GdkDrawable *)drawable;
        gint32 srcX_g = (gint32) srcX;
        gint32 srcY_g = (gint32) srcY;
        gint32 destX_g = (gint32) destX;
        gint32 destY_g = (gint32) destY;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        GdkPixbufAlphaMode alphaMode_g = (GdkPixbufAlphaMode) alphaMode;
        gint32 alphaThreshold_g = (gint32) alphaThreshold;
        GdkRgbDither dither_g = (GdkRgbDither) dither;
        gint32 xDither_g = (gint32) xDither;
        gint32 yDither_g = (gint32) yDither;
        {
            gdk_pixbuf_render_to_drawable_alpha (pixbuf_g, drawable_g, srcX_g, srcY_g, destX_g, 
                destY_g, width_g, height_g, alphaMode_g, alphaThreshold_g, dither_g, xDither_g, 
                yDither_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_render_pixmap_and_mask_for_colormap
     * Signature: (IIIII)V
     */
    JNIEXPORT void JNICALL 
    Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1render_1pixmap_1and_1mask_1for_1colormap (JNIEnv *env, 
        jclass cls, jint pixbuf, jint colormap, jint pixmapReturn, jint maskReturn, jint 
        alphaThreshold) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        GdkColormap *colormap_g = (GdkColormap *)colormap;
        GdkPixmap **pixmapReturn_g = (GdkPixmap **)pixmapReturn;
        GdkBitmap **maskReturn_g = (GdkBitmap **)maskReturn;
        gint32 alphaThreshold_g = (gint32) alphaThreshold;
        {
            gdk_pixbuf_render_pixmap_and_mask_for_colormap (pixbuf_g, colormap_g, pixmapReturn_g, 
                maskReturn_g, alphaThreshold_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_render_pixmap_and_mask
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1render_1pixmap_1and_1mask (JNIEnv 
        *env, jclass cls, jint pixbuf, jint pixmapReturn, jint maskReturn, jint alphaThreshold) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        GdkPixmap **pixmapReturn_g = (GdkPixmap **)pixmapReturn;
        GdkBitmap **maskReturn_g = (GdkBitmap **)maskReturn;
        gint32 alphaThreshold_g = (gint32) alphaThreshold;
        {
            gdk_pixbuf_render_pixmap_and_mask (pixbuf_g, pixmapReturn_g, maskReturn_g, 
                alphaThreshold_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_get_from_drawable
     * Signature: (IIIIIIIII)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1get_1from_1drawable (JNIEnv *env, 
        jclass cls, jint dest, jint src, jint cmap, jint srcX, jint srcY, jint destX, jint destY, 
        jint width, jint height) 
    {
        GdkPixbuf *dest_g = (GdkPixbuf *)dest;
        GdkDrawable *src_g = (GdkDrawable *)src;
        GdkColormap *cmap_g = (GdkColormap *)cmap;
        gint32 srcX_g = (gint32) srcX;
        gint32 srcY_g = (gint32) srcY;
        gint32 destX_g = (gint32) destX;
        gint32 destY_g = (gint32) destY;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        {
            return (jint)gdk_pixbuf_get_from_drawable (dest_g, src_g, cmap_g, srcX_g, srcY_g, 
                destX_g, destY_g, width_g, height_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_get_from_image
     * Signature: (IIIIIIIII)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1get_1from_1image (JNIEnv *env, 
        jclass cls, jint dest, jint src, jint cmap, jint srcX, jint srcY, jint destX, jint destY, 
        jint width, jint height) 
    {
        GdkPixbuf *dest_g = (GdkPixbuf *)dest;
        GdkImage *src_g = (GdkImage *)src;
        GdkColormap *cmap_g = (GdkColormap *)cmap;
        gint32 srcX_g = (gint32) srcX;
        gint32 srcY_g = (gint32) srcY;
        gint32 destX_g = (gint32) destX;
        gint32 destY_g = (gint32) destY;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        {
            return (jint)gdk_pixbuf_get_from_image (dest_g, src_g, cmap_g, srcX_g, srcY_g, destX_g, 
                destY_g, width_g, height_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_get_colorspace
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1get_1colorspace (JNIEnv *env, 
        jclass cls, jint pixbuf) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        {
            jint result_j = (jint) (gdk_pixbuf_get_colorspace (pixbuf_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_get_n_channels
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1get_1n_1channels (JNIEnv *env, 
        jclass cls, jint pixbuf) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        {
            jint result_j = (jint) (gdk_pixbuf_get_n_channels (pixbuf_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_get_has_alpha
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1get_1has_1alpha (JNIEnv *env, 
        jclass cls, jint pixbuf) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        {
            jboolean result_j = (jboolean) (gdk_pixbuf_get_has_alpha (pixbuf_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_get_bits_per_sample
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1get_1bits_1per_1sample (JNIEnv 
        *env, jclass cls, jint pixbuf) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        {
            jint result_j = (jint) (gdk_pixbuf_get_bits_per_sample (pixbuf_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_get_pixels
     * Signature: (I)[B
     */
    JNIEXPORT jbyteArray JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1get_1pixels (JNIEnv *env, 
        jclass cls, jint pixbuf) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        {
            gchar *result_g = gdk_pixbuf_get_pixels (pixbuf_g);
            jsize result_len = result_g ? strlen (result_g) : 0;
            jbyteArray result_j = result_g ? (*env)->NewByteArray (env, result_len) : NULL;
            if (result_g) (*env)->SetByteArrayRegion (env, result_j, 0, result_len, result_g);
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_get_width
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1get_1width (JNIEnv *env, jclass 
        cls, jint pixbuf) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        {
            jint result_j = (jint) (gdk_pixbuf_get_width (pixbuf_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_get_height
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1get_1height (JNIEnv *env, jclass 
        cls, jint pixbuf) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        {
            jint result_j = (jint) (gdk_pixbuf_get_height (pixbuf_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_get_rowstride
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1get_1rowstride (JNIEnv *env, jclass 
        cls, jint pixbuf) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        {
            jint result_j = (jint) (gdk_pixbuf_get_rowstride (pixbuf_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_new
     * Signature: (IZIII)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1new (JNIEnv *env, jclass cls, jint 
        colorspace, jboolean hasAlpha, jint bitsPerSample, jint width, jint height) 
    {
        GdkColorspace colorspace_g = (GdkColorspace) colorspace;
        gboolean hasAlpha_g = (gboolean) hasAlpha;
        gint32 bitsPerSample_g = (gint32) bitsPerSample;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        {
            return (jint)gdk_pixbuf_new (colorspace_g, hasAlpha_g, bitsPerSample_g, width_g, 
                height_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_copy
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1copy (JNIEnv *env, jclass cls, jint 
        pixbuf) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        {
            return (jint)gdk_pixbuf_copy (pixbuf_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_new_subpixbuf
     * Signature: (IIIII)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1new_1subpixbuf (JNIEnv *env, jclass 
        cls, jint srcPixbuf, jint srcX, jint srcY, jint width, jint height) 
    {
        GdkPixbuf *srcPixbuf_g = (GdkPixbuf *)srcPixbuf;
        gint32 srcX_g = (gint32) srcX;
        gint32 srcY_g = (gint32) srcY;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        {
            return (jint)gdk_pixbuf_new_subpixbuf (srcPixbuf_g, srcX_g, srcY_g, width_g, height_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_new_from_file
     * Signature: (java.lang.String;I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1new_1from_1file (JNIEnv *env, 
        jclass cls, jstring filename, jint error) 
    {
        const gchar* filename_g = (*env)->GetStringUTFChars(env, filename, 0);
        jint result =  (jint)gdk_pixbuf_new_from_file (filename_g, (GError**)error);
        (*env)->ReleaseStringUTFChars(env, filename, filename_g);
        return result;
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_new_from_xpm_data
     * Signature: ([B)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1new_1from_1xpm_1data (JNIEnv *env, 
        jclass cls, jbyteArray data) 
    {
        jint data_len = (*env)->GetArrayLength(env, data);
        const gchar** data_g = (const gchar**)g_malloc(data_len + 1);
        (*env)->GetByteArrayRegion(env, data, 0, data_len, (jbyte*)data_g);
        data_g[data_len] = 0;
        {
            return (jint)gdk_pixbuf_new_from_xpm_data (data_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_new_from_inline
     * Signature: (I[BZI)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1new_1from_1inline (JNIEnv *env, 
        jclass cls, jint dataLength, jbyteArray data, jboolean copyPixels, jint error) 
    {
        gint32 dataLength_g = (gint32) dataLength;
        jint data_len = (*env)->GetArrayLength(env, data);
        gchar* data_g = (gchar*)g_malloc(data_len + 1);
        gboolean copyPixels_g = (gboolean) copyPixels;
        GError **error_g = (GError **)error;
        (*env)->GetByteArrayRegion(env, data, 0, data_len, (jbyte*)data_g);
        data_g[data_len] = 0;
        {
            return (jint)gdk_pixbuf_new_from_inline (dataLength_g, data_g, copyPixels_g, error_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_fill
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1fill (JNIEnv *env, jclass cls, jint 
        pixbuf, jint pixel) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        gint32 pixel_g = (gint32) pixel;
        {
            gdk_pixbuf_fill (pixbuf_g, pixel_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_add_alpha
     * Signature: (IZIII)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1add_1alpha (JNIEnv *env, jclass 
        cls, jint pixbuf, jboolean substituteColor, jint r, jint g, jint b) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        gboolean substituteColor_g = (gboolean) substituteColor;
        gint32 r_g = (gint32) r;
        gint32 g_g = (gint32) g;
        gint32 b_g = (gint32) b;
        {
            return (jint)gdk_pixbuf_add_alpha (pixbuf_g, substituteColor_g, r_g, g_g, b_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_copy_area
     * Signature: (IIIIIIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1copy_1area (JNIEnv *env, jclass 
        cls, jint srcPixbuf, jint srcX, jint srcY, jint width, jint height, jint destPixbuf, jint 
        destX, jint destY) 
    {
        GdkPixbuf *srcPixbuf_g = (GdkPixbuf *)srcPixbuf;
        gint32 srcX_g = (gint32) srcX;
        gint32 srcY_g = (gint32) srcY;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        GdkPixbuf *destPixbuf_g = (GdkPixbuf *)destPixbuf;
        gint32 destX_g = (gint32) destX;
        gint32 destY_g = (gint32) destY;
        {
            gdk_pixbuf_copy_area (srcPixbuf_g, srcX_g, srcY_g, width_g, height_g, destPixbuf_g, 
                destX_g, destY_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_saturate_and_pixelate
     * Signature: (IIDZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1saturate_1and_1pixelate (JNIEnv 
        *env, jclass cls, jint src, jint dest, jdouble saturation, jboolean pixelate) 
    {
        GdkPixbuf *src_g = (GdkPixbuf *)src;
        GdkPixbuf *dest_g = (GdkPixbuf *)dest;
        gdouble saturation_g = (gdouble) saturation;
        gboolean pixelate_g = (gboolean) pixelate;
        {
            gdk_pixbuf_saturate_and_pixelate (src_g, dest_g, saturation_g, pixelate_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_scale
     * Signature: (IIIIIIDDDDI)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1scale (JNIEnv *env, jclass cls, 
        jint src, jint dest, jint destX, jint destY, jint destWidth, jint destHeight, jdouble 
        offsetX, jdouble offsetY, jdouble scaleX, jdouble scaleY, jint interpType) 
    {
        GdkPixbuf *src_g = (GdkPixbuf *)src;
        GdkPixbuf *dest_g = (GdkPixbuf *)dest;
        gint32 destX_g = (gint32) destX;
        gint32 destY_g = (gint32) destY;
        gint32 destWidth_g = (gint32) destWidth;
        gint32 destHeight_g = (gint32) destHeight;
        gdouble offsetX_g = (gdouble) offsetX;
        gdouble offsetY_g = (gdouble) offsetY;
        gdouble scaleX_g = (gdouble) scaleX;
        gdouble scaleY_g = (gdouble) scaleY;
        GdkInterpType interpType_g = (GdkInterpType) interpType;
        {
            gdk_pixbuf_scale (src_g, dest_g, destX_g, destY_g, destWidth_g, destHeight_g, 
                offsetX_g, offsetY_g, scaleX_g, scaleY_g, interpType_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_composite
     * Signature: (IIIIIIDDDDII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1composite (JNIEnv *env, jclass cls, 
        jint src, jint dest, jint destX, jint destY, jint destWidth, jint destHeight, jdouble 
        offsetX, jdouble offsetY, jdouble scaleX, jdouble scaleY, jint interpType, jint 
        overallAlpha) 
    {
        GdkPixbuf *src_g = (GdkPixbuf *)src;
        GdkPixbuf *dest_g = (GdkPixbuf *)dest;
        gint32 destX_g = (gint32) destX;
        gint32 destY_g = (gint32) destY;
        gint32 destWidth_g = (gint32) destWidth;
        gint32 destHeight_g = (gint32) destHeight;
        gdouble offsetX_g = (gdouble) offsetX;
        gdouble offsetY_g = (gdouble) offsetY;
        gdouble scaleX_g = (gdouble) scaleX;
        gdouble scaleY_g = (gdouble) scaleY;
        GdkInterpType interpType_g = (GdkInterpType) interpType;
        gint32 overallAlpha_g = (gint32) overallAlpha;
        {
            gdk_pixbuf_composite (src_g, dest_g, destX_g, destY_g, destWidth_g, destHeight_g, 
                offsetX_g, offsetY_g, scaleX_g, scaleY_g, interpType_g, overallAlpha_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_composite_color
     * Signature: (IIIIIIDDDDIIIIIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1composite_1color (JNIEnv *env, 
        jclass cls, jint src, jint dest, jint destX, jint destY, jint destWidth, jint destHeight, 
        jdouble offsetX, jdouble offsetY, jdouble scaleX, jdouble scaleY, jint interpType, jint 
        overallAlpha, jint checkX, jint checkY, jint checkSize, jint color1, jint color2) 
    {
        GdkPixbuf *src_g = (GdkPixbuf *)src;
        GdkPixbuf *dest_g = (GdkPixbuf *)dest;
        gint32 destX_g = (gint32) destX;
        gint32 destY_g = (gint32) destY;
        gint32 destWidth_g = (gint32) destWidth;
        gint32 destHeight_g = (gint32) destHeight;
        gdouble offsetX_g = (gdouble) offsetX;
        gdouble offsetY_g = (gdouble) offsetY;
        gdouble scaleX_g = (gdouble) scaleX;
        gdouble scaleY_g = (gdouble) scaleY;
        GdkInterpType interpType_g = (GdkInterpType) interpType;
        gint32 overallAlpha_g = (gint32) overallAlpha;
        gint32 checkX_g = (gint32) checkX;
        gint32 checkY_g = (gint32) checkY;
        gint32 checkSize_g = (gint32) checkSize;
        gint32 color1_g = (gint32) color1;
        gint32 color2_g = (gint32) color2;
        {
            gdk_pixbuf_composite_color (src_g, dest_g, destX_g, destY_g, destWidth_g, destHeight_g, 
                offsetX_g, offsetY_g, scaleX_g, scaleY_g, interpType_g, overallAlpha_g, checkX_g, 
                checkY_g, checkSize_g, color1_g, color2_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_scale_simple
     * Signature: (IIII)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1scale_1simple (JNIEnv *env, jclass 
        cls, jint src, jint destWidth, jint destHeight, jint interpType) 
    {
        GdkPixbuf *src_g = (GdkPixbuf *)src;
        gint32 destWidth_g = (gint32) destWidth;
        gint32 destHeight_g = (gint32) destHeight;
        GdkInterpType interpType_g = (GdkInterpType) interpType;
        {
            return (jint)gdk_pixbuf_scale_simple (src_g, destWidth_g, destHeight_g, interpType_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_composite_color_simple
     * Signature: (IIIIIIII)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1composite_1color_1simple (JNIEnv 
        *env, jclass cls, jint src, jint destWidth, jint destHeight, jint interpType, jint 
        overallAlpha, jint checkSize, jint color1, jint color2) 
    {
        GdkPixbuf *src_g = (GdkPixbuf *)src;
        gint32 destWidth_g = (gint32) destWidth;
        gint32 destHeight_g = (gint32) destHeight;
        GdkInterpType interpType_g = (GdkInterpType) interpType;
        gint32 overallAlpha_g = (gint32) overallAlpha;
        gint32 checkSize_g = (gint32) checkSize;
        gint32 color1_g = (gint32) color1;
        gint32 color2_g = (gint32) color2;
        {
            return (jint)gdk_pixbuf_composite_color_simple (src_g, destWidth_g, destHeight_g, 
                interpType_g, overallAlpha_g, checkSize_g, color1_g, color2_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixbuf
     * Method:    gdk_pixbuf_get_option
     * Signature: (I[B)[B
     */
    JNIEXPORT jbyteArray JNICALL Java_org_gnu_gdk_Pixbuf_gdk_1pixbuf_1get_1option (JNIEnv *env, 
        jclass cls, jint pixbuf, jbyteArray key) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        jint key_len = (*env)->GetArrayLength(env, key);
        gchar* key_g = (gchar*)g_malloc(key_len + 1);
        (*env)->GetByteArrayRegion(env, key, 0, key_len, (jbyte*)key_g);
        key_g[key_len] = 0;
        {
            gchar *result_g = (gchar*)gdk_pixbuf_get_option (pixbuf_g, key_g);
            jsize result_len = result_g ? strlen (result_g) : 0;
            jbyteArray result_j = result_g ? (*env)->NewByteArray (env, result_len) : NULL;
            if (result_g) (*env)->SetByteArrayRegion (env, result_j, 0, result_len, result_g);
            return result_j;
        }
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
