/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 16:40:18 EDT
 */

package org.gnu.gdk;
import org.gnu.glib.GObject;
/**
 *
 */
public class PixbufLoader extends GObject 
{
	/**
	 * Construct a new PixbufLoader
	 */
	public PixbufLoader() {
		handle = gdk_pixbuf_loader_new();
	}
	
	/**
	 * Construct a new PixbufLoader
	 */
	public PixbufLoader(String imageType) {
		int error = 0;
		handle = gdk_pixbuf_loader_new_with_type(imageType, error);
	}
	
	public boolean write(byte[] buffer) {
		int error = 0;
		return gdk_pixbuf_loader_write(handle, buffer, buffer.length, error);
	}
	
	public Pixbuf getPixbuf() {
		return new Pixbuf(gdk_pixbuf_loader_get_pixbuf(handle));
	}
	
	public PixbufAnimation getPixbufAnimation() {
		return new PixbufAnimation(gdk_pixbuf_loader_get_animation(handle));
	}
	
	public boolean close() {
		int error = 0;
		return gdk_pixbuf_loader_close(handle, error);
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gdk_pixbuf_loader_get_type ();
    native static final protected int gdk_pixbuf_loader_new ();
    native static final protected int gdk_pixbuf_loader_new_with_type (String imageType, int error);
    native static final protected boolean gdk_pixbuf_loader_write (int loader, byte[] buf, int 
        count, int error);
    native static final protected int gdk_pixbuf_loader_get_pixbuf (int loader);
    native static final protected int gdk_pixbuf_loader_get_animation (int loader);
    native static final protected boolean gdk_pixbuf_loader_close (int loader, int error);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

