// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_DRAWABLE_H
#define _GDKMM_DRAWABLE_H

#include <glibmm.h>

/* $Id: drawable.hg,v 1.1.1.1 2003/01/21 13:38:08 murrayc Exp $ */

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdkdrawable.h>
#include <gdk/gdkrgb.h>
#include <pangomm/font.h>
#include <pangomm/layout.h>
#include <pangomm/layoutline.h>
#include <pangomm/glyphstring.h>
#include <gdkmm/gc.h>
#include <gdkmm/image.h>
#include <gdkmm/color.h>
#include <gdkmm/region.h>
#include <gdkmm/rgbcmap.h>
#include <gdkmm/types.h>
//#include <gdkmm/pixbuf.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkDrawable GdkDrawable;
typedef struct _GdkDrawableClass GdkDrawableClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class Drawable_Class; } // namespace Gdk
namespace Gdk
{


/** @addtogroup gdkmmEnums Enums and Flags */

/**
 * @ingroup gdkmmEnums
 */
enum RgbDither
{
  RGB_DITHER_NONE,
  RGB_DITHER_NORMAL,
  RGB_DITHER_MAX
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::RgbDither> : public Glib::Value_Enum<Gdk::RgbDither>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


class GC;
class Pixbuf;

/** Drawing Primitives.
 * Gdk::Drawable is the base class for all of the objects that accept drawing
 * commands.  The available drawables include pixmaps, windows, and bitmaps.
 * Drawable is abstract as there is no such type on the server side.
 *
 * To use a drawable, create a concrete Drawable of the type you wish to use
 * and a Gdk::GC (graphics context) for that Drawable.  With the GC you can
 * draw lines, text, arcs and such.
 */

class Drawable : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Drawable CppObjectType;
  typedef Drawable_Class CppClassType;
  typedef GdkDrawable BaseObjectType;
  typedef GdkDrawableClass BaseClassType;

private:  friend class Drawable_Class;
  static CppClassType drawable_class_;

private:
  // noncopyable
  Drawable(const Drawable&);
  Drawable& operator=(const Drawable&);

protected:
  explicit Drawable(const Glib::ConstructParams& construct_params);
  explicit Drawable(GdkDrawable* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Drawable();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkDrawable*       gobj()       { return reinterpret_cast<GdkDrawable*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkDrawable* gobj() const { return reinterpret_cast<GdkDrawable*>(gobject_); }

  GdkDrawable* gobj_copy();

private:

  
protected:
  Drawable();

public:
  
  static Glib::RefPtr<Drawable> create();


  void get_size(int& width, int& height);
  
  int get_depth() const;

  
  void set_colormap(const Glib::RefPtr<Colormap>& colormap);
  
  Glib::RefPtr<Colormap> get_colormap();
  
  Glib::RefPtr<Visual> get_visual();

  
  void draw_point(const Glib::RefPtr<const GC>& gc, int x, int y);
  void draw_points(const Glib::RefPtr<const GC>& gc, const Glib::ArrayHandle<Point>& points);

  
  void draw_line(const Glib::RefPtr<const GC>& gc, int x1, int y1, int x2, int y2);
  void draw_lines(const Glib::RefPtr<const GC>& gc, const Glib::ArrayHandle<Point>& points);

  
  void draw_rectangle(const Glib::RefPtr<const GC>& gc, bool filled, int x, int y, int width, int height);
  
  void draw_arc(const Glib::RefPtr<const GC>& gc, bool filled, int x, int y, int width, int height, int angle1, int angle2);
  void draw_polygon(const Glib::RefPtr<const GC>& gc, bool filled, const Glib::ArrayHandle<Point>& points);

  
  void draw_drawable(const Glib::RefPtr<const GC>& gc, const Glib::RefPtr<const Drawable>& src, int xsrc, int ysrc, int xdest, int ydest, int width = -1, int height = -1);
  
  void draw_image(const Glib::RefPtr<const GC>& gc, const Glib::RefPtr<const Image>& image, int xsrc, int ysrc, int xdest, int ydest, int width = -1, int height = -1);

  //segs is an array, and this function will be used so little that it doesn't seem worth wrapping it to use a container of C++ types.
  
  void draw_segments(const Glib::RefPtr<const GC>& gc, GdkSegment* segs, int nsegs); // TODO

  //glyphs seems to be an array, and this function will be used so little that it doesn't seem worth wrapping it to use a container of Pango::GlyphString.
  
  void draw_glyphs(const Glib::RefPtr<const GC>& gc, const Glib::RefPtr<const Pango::Font>& font, int x, int y, PangoGlyphString* glyphs); // TODO

  
  void draw_layout_line(const Glib::RefPtr<const GC>& gc, int x, int y, const Glib::RefPtr<const Pango::LayoutLine>& line);
  
  void draw_layout_line(const Glib::RefPtr<const GC>& gc, int x, int y, const Glib::RefPtr<const Pango::LayoutLine>& line, const Color& foreground, const Color& background);

  
  void draw_layout(const Glib::RefPtr<const GC>& gc, int x, int y, const Glib::RefPtr<const Pango::Layout>& layout);
  
  void draw_layout(const Glib::RefPtr<const GC>& gc, int x, int y, const Glib::RefPtr<const Pango::Layout>& layout, const Color& foreground, const Color& background);

  
  void draw_pixbuf(const Glib::RefPtr<const GC>& gc, const Glib::RefPtr<Pixbuf>& pixbuf,
    int src_x, int src_y, int dest_x, int dest_y,
    int width, int height,
    RgbDither dither, int x_dither, int y_dither);

  // XXX: no 'refreturn' -- get_image() returns a newly created Image object.
  
  Glib::RefPtr<Image> get_image(int x, int y, int width, int height) const;

  
  Region get_clip_region() const;
  
  Region get_visible_region() const;


  // **** RGB stuff ****

  
  void draw_rgb_image(
                   const Glib::RefPtr<const GC>& gc,
                   int x, int y, int width, int height,
                   RgbDither dith, const guchar* rgb_buf, int rowstride);

  
  void draw_rgb_image_dithalign(
                   const Glib::RefPtr<const GC>& gc,
                   int x, int y, int width, int height,
                   RgbDither dith, const guchar* rgb_buf, int rowstride,
                   int xdith, int ydith);

  
  void draw_rgb_32_image(
                   const Glib::RefPtr<const GC>& gc,
                   int x, int y, int width, int height,
                   RgbDither dith, const guchar* rgb_buf, int rowstride);

  
  void draw_rgb_32_image_dithalign(
                   const Glib::RefPtr<const GC>& gc,
                   int x, int y, int width, int height,
                   RgbDither dith, const guchar* rgb_buf, int rowstride,
                   int xdith, int ydith);

  
  void draw_gray_image(
                   const Glib::RefPtr<const GC>& gc,
                   int x, int y, int width, int height,
                   RgbDither dith, const guchar* rgb_buf, int rowstride);

  
  void draw_indexed_image(
                   const Glib::RefPtr<const GC>& gc,
                   int x, int y, int width, int height,
                   RgbDither dith, const guchar* rgb_buf, int rowstride,
                   const RgbCmap& cmap);

  
  Glib::RefPtr<Screen> get_screen();
  
  Glib::RefPtr<const Screen> get_screen() const;

  
  Glib::RefPtr<Display> get_display();
  
  Glib::RefPtr<const Display> get_display() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


namespace Glib
{
  /** @relates Gdk::Drawable */
  Glib::RefPtr<Gdk::Drawable> wrap(GdkDrawable* object, bool take_copy = false);
}


#endif /* _GDKMM_DRAWABLE_H */

