#include <libglademm/xml.h>
#include <gtkmm.h>
#include <iostream>

const gchar buffer[] =
  "<?xml version=\"1.0\" standalone=\"no\"?> <!--*- mode: xml -*-->"
  "<!DOCTYPE glade-interface SYSTEM \"http://glade.gnome.org/glade-2.0.dtd\">"
  ""
  "<glade-interface>"
  ""
  "<widget class=\"GtkDialog\" id=\"DialogBasic\">"
  "  <property name=\"title\" translatable=\"yes\">basic libglademm example</property>"
  "  <property name=\"type\">GTK_WINDOW_TOPLEVEL</property>"
  "  <property name=\"window_position\">GTK_WIN_POS_NONE</property>"
  "  <property name=\"modal\">False</property>"
  "  <property name=\"resizable\">True</property>"
  "  <property name=\"destroy_with_parent\">False</property>"
  "  <property name=\"has_separator\">True</property>"
  ""
  "  <child internal-child=\"vbox\">"
  "    <widget class=\"GtkVBox\" id=\"dialog-vbox2\">"
  "      <property name=\"border_width\">2</property>"
  "      <property name=\"visible\">True</property>"
  "      <property name=\"homogeneous\">False</property>"
  "      <property name=\"spacing\">0</property>"
  ""
  "      <child internal-child=\"action_area\">"
  "        <widget class=\"GtkHButtonBox\" id=\"dialog-action_area2\">"
  "          <property name=\"border_width\">5</property>"
  "          <property name=\"visible\">True</property>"
  "          <property name=\"layout_style\">GTK_BUTTONBOX_END</property>"
  "          <property name=\"spacing\">10</property>"
  ""
  "          <child>"
  "            <widget class=\"GtkButton\" id=\"quit_button\">"
  "              <property name=\"visible\">True</property>"
  "              <property name=\"can_default\">True</property>"
  "              <property name=\"can_focus\">True</property>"
  "              <property name=\"label\">gtk-quit</property>"
  "              <property name=\"use_stock\">True</property>"
  "              <property name=\"relief\">GTK_RELIEF_NORMAL</property>"
  "              <property name=\"response_id\">0</property>"
  "            </widget>"
  "          </child>"
  "        </widget>"
  "        <packing>"
  "          <property name=\"padding\">0</property>"
  "          <property name=\"expand\">False</property>"
  "          <property name=\"fill\">True</property>"
  "          <property name=\"pack_type\">GTK_PACK_END</property>"
  "        </packing>"
  "      </child>"
  ""
  "      <child>"
  "        <widget class=\"GtkLabel\" id=\"label1\">"
  "          <property name=\"visible\">True</property>"
  "          <property name=\"label\" translatable=\"yes\">This is a basic libglademm example</property>"
  "          <property name=\"use_underline\">False</property>"
  "          <property name=\"use_markup\">False</property>"
  "          <property name=\"justify\">GTK_JUSTIFY_LEFT</property>"
  "          <property name=\"wrap\">False</property>"
  "          <property name=\"selectable\">False</property>"
  "          <property name=\"xalign\">0.5</property>"
  "          <property name=\"yalign\">0.5</property>"
  "          <property name=\"xpad\">0</property>"
  "          <property name=\"ypad\">0</property>"
  "        </widget>"
  "        <packing>"
  "          <property name=\"padding\">0</property>"
  "          <property name=\"expand\">False</property>"
  "          <property name=\"fill\">False</property>"
  "        </packing>"
  "      </child>"
  "    </widget>"
  "  </child>"
  "</widget>"
  ""
  "</glade-interface>";


Gtk::Dialog* pDialog = 0;

void on_button_clicked()
{
  if(pDialog)
    pDialog->hide(); //hide() will cause main::run() to end.
}

int main (int argc, char **argv)
{
  Gtk::Main kit(argc, argv);

  //Load the Glade file and instiate its widgets:
  Glib::RefPtr<Gnome::Glade::Xml> refXml;
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
    refXml = Gnome::Glade::Xml::create_from_buffer(buffer, sizeof(buffer));
  }
  catch(const Gnome::Glade::XmlError& ex)
  {
    std::cerr << ex.what() << std::endl;
    return 1;
  }
#else
  std::auto_ptr<Gnome::Glade::XmlError> error;
  refXml = Gnome::Glade::Xml::create_from_buffer(buffer, sizeof(buffer), "", "", error);
  if(error.get())
  {
    std::cerr << error->what() << std::endl;
    return 1;
  }
#endif

  //Get the Glade-instantiated Dialog:
  
  refXml->get_widget("DialogBasic", pDialog);
  if(pDialog)
  {
    //Get the Glade-instantiated Button, and connect a signal handler:
    Gtk::Button* pButton = 0;
    refXml->get_widget("quit_button", pButton);
    if(pButton)
    {
      pButton->signal_clicked().connect( sigc::ptr_fun(on_button_clicked) );
    }

    kit.run(*pDialog);
  }

  return 0;
}

