// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_SETTINGS_H
#define _GIOMM_SETTINGS_H


#include <glibmm.h>

/* Copyright (C) 2010 Jonathon Jongsma
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <glibmm/variant.h>
#include <giomm/settingsbackend.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GSettings GSettings;
typedef struct _GSettingsClass GSettingsClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class Settings_Class; } // namespace Gio
namespace Gio
{

  /** @addtogroup giommEnums giomm Enums and Flags */

/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%SettingsBindFlags operator|(SettingsBindFlags, SettingsBindFlags)</tt><br>
 * <tt>%SettingsBindFlags operator&(SettingsBindFlags, SettingsBindFlags)</tt><br>
 * <tt>%SettingsBindFlags operator^(SettingsBindFlags, SettingsBindFlags)</tt><br>
 * <tt>%SettingsBindFlags operator~(SettingsBindFlags)</tt><br>
 * <tt>%SettingsBindFlags& operator|=(SettingsBindFlags&, SettingsBindFlags)</tt><br>
 * <tt>%SettingsBindFlags& operator&=(SettingsBindFlags&, SettingsBindFlags)</tt><br>
 * <tt>%SettingsBindFlags& operator^=(SettingsBindFlags&, SettingsBindFlags)</tt><br>
 */
enum SettingsBindFlags
{
  SETTINGS_BIND_DEFAULT = 0x0,
  SETTINGS_BIND_GET = (1<<0),
  SETTINGS_BIND_SET = (1<<1),
  SETTINGS_BIND_NO_SENSITIVITY = (1<<2),
  SETTINGS_BIND_GET_NO_CHANGES = (1<<3)
};

/** @ingroup giommEnums */
inline SettingsBindFlags operator|(SettingsBindFlags lhs, SettingsBindFlags rhs)
  { return static_cast<SettingsBindFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline SettingsBindFlags operator&(SettingsBindFlags lhs, SettingsBindFlags rhs)
  { return static_cast<SettingsBindFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline SettingsBindFlags operator^(SettingsBindFlags lhs, SettingsBindFlags rhs)
  { return static_cast<SettingsBindFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline SettingsBindFlags operator~(SettingsBindFlags flags)
  { return static_cast<SettingsBindFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline SettingsBindFlags& operator|=(SettingsBindFlags& lhs, SettingsBindFlags rhs)
  { return (lhs = static_cast<SettingsBindFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline SettingsBindFlags& operator&=(SettingsBindFlags& lhs, SettingsBindFlags rhs)
  { return (lhs = static_cast<SettingsBindFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline SettingsBindFlags& operator^=(SettingsBindFlags& lhs, SettingsBindFlags rhs)
  { return (lhs = static_cast<SettingsBindFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gio


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gio::SettingsBindFlags> : public Glib::Value_Flags<Gio::SettingsBindFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{


/** A high-level API for application settings
 *
 * The Settings class provides a convenient API for storing and retrieving
 * application settings.
 *
 * @newin{2,26}
 */

class Settings : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Settings CppObjectType;
  typedef Settings_Class CppClassType;
  typedef GSettings BaseObjectType;
  typedef GSettingsClass BaseClassType;

private:  friend class Settings_Class;
  static CppClassType settings_class_;

private:
  // noncopyable
  Settings(const Settings&);
  Settings& operator=(const Settings&);

protected:
  explicit Settings(const Glib::ConstructParams& construct_params);
  explicit Settings(GSettings* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Settings();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GSettings*       gobj()       { return reinterpret_cast<GSettings*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GSettings* gobj() const { return reinterpret_cast<GSettings*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GSettings* gobj_copy();

private:


protected:
  explicit Settings(const Glib::ustring& schema);
  explicit Settings(const Glib::ustring& schema, const Glib::ustring& path);
  explicit Settings(const Glib::ustring& schema, const Glib::RefPtr<SettingsBackend>& backend);
  explicit Settings(const Glib::ustring& schema, const Glib::RefPtr<SettingsBackend>& backend, const Glib::ustring& path);

public:
  
  static Glib::RefPtr<Settings> create(const Glib::ustring& schema);

  
  static Glib::RefPtr<Settings> create(const Glib::ustring& schema, const Glib::ustring& path);

  
  static Glib::RefPtr<Settings> create(const Glib::ustring& schema, const Glib::RefPtr<SettingsBackend>& backend);

  
  static Glib::RefPtr<Settings> create(const Glib::ustring& schema, const Glib::RefPtr<SettingsBackend>& backend, const Glib::ustring& path);


  // FIXME: implement the GVariant stuff

  
  /** Sets @a key in @a settings to @a value.
   * 
   * It is a programmer error to give a @a key that isn't valid for
   *  @a settings.  It is a programmer error to give a @a value of the
   * incorrect type.
   * 
   * If @a value is floating then this function consumes the reference.
   * 
   * @newin{2,26}
   * @param key The name of the key to set.
   * @param value A Variant of the correct type.
   * @return <tt>true</tt> if setting the key succeeded,
   * <tt>false</tt> if the key was not writable.
   */
  bool set_value(const Glib::ustring& key, const Glib::VariantBase& value);
  
  /** TODO: Documentation.
   */
  void get_value(const Glib::ustring& key, Glib::VariantBase& value) const;
  

  /** Gets the value that is stored at @a key in @a settings.
   * 
   * A convenience variant of g_settings_get() for 32-bit integers.
   * 
   * It is a programmer error to pass a @a key that isn't valid for
   *  @a settings or is not of type int32.
   * 
   * @newin{2,26}
   * @param key The key to get the value for.
   * @return An integer.
   */
  int get_int(const Glib::ustring& key) const;
  
  /** Sets @a key in @a settings to @a value.
   * 
   * A convenience variant of g_settings_set() for 32-bit integers.
   * 
   * It is a programmer error to pass a @a key that isn't valid for
   *  @a settings or is not of type int32.
   * 
   * @newin{2,26}
   * @param key The name of the key to set.
   * @param value The value to set it to.
   * @return <tt>true</tt> if setting the key succeeded,
   * <tt>false</tt> if the key was not writable.
   */
  void set_int(const Glib::ustring& key, int value);
  
  /** Gets the value that is stored at @a key in @a settings.
   * 
   * A convenience variant of g_settings_get() for booleans.
   * 
   * It is a programmer error to pass a @a key that isn't valid for
   *  @a settings or is not of type boolean.
   * 
   * @newin{2,26}
   * @param key The key to get the value for.
   * @return A boolean.
   */
  bool get_boolean(const Glib::ustring& key) const;
  
  /** Sets @a key in @a settings to @a value.
   * 
   * A convenience variant of g_settings_set() for booleans.
   * 
   * It is a programmer error to pass a @a key that isn't valid for
   *  @a settings or is not of type boolean.
   * 
   * @newin{2,26}
   * @param key The name of the key to set.
   * @param value The value to set it to.
   * @return <tt>true</tt> if setting the key succeeded,
   * <tt>false</tt> if the key was not writable.
   */
  void set_boolean(const Glib::ustring& key, bool value);
  
  /** Gets the value that is stored at @a key in @a settings.
   * 
   * A convenience variant of g_settings_get() for strings.
   * 
   * It is a programmer error to pass a @a key that isn't valid for
   *  @a settings or is not of type string.
   * 
   * @newin{2,26}
   * @param key The key to get the value for.
   * @return A newly-allocated string.
   */
  Glib::ustring get_string(const Glib::ustring& key) const;
  
  /** Sets @a key in @a settings to @a value.
   * 
   * A convenience variant of g_settings_set() for strings.
   * 
   * It is a programmer error to pass a @a key that isn't valid for
   *  @a settings or is not of type string.
   * 
   * @newin{2,26}
   * @param key The name of the key to set.
   * @param value The value to set it to.
   * @return <tt>true</tt> if setting the key succeeded,
   * <tt>false</tt> if the key was not writable.
   */
  void set_string(const Glib::ustring& key, const Glib::ustring& value);
  
  /** Gets the value that is stored at @a key in @a settings.
   * 
   * A convenience variant of g_settings_get() for doubles.
   * 
   * It is a programmer error to pass a @a key that isn't valid for
   *  @a settings or is not of type double.
   * 
   * @newin{2,26}
   * @param key The key to get the value for.
   * @return A double.
   */
  double get_double(const Glib::ustring& key) const;
  
  /** Sets @a key in @a settings to @a value.
   * 
   * A convenience variant of g_settings_set() for doubles.
   * 
   * It is a programmer error to pass a @a key that isn't valid for
   *  @a settings or is not of type double.
   * 
   * @newin{2,26}
   * @param key The name of the key to set.
   * @param value The value to set it to.
   * @return <tt>true</tt> if setting the key succeeded,
   * <tt>false</tt> if the key was not writable.
   */
  void set_double(const Glib::ustring& key, double value);

   
  /** Gets the value that is stored at @a key in @a settings.
   * 
   * A convenience variant of g_settings_get() for string arrays.
   * 
   * It is a programmer error to pass a @a key that isn't valid for
   *  @a settings or is not of type 'string array'.
   * 
   * @newin{2,26}
   * @param key The key to get the value for.
   * @return A newly-allocated, <tt>0</tt>-terminated array of strings.
   */
  Glib::StringArrayHandle get_string_array(const Glib::ustring& key) const;

  
  /** Sets @a key in @a settings to @a value.
   * 
   * A convenience variant of g_settings_set() for string arrays.
   * 
   * It is a programmer error to pass a @a key that isn't valid for
   *  @a settings or is not of type 'string array'.
   * 
   * @newin{2,26}
   * @param key The name of the key to set.
   * @param value The value to set it to.
   * @return <tt>true</tt> if setting the key succeeded,
   * <tt>false</tt> if the key was not writable.
   */
  bool set_string_array(const Glib::ustring& key,  const Glib::StringArrayHandle& value);

  
  int get_enum(const Glib::ustring& key) const;
  
  bool get_enum(const Glib::ustring& key, int value);
  
  guint get_flags(const Glib::ustring& key) const;
  
  bool get_flags(const Glib::ustring& key, guint value);
                                                                         
  // Ignore varargs functions.
  

  /** Creates a 'child' settings object which has a base path of
   * <replaceable>base-path</replaceable>/ @a name", where
   * <replaceable>base-path</replaceable> is the base path of @a settings.
   * 
   * The schema for the child settings object must have been declared
   * in the schema of @a settings using a <tag class="starttag">child</tag> element.
   * 
   * @newin{2,26}
   * @param name The name of the 'child' schema.
   * @return A 'child' settings object.
   */
  Glib::RefPtr<Settings> get_child(const Glib::ustring& name);
  
  /** Creates a 'child' settings object which has a base path of
   * <replaceable>base-path</replaceable>/ @a name", where
   * <replaceable>base-path</replaceable> is the base path of @a settings.
   * 
   * The schema for the child settings object must have been declared
   * in the schema of @a settings using a <tag class="starttag">child</tag> element.
   * 
   * @newin{2,26}
   * @param name The name of the 'child' schema.
   * @return A 'child' settings object.
   */
  Glib::RefPtr<const Settings> get_child(const Glib::ustring& name) const;
  
  /** Finds out if a key can be written or not
   * 
   * @newin{2,26}
   * @param name The name of a key.
   * @return <tt>true</tt> if the key @a name is writable.
   */
  bool is_writable(const Glib::ustring& key) const;

  
  /** Changes the Settings object into 'delay-apply' mode. In this
   * mode, changes to @a settings are not immediately propagated to the
   * backend, but kept locally until g_settings_apply() is called.
   * 
   * @newin{2,26}
   */
  void delay();
  
  /** Applies any changes that have been made to the settings.  This
   * function does nothing unless @a settings is in 'delay-apply' mode;
   * see Glib::settings_set_delay_apply().  In the normal case settings are
   * always applied immediately.
   */
  void apply();
  
  /** Reverts all non-applied changes to the settings.  This function
   * does nothing unless @a settings is in 'delay-apply' mode; see
   * Glib::settings_set_delay_apply().  In the normal case settings are
   * always applied immediately.
   * 
   * Change notifications will be emitted for affected keys.
   */
  void revert();
  
  /** Returns whether the Settings object has any unapplied
   * changes.  This can only be the case if it is in 'delayed-apply' mode.
   * 
   * @newin{2,26}
   * @return <tt>true</tt> if @a settings has unapplied changes.
   */
  bool get_has_unapplied() const;

 
  /** Create a binding between the @a key in the @a settings object
   * and the property @a property of @a object.
   * 
   * The binding uses the default GIO mapping functions to map
   * between the settings and property values. These functions
   * handle booleans, numeric types and string types in a
   * straightforward way. Use g_settings_bind_with_mapping() if
   * you need a custom mapping, or map between types that are not
   * supported by the default mapping functions.
   * 
   * Unless the @a flags include SETTINGS_BIND_NO_SENSITIVITY, this
   * function also establishes a binding between the writability of
   *  @a key and the "sensitive" property of @a object (if @a object has
   * a boolean property by that name). See g_settings_bind_writable()
   * for more details about writable bindings.
   * 
   * Note that the lifecycle of the binding is tied to the object,
   * and that you can have only one binding per object property.
   * If you bind the same property twice on the same object, the second
   * binding overrides the first one.
   * 
   * @newin{2,26}
   * @param key The key to bind.
   * @param object A Object.
   * @param property The name of the property to bind.
   * @param flags Flags for the binding.
   */
  void bind(const Glib::ustring& key, Glib::ObjectBase* object, const Glib::ustring& property, SettingsBindFlags flags=SETTINGS_BIND_DEFAULT);
  void bind(const Glib::ustring& key, const Glib::PropertyProxy_Base& property_proxy, SettingsBindFlags flags=SETTINGS_BIND_DEFAULT);
  // FIXME: implement bind_with_mapping
  
  /** Create a binding between the writability of @a key in the
   *  @a settings object and the property @a property of @a object.
   * The property must be boolean; "sensitive" or "visible"
   * properties of widgets are the most likely candidates.
   * 
   * Writable bindings are always uni-directional; changes of the
   * writability of the setting will be propagated to the object
   * property, not the other way.
   * 
   * When the @a inverted argument is <tt>true</tt>, the binding inverts the
   * value as it passes from the setting to the object, i.e. @a property
   * will be set to <tt>true</tt> if the key is <emphasis>not</emphasis>
   * writable.
   * 
   * Note that the lifecycle of the binding is tied to the object,
   * and that you can have only one binding per object property.
   * If you bind the same property twice on the same object, the second
   * binding overrides the first one.
   * 
   * @newin{2,26}
   * @param key The key to bind.
   * @param object A Object.
   * @param property The name of a boolean property to bind.
   * @param inverted Whether to 'invert' the value.
   */
  void bind_writable(const Glib::ustring& key, Glib::ObjectBase* object, const Glib::ustring& property, bool inverted=false);
  void bind_writable(const Glib::ustring& key, const Glib::PropertyProxy_Base& property_proxy, bool inverted=false);
  // FIXME: unbind is not actually a class method

  //TODO?: _WRAP_SIGNAL(bool change_event(const Glib::ArrayHandle<Glib::QueryQuark>& keys, int n_keys), "change-event")

 
  /**
   * @par Prototype:
   * <tt>void on_my_%changed(const Glib::ustring& key)</tt>
   */

  Glib::SignalProxy1< void,const Glib::ustring& > signal_changed();


  //TODO?: _WRAP_SIGNAL(bool writable_change_event(guint key), "writable-change-event")
  
  /**
   * @par Prototype:
   * <tt>void on_my_%writable_changed(const Glib::ustring& key)</tt>
   */

  Glib::SignalProxy1< void,const Glib::ustring& > signal_writable_changed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_changed(const Glib::ustring& key);
  virtual void on_writable_changed(const Glib::ustring& key);


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::Settings
   */
  Glib::RefPtr<Gio::Settings> wrap(GSettings* object, bool take_copy = false);
}


#endif /* _GIOMM_SETTINGS_H */

