// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBRSVGMM_RSVG_H
#define _LIBRSVGMM_RSVG_H

#include <librsvgmmconfig.h>


#include <glibmm.h>

/* Copyright (c) 2009  Daniel Elstner <daniel.kitta@gmail.com>
 *
 * This file is part of librsvgmm.
 *
 * librsvgmm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2.1 of the License,
 * or (at your option) any later version.
 *
 * librsvgmm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <cairomm/cairomm.h>
#include <librsvg/rsvg.h>

/** The librsvgmm namespace.
 */
#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _RsvgHandle RsvgHandle;
typedef struct _RsvgHandleClass RsvgHandleClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Rsvg
{ class Handle_Class; } // namespace Rsvg
namespace Rsvg
{

/** Initialize librsvgmm for use.
 */
void init();

/** Shut down librsvgmm.
 */
void term();

/** Exception class for reporting errors.
 */
class Error : public Glib::Error
{
public:
  enum Code
  {
    FAILED
  };

  Error(Code error_code, const Glib::ustring& error_message);
  explicit Error(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Rsvg

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Rsvg::Error::Code> : public Glib::Value_Enum<Rsvg::Error::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Rsvg
{


/** Sets the DPI for all future pixel calculations.
 * Common values are 75, 90, and 300 DPI. Passing a number <= 0 to @a dpi
 * will reset the DPI to whatever the default value happens to be.
 * @param dpi Dots per inch (aka pixels per inch)
 */
void set_default_dpi(double dpi);

/** Sets the DPI for all future pixel calculations.
 * Common values are 75, 90, and 300 DPI. Passing a number <= 0 to @a dpi_x
 * or @a dpi_y will reset the DPI to whatever the default value happens to be.
 * @param dpi_x Horizontal dots per inch (aka pixels per inch)
 * @param dpi_y Vertical dots per inch (aka pixels per inch)
 */
void set_default_dpi(double dpi_x, double dpi_y);

/** Dimensions of an SVG fragment.
 */
struct DimensionData : RsvgDimensionData
{
  /** Initialize dimensions to 0.
   */
  DimensionData() { width = 0; height = 0; em = 0.0; ex = 0.0; }

#ifdef DOXYGEN_SHOULD_SKIP_THIS
  int width;  /*!< Width in pixels. */
  int height; /*!< Height in pixels. */
  double em;
  double ex;
#endif
};

/** Position of an SVG fragment.
 */
struct PositionData : RsvgPositionData
{
  /** Initialize coordinates to 0.
   */
  PositionData() { x = 0; y = 0; }

#ifdef DOXYGEN_SHOULD_SKIP_THIS
  int x; /*!< Horizontal position in pixels. */
  int y; /*!< Vertical position in pixels. */
#endif
};

/** Create and manipulate SVG objects.
 */

class Handle : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Handle CppObjectType;
  typedef Handle_Class CppClassType;
  typedef RsvgHandle BaseObjectType;
  typedef RsvgHandleClass BaseClassType;

private:  friend class Handle_Class;
  static CppClassType handle_class_;

private:
  // noncopyable
  Handle(const Handle&);
  Handle& operator=(const Handle&);

protected:
  explicit Handle(const Glib::ConstructParams& construct_params);
  explicit Handle(RsvgHandle* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Handle();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  RsvgHandle*       gobj()       { return reinterpret_cast<RsvgHandle*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const RsvgHandle* gobj() const { return reinterpret_cast<RsvgHandle*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  RsvgHandle* gobj_copy();

private:


protected:
  Handle();

public:
  /** Create an empty SVG handle.
   * @return A pointer to the created SVG handle.
   */
  
  static Glib::RefPtr<Handle> create();


  /** Load an SVG from a memory buffer.
   * @param[in] data Pointer to the SVG data in memory.
   * @param data_len Length of the SVG data in bytes.
   * @return A pointer to the created SVG handle.
   * @throw Rsvg::Error Thrown if the SVG could not be loaded.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static Glib::RefPtr<Handle> create_from_data(const guint8* data, gsize data_len);
#else
  static Glib::RefPtr<Handle> create_from_data(const guint8* data, gsize data_len, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Load the SVG file specified by @a file_name.
   * @param file_name The name of the file to load.
   * @return A pointer to the created SVG handle.
   * @throw Rsvg::Error Thrown if the SVG file could not be loaded.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static Glib::RefPtr<Handle> create_from_file(const std::string& file_name);
#else
  static Glib::RefPtr<Handle> create_from_file(const std::string& file_name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Sets the DPI for future pixel calculations.
   * Common values are 75, 90, and 300 DPI. Passing a number <= 0 to @a dpi
   * will reset the DPI to whatever the default value happens to be.
   * @param dpi Dots per inch (aka pixels per inch).
   */
  void set_dpi(double dpi);

  
  /** Sets the DPI for future pixel calculations.
   * Common values are 75, 90, and 300 DPI. Passing a number <= 0 to @a dpi_x
   * or @a dpi_y will reset the DPI to whatever the default value happens to be.
   * @param dpi_x Horizontal dots per inch (aka pixels per inch).
   * @param dpi_y Vertical dots per inch (aka pixels per inch).
   */
  void set_dpi(double dpi_x, double dpi_y);

  
  /** Loads the next @a count bytes of the image.
   * If the data could not be loaded successfully, the loader will be closed,
   * and will not accept further writes.
   * @param[in] buf Pointer to SVG data.
   * @param count Size of the buffer in bytes.
   * @throw Rsvg::Error Thrown if the data could not be loaded successfully.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void write(const guint8* buf, gsize count);
#else
  void write(const guint8* buf, gsize count, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Closes the handle, to indicate that loading the image is complete.
   * @throw Rsvg::Error Thrown if the loader could not close successfully.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void close();
#else
  void close(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Gets the base URI for this Rsvg::Handle.
   * @return The base URI, possibly empty.
   */
  Glib::ustring get_base_uri() const;

  
  /** Set the base URI for this SVG.
   * This can only be called before write() has been called.
   * @param base_uri The base URI.
   */
  void set_base_uri(const Glib::ustring& base_uri);

  
  /** Gets the size of the SVG.
   * @param[out] dimension_data Result object.
   */
  void get_dimensions(DimensionData& dimension_data) const;

  
  /** Gets the size of an SVG fragment.
   * @param[out] dimension_data Result object.
   * @param id An element's ID within the SVG, or the empty string to get
   *  the dimensions of the whole SVG. For example, if you have a layer
   *  called <tt>"layer1"</tt> for that you want to get the dimensions,
   *  pass <tt>"#layer1"</tt> as the ID.
   * @return Whether the dimensions of element @a id could be retrieved.
   */
  bool get_dimensions_sub(DimensionData& dimension_data,
                                       const Glib::ustring& id) const;

  
  /** Gets the position of an SVG fragment.
   * @param[out] position_data Result object.
   * @param id An element's ID within the SVG. For example, if you have
   *  a layer called <tt>"layer1"</tt> for that you want to get the position,
   *  pass <tt>"#layer1"</tt> as the ID.
   * @return Whether the position of element @a id could be retrieved.
   */
  bool get_position_sub(PositionData& position_data,
                                     const Glib::ustring& id) const;

  
  /** Checks whether the element @a id exists in the SVG document.
   * @param id An element's ID within the SVG.
   * @return <tt>true</tt> if @a id exists in the SVG document.
   */
  bool has_sub(const Glib::ustring& id) const;

  
  /** Draws an SVG to a cairo surface.
   * @param cr A cairo context.
   * @return Whether the SVG was drawn successfully.
   */
  bool render(const Cairo::RefPtr<Cairo::Context>& cr) const;

  
  /** Draws an SVG fragment to a cairo surface.
   * @param cr A cairo context.
   * @param id An element's ID within the SVG, or the empty string to render
   *  the whole SVG. For example, if you have a layer called <tt>"layer1"</tt>
   *  that you wish to render, pass <tt>"#layer1"</tt> as the ID.
   * @return Whether the @a id element was drawn successfully.
   */
  bool render_sub(const Cairo::RefPtr<Cairo::Context>& cr,
                               const Glib::ustring& id) const;

  
  /** Returns the SVG's title.
   * @return The SVG's title.
   */
  Glib::ustring get_title() const;

  
  /** Returns the SVG's description.
   * @return The SVG's description.
   */
  Glib::ustring get_desc() const;

  
  /** Returns the SVG's metadata.
   * @return The SVG's metadata.
   */
  Glib::ustring get_metadata() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Horizontal resolution.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_dpi_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Horizontal resolution.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_dpi_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Vertical resolution.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_dpi_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Vertical resolution.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_dpi_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Base URI.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_base_uri() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Base URI.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_base_uri() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Image width.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Image height.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** em.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_em() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** ex.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_ex() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** SVG file title.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_title() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** SVG file description.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_desc() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** SVG file metadata.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_metadata() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Rsvg


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Rsvg::Handle
   */
  Glib::RefPtr<Rsvg::Handle> wrap(RsvgHandle* object, bool take_copy = false);
}


#endif /* _LIBRSVGMM_RSVG_H */

