
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <libgnomeuimm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "about.h"
#include "app.h"
#include "appbar.h"
#include "client.h"
#include "color-picker.h"
#include "dateedit.h"
#include "druid.h"
#include "druid-page.h"
#include "druid-page-standard.h"
#include "druid-page-edge.h"
#include "entry.h"
#include "file-entry.h"
#include "font-picker.h"
#include "href.h"
#include "icon-entry.h"
#include "icon-list.h"
#include "icon-sel.h"
#include "icon-textitem.h"
#include "pixmap-entry.h"
#include "thumbnail.h"
#include "icon-lookup.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType gnome_about_get_type(void);
GType gnome_app_get_type(void);
GType gnome_appbar_get_type(void);
GType gnome_client_get_type(void);
#ifndef LIBGNOMEUIMM_DISABLE_DEPRECATED
GType gnome_color_picker_get_type(void);
#endif // *_DISABLE_DEPRECATED
GType gnome_date_edit_get_type(void);
GType gnome_druid_get_type(void);
GType gnome_druid_page_get_type(void);
GType gnome_druid_page_edge_get_type(void);
GType gnome_druid_page_standard_get_type(void);
#ifndef LIBGNOMEUIMM_DISABLE_DEPRECATED
GType gnome_entry_get_type(void);
#endif // *_DISABLE_DEPRECATED
GType gnome_file_entry_get_type(void);
#ifndef LIBGNOMEUIMM_DISABLE_DEPRECATED
GType gnome_font_picker_get_type(void);
#endif // *_DISABLE_DEPRECATED
GType gnome_href_get_type(void);
GType gnome_icon_entry_get_type(void);
GType gnome_icon_list_get_type(void);
GType gnome_icon_selection_get_type(void);
GType gnome_icon_text_item_get_type(void);
GType gnome_pixmap_entry_get_type(void);
GType gnome_thumbnail_factory_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Gnome { namespace UI {  class About_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace UI {  class App_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace UI {  class AppBar_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace UI {  class Client_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
#ifndef LIBGNOMEUIMM_DISABLE_DEPRECATED
namespace Gnome { namespace UI {  class ColorPicker_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
#endif // *_DISABLE_DEPRECATED
namespace Gnome { namespace UI {  class DateEdit_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace UI {  class Druid_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace UI {  class DruidPage_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace UI {  class DruidPageEdge_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace UI {  class DruidPageStandard_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
#ifndef LIBGNOMEUIMM_DISABLE_DEPRECATED
namespace Gnome { namespace UI {  class Entry_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
#endif // *_DISABLE_DEPRECATED
namespace Gnome { namespace UI {  class FileEntry_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
#ifndef LIBGNOMEUIMM_DISABLE_DEPRECATED
namespace Gnome { namespace UI {  class FontPicker_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
#endif // *_DISABLE_DEPRECATED
namespace Gnome { namespace UI {  class HRef_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace UI {  class IconEntry_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace UI {  class IconList_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace UI {  class IconSelection_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace UI {  class IconTextItem_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace UI {  class PixmapEntry_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace UI {  class ThumbnailFactory_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }

namespace Gnome { namespace UI { 

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(gnome_about_get_type(), &Gnome::UI::About_Class::wrap_new);
  Glib::wrap_register(gnome_app_get_type(), &Gnome::UI::App_Class::wrap_new);
  Glib::wrap_register(gnome_appbar_get_type(), &Gnome::UI::AppBar_Class::wrap_new);
  Glib::wrap_register(gnome_client_get_type(), &Gnome::UI::Client_Class::wrap_new);
#ifndef LIBGNOMEUIMM_DISABLE_DEPRECATED
  Glib::wrap_register(gnome_color_picker_get_type(), &Gnome::UI::ColorPicker_Class::wrap_new);
#endif // *_DISABLE_DEPRECATED
  Glib::wrap_register(gnome_date_edit_get_type(), &Gnome::UI::DateEdit_Class::wrap_new);
  Glib::wrap_register(gnome_druid_get_type(), &Gnome::UI::Druid_Class::wrap_new);
  Glib::wrap_register(gnome_druid_page_get_type(), &Gnome::UI::DruidPage_Class::wrap_new);
  Glib::wrap_register(gnome_druid_page_edge_get_type(), &Gnome::UI::DruidPageEdge_Class::wrap_new);
  Glib::wrap_register(gnome_druid_page_standard_get_type(), &Gnome::UI::DruidPageStandard_Class::wrap_new);
#ifndef LIBGNOMEUIMM_DISABLE_DEPRECATED
  Glib::wrap_register(gnome_entry_get_type(), &Gnome::UI::Entry_Class::wrap_new);
#endif // *_DISABLE_DEPRECATED
  Glib::wrap_register(gnome_file_entry_get_type(), &Gnome::UI::FileEntry_Class::wrap_new);
#ifndef LIBGNOMEUIMM_DISABLE_DEPRECATED
  Glib::wrap_register(gnome_font_picker_get_type(), &Gnome::UI::FontPicker_Class::wrap_new);
#endif // *_DISABLE_DEPRECATED
  Glib::wrap_register(gnome_href_get_type(), &Gnome::UI::HRef_Class::wrap_new);
  Glib::wrap_register(gnome_icon_entry_get_type(), &Gnome::UI::IconEntry_Class::wrap_new);
  Glib::wrap_register(gnome_icon_list_get_type(), &Gnome::UI::IconList_Class::wrap_new);
  Glib::wrap_register(gnome_icon_selection_get_type(), &Gnome::UI::IconSelection_Class::wrap_new);
  Glib::wrap_register(gnome_icon_text_item_get_type(), &Gnome::UI::IconTextItem_Class::wrap_new);
  Glib::wrap_register(gnome_pixmap_entry_get_type(), &Gnome::UI::PixmapEntry_Class::wrap_new);
  Glib::wrap_register(gnome_thumbnail_factory_get_type(), &Gnome::UI::ThumbnailFactory_Class::wrap_new);

  // Register the gtkmm gtypes:
  Gnome::UI::About::get_type();
  Gnome::UI::App::get_type();
  Gnome::UI::AppBar::get_type();
  Gnome::UI::Client::get_type();
#ifndef LIBGNOMEUIMM_DISABLE_DEPRECATED
  Gnome::UI::ColorPicker::get_type();
#endif // *_DISABLE_DEPRECATED
  Gnome::UI::DateEdit::get_type();
  Gnome::UI::Druid::get_type();
  Gnome::UI::DruidPage::get_type();
  Gnome::UI::DruidPageEdge::get_type();
  Gnome::UI::DruidPageStandard::get_type();
#ifndef LIBGNOMEUIMM_DISABLE_DEPRECATED
  Gnome::UI::Entry::get_type();
#endif // *_DISABLE_DEPRECATED
  Gnome::UI::FileEntry::get_type();
#ifndef LIBGNOMEUIMM_DISABLE_DEPRECATED
  Gnome::UI::FontPicker::get_type();
#endif // *_DISABLE_DEPRECATED
  Gnome::UI::HRef::get_type();
  Gnome::UI::IconEntry::get_type();
  Gnome::UI::IconList::get_type();
  Gnome::UI::IconSelection::get_type();
  Gnome::UI::IconTextItem::get_type();
  Gnome::UI::PixmapEntry::get_type();
  Gnome::UI::ThumbnailFactory::get_type();

} // wrap_init()

} //UI
} //Gnome


