// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_ADJUSTMENT_H
#define _GTKMM_ADJUSTMENT_H


#include <glibmm.h>

/* $Id: adjustment.hg,v 1.4 2005/12/15 16:32:16 murrayc Exp $ */

/* adjustment.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkAdjustment GtkAdjustment;
typedef struct _GtkAdjustmentClass GtkAdjustmentClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Adjustment_Class; } // namespace Gtk
namespace Gtk
{

/** A class representing an adjustable bounded value.
 *
 * The Gtk::Adjustment object represents a value which has an associated
 * lower and upper bound, together with step and page increments, and a page
 * size.  It is used within several gtkmm widgets, including
 * Gtk::SpinButton, Gtk::Viewport, and Gtk::Range (which is a base class for
 * Gtk::HScrollbar, Gtk::VScrollbar, Gtk::HScale, and Gtk::VScale).
 *
 * The Gtk::Adjustment object does not update the value itself. Instead it
 * is left up to the owner of the Gtk::Adjustment to control the value.
 *
 * The owner of the Gtk::Adjustment typically calls the value_changed() and
 * changed() functions after changing the value and its bounds. This results
 * in the emission of the "value_changed" or "changed" signal respectively. 
 *
 */

class Adjustment : public Object
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Adjustment CppObjectType;
  typedef Adjustment_Class CppClassType;
  typedef GtkAdjustment BaseObjectType;
  typedef GtkAdjustmentClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Adjustment();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Adjustment_Class;
  static CppClassType adjustment_class_;

  // noncopyable
  Adjustment(const Adjustment&);
  Adjustment& operator=(const Adjustment&);

protected:
  explicit Adjustment(const Glib::ConstructParams& construct_params);
  explicit Adjustment(GtkAdjustment* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkAdjustment*       gobj()       { return reinterpret_cast<GtkAdjustment*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkAdjustment* gobj() const { return reinterpret_cast<GtkAdjustment*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_changed();
  virtual void on_value_changed();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:

  friend class Range;
  friend class HScrollbar;
  friend class VScrollbar;

  /** Constructor to create an Adjustment object.
   * @param value The initial value
   * @param lower The minimum value
   * @param upper The maximum value
   * @param step_increment The step increment
   * @param page_increment The page increment
   * @param page_size The page size
   */
  explicit Adjustment(double value, double lower, double upper, double step_increment = 1, double page_increment = 10, double page_size = 0);
  
  
  /** Emits a "changed" signal from the Adjustment.  This is typically called by the owner of the Adjustment after it has changed any of the Adjustment fields other than the value.
   */
  void changed();
  
  /** Emits a "value_changed" signal from the Adjustment.  This is typically called by the owner of the Adjustment after it has changed the Adjustment value field.
   */
  void value_changed();

  
  /** Updates the Adjustment value to ensure that the range between the parameters @a lower  and @a upper  is in the current page (i.e.\ between @a value  and @a value  + @a page_size ).  If this range is larger than the page size, then only the start of it will be in the current page.  A "changed" signal will be emitted if the value is changed.
   * @param upper The upper value.
   * @param lower The lower value.
   */
  void clamp_page(double lower, double upper);

  
  /** Sets the current value of the Adjustment
   * @param value The new value of the Adjustment.
   */
  void set_value(double value);
  
  /** Gets the current value of the adjustment. See
   * set_value().
   * @return The current value of the adjustment.
   */
  double get_value() const;

  // Other internal fields accessors
  /** Retrieve the @a lower member variable.
   * @return The current value of @a lower.
   */
   double get_lower() const;
 
  /** Retrieve the @a upper member variable.
   * @return The current value of @a upper.
   */
   double get_upper() const;
 
  /** Retrieve the @a step_increment variable.
   * @return The current value of @a step_increment.
   */
   double get_step_increment() const;
 
  /** Retrieve the @a page_increment variable.
   * @return The current value of @a page_increment.
   */
   double get_page_increment() const;
 
  /** Retrieve the @a page_size variable.
   * @return The current value of @a page_size.
   */
   double get_page_size() const;
 
  // TODO: This section needs changing. We must be able to set more at a time,
  // emitting "changed" signal only once.
  /** Sets the @a lower member variable
   * @param lower The value to set the @a lower member variable to.
   */
  void set_lower(double lower);
  
  /** Sets the @a upper member variable
   * @param upper The value to set the @a upper member variable to.
   */
  void set_upper(double upper);

  /** Sets the @a step_increment member variable
   * @param incr The value to set the @a step_incrememnt member variable to.
   */
  void set_step_increment(double incr);

  /** Sets the @a page_increment member variable
   * @param incr The value to set the @a page_increment member variable to.
   */
  void set_page_increment(double incr);

  /** Sets the @a page_size member variable
   * @param size The value to set the @ page_size member varialbe to.
   */
  void set_page_size(double size);

  
/**
   * @par Prototype:
   * <tt>void %changed()</tt>
   */

  Glib::SignalProxy0< void > signal_changed();

  
/**
   * @par Prototype:
   * <tt>void %value_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_value_changed();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Adjustment
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Gtk::Adjustment* wrap(GtkAdjustment* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_ADJUSTMENT_H */

