/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.freedesktop.cairo;

import org.gnu.glib.Enum;

/**
 * Specifies the type of antialiasing to do when rendering text.
 */
public class Antialias extends Enum {

    static final private int _DEFAULT = 0;

    /**
     * Use the default antialiasing for the font subsystem and target device
     */
    static final public Antialias DEFAULT = new Antialias(_DEFAULT);

    static final private int _NONE = 1;

    /**
     * Do no antialiasing of fonts; use bilevel text.
     */
    static final public Antialias NONE = new Antialias(_NONE);

    static final private int _GRAY = 2;

    /**
     * Perform single-color antialiasing (using shades of gray for black text on
     * a white background, for example).
     */
    static final public Antialias GRAY = new Antialias(_GRAY);

    static final private int _SUBPIXEL = 3;

    /**
     * Perform antialiasing by taking advantage of the order of subpixel
     * elements on devices such as LCD panels
     */
    static final public Antialias SUBPIXEL = new Antialias(_SUBPIXEL);

    static final private Antialias[] theInterned = new Antialias[] { DEFAULT,
            NONE, GRAY, SUBPIXEL };

    static private java.util.Hashtable theInternedExtras;

    static final private Antialias theSacrificialOne = new Antialias(0);

    static public Antialias intern(int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        Antialias already = (Antialias) theInternedExtras
                .get(theSacrificialOne);
        if (already == null) {
            already = new Antialias(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private Antialias(int value) {
        value_ = value;
    }

    public boolean test(Antialias other) {
        return (value_ & other.value_) == other.value_;
    }
}
