/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
/**
 * An anchor for embedding widgets within TextView widgets.
 * You would usually only use the methods of {@link TextView} to sort out Child
 * widgets.
 */
public class TextChildAnchor extends GObject 
{

	/**
	 * Constructs a new TextChildAnchor.
	 */
	public TextChildAnchor(){
		super(gtk_text_child_anchor_new ());
	}

	public TextChildAnchor(Handle handle){
		super(handle);
	}

	/**
	 * Returns the associated widget
	 */
	public Widget getWidget(){
	    Handle hndl = gtk_text_child_anchor_get_widgets(getHandle());
		if (null == hndl)
			return null;
		GObject obj = getGObjectFromHandle(hndl);
		if (null != obj)
			return (Widget)obj;
		return new Widget(hndl);
	}

	/**
	 * Returns true if the anchor has been deleted from the textbuffer.
	 */
	public boolean getDeleted(){
		return gtk_text_child_anchor_get_deleted(getHandle());
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_text_child_anchor_get_type());
	}

    native static final protected int gtk_text_child_anchor_get_type ();
    native static final protected Handle gtk_text_child_anchor_new ();
    native static final protected Handle gtk_text_child_anchor_get_widgets (Handle anchor);
    native static final protected boolean gtk_text_child_anchor_get_deleted (Handle anchor);
}

