/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

import org.gnu.glib.EventType;

/**
  * This event is used to identify when a ToolButton receives an event
 * 
 * @see ToolButtonListener
 */
public class ToolButtonEvent extends GtkEvent {
	
	public static class Type extends EventType {
		private Type(int id, String name) {
			super(id, name);
		}

		
		public static final Type CLICKED = new Type(1, "CLICKED");
	}

	/**
	 * Constructor for ToolButtonEvent.
	 * @param source
	 * @param type
	 */
	public ToolButtonEvent(Object source, EventType type) {
		super(source, type);
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(ToolButtonEvent.Type aType) {
		return (type.getID() == aType.getID());
	}
}
