/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;

/**
 *
 */
 
public class WindowAttr extends GObject{
	
	public WindowAttr(Handle handle){
		super(handle);
	}
	
	public String getTitle(){
		return WindowAttr.getTitle(getHandle());
	}
	
	public void setTitle(String title){
		if(title!=null)
			setTitle(getHandle(), title);
	}
	
	// it will change in the future.
	public int getEventMask(){
		return WindowAttr.getEventMask(getHandle());
	}
	
	public void setEventMask(int evtMask){
		setEventMask(getHandle(), evtMask);
	}
	
	public org.gnu.gdk.Point getPosition(){
		int x= WindowAttr.getX(getHandle());
		int y= WindowAttr.getY(getHandle());
		return new org.gnu.gdk.Point(x, y);
	}
	
	public void setPosition(int x, int y){
		setX(getHandle(), x);
		setY(getHandle(), y);
	}
	
	public void setDimension(int width, int height){
		if(width>=0 && height >=0){
			setWidth(getHandle(), width);
			setHeight(getHandle(), height);
		}
	}
	
	public org.gnu.gdk.Dimension getDimension(){
		int width=WindowAttr.getWidth(getHandle());
		int height=WindowAttr.getHeight(getHandle());
		return new org.gnu.gdk.Dimension(width, height);
	}
		
	
    native static final protected String getTitle (Handle obj);
    native final protected void setTitle (Handle obj, String title);
    native static final protected int getEventMask (Handle obj);
    native final protected void setEventMask (Handle obj, int event_mask);
    native static final protected int getX (Handle obj);
    native final protected void setX (Handle obj, int x);
    native static final protected int getY (Handle obj);
    native final protected void setY (Handle obj, int y);
    native static final protected int getWidth (Handle obj);
    native final protected void setWidth (Handle obj, int width);
    native static final protected int getHeight (Handle obj);
    native final protected void setHeight (Handle obj, int height);
    native static final protected Handle getWclass (Handle obj);
    native final protected void setWclass (Handle obj, Handle wclass);
    native static final protected Handle getVisual (Handle obj);
    native final protected void setVisual (Handle obj, Handle visual);
    native static final protected Handle getColormap (Handle obj);
    native final protected void setColormap (Handle obj, Handle colormap);
    native static final protected int getWindowType (Handle obj);
    native final protected void setWindowType (Handle obj, int window_type);
    native static final protected Handle getCursor (Handle obj);
    native final protected void setCursor (Handle obj, int cursor);
    native static final protected String getWmclassName (Handle obj);
    native final protected void setWmclassName (Handle obj, String wmclass_name);
    native static final protected String getWmclassClass (Handle obj);
    native final protected void setWmclassClass (Handle obj, String wmclass_class);
    native static final protected boolean getOverrideRedirect (Handle obj);
    native final protected void setOverrideRedirect (Handle obj, boolean override_redirect);
}

