# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work envronment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=gtk+
VER=2.16.6
REV=3
ARCH=win64

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev
usemingw64
usemsvs9x64

(

set -x

DEPS=`latest --arch=${ARCH} zlib gettext-runtime glib pkg-config atk pixman cairo freetype expat fontconfig cairo pango libpng zlib`
GETTEXT_RUNTIME=`latest --arch=${ARCH} gettext-runtime`

PKG_CONFIG_PATH=
for D in $DEPS; do
    PATH=/devel/dist/${ARCH}/$D/bin:$PATH
    [ -d /devel/dist/${ARCH}/$D/lib/pkgconfig ] && PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/lib/pkgconfig:$PKG_CONFIG_PATH
done

LIBPNG=`latest --arch=${ARCH} libpng`
ZLIB=`latest --arch=${ARCH} zlib`

# Don't do any relinking crap in libtool.
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

mkdir gtk/.libs
echo '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<assembly xmlns="urn:schemas-microsoft-com:asm.v1" manifestVersion="1.0">
  <assemblyIdentity version="1.0.0.0"
     processorArchitecture="AMD64"
     name="gtk-update-icon-cache.exe"
     type="win32"/>
  <!-- Identify the application security requirements. -->
  <trustInfo xmlns="urn:schemas-microsoft-com:asm.v3">
    <security>
      <requestedPrivileges>
        <requestedExecutionLevel
          level="asInvoker"
          uiAccess="false"/>
        </requestedPrivileges>
       </security>
  </trustInfo>
</assembly>' >gtk/gtk-update-icon-cache.exe.manifest &&

cp -p gtk/gtk-update-icon-cache.exe.manifest gtk/.libs/gtk-update-icon-cache.exe.manifest &&

patch --verbose --fuzz=0 -p1 <<'EOF' &&
commit e68a26ea72ce38315bba862e208e238b7febb405
Author: Steffen Macke <sdteffen@gmail.com>
Date:   Sat Feb 6 20:04:30 2010 +0200

    Fix menu bar problem in ms-windows theme engine on Windows 7
    
    Patch from bug #591186

diff --git a/modules/engines/ms-windows/msw_style.c b/modules/engines/ms-windows/msw_style.c
index bc253e1..d086378 100755
--- a/modules/engines/ms-windows/msw_style.c
+++ b/modules/engines/ms-windows/msw_style.c
@@ -698,8 +698,8 @@ setup_msw_rc_style (void)
   GdkColor text_prelight;
 
   /* Prelight */
-  sys_color_to_gtk_color (XP_THEME_CLASS_TEXT,
-			  get_windows_version () == VISTA_VERSION ? COLOR_MENUTEXT : COLOR_HIGHLIGHTTEXT,
+  sys_color_to_gtk_color (get_windows_version () >= VISTA_VERSION ? XP_THEME_CLASS_MENU : XP_THEME_CLASS_TEXT,
+			  get_windows_version () >= VISTA_VERSION ? COLOR_MENUTEXT : COLOR_HIGHLIGHTTEXT,
 			  &fg_prelight);
   sys_color_to_gtk_color (XP_THEME_CLASS_TEXT, COLOR_HIGHLIGHT, &bg_prelight);
   sys_color_to_gtk_color (XP_THEME_CLASS_TEXT, COLOR_HIGHLIGHT,
commit 67834690d0086953ed892322d616c725414996cd
Author: Tor Lillqvist <tml@iki.fi>
Date:   Thu Oct 8 10:54:22 2009 +0300

    Fix the GDI+ gdk-pixbuf loader
    
    Should fix bug #552678. Patch by Dominic Lachowicz, based on a clueful
    response from Jason Copenhaver on Albeto Ruiz's blog
    http://aruiz.typepad.com/siliconisland/2009/08/dear-lazyweb-gtk-need-gdi-help.html

diff --git a/gdk-pixbuf/io-gdip-utils.c b/gdk-pixbuf/io-gdip-utils.c
index 9353725..eff2f76 100644
--- a/gdk-pixbuf/io-gdip-utils.c
+++ b/gdk-pixbuf/io-gdip-utils.c
@@ -31,6 +31,18 @@
 
 #define LOAD_BUFFER_SIZE 65536
 
+struct _GdipContext {
+  GdkPixbufModuleUpdatedFunc  updated_func;
+  GdkPixbufModulePreparedFunc prepared_func;
+  GdkPixbufModuleSizeFunc     size_func;
+
+  gpointer                    user_data;
+  GByteArray                 *buffer;
+  IStream                    *stream;
+  HGLOBAL                     hg;
+};
+typedef struct _GdipContext GdipContext;
+
 static GdiplusStartupFunc GdiplusStartup;
 static GdipCreateBitmapFromStreamFunc GdipCreateBitmapFromStream;
 static GdipBitmapGetPixelFunc GdipBitmapGetPixel;
@@ -339,16 +351,16 @@ gdip_pixbuf_to_bitmap (GdkPixbuf *pixbuf)
 }
 
 static GpBitmap *
-gdip_buffer_to_bitmap (const gchar *buffer, size_t size, GError **error)
+gdip_buffer_to_bitmap (GdipContext *context, GError **error)
 {
   HRESULT hr;
   HGLOBAL hg = NULL;
   GpBitmap *bitmap = NULL;
   IStream *stream = NULL;
   GpStatus status;
-  guint64 size64 = size;
+  guint64 size64 = context->buffer->len;
 
-  hg = gdip_buffer_to_hglobal (buffer, size, error);
+  hg = gdip_buffer_to_hglobal (context->buffer->data, context->buffer->len, error);
 
   if (!hg)
     return NULL;
@@ -364,26 +376,30 @@ gdip_buffer_to_bitmap (const gchar *buffer, size_t size, GError **error)
   
   status = GdipCreateBitmapFromStream (stream, &bitmap);
 
-  if (Ok != status)
+  if (Ok != status) {
     gdip_set_error_from_gpstatus (error, GDK_PIXBUF_ERROR_FAILED, status);
+    IStream_Release (stream);
+    GlobalFree (hg);
+    return NULL;
+  }
 
-  IStream_Release (stream);
-  GlobalFree (hg);
+  context->stream = stream;
+  context->hg = hg;
 
   return bitmap;
 }
 
 static GpImage *
-gdip_buffer_to_image (const gchar *buffer, size_t size, GError **error)
+gdip_buffer_to_image (GdipContext *context, GError **error)
 {
   HRESULT hr;
   HGLOBAL hg = NULL;
   GpImage *image = NULL;
   IStream *stream = NULL;
   GpStatus status;
-  guint64 size64 = size;
+  guint64 size64 = context->buffer->len;
 
-  hg = gdip_buffer_to_hglobal (buffer, size, error);
+  hg = gdip_buffer_to_hglobal (context->buffer->data, context->buffer->len, error);
 
   if (!hg)
     return NULL;
@@ -399,11 +415,15 @@ gdip_buffer_to_image (const gchar *buffer, size_t size, GError **error)
   IStream_SetSize (stream, *(ULARGE_INTEGER *)&size64);
   status = GdipLoadImageFromStream (stream, &image);
 
-  if (Ok != status)
+  if (Ok != status) {
     gdip_set_error_from_gpstatus (error, GDK_PIXBUF_ERROR_FAILED, status);
+    IStream_Release (stream);
+    GlobalFree (hg);
+    return NULL;
+  }
 
-  IStream_Release (stream);
-  GlobalFree (hg);
+  context->stream = stream;
+  context->hg = hg;
 
   return image;
 }
@@ -590,24 +610,14 @@ gdip_bitmap_get_n_loops (GpBitmap *bitmap, guint *loops)
   return success;
 }
 
-/*************************************************************************/
-/*************************************************************************/
-
-struct _GdipContext {
-  GdkPixbufModuleUpdatedFunc  updated_func;
-  GdkPixbufModulePreparedFunc prepared_func;
-  GdkPixbufModuleSizeFunc     size_func;
-
-  gpointer                    user_data;
-
-  GByteArray                 *buffer;
-};
-typedef struct _GdipContext GdipContext;
-
 static void
 destroy_gdipcontext (GdipContext *context)
 {
   if (context != NULL) {
+    if (context->stream != NULL) {
+      IStream_Release(context->stream);
+      GlobalFree (context->hg);
+    }
     g_byte_array_free (context->buffer, TRUE);
     g_free (context);
   }
@@ -806,9 +816,8 @@ gdk_pixbuf__gdip_image_stop_load (gpointer data, GError **error)
 {
   GdipContext *context = (GdipContext *)data;
   GpBitmap    *bitmap = NULL;
-  GByteArray *image_buffer = context->buffer;
 
-  bitmap = gdip_buffer_to_bitmap ((gchar *)image_buffer->data, image_buffer->len, error);
+  bitmap = gdip_buffer_to_bitmap (context, error);
 
   if (!bitmap) {
     destroy_gdipcontext (context);
@@ -823,7 +832,6 @@ static gboolean
 gdk_pixbuf__gdip_image_stop_vector_load (gpointer data, GError **error)
 {
   GdipContext *context = (GdipContext *)data;
-  GByteArray *image_buffer = context->buffer;
 
   GpImage *metafile;
   GpGraphics *graphics;
@@ -832,7 +840,7 @@ gdk_pixbuf__gdip_image_stop_vector_load (gpointer data, GError **error)
   float metafile_xres, metafile_yres;
   guint width, height;
 
-  metafile = gdip_buffer_to_image ((gchar *)image_buffer->data, image_buffer->len, error);
+  metafile = gdip_buffer_to_image (context, error);
   if (!metafile) {
     destroy_gdipcontext (context);
     g_set_error_literal (error, GDK_PIXBUF_ERROR, GDK_PIXBUF_ERROR_CORRUPT_IMAGE, _("Couldn't load metafile"));
commit 6cf7c942f630a3d1bf4d288d6b5d13391d592adb
Author: Shixin Zeng <zeng.shixin@gmail.com>
Date:   Thu Aug 20 23:53:57 2009 +0300

    Don't use stream before it is created
---
 gdk-pixbuf/io-gdip-utils.c |    5 +++--
 1 files changed, 3 insertions(+), 2 deletions(-)

diff --git a/gdk-pixbuf/io-gdip-utils.c b/gdk-pixbuf/io-gdip-utils.c
index eff2f76..b8fa72b 100644
--- a/gdk-pixbuf/io-gdip-utils.c
+++ b/gdk-pixbuf/io-gdip-utils.c
@@ -365,7 +365,6 @@ gdip_buffer_to_bitmap (GdipContext *context, GError **error)
   if (!hg)
     return NULL;
 
-  IStream_SetSize (stream, *(ULARGE_INTEGER *)&size64);
   hr = CreateStreamOnHGlobal (hg, FALSE, (LPSTREAM *)&stream);
 
   if (!SUCCEEDED (hr)) {
@@ -373,7 +372,9 @@ gdip_buffer_to_bitmap (GdipContext *context, GError **error)
     GlobalFree (hg);
     return NULL;
   }
-  
+
+  IStream_SetSize (stream, *(ULARGE_INTEGER *)&size64);
+
   status = GdipCreateBitmapFromStream (stream, &bitmap);
 
   if (Ok != status) {
commit 8c6b326d2e0c71eb801eb6480589621824ac48b6
Author: Tor Lillqvist <tml@iki.fi>
Date:   Thu Sep 2 14:30:59 2010 +0300

    Avoid potential DLL hijacking in ms-windows theme engine
    
    Load uxtheme.dll from an absolute path. A proper uxtheme.dll, if
    present, will always be in the Windows system directory, so load it
    from there.
---
 modules/engines/ms-windows/xp_theme.c |   28 +++++++++++++++++++++++++++-
 1 files changed, 27 insertions(+), 1 deletions(-)

diff --git a/modules/engines/ms-windows/xp_theme.c b/modules/engines/ms-windows/xp_theme.c
index bfd8ab7..abcc837 100755
--- a/modules/engines/ms-windows/xp_theme.c
+++ b/modules/engines/ms-windows/xp_theme.c
@@ -165,6 +165,8 @@ static const short element_part_map[XP_THEME_ELEMENT__SIZEOF] = {
   TKP_TICSVERT
 };
 
+#define UXTHEME_DLL "uxtheme.dll"
+
 static HINSTANCE uxtheme_dll = NULL;
 static HTHEME open_themes[XP_THEME_CLASS__SIZEOF];
 static gboolean use_xp_theme = FALSE;
@@ -219,12 +221,36 @@ xp_theme_close_open_handles (void)
 void
 xp_theme_init (void)
 {
+  char *buf;
+  char dummy;
+  int n, k;
+
   if (uxtheme_dll)
     return;
 
   memset (open_themes, 0, sizeof (open_themes));
 
-  uxtheme_dll = LoadLibrary ("uxtheme.dll");
+  n = GetSystemDirectory (&dummy, 0);
+
+  if (n <= 0)
+    return;
+
+  buf = g_malloc (n + 1 + strlen (UXTHEME_DLL));
+  k = GetSystemDirectory (buf, n);
+  
+  if (k == 0 || k > n)
+    {
+      g_free (buf);
+      return;
+    }
+
+  if (!G_IS_DIR_SEPARATOR (buf[strlen (buf) -1]))
+    strcat (buf, G_DIR_SEPARATOR_S);
+  strcat (buf, UXTHEME_DLL);
+
+  uxtheme_dll = LoadLibrary (buf);
+  g_free (buf);
+
   if (!uxtheme_dll)
     return;
 

commit 9ac354e0e02a9d951688d00ff481df775520d9cd
Author: Tor Lillqvist <tml@iki.fi>
Date:   Fri Sep 3 00:13:36 2010 +0300

    Just use TrackMouseEvent directly
    
    TrackMouseEvent is present in user32.dll in all Windows versions we
    support. No need to look it up dynamically. No need to fallback to
    _TrackMouseEvent from comctrl32.dll.
---
 gdk/win32/gdkevents-win32.c |   47 +++++++++++-------------------------------
 1 files changed, 13 insertions(+), 34 deletions(-)

diff --git a/gdk/win32/gdkevents-win32.c b/gdk/win32/gdkevents-win32.c
index 3cdd66f..722786b 100644
--- a/gdk/win32/gdkevents-win32.c
+++ b/gdk/win32/gdkevents-win32.c
@@ -161,40 +161,19 @@ static void
 track_mouse_event (DWORD dwFlags,
 		   HWND  hwnd)
 {
-  typedef BOOL (WINAPI *PFN_TrackMouseEvent) (LPTRACKMOUSEEVENT);
-  static PFN_TrackMouseEvent p_TrackMouseEvent = NULL;
-  static gboolean once = FALSE;
-
-  if (!once)
-    {
-      HMODULE user32;
-      HINSTANCE commctrl32;
-
-      user32 = GetModuleHandle ("user32.dll");
-      if ((p_TrackMouseEvent = (PFN_TrackMouseEvent)GetProcAddress (user32, "TrackMouseEvent")) == NULL)
-        {
-          if ((commctrl32 = LoadLibrary ("commctrl32.dll")) != NULL)
-	    p_TrackMouseEvent = (PFN_TrackMouseEvent)
-	      GetProcAddress (commctrl32, "_TrackMouseEvent");
-        }
-      once = TRUE;
-    }
-
-  if (p_TrackMouseEvent)
-    {
-      TRACKMOUSEEVENT tme;
-      tme.cbSize = sizeof(TRACKMOUSEEVENT);
-      tme.dwFlags = dwFlags;
-      tme.hwndTrack = hwnd;
-      tme.dwHoverTime = HOVER_DEFAULT; /* not used */
-
-      if (!p_TrackMouseEvent (&tme))
-        WIN32_API_FAILED ("TrackMouseEvent");
-      else if (dwFlags == TME_LEAVE)
-        GDK_NOTE (EVENTS, g_print(" (TrackMouseEvent %p)", hwnd));
-      else if (dwFlags == TME_CANCEL)
-	GDK_NOTE (EVENTS, g_print(" (cancel TrackMouseEvent %p)", hwnd));
-    }
+  TRACKMOUSEEVENT tme;
+
+  tme.cbSize = sizeof(TRACKMOUSEEVENT);
+  tme.dwFlags = dwFlags;
+  tme.hwndTrack = hwnd;
+  tme.dwHoverTime = HOVER_DEFAULT; /* not used */
+
+  if (!TrackMouseEvent (&tme))
+    WIN32_API_FAILED ("TrackMouseEvent");
+  else if (dwFlags == TME_LEAVE)
+    GDK_NOTE (EVENTS, g_print(" (TrackMouseEvent %p)", hwnd));
+  else if (dwFlags == TME_CANCEL)
+    GDK_NOTE (EVENTS, g_print(" (cancel TrackMouseEvent %p)", hwnd));
 }
 
 gulong

commit 6d37b26673ab5ee1a190dc9da867de729c0eb927
Author: Tor Lillqvist <tml@iki.fi>
Date:   Thu Sep 9 19:48:42 2010 +0300

    Avoid potential DLL hijacking in Wintab code
    
    Load Wintab32.dll from an absolute path. A proper Wintab32.dll, if
    present, should be in the Windows system directory, so load it from
    there.
---
 gdk/win32/gdkinput-win32.c |   26 ++++++++++++++++++++++++--
 1 files changed, 24 insertions(+), 2 deletions(-)

diff --git a/gdk/win32/gdkinput-win32.c b/gdk/win32/gdkinput-win32.c
index d844a58..e1a07b3 100644
--- a/gdk/win32/gdkinput-win32.c
+++ b/gdk/win32/gdkinput-win32.c
@@ -37,6 +37,8 @@
 #include "gdkprivate-win32.h"
 #include "gdkinput-win32.h"
 
+#define WINTAB32_DLL "Wintab32.dll"
+
 #define PACKETDATA (PK_CONTEXT | PK_CURSOR | PK_BUTTONS | PK_X | PK_Y  | PK_NORMAL_PRESSURE | PK_ORIENTATION)
 /* We want everything in absolute mode */
 #define PACKETMODE (0)
@@ -334,12 +336,14 @@ _gdk_input_wintab_init_check (void)
   BOOL active;
   DWORD physid;
   AXIS axis_x, axis_y, axis_npressure, axis_or[3];
-  int i, k;
+  int i, k, n;
   int devix, cursorix;
   wchar_t devname[100], csrname[100];
   gchar *devname_utf8, *csrname_utf8;
   BOOL defcontext_done;
   HMODULE wintab32;
+  char *wintab32_dll_path;
+  char dummy;
 
   if (wintab_initialized)
     return;
@@ -351,7 +355,25 @@ _gdk_input_wintab_init_check (void)
   if (_gdk_input_ignore_wintab)
     return;
 
-  if ((wintab32 = LoadLibrary ("wintab32.dll")) == NULL)
+  n = GetSystemDirectory (&dummy, 0);
+
+  if (n <= 0)
+    return;
+
+  wintab32_dll_path = g_malloc (n + 1 + strlen (WINTAB32_DLL));
+  k = GetSystemDirectory (wintab32_dll_path, n);
+  
+  if (k == 0 || k > n)
+    {
+      g_free (wintab32_dll_path);
+      return;
+    }
+
+  if (!G_IS_DIR_SEPARATOR (wintab32_dll_path[strlen (wintab32_dll_path) -1]))
+    strcat (wintab32_dll_path, G_DIR_SEPARATOR_S);
+  strcat (wintab32_dll_path, WINTAB32_DLL);
+
+  if ((wintab32 = LoadLibrary (wintab32_dll_path)) == NULL)
     return;
 
   if ((p_WTInfoA = (t_WTInfoA) GetProcAddress (wintab32, "WTInfoA")) == NULL)

commit aa85263c0ee8c1ce84c2df21ecdd481ecb47c590
Author: Tor Lillqvist <tml@iki.fi>
Date:   Thu Sep 9 21:09:46 2010 +0300

    Link directly to GDI+ API avoiding LoadLibrary
    
    Avoid potential DLL hijacking risks by not calling LoadLibrary() to
    load gdiplus.dll. As gdiplus.dll is a WinSxS (side-by-side) DLL we
    couldn't use the full path anyway as we don't know it.
    
    So just link to the GDI+ functions directly. Gdiplus.dll should be
    present on all Windows versions we support anyway. Some complexity
    added as MinGW doesn't come with an import library for gdiplus.dll, so
    we have to create one ourselves. But we call relatively few functions
    from gdiplus.dll so that is not a big deal.
    
    Note that despite being a side-by-side DLL (or "assembly"),
    gdiplus.dll is apparently a special case in that you don't need a
    manifest to tell the OS which version of gdiplus.dll you want. Weird.
---
 gdk-pixbuf/Makefile.am      |   31 +++++++++++-----
 gdk-pixbuf/io-gdip-native.h |   63 ++++++++++++++------------------
 gdk-pixbuf/io-gdip-utils.c  |   84 ++-----------------------------------------
 3 files changed, 51 insertions(+), 127 deletions(-)

diff --git a/gdk-pixbuf/Makefile.am b/gdk-pixbuf/Makefile.am
index c1ac554..a5f52f6 100644
--- a/gdk-pixbuf/Makefile.am
+++ b/gdk-pixbuf/Makefile.am
@@ -195,6 +195,15 @@ libpixbufloader_jasper_la_LIBADD = $(LIBJASPER) $(module_libs)
 
 if BUILD_GDIPLUS_LOADERS
 
+# MinGW doesn't come with any import library for gdiplus.dll, so
+# create a partial one that's enough for our use.
+
+libgdiplus = libgdiplus.dll.a
+gdiplus_ldflag = -Wl,$(libgdiplus)
+
+libgdiplus.dll.a: gdiplus.def
+	$(DLLTOOL) --kill-at --dllname gdiplus.dll --input-def gdiplus.def --output-lib $@
+
 if INCLUDE_GDIPLUS
 
 # When building the GDI+ loader statically, we put the "common" objects
@@ -250,7 +259,7 @@ GDIPLUS_LIBS = \
 	libpixbufloader-gdip-jpeg.la \
 	libpixbufloader-gdip-tiff.la
 
-libpixbufloader_gdip_ico_la_LDFLAGS = -avoid-version -module -no-undefined
+libpixbufloader_gdip_ico_la_LDFLAGS = -avoid-version -module -no-undefined $(gdiplus_ldflag)
 libpixbufloader_gdip_ico_la_SOURCES = 	\
 	io-gdip-native.h		\
 	io-gdip-propertytags.h		\
@@ -261,7 +270,7 @@ libpixbufloader_gdip_ico_la_SOURCES = 	\
 	io-gdip-ico.c
 libpixbufloader_gdip_ico_la_LIBADD = $(module_libs) $(libole32)
 
-libpixbufloader_gdip_wmf_la_LDFLAGS = -avoid-version -module -no-undefined
+libpixbufloader_gdip_wmf_la_LDFLAGS = -avoid-version -module -no-undefined $(gdiplus_ldflag)
 libpixbufloader_gdip_wmf_la_SOURCES = 	\
 	io-gdip-native.h		\
 	io-gdip-propertytags.h		\
@@ -272,7 +281,7 @@ libpixbufloader_gdip_wmf_la_SOURCES = 	\
 	io-gdip-wmf.c
 libpixbufloader_gdip_wmf_la_LIBADD = $(module_libs) $(libole32)
 
-libpixbufloader_gdip_emf_la_LDFLAGS = -avoid-version -module -no-undefined
+libpixbufloader_gdip_emf_la_LDFLAGS = -avoid-version -module -no-undefined $(gdiplus_ldflag)
 libpixbufloader_gdip_emf_la_SOURCES = 	\
 	io-gdip-native.h		\
 	io-gdip-propertytags.h		\
@@ -283,7 +292,7 @@ libpixbufloader_gdip_emf_la_SOURCES = 	\
 	io-gdip-emf.c
 libpixbufloader_gdip_emf_la_LIBADD = $(module_libs) $(libole32)
 
-libpixbufloader_gdip_bmp_la_LDFLAGS = -avoid-version -module -no-undefined
+libpixbufloader_gdip_bmp_la_LDFLAGS = -avoid-version -module -no-undefined $(gdiplus_ldflag)
 libpixbufloader_gdip_bmp_la_SOURCES = 	\
 	io-gdip-native.h		\
 	io-gdip-propertytags.h		\
@@ -294,7 +303,7 @@ libpixbufloader_gdip_bmp_la_SOURCES = 	\
 	io-gdip-bmp.c
 libpixbufloader_gdip_bmp_la_LIBADD = $(module_libs) $(libole32)
 
-libpixbufloader_gdip_gif_la_LDFLAGS = -avoid-version -module -no-undefined
+libpixbufloader_gdip_gif_la_LDFLAGS = -avoid-version -module -no-undefined $(gdiplus_ldflag)
 libpixbufloader_gdip_gif_la_SOURCES = 	\
 	io-gdip-native.h		\
 	io-gdip-propertytags.h		\
@@ -305,7 +314,7 @@ libpixbufloader_gdip_gif_la_SOURCES = 	\
 	io-gdip-gif.c
 libpixbufloader_gdip_gif_la_LIBADD = $(module_libs) $(libole32)
 
-libpixbufloader_gdip_jpeg_la_LDFLAGS = -avoid-version -module -no-undefined
+libpixbufloader_gdip_jpeg_la_LDFLAGS = -avoid-version -module -no-undefined $(gdiplus_ldflag)
 libpixbufloader_gdip_jpeg_la_SOURCES = 	\
 	io-gdip-native.h		\
 	io-gdip-propertytags.h		\
@@ -327,7 +336,7 @@ libpixbufloader_gdip_png_la_SOURCES = 	\
 	io-gdip-png.c
 libpixbufloader_gdip_png_la_LIBADD = $(module_libs) $(libole32)
 
-libpixbufloader_gdip_tiff_la_LDFLAGS = -avoid-version -module -no-undefined
+libpixbufloader_gdip_tiff_la_LDFLAGS = -avoid-version -module -no-undefined $(gdiplus_ldflag)
 libpixbufloader_gdip_tiff_la_SOURCES = 	\
 	io-gdip-native.h		\
 	io-gdip-propertytags.h		\
@@ -552,11 +561,12 @@ libgdk_pixbuf_2_0_la_LDFLAGS = \
 	-version-info $(LT_VERSION_INFO)	\
 	$(LIBTOOL_EXPORT_OPTIONS)		\
 	$(no_undefined)				\
-	$(gdk_pixbuf_symbols)
+	$(gdk_pixbuf_symbols)			\
+	$(gdiplus_ldflag)
 
 
 libgdk_pixbuf_2_0_la_LIBADD = pixops/libpixops.la $(builtin_objs) $(GDK_PIXBUF_DEP_LIBS) $(libole32)
-libgdk_pixbuf_2_0_la_DEPENDENCIES = pixops/libpixops.la $(builtin_objs) $(gdk_pixbuf_def) $(gdk_pixbuf_win32_res)
+libgdk_pixbuf_2_0_la_DEPENDENCIES = pixops/libpixops.la $(builtin_objs) $(gdk_pixbuf_def) $(gdk_pixbuf_win32_res) $(libgdiplus)
 
 gdk_pixbuf_headers = 			\
 	gdk-pixbuf.h			\
@@ -668,7 +678,8 @@ EXTRA_DIST +=					\
 	gdk-pixbuf-marshal.list			\
 	gdk-pixbuf-enum-types.c.template	\
 	gdk-pixbuf-enum-types.h.template	\
-	gen-color-table.pl
+	gen-color-table.pl			\
+	gdiplus.def
 
 if CROSS_COMPILING
 RUN_QUERY_LOADER_TEST=false
diff --git a/gdk-pixbuf/io-gdip-native.h b/gdk-pixbuf/io-gdip-native.h
index 24ea824..417a747 100644
--- a/gdk-pixbuf/io-gdip-native.h
+++ b/gdk-pixbuf/io-gdip-native.h
@@ -224,41 +224,32 @@ typedef struct _GpRect GpRect;
 #define IStream_SetSize(This,size) (This)->lpVtbl->SetSize(This,size)
 #endif
 
-typedef GpStatus (WINGDIPAPI* GdiplusStartupFunc) (gpointer, const gpointer, gpointer);
-typedef GpStatus (WINGDIPAPI* GdipCreateBitmapFromStreamFunc) (gpointer, GpBitmap**);
-typedef GpStatus (WINGDIPAPI* GdipBitmapGetPixelFunc) (GpBitmap*, gint x, gint y, ARGB*);
-typedef GpStatus (WINGDIPAPI* GdipGetImageWidthFunc) (GpImage*, guint*);
-typedef GpStatus (WINGDIPAPI* GdipGetImageHeightFunc) (GpImage*, guint*);
-typedef GpStatus (WINGDIPAPI* GdipDisposeImageFunc) (GpImage*);
-typedef GpStatus (WINGDIPAPI* GdipGetImageFlagsFunc) (GpImage *, guint*);
-typedef GpStatus (WINGDIPAPI* GdipImageGetFrameCountFunc) (GpImage *image, const GUID* dimensionID, UINT* count);
-typedef GpStatus (WINGDIPAPI* GdipImageSelectActiveFrameFunc) (GpImage *image, const GUID* dimensionID, UINT frameIndex);
-typedef GpStatus (WINGDIPAPI* GdipGetPropertyItemSizeFunc) (GpImage *image, int propId, guint* size);
-typedef GpStatus (WINGDIPAPI* GdipGetPropertyItemFunc) (GpImage *image, int propId, guint propSize, PropertyItem* buffer);
-typedef GpStatus (WINGDIPAPI* GdipGetPropertyCountFunc) (GpImage *image, guint* numOfProperty);
-typedef GpStatus (WINGDIPAPI* GdipGetPropertyIdListFunc) (GpImage *image, guint numOfProperty, PROPID* list);
-typedef GpStatus (WINGDIPAPI* GdipCreateBitmapFromScan0Func) (INT width, INT height, INT stride, PixelFormat format, BYTE* scan0, 
-                                                              GpBitmap** bitmap);
-typedef GpStatus (WINGDIPAPI* GdipSaveImageToStreamFunc) (GpImage *image, IStream* stream, const CLSID* clsidEncoder, 
-                                                          const EncoderParameters* encoderParams);
-
-typedef GpStatus (WINGDIPAPI* GdipGetImageEncodersFunc) (UINT numEncoders, UINT size, ImageCodecInfo *encoders);
-typedef GpStatus (WINGDIPAPI* GdipGetImageEncodersSizeFunc) (UINT *numEncoders, UINT *size);
-typedef GpStatus (WINGDIPAPI* GdipBitmapSetPixelFunc) (GpBitmap* bitmap, INT x, INT y, ARGB color);
-
-typedef GpStatus (WINGDIPAPI* GdipDrawImageIFunc) (GpGraphics *graphics, GpImage *image, INT x, INT y);
-typedef GpStatus (WINGDIPAPI* GdipGetImageGraphicsContextFunc) (GpImage *image, GpGraphics **graphics);
-typedef GpStatus (WINGDIPAPI* GdipFlushFunc) (GpGraphics *graphics, INT intention);
-typedef GpStatus (WINGDIPAPI* GdipGraphicsClearFunc) (GpGraphics *graphics, ARGB color);
-typedef GpStatus (WINGDIPAPI* GdipBitmapSetResolutionFunc) (GpBitmap* bitmap, float xdpi, float ydpi);
-typedef GpStatus (WINGDIPAPI* GdipGetImageHorizontalResolutionFunc) (GpImage *image, float *resolution);
-typedef GpStatus (WINGDIPAPI* GdipGetImageVerticalResolutionFunc) (GpImage *image, float *resolution);
-typedef GpStatus (WINGDIPAPI* GdipLoadImageFromStreamFunc) (IStream* stream, GpImage **image);
-typedef GpStatus (WINGDIPAPI* GdipDeleteGraphicsFunc) (GpGraphics *graphics);
-
-typedef GpStatus (WINGDIPAPI* GdipBitmapLockBitsFunc) (GpBitmap* bitmap, const GpRect* rect, UINT flags, PixelFormat format, BitmapData* lockedBitmapData);
-typedef GpStatus (WINGDIPAPI* GdipBitmapUnlockBitsFunc) (GpBitmap* bitmap, BitmapData* lockedBitmapData);
-typedef GpStatus (WINGDIPAPI* GdipGetImagePixelFormatFunc) (GpImage *image, PixelFormat *format);
-typedef GpStatus (WINGDIPAPI* GdipCloneBitmapAreaIFunc) (INT x, INT y, INT width, INT height, PixelFormat format, GpBitmap *srcBitmap, GpBitmap **dstBitmap);
+GpStatus WINGDIPAPI GdiplusStartup (gpointer, const gpointer, gpointer);
+GpStatus WINGDIPAPI GdipCreateBitmapFromStream (gpointer, GpBitmap**);
+GpStatus WINGDIPAPI GdipBitmapGetPixel (GpBitmap*, gint x, gint y, ARGB*);
+GpStatus WINGDIPAPI GdipGetImageWidth (GpImage*, guint*);
+GpStatus WINGDIPAPI GdipGetImageHeight (GpImage*, guint*);
+GpStatus WINGDIPAPI GdipDisposeImage (GpImage*);
+GpStatus WINGDIPAPI GdipGetImageFlags (GpImage *, guint*);
+GpStatus WINGDIPAPI GdipImageGetFrameCount (GpImage *image, const GUID* dimensionID, UINT* count);
+GpStatus WINGDIPAPI GdipImageSelectActiveFrame (GpImage *image, const GUID* dimensionID, UINT frameIndex);
+GpStatus WINGDIPAPI GdipGetPropertyItemSize (GpImage *image, int propId, guint* size);
+GpStatus WINGDIPAPI GdipGetPropertyItem (GpImage *image, int propId, guint propSize, PropertyItem* buffer);
+GpStatus WINGDIPAPI GdipCreateBitmapFromScan0 (INT width, INT height, INT stride, PixelFormat format, BYTE* scan0, 
+                                               GpBitmap** bitmap);
+GpStatus WINGDIPAPI GdipSaveImageToStream (GpImage *image, IStream* stream, const CLSID* clsidEncoder, 
+                                           const EncoderParameters* encoderParams);
+GpStatus WINGDIPAPI GdipGetImageEncoders (UINT numEncoders, UINT size, ImageCodecInfo *encoders);
+GpStatus WINGDIPAPI GdipGetImageEncodersSize (UINT *numEncoders, UINT *size);
+GpStatus WINGDIPAPI GdipBitmapSetPixel (GpBitmap* bitmap, INT x, INT y, ARGB color);
+GpStatus WINGDIPAPI GdipDrawImageI (GpGraphics *graphics, GpImage *image, INT x, INT y);
+GpStatus WINGDIPAPI GdipGetImageGraphicsContext (GpImage *image, GpGraphics **graphics);
+GpStatus WINGDIPAPI GdipFlush (GpGraphics *graphics, INT intention);
+GpStatus WINGDIPAPI GdipGraphicsClear (GpGraphics *graphics, ARGB color);
+GpStatus WINGDIPAPI GdipBitmapSetResolution (GpBitmap* bitmap, float xdpi, float ydpi);
+GpStatus WINGDIPAPI GdipGetImageHorizontalResolution (GpImage *image, float *resolution);
+GpStatus WINGDIPAPI GdipGetImageVerticalResolution (GpImage *image, float *resolution);
+GpStatus WINGDIPAPI GdipLoadImageFromStream (IStream* stream, GpImage **image);
+GpStatus WINGDIPAPI GdipDeleteGraphics (GpGraphics *graphics);
 
 #endif
diff --git a/gdk-pixbuf/io-gdip-utils.c b/gdk-pixbuf/io-gdip-utils.c
index b8fa72b..8f62d75 100644
--- a/gdk-pixbuf/io-gdip-utils.c
+++ b/gdk-pixbuf/io-gdip-utils.c
@@ -43,38 +43,6 @@ struct _GdipContext {
 };
 typedef struct _GdipContext GdipContext;
 
-static GdiplusStartupFunc GdiplusStartup;
-static GdipCreateBitmapFromStreamFunc GdipCreateBitmapFromStream;
-static GdipBitmapGetPixelFunc GdipBitmapGetPixel;
-static GdipGetImageHeightFunc GdipGetImageHeight;
-static GdipDisposeImageFunc GdipDisposeImage;
-static GdipGetImageFlagsFunc GdipGetImageFlags;
-static GdipGetImageWidthFunc GdipGetImageWidth;
-static GdipImageGetFrameCountFunc GdipImageGetFrameCount;
-static GdipImageSelectActiveFrameFunc GdipImageSelectActiveFrame;
-static GdipGetPropertyItemSizeFunc GdipGetPropertyItemSize;
-static GdipGetPropertyItemFunc GdipGetPropertyItem;
-static GdipGetPropertyCountFunc GdipGetPropertyCount;
-static GdipGetPropertyIdListFunc GdipGetPropertyIdList;
-static GdipCreateBitmapFromScan0Func GdipCreateBitmapFromScan0;
-static GdipSaveImageToStreamFunc GdipSaveImageToStream;
-static GdipBitmapSetPixelFunc GdipBitmapSetPixel;
-static GdipDrawImageIFunc GdipDrawImageI;
-static GdipGetImageGraphicsContextFunc GdipGetImageGraphicsContext;
-static GdipFlushFunc GdipFlush;
-static GdipGraphicsClearFunc GdipGraphicsClear;
-static GdipBitmapSetResolutionFunc GdipBitmapSetResolution;
-static GdipGetImageHorizontalResolutionFunc GdipGetImageHorizontalResolution;
-static GdipGetImageVerticalResolutionFunc GdipGetImageVerticalResolution;
-static GdipLoadImageFromStreamFunc GdipLoadImageFromStream;
-static GdipDeleteGraphicsFunc GdipDeleteGraphics;
-static GdipGetImageEncodersFunc GdipGetImageEncoders;
-static GdipGetImageEncodersSizeFunc GdipGetImageEncodersSize;
-static GdipBitmapLockBitsFunc GdipBitmapLockBits;
-static GdipBitmapUnlockBitsFunc GdipBitmapUnlockBits;
-static GdipGetImagePixelFormatFunc GdipGetImagePixelFormat;
-static GdipCloneBitmapAreaIFunc GdipCloneBitmapAreaI;
-
 DEFINE_GUID(FrameDimensionTime, 0x6aedbd6d,0x3fb5,0x418a,0x83,0xa6,0x7f,0x45,0x22,0x9d,0xc8,0x72);
 DEFINE_GUID(FrameDimensionPage, 0x7462dc86,0x6180,0x4c7e,0x8e,0x3f,0xee,0x73,0x33,0xa7,0xa4,0x83);
 
@@ -131,58 +99,12 @@ gdip_init (void)
 {
   GdiplusStartupInput input;
   ULONG_PTR gdiplusToken = 0;
-  static HINSTANCE gdipluslib = NULL;
+  static gboolean beenhere = FALSE;
 
-  if (!gdipluslib)
-    gdipluslib = LoadLibrary ("gdiplus.dll");
-  else
+  if (beenhere)
     return TRUE; /* gdip_init() is idempotent */
 
-  if (!gdipluslib)
-    return FALSE;
-
-#define LOOKUP(func) \
-  G_STMT_START { \
-    func = (func##Func) GetProcAddress (gdipluslib, #func); \
-    if (!func) {\
-      g_warning ("Couldn't find GDI+ function %s\n", #func); \
-      return FALSE; \
-    } \
-  } G_STMT_END
-
-  LOOKUP (GdiplusStartup);
-  LOOKUP (GdipCreateBitmapFromStream);
-  LOOKUP (GdipBitmapGetPixel);
-  LOOKUP (GdipGetImageHeight);
-  LOOKUP (GdipDisposeImage);
-  LOOKUP (GdipGetImageFlags);
-  LOOKUP (GdipGetImageWidth);
-  LOOKUP (GdipImageGetFrameCount);
-  LOOKUP (GdipImageSelectActiveFrame);
-  LOOKUP (GdipGetPropertyItemSize);
-  LOOKUP (GdipGetPropertyItem);
-  LOOKUP (GdipGetPropertyCount);
-  LOOKUP (GdipGetPropertyIdList);
-  LOOKUP (GdipCreateBitmapFromScan0);
-  LOOKUP (GdipSaveImageToStream);
-  LOOKUP (GdipBitmapSetPixel);
-  LOOKUP (GdipDrawImageI);
-  LOOKUP (GdipGetImageGraphicsContext);
-  LOOKUP (GdipFlush);
-  LOOKUP (GdipGraphicsClear);
-  LOOKUP (GdipBitmapSetResolution);
-  LOOKUP (GdipGetImageHorizontalResolution);
-  LOOKUP (GdipGetImageVerticalResolution);
-  LOOKUP (GdipLoadImageFromStream);
-  LOOKUP (GdipDeleteGraphics);
-  LOOKUP (GdipGetImageEncoders);
-  LOOKUP (GdipGetImageEncodersSize);
-  LOOKUP (GdipBitmapLockBits);
-  LOOKUP (GdipBitmapUnlockBits);
-  LOOKUP (GdipGetImagePixelFormat);
-  LOOKUP (GdipCloneBitmapAreaI);
-
-#undef LOOKUP
+  beenhere = TRUE;
 
   input.GdiplusVersion = 1;
   input.DebugEventCallback = NULL;

commit a9a505a5ce409039031799b5c6a992c9bd21578a
Author: Tor Lillqvist <tml@iki.fi>
Date:   Thu Sep 9 21:11:27 2010 +0300

    Add gdiplus.def
---
 gdk-pixbuf/gdiplus.def |   26 ++++++++++++++++++++++++++
 1 files changed, 26 insertions(+), 0 deletions(-)

diff --git a/gdk-pixbuf/gdiplus.def b/gdk-pixbuf/gdiplus.def
new file mode 100644
index 0000000..a32a4a1
--- /dev/null
+++ b/gdk-pixbuf/gdiplus.def
@@ -0,0 +1,26 @@
+EXPORTS
+	GdiplusStartup
+	GdipCreateBitmapFromStream
+	GdipBitmapGetPixel
+	GdipGetImageWidth
+	GdipGetImageHeight
+	GdipDisposeImage
+	GdipGetImageFlags
+	GdipImageGetFrameCount
+	GdipImageSelectActiveFrame
+	GdipGetPropertyItemSize
+	GdipGetPropertyItem
+	GdipCreateBitmapFromScan0
+	GdipSaveImageToStream
+	GdipGetImageEncoders
+	GdipGetImageEncodersSize
+	GdipBitmapSetPixel
+	GdipDrawImageI
+	GdipGetImageGraphicsContext
+	GdipFlush
+	GdipGraphicsClear
+	GdipBitmapSetResolution
+	GdipGetImageHorizontalResolution
+	GdipGetImageVerticalResolution
+	GdipLoadImageFromStream
+	GdipDeleteGraphics
EOF

patch --verbose --fuzz=0 -p0 <<'EOF' &&
--- Makefile.in
+++ Makefile.in
@@ -527,7 +527,7 @@
 	&& DISPLAY=:$$XID && export DISPLAY
 
 
-SRC_SUBDIRS = gdk-pixbuf gdk gtk modules demos tests perf contrib
+SRC_SUBDIRS = gdk-pixbuf gdk gtk modules demos
 SUBDIRS = po po-properties $(SRC_SUBDIRS) docs m4macros
 
 # require automake 1.4
EOF

patch --verbose --fuzz=0 -p0 <<'EOF' &&
--- gdk-pixbuf/Makefile.in
+++ gdk-pixbuf/Makefile.in
@@ -401,7 +401,7 @@
 	gdk-pixbuf-marshal.list			\
 	gdk-pixbuf-enum-types.c.template	\
 	gdk-pixbuf-enum-types.h.template	\
-	gen-color-table.pl
+	gen-color-table.pl gdipus.def
 
 TEST_PROGS = 
 
@@ -582,6 +582,12 @@
 libpixbufloader_jasper_la_LIBADD = $(LIBJASPER) $(module_libs)
 
 
+libgdiplus = libgdiplus.dll.a
+gdiplus_ldflag = -Wl,$(libgdiplus)
+
+libgdiplus.dll.a: gdiplus.def
+	$(DLLTOOL) --kill-at --dllname gdiplus.dll --input-def gdiplus.def --output-lib $@
+
 # When building the GDI+ loader statically, we put the "common" objects
 # only in one of the archives to avoid duplicate definitions
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_TRUE@STATIC_GDIPLUS_LIBS = \
@@ -642,7 +648,7 @@
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@	libpixbufloader-gdip-tiff.la
 
 
-@BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_ico_la_LDFLAGS = -avoid-version -module -no-undefined
+@BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_ico_la_LDFLAGS = -avoid-version -module -no-undefined $(gdiplus_ldflag)
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_ico_la_SOURCES = \
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@	io-gdip-native.h		\
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@	io-gdip-propertytags.h		\
@@ -654,7 +660,7 @@
 
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_ico_la_LIBADD = $(module_libs) $(libole32)
 
-@BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_wmf_la_LDFLAGS = -avoid-version -module -no-undefined
+@BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_wmf_la_LDFLAGS = -avoid-version -module -no-undefined $(gdiplus_ldflag)
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_wmf_la_SOURCES = \
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@	io-gdip-native.h		\
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@	io-gdip-propertytags.h		\
@@ -666,7 +672,7 @@
 
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_wmf_la_LIBADD = $(module_libs) $(libole32)
 
-@BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_emf_la_LDFLAGS = -avoid-version -module -no-undefined
+@BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_emf_la_LDFLAGS = -avoid-version -module -no-undefined $(gdiplus_ldflag)
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_emf_la_SOURCES = \
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@	io-gdip-native.h		\
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@	io-gdip-propertytags.h		\
@@ -678,7 +684,7 @@
 
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_emf_la_LIBADD = $(module_libs) $(libole32)
 
-@BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_bmp_la_LDFLAGS = -avoid-version -module -no-undefined
+@BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_bmp_la_LDFLAGS = -avoid-version -module -no-undefined $(gdiplus_ldflag)
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_bmp_la_SOURCES = \
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@	io-gdip-native.h		\
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@	io-gdip-propertytags.h		\
@@ -690,7 +696,7 @@
 
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_bmp_la_LIBADD = $(module_libs) $(libole32)
 
-@BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_gif_la_LDFLAGS = -avoid-version -module -no-undefined
+@BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_gif_la_LDFLAGS = -avoid-version -module -no-undefined $(gdiplus_ldflag)
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_gif_la_SOURCES = \
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@	io-gdip-native.h		\
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@	io-gdip-propertytags.h		\
@@ -702,7 +708,7 @@
 
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_gif_la_LIBADD = $(module_libs) $(libole32)
 
-@BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_jpeg_la_LDFLAGS = -avoid-version -module -no-undefined
+@BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_jpeg_la_LDFLAGS = -avoid-version -module -no-undefined $(gdiplus_ldflag)
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_jpeg_la_SOURCES = \
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@	io-gdip-native.h		\
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@	io-gdip-propertytags.h		\
@@ -714,7 +720,7 @@
 
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_jpeg_la_LIBADD = $(module_libs) $(libole32)
 
-@BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_png_la_LDFLAGS = -avoid-version -module -no-undefined
+@BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_png_la_LDFLAGS = -avoid-version -module -no-undefined $(gdiplus_ldflag)
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_png_la_SOURCES = \
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@	io-gdip-native.h		\
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@	io-gdip-propertytags.h		\
@@ -726,7 +732,7 @@
 
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_png_la_LIBADD = $(module_libs) $(libole32)
 
-@BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_tiff_la_LDFLAGS = -avoid-version -module -no-undefined
+@BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_tiff_la_LDFLAGS = -avoid-version -module -no-undefined $(gdiplus_ldflag)
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@libpixbufloader_gdip_tiff_la_SOURCES = \
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@	io-gdip-native.h		\
 @BUILD_GDIPLUS_LOADERS_TRUE@@INCLUDE_GDIPLUS_FALSE@	io-gdip-propertytags.h		\
@@ -888,11 +894,12 @@
 	-version-info $(LT_VERSION_INFO)	\
 	$(LIBTOOL_EXPORT_OPTIONS)		\
 	$(no_undefined)				\
-	$(gdk_pixbuf_symbols)
+	$(gdk_pixbuf_symbols)			\
+	$(gdiplus_ldflag)
 
 
 libgdk_pixbuf_2_0_la_LIBADD = pixops/libpixops.la $(builtin_objs) $(GDK_PIXBUF_DEP_LIBS) $(libole32)
-libgdk_pixbuf_2_0_la_DEPENDENCIES = pixops/libpixops.la $(builtin_objs) $(gdk_pixbuf_def) $(gdk_pixbuf_win32_res)
+libgdk_pixbuf_2_0_la_DEPENDENCIES = pixops/libpixops.la $(builtin_objs) $(gdk_pixbuf_def) $(gdk_pixbuf_win32_res) $(libgdiplus)
 
 gdk_pixbuf_headers = \
 	gdk-pixbuf.h			\
EOF

patch --verbose --fuzz=0 -p1 <<'EOF' &&
commit ba5ba3b022d6811c886501fb015e99ce8ee80138
Author: Benjamin Otte <otte@redhat.com>
Date:   Wed Sep 1 00:59:56 2010 +0200

    gdk: Ensure flush of surface when cairo_t is destroyed
    
    Add an ugly workaround because GTK does not ensure surfaces get flushed
    before directly accessing the drawable backed by the surface. This is
    not visible on X11 (where flushing is a no-op), but can be seen on
    Windows.
    
    https://bugzilla.gnome.org/show_bug.cgi?id=628291

diff --git a/gdk/gdkcairo.c b/gdk/gdkcairo.c
index ef8ec25..e1d0daf 100644
--- a/gdk/gdkcairo.c
+++ b/gdk/gdkcairo.c
@@ -23,6 +23,13 @@
 #include "gdkregion-generic.h"
 #include "gdkalias.h"
 
+static void
+gdk_ensure_surface_flush (gpointer surface)
+{
+  cairo_surface_flush (surface);
+  cairo_surface_destroy (surface);
+}
+
 /**
  * gdk_cairo_create:
  * @drawable: a #GdkDrawable
@@ -43,6 +50,7 @@
 cairo_t *
 gdk_cairo_create (GdkDrawable *drawable)
 {
+  static const cairo_user_data_key_t key;
   cairo_surface_t *surface;
   cairo_t *cr;
     
@@ -54,7 +62,12 @@ gdk_cairo_create (GdkDrawable *drawable)
 
   surface = _gdk_drawable_ref_cairo_surface (drawable);
   cr = cairo_create (surface);
-  cairo_surface_destroy (surface);
+  /* Ugly workaround for GTK not ensuring to flush surfaces before
+   * directly accessing the drawable backed by the surface. Not visible
+   * on X11 (where flushing is a no-op). For details, see
+   * https://bugzilla.gnome.org/show_bug.cgi?id=628291
+   */
+  cairo_set_user_data (cr, &key, surface, gdk_ensure_surface_flush);
 
   return cr;
 }
EOF

patch --verbose --fuzz=0 -p0 <<'EOF' &&
--- gtk/gtkprintoperation-win32.c
+++ gtk/gtkprintoperation-win32.c
@@ -72,7 +72,7 @@
 
 static const GUID myIID_IPrintDialogCallback  = {0x5852a2c3,0x6530,0x11d1,{0xb6,0xa3,0x0,0x0,0xf8,0x75,0x7b,0xf9}};
 
-#if !defined (_MSC_VER) && !defined (MINGW64) && !defined (__MINGW64)
+#if 0
 #undef INTERFACE
 #define INTERFACE IPrintDialogCallback
 DECLARE_INTERFACE_ (IPrintDialogCallback, IUnknown)
EOF

lt_cv_deplibs_check_method='pass_all' \
CC='x86_64-w64-mingw32-gcc' \
CPPFLAGS="-I/devel/dist/${ARCH}/${LIBPNG}/include \
-I/devel/dist/${ARCH}/${ZLIB}/include \
-I/devel/dist/${ARCH}/${GETTEXT_RUNTIME}/include" \
LDFLAGS="-L/devel/dist/${ARCH}/${LIBPNG}/lib \
-L/devel/dist/${ARCH}/${ZLIB}/lib \
-L/devel/dist/${ARCH}/${GETTEXT_RUNTIME}/lib \
-Wl,--enable-auto-image-base" \
LIBS=-lintl \
LIBPNG=`pkg-config --libs libpng` \
CFLAGS=-O2 \
./configure --host=x86_64-w64-mingw32 \
--with-gdktarget=win32 \
--enable-gdiplus \
--with-included-loaders \
--with-included-immodules \
--without-libjasper \
--enable-debug=yes \
--enable-explicit-deps=no \
--disable-gtk-doc \
--disable-static \
--prefix=$TARGET &&

rm gtk/gtk.def &&
PATH="$PWD/gdk-pixbuf/.libs:/devel/target/$HEX/bin:$PATH" make -j3 install &&

(echo '# Note: After adding a new separate gdk-pixbuf loader (for instance the svg one)' &&
    echo '# run gdk-pixbuf-query-loaders.exe redirecting its output into this file.' &&
    echo &&
    echo '# Note that the LoaderDir folder below does not name a folder that is' &&
    echo '# expected to exist. It was just a temporary directory used at build time.' &&
    echo &&
    cat $TARGET/etc/gtk-2.0/gdk-pixbuf.loaders ) >$TARGET/etc/gtk-2.0/gdk-pixbuf.loaders.temp &&
    mv $TARGET/etc/gtk-2.0/gdk-pixbuf.loaders.temp $TARGET/etc/gtk-2.0/gdk-pixbuf.loaders &&

grep -v -E 'Automatically generated|Created by|ModulesPath =' <$TARGET/etc/gtk-2.0/gtk.immodules >$TARGET/etc/gtk-2.0/gtk.immodules.temp &&
    mv $TARGET/etc/gtk-2.0/gtk.immodules.temp $TARGET/etc/gtk-2.0/gtk.immodules &&

./gtk-zip.sh &&

# Package also the gtk-update-icon-cache.exe.manifest
cp -p gtk/gtk-update-icon-cache.exe.manifest $TARGET/bin
(cd $TARGET && zip /tmp/${MOD}-dev-${VER}.zip bin/gtk-update-icon-cache.exe.manifest) &&

mv /tmp/${MOD}-${VER}.zip /tmp/$RUNZIP &&
mv /tmp/${MOD}-dev-${VER}.zip /tmp/$DEVZIP

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
