# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=libart-lgpl
VER=2.3.21
REV=1
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev

(

set -x

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

usedev

CC='gcc -mthreads' CFLAGS=-O2 ./configure --disable-static --prefix=c:/devel/target/$HEX &&

PATH=/devel/target/$HEX/bin:$PATH make install &&
PATH=/devel/target/$HEX/bin:$PATH make check &&

./libart-zip &&

mv /tmp/libart_lgpl-${VER}.zip /tmp/$RUNZIP &&
mv /tmp/libart_lgpl-dev-${VER}.zip /tmp/$DEVZIP &&

:

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
