/* chess-scene.c generated by valac 0.21.1.8-8f10, the Vala compiler
 * generated from chess-scene.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
typedef struct _ChessModelPrivate ChessModelPrivate;

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;
#define _chess_piece_unref0(var) ((var == NULL) ? NULL : (var = (chess_piece_unref (var), NULL)))
typedef struct _ParamSpecChessModel ParamSpecChessModel;

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;
#define __g_list_free__chess_model_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__chess_model_unref0_ (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _chess_game_unref0(var) ((var == NULL) ? NULL : (var = (chess_game_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;
typedef struct _ChessPiecePrivate ChessPiecePrivate;

#define TYPE_PIECE_TYPE (piece_type_get_type ())

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
#define _chess_model_unref0(var) ((var == NULL) ? NULL : (var = (chess_model_unref (var), NULL)))
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

#define TYPE_COLOR (color_get_type ())

struct _ChessModel {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessModelPrivate * priv;
	ChessPiece* piece;
	gdouble x;
	gdouble y;
	gdouble target_x;
	gdouble target_y;
	gboolean under_threat;
	gboolean is_selected;
};

struct _ChessModelClass {
	GTypeClass parent_class;
	void (*finalize) (ChessModel *self);
};

struct _ParamSpecChessModel {
	GParamSpec parent_instance;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _ChessScenePrivate {
	gboolean _can_move[64];
	GTimer* animation_timer;
	gdouble animation_time;
	ChessGame* _game;
	gint _move_number;
	gboolean _show_numbering;
	gboolean _show_move_hints;
	gchar* _theme_name;
	gboolean _show_3d_smooth;
	gchar* _board_side;
	gchar* _move_format;
};

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};


static gpointer chess_model_parent_class = NULL;
static gpointer chess_scene_parent_class = NULL;

gpointer chess_model_ref (gpointer instance);
void chess_model_unref (gpointer instance);
GParamSpec* param_spec_chess_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_model (GValue* value, gpointer v_object);
void value_take_chess_model (GValue* value, gpointer v_object);
gpointer value_get_chess_model (const GValue* value);
GType chess_model_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
enum  {
	CHESS_MODEL_DUMMY_PROPERTY
};
ChessModel* chess_model_new (ChessPiece* piece, gdouble x, gdouble y);
ChessModel* chess_model_construct (GType object_type, ChessPiece* piece, gdouble x, gdouble y);
gboolean chess_model_move_to (ChessModel* self, gdouble x, gdouble y);
gboolean chess_model_animate (ChessModel* self, gdouble timestep);
gboolean chess_model_get_moving (ChessModel* self);
static gdouble chess_model_update_position (ChessModel* self, gdouble timestep, gdouble value, gdouble target);
static void chess_model_finalize (ChessModel* obj);
GType chess_scene_get_type (void) G_GNUC_CONST;
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
#define CHESS_SCENE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_SCENE, ChessScenePrivate))
enum  {
	CHESS_SCENE_DUMMY_PROPERTY,
	CHESS_SCENE_GAME,
	CHESS_SCENE_MOVE_NUMBER,
	CHESS_SCENE_SHOW_NUMBERING,
	CHESS_SCENE_SHOW_MOVE_HINTS,
	CHESS_SCENE_THEME_NAME,
	CHESS_SCENE_SHOW_3D_SMOOTH,
	CHESS_SCENE_BOARD_SIDE,
	CHESS_SCENE_BOARD_ANGLE,
	CHESS_SCENE_MOVE_FORMAT
};
static void _chess_model_unref0_ (gpointer var);
static void _g_list_free__chess_model_unref0_ (GList* self);
ChessPiece* chess_scene_get_selected_piece (ChessScene* self);
ChessGame* chess_scene_get_game (ChessScene* self);
ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number);
gint chess_scene_get_move_number (ChessScene* self);
ChessScene* chess_scene_new (void);
ChessScene* chess_scene_construct (GType object_type);
void chess_scene_select_square (ChessScene* self, gint file, gint rank);
GType chess_player_get_type (void) G_GNUC_CONST;
ChessPlayer* chess_game_get_current_player (ChessGame* self);
gboolean chess_player_get_local_human (ChessPlayer* self);
GType piece_type_get_type (void) G_GNUC_CONST;
gboolean chess_player_move_with_coords (ChessPlayer* self, gint r0, gint f0, gint r1, gint f1, gboolean apply, PieceType promotion_type);
static void chess_scene_update_board (ChessScene* self);
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
static void chess_scene_moved_cb (ChessScene* self, ChessGame* game, ChessMove* move);
static void chess_scene_paused_cb (ChessScene* self, ChessGame* game);
static void chess_scene_unpaused_cb (ChessScene* self, ChessGame* game);
static void chess_scene_undo_cb (ChessScene* self, ChessGame* game);
static ChessModel* chess_scene_find_model (ChessScene* self, ChessPiece* piece);
void chess_game_add_hold (ChessGame* self);
static gboolean chess_scene_animate_cb (ChessScene* self);
static gboolean _chess_scene_animate_cb_gsource_func (gpointer self);
gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file);
void chess_game_remove_hold (ChessGame* self);
void chess_scene_set_game (ChessScene* self, ChessGame* value);
static void _chess_scene_moved_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self);
static void _chess_scene_paused_cb_chess_game_superpaused (ChessGame* _sender, gpointer self);
static void _chess_scene_unpaused_cb_chess_game_unpaused (ChessGame* _sender, gpointer self);
static void _chess_scene_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self);
void chess_scene_set_move_number (ChessScene* self, gint value);
gboolean chess_scene_get_show_numbering (ChessScene* self);
void chess_scene_set_show_numbering (ChessScene* self, gboolean value);
gboolean chess_scene_get_show_move_hints (ChessScene* self);
void chess_scene_set_show_move_hints (ChessScene* self, gboolean value);
const gchar* chess_scene_get_theme_name (ChessScene* self);
void chess_scene_set_theme_name (ChessScene* self, const gchar* value);
gboolean chess_scene_get_show_3d_smooth (ChessScene* self);
void chess_scene_set_show_3d_smooth (ChessScene* self, gboolean value);
const gchar* chess_scene_get_board_side (ChessScene* self);
void chess_scene_set_board_side (ChessScene* self, const gchar* value);
gdouble chess_scene_get_board_angle (ChessScene* self);
ChessPlayer* chess_game_get_black (ChessGame* self);
GType color_get_type (void) G_GNUC_CONST;
const gchar* chess_scene_get_move_format (ChessScene* self);
void chess_scene_set_move_format (ChessScene* self, const gchar* value);
static void g_cclosure_user_marshal_BOOLEAN__OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_ENUM__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void chess_scene_finalize (GObject* obj);
static void _vala_chess_scene_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_scene_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _chess_piece_ref0 (gpointer self) {
	return self ? chess_piece_ref (self) : NULL;
}


ChessModel* chess_model_construct (GType object_type, ChessPiece* piece, gdouble x, gdouble y) {
	ChessModel* self = NULL;
	ChessPiece* _tmp0_ = NULL;
	ChessPiece* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	g_return_val_if_fail (piece != NULL, NULL);
	self = (ChessModel*) g_type_create_instance (object_type);
	_tmp0_ = piece;
	_tmp1_ = _chess_piece_ref0 (_tmp0_);
	_chess_piece_unref0 (self->piece);
	self->piece = _tmp1_;
	_tmp2_ = x;
	self->target_x = _tmp2_;
	_tmp3_ = self->target_x;
	self->x = _tmp3_;
	_tmp4_ = y;
	self->target_y = _tmp4_;
	_tmp5_ = self->target_y;
	self->y = _tmp5_;
	return self;
}


ChessModel* chess_model_new (ChessPiece* piece, gdouble x, gdouble y) {
	return chess_model_construct (TYPE_CHESS_MODEL, piece, x, y);
}


gboolean chess_model_move_to (ChessModel* self, gdouble x, gdouble y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp5_ = FALSE;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->target_x;
	_tmp2_ = x;
	if (_tmp1_ == _tmp2_) {
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		_tmp3_ = self->target_y;
		_tmp4_ = y;
		_tmp0_ = _tmp3_ == _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = x;
	self->target_x = _tmp6_;
	_tmp7_ = y;
	self->target_y = _tmp7_;
	result = TRUE;
	return result;
}


gboolean chess_model_animate (ChessModel* self, gdouble timestep) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = chess_model_get_moving (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = timestep;
	_tmp3_ = self->x;
	_tmp4_ = self->target_x;
	_tmp5_ = chess_model_update_position (self, _tmp2_, _tmp3_, _tmp4_);
	self->x = _tmp5_;
	_tmp6_ = timestep;
	_tmp7_ = self->y;
	_tmp8_ = self->target_y;
	_tmp9_ = chess_model_update_position (self, _tmp6_, _tmp7_, _tmp8_);
	self->y = _tmp9_;
	result = TRUE;
	return result;
}


static gdouble chess_model_update_position (ChessModel* self, gdouble timestep, gdouble value, gdouble target) {
	gdouble result = 0.0;
	gdouble distance = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble step = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = target;
	_tmp1_ = value;
	_tmp2_ = fabs (_tmp0_ - _tmp1_);
	distance = _tmp2_;
	_tmp3_ = timestep;
	step = _tmp3_ * 4.0;
	_tmp4_ = step;
	_tmp5_ = distance;
	if (_tmp4_ > _tmp5_) {
		gdouble _tmp6_ = 0.0;
		_tmp6_ = distance;
		step = _tmp6_;
	}
	_tmp7_ = target;
	_tmp8_ = value;
	if (_tmp7_ > _tmp8_) {
		gdouble _tmp9_ = 0.0;
		gdouble _tmp10_ = 0.0;
		_tmp9_ = value;
		_tmp10_ = step;
		result = _tmp9_ + _tmp10_;
		return result;
	} else {
		gdouble _tmp11_ = 0.0;
		gdouble _tmp12_ = 0.0;
		_tmp11_ = value;
		_tmp12_ = step;
		result = _tmp11_ - _tmp12_;
		return result;
	}
}


gboolean chess_model_get_moving (ChessModel* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->x;
	_tmp2_ = self->target_x;
	if (_tmp1_ != _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		_tmp3_ = self->y;
		_tmp4_ = self->target_y;
		_tmp0_ = _tmp3_ != _tmp4_;
	}
	_tmp5_ = _tmp0_;
	result = _tmp5_;
	return result;
}


static void value_chess_model_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_chess_model_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		chess_model_unref (value->data[0].v_pointer);
	}
}


static void value_chess_model_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = chess_model_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_chess_model_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_chess_model_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ChessModel* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = chess_model_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_chess_model_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ChessModel** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = chess_model_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_chess_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecChessModel* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHESS_MODEL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_chess_model (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MODEL), NULL);
	return value->data[0].v_pointer;
}


void value_set_chess_model (GValue* value, gpointer v_object) {
	ChessModel* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MODEL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_MODEL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		chess_model_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_model_unref (old);
	}
}


void value_take_chess_model (GValue* value, gpointer v_object) {
	ChessModel* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MODEL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_MODEL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_model_unref (old);
	}
}


static void chess_model_class_init (ChessModelClass * klass) {
	chess_model_parent_class = g_type_class_peek_parent (klass);
	CHESS_MODEL_CLASS (klass)->finalize = chess_model_finalize;
}


static void chess_model_instance_init (ChessModel * self) {
	self->ref_count = 1;
}


static void chess_model_finalize (ChessModel* obj) {
	ChessModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_MODEL, ChessModel);
	_chess_piece_unref0 (self->piece);
}


GType chess_model_get_type (void) {
	static volatile gsize chess_model_type_id__volatile = 0;
	if (g_once_init_enter (&chess_model_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_chess_model_init, value_chess_model_free_value, value_chess_model_copy_value, value_chess_model_peek_pointer, "p", value_chess_model_collect_value, "p", value_chess_model_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ChessModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessModel), 0, (GInstanceInitFunc) chess_model_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType chess_model_type_id;
		chess_model_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ChessModel", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&chess_model_type_id__volatile, chess_model_type_id);
	}
	return chess_model_type_id__volatile;
}


gpointer chess_model_ref (gpointer instance) {
	ChessModel* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void chess_model_unref (gpointer instance) {
	ChessModel* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CHESS_MODEL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _chess_model_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (chess_model_unref (var), NULL));
}


static void _g_list_free__chess_model_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _chess_model_unref0_, NULL);
	g_list_free (self);
}


ChessPiece* chess_scene_get_selected_piece (ChessScene* self) {
	ChessPiece* result = NULL;
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
	ChessGame* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
	ChessGame* _tmp5_ = NULL;
	ChessGame* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	ChessPiece* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = chess_scene_get_game (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp3_ = 0;
		_tmp3_ = self->selected_rank;
		_tmp0_ = _tmp3_ < 0;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		result = NULL;
		return result;
	}
	_tmp5_ = chess_scene_get_game (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->selected_rank;
	_tmp8_ = self->selected_file;
	_tmp9_ = chess_scene_get_move_number (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = chess_game_get_piece (_tmp6_, _tmp7_, _tmp8_, _tmp10_);
	result = _tmp11_;
	return result;
}


ChessScene* chess_scene_construct (GType object_type) {
	ChessScene * self = NULL;
	GTimer* _tmp0_ = NULL;
	self = (ChessScene*) g_object_new (object_type, NULL);
	_tmp0_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->animation_timer);
	self->priv->animation_timer = _tmp0_;
	return self;
}


ChessScene* chess_scene_new (void) {
	return chess_scene_construct (TYPE_CHESS_SCENE);
}


void chess_scene_select_square (ChessScene* self, gint file, gint rank) {
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
	ChessGame* _tmp2_ = NULL;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	ChessPiece* piece = NULL;
	ChessGame* _tmp12_ = NULL;
	ChessGame* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	ChessPiece* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gboolean _tmp24_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = chess_scene_get_game (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ChessGame* _tmp3_ = NULL;
		ChessGame* _tmp4_ = NULL;
		ChessPlayer* _tmp5_ = NULL;
		ChessPlayer* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_tmp3_ = chess_scene_get_game (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = chess_game_get_current_player (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = chess_player_get_local_human (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = !_tmp8_;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		return;
	}
	_tmp10_ = chess_scene_get_move_number (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != (-1)) {
		return;
	}
	_tmp12_ = chess_scene_get_game (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = rank;
	_tmp15_ = file;
	_tmp16_ = chess_scene_get_move_number (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = chess_game_get_piece (_tmp13_, _tmp14_, _tmp15_, _tmp17_);
	piece = _tmp18_;
	_tmp20_ = file;
	_tmp21_ = self->selected_file;
	if (_tmp20_ == _tmp21_) {
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp22_ = rank;
		_tmp23_ = self->selected_rank;
		_tmp19_ = _tmp22_ == _tmp23_;
	} else {
		_tmp19_ = FALSE;
	}
	_tmp24_ = _tmp19_;
	if (_tmp24_) {
		gint _tmp25_ = 0;
		self->selected_file = -1;
		_tmp25_ = self->selected_file;
		self->selected_rank = _tmp25_;
	} else {
		gboolean _tmp26_ = FALSE;
		ChessPiece* _tmp27_ = NULL;
		gboolean _tmp34_ = FALSE;
		_tmp27_ = piece;
		if (_tmp27_ != NULL) {
			ChessPiece* _tmp28_ = NULL;
			ChessPlayer* _tmp29_ = NULL;
			ChessGame* _tmp30_ = NULL;
			ChessGame* _tmp31_ = NULL;
			ChessPlayer* _tmp32_ = NULL;
			ChessPlayer* _tmp33_ = NULL;
			_tmp28_ = piece;
			_tmp29_ = _tmp28_->player;
			_tmp30_ = chess_scene_get_game (self);
			_tmp31_ = _tmp30_;
			_tmp32_ = chess_game_get_current_player (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp26_ = _tmp29_ == _tmp33_;
		} else {
			_tmp26_ = FALSE;
		}
		_tmp34_ = _tmp26_;
		if (_tmp34_) {
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			_tmp35_ = rank;
			self->selected_rank = _tmp35_;
			_tmp36_ = file;
			self->selected_file = _tmp36_;
		} else {
			gint _tmp37_ = 0;
			_tmp37_ = self->selected_file;
			if (_tmp37_ != (-1)) {
				gboolean can_move = FALSE;
				ChessGame* _tmp38_ = NULL;
				ChessGame* _tmp39_ = NULL;
				ChessPlayer* _tmp40_ = NULL;
				ChessPlayer* _tmp41_ = NULL;
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
				gboolean _tmp46_ = FALSE;
				gboolean _tmp47_ = FALSE;
				gboolean _tmp48_ = FALSE;
				gboolean _tmp49_ = FALSE;
				gboolean _tmp53_ = FALSE;
				gboolean _tmp58_ = FALSE;
				ChessGame* _tmp70_ = NULL;
				ChessGame* _tmp71_ = NULL;
				ChessPlayer* _tmp72_ = NULL;
				ChessPlayer* _tmp73_ = NULL;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				gboolean _tmp78_ = FALSE;
				_tmp38_ = chess_scene_get_game (self);
				_tmp39_ = _tmp38_;
				_tmp40_ = chess_game_get_current_player (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = self->selected_rank;
				_tmp43_ = self->selected_file;
				_tmp44_ = rank;
				_tmp45_ = file;
				_tmp46_ = chess_player_move_with_coords (_tmp41_, _tmp42_, _tmp43_, _tmp44_, _tmp45_, FALSE, PIECE_TYPE_QUEEN);
				can_move = _tmp46_;
				_tmp49_ = can_move;
				if (_tmp49_) {
					ChessPiece* _tmp50_ = NULL;
					ChessPiece* _tmp51_ = NULL;
					PieceType _tmp52_ = 0;
					_tmp50_ = chess_scene_get_selected_piece (self);
					_tmp51_ = _tmp50_;
					_tmp52_ = _tmp51_->type;
					_tmp48_ = _tmp52_ == PIECE_TYPE_PAWN;
					_chess_piece_unref0 (_tmp51_);
				} else {
					_tmp48_ = FALSE;
				}
				_tmp53_ = _tmp48_;
				if (_tmp53_) {
					gboolean _tmp54_ = FALSE;
					gint _tmp55_ = 0;
					gboolean _tmp57_ = FALSE;
					_tmp55_ = rank;
					if (_tmp55_ == 0) {
						_tmp54_ = TRUE;
					} else {
						gint _tmp56_ = 0;
						_tmp56_ = rank;
						_tmp54_ = _tmp56_ == 7;
					}
					_tmp57_ = _tmp54_;
					_tmp47_ = _tmp57_;
				} else {
					_tmp47_ = FALSE;
				}
				_tmp58_ = _tmp47_;
				if (_tmp58_) {
					PieceType promotion_selection = 0;
					PieceType _tmp59_ = 0;
					ChessGame* _tmp60_ = NULL;
					ChessGame* _tmp61_ = NULL;
					ChessPlayer* _tmp62_ = NULL;
					ChessPlayer* _tmp63_ = NULL;
					gint _tmp64_ = 0;
					gint _tmp65_ = 0;
					gint _tmp66_ = 0;
					gint _tmp67_ = 0;
					PieceType _tmp68_ = 0;
					gint _tmp69_ = 0;
					g_signal_emit_by_name (self, "choose-promotion-type", &_tmp59_);
					promotion_selection = _tmp59_;
					_tmp60_ = chess_scene_get_game (self);
					_tmp61_ = _tmp60_;
					_tmp62_ = chess_game_get_current_player (_tmp61_);
					_tmp63_ = _tmp62_;
					_tmp64_ = self->selected_rank;
					_tmp65_ = self->selected_file;
					_tmp66_ = rank;
					_tmp67_ = file;
					_tmp68_ = promotion_selection;
					chess_player_move_with_coords (_tmp63_, _tmp64_, _tmp65_, _tmp66_, _tmp67_, TRUE, _tmp68_);
					self->selected_file = -1;
					_tmp69_ = self->selected_file;
					self->selected_rank = _tmp69_;
				}
				_tmp70_ = chess_scene_get_game (self);
				_tmp71_ = _tmp70_;
				_tmp72_ = chess_game_get_current_player (_tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = self->selected_rank;
				_tmp75_ = self->selected_file;
				_tmp76_ = rank;
				_tmp77_ = file;
				_tmp78_ = chess_player_move_with_coords (_tmp73_, _tmp74_, _tmp75_, _tmp76_, _tmp77_, TRUE, PIECE_TYPE_QUEEN);
				if (_tmp78_) {
					gint _tmp79_ = 0;
					self->selected_file = -1;
					_tmp79_ = self->selected_file;
					self->selected_rank = _tmp79_;
				}
			}
		}
	}
	chess_scene_update_board (self);
	g_signal_emit_by_name (self, "changed");
	_chess_piece_unref0 (piece);
}


static void chess_scene_moved_cb (ChessScene* self, ChessGame* game, ChessMove* move) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (move != NULL);
	chess_scene_update_board (self);
}


static void chess_scene_paused_cb (ChessScene* self, ChessGame* game) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_signal_emit_by_name (self, "changed");
}


static void chess_scene_unpaused_cb (ChessScene* self, ChessGame* game) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_signal_emit_by_name (self, "changed");
}


static void chess_scene_undo_cb (ChessScene* self, ChessGame* game) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	chess_scene_update_board (self);
}


static gpointer _chess_model_ref0 (gpointer self) {
	return self ? chess_model_ref (self) : NULL;
}


static ChessModel* chess_scene_find_model (ChessScene* self, ChessPiece* piece) {
	ChessModel* result = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (piece != NULL, NULL);
	_tmp0_ = self->pieces;
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
		model_collection = _tmp0_;
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
			ChessModel* _tmp1_ = NULL;
			ChessModel* model = NULL;
			_tmp1_ = _chess_model_ref0 ((ChessModel*) model_it->data);
			model = _tmp1_;
			{
				ChessModel* _tmp2_ = NULL;
				ChessPiece* _tmp3_ = NULL;
				ChessPiece* _tmp4_ = NULL;
				_tmp2_ = model;
				_tmp3_ = _tmp2_->piece;
				_tmp4_ = piece;
				if (_tmp3_ == _tmp4_) {
					result = model;
					return result;
				}
				_chess_model_unref0 (model);
			}
		}
	}
	result = NULL;
	return result;
}


static gboolean _chess_scene_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_scene_animate_cb (self);
	return result;
}


static void chess_scene_update_board (ChessScene* self) {
	ChessGame* _tmp0_ = NULL;
	ChessGame* _tmp1_ = NULL;
	gboolean board_changed = FALSE;
	gboolean need_animation = FALSE;
	GList* new_pieces = NULL;
	GList* _tmp65_ = NULL;
	guint _tmp66_ = 0U;
	GList* _tmp67_ = NULL;
	guint _tmp68_ = 0U;
	gboolean _tmp69_ = FALSE;
	GList* _tmp70_ = NULL;
	gboolean _tmp74_ = FALSE;
	gboolean _tmp75_ = FALSE;
	gboolean _tmp77_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_scene_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	board_changed = FALSE;
	need_animation = FALSE;
	new_pieces = NULL;
	{
		gint rank = 0;
		rank = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gint _tmp5_ = 0;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = rank;
					rank = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = rank;
				if (!(_tmp5_ < 8)) {
					break;
				}
				{
					gint file = 0;
					file = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gboolean _tmp7_ = FALSE;
							gint _tmp9_ = 0;
							gboolean can_move = FALSE;
							gboolean _tmp10_ = FALSE;
							gboolean _tmp11_ = FALSE;
							gint _tmp12_ = 0;
							gboolean _tmp15_ = FALSE;
							gboolean _tmp25_ = FALSE;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							gboolean _tmp28_ = FALSE;
							gboolean _tmp29_ = FALSE;
							ChessPiece* piece = NULL;
							ChessGame* _tmp30_ = NULL;
							ChessGame* _tmp31_ = NULL;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							gint _tmp35_ = 0;
							ChessPiece* _tmp36_ = NULL;
							ChessPiece* _tmp37_ = NULL;
							ChessModel* model = NULL;
							ChessPiece* _tmp38_ = NULL;
							ChessModel* _tmp39_ = NULL;
							ChessModel* _tmp40_ = NULL;
							ChessModel* _tmp45_ = NULL;
							gboolean _tmp46_ = FALSE;
							ChessModel* _tmp47_ = NULL;
							gint _tmp48_ = 0;
							gint _tmp49_ = 0;
							gboolean _tmp50_ = FALSE;
							gboolean _tmp51_ = FALSE;
							gboolean _tmp52_ = FALSE;
							gint _tmp53_ = 0;
							gint _tmp54_ = 0;
							gboolean _tmp57_ = FALSE;
							gboolean _tmp60_ = FALSE;
							ChessModel* _tmp63_ = NULL;
							ChessModel* _tmp64_ = NULL;
							_tmp7_ = _tmp6_;
							if (!_tmp7_) {
								gint _tmp8_ = 0;
								_tmp8_ = file;
								file = _tmp8_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp9_ = file;
							if (!(_tmp9_ < 8)) {
								break;
							}
							can_move = FALSE;
							_tmp12_ = self->selected_rank;
							if (_tmp12_ >= 0) {
								gint _tmp13_ = 0;
								gint _tmp14_ = 0;
								_tmp13_ = chess_scene_get_move_number (self);
								_tmp14_ = _tmp13_;
								_tmp11_ = _tmp14_ == (-1);
							} else {
								_tmp11_ = FALSE;
							}
							_tmp15_ = _tmp11_;
							if (_tmp15_) {
								ChessGame* _tmp16_ = NULL;
								ChessGame* _tmp17_ = NULL;
								ChessPlayer* _tmp18_ = NULL;
								ChessPlayer* _tmp19_ = NULL;
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								gboolean _tmp24_ = FALSE;
								_tmp16_ = chess_scene_get_game (self);
								_tmp17_ = _tmp16_;
								_tmp18_ = chess_game_get_current_player (_tmp17_);
								_tmp19_ = _tmp18_;
								_tmp20_ = self->selected_rank;
								_tmp21_ = self->selected_file;
								_tmp22_ = rank;
								_tmp23_ = file;
								_tmp24_ = chess_player_move_with_coords (_tmp19_, _tmp20_, _tmp21_, _tmp22_, _tmp23_, FALSE, PIECE_TYPE_QUEEN);
								_tmp10_ = _tmp24_;
							} else {
								_tmp10_ = FALSE;
							}
							_tmp25_ = _tmp10_;
							if (_tmp25_) {
								can_move = TRUE;
							}
							_tmp26_ = rank;
							_tmp27_ = file;
							_tmp28_ = can_move;
							self->priv->_can_move[(_tmp26_ * 8) + _tmp27_] = _tmp28_;
							_tmp29_ = self->priv->_can_move[(_tmp26_ * 8) + _tmp27_];
							_tmp30_ = chess_scene_get_game (self);
							_tmp31_ = _tmp30_;
							_tmp32_ = rank;
							_tmp33_ = file;
							_tmp34_ = chess_scene_get_move_number (self);
							_tmp35_ = _tmp34_;
							_tmp36_ = chess_game_get_piece (_tmp31_, _tmp32_, _tmp33_, _tmp35_);
							piece = _tmp36_;
							_tmp37_ = piece;
							if (_tmp37_ == NULL) {
								_chess_piece_unref0 (piece);
								continue;
							}
							_tmp38_ = piece;
							_tmp39_ = chess_scene_find_model (self, _tmp38_);
							model = _tmp39_;
							_tmp40_ = model;
							if (_tmp40_ == NULL) {
								ChessPiece* _tmp41_ = NULL;
								gint _tmp42_ = 0;
								gint _tmp43_ = 0;
								ChessModel* _tmp44_ = NULL;
								_tmp41_ = piece;
								_tmp42_ = file;
								_tmp43_ = rank;
								_tmp44_ = chess_model_new (_tmp41_, (gdouble) _tmp42_, (gdouble) _tmp43_);
								_chess_model_unref0 (model);
								model = _tmp44_;
								board_changed = TRUE;
							}
							_tmp45_ = model;
							_tmp46_ = can_move;
							_tmp45_->under_threat = _tmp46_;
							_tmp47_ = model;
							_tmp48_ = file;
							_tmp49_ = rank;
							_tmp50_ = chess_model_move_to (_tmp47_, (gdouble) _tmp48_, (gdouble) _tmp49_);
							if (_tmp50_) {
								board_changed = TRUE;
								need_animation = TRUE;
							}
							_tmp53_ = chess_scene_get_move_number (self);
							_tmp54_ = _tmp53_;
							if (_tmp54_ == (-1)) {
								gint _tmp55_ = 0;
								gint _tmp56_ = 0;
								_tmp55_ = rank;
								_tmp56_ = self->selected_rank;
								_tmp52_ = _tmp55_ == _tmp56_;
							} else {
								_tmp52_ = FALSE;
							}
							_tmp57_ = _tmp52_;
							if (_tmp57_) {
								gint _tmp58_ = 0;
								gint _tmp59_ = 0;
								_tmp58_ = file;
								_tmp59_ = self->selected_file;
								_tmp51_ = _tmp58_ == _tmp59_;
							} else {
								_tmp51_ = FALSE;
							}
							_tmp60_ = _tmp51_;
							if (_tmp60_) {
								ChessModel* _tmp61_ = NULL;
								_tmp61_ = model;
								_tmp61_->is_selected = TRUE;
							} else {
								ChessModel* _tmp62_ = NULL;
								_tmp62_ = model;
								_tmp62_->is_selected = FALSE;
							}
							_tmp63_ = model;
							_tmp64_ = _chess_model_ref0 (_tmp63_);
							new_pieces = g_list_append (new_pieces, _tmp64_);
							_chess_model_unref0 (model);
							_chess_piece_unref0 (piece);
						}
					}
				}
			}
		}
	}
	_tmp65_ = new_pieces;
	_tmp66_ = g_list_length (_tmp65_);
	_tmp67_ = self->pieces;
	_tmp68_ = g_list_length (_tmp67_);
	if (_tmp66_ != _tmp68_) {
		board_changed = TRUE;
	}
	_tmp69_ = board_changed;
	if (!_tmp69_) {
		__g_list_free__chess_model_unref0_0 (new_pieces);
		return;
	}
	__g_list_free__chess_model_unref0_0 (self->pieces);
	self->pieces = NULL;
	_tmp70_ = new_pieces;
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
		model_collection = _tmp70_;
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
			ChessModel* _tmp71_ = NULL;
			ChessModel* model = NULL;
			_tmp71_ = _chess_model_ref0 ((ChessModel*) model_it->data);
			model = _tmp71_;
			{
				ChessModel* _tmp72_ = NULL;
				ChessModel* _tmp73_ = NULL;
				_tmp72_ = model;
				_tmp73_ = _chess_model_ref0 (_tmp72_);
				self->pieces = g_list_append (self->pieces, _tmp73_);
				_chess_model_unref0 (model);
			}
		}
	}
	g_signal_emit_by_name (self, "changed");
	_tmp75_ = need_animation;
	if (_tmp75_) {
		gboolean _tmp76_ = FALSE;
		_tmp76_ = self->animating;
		_tmp74_ = !_tmp76_;
	} else {
		_tmp74_ = FALSE;
	}
	_tmp77_ = _tmp74_;
	if (_tmp77_) {
		GTimer* _tmp78_ = NULL;
		ChessGame* _tmp79_ = NULL;
		ChessGame* _tmp80_ = NULL;
		self->animating = TRUE;
		_tmp78_ = self->priv->animation_timer;
		g_timer_start (_tmp78_);
		self->priv->animation_time = (gdouble) 0;
		_tmp79_ = chess_scene_get_game (self);
		_tmp80_ = _tmp79_;
		chess_game_add_hold (_tmp80_);
		g_timeout_add_full (G_PRIORITY_DEFAULT_IDLE, (guint) 10, _chess_scene_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
	}
	__g_list_free__chess_model_unref0_0 (new_pieces);
}


gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rank;
	_tmp1_ = file;
	_tmp2_ = self->priv->_can_move[(_tmp0_ * 8) + _tmp1_];
	result = _tmp2_;
	return result;
}


static gboolean chess_scene_animate_cb (ChessScene* self) {
	gboolean result = FALSE;
	gdouble old_time = 0.0;
	gdouble _tmp0_ = 0.0;
	GTimer* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble timestep = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gint animate_count = 0;
	GList* _tmp5_ = NULL;
	gint _tmp11_ = 0;
	gboolean _tmp12_ = FALSE;
	ChessGame* _tmp13_ = NULL;
	ChessGame* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->animation_time;
	old_time = _tmp0_;
	_tmp1_ = self->priv->animation_timer;
	_tmp2_ = g_timer_elapsed (_tmp1_, NULL);
	self->priv->animation_time = _tmp2_;
	_tmp3_ = self->priv->animation_time;
	_tmp4_ = old_time;
	timestep = _tmp3_ - _tmp4_;
	animate_count = 0;
	_tmp5_ = self->pieces;
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
		model_collection = _tmp5_;
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
			ChessModel* _tmp6_ = NULL;
			ChessModel* model = NULL;
			_tmp6_ = _chess_model_ref0 ((ChessModel*) model_it->data);
			model = _tmp6_;
			{
				ChessModel* _tmp7_ = NULL;
				gdouble _tmp8_ = 0.0;
				gboolean _tmp9_ = FALSE;
				_tmp7_ = model;
				_tmp8_ = timestep;
				_tmp9_ = chess_model_animate (_tmp7_, _tmp8_);
				if (_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = animate_count;
					animate_count = _tmp10_ + 1;
				}
				_chess_model_unref0 (model);
			}
		}
	}
	_tmp11_ = animate_count;
	self->animating = _tmp11_ > 0;
	g_signal_emit_by_name (self, "changed");
	_tmp12_ = self->animating;
	if (_tmp12_) {
		result = TRUE;
		return result;
	}
	self->animating = FALSE;
	_tmp13_ = chess_scene_get_game (self);
	_tmp14_ = _tmp13_;
	chess_game_remove_hold (_tmp14_);
	result = FALSE;
	return result;
}


ChessGame* chess_scene_get_game (ChessScene* self) {
	ChessGame* result;
	ChessGame* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}


static gpointer _chess_game_ref0 (gpointer self) {
	return self ? chess_game_ref (self) : NULL;
}


static void _chess_scene_moved_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self) {
	chess_scene_moved_cb (self, _sender, move);
}


static void _chess_scene_paused_cb_chess_game_superpaused (ChessGame* _sender, gpointer self) {
	chess_scene_paused_cb (self, _sender);
}


static void _chess_scene_unpaused_cb_chess_game_unpaused (ChessGame* _sender, gpointer self) {
	chess_scene_unpaused_cb (self, _sender);
}


static void _chess_scene_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self) {
	chess_scene_undo_cb (self, _sender);
}


void chess_scene_set_game (ChessScene* self, ChessGame* value) {
	ChessGame* _tmp0_ = NULL;
	ChessGame* _tmp1_ = NULL;
	ChessGame* _tmp2_ = NULL;
	ChessGame* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessGame* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _chess_game_ref0 (_tmp0_);
	_chess_game_unref0 (self->priv->_game);
	self->priv->_game = _tmp1_;
	self->priv->_move_number = -1;
	self->selected_rank = -1;
	self->selected_file = -1;
	_tmp2_ = self->priv->_game;
	g_signal_connect_object (_tmp2_, "moved", (GCallback) _chess_scene_moved_cb_chess_game_moved, self, 0);
	_tmp3_ = self->priv->_game;
	g_signal_connect_object (_tmp3_, "superpaused", (GCallback) _chess_scene_paused_cb_chess_game_superpaused, self, 0);
	_tmp4_ = self->priv->_game;
	g_signal_connect_object (_tmp4_, "unpaused", (GCallback) _chess_scene_unpaused_cb_chess_game_unpaused, self, 0);
	_tmp5_ = self->priv->_game;
	g_signal_connect_object (_tmp5_, "undo", (GCallback) _chess_scene_undo_cb_chess_game_undo, self, 0);
	chess_scene_update_board (self);
	g_object_notify ((GObject *) self, "game");
}


gint chess_scene_get_move_number (ChessScene* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_move_number;
	result = _tmp0_;
	return result;
}


void chess_scene_set_move_number (ChessScene* self, gint value) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_move_number;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->_move_number = _tmp2_;
	chess_scene_update_board (self);
	g_object_notify ((GObject *) self, "move-number");
}


gboolean chess_scene_get_show_numbering (ChessScene* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_numbering;
	result = _tmp0_;
	return result;
}


void chess_scene_set_show_numbering (ChessScene* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_numbering = _tmp0_;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "show-numbering");
}


gboolean chess_scene_get_show_move_hints (ChessScene* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_move_hints;
	result = _tmp0_;
	return result;
}


void chess_scene_set_show_move_hints (ChessScene* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_move_hints = _tmp0_;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "show-move-hints");
}


const gchar* chess_scene_get_theme_name (ChessScene* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme_name;
	result = _tmp0_;
	return result;
}


void chess_scene_set_theme_name (ChessScene* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_theme_name);
	self->priv->_theme_name = _tmp1_;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "theme-name");
}


gboolean chess_scene_get_show_3d_smooth (ChessScene* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_3d_smooth;
	result = _tmp0_;
	return result;
}


void chess_scene_set_show_3d_smooth (ChessScene* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_3d_smooth = _tmp0_;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "show-3d-smooth");
}


const gchar* chess_scene_get_board_side (ChessScene* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_board_side;
	result = _tmp0_;
	return result;
}


void chess_scene_set_board_side (ChessScene* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_board_side);
	self->priv->_board_side = _tmp1_;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "board-side");
}


gdouble chess_scene_get_board_angle (ChessScene* self) {
	gdouble result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = chess_scene_get_board_side (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("black")))) {
		switch (0) {
			default:
			{
				result = 180.0;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("human")))) {
		switch (0) {
			default:
			{
				ChessGame* _tmp5_ = NULL;
				ChessGame* _tmp6_ = NULL;
				ChessPlayer* _tmp7_ = NULL;
				ChessPlayer* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
				_tmp5_ = chess_scene_get_game (self);
				_tmp6_ = _tmp5_;
				_tmp7_ = chess_game_get_black (_tmp6_);
				_tmp8_ = _tmp7_;
				g_signal_emit_by_name (self, "is-human", _tmp8_, &_tmp9_);
				if (_tmp9_) {
					result = 180.0;
					return result;
				} else {
					result = 0.0;
					return result;
				}
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("current")))) {
		switch (0) {
			default:
			{
				gdouble _tmp10_ = 0.0;
				ChessGame* _tmp11_ = NULL;
				ChessGame* _tmp12_ = NULL;
				ChessPlayer* _tmp13_ = NULL;
				ChessPlayer* _tmp14_ = NULL;
				Color _tmp15_ = 0;
				gdouble _tmp16_ = 0.0;
				_tmp11_ = chess_scene_get_game (self);
				_tmp12_ = _tmp11_;
				_tmp13_ = chess_game_get_current_player (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = _tmp14_->color;
				if (_tmp15_ == COLOR_WHITE) {
					_tmp10_ = 0.0;
				} else {
					_tmp10_ = 180.0;
				}
				_tmp16_ = _tmp10_;
				result = _tmp16_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = 0.0;
				return result;
			}
		}
	}
}


const gchar* chess_scene_get_move_format (ChessScene* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_move_format;
	result = _tmp0_;
	return result;
}


void chess_scene_set_move_format (ChessScene* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_move_format);
	self->priv->_move_format = _tmp1_;
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "move-format");
}


static void g_cclosure_user_marshal_BOOLEAN__OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__OBJECT) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__OBJECT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_object (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_ENUM__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gint (*GMarshalFunc_ENUM__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_ENUM__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gint v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_ENUM__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_enum (return_value, v_return);
}


static void chess_scene_class_init (ChessSceneClass * klass) {
	chess_scene_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessScenePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_scene_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_scene_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_scene_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_GAME, param_spec_chess_game ("game", "game", "game", TYPE_CHESS_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_MOVE_NUMBER, g_param_spec_int ("move-number", "move-number", "move-number", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_SHOW_NUMBERING, g_param_spec_boolean ("show-numbering", "show-numbering", "show-numbering", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_SHOW_MOVE_HINTS, g_param_spec_boolean ("show-move-hints", "show-move-hints", "show-move-hints", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_THEME_NAME, g_param_spec_string ("theme-name", "theme-name", "theme-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_SHOW_3D_SMOOTH, g_param_spec_boolean ("show-3d-smooth", "show-3d-smooth", "show-3d-smooth", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_BOARD_SIDE, g_param_spec_string ("board-side", "board-side", "board-side", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_BOARD_ANGLE, g_param_spec_double ("board-angle", "board-angle", "board-angle", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_MOVE_FORMAT, g_param_spec_string ("move-format", "move-format", "move-format", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("is_human", TYPE_CHESS_SCENE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__OBJECT, G_TYPE_BOOLEAN, 1, TYPE_CHESS_PLAYER);
	g_signal_new ("choose_promotion_type", TYPE_CHESS_SCENE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_ENUM__VOID, TYPE_PIECE_TYPE, 0);
	g_signal_new ("changed", TYPE_CHESS_SCENE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_scene_instance_init (ChessScene * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self->priv = CHESS_SCENE_GET_PRIVATE (self);
	self->pieces = NULL;
	self->animating = FALSE;
	self->selected_rank = -1;
	self->selected_file = -1;
	self->priv->_game = NULL;
	self->priv->_move_number = -1;
	self->priv->_show_numbering = TRUE;
	self->priv->_show_move_hints = TRUE;
	_tmp0_ = g_strdup ("simple");
	self->priv->_theme_name = _tmp0_;
	self->priv->_show_3d_smooth = FALSE;
	_tmp1_ = g_strdup ("human");
	self->priv->_board_side = _tmp1_;
	_tmp2_ = g_strdup ("human");
	self->priv->_move_format = _tmp2_;
}


static void chess_scene_finalize (GObject* obj) {
	ChessScene * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_SCENE, ChessScene);
	__g_list_free__chess_model_unref0_0 (self->pieces);
	_g_timer_destroy0 (self->priv->animation_timer);
	_chess_game_unref0 (self->priv->_game);
	_g_free0 (self->priv->_theme_name);
	_g_free0 (self->priv->_board_side);
	_g_free0 (self->priv->_move_format);
	G_OBJECT_CLASS (chess_scene_parent_class)->finalize (obj);
}


GType chess_scene_get_type (void) {
	static volatile gsize chess_scene_type_id__volatile = 0;
	if (g_once_init_enter (&chess_scene_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessSceneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_scene_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessScene), 0, (GInstanceInitFunc) chess_scene_instance_init, NULL };
		GType chess_scene_type_id;
		chess_scene_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessScene", &g_define_type_info, 0);
		g_once_init_leave (&chess_scene_type_id__volatile, chess_scene_type_id);
	}
	return chess_scene_type_id__volatile;
}


static void _vala_chess_scene_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessScene * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_SCENE, ChessScene);
	switch (property_id) {
		case CHESS_SCENE_GAME:
		value_set_chess_game (value, chess_scene_get_game (self));
		break;
		case CHESS_SCENE_MOVE_NUMBER:
		g_value_set_int (value, chess_scene_get_move_number (self));
		break;
		case CHESS_SCENE_SHOW_NUMBERING:
		g_value_set_boolean (value, chess_scene_get_show_numbering (self));
		break;
		case CHESS_SCENE_SHOW_MOVE_HINTS:
		g_value_set_boolean (value, chess_scene_get_show_move_hints (self));
		break;
		case CHESS_SCENE_THEME_NAME:
		g_value_set_string (value, chess_scene_get_theme_name (self));
		break;
		case CHESS_SCENE_SHOW_3D_SMOOTH:
		g_value_set_boolean (value, chess_scene_get_show_3d_smooth (self));
		break;
		case CHESS_SCENE_BOARD_SIDE:
		g_value_set_string (value, chess_scene_get_board_side (self));
		break;
		case CHESS_SCENE_BOARD_ANGLE:
		g_value_set_double (value, chess_scene_get_board_angle (self));
		break;
		case CHESS_SCENE_MOVE_FORMAT:
		g_value_set_string (value, chess_scene_get_move_format (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_chess_scene_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessScene * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_SCENE, ChessScene);
	switch (property_id) {
		case CHESS_SCENE_GAME:
		chess_scene_set_game (self, value_get_chess_game (value));
		break;
		case CHESS_SCENE_MOVE_NUMBER:
		chess_scene_set_move_number (self, g_value_get_int (value));
		break;
		case CHESS_SCENE_SHOW_NUMBERING:
		chess_scene_set_show_numbering (self, g_value_get_boolean (value));
		break;
		case CHESS_SCENE_SHOW_MOVE_HINTS:
		chess_scene_set_show_move_hints (self, g_value_get_boolean (value));
		break;
		case CHESS_SCENE_THEME_NAME:
		chess_scene_set_theme_name (self, g_value_get_string (value));
		break;
		case CHESS_SCENE_SHOW_3D_SMOOTH:
		chess_scene_set_show_3d_smooth (self, g_value_get_boolean (value));
		break;
		case CHESS_SCENE_BOARD_SIDE:
		chess_scene_set_board_side (self, g_value_get_string (value));
		break;
		case CHESS_SCENE_MOVE_FORMAT:
		chess_scene_set_move_format (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



