/* seahorse-exporter.c generated by valac 0.20.1, the Vala compiler
 * generated from seahorse-exporter.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2012 Stefan Walter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 59 Temple Exporter, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Stef Walter <stefw@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include "seahorse-common.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SeahorseExporterExportToFileData SeahorseExporterExportToFileData;

struct _SeahorseExporterExportToFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SeahorseExporter* self;
	GFile* file;
	gboolean overwrite;
	GCancellable* cancellable;
	gboolean result;
	guint8* bytes;
	gint bytes_length1;
	gint _bytes_size_;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* outfile;
	GCancellable* _tmp2_;
	size_t _tmp3_;
	guint8* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	gint __tmp5__size_;
	guint unique;
	const gchar* _tmp6_;
	gboolean _tmp7_;
	GFile* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	GCancellable* _tmp11_;
	GError* err;
	GError* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GError * _inner_error_;
};



static GFile* seahorse_exporter_file_increment_unique (GFile* file, guint* state);
static void seahorse_exporter_export_to_file_data_free (gpointer _data);
static gboolean seahorse_exporter_export_to_file_co (SeahorseExporterExportToFileData* _data_);
static void seahorse_exporter_export_to_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);


GType seahorse_exporter_type_get_type (void) {
	static volatile gsize seahorse_exporter_type_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_exporter_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SEAHORSE_EXPORTER_TYPE_ANY, "SEAHORSE_EXPORTER_TYPE_ANY", "any"}, {SEAHORSE_EXPORTER_TYPE_TEXTUAL, "SEAHORSE_EXPORTER_TYPE_TEXTUAL", "textual"}, {0, NULL, NULL}};
		GType seahorse_exporter_type_type_id;
		seahorse_exporter_type_type_id = g_enum_register_static ("SeahorseExporterType", values);
		g_once_init_leave (&seahorse_exporter_type_type_id__volatile, seahorse_exporter_type_type_id);
	}
	return seahorse_exporter_type_type_id__volatile;
}


GList* seahorse_exporter_get_objects (SeahorseExporter* self) {
#line 41 "/data/projects/seahorse/common/seahorse-exporter.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 41 "/data/projects/seahorse/common/seahorse-exporter.vala"
	return SEAHORSE_EXPORTER_GET_INTERFACE (self)->get_objects (self);
#line 105 "seahorse-exporter.c"
}


gboolean seahorse_exporter_add_object (SeahorseExporter* self, GObject* obj) {
#line 43 "/data/projects/seahorse/common/seahorse-exporter.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 43 "/data/projects/seahorse/common/seahorse-exporter.vala"
	return SEAHORSE_EXPORTER_GET_INTERFACE (self)->add_object (self, obj);
#line 114 "seahorse-exporter.c"
}


void seahorse_exporter_export (SeahorseExporter* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	SEAHORSE_EXPORTER_GET_INTERFACE (self)->export (self, cancellable, _callback_, _user_data_);
#line 121 "seahorse-exporter.c"
}


guint8* seahorse_exporter_export_finish (SeahorseExporter* self, GAsyncResult* _res_, size_t* result_length1, GError** error) {
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	return SEAHORSE_EXPORTER_GET_INTERFACE (self)->export_finish (self, _res_, result_length1, error);
#line 128 "seahorse-exporter.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
#line 928 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 931 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 931 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 153 "seahorse-exporter.c"
		gchar* _tmp4_;
#line 932 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 932 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 932 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 161 "seahorse-exporter.c"
	} else {
#line 934 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = -1;
#line 934 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 167 "seahorse-exporter.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1158 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1158 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 191 "seahorse-exporter.c"
		glong _tmp4_;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 199 "seahorse-exporter.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 211 "seahorse-exporter.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1168 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 236 "seahorse-exporter.c"
		glong _tmp2_;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 242 "seahorse-exporter.c"
	} else {
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 246 "seahorse-exporter.c"
	}
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 252 "seahorse-exporter.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 264 "seahorse-exporter.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 274 "seahorse-exporter.c"
	}
#line 1177 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1177 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 280 "seahorse-exporter.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1179 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1179 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 294 "seahorse-exporter.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 304 "seahorse-exporter.c"
	}
#line 1183 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1183 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 310 "seahorse-exporter.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 319 "seahorse-exporter.c"
	}
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 339 "seahorse-exporter.c"
}


static GFile* seahorse_exporter_file_increment_unique (GFile* file, guint* state) {
	GFile* result = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* uri;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	gint last;
	gint _tmp4_;
	gchar* prefix = NULL;
	gchar* suffix = NULL;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_ = 0;
	gint index;
	gint _tmp8_;
	guint _tmp18_;
	const gchar* _tmp19_;
	guint _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	GFile* _tmp24_ = NULL;
	GFile* _tmp25_;
#line 48 "/data/projects/seahorse/common/seahorse-exporter.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 51 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp0_ = file;
#line 51 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp1_ = g_file_get_uri (_tmp0_);
#line 51 "/data/projects/seahorse/common/seahorse-exporter.vala"
	uri = _tmp1_;
#line 54 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp2_ = uri;
#line 54 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp3_ = string_last_index_of_char (_tmp2_, (gunichar) '/', 0);
#line 54 "/data/projects/seahorse/common/seahorse-exporter.vala"
	last = _tmp3_;
#line 55 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp4_ = last;
#line 55 "/data/projects/seahorse/common/seahorse-exporter.vala"
	if (_tmp4_ == (-1)) {
#line 56 "/data/projects/seahorse/common/seahorse-exporter.vala"
		last = 0;
#line 387 "seahorse-exporter.c"
	}
#line 62 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp5_ = uri;
#line 62 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp6_ = last;
#line 62 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp7_ = string_last_index_of_char (_tmp5_, (gunichar) '.', _tmp6_);
#line 62 "/data/projects/seahorse/common/seahorse-exporter.vala"
	index = _tmp7_;
#line 63 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp8_ = index;
#line 63 "/data/projects/seahorse/common/seahorse-exporter.vala"
	if (_tmp8_ == (-1)) {
#line 401 "seahorse-exporter.c"
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
#line 64 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_tmp9_ = uri;
#line 64 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_tmp10_ = g_strdup (_tmp9_);
#line 64 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_g_free0 (prefix);
#line 64 "/data/projects/seahorse/common/seahorse-exporter.vala"
		prefix = _tmp10_;
#line 65 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_tmp11_ = g_strdup ("");
#line 65 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_g_free0 (suffix);
#line 65 "/data/projects/seahorse/common/seahorse-exporter.vala"
		suffix = _tmp11_;
#line 419 "seahorse-exporter.c"
	} else {
		const gchar* _tmp12_;
		gint _tmp13_;
		gchar* _tmp14_ = NULL;
		const gchar* _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_ = NULL;
#line 67 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_tmp12_ = uri;
#line 67 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_tmp13_ = index;
#line 67 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_tmp14_ = string_substring (_tmp12_, (glong) 0, (glong) _tmp13_);
#line 67 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_g_free0 (prefix);
#line 67 "/data/projects/seahorse/common/seahorse-exporter.vala"
		prefix = _tmp14_;
#line 68 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_tmp15_ = uri;
#line 68 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_tmp16_ = index;
#line 68 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_tmp17_ = string_substring (_tmp15_, (glong) _tmp16_, (glong) (-1));
#line 68 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_g_free0 (suffix);
#line 68 "/data/projects/seahorse/common/seahorse-exporter.vala"
		suffix = _tmp17_;
#line 447 "seahorse-exporter.c"
	}
#line 71 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp18_ = *state;
#line 71 "/data/projects/seahorse/common/seahorse-exporter.vala"
	*state = _tmp18_ + 1;
#line 72 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp19_ = prefix;
#line 72 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp20_ = *state;
#line 72 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp21_ = suffix;
#line 72 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp22_ = g_strdup_printf ("%s-%u%s", _tmp19_, _tmp20_, _tmp21_);
#line 72 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp23_ = _tmp22_;
#line 72 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp24_ = g_file_new_for_uri (_tmp23_);
#line 72 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp25_ = _tmp24_;
#line 72 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_g_free0 (_tmp23_);
#line 72 "/data/projects/seahorse/common/seahorse-exporter.vala"
	result = _tmp25_;
#line 72 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_g_free0 (suffix);
#line 72 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_g_free0 (prefix);
#line 72 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_g_free0 (uri);
#line 72 "/data/projects/seahorse/common/seahorse-exporter.vala"
	return result;
#line 479 "seahorse-exporter.c"
}


static void seahorse_exporter_export_to_file_data_free (gpointer _data) {
	SeahorseExporterExportToFileData* _data_;
	_data_ = _data;
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_g_object_unref0 (_data_->file);
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_g_object_unref0 (_data_->cancellable);
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_g_object_unref0 (_data_->self);
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	g_slice_free (SeahorseExporterExportToFileData, _data_);
#line 494 "seahorse-exporter.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	return self ? g_object_ref (self) : NULL;
#line 501 "seahorse-exporter.c"
}


void seahorse_exporter_export_to_file (SeahorseExporter* self, GFile* file, gboolean overwrite, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SeahorseExporterExportToFileData* _data_;
	SeahorseExporter* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_;
	GCancellable* _tmp4_;
	GCancellable* _tmp5_;
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_ = g_slice_new0 (SeahorseExporterExportToFileData);
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, seahorse_exporter_export_to_file);
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, seahorse_exporter_export_to_file_data_free);
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->self = _tmp0_;
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp1_ = file;
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_g_object_unref0 (_data_->file);
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->file = _tmp2_;
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp3_ = overwrite;
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->overwrite = _tmp3_;
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp4_ = cancellable;
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_g_object_unref0 (_data_->cancellable);
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->cancellable = _tmp5_;
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	seahorse_exporter_export_to_file_co (_data_);
#line 545 "seahorse-exporter.c"
}


gboolean seahorse_exporter_export_to_file_finish (SeahorseExporter* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SeahorseExporterExportToFileData* _data_;
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
		return FALSE;
#line 556 "seahorse-exporter.c"
	}
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	result = _data_->result;
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	return result;
#line 564 "seahorse-exporter.c"
}


static void seahorse_exporter_export_to_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SeahorseExporterExportToFileData* _data_;
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_ = _user_data_;
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->_source_object_ = source_object;
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->_res_ = _res_;
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	seahorse_exporter_export_to_file_co (_data_);
#line 578 "seahorse-exporter.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 103 "/data/projects/seahorse/common/seahorse-exporter.vala"
	return self ? g_error_copy (self) : NULL;
#line 585 "seahorse-exporter.c"
}


static gboolean seahorse_exporter_export_to_file_co (SeahorseExporterExportToFileData* _data_) {
#line 75 "/data/projects/seahorse/common/seahorse-exporter.vala"
	switch (_data_->_state_) {
#line 75 "/data/projects/seahorse/common/seahorse-exporter.vala"
		case 0:
#line 594 "seahorse-exporter.c"
		goto _state_0;
#line 75 "/data/projects/seahorse/common/seahorse-exporter.vala"
		case 1:
#line 598 "seahorse-exporter.c"
		goto _state_1;
#line 75 "/data/projects/seahorse/common/seahorse-exporter.vala"
		case 2:
#line 602 "seahorse-exporter.c"
		goto _state_2;
		default:
#line 75 "/data/projects/seahorse/common/seahorse-exporter.vala"
		g_assert_not_reached ();
#line 607 "seahorse-exporter.c"
	}
	_state_0:
#line 79 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->bytes_length1 = 0;
#line 79 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->_bytes_size_ = 0;
#line 80 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->_tmp0_ = _data_->file;
#line 80 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
#line 80 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->outfile = _data_->_tmp1_;
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->_tmp2_ = _data_->cancellable;
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	memset (&_data_->_tmp3_, 0, sizeof (size_t));
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->_state_ = 1;
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	seahorse_exporter_export (_data_->self, _data_->_tmp2_, seahorse_exporter_export_to_file_ready, _data_);
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	return FALSE;
#line 630 "seahorse-exporter.c"
	_state_1:
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->_tmp4_ = NULL;
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->_tmp4_ = seahorse_exporter_export_finish (_data_->self, _data_->_res_, &_data_->_tmp3_, &_data_->_inner_error_);
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->_tmp5__length1 = _data_->_tmp3_;
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->__tmp5__size_ = _data_->_tmp5__length1;
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	if (_data_->_inner_error_ != NULL) {
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
		g_error_free (_data_->_inner_error_);
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_g_object_unref0 (_data_->outfile);
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_data_->bytes = (g_free (_data_->bytes), NULL);
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
		if (_data_->_state_ == 0) {
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 656 "seahorse-exporter.c"
		} else {
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 660 "seahorse-exporter.c"
		}
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
		g_object_unref (_data_->_async_result);
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
		return FALSE;
#line 666 "seahorse-exporter.c"
	}
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->bytes = (g_free (_data_->bytes), NULL);
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->bytes = _data_->_tmp5_;
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->bytes_length1 = _data_->_tmp5__length1;
#line 82 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->_bytes_size_ = _data_->bytes_length1;
#line 90 "/data/projects/seahorse/common/seahorse-exporter.vala"
	while (TRUE) {
#line 91 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_data_->unique = (guint) 0;
#line 680 "seahorse-exporter.c"
		{
#line 93 "/data/projects/seahorse/common/seahorse-exporter.vala"
			_data_->_tmp7_ = _data_->overwrite;
#line 93 "/data/projects/seahorse/common/seahorse-exporter.vala"
			if (_data_->_tmp7_) {
#line 93 "/data/projects/seahorse/common/seahorse-exporter.vala"
				_data_->_tmp6_ = NULL;
#line 688 "seahorse-exporter.c"
			} else {
#line 93 "/data/projects/seahorse/common/seahorse-exporter.vala"
				_data_->_tmp6_ = "invalid etag";
#line 692 "seahorse-exporter.c"
			}
#line 93 "/data/projects/seahorse/common/seahorse-exporter.vala"
			_data_->_tmp8_ = _data_->outfile;
#line 93 "/data/projects/seahorse/common/seahorse-exporter.vala"
			_data_->_tmp9_ = _data_->bytes;
#line 93 "/data/projects/seahorse/common/seahorse-exporter.vala"
			_data_->_tmp9__length1 = _data_->bytes_length1;
#line 93 "/data/projects/seahorse/common/seahorse-exporter.vala"
			_data_->_tmp10_ = _data_->_tmp6_;
#line 93 "/data/projects/seahorse/common/seahorse-exporter.vala"
			_data_->_tmp11_ = _data_->cancellable;
#line 93 "/data/projects/seahorse/common/seahorse-exporter.vala"
			_data_->_state_ = 2;
#line 93 "/data/projects/seahorse/common/seahorse-exporter.vala"
			g_file_replace_contents_async (_data_->_tmp8_, _data_->_tmp9_, (gsize) _data_->_tmp9__length1, _data_->_tmp10_, FALSE, G_FILE_CREATE_PRIVATE, _data_->_tmp11_, seahorse_exporter_export_to_file_ready, _data_);
#line 93 "/data/projects/seahorse/common/seahorse-exporter.vala"
			return FALSE;
#line 710 "seahorse-exporter.c"
			_state_2:
#line 93 "/data/projects/seahorse/common/seahorse-exporter.vala"
			g_file_replace_contents_finish (_data_->_tmp8_, _data_->_res_, NULL, &_data_->_inner_error_);
#line 93 "/data/projects/seahorse/common/seahorse-exporter.vala"
			if (_data_->_inner_error_ != NULL) {
#line 93 "/data/projects/seahorse/common/seahorse-exporter.vala"
				if (_data_->_inner_error_->domain == G_IO_ERROR) {
#line 718 "seahorse-exporter.c"
					goto __catch0_g_io_error;
				}
				goto __finally0;
			}
#line 96 "/data/projects/seahorse/common/seahorse-exporter.vala"
			_data_->result = TRUE;
#line 96 "/data/projects/seahorse/common/seahorse-exporter.vala"
			_g_object_unref0 (_data_->outfile);
#line 96 "/data/projects/seahorse/common/seahorse-exporter.vala"
			_data_->bytes = (g_free (_data_->bytes), NULL);
#line 96 "/data/projects/seahorse/common/seahorse-exporter.vala"
			if (_data_->_state_ == 0) {
#line 96 "/data/projects/seahorse/common/seahorse-exporter.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 733 "seahorse-exporter.c"
			} else {
#line 96 "/data/projects/seahorse/common/seahorse-exporter.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 737 "seahorse-exporter.c"
			}
#line 96 "/data/projects/seahorse/common/seahorse-exporter.vala"
			g_object_unref (_data_->_async_result);
#line 96 "/data/projects/seahorse/common/seahorse-exporter.vala"
			return FALSE;
#line 743 "seahorse-exporter.c"
		}
		goto __finally0;
		__catch0_g_io_error:
		{
#line 92 "/data/projects/seahorse/common/seahorse-exporter.vala"
			_data_->err = _data_->_inner_error_;
#line 92 "/data/projects/seahorse/common/seahorse-exporter.vala"
			_data_->_inner_error_ = NULL;
#line 99 "/data/projects/seahorse/common/seahorse-exporter.vala"
			_data_->_tmp12_ = _data_->err;
#line 99 "/data/projects/seahorse/common/seahorse-exporter.vala"
			if (g_error_matches (_data_->_tmp12_, G_IO_ERROR, G_IO_ERROR_WRONG_ETAG)) {
#line 100 "/data/projects/seahorse/common/seahorse-exporter.vala"
				_data_->_tmp13_ = _data_->file;
#line 100 "/data/projects/seahorse/common/seahorse-exporter.vala"
				_data_->_tmp14_ = NULL;
#line 100 "/data/projects/seahorse/common/seahorse-exporter.vala"
				_data_->_tmp14_ = seahorse_exporter_file_increment_unique (_data_->_tmp13_, &_data_->unique);
#line 100 "/data/projects/seahorse/common/seahorse-exporter.vala"
				_g_object_unref0 (_data_->outfile);
#line 100 "/data/projects/seahorse/common/seahorse-exporter.vala"
				_data_->outfile = _data_->_tmp14_;
#line 101 "/data/projects/seahorse/common/seahorse-exporter.vala"
				_g_error_free0 (_data_->err);
#line 101 "/data/projects/seahorse/common/seahorse-exporter.vala"
				continue;
#line 770 "seahorse-exporter.c"
			}
#line 103 "/data/projects/seahorse/common/seahorse-exporter.vala"
			_data_->_tmp15_ = _data_->err;
#line 103 "/data/projects/seahorse/common/seahorse-exporter.vala"
			_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
#line 103 "/data/projects/seahorse/common/seahorse-exporter.vala"
			_data_->_inner_error_ = _data_->_tmp16_;
#line 103 "/data/projects/seahorse/common/seahorse-exporter.vala"
			_g_error_free0 (_data_->err);
#line 780 "seahorse-exporter.c"
			goto __finally0;
		}
		__finally0:
#line 92 "/data/projects/seahorse/common/seahorse-exporter.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 92 "/data/projects/seahorse/common/seahorse-exporter.vala"
		g_error_free (_data_->_inner_error_);
#line 92 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_g_object_unref0 (_data_->outfile);
#line 92 "/data/projects/seahorse/common/seahorse-exporter.vala"
		_data_->bytes = (g_free (_data_->bytes), NULL);
#line 92 "/data/projects/seahorse/common/seahorse-exporter.vala"
		if (_data_->_state_ == 0) {
#line 92 "/data/projects/seahorse/common/seahorse-exporter.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 796 "seahorse-exporter.c"
		} else {
#line 92 "/data/projects/seahorse/common/seahorse-exporter.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 800 "seahorse-exporter.c"
		}
#line 92 "/data/projects/seahorse/common/seahorse-exporter.vala"
		g_object_unref (_data_->_async_result);
#line 92 "/data/projects/seahorse/common/seahorse-exporter.vala"
		return FALSE;
#line 806 "seahorse-exporter.c"
	}
#line 75 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_g_object_unref0 (_data_->outfile);
#line 75 "/data/projects/seahorse/common/seahorse-exporter.vala"
	_data_->bytes = (g_free (_data_->bytes), NULL);
#line 75 "/data/projects/seahorse/common/seahorse-exporter.vala"
	if (_data_->_state_ == 0) {
#line 75 "/data/projects/seahorse/common/seahorse-exporter.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 816 "seahorse-exporter.c"
	} else {
#line 75 "/data/projects/seahorse/common/seahorse-exporter.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 820 "seahorse-exporter.c"
	}
#line 75 "/data/projects/seahorse/common/seahorse-exporter.vala"
	g_object_unref (_data_->_async_result);
#line 75 "/data/projects/seahorse/common/seahorse-exporter.vala"
	return FALSE;
#line 826 "seahorse-exporter.c"
}


gchar* seahorse_exporter_get_filename (SeahorseExporter* self) {
#line 35 "/data/projects/seahorse/common/seahorse-exporter.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 35 "/data/projects/seahorse/common/seahorse-exporter.vala"
	return SEAHORSE_EXPORTER_GET_INTERFACE (self)->get_filename (self);
#line 835 "seahorse-exporter.c"
}


const gchar* seahorse_exporter_get_content_type (SeahorseExporter* self) {
#line 37 "/data/projects/seahorse/common/seahorse-exporter.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 37 "/data/projects/seahorse/common/seahorse-exporter.vala"
	return SEAHORSE_EXPORTER_GET_INTERFACE (self)->get_content_type (self);
#line 844 "seahorse-exporter.c"
}


GtkFileFilter* seahorse_exporter_get_file_filter (SeahorseExporter* self) {
#line 39 "/data/projects/seahorse/common/seahorse-exporter.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "/data/projects/seahorse/common/seahorse-exporter.vala"
	return SEAHORSE_EXPORTER_GET_INTERFACE (self)->get_file_filter (self);
#line 853 "seahorse-exporter.c"
}


static void seahorse_exporter_base_init (SeahorseExporterIface * iface) {
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	static gboolean initialized = FALSE;
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
	if (!initialized) {
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
		initialized = TRUE;
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("content-type", "content-type", "content-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 34 "/data/projects/seahorse/common/seahorse-exporter.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("file-filter", "file-filter", "file-filter", GTK_TYPE_FILE_FILTER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 870 "seahorse-exporter.c"
	}
}


GType seahorse_exporter_get_type (void) {
	static volatile gsize seahorse_exporter_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_exporter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseExporterIface), (GBaseInitFunc) seahorse_exporter_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType seahorse_exporter_type_id;
		seahorse_exporter_type_id = g_type_register_static (G_TYPE_INTERFACE, "SeahorseExporter", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (seahorse_exporter_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&seahorse_exporter_type_id__volatile, seahorse_exporter_type_id);
	}
	return seahorse_exporter_type_id__volatile;
}



