/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-language.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-editor-language
 * @title: IAnjutaEditorLanguage
 * @short_description: Text editor language interface
 * @see_also:
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-editor-language.h
 *
 */

#include "ianjuta-editor-language.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_editor_language_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-editor-language-quark");
	}
	
	return quark;
}

/**
 * ianjuta_editor_language_get_language:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Return the name of the currently used language
 *
 */
const gchar *
ianjuta_editor_language_get_language (IAnjutaEditorLanguage *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_LANGUAGE(obj), NULL);
	return IANJUTA_EDITOR_LANGUAGE_GET_IFACE (obj)->get_language (obj, err);
}

/* Default implementation */
static const gchar *
ianjuta_editor_language_get_language_default (IAnjutaEditorLanguage *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_editor_language_name:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Get a list of languages the editor can highlight
 *
 */
const gchar *
ianjuta_editor_language_get_language_name (IAnjutaEditorLanguage *obj, const gchar* language, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_LANGUAGE(obj), NULL);
	return IANJUTA_EDITOR_LANGUAGE_GET_IFACE (obj)->get_language_name (obj, language, err);
}

/* Default implementation */
static const gchar *
ianjuta_editor_language_get_language_name_default (IAnjutaEditorLanguage *obj, const gchar* language, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_editor_language_get_supported_languages:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Return a list of languages supported by the editor
 * Note: These list contains the names in the form
 * the editor implementation knows them
 * Returns: (element-type utf8):
 */
const GList*
ianjuta_editor_language_get_supported_languages (IAnjutaEditorLanguage *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_LANGUAGE(obj), 0);
	return IANJUTA_EDITOR_LANGUAGE_GET_IFACE (obj)->get_supported_languages (obj, err);
}

/* Default implementation */
static const GList*
ianjuta_editor_language_get_supported_languages_default (IAnjutaEditorLanguage *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_editor_language_set_language:
 * @obj: Self
 * @language: Language
 * @err: Error propagation and reporting
 *
 * Force the editor to use a given language
 *
 */
void
ianjuta_editor_language_set_language (IAnjutaEditorLanguage *obj, const gchar* language, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_LANGUAGE(obj));
	IANJUTA_EDITOR_LANGUAGE_GET_IFACE (obj)->set_language (obj, language, err);
}

/* Default implementation */
static void
ianjuta_editor_language_set_language_default (IAnjutaEditorLanguage *obj, const gchar* language, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_editor_language_base_init (IAnjutaEditorLanguageIface* klass)
{
	static gboolean initialized = FALSE;

	klass->get_language = ianjuta_editor_language_get_language_default;
	klass->get_language_name = ianjuta_editor_language_get_language_name_default;
	klass->get_supported_languages = ianjuta_editor_language_get_supported_languages_default;
	klass->set_language = ianjuta_editor_language_set_language_default;
	
	if (!initialized) {

		  /* IAnjutaEditorLanguage::language-changed:
		 * @obj: self
		 * @language: new language
		 *
		 * the language of the editor changed to @language
		 */
		g_signal_new ("language-changed",
			IANJUTA_TYPE_EDITOR_LANGUAGE,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaEditorLanguageIface, language_changed),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			1,
			G_TYPE_STRING);


		initialized = TRUE;
	}
}

GType
ianjuta_editor_language_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEditorLanguageIface),
			(GBaseInitFunc) ianjuta_editor_language_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEditorLanguage", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_EDITOR);
	}
	return type;			
}
