/* rygel-mp2ts-transcoder.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-mp2ts-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>
#include <gst/pbutils/pbutils.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <rygel-core.h>


#define RYGEL_TYPE_MP2_TS_PROFILE (rygel_mp2_ts_profile_get_type ())

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_AUDIO_TRANSCODER (rygel_audio_transcoder_get_type ())
#define RYGEL_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoder))
#define RYGEL_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))
#define RYGEL_IS_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_IS_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_AUDIO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))

typedef struct _RygelAudioTranscoder RygelAudioTranscoder;
typedef struct _RygelAudioTranscoderClass RygelAudioTranscoderClass;
typedef struct _RygelAudioTranscoderPrivate RygelAudioTranscoderPrivate;

#define RYGEL_TYPE_VIDEO_TRANSCODER (rygel_video_transcoder_get_type ())
#define RYGEL_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoder))
#define RYGEL_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))
#define RYGEL_IS_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_IS_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_VIDEO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))

typedef struct _RygelVideoTranscoder RygelVideoTranscoder;
typedef struct _RygelVideoTranscoderClass RygelVideoTranscoderClass;
typedef struct _RygelVideoTranscoderPrivate RygelVideoTranscoderPrivate;

#define RYGEL_TYPE_MP2_TS_TRANSCODER (rygel_mp2_ts_transcoder_get_type ())
#define RYGEL_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoder))
#define RYGEL_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))
#define RYGEL_IS_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_IS_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_MP2_TS_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))

typedef struct _RygelMP2TSTranscoder RygelMP2TSTranscoder;
typedef struct _RygelMP2TSTranscoderClass RygelMP2TSTranscoderClass;
typedef struct _RygelMP2TSTranscoderPrivate RygelMP2TSTranscoderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

typedef enum  {
	RYGEL_MP2_TS_PROFILE_SD = 0,
	RYGEL_MP2_TS_PROFILE_HD
} RygelMP2TSProfile;

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
	GstElement* (*create_source) (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error);
	GUPnPDIDLLiteResource* (*add_resource) (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
	guint (*get_distance) (RygelTranscoder* self, RygelMediaItem* item);
	GstEncodingProfile* (*get_encoding_profile) (RygelTranscoder* self);
};

struct _RygelAudioTranscoder {
	RygelTranscoder parent_instance;
	RygelAudioTranscoderPrivate * priv;
	gint audio_bitrate;
	GstCaps* container_format;
	GstCaps* audio_codec_format;
};

struct _RygelAudioTranscoderClass {
	RygelTranscoderClass parent_class;
};

struct _RygelVideoTranscoder {
	RygelAudioTranscoder parent_instance;
	RygelVideoTranscoderPrivate * priv;
};

struct _RygelVideoTranscoderClass {
	RygelAudioTranscoderClass parent_class;
};

struct _RygelMP2TSTranscoder {
	RygelVideoTranscoder parent_instance;
	RygelMP2TSTranscoderPrivate * priv;
};

struct _RygelMP2TSTranscoderClass {
	RygelVideoTranscoderClass parent_class;
};

struct _RygelMP2TSTranscoderPrivate {
	RygelMP2TSProfile profile;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self, const gchar* host_ip);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};


static gpointer rygel_mp2_ts_transcoder_parent_class = NULL;

GType rygel_mp2_ts_profile_get_type (void) G_GNUC_CONST;
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_audio_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_video_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_mp2_ts_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_MP2_TS_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderPrivate))
enum  {
	RYGEL_MP2_TS_TRANSCODER_DUMMY_PROPERTY
};
#define RYGEL_MP2_TS_TRANSCODER_VIDEO_BITRATE 1500
#define RYGEL_MP2_TS_TRANSCODER_AUDIO_BITRATE 192
#define RYGEL_MP2_TS_TRANSCODER_CONTAINER "video/mpegts,systemstream=true,packetsize=188"
#define RYGEL_MP2_TS_TRANSCODER_AUDIO_FORMAT "audio/mpeg,mpegversion=1,layer=2"
#define RYGEL_MP2_TS_TRANSCODER_BASE_VIDEO_FORMAT "video/mpeg,mpegversion=2,systemstream=false"
#define RYGEL_MP2_TS_TRANSCODER_RESTRICTION_TEMPLATE "video/x-raw-yuv,framerate=(fraction)%d/1,width=%d,height=%d"
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_new (RygelMP2TSProfile profile);
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_construct (GType object_type, RygelMP2TSProfile profile);
RygelVideoTranscoder* rygel_video_transcoder_new (const gchar* content_type, const gchar* dlna_profile, gint audio_bitrate, gint video_bitrate, const gchar* container_caps, const gchar* audio_codec_caps, const gchar* video_codec_caps, const gchar* extension, const gchar* restrictions);
RygelVideoTranscoder* rygel_video_transcoder_construct (GType object_type, const gchar* content_type, const gchar* dlna_profile, gint audio_bitrate, gint video_bitrate, const gchar* container_caps, const gchar* audio_codec_caps, const gchar* video_codec_caps, const gchar* extension, const gchar* restrictions);
static GUPnPDIDLLiteResource* rygel_mp2_ts_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static guint rygel_mp2_ts_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
gint rygel_visual_item_get_width (RygelVisualItem* self);
gint rygel_visual_item_get_height (RygelVisualItem* self);
static void rygel_mp2_ts_transcoder_finalize (GObject* obj);

static const gint RYGEL_MP2_TS_TRANSCODER_WIDTH[2] = {720, 1280};
static const gint RYGEL_MP2_TS_TRANSCODER_HEIGHT[2] = {576, 720};
static const gint RYGEL_MP2_TS_TRANSCODER_FRAME_RATE[2] = {25, 30};
static const gchar* RYGEL_MP2_TS_TRANSCODER_PROFILES[2] = {"MPEG_TS_SD_EU_ISO", "MPEG_TS_HD_NA_ISO"};

GType rygel_mp2_ts_profile_get_type (void) {
	static volatile gsize rygel_mp2_ts_profile_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mp2_ts_profile_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_MP2_TS_PROFILE_SD, "RYGEL_MP2_TS_PROFILE_SD", "sd"}, {RYGEL_MP2_TS_PROFILE_HD, "RYGEL_MP2_TS_PROFILE_HD", "hd"}, {0, NULL, NULL}};
		GType rygel_mp2_ts_profile_type_id;
		rygel_mp2_ts_profile_type_id = g_enum_register_static ("RygelMP2TSProfile", values);
		g_once_init_leave (&rygel_mp2_ts_profile_type_id__volatile, rygel_mp2_ts_profile_type_id);
	}
	return rygel_mp2_ts_profile_type_id__volatile;
}


RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_construct (GType object_type, RygelMP2TSProfile profile) {
	RygelMP2TSTranscoder * self = NULL;
	RygelMP2TSProfile _tmp0_;
	const gchar* _tmp1_;
	RygelMP2TSProfile _tmp2_;
	gint _tmp3_;
	RygelMP2TSProfile _tmp4_;
	gint _tmp5_;
	RygelMP2TSProfile _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	RygelMP2TSProfile _tmp10_;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp0_ = profile;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp1_ = RYGEL_MP2_TS_TRANSCODER_PROFILES[_tmp0_];
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp2_ = profile;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp3_ = RYGEL_MP2_TS_TRANSCODER_FRAME_RATE[_tmp2_];
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp4_ = profile;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp5_ = RYGEL_MP2_TS_TRANSCODER_WIDTH[_tmp4_];
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp6_ = profile;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp7_ = RYGEL_MP2_TS_TRANSCODER_HEIGHT[_tmp6_];
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp8_ = g_strdup_printf (RYGEL_MP2_TS_TRANSCODER_RESTRICTION_TEMPLATE, _tmp3_, _tmp5_, _tmp7_);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp9_ = _tmp8_;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	self = (RygelMP2TSTranscoder*) rygel_video_transcoder_construct (object_type, "video/mpeg", _tmp1_, RYGEL_MP2_TS_TRANSCODER_AUDIO_BITRATE, RYGEL_MP2_TS_TRANSCODER_VIDEO_BITRATE, RYGEL_MP2_TS_TRANSCODER_CONTAINER, RYGEL_MP2_TS_TRANSCODER_AUDIO_FORMAT, RYGEL_MP2_TS_TRANSCODER_BASE_VIDEO_FORMAT, "mpg", _tmp9_);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_g_free0 (_tmp9_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp10_ = profile;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	self->priv->profile = _tmp10_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	return self;
#line 397 "rygel-mp2ts-transcoder.c"
}


RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_new (RygelMP2TSProfile profile) {
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	return rygel_mp2_ts_transcoder_construct (RYGEL_TYPE_MP2_TS_TRANSCODER, profile);
#line 404 "rygel-mp2ts-transcoder.c"
}


static GUPnPDIDLLiteResource* rygel_mp2_ts_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
	RygelMP2TSTranscoder * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteItem* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelTranscodeManager* _tmp2_;
	GUPnPDIDLLiteResource* _tmp3_ = NULL;
	GUPnPDIDLLiteResource* resource;
	RygelMP2TSProfile _tmp4_;
	gint _tmp5_;
	RygelMP2TSProfile _tmp6_;
	gint _tmp7_;
	GError * _inner_error_ = NULL;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	self = (RygelMP2TSTranscoder*) base;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	g_return_val_if_fail (didl_item != NULL, NULL);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	g_return_val_if_fail (manager != NULL, NULL);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp0_ = didl_item;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp1_ = item;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp2_ = manager;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp3_ = RYGEL_TRANSCODER_CLASS (rygel_mp2_ts_transcoder_parent_class)->add_resource ((RygelTranscoder*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoder), _tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	resource = _tmp3_;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		return NULL;
#line 445 "rygel-mp2ts-transcoder.c"
	}
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	if (resource == NULL) {
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		result = NULL;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_g_object_unref0 (resource);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		return result;
#line 455 "rygel-mp2ts-transcoder.c"
	}
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp4_ = self->priv->profile;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp5_ = RYGEL_MP2_TS_TRANSCODER_WIDTH[_tmp4_];
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	gupnp_didl_lite_resource_set_width (resource, _tmp5_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp6_ = self->priv->profile;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp7_ = RYGEL_MP2_TS_TRANSCODER_HEIGHT[_tmp6_];
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	gupnp_didl_lite_resource_set_height (resource, _tmp7_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	gupnp_didl_lite_resource_set_bitrate (resource, ((RYGEL_MP2_TS_TRANSCODER_VIDEO_BITRATE + RYGEL_MP2_TS_TRANSCODER_AUDIO_BITRATE) * 1000) / 8);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	result = resource;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	return result;
#line 475 "rygel-mp2ts-transcoder.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	return self ? g_object_ref (self) : NULL;
#line 482 "rygel-mp2ts-transcoder.c"
}


static guint rygel_mp2_ts_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item) {
	RygelMP2TSTranscoder * self;
	guint result = 0U;
	RygelMediaItem* _tmp0_;
	RygelMediaItem* _tmp2_;
	RygelVideoItem* _tmp3_;
	RygelVideoItem* video_item;
	RygelMediaItem* _tmp4_;
	guint _tmp5_ = 0U;
	guint distance;
	RygelVideoItem* _tmp6_;
	gint _tmp7_;
	RygelVideoItem* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	RygelVideoItem* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	self = (RygelMP2TSTranscoder*) base;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	g_return_val_if_fail (item != NULL, 0U);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp0_ = item;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_VIDEO_ITEM)) {
#line 512 "rygel-mp2ts-transcoder.c"
		guint _tmp1_;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp1_ = G_MAXUINT;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		result = _tmp1_;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		return result;
#line 520 "rygel-mp2ts-transcoder.c"
	}
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp2_ = item;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _tmp2_) : NULL);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	video_item = _tmp3_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp4_ = item;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp5_ = RYGEL_TRANSCODER_CLASS (rygel_mp2_ts_transcoder_parent_class)->get_distance ((RygelTranscoder*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoder), _tmp4_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	distance = _tmp5_;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp6_ = video_item;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp7_ = ((RygelAudioItem*) _tmp6_)->bitrate;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	if (_tmp7_ > 0) {
#line 540 "rygel-mp2ts-transcoder.c"
		guint _tmp8_;
		RygelVideoItem* _tmp9_;
		gint _tmp10_;
		gint _tmp11_ = 0;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp8_ = distance;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp9_ = video_item;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp10_ = ((RygelAudioItem*) _tmp9_)->bitrate;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp11_ = abs (_tmp10_ - RYGEL_MP2_TS_TRANSCODER_VIDEO_BITRATE);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		distance = _tmp8_ + _tmp11_;
#line 555 "rygel-mp2ts-transcoder.c"
	}
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp12_ = video_item;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp13_ = rygel_visual_item_get_width ((RygelVisualItem*) _tmp12_);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp14_ = _tmp13_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	if (_tmp14_ > 0) {
#line 565 "rygel-mp2ts-transcoder.c"
		guint _tmp15_;
		RygelVideoItem* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		RygelMP2TSProfile _tmp19_;
		gint _tmp20_;
		gint _tmp21_ = 0;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp15_ = distance;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp16_ = video_item;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp17_ = rygel_visual_item_get_width ((RygelVisualItem*) _tmp16_);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp18_ = _tmp17_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp19_ = self->priv->profile;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp20_ = RYGEL_MP2_TS_TRANSCODER_WIDTH[_tmp19_];
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp21_ = abs (_tmp18_ - _tmp20_);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		distance = _tmp15_ + _tmp21_;
#line 589 "rygel-mp2ts-transcoder.c"
	}
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp22_ = video_item;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp23_ = rygel_visual_item_get_height ((RygelVisualItem*) _tmp22_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_tmp24_ = _tmp23_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	if (_tmp24_ > 0) {
#line 599 "rygel-mp2ts-transcoder.c"
		guint _tmp25_;
		RygelVideoItem* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		RygelMP2TSProfile _tmp29_;
		gint _tmp30_;
		gint _tmp31_ = 0;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp25_ = distance;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp26_ = video_item;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp27_ = rygel_visual_item_get_height ((RygelVisualItem*) _tmp26_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp28_ = _tmp27_;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp29_ = self->priv->profile;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp30_ = RYGEL_MP2_TS_TRANSCODER_HEIGHT[_tmp29_];
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		_tmp31_ = abs (_tmp28_ - _tmp30_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
		distance = _tmp25_ + _tmp31_;
#line 623 "rygel-mp2ts-transcoder.c"
	}
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	result = distance;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	_g_object_unref0 (video_item);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	return result;
#line 631 "rygel-mp2ts-transcoder.c"
}


static void rygel_mp2_ts_transcoder_class_init (RygelMP2TSTranscoderClass * klass) {
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	rygel_mp2_ts_transcoder_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	g_type_class_add_private (klass, sizeof (RygelMP2TSTranscoderPrivate));
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->add_resource = rygel_mp2_ts_transcoder_real_add_resource;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->get_distance = rygel_mp2_ts_transcoder_real_get_distance;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_mp2_ts_transcoder_finalize;
#line 646 "rygel-mp2ts-transcoder.c"
}


static void rygel_mp2_ts_transcoder_instance_init (RygelMP2TSTranscoder * self) {
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	self->priv = RYGEL_MP2_TS_TRANSCODER_GET_PRIVATE (self);
#line 653 "rygel-mp2ts-transcoder.c"
}


static void rygel_mp2_ts_transcoder_finalize (GObject* obj) {
	RygelMP2TSTranscoder * self;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoder);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-mp2ts-transcoder.vala"
	G_OBJECT_CLASS (rygel_mp2_ts_transcoder_parent_class)->finalize (obj);
#line 663 "rygel-mp2ts-transcoder.c"
}


/**
 * Transcoder for mpeg transport stream containing mpeg 2 video and mp2 audio.
 */
GType rygel_mp2_ts_transcoder_get_type (void) {
	static volatile gsize rygel_mp2_ts_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mp2_ts_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMP2TSTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mp2_ts_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMP2TSTranscoder), 0, (GInstanceInitFunc) rygel_mp2_ts_transcoder_instance_init, NULL };
		GType rygel_mp2_ts_transcoder_type_id;
		rygel_mp2_ts_transcoder_type_id = g_type_register_static (RYGEL_TYPE_VIDEO_TRANSCODER, "RygelMP2TSTranscoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_mp2_ts_transcoder_type_id__volatile, rygel_mp2_ts_transcoder_type_id);
	}
	return rygel_mp2_ts_transcoder_type_id__volatile;
}



