/* rygel-media-query-action.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-media-query-action.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libgupnp-av/gupnp-av.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;
typedef struct _RygelMediaQueryActionPrivate RygelMediaQueryActionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaQueryActionRunData RygelMediaQueryActionRunData;
typedef struct _RygelMediaQueryActionFetchMediaObjectData RygelMediaQueryActionFetchMediaObjectData;

struct _RygelMediaQueryAction {
	GObject parent_instance;
	RygelMediaQueryActionPrivate * priv;
	gchar* object_id;
	gchar* browse_flag;
	gchar* filter;
	guint index;
	guint requested_count;
	gchar* sort_criteria;
	guint number_returned;
	guint total_matches;
	guint update_id;
	RygelMediaContainer* root_container;
	RygelHTTPServer* http_server;
	guint32 system_update_id;
	GUPnPServiceAction* action;
	GUPnPDIDLLiteWriter* didl_writer;
	RygelClientHacks* hacks;
	gchar* object_id_arg;
};

struct _RygelMediaQueryActionClass {
	GObjectClass parent_class;
	void (*parse_args) (RygelMediaQueryAction* self, GError** error);
	void (*fetch_results) (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*fetch_results_finish) (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
	void (*handle_error) (RygelMediaQueryAction* self, GError* _error_);
};

struct _RygelMediaQueryActionPrivate {
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()
struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
	gint64 storage_used;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaQueryActionRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaQueryAction* self;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* media_object;
	RygelMediaObject* _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* results;
	RygelMediaObjects* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	RygelMediaObject* _tmp6_;
	RygelMediaObject* _tmp7_;
	guint32 _tmp8_;
	guint32 _tmp9_;
	RygelMediaObjects* _tmp10_;
	GUPnPDIDLLiteWriter* _tmp11_;
	RygelHTTPServer* _tmp12_;
	RygelClientHacks* _tmp13_;
	GError* err;
	GError* _tmp14_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelMediaQueryActionFetchMediaObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaQueryAction* self;
	RygelMediaObject* result;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	RygelMediaContainer* _tmp3_;
	RygelMediaObject* _tmp4_;
	const gchar* _tmp5_;
	RygelMediaContainer* _tmp6_;
	const gchar* _tmp7_;
	GCancellable* _tmp8_;
	GCancellable* _tmp9_;
	RygelMediaObject* _tmp10_;
	RygelMediaObject* media_object;
	RygelMediaObject* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError * _inner_error_;
};


static gpointer rygel_media_query_action_parent_class = NULL;
static RygelStateMachineIface* rygel_media_query_action_rygel_state_machine_parent_iface = NULL;

GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_QUERY_ACTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionPrivate))
enum  {
	RYGEL_MEDIA_QUERY_ACTION_DUMMY_PROPERTY,
	RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE
};
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
RygelMediaQueryAction* rygel_media_query_action_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GQuark rygel_client_hacks_error_quark (void);
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error);
static void rygel_media_query_action_real_run_data_free (gpointer _data);
static void rygel_media_query_action_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_query_action_real_run_co (RygelMediaQueryActionRunData* _data_);
void rygel_media_query_action_parse_args (RygelMediaQueryAction* self, GError** error);
static void rygel_media_query_action_fetch_media_object (RygelMediaQueryAction* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObject* rygel_media_query_action_fetch_media_object_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
static void rygel_media_query_action_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_query_action_fetch_results (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_query_action_fetch_results_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
void rygel_media_objects_serialize (RygelMediaObjects* self, GUPnPDIDLLiteWriter* didl_writer, RygelHTTPServer* http_server, RygelClientHacks* hacks, GError** error);
static void rygel_media_query_action_conclude (RygelMediaQueryAction* self);
void rygel_media_query_action_handle_error (RygelMediaQueryAction* self, GError* _error_);
static void rygel_media_query_action_real_parse_args (RygelMediaQueryAction* self, GError** error);
GQuark rygel_content_directory_error_quark (void);
void rygel_client_hacks_filter_sort_criteria (RygelClientHacks* self, gchar** sort_criteria);
static void rygel_media_query_action_validate_sort_criteria (RygelMediaQueryAction* self, GError** error);
void rygel_client_hacks_translate_container_id (RygelClientHacks* self, RygelMediaQueryAction* action, gchar** container_id);
#define RYGEL_MEDIA_OBJECTS_SORT_CAPS "@id,@parentID,dc:title,upnp:class," "upnp:artist,upnp:author,upnp:album," "dc:date,upnp:originalTrackNumber"
static void rygel_media_query_action_fetch_media_object_data_free (gpointer _data);
static gboolean rygel_media_query_action_fetch_media_object_co (RygelMediaQueryActionFetchMediaObjectData* _data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_media_query_action_fetch_media_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_media_query_action_real_handle_error (RygelMediaQueryAction* self, GError* _error_);
static void rygel_media_query_action_finalize (GObject* obj);
static void _vala_rygel_media_query_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_query_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	return self ? g_object_ref (self) : NULL;
#line 333 "rygel-media-query-action.c"
}


RygelMediaQueryAction* rygel_media_query_action_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelMediaQueryAction * self = NULL;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelMediaContainer* _tmp2_;
	RygelContentDirectory* _tmp3_;
	RygelHTTPServer* _tmp4_;
	RygelHTTPServer* _tmp5_;
	RygelContentDirectory* _tmp6_;
	guint32 _tmp7_;
	RygelContentDirectory* _tmp8_;
	GCancellable* _tmp9_;
	GUPnPServiceAction* _tmp10_;
	GUPnPDIDLLiteWriter* _tmp11_;
	GError * _inner_error_ = NULL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	self = (RygelMediaQueryAction*) g_object_new (object_type, NULL);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp0_ = content_dir;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp1_ = _tmp0_->root_container;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_object_unref0 (self->root_container);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	self->root_container = _tmp2_;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp3_ = content_dir;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp4_ = _tmp3_->http_server;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_object_unref0 (self->http_server);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	self->http_server = _tmp5_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp6_ = content_dir;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp7_ = _tmp6_->system_update_id;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	self->system_update_id = _tmp7_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp8_ = content_dir;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp9_ = _tmp8_->cancellable;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp9_);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp10_ = action;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	action = NULL;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	self->action = _tmp10_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp11_ = gupnp_didl_lite_writer_new (NULL);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_object_unref0 (self->didl_writer);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	self->didl_writer = _tmp11_;
#line 402 "rygel-media-query-action.c"
	{
		GUPnPServiceAction* _tmp12_;
		SoupMessage* _tmp13_ = NULL;
		SoupMessage* _tmp14_;
		RygelClientHacks* _tmp15_ = NULL;
		RygelClientHacks* _tmp16_;
		RygelClientHacks* _tmp17_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp12_ = self->action;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp13_ = gupnp_service_action_get_message (_tmp12_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp14_ = _tmp13_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp15_ = rygel_client_hacks_create (_tmp14_, &_inner_error_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp16_ = _tmp15_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_g_object_unref0 (_tmp14_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp17_ = _tmp16_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		if (_inner_error_ != NULL) {
#line 426 "rygel-media-query-action.c"
			goto __catch43_g_error;
		}
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_g_object_unref0 (self->hacks);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		self->hacks = _tmp17_;
#line 433 "rygel-media-query-action.c"
	}
	goto __finally43;
	__catch43_g_error:
	{
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_clear_error (&_inner_error_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_inner_error_ = NULL;
#line 442 "rygel-media-query-action.c"
	}
	__finally43:
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	if (_inner_error_ != NULL) {
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_clear_error (&_inner_error_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		return NULL;
#line 453 "rygel-media-query-action.c"
	}
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	return self;
#line 457 "rygel-media-query-action.c"
}


static void rygel_media_query_action_real_run_data_free (gpointer _data) {
	RygelMediaQueryActionRunData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	g_slice_free (RygelMediaQueryActionRunData, _data_);
#line 468 "rygel-media-query-action.c"
}


static void rygel_media_query_action_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaQueryAction * self;
	RygelMediaQueryActionRunData* _data_;
	RygelMediaQueryAction* _tmp0_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	self = (RygelMediaQueryAction*) base;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_ = g_slice_new0 (RygelMediaQueryActionRunData);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_query_action_real_run);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_query_action_real_run_data_free);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	rygel_media_query_action_real_run_co (_data_);
#line 490 "rygel-media-query-action.c"
}


static void rygel_media_query_action_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelMediaQueryActionRunData* _data_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 498 "rygel-media-query-action.c"
}


static void rygel_media_query_action_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaQueryActionRunData* _data_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_ = _user_data_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_->_source_object_ = source_object;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_->_res_ = _res_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	rygel_media_query_action_real_run_co (_data_);
#line 512 "rygel-media-query-action.c"
}


static gboolean rygel_media_query_action_real_run_co (RygelMediaQueryActionRunData* _data_) {
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	switch (_data_->_state_) {
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		case 0:
#line 521 "rygel-media-query-action.c"
		goto _state_0;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		case 1:
#line 525 "rygel-media-query-action.c"
		goto _state_1;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		case 2:
#line 529 "rygel-media-query-action.c"
		goto _state_2;
		default:
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_assert_not_reached ();
#line 534 "rygel-media-query-action.c"
	}
	_state_0:
	{
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		rygel_media_query_action_parse_args (_data_->self, &_data_->_inner_error_);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		if (_data_->_inner_error_ != NULL) {
#line 542 "rygel-media-query-action.c"
			goto __catch44_g_error;
		}
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_state_ = 1;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		rygel_media_query_action_fetch_media_object (_data_->self, rygel_media_query_action_run_ready, _data_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		return FALSE;
#line 551 "rygel-media-query-action.c"
		_state_1:
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp0_ = NULL;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp0_ = rygel_media_query_action_fetch_media_object_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->media_object = _data_->_tmp0_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		if (_data_->_inner_error_ != NULL) {
#line 561 "rygel-media-query-action.c"
			goto __catch44_g_error;
		}
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp1_ = _data_->media_object;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_state_ = 2;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		rygel_media_query_action_fetch_results (_data_->self, _data_->_tmp1_, rygel_media_query_action_run_ready, _data_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		return FALSE;
#line 572 "rygel-media-query-action.c"
		_state_2:
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp2_ = NULL;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp2_ = rygel_media_query_action_fetch_results_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->results = _data_->_tmp2_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		if (_data_->_inner_error_ != NULL) {
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			_g_object_unref0 (_data_->media_object);
#line 584 "rygel-media-query-action.c"
			goto __catch44_g_error;
		}
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp3_ = _data_->results;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->self->number_returned = (guint) _data_->_tmp5_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp6_ = _data_->media_object;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp6_, RYGEL_TYPE_MEDIA_CONTAINER)) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			_data_->_tmp7_ = _data_->media_object;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			_data_->_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer)->update_id;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			_data_->self->update_id = (guint) _data_->_tmp8_;
#line 605 "rygel-media-query-action.c"
		} else {
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			_data_->_tmp9_ = G_MAXUINT32;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			_data_->self->update_id = (guint) _data_->_tmp9_;
#line 611 "rygel-media-query-action.c"
		}
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp10_ = _data_->results;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp11_ = _data_->self->didl_writer;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp12_ = _data_->self->http_server;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp13_ = _data_->self->hacks;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		rygel_media_objects_serialize (_data_->_tmp10_, _data_->_tmp11_, _data_->_tmp12_, _data_->_tmp13_, &_data_->_inner_error_);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		if (_data_->_inner_error_ != NULL) {
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			_g_object_unref0 (_data_->results);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			_g_object_unref0 (_data_->media_object);
#line 629 "rygel-media-query-action.c"
			goto __catch44_g_error;
		}
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		rygel_media_query_action_conclude (_data_->self);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_g_object_unref0 (_data_->results);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_g_object_unref0 (_data_->media_object);
#line 638 "rygel-media-query-action.c"
	}
	goto __finally44;
	__catch44_g_error:
	{
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->err = _data_->_inner_error_;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_inner_error_ = NULL;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp14_ = _data_->err;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		rygel_media_query_action_handle_error (_data_->self, _data_->_tmp14_);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_g_error_free0 (_data_->err);
#line 653 "rygel-media-query-action.c"
	}
	__finally44:
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	if (_data_->_inner_error_ != NULL) {
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_clear_error (&_data_->_inner_error_);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		return FALSE;
#line 664 "rygel-media-query-action.c"
	}
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	if (_data_->_state_ == 0) {
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 670 "rygel-media-query-action.c"
	} else {
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 674 "rygel-media-query-action.c"
	}
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	g_object_unref (_data_->_async_result);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	return FALSE;
#line 680 "rygel-media-query-action.c"
}


static void rygel_media_query_action_real_parse_args (RygelMediaQueryAction* self, GError** error) {
	gint64 index = 0LL;
	gint64 requested_count = 0LL;
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp5_ = FALSE;
	gint64 _tmp6_;
	gboolean _tmp8_;
	gint64 _tmp11_;
	gint64 _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp14_ = FALSE;
	RygelClientHacks* _tmp15_;
	gboolean _tmp17_;
	RygelClientHacks* _tmp19_;
	GError * _inner_error_ = NULL;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp0_ = self->action;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp1_ = self->object_id_arg;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	gupnp_service_action_get (_tmp0_, _tmp1_, G_TYPE_STRING, &self->object_id, "Filter", G_TYPE_STRING, &self->filter, "StartingIndex", G_TYPE_INT64, &index, "RequestedCount", G_TYPE_INT64, &requested_count, "SortCriteria", G_TYPE_STRING, &self->sort_criteria, NULL);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp2_ = self->object_id;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	if (_tmp2_ == NULL) {
#line 711 "rygel-media-query-action.c"
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp3_ = _ ("No such object");
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp4_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _tmp3_);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_inner_error_ = _tmp4_;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_propagate_error (error, _inner_error_);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		return;
#line 724 "rygel-media-query-action.c"
	}
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp6_ = index;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	if (_tmp6_ < ((gint64) 0)) {
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp5_ = TRUE;
#line 732 "rygel-media-query-action.c"
	} else {
		gint64 _tmp7_;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp7_ = requested_count;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp5_ = _tmp7_ < ((gint64) 0);
#line 739 "rygel-media-query-action.c"
	}
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp8_ = _tmp5_;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	if (_tmp8_) {
#line 745 "rygel-media-query-action.c"
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp9_ = _ ("Invalid range");
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp10_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _tmp9_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_inner_error_ = _tmp10_;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_propagate_error (error, _inner_error_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		return;
#line 758 "rygel-media-query-action.c"
	}
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp11_ = index;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	self->index = (guint) _tmp11_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp12_ = requested_count;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	self->requested_count = (guint) _tmp12_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp13_ = self->sort_criteria;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	if (g_strcmp0 (_tmp13_, "") == 0) {
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_g_free0 (self->sort_criteria);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		self->sort_criteria = NULL;
#line 776 "rygel-media-query-action.c"
	}
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp15_ = self->hacks;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	if (_tmp15_ != NULL) {
#line 782 "rygel-media-query-action.c"
		const gchar* _tmp16_;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp16_ = self->sort_criteria;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp14_ = _tmp16_ != NULL;
#line 788 "rygel-media-query-action.c"
	} else {
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp14_ = FALSE;
#line 792 "rygel-media-query-action.c"
	}
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp17_ = _tmp14_;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	if (_tmp17_) {
#line 798 "rygel-media-query-action.c"
		RygelClientHacks* _tmp18_;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp18_ = self->hacks;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		rygel_client_hacks_filter_sort_criteria (_tmp18_, &self->sort_criteria);
#line 804 "rygel-media-query-action.c"
	}
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	rygel_media_query_action_validate_sort_criteria (self, &_inner_error_);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	if (_inner_error_ != NULL) {
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_propagate_error (error, _inner_error_);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		return;
#line 814 "rygel-media-query-action.c"
	}
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp19_ = self->hacks;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	if (_tmp19_ != NULL) {
#line 820 "rygel-media-query-action.c"
		RygelClientHacks* _tmp20_;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp20_ = self->hacks;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		rygel_client_hacks_translate_container_id (_tmp20_, self, &self->object_id);
#line 826 "rygel-media-query-action.c"
	}
}


void rygel_media_query_action_parse_args (RygelMediaQueryAction* self, GError** error) {
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	g_return_if_fail (self != NULL);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->parse_args (self, error);
#line 836 "rygel-media-query-action.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1176 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1177 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1177 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1177 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1178 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1178 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 871 "rygel-media-query-action.c"
		glong _tmp3_;
		glong _tmp4_;
#line 1179 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1179 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1179 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 880 "rygel-media-query-action.c"
	}
#line 1181 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1181 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 886 "rygel-media-query-action.c"
		glong _tmp6_;
		glong _tmp7_;
#line 1182 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1182 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1182 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 895 "rygel-media-query-action.c"
	}
#line 1184 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1184 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 901 "rygel-media-query-action.c"
		glong _tmp10_;
		glong _tmp11_;
#line 1184 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1184 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1184 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 910 "rygel-media-query-action.c"
	} else {
#line 1184 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 914 "rygel-media-query-action.c"
	}
#line 1184 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1184 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1185 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1185 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 924 "rygel-media-query-action.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1185 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1185 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1185 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 933 "rygel-media-query-action.c"
	} else {
#line 1185 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 937 "rygel-media-query-action.c"
	}
#line 1185 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1185 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1186 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1186 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1186 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1187 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1187 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1187 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1187 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1187 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1187 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	return result;
#line 961 "rygel-media-query-action.c"
}


static void rygel_media_query_action_validate_sort_criteria (RygelMediaQueryAction* self, GError** error) {
	const gchar* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* supported_props;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** requested_sort_props;
	gint requested_sort_props_length1;
	gint _requested_sort_props_size_;
	gchar** _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GError * _inner_error_ = NULL;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	g_return_if_fail (self != NULL);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp0_ = self->sort_criteria;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	if (_tmp0_ == NULL) {
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		return;
#line 988 "rygel-media-query-action.c"
	}
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp1_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	supported_props = _tmp1_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp2_ = self->sort_criteria;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ",", 0);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	requested_sort_props = _tmp4_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	requested_sort_props_length1 = _vala_array_length (_tmp3_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_requested_sort_props_size_ = requested_sort_props_length1;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp6_ = _tmp5_ = g_strsplit (RYGEL_MEDIA_OBJECTS_SORT_CAPS, ",", 0);
#line 1006 "rygel-media-query-action.c"
	{
		gchar** property_collection = NULL;
		gint property_collection_length1 = 0;
		gint _property_collection_size_ = 0;
		gint property_it = 0;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		property_collection = _tmp6_;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		property_collection_length1 = _vala_array_length (_tmp5_);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		for (property_it = 0; property_it < _vala_array_length (_tmp5_); property_it = property_it + 1) {
#line 1018 "rygel-media-query-action.c"
			gchar* _tmp7_;
			gchar* property = NULL;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			_tmp7_ = g_strdup (property_collection[property_it]);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			property = _tmp7_;
#line 1025 "rygel-media-query-action.c"
			{
				GeeHashSet* _tmp8_;
				const gchar* _tmp9_;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				_tmp8_ = supported_props;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				_tmp9_ = property;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				_g_free0 (property);
#line 1037 "rygel-media-query-action.c"
			}
		}
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		property_collection = (_vala_array_free (property_collection, property_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1042 "rygel-media-query-action.c"
	}
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp10_ = requested_sort_props;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp10__length1 = requested_sort_props_length1;
#line 1048 "rygel-media-query-action.c"
	{
		gchar** property_collection = NULL;
		gint property_collection_length1 = 0;
		gint _property_collection_size_ = 0;
		gint property_it = 0;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		property_collection = _tmp10_;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		property_collection_length1 = _tmp10__length1;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		for (property_it = 0; property_it < _tmp10__length1; property_it = property_it + 1) {
#line 1060 "rygel-media-query-action.c"
			gchar* _tmp11_;
			gchar* property = NULL;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			_tmp11_ = g_strdup (property_collection[property_it]);
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			property = _tmp11_;
#line 1067 "rygel-media-query-action.c"
			{
				gboolean _tmp12_ = FALSE;
				const gchar* _tmp13_;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp17_;
				GeeHashSet* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_;
				gboolean _tmp27_ = FALSE;
				gboolean _tmp28_;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				_tmp13_ = property;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				_tmp14_ = g_str_has_prefix (_tmp13_, "+");
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				if (_tmp14_) {
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					_tmp12_ = TRUE;
#line 1090 "rygel-media-query-action.c"
				} else {
					const gchar* _tmp15_;
					gboolean _tmp16_ = FALSE;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					_tmp15_ = property;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					_tmp16_ = g_str_has_prefix (_tmp15_, "-");
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					_tmp12_ = _tmp16_;
#line 1100 "rygel-media-query-action.c"
				}
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				_tmp17_ = _tmp12_;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				if (!_tmp17_) {
#line 1106 "rygel-media-query-action.c"
					const gchar* _tmp18_;
					GError* _tmp19_;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					_tmp18_ = property;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					_tmp19_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA, "%s is missing + or - modifier", _tmp18_);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					_inner_error_ = _tmp19_;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					g_propagate_error (error, _inner_error_);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					_g_free0 (property);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					requested_sort_props = (_vala_array_free (requested_sort_props, requested_sort_props_length1, (GDestroyNotify) g_free), NULL);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					_g_object_unref0 (supported_props);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					return;
#line 1125 "rygel-media-query-action.c"
				}
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				_tmp20_ = supported_props;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				_tmp21_ = property;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				_tmp22_ = property;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				_tmp23_ = strlen (_tmp22_);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				_tmp24_ = _tmp23_;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				_tmp25_ = string_slice (_tmp21_, (glong) 1, (glong) _tmp24_);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				_tmp26_ = _tmp25_;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				_tmp27_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp20_, _tmp26_);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				_tmp28_ = !_tmp27_;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				_g_free0 (_tmp26_);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				if (_tmp28_) {
#line 1149 "rygel-media-query-action.c"
					const gchar* _tmp29_;
					GError* _tmp30_;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					_tmp29_ = property;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					_tmp30_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA, "%s is invalid or not supported", _tmp29_);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					_inner_error_ = _tmp30_;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					g_propagate_error (error, _inner_error_);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					_g_free0 (property);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					requested_sort_props = (_vala_array_free (requested_sort_props, requested_sort_props_length1, (GDestroyNotify) g_free), NULL);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					_g_object_unref0 (supported_props);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
					return;
#line 1168 "rygel-media-query-action.c"
				}
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				_g_free0 (property);
#line 1172 "rygel-media-query-action.c"
			}
		}
	}
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	requested_sort_props = (_vala_array_free (requested_sort_props, requested_sort_props_length1, (GDestroyNotify) g_free), NULL);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_object_unref0 (supported_props);
#line 1180 "rygel-media-query-action.c"
}


void rygel_media_query_action_fetch_results (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->fetch_results (self, media_object, _callback_, _user_data_);
#line 1187 "rygel-media-query-action.c"
}


RygelMediaObjects* rygel_media_query_action_fetch_results_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	return RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->fetch_results_finish (self, _res_, error);
#line 1194 "rygel-media-query-action.c"
}


static void rygel_media_query_action_fetch_media_object_data_free (gpointer _data) {
	RygelMediaQueryActionFetchMediaObjectData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_object_unref0 (_data_->result);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	g_slice_free (RygelMediaQueryActionFetchMediaObjectData, _data_);
#line 1207 "rygel-media-query-action.c"
}


static void rygel_media_query_action_fetch_media_object (RygelMediaQueryAction* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaQueryActionFetchMediaObjectData* _data_;
	RygelMediaQueryAction* _tmp0_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_ = g_slice_new0 (RygelMediaQueryActionFetchMediaObjectData);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_query_action_fetch_media_object);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_query_action_fetch_media_object_data_free);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	rygel_media_query_action_fetch_media_object_co (_data_);
#line 1226 "rygel-media-query-action.c"
}


static RygelMediaObject* rygel_media_query_action_fetch_media_object_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaQueryActionFetchMediaObjectData* _data_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		return NULL;
#line 1237 "rygel-media-query-action.c"
	}
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_->result = NULL;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	return result;
#line 1247 "rygel-media-query-action.c"
}


static void rygel_media_query_action_fetch_media_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaQueryActionFetchMediaObjectData* _data_;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_ = _user_data_;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_->_source_object_ = source_object;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_->_res_ = _res_;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	rygel_media_query_action_fetch_media_object_co (_data_);
#line 1261 "rygel-media-query-action.c"
}


static gboolean rygel_media_query_action_fetch_media_object_co (RygelMediaQueryActionFetchMediaObjectData* _data_) {
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	switch (_data_->_state_) {
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		case 0:
#line 1270 "rygel-media-query-action.c"
		goto _state_0;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		case 1:
#line 1274 "rygel-media-query-action.c"
		goto _state_1;
		default:
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_assert_not_reached ();
#line 1279 "rygel-media-query-action.c"
	}
	_state_0:
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_->_tmp0_ = _data_->self->object_id;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_->_tmp1_ = _data_->self->root_container;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_data_->_tmp2_ = ((RygelMediaObject*) _data_->_tmp1_)->id;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	if (g_strcmp0 (_data_->_tmp0_, _data_->_tmp2_) == 0) {
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp3_ = _data_->self->root_container;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp4_ = _g_object_ref0 ((RygelMediaObject*) _data_->_tmp3_);
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->result = _data_->_tmp4_;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		if (_data_->_state_ == 0) {
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1300 "rygel-media-query-action.c"
		} else {
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1304 "rygel-media-query-action.c"
		}
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_object_unref (_data_->_async_result);
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		return FALSE;
#line 1310 "rygel-media-query-action.c"
	} else {
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp5_ = _data_->self->object_id;
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_debug ("rygel-media-query-action.vala:177: searching for object '%s'..", _data_->_tmp5_);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp6_ = _data_->self->root_container;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp7_ = _data_->self->object_id;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp8_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_state_ = 1;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		rygel_media_container_find_object (_data_->_tmp6_, _data_->_tmp7_, _data_->_tmp9_, rygel_media_query_action_fetch_media_object_ready, _data_);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		return FALSE;
#line 1330 "rygel-media-query-action.c"
		_state_1:
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp10_ = NULL;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp10_ = rygel_media_container_find_object_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->media_object = _data_->_tmp10_;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		if (_data_->_inner_error_ != NULL) {
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			g_error_free (_data_->_inner_error_);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			if (_data_->_state_ == 0) {
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1348 "rygel-media-query-action.c"
			} else {
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1352 "rygel-media-query-action.c"
			}
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			g_object_unref (_data_->_async_result);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			return FALSE;
#line 1358 "rygel-media-query-action.c"
		}
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp11_ = _data_->media_object;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		if (_data_->_tmp11_ == NULL) {
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			_data_->_tmp12_ = NULL;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			_data_->_tmp12_ = _ ("No such object");
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			_data_->_tmp13_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp12_);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			_data_->_inner_error_ = _data_->_tmp13_;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			g_error_free (_data_->_inner_error_);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			_g_object_unref0 (_data_->media_object);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			if (_data_->_state_ == 0) {
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1382 "rygel-media-query-action.c"
			} else {
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1386 "rygel-media-query-action.c"
			}
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			g_object_unref (_data_->_async_result);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			return FALSE;
#line 1392 "rygel-media-query-action.c"
		}
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->_tmp14_ = _data_->self->object_id;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_debug ("rygel-media-query-action.vala:184: object '%s' found.", _data_->_tmp14_);
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_data_->result = _data_->media_object;
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		if (_data_->_state_ == 0) {
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1404 "rygel-media-query-action.c"
		} else {
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1408 "rygel-media-query-action.c"
		}
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_object_unref (_data_->_async_result);
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		return FALSE;
#line 1414 "rygel-media-query-action.c"
	}
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	if (_data_->_state_ == 0) {
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1420 "rygel-media-query-action.c"
	} else {
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1424 "rygel-media-query-action.c"
	}
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	g_object_unref (_data_->_async_result);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	return FALSE;
#line 1430 "rygel-media-query-action.c"
}


static void rygel_media_query_action_conclude (RygelMediaQueryAction* self) {
	GUPnPDIDLLiteWriter* _tmp0_;
	const gchar* _tmp1_;
	GUPnPDIDLLiteWriter* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* didl;
	guint _tmp4_;
	guint32 _tmp5_;
	GUPnPServiceAction* _tmp7_;
	const gchar* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	GUPnPServiceAction* _tmp12_;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	g_return_if_fail (self != NULL);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp0_ = self->didl_writer;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp1_ = self->filter;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	gupnp_didl_lite_writer_filter (_tmp0_, _tmp1_);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp2_ = self->didl_writer;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp3_ = gupnp_didl_lite_writer_get_string (_tmp2_);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	didl = _tmp3_;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp4_ = self->update_id;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp5_ = G_MAXUINT32;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	if (_tmp4_ == ((guint) _tmp5_)) {
#line 1468 "rygel-media-query-action.c"
		guint32 _tmp6_;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp6_ = self->system_update_id;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		self->update_id = (guint) _tmp6_;
#line 1474 "rygel-media-query-action.c"
	}
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp7_ = self->action;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp8_ = didl;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp9_ = self->number_returned;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp10_ = self->total_matches;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp11_ = self->update_id;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	gupnp_service_action_set (_tmp7_, "Result", G_TYPE_STRING, _tmp8_, "NumberReturned", G_TYPE_UINT, _tmp9_, "TotalMatches", G_TYPE_UINT, _tmp10_, "UpdateID", G_TYPE_UINT, _tmp11_, NULL);
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp12_ = self->action;
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	gupnp_service_action_return (_tmp12_);
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_free0 (didl);
#line 1496 "rygel-media-query-action.c"
}


static void rygel_media_query_action_real_handle_error (RygelMediaQueryAction* self, GError* _error_) {
	GError* _tmp0_;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp0_ = _error_;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	if (_tmp0_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
#line 1506 "rygel-media-query-action.c"
		GUPnPServiceAction* _tmp1_;
		GError* _tmp2_;
		gint _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp1_ = self->action;
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp2_ = _error_;
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp3_ = _tmp2_->code;
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp4_ = _error_;
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp5_ = _tmp4_->message;
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		gupnp_service_action_return_error (_tmp1_, (guint) _tmp3_, _tmp5_);
#line 1524 "rygel-media-query-action.c"
	} else {
		GUPnPServiceAction* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp6_ = self->action;
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp7_ = _error_;
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		_tmp8_ = _tmp7_->message;
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		gupnp_service_action_return_error (_tmp6_, (guint) 701, _tmp8_);
#line 1537 "rygel-media-query-action.c"
	}
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 1541 "rygel-media-query-action.c"
}


void rygel_media_query_action_handle_error (RygelMediaQueryAction* self, GError* _error_) {
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	g_return_if_fail (self != NULL);
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->handle_error (self, _error_);
#line 1550 "rygel-media-query-action.c"
}


static GCancellable* rygel_media_query_action_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelMediaQueryAction* self;
	GCancellable* _tmp0_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	self = (RygelMediaQueryAction*) base;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp0_ = self->priv->_cancellable;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	result = _tmp0_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	return result;
#line 1566 "rygel-media-query-action.c"
}


static void rygel_media_query_action_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelMediaQueryAction* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	self = (RygelMediaQueryAction*) base;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp0_ = value;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	self->priv->_cancellable = _tmp1_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 1586 "rygel-media-query-action.c"
}


static void rygel_media_query_action_class_init (RygelMediaQueryActionClass * klass) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	rygel_media_query_action_parent_class = g_type_class_peek_parent (klass);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaQueryActionPrivate));
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	RYGEL_MEDIA_QUERY_ACTION_CLASS (klass)->parse_args = rygel_media_query_action_real_parse_args;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	RYGEL_MEDIA_QUERY_ACTION_CLASS (klass)->handle_error = rygel_media_query_action_real_handle_error;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_query_action_get_property;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_query_action_set_property;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_query_action_finalize;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1607 "rygel-media-query-action.c"
}


static void rygel_media_query_action_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	rygel_media_query_action_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_media_query_action_real_run;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	iface->run_finish = rygel_media_query_action_real_run_finish;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	iface->get_cancellable = rygel_media_query_action_real_get_cancellable;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	iface->set_cancellable = rygel_media_query_action_real_set_cancellable;
#line 1622 "rygel-media-query-action.c"
}


static void rygel_media_query_action_instance_init (RygelMediaQueryAction * self) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	self->priv = RYGEL_MEDIA_QUERY_ACTION_GET_PRIVATE (self);
#line 1629 "rygel-media-query-action.c"
}


static void rygel_media_query_action_finalize (GObject* obj) {
	RygelMediaQueryAction * self;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_free0 (self->object_id);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_free0 (self->browse_flag);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_free0 (self->filter);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_free0 (self->sort_criteria);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_object_unref0 (self->root_container);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_object_unref0 (self->http_server);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_object_unref0 (self->didl_writer);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_object_unref0 (self->hacks);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	_g_free0 (self->object_id_arg);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	G_OBJECT_CLASS (rygel_media_query_action_parent_class)->finalize (obj);
#line 1659 "rygel-media-query-action.c"
}


/**
 * Base class of Browse and Search actions.
 */
GType rygel_media_query_action_get_type (void) {
	static volatile gsize rygel_media_query_action_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_query_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaQueryActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_query_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaQueryAction), 0, (GInstanceInitFunc) rygel_media_query_action_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_media_query_action_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_media_query_action_type_id;
		rygel_media_query_action_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaQueryAction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (rygel_media_query_action_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_media_query_action_type_id__volatile, rygel_media_query_action_type_id);
	}
	return rygel_media_query_action_type_id__volatile;
}


static void _vala_rygel_media_query_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaQueryAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		case RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE:
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		break;
#line 1691 "rygel-media-query-action.c"
		default:
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		break;
#line 1697 "rygel-media-query-action.c"
	}
}


static void _vala_rygel_media_query_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaQueryAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		case RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE:
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		break;
#line 1713 "rygel-media-query-action.c"
		default:
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-media-query-action.vala"
		break;
#line 1719 "rygel-media-query-action.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



