/* rygel-av-transport.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-av-transport.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010 Nokia Corporation.
 * Copyright (C) 2012 Openismus GmbH.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <float.h>
#include <math.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_AV_TRANSPORT (rygel_av_transport_get_type ())
#define RYGEL_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport))
#define RYGEL_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))
#define RYGEL_IS_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_IS_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_AV_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))

typedef struct _RygelAVTransport RygelAVTransport;
typedef struct _RygelAVTransportClass RygelAVTransportClass;
typedef struct _RygelAVTransportPrivate RygelAVTransportPrivate;

#define RYGEL_TYPE_CHANGE_LOG (rygel_change_log_get_type ())
#define RYGEL_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLog))
#define RYGEL_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))
#define RYGEL_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))

typedef struct _RygelChangeLog RygelChangeLog;
typedef struct _RygelChangeLogClass RygelChangeLogClass;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;
typedef struct _Block1Data Block1Data;

struct _RygelAVTransport {
	GUPnPService parent_instance;
	RygelAVTransportPrivate * priv;
};

struct _RygelAVTransportClass {
	GUPnPServiceClass parent_class;
};

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, GstClockTime time);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
};

struct _RygelAVTransportPrivate {
	SoupSession* session;
	guint _n_tracks;
	guint _track;
	gchar* _metadata;
	gchar* _status;
	gchar* _speed;
	gchar* _mode;
	RygelChangeLog* changelog;
	RygelMediaPlayer* player;
};

struct _Block1Data {
	int _ref_count_;
	RygelAVTransport * self;
	gchar* _uri;
	gchar* _metadata;
	GUPnPServiceAction* action;
};


static gpointer rygel_av_transport_parent_class = NULL;

GType rygel_av_transport_get_type (void) G_GNUC_CONST;
GType rygel_change_log_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
#define RYGEL_AV_TRANSPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportPrivate))
enum  {
	RYGEL_AV_TRANSPORT_DUMMY_PROPERTY,
	RYGEL_AV_TRANSPORT_N_TRACKS,
	RYGEL_AV_TRANSPORT_TRACK,
	RYGEL_AV_TRANSPORT_METADATA,
	RYGEL_AV_TRANSPORT_URI,
	RYGEL_AV_TRANSPORT_STATUS,
	RYGEL_AV_TRANSPORT_SPEED,
	RYGEL_AV_TRANSPORT_MODE
};
#define RYGEL_AV_TRANSPORT_UPNP_ID "urn:upnp-org:serviceId:AVTransport"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE "urn:schemas-upnp-org:service:AVTransport:2"
#define RYGEL_AV_TRANSPORT_DESCRIPTION_PATH "xml/AVTransport2.xml"
#define RYGEL_AV_TRANSPORT_LAST_CHANGE_NS "urn:schemas-upnp-org:metadata-1-0/AVT/"
static void rygel_av_transport_real_constructed (GObject* base);
RygelChangeLog* rygel_change_log_new (GUPnPService* service, const gchar* service_ns);
RygelChangeLog* rygel_change_log_construct (GType object_type, GUPnPService* service, const gchar* service_ns);
static RygelMediaPlayer* rygel_av_transport_get_player (RygelAVTransport* self);
static void rygel_av_transport_query_last_change_cb (RygelAVTransport* self, GUPnPService* service, const gchar* variable, GValue* value);
static void _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_media_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_media_info_ex_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_stop_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_play_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_pause_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_seek_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_next_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_previous_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_notify_state_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_duration_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_uri_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self);
void rygel_change_log_log (RygelChangeLog* self, const gchar* variable, const gchar* value);
gchar* rygel_media_player_get_playback_state (RygelMediaPlayer* self);
const gchar* rygel_av_transport_get_status (RygelAVTransport* self);
const gchar* rygel_av_transport_get_mode (RygelAVTransport* self);
const gchar* rygel_av_transport_get_speed (RygelAVTransport* self);
guint rygel_av_transport_get_n_tracks (RygelAVTransport* self);
guint rygel_av_transport_get_track (RygelAVTransport* self);
gchar* rygel_media_player_get_duration_as_str (RygelMediaPlayer* self);
gchar* rygel_av_transport_get_metadata (RygelAVTransport* self);
gchar* rygel_av_transport_get_uri (RygelAVTransport* self);
gchar* rygel_change_log_finish (RygelChangeLog* self);
static gboolean rygel_av_transport_check_instance_id (RygelAVTransport* self, GUPnPServiceAction* action);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda2_ (Block1Data* _data1_, SoupMessage* msg);
gchar** rygel_media_player_get_mime_types (RygelMediaPlayer* self, int* result_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
void rygel_media_player_set_mime_type (RygelMediaPlayer* self, const gchar* value);
void rygel_media_player_set_content_features (RygelMediaPlayer* self, const gchar* value);
void rygel_av_transport_set_metadata (RygelAVTransport* self, const gchar* value);
void rygel_av_transport_set_uri (RygelAVTransport* self, const gchar* value);
void rygel_av_transport_set_n_tracks (RygelAVTransport* self, guint value);
static void ____lambda2__soup_message_finished (SoupMessage* _sender, gpointer self);
gchar* rygel_media_player_get_position_as_str (RygelMediaPlayer* self);
void rygel_media_player_set_playback_state (RygelMediaPlayer* self, const gchar* value);
gboolean rygel_media_player_seek (RygelMediaPlayer* self, GstClockTime time);
GstClockTime rygel_gst_utils_time_from_string (const gchar* str);
gchar* rygel_media_player_get_metadata (RygelMediaPlayer* self);
RygelAVTransport* rygel_av_transport_new (void);
RygelAVTransport* rygel_av_transport_construct (GType object_type);
void rygel_av_transport_set_track (RygelAVTransport* self, guint value);
void rygel_media_player_set_metadata (RygelMediaPlayer* self, const gchar* value);
gchar* rygel_media_player_get_uri (RygelMediaPlayer* self);
void rygel_media_player_set_uri (RygelMediaPlayer* self, const gchar* value);
void rygel_av_transport_set_status (RygelAVTransport* self, const gchar* value);
void rygel_av_transport_set_speed (RygelAVTransport* self, const gchar* value);
void rygel_av_transport_set_mode (RygelAVTransport* self, const gchar* value);
static void rygel_av_transport_finalize (GObject* obj);
static void _vala_rygel_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_query_last_change_cb (self, _sender, variable, value);
#line 245 "rygel-av-transport.c"
}


static void _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 144 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_set_av_transport_uri_cb (self, _sender, action);
#line 252 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_media_info_cb (self, _sender, action);
#line 259 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_media_info_ex_cb (self, _sender, action);
#line 266 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_transport_info_cb (self, _sender, action);
#line 273 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_position_info_cb (self, _sender, action);
#line 280 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_device_capabilities_cb (self, _sender, action);
#line 287 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_transport_settings_cb (self, _sender, action);
#line 294 "rygel-av-transport.c"
}


static void _rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 154 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_stop_cb (self, _sender, action);
#line 301 "rygel-av-transport.c"
}


static void _rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_play_cb (self, _sender, action);
#line 308 "rygel-av-transport.c"
}


static void _rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_pause_cb (self, _sender, action);
#line 315 "rygel-av-transport.c"
}


static void _rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 157 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_seek_cb (self, _sender, action);
#line 322 "rygel-av-transport.c"
}


static void _rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_next_cb (self, _sender, action);
#line 329 "rygel-av-transport.c"
}


static void _rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 159 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_previous_cb (self, _sender, action);
#line 336 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_state_cb (self, _sender, pspec);
#line 343 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_duration_cb (self, _sender, pspec);
#line 350 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_uri_cb (self, _sender, pspec);
#line 357 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_meta_data_cb (self, _sender, pspec);
#line 364 "rygel-av-transport.c"
}


static void rygel_av_transport_real_constructed (GObject* base) {
	RygelAVTransport * self;
	RygelChangeLog* _tmp0_;
	RygelMediaPlayer* _tmp1_ = NULL;
	RygelMediaPlayer* _tmp2_;
	RygelMediaPlayer* _tmp3_;
	RygelMediaPlayer* _tmp4_;
	RygelMediaPlayer* _tmp5_;
	SoupSessionAsync* _tmp6_;
#line 138 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self = (RygelAVTransport*) base;
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = rygel_change_log_new ((GUPnPService*) self, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS);
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->changelog);
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->changelog = _tmp0_;
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_get_player (self);
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->player);
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->player = _tmp1_;
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable, self, 0);
#line 144 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetAVTransportURI", (GCallback) _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked, self, 0);
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMediaInfo", (GCallback) _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked, self, 0);
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMediaInfo_Ext", (GCallback) _rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked, self, 0);
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportInfo", (GCallback) _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked, self, 0);
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetPositionInfo", (GCallback) _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked, self, 0);
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetDeviceCapabilities", (GCallback) _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked, self, 0);
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportSettings", (GCallback) _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked, self, 0);
#line 154 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Stop", (GCallback) _rygel_av_transport_stop_cb_gupnp_service_action_invoked, self, 0);
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Play", (GCallback) _rygel_av_transport_play_cb_gupnp_service_action_invoked, self, 0);
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Pause", (GCallback) _rygel_av_transport_pause_cb_gupnp_service_action_invoked, self, 0);
#line 157 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Seek", (GCallback) _rygel_av_transport_seek_cb_gupnp_service_action_invoked, self, 0);
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Next", (GCallback) _rygel_av_transport_next_cb_gupnp_service_action_invoked, self, 0);
#line 159 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Previous", (GCallback) _rygel_av_transport_previous_cb_gupnp_service_action_invoked, self, 0);
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->player;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp2_, "notify::playback-state", (GCallback) _rygel_av_transport_notify_state_cb_g_object_notify, self, 0);
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->player;
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp3_, "notify::duration", (GCallback) _rygel_av_transport_notify_duration_cb_g_object_notify, self, 0);
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = self->priv->player;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp4_, "notify::uri", (GCallback) _rygel_av_transport_notify_uri_cb_g_object_notify, self, 0);
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = self->priv->player;
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp5_, "notify::metadata", (GCallback) _rygel_av_transport_notify_meta_data_cb_g_object_notify, self, 0);
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = (SoupSessionAsync*) soup_session_async_new ();
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->session);
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->session = (SoupSession*) _tmp6_;
#line 441 "rygel-av-transport.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return self ? g_object_ref (self) : NULL;
#line 448 "rygel-av-transport.c"
}


static RygelMediaPlayer* rygel_av_transport_get_player (RygelAVTransport* self) {
	RygelMediaPlayer* result = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_;
	GUPnPRootDevice* _tmp2_;
	GUPnPResourceFactory* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	RygelMediaRendererPlugin* _tmp5_;
	RygelMediaRendererPlugin* _tmp6_;
	RygelMediaRendererPlugin* plugin;
	RygelMediaPlayer* _tmp7_ = NULL;
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = _tmp0_;
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN) ? ((RygelMediaRendererPlugin*) _tmp4_) : NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (_tmp2_);
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	plugin = _tmp6_;
#line 172 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = rygel_media_renderer_plugin_get_player (plugin);
#line 172 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp7_;
#line 172 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (plugin);
#line 172 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 491 "rygel-av-transport.c"
}


static void rygel_av_transport_query_last_change_cb (RygelAVTransport* self, GUPnPService* service, const gchar* variable, GValue* value) {
	RygelChangeLog* _tmp0_;
	RygelChangeLog* log;
	RygelMediaPlayer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	guint _tmp15_;
	guint _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	RygelMediaPlayer* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	RygelMediaPlayer* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_;
#line 175 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 175 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 175 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (variable != NULL);
#line 175 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (value != NULL);
#line 179 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = rygel_change_log_new (NULL, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS);
#line 179 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	log = _tmp0_;
#line 181 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->player;
#line 181 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_media_player_get_playback_state (_tmp1_);
#line 181 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 181 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 181 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "TransportState", _tmp4_);
#line 181 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 182 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = rygel_av_transport_get_status (self);
#line 182 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 182 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "TransportStatus", _tmp6_);
#line 183 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "PlaybackStorageMedium", "NOT_IMPLEMENTED");
#line 184 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "RecordStorageMedium", "NOT_IMPLEMENTED");
#line 185 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "PossiblePlaybackStorageMedia", "NOT_IMPLEMENTED");
#line 186 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "PossibleRecordStorageMedia", "NOT_IMPLEMENTED");
#line 187 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = rygel_av_transport_get_mode (self);
#line 187 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 187 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentPlayMode", _tmp8_);
#line 188 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = rygel_av_transport_get_speed (self);
#line 188 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = _tmp9_;
#line 188 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "TransportPlaySpeed", _tmp10_);
#line 189 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "RecordMediumWriteStatus", "NOT_IMPLEMENTED");
#line 190 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentRecordQualityMode", "NOT_IMPLEMENTED");
#line 191 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "PossibleRecordQualityMode", "NOT_IMPLEMENTED");
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = rygel_av_transport_get_n_tracks (self);
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = _tmp11_;
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp13_ = g_strdup_printf ("%u", _tmp12_);
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp14_ = _tmp13_;
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "NumberOfTracks", _tmp14_);
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp14_);
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp15_ = rygel_av_transport_get_track (self);
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp16_ = _tmp15_;
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp17_ = g_strdup_printf ("%u", _tmp16_);
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp18_ = _tmp17_;
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrack", _tmp18_);
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp18_);
#line 194 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp19_ = self->priv->player;
#line 194 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp20_ = rygel_media_player_get_duration_as_str (_tmp19_);
#line 194 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp21_ = _tmp20_;
#line 194 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp22_ = _tmp21_;
#line 194 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrackDuration", _tmp22_);
#line 194 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp22_);
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp23_ = self->priv->player;
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp24_ = rygel_media_player_get_duration_as_str (_tmp23_);
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp25_ = _tmp24_;
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp26_ = _tmp25_;
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentMediaDuration", _tmp26_);
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp26_);
#line 196 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp27_ = rygel_av_transport_get_metadata (self);
#line 196 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp28_ = _tmp27_;
#line 196 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp29_ = _tmp28_;
#line 196 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrackMetaData", _tmp29_);
#line 196 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp29_);
#line 197 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp30_ = rygel_av_transport_get_metadata (self);
#line 197 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp31_ = _tmp30_;
#line 197 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp32_ = _tmp31_;
#line 197 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "AVTransportURIMetaData", _tmp32_);
#line 197 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp32_);
#line 198 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp33_ = rygel_av_transport_get_uri (self);
#line 198 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp34_ = _tmp33_;
#line 198 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp35_ = _tmp34_;
#line 198 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrackURI", _tmp35_);
#line 198 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp35_);
#line 199 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp36_ = rygel_av_transport_get_uri (self);
#line 199 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp37_ = _tmp36_;
#line 199 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp38_ = _tmp37_;
#line 199 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "AVTransportURI", _tmp38_);
#line 199 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp38_);
#line 200 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "NextAVTransportURI", "NOT_IMPLEMENTED");
#line 201 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "NextAVTransportURIMetaData", "NOT_IMPLEMENTED");
#line 203 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_value_init (value, G_TYPE_STRING);
#line 204 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp39_ = rygel_change_log_finish (log);
#line 204 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp40_ = _tmp39_;
#line 204 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_value_set_string (value, _tmp40_);
#line 204 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp40_);
#line 175 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (log);
#line 698 "rygel-av-transport.c"
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
#line 596 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, FALSE);
#line 598 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 598 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
#line 598 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	endptr = _tmp1_;
#line 598 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_vala_result = _tmp2_;
#line 599 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = endptr;
#line 599 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp4_ = str;
#line 599 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp5_ = str;
#line 599 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp6_ = strlen (_tmp5_);
#line 599 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp7_ = _tmp6_;
#line 599 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
#line 600 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = TRUE;
#line 600 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		if (_result_) {
#line 600 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			*_result_ = _vala_result;
#line 742 "rygel-av-transport.c"
		}
#line 600 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 746 "rygel-av-transport.c"
	} else {
#line 602 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = FALSE;
#line 602 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		if (_result_) {
#line 602 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			*_result_ = _vala_result;
#line 754 "rygel-av-transport.c"
		}
#line 602 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 758 "rygel-av-transport.c"
	}
#line 596 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_result_) {
#line 596 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		*_result_ = _vala_result;
#line 764 "rygel-av-transport.c"
	}
}


static gboolean rygel_av_transport_check_instance_id (RygelAVTransport* self, GUPnPServiceAction* action) {
	gboolean result = FALSE;
	gchar* instance_id_string = NULL;
	gint64 instance_id;
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp6_;
	gint64 _tmp9_;
#line 208 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 208 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (action != NULL, FALSE);
#line 210 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	instance_id = (gint64) (-1);
#line 212 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 212 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp0_, "InstanceID", G_TYPE_STRING, &instance_id_string, NULL);
#line 213 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = instance_id_string;
#line 213 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp2_ == NULL) {
#line 213 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp1_ = TRUE;
#line 794 "rygel-av-transport.c"
	} else {
		const gchar* _tmp3_;
		gint64 _tmp4_ = 0LL;
		gboolean _tmp5_ = FALSE;
#line 214 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp3_ = instance_id_string;
#line 214 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp5_ = int64_try_parse (_tmp3_, &_tmp4_);
#line 214 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		instance_id = _tmp4_;
#line 214 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp1_ = !_tmp5_;
#line 807 "rygel-av-transport.c"
	}
#line 213 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp1_;
#line 213 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp6_) {
#line 813 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp7_;
		const gchar* _tmp8_ = NULL;
#line 215 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = action;
#line 215 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp8_ = _ ("Invalid argument");
#line 215 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp7_, (guint) 402, _tmp8_);
#line 217 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		result = FALSE;
#line 217 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (instance_id_string);
#line 217 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return result;
#line 828 "rygel-av-transport.c"
	}
#line 220 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = instance_id;
#line 220 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp9_ != ((gint64) 0)) {
#line 834 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp10_;
		const gchar* _tmp11_ = NULL;
#line 221 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp10_ = action;
#line 221 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp11_ = _ ("Invalid InstanceID");
#line 221 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp10_, (guint) 718, _tmp11_);
#line 223 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		result = FALSE;
#line 223 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (instance_id_string);
#line 223 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return result;
#line 849 "rygel-av-transport.c"
	}
#line 226 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = TRUE;
#line 226 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (instance_id_string);
#line 226 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 857 "rygel-av-transport.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return _data1_;
#line 866 "rygel-av-transport.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 875 "rygel-av-transport.c"
		RygelAVTransport * self;
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		self = _data1_->self;
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (_data1_->_metadata);
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (_data1_->_uri);
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (self);
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_slice_free (Block1Data, _data1_);
#line 887 "rygel-av-transport.c"
	}
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	for (i = 0; i < stack_length; i++) {
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			return TRUE;
#line 900 "rygel-av-transport.c"
		}
	}
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return FALSE;
#line 905 "rygel-av-transport.c"
}


static void ___lambda2_ (Block1Data* _data1_, SoupMessage* msg) {
	RygelAVTransport * self;
	SoupMessage* _tmp0_;
	guint _tmp1_ = 0U;
	guint _tmp2_;
#line 248 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self = _data1_->self;
#line 248 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (msg != NULL);
#line 249 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = msg;
#line 249 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_get (_tmp0_, "status-code", &_tmp1_, NULL);
#line 249 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 249 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp2_ != ((guint) SOUP_STATUS_OK)) {
#line 926 "rygel-av-transport.c"
		const gchar* _tmp3_;
		SoupMessage* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GUPnPServiceAction* _tmp8_;
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp3_ = _data1_->_uri;
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp4_ = msg;
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_object_get (_tmp4_, "reason-phrase", &_tmp5_, NULL);
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = _tmp5_;
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = _tmp6_;
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_warning ("rygel-av-transport.vala:250: Failed to access %s: %s", _tmp3_, _tmp7_);
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (_tmp7_);
#line 254 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp8_ = _data1_->action;
#line 254 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp8_, (guint) 716, "Resource not found");
#line 256 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 953 "rygel-av-transport.c"
	} else {
		SoupMessage* _tmp9_;
		SoupMessageHeaders* _tmp10_;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* mime;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		gboolean _tmp20_;
		RygelMediaPlayer* _tmp22_;
		const gchar* _tmp23_;
		SoupMessage* _tmp24_;
		SoupMessageHeaders* _tmp25_;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		gchar* features;
		const gchar* _tmp28_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		GUPnPServiceAction* _tmp34_;
#line 258 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp9_ = msg;
#line 258 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp10_ = _tmp9_->response_headers;
#line 258 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp11_ = soup_message_headers_get_one (_tmp10_, "Content-Type");
#line 258 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp12_ = g_strdup (_tmp11_);
#line 258 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		mime = _tmp12_;
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp14_ = mime;
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (_tmp14_ != NULL) {
#line 988 "rygel-av-transport.c"
			const gchar* _tmp15_;
			RygelMediaPlayer* _tmp16_;
			gint _tmp17_ = 0;
			gchar** _tmp18_ = NULL;
			gchar** _tmp19_;
			gint _tmp19__length1;
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp15_ = mime;
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp16_ = self->priv->player;
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp18_ = rygel_media_player_get_mime_types (_tmp16_, &_tmp17_);
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp19_ = _tmp18_;
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp19__length1 = _tmp17_;
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp13_ = !_vala_string_array_contains (_tmp19_, _tmp17_, _tmp15_);
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
#line 1009 "rygel-av-transport.c"
		} else {
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp13_ = FALSE;
#line 1013 "rygel-av-transport.c"
		}
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp20_ = _tmp13_;
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (_tmp20_) {
#line 1019 "rygel-av-transport.c"
			GUPnPServiceAction* _tmp21_;
#line 261 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp21_ = _data1_->action;
#line 261 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			gupnp_service_action_return_error (_tmp21_, (guint) 714, "Illegal MIME-type");
#line 263 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_free0 (mime);
#line 263 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			return;
#line 1029 "rygel-av-transport.c"
		}
#line 265 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp22_ = self->priv->player;
#line 265 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp23_ = mime;
#line 265 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_media_player_set_mime_type (_tmp22_, _tmp23_);
#line 266 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp24_ = msg;
#line 266 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp25_ = _tmp24_->response_headers;
#line 266 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp26_ = soup_message_headers_get_one (_tmp25_, "contentFeatures.dlna.org");
#line 266 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp27_ = g_strdup (_tmp26_);
#line 266 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		features = _tmp27_;
#line 269 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp28_ = features;
#line 269 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (_tmp28_ != NULL) {
#line 1051 "rygel-av-transport.c"
			RygelMediaPlayer* _tmp29_;
			const gchar* _tmp30_;
#line 270 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp29_ = self->priv->player;
#line 270 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp30_ = features;
#line 270 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			rygel_media_player_set_content_features (_tmp29_, _tmp30_);
#line 1060 "rygel-av-transport.c"
		} else {
			RygelMediaPlayer* _tmp31_;
#line 272 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp31_ = self->priv->player;
#line 272 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			rygel_media_player_set_content_features (_tmp31_, "*");
#line 1067 "rygel-av-transport.c"
		}
#line 275 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp32_ = _data1_->_metadata;
#line 275 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_metadata (self, _tmp32_);
#line 276 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp33_ = _data1_->_uri;
#line 276 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_uri (self, _tmp33_);
#line 277 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_n_tracks (self, (guint) 1);
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp34_ = _data1_->action;
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return (_tmp34_);
#line 249 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (features);
#line 249 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (mime);
#line 1087 "rygel-av-transport.c"
	}
}


static void ____lambda2__soup_message_finished (SoupMessage* _sender, gpointer self) {
#line 248 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	___lambda2_ (self, _sender);
#line 1095 "rygel-av-transport.c"
}


static void rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	Block1Data* _data1_;
	GUPnPServiceAction* _tmp0_;
	GUPnPServiceAction* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GUPnPServiceAction* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp9_;
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data1_->_ref_count_ = 1;
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data1_->self = g_object_ref (self);
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data1_->action = _tmp0_;
#line 231 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = _data1_->action;
#line 231 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_av_transport_check_instance_id (self, _tmp1_);
#line 231 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp2_) {
#line 232 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		block1_data_unref (_data1_);
#line 232 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data1_ = NULL;
#line 232 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1137 "rygel-av-transport.c"
	}
#line 237 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _data1_->action;
#line 237 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp3_, "CurrentURI", G_TYPE_STRING, &_data1_->_uri, "CurrentURIMetaData", G_TYPE_STRING, &_data1_->_metadata, NULL);
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _data1_->_uri;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = g_str_has_prefix (_tmp5_, "http://");
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp6_) {
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp4_ = TRUE;
#line 1151 "rygel-av-transport.c"
	} else {
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = _data1_->_uri;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp8_ = g_str_has_prefix (_tmp7_, "https://");
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp4_ = _tmp8_;
#line 1161 "rygel-av-transport.c"
	}
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = _tmp4_;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp9_) {
#line 1167 "rygel-av-transport.c"
		const gchar* _tmp10_;
		SoupMessage* _tmp11_;
		SoupMessage* message;
		SoupMessage* _tmp12_;
		SoupMessageHeaders* _tmp13_;
		SoupMessage* _tmp14_;
		SoupSession* _tmp15_;
		SoupMessage* _tmp16_;
		SoupMessage* _tmp17_;
#line 245 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp10_ = _data1_->_uri;
#line 245 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp11_ = soup_message_new ("HEAD", _tmp10_);
#line 245 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		message = _tmp11_;
#line 246 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp12_ = message;
#line 246 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp13_ = _tmp12_->request_headers;
#line 246 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		soup_message_headers_append (_tmp13_, "getContentFeatures.dlna.org", "1");
#line 248 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp14_ = message;
#line 248 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_signal_connect_data (_tmp14_, "finished", (GCallback) ____lambda2__soup_message_finished, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 282 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp15_ = self->priv->session;
#line 282 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp16_ = message;
#line 282 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp17_ = _g_object_ref0 (_tmp16_);
#line 282 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		soup_session_queue_message (_tmp15_, _tmp17_, NULL, NULL);
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (message);
#line 1203 "rygel-av-transport.c"
	} else {
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		GUPnPServiceAction* _tmp21_;
#line 284 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp18_ = _data1_->_metadata;
#line 284 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_metadata (self, _tmp18_);
#line 285 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp19_ = _data1_->_uri;
#line 285 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_uri (self, _tmp19_);
#line 286 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp20_ = _data1_->_uri;
#line 286 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (g_strcmp0 (_tmp20_, "") == 0) {
#line 287 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			rygel_av_transport_set_n_tracks (self, (guint) 0);
#line 1223 "rygel-av-transport.c"
		} else {
#line 289 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			rygel_av_transport_set_n_tracks (self, (guint) 1);
#line 1227 "rygel-av-transport.c"
		}
#line 292 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp21_ = _data1_->action;
#line 292 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return (_tmp21_);
#line 1233 "rygel-av-transport.c"
	}
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	block1_data_unref (_data1_);
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data1_ = NULL;
#line 1239 "rygel-av-transport.c"
}


static void rygel_av_transport_get_media_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	RygelMediaPlayer* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GUPnPServiceAction* _tmp15_;
#line 296 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 296 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 296 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 298 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 298 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 298 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 299 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1274 "rygel-av-transport.c"
	}
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = rygel_av_transport_get_n_tracks (self);
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = self->priv->player;
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = rygel_media_player_get_duration_as_str (_tmp5_);
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = _tmp6_;
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = rygel_av_transport_get_uri (self);
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = _tmp9_;
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = _tmp10_;
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = rygel_av_transport_get_metadata (self);
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp13_ = _tmp12_;
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp14_ = _tmp13_;
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "NrTracks", G_TYPE_UINT, _tmp4_, "MediaDuration", G_TYPE_STRING, _tmp8_, "CurrentURI", G_TYPE_STRING, _tmp11_, "CurrentURIMetaData", G_TYPE_STRING, _tmp14_, "NextURI", G_TYPE_STRING, "NOT_IMPLEMENTED", "NextURIMetaData", G_TYPE_STRING, "NOT_IMPLEMENTED", "PlayMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecordMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "WriteStatus", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp14_);
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp11_);
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp8_);
#line 330 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp15_ = action;
#line 330 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp15_);
#line 1314 "rygel-av-transport.c"
}


static void rygel_av_transport_get_media_info_ex_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	RygelMediaPlayer* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GUPnPServiceAction* _tmp15_;
#line 333 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 333 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 333 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 335 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 335 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 335 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 336 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1349 "rygel-av-transport.c"
	}
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = rygel_av_transport_get_n_tracks (self);
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = self->priv->player;
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = rygel_media_player_get_duration_as_str (_tmp5_);
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = _tmp6_;
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = rygel_av_transport_get_uri (self);
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = _tmp9_;
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = _tmp10_;
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = rygel_av_transport_get_metadata (self);
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp13_ = _tmp12_;
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp14_ = _tmp13_;
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "CurrentType", G_TYPE_STRING, "NO_MEDIA", "NrTracks", G_TYPE_UINT, _tmp4_, "MediaDuration", G_TYPE_STRING, _tmp8_, "CurrentURI", G_TYPE_STRING, _tmp11_, "CurrentURIMetaData", G_TYPE_STRING, _tmp14_, "NextURI", G_TYPE_STRING, "NOT_IMPLEMENTED", "NextURIMetaData", G_TYPE_STRING, "NOT_IMPLEMENTED", "PlayMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecordMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "WriteStatus", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp14_);
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp11_);
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp8_);
#line 370 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp15_ = action;
#line 370 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp15_);
#line 1389 "rygel-av-transport.c"
}


static void rygel_av_transport_get_transport_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	RygelMediaPlayer* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GUPnPServiceAction* _tmp11_;
#line 374 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 374 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 374 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 376 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 376 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 376 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 377 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1420 "rygel-av-transport.c"
	}
#line 380 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 380 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->player;
#line 380 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = rygel_media_player_get_playback_state (_tmp3_);
#line 380 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 380 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 380 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = rygel_av_transport_get_status (self);
#line 380 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 380 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = rygel_av_transport_get_speed (self);
#line 380 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = _tmp9_;
#line 380 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "CurrentTransportState", G_TYPE_STRING, _tmp6_, "CurrentTransportStatus", G_TYPE_STRING, _tmp8_, "CurrentSpeed", G_TYPE_STRING, _tmp10_, NULL);
#line 380 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp6_);
#line 390 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = action;
#line 390 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp11_);
#line 1448 "rygel-av-transport.c"
}


static void rygel_av_transport_get_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	RygelMediaPlayer* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	RygelMediaPlayer* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	RygelMediaPlayer* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GUPnPServiceAction* _tmp25_;
#line 393 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 393 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 393 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 395 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 395 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 395 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 396 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1493 "rygel-av-transport.c"
	}
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = rygel_av_transport_get_track (self);
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = self->priv->player;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = rygel_media_player_get_duration_as_str (_tmp5_);
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = _tmp6_;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = rygel_av_transport_get_metadata (self);
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = _tmp9_;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = _tmp10_;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = rygel_av_transport_get_uri (self);
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp13_ = _tmp12_;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp14_ = _tmp13_;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp15_ = self->priv->player;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp16_ = rygel_media_player_get_position_as_str (_tmp15_);
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp17_ = _tmp16_;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp18_ = _tmp17_;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp19_ = self->priv->player;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp20_ = rygel_media_player_get_position_as_str (_tmp19_);
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp21_ = _tmp20_;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp22_ = _tmp21_;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp23_ = G_MAXINT;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp24_ = G_MAXINT;
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "Track", G_TYPE_UINT, _tmp4_, "TrackDuration", G_TYPE_STRING, _tmp8_, "TrackMetaData", G_TYPE_STRING, _tmp11_, "TrackURI", G_TYPE_STRING, _tmp14_, "RelTime", G_TYPE_STRING, _tmp18_, "AbsTime", G_TYPE_STRING, _tmp22_, "RelCount", G_TYPE_INT, _tmp23_, "AbsCount", G_TYPE_INT, _tmp24_, NULL);
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp22_);
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp18_);
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp14_);
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp11_);
#line 399 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp8_);
#line 424 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp25_ = action;
#line 424 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp25_);
#line 1557 "rygel-av-transport.c"
}


static void rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	GUPnPServiceAction* _tmp3_;
#line 427 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 427 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 427 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 429 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 429 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 429 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 430 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1580 "rygel-av-transport.c"
	}
#line 433 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 433 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "PlayMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecQualityModes", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 443 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = action;
#line 443 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp3_);
#line 1590 "rygel-av-transport.c"
}


static void rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GUPnPServiceAction* _tmp5_;
#line 446 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 446 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 446 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 448 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 448 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 448 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 449 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1615 "rygel-av-transport.c"
	}
#line 452 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 452 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = rygel_av_transport_get_mode (self);
#line 452 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 452 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "PlayMode", G_TYPE_STRING, _tmp4_, "RecQualityMode", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 459 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = action;
#line 459 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp5_);
#line 1629 "rygel-av-transport.c"
}


static void rygel_av_transport_stop_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelMediaPlayer* _tmp2_;
	GUPnPServiceAction* _tmp3_;
#line 462 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 462 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 462 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 463 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 463 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 463 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 464 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1652 "rygel-av-transport.c"
	}
#line 467 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->player;
#line 467 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_media_player_set_playback_state (_tmp2_, "STOPPED");
#line 469 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = action;
#line 469 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp3_);
#line 1662 "rygel-av-transport.c"
}


static void rygel_av_transport_play_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* speed = NULL;
	GUPnPServiceAction* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaPlayer* _tmp6_;
	GUPnPServiceAction* _tmp7_;
#line 472 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 472 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 472 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 473 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 473 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 473 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 474 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1688 "rygel-av-transport.c"
	}
#line 479 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 479 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp2_, "Speed", G_TYPE_STRING, &speed, NULL);
#line 480 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = speed;
#line 480 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (g_strcmp0 (_tmp3_, "1") != 0) {
#line 1698 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp4_;
		const gchar* _tmp5_ = NULL;
#line 481 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp4_ = action;
#line 481 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp5_ = _ ("Play speed not supported");
#line 481 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp4_, (guint) 717, _tmp5_);
#line 483 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (speed);
#line 483 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1711 "rygel-av-transport.c"
	}
#line 486 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = self->priv->player;
#line 486 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_media_player_set_playback_state (_tmp6_, "PLAYING");
#line 488 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = action;
#line 488 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp7_);
#line 472 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (speed);
#line 1723 "rygel-av-transport.c"
}


static void rygel_av_transport_pause_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelMediaPlayer* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	RygelMediaPlayer* _tmp9_;
	GUPnPServiceAction* _tmp10_;
#line 491 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 491 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 491 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 492 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 492 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 492 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 493 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1751 "rygel-av-transport.c"
	}
#line 496 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->player;
#line 496 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = rygel_media_player_get_playback_state (_tmp2_);
#line 496 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 496 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 496 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = g_strcmp0 (_tmp5_, "PLAYING") != 0;
#line 496 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp5_);
#line 496 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp6_) {
#line 1767 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp7_;
		const gchar* _tmp8_ = NULL;
#line 497 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = action;
#line 497 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp8_ = _ ("Transition not available");
#line 497 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp7_, (guint) 701, _tmp8_);
#line 499 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1778 "rygel-av-transport.c"
	}
#line 502 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = self->priv->player;
#line 502 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_media_player_set_playback_state (_tmp9_, "PAUSED_PLAYBACK");
#line 504 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = action;
#line 504 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp10_);
#line 1788 "rygel-av-transport.c"
}


static void rygel_av_transport_seek_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* unit = NULL;
	gchar* target = NULL;
	GUPnPServiceAction* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
#line 520 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	static GQuark _tmp5_label0 = 0;
#line 520 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	static GQuark _tmp5_label1 = 0;
#line 507 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 507 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 507 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 508 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 508 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 508 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 509 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1819 "rygel-av-transport.c"
	}
#line 514 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 514 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp2_, "Unit", G_TYPE_STRING, &unit, "Target", G_TYPE_STRING, &target, NULL);
#line 520 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = unit;
#line 520 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 520 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 520 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if ((_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("ABS_TIME")))) || (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("REL_TIME"))))) {
#line 520 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		switch (0) {
#line 1835 "rygel-av-transport.c"
			default:
			{
				const gchar* _tmp7_;
				RygelMediaPlayer* _tmp8_;
				const gchar* _tmp9_;
				GstClockTime _tmp10_ = 0ULL;
				gboolean _tmp11_ = FALSE;
				GUPnPServiceAction* _tmp14_;
#line 523 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp7_ = target;
#line 523 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				g_debug ("rygel-av-transport.vala:523: Seeking to %s.", _tmp7_);
#line 525 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp8_ = self->priv->player;
#line 525 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp9_ = target;
#line 525 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp10_ = rygel_gst_utils_time_from_string (_tmp9_);
#line 525 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp11_ = rygel_media_player_seek (_tmp8_, _tmp10_);
#line 525 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				if (!_tmp11_) {
#line 1858 "rygel-av-transport.c"
					GUPnPServiceAction* _tmp12_;
					const gchar* _tmp13_ = NULL;
#line 526 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp12_ = action;
#line 526 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp13_ = _ ("Seek mode not supported");
#line 526 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					gupnp_service_action_return_error (_tmp12_, (guint) 710, _tmp13_);
#line 528 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (target);
#line 528 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (unit);
#line 528 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					return;
#line 1873 "rygel-av-transport.c"
				}
#line 531 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp14_ = action;
#line 531 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				gupnp_service_action_return (_tmp14_);
#line 533 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_free0 (target);
#line 533 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_free0 (unit);
#line 533 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				return;
#line 1885 "rygel-av-transport.c"
			}
		}
	} else {
#line 520 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		switch (0) {
#line 1891 "rygel-av-transport.c"
			default:
			{
				GUPnPServiceAction* _tmp15_;
				const gchar* _tmp16_ = NULL;
#line 535 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp15_ = action;
#line 535 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp16_ = _ ("Seek mode not supported");
#line 535 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				gupnp_service_action_return_error (_tmp15_, (guint) 710, _tmp16_);
#line 537 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_free0 (target);
#line 537 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_free0 (unit);
#line 537 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				return;
#line 1908 "rygel-av-transport.c"
			}
		}
	}
#line 507 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (target);
#line 507 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (unit);
#line 1916 "rygel-av-transport.c"
}


static void rygel_av_transport_next_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_ = NULL;
#line 541 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 541 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 541 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 542 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 542 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = _ ("Transition not available");
#line 542 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return_error (_tmp0_, (guint) 701, _tmp1_);
#line 1935 "rygel-av-transport.c"
}


static void rygel_av_transport_previous_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_ = NULL;
#line 545 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 545 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 545 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 546 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 546 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = _ ("Transition not available");
#line 546 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return_error (_tmp0_, (guint) 701, _tmp1_);
#line 1954 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_state_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	RygelMediaPlayer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 549 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 549 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 549 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 550 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 550 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->player;
#line 550 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_media_player_get_playback_state (_tmp1_);
#line 550 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 550 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 550 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "TransportState", _tmp4_);
#line 550 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 1984 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_duration_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	RygelMediaPlayer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	RygelChangeLog* _tmp5_;
	RygelMediaPlayer* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
#line 553 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 553 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 553 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 554 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 554 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->player;
#line 554 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_media_player_get_duration_as_str (_tmp1_);
#line 554 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 554 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 554 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "CurrentTrackDuration", _tmp4_);
#line 554 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 556 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = self->priv->changelog;
#line 556 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = self->priv->player;
#line 556 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
#line 556 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 556 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = _tmp8_;
#line 556 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp5_, "CurrentMediaDuration", _tmp9_);
#line 556 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp9_);
#line 2033 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_uri_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	RygelChangeLog* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
#line 560 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 560 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 560 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 561 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 561 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_get_uri (self);
#line 561 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 561 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 561 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "CurrentTrackURI", _tmp3_);
#line 561 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp3_);
#line 562 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = self->priv->changelog;
#line 562 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = rygel_av_transport_get_uri (self);
#line 562 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 562 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = _tmp6_;
#line 562 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp4_, "AVTransportURI", _tmp7_);
#line 562 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp7_);
#line 2076 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelMediaPlayer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	RygelChangeLog* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
#line 565 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 565 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 565 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 566 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->player;
#line 566 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_media_player_get_metadata (_tmp0_);
#line 566 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 566 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->_metadata);
#line 566 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_metadata = _tmp2_;
#line 567 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->changelog;
#line 567 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = rygel_av_transport_get_metadata (self);
#line 567 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 567 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 567 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp3_, "CurrentTrackMetadata", _tmp6_);
#line 567 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp6_);
#line 2116 "rygel-av-transport.c"
}


RygelAVTransport* rygel_av_transport_construct (GType object_type) {
	RygelAVTransport * self = NULL;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self = (RygelAVTransport*) g_object_new (object_type, NULL);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return self;
#line 2126 "rygel-av-transport.c"
}


RygelAVTransport* rygel_av_transport_new (void) {
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return rygel_av_transport_construct (RYGEL_TYPE_AV_TRANSPORT);
#line 2133 "rygel-av-transport.c"
}


guint rygel_av_transport_get_n_tracks (RygelAVTransport* self) {
	guint result;
	guint _tmp0_;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 43 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->_n_tracks;
#line 43 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp0_;
#line 43 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 2148 "rygel-av-transport.c"
}


void rygel_av_transport_set_n_tracks (RygelAVTransport* self, guint value) {
	guint _tmp0_;
	RygelChangeLog* _tmp1_;
	guint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
#line 46 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = value;
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_n_tracks = _tmp0_;
#line 49 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->changelog;
#line 49 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->_n_tracks;
#line 49 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = g_strdup_printf ("%u", _tmp2_);
#line 49 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 49 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp1_, "NumberOfTracks", _tmp4_);
#line 49 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 46 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "n-tracks");
#line 2178 "rygel-av-transport.c"
}


guint rygel_av_transport_get_track (RygelAVTransport* self) {
	guint result;
	guint _tmp0_;
#line 55 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->_track;
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp0_;
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 2193 "rygel-av-transport.c"
}


void rygel_av_transport_set_track (RygelAVTransport* self, guint value) {
	guint _tmp0_;
	RygelChangeLog* _tmp1_;
	guint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
#line 59 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 60 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = value;
#line 60 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_track = _tmp0_;
#line 62 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->changelog;
#line 62 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->_track;
#line 62 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = g_strdup_printf ("%u", _tmp2_);
#line 62 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 62 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp1_, "CurrentTrack", _tmp4_);
#line 62 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 59 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "track");
#line 2223 "rygel-av-transport.c"
}


gchar* rygel_av_transport_get_metadata (RygelAVTransport* self) {
	gchar* result;
	const gchar* _tmp0_;
#line 68 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 69 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->_metadata;
#line 69 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp0_ != NULL) {
#line 2236 "rygel-av-transport.c"
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
#line 70 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp1_ = self->priv->_metadata;
#line 70 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp2_ = g_markup_escape_text (_tmp1_, (gssize) (-1));
#line 70 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		result = _tmp2_;
#line 70 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return result;
#line 2247 "rygel-av-transport.c"
	} else {
		gchar* _tmp3_;
#line 72 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp3_ = g_strdup ("");
#line 72 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		result = _tmp3_;
#line 72 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return result;
#line 2256 "rygel-av-transport.c"
	}
}


void rygel_av_transport_set_metadata (RygelAVTransport* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelMediaPlayer* _tmp2_;
	const gchar* _tmp3_;
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = value;
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->_metadata);
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_metadata = _tmp1_;
#line 78 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->player;
#line 78 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = value;
#line 78 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_media_player_set_metadata (_tmp2_, _tmp3_);
#line 76 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "metadata");
#line 2284 "rygel-av-transport.c"
}


gchar* rygel_av_transport_get_uri (RygelAVTransport* self) {
	gchar* result;
	RygelMediaPlayer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
#line 83 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->player;
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_media_player_get_uri (_tmp0_);
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_ != NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp3_);
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp4_) {
#line 2311 "rygel-av-transport.c"
		RygelMediaPlayer* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
#line 85 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp5_ = self->priv->player;
#line 85 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = rygel_media_player_get_uri (_tmp5_);
#line 85 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = _tmp6_;
#line 85 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp8_ = _tmp7_;
#line 85 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp9_ = g_markup_escape_text (_tmp8_, (gssize) (-1));
#line 85 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp10_ = _tmp9_;
#line 85 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (_tmp8_);
#line 85 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		result = _tmp10_;
#line 85 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return result;
#line 2336 "rygel-av-transport.c"
	} else {
		gchar* _tmp11_;
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp11_ = g_strdup ("");
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		result = _tmp11_;
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return result;
#line 2345 "rygel-av-transport.c"
	}
}


void rygel_av_transport_set_uri (RygelAVTransport* self, const gchar* value) {
	RygelMediaPlayer* _tmp0_;
	const gchar* _tmp1_;
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 92 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->player;
#line 92 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = value;
#line 92 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_media_player_set_uri (_tmp0_, _tmp1_);
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "uri");
#line 2363 "rygel-av-transport.c"
}


const gchar* rygel_av_transport_get_status (RygelAVTransport* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 98 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->_status;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp0_;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 2378 "rygel-av-transport.c"
}


void rygel_av_transport_set_status (RygelAVTransport* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelChangeLog* _tmp2_;
	const gchar* _tmp3_;
#line 102 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 103 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = value;
#line 103 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 103 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->_status);
#line 103 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_status = _tmp1_;
#line 105 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->changelog;
#line 105 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->_status;
#line 105 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp2_, "TransportStatus", _tmp3_);
#line 102 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "status");
#line 2405 "rygel-av-transport.c"
}


const gchar* rygel_av_transport_get_speed (RygelAVTransport* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 111 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->_speed;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp0_;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 2420 "rygel-av-transport.c"
}


void rygel_av_transport_set_speed (RygelAVTransport* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelChangeLog* _tmp2_;
	const gchar* _tmp3_;
#line 115 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 116 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = value;
#line 116 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 116 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->_speed);
#line 116 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_speed = _tmp1_;
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->changelog;
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->_speed;
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp2_, "TransportPlaySpeed", _tmp3_);
#line 115 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "speed");
#line 2447 "rygel-av-transport.c"
}


const gchar* rygel_av_transport_get_mode (RygelAVTransport* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 125 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->_mode;
#line 125 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp0_;
#line 125 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 2462 "rygel-av-transport.c"
}


void rygel_av_transport_set_mode (RygelAVTransport* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelChangeLog* _tmp2_;
	const gchar* _tmp3_;
#line 128 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 129 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = value;
#line 129 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 129 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->_mode);
#line 129 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_mode = _tmp1_;
#line 131 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->changelog;
#line 131 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->_mode;
#line 131 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp2_, "CurrentPlayMode", _tmp3_);
#line 128 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "mode");
#line 2489 "rygel-av-transport.c"
}


static void rygel_av_transport_class_init (RygelAVTransportClass * klass) {
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_parent_class = g_type_class_peek_parent (klass);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_type_class_add_private (klass, sizeof (RygelAVTransportPrivate));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_av_transport_real_constructed;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_av_transport_get_property;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_av_transport_set_property;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_av_transport_finalize;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_N_TRACKS, g_param_spec_uint ("n-tracks", "n-tracks", "n-tracks", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_TRACK, g_param_spec_uint ("track", "track", "track", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_METADATA, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_STATUS, g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_SPEED, g_param_spec_string ("speed", "speed", "speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_MODE, g_param_spec_string ("mode", "mode", "mode", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2520 "rygel-av-transport.c"
}


static void rygel_av_transport_instance_init (RygelAVTransport * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv = RYGEL_AV_TRANSPORT_GET_PRIVATE (self);
#line 40 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_n_tracks = (guint) 0;
#line 53 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_track = (guint) 0;
#line 66 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = g_strdup ("");
#line 66 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_metadata = _tmp0_;
#line 96 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = g_strdup ("OK");
#line 96 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_status = _tmp1_;
#line 109 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = g_strdup ("1");
#line 109 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_speed = _tmp2_;
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = g_strdup ("NORMAL");
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_mode = _tmp3_;
#line 2551 "rygel-av-transport.c"
}


static void rygel_av_transport_finalize (GObject* obj) {
	RygelAVTransport * self;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
#line 37 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->session);
#line 66 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->_metadata);
#line 96 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->_status);
#line 109 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->_speed);
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->_mode);
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->changelog);
#line 136 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->player);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	G_OBJECT_CLASS (rygel_av_transport_parent_class)->finalize (obj);
#line 2575 "rygel-av-transport.c"
}


GType rygel_av_transport_get_type (void) {
	static volatile gsize rygel_av_transport_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_av_transport_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAVTransportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_av_transport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAVTransport), 0, (GInstanceInitFunc) rygel_av_transport_instance_init, NULL };
		GType rygel_av_transport_type_id;
		rygel_av_transport_type_id = g_type_register_static (GUPNP_TYPE_SERVICE, "RygelAVTransport", &g_define_type_info, 0);
		g_once_init_leave (&rygel_av_transport_type_id__volatile, rygel_av_transport_type_id);
	}
	return rygel_av_transport_type_id__volatile;
}


static void _vala_rygel_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelAVTransport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_N_TRACKS:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_value_set_uint (value, rygel_av_transport_get_n_tracks (self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_TRACK:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_value_set_uint (value, rygel_av_transport_get_track (self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_METADATA:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_value_take_string (value, rygel_av_transport_get_metadata (self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_URI:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_value_take_string (value, rygel_av_transport_get_uri (self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_STATUS:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_value_set_string (value, rygel_av_transport_get_status (self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_SPEED:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_value_set_string (value, rygel_av_transport_get_speed (self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_MODE:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_value_set_string (value, rygel_av_transport_get_mode (self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 2638 "rygel-av-transport.c"
		default:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 2644 "rygel-av-transport.c"
	}
}


static void _vala_rygel_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelAVTransport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_N_TRACKS:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_n_tracks (self, g_value_get_uint (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_TRACK:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_track (self, g_value_get_uint (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_METADATA:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_metadata (self, g_value_get_string (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_URI:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_uri (self, g_value_get_string (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_STATUS:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_status (self, g_value_get_string (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_SPEED:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_speed (self, g_value_get_string (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_MODE:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_mode (self, g_value_get_string (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 2696 "rygel-av-transport.c"
		default:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 2702 "rygel-av-transport.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



