/* minefield-view.c generated by valac 0.16.0, the Vala compiler
 * generated from minefield-view.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <games-preimage.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <glib/gi18n-lib.h>


#define TYPE_MINEFIELD_VIEW (minefield_view_get_type ())
#define MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD_VIEW, MinefieldView))
#define MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD_VIEW, MinefieldViewClass))
#define IS_MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD_VIEW))
#define IS_MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD_VIEW))
#define MINEFIELD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD_VIEW, MinefieldViewClass))

typedef struct _MinefieldView MinefieldView;
typedef struct _MinefieldViewClass MinefieldViewClass;
typedef struct _MinefieldViewPrivate MinefieldViewPrivate;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _minefield_unref0(var) ((var == NULL) ? NULL : (var = (minefield_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MinefieldPrivate MinefieldPrivate;

#define TYPE_FLAG_TYPE (flag_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

#define TYPE_NEIGHBOUR (neighbour_get_type ())
typedef struct _Neighbour Neighbour;

struct _MinefieldView {
	GtkDrawingArea parent_instance;
	MinefieldViewPrivate * priv;
};

struct _MinefieldViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _MinefieldViewPrivate {
	gboolean use_question_marks;
	gboolean use_overmine_warning;
	gboolean use_autoflag;
	gint selected_x;
	gint selected_y;
	GamesPreimage* flag_preimage;
	GamesPreimage* mine_preimage;
	GamesPreimage* question_preimage;
	GamesPreimage* bang_preimage;
	GamesPreimage* warning_preimage;
	guint render_size;
	cairo_pattern_t* flag_pattern;
	cairo_pattern_t* mine_pattern;
	cairo_pattern_t* question_pattern;
	cairo_pattern_t* bang_pattern;
	cairo_pattern_t* warning_pattern;
	cairo_pattern_t** number_patterns;
	gint number_patterns_length1;
	gint _number_patterns_size_;
	gboolean _paused;
	Minefield* _minefield;
};

struct _Minefield {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	gboolean exploded;
};

struct _MinefieldClass {
	GTypeClass parent_class;
	void (*finalize) (Minefield *self);
};

typedef enum  {
	FLAG_TYPE_NONE,
	FLAG_TYPE_FLAG,
	FLAG_TYPE_MAYBE
} FlagType;

struct _Neighbour {
	gint x;
	gint y;
};


static gpointer minefield_view_parent_class = NULL;

GType minefield_view_get_type (void) G_GNUC_CONST;
gpointer minefield_ref (gpointer instance);
void minefield_unref (gpointer instance);
GParamSpec* param_spec_minefield (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_minefield (GValue* value, gpointer v_object);
void value_take_minefield (GValue* value, gpointer v_object);
gpointer value_get_minefield (const GValue* value);
GType minefield_get_type (void) G_GNUC_CONST;
#define MINEFIELD_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MINEFIELD_VIEW, MinefieldViewPrivate))
enum  {
	MINEFIELD_VIEW_DUMMY_PROPERTY,
	MINEFIELD_VIEW_PAUSED,
	MINEFIELD_VIEW_MINEFIELD
};
MinefieldView* minefield_view_new (void);
MinefieldView* minefield_view_construct (GType object_type);
static GamesPreimage* minefield_view_load_preimage (MinefieldView* self, const gchar* filename);
void minefield_view_set_use_question_marks (MinefieldView* self, gboolean use_question_marks);
void minefield_view_set_use_overmine_warning (MinefieldView* self, gboolean use_overmine_warning);
void minefield_view_set_use_autoflag (MinefieldView* self, gboolean use_autoflag);
static void minefield_view_explode_cb (MinefieldView* self, Minefield* minefield);
gboolean minefield_has_mine (Minefield* self, guint x, guint y);
GType flag_type_get_type (void) G_GNUC_CONST;
FlagType minefield_get_flag (Minefield* self, guint x, guint y);
static void minefield_view_redraw_sector_cb (MinefieldView* self, guint x, guint y);
static cairo_pattern_t* minefield_view_render_preimage_pattern (MinefieldView* self, cairo_t* cr, GamesPreimage* preimage);
static guint minefield_view_get_mine_size (MinefieldView* self);
static cairo_pattern_t* minefield_view_render_number_pattern (MinefieldView* self, guint n);
static void minefield_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural);
Minefield* minefield_view_get_minefield (MinefieldView* self);
static guint minefield_view_get_minimum_size (MinefieldView* self);
static void minefield_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural);
static guint minefield_view_get_x_offset (MinefieldView* self);
static guint minefield_view_get_y_offset (MinefieldView* self);
static void minefield_view_draw_square (MinefieldView* self, cairo_t* cr, guint x, guint y);
gboolean minefield_is_cleared (Minefield* self, guint x, guint y);
GType neighbour_get_type (void) G_GNUC_CONST;
Neighbour* neighbour_dup (const Neighbour* self);
void neighbour_free (Neighbour* self);
gboolean minefield_is_location (Minefield* self, guint x, guint y);
gboolean minefield_view_get_paused (MinefieldView* self);
gboolean minefield_has_flag_warning (Minefield* self, guint x, guint y);
guint minefield_get_n_adjacent_mines (Minefield* self, guint x, guint y);
static gboolean minefield_view_real_draw (GtkWidget* base, cairo_t* cr);
static void minefield_view_toggle_mark (MinefieldView* self, guint x, guint y);
guint minefield_get_n_flags (Minefield* self);
void minefield_set_flag (Minefield* self, guint x, guint y, FlagType flag);
static void minefield_view_redraw_adjacent (MinefieldView* self, guint x, guint y);
static void minefield_view_multi_release (MinefieldView* self, guint x, guint y);
void minefield_clear_mine (Minefield* self, guint x, guint y);
static gboolean minefield_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
gboolean minefield_get_is_complete (Minefield* self);
static gboolean minefield_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
static gboolean minefield_view_real_button_release_event (GtkWidget* base, GdkEventButton* event);
void minefield_view_set_paused (MinefieldView* self, gboolean value);
void minefield_view_set_minefield (MinefieldView* self, Minefield* value);
static void _minefield_view_redraw_sector_cb_minefield_redraw_sector (Minefield* _sender, guint x, guint y, gpointer self);
static void _minefield_view_explode_cb_minefield_explode (Minefield* _sender, gpointer self);
static void minefield_view_finalize (GObject* obj);
static void _vala_minefield_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_minefield_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

extern const Neighbour neighbour_map[8];

MinefieldView* minefield_view_construct (GType object_type) {
	MinefieldView * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GamesPreimage* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GamesPreimage* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GamesPreimage* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	GamesPreimage* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	GamesPreimage* _tmp14_ = NULL;
	cairo_pattern_t** _tmp15_ = NULL;
	self = (MinefieldView*) g_object_new (object_type, NULL);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_BUTTON_RELEASE_MASK));
	_tmp0_ = g_build_filename (DATA_DIRECTORY, "flag.svg", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = minefield_view_load_preimage (self, _tmp1_);
	_g_object_unref0 (self->priv->flag_preimage);
	self->priv->flag_preimage = _tmp2_;
	_g_free0 (_tmp1_);
	_tmp3_ = g_build_filename (DATA_DIRECTORY, "mine.svg", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = minefield_view_load_preimage (self, _tmp4_);
	_g_object_unref0 (self->priv->mine_preimage);
	self->priv->mine_preimage = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp6_ = g_build_filename (DATA_DIRECTORY, "flag-question.svg", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = minefield_view_load_preimage (self, _tmp7_);
	_g_object_unref0 (self->priv->question_preimage);
	self->priv->question_preimage = _tmp8_;
	_g_free0 (_tmp7_);
	_tmp9_ = g_build_filename (DATA_DIRECTORY, "bang.svg", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = minefield_view_load_preimage (self, _tmp10_);
	_g_object_unref0 (self->priv->bang_preimage);
	self->priv->bang_preimage = _tmp11_;
	_g_free0 (_tmp10_);
	_tmp12_ = g_build_filename (DATA_DIRECTORY, "warning.svg", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = minefield_view_load_preimage (self, _tmp13_);
	_g_object_unref0 (self->priv->warning_preimage);
	self->priv->warning_preimage = _tmp14_;
	_g_free0 (_tmp13_);
	_tmp15_ = g_new0 (cairo_pattern_t*, 8 + 1);
	self->priv->number_patterns = (_vala_array_free (self->priv->number_patterns, self->priv->number_patterns_length1, (GDestroyNotify) cairo_pattern_destroy), NULL);
	self->priv->number_patterns = _tmp15_;
	self->priv->number_patterns_length1 = 8;
	self->priv->_number_patterns_size_ = self->priv->number_patterns_length1;
	return self;
}


MinefieldView* minefield_view_new (void) {
	return minefield_view_construct (TYPE_MINEFIELD_VIEW);
}


void minefield_view_set_use_question_marks (MinefieldView* self, gboolean use_question_marks) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = use_question_marks;
	self->priv->use_question_marks = _tmp0_;
}


void minefield_view_set_use_overmine_warning (MinefieldView* self, gboolean use_overmine_warning) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = use_overmine_warning;
	self->priv->use_overmine_warning = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


void minefield_view_set_use_autoflag (MinefieldView* self, gboolean use_autoflag) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = use_autoflag;
	self->priv->use_autoflag = _tmp0_;
}


static void minefield_view_explode_cb (MinefieldView* self, Minefield* minefield) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	{
		gint x;
		x = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				Minefield* _tmp4_;
				guint _tmp5_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = x;
				_tmp4_ = minefield;
				_tmp5_ = _tmp4_->width;
				if (!(((guint) _tmp3_) < _tmp5_)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp6_;
						_tmp6_ = TRUE;
						while (TRUE) {
							gboolean _tmp7_;
							gint _tmp9_;
							Minefield* _tmp10_;
							guint _tmp11_;
							gboolean _tmp12_ = FALSE;
							Minefield* _tmp13_;
							gint _tmp14_;
							gint _tmp15_;
							gboolean _tmp16_ = FALSE;
							gboolean _tmp27_;
							_tmp7_ = _tmp6_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = y;
								y = _tmp8_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp9_ = y;
							_tmp10_ = minefield;
							_tmp11_ = _tmp10_->height;
							if (!(((guint) _tmp9_) < _tmp11_)) {
								break;
							}
							_tmp13_ = minefield;
							_tmp14_ = x;
							_tmp15_ = y;
							_tmp16_ = minefield_has_mine (_tmp13_, (guint) _tmp14_, (guint) _tmp15_);
							if (_tmp16_) {
								_tmp12_ = TRUE;
							} else {
								gboolean _tmp17_ = FALSE;
								Minefield* _tmp18_;
								gint _tmp19_;
								gint _tmp20_;
								gboolean _tmp21_ = FALSE;
								gboolean _tmp26_;
								_tmp18_ = minefield;
								_tmp19_ = x;
								_tmp20_ = y;
								_tmp21_ = minefield_has_mine (_tmp18_, (guint) _tmp19_, (guint) _tmp20_);
								if (!_tmp21_) {
									Minefield* _tmp22_;
									gint _tmp23_;
									gint _tmp24_;
									FlagType _tmp25_ = 0;
									_tmp22_ = minefield;
									_tmp23_ = x;
									_tmp24_ = y;
									_tmp25_ = minefield_get_flag (_tmp22_, (guint) _tmp23_, (guint) _tmp24_);
									_tmp17_ = _tmp25_ == FLAG_TYPE_FLAG;
								} else {
									_tmp17_ = FALSE;
								}
								_tmp26_ = _tmp17_;
								_tmp12_ = _tmp26_;
							}
							_tmp27_ = _tmp12_;
							if (_tmp27_) {
								gint _tmp28_;
								gint _tmp29_;
								_tmp28_ = x;
								_tmp29_ = y;
								minefield_view_redraw_sector_cb (self, (guint) _tmp28_, (guint) _tmp29_);
							}
						}
					}
				}
			}
		}
	}
}


static GamesPreimage* minefield_view_load_preimage (MinefieldView* self, const gchar* filename) {
	GamesPreimage* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	{
		const gchar* _tmp0_;
		GamesPreimage* _tmp1_;
		GamesPreimage* _tmp2_;
		_tmp0_ = filename;
		_tmp1_ = games_preimage_new_from_file (_tmp0_, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		result = _tmp2_;
		return result;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static cairo_pattern_t* minefield_view_render_preimage_pattern (MinefieldView* self, cairo_t* cr, GamesPreimage* preimage) {
	cairo_pattern_t* result = NULL;
	cairo_t* _tmp0_;
	cairo_surface_t* _tmp1_ = NULL;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	cairo_surface_t* _tmp6_;
	cairo_surface_t* surface;
	cairo_t* _tmp7_;
	cairo_t* c;
	GamesPreimage* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	GdkPixbuf* _tmp13_ = NULL;
	GdkPixbuf* pixbuf;
	cairo_pattern_t* _tmp14_;
	cairo_pattern_t* pattern;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cr != NULL, NULL);
	g_return_val_if_fail (preimage != NULL, NULL);
	_tmp0_ = cr;
	_tmp1_ = cairo_get_target (_tmp0_);
	_tmp2_ = minefield_view_get_mine_size (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = minefield_view_get_mine_size (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = cairo_surface_create_similar (_tmp1_, CAIRO_CONTENT_COLOR_ALPHA, (gint) _tmp3_, (gint) _tmp5_);
	surface = _tmp6_;
	_tmp7_ = cairo_create (surface);
	c = _tmp7_;
	_tmp8_ = preimage;
	_tmp9_ = minefield_view_get_mine_size (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = minefield_view_get_mine_size (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = games_preimage_render (_tmp8_, ((gint) _tmp10_) - 2, ((gint) _tmp12_) - 2);
	pixbuf = _tmp13_;
	gdk_cairo_set_source_pixbuf (c, pixbuf, (gdouble) 1, (gdouble) 1);
	cairo_paint (c);
	_tmp14_ = cairo_pattern_create_for_surface (surface);
	pattern = _tmp14_;
	cairo_pattern_set_extend (pattern, CAIRO_EXTEND_REPEAT);
	result = pattern;
	_g_object_unref0 (pixbuf);
	_cairo_destroy0 (c);
	_cairo_surface_destroy0 (surface);
	return result;
}


static cairo_pattern_t* minefield_view_render_number_pattern (MinefieldView* self, guint n) {
	cairo_pattern_t* result = NULL;
	guint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	PangoLayout* _tmp3_ = NULL;
	PangoLayout* _tmp4_;
	PangoLayout* layout;
	PangoLayout* _tmp5_;
	PangoAttrList* _tmp6_;
	PangoAttrList* attributes;
	PangoAttribute* color_attribute = NULL;
	guint _tmp7_;
	PangoAttribute* _tmp16_;
	PangoAttribute* _tmp17_;
	guint _tmp18_;
	PangoAttrList* _tmp19_;
	PangoAttribute* _tmp20_;
	PangoFontDescription* _tmp21_;
	PangoFontDescription* font_desc;
	guint _tmp22_;
	guint _tmp23_;
	gdouble font_size;
	PangoAttrFontDesc* _tmp24_;
	PangoAttrFontDesc* font_attribute;
	PangoAttrFontDesc* _tmp25_;
	PangoAttrFontDesc* _tmp26_;
	guint _tmp27_;
	PangoAttrList* _tmp28_;
	PangoAttrFontDesc* _tmp29_;
	PangoLayout* _tmp30_;
	PangoAttrList* _tmp31_;
	guint _tmp32_;
	guint _tmp33_;
	guint _tmp34_;
	guint _tmp35_;
	cairo_surface_t* _tmp36_;
	cairo_surface_t* surface;
	cairo_t* _tmp37_;
	cairo_t* c;
	PangoRectangle extent = {0};
	PangoLayout* _tmp38_;
	PangoRectangle _tmp39_ = {0};
	guint _tmp40_;
	guint _tmp41_;
	PangoRectangle _tmp42_;
	gint _tmp43_;
	gint dx;
	guint _tmp44_;
	guint _tmp45_;
	PangoRectangle _tmp46_;
	gint _tmp47_;
	gint dy;
	PangoLayout* _tmp48_;
	cairo_pattern_t* _tmp49_;
	cairo_pattern_t* pattern;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = n;
	_tmp1_ = g_strdup_printf ("%u", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	layout = _tmp4_;
	_tmp5_ = layout;
	pango_layout_set_alignment (_tmp5_, PANGO_ALIGN_CENTER);
	_tmp6_ = pango_attr_list_new ();
	attributes = _tmp6_;
	_tmp7_ = n;
	switch (_tmp7_) {
		case 1:
		{
			PangoAttribute* _tmp8_ = NULL;
			_tmp8_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0x0000, (guint16) 0xffff);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp8_;
			break;
		}
		case 2:
		{
			PangoAttribute* _tmp9_ = NULL;
			_tmp9_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0xa0a0, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp9_;
			break;
		}
		case 3:
		{
			PangoAttribute* _tmp10_ = NULL;
			_tmp10_ = pango_attr_foreground_new ((guint16) 0xffff, (guint16) 0x0000, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp10_;
			break;
		}
		case 4:
		{
			PangoAttribute* _tmp11_ = NULL;
			_tmp11_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0x0000, (guint16) 0x7fff);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp11_;
			break;
		}
		case 5:
		{
			PangoAttribute* _tmp12_ = NULL;
			_tmp12_ = pango_attr_foreground_new ((guint16) 0xa0a0, (guint16) 0x0000, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp12_;
			break;
		}
		case 6:
		{
			PangoAttribute* _tmp13_ = NULL;
			_tmp13_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0xffff, (guint16) 0xffff);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp13_;
			break;
		}
		case 7:
		{
			PangoAttribute* _tmp14_ = NULL;
			_tmp14_ = pango_attr_foreground_new ((guint16) 0xa0a0, (guint16) 0x0000, (guint16) 0xa0a0);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp14_;
			break;
		}
		default:
		case 8:
		{
			PangoAttribute* _tmp15_ = NULL;
			_tmp15_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0x0000, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp15_;
			break;
		}
	}
	_tmp16_ = color_attribute;
	_tmp16_->start_index = (guint) 0;
	_tmp17_ = color_attribute;
	_tmp18_ = G_MAXUINT;
	_tmp17_->end_index = _tmp18_;
	_tmp19_ = attributes;
	_tmp20_ = color_attribute;
	color_attribute = NULL;
	pango_attr_list_insert (_tmp19_, _tmp20_);
	_tmp21_ = pango_font_description_new ();
	font_desc = _tmp21_;
	pango_font_description_set_family (font_desc, "Sans");
	_tmp22_ = minefield_view_get_mine_size (self);
	_tmp23_ = _tmp22_;
	font_size = ((_tmp23_ - 2) * PANGO_SCALE) * 0.85;
	pango_font_description_set_absolute_size (font_desc, font_size);
	pango_font_description_set_weight (font_desc, PANGO_WEIGHT_BOLD);
	_tmp24_ = (PangoAttrFontDesc*) pango_attr_font_desc_new (font_desc);
	font_attribute = _tmp24_;
	_tmp25_ = font_attribute;
	((PangoAttribute*) _tmp25_)->start_index = (guint) 0;
	_tmp26_ = font_attribute;
	_tmp27_ = G_MAXUINT;
	((PangoAttribute*) _tmp26_)->end_index = _tmp27_;
	_tmp28_ = attributes;
	_tmp29_ = font_attribute;
	font_attribute = NULL;
	pango_attr_list_insert (_tmp28_, (PangoAttribute*) _tmp29_);
	_tmp30_ = layout;
	_tmp31_ = attributes;
	pango_layout_set_attributes (_tmp30_, _tmp31_);
	_tmp32_ = minefield_view_get_mine_size (self);
	_tmp33_ = _tmp32_;
	_tmp34_ = minefield_view_get_mine_size (self);
	_tmp35_ = _tmp34_;
	_tmp36_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, (gint) _tmp33_, (gint) _tmp35_);
	surface = _tmp36_;
	_tmp37_ = cairo_create (surface);
	c = _tmp37_;
	_tmp38_ = layout;
	pango_layout_get_extents (_tmp38_, NULL, &_tmp39_);
	extent = _tmp39_;
	_tmp40_ = minefield_view_get_mine_size (self);
	_tmp41_ = _tmp40_;
	_tmp42_ = extent;
	_tmp43_ = _tmp42_.width;
	dx = (((((gint) _tmp41_) - 2) - (_tmp43_ / PANGO_SCALE)) / 2) + 1;
	_tmp44_ = minefield_view_get_mine_size (self);
	_tmp45_ = _tmp44_;
	_tmp46_ = extent;
	_tmp47_ = _tmp46_.height;
	dy = (((((gint) _tmp45_) - 2) - (_tmp47_ / PANGO_SCALE)) / 2) + 1;
	cairo_move_to (c, (gdouble) dx, (gdouble) dy);
	_tmp48_ = layout;
	pango_cairo_show_layout (c, _tmp48_);
	_tmp49_ = cairo_pattern_create_for_surface (surface);
	pattern = _tmp49_;
	cairo_pattern_set_extend (pattern, CAIRO_EXTEND_REPEAT);
	result = pattern;
	_cairo_destroy0 (c);
	_cairo_surface_destroy0 (surface);
	_pango_attribute_destroy0 (font_attribute);
	_pango_font_description_free0 (font_desc);
	_pango_attribute_destroy0 (color_attribute);
	_pango_attr_list_unref0 (attributes);
	_g_object_unref0 (layout);
	return result;
}


static void minefield_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural) {
	MinefieldView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	Minefield* _tmp0_;
	Minefield* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	self = (MinefieldView*) base;
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->width;
	_tmp3_ = minefield_view_get_minimum_size (self);
	_tmp4_ = _tmp3_;
	_vala_natural = (gint) (_tmp2_ * _tmp4_);
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void minefield_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural) {
	MinefieldView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	Minefield* _tmp0_;
	Minefield* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	self = (MinefieldView*) base;
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->height;
	_tmp3_ = minefield_view_get_minimum_size (self);
	_tmp4_ = _tmp3_;
	_vala_natural = (gint) (_tmp2_ * _tmp4_);
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void minefield_view_redraw_sector_cb (MinefieldView* self, guint x, guint y) {
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = minefield_view_get_x_offset (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = minefield_view_get_mine_size (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = minefield_view_get_y_offset (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = y;
	_tmp8_ = minefield_view_get_mine_size (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = minefield_view_get_mine_size (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = minefield_view_get_mine_size (self);
	_tmp13_ = _tmp12_;
	gtk_widget_queue_draw_area ((GtkWidget*) self, (gint) (_tmp1_ + (_tmp2_ * _tmp4_)), (gint) (_tmp6_ + (_tmp7_ * _tmp9_)), (gint) _tmp11_, (gint) _tmp13_);
}


static void minefield_view_draw_square (MinefieldView* self, cairo_t* cr, guint x, guint y) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	guint _tmp2_;
	gint _tmp3_;
	gboolean _tmp6_;
	gboolean _tmp12_;
	gboolean is_down;
	gboolean _tmp13_ = FALSE;
	gint _tmp14_;
	gboolean _tmp20_;
	Minefield* _tmp45_;
	Minefield* _tmp46_;
	guint _tmp47_;
	guint _tmp48_;
	gboolean _tmp49_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp2_ = x;
	_tmp3_ = self->priv->selected_x;
	if (_tmp2_ == ((guint) _tmp3_)) {
		guint _tmp4_;
		gint _tmp5_;
		_tmp4_ = y;
		_tmp5_ = self->priv->selected_y;
		_tmp1_ = _tmp4_ == ((guint) _tmp5_);
	} else {
		_tmp1_ = FALSE;
	}
	_tmp6_ = _tmp1_;
	if (_tmp6_) {
		Minefield* _tmp7_;
		Minefield* _tmp8_;
		guint _tmp9_;
		guint _tmp10_;
		FlagType _tmp11_ = 0;
		_tmp7_ = minefield_view_get_minefield (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = x;
		_tmp10_ = y;
		_tmp11_ = minefield_get_flag (_tmp8_, _tmp9_, _tmp10_);
		_tmp0_ = _tmp11_ != FLAG_TYPE_FLAG;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp12_ = _tmp0_;
	is_down = _tmp12_;
	_tmp14_ = self->priv->selected_x;
	if (_tmp14_ >= 0) {
		Minefield* _tmp15_;
		Minefield* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gboolean _tmp19_ = FALSE;
		_tmp15_ = minefield_view_get_minefield (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->selected_x;
		_tmp18_ = self->priv->selected_y;
		_tmp19_ = minefield_is_cleared (_tmp16_, (guint) _tmp17_, (guint) _tmp18_);
		_tmp13_ = _tmp19_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp20_ = _tmp13_;
	if (_tmp20_) {
		{
			Neighbour* neighbour_collection = NULL;
			gint neighbour_collection_length1 = 0;
			gint _neighbour_collection_size_ = 0;
			gint neighbour_it = 0;
			neighbour_collection = neighbour_map;
			neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
			for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
				Neighbour neighbour = {0};
				neighbour = neighbour_collection[neighbour_it];
				{
					gint _tmp21_;
					Neighbour _tmp22_;
					gint _tmp23_;
					gint nx;
					gint _tmp24_;
					Neighbour _tmp25_;
					gint _tmp26_;
					gint ny;
					Minefield* _tmp27_;
					Minefield* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					gboolean _tmp31_ = FALSE;
					gboolean _tmp32_ = FALSE;
					gboolean _tmp33_ = FALSE;
					guint _tmp34_;
					gint _tmp35_;
					gboolean _tmp38_;
					gboolean _tmp44_;
					_tmp21_ = self->priv->selected_x;
					_tmp22_ = neighbour;
					_tmp23_ = _tmp22_.x;
					nx = _tmp21_ + _tmp23_;
					_tmp24_ = self->priv->selected_y;
					_tmp25_ = neighbour;
					_tmp26_ = _tmp25_.y;
					ny = _tmp24_ + _tmp26_;
					_tmp27_ = minefield_view_get_minefield (self);
					_tmp28_ = _tmp27_;
					_tmp29_ = nx;
					_tmp30_ = ny;
					_tmp31_ = minefield_is_location (_tmp28_, (guint) _tmp29_, (guint) _tmp30_);
					if (!_tmp31_) {
						continue;
					}
					_tmp34_ = x;
					_tmp35_ = nx;
					if (_tmp34_ == ((guint) _tmp35_)) {
						guint _tmp36_;
						gint _tmp37_;
						_tmp36_ = y;
						_tmp37_ = ny;
						_tmp33_ = _tmp36_ == ((guint) _tmp37_);
					} else {
						_tmp33_ = FALSE;
					}
					_tmp38_ = _tmp33_;
					if (_tmp38_) {
						Minefield* _tmp39_;
						Minefield* _tmp40_;
						gint _tmp41_;
						gint _tmp42_;
						FlagType _tmp43_ = 0;
						_tmp39_ = minefield_view_get_minefield (self);
						_tmp40_ = _tmp39_;
						_tmp41_ = nx;
						_tmp42_ = ny;
						_tmp43_ = minefield_get_flag (_tmp40_, (guint) _tmp41_, (guint) _tmp42_);
						_tmp32_ = _tmp43_ != FLAG_TYPE_FLAG;
					} else {
						_tmp32_ = FALSE;
					}
					_tmp44_ = _tmp32_;
					if (_tmp44_) {
						is_down = TRUE;
					}
				}
			}
		}
	}
	_tmp45_ = minefield_view_get_minefield (self);
	_tmp46_ = _tmp45_;
	_tmp47_ = x;
	_tmp48_ = y;
	_tmp49_ = minefield_is_cleared (_tmp46_, _tmp47_, _tmp48_);
	if (_tmp49_) {
		GtkStateType _tmp50_ = 0;
		gboolean _tmp51_;
		GtkStyle* _tmp52_ = NULL;
		cairo_t* _tmp53_;
		GtkStateType _tmp54_;
		guint _tmp55_;
		guint _tmp56_;
		guint _tmp57_;
		guint _tmp58_;
		guint _tmp59_;
		guint _tmp64_;
		cairo_t* _tmp69_;
		guint _tmp70_;
		guint _tmp71_;
		cairo_t* _tmp72_;
		guint _tmp73_;
		guint _tmp74_;
		guint _tmp75_;
		guint _tmp76_;
		cairo_t* _tmp77_;
		guint _tmp78_;
		guint _tmp79_;
		cairo_t* _tmp80_;
		guint _tmp81_;
		guint _tmp82_;
		guint _tmp83_;
		guint _tmp84_;
		cairo_t* _tmp85_;
		cairo_t* _tmp86_;
		GtkStyle* _tmp87_ = NULL;
		GdkColor* _tmp88_;
		gint _tmp88__length1;
		GtkStateType _tmp89_ = 0;
		GdkColor _tmp90_;
		cairo_t* _tmp91_;
		gdouble* _tmp92_ = NULL;
		gdouble* dots;
		gint dots_length1;
		gint _dots_size_;
		cairo_t* _tmp93_;
		gdouble* _tmp94_;
		gint _tmp94__length1;
		cairo_t* _tmp95_;
		cairo_t* _tmp96_;
		gboolean _tmp97_;
		gboolean _tmp98_;
		Minefield* _tmp99_;
		Minefield* _tmp100_;
		guint _tmp101_;
		guint _tmp102_;
		gboolean _tmp103_ = FALSE;
		_tmp51_ = is_down;
		if (_tmp51_) {
			_tmp50_ = GTK_STATE_ACTIVE;
		} else {
			_tmp50_ = GTK_STATE_NORMAL;
		}
		_tmp52_ = gtk_widget_get_style ((GtkWidget*) self);
		_tmp53_ = cr;
		_tmp54_ = _tmp50_;
		_tmp55_ = minefield_view_get_mine_size (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = minefield_view_get_mine_size (self);
		_tmp58_ = _tmp57_;
		gtk_paint_box (_tmp52_, _tmp53_, _tmp54_, GTK_SHADOW_IN, (GtkWidget*) self, "button", 0, 0, (gint) _tmp56_, (gint) _tmp58_);
		_tmp59_ = y;
		if (_tmp59_ == ((guint) 0)) {
			cairo_t* _tmp60_;
			cairo_t* _tmp61_;
			guint _tmp62_;
			guint _tmp63_;
			_tmp60_ = cr;
			cairo_move_to (_tmp60_, (gdouble) 0, (gdouble) 0);
			_tmp61_ = cr;
			_tmp62_ = minefield_view_get_mine_size (self);
			_tmp63_ = _tmp62_;
			cairo_line_to (_tmp61_, (gdouble) (_tmp63_ - 1), (gdouble) 0);
		}
		_tmp64_ = x;
		if (_tmp64_ == ((guint) 0)) {
			cairo_t* _tmp65_;
			cairo_t* _tmp66_;
			guint _tmp67_;
			guint _tmp68_;
			_tmp65_ = cr;
			cairo_move_to (_tmp65_, (gdouble) 0, (gdouble) 0);
			_tmp66_ = cr;
			_tmp67_ = minefield_view_get_mine_size (self);
			_tmp68_ = _tmp67_;
			cairo_line_to (_tmp66_, (gdouble) 0, (gdouble) (_tmp68_ - 1));
		}
		_tmp69_ = cr;
		_tmp70_ = minefield_view_get_mine_size (self);
		_tmp71_ = _tmp70_;
		cairo_move_to (_tmp69_, (_tmp71_ - 1) + 0.5, 0.5);
		_tmp72_ = cr;
		_tmp73_ = minefield_view_get_mine_size (self);
		_tmp74_ = _tmp73_;
		_tmp75_ = minefield_view_get_mine_size (self);
		_tmp76_ = _tmp75_;
		cairo_line_to (_tmp72_, (_tmp74_ - 1) + 0.5, (_tmp76_ - 1) + 0.5);
		_tmp77_ = cr;
		_tmp78_ = minefield_view_get_mine_size (self);
		_tmp79_ = _tmp78_;
		cairo_move_to (_tmp77_, 0.5, (_tmp79_ - 1) + 0.5);
		_tmp80_ = cr;
		_tmp81_ = minefield_view_get_mine_size (self);
		_tmp82_ = _tmp81_;
		_tmp83_ = minefield_view_get_mine_size (self);
		_tmp84_ = _tmp83_;
		cairo_line_to (_tmp80_, (_tmp82_ - 1) + 0.5, (_tmp84_ - 1) + 0.5);
		_tmp85_ = cr;
		cairo_save (_tmp85_);
		_tmp86_ = cr;
		_tmp87_ = gtk_widget_get_style ((GtkWidget*) self);
		_tmp88_ = _tmp87_->dark;
		_tmp88__length1 = -1;
		_tmp89_ = gtk_widget_get_state ((GtkWidget*) self);
		_tmp90_ = _tmp88_[_tmp89_];
		gdk_cairo_set_source_color (_tmp86_, &_tmp90_);
		_tmp91_ = cr;
		cairo_set_line_width (_tmp91_, (gdouble) 1);
		_tmp92_ = g_new0 (gdouble, 2);
		_tmp92_[0] = (gdouble) 2;
		_tmp92_[1] = (gdouble) 2;
		dots = _tmp92_;
		dots_length1 = 2;
		_dots_size_ = dots_length1;
		_tmp93_ = cr;
		_tmp94_ = dots;
		_tmp94__length1 = dots_length1;
		cairo_set_dash (_tmp93_, _tmp94_, _tmp94__length1, (gdouble) 0);
		_tmp95_ = cr;
		cairo_stroke (_tmp95_);
		_tmp96_ = cr;
		cairo_restore (_tmp96_);
		_tmp97_ = minefield_view_get_paused (self);
		_tmp98_ = _tmp97_;
		if (_tmp98_) {
			dots = (g_free (dots), NULL);
			return;
		}
		_tmp99_ = minefield_view_get_minefield (self);
		_tmp100_ = _tmp99_;
		_tmp101_ = x;
		_tmp102_ = y;
		_tmp103_ = minefield_has_mine (_tmp100_, _tmp101_, _tmp102_);
		if (_tmp103_) {
			cairo_pattern_t* _tmp104_;
			cairo_t* _tmp108_;
			cairo_pattern_t* _tmp109_;
			cairo_t* _tmp110_;
			guint _tmp111_;
			guint _tmp112_;
			guint _tmp113_;
			guint _tmp114_;
			cairo_t* _tmp115_;
			_tmp104_ = self->priv->bang_pattern;
			if (_tmp104_ == NULL) {
				cairo_t* _tmp105_;
				GamesPreimage* _tmp106_;
				cairo_pattern_t* _tmp107_ = NULL;
				_tmp105_ = cr;
				_tmp106_ = self->priv->bang_preimage;
				_tmp107_ = minefield_view_render_preimage_pattern (self, _tmp105_, _tmp106_);
				_cairo_pattern_destroy0 (self->priv->bang_pattern);
				self->priv->bang_pattern = _tmp107_;
			}
			_tmp108_ = cr;
			_tmp109_ = self->priv->bang_pattern;
			cairo_set_source (_tmp108_, _tmp109_);
			_tmp110_ = cr;
			_tmp111_ = minefield_view_get_mine_size (self);
			_tmp112_ = _tmp111_;
			_tmp113_ = minefield_view_get_mine_size (self);
			_tmp114_ = _tmp113_;
			cairo_rectangle (_tmp110_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp112_, (gdouble) _tmp114_);
			_tmp115_ = cr;
			cairo_fill (_tmp115_);
		} else {
			gboolean _tmp116_ = FALSE;
			gboolean _tmp117_;
			gboolean _tmp123_;
			Minefield* _tmp136_;
			Minefield* _tmp137_;
			guint _tmp138_;
			guint _tmp139_;
			guint _tmp140_ = 0U;
			guint n;
			guint _tmp141_;
			_tmp117_ = self->priv->use_overmine_warning;
			if (_tmp117_) {
				Minefield* _tmp118_;
				Minefield* _tmp119_;
				guint _tmp120_;
				guint _tmp121_;
				gboolean _tmp122_ = FALSE;
				_tmp118_ = minefield_view_get_minefield (self);
				_tmp119_ = _tmp118_;
				_tmp120_ = x;
				_tmp121_ = y;
				_tmp122_ = minefield_has_flag_warning (_tmp119_, _tmp120_, _tmp121_);
				_tmp116_ = _tmp122_;
			} else {
				_tmp116_ = FALSE;
			}
			_tmp123_ = _tmp116_;
			if (_tmp123_) {
				cairo_pattern_t* _tmp124_;
				cairo_t* _tmp128_;
				cairo_pattern_t* _tmp129_;
				cairo_t* _tmp130_;
				guint _tmp131_;
				guint _tmp132_;
				guint _tmp133_;
				guint _tmp134_;
				cairo_t* _tmp135_;
				_tmp124_ = self->priv->warning_pattern;
				if (_tmp124_ == NULL) {
					cairo_t* _tmp125_;
					GamesPreimage* _tmp126_;
					cairo_pattern_t* _tmp127_ = NULL;
					_tmp125_ = cr;
					_tmp126_ = self->priv->warning_preimage;
					_tmp127_ = minefield_view_render_preimage_pattern (self, _tmp125_, _tmp126_);
					_cairo_pattern_destroy0 (self->priv->warning_pattern);
					self->priv->warning_pattern = _tmp127_;
				}
				_tmp128_ = cr;
				_tmp129_ = self->priv->warning_pattern;
				cairo_set_source (_tmp128_, _tmp129_);
				_tmp130_ = cr;
				_tmp131_ = minefield_view_get_mine_size (self);
				_tmp132_ = _tmp131_;
				_tmp133_ = minefield_view_get_mine_size (self);
				_tmp134_ = _tmp133_;
				cairo_rectangle (_tmp130_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp132_, (gdouble) _tmp134_);
				_tmp135_ = cr;
				cairo_fill (_tmp135_);
			}
			_tmp136_ = minefield_view_get_minefield (self);
			_tmp137_ = _tmp136_;
			_tmp138_ = x;
			_tmp139_ = y;
			_tmp140_ = minefield_get_n_adjacent_mines (_tmp137_, _tmp138_, _tmp139_);
			n = _tmp140_;
			_tmp141_ = n;
			if (_tmp141_ != ((guint) 0)) {
				cairo_pattern_t** _tmp142_;
				gint _tmp142__length1;
				guint _tmp143_;
				cairo_pattern_t* _tmp144_;
				cairo_t* _tmp150_;
				cairo_pattern_t** _tmp151_;
				gint _tmp151__length1;
				guint _tmp152_;
				cairo_pattern_t* _tmp153_;
				cairo_t* _tmp154_;
				guint _tmp155_;
				guint _tmp156_;
				guint _tmp157_;
				guint _tmp158_;
				cairo_t* _tmp159_;
				_tmp142_ = self->priv->number_patterns;
				_tmp142__length1 = self->priv->number_patterns_length1;
				_tmp143_ = n;
				_tmp144_ = _tmp142_[_tmp143_ - 1];
				if (_tmp144_ == NULL) {
					cairo_pattern_t** _tmp145_;
					gint _tmp145__length1;
					guint _tmp146_;
					guint _tmp147_;
					cairo_pattern_t* _tmp148_ = NULL;
					cairo_pattern_t* _tmp149_;
					_tmp145_ = self->priv->number_patterns;
					_tmp145__length1 = self->priv->number_patterns_length1;
					_tmp146_ = n;
					_tmp147_ = n;
					_tmp148_ = minefield_view_render_number_pattern (self, _tmp147_);
					_cairo_pattern_destroy0 (_tmp145_[_tmp146_ - 1]);
					_tmp145_[_tmp146_ - 1] = _tmp148_;
					_tmp149_ = _tmp145_[_tmp146_ - 1];
				}
				_tmp150_ = cr;
				_tmp151_ = self->priv->number_patterns;
				_tmp151__length1 = self->priv->number_patterns_length1;
				_tmp152_ = n;
				_tmp153_ = _tmp151_[_tmp152_ - 1];
				cairo_set_source (_tmp150_, _tmp153_);
				_tmp154_ = cr;
				_tmp155_ = minefield_view_get_mine_size (self);
				_tmp156_ = _tmp155_;
				_tmp157_ = minefield_view_get_mine_size (self);
				_tmp158_ = _tmp157_;
				cairo_rectangle (_tmp154_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp156_, (gdouble) _tmp158_);
				_tmp159_ = cr;
				cairo_fill (_tmp159_);
			}
		}
		dots = (g_free (dots), NULL);
	} else {
		GtkStateType _tmp160_ = 0;
		gboolean _tmp161_;
		GtkShadowType _tmp162_ = 0;
		gboolean _tmp163_;
		GtkStyle* _tmp164_ = NULL;
		cairo_t* _tmp165_;
		GtkStateType _tmp166_;
		GtkShadowType _tmp167_;
		guint _tmp168_;
		guint _tmp169_;
		guint _tmp170_;
		guint _tmp171_;
		gboolean _tmp172_;
		gboolean _tmp173_;
		Minefield* _tmp174_;
		Minefield* _tmp175_;
		guint _tmp176_;
		guint _tmp177_;
		FlagType _tmp178_ = 0;
		_tmp161_ = is_down;
		if (_tmp161_) {
			_tmp160_ = GTK_STATE_ACTIVE;
		} else {
			_tmp160_ = GTK_STATE_SELECTED;
		}
		_tmp163_ = is_down;
		if (_tmp163_) {
			_tmp162_ = GTK_SHADOW_IN;
		} else {
			_tmp162_ = GTK_SHADOW_OUT;
		}
		_tmp164_ = gtk_widget_get_style ((GtkWidget*) self);
		_tmp165_ = cr;
		_tmp166_ = _tmp160_;
		_tmp167_ = _tmp162_;
		_tmp168_ = minefield_view_get_mine_size (self);
		_tmp169_ = _tmp168_;
		_tmp170_ = minefield_view_get_mine_size (self);
		_tmp171_ = _tmp170_;
		gtk_paint_box (_tmp164_, _tmp165_, _tmp166_, _tmp167_, (GtkWidget*) self, "button", 0, 0, (gint) _tmp169_, (gint) _tmp171_);
		_tmp172_ = minefield_view_get_paused (self);
		_tmp173_ = _tmp172_;
		if (_tmp173_) {
			return;
		}
		_tmp174_ = minefield_view_get_minefield (self);
		_tmp175_ = _tmp174_;
		_tmp176_ = x;
		_tmp177_ = y;
		_tmp178_ = minefield_get_flag (_tmp175_, _tmp176_, _tmp177_);
		if (_tmp178_ == FLAG_TYPE_FLAG) {
			cairo_pattern_t* _tmp179_;
			cairo_t* _tmp183_;
			cairo_pattern_t* _tmp184_;
			cairo_t* _tmp185_;
			guint _tmp186_;
			guint _tmp187_;
			guint _tmp188_;
			guint _tmp189_;
			cairo_t* _tmp190_;
			gboolean _tmp191_ = FALSE;
			Minefield* _tmp192_;
			Minefield* _tmp193_;
			gboolean _tmp194_;
			gboolean _tmp200_;
			_tmp179_ = self->priv->flag_pattern;
			if (_tmp179_ == NULL) {
				cairo_t* _tmp180_;
				GamesPreimage* _tmp181_;
				cairo_pattern_t* _tmp182_ = NULL;
				_tmp180_ = cr;
				_tmp181_ = self->priv->flag_preimage;
				_tmp182_ = minefield_view_render_preimage_pattern (self, _tmp180_, _tmp181_);
				_cairo_pattern_destroy0 (self->priv->flag_pattern);
				self->priv->flag_pattern = _tmp182_;
			}
			_tmp183_ = cr;
			_tmp184_ = self->priv->flag_pattern;
			cairo_set_source (_tmp183_, _tmp184_);
			_tmp185_ = cr;
			_tmp186_ = minefield_view_get_mine_size (self);
			_tmp187_ = _tmp186_;
			_tmp188_ = minefield_view_get_mine_size (self);
			_tmp189_ = _tmp188_;
			cairo_rectangle (_tmp185_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp187_, (gdouble) _tmp189_);
			_tmp190_ = cr;
			cairo_fill (_tmp190_);
			_tmp192_ = minefield_view_get_minefield (self);
			_tmp193_ = _tmp192_;
			_tmp194_ = _tmp193_->exploded;
			if (_tmp194_) {
				Minefield* _tmp195_;
				Minefield* _tmp196_;
				guint _tmp197_;
				guint _tmp198_;
				gboolean _tmp199_ = FALSE;
				_tmp195_ = minefield_view_get_minefield (self);
				_tmp196_ = _tmp195_;
				_tmp197_ = x;
				_tmp198_ = y;
				_tmp199_ = minefield_has_mine (_tmp196_, _tmp197_, _tmp198_);
				_tmp191_ = !_tmp199_;
			} else {
				_tmp191_ = FALSE;
			}
			_tmp200_ = _tmp191_;
			if (_tmp200_) {
				guint _tmp201_;
				guint _tmp202_;
				gdouble x1;
				guint _tmp203_;
				guint _tmp204_;
				gdouble y1;
				guint _tmp205_;
				guint _tmp206_;
				gdouble x2;
				guint _tmp207_;
				guint _tmp208_;
				gdouble y2;
				cairo_t* _tmp209_;
				gdouble _tmp210_;
				gdouble _tmp211_;
				cairo_t* _tmp212_;
				gdouble _tmp213_;
				gdouble _tmp214_;
				cairo_t* _tmp215_;
				gdouble _tmp216_;
				gdouble _tmp217_;
				cairo_t* _tmp218_;
				gdouble _tmp219_;
				gdouble _tmp220_;
				cairo_t* _tmp221_;
				cairo_t* _tmp222_;
				GtkStyle* _tmp223_ = NULL;
				GdkColor _tmp224_;
				cairo_t* _tmp225_;
				guint _tmp226_;
				guint _tmp227_;
				gdouble _tmp228_ = 0.0;
				cairo_t* _tmp229_;
				cairo_t* _tmp230_;
				cairo_t* _tmp231_;
				cairo_t* _tmp232_;
				_tmp201_ = minefield_view_get_mine_size (self);
				_tmp202_ = _tmp201_;
				x1 = 0.1 * _tmp202_;
				_tmp203_ = minefield_view_get_mine_size (self);
				_tmp204_ = _tmp203_;
				y1 = 0.1 * _tmp204_;
				_tmp205_ = minefield_view_get_mine_size (self);
				_tmp206_ = _tmp205_;
				x2 = 0.9 * _tmp206_;
				_tmp207_ = minefield_view_get_mine_size (self);
				_tmp208_ = _tmp207_;
				y2 = 0.9 * _tmp208_;
				_tmp209_ = cr;
				_tmp210_ = x1;
				_tmp211_ = y1;
				cairo_move_to (_tmp209_, _tmp210_, _tmp211_);
				_tmp212_ = cr;
				_tmp213_ = x2;
				_tmp214_ = y2;
				cairo_line_to (_tmp212_, _tmp213_, _tmp214_);
				_tmp215_ = cr;
				_tmp216_ = x1;
				_tmp217_ = y2;
				cairo_move_to (_tmp215_, _tmp216_, _tmp217_);
				_tmp218_ = cr;
				_tmp219_ = x2;
				_tmp220_ = y1;
				cairo_line_to (_tmp218_, _tmp219_, _tmp220_);
				_tmp221_ = cr;
				cairo_save (_tmp221_);
				_tmp222_ = cr;
				_tmp223_ = gtk_widget_get_style ((GtkWidget*) self);
				_tmp224_ = _tmp223_->black;
				gdk_cairo_set_source_color (_tmp222_, &_tmp224_);
				_tmp225_ = cr;
				_tmp226_ = minefield_view_get_mine_size (self);
				_tmp227_ = _tmp226_;
				_tmp228_ = MAX ((gdouble) 1, 0.1 * _tmp227_);
				cairo_set_line_width (_tmp225_, _tmp228_);
				_tmp229_ = cr;
				cairo_set_line_join (_tmp229_, CAIRO_LINE_JOIN_ROUND);
				_tmp230_ = cr;
				cairo_set_line_cap (_tmp230_, CAIRO_LINE_CAP_ROUND);
				_tmp231_ = cr;
				cairo_stroke (_tmp231_);
				_tmp232_ = cr;
				cairo_restore (_tmp232_);
			}
		} else {
			gboolean _tmp233_ = FALSE;
			Minefield* _tmp234_;
			Minefield* _tmp235_;
			gboolean _tmp236_;
			gboolean _tmp242_;
			_tmp234_ = minefield_view_get_minefield (self);
			_tmp235_ = _tmp234_;
			_tmp236_ = _tmp235_->exploded;
			if (_tmp236_) {
				Minefield* _tmp237_;
				Minefield* _tmp238_;
				guint _tmp239_;
				guint _tmp240_;
				gboolean _tmp241_ = FALSE;
				_tmp237_ = minefield_view_get_minefield (self);
				_tmp238_ = _tmp237_;
				_tmp239_ = x;
				_tmp240_ = y;
				_tmp241_ = minefield_has_mine (_tmp238_, _tmp239_, _tmp240_);
				_tmp233_ = _tmp241_;
			} else {
				_tmp233_ = FALSE;
			}
			_tmp242_ = _tmp233_;
			if (_tmp242_) {
				cairo_pattern_t* _tmp243_;
				cairo_t* _tmp247_;
				cairo_pattern_t* _tmp248_;
				cairo_t* _tmp249_;
				guint _tmp250_;
				guint _tmp251_;
				guint _tmp252_;
				guint _tmp253_;
				cairo_t* _tmp254_;
				_tmp243_ = self->priv->mine_pattern;
				if (_tmp243_ == NULL) {
					cairo_t* _tmp244_;
					GamesPreimage* _tmp245_;
					cairo_pattern_t* _tmp246_ = NULL;
					_tmp244_ = cr;
					_tmp245_ = self->priv->mine_preimage;
					_tmp246_ = minefield_view_render_preimage_pattern (self, _tmp244_, _tmp245_);
					_cairo_pattern_destroy0 (self->priv->mine_pattern);
					self->priv->mine_pattern = _tmp246_;
				}
				_tmp247_ = cr;
				_tmp248_ = self->priv->mine_pattern;
				cairo_set_source (_tmp247_, _tmp248_);
				_tmp249_ = cr;
				_tmp250_ = minefield_view_get_mine_size (self);
				_tmp251_ = _tmp250_;
				_tmp252_ = minefield_view_get_mine_size (self);
				_tmp253_ = _tmp252_;
				cairo_rectangle (_tmp249_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp251_, (gdouble) _tmp253_);
				_tmp254_ = cr;
				cairo_fill (_tmp254_);
			} else {
				Minefield* _tmp255_;
				Minefield* _tmp256_;
				guint _tmp257_;
				guint _tmp258_;
				FlagType _tmp259_ = 0;
				_tmp255_ = minefield_view_get_minefield (self);
				_tmp256_ = _tmp255_;
				_tmp257_ = x;
				_tmp258_ = y;
				_tmp259_ = minefield_get_flag (_tmp256_, _tmp257_, _tmp258_);
				if (_tmp259_ == FLAG_TYPE_MAYBE) {
					cairo_pattern_t* _tmp260_;
					cairo_t* _tmp264_;
					cairo_pattern_t* _tmp265_;
					cairo_t* _tmp266_;
					guint _tmp267_;
					guint _tmp268_;
					guint _tmp269_;
					guint _tmp270_;
					cairo_t* _tmp271_;
					_tmp260_ = self->priv->question_pattern;
					if (_tmp260_ == NULL) {
						cairo_t* _tmp261_;
						GamesPreimage* _tmp262_;
						cairo_pattern_t* _tmp263_ = NULL;
						_tmp261_ = cr;
						_tmp262_ = self->priv->question_preimage;
						_tmp263_ = minefield_view_render_preimage_pattern (self, _tmp261_, _tmp262_);
						_cairo_pattern_destroy0 (self->priv->question_pattern);
						self->priv->question_pattern = _tmp263_;
					}
					_tmp264_ = cr;
					_tmp265_ = self->priv->question_pattern;
					cairo_set_source (_tmp264_, _tmp265_);
					_tmp266_ = cr;
					_tmp267_ = minefield_view_get_mine_size (self);
					_tmp268_ = _tmp267_;
					_tmp269_ = minefield_view_get_mine_size (self);
					_tmp270_ = _tmp269_;
					cairo_rectangle (_tmp266_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp268_, (gdouble) _tmp270_);
					_tmp271_ = cr;
					cairo_fill (_tmp271_);
				}
			}
		}
	}
}


static gboolean minefield_view_real_draw (GtkWidget* base, cairo_t* cr) {
	MinefieldView * self;
	gboolean result = FALSE;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	self = (MinefieldView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = self->priv->render_size;
	_tmp1_ = minefield_view_get_mine_size (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ != _tmp2_) {
		guint _tmp3_;
		guint _tmp4_;
		_tmp3_ = minefield_view_get_mine_size (self);
		_tmp4_ = _tmp3_;
		self->priv->render_size = _tmp4_;
		_cairo_pattern_destroy0 (self->priv->flag_pattern);
		self->priv->flag_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->mine_pattern);
		self->priv->mine_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->question_pattern);
		self->priv->question_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->bang_pattern);
		self->priv->bang_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->warning_pattern);
		self->priv->warning_pattern = NULL;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp5_;
				_tmp5_ = TRUE;
				while (TRUE) {
					gboolean _tmp6_;
					gint _tmp8_;
					cairo_pattern_t** _tmp9_;
					gint _tmp9__length1;
					cairo_pattern_t** _tmp10_;
					gint _tmp10__length1;
					gint _tmp11_;
					cairo_pattern_t* _tmp12_;
					_tmp6_ = _tmp5_;
					if (!_tmp6_) {
						gint _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp8_ = i;
					_tmp9_ = self->priv->number_patterns;
					_tmp9__length1 = self->priv->number_patterns_length1;
					if (!(_tmp8_ < _tmp9__length1)) {
						break;
					}
					_tmp10_ = self->priv->number_patterns;
					_tmp10__length1 = self->priv->number_patterns_length1;
					_tmp11_ = i;
					_cairo_pattern_destroy0 (_tmp10_[_tmp11_]);
					_tmp10_[_tmp11_] = NULL;
					_tmp12_ = _tmp10_[_tmp11_];
				}
			}
		}
	}
	{
		gint x;
		x = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_;
				gint _tmp16_;
				Minefield* _tmp17_;
				Minefield* _tmp18_;
				guint _tmp19_;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = x;
					x = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = x;
				_tmp17_ = minefield_view_get_minefield (self);
				_tmp18_ = _tmp17_;
				_tmp19_ = _tmp18_->width;
				if (!(((guint) _tmp16_) < _tmp19_)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp20_;
						_tmp20_ = TRUE;
						while (TRUE) {
							gboolean _tmp21_;
							gint _tmp23_;
							Minefield* _tmp24_;
							Minefield* _tmp25_;
							guint _tmp26_;
							cairo_t* _tmp27_;
							cairo_t* _tmp28_;
							guint _tmp29_;
							guint _tmp30_;
							gint _tmp31_;
							guint _tmp32_;
							guint _tmp33_;
							guint _tmp34_;
							guint _tmp35_;
							gint _tmp36_;
							guint _tmp37_;
							guint _tmp38_;
							cairo_t* _tmp39_;
							gint _tmp40_;
							gint _tmp41_;
							cairo_t* _tmp42_;
							_tmp21_ = _tmp20_;
							if (!_tmp21_) {
								gint _tmp22_;
								_tmp22_ = y;
								y = _tmp22_ + 1;
							}
							_tmp20_ = FALSE;
							_tmp23_ = y;
							_tmp24_ = minefield_view_get_minefield (self);
							_tmp25_ = _tmp24_;
							_tmp26_ = _tmp25_->height;
							if (!(((guint) _tmp23_) < _tmp26_)) {
								break;
							}
							_tmp27_ = cr;
							cairo_save (_tmp27_);
							_tmp28_ = cr;
							_tmp29_ = minefield_view_get_x_offset (self);
							_tmp30_ = _tmp29_;
							_tmp31_ = x;
							_tmp32_ = minefield_view_get_mine_size (self);
							_tmp33_ = _tmp32_;
							_tmp34_ = minefield_view_get_y_offset (self);
							_tmp35_ = _tmp34_;
							_tmp36_ = y;
							_tmp37_ = minefield_view_get_mine_size (self);
							_tmp38_ = _tmp37_;
							cairo_translate (_tmp28_, (gdouble) (_tmp30_ + (_tmp31_ * _tmp33_)), (gdouble) (_tmp35_ + (_tmp36_ * _tmp38_)));
							_tmp39_ = cr;
							_tmp40_ = x;
							_tmp41_ = y;
							minefield_view_draw_square (self, _tmp39_, (guint) _tmp40_, (guint) _tmp41_);
							_tmp42_ = cr;
							cairo_restore (_tmp42_);
						}
					}
				}
			}
		}
	}
	_tmp43_ = minefield_view_get_paused (self);
	_tmp44_ = _tmp43_;
	if (_tmp44_) {
		cairo_t* _tmp45_;
		cairo_t* _tmp46_;
		cairo_t* _tmp47_;
		cairo_t* _tmp48_;
		gint _tmp49_ = 0;
		const gchar* _tmp50_ = NULL;
		gchar* _tmp51_;
		gchar* text;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp52_;
		const gchar* _tmp53_;
		cairo_text_extents_t _tmp54_ = {0};
		cairo_t* _tmp55_;
		gint _tmp56_ = 0;
		cairo_text_extents_t _tmp57_;
		gdouble _tmp58_;
		gint _tmp59_ = 0;
		cairo_text_extents_t _tmp60_;
		gdouble _tmp61_;
		cairo_t* _tmp62_;
		cairo_t* _tmp63_;
		const gchar* _tmp64_;
		_tmp45_ = cr;
		cairo_set_source_rgba (_tmp45_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
		_tmp46_ = cr;
		cairo_paint (_tmp46_);
		_tmp47_ = cr;
		cairo_select_font_face (_tmp47_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		_tmp48_ = cr;
		_tmp49_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		cairo_set_font_size (_tmp48_, _tmp49_ * 0.125);
		_tmp50_ = _ ("Paused");
		_tmp51_ = g_strdup (_tmp50_);
		text = _tmp51_;
		_tmp52_ = cr;
		_tmp53_ = text;
		cairo_text_extents (_tmp52_, _tmp53_, &_tmp54_);
		extents = _tmp54_;
		_tmp55_ = cr;
		_tmp56_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp57_ = extents;
		_tmp58_ = _tmp57_.width;
		_tmp59_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp60_ = extents;
		_tmp61_ = _tmp60_.height;
		cairo_move_to (_tmp55_, (_tmp56_ - _tmp58_) / 2.0, (_tmp59_ + _tmp61_) / 2.0);
		_tmp62_ = cr;
		cairo_set_source_rgb (_tmp62_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp63_ = cr;
		_tmp64_ = text;
		cairo_show_text (_tmp63_, _tmp64_);
		_g_free0 (text);
	}
	result = FALSE;
	return result;
}


static void minefield_view_toggle_mark (MinefieldView* self, guint x, guint y) {
	Minefield* _tmp0_;
	Minefield* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	FlagType _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = y;
	_tmp4_ = minefield_get_flag (_tmp1_, _tmp2_, _tmp3_);
	switch (_tmp4_) {
		case FLAG_TYPE_NONE:
		{
			gboolean _tmp5_ = FALSE;
			Minefield* _tmp6_;
			Minefield* _tmp7_;
			guint _tmp8_;
			guint _tmp9_;
			Minefield* _tmp10_;
			Minefield* _tmp11_;
			guint _tmp12_;
			gboolean _tmp14_;
			_tmp6_ = minefield_view_get_minefield (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = minefield_get_n_flags (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = minefield_view_get_minefield (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = _tmp11_->n_mines;
			if (_tmp9_ >= _tmp12_) {
				gboolean _tmp13_;
				_tmp13_ = self->priv->use_question_marks;
				_tmp5_ = _tmp13_;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp14_ = _tmp5_;
			if (_tmp14_) {
				Minefield* _tmp15_;
				Minefield* _tmp16_;
				guint _tmp17_;
				guint _tmp18_;
				_tmp15_ = minefield_view_get_minefield (self);
				_tmp16_ = _tmp15_;
				_tmp17_ = x;
				_tmp18_ = y;
				minefield_set_flag (_tmp16_, _tmp17_, _tmp18_, FLAG_TYPE_MAYBE);
			} else {
				Minefield* _tmp19_;
				Minefield* _tmp20_;
				guint _tmp21_;
				guint _tmp22_;
				_tmp19_ = minefield_view_get_minefield (self);
				_tmp20_ = _tmp19_;
				_tmp21_ = x;
				_tmp22_ = y;
				minefield_set_flag (_tmp20_, _tmp21_, _tmp22_, FLAG_TYPE_FLAG);
			}
			break;
		}
		case FLAG_TYPE_MAYBE:
		{
			Minefield* _tmp23_;
			Minefield* _tmp24_;
			guint _tmp25_;
			guint _tmp26_;
			_tmp23_ = minefield_view_get_minefield (self);
			_tmp24_ = _tmp23_;
			_tmp25_ = x;
			_tmp26_ = y;
			minefield_set_flag (_tmp24_, _tmp25_, _tmp26_, FLAG_TYPE_NONE);
			break;
		}
		case FLAG_TYPE_FLAG:
		{
			gboolean _tmp27_;
			_tmp27_ = self->priv->use_question_marks;
			if (_tmp27_) {
				Minefield* _tmp28_;
				Minefield* _tmp29_;
				guint _tmp30_;
				guint _tmp31_;
				_tmp28_ = minefield_view_get_minefield (self);
				_tmp29_ = _tmp28_;
				_tmp30_ = x;
				_tmp31_ = y;
				minefield_set_flag (_tmp29_, _tmp30_, _tmp31_, FLAG_TYPE_MAYBE);
			} else {
				Minefield* _tmp32_;
				Minefield* _tmp33_;
				guint _tmp34_;
				guint _tmp35_;
				_tmp32_ = minefield_view_get_minefield (self);
				_tmp33_ = _tmp32_;
				_tmp34_ = x;
				_tmp35_ = y;
				minefield_set_flag (_tmp33_, _tmp34_, _tmp35_, FLAG_TYPE_NONE);
			}
			break;
		}
		default:
		break;
	}
}


static void minefield_view_redraw_adjacent (MinefieldView* self, guint x, guint y) {
	g_return_if_fail (self != NULL);
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				guint _tmp0_;
				Neighbour _tmp1_;
				gint _tmp2_;
				guint nx;
				guint _tmp3_;
				Neighbour _tmp4_;
				gint _tmp5_;
				guint ny;
				Minefield* _tmp6_;
				Minefield* _tmp7_;
				guint _tmp8_;
				guint _tmp9_;
				gboolean _tmp10_ = FALSE;
				_tmp0_ = x;
				_tmp1_ = neighbour;
				_tmp2_ = _tmp1_.x;
				nx = _tmp0_ + _tmp2_;
				_tmp3_ = y;
				_tmp4_ = neighbour;
				_tmp5_ = _tmp4_.y;
				ny = _tmp3_ + _tmp5_;
				_tmp6_ = minefield_view_get_minefield (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = nx;
				_tmp9_ = ny;
				_tmp10_ = minefield_is_location (_tmp7_, _tmp8_, _tmp9_);
				if (_tmp10_) {
					guint _tmp11_;
					guint _tmp12_;
					_tmp11_ = nx;
					_tmp12_ = ny;
					minefield_view_redraw_sector_cb (self, _tmp11_, _tmp12_);
				}
			}
		}
	}
}


static gpointer _minefield_ref0 (gpointer self) {
	return self ? minefield_ref (self) : NULL;
}


static void minefield_view_multi_release (MinefieldView* self, guint x, guint y) {
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp11_;
	Minefield* _tmp12_;
	Minefield* _tmp13_;
	guint _tmp14_;
	guint _tmp15_;
	guint _tmp16_ = 0U;
	guint n_mines;
	guint n_flags;
	guint n_unknown;
	gboolean do_clear;
	guint _tmp40_;
	guint _tmp41_;
	Minefield* _tmp47_;
	Minefield* _tmp48_;
	Minefield* _tmp49_;
	Minefield* m;
	g_return_if_fail (self != NULL);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = x;
	_tmp4_ = y;
	_tmp5_ = minefield_is_cleared (_tmp2_, _tmp3_, _tmp4_);
	if (!_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp6_;
		Minefield* _tmp7_;
		guint _tmp8_;
		guint _tmp9_;
		FlagType _tmp10_ = 0;
		_tmp6_ = minefield_view_get_minefield (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = x;
		_tmp9_ = y;
		_tmp10_ = minefield_get_flag (_tmp7_, _tmp8_, _tmp9_);
		_tmp0_ = _tmp10_ == FLAG_TYPE_FLAG;
	}
	_tmp11_ = _tmp0_;
	if (_tmp11_) {
		return;
	}
	_tmp12_ = minefield_view_get_minefield (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = x;
	_tmp15_ = y;
	_tmp16_ = minefield_get_n_adjacent_mines (_tmp13_, _tmp14_, _tmp15_);
	n_mines = _tmp16_;
	n_flags = (guint) 0;
	n_unknown = (guint) 0;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				guint _tmp17_;
				Neighbour _tmp18_;
				gint _tmp19_;
				guint nx;
				guint _tmp20_;
				Neighbour _tmp21_;
				gint _tmp22_;
				guint ny;
				Minefield* _tmp23_;
				Minefield* _tmp24_;
				guint _tmp25_;
				guint _tmp26_;
				gboolean _tmp27_ = FALSE;
				Minefield* _tmp28_;
				Minefield* _tmp29_;
				guint _tmp30_;
				guint _tmp31_;
				FlagType _tmp32_ = 0;
				Minefield* _tmp34_;
				Minefield* _tmp35_;
				guint _tmp36_;
				guint _tmp37_;
				gboolean _tmp38_ = FALSE;
				_tmp17_ = x;
				_tmp18_ = neighbour;
				_tmp19_ = _tmp18_.x;
				nx = _tmp17_ + _tmp19_;
				_tmp20_ = y;
				_tmp21_ = neighbour;
				_tmp22_ = _tmp21_.y;
				ny = _tmp20_ + _tmp22_;
				_tmp23_ = minefield_view_get_minefield (self);
				_tmp24_ = _tmp23_;
				_tmp25_ = nx;
				_tmp26_ = ny;
				_tmp27_ = minefield_is_location (_tmp24_, _tmp25_, _tmp26_);
				if (!_tmp27_) {
					continue;
				}
				_tmp28_ = minefield_view_get_minefield (self);
				_tmp29_ = _tmp28_;
				_tmp30_ = nx;
				_tmp31_ = ny;
				_tmp32_ = minefield_get_flag (_tmp29_, _tmp30_, _tmp31_);
				if (_tmp32_ == FLAG_TYPE_FLAG) {
					guint _tmp33_;
					_tmp33_ = n_flags;
					n_flags = _tmp33_ + 1;
				}
				_tmp34_ = minefield_view_get_minefield (self);
				_tmp35_ = _tmp34_;
				_tmp36_ = nx;
				_tmp37_ = ny;
				_tmp38_ = minefield_is_cleared (_tmp35_, _tmp36_, _tmp37_);
				if (!_tmp38_) {
					guint _tmp39_;
					_tmp39_ = n_unknown;
					n_unknown = _tmp39_ + 1;
				}
			}
		}
	}
	do_clear = FALSE;
	_tmp40_ = n_mines;
	_tmp41_ = n_flags;
	if (_tmp40_ == _tmp41_) {
		do_clear = TRUE;
	} else {
		gboolean _tmp42_ = FALSE;
		gboolean _tmp43_;
		gboolean _tmp46_;
		_tmp43_ = self->priv->use_autoflag;
		if (_tmp43_) {
			guint _tmp44_;
			guint _tmp45_;
			_tmp44_ = n_unknown;
			_tmp45_ = n_mines;
			_tmp42_ = _tmp44_ == _tmp45_;
		} else {
			_tmp42_ = FALSE;
		}
		_tmp46_ = _tmp42_;
		if (_tmp46_) {
			do_clear = FALSE;
		} else {
			return;
		}
	}
	_tmp47_ = minefield_view_get_minefield (self);
	_tmp48_ = _tmp47_;
	_tmp49_ = _minefield_ref0 (_tmp48_);
	m = _tmp49_;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				guint _tmp50_;
				Neighbour _tmp51_;
				gint _tmp52_;
				guint nx;
				guint _tmp53_;
				Neighbour _tmp54_;
				gint _tmp55_;
				guint ny;
				Minefield* _tmp56_;
				guint _tmp57_;
				guint _tmp58_;
				gboolean _tmp59_ = FALSE;
				gboolean _tmp60_ = FALSE;
				gboolean _tmp61_;
				gboolean _tmp66_;
				_tmp50_ = x;
				_tmp51_ = neighbour;
				_tmp52_ = _tmp51_.x;
				nx = _tmp50_ + _tmp52_;
				_tmp53_ = y;
				_tmp54_ = neighbour;
				_tmp55_ = _tmp54_.y;
				ny = _tmp53_ + _tmp55_;
				_tmp56_ = m;
				_tmp57_ = nx;
				_tmp58_ = ny;
				_tmp59_ = minefield_is_location (_tmp56_, _tmp57_, _tmp58_);
				if (!_tmp59_) {
					continue;
				}
				_tmp61_ = do_clear;
				if (_tmp61_) {
					Minefield* _tmp62_;
					guint _tmp63_;
					guint _tmp64_;
					FlagType _tmp65_ = 0;
					_tmp62_ = m;
					_tmp63_ = nx;
					_tmp64_ = ny;
					_tmp65_ = minefield_get_flag (_tmp62_, _tmp63_, _tmp64_);
					_tmp60_ = _tmp65_ != FLAG_TYPE_FLAG;
				} else {
					_tmp60_ = FALSE;
				}
				_tmp66_ = _tmp60_;
				if (_tmp66_) {
					Minefield* _tmp67_;
					guint _tmp68_;
					guint _tmp69_;
					_tmp67_ = m;
					_tmp68_ = nx;
					_tmp69_ = ny;
					minefield_clear_mine (_tmp67_, _tmp68_, _tmp69_);
				} else {
					Minefield* _tmp70_;
					guint _tmp71_;
					guint _tmp72_;
					_tmp70_ = m;
					_tmp71_ = nx;
					_tmp72_ = ny;
					minefield_set_flag (_tmp70_, _tmp71_, _tmp72_, FLAG_TYPE_FLAG);
				}
			}
		}
	}
	_minefield_unref0 (m);
}


static gboolean minefield_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	GdkEventButton _tmp0_;
	GdkEventType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Minefield* _tmp4_;
	Minefield* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp11_;
	gboolean _tmp14_;
	GdkEventButton _tmp15_;
	gdouble _tmp16_;
	guint _tmp17_;
	guint _tmp18_;
	guint _tmp19_;
	guint _tmp20_;
	gdouble _tmp21_ = 0.0;
	gint x;
	GdkEventButton _tmp22_;
	gdouble _tmp23_;
	guint _tmp24_;
	guint _tmp25_;
	guint _tmp26_;
	guint _tmp27_;
	gdouble _tmp28_ = 0.0;
	gint y;
	Minefield* _tmp29_;
	Minefield* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	GdkEventButton _tmp35_;
	guint _tmp36_;
	gboolean _tmp43_;
	GdkEventButton _tmp46_;
	guint _tmp47_;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ != GDK_BUTTON_PRESS) {
		result = FALSE;
		return result;
	}
	_tmp4_ = minefield_view_get_minefield (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->exploded;
	if (_tmp6_) {
		_tmp3_ = TRUE;
	} else {
		Minefield* _tmp7_;
		Minefield* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = minefield_view_get_minefield (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = minefield_get_is_complete (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = _tmp10_;
	}
	_tmp11_ = _tmp3_;
	if (_tmp11_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp12_ = minefield_view_get_paused (self);
		_tmp13_ = _tmp12_;
		_tmp2_ = _tmp13_;
	}
	_tmp14_ = _tmp2_;
	if (_tmp14_) {
		result = FALSE;
		return result;
	}
	_tmp15_ = *event;
	_tmp16_ = _tmp15_.x;
	_tmp17_ = minefield_view_get_x_offset (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = minefield_view_get_mine_size (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = floor ((_tmp16_ - _tmp18_) / _tmp20_);
	x = (gint) _tmp21_;
	_tmp22_ = *event;
	_tmp23_ = _tmp22_.y;
	_tmp24_ = minefield_view_get_y_offset (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = minefield_view_get_mine_size (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = floor ((_tmp23_ - _tmp25_) / _tmp27_);
	y = (gint) _tmp28_;
	_tmp29_ = minefield_view_get_minefield (self);
	_tmp30_ = _tmp29_;
	_tmp31_ = x;
	_tmp32_ = y;
	_tmp33_ = minefield_is_location (_tmp30_, (guint) _tmp31_, (guint) _tmp32_);
	if (!_tmp33_) {
		result = FALSE;
		return result;
	}
	_tmp35_ = *event;
	_tmp36_ = _tmp35_.button;
	if (_tmp36_ == ((guint) 3)) {
		_tmp34_ = TRUE;
	} else {
		gboolean _tmp37_ = FALSE;
		GdkEventButton _tmp38_;
		guint _tmp39_;
		gboolean _tmp42_;
		_tmp38_ = *event;
		_tmp39_ = _tmp38_.button;
		if (_tmp39_ == ((guint) 1)) {
			GdkEventButton _tmp40_;
			GdkModifierType _tmp41_;
			_tmp40_ = *event;
			_tmp41_ = _tmp40_.state;
			_tmp37_ = (_tmp41_ & GDK_CONTROL_MASK) != 0;
		} else {
			_tmp37_ = FALSE;
		}
		_tmp42_ = _tmp37_;
		_tmp34_ = _tmp42_;
	}
	_tmp43_ = _tmp34_;
	if (_tmp43_) {
		gint _tmp44_;
		gint _tmp45_;
		_tmp44_ = x;
		_tmp45_ = y;
		minefield_view_toggle_mark (self, (guint) _tmp44_, (guint) _tmp45_);
		result = FALSE;
		return result;
	}
	_tmp46_ = *event;
	_tmp47_ = _tmp46_.button;
	if (_tmp47_ == ((guint) 1)) {
		gint _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		Minefield* _tmp52_;
		Minefield* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp48_ = x;
		self->priv->selected_x = _tmp48_;
		_tmp49_ = y;
		self->priv->selected_y = _tmp49_;
		_tmp50_ = x;
		_tmp51_ = y;
		minefield_view_redraw_sector_cb (self, (guint) _tmp50_, (guint) _tmp51_);
		g_signal_emit_by_name (self, "look");
		_tmp52_ = minefield_view_get_minefield (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = x;
		_tmp55_ = y;
		_tmp56_ = minefield_is_cleared (_tmp53_, (guint) _tmp54_, (guint) _tmp55_);
		if (_tmp56_) {
			gint _tmp57_;
			gint _tmp58_;
			_tmp57_ = x;
			_tmp58_ = y;
			minefield_view_redraw_adjacent (self, (guint) _tmp57_, (guint) _tmp58_);
		}
	}
	result = FALSE;
	return result;
}


static gboolean minefield_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp8_;
	gint _tmp9_;
	GdkEventMotion _tmp10_;
	gdouble _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	guint _tmp15_;
	gdouble _tmp16_ = 0.0;
	gint x;
	GdkEventMotion _tmp17_;
	gdouble _tmp18_;
	guint _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	gdouble _tmp23_ = 0.0;
	gint y;
	Minefield* _tmp24_;
	Minefield* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gint _tmp30_;
	gint _tmp31_;
	gboolean _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	Minefield* _tmp37_;
	Minefield* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gboolean _tmp41_ = FALSE;
	gint _tmp44_;
	gint _tmp45_;
	Minefield* _tmp46_;
	Minefield* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	gboolean _tmp50_ = FALSE;
	gint _tmp53_;
	gint _tmp54_;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->exploded;
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp4_;
		Minefield* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = minefield_view_get_minefield (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = minefield_get_is_complete (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		result = FALSE;
		return result;
	}
	_tmp9_ = self->priv->selected_x;
	if (_tmp9_ < 0) {
		result = FALSE;
		return result;
	}
	_tmp10_ = *event;
	_tmp11_ = _tmp10_.x;
	_tmp12_ = minefield_view_get_x_offset (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = minefield_view_get_mine_size (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = floor ((_tmp11_ - _tmp13_) / _tmp15_);
	x = (gint) _tmp16_;
	_tmp17_ = *event;
	_tmp18_ = _tmp17_.y;
	_tmp19_ = minefield_view_get_y_offset (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = minefield_view_get_mine_size (self);
	_tmp22_ = _tmp21_;
	_tmp23_ = floor ((_tmp18_ - _tmp20_) / _tmp22_);
	y = (gint) _tmp23_;
	_tmp24_ = minefield_view_get_minefield (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = x;
	_tmp27_ = y;
	_tmp28_ = minefield_is_location (_tmp25_, (guint) _tmp26_, (guint) _tmp27_);
	if (!_tmp28_) {
		result = FALSE;
		return result;
	}
	_tmp30_ = x;
	_tmp31_ = self->priv->selected_x;
	if (_tmp30_ == _tmp31_) {
		gint _tmp32_;
		gint _tmp33_;
		_tmp32_ = y;
		_tmp33_ = self->priv->selected_y;
		_tmp29_ = _tmp32_ == _tmp33_;
	} else {
		_tmp29_ = FALSE;
	}
	_tmp34_ = _tmp29_;
	if (_tmp34_) {
		result = FALSE;
		return result;
	}
	_tmp35_ = self->priv->selected_x;
	_tmp36_ = self->priv->selected_y;
	minefield_view_redraw_sector_cb (self, (guint) _tmp35_, (guint) _tmp36_);
	_tmp37_ = minefield_view_get_minefield (self);
	_tmp38_ = _tmp37_;
	_tmp39_ = self->priv->selected_x;
	_tmp40_ = self->priv->selected_y;
	_tmp41_ = minefield_is_cleared (_tmp38_, (guint) _tmp39_, (guint) _tmp40_);
	if (_tmp41_) {
		gint _tmp42_;
		gint _tmp43_;
		_tmp42_ = self->priv->selected_x;
		_tmp43_ = self->priv->selected_y;
		minefield_view_redraw_adjacent (self, (guint) _tmp42_, (guint) _tmp43_);
	}
	_tmp44_ = x;
	_tmp45_ = y;
	minefield_view_redraw_sector_cb (self, (guint) _tmp44_, (guint) _tmp45_);
	_tmp46_ = minefield_view_get_minefield (self);
	_tmp47_ = _tmp46_;
	_tmp48_ = x;
	_tmp49_ = y;
	_tmp50_ = minefield_is_cleared (_tmp47_, (guint) _tmp48_, (guint) _tmp49_);
	if (_tmp50_) {
		gint _tmp51_;
		gint _tmp52_;
		_tmp51_ = x;
		_tmp52_ = y;
		minefield_view_redraw_adjacent (self, (guint) _tmp51_, (guint) _tmp52_);
	}
	_tmp53_ = x;
	self->priv->selected_x = _tmp53_;
	_tmp54_ = y;
	self->priv->selected_y = _tmp54_;
	result = FALSE;
	return result;
}


static gboolean minefield_view_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp8_;
	gint _tmp9_;
	GdkEventButton _tmp10_;
	guint _tmp11_;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->exploded;
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp4_;
		Minefield* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = minefield_view_get_minefield (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = minefield_get_is_complete (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		result = FALSE;
		return result;
	}
	_tmp9_ = self->priv->selected_x;
	if (_tmp9_ < 0) {
		result = FALSE;
		return result;
	}
	_tmp10_ = *event;
	_tmp11_ = _tmp10_.button;
	if (_tmp11_ == ((guint) 1)) {
		Minefield* _tmp12_;
		Minefield* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gboolean _tmp16_ = FALSE;
		gint _tmp30_;
		gint _tmp31_;
		g_signal_emit_by_name (self, "unlook");
		_tmp12_ = minefield_view_get_minefield (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->selected_x;
		_tmp15_ = self->priv->selected_y;
		_tmp16_ = minefield_is_cleared (_tmp13_, (guint) _tmp14_, (guint) _tmp15_);
		if (_tmp16_) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			_tmp17_ = self->priv->selected_x;
			_tmp18_ = self->priv->selected_y;
			minefield_view_multi_release (self, (guint) _tmp17_, (guint) _tmp18_);
			_tmp19_ = self->priv->selected_x;
			_tmp20_ = self->priv->selected_y;
			minefield_view_redraw_adjacent (self, (guint) _tmp19_, (guint) _tmp20_);
		} else {
			Minefield* _tmp21_;
			Minefield* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			FlagType _tmp25_ = 0;
			_tmp21_ = minefield_view_get_minefield (self);
			_tmp22_ = _tmp21_;
			_tmp23_ = self->priv->selected_x;
			_tmp24_ = self->priv->selected_y;
			_tmp25_ = minefield_get_flag (_tmp22_, (guint) _tmp23_, (guint) _tmp24_);
			if (_tmp25_ != FLAG_TYPE_FLAG) {
				Minefield* _tmp26_;
				Minefield* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				_tmp26_ = minefield_view_get_minefield (self);
				_tmp27_ = _tmp26_;
				_tmp28_ = self->priv->selected_x;
				_tmp29_ = self->priv->selected_y;
				minefield_clear_mine (_tmp27_, (guint) _tmp28_, (guint) _tmp29_);
			}
		}
		_tmp30_ = self->priv->selected_x;
		_tmp31_ = self->priv->selected_y;
		minefield_view_redraw_sector_cb (self, (guint) _tmp30_, (guint) _tmp31_);
	}
	self->priv->selected_x = -1;
	self->priv->selected_y = -1;
	result = FALSE;
	return result;
}


static guint minefield_view_get_mine_size (MinefieldView* self) {
	guint result;
	gint _tmp0_ = 0;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	guint _tmp3_;
	gint _tmp4_ = 0;
	Minefield* _tmp5_;
	Minefield* _tmp6_;
	guint _tmp7_;
	gint _tmp8_ = 0;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->width;
	_tmp4_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp5_ = minefield_view_get_minefield (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->height;
	_tmp8_ = MIN (_tmp0_ / ((gint) _tmp3_), _tmp4_ / ((gint) _tmp7_));
	result = (guint) _tmp8_;
	return result;
}


static guint minefield_view_get_x_offset (MinefieldView* self) {
	guint result;
	gint _tmp0_ = 0;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->width;
	_tmp4_ = minefield_view_get_mine_size (self);
	_tmp5_ = _tmp4_;
	result = (_tmp0_ - (_tmp3_ * _tmp5_)) / 2;
	return result;
}


static guint minefield_view_get_y_offset (MinefieldView* self) {
	guint result;
	gint _tmp0_ = 0;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->height;
	_tmp4_ = minefield_view_get_mine_size (self);
	_tmp5_ = _tmp4_;
	result = (_tmp0_ - (_tmp3_ * _tmp5_)) / 2;
	return result;
}


static guint minefield_view_get_minimum_size (MinefieldView* self) {
	guint result;
	Minefield* _tmp0_;
	Minefield* _tmp1_;
	guint _tmp2_;
	guint w;
	Minefield* _tmp3_;
	Minefield* _tmp4_;
	guint _tmp5_;
	guint h;
	guint _tmp6_;
	guint _tmp7_;
	guint _tmp8_ = 0U;
	guint s;
	guint _tmp9_;
	guint _tmp10_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->width;
	w = 320 / _tmp2_;
	_tmp3_ = minefield_view_get_minefield (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->height;
	h = 200 / _tmp5_;
	_tmp6_ = w;
	_tmp7_ = h;
	_tmp8_ = MIN (_tmp6_, _tmp7_);
	s = _tmp8_;
	_tmp9_ = s;
	if (_tmp9_ < ((guint) 30)) {
		s = (guint) 30;
	}
	_tmp10_ = s;
	result = _tmp10_;
	return result;
}


gboolean minefield_view_get_paused (MinefieldView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_paused;
	result = _tmp0_;
	return result;
}


void minefield_view_set_paused (MinefieldView* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_paused = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "paused");
}


Minefield* minefield_view_get_minefield (MinefieldView* self) {
	Minefield* result;
	Minefield* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_minefield;
	result = _tmp0_;
	return result;
}


static void _minefield_view_redraw_sector_cb_minefield_redraw_sector (Minefield* _sender, guint x, guint y, gpointer self) {
	minefield_view_redraw_sector_cb (self, x, y);
}


static void _minefield_view_explode_cb_minefield_explode (Minefield* _sender, gpointer self) {
	minefield_view_explode_cb (self, _sender);
}


void minefield_view_set_minefield (MinefieldView* self, Minefield* value) {
	Minefield* _tmp0_;
	Minefield* _tmp2_;
	Minefield* _tmp3_;
	Minefield* _tmp4_;
	Minefield* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_minefield;
	if (_tmp0_ != NULL) {
		Minefield* _tmp1_;
		_tmp1_ = self->priv->_minefield;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = value;
	_tmp3_ = _minefield_ref0 (_tmp2_);
	_minefield_unref0 (self->priv->_minefield);
	self->priv->_minefield = _tmp3_;
	self->priv->selected_x = -1;
	self->priv->selected_y = -1;
	_tmp4_ = self->priv->_minefield;
	g_signal_connect_object (_tmp4_, "redraw-sector", (GCallback) _minefield_view_redraw_sector_cb_minefield_redraw_sector, self, 0);
	_tmp5_ = self->priv->_minefield;
	g_signal_connect_object (_tmp5_, "explode", (GCallback) _minefield_view_explode_cb_minefield_explode, self, 0);
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "minefield");
}


static void minefield_view_class_init (MinefieldViewClass * klass) {
	minefield_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MinefieldViewPrivate));
	GTK_WIDGET_CLASS (klass)->get_preferred_width = minefield_view_real_get_preferred_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = minefield_view_real_get_preferred_height;
	GTK_WIDGET_CLASS (klass)->draw = minefield_view_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = minefield_view_real_button_press_event;
	GTK_WIDGET_CLASS (klass)->motion_notify_event = minefield_view_real_motion_notify_event;
	GTK_WIDGET_CLASS (klass)->button_release_event = minefield_view_real_button_release_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_minefield_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_minefield_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = minefield_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_VIEW_PAUSED, g_param_spec_boolean ("paused", "paused", "paused", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_VIEW_MINEFIELD, param_spec_minefield ("minefield", "minefield", "minefield", TYPE_MINEFIELD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("look", TYPE_MINEFIELD_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("unlook", TYPE_MINEFIELD_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void minefield_view_instance_init (MinefieldView * self) {
	self->priv = MINEFIELD_VIEW_GET_PRIVATE (self);
	self->priv->selected_x = -1;
	self->priv->selected_y = -1;
	self->priv->render_size = (guint) 0;
	self->priv->_paused = FALSE;
}


static void minefield_view_finalize (GObject* obj) {
	MinefieldView * self;
	self = MINEFIELD_VIEW (obj);
	_g_object_unref0 (self->priv->flag_preimage);
	_g_object_unref0 (self->priv->mine_preimage);
	_g_object_unref0 (self->priv->question_preimage);
	_g_object_unref0 (self->priv->bang_preimage);
	_g_object_unref0 (self->priv->warning_preimage);
	_cairo_pattern_destroy0 (self->priv->flag_pattern);
	_cairo_pattern_destroy0 (self->priv->mine_pattern);
	_cairo_pattern_destroy0 (self->priv->question_pattern);
	_cairo_pattern_destroy0 (self->priv->bang_pattern);
	_cairo_pattern_destroy0 (self->priv->warning_pattern);
	self->priv->number_patterns = (_vala_array_free (self->priv->number_patterns, self->priv->number_patterns_length1, (GDestroyNotify) cairo_pattern_destroy), NULL);
	_minefield_unref0 (self->priv->_minefield);
	G_OBJECT_CLASS (minefield_view_parent_class)->finalize (obj);
}


GType minefield_view_get_type (void) {
	static volatile gsize minefield_view_type_id__volatile = 0;
	if (g_once_init_enter (&minefield_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MinefieldViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) minefield_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MinefieldView), 0, (GInstanceInitFunc) minefield_view_instance_init, NULL };
		GType minefield_view_type_id;
		minefield_view_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "MinefieldView", &g_define_type_info, 0);
		g_once_init_leave (&minefield_view_type_id__volatile, minefield_view_type_id);
	}
	return minefield_view_type_id__volatile;
}


static void _vala_minefield_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MinefieldView * self;
	self = MINEFIELD_VIEW (object);
	switch (property_id) {
		case MINEFIELD_VIEW_PAUSED:
		g_value_set_boolean (value, minefield_view_get_paused (self));
		break;
		case MINEFIELD_VIEW_MINEFIELD:
		value_set_minefield (value, minefield_view_get_minefield (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_minefield_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MinefieldView * self;
	self = MINEFIELD_VIEW (object);
	switch (property_id) {
		case MINEFIELD_VIEW_PAUSED:
		minefield_view_set_paused (self, g_value_get_boolean (value));
		break;
		case MINEFIELD_VIEW_MINEFIELD:
		minefield_view_set_minefield (self, value_get_minefield (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



