#include <gio/gio.h>

#if defined (__ELF__) && ( __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 6))
# define SECTION __attribute__ ((section (".gresource.gcm"), aligned (8)))
#else
# define SECTION
#endif

static const SECTION union { const guint8 data[2304]; const double alignment; void * const ptr;}  gcm_resource_data = { {
  0x47, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x18, 0x00, 0x00, 0x00, 0xac, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x28, 0x05, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
  0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
  0x05, 0x00, 0x00, 0x00, 0xd4, 0xb5, 0x02, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x4c, 0x00, 0xb0, 0x00, 0x00, 0x00, 
  0xb4, 0x00, 0x00, 0x00, 0x4b, 0x50, 0x90, 0x0b, 
  0x00, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x00, 0x00, 
  0x04, 0x00, 0x4c, 0x00, 0xb8, 0x00, 0x00, 0x00, 
  0xbc, 0x00, 0x00, 0x00, 0xf4, 0x3c, 0xaf, 0x8f, 
  0x03, 0x00, 0x00, 0x00, 0xbc, 0x00, 0x00, 0x00, 
  0x0d, 0x00, 0x76, 0x00, 0xd0, 0x00, 0x00, 0x00, 
  0xdf, 0x08, 0x00, 0x00, 0x66, 0xec, 0xb7, 0xce, 
  0x04, 0x00, 0x00, 0x00, 0xdf, 0x08, 0x00, 0x00, 
  0x0e, 0x00, 0x4c, 0x00, 0xf0, 0x08, 0x00, 0x00, 
  0xf4, 0x08, 0x00, 0x00, 0xb0, 0xb7, 0x24, 0x30, 
  0x01, 0x00, 0x00, 0x00, 0xf4, 0x08, 0x00, 0x00, 
  0x06, 0x00, 0x4c, 0x00, 0xfc, 0x08, 0x00, 0x00, 
  0x00, 0x09, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x6f, 0x72, 0x67, 0x2f, 
  0x04, 0x00, 0x00, 0x00, 0x67, 0x63, 0x6d, 0x2d, 
  0x70, 0x69, 0x63, 0x6b, 0x65, 0x72, 0x2e, 0x75, 
  0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x3b, 0x6b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x78, 0xda, 0xed, 0x9d, 0x5b, 0x93, 0x9b, 0x36, 
  0x14, 0xc7, 0xdf, 0xf3, 0x29, 0x34, 0x7a, 0x6a, 
  0xa7, 0xeb, 0x78, 0xbd, 0x6d, 0xd2, 0xcb, 0xd8, 
  0x64, 0x72, 0xdd, 0x76, 0xa6, 0x99, 0xe9, 0xa4, 
  0xdb, 0xeb, 0x0b, 0x23, 0xc3, 0xb1, 0x51, 0x17, 
  0x10, 0x91, 0xc4, 0x7a, 0x37, 0x9f, 0xbe, 0x12, 
  0xf2, 0x1d, 0x0c, 0x02, 0x3b, 0x89, 0x33, 0xe8, 
  0x69, 0x59, 0x38, 0x07, 0x74, 0xfe, 0x92, 0x8e, 
  0x7e, 0x16, 0x20, 0xc6, 0xcf, 0xee, 0x93, 0x18, 
  0xdd, 0x01, 0x17, 0x94, 0xa5, 0x13, 0x3c, 0x7a, 
  0x7c, 0x89, 0x11, 0xa4, 0x01, 0x0b, 0x69, 0x3a, 
  0x9f, 0xe0, 0x3f, 0x6e, 0xde, 0x0c, 0x7e, 0xc0, 
  0xcf, 0xbc, 0x47, 0x63, 0x9a, 0x4a, 0xe0, 0x33, 
  0x12, 0x80, 0xf7, 0x08, 0xa1, 0x31, 0x87, 0xf7, 
  0x39, 0xe5, 0x20, 0x50, 0x4c, 0xa7, 0x13, 0x3c, 
  0x97, 0xb7, 0xdf, 0xe0, 0xcd, 0x39, 0xae, 0x1e, 
  0x8f, 0x9e, 0xe2, 0x61, 0x61, 0xc7, 0xa6, 0xff, 
  0x41, 0x20, 0x51, 0x10, 0x13, 0x21, 0x26, 0xf8, 
  0x5a, 0xde, 0xbe, 0xa2, 0x24, 0x66, 0x73, 0x8c, 
  0x68, 0x38, 0xc1, 0x61, 0xb1, 0xed, 0x67, 0x34, 
  0xb8, 0x05, 0x8e, 0xb5, 0xbd, 0xf2, 0xc8, 0x38, 
  0xcb, 0x80, 0xcb, 0x07, 0x94, 0x92, 0x04, 0x26, 
  0x38, 0x20, 0xa9, 0x3f, 0x63, 0x41, 0x2e, 0xb0, 
  0xf7, 0x86, 0xc4, 0x02, 0xc6, 0xc3, 0x95, 0x41, 
  0xb5, 0xfd, 0x94, 0xf1, 0x10, 0xb8, 0xbf, 0xa0, 
  0xa1, 0x8c, 0xb0, 0xf7, 0xa4, 0xc9, 0x5c, 0x52, 
  0x19, 0x03, 0x46, 0x92, 0x93, 0x54, 0xc4, 0x44, 
  0x92, 0x69, 0xac, 0x76, 0x3e, 0x80, 0xc0, 0x28, 
  0x60, 0x49, 0x02, 0xa9, 0x54, 0xa5, 0xfe, 0x8b, 
  0xa6, 0x21, 0x5b, 0xa0, 0xc2, 0xf4, 0x02, 0x2d, 
  0x22, 0xe0, 0x80, 0x64, 0x04, 0x28, 0x17, 0xc0, 
  0x91, 0x2a, 0x1f, 0xd2, 0x01, 0x20, 0x91, 0x31, 
  0x15, 0x27, 0x8b, 0x19, 0x17, 0xea, 0x88, 0x12, 
  0x0f, 0x11, 0x94, 0x00, 0x11, 0x39, 0xd7, 0xdb, 
  0x21, 0xdc, 0xd1, 0x00, 0xb0, 0xf7, 0x52, 0x1b, 
  0xa0, 0xdf, 0x8a, 0x88, 0x9b, 0xca, 0x46, 0x03, 
  0x96, 0xfa, 0x7a, 0x13, 0x7b, 0xf3, 0x94, 0x25, 
  0x30, 0x28, 0xce, 0x3e, 0x48, 0x48, 0x4a, 0xe6, 
  0xcd, 0xde, 0xf2, 0x21, 0x03, 0x3f, 0x52, 0xb5, 
  0x86, 0x3d, 0xa3, 0x73, 0xc9, 0x21, 0x88, 0x68, 
  0x1c, 0xa2, 0xa2, 0x5e, 0x53, 0x12, 0x0f, 0x8a, 
  0x7f, 0x27, 0xf8, 0x6e, 0xca, 0xee, 0x97, 0x75, 
  0x51, 0x55, 0x7f, 0x2f, 0xd4, 0xd1, 0xad, 0xca, 
  0x1b, 0x68, 0xf3, 0xd1, 0xda, 0xbe, 0x5c, 0x8c, 
  0x3b, 0x2a, 0xa8, 0x12, 0x15, 0x7b, 0x37, 0x3c, 
  0x2f, 0x55, 0x5e, 0x97, 0x0a, 0xaf, 0xf2, 0x61, 
  0x9c, 0xaa, 0xaa, 0x22, 0x52, 0xb5, 0x3e, 0xec, 
  0xa9, 0x66, 0x28, 0x69, 0x40, 0x62, 0x1b, 0x47, 
  0x91, 0x91, 0x40, 0x55, 0x0f, 0xf6, 0xae, 0x2a, 
  0xad, 0xab, 0x15, 0x22, 0x81, 0xbe, 0x90, 0x4f, 
  0x38, 0x90, 0xad, 0xc0, 0x2b, 0xc5, 0xca, 0xa5, 
  0x64, 0xe9, 0xbe, 0x64, 0x5b, 0xfe, 0xa3, 0x9d, 
  0x13, 0x74, 0x50, 0xaf, 0xab, 0x82, 0x55, 0x7e, 
  0x31, 0x79, 0x60, 0xb9, 0xf4, 0x85, 0x7c, 0xd0, 
  0x57, 0x84, 0x34, 0x3c, 0xe8, 0x58, 0x08, 0xb1, 
  0xbb, 0xef, 0x70, 0xf8, 0x26, 0xf6, 0x69, 0xb1, 
  0xed, 0x07, 0x31, 0x13, 0x80, 0xf7, 0x5d, 0xab, 
  0xca, 0x32, 0x85, 0x58, 0xb5, 0x7b, 0x79, 0x3b, 
  0x28, 0x5c, 0x0e, 0x15, 0xa5, 0xb3, 0x68, 0x0d, 
  0xc2, 0xb5, 0x75, 0xe5, 0x10, 0x00, 0xbd, 0x03, 
  0xe1, 0x87, 0x30, 0x23, 0x79, 0x2c, 0xdb, 0x9f, 
  0x41, 0x65, 0x13, 0x7f, 0xd5, 0x32, 0xb2, 0x0c, 
  0x88, 0xca, 0x48, 0x3a, 0x61, 0xd4, 0xd6, 0xe0, 
  0xa1, 0xf3, 0x08, 0xc9, 0x82, 0xdb, 0xa6, 0x22, 
  0x8c, 0x87, 0xa6, 0xc2, 0x4a, 0xfb, 0x55, 0x9f, 
  0xb8, 0x55, 0x9d, 0xa2, 0xf9, 0x52, 0x70, 0x9f, 
  0x91, 0x34, 0xec, 0x50, 0xc6, 0x19, 0x8d, 0xe3, 
  0x0e, 0x6e, 0x19, 0x13, 0xd4, 0xf4, 0xf1, 0xcb, 
  0xba, 0xb0, 0x2a, 0xcb, 0x3f, 0x1e, 0x96, 0x1a, 
  0x6d, 0x59, 0x80, 0x92, 0x51, 0xb9, 0xa5, 0x97, 
  0x5b, 0xf9, 0x9f, 0xeb, 0xfe, 0xbd, 0x9f, 0x0b, 
  0x3f, 0x7b, 0x8f, 0xde, 0x1d, 0x0c, 0x47, 0x57, 
  0xb6, 0x7e, 0xeb, 0xb4, 0x58, 0xe3, 0x62, 0x99, 
  0x03, 0x7e, 0x5e, 0xab, 0x13, 0x55, 0xa8, 0xf3, 
  0xb1, 0xba, 0x6f, 0xeb, 0xa6, 0xb5, 0x8e, 0xf8, 
  0x69, 0xad, 0x57, 0x65, 0xd0, 0xd5, 0x81, 0xff, 
  0x92, 0xa8, 0x51, 0xda, 0x44, 0x4e, 0xf5, 0xa6, 
  0x9f, 0x71, 0xc5, 0x00, 0xb0, 0xc0, 0x55, 0xee, 
  0x47, 0xa8, 0x70, 0xac, 0x12, 0x87, 0x13, 0x41, 
  0x7d, 0x32, 0xa8, 0x4b, 0x08, 0x5d, 0xca, 0x6c, 
  0x72, 0x42, 0x17, 0x4f, 0xab, 0xb4, 0x50, 0x93, 
  0x1a, 0x0e, 0xa4, 0x87, 0xf6, 0x55, 0x5e, 0x31, 
  0xde, 0x19, 0x02, 0x04, 0xcb, 0x4a, 0x37, 0xa3, 
  0x5e, 0x3d, 0x8d, 0x9a, 0x8b, 0x20, 0x09, 0xf7, 
  0xf2, 0x02, 0x49, 0x86, 0xe6, 0x20, 0x15, 0x69, 
  0x6a, 0xe0, 0x8c, 0x01, 0x09, 0x92, 0x64, 0xea, 
  0x0f, 0x9b, 0x19, 0x12, 0xc5, 0x9e, 0xff, 0xd6, 
  0x14, 0xa0, 0xad, 0xa6, 0xa7, 0x6a, 0x7e, 0x5d, 
  0xdc, 0xdb, 0x8f, 0xa5, 0xa7, 0x1c, 0x4f, 0x0f, 
  0x9d, 0x2b, 0x4f, 0x55, 0x2a, 0x8d, 0x69, 0xda, 
  0x51, 0x93, 0x65, 0x0e, 0x58, 0x37, 0x55, 0xc9, 
  0xb2, 0x4f, 0xdd, 0x2b, 0x3b, 0x85, 0x6e, 0x39, 
  0x54, 0xd7, 0xf7, 0xcb, 0xd1, 0xa9, 0xfb, 0x65, 
  0xef, 0xd9, 0xc5, 0x7e, 0x00, 0x7e, 0x5d, 0x04, 
  0xaa, 0x7e, 0x5f, 0x17, 0x69, 0x09, 0x96, 0xff, 
  0xf9, 0xea, 0xb7, 0xbb, 0xea, 0x5a, 0x02, 0x9f, 
  0x09, 0x4e, 0xb7, 0xc8, 0xb2, 0xbb, 0xbc, 0x75, 
  0x75, 0x7e, 0xe3, 0x69, 0x13, 0x87, 0xfd, 0xd8, 
  0xd6, 0xdd, 0x0e, 0x4e, 0xea, 0x75, 0xb4, 0xa1, 
  0x33, 0xff, 0xfe, 0xe1, 0x03, 0x3e, 0xe4, 0x7c, 
  0xa4, 0xa4, 0xa7, 0x90, 0xb5, 0x23, 0xaa, 0xda, 
  0x0b, 0x64, 0x2b, 0x92, 0x4f, 0x62, 0x3a, 0x4f, 
  0x71, 0xdd, 0x69, 0x4e, 0x20, 0xd7, 0xa9, 0x24, 
  0xb3, 0x8b, 0xbb, 0x3a, 0xf6, 0x5f, 0x0d, 0x91, 
  0xe8, 0xe0, 0x0b, 0x38, 0x29, 0xa2, 0x37, 0x93, 
  0x66, 0x4d, 0x27, 0x3b, 0x91, 0x02, 0xa7, 0x54, 
  0xa1, 0x2b, 0x73, 0xe9, 0xd9, 0xbe, 0x02, 0xa8, 
  0x10, 0x07, 0x85, 0xf1, 0x62, 0x33, 0xd9, 0xf4, 
  0xf7, 0x3f, 0xff, 0xfe, 0x64, 0x7f, 0xf5, 0xba, 
  0x31, 0xdd, 0x7e, 0x7c, 0x3f, 0xd9, 0x58, 0x7f, 
  0xa2, 0x71, 0xff, 0x24, 0x6c, 0x6e, 0xc9, 0x03, 
  0x56, 0xcc, 0xde, 0x4e, 0x70, 0x3b, 0xb1, 0x4f, 
  0x22, 0xf4, 0x09, 0x44, 0x3e, 0x5a, 0x60, 0x0b, 
  0x71, 0x1b, 0x85, 0xed, 0x92, 0x45, 0xab, 0x32, 
  0xc9, 0x17, 0x95, 0x41, 0xf7, 0x07, 0x1e, 0x88, 
  0x55, 0x80, 0xa4, 0x65, 0x79, 0xfa, 0xd4, 0x20, 
  0x47, 0x9f, 0xaa, 0x41, 0x36, 0x89, 0xda, 0x2c, 
  0xe8, 0xd1, 0x62, 0x1e, 0x29, 0xe4, 0x51, 0xbd, 
  0xba, 0x41, 0xc0, 0x5a, 0xf1, 0x8e, 0x04, 0x46, 
  0xd5, 0x93, 0x1d, 0x30, 0x5a, 0x88, 0xd4, 0x63, 
  0x60, 0xd4, 0xd1, 0xf7, 0x0e, 0x18, 0x95, 0x0a, 
  0x88, 0x0a, 0x74, 0x88, 0x1b, 0x91, 0x4a, 0x2e, 
  0xe8, 0xd5, 0x93, 0xcb, 0x95, 0xcd, 0x22, 0xa2, 
  0x12, 0x50, 0xc6, 0x8a, 0xbb, 0xb5, 0xda, 0xf7, 
  0x2b, 0x75, 0xf0, 0x6b, 0x07, 0x96, 0x0e, 0x2c, 
  0x1d, 0x58, 0x76, 0xca, 0x38, 0x0e, 0x2c, 0x1d, 
  0x58, 0x3a, 0xb0, 0x3c, 0x56, 0xc4, 0xcf, 0x08, 
  0x96, 0xc5, 0x88, 0xb8, 0x1c, 0x10, 0x1d, 0x5f, 
  0xda, 0x6a, 0xd5, 0x63, 0xcc, 0xdc, 0x12, 0xa1, 
  0x77, 0xb4, 0x79, 0x13, 0x29, 0x8e, 0xe4, 0x30, 
  0x03, 0x2e, 0xf4, 0x1d, 0x61, 0x4d, 0x94, 0x24, 
  0x61, 0x79, 0x2a, 0xf5, 0x8d, 0x60, 0x92, 0x4c, 
  0xf5, 0xc3, 0x71, 0x48, 0xb5, 0x8c, 0x48, 0xed, 
  0x48, 0x8b, 0xc3, 0x8a, 0x44, 0x85, 0xbe, 0x3d, 
  0xfc, 0x16, 0x42, 0x4a, 0xd0, 0x46, 0x3b, 0x87, 
  0x9c, 0x0e, 0x39, 0x1d, 0x72, 0x1e, 0x93, 0x7d, 
  0x1c, 0x79, 0x3a, 0xf2, 0x74, 0xe4, 0x59, 0x2b, 
  0xe2, 0xd5, 0x59, 0x93, 0xa7, 0x84, 0x44, 0x15, 
  0x8d, 0xc8, 0xc3, 0x4f, 0x6d, 0x39, 0xf4, 0xac, 
  0x12, 0xab, 0xc7, 0xec, 0xb9, 0xad, 0x82, 0x83, 
  0x4f, 0x6b, 0xf8, 0x34, 0xef, 0xc2, 0xdc, 0x6c, 
  0xc4, 0x73, 0xf4, 0xe9, 0xe8, 0xd3, 0xd1, 0xe7, 
  0x51, 0xf9, 0xc7, 0xe1, 0xa7, 0xc3, 0x4f, 0x87, 
  0x9f, 0xb5, 0x22, 0x7e, 0x7b, 0xd6, 0xf8, 0xb9, 
  0x1c, 0x31, 0x1d, 0x7a, 0x5a, 0x0a, 0xd5, 0x63, 
  0xec, 0x5c, 0x29, 0xe0, 0x90, 0xd3, 0x1a, 0x39, 
  0x9f, 0x9b, 0x83, 0x0e, 0x34, 0x1d, 0x68, 0x3a, 
  0xd0, 0xec, 0x9c, 0x71, 0x1c, 0x64, 0x3a, 0xc8, 
  0x74, 0x90, 0x59, 0x2b, 0xe2, 0x77, 0xe7, 0x0c, 
  0x99, 0x57, 0x8e, 0x2e, 0x9b, 0xe8, 0xd2, 0x2c, 
  0xe4, 0xa2, 0x2e, 0xdb, 0xe7, 0x79, 0xcd, 0x8d, 
  0x08, 0xbd, 0xa3, 0xcb, 0xe5, 0x83, 0x99, 0x05, 
  0x5a, 0x6b, 0xc6, 0x24, 0xda, 0x60, 0xca, 0x54, 
  0xd3, 0x50, 0xfb, 0x89, 0x44, 0x62, 0x41, 0x65, 
  0x10, 0x81, 0xb1, 0x7a, 0x77, 0xfd, 0x42, 0x1d, 
  0x4e, 0x97, 0xeb, 0x1f, 0xa1, 0x29, 0xc8, 0x05, 
  0x40, 0x8a, 0x42, 0x3a, 0x53, 0x88, 0xaa, 0x59, 
  0x74, 0x23, 0xa4, 0x40, 0x22, 0x0f, 0x22, 0x44, 
  0x04, 0x7a, 0x1e, 0xb2, 0xa9, 0x71, 0xd5, 0x0f, 
  0x83, 0x0a, 0xb5, 0xb1, 0x9c, 0x11, 0x2d, 0xec, 
  0x1c, 0xa1, 0x3a, 0x42, 0x75, 0x84, 0xda, 0x98, 
  0xb2, 0x5e, 0xea, 0x4e, 0xb9, 0xce, 0xdc, 0xab, 
  0x2e, 0x6a, 0x9f, 0xb8, 0xce, 0x28, 0x6f, 0x7f, 
  0xfc, 0x56, 0x75, 0x4c, 0x4c, 0xf6, 0xab, 0x73, 
  0x38, 0xc0, 0xfc, 0x24, 0x80, 0xf9, 0xe4, 0xac, 
  0x67, 0x31, 0xf9, 0xdc, 0xbd, 0x17, 0x64, 0x23, 
  0x52, 0x8f, 0xe1, 0x52, 0x47, 0xdf, 0xc3, 0x99, 
  0x4b, 0x10, 0x80, 0xc8, 0x72, 0x01, 0xc9, 0x3b, 
  0x12, 0xe7, 0x8a, 0x08, 0xd9, 0xcc, 0xbc, 0x28, 
  0x14, 0x31, 0xa1, 0xa8, 0xd1, 0xbc, 0x2f, 0x44, 
  0x53, 0xf4, 0x0e, 0xc2, 0x0b, 0x74, 0xcd, 0x15, 
  0x49, 0x5e, 0xa0, 0x17, 0xca, 0x70, 0xbd, 0x2a, 
  0x27, 0xf6, 0x14, 0x2c, 0x3a, 0x40, 0x74, 0x80, 
  0xe8, 0x00, 0xb1, 0x53, 0xda, 0x71, 0xd3, 0x97, 
  0x6e, 0xfa, 0xd2, 0xd1, 0x65, 0xad, 0x88, 0x4f, 
  0xcf, 0x9a, 0x2e, 0x81, 0x73, 0xc6, 0x1d, 0x5f, 
  0x5a, 0xc9, 0xd4, 0x63, 0xc2, 0x34, 0xf1, 0xf7, 
  0xf3, 0xee, 0xb8, 0x88, 0xd8, 0xc2, 0x4c, 0x4e, 
  0x16, 0x2a, 0x68, 0x9e, 0x34, 0x2f, 0xa3, 0xaf, 
  0x67, 0x29, 0x25, 0xd3, 0x93, 0x8f, 0x8f, 0xb1, 
  0xf7, 0x5a, 0x1b, 0x38, 0x9c, 0x74, 0x38, 0xe9, 
  0x70, 0xb2, 0x63, 0x8e, 0x71, 0x40, 0xe9, 0x80, 
  0xd2, 0x01, 0x65, 0xad, 0x88, 0xdf, 0x7f, 0x4c, 
  0xa0, 0x3c, 0x2c, 0x5c, 0xc3, 0xb2, 0xce, 0x48, 
  0x7f, 0x24, 0x63, 0xfd, 0xb1, 0x81, 0x47, 0x5d, 
  0x32, 0xc0, 0xe8, 0x4b, 0x58, 0x7f, 0xd4, 0x06, 
  0x1b, 0x56, 0xeb, 0xc4, 0xae, 0xbe, 0x73, 0xa2, 
  0x71, 0x61, 0xb9, 0x48, 0x2c, 0x9a, 0x71, 0x96, 
  0x6c, 0x2d, 0x66, 0xb3, 0xfa, 0x60, 0xcb, 0x3b, 
  0x73, 0xb8, 0xb1, 0x34, 0x44, 0x4a, 0x4e, 0xa7, 
  0xb9, 0x04, 0x71, 0xb0, 0xee, 0xd7, 0x26, 0xcb, 
  0x12, 0x2f, 0x40, 0x3f, 0xbe, 0x87, 0xcd, 0x14, 
  0x99, 0x5e, 0x40, 0x35, 0x0e, 0xcd, 0x17, 0x65, 
  0xaa, 0x6a, 0xbf, 0xfe, 0xfc, 0xad, 0x5b, 0xc7, 
  0x67, 0x5f, 0x5c, 0xb8, 0xed, 0x42, 0xbb, 0x56, 
  0xb9, 0xea, 0x98, 0xef, 0x22, 0x1c, 0x8a, 0xbd, 
  0x53, 0xdc, 0xed, 0x63, 0x6e, 0x1d, 0x6f, 0x45, 
  0xac, 0x7b, 0x71, 0xee, 0xc6, 0xb8, 0x73, 0x70, 
  0x6c, 0x56, 0x0d, 0x1f, 0x2c, 0x68, 0x38, 0x07, 
  0xb9, 0x6e, 0x52, 0xbb, 0xbb, 0x75, 0xd7, 0xc8, 
  0x58, 0x2a, 0x54, 0x69, 0x2e, 0xb1, 0xb7, 0xfd, 
  0x71, 0x13, 0xd5, 0x1c, 0xb7, 0x0d, 0x57, 0x17, 
  0x28, 0x9f, 0x74, 0xbb, 0x08, 0xe5, 0x3c, 0xf3, 
  0x3b, 0xfd, 0x00, 0xd7, 0x9c, 0xe5, 0x99, 0xc9, 
  0x35, 0x42, 0xfd, 0x3b, 0xd7, 0xff, 0x9a, 0xdf, 
  0x33, 0xab, 0x75, 0x9b, 0xc7, 0xfb, 0x85, 0x5c, 
  0x96, 0xce, 0xe8, 0xb4, 0xb7, 0x5c, 0xed, 0xb0, 
  0xc6, 0x6a, 0xb3, 0x46, 0x59, 0x9d, 0x55, 0xe9, 
  0xa9, 0x98, 0x3a, 0xe3, 0xcd, 0xed, 0x8d, 0x3a, 
  0xab, 0xed, 0x1f, 0xa9, 0x75, 0x76, 0xbb, 0x8f, 
  0x7b, 0xd7, 0x59, 0x96, 0xdf, 0x49, 0xac, 0xb3, 
  0x2e, 0x2d, 0x9e, 0x31, 0x5c, 0xd5, 0x58, 0x65, 
  0x55, 0x8d, 0x87, 0x5b, 0xdf, 0xc1, 0xfa, 0x1f, 
  0xe3, 0x53, 0x84, 0x08, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x28, 0x75, 0x75, 0x61, 0x79, 0x29, 0x63, 
  0x6f, 0x6c, 0x6f, 0x72, 0x2d, 0x6d, 0x61, 0x6e, 
  0x61, 0x67, 0x65, 0x72, 0x2f, 0x00, 0x00, 0x00, 
  0x02, 0x00, 0x00, 0x00, 0x67, 0x6e, 0x6f, 0x6d, 
  0x65, 0x2f, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00
} };

static GStaticResource static_resource = { gcm_resource_data.data, sizeof (gcm_resource_data.data) };
extern GResource *gcm_get_resource (void);
GResource *gcm_get_resource (void)
{
  return g_static_resource_get_resource (&static_resource);
}
/*
  If G_HAS_CONSTRUCTORS is true then the compiler support *both* constructors and
  destructors, in a sane way, including e.g. on library unload. If not you're on
  your own.

  Some compilers need #pragma to handle this, which does not work with macros,
  so the way you need to use this is (for constructors):

  #ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
  #pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(my_constructor)
  #endif
  G_DEFINE_CONSTRUCTOR(my_constructor)
  static void my_constructor(void) {
   ...
  }

*/

#if  __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) static void __attribute__((constructor)) _func (void);
#define G_DEFINE_DESTRUCTOR(_func) static void __attribute__((destructor)) _func (void);

#elif defined (_MSC_VER) && (_MSC_VER >= 1500)
/* Visual studio 2008 and later has _Pragma */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _wrapper(void) { _func(); return 0; } \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) static int (* _array ## _func)(void) = _func ## _wrapper;

#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _constructor(void) { atexit (_func); return 0; } \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) static int (* _array ## _func)(void) = _func ## _constructor;

#elif defined (_MSC_VER)

#define G_HAS_CONSTRUCTORS 1

/* Pre Visual studio 2008 must use #pragma section */
#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _wrapper(void) { _func(); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (*p)(void) = _func ## _wrapper;

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _constructor(void) { atexit (_func); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (* _array ## _func)(void) = _func ## _constructor;

#elif defined(__SUNPRO_C)

/* This is not tested, but i believe it should work, based on:
 * http://opensource.apple.com/source/OpenSSL098/OpenSSL098-35/src/fips/fips_premain.c
 */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  init(_func)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void);

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  fini(_func)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void);

#else

/* constructors not supported for this compiler */

#endif


#ifdef G_HAS_CONSTRUCTORS

#ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(resource_constructor)
#endif
G_DEFINE_CONSTRUCTOR(resource_constructor)
#ifdef G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(resource_destructor)
#endif
G_DEFINE_DESTRUCTOR(resource_destructor)

#else
#warning "Constructor not supported on this compiler, linking in resources will not work"
#endif

static void resource_constructor (void)
{
  g_static_resource_init (&static_resource);
}

static void resource_destructor (void)
{
  g_static_resource_fini (&static_resource);
}
