/* rygel-gst-utils.c generated by valac 0.15.2, the Vala compiler
 * generated from rygel-gst-utils.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gst/pbutils/pbutils.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_GST_UTILS (rygel_gst_utils_get_type ())
#define RYGEL_GST_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_UTILS, RygelGstUtils))
#define RYGEL_GST_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_UTILS, RygelGstUtilsClass))
#define RYGEL_IS_GST_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_UTILS))
#define RYGEL_IS_GST_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_UTILS))
#define RYGEL_GST_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_UTILS, RygelGstUtilsClass))

typedef struct _RygelGstUtils RygelGstUtils;
typedef struct _RygelGstUtilsClass RygelGstUtilsClass;
typedef struct _RygelGstUtilsPrivate RygelGstUtilsPrivate;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_encoding_profile_unref0(var) ((var == NULL) ? NULL : (var = (gst_encoding_profile_unref (var), NULL)))
#define __g_list_free__gst_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gst_object_unref0_ (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
typedef struct _RygelParamSpecGstUtils RygelParamSpecGstUtils;

typedef enum  {
	RYGEL_GST_ERROR_MISSING_PLUGIN,
	RYGEL_GST_ERROR_LINK
} RygelGstError;
#define RYGEL_GST_ERROR rygel_gst_error_quark ()
struct _RygelGstUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelGstUtilsPrivate * priv;
};

struct _RygelGstUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (RygelGstUtils *self);
};

struct _RygelParamSpecGstUtils {
	GParamSpec parent_instance;
};


static gpointer rygel_gst_utils_parent_class = NULL;

GQuark rygel_gst_error_quark (void);
gpointer rygel_gst_utils_ref (gpointer instance);
void rygel_gst_utils_unref (gpointer instance);
GParamSpec* rygel_param_spec_gst_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_gst_utils (GValue* value, gpointer v_object);
void rygel_value_take_gst_utils (GValue* value, gpointer v_object);
gpointer rygel_value_get_gst_utils (const GValue* value);
GType rygel_gst_utils_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_GST_UTILS_DUMMY_PROPERTY
};
GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error);
GstClockTime rygel_gst_utils_time_from_string (const gchar* str);
gchar* rygel_gst_utils_time_to_string (GstClockTime time);
GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri);
static inline void _dynamic_set_blocksize5 (GstElement* obj, glong value);
static inline void _dynamic_set_tcp_timeout6 (GstElement* obj, gint64 value);
void rygel_gst_utils_dump_encoding_profile (GstEncodingProfile* profile, gint indent);
GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps);
static gboolean rygel_gst_utils_need_rtp_depayloader (GstCaps* caps);
static void _gst_object_unref0_ (gpointer var);
static void _g_list_free__gst_object_unref0_ (GList* self);
RygelGstUtils* rygel_gst_utils_construct (GType object_type);
static void rygel_gst_utils_finalize (RygelGstUtils* obj);


GQuark rygel_gst_error_quark (void) {
	return g_quark_from_static_string ("rygel_gst_error-quark");
}


GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error) {
	GstElement* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GstElement* _tmp2_ = NULL;
	GstElement* element;
	GstElement* _tmp3_;
	GError * _inner_error_ = NULL;
#line 32 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	g_return_val_if_fail (factoryname != NULL, NULL);
#line 35 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp0_ = factoryname;
#line 35 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp1_ = name;
#line 35 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp2_ = gst_element_factory_make (_tmp0_, _tmp1_);
#line 35 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	gst_object_ref_sink (_tmp2_);
#line 35 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	element = _tmp2_;
#line 36 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp3_ = element;
#line 36 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	if (_tmp3_ == NULL) {
#line 134 "rygel-gst-utils.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_;
		GError* _tmp6_;
#line 37 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp4_ = _ ("Required element %s missing");
#line 37 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp5_ = factoryname;
#line 37 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp6_ = g_error_new (RYGEL_GST_ERROR, RYGEL_GST_ERROR_MISSING_PLUGIN, _tmp4_, _tmp5_);
#line 37 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_inner_error_ = _tmp6_;
#line 37 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		g_propagate_error (error, _inner_error_);
#line 37 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_gst_object_unref0 (element);
#line 37 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		return NULL;
#line 152 "rygel-gst-utils.c"
	}
#line 42 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	result = element;
#line 42 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	return result;
#line 158 "rygel-gst-utils.c"
}


GstClockTime rygel_gst_utils_time_from_string (const gchar* str) {
	GstClockTime result = 0ULL;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
	const gchar* _tmp0_;
#line 45 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	g_return_val_if_fail (str != NULL, 0ULL);
#line 48 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp0_ = str;
#line 48 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	sscanf (_tmp0_, "%llu:%2llu:%2llu%*s", &hours, &minutes, &seconds);
#line 50 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	result = (GstClockTime) ((((hours * 3600) + (minutes * 60)) + seconds) * GST_SECOND);
#line 50 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	return result;
#line 178 "rygel-gst-utils.c"
}


gchar* rygel_gst_utils_time_to_string (GstClockTime time) {
	gchar* result = NULL;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
	GstClockTime _tmp0_;
	GstClockTime _tmp1_;
	guint64 _tmp2_;
	guint64 _tmp3_;
	guint64 _tmp4_;
	gchar* _tmp5_ = NULL;
#line 57 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp0_ = time;
#line 57 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	hours = (guint64) ((_tmp0_ / GST_SECOND) / 3600);
#line 58 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp1_ = time;
#line 58 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	seconds = (guint64) ((_tmp1_ / GST_SECOND) % 3600);
#line 59 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp2_ = seconds;
#line 59 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	minutes = _tmp2_ / 60;
#line 60 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp3_ = seconds;
#line 60 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	seconds = _tmp3_ % 60;
#line 62 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp4_ = seconds;
#line 62 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp5_ = g_strdup_printf ("%llu:%.2llu:%.2llu", hours, minutes, _tmp4_);
#line 62 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	result = _tmp5_;
#line 62 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	return result;
#line 217 "rygel-gst-utils.c"
}


static inline void _dynamic_set_blocksize5 (GstElement* obj, glong value) {
#line 75 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	g_object_set (obj, "blocksize", value, NULL);
#line 224 "rygel-gst-utils.c"
}


static inline void _dynamic_set_tcp_timeout6 (GstElement* obj, gint64 value) {
#line 81 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	g_object_set (obj, "tcp-timeout", value, NULL);
#line 231 "rygel-gst-utils.c"
}


GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri) {
	GstElement* result = NULL;
	const gchar* _tmp0_;
	GstElement* _tmp1_ = NULL;
	GstElement* src;
	GstElement* _tmp2_;
#line 65 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 66 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp0_ = uri;
#line 66 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp1_ = gst_element_make_from_uri (GST_URI_SRC, _tmp0_, NULL);
#line 66 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	gst_object_ref_sink (_tmp1_);
#line 66 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	src = _tmp1_;
#line 67 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp2_ = src;
#line 67 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	if (_tmp2_ != NULL) {
#line 255 "rygel-gst-utils.c"
		GstElement* _tmp3_;
		gboolean _tmp4_ = FALSE;
		GstElement* _tmp6_;
		GObjectClass* _tmp7_ = NULL;
		GParamSpec* _tmp8_ = NULL;
		GstElement* _tmp10_;
		GObjectClass* _tmp11_ = NULL;
		GParamSpec* _tmp12_ = NULL;
#line 68 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp3_ = src;
#line 68 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp4_ = GST_OBJECT_IS_FLOATING ((GstObject*) _tmp3_);
#line 68 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		if (_tmp4_) {
#line 270 "rygel-gst-utils.c"
			GstElement* _tmp5_;
#line 69 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			_tmp5_ = src;
#line 69 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			gst_object_ref_sink ((GstObject*) _tmp5_);
#line 276 "rygel-gst-utils.c"
		}
#line 72 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp6_ = src;
#line 72 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp7_ = G_OBJECT_GET_CLASS ((GObject*) _tmp6_);
#line 72 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp8_ = g_object_class_find_property (_tmp7_, "blocksize");
#line 72 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		if (_tmp8_ != NULL) {
#line 286 "rygel-gst-utils.c"
			GstElement* _tmp9_;
#line 75 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			_tmp9_ = src;
#line 75 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			_dynamic_set_blocksize5 (_tmp9_, (glong) 65536);
#line 292 "rygel-gst-utils.c"
		}
#line 78 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp10_ = src;
#line 78 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp11_ = G_OBJECT_GET_CLASS ((GObject*) _tmp10_);
#line 78 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp12_ = g_object_class_find_property (_tmp11_, "tcp-timeout");
#line 78 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		if (_tmp12_ != NULL) {
#line 302 "rygel-gst-utils.c"
			GstElement* _tmp13_;
#line 81 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			_tmp13_ = src;
#line 81 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			_dynamic_set_tcp_timeout6 (_tmp13_, (gint64) 60000000);
#line 308 "rygel-gst-utils.c"
		}
	}
#line 85 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	result = src;
#line 85 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	return result;
#line 315 "rygel-gst-utils.c"
}


static gpointer _gst_encoding_profile_ref0 (gpointer self) {
#line 99 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	return self ? gst_encoding_profile_ref (self) : NULL;
#line 322 "rygel-gst-utils.c"
}


void rygel_gst_utils_dump_encoding_profile (GstEncodingProfile* profile, gint indent) {
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* indent_s;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GstEncodingProfile* _tmp5_;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GstEncodingProfile* _tmp10_;
	GstCaps* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	GstEncodingProfile* _tmp14_;
	GstCaps* _tmp15_ = NULL;
	GstEncodingProfile* _tmp23_;
#line 88 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	g_return_if_fail (profile != NULL);
#line 90 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp0_ = indent;
#line 90 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp1_ = g_strnfill ((gsize) _tmp0_, ' ');
#line 90 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	indent_s = _tmp1_;
#line 91 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp2_ = indent_s;
#line 91 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp3_ = g_strconcat (_tmp2_, "%s:", NULL);
#line 91 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp4_ = _tmp3_;
#line 91 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp5_ = profile;
#line 91 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp6_ = gst_encoding_profile_get_name (_tmp5_);
#line 91 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	g_debug (_tmp4_, _tmp6_);
#line 91 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_g_free0 (_tmp4_);
#line 92 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp7_ = indent_s;
#line 92 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp8_ = g_strconcat (_tmp7_, "  Format: %s", NULL);
#line 92 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp9_ = _tmp8_;
#line 92 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp10_ = profile;
#line 92 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp11_ = gst_encoding_profile_get_format (_tmp10_);
#line 92 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp12_ = gst_caps_to_string (_tmp11_);
#line 92 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp13_ = _tmp12_;
#line 92 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	g_debug (_tmp9_, _tmp13_);
#line 92 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_g_free0 (_tmp13_);
#line 92 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_g_free0 (_tmp9_);
#line 93 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp14_ = profile;
#line 93 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp15_ = gst_encoding_profile_get_restriction (_tmp14_);
#line 93 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	if (_tmp15_ != NULL) {
#line 393 "rygel-gst-utils.c"
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GstEncodingProfile* _tmp19_;
		GstCaps* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
#line 94 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp16_ = indent_s;
#line 94 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp17_ = g_strconcat (_tmp16_, "  Restriction: %s", NULL);
#line 94 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp18_ = _tmp17_;
#line 94 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp19_ = profile;
#line 94 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp20_ = gst_encoding_profile_get_restriction (_tmp19_);
#line 94 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp21_ = gst_caps_to_string (_tmp20_);
#line 94 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp22_ = _tmp21_;
#line 94 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		g_debug (_tmp18_, _tmp22_);
#line 94 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_g_free0 (_tmp22_);
#line 94 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_g_free0 (_tmp18_);
#line 421 "rygel-gst-utils.c"
	}
#line 98 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp23_ = profile;
#line 98 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	if (GST_IS_ENCODING_CONTAINER_PROFILE (_tmp23_)) {
#line 427 "rygel-gst-utils.c"
		GstEncodingProfile* _tmp24_;
		GstEncodingContainerProfile* _tmp25_;
		GstEncodingContainerProfile* container;
		GstEncodingContainerProfile* _tmp26_;
		GList* _tmp27_ = NULL;
#line 99 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp24_ = profile;
#line 99 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp25_ = _gst_encoding_profile_ref0 (GST_IS_ENCODING_CONTAINER_PROFILE (_tmp24_) ? ((GstEncodingContainerProfile*) _tmp24_) : NULL);
#line 99 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		container = _tmp25_;
#line 100 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp26_ = container;
#line 100 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp27_ = gst_encoding_container_profile_get_profiles (_tmp26_);
#line 443 "rygel-gst-utils.c"
		{
			GList* subprofile_collection = NULL;
			GList* subprofile_it = NULL;
#line 100 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			subprofile_collection = _tmp27_;
#line 100 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			for (subprofile_it = subprofile_collection; subprofile_it != NULL; subprofile_it = subprofile_it->next) {
#line 451 "rygel-gst-utils.c"
				GstEncodingProfile* _tmp28_;
				GstEncodingProfile* subprofile = NULL;
#line 100 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
				_tmp28_ = _gst_encoding_profile_ref0 ((GstEncodingProfile*) subprofile_it->data);
#line 100 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
				subprofile = _tmp28_;
#line 458 "rygel-gst-utils.c"
				{
					GstEncodingProfile* _tmp29_;
					gint _tmp30_;
#line 101 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
					_tmp29_ = subprofile;
#line 101 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
					_tmp30_ = indent;
#line 101 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
					rygel_gst_utils_dump_encoding_profile (_tmp29_, _tmp30_ + 4);
#line 100 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
					_gst_encoding_profile_unref0 (subprofile);
#line 470 "rygel-gst-utils.c"
				}
			}
		}
#line 98 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_gst_encoding_profile_unref0 (container);
#line 476 "rygel-gst-utils.c"
	}
#line 88 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_g_free0 (indent_s);
#line 480 "rygel-gst-utils.c"
}


static void _gst_object_unref0_ (gpointer var) {
#line 114 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	(var == NULL) ? NULL : (var = (gst_object_unref (var), NULL));
#line 487 "rygel-gst-utils.c"
}


static void _g_list_free__gst_object_unref0_ (GList* self) {
#line 114 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	g_list_foreach (self, (GFunc) _gst_object_unref0_, NULL);
#line 114 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	g_list_free (self);
#line 496 "rygel-gst-utils.c"
}


GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps) {
	GstElement* result = NULL;
	GstCaps* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GList* _tmp2_ = NULL;
	GList* features;
	GList* _tmp3_;
	GstCaps* _tmp4_;
	GList* _tmp5_ = NULL;
	GList* _tmp6_;
	gconstpointer _tmp7_;
	const gchar* _tmp8_ = NULL;
#line 106 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	g_return_val_if_fail (caps != NULL, NULL);
#line 107 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp0_ = caps;
#line 107 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp1_ = rygel_gst_utils_need_rtp_depayloader (_tmp0_);
#line 107 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	if (!_tmp1_) {
#line 108 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		result = NULL;
#line 108 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		return result;
#line 524 "rygel-gst-utils.c"
	}
#line 111 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp2_ = gst_element_factory_list_get_elements ((GstElementFactoryListType) GST_ELEMENT_FACTORY_TYPE_DEPAYLOADER, GST_RANK_NONE);
#line 111 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	features = _tmp2_;
#line 114 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp3_ = features;
#line 114 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp4_ = caps;
#line 114 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp5_ = gst_element_factory_list_filter (_tmp3_, _tmp4_, GST_PAD_SINK, FALSE);
#line 114 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	__g_list_free__gst_object_unref0_0 (features);
#line 114 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	features = _tmp5_;
#line 121 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp6_ = features;
#line 121 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp7_ = _tmp6_->data;
#line 121 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp8_ = gst_plugin_feature_get_name ((GstPluginFeature*) ((GstElementFactory*) _tmp7_));
#line 121 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	if (g_strcmp0 (_tmp8_, "rtpdepay") == 0) {
#line 548 "rygel-gst-utils.c"
		GList* _tmp9_;
		GList* _tmp10_;
#line 122 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp9_ = features;
#line 122 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp10_ = _tmp9_->next;
#line 122 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		if (_tmp10_ != NULL) {
#line 557 "rygel-gst-utils.c"
			GList* _tmp11_;
			GList* _tmp12_;
			gconstpointer _tmp13_;
			GstElement* _tmp14_ = NULL;
#line 123 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			_tmp11_ = features;
#line 123 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			_tmp12_ = _tmp11_->next;
#line 123 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			_tmp13_ = _tmp12_->data;
#line 123 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			_tmp14_ = gst_element_factory_create ((GstElementFactory*) _tmp13_, NULL);
#line 123 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			gst_object_ref_sink (_tmp14_);
#line 123 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			result = _tmp14_;
#line 123 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			__g_list_free__gst_object_unref0_0 (features);
#line 123 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			return result;
#line 578 "rygel-gst-utils.c"
		}
#line 126 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		result = NULL;
#line 126 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		__g_list_free__gst_object_unref0_0 (features);
#line 126 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		return result;
#line 586 "rygel-gst-utils.c"
	} else {
		GList* _tmp15_;
		gconstpointer _tmp16_;
		GstElement* _tmp17_ = NULL;
#line 128 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp15_ = features;
#line 128 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp16_ = _tmp15_->data;
#line 128 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		_tmp17_ = gst_element_factory_create ((GstElementFactory*) _tmp16_, NULL);
#line 128 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		gst_object_ref_sink (_tmp17_);
#line 128 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		result = _tmp17_;
#line 128 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		__g_list_free__gst_object_unref0_0 (features);
#line 128 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		return result;
#line 605 "rygel-gst-utils.c"
	}
#line 106 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	__g_list_free__gst_object_unref0_0 (features);
#line 609 "rygel-gst-utils.c"
}


static gpointer _gst_structure_copy0 (gpointer self) {
#line 133 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	return self ? gst_structure_copy (self) : NULL;
#line 616 "rygel-gst-utils.c"
}


static gboolean rygel_gst_utils_need_rtp_depayloader (GstCaps* caps) {
	gboolean result = FALSE;
	GstCaps* _tmp0_;
	const GstStructure* _tmp1_ = NULL;
	GstStructure* _tmp2_;
	GstStructure* structure;
	const gchar* _tmp3_ = NULL;
#line 132 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	g_return_val_if_fail (caps != NULL, FALSE);
#line 133 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp0_ = caps;
#line 133 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp1_ = gst_caps_get_structure (_tmp0_, (guint) 0);
#line 133 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp2_ = _gst_structure_copy0 (_tmp1_);
#line 133 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	structure = _tmp2_;
#line 135 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_tmp3_ = gst_structure_get_name (structure);
#line 135 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	result = g_strcmp0 (_tmp3_, "application/x-rtp") == 0;
#line 135 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	_gst_structure_free0 (structure);
#line 135 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	return result;
#line 645 "rygel-gst-utils.c"
}


RygelGstUtils* rygel_gst_utils_construct (GType object_type) {
	RygelGstUtils* self = NULL;
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	self = (RygelGstUtils*) g_type_create_instance (object_type);
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	return self;
#line 655 "rygel-gst-utils.c"
}


static void rygel_value_gst_utils_init (GValue* value) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	value->data[0].v_pointer = NULL;
#line 662 "rygel-gst-utils.c"
}


static void rygel_value_gst_utils_free_value (GValue* value) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	if (value->data[0].v_pointer) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		rygel_gst_utils_unref (value->data[0].v_pointer);
#line 671 "rygel-gst-utils.c"
	}
}


static void rygel_value_gst_utils_copy_value (const GValue* src_value, GValue* dest_value) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	if (src_value->data[0].v_pointer) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		dest_value->data[0].v_pointer = rygel_gst_utils_ref (src_value->data[0].v_pointer);
#line 681 "rygel-gst-utils.c"
	} else {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 685 "rygel-gst-utils.c"
	}
}


static gpointer rygel_value_gst_utils_peek_pointer (const GValue* value) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	return value->data[0].v_pointer;
#line 693 "rygel-gst-utils.c"
}


static gchar* rygel_value_gst_utils_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	if (collect_values[0].v_pointer) {
#line 700 "rygel-gst-utils.c"
		RygelGstUtils* object;
		object = collect_values[0].v_pointer;
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 707 "rygel-gst-utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 711 "rygel-gst-utils.c"
		}
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		value->data[0].v_pointer = rygel_gst_utils_ref (object);
#line 715 "rygel-gst-utils.c"
	} else {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		value->data[0].v_pointer = NULL;
#line 719 "rygel-gst-utils.c"
	}
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	return NULL;
#line 723 "rygel-gst-utils.c"
}


static gchar* rygel_value_gst_utils_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelGstUtils** object_p;
	object_p = collect_values[0].v_pointer;
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	if (!object_p) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 734 "rygel-gst-utils.c"
	}
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	if (!value->data[0].v_pointer) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		*object_p = NULL;
#line 740 "rygel-gst-utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		*object_p = value->data[0].v_pointer;
#line 744 "rygel-gst-utils.c"
	} else {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		*object_p = rygel_gst_utils_ref (value->data[0].v_pointer);
#line 748 "rygel-gst-utils.c"
	}
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	return NULL;
#line 752 "rygel-gst-utils.c"
}


GParamSpec* rygel_param_spec_gst_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecGstUtils* spec;
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_GST_UTILS), NULL);
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	return G_PARAM_SPEC (spec);
#line 766 "rygel-gst-utils.c"
}


gpointer rygel_value_get_gst_utils (const GValue* value) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_GST_UTILS), NULL);
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	return value->data[0].v_pointer;
#line 775 "rygel-gst-utils.c"
}


void rygel_value_set_gst_utils (GValue* value, gpointer v_object) {
	RygelGstUtils* old;
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_GST_UTILS));
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	old = value->data[0].v_pointer;
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	if (v_object) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_GST_UTILS));
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		value->data[0].v_pointer = v_object;
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		rygel_gst_utils_ref (value->data[0].v_pointer);
#line 795 "rygel-gst-utils.c"
	} else {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		value->data[0].v_pointer = NULL;
#line 799 "rygel-gst-utils.c"
	}
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	if (old) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		rygel_gst_utils_unref (old);
#line 805 "rygel-gst-utils.c"
	}
}


void rygel_value_take_gst_utils (GValue* value, gpointer v_object) {
	RygelGstUtils* old;
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_GST_UTILS));
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	old = value->data[0].v_pointer;
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	if (v_object) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_GST_UTILS));
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		value->data[0].v_pointer = v_object;
#line 824 "rygel-gst-utils.c"
	} else {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		value->data[0].v_pointer = NULL;
#line 828 "rygel-gst-utils.c"
	}
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	if (old) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		rygel_gst_utils_unref (old);
#line 834 "rygel-gst-utils.c"
	}
}


static void rygel_gst_utils_class_init (RygelGstUtilsClass * klass) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	rygel_gst_utils_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	RYGEL_GST_UTILS_CLASS (klass)->finalize = rygel_gst_utils_finalize;
#line 844 "rygel-gst-utils.c"
}


static void rygel_gst_utils_instance_init (RygelGstUtils * self) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	self->ref_count = 1;
#line 851 "rygel-gst-utils.c"
}


static void rygel_gst_utils_finalize (RygelGstUtils* obj) {
	RygelGstUtils * self;
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	self = RYGEL_GST_UTILS (obj);
#line 859 "rygel-gst-utils.c"
}


GType rygel_gst_utils_get_type (void) {
	static volatile gsize rygel_gst_utils_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_utils_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_gst_utils_init, rygel_value_gst_utils_free_value, rygel_value_gst_utils_copy_value, rygel_value_gst_utils_peek_pointer, "p", rygel_value_gst_utils_collect_value, "p", rygel_value_gst_utils_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstUtils), 0, (GInstanceInitFunc) rygel_gst_utils_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_gst_utils_type_id;
		rygel_gst_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelGstUtils", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_gst_utils_type_id__volatile, rygel_gst_utils_type_id);
	}
	return rygel_gst_utils_type_id__volatile;
}


gpointer rygel_gst_utils_ref (gpointer instance) {
	RygelGstUtils* self;
	self = instance;
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	return instance;
#line 884 "rygel-gst-utils.c"
}


void rygel_gst_utils_unref (gpointer instance) {
	RygelGstUtils* self;
	self = instance;
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		RYGEL_GST_UTILS_GET_CLASS (self)->finalize (self);
#line 31 "/home/jens/Source/rygel/tests/rygel-gst-utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 897 "rygel-gst-utils.c"
	}
}



