/* rygel-item-creator.c generated by valac 0.15.2, the Vala compiler
 * generated from rygel-item-creator.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gst/gst.h>
#include <libsoup/soup.h>
#include <stdio.h>
#include <libgupnp-dlna/gupnp-dlna-discoverer.h>
#include <libgupnp-dlna/gupnp-dlna-profile.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_ITEM_CREATOR (rygel_item_creator_get_type ())
#define RYGEL_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreator))
#define RYGEL_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))
#define RYGEL_IS_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_IS_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_ITEM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))

typedef struct _RygelItemCreator RygelItemCreator;
typedef struct _RygelItemCreatorClass RygelItemCreatorClass;
typedef struct _RygelItemCreatorPrivate RygelItemCreatorPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_ITEM_REMOVAL_QUEUE (rygel_item_removal_queue_get_type ())
#define RYGEL_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueue))
#define RYGEL_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_ITEM_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))

typedef struct _RygelItemRemovalQueue RygelItemRemovalQueue;
typedef struct _RygelItemRemovalQueueClass RygelItemRemovalQueueClass;
typedef struct _RygelItemCreatorRunData RygelItemCreatorRunData;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelItemCreatorFindAnyContainerData RygelItemCreatorFindAnyContainerData;
typedef struct _RygelItemCreatorFetchContainerData RygelItemCreatorFetchContainerData;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelItemCreatorCreateItemFromDidlData RygelItemCreatorCreateItemFromDidlData;
#define __vala_SoupDate_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupDate_free (var), NULL)))

#define RYGEL_TYPE_PHOTO_ITEM (rygel_photo_item_get_type ())
#define RYGEL_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItem))
#define RYGEL_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))
#define RYGEL_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))

typedef struct _RygelPhotoItem RygelPhotoItem;
typedef struct _RygelPhotoItemClass RygelPhotoItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
typedef struct _RygelItemCreatorCreateUriData RygelItemCreatorCreateUriData;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _RygelItemCreatorWaitForItemData RygelItemCreatorWaitForItemData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelItemCreator {
	GObject parent_instance;
	RygelItemCreatorPrivate * priv;
};

struct _RygelItemCreatorClass {
	GObjectClass parent_class;
};

struct _RygelItemCreatorPrivate {
	gchar* container_id;
	gchar* elements;
	GUPnPDIDLLiteItem* didl_item;
	RygelMediaItem* item;
	RygelContentDirectory* content_dir;
	GUPnPServiceAction* action;
	GUPnPDIDLLiteWriter* didl_writer;
	GUPnPDIDLLiteParser* didl_parser;
	GRegex* title_regex;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelItemCreatorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* _tmp0_;
	RygelWritableContainer* container;
	gboolean _tmp1_;
	RygelWritableContainer* _tmp2_;
	GUPnPDIDLLiteItem* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	GUPnPDIDLLiteItem* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	RygelWritableContainer* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	RygelWritableContainer* _tmp15_;
	RygelWritableContainer* _tmp16_;
	RygelMediaItem* _tmp17_;
	GCancellable* _tmp18_;
	GCancellable* _tmp19_;
	RygelWritableContainer* _tmp20_;
	RygelMediaItem* _tmp21_;
	GUPnPDIDLLiteWriter* _tmp22_;
	RygelContentDirectory* _tmp23_;
	RygelHTTPServer* _tmp24_;
	GUPnPDIDLLiteObject* _tmp25_;
	GUPnPDIDLLiteObject* _tmp26_;
	gboolean _tmp27_;
	const gchar* _tmp28_;
	RygelMediaItem* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	RygelItemRemovalQueue* _tmp33_;
	RygelItemRemovalQueue* queue;
	RygelItemRemovalQueue* _tmp34_;
	RygelMediaItem* _tmp35_;
	GCancellable* _tmp36_;
	GCancellable* _tmp37_;
	GError* err;
	GError* _tmp38_;
	GError * _inner_error_;
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelItemCreatorFindAnyContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelMediaObject* result;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelSearchableContainer* _tmp2_;
	RygelSearchableContainer* root_container;
	RygelSearchableContainer* _tmp3_;
	GUPnPDIDLLiteItem* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* upnp_class;
	RygelRelationalExpression* _tmp8_;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp9_;
	RygelRelationalExpression* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	RygelRelationalExpression* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	guint total_matches;
	RygelSearchableContainer* _tmp16_;
	RygelRelationalExpression* _tmp17_;
	GCancellable* _tmp18_;
	GCancellable* _tmp19_;
	guint _tmp20_;
	RygelMediaObjects* _tmp21_;
	RygelMediaObjects* _result_;
	RygelMediaObjects* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GUPnPDIDLLiteItem* _tmp25_;
	const gchar* _tmp26_;
	RygelMediaObjects* _tmp27_;
	gpointer _tmp28_;
	const gchar* _tmp29_;
	GUPnPDIDLLiteItem* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GError* _tmp33_;
	GError * _inner_error_;
};

struct _RygelItemCreatorFetchContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* result;
	RygelMediaObject* media_object;
	const gchar* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaObject* _tmp2_;
	RygelContentDirectory* _tmp3_;
	RygelMediaContainer* _tmp4_;
	const gchar* _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
	RygelMediaObject* _tmp8_;
	RygelMediaObject* _tmp9_;
	gboolean _tmp10_;
	RygelMediaObject* _tmp11_;
	RygelMediaObject* _tmp12_;
	gboolean _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	gboolean _tmp16_;
	RygelMediaObject* _tmp17_;
	GUPnPOCMFlags _tmp18_;
	GUPnPOCMFlags _tmp19_;
	RygelMediaObject* _tmp20_;
	gboolean _tmp21_;
	const gchar* _tmp22_;
	RygelMediaObject* _tmp23_;
	const gchar* _tmp24_;
	GError* _tmp25_;
	RygelMediaObject* _tmp26_;
	RygelWritableContainer* _tmp27_;
	GError * _inner_error_;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self, const gchar* host_ip);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelItemCreatorCreateItemFromDidlData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* container;
	GUPnPDIDLLiteItem* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	RygelWritableContainer* _tmp3_;
	GUPnPDIDLLiteItem* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GUPnPDIDLLiteItem* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	RygelMediaItem* _tmp10_;
	RygelMediaItem* _tmp11_;
	GUPnPDIDLLiteItem* _tmp12_;
	GList* _tmp13_;
	GList* resources;
	gboolean _tmp14_;
	GList* _tmp15_;
	GList* _tmp16_;
	guint _tmp17_;
	gboolean _tmp18_;
	GList* _tmp19_;
	GList* _tmp20_;
	gconstpointer _tmp21_;
	GUPnPDIDLLiteResource* _tmp22_;
	GUPnPDIDLLiteResource* resource;
	GUPnPDIDLLiteResource* _tmp23_;
	GUPnPProtocolInfo* _tmp24_;
	GUPnPProtocolInfo* _tmp25_;
	GUPnPProtocolInfo* _tmp26_;
	GUPnPProtocolInfo* info;
	GUPnPProtocolInfo* _tmp27_;
	GUPnPProtocolInfo* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	GUPnPProtocolInfo* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gboolean _tmp34_;
	GUPnPProtocolInfo* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	GError* _tmp38_;
	RygelMediaItem* _tmp39_;
	GUPnPProtocolInfo* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	GUPnPProtocolInfo* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	RygelMediaItem* _tmp47_;
	GUPnPProtocolInfo* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* sanitized_uri;
	GUPnPDIDLLiteResource* _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	gchar* _tmp55_;
	gboolean _tmp56_;
	RygelMediaItem* _tmp57_;
	const gchar* _tmp58_;
	GUPnPDIDLLiteResource* _tmp59_;
	glong _tmp60_;
	glong _tmp61_;
	RygelMediaItem* _tmp62_;
	GUPnPDIDLLiteResource* _tmp63_;
	glong _tmp64_;
	glong _tmp65_;
	RygelMediaItem* _tmp66_;
	const gchar* _tmp67_;
	RygelMediaItem* _tmp68_;
	gchar* _tmp69_;
	RygelMediaItem* _tmp70_;
	gint64 _tmp71_;
	gint64 _tmp72_;
	RygelMediaItem* _tmp73_;
	RygelMediaItem* _tmp74_;
	GeeArrayList* _tmp75_;
	gint _tmp76_;
	gint _tmp77_;
	RygelWritableContainer* _tmp78_;
	RygelMediaItem* _tmp79_;
	const gchar* _tmp80_;
	const gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* uri;
	RygelMediaItem* _tmp83_;
	GeeArrayList* _tmp84_;
	const gchar* _tmp85_;
	RygelMediaItem* _tmp86_;
	RygelMediaItem* _tmp87_;
	GeeArrayList* _tmp88_;
	gpointer _tmp89_;
	gchar* _tmp90_;
	GFile* _tmp91_;
	GFile* _tmp92_;
	GFile* file;
	RygelMediaItem* _tmp93_;
	GFile* _tmp94_;
	gboolean _tmp95_;
	RygelMediaItem* _tmp96_;
	RygelMediaItem* _tmp97_;
	GeeArrayList* _tmp98_;
	gpointer _tmp99_;
	GError * _inner_error_;
};

struct _RygelItemCreatorCreateUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* container;
	gchar* title;
	gchar* result;
	RygelWritableContainer* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GFile* _tmp3_;
	GFile* dir;
	GFile* _tmp4_;
	const gchar* _tmp5_;
	RygelWritableContainer* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	gchar* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFile* file;
	guchar* _tmp16_;
	guchar* udn;
	gint udn_length1;
	gint _udn_size_;
	guchar* _tmp17_;
	guchar* id;
	gint id_length1;
	gint _id_size_;
	guchar* _tmp18_;
	gint _tmp18__length1;
	guchar* _tmp19_;
	gint _tmp19__length1;
	guchar* _tmp20_;
	gint _tmp20__length1;
	GFile* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	guchar* _tmp24_;
	gint _tmp24__length1;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GError * _inner_error_;
};

struct _Block8Data {
	int _ref_count_;
	RygelItemCreator * self;
	RygelWritableContainer* container;
	gpointer _async_data_;
};

struct _Block9Data {
	int _ref_count_;
	Block8Data * _data8_;
	guint timeout;
};

struct _RygelItemCreatorWaitForItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* container;
	Block8Data* _data8_;
	RygelWritableContainer* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaItem* item;
	RygelMediaItem* _tmp4_;
	RygelWritableContainer* _tmp5_;
	RygelMediaItem* _tmp6_;
	const gchar* _tmp7_;
	GCancellable* _tmp8_;
	GCancellable* _tmp9_;
	RygelMediaObject* _tmp10_;
	RygelMediaObject* _tmp11_;
	GError* _error_;
	RygelWritableContainer* _tmp12_;
	const gchar* _tmp13_;
	RygelMediaItem* _tmp14_;
	const gchar* _tmp15_;
	RygelMediaItem* _tmp16_;
	Block9Data* _data9_;
	RygelWritableContainer* _tmp17_;
	gulong _tmp18_;
	gulong id;
	guint _tmp19_;
	RygelWritableContainer* _tmp20_;
	gulong _tmp21_;
	guint _tmp22_;
	guint _tmp23_;
	RygelWritableContainer* _tmp24_;
	const gchar* _tmp25_;
	GError * _inner_error_;
};


static gpointer rygel_item_creator_parent_class = NULL;
static GPatternSpec* rygel_item_creator_comment_pattern;
static GPatternSpec* rygel_item_creator_comment_pattern = NULL;
static RygelStateMachineIface* rygel_item_creator_rygel_state_machine_parent_iface = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_item_creator_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
#define RYGEL_ITEM_CREATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorPrivate))
enum  {
	RYGEL_ITEM_CREATOR_DUMMY_PROPERTY,
	RYGEL_ITEM_CREATOR_CANCELLABLE
};
#define RYGEL_ITEM_CREATOR_INVALID_CHARS "/?<>\\:*|\""
RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_item_creator_real_run_data_free (gpointer _data);
static void rygel_item_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_item_creator_real_run_co (RygelItemCreatorRunData* _data_);
static void rygel_item_creator_parse_args (RygelItemCreator* self, GError** error);
static void rygel_item_creator_parse_didl (RygelItemCreator* self, GError** error);
static void rygel_item_creator_fetch_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
static RygelWritableContainer* rygel_item_creator_fetch_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
static void rygel_item_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean rygel_writable_container_can_create (RygelWritableContainer* self, const gchar* upnp_class);
GQuark rygel_content_directory_error_quark (void);
static void rygel_item_creator_create_item_from_didl (RygelItemCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_creator_create_item_from_didl_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
void rygel_writable_container_add_item (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_item_creator_wait_for_item (RygelItemCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_creator_wait_for_item_finish (RygelItemCreator* self, GAsyncResult* _res_);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
static void rygel_item_creator_conclude (RygelItemCreator* self);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
GType rygel_item_removal_queue_get_type (void) G_GNUC_CONST;
RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void);
void rygel_item_removal_queue_queue (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable);
static void rygel_item_creator_handle_error (RygelItemCreator* self, GError* _error_);
static void __lambda11_ (RygelItemCreator* self, GUPnPDIDLLiteItem* didl_item);
static void ___lambda11__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self);
static void rygel_item_creator_generalize_upnp_class (RygelItemCreator* self, gchar** upnp_class);
static void rygel_item_creator_find_any_container_data_free (gpointer _data);
static void rygel_item_creator_find_any_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObject* rygel_item_creator_find_any_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_item_creator_find_any_container_co (RygelItemCreatorFindAnyContainerData* _data_);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_item_creator_find_any_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_item_creator_fetch_container_data_free (gpointer _data);
static gboolean rygel_item_creator_fetch_container_co (RygelItemCreatorFetchContainerData* _data_);
static void rygel_item_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
static gchar* rygel_item_creator_get_generic_mime_type (RygelItemCreator* self);
GType rygel_image_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
static void rygel_item_creator_create_item_from_didl_data_free (gpointer _data);
static gboolean rygel_item_creator_create_item_from_didl_co (RygelItemCreatorCreateItemFromDidlData* _data_);
static RygelMediaItem* rygel_item_creator_create_item (RygelItemCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error);
static gboolean rygel_item_creator_is_profile_valid (RygelItemCreator* self, const gchar* profile);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gboolean rygel_item_creator_is_valid_uri (RygelItemCreator* self, const gchar* uri, gchar** sanitized_uri);
void rygel_media_item_add_uri (RygelMediaItem* self, const gchar* uri);
void rygel_media_item_set_size (RygelMediaItem* self, gint64 value);
gint64 rygel_media_item_get_size (RygelMediaItem* self);
static void rygel_item_creator_create_uri (RygelItemCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* rygel_item_creator_create_uri_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
static void rygel_item_creator_create_item_from_didl_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_item_set_place_holder (RygelMediaItem* self, gboolean value);
static void rygel_item_creator_parse_and_verify_didl_date (RygelItemCreator* self, GError** error);
static void _vala_SoupDate_free (SoupDate* self);
#define RYGEL_IMAGE_ITEM_UPNP_CLASS "object.item.imageItem"
#define RYGEL_PHOTO_ITEM_UPNP_CLASS "object.item.imageItem.photo"
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
RygelImageItem* rygel_image_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelImageItem* rygel_image_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelPhotoItem* rygel_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelPhotoItem* rygel_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_photo_item_get_type (void) G_GNUC_CONST;
RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
static void _vala_SoupURI_free (SoupURI* self);
static gchar* rygel_item_creator_mangle_title (RygelItemCreator* self, const gchar* title, GError** error);
static void rygel_item_creator_create_uri_data_free (gpointer _data);
static gboolean rygel_item_creator_create_uri_co (RygelItemCreatorCreateUriData* _data_);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static void rygel_item_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void uuid_generate (guchar* uuid);
void uuid_unparse (guchar* uuid, guchar* output);
static void rygel_item_creator_wait_for_item_data_free (gpointer _data);
static gboolean rygel_item_creator_wait_for_item_co (RygelItemCreatorWaitForItemData* _data_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void rygel_item_creator_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void ____lambda12_ (Block9Data* _data9_, RygelMediaContainer* container);
static void _____lambda12__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
static gboolean ____lambda13_ (Block9Data* _data9_);
static gboolean _____lambda13__gsource_func (gpointer self);
static void rygel_item_creator_finalize (GObject* obj);
static void _vala_rygel_item_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_item_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelItemCreator * self = NULL;
	RygelContentDirectory* _tmp0_;
	RygelContentDirectory* _tmp1_;
	RygelContentDirectory* _tmp2_;
	GCancellable* _tmp3_;
	GUPnPServiceAction* _tmp4_;
	GUPnPDIDLLiteWriter* _tmp5_;
	GUPnPDIDLLiteParser* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelItemCreator*) g_object_new (object_type, NULL);
	_tmp0_ = content_dir;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->content_dir);
	self->priv->content_dir = _tmp1_;
	_tmp2_ = content_dir;
	_tmp3_ = _tmp2_->cancellable;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp3_);
	_tmp4_ = action;
	action = NULL;
	self->priv->action = _tmp4_;
	_tmp5_ = gupnp_didl_lite_writer_new (NULL);
	_g_object_unref0 (self->priv->didl_writer);
	self->priv->didl_writer = _tmp5_;
	_tmp6_ = gupnp_didl_lite_parser_new ();
	_g_object_unref0 (self->priv->didl_parser);
	self->priv->didl_parser = _tmp6_;
	{
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* pattern;
		GRegex* _tmp13_;
		GRegex* _tmp14_;
		_tmp7_ = g_regex_escape_string (RYGEL_ITEM_CREATOR_INVALID_CHARS, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat ("[", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp10_, "]", NULL);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		pattern = _tmp12_;
		_tmp13_ = g_regex_new (pattern, G_REGEX_OPTIMIZE, G_REGEX_MATCH_NOTEMPTY, &_inner_error_);
		_tmp14_ = _tmp13_;
		if (_inner_error_ != NULL) {
			_g_free0 (pattern);
			goto __catch82_g_error;
		}
		_g_regex_unref0 (self->priv->title_regex);
		self->priv->title_regex = _tmp14_;
		_g_free0 (pattern);
	}
	goto __finally82;
	__catch82_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally82:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	return rygel_item_creator_construct (RYGEL_TYPE_ITEM_CREATOR, content_dir, action);
}


static void rygel_item_creator_real_run_data_free (gpointer _data) {
	RygelItemCreatorRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemCreatorRunData, _data_);
}


static void rygel_item_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreator * self;
	RygelItemCreatorRunData* _data_;
	RygelItemCreator* _tmp0_;
	self = (RygelItemCreator*) base;
	_data_ = g_slice_new0 (RygelItemCreatorRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_item_creator_real_run_co (_data_);
}


static void rygel_item_creator_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelItemCreatorRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_item_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_creator_real_run_co (_data_);
}


static gboolean rygel_item_creator_real_run_co (RygelItemCreatorRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		rygel_item_creator_parse_args (_data_->self, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch83_g_error;
		}
		rygel_item_creator_parse_didl (_data_->self, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch83_g_error;
		}
		_data_->_state_ = 1;
		rygel_item_creator_fetch_container (_data_->self, rygel_item_creator_run_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = rygel_item_creator_fetch_container_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->container = _data_->_tmp0_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch83_g_error;
		}
		_data_->_tmp2_ = _data_->container;
		_data_->_tmp3_ = _data_->self->priv->didl_item;
		_data_->_tmp4_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = FALSE;
		_data_->_tmp6_ = rygel_writable_container_can_create (_data_->_tmp2_, _data_->_tmp5_);
		if (!_data_->_tmp6_) {
			_data_->_tmp7_ = _data_->self->priv->container_id;
			_data_->_tmp1_ = g_strcmp0 (_data_->_tmp7_, "DLNA_ORG.AnyContainer") != 0;
		} else {
			_data_->_tmp1_ = FALSE;
		}
		_data_->_tmp8_ = _data_->_tmp1_;
		if (_data_->_tmp8_) {
			_data_->_tmp9_ = _data_->self->priv->didl_item;
			_data_->_tmp10_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp9_);
			_data_->_tmp11_ = _data_->_tmp10_;
			_data_->_tmp12_ = _data_->container;
			_data_->_tmp13_ = ((RygelMediaObject*) _data_->_tmp12_)->id;
			_data_->_tmp14_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Creating of objects with class %s " "is not supported in %s", _data_->_tmp11_, _data_->_tmp13_);
			_data_->_inner_error_ = _data_->_tmp14_;
			_g_object_unref0 (_data_->container);
			goto __catch83_g_error;
		}
		_data_->_tmp15_ = _data_->container;
		_data_->_state_ = 2;
		rygel_item_creator_create_item_from_didl (_data_->self, _data_->_tmp15_, rygel_item_creator_run_ready, _data_);
		return FALSE;
		_state_2:
		rygel_item_creator_create_item_from_didl_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			_g_object_unref0 (_data_->container);
			goto __catch83_g_error;
		}
		_data_->_tmp16_ = _data_->container;
		_data_->_tmp17_ = _data_->self->priv->item;
		_data_->_tmp18_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_state_ = 3;
		rygel_writable_container_add_item (_data_->_tmp16_, _data_->_tmp17_, _data_->_tmp19_, rygel_item_creator_run_ready, _data_);
		return FALSE;
		_state_3:
		rygel_writable_container_add_item_finish (_data_->_tmp16_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			_g_object_unref0 (_data_->container);
			goto __catch83_g_error;
		}
		_data_->_tmp20_ = _data_->container;
		_data_->_state_ = 4;
		rygel_item_creator_wait_for_item (_data_->self, _data_->_tmp20_, rygel_item_creator_run_ready, _data_);
		return FALSE;
		_state_4:
		rygel_item_creator_wait_for_item_finish (_data_->self, _data_->_res_);
		_data_->_tmp21_ = _data_->self->priv->item;
		_data_->_tmp22_ = _data_->self->priv->didl_writer;
		_data_->_tmp23_ = _data_->self->priv->content_dir;
		_data_->_tmp24_ = _data_->_tmp23_->http_server;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = rygel_media_object_serialize ((RygelMediaObject*) _data_->_tmp21_, _data_->_tmp22_, _data_->_tmp24_, &_data_->_inner_error_);
		_data_->_tmp26_ = _data_->_tmp25_;
		_g_object_unref0 (_data_->_tmp26_);
		if (_data_->_inner_error_ != NULL) {
			_g_object_unref0 (_data_->container);
			goto __catch83_g_error;
		}
		rygel_item_creator_conclude (_data_->self);
		_data_->_tmp28_ = _data_->self->priv->container_id;
		if (g_strcmp0 (_data_->_tmp28_, "DLNA.ORG_AnyContainer") == 0) {
			_data_->_tmp29_ = _data_->self->priv->item;
			_data_->_tmp30_ = rygel_media_item_get_place_holder (_data_->_tmp29_);
			_data_->_tmp31_ = _data_->_tmp30_;
			_data_->_tmp27_ = _data_->_tmp31_;
		} else {
			_data_->_tmp27_ = FALSE;
		}
		_data_->_tmp32_ = _data_->_tmp27_;
		if (_data_->_tmp32_) {
			_data_->_tmp33_ = NULL;
			_data_->_tmp33_ = rygel_item_removal_queue_get_default ();
			_data_->queue = _data_->_tmp33_;
			_data_->_tmp34_ = _data_->queue;
			_data_->_tmp35_ = _data_->self->priv->item;
			_data_->_tmp36_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
			_data_->_tmp37_ = _data_->_tmp36_;
			rygel_item_removal_queue_queue (_data_->_tmp34_, _data_->_tmp35_, _data_->_tmp37_);
			_g_object_unref0 (_data_->queue);
		}
		_g_object_unref0 (_data_->container);
	}
	goto __finally83;
	__catch83_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp38_ = _data_->err;
		rygel_item_creator_handle_error (_data_->self, _data_->_tmp38_);
		_g_error_free0 (_data_->err);
	}
	__finally83:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Check the supplied input parameters.
     */
static void rygel_item_creator_parse_args (RygelItemCreator* self, GError** error) {
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->action;
	gupnp_service_action_get (_tmp0_, "ContainerID", G_TYPE_STRING, &self->priv->container_id, "Elements", G_TYPE_STRING, &self->priv->elements, NULL);
	_tmp1_ = self->priv->elements;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_;
		_tmp2_ = _ ("'Elements' argument missing.");
		_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp2_);
		_inner_error_ = _tmp3_;
		g_propagate_error (error, _inner_error_);
		return;
	} else {
		GPatternSpec* _tmp4_;
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = rygel_item_creator_comment_pattern;
		_tmp5_ = self->priv->elements;
		_tmp6_ = g_pattern_match_string (_tmp4_, _tmp5_);
		if (_tmp6_) {
			const gchar* _tmp7_ = NULL;
			GError* _tmp8_;
			_tmp7_ = _ ("Comments not allowed in XML");
			_tmp8_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp7_);
			_inner_error_ = _tmp8_;
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp9_ = self->priv->container_id;
	if (_tmp9_ == NULL) {
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_;
		_tmp10_ = _ ("No such object");
		_tmp11_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _tmp10_);
		_inner_error_ = _tmp11_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/**
     * Parse the given DIDL-Lite snippet.
     *
     * Parses the DIDL-Lite and performs checking of the passed meta-data
     * according to UPnP and DLNA guidelines.
     */
static void __lambda11_ (RygelItemCreator* self, GUPnPDIDLLiteItem* didl_item) {
	GUPnPDIDLLiteItem* _tmp0_;
	GUPnPDIDLLiteItem* _tmp1_;
	g_return_if_fail (didl_item != NULL);
	_tmp0_ = didl_item;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->didl_item);
	self->priv->didl_item = _tmp1_;
}


static void ___lambda11__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self) {
	__lambda11_ (self, item);
}


static void rygel_item_creator_parse_didl (RygelItemCreator* self, GError** error) {
	GUPnPDIDLLiteParser* _tmp0_;
	GUPnPDIDLLiteItem* _tmp4_;
	gboolean _tmp10_ = FALSE;
	GUPnPDIDLLiteItem* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp17_;
	GUPnPDIDLLiteItem* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GUPnPDIDLLiteItem* _tmp23_;
	GUPnPOCMFlags _tmp24_;
	GUPnPOCMFlags _tmp25_;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	GUPnPDIDLLiteItem* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gboolean _tmp35_;
	gboolean _tmp40_;
	GUPnPDIDLLiteItem* _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->didl_parser;
	g_signal_connect_object (_tmp0_, "item-available", (GCallback) ___lambda11__gupnp_didl_lite_parser_item_available, self, 0);
	{
		GUPnPDIDLLiteParser* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->didl_parser;
		_tmp2_ = self->priv->elements;
		gupnp_didl_lite_parser_parse_didl (_tmp1_, _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch84_g_error;
		}
	}
	goto __finally84;
	__catch84_g_error:
	{
		GError* parse_err = NULL;
		GError* _tmp3_;
		parse_err = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Bad metadata");
		_inner_error_ = _tmp3_;
		_g_error_free0 (parse_err);
		goto __finally84;
	}
	__finally84:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp4_ = self->priv->didl_item;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* message;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GError* _tmp9_;
		_tmp5_ = _ ("No items in DIDL-Lite from client: '%s'");
		_tmp6_ = g_strdup (_tmp5_);
		message = _tmp6_;
		_tmp7_ = message;
		_tmp8_ = self->priv->elements;
		_tmp9_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp7_, _tmp8_);
		_inner_error_ = _tmp9_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (message);
		return;
	}
	_tmp11_ = self->priv->didl_item;
	_tmp12_ = gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) _tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		GUPnPDIDLLiteItem* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp14_ = self->priv->didl_item;
		_tmp15_ = gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp10_ = g_strcmp0 (_tmp16_, "") != 0;
	}
	_tmp17_ = _tmp10_;
	if (_tmp17_) {
		GError* _tmp18_;
		_tmp18_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "@id must be set to \"\" in " "CreateItem");
		_inner_error_ = _tmp18_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp19_ = self->priv->didl_item;
	_tmp20_ = gupnp_didl_lite_object_get_title ((GUPnPDIDLLiteObject*) _tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp21_ == NULL) {
		GError* _tmp22_;
		_tmp22_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "dc:title must be set in " "CreateItem");
		_inner_error_ = _tmp22_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp23_ = self->priv->didl_item;
	_tmp24_ = gupnp_didl_lite_object_get_dlna_managed ((GUPnPDIDLLiteObject*) _tmp23_);
	_tmp25_ = _tmp24_;
	if ((_tmp25_ & ((GUPNP_OCM_FLAGS_UPLOAD | GUPNP_OCM_FLAGS_CREATE_CONTAINER) | GUPNP_OCM_FLAGS_UPLOAD_DESTROYABLE)) != 0) {
		GError* _tmp26_;
		_tmp26_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Flags that must not be set " "were found in 'dlnaManaged'");
		_inner_error_ = _tmp26_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp29_ = self->priv->didl_item;
	_tmp30_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _tmp29_);
	_tmp31_ = _tmp30_;
	if (_tmp31_ == NULL) {
		_tmp28_ = TRUE;
	} else {
		GUPnPDIDLLiteItem* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		_tmp32_ = self->priv->didl_item;
		_tmp33_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp28_ = g_strcmp0 (_tmp34_, "") == 0;
	}
	_tmp35_ = _tmp28_;
	if (_tmp35_) {
		_tmp27_ = TRUE;
	} else {
		GUPnPDIDLLiteItem* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		gboolean _tmp39_ = FALSE;
		_tmp36_ = self->priv->didl_item;
		_tmp37_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_str_has_prefix (_tmp38_, "object.item");
		_tmp27_ = !_tmp39_;
	}
	_tmp40_ = _tmp27_;
	if (_tmp40_) {
		GError* _tmp41_;
		_tmp41_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Invalid upnp:class given ");
		_inner_error_ = _tmp41_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp42_ = self->priv->didl_item;
	_tmp43_ = gupnp_didl_lite_object_get_restricted ((GUPnPDIDLLiteObject*) _tmp42_);
	_tmp44_ = _tmp43_;
	if (_tmp44_) {
		GError* _tmp45_;
		_tmp45_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, "Cannot create restricted item");
		_inner_error_ = _tmp45_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/**
     * Modify the give UPnP class to be a more general one.
     *
     * Used to simplify the search for a valid container in the
     * DLNA.ORG_AnyContainer use-case.
     * Example: object.item.videoItem.videoBroadcast → object.item.videoItem
     *
     * @param upnp_class the current UPnP class which will be modified in-place.
     */
static void rygel_item_creator_generalize_upnp_class (RygelItemCreator* self, gchar** upnp_class) {
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* needle;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*upnp_class != NULL);
	_tmp0_ = *upnp_class;
	_tmp1_ = g_strrstr_len (_tmp0_, (gssize) (-1), ".");
	needle = _tmp1_;
	_tmp2_ = needle;
	if (_tmp2_ != NULL) {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = needle;
		*_tmp3_ = '\0';
		_tmp4_ = *_tmp3_;
	}
}


static void rygel_item_creator_find_any_container_data_free (gpointer _data) {
	RygelItemCreatorFindAnyContainerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemCreatorFindAnyContainerData, _data_);
}


static void rygel_item_creator_find_any_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorFindAnyContainerData* _data_;
	RygelItemCreator* _tmp0_;
	_data_ = g_slice_new0 (RygelItemCreatorFindAnyContainerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_find_any_container);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_find_any_container_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_item_creator_find_any_container_co (_data_);
}


static RygelMediaObject* rygel_item_creator_find_any_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelItemCreatorFindAnyContainerData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Find a container that can create items matching the UPnP class of the
     * requested item.
     *
     * If the item's UPnP class cannot be found, generalize the UPnP class until
     * we reach object.item according to DLNA guideline 7.3.120.4.
     *
     * @returns a container able to create the item or null if no such container
     *          can be found.
     */
static void rygel_item_creator_find_any_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorFindAnyContainerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_creator_find_any_container_co (_data_);
}


static gboolean rygel_item_creator_find_any_container_co (RygelItemCreatorFindAnyContainerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->content_dir;
	_data_->_tmp1_ = _data_->_tmp0_->root_container;
	_data_->_tmp2_ = _g_object_ref0 (RYGEL_IS_SEARCHABLE_CONTAINER (_data_->_tmp1_) ? ((RygelSearchableContainer*) _data_->_tmp1_) : NULL);
	_data_->root_container = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->root_container;
	if (_data_->_tmp3_ == NULL) {
		_data_->result = NULL;
		_g_object_unref0 (_data_->root_container);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->didl_item;
	_data_->_tmp5_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
	_data_->upnp_class = _data_->_tmp7_;
	_data_->_tmp8_ = rygel_relational_expression_new ();
	_data_->expression = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->expression;
	((RygelSearchExpression*) _data_->_tmp9_)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM);
	_data_->_tmp10_ = _data_->expression;
	_data_->_tmp11_ = g_strdup ("upnp:createClass");
	_g_free0 (((RygelSearchExpression*) _data_->_tmp10_)->operand1);
	((RygelSearchExpression*) _data_->_tmp10_)->operand1 = _data_->_tmp11_;
	while (TRUE) {
		_data_->_tmp12_ = _data_->upnp_class;
		if (!(g_strcmp0 (_data_->_tmp12_, "object.item") != 0)) {
			break;
		}
		_data_->_tmp13_ = _data_->expression;
		_data_->_tmp14_ = _data_->upnp_class;
		_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
		_g_free0 (((RygelSearchExpression*) _data_->_tmp13_)->operand2);
		((RygelSearchExpression*) _data_->_tmp13_)->operand2 = _data_->_tmp15_;
		_data_->_tmp16_ = _data_->root_container;
		_data_->_tmp17_ = _data_->expression;
		_data_->_tmp18_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_tmp20_ = 0U;
		_data_->_state_ = 1;
		rygel_searchable_container_search (_data_->_tmp16_, (RygelSearchExpression*) _data_->_tmp17_, (guint) 0, (guint) 1, _data_->_tmp19_, rygel_item_creator_find_any_container_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = rygel_searchable_container_search_finish (_data_->_tmp16_, _data_->_res_, &_data_->_tmp20_, &_data_->_inner_error_);
		_data_->total_matches = _data_->_tmp20_;
		_data_->_result_ = _data_->_tmp21_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_rygel_search_expression_unref0 (_data_->expression);
			_g_free0 (_data_->upnp_class);
			_g_object_unref0 (_data_->root_container);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp22_ = _data_->_result_;
		_data_->_tmp23_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp22_);
		_data_->_tmp24_ = _data_->_tmp23_;
		if (_data_->_tmp24_ > 0) {
			_data_->_tmp25_ = _data_->self->priv->didl_item;
			_data_->_tmp26_ = _data_->upnp_class;
			gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp25_, _data_->_tmp26_);
			_data_->_tmp27_ = _data_->_result_;
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp27_, 0);
			_data_->result = (RygelMediaObject*) _data_->_tmp28_;
			_g_object_unref0 (_data_->_result_);
			_rygel_search_expression_unref0 (_data_->expression);
			_g_free0 (_data_->upnp_class);
			_g_object_unref0 (_data_->root_container);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			rygel_item_creator_generalize_upnp_class (_data_->self, &_data_->upnp_class);
		}
		_g_object_unref0 (_data_->_result_);
	}
	_data_->_tmp29_ = _data_->upnp_class;
	if (g_strcmp0 (_data_->_tmp29_, "object.item") == 0) {
		_data_->_tmp30_ = _data_->self->priv->didl_item;
		_data_->_tmp31_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp30_);
		_data_->_tmp32_ = _data_->_tmp31_;
		_data_->_tmp33_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "'%s' UPnP class unsupported", _data_->_tmp32_);
		_data_->_inner_error_ = _data_->_tmp33_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_rygel_search_expression_unref0 (_data_->expression);
		_g_free0 (_data_->upnp_class);
		_g_object_unref0 (_data_->root_container);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = NULL;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->upnp_class);
	_g_object_unref0 (_data_->root_container);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->upnp_class);
	_g_object_unref0 (_data_->root_container);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_item_creator_fetch_container_data_free (gpointer _data) {
	RygelItemCreatorFetchContainerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemCreatorFetchContainerData, _data_);
}


static void rygel_item_creator_fetch_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorFetchContainerData* _data_;
	RygelItemCreator* _tmp0_;
	_data_ = g_slice_new0 (RygelItemCreatorFetchContainerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_fetch_container);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_fetch_container_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_item_creator_fetch_container_co (_data_);
}


static RygelWritableContainer* rygel_item_creator_fetch_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelWritableContainer* result;
	RygelItemCreatorFetchContainerData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Get the container to create the item in.
     *
     * This will either try to fetch the container supplied by the caller or
     * search for a container if the caller supplied the "DLNA.ORG_AnyContainer"
     * id.
     *
     * @return a instance of WritableContainer matching the criteria
     * @throws ContentDirectoryError for various problems
     */
static void rygel_item_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorFetchContainerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_creator_fetch_container_co (_data_);
}


static gboolean rygel_item_creator_fetch_container_co (RygelItemCreatorFetchContainerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->media_object = NULL;
	_data_->_tmp0_ = _data_->self->priv->container_id;
	if (g_strcmp0 (_data_->_tmp0_, "DLNA.ORG_AnyContainer") == 0) {
		_data_->_state_ = 1;
		rygel_item_creator_find_any_container (_data_->self, rygel_item_creator_fetch_container_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = rygel_item_creator_find_any_container_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp2_ = _data_->_tmp1_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->media_object);
		_data_->media_object = _data_->_tmp2_;
	} else {
		_data_->_tmp3_ = _data_->self->priv->content_dir;
		_data_->_tmp4_ = _data_->_tmp3_->root_container;
		_data_->_tmp5_ = _data_->self->priv->container_id;
		_data_->_tmp6_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_state_ = 2;
		rygel_media_container_find_object (_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp7_, rygel_item_creator_fetch_container_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = rygel_media_container_find_object_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp9_ = _data_->_tmp8_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->media_object);
		_data_->media_object = _data_->_tmp9_;
	}
	_data_->_tmp11_ = _data_->media_object;
	if (_data_->_tmp11_ == NULL) {
		_data_->_tmp10_ = TRUE;
	} else {
		_data_->_tmp12_ = _data_->media_object;
		_data_->_tmp10_ = !RYGEL_IS_MEDIA_CONTAINER (_data_->_tmp12_);
	}
	_data_->_tmp13_ = _data_->_tmp10_;
	if (_data_->_tmp13_) {
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _ ("No such object");
		_data_->_tmp15_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp14_);
		_data_->_inner_error_ = _data_->_tmp15_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->media_object);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp17_ = _data_->media_object;
		_data_->_tmp18_ = rygel_media_object_get_ocm_flags (_data_->_tmp17_);
		_data_->_tmp19_ = _data_->_tmp18_;
		if (!((_data_->_tmp19_ & GUPNP_OCM_FLAGS_UPLOAD) == GUPNP_OCM_FLAGS_UPLOAD)) {
			_data_->_tmp16_ = TRUE;
		} else {
			_data_->_tmp20_ = _data_->media_object;
			_data_->_tmp16_ = !RYGEL_IS_WRITABLE_CONTAINER (_data_->_tmp20_);
		}
		_data_->_tmp21_ = _data_->_tmp16_;
		if (_data_->_tmp21_) {
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _ ("Object creation in %s not allowed");
			_data_->_tmp23_ = _data_->media_object;
			_data_->_tmp24_ = _data_->_tmp23_->id;
			_data_->_tmp25_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp22_, _data_->_tmp24_);
			_data_->_inner_error_ = _data_->_tmp25_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp26_ = _data_->media_object;
	_data_->_tmp27_ = _g_object_ref0 (RYGEL_IS_WRITABLE_CONTAINER (_data_->_tmp26_) ? ((RygelWritableContainer*) _data_->_tmp26_) : NULL);
	_data_->result = _data_->_tmp27_;
	_g_object_unref0 (_data_->media_object);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->media_object);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_item_creator_conclude (RygelItemCreator* self) {
	GUPnPDIDLLiteWriter* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* didl;
	GUPnPServiceAction* _tmp2_;
	RygelMediaItem* _tmp3_;
	const gchar* _tmp4_;
	GUPnPServiceAction* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->didl_writer;
	_tmp1_ = gupnp_didl_lite_writer_get_string (_tmp0_);
	didl = _tmp1_;
	_tmp2_ = self->priv->action;
	_tmp3_ = self->priv->item;
	_tmp4_ = ((RygelMediaObject*) _tmp3_)->id;
	gupnp_service_action_set (_tmp2_, "ObjectID", G_TYPE_STRING, _tmp4_, "Result", G_TYPE_STRING, didl, NULL);
	_tmp5_ = self->priv->action;
	gupnp_service_action_return (_tmp5_);
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
	_g_free0 (didl);
}


static void rygel_item_creator_handle_error (RygelItemCreator* self, GError* _error_) {
	GError* _tmp0_;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _error_;
	if (_tmp0_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
		GUPnPServiceAction* _tmp1_;
		GError* _tmp2_;
		gint _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_tmp1_ = self->priv->action;
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->code;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		gupnp_service_action_return_error (_tmp1_, (guint) _tmp3_, _tmp5_);
	} else {
		GUPnPServiceAction* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = self->priv->action;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		gupnp_service_action_return_error (_tmp6_, (guint) 701, _tmp8_);
	}
	_tmp9_ = _ ("Failed to create item under '%s': %s");
	_tmp10_ = self->priv->container_id;
	_tmp11_ = _error_;
	_tmp12_ = _tmp11_->message;
	g_warning (_tmp9_, _tmp10_, _tmp12_);
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
}


static gchar* rygel_item_creator_get_generic_mime_type (RygelItemCreator* self) {
	gchar* result = NULL;
	RygelMediaItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->item;
	if (RYGEL_IS_IMAGE_ITEM (_tmp0_)) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("image");
		result = _tmp1_;
		return result;
	} else {
		RygelMediaItem* _tmp2_;
		_tmp2_ = self->priv->item;
		if (RYGEL_IS_VIDEO_ITEM (_tmp2_)) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("video");
			result = _tmp3_;
			return result;
		} else {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("audio");
			result = _tmp4_;
			return result;
		}
	}
}


static void rygel_item_creator_create_item_from_didl_data_free (gpointer _data) {
	RygelItemCreatorCreateItemFromDidlData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->container);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemCreatorCreateItemFromDidlData, _data_);
}


static void rygel_item_creator_create_item_from_didl (RygelItemCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorCreateItemFromDidlData* _data_;
	RygelItemCreator* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
	_data_ = g_slice_new0 (RygelItemCreatorCreateItemFromDidlData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_create_item_from_didl);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_create_item_from_didl_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = container;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->container = _tmp2_;
	rygel_item_creator_create_item_from_didl_co (_data_);
}


static void rygel_item_creator_create_item_from_didl_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelItemCreatorCreateItemFromDidlData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Transfer information passed by caller to a MediaItem.
     *
     * WritableContainer works on MediaItem so we transfer the supplied data to
     * one. Additionally some checks are performed (e.g. whether the DLNA
     * profile is supported or not) or sanitize the supplied title for use as
     * part of the on-disk filename.
     *
     * This function fills ItemCreator.item.
     */
static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void rygel_item_creator_create_item_from_didl_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorCreateItemFromDidlData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_creator_create_item_from_didl_co (_data_);
}


static gboolean rygel_item_creator_create_item_from_didl_co (RygelItemCreatorCreateItemFromDidlData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->didl_item;
	_data_->_tmp1_ = gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) _data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->container;
	_data_->_tmp4_ = _data_->self->priv->didl_item;
	_data_->_tmp5_ = gupnp_didl_lite_object_get_title ((GUPnPDIDLLiteObject*) _data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = _data_->self->priv->didl_item;
	_data_->_tmp8_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = rygel_item_creator_create_item (_data_->self, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp6_, _data_->_tmp9_, &_data_->_inner_error_);
	_data_->_tmp11_ = _data_->_tmp10_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->self->priv->item);
	_data_->self->priv->item = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->self->priv->didl_item;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = gupnp_didl_lite_object_get_resources ((GUPnPDIDLLiteObject*) _data_->_tmp12_);
	_data_->resources = _data_->_tmp13_;
	_data_->_tmp15_ = _data_->resources;
	if (_data_->_tmp15_ != NULL) {
		_data_->_tmp16_ = _data_->resources;
		_data_->_tmp17_ = 0U;
		_data_->_tmp17_ = g_list_length (_data_->_tmp16_);
		_data_->_tmp14_ = _data_->_tmp17_ > ((guint) 0);
	} else {
		_data_->_tmp14_ = FALSE;
	}
	_data_->_tmp18_ = _data_->_tmp14_;
	if (_data_->_tmp18_) {
		_data_->_tmp19_ = _data_->resources;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = g_list_nth (_data_->_tmp19_, (guint) 0);
		_data_->_tmp21_ = _data_->_tmp20_->data;
		_data_->_tmp22_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) _data_->_tmp21_);
		_data_->resource = _data_->_tmp22_;
		_data_->_tmp23_ = _data_->resource;
		_data_->_tmp24_ = gupnp_didl_lite_resource_get_protocol_info (_data_->_tmp23_);
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp26_ = _g_object_ref0 (_data_->_tmp25_);
		_data_->info = _data_->_tmp26_;
		_data_->_tmp27_ = _data_->info;
		if (_data_->_tmp27_ != NULL) {
			_data_->_tmp28_ = _data_->info;
			_data_->_tmp29_ = gupnp_protocol_info_get_dlna_profile (_data_->_tmp28_);
			_data_->_tmp30_ = _data_->_tmp29_;
			if (_data_->_tmp30_ != NULL) {
				_data_->_tmp31_ = _data_->info;
				_data_->_tmp32_ = gupnp_protocol_info_get_dlna_profile (_data_->_tmp31_);
				_data_->_tmp33_ = _data_->_tmp32_;
				_data_->_tmp34_ = FALSE;
				_data_->_tmp34_ = rygel_item_creator_is_profile_valid (_data_->self, _data_->_tmp33_);
				if (!_data_->_tmp34_) {
					_data_->_tmp35_ = _data_->info;
					_data_->_tmp36_ = gupnp_protocol_info_get_dlna_profile (_data_->_tmp35_);
					_data_->_tmp37_ = _data_->_tmp36_;
					_data_->_tmp38_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "'%s' DLNA profile unsupported", _data_->_tmp37_);
					_data_->_inner_error_ = _data_->_tmp38_;
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
					g_error_free (_data_->_inner_error_);
					_g_object_unref0 (_data_->info);
					_g_object_unref0 (_data_->resource);
					__g_list_free__g_object_unref0_0 (_data_->resources);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp39_ = _data_->self->priv->item;
				_data_->_tmp40_ = _data_->info;
				_data_->_tmp41_ = gupnp_protocol_info_get_dlna_profile (_data_->_tmp40_);
				_data_->_tmp42_ = _data_->_tmp41_;
				_data_->_tmp43_ = g_strdup (_data_->_tmp42_);
				_g_free0 (_data_->_tmp39_->dlna_profile);
				_data_->_tmp39_->dlna_profile = _data_->_tmp43_;
			}
			_data_->_tmp44_ = _data_->info;
			_data_->_tmp45_ = gupnp_protocol_info_get_mime_type (_data_->_tmp44_);
			_data_->_tmp46_ = _data_->_tmp45_;
			if (_data_->_tmp46_ != NULL) {
				_data_->_tmp47_ = _data_->self->priv->item;
				_data_->_tmp48_ = _data_->info;
				_data_->_tmp49_ = gupnp_protocol_info_get_mime_type (_data_->_tmp48_);
				_data_->_tmp50_ = _data_->_tmp49_;
				_data_->_tmp51_ = g_strdup (_data_->_tmp50_);
				_g_free0 (_data_->_tmp47_->mime_type);
				_data_->_tmp47_->mime_type = _data_->_tmp51_;
			}
		}
		_data_->_tmp52_ = _data_->resource;
		_data_->_tmp53_ = gupnp_didl_lite_resource_get_uri (_data_->_tmp52_);
		_data_->_tmp54_ = _data_->_tmp53_;
		_data_->_tmp55_ = NULL;
		_data_->_tmp56_ = FALSE;
		_data_->_tmp56_ = rygel_item_creator_is_valid_uri (_data_->self, _data_->_tmp54_, &_data_->_tmp55_);
		_g_free0 (_data_->sanitized_uri);
		_data_->sanitized_uri = _data_->_tmp55_;
		if (_data_->_tmp56_) {
			_data_->_tmp57_ = _data_->self->priv->item;
			_data_->_tmp58_ = _data_->sanitized_uri;
			rygel_media_item_add_uri (_data_->_tmp57_, _data_->_tmp58_);
		}
		_data_->_tmp59_ = _data_->resource;
		_data_->_tmp60_ = gupnp_didl_lite_resource_get_size (_data_->_tmp59_);
		_data_->_tmp61_ = _data_->_tmp60_;
		if (_data_->_tmp61_ >= ((glong) 0)) {
			_data_->_tmp62_ = _data_->self->priv->item;
			_data_->_tmp63_ = _data_->resource;
			_data_->_tmp64_ = gupnp_didl_lite_resource_get_size (_data_->_tmp63_);
			_data_->_tmp65_ = _data_->_tmp64_;
			rygel_media_item_set_size (_data_->_tmp62_, (gint64) _data_->_tmp65_);
		}
		_g_free0 (_data_->sanitized_uri);
		_g_object_unref0 (_data_->info);
		_g_object_unref0 (_data_->resource);
	}
	_data_->_tmp66_ = _data_->self->priv->item;
	_data_->_tmp67_ = _data_->_tmp66_->mime_type;
	if (_data_->_tmp67_ == NULL) {
		_data_->_tmp68_ = _data_->self->priv->item;
		_data_->_tmp69_ = NULL;
		_data_->_tmp69_ = rygel_item_creator_get_generic_mime_type (_data_->self);
		_g_free0 (_data_->_tmp68_->mime_type);
		_data_->_tmp68_->mime_type = _data_->_tmp69_;
	}
	_data_->_tmp70_ = _data_->self->priv->item;
	_data_->_tmp71_ = rygel_media_item_get_size (_data_->_tmp70_);
	_data_->_tmp72_ = _data_->_tmp71_;
	if (_data_->_tmp72_ < ((gint64) 0)) {
		_data_->_tmp73_ = _data_->self->priv->item;
		rygel_media_item_set_size (_data_->_tmp73_, (gint64) 0);
	}
	_data_->_tmp74_ = _data_->self->priv->item;
	_data_->_tmp75_ = ((RygelMediaObject*) _data_->_tmp74_)->uris;
	_data_->_tmp76_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp75_);
	_data_->_tmp77_ = _data_->_tmp76_;
	if (_data_->_tmp77_ == 0) {
		_data_->_tmp78_ = _data_->container;
		_data_->_tmp79_ = _data_->self->priv->item;
		_data_->_tmp80_ = rygel_media_object_get_title ((RygelMediaObject*) _data_->_tmp79_);
		_data_->_tmp81_ = _data_->_tmp80_;
		_data_->_state_ = 1;
		rygel_item_creator_create_uri (_data_->self, _data_->_tmp78_, _data_->_tmp81_, rygel_item_creator_create_item_from_didl_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp82_ = NULL;
		_data_->_tmp82_ = rygel_item_creator_create_uri_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->uri = _data_->_tmp82_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			__g_list_free__g_object_unref0_0 (_data_->resources);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp83_ = _data_->self->priv->item;
		_data_->_tmp84_ = ((RygelMediaObject*) _data_->_tmp83_)->uris;
		_data_->_tmp85_ = _data_->uri;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp84_, _data_->_tmp85_);
		_data_->_tmp86_ = _data_->self->priv->item;
		rygel_media_item_set_place_holder (_data_->_tmp86_, TRUE);
		_g_free0 (_data_->uri);
	} else {
		_data_->_tmp87_ = _data_->self->priv->item;
		_data_->_tmp88_ = ((RygelMediaObject*) _data_->_tmp87_)->uris;
		_data_->_tmp89_ = NULL;
		_data_->_tmp89_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp88_, 0);
		_data_->_tmp90_ = (gchar*) _data_->_tmp89_;
		_data_->_tmp91_ = NULL;
		_data_->_tmp91_ = g_file_new_for_uri (_data_->_tmp90_);
		_data_->_tmp92_ = _data_->_tmp91_;
		_g_free0 (_data_->_tmp90_);
		_data_->file = _data_->_tmp92_;
		_data_->_tmp93_ = _data_->self->priv->item;
		_data_->_tmp94_ = _data_->file;
		_data_->_tmp95_ = FALSE;
		_data_->_tmp95_ = g_file_is_native (_data_->_tmp94_);
		rygel_media_item_set_place_holder (_data_->_tmp93_, !_data_->_tmp95_);
		_g_object_unref0 (_data_->file);
	}
	_data_->_tmp96_ = _data_->self->priv->item;
	_data_->_tmp97_ = _data_->self->priv->item;
	_data_->_tmp98_ = ((RygelMediaObject*) _data_->_tmp97_)->uris;
	_data_->_tmp99_ = NULL;
	_data_->_tmp99_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp98_, 0);
	_g_free0 (((RygelMediaObject*) _data_->_tmp96_)->id);
	((RygelMediaObject*) _data_->_tmp96_)->id = (gchar*) _data_->_tmp99_;
	rygel_item_creator_parse_and_verify_didl_date (_data_->self, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		__g_list_free__g_object_unref0_0 (_data_->resources);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__g_list_free__g_object_unref0_0 (_data_->resources);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _vala_SoupDate_free (SoupDate* self) {
	g_boxed_free (soup_date_get_type (), self);
}


static void rygel_item_creator_parse_and_verify_didl_date (RygelItemCreator* self, GError** error) {
	GUPnPDIDLLiteItem* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GUPnPDIDLLiteItem* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	SoupDate* _tmp6_;
	SoupDate* parsed_date;
	SoupDate* _tmp7_;
	gint year;
	gint month;
	gint day;
	GUPnPDIDLLiteItem* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gint _tmp14_ = 0;
	GDate date = {0};
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gboolean _tmp22_ = FALSE;
	RygelMediaItem* _tmp27_;
	GUPnPDIDLLiteItem* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->didl_item;
	_tmp1_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = self->priv->didl_item;
	_tmp4_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = soup_date_new_from_string (_tmp5_);
	parsed_date = _tmp6_;
	_tmp7_ = parsed_date;
	if (_tmp7_ != NULL) {
		RygelMediaItem* _tmp8_;
		SoupDate* _tmp9_;
		gchar* _tmp10_ = NULL;
		_tmp8_ = self->priv->item;
		_tmp9_ = parsed_date;
		_tmp10_ = soup_date_to_string (_tmp9_, SOUP_DATE_ISO8601);
		_g_free0 (_tmp8_->date);
		_tmp8_->date = _tmp10_;
		__vala_SoupDate_free0 (parsed_date);
		return;
	}
	year = 0;
	month = 0;
	day = 0;
	_tmp11_ = self->priv->didl_item;
	_tmp12_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = sscanf (_tmp13_, "%4d-%02d-%02d", &year, &month, &day);
	if (_tmp14_ != 3) {
		GUPnPDIDLLiteItem* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GError* _tmp18_;
		_tmp15_ = self->priv->didl_item;
		_tmp16_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Invalid date format: %s", _tmp17_);
		_inner_error_ = _tmp18_;
		g_propagate_error (error, _inner_error_);
		__vala_SoupDate_free0 (parsed_date);
		return;
	}
	memset (&date, 0, sizeof (GDate));
	_tmp19_ = day;
	_tmp20_ = month;
	_tmp21_ = year;
	g_date_set_dmy (&date, (GDateDay) _tmp19_, (gint) ((GDateMonth) _tmp20_), (GDateYear) _tmp21_);
	_tmp22_ = g_date_valid (&date);
	if (!_tmp22_) {
		GUPnPDIDLLiteItem* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		GError* _tmp26_;
		_tmp23_ = self->priv->didl_item;
		_tmp24_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Invalid date: %s", _tmp25_);
		_inner_error_ = _tmp26_;
		g_propagate_error (error, _inner_error_);
		__vala_SoupDate_free0 (parsed_date);
		return;
	}
	_tmp27_ = self->priv->item;
	_tmp28_ = self->priv->didl_item;
	_tmp29_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat (_tmp30_, "T00:00:00", NULL);
	_g_free0 (_tmp27_->date);
	_tmp27_->date = _tmp31_;
	__vala_SoupDate_free0 (parsed_date);
}


static RygelMediaItem* rygel_item_creator_create_item (RygelItemCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error) {
	RygelMediaItem* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	_tmp0_ = upnp_class;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == g_quark_from_string (RYGEL_IMAGE_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp4_;
				RygelWritableContainer* _tmp5_;
				const gchar* _tmp6_;
				RygelImageItem* _tmp7_;
				_tmp4_ = id;
				_tmp5_ = parent;
				_tmp6_ = title;
				_tmp7_ = rygel_image_item_new (_tmp4_, (RygelMediaContainer*) _tmp5_, _tmp6_, RYGEL_IMAGE_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp7_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_PHOTO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp8_;
				RygelWritableContainer* _tmp9_;
				const gchar* _tmp10_;
				RygelPhotoItem* _tmp11_;
				_tmp8_ = id;
				_tmp9_ = parent;
				_tmp10_ = title;
				_tmp11_ = rygel_photo_item_new (_tmp8_, (RygelMediaContainer*) _tmp9_, _tmp10_, RYGEL_PHOTO_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp11_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_VIDEO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp12_;
				RygelWritableContainer* _tmp13_;
				const gchar* _tmp14_;
				RygelVideoItem* _tmp15_;
				_tmp12_ = id;
				_tmp13_ = parent;
				_tmp14_ = title;
				_tmp15_ = rygel_video_item_new (_tmp12_, (RygelMediaContainer*) _tmp13_, _tmp14_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp15_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_AUDIO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp16_;
				RygelWritableContainer* _tmp17_;
				const gchar* _tmp18_;
				RygelAudioItem* _tmp19_;
				_tmp16_ = id;
				_tmp17_ = parent;
				_tmp18_ = title;
				_tmp19_ = rygel_audio_item_new (_tmp16_, (RygelMediaContainer*) _tmp17_, _tmp18_, RYGEL_AUDIO_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp19_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_MUSIC_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp20_;
				RygelWritableContainer* _tmp21_;
				const gchar* _tmp22_;
				RygelMusicItem* _tmp23_;
				_tmp20_ = id;
				_tmp21_ = parent;
				_tmp22_ = title;
				_tmp23_ = rygel_music_item_new (_tmp20_, (RygelMediaContainer*) _tmp21_, _tmp22_, RYGEL_MUSIC_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp23_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp24_;
				GError* _tmp25_;
				_tmp24_ = upnp_class;
				_tmp25_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Creation of item of class '%s' " "not supported.", _tmp24_);
				_inner_error_ = _tmp25_;
				g_propagate_error (error, _inner_error_);
				return NULL;
			}
		}
	}
}


/**
     * Simple check for the validity of an URI.
     *
     * Check is done by parsing the URI with soup. Additionaly a cleaned-up
     * version of the URI is returned in sanitized_uri.
     *
     * @param uri the input URI
     * @param sanitized_uri containes a sanitized version of the URI on return
     * @returns true if the URI is valid, false otherwise.
     */
static void _vala_SoupURI_free (SoupURI* self) {
	g_boxed_free (soup_uri_get_type (), self);
}


static gboolean rygel_item_creator_is_valid_uri (RygelItemCreator* self, const gchar* uri, gchar** sanitized_uri) {
	gchar* _vala_sanitized_uri = NULL;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	const gchar* _tmp4_;
	SoupURI* _tmp5_;
	SoupURI* soup_uri;
	gboolean _tmp6_ = FALSE;
	SoupURI* _tmp7_;
	gboolean _tmp10_;
	SoupURI* _tmp11_;
	gchar* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_g_free0 (_vala_sanitized_uri);
	_vala_sanitized_uri = NULL;
	_tmp1_ = uri;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = uri;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		result = FALSE;
		if (sanitized_uri) {
			*sanitized_uri = _vala_sanitized_uri;
		} else {
			_g_free0 (_vala_sanitized_uri);
		}
		return result;
	}
	_tmp4_ = uri;
	_tmp5_ = soup_uri_new (_tmp4_);
	soup_uri = _tmp5_;
	_tmp7_ = soup_uri;
	if (_tmp7_ == NULL) {
		_tmp6_ = TRUE;
	} else {
		SoupURI* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = soup_uri;
		_tmp9_ = _tmp8_->scheme;
		_tmp6_ = _tmp9_ == NULL;
	}
	_tmp10_ = _tmp6_;
	if (_tmp10_) {
		result = FALSE;
		__vala_SoupURI_free0 (soup_uri);
		if (sanitized_uri) {
			*sanitized_uri = _vala_sanitized_uri;
		} else {
			_g_free0 (_vala_sanitized_uri);
		}
		return result;
	}
	_tmp11_ = soup_uri;
	_tmp12_ = soup_uri_to_string (_tmp11_, FALSE);
	_g_free0 (_vala_sanitized_uri);
	_vala_sanitized_uri = _tmp12_;
	result = TRUE;
	__vala_SoupURI_free0 (soup_uri);
	if (sanitized_uri) {
		*sanitized_uri = _vala_sanitized_uri;
	} else {
		_g_free0 (_vala_sanitized_uri);
	}
	return result;
}


/**
     * Transform the title to be usable on legacy file-systems such as FAT32.
     *
     * The function trims down the title to 205 chars (leaving room for an UUID)
     * and replaces all special characters.
     *
     * @param title of the the media item
     * @return the cleaned and shortened title
     */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gchar* rygel_item_creator_mangle_title (RygelItemCreator* self, const gchar* title, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* mangled;
	GRegex* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = title;
	_tmp1_ = title;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = MIN (_tmp3_, 205);
	_tmp5_ = string_substring (_tmp0_, (glong) 0, (glong) _tmp4_);
	mangled = _tmp5_;
	_tmp6_ = self->priv->title_regex;
	_tmp7_ = mangled;
	_tmp8_ = g_regex_replace_literal (_tmp6_, _tmp7_, (gssize) (-1), 0, "_", G_REGEX_MATCH_NOTEMPTY, &_inner_error_);
	_tmp9_ = _tmp8_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (mangled);
		return NULL;
	}
	_g_free0 (mangled);
	mangled = _tmp9_;
	result = mangled;
	return result;
}


static void rygel_item_creator_create_uri_data_free (gpointer _data) {
	RygelItemCreatorCreateUriData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->container);
	_g_free0 (_data_->title);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemCreatorCreateUriData, _data_);
}


static void rygel_item_creator_create_uri (RygelItemCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorCreateUriData* _data_;
	RygelItemCreator* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_data_ = g_slice_new0 (RygelItemCreatorCreateUriData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_create_uri);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_create_uri_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = container;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->container = _tmp2_;
	_tmp3_ = title;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->title = _tmp4_;
	rygel_item_creator_create_uri_co (_data_);
}


static gchar* rygel_item_creator_create_uri_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	RygelItemCreatorCreateUriData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Create an URI from the item's title.
     *
     * Create an unique URI from the supplied title by cleaning it from
     * unwanted characters, shortening it and adding an UUID.
     *
     * @param container to create the item in
     * @param title of the item to base the name on
     * @returns an URI for the newly created item
     */
static void rygel_item_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorCreateUriData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_creator_create_uri_co (_data_);
}


static gboolean rygel_item_creator_create_uri_co (RygelItemCreatorCreateUriData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->container;
	_data_->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_state_ = 1;
	rygel_media_object_get_writable ((RygelMediaObject*) _data_->_tmp0_, _data_->_tmp2_, rygel_item_creator_create_uri_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = rygel_media_object_get_writable_finish ((RygelMediaObject*) _data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
	_data_->dir = _data_->_tmp3_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->dir;
	if (_data_->_tmp4_ == NULL) {
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _ ("Object creation in %s not allowed");
		_data_->_tmp6_ = _data_->container;
		_data_->_tmp7_ = ((RygelMediaObject*) _data_->_tmp6_)->id;
		_data_->_tmp8_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp5_, _data_->_tmp7_);
		_data_->_inner_error_ = _data_->_tmp8_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->dir);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = _data_->title;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = rygel_item_creator_mangle_title (_data_->self, _data_->_tmp9_, &_data_->_inner_error_);
	_data_->_tmp11_ = _data_->_tmp10_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->dir);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->dir;
	_data_->_tmp13_ = _data_->_tmp11_;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = g_file_get_child_for_display_name (_data_->_tmp12_, _data_->_tmp13_, &_data_->_inner_error_);
	_data_->_tmp15_ = _data_->_tmp14_;
	_g_free0 (_data_->_tmp13_);
	_data_->file = _data_->_tmp15_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->dir);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = g_new0 (guchar, 50);
	_data_->udn = _data_->_tmp16_;
	_data_->udn_length1 = 50;
	_data_->_udn_size_ = _data_->udn_length1;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = g_new0 (guchar, 16);
	_data_->id = _data_->_tmp17_;
	_data_->id_length1 = 16;
	_data_->_id_size_ = _data_->id_length1;
	_data_->_tmp18_ = _data_->id;
	_data_->_tmp18__length1 = _data_->id_length1;
	uuid_generate (_data_->_tmp18_);
	_data_->_tmp19_ = _data_->id;
	_data_->_tmp19__length1 = _data_->id_length1;
	_data_->_tmp20_ = _data_->udn;
	_data_->_tmp20__length1 = _data_->udn_length1;
	uuid_unparse (_data_->_tmp19_, _data_->_tmp20_);
	_data_->_tmp21_ = _data_->file;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = g_file_get_uri (_data_->_tmp21_);
	_data_->_tmp23_ = _data_->_tmp22_;
	_data_->_tmp24_ = _data_->udn;
	_data_->_tmp24__length1 = _data_->udn_length1;
	_data_->_tmp25_ = g_strconcat (_data_->_tmp23_, (const gchar*) _data_->_tmp24_, NULL);
	_data_->_tmp26_ = _data_->_tmp25_;
	_g_free0 (_data_->_tmp23_);
	_data_->result = _data_->_tmp26_;
	_data_->id = (g_free (_data_->id), NULL);
	_data_->udn = (g_free (_data_->udn), NULL);
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->dir);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_data_->id = (g_free (_data_->id), NULL);
	_data_->udn = (g_free (_data_->udn), NULL);
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->dir);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_item_creator_wait_for_item_data_free (gpointer _data) {
	RygelItemCreatorWaitForItemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->container);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemCreatorWaitForItemData, _data_);
}


static void rygel_item_creator_wait_for_item (RygelItemCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorWaitForItemData* _data_;
	RygelItemCreator* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
	_data_ = g_slice_new0 (RygelItemCreatorWaitForItemData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_wait_for_item);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_wait_for_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = container;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->container = _tmp2_;
	rygel_item_creator_wait_for_item_co (_data_);
}


static void rygel_item_creator_wait_for_item_finish (RygelItemCreator* self, GAsyncResult* _res_) {
	RygelItemCreatorWaitForItemData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Wait for the new item
     *
     * When creating an item in the back-end via WritableContainer.add_item
     * there might be a delay between the creation and the back-end having the
     * newly created item available. This function waits for the item to become
     * available by hooking into the container_updated signal. The maximum time
     * to wait is 5 seconds.
     *
     * @param container to watch
     */
static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		RygelItemCreator * self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->container);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}


static void rygel_item_creator_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorWaitForItemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_creator_wait_for_item_co (_data_);
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		RygelItemCreator * self;
		self = _data9_->_data8_->self;
		block8_data_unref (_data9_->_data8_);
		_data9_->_data8_ = NULL;
		g_slice_free (Block9Data, _data9_);
	}
}


static void ____lambda12_ (Block9Data* _data9_, RygelMediaContainer* container) {
	Block8Data* _data8_;
	RygelItemCreator * self;
	_data8_ = _data9_->_data8_;
	self = _data8_->self;
	g_return_if_fail (container != NULL);
	rygel_item_creator_wait_for_item_co (_data8_->_async_data_);
}


static void _____lambda12__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
	____lambda12_ (self, container);
}


static gboolean ____lambda13_ (Block9Data* _data9_) {
	Block8Data* _data8_;
	RygelItemCreator * self;
	gboolean result = FALSE;
	RygelWritableContainer* _tmp0_;
	const gchar* _tmp1_;
	_data8_ = _data9_->_data8_;
	self = _data8_->self;
	_tmp0_ = _data8_->container;
	_tmp1_ = ((RygelMediaObject*) _tmp0_)->id;
	g_debug ("rygel-item-creator.vala:569: Timeout on waiting for 'updated' signal o" \
"n '%s'.", _tmp1_);
	_data9_->timeout = (guint) 0;
	rygel_item_creator_wait_for_item_co (_data8_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean _____lambda13__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda13_ (self);
	return result;
}


static gboolean rygel_item_creator_wait_for_item_co (RygelItemCreatorWaitForItemData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data8_ = g_slice_new0 (Block8Data);
	_data_->_data8_->_ref_count_ = 1;
	_data_->_data8_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = _data_->container;
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->_data8_->container = _data_->_tmp1_;
	_data_->_data8_->_async_data_ = _data_;
	_data_->_tmp2_ = _data_->_data8_->container;
	_data_->_tmp3_ = ((RygelMediaObject*) _data_->_tmp2_)->id;
	g_debug ("rygel-item-creator.vala:545: Waiting for new item to appear under cont" \
"ainer '%s'..", _data_->_tmp3_);
	_data_->item = NULL;
	while (TRUE) {
		_data_->_tmp4_ = _data_->item;
		if (!(_data_->_tmp4_ == NULL)) {
			break;
		}
		{
			_data_->_tmp5_ = _data_->_data8_->container;
			_data_->_tmp6_ = _data_->self->priv->item;
			_data_->_tmp7_ = ((RygelMediaObject*) _data_->_tmp6_)->id;
			_data_->_tmp8_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_state_ = 1;
			rygel_media_container_find_object ((RygelMediaContainer*) _data_->_tmp5_, _data_->_tmp7_, _data_->_tmp9_, rygel_item_creator_wait_for_item_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = rygel_media_container_find_object_finish ((RygelMediaContainer*) _data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp11_ = _data_->_tmp10_;
			if (_data_->_inner_error_ != NULL) {
				goto __catch85_g_error;
			}
			_g_object_unref0 (_data_->item);
			_data_->item = RYGEL_IS_MEDIA_ITEM (_data_->_tmp11_) ? ((RygelMediaItem*) _data_->_tmp11_) : NULL;
		}
		goto __finally85;
		__catch85_g_error:
		{
			_data_->_error_ = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp12_ = _data_->_data8_->container;
			_data_->_tmp13_ = ((RygelMediaObject*) _data_->_tmp12_)->id;
			_data_->_tmp14_ = _data_->self->priv->item;
			_data_->_tmp15_ = ((RygelMediaObject*) _data_->_tmp14_)->id;
			g_warning ("Error from container '%s' on trying to find newly " "added child item '%s' in it", _data_->_tmp13_, _data_->_tmp15_);
			_g_error_free0 (_data_->_error_);
		}
		__finally85:
		if (_data_->_inner_error_ != NULL) {
			_g_object_unref0 (_data_->item);
			block8_data_unref (_data_->_data8_);
			_data_->_data8_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp16_ = _data_->item;
		if (_data_->_tmp16_ == NULL) {
			_data_->_data9_ = g_slice_new0 (Block9Data);
			_data_->_data9_->_ref_count_ = 1;
			_data_->_data9_->_data8_ = block8_data_ref (_data_->_data8_);
			_data_->_tmp17_ = _data_->_data8_->container;
			_data_->_tmp18_ = 0UL;
			_data_->_tmp18_ = g_signal_connect_data ((RygelMediaContainer*) _data_->_tmp17_, "container-updated", (GCallback) _____lambda12__rygel_media_container_container_updated, block9_data_ref (_data_->_data9_), (GClosureNotify) block9_data_unref, 0);
			_data_->id = _data_->_tmp18_;
			_data_->_data9_->timeout = (guint) 0;
			_data_->_tmp19_ = 0U;
			_data_->_tmp19_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _____lambda13__gsource_func, block9_data_ref (_data_->_data9_), block9_data_unref);
			_data_->_data9_->timeout = _data_->_tmp19_;
			_data_->_state_ = 2;
			return FALSE;
			_state_2:
			;
			_data_->_tmp20_ = _data_->_data8_->container;
			_data_->_tmp21_ = _data_->id;
			g_signal_handler_disconnect ((GObject*) _data_->_tmp20_, _data_->_tmp21_);
			_data_->_tmp22_ = _data_->_data9_->timeout;
			if (_data_->_tmp22_ != ((guint) 0)) {
				_data_->_tmp23_ = _data_->_data9_->timeout;
				g_source_remove (_data_->_tmp23_);
			} else {
				block9_data_unref (_data_->_data9_);
				_data_->_data9_ = NULL;
				break;
			}
			block9_data_unref (_data_->_data9_);
			_data_->_data9_ = NULL;
		}
	}
	_data_->_tmp24_ = _data_->_data8_->container;
	_data_->_tmp25_ = ((RygelMediaObject*) _data_->_tmp24_)->id;
	g_debug ("rygel-item-creator.vala:588: Finished waiting for new item to appear u" \
"nder container '%s'", _data_->_tmp25_);
	_g_object_unref0 (_data_->item);
	block8_data_unref (_data_->_data8_);
	_data_->_data8_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Check if the profile is supported.
     *
     * The check is performed against GUPnP-DLNA's database explicitly excluding
     * the transcoders.
     *
     * @param profile to check
     * @returns true if the profile is supported, false otherwise.
     */
static gboolean rygel_item_creator_is_profile_valid (RygelItemCreator* self, const gchar* profile) {
	gboolean result = FALSE;
	GUPnPDLNADiscoverer* _tmp0_;
	GUPnPDLNADiscoverer* discoverer;
	gboolean valid;
	GUPnPDLNADiscoverer* _tmp1_;
	GList* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (profile != NULL, FALSE);
	_tmp0_ = gupnp_dlna_discoverer_new ((GstClockTime) GST_SECOND, TRUE, FALSE);
	discoverer = _tmp0_;
	valid = FALSE;
	_tmp1_ = discoverer;
	_tmp2_ = gupnp_dlna_discoverer_list_profiles (_tmp1_);
	{
		GList* known_profile_collection = NULL;
		GList* known_profile_it = NULL;
		known_profile_collection = _tmp2_;
		for (known_profile_it = known_profile_collection; known_profile_it != NULL; known_profile_it = known_profile_it->next) {
			GUPnPDLNAProfile* known_profile = NULL;
			known_profile = (GUPnPDLNAProfile*) known_profile_it->data;
			{
				GUPnPDLNAProfile* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				_tmp3_ = known_profile;
				_tmp4_ = gupnp_dlna_profile_get_name (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = profile;
				if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
					valid = TRUE;
					break;
				}
			}
		}
	}
	result = valid;
	_g_object_unref0 (discoverer);
	return result;
}


static GCancellable* rygel_item_creator_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelItemCreator* self;
	GCancellable* _tmp0_;
	self = (RygelItemCreator*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}


static void rygel_item_creator_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelItemCreator* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	self = (RygelItemCreator*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_item_creator_class_init (RygelItemCreatorClass * klass) {
	GPatternSpec* _tmp0_;
	rygel_item_creator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelItemCreatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_item_creator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_item_creator_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_item_creator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_ITEM_CREATOR_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", G_TYPE_CANCELLABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_pattern_spec_new ("*<!--*-->*");
	rygel_item_creator_comment_pattern = _tmp0_;
}


static void rygel_item_creator_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_item_creator_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_item_creator_real_run;
	iface->run_finish = rygel_item_creator_real_run_finish;
	iface->get_cancellable = rygel_item_creator_real_get_cancellable;
	iface->set_cancellable = rygel_item_creator_real_set_cancellable;
}


static void rygel_item_creator_instance_init (RygelItemCreator * self) {
	self->priv = RYGEL_ITEM_CREATOR_GET_PRIVATE (self);
}


static void rygel_item_creator_finalize (GObject* obj) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (obj);
	_g_free0 (self->priv->container_id);
	_g_free0 (self->priv->elements);
	_g_object_unref0 (self->priv->didl_item);
	_g_object_unref0 (self->priv->item);
	_g_object_unref0 (self->priv->content_dir);
	_g_object_unref0 (self->priv->didl_writer);
	_g_object_unref0 (self->priv->didl_parser);
	_g_regex_unref0 (self->priv->title_regex);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_item_creator_parent_class)->finalize (obj);
}


/**
 * CreateObject action implementation.
 */
GType rygel_item_creator_get_type (void) {
	static volatile gsize rygel_item_creator_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_item_creator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelItemCreatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_creator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemCreator), 0, (GInstanceInitFunc) rygel_item_creator_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_item_creator_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_item_creator_type_id;
		rygel_item_creator_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemCreator", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_item_creator_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_item_creator_type_id__volatile, rygel_item_creator_type_id);
	}
	return rygel_item_creator_type_id__volatile;
}


static void _vala_rygel_item_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (object);
	switch (property_id) {
		case RYGEL_ITEM_CREATOR_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_item_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (object);
	switch (property_id) {
		case RYGEL_ITEM_CREATOR_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



