/* rygel-gst-utils.c generated by valac 0.15.2, the Vala compiler
 * generated from rygel-gst-utils.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gst/pbutils/pbutils.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_GST_UTILS (rygel_gst_utils_get_type ())
#define RYGEL_GST_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_UTILS, RygelGstUtils))
#define RYGEL_GST_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_UTILS, RygelGstUtilsClass))
#define RYGEL_IS_GST_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_UTILS))
#define RYGEL_IS_GST_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_UTILS))
#define RYGEL_GST_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_UTILS, RygelGstUtilsClass))

typedef struct _RygelGstUtils RygelGstUtils;
typedef struct _RygelGstUtilsClass RygelGstUtilsClass;
typedef struct _RygelGstUtilsPrivate RygelGstUtilsPrivate;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_encoding_profile_unref0(var) ((var == NULL) ? NULL : (var = (gst_encoding_profile_unref (var), NULL)))
#define __g_list_free__gst_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gst_object_unref0_ (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
typedef struct _RygelParamSpecGstUtils RygelParamSpecGstUtils;

typedef enum  {
	RYGEL_GST_ERROR_MISSING_PLUGIN,
	RYGEL_GST_ERROR_LINK
} RygelGstError;
#define RYGEL_GST_ERROR rygel_gst_error_quark ()
struct _RygelGstUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelGstUtilsPrivate * priv;
};

struct _RygelGstUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (RygelGstUtils *self);
};

struct _RygelParamSpecGstUtils {
	GParamSpec parent_instance;
};


static gpointer rygel_gst_utils_parent_class = NULL;

GQuark rygel_gst_error_quark (void);
gpointer rygel_gst_utils_ref (gpointer instance);
void rygel_gst_utils_unref (gpointer instance);
GParamSpec* rygel_param_spec_gst_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_gst_utils (GValue* value, gpointer v_object);
void rygel_value_take_gst_utils (GValue* value, gpointer v_object);
gpointer rygel_value_get_gst_utils (const GValue* value);
GType rygel_gst_utils_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_GST_UTILS_DUMMY_PROPERTY
};
GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error);
GstClockTime rygel_gst_utils_time_from_string (const gchar* str);
gchar* rygel_gst_utils_time_to_string (GstClockTime time);
GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri);
static inline void _dynamic_set_blocksize2 (GstElement* obj, glong value);
static inline void _dynamic_set_tcp_timeout3 (GstElement* obj, gint64 value);
void rygel_gst_utils_dump_encoding_profile (GstEncodingProfile* profile, gint indent);
GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps);
static gboolean rygel_gst_utils_need_rtp_depayloader (GstCaps* caps);
static void _gst_object_unref0_ (gpointer var);
static void _g_list_free__gst_object_unref0_ (GList* self);
RygelGstUtils* rygel_gst_utils_construct (GType object_type);
static void rygel_gst_utils_finalize (RygelGstUtils* obj);


GQuark rygel_gst_error_quark (void) {
	return g_quark_from_static_string ("rygel_gst_error-quark");
}


GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error) {
	GstElement* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GstElement* _tmp2_ = NULL;
	GstElement* element;
	GstElement* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (factoryname != NULL, NULL);
	_tmp0_ = factoryname;
	_tmp1_ = name;
	_tmp2_ = gst_element_factory_make (_tmp0_, _tmp1_);
	gst_object_ref_sink (_tmp2_);
	element = _tmp2_;
	_tmp3_ = element;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_;
		GError* _tmp6_;
		_tmp4_ = _ ("Required element %s missing");
		_tmp5_ = factoryname;
		_tmp6_ = g_error_new (RYGEL_GST_ERROR, RYGEL_GST_ERROR_MISSING_PLUGIN, _tmp4_, _tmp5_);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		_gst_object_unref0 (element);
		return NULL;
	}
	result = element;
	return result;
}


GstClockTime rygel_gst_utils_time_from_string (const gchar* str) {
	GstClockTime result = 0ULL;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	sscanf (_tmp0_, "%llu:%2llu:%2llu%*s", &hours, &minutes, &seconds);
	result = (GstClockTime) ((((hours * 3600) + (minutes * 60)) + seconds) * GST_SECOND);
	return result;
}


gchar* rygel_gst_utils_time_to_string (GstClockTime time) {
	gchar* result = NULL;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
	GstClockTime _tmp0_;
	GstClockTime _tmp1_;
	guint64 _tmp2_;
	guint64 _tmp3_;
	guint64 _tmp4_;
	gchar* _tmp5_ = NULL;
	_tmp0_ = time;
	hours = (guint64) ((_tmp0_ / GST_SECOND) / 3600);
	_tmp1_ = time;
	seconds = (guint64) ((_tmp1_ / GST_SECOND) % 3600);
	_tmp2_ = seconds;
	minutes = _tmp2_ / 60;
	_tmp3_ = seconds;
	seconds = _tmp3_ % 60;
	_tmp4_ = seconds;
	_tmp5_ = g_strdup_printf ("%llu:%.2llu:%.2llu", hours, minutes, _tmp4_);
	result = _tmp5_;
	return result;
}


static inline void _dynamic_set_blocksize2 (GstElement* obj, glong value) {
	g_object_set (obj, "blocksize", value, NULL);
}


static inline void _dynamic_set_tcp_timeout3 (GstElement* obj, gint64 value) {
	g_object_set (obj, "tcp-timeout", value, NULL);
}


GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri) {
	GstElement* result = NULL;
	const gchar* _tmp0_;
	GstElement* _tmp1_ = NULL;
	GstElement* src;
	GstElement* _tmp2_;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	_tmp1_ = gst_element_make_from_uri (GST_URI_SRC, _tmp0_, NULL);
	gst_object_ref_sink (_tmp1_);
	src = _tmp1_;
	_tmp2_ = src;
	if (_tmp2_ != NULL) {
		GstElement* _tmp3_;
		gboolean _tmp4_ = FALSE;
		GstElement* _tmp6_;
		GObjectClass* _tmp7_ = NULL;
		GParamSpec* _tmp8_ = NULL;
		GstElement* _tmp10_;
		GObjectClass* _tmp11_ = NULL;
		GParamSpec* _tmp12_ = NULL;
		_tmp3_ = src;
		_tmp4_ = GST_OBJECT_IS_FLOATING ((GstObject*) _tmp3_);
		if (_tmp4_) {
			GstElement* _tmp5_;
			_tmp5_ = src;
			gst_object_ref_sink ((GstObject*) _tmp5_);
		}
		_tmp6_ = src;
		_tmp7_ = G_OBJECT_GET_CLASS ((GObject*) _tmp6_);
		_tmp8_ = g_object_class_find_property (_tmp7_, "blocksize");
		if (_tmp8_ != NULL) {
			GstElement* _tmp9_;
			_tmp9_ = src;
			_dynamic_set_blocksize2 (_tmp9_, (glong) 65536);
		}
		_tmp10_ = src;
		_tmp11_ = G_OBJECT_GET_CLASS ((GObject*) _tmp10_);
		_tmp12_ = g_object_class_find_property (_tmp11_, "tcp-timeout");
		if (_tmp12_ != NULL) {
			GstElement* _tmp13_;
			_tmp13_ = src;
			_dynamic_set_tcp_timeout3 (_tmp13_, (gint64) 60000000);
		}
	}
	result = src;
	return result;
}


static gpointer _gst_encoding_profile_ref0 (gpointer self) {
	return self ? gst_encoding_profile_ref (self) : NULL;
}


void rygel_gst_utils_dump_encoding_profile (GstEncodingProfile* profile, gint indent) {
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* indent_s;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GstEncodingProfile* _tmp5_;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GstEncodingProfile* _tmp10_;
	GstCaps* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	GstEncodingProfile* _tmp14_;
	GstCaps* _tmp15_ = NULL;
	GstEncodingProfile* _tmp23_;
	g_return_if_fail (profile != NULL);
	_tmp0_ = indent;
	_tmp1_ = g_strnfill ((gsize) _tmp0_, ' ');
	indent_s = _tmp1_;
	_tmp2_ = indent_s;
	_tmp3_ = g_strconcat (_tmp2_, "%s:", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = profile;
	_tmp6_ = gst_encoding_profile_get_name (_tmp5_);
	g_debug (_tmp4_, _tmp6_);
	_g_free0 (_tmp4_);
	_tmp7_ = indent_s;
	_tmp8_ = g_strconcat (_tmp7_, "  Format: %s", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = profile;
	_tmp11_ = gst_encoding_profile_get_format (_tmp10_);
	_tmp12_ = gst_caps_to_string (_tmp11_);
	_tmp13_ = _tmp12_;
	g_debug (_tmp9_, _tmp13_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp9_);
	_tmp14_ = profile;
	_tmp15_ = gst_encoding_profile_get_restriction (_tmp14_);
	if (_tmp15_ != NULL) {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GstEncodingProfile* _tmp19_;
		GstCaps* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		_tmp16_ = indent_s;
		_tmp17_ = g_strconcat (_tmp16_, "  Restriction: %s", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = profile;
		_tmp20_ = gst_encoding_profile_get_restriction (_tmp19_);
		_tmp21_ = gst_caps_to_string (_tmp20_);
		_tmp22_ = _tmp21_;
		g_debug (_tmp18_, _tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp18_);
	}
	_tmp23_ = profile;
	if (GST_IS_ENCODING_CONTAINER_PROFILE (_tmp23_)) {
		GstEncodingProfile* _tmp24_;
		GstEncodingContainerProfile* _tmp25_;
		GstEncodingContainerProfile* container;
		GstEncodingContainerProfile* _tmp26_;
		GList* _tmp27_ = NULL;
		_tmp24_ = profile;
		_tmp25_ = _gst_encoding_profile_ref0 (GST_IS_ENCODING_CONTAINER_PROFILE (_tmp24_) ? ((GstEncodingContainerProfile*) _tmp24_) : NULL);
		container = _tmp25_;
		_tmp26_ = container;
		_tmp27_ = gst_encoding_container_profile_get_profiles (_tmp26_);
		{
			GList* subprofile_collection = NULL;
			GList* subprofile_it = NULL;
			subprofile_collection = _tmp27_;
			for (subprofile_it = subprofile_collection; subprofile_it != NULL; subprofile_it = subprofile_it->next) {
				GstEncodingProfile* _tmp28_;
				GstEncodingProfile* subprofile = NULL;
				_tmp28_ = _gst_encoding_profile_ref0 ((GstEncodingProfile*) subprofile_it->data);
				subprofile = _tmp28_;
				{
					GstEncodingProfile* _tmp29_;
					gint _tmp30_;
					_tmp29_ = subprofile;
					_tmp30_ = indent;
					rygel_gst_utils_dump_encoding_profile (_tmp29_, _tmp30_ + 4);
					_gst_encoding_profile_unref0 (subprofile);
				}
			}
		}
		_gst_encoding_profile_unref0 (container);
	}
	_g_free0 (indent_s);
}


static void _gst_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gst_object_unref (var), NULL));
}


static void _g_list_free__gst_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gst_object_unref0_, NULL);
	g_list_free (self);
}


GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps) {
	GstElement* result = NULL;
	GstCaps* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GList* _tmp2_ = NULL;
	GList* features;
	GList* _tmp3_;
	GstCaps* _tmp4_;
	GList* _tmp5_ = NULL;
	GList* _tmp6_;
	gconstpointer _tmp7_;
	const gchar* _tmp8_ = NULL;
	g_return_val_if_fail (caps != NULL, NULL);
	_tmp0_ = caps;
	_tmp1_ = rygel_gst_utils_need_rtp_depayloader (_tmp0_);
	if (!_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = gst_element_factory_list_get_elements ((GstElementFactoryListType) GST_ELEMENT_FACTORY_TYPE_DEPAYLOADER, GST_RANK_NONE);
	features = _tmp2_;
	_tmp3_ = features;
	_tmp4_ = caps;
	_tmp5_ = gst_element_factory_list_filter (_tmp3_, _tmp4_, GST_PAD_SINK, FALSE);
	__g_list_free__gst_object_unref0_0 (features);
	features = _tmp5_;
	_tmp6_ = features;
	_tmp7_ = _tmp6_->data;
	_tmp8_ = gst_plugin_feature_get_name ((GstPluginFeature*) ((GstElementFactory*) _tmp7_));
	if (g_strcmp0 (_tmp8_, "rtpdepay") == 0) {
		GList* _tmp9_;
		GList* _tmp10_;
		_tmp9_ = features;
		_tmp10_ = _tmp9_->next;
		if (_tmp10_ != NULL) {
			GList* _tmp11_;
			GList* _tmp12_;
			gconstpointer _tmp13_;
			GstElement* _tmp14_ = NULL;
			_tmp11_ = features;
			_tmp12_ = _tmp11_->next;
			_tmp13_ = _tmp12_->data;
			_tmp14_ = gst_element_factory_create ((GstElementFactory*) _tmp13_, NULL);
			gst_object_ref_sink (_tmp14_);
			result = _tmp14_;
			__g_list_free__gst_object_unref0_0 (features);
			return result;
		}
		result = NULL;
		__g_list_free__gst_object_unref0_0 (features);
		return result;
	} else {
		GList* _tmp15_;
		gconstpointer _tmp16_;
		GstElement* _tmp17_ = NULL;
		_tmp15_ = features;
		_tmp16_ = _tmp15_->data;
		_tmp17_ = gst_element_factory_create ((GstElementFactory*) _tmp16_, NULL);
		gst_object_ref_sink (_tmp17_);
		result = _tmp17_;
		__g_list_free__gst_object_unref0_0 (features);
		return result;
	}
	__g_list_free__gst_object_unref0_0 (features);
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


static gboolean rygel_gst_utils_need_rtp_depayloader (GstCaps* caps) {
	gboolean result = FALSE;
	GstCaps* _tmp0_;
	const GstStructure* _tmp1_ = NULL;
	GstStructure* _tmp2_;
	GstStructure* structure;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (caps != NULL, FALSE);
	_tmp0_ = caps;
	_tmp1_ = gst_caps_get_structure (_tmp0_, (guint) 0);
	_tmp2_ = _gst_structure_copy0 (_tmp1_);
	structure = _tmp2_;
	_tmp3_ = gst_structure_get_name (structure);
	result = g_strcmp0 (_tmp3_, "application/x-rtp") == 0;
	_gst_structure_free0 (structure);
	return result;
}


RygelGstUtils* rygel_gst_utils_construct (GType object_type) {
	RygelGstUtils* self = NULL;
	self = (RygelGstUtils*) g_type_create_instance (object_type);
	return self;
}


static void rygel_value_gst_utils_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_gst_utils_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_gst_utils_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_gst_utils_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_gst_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_gst_utils_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_gst_utils_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelGstUtils* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_gst_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_gst_utils_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelGstUtils** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_gst_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_gst_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecGstUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_GST_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_gst_utils (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_GST_UTILS), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_gst_utils (GValue* value, gpointer v_object) {
	RygelGstUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_GST_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_GST_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_gst_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_gst_utils_unref (old);
	}
}


void rygel_value_take_gst_utils (GValue* value, gpointer v_object) {
	RygelGstUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_GST_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_GST_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_gst_utils_unref (old);
	}
}


static void rygel_gst_utils_class_init (RygelGstUtilsClass * klass) {
	rygel_gst_utils_parent_class = g_type_class_peek_parent (klass);
	RYGEL_GST_UTILS_CLASS (klass)->finalize = rygel_gst_utils_finalize;
}


static void rygel_gst_utils_instance_init (RygelGstUtils * self) {
	self->ref_count = 1;
}


static void rygel_gst_utils_finalize (RygelGstUtils* obj) {
	RygelGstUtils * self;
	self = RYGEL_GST_UTILS (obj);
}


GType rygel_gst_utils_get_type (void) {
	static volatile gsize rygel_gst_utils_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_utils_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_gst_utils_init, rygel_value_gst_utils_free_value, rygel_value_gst_utils_copy_value, rygel_value_gst_utils_peek_pointer, "p", rygel_value_gst_utils_collect_value, "p", rygel_value_gst_utils_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstUtils), 0, (GInstanceInitFunc) rygel_gst_utils_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_gst_utils_type_id;
		rygel_gst_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelGstUtils", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_gst_utils_type_id__volatile, rygel_gst_utils_type_id);
	}
	return rygel_gst_utils_type_id__volatile;
}


gpointer rygel_gst_utils_ref (gpointer instance) {
	RygelGstUtils* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_gst_utils_unref (gpointer instance) {
	RygelGstUtils* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_GST_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



