/* game.c generated by valac 0.15.0, the Vala compiler
 * generated from game.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PLAYER (player_get_type ())

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;
typedef struct _ParamSpecGame ParamSpecGame;

typedef enum  {
	PLAYER_NONE,
	PLAYER_LIGHT,
	PLAYER_DARK
} Player;

struct _Game {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GamePrivate * priv;
	Player* tiles;
	gint tiles_length1;
	gint tiles_length2;
	Player current_color;
};

struct _GameClass {
	GTypeClass parent_class;
	void (*finalize) (Game *self);
};

struct _GamePrivate {
	gint undo_history[1344];
	gint undo_index;
};

struct _ParamSpecGame {
	GParamSpec parent_instance;
};


static gpointer game_parent_class = NULL;

GType player_get_type (void) G_GNUC_CONST;
gpointer game_ref (gpointer instance);
void game_unref (gpointer instance);
GParamSpec* param_spec_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_game (GValue* value, gpointer v_object);
void value_take_game (GValue* value, gpointer v_object);
gpointer value_get_game (const GValue* value);
GType game_get_type (void) G_GNUC_CONST;
#define GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME, GamePrivate))
enum  {
	GAME_DUMMY_PROPERTY
};
Game* game_new (void);
Game* game_construct (GType object_type);
static void game_set_tile (Game* self, gint x, gint y, Player color, gboolean update_history);
void game_start (Game* self);
gint game_get_n_tiles (Game* self);
Game* game_new_copy (Game* game);
Game* game_construct_copy (GType object_type, Game* game);
Player game_get_owner (Game* self, gint x, gint y);
static gboolean game_is_valid_location (Game* self, gint x, gint y);
gboolean game_can_place (Game* self, gint x, gint y);
static gint game_place (Game* self, gint x, gint y, Player color, gboolean apply);
gint game_place_tile (Game* self, gint x, gint y);
gboolean game_get_is_complete (Game* self);
void game_pass (Game* self);
static gint game_flip_tiles (Game* self, gint x, gint y, gint x_step, gint y_step, Player color, gboolean apply);
static gint game_count_tiles (Game* self, Player color);
void game_undo (Game* self, gint count);
gint game_get_n_light_tiles (Game* self);
gint game_get_n_dark_tiles (Game* self);
gboolean game_get_can_move (Game* self);
gboolean game_get_can_undo (Game* self);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void game_finalize (Game* obj);


GType player_get_type (void) {
	static volatile gsize player_type_id__volatile = 0;
	if (g_once_init_enter (&player_type_id__volatile)) {
		static const GEnumValue values[] = {{PLAYER_NONE, "PLAYER_NONE", "none"}, {PLAYER_LIGHT, "PLAYER_LIGHT", "light"}, {PLAYER_DARK, "PLAYER_DARK", "dark"}, {0, NULL, NULL}};
		GType player_type_id;
		player_type_id = g_enum_register_static ("Player", values);
		g_once_init_leave (&player_type_id__volatile, player_type_id);
	}
	return player_type_id__volatile;
}


Game* game_construct (GType object_type) {
	Game* self = NULL;
	Player* _tmp0_ = NULL;
	self = (Game*) g_type_create_instance (object_type);
	_tmp0_ = g_new0 (Player, 8 * 8);
	self->tiles = (g_free (self->tiles), NULL);
	self->tiles = _tmp0_;
	self->tiles_length1 = 8;
	self->tiles_length2 = 8;
	{
		gint x;
		x = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = x;
					x = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = x;
				if (!(_tmp4_ < 8)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp5_;
						_tmp5_ = TRUE;
						while (TRUE) {
							gboolean _tmp6_;
							gint _tmp8_;
							Player* _tmp9_;
							gint _tmp9__length1;
							gint _tmp9__length2;
							gint _tmp10_;
							gint _tmp11_;
							Player _tmp12_;
							_tmp6_ = _tmp5_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = y;
								y = _tmp7_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp8_ = y;
							if (!(_tmp8_ < 8)) {
								break;
							}
							_tmp9_ = self->tiles;
							_tmp9__length1 = self->tiles_length1;
							_tmp9__length2 = self->tiles_length2;
							_tmp10_ = x;
							_tmp11_ = y;
							_tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_] = PLAYER_NONE;
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
						}
					}
				}
			}
		}
	}
	game_set_tile (self, 3, 3, PLAYER_LIGHT, FALSE);
	game_set_tile (self, 3, 4, PLAYER_DARK, FALSE);
	game_set_tile (self, 4, 3, PLAYER_DARK, FALSE);
	game_set_tile (self, 4, 4, PLAYER_LIGHT, FALSE);
	self->current_color = PLAYER_DARK;
	return self;
}


Game* game_new (void) {
	return game_construct (TYPE_GAME);
}


void game_start (Game* self) {
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_get_n_tiles (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != 4) {
		return;
	}
	g_signal_emit_by_name (self, "move");
}


Game* game_construct_copy (GType object_type, Game* game) {
	Game* self = NULL;
	Player* _tmp0_ = NULL;
	Game* _tmp29_;
	gint _tmp30_;
	Game* _tmp31_;
	Player _tmp32_;
	g_return_val_if_fail (game != NULL, NULL);
	self = (Game*) g_type_create_instance (object_type);
	_tmp0_ = g_new0 (Player, 8 * 8);
	self->tiles = (g_free (self->tiles), NULL);
	self->tiles = _tmp0_;
	self->tiles_length1 = 8;
	self->tiles_length2 = 8;
	{
		gint x;
		x = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = x;
					x = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = x;
				if (!(_tmp4_ < 8)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp5_;
						_tmp5_ = TRUE;
						while (TRUE) {
							gboolean _tmp6_;
							gint _tmp8_;
							Player* _tmp9_;
							gint _tmp9__length1;
							gint _tmp9__length2;
							gint _tmp10_;
							gint _tmp11_;
							Game* _tmp12_;
							Player* _tmp13_;
							gint _tmp13__length1;
							gint _tmp13__length2;
							gint _tmp14_;
							gint _tmp15_;
							Player _tmp16_;
							Player _tmp17_;
							_tmp6_ = _tmp5_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = y;
								y = _tmp7_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp8_ = y;
							if (!(_tmp8_ < 8)) {
								break;
							}
							_tmp9_ = self->tiles;
							_tmp9__length1 = self->tiles_length1;
							_tmp9__length2 = self->tiles_length2;
							_tmp10_ = x;
							_tmp11_ = y;
							_tmp12_ = game;
							_tmp13_ = _tmp12_->tiles;
							_tmp13__length1 = _tmp12_->tiles_length1;
							_tmp13__length2 = _tmp12_->tiles_length2;
							_tmp14_ = x;
							_tmp15_ = y;
							_tmp16_ = _tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_];
							_tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_] = _tmp16_;
							_tmp17_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
						}
					}
				}
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp18_;
			_tmp18_ = TRUE;
			while (TRUE) {
				gboolean _tmp19_;
				gint _tmp21_;
				Game* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				Game* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				_tmp19_ = _tmp18_;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ + 1;
				}
				_tmp18_ = FALSE;
				_tmp21_ = i;
				_tmp22_ = game;
				_tmp23_ = _tmp22_->priv->undo_index;
				if (!(_tmp21_ < _tmp23_)) {
					break;
				}
				_tmp24_ = i;
				_tmp25_ = game;
				_tmp26_ = i;
				_tmp27_ = _tmp25_->priv->undo_history[_tmp26_];
				self->priv->undo_history[_tmp24_] = _tmp27_;
				_tmp28_ = self->priv->undo_history[_tmp24_];
			}
		}
	}
	_tmp29_ = game;
	_tmp30_ = _tmp29_->priv->undo_index;
	self->priv->undo_index = _tmp30_;
	_tmp31_ = game;
	_tmp32_ = _tmp31_->current_color;
	self->current_color = _tmp32_;
	return self;
}


Game* game_new_copy (Game* game) {
	return game_construct_copy (TYPE_GAME, game);
}


Player game_get_owner (Game* self, gint x, gint y) {
	Player result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = game_is_valid_location (self, _tmp0_, _tmp1_);
	if (_tmp2_) {
		Player* _tmp3_;
		gint _tmp3__length1;
		gint _tmp3__length2;
		gint _tmp4_;
		gint _tmp5_;
		Player _tmp6_;
		_tmp3_ = self->tiles;
		_tmp3__length1 = self->tiles_length1;
		_tmp3__length2 = self->tiles_length2;
		_tmp4_ = x;
		_tmp5_ = y;
		_tmp6_ = _tmp3_[(_tmp4_ * _tmp3__length2) + _tmp5_];
		result = _tmp6_;
		return result;
	} else {
		result = PLAYER_NONE;
		return result;
	}
}


gboolean game_can_place (Game* self, gint x, gint y) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	Player _tmp2_;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = self->current_color;
	_tmp3_ = game_place (self, _tmp0_, _tmp1_, _tmp2_, FALSE);
	result = _tmp3_ > 0;
	return result;
}


gint game_place_tile (Game* self, gint x, gint y) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	Player _tmp2_;
	gint _tmp3_ = 0;
	gint n_tiles;
	gint _tmp4_;
	Player _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = self->current_color;
	_tmp3_ = game_place (self, _tmp0_, _tmp1_, _tmp2_, TRUE);
	n_tiles = _tmp3_;
	_tmp4_ = n_tiles;
	if (_tmp4_ == 0) {
		result = 0;
		return result;
	}
	_tmp5_ = self->current_color;
	if (_tmp5_ == PLAYER_LIGHT) {
		self->current_color = PLAYER_DARK;
	} else {
		self->current_color = PLAYER_LIGHT;
	}
	_tmp6_ = game_get_is_complete (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		g_signal_emit_by_name (self, "complete");
	} else {
		g_signal_emit_by_name (self, "move");
	}
	result = n_tiles;
	return result;
}


void game_pass (Game* self) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Player _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undo_index;
	self->priv->undo_history[_tmp0_] = 0;
	_tmp1_ = self->priv->undo_history[_tmp0_];
	_tmp2_ = self->priv->undo_index;
	self->priv->undo_index = _tmp2_ + 1;
	_tmp3_ = self->current_color;
	if (_tmp3_ == PLAYER_LIGHT) {
		self->current_color = PLAYER_DARK;
	} else {
		self->current_color = PLAYER_LIGHT;
	}
	g_signal_emit_by_name (self, "move");
}


static gint game_place (Game* self, gint x, gint y, Player color, gboolean apply) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp8_;
	gint n_flips;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	Player _tmp12_;
	gboolean _tmp13_;
	gint _tmp14_ = 0;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	Player _tmp18_;
	gboolean _tmp19_;
	gint _tmp20_ = 0;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	Player _tmp24_;
	gboolean _tmp25_;
	gint _tmp26_ = 0;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	Player _tmp30_;
	gboolean _tmp31_;
	gint _tmp32_ = 0;
	gint _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	Player _tmp36_;
	gboolean _tmp37_;
	gint _tmp38_ = 0;
	gint _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	Player _tmp42_;
	gboolean _tmp43_;
	gint _tmp44_ = 0;
	gint _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	Player _tmp48_;
	gboolean _tmp49_;
	gint _tmp50_ = 0;
	gint _tmp51_;
	gint _tmp52_;
	gint _tmp53_;
	Player _tmp54_;
	gboolean _tmp55_;
	gint _tmp56_ = 0;
	gboolean _tmp57_ = FALSE;
	gboolean _tmp58_;
	gboolean _tmp60_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = game_is_valid_location (self, _tmp1_, _tmp2_);
	if (!_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		Player* _tmp4_;
		gint _tmp4__length1;
		gint _tmp4__length2;
		gint _tmp5_;
		gint _tmp6_;
		Player _tmp7_;
		_tmp4_ = self->tiles;
		_tmp4__length1 = self->tiles_length1;
		_tmp4__length2 = self->tiles_length2;
		_tmp5_ = x;
		_tmp6_ = y;
		_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
		_tmp0_ = _tmp7_ != PLAYER_NONE;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		result = 0;
		return result;
	}
	n_flips = 0;
	_tmp9_ = n_flips;
	_tmp10_ = x;
	_tmp11_ = y;
	_tmp12_ = color;
	_tmp13_ = apply;
	_tmp14_ = game_flip_tiles (self, _tmp10_, _tmp11_, 1, 0, _tmp12_, _tmp13_);
	n_flips = _tmp9_ + _tmp14_;
	_tmp15_ = n_flips;
	_tmp16_ = x;
	_tmp17_ = y;
	_tmp18_ = color;
	_tmp19_ = apply;
	_tmp20_ = game_flip_tiles (self, _tmp16_, _tmp17_, 1, 1, _tmp18_, _tmp19_);
	n_flips = _tmp15_ + _tmp20_;
	_tmp21_ = n_flips;
	_tmp22_ = x;
	_tmp23_ = y;
	_tmp24_ = color;
	_tmp25_ = apply;
	_tmp26_ = game_flip_tiles (self, _tmp22_, _tmp23_, 0, 1, _tmp24_, _tmp25_);
	n_flips = _tmp21_ + _tmp26_;
	_tmp27_ = n_flips;
	_tmp28_ = x;
	_tmp29_ = y;
	_tmp30_ = color;
	_tmp31_ = apply;
	_tmp32_ = game_flip_tiles (self, _tmp28_, _tmp29_, -1, 1, _tmp30_, _tmp31_);
	n_flips = _tmp27_ + _tmp32_;
	_tmp33_ = n_flips;
	_tmp34_ = x;
	_tmp35_ = y;
	_tmp36_ = color;
	_tmp37_ = apply;
	_tmp38_ = game_flip_tiles (self, _tmp34_, _tmp35_, -1, 0, _tmp36_, _tmp37_);
	n_flips = _tmp33_ + _tmp38_;
	_tmp39_ = n_flips;
	_tmp40_ = x;
	_tmp41_ = y;
	_tmp42_ = color;
	_tmp43_ = apply;
	_tmp44_ = game_flip_tiles (self, _tmp40_, _tmp41_, -1, -1, _tmp42_, _tmp43_);
	n_flips = _tmp39_ + _tmp44_;
	_tmp45_ = n_flips;
	_tmp46_ = x;
	_tmp47_ = y;
	_tmp48_ = color;
	_tmp49_ = apply;
	_tmp50_ = game_flip_tiles (self, _tmp46_, _tmp47_, 0, -1, _tmp48_, _tmp49_);
	n_flips = _tmp45_ + _tmp50_;
	_tmp51_ = n_flips;
	_tmp52_ = x;
	_tmp53_ = y;
	_tmp54_ = color;
	_tmp55_ = apply;
	_tmp56_ = game_flip_tiles (self, _tmp52_, _tmp53_, 1, -1, _tmp54_, _tmp55_);
	n_flips = _tmp51_ + _tmp56_;
	_tmp58_ = apply;
	if (_tmp58_) {
		gint _tmp59_;
		_tmp59_ = n_flips;
		_tmp57_ = _tmp59_ > 0;
	} else {
		_tmp57_ = FALSE;
	}
	_tmp60_ = _tmp57_;
	if (_tmp60_) {
		gint _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		gint _tmp64_;
		_tmp61_ = self->priv->undo_index;
		_tmp62_ = n_flips;
		self->priv->undo_history[_tmp61_] = _tmp62_ + 1;
		_tmp63_ = self->priv->undo_history[_tmp61_];
		_tmp64_ = self->priv->undo_index;
		self->priv->undo_index = _tmp64_ + 1;
	}
	result = n_flips;
	return result;
}


static gint game_count_tiles (Game* self, Player color) {
	gint result = 0;
	gint count;
	g_return_val_if_fail (self != NULL, 0);
	count = 0;
	{
		gint x;
		x = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = x;
				if (!(_tmp3_ < 8)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp4_;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_;
							gint _tmp7_;
							Player* _tmp8_;
							gint _tmp8__length1;
							gint _tmp8__length2;
							gint _tmp9_;
							gint _tmp10_;
							Player _tmp11_;
							Player _tmp12_;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = y;
								y = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = y;
							if (!(_tmp7_ < 8)) {
								break;
							}
							_tmp8_ = self->tiles;
							_tmp8__length1 = self->tiles_length1;
							_tmp8__length2 = self->tiles_length2;
							_tmp9_ = x;
							_tmp10_ = y;
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
							_tmp12_ = color;
							if (_tmp11_ == _tmp12_) {
								gint _tmp13_;
								_tmp13_ = count;
								count = _tmp13_ + 1;
							}
						}
					}
				}
			}
		}
	}
	result = count;
	return result;
}


static gboolean game_is_valid_location (Game* self, gint x, gint y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = x;
	if (_tmp3_ >= 0) {
		gint _tmp4_;
		_tmp4_ = x;
		_tmp2_ = _tmp4_ < 8;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		gint _tmp6_;
		_tmp6_ = y;
		_tmp1_ = _tmp6_ >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		gint _tmp8_;
		_tmp8_ = y;
		_tmp0_ = _tmp8_ < 8;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = _tmp0_;
	result = _tmp9_;
	return result;
}


static gint game_flip_tiles (Game* self, gint x, gint y, gint x_step, gint y_step, Player color, gboolean apply) {
	gint result = 0;
	Player enemy;
	Player _tmp0_;
	gint enemy_count;
	gint _tmp1_;
	gint _tmp2_;
	gint xt;
	gint _tmp3_;
	gint _tmp4_;
	gint yt;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gint _tmp20_;
	gboolean _tmp24_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	g_return_val_if_fail (self != NULL, 0);
	enemy = PLAYER_LIGHT;
	_tmp0_ = color;
	if (_tmp0_ == PLAYER_LIGHT) {
		enemy = PLAYER_DARK;
	}
	enemy_count = 0;
	_tmp1_ = x;
	_tmp2_ = x_step;
	xt = _tmp1_ + _tmp2_;
	_tmp3_ = y;
	_tmp4_ = y_step;
	yt = _tmp3_ + _tmp4_;
	while (TRUE) {
		gint _tmp5_;
		gint _tmp6_;
		gboolean _tmp7_ = FALSE;
		Player* _tmp8_;
		gint _tmp8__length1;
		gint _tmp8__length2;
		gint _tmp9_;
		gint _tmp10_;
		Player _tmp11_;
		Player _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp5_ = xt;
		_tmp6_ = yt;
		_tmp7_ = game_is_valid_location (self, _tmp5_, _tmp6_);
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = self->tiles;
		_tmp8__length1 = self->tiles_length1;
		_tmp8__length2 = self->tiles_length2;
		_tmp9_ = xt;
		_tmp10_ = yt;
		_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
		_tmp12_ = enemy;
		if (_tmp11_ != _tmp12_) {
			break;
		}
		_tmp13_ = enemy_count;
		enemy_count = _tmp13_ + 1;
		_tmp14_ = xt;
		_tmp15_ = x_step;
		xt = _tmp14_ + _tmp15_;
		_tmp16_ = yt;
		_tmp17_ = y_step;
		yt = _tmp16_ + _tmp17_;
	}
	_tmp20_ = enemy_count;
	if (_tmp20_ == 0) {
		_tmp19_ = TRUE;
	} else {
		gint _tmp21_;
		gint _tmp22_;
		gboolean _tmp23_ = FALSE;
		_tmp21_ = xt;
		_tmp22_ = yt;
		_tmp23_ = game_is_valid_location (self, _tmp21_, _tmp22_);
		_tmp19_ = !_tmp23_;
	}
	_tmp24_ = _tmp19_;
	if (_tmp24_) {
		_tmp18_ = TRUE;
	} else {
		Player* _tmp25_;
		gint _tmp25__length1;
		gint _tmp25__length2;
		gint _tmp26_;
		gint _tmp27_;
		Player _tmp28_;
		Player _tmp29_;
		_tmp25_ = self->tiles;
		_tmp25__length1 = self->tiles_length1;
		_tmp25__length2 = self->tiles_length2;
		_tmp26_ = xt;
		_tmp27_ = yt;
		_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
		_tmp29_ = color;
		_tmp18_ = _tmp28_ != _tmp29_;
	}
	_tmp30_ = _tmp18_;
	if (_tmp30_) {
		result = 0;
		return result;
	}
	_tmp31_ = apply;
	if (_tmp31_) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp32_;
				_tmp32_ = TRUE;
				while (TRUE) {
					gboolean _tmp33_;
					gint _tmp35_;
					gint _tmp36_;
					gint _tmp37_;
					gint _tmp38_;
					gint _tmp39_;
					gint _tmp40_;
					gint _tmp41_;
					gint _tmp42_;
					Player _tmp43_;
					_tmp33_ = _tmp32_;
					if (!_tmp33_) {
						gint _tmp34_;
						_tmp34_ = i;
						i = _tmp34_ + 1;
					}
					_tmp32_ = FALSE;
					_tmp35_ = i;
					_tmp36_ = enemy_count;
					if (!(_tmp35_ <= _tmp36_)) {
						break;
					}
					_tmp37_ = x;
					_tmp38_ = i;
					_tmp39_ = x_step;
					_tmp40_ = y;
					_tmp41_ = i;
					_tmp42_ = y_step;
					_tmp43_ = color;
					game_set_tile (self, _tmp37_ + (_tmp38_ * _tmp39_), _tmp40_ + (_tmp41_ * _tmp42_), _tmp43_, TRUE);
				}
			}
		}
	}
	result = enemy_count;
	return result;
}


void game_undo (Game* self, gint count) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = count;
	if (_tmp0_ < 1) {
		return;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				gint n_changes;
				gint _tmp8_;
				Player _tmp22_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = count;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->undo_index;
				_tmp7_ = self->priv->undo_history[_tmp6_ - 1];
				n_changes = _tmp7_;
				_tmp8_ = self->priv->undo_index;
				self->priv->undo_index = _tmp8_ - 1;
				{
					gint j;
					j = 0;
					{
						gboolean _tmp9_;
						_tmp9_ = TRUE;
						while (TRUE) {
							gboolean _tmp10_;
							gint _tmp12_;
							gint _tmp13_;
							gint _tmp14_;
							gint _tmp15_;
							gint n;
							gint _tmp16_;
							gint _tmp17_;
							Player c;
							gint _tmp18_;
							gint xy;
							gint _tmp19_;
							gint _tmp20_;
							Player _tmp21_;
							_tmp10_ = _tmp9_;
							if (!_tmp10_) {
								gint _tmp11_;
								_tmp11_ = j;
								j = _tmp11_ + 1;
							}
							_tmp9_ = FALSE;
							_tmp12_ = j;
							_tmp13_ = n_changes;
							if (!(_tmp12_ < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->undo_index;
							_tmp15_ = self->priv->undo_history[_tmp14_ - 1];
							n = _tmp15_;
							_tmp16_ = self->priv->undo_index;
							self->priv->undo_index = _tmp16_ - 1;
							_tmp17_ = n;
							c = (Player) (_tmp17_ >> 6);
							_tmp18_ = n;
							xy = _tmp18_ & 0x3F;
							_tmp19_ = xy;
							_tmp20_ = xy;
							_tmp21_ = c;
							game_set_tile (self, _tmp19_ / 8, _tmp20_ % 8, _tmp21_, FALSE);
						}
					}
				}
				_tmp22_ = self->current_color;
				if (_tmp22_ == PLAYER_LIGHT) {
					self->current_color = PLAYER_DARK;
				} else {
					self->current_color = PLAYER_LIGHT;
				}
			}
		}
	}
	g_signal_emit_by_name (self, "move");
}


static void game_set_tile (Game* self, gint x, gint y, Player color, gboolean update_history) {
	Player* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint _tmp2_;
	Player _tmp3_;
	Player _tmp4_;
	gboolean _tmp5_;
	Player* _tmp15_;
	gint _tmp15__length1;
	gint _tmp15__length2;
	gint _tmp16_;
	gint _tmp17_;
	Player _tmp18_;
	Player _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tiles;
	_tmp0__length1 = self->tiles_length1;
	_tmp0__length2 = self->tiles_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = color;
	if (_tmp3_ == _tmp4_) {
		return;
	}
	_tmp5_ = update_history;
	if (_tmp5_) {
		gint _tmp6_;
		Player* _tmp7_;
		gint _tmp7__length1;
		gint _tmp7__length2;
		gint _tmp8_;
		gint _tmp9_;
		Player _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp6_ = self->priv->undo_index;
		_tmp7_ = self->tiles;
		_tmp7__length1 = self->tiles_length1;
		_tmp7__length2 = self->tiles_length2;
		_tmp8_ = x;
		_tmp9_ = y;
		_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
		_tmp11_ = x;
		_tmp12_ = y;
		self->priv->undo_history[_tmp6_] = (((gint) _tmp10_) << 6) | ((_tmp11_ * 8) + _tmp12_);
		_tmp13_ = self->priv->undo_history[_tmp6_];
		_tmp14_ = self->priv->undo_index;
		self->priv->undo_index = _tmp14_ + 1;
	}
	_tmp15_ = self->tiles;
	_tmp15__length1 = self->tiles_length1;
	_tmp15__length2 = self->tiles_length2;
	_tmp16_ = x;
	_tmp17_ = y;
	_tmp18_ = color;
	_tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_] = _tmp18_;
	_tmp19_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
	_tmp20_ = x;
	_tmp21_ = y;
	g_signal_emit_by_name (self, "square-changed", _tmp20_, _tmp21_);
}


gint game_get_n_tiles (Game* self) {
	gint result;
	gint count;
	gint _tmp13_;
	g_return_val_if_fail (self != NULL, 0);
	count = 0;
	{
		gint x;
		x = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = x;
				if (!(_tmp3_ < 8)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp4_;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_;
							gint _tmp7_;
							Player* _tmp8_;
							gint _tmp8__length1;
							gint _tmp8__length2;
							gint _tmp9_;
							gint _tmp10_;
							Player _tmp11_;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = y;
								y = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = y;
							if (!(_tmp7_ < 8)) {
								break;
							}
							_tmp8_ = self->tiles;
							_tmp8__length1 = self->tiles_length1;
							_tmp8__length2 = self->tiles_length2;
							_tmp9_ = x;
							_tmp10_ = y;
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
							if (_tmp11_ != PLAYER_NONE) {
								gint _tmp12_;
								_tmp12_ = count;
								count = _tmp12_ + 1;
							}
						}
					}
				}
			}
		}
	}
	_tmp13_ = count;
	result = _tmp13_;
	return result;
}


gint game_get_n_light_tiles (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = game_count_tiles (self, PLAYER_LIGHT);
	result = _tmp0_;
	return result;
}


gint game_get_n_dark_tiles (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = game_count_tiles (self, PLAYER_DARK);
	result = _tmp0_;
	return result;
}


gboolean game_get_can_move (Game* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint x;
		x = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = x;
				if (!(_tmp3_ < 8)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp4_;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_;
							gint _tmp7_;
							gint _tmp8_;
							gint _tmp9_;
							gboolean _tmp10_ = FALSE;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = y;
								y = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = y;
							if (!(_tmp7_ < 8)) {
								break;
							}
							_tmp8_ = x;
							_tmp9_ = y;
							_tmp10_ = game_can_place (self, _tmp8_, _tmp9_);
							if (_tmp10_) {
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}


gboolean game_get_is_complete (Game* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp6_;
	gboolean _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = game_get_n_tiles (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 64) {
		_tmp1_ = TRUE;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = game_get_n_light_tiles (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ == 0;
	}
	_tmp6_ = _tmp1_;
	if (_tmp6_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = game_get_n_dark_tiles (self);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_ == 0;
	}
	_tmp9_ = _tmp0_;
	result = _tmp9_;
	return result;
}


gboolean game_get_can_undo (Game* self) {
	gboolean result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->undo_index;
	result = _tmp0_ > 0;
	return result;
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void value_game_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_game_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		game_unref (value->data[0].v_pointer);
	}
}


static void value_game_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = game_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_game_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_game_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Game* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = game_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_game_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Game** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = game_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecGame* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_GAME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_game (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GAME), NULL);
	return value->data[0].v_pointer;
}


void value_set_game (GValue* value, gpointer v_object) {
	Game* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GAME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GAME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		game_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		game_unref (old);
	}
}


void value_take_game (GValue* value, gpointer v_object) {
	Game* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GAME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GAME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		game_unref (old);
	}
}


static void game_class_init (GameClass * klass) {
	game_parent_class = g_type_class_peek_parent (klass);
	GAME_CLASS (klass)->finalize = game_finalize;
	g_type_class_add_private (klass, sizeof (GamePrivate));
	g_signal_new ("move", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("square_changed", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	g_signal_new ("complete", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void game_instance_init (Game * self) {
	self->priv = GAME_GET_PRIVATE (self);
	self->priv->undo_index = 0;
	self->ref_count = 1;
}


static void game_finalize (Game* obj) {
	Game * self;
	self = GAME (obj);
	self->tiles = (g_free (self->tiles), NULL);
}


GType game_get_type (void) {
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_game_init, value_game_free_value, value_game_copy_value, value_game_peek_pointer, "p", value_game_collect_value, "p", value_game_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType game_type_id;
		game_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Game", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


gpointer game_ref (gpointer instance) {
	Game* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void game_unref (gpointer instance) {
	Game* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GAME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



