/* chess-engine.c generated by valac 0.15.0, the Vala compiler
 * generated from chess-engine.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>


#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;
typedef struct _ChessEnginePrivate ChessEnginePrivate;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ChessEngine {
	GObject parent_instance;
	ChessEnginePrivate * priv;
	gchar* binary;
};

struct _ChessEngineClass {
	GObjectClass parent_class;
	void (*process_input) (ChessEngine* self, gchar* data, int data_length1);
	void (*start_game) (ChessEngine* self);
	void (*request_move) (ChessEngine* self);
	void (*report_move) (ChessEngine* self, ChessMove* move);
	void (*undo) (ChessEngine* self);
};

struct _ChessEnginePrivate {
	GPid pid;
	gint stdin_fd;
	gint stderr_fd;
	GIOChannel* stdout_channel;
	gboolean _ready;
};


static gpointer chess_engine_parent_class = NULL;

GType chess_engine_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
#define CHESS_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_ENGINE, ChessEnginePrivate))
enum  {
	CHESS_ENGINE_DUMMY_PROPERTY,
	CHESS_ENGINE_READY
};
void chess_engine_process_input (ChessEngine* self, gchar* data, int data_length1);
static void chess_engine_real_process_input (ChessEngine* self, gchar* data, int data_length1);
gboolean chess_engine_start (ChessEngine* self);
static gboolean chess_engine_read_cb (ChessEngine* self, GIOChannel* source, GIOCondition condition);
static gboolean _chess_engine_read_cb_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
void chess_engine_start_game (ChessEngine* self);
static void chess_engine_real_start_game (ChessEngine* self);
void chess_engine_request_move (ChessEngine* self);
static void chess_engine_real_request_move (ChessEngine* self);
void chess_engine_report_move (ChessEngine* self, ChessMove* move);
static void chess_engine_real_report_move (ChessEngine* self, ChessMove* move);
void chess_engine_undo (ChessEngine* self);
static void chess_engine_real_undo (ChessEngine* self);
void chess_engine_stop (ChessEngine* self);
void chess_engine_write (ChessEngine* self, gchar* data, int data_length1);
void chess_engine_write_line (ChessEngine* self, const gchar* line);
ChessEngine* chess_engine_new (void);
ChessEngine* chess_engine_construct (GType object_type);
gboolean chess_engine_get_ready (ChessEngine* self);
void chess_engine_set_ready (ChessEngine* self, gboolean value);
static void chess_engine_finalize (GObject* obj);
static void _vala_chess_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void chess_engine_real_process_input (ChessEngine* self, gchar* data, int data_length1) {
}


void chess_engine_process_input (ChessEngine* self, gchar* data, int data_length1) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->process_input (self, data, data_length1);
}


static gboolean _chess_engine_read_cb_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = chess_engine_read_cb (self, source, condition);
	return result;
}


gboolean chess_engine_start (ChessEngine* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** argv;
	gint argv_length1;
	gint _argv_size_;
	gint stdout_fd = 0;
	gint _tmp11_;
	GIOChannel* _tmp12_;
	GIOChannel* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->binary;
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp2_[1] = NULL;
	argv = _tmp2_;
	argv_length1 = 2;
	_argv_size_ = argv_length1;
	{
		gchar** _tmp3_;
		gint _tmp3__length1;
		GPid _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp3_ = argv;
		_tmp3__length1 = argv_length1;
		g_spawn_async_with_pipes (NULL, _tmp3_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &_inner_error_);
		self->priv->pid = _tmp4_;
		self->priv->stdin_fd = _tmp5_;
		stdout_fd = _tmp6_;
		self->priv->stderr_fd = _tmp7_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch10_g_spawn_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	goto __finally10;
	__catch10_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = stderr;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		fprintf (_tmp8_, "Failed to execute chess engine: %s\n", _tmp10_);
		result = FALSE;
		_g_error_free0 (e);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally10:
	if (_inner_error_ != NULL) {
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp11_ = stdout_fd;
	_tmp12_ = g_io_channel_unix_new (_tmp11_);
	_g_io_channel_unref0 (self->priv->stdout_channel);
	self->priv->stdout_channel = _tmp12_;
	{
		GIOChannel* _tmp13_;
		_tmp13_ = self->priv->stdout_channel;
		g_io_channel_set_flags (_tmp13_, G_IO_FLAG_NONBLOCK, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch11_g_io_channel_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	goto __finally11;
	__catch11_g_io_channel_error:
	{
		GError* e = NULL;
		FILE* _tmp14_;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = stderr;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		fprintf (_tmp14_, "Failed to set input from chess engine to non-blocking: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp17_ = self->priv->stdout_channel;
	g_io_add_watch (_tmp17_, G_IO_IN, _chess_engine_read_cb_gio_func, self);
	g_signal_emit_by_name (self, "starting");
	result = TRUE;
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void chess_engine_real_start_game (ChessEngine* self) {
}


void chess_engine_start_game (ChessEngine* self) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->start_game (self);
}


static void chess_engine_real_request_move (ChessEngine* self) {
}


void chess_engine_request_move (ChessEngine* self) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->request_move (self);
}


static void chess_engine_real_report_move (ChessEngine* self, ChessMove* move) {
	g_return_if_fail (move != NULL);
}


void chess_engine_report_move (ChessEngine* self, ChessMove* move) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->report_move (self, move);
}


static void chess_engine_real_undo (ChessEngine* self) {
}


void chess_engine_undo (ChessEngine* self) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->undo (self);
}


void chess_engine_stop (ChessEngine* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "stopped");
}


static gboolean chess_engine_read_cb (ChessEngine* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	gchar* buf = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	gsize n_read = 0UL;
	GIOStatus status = 0;
	gchar* _tmp0_ = NULL;
	GIOStatus _tmp6_;
	GIOStatus _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = g_new0 (gchar, 1024);
	buf = (g_free (buf), NULL);
	buf = _tmp0_;
	buf_length1 = 1024;
	_buf_size_ = buf_length1;
	{
		GIOChannel* _tmp1_;
		gchar* _tmp2_;
		gint _tmp2__length1;
		gsize _tmp3_ = 0UL;
		GIOStatus _tmp4_ = 0;
		GIOStatus _tmp5_;
		_tmp1_ = source;
		_tmp2_ = buf;
		_tmp2__length1 = buf_length1;
		_tmp4_ = g_io_channel_read_chars (_tmp1_, _tmp2_, _tmp2__length1, &_tmp3_, &_inner_error_);
		n_read = _tmp3_;
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_CONVERT_ERROR) {
				goto __catch12_g_convert_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch12_g_io_channel_error;
			}
			buf = (g_free (buf), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		status = _tmp5_;
	}
	goto __finally12;
	__catch12_g_convert_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		buf = (g_free (buf), NULL);
		return result;
	}
	goto __finally12;
	__catch12_g_io_channel_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		buf = (g_free (buf), NULL);
		return result;
	}
	__finally12:
	if (_inner_error_ != NULL) {
		buf = (g_free (buf), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp6_ = status;
	if (_tmp6_ == G_IO_STATUS_EOF) {
		FILE* _tmp7_;
		_tmp7_ = stdout;
		fprintf (_tmp7_, "EOF\n");
		result = FALSE;
		buf = (g_free (buf), NULL);
		return result;
	}
	_tmp8_ = status;
	if (_tmp8_ == G_IO_STATUS_NORMAL) {
		gsize _tmp9_;
		gint _tmp10_ = 0;
		gchar* _tmp11_;
		gint _tmp11__length1;
		_tmp9_ = n_read;
		_tmp10_ = (gint) _tmp9_;
		buf = g_renew (gchar, buf, (gint) _tmp9_);
		(_tmp10_ > buf_length1) ? memset (buf + buf_length1, 0, sizeof (gchar) * (_tmp10_ - buf_length1)) : NULL;
		buf_length1 = _tmp10_;
		_buf_size_ = _tmp10_;
		_tmp11_ = buf;
		_tmp11__length1 = buf_length1;
		chess_engine_process_input (self, _tmp11_, _tmp11__length1);
	}
	result = TRUE;
	buf = (g_free (buf), NULL);
	return result;
}


void chess_engine_write (ChessEngine* self, gchar* data, int data_length1) {
	gsize offset;
	gsize n_written = 0UL;
	g_return_if_fail (self != NULL);
	offset = (gsize) 0;
	while (TRUE) {
		gsize _tmp0_;
		gchar* _tmp1_;
		gint _tmp1__length1;
		gchar* _tmp2_;
		gint _tmp2__length1;
		gsize _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* d;
		gint d_length1;
		gint _d_size_;
		gint _tmp18_;
		gchar* _tmp19_;
		gint _tmp19__length1;
		gchar* _tmp20_;
		gint _tmp20__length1;
		gssize _tmp21_ = 0L;
		gsize _tmp22_;
		gsize _tmp23_;
		gsize _tmp24_;
		_tmp0_ = offset;
		_tmp1_ = data;
		_tmp1__length1 = data_length1;
		if (!(_tmp0_ < ((gsize) _tmp1__length1))) {
			break;
		}
		_tmp2_ = data;
		_tmp2__length1 = data_length1;
		_tmp3_ = offset;
		_tmp4_ = g_new0 (gchar, _tmp2__length1 - _tmp3_);
		d = _tmp4_;
		d_length1 = _tmp2__length1 - _tmp3_;
		_d_size_ = d_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp5_;
				_tmp5_ = TRUE;
				while (TRUE) {
					gboolean _tmp6_;
					gint _tmp8_;
					gchar* _tmp9_;
					gint _tmp9__length1;
					gsize _tmp10_;
					gchar* _tmp11_;
					gint _tmp11__length1;
					gint _tmp12_;
					gchar* _tmp13_;
					gint _tmp13__length1;
					gsize _tmp14_;
					gint _tmp15_;
					gchar _tmp16_;
					gchar _tmp17_;
					_tmp6_ = _tmp5_;
					if (!_tmp6_) {
						gint _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp8_ = i;
					_tmp9_ = data;
					_tmp9__length1 = data_length1;
					_tmp10_ = offset;
					if (!(((gsize) _tmp8_) < (_tmp9__length1 - _tmp10_))) {
						break;
					}
					_tmp11_ = d;
					_tmp11__length1 = d_length1;
					_tmp12_ = i;
					_tmp13_ = data;
					_tmp13__length1 = data_length1;
					_tmp14_ = offset;
					_tmp15_ = i;
					_tmp16_ = _tmp13_[_tmp14_ + _tmp15_];
					_tmp11_[_tmp12_] = _tmp16_;
					_tmp17_ = _tmp11_[_tmp12_];
				}
			}
		}
		_tmp18_ = self->priv->stdin_fd;
		_tmp19_ = d;
		_tmp19__length1 = d_length1;
		_tmp20_ = d;
		_tmp20__length1 = d_length1;
		_tmp21_ = write (_tmp18_, _tmp19_, (gsize) _tmp20__length1);
		n_written = (gsize) _tmp21_;
		_tmp22_ = n_written;
		if (_tmp22_ < ((gsize) 0)) {
			d = (g_free (d), NULL);
			return;
		}
		_tmp23_ = offset;
		_tmp24_ = n_written;
		offset = _tmp23_ + _tmp24_;
		d = (g_free (d), NULL);
	}
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
	_result_ = _tmp2_;
	_result__length1 = _tmp1_ + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	_tmp5_ = strlen (self);
	_tmp6_ = _tmp5_;
	memcpy (_tmp4_, self, (gsize) _tmp6_);
	_tmp7_ = _result_;
	_tmp7__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


void chess_engine_write_line (ChessEngine* self, const gchar* line) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* l;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* d;
	gint d_length1;
	gint _d_size_;
	gchar* _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = line;
	_tmp1_ = g_strconcat (_tmp0_, "\n", NULL);
	l = _tmp1_;
	_tmp2_ = line;
	g_debug ("chess-engine.vala:146: Writing line to engine: '%s'", _tmp2_);
	_tmp3_ = l;
	_tmp5_ = string_to_utf8 (_tmp3_, &_tmp4_);
	d = _tmp5_;
	d_length1 = _tmp4_;
	_d_size_ = d_length1;
	_tmp6_ = d;
	_tmp6__length1 = d_length1;
	if (_tmp6_ != NULL) {
		gchar* _tmp7_;
		gint _tmp7__length1;
		_tmp7_ = d;
		_tmp7__length1 = d_length1;
		chess_engine_write (self, _tmp7_, _tmp7__length1);
	}
	d = (g_free (d), NULL);
	_g_free0 (l);
}


ChessEngine* chess_engine_construct (GType object_type) {
	ChessEngine * self = NULL;
	self = (ChessEngine*) g_object_new (object_type, NULL);
	return self;
}


ChessEngine* chess_engine_new (void) {
	return chess_engine_construct (TYPE_CHESS_ENGINE);
}


gboolean chess_engine_get_ready (ChessEngine* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_ready;
	result = _tmp0_;
	return result;
}


void chess_engine_set_ready (ChessEngine* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_ready = _tmp0_;
	g_signal_emit_by_name (self, "ready-changed");
	g_object_notify ((GObject *) self, "ready");
}


static void chess_engine_class_init (ChessEngineClass * klass) {
	chess_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessEnginePrivate));
	CHESS_ENGINE_CLASS (klass)->process_input = chess_engine_real_process_input;
	CHESS_ENGINE_CLASS (klass)->start_game = chess_engine_real_start_game;
	CHESS_ENGINE_CLASS (klass)->request_move = chess_engine_real_request_move;
	CHESS_ENGINE_CLASS (klass)->report_move = chess_engine_real_report_move;
	CHESS_ENGINE_CLASS (klass)->undo = chess_engine_real_undo;
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_engine_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_engine_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_engine_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_ENGINE_READY, g_param_spec_boolean ("ready", "ready", "ready", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("starting", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("ready_changed", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("moved", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("resigned", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("stopped", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_engine_instance_init (ChessEngine * self) {
	self->priv = CHESS_ENGINE_GET_PRIVATE (self);
	self->priv->_ready = FALSE;
}


static void chess_engine_finalize (GObject* obj) {
	ChessEngine * self;
	self = CHESS_ENGINE (obj);
	_g_free0 (self->binary);
	_g_io_channel_unref0 (self->priv->stdout_channel);
	G_OBJECT_CLASS (chess_engine_parent_class)->finalize (obj);
}


GType chess_engine_get_type (void) {
	static volatile gsize chess_engine_type_id__volatile = 0;
	if (g_once_init_enter (&chess_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEngine), 0, (GInstanceInitFunc) chess_engine_instance_init, NULL };
		GType chess_engine_type_id;
		chess_engine_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessEngine", &g_define_type_info, 0);
		g_once_init_leave (&chess_engine_type_id__volatile, chess_engine_type_id);
	}
	return chess_engine_type_id__volatile;
}


static void _vala_chess_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessEngine * self;
	self = CHESS_ENGINE (object);
	switch (property_id) {
		case CHESS_ENGINE_READY:
		g_value_set_boolean (value, chess_engine_get_ready (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_chess_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessEngine * self;
	self = CHESS_ENGINE (object);
	switch (property_id) {
		case CHESS_ENGINE_READY:
		chess_engine_set_ready (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



