/* game-view.c generated by valac 0.14.1, the Vala compiler
 * generated from game-view.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_LED_ARRAY (led_array_get_type ())
#define LED_ARRAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LED_ARRAY, LEDArray))
#define LED_ARRAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LED_ARRAY, LEDArrayClass))
#define IS_LED_ARRAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LED_ARRAY))
#define IS_LED_ARRAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LED_ARRAY))
#define LED_ARRAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LED_ARRAY, LEDArrayClass))

typedef struct _LEDArray LEDArray;
typedef struct _LEDArrayClass LEDArrayClass;

#define TYPE_BOARD_VIEW (board_view_get_type ())
#define BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD_VIEW, BoardView))
#define BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD_VIEW, BoardViewClass))
#define IS_BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD_VIEW))
#define IS_BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD_VIEW))
#define BOARD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD_VIEW, BoardViewClass))

typedef struct _BoardView BoardView;
typedef struct _BoardViewClass BoardViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BoardViewPrivate BoardViewPrivate;

struct _GameView {
	ClutterGroup parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	ClutterGroupClass parent_class;
};

struct _GameViewPrivate {
	ClutterTexture* backing_texture;
	ClutterTexture* highlight_texture;
	ClutterTexture* off_texture;
	ClutterTexture* on_texture;
	ClutterTexture* led_back_texture;
	ClutterTexture* arrow_texture;
	gint current_level;
	GList* actor_remove_queue;
	LEDArray* score_view;
	BoardView* board_view;
	BoardView* new_board_view;
	ClutterActor* backing_view;
	ClutterActor* left_arrow;
	ClutterActor* right_arrow;
	ClutterActor* key_cursor_view;
	ClutterTimeline* timeline;
	gint key_cursor_x;
	gint key_cursor_y;
	gboolean key_cursor_ready;
	gint last_direction;
	gint last_sign;
};

struct _BoardView {
	ClutterGroup parent_instance;
	BoardViewPrivate * priv;
	gboolean playable;
};

struct _BoardViewClass {
	ClutterGroupClass parent_class;
};


static gpointer game_view_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType led_array_get_type (void) G_GNUC_CONST;
GType board_view_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GameView* game_view_new (gint level);
GameView* game_view_construct (GType object_type, gint level);
static BoardView* game_view_create_board_view (GameView* self, gint level);
LEDArray* led_array_new (gint n_digits, ClutterActor* back_texture);
LEDArray* led_array_construct (GType object_type, gint n_digits, ClutterActor* back_texture);
void led_array_set_value (LEDArray* self, gint value);
static gboolean game_view_left_arrow_button_release_cb (GameView* self, ClutterActor* actor, ClutterButtonEvent* event);
static gboolean _game_view_left_arrow_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
static gboolean game_view_right_arrow_button_release_cb (GameView* self, ClutterActor* actor, ClutterButtonEvent* event);
static gboolean _game_view_right_arrow_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
BoardView* board_view_new (ClutterTexture* off_texture, ClutterTexture* on_texture);
BoardView* board_view_construct (GType object_type, ClutterTexture* off_texture, ClutterTexture* on_texture);
void board_view_load_level (BoardView* self, gint level);
static void game_view_game_won_cb (GameView* self);
static void _game_view_game_won_cb_board_view_game_won (BoardView* _sender, gpointer self);
static void game_view_transition_complete_cb (GameView* self);
void board_view_slide_in (BoardView* self, gint direction, gint sign, ClutterTimeline* timeline);
void board_view_slide_out (BoardView* self, gint direction, gint sign, ClutterTimeline* timeline);
static void _game_view_transition_complete_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static void game_view_swap_board (GameView* self, gint direction);
void board_view_swap_in (BoardView* self, gfloat direction, ClutterTimeline* timeline);
void board_view_swap_out (BoardView* self, gfloat direction, ClutterTimeline* timeline);
void game_view_hide_cursor (GameView* self);
void game_view_move_cursor (GameView* self, gint x_step, gint y_step);
void board_view_get_light_position (BoardView* self, gint x, gint y, gfloat* xx, gfloat* yy);
void game_view_activate_cursor (GameView* self);
void board_view_toggle_light (BoardView* self, gint x, gint y, gboolean animate);
void game_view_reset_game (GameView* self);
static void game_view_finalize (GObject* obj);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean _game_view_left_arrow_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = game_view_left_arrow_button_release_cb (self, _sender, event);
	return result;
}


static gboolean _game_view_right_arrow_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = game_view_right_arrow_button_release_cb (self, _sender, event);
	return result;
}


GameView* game_view_construct (GType object_type, gint level) {
	GameView * self = NULL;
	ClutterTexture* _tmp26_;
	ClutterTexture* _tmp27_;
	ClutterTexture* _tmp28_;
	ClutterTexture* _tmp29_;
	ClutterTexture* _tmp30_;
	ClutterTexture* _tmp31_;
	ClutterTexture* _tmp32_;
	ClutterTexture* _tmp33_;
	ClutterTexture* _tmp34_;
	ClutterTexture* _tmp35_;
	ClutterTexture* _tmp36_;
	ClutterTexture* _tmp37_;
	ClutterTexture* _tmp38_;
	gfloat _tmp39_;
	gfloat _tmp40_;
	gfloat real_board_width;
	ClutterTexture* _tmp41_;
	gfloat _tmp42_;
	gfloat _tmp43_;
	gfloat real_board_height;
	gint _tmp44_;
	gint _tmp45_;
	BoardView* _tmp46_ = NULL;
	BoardView* _tmp47_;
	BoardView* _tmp48_;
	ClutterTexture* _tmp49_;
	ClutterClone* _tmp50_;
	ClutterActor* _tmp51_;
	ClutterActor* _tmp52_;
	ClutterActor* _tmp53_;
	ClutterTexture* _tmp54_;
	LEDArray* _tmp55_;
	LEDArray* _tmp56_;
	LEDArray* _tmp57_;
	gint _tmp58_;
	LEDArray* _tmp59_;
	LEDArray* _tmp60_;
	gfloat _tmp61_;
	gfloat _tmp62_;
	LEDArray* _tmp63_;
	LEDArray* _tmp64_;
	LEDArray* _tmp65_;
	gfloat _tmp66_;
	gfloat _tmp67_;
	LEDArray* _tmp68_;
	gfloat _tmp69_;
	gfloat _tmp70_;
	ClutterTexture* _tmp71_;
	ClutterClone* _tmp72_;
	ClutterActor* _tmp73_;
	ClutterActor* _tmp74_;
	ClutterActor* _tmp75_;
	ClutterActor* _tmp76_;
	ClutterActor* _tmp77_;
	LEDArray* _tmp78_;
	gfloat _tmp79_;
	gfloat _tmp80_;
	LEDArray* _tmp81_;
	gfloat _tmp82_ = 0.0F;
	gfloat _tmp83_;
	LEDArray* _tmp84_;
	gfloat _tmp85_;
	gfloat _tmp86_;
	LEDArray* _tmp87_;
	gfloat _tmp88_;
	gfloat _tmp89_;
	ClutterActor* _tmp90_;
	ClutterTexture* _tmp91_;
	ClutterClone* _tmp92_;
	ClutterActor* _tmp93_;
	ClutterActor* _tmp94_;
	ClutterActor* _tmp95_;
	ClutterActor* _tmp96_;
	ClutterActor* _tmp97_;
	ClutterActor* _tmp98_;
	ClutterActor* _tmp99_;
	gfloat _tmp100_;
	gfloat _tmp101_;
	LEDArray* _tmp102_;
	gfloat _tmp103_;
	gfloat _tmp104_;
	LEDArray* _tmp105_;
	gfloat _tmp106_;
	gfloat _tmp107_;
	ClutterActor* _tmp108_;
	ClutterTexture* _tmp109_;
	ClutterClone* _tmp110_;
	ClutterActor* _tmp111_;
	ClutterActor* _tmp112_;
	ClutterActor* _tmp113_;
	ClutterActor* _tmp114_;
	GError * _inner_error_ = NULL;
	self = (GameView*) g_object_new (object_type, NULL);
	{
		ClutterTexture* _tmp0_;
		ClutterTexture* _tmp1_;
		ClutterTexture* _tmp2_;
		ClutterTexture* _tmp3_;
		ClutterTexture* _tmp4_;
		ClutterTexture* _tmp5_;
		ClutterTexture* _tmp6_;
		ClutterTexture* _tmp7_;
		ClutterTexture* _tmp8_;
		ClutterTexture* _tmp9_;
		ClutterTexture* _tmp10_;
		ClutterTexture* _tmp11_;
		ClutterTexture* _tmp12_;
		ClutterTexture* _tmp13_;
		ClutterTexture* _tmp14_;
		ClutterTexture* _tmp15_;
		ClutterTexture* _tmp16_;
		ClutterTexture* _tmp17_;
		ClutterTexture* _tmp18_;
		ClutterTexture* _tmp19_;
		ClutterTexture* _tmp20_;
		ClutterTexture* _tmp21_;
		ClutterTexture* _tmp22_;
		ClutterTexture* _tmp23_;
		_tmp0_ = (ClutterTexture*) clutter_texture_new_from_file ("data/backing.svg", &_inner_error_);
		_tmp1_ = g_object_ref_sink (_tmp0_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp3_ = g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->backing_texture);
		self->priv->backing_texture = _tmp3_;
		_tmp4_ = (ClutterTexture*) clutter_texture_new_from_file ("data/highlight.svg", &_inner_error_);
		_tmp5_ = g_object_ref_sink (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp7_ = g_object_ref_sink (_tmp6_);
		_g_object_unref0 (self->priv->highlight_texture);
		self->priv->highlight_texture = _tmp7_;
		_tmp8_ = (ClutterTexture*) clutter_texture_new_from_file ("data/off.svg", &_inner_error_);
		_tmp9_ = g_object_ref_sink (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp11_ = g_object_ref_sink (_tmp10_);
		_g_object_unref0 (self->priv->off_texture);
		self->priv->off_texture = _tmp11_;
		_tmp12_ = (ClutterTexture*) clutter_texture_new_from_file ("data/on.svg", &_inner_error_);
		_tmp13_ = g_object_ref_sink (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = g_object_ref_sink (_tmp14_);
		_g_object_unref0 (self->priv->on_texture);
		self->priv->on_texture = _tmp15_;
		_tmp16_ = (ClutterTexture*) clutter_texture_new_from_file ("data/led-back.svg", &_inner_error_);
		_tmp17_ = g_object_ref_sink (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp19_ = g_object_ref_sink (_tmp18_);
		_g_object_unref0 (self->priv->led_back_texture);
		self->priv->led_back_texture = _tmp19_;
		_tmp20_ = (ClutterTexture*) clutter_texture_new_from_file ("data/arrow.svg", &_inner_error_);
		_tmp21_ = g_object_ref_sink (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp23_ = g_object_ref_sink (_tmp22_);
		_g_object_unref0 (self->priv->arrow_texture);
		self->priv->arrow_texture = _tmp23_;
	}
	goto __finally1;
	__catch1_clutter_texture_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		g_warning ("game-view.vala:46: Failed to load textures: %s", _tmp25_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp26_ = self->priv->backing_texture;
	clutter_actor_hide ((ClutterActor*) _tmp26_);
	_tmp27_ = self->priv->backing_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp27_);
	_tmp28_ = self->priv->highlight_texture;
	clutter_actor_hide ((ClutterActor*) _tmp28_);
	_tmp29_ = self->priv->highlight_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp29_);
	_tmp30_ = self->priv->off_texture;
	clutter_actor_hide ((ClutterActor*) _tmp30_);
	_tmp31_ = self->priv->off_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp31_);
	_tmp32_ = self->priv->on_texture;
	clutter_actor_hide ((ClutterActor*) _tmp32_);
	_tmp33_ = self->priv->on_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp33_);
	_tmp34_ = self->priv->led_back_texture;
	clutter_actor_hide ((ClutterActor*) _tmp34_);
	_tmp35_ = self->priv->led_back_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp35_);
	_tmp36_ = self->priv->arrow_texture;
	clutter_actor_hide ((ClutterActor*) _tmp36_);
	_tmp37_ = self->priv->arrow_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp37_);
	_tmp38_ = self->priv->off_texture;
	_tmp39_ = clutter_actor_get_width ((ClutterActor*) _tmp38_);
	_tmp40_ = _tmp39_;
	real_board_width = (5 * _tmp40_) + 4;
	_tmp41_ = self->priv->off_texture;
	_tmp42_ = clutter_actor_get_height ((ClutterActor*) _tmp41_);
	_tmp43_ = _tmp42_;
	real_board_height = (5 * _tmp43_) + 4;
	_tmp44_ = level;
	self->priv->current_level = _tmp44_;
	_tmp45_ = self->priv->current_level;
	_tmp46_ = game_view_create_board_view (self, _tmp45_);
	_g_object_unref0 (self->priv->board_view);
	self->priv->board_view = _tmp46_;
	_tmp47_ = self->priv->board_view;
	_tmp47_->playable = TRUE;
	_tmp48_ = self->priv->board_view;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp48_);
	_tmp49_ = self->priv->backing_texture;
	_tmp50_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp49_);
	_tmp51_ = (ClutterActor*) g_object_ref_sink (_tmp50_);
	_g_object_unref0 (self->priv->backing_view);
	self->priv->backing_view = _tmp51_;
	_tmp52_ = self->priv->backing_view;
	clutter_actor_set_position (_tmp52_, (gfloat) 0, real_board_height);
	_tmp53_ = self->priv->backing_view;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp53_);
	_tmp54_ = self->priv->led_back_texture;
	_tmp55_ = led_array_new (5, (ClutterActor*) _tmp54_);
	_tmp56_ = g_object_ref_sink (_tmp55_);
	_g_object_unref0 (self->priv->score_view);
	self->priv->score_view = _tmp56_;
	_tmp57_ = self->priv->score_view;
	_tmp58_ = self->priv->current_level;
	led_array_set_value (_tmp57_, _tmp58_);
	_tmp59_ = self->priv->score_view;
	_tmp60_ = self->priv->score_view;
	_tmp61_ = clutter_actor_get_width ((ClutterActor*) _tmp60_);
	_tmp62_ = _tmp61_;
	clutter_actor_set_anchor_point ((ClutterActor*) _tmp59_, _tmp62_ / 2, (gfloat) 0);
	_tmp63_ = self->priv->score_view;
	clutter_actor_set_position ((ClutterActor*) _tmp63_, real_board_width / 2, real_board_height + 18);
	_tmp64_ = self->priv->score_view;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp64_);
	_tmp65_ = self->priv->score_view;
	_tmp66_ = clutter_actor_get_y ((ClutterActor*) _tmp65_);
	_tmp67_ = _tmp66_;
	_tmp68_ = self->priv->score_view;
	_tmp69_ = clutter_actor_get_height ((ClutterActor*) _tmp68_);
	_tmp70_ = _tmp69_;
	clutter_actor_set_size ((ClutterActor*) self, real_board_width, _tmp67_ + _tmp70_);
	_tmp71_ = self->priv->arrow_texture;
	_tmp72_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp71_);
	_tmp73_ = (ClutterActor*) g_object_ref_sink (_tmp72_);
	_g_object_unref0 (self->priv->left_arrow);
	self->priv->left_arrow = _tmp73_;
	_tmp74_ = self->priv->left_arrow;
	g_object_set (_tmp74_, "anchor-gravity", CLUTTER_GRAVITY_CENTER, NULL);
	_tmp75_ = self->priv->left_arrow;
	clutter_actor_set_reactive (_tmp75_, TRUE);
	_tmp76_ = self->priv->left_arrow;
	g_signal_connect_object (_tmp76_, "button-release-event", (GCallback) _game_view_left_arrow_button_release_cb_clutter_actor_button_release_event, self, 0);
	_tmp77_ = self->priv->left_arrow;
	_tmp78_ = self->priv->score_view;
	_tmp79_ = clutter_actor_get_x ((ClutterActor*) _tmp78_);
	_tmp80_ = _tmp79_;
	_tmp81_ = self->priv->score_view;
	g_object_get ((ClutterActor*) _tmp81_, "anchor-x", &_tmp82_, NULL);
	_tmp83_ = _tmp82_;
	_tmp84_ = self->priv->score_view;
	_tmp85_ = clutter_actor_get_y ((ClutterActor*) _tmp84_);
	_tmp86_ = _tmp85_;
	_tmp87_ = self->priv->score_view;
	_tmp88_ = clutter_actor_get_height ((ClutterActor*) _tmp87_);
	_tmp89_ = _tmp88_;
	clutter_actor_set_position (_tmp77_, (_tmp80_ - _tmp83_) / 2, (_tmp86_ + (_tmp89_ / 2)) - 10);
	_tmp90_ = self->priv->left_arrow;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp90_);
	_tmp91_ = self->priv->arrow_texture;
	_tmp92_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp91_);
	_tmp93_ = (ClutterActor*) g_object_ref_sink (_tmp92_);
	_g_object_unref0 (self->priv->right_arrow);
	self->priv->right_arrow = _tmp93_;
	_tmp94_ = self->priv->right_arrow;
	g_object_set (_tmp94_, "anchor-gravity", CLUTTER_GRAVITY_CENTER, NULL);
	_tmp95_ = self->priv->right_arrow;
	clutter_actor_set_reactive (_tmp95_, TRUE);
	_tmp96_ = self->priv->right_arrow;
	g_signal_connect_object (_tmp96_, "button-release-event", (GCallback) _game_view_right_arrow_button_release_cb_clutter_actor_button_release_event, self, 0);
	_tmp97_ = self->priv->right_arrow;
	g_object_set (_tmp97_, "rotation-angle-y", (gdouble) 180, NULL);
	_tmp98_ = self->priv->right_arrow;
	_tmp99_ = self->priv->left_arrow;
	_tmp100_ = clutter_actor_get_x (_tmp99_);
	_tmp101_ = _tmp100_;
	_tmp102_ = self->priv->score_view;
	_tmp103_ = clutter_actor_get_y ((ClutterActor*) _tmp102_);
	_tmp104_ = _tmp103_;
	_tmp105_ = self->priv->score_view;
	_tmp106_ = clutter_actor_get_height ((ClutterActor*) _tmp105_);
	_tmp107_ = _tmp106_;
	clutter_actor_set_position (_tmp98_, real_board_width - _tmp101_, (_tmp104_ + (_tmp107_ / 2)) - 10);
	_tmp108_ = self->priv->right_arrow;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp108_);
	_tmp109_ = self->priv->highlight_texture;
	_tmp110_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp109_);
	_tmp111_ = (ClutterActor*) g_object_ref_sink (_tmp110_);
	_g_object_unref0 (self->priv->key_cursor_view);
	self->priv->key_cursor_view = _tmp111_;
	_tmp112_ = self->priv->key_cursor_view;
	clutter_actor_set_position (_tmp112_, (gfloat) (-100), (gfloat) (-100));
	_tmp113_ = self->priv->key_cursor_view;
	g_object_set (_tmp113_, "anchor-gravity", CLUTTER_GRAVITY_CENTER, NULL);
	_tmp114_ = self->priv->key_cursor_view;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp114_);
	return self;
}


GameView* game_view_new (gint level) {
	return game_view_construct (TYPE_GAME_VIEW, level);
}


static void _game_view_game_won_cb_board_view_game_won (BoardView* _sender, gpointer self) {
	game_view_game_won_cb (self);
}


static BoardView* game_view_create_board_view (GameView* self, gint level) {
	BoardView* result = NULL;
	ClutterTexture* _tmp0_;
	ClutterTexture* _tmp1_;
	BoardView* _tmp2_;
	BoardView* _tmp3_;
	BoardView* view;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->off_texture;
	_tmp1_ = self->priv->on_texture;
	_tmp2_ = board_view_new (_tmp0_, _tmp1_);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	view = _tmp3_;
	_tmp4_ = level;
	board_view_load_level (view, _tmp4_);
	g_signal_connect_object (view, "game-won", (GCallback) _game_view_game_won_cb_board_view_game_won, self, 0);
	view->playable = FALSE;
	result = view;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void game_view_transition_complete_cb (GameView* self) {
	BoardView* _tmp0_;
	BoardView* _tmp1_;
	BoardView* _tmp2_;
	BoardView* _tmp3_;
	ClutterActor* _tmp4_;
	GList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->board_view;
	clutter_container_remove_actor ((ClutterContainer*) self, (ClutterActor*) _tmp0_);
	_tmp1_ = self->priv->new_board_view;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->board_view);
	self->priv->board_view = _tmp2_;
	_tmp3_ = self->priv->board_view;
	_tmp3_->playable = TRUE;
	_tmp4_ = self->priv->key_cursor_view;
	clutter_actor_raise_top (_tmp4_);
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = NULL;
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = NULL;
	_tmp5_ = self->priv->actor_remove_queue;
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp5_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* _tmp6_;
			ClutterActor* actor = NULL;
			_tmp6_ = _g_object_ref0 ((ClutterActor*) actor_it->data);
			actor = _tmp6_;
			{
				ClutterActor* _tmp7_;
				ClutterActor* _tmp8_ = NULL;
				ClutterActor* _tmp9_;
				ClutterActor* _tmp10_ = NULL;
				ClutterGroup* _tmp11_;
				ClutterGroup* group;
				ClutterGroup* _tmp12_;
				ClutterActor* _tmp13_;
				_tmp7_ = actor;
				_tmp8_ = clutter_actor_get_parent (_tmp7_);
				if (_tmp8_ == NULL) {
					_g_object_unref0 (actor);
					continue;
				}
				_tmp9_ = actor;
				_tmp10_ = clutter_actor_get_parent (_tmp9_);
				_tmp11_ = _g_object_ref0 (CLUTTER_GROUP (_tmp10_));
				group = _tmp11_;
				_tmp12_ = group;
				_tmp13_ = actor;
				clutter_container_remove_actor ((ClutterContainer*) _tmp12_, _tmp13_);
				_g_object_unref0 (group);
				_g_object_unref0 (actor);
			}
		}
	}
	__g_list_free__g_object_unref0_0 (self->priv->actor_remove_queue);
	self->priv->actor_remove_queue = NULL;
}


static void _game_view_transition_complete_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
	game_view_transition_complete_cb (self);
}


static void game_view_game_won_cb (GameView* self) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_;
	gboolean _tmp4_;
	gint _tmp5_;
	LEDArray* _tmp6_;
	gint _tmp7_;
	gint direction;
	gint sign;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	BoardView* _tmp23_ = NULL;
	BoardView* _tmp24_;
	BoardView* _tmp25_;
	BoardView* _tmp26_;
	ClutterTimeline* _tmp27_;
	BoardView* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	ClutterTimeline* _tmp31_;
	BoardView* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	ClutterTimeline* _tmp35_;
	ClutterTimeline* _tmp36_;
	gint _tmp37_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timeline;
	if (_tmp1_ != NULL) {
		ClutterTimeline* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->timeline;
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->current_level;
	self->priv->current_level = _tmp5_ + 1;
	_tmp6_ = self->priv->score_view;
	_tmp7_ = self->priv->current_level;
	led_array_set_value (_tmp6_, _tmp7_);
	direction = 0;
	sign = 0;
	{
		gboolean _tmp8_;
		_tmp8_ = TRUE;
		while (TRUE) {
			gboolean _tmp9_;
			gint32 _tmp16_ = 0;
			gint _tmp17_ = 0;
			gboolean _tmp18_ = FALSE;
			gint _tmp19_;
			_tmp9_ = _tmp8_;
			if (!_tmp9_) {
				gboolean _tmp10_ = FALSE;
				gint _tmp11_;
				gint _tmp12_;
				gboolean _tmp15_;
				_tmp11_ = self->priv->last_direction;
				_tmp12_ = direction;
				if (_tmp11_ == _tmp12_) {
					_tmp10_ = TRUE;
				} else {
					gint _tmp13_;
					gint _tmp14_;
					_tmp13_ = self->priv->last_sign;
					_tmp14_ = sign;
					_tmp10_ = _tmp13_ == _tmp14_;
				}
				_tmp15_ = _tmp10_;
				if (!_tmp15_) {
					break;
				}
			}
			_tmp8_ = FALSE;
			_tmp16_ = g_random_int_range ((gint32) 0, (gint32) 2);
			direction = (gint) _tmp16_;
			_tmp18_ = g_random_boolean ();
			if (_tmp18_) {
				_tmp17_ = 1;
			} else {
				_tmp17_ = -1;
			}
			_tmp19_ = _tmp17_;
			sign = _tmp19_;
		}
	}
	_tmp20_ = direction;
	self->priv->last_direction = _tmp20_;
	_tmp21_ = sign;
	self->priv->last_sign = _tmp21_;
	_tmp22_ = self->priv->current_level;
	_tmp23_ = game_view_create_board_view (self, _tmp22_);
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = _tmp23_;
	_tmp24_ = self->priv->new_board_view;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp24_);
	_tmp25_ = self->priv->new_board_view;
	_tmp26_ = self->priv->board_view;
	clutter_actor_lower ((ClutterActor*) _tmp25_, (ClutterActor*) _tmp26_);
	_tmp27_ = clutter_timeline_new ((guint) 1500);
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = _tmp27_;
	_tmp28_ = self->priv->new_board_view;
	_tmp29_ = direction;
	_tmp30_ = sign;
	_tmp31_ = self->priv->timeline;
	board_view_slide_in (_tmp28_, _tmp29_, _tmp30_, _tmp31_);
	_tmp32_ = self->priv->board_view;
	_tmp33_ = direction;
	_tmp34_ = sign;
	_tmp35_ = self->priv->timeline;
	board_view_slide_out (_tmp32_, _tmp33_, _tmp34_, _tmp35_);
	_tmp36_ = self->priv->timeline;
	g_signal_connect_object (_tmp36_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
	_tmp37_ = self->priv->current_level;
	g_signal_emit_by_name (self, "level-changed", _tmp37_);
}


static gboolean game_view_left_arrow_button_release_cb (GameView* self, ClutterActor* actor, ClutterButtonEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	game_view_swap_board (self, -1);
	result = FALSE;
	return result;
}


static gboolean game_view_right_arrow_button_release_cb (GameView* self, ClutterActor* actor, ClutterButtonEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	game_view_swap_board (self, 1);
	result = FALSE;
	return result;
}


static void game_view_swap_board (GameView* self, gint direction) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_;
	gboolean _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	LEDArray* _tmp8_;
	gint _tmp9_;
	ClutterTimeline* _tmp10_;
	gint _tmp11_;
	BoardView* _tmp12_ = NULL;
	BoardView* _tmp13_;
	BoardView* _tmp14_;
	BoardView* _tmp15_;
	BoardView* _tmp16_;
	gint _tmp17_;
	BoardView* _tmp18_;
	BoardView* _tmp19_;
	gint _tmp20_;
	ClutterTimeline* _tmp21_;
	BoardView* _tmp22_;
	gint _tmp23_;
	ClutterTimeline* _tmp24_;
	ClutterTimeline* _tmp25_;
	gint _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timeline;
	if (_tmp1_ != NULL) {
		ClutterTimeline* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->timeline;
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->current_level;
	_tmp6_ = direction;
	self->priv->current_level = _tmp5_ + _tmp6_;
	_tmp7_ = self->priv->current_level;
	if (_tmp7_ <= 0) {
		self->priv->current_level = 1;
		return;
	}
	_tmp8_ = self->priv->score_view;
	_tmp9_ = self->priv->current_level;
	led_array_set_value (_tmp8_, _tmp9_);
	_tmp10_ = clutter_timeline_new ((guint) 500);
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = _tmp10_;
	_tmp11_ = self->priv->current_level;
	_tmp12_ = game_view_create_board_view (self, _tmp11_);
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = _tmp12_;
	_tmp13_ = self->priv->new_board_view;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp13_);
	_tmp14_ = self->priv->new_board_view;
	_tmp15_ = self->priv->board_view;
	clutter_actor_lower ((ClutterActor*) _tmp14_, (ClutterActor*) _tmp15_);
	_tmp16_ = self->priv->new_board_view;
	_tmp17_ = direction;
	clutter_actor_set_depth ((ClutterActor*) _tmp16_, (gfloat) ((-250) * _tmp17_));
	_tmp18_ = self->priv->new_board_view;
	clutter_actor_set_opacity ((ClutterActor*) _tmp18_, (guint) 0);
	_tmp19_ = self->priv->new_board_view;
	_tmp20_ = direction;
	_tmp21_ = self->priv->timeline;
	board_view_swap_in (_tmp19_, (gfloat) _tmp20_, _tmp21_);
	_tmp22_ = self->priv->board_view;
	_tmp23_ = direction;
	_tmp24_ = self->priv->timeline;
	board_view_swap_out (_tmp22_, (gfloat) _tmp23_, _tmp24_);
	_tmp25_ = self->priv->timeline;
	g_signal_connect_object (_tmp25_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
	_tmp26_ = self->priv->current_level;
	g_signal_emit_by_name (self, "level-changed", _tmp26_);
}


void game_view_hide_cursor (GameView* self) {
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_cursor_view;
	clutter_actor_raise_top (_tmp0_);
	_tmp1_ = self->priv->key_cursor_view;
	clutter_actor_animate (_tmp1_, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 250, "opacity", 0, NULL);
	self->priv->key_cursor_ready = FALSE;
}


void game_view_move_cursor (GameView* self, gint x_step, gint y_step) {
	gboolean _tmp0_;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	BoardView* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gfloat _tmp16_ = 0.0F;
	gfloat _tmp17_ = 0.0F;
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_cursor_ready;
	if (_tmp0_) {
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_ = 0;
		gint _tmp7_;
		gint _tmp8_ = 0;
		gint _tmp9_;
		gint _tmp10_ = 0;
		gint _tmp11_;
		gint _tmp12_ = 0;
		_tmp1_ = self->priv->key_cursor_x;
		_tmp2_ = x_step;
		self->priv->key_cursor_x = _tmp1_ + _tmp2_;
		_tmp3_ = self->priv->key_cursor_y;
		_tmp4_ = y_step;
		self->priv->key_cursor_y = _tmp3_ + _tmp4_;
		_tmp5_ = self->priv->key_cursor_x;
		_tmp6_ = MAX (_tmp5_, 0);
		self->priv->key_cursor_x = _tmp6_;
		_tmp7_ = self->priv->key_cursor_x;
		_tmp8_ = MIN (_tmp7_, 4);
		self->priv->key_cursor_x = _tmp8_;
		_tmp9_ = self->priv->key_cursor_y;
		_tmp10_ = MAX (_tmp9_, 0);
		self->priv->key_cursor_y = _tmp10_;
		_tmp11_ = self->priv->key_cursor_y;
		_tmp12_ = MIN (_tmp11_, 4);
		self->priv->key_cursor_y = _tmp12_;
	}
	_tmp13_ = self->priv->board_view;
	_tmp14_ = self->priv->key_cursor_x;
	_tmp15_ = self->priv->key_cursor_y;
	board_view_get_light_position (_tmp13_, _tmp14_, _tmp15_, &_tmp16_, &_tmp17_);
	x = _tmp16_;
	y = _tmp17_;
	_tmp18_ = self->priv->key_cursor_ready;
	if (_tmp18_) {
		ClutterActor* _tmp19_;
		gfloat _tmp20_;
		gfloat _tmp21_;
		_tmp19_ = self->priv->key_cursor_view;
		_tmp20_ = x;
		_tmp21_ = y;
		clutter_actor_animate (_tmp19_, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 250, "x", _tmp20_, "y", _tmp21_, NULL);
	} else {
		ClutterActor* _tmp22_;
		ClutterActor* _tmp23_;
		gfloat _tmp24_;
		gfloat _tmp25_;
		ClutterActor* _tmp26_;
		_tmp22_ = self->priv->key_cursor_view;
		clutter_actor_set_opacity (_tmp22_, (guint) 0);
		_tmp23_ = self->priv->key_cursor_view;
		_tmp24_ = x;
		_tmp25_ = y;
		clutter_actor_set_position (_tmp23_, _tmp24_, _tmp25_);
		_tmp26_ = self->priv->key_cursor_view;
		clutter_actor_animate (_tmp26_, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 250, "opacity", 255, NULL);
	}
	self->priv->key_cursor_ready = TRUE;
}


void game_view_activate_cursor (GameView* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_cursor_ready;
	if (_tmp0_) {
		BoardView* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->board_view;
		_tmp2_ = self->priv->key_cursor_x;
		_tmp3_ = self->priv->key_cursor_y;
		board_view_toggle_light (_tmp1_, _tmp2_, _tmp3_, TRUE);
	}
}


void game_view_reset_game (GameView* self) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_;
	gboolean _tmp4_;
	LEDArray* _tmp5_;
	gint _tmp6_;
	ClutterTimeline* _tmp7_;
	gint _tmp8_;
	BoardView* _tmp9_ = NULL;
	BoardView* _tmp10_;
	BoardView* _tmp11_;
	BoardView* _tmp12_;
	BoardView* _tmp13_;
	BoardView* _tmp14_;
	BoardView* _tmp15_;
	ClutterTimeline* _tmp16_;
	BoardView* _tmp17_;
	ClutterTimeline* _tmp18_;
	ClutterTimeline* _tmp19_;
	gint _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timeline;
	if (_tmp1_ != NULL) {
		ClutterTimeline* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->timeline;
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		return;
	}
	self->priv->current_level = 1;
	_tmp5_ = self->priv->score_view;
	_tmp6_ = self->priv->current_level;
	led_array_set_value (_tmp5_, _tmp6_);
	_tmp7_ = clutter_timeline_new ((guint) 500);
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = _tmp7_;
	_tmp8_ = self->priv->current_level;
	_tmp9_ = game_view_create_board_view (self, _tmp8_);
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = _tmp9_;
	_tmp10_ = self->priv->new_board_view;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp10_);
	_tmp11_ = self->priv->new_board_view;
	_tmp12_ = self->priv->board_view;
	clutter_actor_lower ((ClutterActor*) _tmp11_, (ClutterActor*) _tmp12_);
	_tmp13_ = self->priv->new_board_view;
	clutter_actor_set_depth ((ClutterActor*) _tmp13_, (gfloat) 250);
	_tmp14_ = self->priv->new_board_view;
	clutter_actor_set_opacity ((ClutterActor*) _tmp14_, (guint) 0);
	_tmp15_ = self->priv->new_board_view;
	_tmp16_ = self->priv->timeline;
	board_view_swap_in (_tmp15_, (gfloat) (-1), _tmp16_);
	_tmp17_ = self->priv->board_view;
	_tmp18_ = self->priv->timeline;
	board_view_swap_out (_tmp17_, (gfloat) (-1), _tmp18_);
	_tmp19_ = self->priv->timeline;
	g_signal_connect_object (_tmp19_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
	_tmp20_ = self->priv->current_level;
	g_signal_emit_by_name (self, "level-changed", _tmp20_);
}


static void game_view_class_init (GameViewClass * klass) {
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_signal_new ("level_changed", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}


static void game_view_instance_init (GameView * self) {
	self->priv = GAME_VIEW_GET_PRIVATE (self);
	self->priv->actor_remove_queue = NULL;
	self->priv->new_board_view = NULL;
	self->priv->key_cursor_x = 0;
	self->priv->key_cursor_y = 0;
	self->priv->key_cursor_ready = FALSE;
	self->priv->last_direction = 0;
	self->priv->last_sign = 0;
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
	self = GAME_VIEW (obj);
	_g_object_unref0 (self->priv->backing_texture);
	_g_object_unref0 (self->priv->highlight_texture);
	_g_object_unref0 (self->priv->off_texture);
	_g_object_unref0 (self->priv->on_texture);
	_g_object_unref0 (self->priv->led_back_texture);
	_g_object_unref0 (self->priv->arrow_texture);
	__g_list_free__g_object_unref0_0 (self->priv->actor_remove_queue);
	_g_object_unref0 (self->priv->score_view);
	_g_object_unref0 (self->priv->board_view);
	_g_object_unref0 (self->priv->new_board_view);
	_g_object_unref0 (self->priv->backing_view);
	_g_object_unref0 (self->priv->left_arrow);
	_g_object_unref0 (self->priv->right_arrow);
	_g_object_unref0 (self->priv->key_cursor_view);
	_g_object_unref0 (self->priv->timeline);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (clutter_group_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}



