/* rygel-http-gst-sink.c generated by valac 0.14.0, the Vala compiler
 * generated from rygel-http-gst-sink.vala, do not modify */

/*
 * Copyright (C) 2011 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/base/gstbasesink.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_HTTP_GST_SINK (rygel_http_gst_sink_get_type ())
#define RYGEL_HTTP_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSink))
#define RYGEL_HTTP_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSinkClass))
#define RYGEL_IS_HTTP_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GST_SINK))
#define RYGEL_IS_HTTP_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GST_SINK))
#define RYGEL_HTTP_GST_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSinkClass))

typedef struct _RygelHTTPGstSink RygelHTTPGstSink;
typedef struct _RygelHTTPGstSinkClass RygelHTTPGstSinkClass;
typedef struct _RygelHTTPGstSinkPrivate RygelHTTPGstSinkPrivate;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_mutex_free0(var) ((var == NULL) ? NULL : (var = (g_mutex_free (var), NULL)))
#define _g_cond_free0(var) ((var == NULL) ? NULL : (var = (g_cond_free (var), NULL)))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;
typedef struct _Block4Data Block4Data;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _gst_buffer_unref0(var) ((var == NULL) ? NULL : (var = (gst_buffer_unref (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))

struct _RygelHTTPGstSink {
	GstBaseSink parent_instance;
	RygelHTTPGstSinkPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelHTTPGstSinkClass {
	GstBaseSinkClass parent_class;
};

struct _RygelHTTPGstSinkPrivate {
	RygelHTTPResponse* response;
	gint priority;
	gint64 chunks_buffered;
	gint64 bytes_sent;
	gint64 max_bytes;
	GMutex* buffer_mutex;
	GCond* buffer_condition;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
	SoupMessage* msg;
	RygelHTTPSeek* seek;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
	void (*end) (RygelHTTPResponse* self, gboolean aborted, guint status);
};

struct _Block4Data {
	int _ref_count_;
	RygelHTTPGstSink * self;
	GstBuffer* buffer;
};


static gpointer rygel_http_gst_sink_parent_class = NULL;

GType rygel_http_gst_sink_get_type (void) G_GNUC_CONST;
GType rygel_http_response_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GST_SINK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSinkPrivate))
enum  {
	RYGEL_HTTP_GST_SINK_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GST_SINK_NAME "http-gst-sink"
#define RYGEL_HTTP_GST_SINK_PAD_NAME "sink"
#define RYGEL_HTTP_GST_SINK_MAX_BUFFERED_CHUNKS ((guint) 32)
#define RYGEL_HTTP_GST_SINK_MIN_BUFFERED_CHUNKS ((guint) 4)
RygelHTTPGstSink* rygel_http_gst_sink_new (RygelHTTPResponse* response);
RygelHTTPGstSink* rygel_http_gst_sink_construct (GType object_type, RygelHTTPResponse* response);
gint rygel_http_response_get_priority (RygelHTTPResponse* self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
static void rygel_http_gst_sink_on_cancelled (RygelHTTPGstSink* self);
static void _rygel_http_gst_sink_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static void rygel_http_gst_sink_on_wrote_chunk (RygelHTTPGstSink* self, SoupMessage* msg);
static void _rygel_http_gst_sink_on_wrote_chunk_soup_message_wrote_chunk (SoupMessage* _sender, gpointer self);
static GstFlowReturn rygel_http_gst_sink_real_render (GstBaseSink* base, GstBuffer* buffer);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static gboolean __lambda2_ (Block4Data* _data4_);
gboolean rygel_http_gst_sink_push_data (RygelHTTPGstSink* self, GstBuffer* buffer);
static gboolean ___lambda2__gsource_func (gpointer self);
void rygel_http_response_push_data (RygelHTTPResponse* self, guint8* data, int data_length1);
static void rygel_http_gst_sink_finalize (GObject* obj);


static void _rygel_http_gst_sink_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
	rygel_http_gst_sink_on_cancelled (self);
}


static void _rygel_http_gst_sink_on_wrote_chunk_soup_message_wrote_chunk (SoupMessage* _sender, gpointer self) {
	rygel_http_gst_sink_on_wrote_chunk (self, _sender);
}


RygelHTTPGstSink* rygel_http_gst_sink_construct (GType object_type, RygelHTTPResponse* response) {
	RygelHTTPGstSink * self = NULL;
	gint64 _tmp0_;
	GMutex* _tmp1_;
	GCond* _tmp2_;
	GCancellable* _tmp3_;
	RygelHTTPResponse* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	RygelHTTPResponse* _tmp7_;
	RygelHTTPResponse* _tmp8_;
	RygelHTTPSeek* _tmp9_;
	GCancellable* _tmp16_;
	RygelHTTPResponse* _tmp17_;
	SoupMessage* _tmp18_;
	g_return_val_if_fail (response != NULL, NULL);
	self = (RygelHTTPGstSink*) g_object_new (object_type, NULL);
	self->priv->chunks_buffered = (gint64) 0;
	self->priv->bytes_sent = (gint64) 0;
	_tmp0_ = G_MAXINT64;
	self->priv->max_bytes = _tmp0_;
	_tmp1_ = g_mutex_new ();
	_g_mutex_free0 (self->priv->buffer_mutex);
	self->priv->buffer_mutex = _tmp1_;
	_tmp2_ = g_cond_new ();
	_g_cond_free0 (self->priv->buffer_condition);
	self->priv->buffer_condition = _tmp2_;
	_tmp3_ = g_cancellable_new ();
	_g_object_unref0 (self->cancellable);
	self->cancellable = _tmp3_;
	_tmp4_ = response;
	_tmp5_ = rygel_http_response_get_priority (_tmp4_);
	_tmp6_ = _tmp5_;
	self->priv->priority = _tmp6_;
	_tmp7_ = response;
	self->priv->response = _tmp7_;
	gst_base_sink_set_sync ((GstBaseSink*) self, FALSE);
	gst_object_set_name ((GstObject*) self, RYGEL_HTTP_GST_SINK_NAME);
	_tmp8_ = response;
	_tmp9_ = _tmp8_->seek;
	if (_tmp9_ != NULL) {
		RygelHTTPResponse* _tmp10_;
		RygelHTTPSeek* _tmp11_;
		_tmp10_ = response;
		_tmp11_ = _tmp10_->seek;
		if (RYGEL_IS_HTTP_BYTE_SEEK (_tmp11_)) {
			RygelHTTPResponse* _tmp12_;
			RygelHTTPSeek* _tmp13_;
			gint64 _tmp14_;
			gint64 _tmp15_;
			_tmp12_ = response;
			_tmp13_ = _tmp12_->seek;
			_tmp14_ = rygel_http_seek_get_length (_tmp13_);
			_tmp15_ = _tmp14_;
			self->priv->max_bytes = _tmp15_;
		}
	}
	_tmp16_ = self->cancellable;
	g_signal_connect_object (_tmp16_, "cancelled", (GCallback) _rygel_http_gst_sink_on_cancelled_g_cancellable_cancelled, self, 0);
	_tmp17_ = response;
	_tmp18_ = _tmp17_->msg;
	g_signal_connect_object (_tmp18_, "wrote-chunk", (GCallback) _rygel_http_gst_sink_on_wrote_chunk_soup_message_wrote_chunk, self, 0);
	return self;
}


RygelHTTPGstSink* rygel_http_gst_sink_new (RygelHTTPResponse* response) {
	return rygel_http_gst_sink_construct (RYGEL_TYPE_HTTP_GST_SINK, response);
}


static gpointer _gst_buffer_ref0 (gpointer self) {
	return self ? gst_buffer_ref (self) : NULL;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_gst_object_unref0 (_data4_->self);
		_gst_buffer_unref0 (_data4_->buffer);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean __lambda2_ (Block4Data* _data4_) {
	RygelHTTPGstSink * self;
	gboolean result = FALSE;
	GstBuffer* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = _data4_->self;
	_tmp0_ = _data4_->buffer;
	_tmp1_ = rygel_http_gst_sink_push_data (self, _tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean ___lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda2_ (self);
	return result;
}


static GstFlowReturn rygel_http_gst_sink_real_render (GstBaseSink* base, GstBuffer* buffer) {
	RygelHTTPGstSink * self;
	GstFlowReturn result = 0;
	Block4Data* _data4_;
	GstBuffer* _tmp0_;
	GstBuffer* _tmp1_;
	GMutex* _tmp2_;
	GMutex* _tmp10_;
	GCancellable* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gint _tmp13_;
	self = (RygelHTTPGstSink*) base;
	g_return_val_if_fail (buffer != NULL, 0);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = gst_object_ref (self);
	_tmp0_ = buffer;
	_tmp1_ = _gst_buffer_ref0 (_tmp0_);
	_data4_->buffer = _tmp1_;
	_tmp2_ = self->priv->buffer_mutex;
	g_mutex_lock (_tmp2_);
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		GCancellable* _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp7_;
		GCond* _tmp8_;
		GMutex* _tmp9_;
		_tmp4_ = self->cancellable;
		_tmp5_ = g_cancellable_is_cancelled (_tmp4_);
		if (!_tmp5_) {
			gint64 _tmp6_;
			_tmp6_ = self->priv->chunks_buffered;
			_tmp3_ = _tmp6_ > ((gint64) RYGEL_HTTP_GST_SINK_MAX_BUFFERED_CHUNKS);
		} else {
			_tmp3_ = FALSE;
		}
		_tmp7_ = _tmp3_;
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = self->priv->buffer_condition;
		_tmp9_ = self->priv->buffer_mutex;
		g_cond_wait (_tmp8_, _tmp9_);
	}
	_tmp10_ = self->priv->buffer_mutex;
	g_mutex_unlock (_tmp10_);
	_tmp11_ = self->cancellable;
	_tmp12_ = g_cancellable_is_cancelled (_tmp11_);
	if (_tmp12_) {
		result = GST_FLOW_OK;
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return result;
	}
	_tmp13_ = self->priv->priority;
	g_idle_add_full (_tmp13_, ___lambda2__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	result = GST_FLOW_OK;
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return result;
}


gboolean rygel_http_gst_sink_push_data (RygelHTTPGstSink* self, GstBuffer* buffer) {
	gboolean result = FALSE;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 left;
	gboolean _tmp2_ = FALSE;
	GCancellable* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_;
	GstBuffer* _tmp7_;
	guint _tmp8_;
	gint64 _tmp9_;
	gint64 _tmp10_ = 0LL;
	gint64 to_send;
	RygelHTTPResponse* _tmp11_;
	GstBuffer* _tmp12_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	gint64 _tmp14_;
	gint64 _tmp15_;
	gint64 _tmp16_;
	gint64 _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (buffer != NULL, FALSE);
	_tmp0_ = self->priv->max_bytes;
	_tmp1_ = self->priv->bytes_sent;
	left = _tmp0_ - _tmp1_;
	_tmp3_ = self->cancellable;
	_tmp4_ = g_cancellable_is_cancelled (_tmp3_);
	if (_tmp4_) {
		_tmp2_ = TRUE;
	} else {
		gint64 _tmp5_;
		_tmp5_ = left;
		_tmp2_ = _tmp5_ <= ((gint64) 0);
	}
	_tmp6_ = _tmp2_;
	if (_tmp6_) {
		result = FALSE;
		return result;
	}
	_tmp7_ = buffer;
	_tmp8_ = _tmp7_->size;
	_tmp9_ = left;
	_tmp10_ = MIN ((gint64) _tmp8_, _tmp9_);
	to_send = _tmp10_;
	_tmp11_ = self->priv->response;
	_tmp12_ = buffer;
	_tmp13_ = _tmp12_->data;
	_tmp13__length1 = (gint) _tmp12_->size;
	_tmp14_ = to_send;
	rygel_http_response_push_data (_tmp11_, _tmp13_ + 0, _tmp14_ - 0);
	_tmp15_ = self->priv->chunks_buffered;
	self->priv->chunks_buffered = _tmp15_ + 1;
	_tmp16_ = self->priv->bytes_sent;
	_tmp17_ = to_send;
	self->priv->bytes_sent = _tmp16_ + _tmp17_;
	result = FALSE;
	return result;
}


static void rygel_http_gst_sink_on_wrote_chunk (RygelHTTPGstSink* self, SoupMessage* msg) {
	GMutex* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	GMutex* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = self->priv->buffer_mutex;
	g_mutex_lock (_tmp0_);
	_tmp1_ = self->priv->chunks_buffered;
	self->priv->chunks_buffered = _tmp1_ - 1;
	_tmp2_ = self->priv->chunks_buffered;
	if (_tmp2_ < ((gint64) RYGEL_HTTP_GST_SINK_MIN_BUFFERED_CHUNKS)) {
		GCond* _tmp3_;
		_tmp3_ = self->priv->buffer_condition;
		g_cond_broadcast (_tmp3_);
	}
	_tmp4_ = self->priv->buffer_mutex;
	g_mutex_unlock (_tmp4_);
}


static void rygel_http_gst_sink_on_cancelled (RygelHTTPGstSink* self) {
	GMutex* _tmp0_;
	GCond* _tmp1_;
	GMutex* _tmp2_;
	RygelHTTPResponse* _tmp3_;
	SoupMessage* _tmp4_;
	guint _tmp5_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->buffer_mutex;
	g_mutex_lock (_tmp0_);
	_tmp1_ = self->priv->buffer_condition;
	g_cond_broadcast (_tmp1_);
	_tmp2_ = self->priv->buffer_mutex;
	g_mutex_unlock (_tmp2_);
	_tmp3_ = self->priv->response;
	_tmp4_ = _tmp3_->msg;
	g_signal_parse_name ("wrote-chunk", soup_message_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _rygel_http_gst_sink_on_wrote_chunk_soup_message_wrote_chunk, self);
}


static gpointer _gst_caps_ref0 (gpointer self) {
	return self ? gst_caps_ref (self) : NULL;
}


static void rygel_http_gst_sink_class_init (RygelHTTPGstSinkClass * klass) {
	GstCaps* _tmp0_;
	GstCaps* caps;
	GstCaps* _tmp1_;
	GstCaps* _tmp2_;
	GstPadTemplate* _tmp3_;
	GstPadTemplate* template;
	GstPadTemplate* _tmp4_;
	rygel_http_gst_sink_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPGstSinkPrivate));
	GST_BASE_SINK_CLASS (klass)->render = rygel_http_gst_sink_real_render;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_gst_sink_finalize;
	_tmp0_ = gst_caps_new_any ();
	caps = _tmp0_;
	_tmp1_ = caps;
	_tmp2_ = _gst_caps_ref0 (_tmp1_);
	_tmp3_ = gst_pad_template_new (RYGEL_HTTP_GST_SINK_PAD_NAME, GST_PAD_SINK, GST_PAD_ALWAYS, _tmp2_);
	gst_object_ref_sink (_tmp3_);
	template = _tmp3_;
	_tmp4_ = template;
	gst_element_class_add_pad_template (GST_ELEMENT_CLASS (klass), _tmp4_);
	_gst_object_unref0 (template);
	_gst_caps_unref0 (caps);
}


static void rygel_http_gst_sink_instance_init (RygelHTTPGstSink * self) {
	self->priv = RYGEL_HTTP_GST_SINK_GET_PRIVATE (self);
}


static void rygel_http_gst_sink_finalize (GObject* obj) {
	RygelHTTPGstSink * self;
	self = RYGEL_HTTP_GST_SINK (obj);
	_g_object_unref0 (self->cancellable);
	_g_mutex_free0 (self->priv->buffer_mutex);
	_g_cond_free0 (self->priv->buffer_condition);
	G_OBJECT_CLASS (rygel_http_gst_sink_parent_class)->finalize (obj);
}


GType rygel_http_gst_sink_get_type (void) {
	static volatile gsize rygel_http_gst_sink_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_gst_sink_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGstSinkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_gst_sink_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGstSink), 0, (GInstanceInitFunc) rygel_http_gst_sink_instance_init, NULL };
		GType rygel_http_gst_sink_type_id;
		rygel_http_gst_sink_type_id = g_type_register_static (GST_TYPE_BASE_SINK, "RygelHTTPGstSink", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_gst_sink_type_id__volatile, rygel_http_gst_sink_type_id);
	}
	return rygel_http_gst_sink_type_id__volatile;
}



