/* rygel-playbin-player.c generated by valac 0.14.0, the Vala compiler
 * generated from rygel-playbin-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_PLAYBIN_TYPE_PLAYER (rygel_playbin_player_get_type ())
#define RYGEL_PLAYBIN_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer))
#define RYGEL_PLAYBIN_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))
#define RYGEL_PLAYBIN_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))

typedef struct _RygelPlaybinPlayer RygelPlaybinPlayer;
typedef struct _RygelPlaybinPlayerClass RygelPlaybinPlayerClass;
typedef struct _RygelPlaybinPlayerPrivate RygelPlaybinPlayerPrivate;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelPlaybinPlayer {
	GObject parent_instance;
	RygelPlaybinPlayerPrivate * priv;
};

struct _RygelPlaybinPlayerClass {
	GObjectClass parent_class;
};

struct _RygelPlaybinPlayerPrivate {
	GstElement* playbin;
	gchar* _playback_state;
};


static gpointer rygel_playbin_player_parent_class = NULL;
static RygelPlaybinPlayer* rygel_playbin_player_player;
static RygelPlaybinPlayer* rygel_playbin_player_player = NULL;
static RygelMediaPlayerIface* rygel_playbin_player_rygel_media_player_parent_iface = NULL;

GType rygel_playbin_player_get_type (void) G_GNUC_CONST;
#define RYGEL_PLAYBIN_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerPrivate))
enum  {
	RYGEL_PLAYBIN_PLAYER_DUMMY_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE,
	RYGEL_PLAYBIN_PLAYER_URI,
	RYGEL_PLAYBIN_PLAYER_VOLUME,
	RYGEL_PLAYBIN_PLAYER_DURATION,
	RYGEL_PLAYBIN_PLAYER_POSITION
};
static RygelPlaybinPlayer* rygel_playbin_player_new (void);
static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type);
static gboolean rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message);
static gboolean _rygel_playbin_player_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
RygelPlaybinPlayer* rygel_playbin_player_get_default (void);
static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, GstClockTime time);
static gchar** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
static inline gchar* _dynamic_get_uri0 (GstElement* obj);
static inline void _dynamic_set_uri1 (GstElement* obj, const gchar* value);
static inline gdouble _dynamic_get_volume2 (GstElement* obj);
static inline void _dynamic_set_volume3 (GstElement* obj, gdouble value);
static void rygel_playbin_player_finalize (GObject* obj);
static void _vala_rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* RYGEL_PLAYBIN_PLAYER_protocols[2] = {"http-get", "rtsp"};
static const gchar* RYGEL_PLAYBIN_PLAYER_mime_types[27] = {"audio/mpeg", "application/ogg", "audio/x-vorbis", "audio/x-vorbis+ogg", "audio/x-ms-wma", "audio/x-ms-asf", "audio/x-flac", "audio/x-mod", "audio/x-wav", "audio/x-ac3", "audio/x-m4a", "video/x-theora", "video/x-dirac", "video/x-wmv", "video/x-wma", "video/x-msvideo", "video/x-3ivx", "video/x-3ivx", "video/x-matroska", "video/x-mkv", "video/mpeg", "video/mp4", "video/x-ms-asf", "video/x-xvid", "video/x-ms-wmv", "audio/L16;rate=44100;channels=2", "audio/L16;rate=44100;channels=1"};

static gboolean _rygel_playbin_player_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = rygel_playbin_player_bus_handler (self, bus, message);
#line 142 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	return result;
#line 107 "rygel-playbin-player.c"
}


static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type) {
	RygelPlaybinPlayer * self = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_;
	GstElement* _tmp2_;
	GstBus* _tmp3_ = NULL;
	GstBus* bus;
#line 136 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) g_object_new (object_type, NULL);
#line 137 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp0_ = gst_element_factory_make ("playbin2", NULL);
#line 137 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_gst_object_unref0 (self->priv->playbin);
#line 137 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	self->priv->playbin = _tmp0_;
#line 138 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp1_ = self->priv->playbin;
#line 138 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_assert (_tmp1_ != NULL);
#line 141 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp2_ = self->priv->playbin;
#line 141 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp3_ = gst_element_get_bus (_tmp2_);
#line 141 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	bus = _tmp3_;
#line 142 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	gst_bus_add_watch_full (bus, G_PRIORITY_DEFAULT, _rygel_playbin_player_bus_handler_gst_bus_func, g_object_ref (self), g_object_unref);
#line 136 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_gst_object_unref0 (bus);
#line 136 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	return self;
#line 142 "rygel-playbin-player.c"
}


static RygelPlaybinPlayer* rygel_playbin_player_new (void) {
#line 136 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	return rygel_playbin_player_construct (RYGEL_PLAYBIN_TYPE_PLAYER);
#line 149 "rygel-playbin-player.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 150 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	return self ? g_object_ref (self) : NULL;
#line 156 "rygel-playbin-player.c"
}


RygelPlaybinPlayer* rygel_playbin_player_get_default (void) {
	RygelPlaybinPlayer* result = NULL;
	RygelPlaybinPlayer* _tmp0_;
	RygelPlaybinPlayer* _tmp2_;
	RygelPlaybinPlayer* _tmp3_;
#line 146 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp0_ = rygel_playbin_player_player;
#line 146 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	if (_tmp0_ == NULL) {
#line 169 "rygel-playbin-player.c"
		RygelPlaybinPlayer* _tmp1_;
#line 147 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		_tmp1_ = rygel_playbin_player_new ();
#line 147 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		_g_object_unref0 (rygel_playbin_player_player);
#line 147 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		rygel_playbin_player_player = _tmp1_;
#line 177 "rygel-playbin-player.c"
	}
#line 150 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp2_ = rygel_playbin_player_player;
#line 150 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 150 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	result = _tmp3_;
#line 150 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	return result;
#line 187 "rygel-playbin-player.c"
}


static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, GstClockTime time) {
	RygelPlaybinPlayer * self;
	gboolean result = FALSE;
	GstElement* _tmp0_;
	GstClockTime _tmp1_;
	gboolean _tmp2_ = FALSE;
#line 153 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 154 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp0_ = self->priv->playbin;
#line 154 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp1_ = time;
#line 154 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp2_ = gst_element_seek (_tmp0_, 1.0, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, GST_SEEK_TYPE_SET, (gint64) _tmp1_, GST_SEEK_TYPE_NONE, (gint64) (-1));
#line 154 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	result = _tmp2_;
#line 154 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	return result;
#line 209 "rygel-playbin-player.c"
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
#line 164 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	result = g_new0 (gchar*, length + 1);
#line 164 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	for (i = 0; i < length; i++) {
#line 220 "rygel-playbin-player.c"
		gchar* _tmp0_;
#line 164 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		_tmp0_ = g_strdup (self[i]);
#line 164 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		result[i] = _tmp0_;
#line 226 "rygel-playbin-player.c"
	}
#line 164 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	return result;
#line 230 "rygel-playbin-player.c"
}


static gchar** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1) {
	RygelPlaybinPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
#line 163 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 164 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp0_ = (RYGEL_PLAYBIN_PLAYER_protocols != NULL) ? _vala_array_dup1 (RYGEL_PLAYBIN_PLAYER_protocols, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols)) : ((gpointer) RYGEL_PLAYBIN_PLAYER_protocols);
#line 164 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols);
#line 164 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp1_ = _tmp0_;
#line 164 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp1__length1 = _tmp0__length1;
#line 164 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	if (result_length1) {
#line 164 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		*result_length1 = _tmp1__length1;
#line 255 "rygel-playbin-player.c"
	}
#line 164 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	result = _tmp1_;
#line 164 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	return result;
#line 261 "rygel-playbin-player.c"
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
#line 168 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	result = g_new0 (gchar*, length + 1);
#line 168 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	for (i = 0; i < length; i++) {
#line 272 "rygel-playbin-player.c"
		gchar* _tmp0_;
#line 168 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		_tmp0_ = g_strdup (self[i]);
#line 168 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		result[i] = _tmp0_;
#line 278 "rygel-playbin-player.c"
	}
#line 168 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	return result;
#line 282 "rygel-playbin-player.c"
}


static gchar** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1) {
	RygelPlaybinPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
#line 167 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 168 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp0_ = (RYGEL_PLAYBIN_PLAYER_mime_types != NULL) ? _vala_array_dup2 (RYGEL_PLAYBIN_PLAYER_mime_types, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types)) : ((gpointer) RYGEL_PLAYBIN_PLAYER_mime_types);
#line 168 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types);
#line 168 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp1_ = _tmp0_;
#line 168 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp1__length1 = _tmp0__length1;
#line 168 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	if (result_length1) {
#line 168 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		*result_length1 = _tmp1__length1;
#line 307 "rygel-playbin-player.c"
	}
#line 168 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	result = _tmp1_;
#line 168 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	return result;
#line 313 "rygel-playbin-player.c"
}


static gboolean rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	GstMessage* _tmp0_;
	GstMessageType _tmp1_;
#line 171 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 171 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_return_val_if_fail (bus != NULL, FALSE);
#line 171 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_return_val_if_fail (message != NULL, FALSE);
#line 173 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp0_ = message;
#line 173 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp1_ = _tmp0_->type;
#line 173 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	switch (_tmp1_) {
#line 173 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		case GST_MESSAGE_EOS:
#line 335 "rygel-playbin-player.c"
		{
#line 175 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			g_debug ("rygel-playbin-player.vala:175: EOS");
#line 177 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
#line 179 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			break;
#line 343 "rygel-playbin-player.c"
		}
#line 173 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		case GST_MESSAGE_ERROR:
#line 347 "rygel-playbin-player.c"
		{
			GError* _error_ = NULL;
			gchar* error_message = NULL;
			GstMessage* _tmp2_;
			GError* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			GstElement* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
#line 184 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			_tmp2_ = message;
#line 184 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			gst_message_parse_error (_tmp2_, &_tmp3_, &_tmp4_);
#line 184 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			_g_error_free0 (_error_);
#line 184 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			_error_ = _tmp3_;
#line 184 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			_g_free0 (error_message);
#line 184 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			error_message = _tmp4_;
#line 186 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			_tmp5_ = self->priv->playbin;
#line 186 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			_tmp6_ = gst_object_get_name ((GstObject*) _tmp5_);
#line 186 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			_tmp7_ = _tmp6_;
#line 186 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			_tmp8_ = _tmp7_;
#line 186 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			_tmp9_ = error_message;
#line 186 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			g_warning ("rygel-playbin-player.vala:186: Error from GStreamer element %s: %s", _tmp8_, _tmp9_);
#line 186 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			_g_free0 (_tmp8_);
#line 189 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			g_warning ("rygel-playbin-player.vala:189: Going to STOPPED state");
#line 191 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
#line 193 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			_g_free0 (error_message);
#line 193 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			_g_error_free0 (_error_);
#line 193 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
			break;
#line 395 "rygel-playbin-player.c"
		}
		default:
#line 173 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		break;
#line 400 "rygel-playbin-player.c"
	}
#line 196 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	result = TRUE;
#line 196 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	return result;
#line 406 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_playback_state (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 62 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 63 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playback_state;
#line 63 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 63 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	result = _tmp1_;
#line 63 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	return result;
#line 425 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_playback_state (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
#line 70 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	static GQuark _tmp5_label0 = 0;
#line 70 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	static GQuark _tmp5_label1 = 0;
#line 70 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	static GQuark _tmp5_label2 = 0;
#line 66 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 67 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp0_ = value;
#line 67 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_debug ("rygel-playbin-player.vala:67: Changing playback state to %s.", _tmp0_);
#line 68 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp1_ = value;
#line 68 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 68 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_g_free0 (self->priv->_playback_state);
#line 68 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	self->priv->_playback_state = _tmp2_;
#line 70 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp3_ = self->priv->_playback_state;
#line 70 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp4_ = _tmp3_;
#line 70 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 70 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("STOPPED")))) {
#line 70 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		switch (0) {
#line 467 "rygel-playbin-player.c"
			default:
			{
				GstElement* _tmp7_;
#line 72 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
				_tmp7_ = self->priv->playbin;
#line 72 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
				gst_element_set_state (_tmp7_, GST_STATE_NULL);
#line 73 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
				break;
#line 477 "rygel-playbin-player.c"
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
#line 70 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		switch (0) {
#line 483 "rygel-playbin-player.c"
			default:
			{
				GstElement* _tmp8_;
#line 75 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
				_tmp8_ = self->priv->playbin;
#line 75 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
				gst_element_set_state (_tmp8_, GST_STATE_PAUSED);
#line 76 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
				break;
#line 493 "rygel-playbin-player.c"
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("PLAYING")))) {
#line 70 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		switch (0) {
#line 499 "rygel-playbin-player.c"
			default:
			{
				GstElement* _tmp9_;
#line 78 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
				_tmp9_ = self->priv->playbin;
#line 78 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
				gst_element_set_state (_tmp9_, GST_STATE_PLAYING);
#line 79 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
				break;
#line 509 "rygel-playbin-player.c"
			}
		}
	} else {
#line 70 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		switch (0) {
#line 515 "rygel-playbin-player.c"
			default:
			{
#line 81 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
				break;
#line 520 "rygel-playbin-player.c"
			}
		}
	}
#line 66 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "playback-state");
#line 526 "rygel-playbin-player.c"
}


static inline gchar* _dynamic_get_uri0 (GstElement* obj) {
	gchar* result;
#line 88 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_object_get (obj, "uri", &result, NULL);
#line 88 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	return result;
#line 536 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_uri (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 87 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 88 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp0_ = self->priv->playbin;
#line 88 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp1_ = _dynamic_get_uri0 (_tmp0_);
#line 88 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp2_ = _tmp1_;
#line 88 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	result = _tmp2_;
#line 88 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	return result;
#line 558 "rygel-playbin-player.c"
}


static inline void _dynamic_set_uri1 (GstElement* obj, const gchar* value) {
#line 93 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_object_set (obj, "uri", value, NULL);
#line 565 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_uri (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_;
	GstElement* _tmp1_;
	const gchar* _tmp2_;
	GstElement* _tmp3_;
	const gchar* _tmp4_;
#line 91 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 92 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp0_ = self->priv->playbin;
#line 92 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	gst_element_set_state (_tmp0_, GST_STATE_NULL);
#line 93 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp1_ = self->priv->playbin;
#line 93 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp2_ = value;
#line 93 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_dynamic_set_uri1 (_tmp1_, _tmp2_);
#line 94 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp3_ = self->priv->playbin;
#line 94 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	gst_element_set_state (_tmp3_, GST_STATE_PLAYING);
#line 95 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp4_ = value;
#line 95 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_debug ("rygel-playbin-player.vala:95: URI set to %s.", _tmp4_);
#line 91 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "uri");
#line 598 "rygel-playbin-player.c"
}


static inline gdouble _dynamic_get_volume2 (GstElement* obj) {
	gdouble result;
#line 101 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_object_get (obj, "volume", &result, NULL);
#line 101 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	return result;
#line 608 "rygel-playbin-player.c"
}


static gdouble rygel_playbin_player_real_get_volume (RygelMediaPlayer* base) {
	gdouble result;
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
#line 100 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 101 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp0_ = self->priv->playbin;
#line 101 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp1_ = _dynamic_get_volume2 (_tmp0_);
#line 101 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp2_ = _tmp1_;
#line 101 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	result = _tmp2_;
#line 101 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	return result;
#line 630 "rygel-playbin-player.c"
}


static inline void _dynamic_set_volume3 (GstElement* obj, gdouble value) {
#line 105 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_object_set (obj, "volume", value, NULL);
#line 637 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_volume (RygelMediaPlayer* base, gdouble value) {
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
#line 104 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 105 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp0_ = self->priv->playbin;
#line 105 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp1_ = value;
#line 105 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_dynamic_set_volume3 (_tmp0_, _tmp1_);
#line 106 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp2_ = value;
#line 106 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_debug ("rygel-playbin-player.vala:106: volume set to %f.", _tmp2_);
#line 104 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "volume");
#line 660 "rygel-playbin-player.c"
}


static gint64 rygel_playbin_player_real_get_duration (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	GstFormat format;
	gint64 dur = 0LL;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
#line 111 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 112 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	format = GST_FORMAT_TIME;
#line 115 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp0_ = self->priv->playbin;
#line 115 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp2_ = gst_element_query_duration (_tmp0_, &format, &_tmp1_);
#line 115 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	dur = _tmp1_;
#line 115 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	if (_tmp2_) {
#line 684 "rygel-playbin-player.c"
		gint64 _tmp3_;
#line 116 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		_tmp3_ = dur;
#line 116 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		result = _tmp3_;
#line 116 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		return result;
#line 692 "rygel-playbin-player.c"
	} else {
#line 118 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		result = (gint64) 0;
#line 118 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		return result;
#line 698 "rygel-playbin-player.c"
	}
}


static gint64 rygel_playbin_player_real_get_position (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	GstFormat format;
	gint64 pos = 0LL;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
#line 124 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 125 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	format = GST_FORMAT_TIME;
#line 128 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp0_ = self->priv->playbin;
#line 128 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp2_ = gst_element_query_position (_tmp0_, &format, &_tmp1_);
#line 128 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	pos = _tmp1_;
#line 128 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	if (_tmp2_) {
#line 723 "rygel-playbin-player.c"
		gint64 _tmp3_;
#line 129 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		_tmp3_ = pos;
#line 129 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		result = _tmp3_;
#line 129 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		return result;
#line 731 "rygel-playbin-player.c"
	} else {
#line 131 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		result = (gint64) 0;
#line 131 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		return result;
#line 737 "rygel-playbin-player.c"
	}
}


static void rygel_playbin_player_class_init (RygelPlaybinPlayerClass * klass) {
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	rygel_playbin_player_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_type_class_add_private (klass, sizeof (RygelPlaybinPlayerPrivate));
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_playbin_player_get_property;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_playbin_player_set_property;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_playbin_player_finalize;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE, "playback-state");
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_URI, "uri");
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_VOLUME, "volume");
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_DURATION, "duration");
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_POSITION, "position");
#line 763 "rygel-playbin-player.c"
}


static void rygel_playbin_player_rygel_media_player_interface_init (RygelMediaPlayerIface * iface) {
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	rygel_playbin_player_rygel_media_player_parent_iface = g_type_interface_peek_parent (iface);
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	iface->seek = (gboolean (*)(RygelMediaPlayer*, GstClockTime)) rygel_playbin_player_real_seek;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	iface->get_protocols = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_playbin_player_real_get_protocols;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	iface->get_mime_types = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_playbin_player_real_get_mime_types;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	iface->get_playback_state = rygel_playbin_player_real_get_playback_state;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	iface->set_playback_state = rygel_playbin_player_real_set_playback_state;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	iface->get_uri = rygel_playbin_player_real_get_uri;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	iface->set_uri = rygel_playbin_player_real_set_uri;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	iface->get_volume = rygel_playbin_player_real_get_volume;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	iface->set_volume = rygel_playbin_player_real_set_volume;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	iface->get_duration = rygel_playbin_player_real_get_duration;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	iface->get_position = rygel_playbin_player_real_get_position;
#line 792 "rygel-playbin-player.c"
}


static void rygel_playbin_player_instance_init (RygelPlaybinPlayer * self) {
	gchar* _tmp0_;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	self->priv = RYGEL_PLAYBIN_PLAYER_GET_PRIVATE (self);
#line 60 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_tmp0_ = g_strdup ("STOPPED");
#line 60 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	self->priv->_playback_state = _tmp0_;
#line 804 "rygel-playbin-player.c"
}


static void rygel_playbin_player_finalize (GObject* obj) {
	RygelPlaybinPlayer * self;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	self = RYGEL_PLAYBIN_PLAYER (obj);
#line 58 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_gst_object_unref0 (self->priv->playbin);
#line 60 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	_g_free0 (self->priv->_playback_state);
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	G_OBJECT_CLASS (rygel_playbin_player_parent_class)->finalize (obj);
#line 818 "rygel-playbin-player.c"
}


GType rygel_playbin_player_get_type (void) {
	static volatile gsize rygel_playbin_player_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_playbin_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaybinPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_playbin_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaybinPlayer), 0, (GInstanceInitFunc) rygel_playbin_player_instance_init, NULL };
		static const GInterfaceInfo rygel_media_player_info = { (GInterfaceInitFunc) rygel_playbin_player_rygel_media_player_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_playbin_player_type_id;
		rygel_playbin_player_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlaybinPlayer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_playbin_player_type_id, RYGEL_TYPE_MEDIA_PLAYER, &rygel_media_player_info);
		g_once_init_leave (&rygel_playbin_player_type_id__volatile, rygel_playbin_player_type_id);
	}
	return rygel_playbin_player_type_id__volatile;
}


static void _vala_rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = RYGEL_PLAYBIN_PLAYER (object);
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	switch (property_id) {
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_playback_state ((RygelMediaPlayer*) self));
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_URI:
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_uri ((RygelMediaPlayer*) self));
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		g_value_set_double (value, rygel_media_player_get_volume ((RygelMediaPlayer*) self));
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_DURATION:
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		g_value_set_int64 (value, rygel_media_player_get_duration ((RygelMediaPlayer*) self));
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_POSITION:
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		g_value_set_int64 (value, rygel_media_player_get_position ((RygelMediaPlayer*) self));
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		break;
#line 871 "rygel-playbin-player.c"
		default:
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		break;
#line 877 "rygel-playbin-player.c"
	}
}


static void _vala_rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = RYGEL_PLAYBIN_PLAYER (object);
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
	switch (property_id) {
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_URI:
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		rygel_media_player_set_uri ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		rygel_media_player_set_volume ((RygelMediaPlayer*) self, g_value_get_double (value));
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		break;
#line 905 "rygel-playbin-player.c"
		default:
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "/home/jens/Source/rygel/src/plugins/playbin/rygel-playbin-player.vala"
		break;
#line 911 "rygel-playbin-player.c"
	}
}



