/* rygel-http-resource-handler.c generated by valac 0.34.7, the Vala compiler
 * generated from rygel-http-resource-handler.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rygel-core.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;

#define RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER (rygel_http_media_resource_handler_get_type ())
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandler))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))

typedef struct _RygelHTTPMediaResourceHandler RygelHTTPMediaResourceHandler;
typedef struct _RygelHTTPMediaResourceHandlerClass RygelHTTPMediaResourceHandlerClass;
typedef struct _RygelHTTPMediaResourceHandlerPrivate RygelHTTPMediaResourceHandlerPrivate;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	gchar* (*get_default_transfer_mode) (RygelHTTPGetHandler* self);
	gboolean (*supports_transfer_mode) (RygelHTTPGetHandler* self, const gchar* mode);
	gint64 (*get_resource_size) (RygelHTTPGetHandler* self);
	gint64 (*get_resource_duration) (RygelHTTPGetHandler* self);
	gboolean (*supports_byte_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_time_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_playspeed) (RygelHTTPGetHandler* self);
	RygelHTTPResponse* (*render_body) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
};

struct _RygelHTTPMediaResourceHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPMediaResourceHandlerPrivate * priv;
	RygelMediaResource* media_resource;
};

struct _RygelHTTPMediaResourceHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPMediaResourceHandlerPrivate {
	RygelMediaObject* media_object;
	gchar* media_resource_name;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};


static gpointer rygel_http_media_resource_handler_parent_class = NULL;

GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_request_error_quark (void);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
GType rygel_http_media_resource_handler_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerPrivate))
enum  {
	RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_DUMMY_PROPERTY
};
RygelHTTPMediaResourceHandler* rygel_http_media_resource_handler_new (RygelMediaObject* media_object, const gchar* media_resource_name, GCancellable* cancellable, GError** error);
RygelHTTPMediaResourceHandler* rygel_http_media_resource_handler_construct (GType object_type, RygelMediaObject* media_object, const gchar* media_resource_name, GCancellable* cancellable, GError** error);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type);
void rygel_http_get_handler_set_cancellable (RygelHTTPGetHandler* self, GCancellable* value);
RygelMediaResource* rygel_media_object_get_resource_by_name (RygelMediaObject* self, const gchar* resource_name);
RygelMediaResource* rygel_media_resource_dup (RygelMediaResource* self);
static void rygel_http_media_resource_handler_real_add_response_headers (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
void rygel_http_server_set_resource_delivery_options (RygelHTTPServer* self, RygelMediaResource* res);
GHashTable* rygel_http_server_get_replacements (RygelHTTPServer* self);
gchar* rygel_media_object_apply_replacements (GHashTable* replacement_pairs, const gchar* source_string);
const gchar* rygel_media_resource_get_mime_type (RygelMediaResource* self);
GUPnPProtocolInfo* rygel_media_resource_get_protocol_info (RygelMediaResource* self, GHashTable* replacements);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
static gchar* rygel_http_media_resource_handler_real_get_default_transfer_mode (RygelHTTPGetHandler* base);
gchar* rygel_media_resource_get_default_transfer_mode (RygelMediaResource* self);
static gboolean rygel_http_media_resource_handler_real_supports_transfer_mode (RygelHTTPGetHandler* base, const gchar* mode);
gboolean rygel_media_resource_supports_transfer_mode (RygelMediaResource* self, const gchar* transfer_mode);
static RygelHTTPResponse* rygel_http_media_resource_handler_real_render_body (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error);
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
RygelDataSource* rygel_media_object_create_stream_source_for_resource (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
gchar* rygel_media_resource_get_name (RygelMediaResource* self);
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error);
static gint64 rygel_http_media_resource_handler_real_get_resource_size (RygelHTTPGetHandler* base);
gint64 rygel_media_resource_get_size (RygelMediaResource* self);
static gint64 rygel_http_media_resource_handler_real_get_resource_duration (RygelHTTPGetHandler* base);
glong rygel_media_resource_get_duration (RygelMediaResource* self);
static gboolean rygel_http_media_resource_handler_real_supports_byte_seek (RygelHTTPGetHandler* base);
gboolean rygel_media_resource_supports_arbitrary_byte_seek (RygelMediaResource* self);
gboolean rygel_media_resource_supports_limited_byte_seek (RygelMediaResource* self);
static gboolean rygel_http_media_resource_handler_real_supports_time_seek (RygelHTTPGetHandler* base);
gboolean rygel_media_resource_supports_arbitrary_time_seek (RygelMediaResource* self);
gboolean rygel_media_resource_supports_limited_time_seek (RygelMediaResource* self);
static gboolean rygel_http_media_resource_handler_real_supports_playspeed (RygelHTTPGetHandler* base);
gboolean rygel_media_resource_supports_playspeed (RygelMediaResource* self);
static void rygel_http_media_resource_handler_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelHTTPMediaResourceHandler* rygel_http_media_resource_handler_construct (GType object_type, RygelMediaObject* media_object, const gchar* media_resource_name, GCancellable* cancellable, GError** error) {
	RygelHTTPMediaResourceHandler * self = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	RygelMediaResource* resource = NULL;
	RygelMediaObject* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	RygelMediaResource* _tmp7_ = NULL;
	RygelMediaResource* _tmp8_ = NULL;
	RygelMediaResource* _tmp11_ = NULL;
	RygelMediaResource* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (media_object != NULL, NULL);
	g_return_val_if_fail (media_resource_name != NULL, NULL);
	self = (RygelHTTPMediaResourceHandler*) rygel_http_get_handler_construct (object_type);
	_tmp0_ = media_object;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->media_object);
	self->priv->media_object = _tmp1_;
	_tmp2_ = cancellable;
	rygel_http_get_handler_set_cancellable ((RygelHTTPGetHandler*) self, _tmp2_);
	_tmp3_ = media_resource_name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->media_resource_name);
	self->priv->media_resource_name = _tmp4_;
	_tmp5_ = media_object;
	_tmp6_ = media_resource_name;
	_tmp7_ = rygel_media_object_get_resource_by_name (_tmp5_, _tmp6_);
	resource = _tmp7_;
	_tmp8_ = resource;
	if (_tmp8_ == NULL) {
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		_tmp9_ = media_resource_name;
		_tmp10_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "MediaResource %s not found", _tmp9_);
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (resource);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (resource);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp11_ = resource;
	_tmp12_ = rygel_media_resource_dup (_tmp11_);
	_g_object_unref0 (self->media_resource);
	self->media_resource = _tmp12_;
	_g_object_unref0 (resource);
	return self;
}


RygelHTTPMediaResourceHandler* rygel_http_media_resource_handler_new (RygelMediaObject* media_object, const gchar* media_resource_name, GCancellable* cancellable, GError** error) {
	return rygel_http_media_resource_handler_construct (RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, media_object, media_resource_name, cancellable, error);
}


static void rygel_http_media_resource_handler_real_add_response_headers (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error) {
	RygelHTTPMediaResourceHandler * self;
	RygelHTTPGet* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	RygelMediaResource* _tmp2_ = NULL;
	GHashTable* replacements = NULL;
	RygelHTTPGet* _tmp3_ = NULL;
	RygelHTTPServer* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	gchar* mime_type = NULL;
	GHashTable* _tmp6_ = NULL;
	RygelMediaResource* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	RygelHTTPGet* _tmp11_ = NULL;
	SoupMessage* _tmp12_ = NULL;
	SoupMessageHeaders* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GUPnPProtocolInfo* protocol_info = NULL;
	RygelMediaResource* _tmp15_ = NULL;
	GHashTable* _tmp16_ = NULL;
	GUPnPProtocolInfo* _tmp17_ = NULL;
	GUPnPProtocolInfo* _tmp18_ = NULL;
	RygelHTTPGet* _tmp34_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPMediaResourceHandler*) base;
	g_return_if_fail (request != NULL);
	_tmp0_ = request;
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->http_server;
	_tmp2_ = self->media_resource;
	rygel_http_server_set_resource_delivery_options (_tmp1_, _tmp2_);
	_tmp3_ = request;
	_tmp4_ = ((RygelHTTPRequest*) _tmp3_)->http_server;
	_tmp5_ = rygel_http_server_get_replacements (_tmp4_);
	replacements = _tmp5_;
	_tmp6_ = replacements;
	_tmp7_ = self->media_resource;
	_tmp8_ = rygel_media_resource_get_mime_type (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = rygel_media_object_apply_replacements (_tmp6_, _tmp9_);
	mime_type = _tmp10_;
	_tmp11_ = request;
	_tmp12_ = ((RygelHTTPRequest*) _tmp11_)->msg;
	_tmp13_ = _tmp12_->response_headers;
	_tmp14_ = mime_type;
	soup_message_headers_append (_tmp13_, "Content-Type", _tmp14_);
	_tmp15_ = self->media_resource;
	_tmp16_ = replacements;
	_tmp17_ = rygel_media_resource_get_protocol_info (_tmp15_, _tmp16_);
	protocol_info = _tmp17_;
	_tmp18_ = protocol_info;
	if (_tmp18_ != NULL) {
		gchar** pi_fields = NULL;
		GUPnPProtocolInfo* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar** _tmp22_ = NULL;
		gchar** _tmp23_ = NULL;
		gchar** _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		gint pi_fields_length1 = 0;
		gint _pi_fields_size_ = 0;
		gboolean _tmp25_ = FALSE;
		gchar** _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		_tmp19_ = protocol_info;
		_tmp20_ = gupnp_protocol_info_to_string (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp23_ = _tmp22_ = g_strsplit (_tmp21_, ":", 4);
		_tmp24_ = _tmp23_;
		_tmp24__length1 = _vala_array_length (_tmp22_);
		_g_free0 (_tmp21_);
		pi_fields = _tmp24_;
		pi_fields_length1 = _tmp24__length1;
		_pi_fields_size_ = pi_fields_length1;
		_tmp26_ = pi_fields;
		_tmp26__length1 = pi_fields_length1;
		if (_tmp26_ != NULL) {
			gchar** _tmp27_ = NULL;
			gint _tmp27__length1 = 0;
			const gchar* _tmp28_ = NULL;
			_tmp27_ = pi_fields;
			_tmp27__length1 = pi_fields_length1;
			_tmp28_ = _tmp27_[3];
			_tmp25_ = _tmp28_ != NULL;
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			RygelHTTPGet* _tmp29_ = NULL;
			SoupMessage* _tmp30_ = NULL;
			SoupMessageHeaders* _tmp31_ = NULL;
			gchar** _tmp32_ = NULL;
			gint _tmp32__length1 = 0;
			const gchar* _tmp33_ = NULL;
			_tmp29_ = request;
			_tmp30_ = ((RygelHTTPRequest*) _tmp29_)->msg;
			_tmp31_ = _tmp30_->response_headers;
			_tmp32_ = pi_fields;
			_tmp32__length1 = pi_fields_length1;
			_tmp33_ = _tmp32_[3];
			soup_message_headers_append (_tmp31_, "contentFeatures.dlna.org", _tmp33_);
		}
		pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp34_ = request;
	RYGEL_HTTP_GET_HANDLER_CLASS (rygel_http_media_resource_handler_parent_class)->add_response_headers (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler), _tmp34_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (protocol_info);
			_g_free0 (mime_type);
			_g_hash_table_unref0 (replacements);
			return;
		} else {
			_g_object_unref0 (protocol_info);
			_g_free0 (mime_type);
			_g_hash_table_unref0 (replacements);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (protocol_info);
	_g_free0 (mime_type);
	_g_hash_table_unref0 (replacements);
}


static gchar* rygel_http_media_resource_handler_real_get_default_transfer_mode (RygelHTTPGetHandler* base) {
	RygelHTTPMediaResourceHandler * self;
	gchar* result = NULL;
	RygelMediaResource* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelHTTPMediaResourceHandler*) base;
	_tmp0_ = self->media_resource;
	_tmp1_ = rygel_media_resource_get_default_transfer_mode (_tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean rygel_http_media_resource_handler_real_supports_transfer_mode (RygelHTTPGetHandler* base, const gchar* mode) {
	RygelHTTPMediaResourceHandler * self;
	gboolean result = FALSE;
	RygelMediaResource* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	self = (RygelHTTPMediaResourceHandler*) base;
	g_return_val_if_fail (mode != NULL, FALSE);
	_tmp0_ = self->media_resource;
	_tmp1_ = mode;
	_tmp2_ = rygel_media_resource_supports_transfer_mode (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static RygelHTTPResponse* rygel_http_media_resource_handler_real_render_body (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error) {
	RygelHTTPMediaResourceHandler * self;
	RygelHTTPResponse* result = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPMediaResourceHandler*) base;
	g_return_val_if_fail (request != NULL, NULL);
	{
		RygelDataSource* src = NULL;
		RygelHTTPGet* _tmp0_ = NULL;
		RygelMediaObject* _tmp1_ = NULL;
		RygelHTTPGet* _tmp2_ = NULL;
		RygelMediaResource* _tmp3_ = NULL;
		RygelDataSource* _tmp4_ = NULL;
		RygelDataSource* _tmp5_ = NULL;
		RygelHTTPResponse* _tmp12_ = NULL;
		RygelHTTPGet* _tmp13_ = NULL;
		RygelDataSource* _tmp14_ = NULL;
		RygelHTTPResponse* _tmp15_ = NULL;
		RygelHTTPResponse* _tmp16_ = NULL;
		_tmp0_ = request;
		_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->object;
		_tmp2_ = request;
		_tmp3_ = self->media_resource;
		_tmp4_ = rygel_media_object_create_stream_source_for_resource (_tmp1_, (RygelHTTPRequest*) _tmp2_, _tmp3_, &_inner_error_);
		src = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch55_g_error;
		}
		_tmp5_ = src;
		if (_tmp5_ == NULL) {
			const gchar* _tmp6_ = NULL;
			RygelMediaResource* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			GError* _tmp10_ = NULL;
			GError* _tmp11_ = NULL;
			_tmp6_ = _ ("Couldn’t create data source for %s");
			_tmp7_ = self->media_resource;
			_tmp8_ = rygel_media_resource_get_name (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp6_, _tmp9_);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp9_);
			_inner_error_ = _tmp11_;
			_g_object_unref0 (src);
			goto __catch55_g_error;
		}
		_tmp13_ = request;
		_tmp14_ = src;
		_tmp15_ = rygel_http_response_new (_tmp13_, (RygelHTTPGetHandler*) self, _tmp14_, &_inner_error_);
		_tmp12_ = _tmp15_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (src);
			goto __catch55_g_error;
		}
		_tmp16_ = _tmp12_;
		_tmp12_ = NULL;
		result = _tmp16_;
		_g_object_unref0 (_tmp12_);
		_g_object_unref0 (src);
		return result;
	}
	goto __finally55;
	__catch55_g_error:
	{
		GError* err = NULL;
		GError* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = err;
		_tmp18_ = _tmp17_->message;
		_tmp19_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp18_);
		_inner_error_ = _tmp19_;
		_g_error_free0 (err);
		goto __finally55;
	}
	__finally55:
	if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gint64 rygel_http_media_resource_handler_real_get_resource_size (RygelHTTPGetHandler* base) {
	RygelHTTPMediaResourceHandler * self;
	gint64 result = 0LL;
	RygelMediaResource* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	self = (RygelHTTPMediaResourceHandler*) base;
	_tmp0_ = self->media_resource;
	_tmp1_ = rygel_media_resource_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static gint64 rygel_http_media_resource_handler_real_get_resource_duration (RygelHTTPGetHandler* base) {
	RygelHTTPMediaResourceHandler * self;
	gint64 result = 0LL;
	RygelMediaResource* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	glong _tmp2_ = 0L;
	self = (RygelHTTPMediaResourceHandler*) base;
	_tmp0_ = self->media_resource;
	_tmp1_ = rygel_media_resource_get_duration (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (gint64) (_tmp2_ * G_TIME_SPAN_SECOND);
	return result;
}


static gboolean rygel_http_media_resource_handler_real_supports_byte_seek (RygelHTTPGetHandler* base) {
	RygelHTTPMediaResourceHandler * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	RygelMediaResource* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	self = (RygelHTTPMediaResourceHandler*) base;
	_tmp1_ = self->media_resource;
	_tmp2_ = rygel_media_resource_supports_arbitrary_byte_seek (_tmp1_);
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		RygelMediaResource* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = self->media_resource;
		_tmp4_ = rygel_media_resource_supports_limited_byte_seek (_tmp3_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}


static gboolean rygel_http_media_resource_handler_real_supports_time_seek (RygelHTTPGetHandler* base) {
	RygelHTTPMediaResourceHandler * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	RygelMediaResource* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	self = (RygelHTTPMediaResourceHandler*) base;
	_tmp1_ = self->media_resource;
	_tmp2_ = rygel_media_resource_supports_arbitrary_time_seek (_tmp1_);
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		RygelMediaResource* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = self->media_resource;
		_tmp4_ = rygel_media_resource_supports_limited_time_seek (_tmp3_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}


static gboolean rygel_http_media_resource_handler_real_supports_playspeed (RygelHTTPGetHandler* base) {
	RygelHTTPMediaResourceHandler * self;
	gboolean result = FALSE;
	RygelMediaResource* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (RygelHTTPMediaResourceHandler*) base;
	_tmp0_ = self->media_resource;
	_tmp1_ = rygel_media_resource_supports_playspeed (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_http_media_resource_handler_class_init (RygelHTTPMediaResourceHandlerClass * klass) {
	rygel_http_media_resource_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPMediaResourceHandlerPrivate));
	((RygelHTTPGetHandlerClass *) klass)->add_response_headers = (void (*)(RygelHTTPGetHandler*, RygelHTTPGet*, GError**)) rygel_http_media_resource_handler_real_add_response_headers;
	((RygelHTTPGetHandlerClass *) klass)->get_default_transfer_mode = (gchar* (*)(RygelHTTPGetHandler*)) rygel_http_media_resource_handler_real_get_default_transfer_mode;
	((RygelHTTPGetHandlerClass *) klass)->supports_transfer_mode = (gboolean (*)(RygelHTTPGetHandler*, const gchar*)) rygel_http_media_resource_handler_real_supports_transfer_mode;
	((RygelHTTPGetHandlerClass *) klass)->render_body = (RygelHTTPResponse* (*)(RygelHTTPGetHandler*, RygelHTTPGet*, GError**)) rygel_http_media_resource_handler_real_render_body;
	((RygelHTTPGetHandlerClass *) klass)->get_resource_size = (gint64 (*)(RygelHTTPGetHandler*)) rygel_http_media_resource_handler_real_get_resource_size;
	((RygelHTTPGetHandlerClass *) klass)->get_resource_duration = (gint64 (*)(RygelHTTPGetHandler*)) rygel_http_media_resource_handler_real_get_resource_duration;
	((RygelHTTPGetHandlerClass *) klass)->supports_byte_seek = (gboolean (*)(RygelHTTPGetHandler*)) rygel_http_media_resource_handler_real_supports_byte_seek;
	((RygelHTTPGetHandlerClass *) klass)->supports_time_seek = (gboolean (*)(RygelHTTPGetHandler*)) rygel_http_media_resource_handler_real_supports_time_seek;
	((RygelHTTPGetHandlerClass *) klass)->supports_playspeed = (gboolean (*)(RygelHTTPGetHandler*)) rygel_http_media_resource_handler_real_supports_playspeed;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_media_resource_handler_finalize;
}


static void rygel_http_media_resource_handler_instance_init (RygelHTTPMediaResourceHandler * self) {
	self->priv = RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_GET_PRIVATE (self);
}


static void rygel_http_media_resource_handler_finalize (GObject* obj) {
	RygelHTTPMediaResourceHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandler);
	_g_object_unref0 (self->priv->media_object);
	_g_free0 (self->priv->media_resource_name);
	_g_object_unref0 (self->media_resource);
	G_OBJECT_CLASS (rygel_http_media_resource_handler_parent_class)->finalize (obj);
}


/**
 * The HTTP handler for HTTP ContentResource requests.
 */
GType rygel_http_media_resource_handler_get_type (void) {
	static volatile gsize rygel_http_media_resource_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_media_resource_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPMediaResourceHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_media_resource_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPMediaResourceHandler), 0, (GInstanceInitFunc) rygel_http_media_resource_handler_instance_init, NULL };
		GType rygel_http_media_resource_handler_type_id;
		rygel_http_media_resource_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPMediaResourceHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_media_resource_handler_type_id__volatile, rygel_http_media_resource_handler_type_id);
	}
	return rygel_http_media_resource_handler_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



