/* gitg-stage.c generated by valac 0.34.7, the Vala compiler
 * generated from gitg-stage.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2013 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define GITG_TYPE_STAGE_COMMIT_OPTIONS (gitg_stage_commit_options_get_type ())

#define GITG_TYPE_PATCH_SET (gitg_patch_set_get_type ())
#define GITG_PATCH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PATCH_SET, GitgPatchSet))
#define GITG_PATCH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PATCH_SET, GitgPatchSetClass))
#define GITG_IS_PATCH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PATCH_SET))
#define GITG_IS_PATCH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PATCH_SET))
#define GITG_PATCH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PATCH_SET, GitgPatchSetClass))

typedef struct _GitgPatchSet GitgPatchSet;
typedef struct _GitgPatchSetClass GitgPatchSetClass;
typedef struct _GitgPatchSetPrivate GitgPatchSetPrivate;

#define GITG_PATCH_SET_TYPE_PATCH (gitg_patch_set_patch_get_type ())

#define GITG_PATCH_SET_TYPE_TYPE (gitg_patch_set_type_get_type ())
typedef struct _GitgPatchSetPatch GitgPatchSetPatch;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gitg_patch_set_unref0(var) ((var == NULL) ? NULL : (var = (gitg_patch_set_unref (var), NULL)))
typedef struct _GitgParamSpecPatchSet GitgParamSpecPatchSet;

#define GITG_TYPE_STAGE (gitg_stage_get_type ())
#define GITG_STAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_STAGE, GitgStage))
#define GITG_STAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_STAGE, GitgStageClass))
#define GITG_IS_STAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_STAGE))
#define GITG_IS_STAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_STAGE))
#define GITG_STAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_STAGE, GitgStageClass))

typedef struct _GitgStage GitgStage;
typedef struct _GitgStageClass GitgStageClass;
typedef struct _GitgStagePrivate GitgStagePrivate;

#define GITG_TYPE_REPOSITORY (gitg_repository_get_type ())
#define GITG_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY, GitgRepository))
#define GITG_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY, GitgRepositoryClass))
#define GITG_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY))
#define GITG_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY))
#define GITG_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY, GitgRepositoryClass))

typedef struct _GitgRepository GitgRepository;
typedef struct _GitgRepositoryClass GitgRepositoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GitgStageRefreshData GitgStageRefreshData;
typedef struct _Block22Data Block22Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GITG_TYPE_REF (gitg_ref_get_type ())
#define GITG_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF, GitgRef))
#define GITG_IS_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF))
#define GITG_REF_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_REF, GitgRefIface))

typedef struct _GitgRef GitgRef;
typedef struct _GitgRefIface GitgRefIface;

#define GITG_TYPE_PARSED_REF_NAME (gitg_parsed_ref_name_get_type ())
#define GITG_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName))
#define GITG_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))
#define GITG_IS_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PARSED_REF_NAME))
#define GITG_IS_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PARSED_REF_NAME))
#define GITG_PARSED_REF_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))

typedef struct _GitgParsedRefName GitgParsedRefName;
typedef struct _GitgParsedRefNameClass GitgParsedRefNameClass;

#define GITG_TYPE_REF_STATE (gitg_ref_state_get_type ())
typedef struct _GitgStageGetHeadTreeData GitgStageGetHeadTreeData;

#define GITG_TYPE_STAGE_STATUS_ENUMERATOR (gitg_stage_status_enumerator_get_type ())
#define GITG_STAGE_STATUS_ENUMERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_STAGE_STATUS_ENUMERATOR, GitgStageStatusEnumerator))
#define GITG_STAGE_STATUS_ENUMERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_STAGE_STATUS_ENUMERATOR, GitgStageStatusEnumeratorClass))
#define GITG_IS_STAGE_STATUS_ENUMERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_STAGE_STATUS_ENUMERATOR))
#define GITG_IS_STAGE_STATUS_ENUMERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_STAGE_STATUS_ENUMERATOR))
#define GITG_STAGE_STATUS_ENUMERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_STAGE_STATUS_ENUMERATOR, GitgStageStatusEnumeratorClass))

typedef struct _GitgStageStatusEnumerator GitgStageStatusEnumerator;
typedef struct _GitgStageStatusEnumeratorClass GitgStageStatusEnumeratorClass;
typedef struct _Block23Data Block23Data;
typedef struct _GitgStageThreadIndexData GitgStageThreadIndexData;

#define GITG_TYPE_HOOK (gitg_hook_get_type ())
#define GITG_HOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_HOOK, GitgHook))
#define GITG_HOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_HOOK, GitgHookClass))
#define GITG_IS_HOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_HOOK))
#define GITG_IS_HOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_HOOK))
#define GITG_HOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_HOOK, GitgHookClass))

typedef struct _GitgHook GitgHook;
typedef struct _GitgHookClass GitgHookClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
typedef struct _Block24Data Block24Data;
typedef struct _GitgStagePreCommitHookData GitgStagePreCommitHookData;
typedef struct _Block25Data Block25Data;
#define __vala_GgitStatusOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitStatusOptions_free (var), NULL)))
typedef struct _Block26Data Block26Data;
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
typedef struct _Block27Data Block27Data;
typedef struct _GitgStageCommitIndexData GitgStageCommitIndexData;
typedef struct _Block28Data Block28Data;
#define _ggit_reflog_unref0(var) ((var == NULL) ? NULL : (var = (ggit_reflog_unref (var), NULL)))
typedef struct _GitgStageCommitTreeData GitgStageCommitTreeData;
typedef struct _Block29Data Block29Data;
typedef struct _GitgStageCommitData GitgStageCommitData;
typedef struct _Block30Data Block30Data;
#define _ggit_tree_entry_unref0(var) ((var == NULL) ? NULL : (var = (ggit_tree_entry_unref (var), NULL)))
typedef struct _GitgStageRevertData GitgStageRevertData;
typedef struct _GitgStageRevertPathData GitgStageRevertPathData;
typedef struct _Block31Data Block31Data;
#define _ggit_index_entry_unref0(var) ((var == NULL) ? NULL : (var = (ggit_index_entry_unref (var), NULL)))
#define _ggit_index_entries_unref0(var) ((var == NULL) ? NULL : (var = (ggit_index_entries_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _GitgStageRevertPatchData GitgStageRevertPatchData;
typedef struct _Block32Data Block32Data;
typedef struct _GitgStageDeleteData GitgStageDeleteData;
typedef struct _GitgStageDeletePathData GitgStageDeletePathData;
typedef struct _Block33Data Block33Data;
typedef struct _GitgStageStageData GitgStageStageData;
typedef struct _GitgStageStagePathData GitgStageStagePathData;
typedef struct _Block34Data Block34Data;
typedef struct _GitgStageStageCommitData GitgStageStageCommitData;
typedef struct _Block35Data Block35Data;
typedef struct _GitgStageStagePatchData GitgStageStagePatchData;
typedef struct _Block36Data Block36Data;
typedef struct _GitgStageUnstageData GitgStageUnstageData;
typedef struct _GitgStageUnstagePathData GitgStageUnstagePathData;
typedef struct _Block37Data Block37Data;
typedef struct _GitgStageUnstagePatchData GitgStageUnstagePatchData;

#define GITG_TYPE_STAGE_STATUS_ITEM (gitg_stage_status_item_get_type ())
#define GITG_STAGE_STATUS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_STAGE_STATUS_ITEM, GitgStageStatusItem))
#define GITG_IS_STAGE_STATUS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_STAGE_STATUS_ITEM))
#define GITG_STAGE_STATUS_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_STAGE_STATUS_ITEM, GitgStageStatusItemIface))

typedef struct _GitgStageStatusItem GitgStageStatusItem;
typedef struct _GitgStageStatusItemIface GitgStageStatusItemIface;
typedef struct _GitgStageDiffIndexAllData GitgStageDiffIndexAllData;
typedef struct _GitgStageDiffIndexData GitgStageDiffIndexData;
typedef struct _GitgStageDiffWorkdirAllData GitgStageDiffWorkdirAllData;
typedef struct _GitgStageDiffWorkdirData GitgStageDiffWorkdirData;

typedef enum  {
	GITG_STAGE_COMMIT_OPTIONS_NONE = 0,
	GITG_STAGE_COMMIT_OPTIONS_SIGN_OFF = 1 << 0,
	GITG_STAGE_COMMIT_OPTIONS_AMEND = 1 << 1,
	GITG_STAGE_COMMIT_OPTIONS_SKIP_HOOKS = 1 << 2
} GitgStageCommitOptions;

typedef enum  {
	GITG_STAGE_ERROR_PRE_COMMIT_HOOK_FAILED,
	GITG_STAGE_ERROR_COMMIT_MSG_HOOK_FAILED,
	GITG_STAGE_ERROR_NOTHING_TO_COMMIT,
	GITG_STAGE_ERROR_INDEX_ENTRY_NOT_FOUND
} GitgStageError;
#define GITG_STAGE_ERROR gitg_stage_error_quark ()
typedef enum  {
	GITG_PATCH_SET_TYPE_ADD = 'a',
	GITG_PATCH_SET_TYPE_REMOVE = 'r'
} GitgPatchSetType;

struct _GitgPatchSetPatch {
	GitgPatchSetType type;
	gsize old_offset;
	gsize new_offset;
	gsize length;
};

struct _GitgPatchSet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgPatchSetPrivate * priv;
	gchar* filename;
	GitgPatchSetPatch* patches;
	gint patches_length1;
};

struct _GitgPatchSetClass {
	GTypeClass parent_class;
	void (*finalize) (GitgPatchSet *self);
};

struct _GitgParamSpecPatchSet {
	GParamSpec parent_instance;
};

struct _GitgStage {
	GObject parent_instance;
	GitgStagePrivate * priv;
};

struct _GitgStageClass {
	GObjectClass parent_class;
};

struct _GitgStagePrivate {
	GitgRepository* d_repository;
	GMutex d_index_mutex;
	GRecMutex __lock_d_index_mutex;
	GgitTree* d_head_tree;
};

typedef void (*GitgStageWithIndexFunc) (GgitIndex* index, void* user_data, GError** error);
struct _GitgStageRefreshData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	GError * _inner_error_;
};

struct _Block22Data {
	int _ref_count_;
	GitgStage* self;
	GError* e;
	gpointer _async_data_;
};

typedef void (*GitgAsyncThreadFunc) (void* user_data, GError** error);
typedef enum  {
	GITG_REF_STATE_NONE,
	GITG_REF_STATE_SELECTED,
	GITG_REF_STATE_PRELIGHT
} GitgRefState;

struct _GitgRefIface {
	GTypeInterface parent_iface;
	GitgRepository* (*get_owner) (GitgRef* self);
	GitgParsedRefName* (*get_d_parsed_name) (GitgRef* self);
	void (*set_d_parsed_name) (GitgRef* self, GitgParsedRefName* value);
	GList* (*get_d_pushes) (GitgRef* self);
	void (*set_d_pushes) (GitgRef* self, GList* value);
	GitgRefState (*get_state) (GitgRef* self);
	void (*set_state) (GitgRef* self, GitgRefState value);
	gboolean (*get_working) (GitgRef* self);
	void (*set_working) (GitgRef* self, gboolean value);
};

struct _GitgStageGetHeadTreeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	GgitTree* result;
	Block22Data* _data22_;
	GgitTree* _tmp0_;
	GgitTree* _tmp1_;
	GgitTree* _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	GError* _tmp5_;
	GgitTree* _tmp6_;
	GgitTree* _tmp7_;
	GError * _inner_error_;
};

struct _Block23Data {
	int _ref_count_;
	GitgStage* self;
	GitgStageWithIndexFunc func;
	gpointer func_target;
	gpointer _async_data_;
};

struct _GitgStageThreadIndexData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	GitgStageWithIndexFunc func;
	gpointer func_target;
	Block23Data* _data23_;
	GitgStageWithIndexFunc _tmp0_;
	void* _tmp0__target;
	GError * _inner_error_;
};

struct _Block24Data {
	int _ref_count_;
	GitgStage* self;
	gchar* errormsg;
	GgitSignature* author;
	gpointer _async_data_;
};

struct _GitgStagePreCommitHookData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	GgitSignature* author;
	Block24Data* _data24_;
	GgitSignature* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _tmp3_;
	GError * _inner_error_;
};

struct _Block25Data {
	int _ref_count_;
	GitgStage* self;
	gboolean has_changes;
};

struct _Block26Data {
	int _ref_count_;
	GitgStage* self;
	GitgHook* hook;
};

struct _Block27Data {
	int _ref_count_;
	GitgStage* self;
	GgitOId* treeoid;
	GgitIndex* index;
	gpointer _async_data_;
};

struct _GitgStageCommitIndexData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	GgitIndex* index;
	GgitRef* reference;
	gchar* message;
	GgitSignature* author;
	GgitSignature* committer;
	GgitOId** parents;
	gint parents_length1;
	GitgStageCommitOptions options;
	GgitOId* result;
	Block27Data* _data27_;
	GgitIndex* _tmp0_;
	GgitOId* _tmp1_;
	GgitOId* _tmp2_;
	GgitRef* _tmp3_;
	const gchar* _tmp4_;
	GgitSignature* _tmp5_;
	GgitSignature* _tmp6_;
	GgitOId** _tmp7_;
	gint _tmp7__length1;
	GitgStageCommitOptions _tmp8_;
	GgitOId* _tmp9_;
	GgitOId* _tmp10_;
	GError * _inner_error_;
};

struct _Block28Data {
	int _ref_count_;
	GitgStage* self;
	GgitOId* ret;
	GgitOId* treeoid;
	GgitRef* reference;
	gchar* message;
	GgitSignature* author;
	GgitSignature* committer;
	GgitOId** parents;
	gint parents_length1;
	GitgStageCommitOptions options;
	gpointer _async_data_;
};

struct _GitgStageCommitTreeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	GgitOId* treeoid;
	GgitRef* reference;
	gchar* message;
	GgitSignature* author;
	GgitSignature* committer;
	GgitOId** parents;
	gint parents_length1;
	GitgStageCommitOptions options;
	GgitOId* result;
	Block28Data* _data28_;
	GgitOId* _tmp0_;
	GgitRef* _tmp1_;
	const gchar* _tmp2_;
	GgitSignature* _tmp3_;
	GgitSignature* _tmp4_;
	GgitOId** _tmp5_;
	gint _tmp5__length1;
	GitgStageCommitOptions _tmp6_;
	GgitOId* _tmp7_;
	GError * _inner_error_;
};

struct _Block29Data {
	int _ref_count_;
	GitgStage* self;
	GgitIndex* index;
};

struct _GitgStageCommitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	gchar* message;
	GgitSignature* author;
	GgitSignature* committer;
	GitgStageCommitOptions options;
	GgitOId* result;
	gboolean amend;
	GitgStageCommitOptions _tmp0_;
	GgitOId* ret;
	Block29Data* _data29_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError* _tmp4_;
	GitgRef* _tmp5_;
	GitgRepository* _tmp6_;
	GitgRef* _tmp7_;
	GgitOId* _tmp8_;
	GgitIndex* _tmp9_;
	const gchar* _tmp10_;
	GgitSignature* _tmp11_;
	GgitSignature* _tmp12_;
	GitgStageCommitOptions _tmp13_;
	GgitOId* _tmp14_;
	GgitOId* _tmp15_;
	GError * _inner_error_;
};

struct _Block30Data {
	int _ref_count_;
	GitgStage* self;
	GgitTree* tree;
	GFile* file;
	gpointer _async_data_;
};

struct _GitgStageRevertData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	GFile* file;
	Block30Data* _data30_;
	GFile* _tmp0_;
	GgitTree* _tmp1_;
	GError * _inner_error_;
};

struct _GitgStageRevertPathData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	gchar* path;
	GitgRepository* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GError * _inner_error_;
};

struct _Block31Data {
	int _ref_count_;
	GitgStage* self;
	GFile* workdirf;
	GFileInputStream* workdirf_stream;
	GitgPatchSet* patch;
	gpointer _async_data_;
};

struct _GitgStageRevertPatchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	GitgPatchSet* patch;
	Block31Data* _data31_;
	GitgPatchSet* _tmp0_;
	GitgRepository* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GitgPatchSet* _tmp4_;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFileInputStream* _tmp9_;
	GError * _inner_error_;
};

struct _Block32Data {
	int _ref_count_;
	GitgStage* self;
	GFile* file;
	gpointer _async_data_;
};

struct _GitgStageDeleteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	GFile* file;
	Block32Data* _data32_;
	GFile* _tmp0_;
	GError * _inner_error_;
};

struct _GitgStageDeletePathData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	gchar* path;
	GitgRepository* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GError * _inner_error_;
};

struct _Block33Data {
	int _ref_count_;
	GitgStage* self;
	GFile* file;
	gpointer _async_data_;
};

struct _GitgStageStageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	GFile* file;
	Block33Data* _data33_;
	GFile* _tmp0_;
	GError * _inner_error_;
};

struct _GitgStageStagePathData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	gchar* path;
	GitgRepository* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GError * _inner_error_;
};

struct _Block34Data {
	int _ref_count_;
	GitgStage* self;
	gchar* path;
	GgitCommit* commit;
	gpointer _async_data_;
};

struct _GitgStageStageCommitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	gchar* path;
	GgitCommit* commit;
	Block34Data* _data34_;
	const gchar* _tmp0_;
	GgitCommit* _tmp1_;
	GError * _inner_error_;
};

struct _Block35Data {
	int _ref_count_;
	GitgStage* self;
	GFile* newf;
	GFileInputStream* new_stream;
	GitgPatchSet* patch;
	gpointer _async_data_;
};

struct _GitgStageStagePatchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	GitgPatchSet* patch;
	Block35Data* _data35_;
	GitgPatchSet* _tmp0_;
	GitgRepository* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GitgPatchSet* _tmp4_;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFileInputStream* _tmp9_;
	GError * _inner_error_;
};

struct _Block36Data {
	int _ref_count_;
	GitgStage* self;
	GgitTree* tree;
	GFile* file;
	gpointer _async_data_;
};

struct _GitgStageUnstageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	GFile* file;
	Block36Data* _data36_;
	GFile* _tmp0_;
	GgitTree* _tmp1_;
	GError * _inner_error_;
};

struct _GitgStageUnstagePathData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	gchar* path;
	GitgRepository* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GError * _inner_error_;
};

struct _Block37Data {
	int _ref_count_;
	GitgStage* self;
	GFile* file;
	GgitTree* tree;
	GitgPatchSet* patch;
	gpointer _async_data_;
};

struct _GitgStageUnstagePatchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	GitgPatchSet* patch;
	Block37Data* _data37_;
	GitgPatchSet* _tmp0_;
	GitgRepository* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GitgPatchSet* _tmp4_;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GgitTree* _tmp8_;
	GError * _inner_error_;
};

struct _GitgStageStatusItemIface {
	GTypeInterface parent_iface;
	gchar* (*get_path) (GitgStageStatusItem* self);
	gboolean (*get_is_staged) (GitgStageStatusItem* self);
	gboolean (*get_is_unstaged) (GitgStageStatusItem* self);
	gboolean (*get_is_untracked) (GitgStageStatusItem* self);
	gchar* (*get_icon_name) (GitgStageStatusItem* self);
};

struct _GitgStageDiffIndexAllData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	GitgStageStatusItem** files;
	gint files_length1;
	GgitDiffOptions* defopts;
	GgitDiff* result;
	GgitDiffOptions* opts;
	GgitDiffOptions* _tmp0_;
	GgitDiffOptions* _tmp1_;
	GitgStageStatusItem** _tmp2_;
	gint _tmp2__length1;
	gchar** pspec;
	GitgStageStatusItem** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint pspec_length1;
	gint _pspec_size_;
	gint i;
	gboolean _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GitgStageStatusItem** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_;
	GitgStageStatusItem** _tmp11_;
	gint _tmp11__length1;
	gint _tmp12_;
	GitgStageStatusItem* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GgitDiffOptions* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GgitDiffOptions* _tmp19_;
	GgitDiffOptions* _tmp20_;
	GgitDiffOptions* _tmp21_;
	GgitDiffOption _tmp22_;
	GgitDiffOption _tmp23_;
	GgitDiffOptions* _tmp24_;
	GgitDiffOption _tmp25_;
	GgitDiffOption _tmp26_;
	GgitDiffOptions* _tmp27_;
	GgitDiffOptions* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	GgitDiffOptions* _tmp31_;
	GgitDiffOptions* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	GgitDiffOptions* _tmp35_;
	GgitDiffOptions* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	GgitDiffOptions* _tmp39_;
	GgitDiffOptions* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	GgitTree* tree;
	gboolean _tmp43_;
	GitgRepository* _tmp44_;
	gboolean _tmp45_;
	GgitTree* _tmp46_;
	GgitTree* _tmp47_;
	GgitTree* _tmp48_;
	GgitIndex* _tmp49_;
	GitgRepository* _tmp50_;
	GgitIndex* _tmp51_;
	GgitDiff* _tmp52_;
	GitgRepository* _tmp53_;
	GgitTree* _tmp54_;
	GgitDiffOptions* _tmp55_;
	GgitDiff* _tmp56_;
	GgitDiff* _tmp57_;
	GError * _inner_error_;
};

struct _GitgStageDiffIndexData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	GitgStageStatusItem* f;
	GgitDiffOptions* defopts;
	GgitDiff* result;
	GgitDiff* _tmp0_;
	GitgStageStatusItem* _tmp1_;
	GitgStageStatusItem* _tmp2_;
	GitgStageStatusItem** _tmp3_;
	GitgStageStatusItem** _tmp4_;
	gint _tmp4__length1;
	GgitDiffOptions* _tmp5_;
	GgitDiff* _tmp6_;
	GgitDiff* _tmp7_;
	GgitDiff* _tmp8_;
	GError * _inner_error_;
};

struct _GitgStageDiffWorkdirAllData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	GitgStageStatusItem** files;
	gint files_length1;
	GgitDiffOptions* defopts;
	GgitDiff* result;
	GgitDiffOptions* opts;
	GgitDiffOptions* _tmp0_;
	GgitDiffOptions* _tmp1_;
	GitgStageStatusItem** _tmp2_;
	gint _tmp2__length1;
	gchar** pspec;
	GitgStageStatusItem** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint pspec_length1;
	gint _pspec_size_;
	gint i;
	gboolean _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GitgStageStatusItem** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_;
	GitgStageStatusItem** _tmp11_;
	gint _tmp11__length1;
	gint _tmp12_;
	GitgStageStatusItem* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GgitDiffOptions* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GgitDiffOptions* _tmp19_;
	GgitDiffOptions* _tmp20_;
	GgitDiffOptions* _tmp21_;
	GgitDiffOption _tmp22_;
	GgitDiffOption _tmp23_;
	GgitDiffOptions* _tmp24_;
	GgitDiffOption _tmp25_;
	GgitDiffOption _tmp26_;
	GgitDiffOptions* _tmp27_;
	GgitDiffOptions* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	GgitDiffOptions* _tmp31_;
	GgitDiffOptions* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	GgitDiffOptions* _tmp35_;
	GgitDiffOptions* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	GgitDiffOptions* _tmp39_;
	GgitDiffOptions* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	GgitIndex* _tmp43_;
	GitgRepository* _tmp44_;
	GgitIndex* _tmp45_;
	GgitDiff* _tmp46_;
	GitgRepository* _tmp47_;
	GgitDiffOptions* _tmp48_;
	GgitDiff* _tmp49_;
	GgitDiff* _tmp50_;
	GError * _inner_error_;
};

struct _GitgStageDiffWorkdirData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgStage* self;
	GitgStageStatusItem* f;
	GgitDiffOptions* defopts;
	GgitDiff* result;
	GgitDiff* _tmp0_;
	GitgStageStatusItem* _tmp1_;
	GitgStageStatusItem* _tmp2_;
	GitgStageStatusItem** _tmp3_;
	GitgStageStatusItem** _tmp4_;
	gint _tmp4__length1;
	GgitDiffOptions* _tmp5_;
	GgitDiff* _tmp6_;
	GgitDiff* _tmp7_;
	GgitDiff* _tmp8_;
	GError * _inner_error_;
};


static gpointer gitg_patch_set_parent_class = NULL;
static gpointer gitg_stage_parent_class = NULL;

GType gitg_stage_commit_options_get_type (void) G_GNUC_CONST;
GQuark gitg_stage_error_quark (void);
gpointer gitg_patch_set_ref (gpointer instance);
void gitg_patch_set_unref (gpointer instance);
GParamSpec* gitg_param_spec_patch_set (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gitg_value_set_patch_set (GValue* value, gpointer v_object);
void gitg_value_take_patch_set (GValue* value, gpointer v_object);
gpointer gitg_value_get_patch_set (const GValue* value);
GType gitg_patch_set_get_type (void) G_GNUC_CONST;
GType gitg_patch_set_patch_get_type (void) G_GNUC_CONST;
GType gitg_patch_set_type_get_type (void) G_GNUC_CONST;
GitgPatchSetPatch* gitg_patch_set_patch_dup (const GitgPatchSetPatch* self);
void gitg_patch_set_patch_free (GitgPatchSetPatch* self);
enum  {
	GITG_PATCH_SET_DUMMY_PROPERTY
};
GitgPatchSet* gitg_patch_set_reversed (GitgPatchSet* self);
GitgPatchSet* gitg_patch_set_new (void);
GitgPatchSet* gitg_patch_set_construct (GType object_type);
static void gitg_patch_set_finalize (GitgPatchSet* obj);
GType gitg_stage_get_type (void) G_GNUC_CONST;
GType gitg_repository_get_type (void) G_GNUC_CONST;
#define GITG_STAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_STAGE, GitgStagePrivate))
enum  {
	GITG_STAGE_DUMMY_PROPERTY
};
GitgStage* gitg_stage_new (GitgRepository* repository);
GitgStage* gitg_stage_construct (GType object_type, GitgRepository* repository);
static void gitg_stage_refresh_data_free (gpointer _data);
void gitg_stage_refresh (GitgStage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_stage_refresh_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_refresh_co (GitgStageRefreshData* _data_);
static void gitg_stage_thread_index (GitgStage* self, GitgStageWithIndexFunc func, void* func_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gitg_stage_thread_index_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static void __lambda6_ (GitgStage* self, GgitIndex* index, GError** error);
static void ___lambda6__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error);
static void gitg_stage_refresh_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_stage_get_head_tree_data_free (gpointer _data);
void gitg_stage_get_head_tree (GitgStage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
GgitTree* gitg_stage_get_head_tree_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_get_head_tree_co (GitgStageGetHeadTreeData* _data_);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
void gitg_async_thread (GitgAsyncThreadFunc func, void* func_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_async_thread_finish (GAsyncResult* _res_, GError** error);
static void __lambda7_ (Block22Data* _data22_, GError** error);
GType gitg_parsed_ref_name_get_type (void) G_GNUC_CONST;
GType gitg_ref_state_get_type (void) G_GNUC_CONST;
GType gitg_ref_get_type (void) G_GNUC_CONST;
GitgRef* gitg_repository_get_head (GitgRepository* self, GError** error);
static void ___lambda7__gitg_async_thread_func (gpointer self, GError** error);
static void gitg_stage_get_head_tree_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType gitg_stage_status_enumerator_get_type (void) G_GNUC_CONST;
GitgStageStatusEnumerator* gitg_stage_file_status (GitgStage* self, GgitStatusOptions* options);
GitgStageStatusEnumerator* gitg_stage_status_enumerator_new (GitgRepository* repository, GgitStatusOptions* options);
GitgStageStatusEnumerator* gitg_stage_status_enumerator_construct (GType object_type, GitgRepository* repository, GgitStatusOptions* options);
static void gitg_stage_with_index (GitgStage* self, GitgStageWithIndexFunc func, void* func_target, GError** error);
static void gitg_stage_thread_index_data_free (gpointer _data);
static gboolean gitg_stage_thread_index_co (GitgStageThreadIndexData* _data_);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static void __lambda5_ (Block23Data* _data23_, GError** error);
static void ___lambda5__gitg_async_thread_func (gpointer self, GError** error);
static void gitg_stage_thread_index_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* gitg_stage_message_with_sign_off (GitgStage* self, const gchar* message, GgitSignature* committer);
static gchar* gitg_stage_convert_message_to_encoding (GitgStage* self, GgitConfig* conf, const gchar* message, gchar** encoding);
GType gitg_hook_get_type (void) G_GNUC_CONST;
static void gitg_stage_setup_commit_hook_environment (GitgStage* self, GitgHook* hook, GgitSignature* author);
void gitg_hook_set_working_directory (GitgHook* self, GFile* value);
GeeHashMap* gitg_hook_get_environment (GitgHook* self);
static void gitg_stage_pre_commit_hook_data_free (gpointer _data);
void gitg_stage_pre_commit_hook (GitgStage* self, GgitSignature* author, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_stage_pre_commit_hook_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_pre_commit_hook_co (GitgStagePreCommitHookData* _data_);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void ___lambda15_ (Block24Data* _data24_, GError** error);
GitgHook* gitg_hook_new (const gchar* name);
GitgHook* gitg_hook_construct (GType object_type, const gchar* name);
gint gitg_hook_run_sync (GitgHook* self, GgitRepository* repository, GError** error);
gchar** gitg_hook_get_output (GitgHook* self, int* result_length1);
static void ____lambda15__gitg_async_thread_func (gpointer self, GError** error);
static void gitg_stage_pre_commit_hook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean gitg_stage_has_index_changes (GitgStage* self);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static gint ___lambda16_ (Block25Data* _data25_, const gchar* path, GgitStatusFlags flags);
static gint ____lambda16__ggit_status_callback (const gchar* path, GgitStatusFlags status_flags, gpointer self);
static void _vala_GgitStatusOptions_free (GgitStatusOptions* self);
static gchar* gitg_stage_commit_msg_hook (GitgStage* self, const gchar* message, GgitSignature* author, GgitSignature* committer, GError** error);
gboolean gitg_hook_exists_in (GitgHook* self, GgitRepository* repository);
void gitg_hook_add_argument (GitgHook* self, const gchar* arg);
static void gitg_stage_post_commit_hook (GitgStage* self, GgitSignature* author);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
void gitg_hook_run (GitgHook* self, GgitRepository* repository, GAsyncReadyCallback _callback_, gpointer _user_data_);
gint gitg_hook_run_finish (GitgHook* self, GAsyncResult* _res_, GError** error);
static void __lambda17_ (Block26Data* _data26_, GObject* obj, GAsyncResult* res);
static void ___lambda17__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gchar* gitg_stage_get_subject (GitgStage* self, const gchar* message);
static void _vala_GgitOId_free (GgitOId* self);
static void gitg_stage_commit_index_data_free (gpointer _data);
void gitg_stage_commit_index (GitgStage* self, GgitIndex* index, GgitRef* reference, const gchar* message, GgitSignature* author, GgitSignature* committer, GgitOId** parents, int parents_length1, GitgStageCommitOptions options, GAsyncReadyCallback _callback_, gpointer _user_data_);
GgitOId* gitg_stage_commit_index_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_commit_index_co (GitgStageCommitIndexData* _data_);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
static void __lambda18_ (Block27Data* _data27_, GError** error);
static void ___lambda18__gitg_async_thread_func (gpointer self, GError** error);
static void gitg_stage_commit_index_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void gitg_stage_commit_tree (GitgStage* self, GgitOId* treeoid, GgitRef* reference, const gchar* message, GgitSignature* author, GgitSignature* committer, GgitOId** parents, int parents_length1, GitgStageCommitOptions options, GAsyncReadyCallback _callback_, gpointer _user_data_);
GgitOId* gitg_stage_commit_tree_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static void gitg_stage_commit_tree_data_free (gpointer _data);
static GgitOId* _vala_GgitOId_copy (GgitOId* self);
static gboolean gitg_stage_commit_tree_co (GitgStageCommitTreeData* _data_);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static void __lambda19_ (Block28Data* _data28_, GError** error);
static GgitOId** _vala_array_dup21 (GgitOId** self, int length);
gpointer gitg_repository_lookup (GitgRepository* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GgitOId* id, GError** error);
static void ___lambda19__gitg_async_thread_func (gpointer self, GError** error);
static void gitg_stage_commit_tree_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_stage_commit_data_free (gpointer _data);
void gitg_stage_commit (GitgStage* self, const gchar* message, GgitSignature* author, GgitSignature* committer, GitgStageCommitOptions options, GAsyncReadyCallback _callback_, gpointer _user_data_);
GgitOId* gitg_stage_commit_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_commit_co (GitgStageCommitData* _data_);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static void ____lambda20_ (Block29Data* _data29_, GError** error);
static void _____lambda20__gitg_async_thread_func (gpointer self, GError** error);
static void gitg_stage_commit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GitgRef* gitg_repository_lookup_reference (GitgRepository* self, const gchar* name, GError** error);
static void gitg_stage_revert_data_free (gpointer _data);
void gitg_stage_revert (GitgStage* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_stage_revert_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_revert_co (GitgStageRevertData* _data_);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
static void gitg_stage_revert_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda21_ (Block30Data* _data30_, GgitIndex* index, GError** error);
static void ___lambda21__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error);
static void gitg_stage_revert_path_data_free (gpointer _data);
void gitg_stage_revert_path (GitgStage* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_stage_revert_path_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_revert_path_co (GitgStageRevertPathData* _data_);
static void gitg_stage_revert_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_stage_revert_patch_data_free (gpointer _data);
void gitg_stage_revert_patch (GitgStage* self, GitgPatchSet* patch, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_stage_revert_patch_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_revert_patch_co (GitgStageRevertPatchData* _data_);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
static void gitg_stage_revert_patch_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda22_ (Block31Data* _data31_, GgitIndex* index, GError** error);
static void gitg_stage_apply_patch_stream (GitgStage* self, GInputStream* old_stream, GInputStream* new_stream, GOutputStream* patched_stream, GitgPatchSet* patch, GError** error);
static void ___lambda22__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error);
static void gitg_stage_delete_data_free (gpointer _data);
void gitg_stage_delete (GitgStage* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_stage_delete_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_delete_co (GitgStageDeleteData* _data_);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
static void __lambda23_ (Block32Data* _data32_, GgitIndex* index, GError** error);
static void ___lambda23__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error);
static void gitg_stage_delete_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_stage_delete_path_data_free (gpointer _data);
void gitg_stage_delete_path (GitgStage* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_stage_delete_path_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_delete_path_co (GitgStageDeletePathData* _data_);
static void gitg_stage_delete_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_stage_stage_data_free (gpointer _data);
void gitg_stage_stage (GitgStage* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_stage_stage_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_stage_co (GitgStageStageData* _data_);
static Block33Data* block33_data_ref (Block33Data* _data33_);
static void block33_data_unref (void * _userdata_);
static void __lambda24_ (Block33Data* _data33_, GgitIndex* index, GError** error);
static void ___lambda24__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error);
static void gitg_stage_stage_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_stage_stage_path_data_free (gpointer _data);
void gitg_stage_stage_path (GitgStage* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_stage_stage_path_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_stage_path_co (GitgStageStagePathData* _data_);
static void gitg_stage_stage_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_stage_stage_commit_data_free (gpointer _data);
void gitg_stage_stage_commit (GitgStage* self, const gchar* path, GgitCommit* commit, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_stage_stage_commit_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_stage_commit_co (GitgStageStageCommitData* _data_);
static Block34Data* block34_data_ref (Block34Data* _data34_);
static void block34_data_unref (void * _userdata_);
static void __lambda25_ (Block34Data* _data34_, GgitIndex* index, GError** error);
static void ___lambda25__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error);
static void gitg_stage_stage_commit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_stage_copy_stream (GitgStage* self, GOutputStream* dest, GInputStream* src, gsize* pos, gsize index, gsize length, GError** error);
static void gitg_stage_apply_patch (GitgStage* self, GgitIndex* index, GInputStream* old_stream, GInputStream* new_stream, GitgPatchSet* patch, GError** error);
static void gitg_stage_stage_patch_data_free (gpointer _data);
void gitg_stage_stage_patch (GitgStage* self, GitgPatchSet* patch, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_stage_stage_patch_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_stage_patch_co (GitgStageStagePatchData* _data_);
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (void * _userdata_);
static void gitg_stage_stage_patch_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda26_ (Block35Data* _data35_, GgitIndex* index, GError** error);
static void ___lambda26__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error);
static void gitg_stage_unstage_data_free (gpointer _data);
void gitg_stage_unstage (GitgStage* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_stage_unstage_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_unstage_co (GitgStageUnstageData* _data_);
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
static void gitg_stage_unstage_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda27_ (Block36Data* _data36_, GgitIndex* index, GError** error);
static void ___lambda27__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error);
static void gitg_stage_unstage_path_data_free (gpointer _data);
void gitg_stage_unstage_path (GitgStage* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_stage_unstage_path_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_unstage_path_co (GitgStageUnstagePathData* _data_);
static void gitg_stage_unstage_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_stage_unstage_patch_data_free (gpointer _data);
void gitg_stage_unstage_patch (GitgStage* self, GitgPatchSet* patch, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_stage_unstage_patch_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_unstage_patch_co (GitgStageUnstagePatchData* _data_);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (void * _userdata_);
static void gitg_stage_unstage_patch_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda28_ (Block37Data* _data37_, GgitIndex* index, GError** error);
static void ___lambda28__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error);
static void gitg_stage_diff_index_all_data_free (gpointer _data);
GType gitg_stage_status_item_get_type (void) G_GNUC_CONST;
void gitg_stage_diff_index_all (GitgStage* self, GitgStageStatusItem** files, int files_length1, GgitDiffOptions* defopts, GAsyncReadyCallback _callback_, gpointer _user_data_);
GgitDiff* gitg_stage_diff_index_all_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_diff_index_all_co (GitgStageDiffIndexAllData* _data_);
gchar* gitg_stage_status_item_get_path (GitgStageStatusItem* self);
static void gitg_stage_diff_index_all_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_stage_diff_index_data_free (gpointer _data);
void gitg_stage_diff_index (GitgStage* self, GitgStageStatusItem* f, GgitDiffOptions* defopts, GAsyncReadyCallback _callback_, gpointer _user_data_);
GgitDiff* gitg_stage_diff_index_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_diff_index_co (GitgStageDiffIndexData* _data_);
static void gitg_stage_diff_index_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_stage_diff_workdir_all_data_free (gpointer _data);
void gitg_stage_diff_workdir_all (GitgStage* self, GitgStageStatusItem** files, int files_length1, GgitDiffOptions* defopts, GAsyncReadyCallback _callback_, gpointer _user_data_);
GgitDiff* gitg_stage_diff_workdir_all_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_diff_workdir_all_co (GitgStageDiffWorkdirAllData* _data_);
static void gitg_stage_diff_workdir_data_free (gpointer _data);
void gitg_stage_diff_workdir (GitgStage* self, GitgStageStatusItem* f, GgitDiffOptions* defopts, GAsyncReadyCallback _callback_, gpointer _user_data_);
GgitDiff* gitg_stage_diff_workdir_finish (GitgStage* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_stage_diff_workdir_co (GitgStageDiffWorkdirData* _data_);
static void gitg_stage_diff_workdir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_stage_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);


GType gitg_stage_commit_options_get_type (void) {
	static volatile gsize gitg_stage_commit_options_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_stage_commit_options_type_id__volatile)) {
		static const GFlagsValue values[] = {{GITG_STAGE_COMMIT_OPTIONS_NONE, "GITG_STAGE_COMMIT_OPTIONS_NONE", "none"}, {GITG_STAGE_COMMIT_OPTIONS_SIGN_OFF, "GITG_STAGE_COMMIT_OPTIONS_SIGN_OFF", "sign-off"}, {GITG_STAGE_COMMIT_OPTIONS_AMEND, "GITG_STAGE_COMMIT_OPTIONS_AMEND", "amend"}, {GITG_STAGE_COMMIT_OPTIONS_SKIP_HOOKS, "GITG_STAGE_COMMIT_OPTIONS_SKIP_HOOKS", "skip-hooks"}, {0, NULL, NULL}};
		GType gitg_stage_commit_options_type_id;
		gitg_stage_commit_options_type_id = g_flags_register_static ("GitgStageCommitOptions", values);
		g_once_init_leave (&gitg_stage_commit_options_type_id__volatile, gitg_stage_commit_options_type_id);
	}
	return gitg_stage_commit_options_type_id__volatile;
}


GQuark gitg_stage_error_quark (void) {
	return g_quark_from_static_string ("gitg_stage_error-quark");
}


GType gitg_patch_set_type_get_type (void) {
	static volatile gsize gitg_patch_set_type_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_patch_set_type_type_id__volatile)) {
		static const GEnumValue values[] = {{GITG_PATCH_SET_TYPE_ADD, "GITG_PATCH_SET_TYPE_ADD", "add"}, {GITG_PATCH_SET_TYPE_REMOVE, "GITG_PATCH_SET_TYPE_REMOVE", "remove"}, {0, NULL, NULL}};
		GType gitg_patch_set_type_type_id;
		gitg_patch_set_type_type_id = g_enum_register_static ("GitgPatchSetType", values);
		g_once_init_leave (&gitg_patch_set_type_type_id__volatile, gitg_patch_set_type_type_id);
	}
	return gitg_patch_set_type_type_id__volatile;
}


GitgPatchSet* gitg_patch_set_reversed (GitgPatchSet* self) {
	GitgPatchSet* result = NULL;
	GitgPatchSet* ret = NULL;
	GitgPatchSet* _tmp0_ = NULL;
	GitgPatchSet* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GitgPatchSet* _tmp4_ = NULL;
	GitgPatchSetPatch* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GitgPatchSetPatch* _tmp6_ = NULL;
#line 59 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = gitg_patch_set_new ();
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	ret = _tmp0_;
#line 63 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = ret;
#line 63 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = self->filename;
#line 63 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 63 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_tmp1_->filename);
#line 63 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_->filename = _tmp3_;
#line 64 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = ret;
#line 64 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp5_ = self->patches;
#line 64 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp5__length1 = self->patches_length1;
#line 64 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp6_ = g_new0 (GitgPatchSetPatch, _tmp5__length1);
#line 64 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_->patches = (g_free (_tmp4_->patches), NULL);
#line 64 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_->patches = _tmp6_;
#line 64 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_->patches_length1 = _tmp5__length1;
#line 1267 "gitg-stage.c"
	{
		gint i = 0;
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		i = 0;
#line 1272 "gitg-stage.c"
		{
			gboolean _tmp7_ = FALSE;
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp7_ = TRUE;
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			while (TRUE) {
#line 1279 "gitg-stage.c"
				gint _tmp9_ = 0;
				GitgPatchSetPatch* _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				GitgPatchSetPatch orig = {0};
				GitgPatchSetPatch* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint _tmp12_ = 0;
				GitgPatchSetPatch _tmp13_ = {0};
				GitgPatchSetPatch p = {0};
				GitgPatchSetPatch _tmp14_ = {0};
				gsize _tmp15_ = 0UL;
				GitgPatchSetPatch _tmp16_ = {0};
				gsize _tmp17_ = 0UL;
				GitgPatchSetPatch _tmp18_ = {0};
				gsize _tmp19_ = 0UL;
				GitgPatchSetPatch _tmp20_ = {0};
				GitgPatchSetPatch* _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				gint _tmp22_ = 0;
				GitgPatchSetPatch _tmp23_ = {0};
				GitgPatchSetType _tmp24_ = 0;
				GitgPatchSet* _tmp25_ = NULL;
				GitgPatchSetPatch* _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				gint _tmp27_ = 0;
				GitgPatchSetPatch _tmp28_ = {0};
				GitgPatchSetPatch _tmp29_ = {0};
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				if (!_tmp7_) {
#line 1309 "gitg-stage.c"
					gint _tmp8_ = 0;
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_tmp8_ = i;
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					i = _tmp8_ + 1;
#line 1315 "gitg-stage.c"
				}
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp7_ = FALSE;
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp9_ = i;
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp10_ = self->patches;
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp10__length1 = self->patches_length1;
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				if (!(_tmp9_ < _tmp10__length1)) {
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					break;
#line 1329 "gitg-stage.c"
				}
#line 68 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp11_ = self->patches;
#line 68 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp11__length1 = self->patches_length1;
#line 68 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp12_ = i;
#line 68 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp13_ = _tmp11_[_tmp12_];
#line 68 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				orig = _tmp13_;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp14_ = orig;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp15_ = _tmp14_.new_offset;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp16_ = orig;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp17_ = _tmp16_.old_offset;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp18_ = orig;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp19_ = _tmp18_.length;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				memset (&_tmp20_, 0, sizeof (GitgPatchSetPatch));
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp20_.old_offset = _tmp15_;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp20_.new_offset = _tmp17_;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp20_.length = _tmp19_;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				p = _tmp20_;
#line 76 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp21_ = self->patches;
#line 76 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp21__length1 = self->patches_length1;
#line 76 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp22_ = i;
#line 76 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp23_ = _tmp21_[_tmp22_];
#line 76 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp24_ = _tmp23_.type;
#line 76 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				switch (_tmp24_) {
#line 76 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					case GITG_PATCH_SET_TYPE_ADD:
#line 1377 "gitg-stage.c"
					{
#line 79 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
						p.type = GITG_PATCH_SET_TYPE_REMOVE;
#line 80 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
						break;
#line 1383 "gitg-stage.c"
					}
#line 76 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					case GITG_PATCH_SET_TYPE_REMOVE:
#line 1387 "gitg-stage.c"
					{
#line 82 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
						p.type = GITG_PATCH_SET_TYPE_ADD;
#line 83 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
						break;
#line 1393 "gitg-stage.c"
					}
					default:
#line 76 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					break;
#line 1398 "gitg-stage.c"
				}
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp25_ = ret;
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp26_ = _tmp25_->patches;
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp26__length1 = _tmp25_->patches_length1;
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp27_ = i;
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp28_ = p;
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp26_[_tmp27_] = _tmp28_;
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp29_ = _tmp26_[_tmp27_];
#line 1414 "gitg-stage.c"
			}
		}
	}
#line 89 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	result = ret;
#line 89 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return result;
#line 1422 "gitg-stage.c"
}


GitgPatchSet* gitg_patch_set_construct (GType object_type) {
	GitgPatchSet* self = NULL;
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = (GitgPatchSet*) g_type_create_instance (object_type);
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return self;
#line 1432 "gitg-stage.c"
}


GitgPatchSet* gitg_patch_set_new (void) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return gitg_patch_set_construct (GITG_TYPE_PATCH_SET);
#line 1439 "gitg-stage.c"
}


GitgPatchSetPatch* gitg_patch_set_patch_dup (const GitgPatchSetPatch* self) {
	GitgPatchSetPatch* dup;
#line 48 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	dup = g_new0 (GitgPatchSetPatch, 1);
#line 48 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	memcpy (dup, self, sizeof (GitgPatchSetPatch));
#line 48 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return dup;
#line 1451 "gitg-stage.c"
}


void gitg_patch_set_patch_free (GitgPatchSetPatch* self) {
#line 48 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_free (self);
#line 1458 "gitg-stage.c"
}


GType gitg_patch_set_patch_get_type (void) {
	static volatile gsize gitg_patch_set_patch_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_patch_set_patch_type_id__volatile)) {
		GType gitg_patch_set_patch_type_id;
		gitg_patch_set_patch_type_id = g_boxed_type_register_static ("GitgPatchSetPatch", (GBoxedCopyFunc) gitg_patch_set_patch_dup, (GBoxedFreeFunc) gitg_patch_set_patch_free);
		g_once_init_leave (&gitg_patch_set_patch_type_id__volatile, gitg_patch_set_patch_type_id);
	}
	return gitg_patch_set_patch_type_id__volatile;
}


static void gitg_value_patch_set_init (GValue* value) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	value->data[0].v_pointer = NULL;
#line 1476 "gitg-stage.c"
}


static void gitg_value_patch_set_free_value (GValue* value) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (value->data[0].v_pointer) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		gitg_patch_set_unref (value->data[0].v_pointer);
#line 1485 "gitg-stage.c"
	}
}


static void gitg_value_patch_set_copy_value (const GValue* src_value, GValue* dest_value) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (src_value->data[0].v_pointer) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		dest_value->data[0].v_pointer = gitg_patch_set_ref (src_value->data[0].v_pointer);
#line 1495 "gitg-stage.c"
	} else {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1499 "gitg-stage.c"
	}
}


static gpointer gitg_value_patch_set_peek_pointer (const GValue* value) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return value->data[0].v_pointer;
#line 1507 "gitg-stage.c"
}


static gchar* gitg_value_patch_set_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (collect_values[0].v_pointer) {
#line 1514 "gitg-stage.c"
		GitgPatchSet* object;
		object = collect_values[0].v_pointer;
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (object->parent_instance.g_class == NULL) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1521 "gitg-stage.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1525 "gitg-stage.c"
		}
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		value->data[0].v_pointer = gitg_patch_set_ref (object);
#line 1529 "gitg-stage.c"
	} else {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		value->data[0].v_pointer = NULL;
#line 1533 "gitg-stage.c"
	}
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return NULL;
#line 1537 "gitg-stage.c"
}


static gchar* gitg_value_patch_set_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GitgPatchSet** object_p;
	object_p = collect_values[0].v_pointer;
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (!object_p) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1548 "gitg-stage.c"
	}
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (!value->data[0].v_pointer) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		*object_p = NULL;
#line 1554 "gitg-stage.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		*object_p = value->data[0].v_pointer;
#line 1558 "gitg-stage.c"
	} else {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		*object_p = gitg_patch_set_ref (value->data[0].v_pointer);
#line 1562 "gitg-stage.c"
	}
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return NULL;
#line 1566 "gitg-stage.c"
}


GParamSpec* gitg_param_spec_patch_set (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GitgParamSpecPatchSet* spec;
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GITG_TYPE_PATCH_SET), NULL);
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return G_PARAM_SPEC (spec);
#line 1580 "gitg-stage.c"
}


gpointer gitg_value_get_patch_set (const GValue* value) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_PATCH_SET), NULL);
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return value->data[0].v_pointer;
#line 1589 "gitg-stage.c"
}


void gitg_value_set_patch_set (GValue* value, gpointer v_object) {
	GitgPatchSet* old;
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_PATCH_SET));
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	old = value->data[0].v_pointer;
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (v_object) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_PATCH_SET));
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		value->data[0].v_pointer = v_object;
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		gitg_patch_set_ref (value->data[0].v_pointer);
#line 1609 "gitg-stage.c"
	} else {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		value->data[0].v_pointer = NULL;
#line 1613 "gitg-stage.c"
	}
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (old) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		gitg_patch_set_unref (old);
#line 1619 "gitg-stage.c"
	}
}


void gitg_value_take_patch_set (GValue* value, gpointer v_object) {
	GitgPatchSet* old;
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_PATCH_SET));
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	old = value->data[0].v_pointer;
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (v_object) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_PATCH_SET));
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		value->data[0].v_pointer = v_object;
#line 1638 "gitg-stage.c"
	} else {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		value->data[0].v_pointer = NULL;
#line 1642 "gitg-stage.c"
	}
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (old) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		gitg_patch_set_unref (old);
#line 1648 "gitg-stage.c"
	}
}


static void gitg_patch_set_class_init (GitgPatchSetClass * klass) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_patch_set_parent_class = g_type_class_peek_parent (klass);
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	((GitgPatchSetClass *) klass)->finalize = gitg_patch_set_finalize;
#line 1658 "gitg-stage.c"
}


static void gitg_patch_set_instance_init (GitgPatchSet * self) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self->ref_count = 1;
#line 1665 "gitg-stage.c"
}


static void gitg_patch_set_finalize (GitgPatchSet* obj) {
	GitgPatchSet * self;
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_PATCH_SET, GitgPatchSet);
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_signal_handlers_destroy (self);
#line 56 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (self->filename);
#line 57 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self->patches = (g_free (self->patches), NULL);
#line 1679 "gitg-stage.c"
}


GType gitg_patch_set_get_type (void) {
	static volatile gsize gitg_patch_set_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_patch_set_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gitg_value_patch_set_init, gitg_value_patch_set_free_value, gitg_value_patch_set_copy_value, gitg_value_patch_set_peek_pointer, "p", gitg_value_patch_set_collect_value, "p", gitg_value_patch_set_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GitgPatchSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_patch_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgPatchSet), 0, (GInstanceInitFunc) gitg_patch_set_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gitg_patch_set_type_id;
		gitg_patch_set_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgPatchSet", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gitg_patch_set_type_id__volatile, gitg_patch_set_type_id);
	}
	return gitg_patch_set_type_id__volatile;
}


gpointer gitg_patch_set_ref (gpointer instance) {
	GitgPatchSet* self;
	self = instance;
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_atomic_int_inc (&self->ref_count);
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return instance;
#line 1704 "gitg-stage.c"
}


void gitg_patch_set_unref (gpointer instance) {
	GitgPatchSet* self;
	self = instance;
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		GITG_PATCH_SET_GET_CLASS (self)->finalize (self);
#line 40 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1717 "gitg-stage.c"
	}
}


GitgStage* gitg_stage_construct (GType object_type, GitgRepository* repository) {
	GitgStage * self = NULL;
	GitgRepository* _tmp0_ = NULL;
#line 99 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (repository != NULL, NULL);
#line 99 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = (GitgStage*) g_object_new (object_type, NULL);
#line 101 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = repository;
#line 101 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self->priv->d_repository = _tmp0_;
#line 99 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return self;
#line 1735 "gitg-stage.c"
}


GitgStage* gitg_stage_new (GitgRepository* repository) {
#line 99 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return gitg_stage_construct (GITG_TYPE_STAGE, repository);
#line 1742 "gitg-stage.c"
}


static void gitg_stage_refresh_data_free (gpointer _data) {
	GitgStageRefreshData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageRefreshData, _data_);
#line 1753 "gitg-stage.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return self ? g_object_ref (self) : NULL;
#line 1760 "gitg-stage.c"
}


void gitg_stage_refresh (GitgStage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageRefreshData* _data_;
	GitgStage* _tmp0_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageRefreshData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_refresh);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_refresh_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_refresh_co (_data_);
#line 1779 "gitg-stage.c"
}


void gitg_stage_refresh_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GitgStageRefreshData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 1789 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1793 "gitg-stage.c"
}


static void __lambda6_ (GitgStage* self, GgitIndex* index, GError** error) {
	GgitIndex* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (index != NULL);
#line 109 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = index;
#line 109 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	ggit_index_read (_tmp0_, FALSE, &_inner_error_);
#line 109 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 109 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 109 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 1812 "gitg-stage.c"
	}
}


static void ___lambda6__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error) {
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__lambda6_ ((GitgStage*) self, index, error);
#line 1820 "gitg-stage.c"
}


static void gitg_stage_refresh_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageRefreshData* _data_;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_refresh_co (_data_);
#line 1834 "gitg-stage.c"
}


static gboolean gitg_stage_refresh_co (GitgStageRefreshData* _data_) {
#line 104 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 104 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 1843 "gitg-stage.c"
		goto _state_0;
#line 104 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 1847 "gitg-stage.c"
		goto _state_1;
		default:
#line 104 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 1852 "gitg-stage.c"
	}
	_state_0:
#line 106 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self->priv->d_head_tree);
#line 106 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self->priv->d_head_tree = NULL;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index (_data_->self, ___lambda6__gitg_stage_with_index_func, _data_->self, gitg_stage_refresh_ready, _data_);
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 1865 "gitg-stage.c"
	_state_1:
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1879 "gitg-stage.c"
		} else {
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1883 "gitg-stage.c"
		}
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 1889 "gitg-stage.c"
	}
#line 104 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 104 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1895 "gitg-stage.c"
	} else {
#line 104 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1899 "gitg-stage.c"
	}
#line 104 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 104 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 1905 "gitg-stage.c"
}


static void gitg_stage_get_head_tree_data_free (gpointer _data) {
	GitgStageGetHeadTreeData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->result);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageGetHeadTreeData, _data_);
#line 1918 "gitg-stage.c"
}


void gitg_stage_get_head_tree (GitgStage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageGetHeadTreeData* _data_;
	GitgStage* _tmp0_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageGetHeadTreeData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_get_head_tree);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_get_head_tree_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_get_head_tree_co (_data_);
#line 1937 "gitg-stage.c"
}


GgitTree* gitg_stage_get_head_tree_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GgitTree* result;
	GitgStageGetHeadTreeData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return NULL;
#line 1948 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	result = _data_->result;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->result = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return result;
#line 1958 "gitg-stage.c"
}


static Block22Data* block22_data_ref (Block22Data* _data22_) {
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_atomic_int_inc (&_data22_->_ref_count_);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return _data22_;
#line 1967 "gitg-stage.c"
}


static void block22_data_unref (void * _userdata_) {
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
#line 1976 "gitg-stage.c"
		GitgStage* self;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self = _data22_->self;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_error_free0 (_data22_->e);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_slice_free (Block22Data, _data22_);
#line 1986 "gitg-stage.c"
	}
}


static gpointer _g_error_copy0 (gpointer self) {
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return self ? g_error_copy (self) : NULL;
#line 1994 "gitg-stage.c"
}


static void __lambda7_ (Block22Data* _data22_, GError** error) {
	GitgStage* self;
	GError * _inner_error_ = NULL;
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = _data22_->self;
#line 2003 "gitg-stage.c"
	{
		GitgRef* head = NULL;
		GitgRepository* _tmp0_ = NULL;
		GitgRef* _tmp1_ = NULL;
		GgitObject* _tmp2_ = NULL;
		GitgRef* _tmp3_ = NULL;
		GgitObject* _tmp4_ = NULL;
		GgitCommit* commit = NULL;
		GgitObject* _tmp5_ = NULL;
		GgitCommit* _tmp6_ = NULL;
		GgitTree* _tmp7_ = NULL;
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp0_ = self->priv->d_repository;
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp1_ = gitg_repository_get_head (_tmp0_, &_inner_error_);
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		head = _tmp1_;
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2023 "gitg-stage.c"
			goto __catch92_g_error;
		}
#line 126 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp3_ = head;
#line 126 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp4_ = ggit_ref_lookup ((GgitRef*) _tmp3_, &_inner_error_);
#line 126 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp2_ = _tmp4_;
#line 126 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 126 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (head);
#line 2036 "gitg-stage.c"
			goto __catch92_g_error;
		}
#line 126 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp5_ = _tmp2_;
#line 126 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp2_ = NULL;
#line 126 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		commit = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, ggit_commit_get_type (), GgitCommit);
#line 128 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp6_ = commit;
#line 128 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp7_ = ggit_commit_get_tree (_tmp6_);
#line 128 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self->priv->d_head_tree);
#line 128 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self->priv->d_head_tree = _tmp7_;
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (commit);
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_tmp2_);
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (head);
#line 2059 "gitg-stage.c"
	}
	goto __finally92;
	__catch92_g_error:
	{
		GError* err = NULL;
		GError* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		err = _inner_error_;
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = NULL;
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp8_ = err;
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp9_ = _g_error_copy0 (_tmp8_);
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_error_free0 (_data22_->e);
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data22_->e = _tmp9_;
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_error_free0 (err);
#line 2081 "gitg-stage.c"
	}
	__finally92:
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 123 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 2090 "gitg-stage.c"
	}
}


static void ___lambda7__gitg_async_thread_func (gpointer self, GError** error) {
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__lambda7_ (self, error);
#line 2098 "gitg-stage.c"
}


static void gitg_stage_get_head_tree_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageGetHeadTreeData* _data_;
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_get_head_tree_co (_data_);
#line 2112 "gitg-stage.c"
}


static gboolean gitg_stage_get_head_tree_co (GitgStageGetHeadTreeData* _data_) {
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 2121 "gitg-stage.c"
		goto _state_0;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 2125 "gitg-stage.c"
		goto _state_1;
		default:
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 2130 "gitg-stage.c"
	}
	_state_0:
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data22_ = g_slice_new0 (Block22Data);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data22_->_ref_count_ = 1;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data22_->self = g_object_ref (_data_->self);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data22_->_async_data_ = _data_;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->self->priv->d_head_tree;
#line 115 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_tmp0_ != NULL) {
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp1_ = NULL;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp1_ = _data_->self->priv->d_head_tree;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp2_ = NULL;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->result = _data_->_tmp2_;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block22_data_unref (_data_->_data22_);
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data22_ = NULL;
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2165 "gitg-stage.c"
		} else {
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2169 "gitg-stage.c"
		}
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 117 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 2175 "gitg-stage.c"
	}
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data22_->e = NULL;
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_async_thread (___lambda7__gitg_async_thread_func, _data_->_data22_, gitg_stage_get_head_tree_ready, _data_);
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 2185 "gitg-stage.c"
	_state_1:
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error_);
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block22_data_unref (_data_->_data22_);
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data22_ = NULL;
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2203 "gitg-stage.c"
		} else {
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2207 "gitg-stage.c"
		}
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 2213 "gitg-stage.c"
	}
#line 136 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = NULL;
#line 136 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = _data_->_data22_->e;
#line 136 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_tmp3_ != NULL) {
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp4_ = NULL;
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp4_ = _data_->_data22_->e;
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp5_ = NULL;
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp5_ = _g_error_copy0 (_data_->_tmp4_);
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_inner_error_ = _data_->_tmp5_;
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block22_data_unref (_data_->_data22_);
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data22_ = NULL;
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2243 "gitg-stage.c"
		} else {
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2247 "gitg-stage.c"
		}
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 2253 "gitg-stage.c"
	}
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp6_ = NULL;
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp6_ = _data_->self->priv->d_head_tree;
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7_ = NULL;
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->result = _data_->_tmp7_;
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block22_data_unref (_data_->_data22_);
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data22_ = NULL;
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2273 "gitg-stage.c"
	} else {
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2277 "gitg-stage.c"
	}
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block22_data_unref (_data_->_data22_);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data22_ = NULL;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2291 "gitg-stage.c"
	} else {
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2295 "gitg-stage.c"
	}
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 2301 "gitg-stage.c"
}


GitgStageStatusEnumerator* gitg_stage_file_status (GitgStage* self, GgitStatusOptions* options) {
	GitgStageStatusEnumerator* result = NULL;
	GitgRepository* _tmp0_ = NULL;
	GgitStatusOptions* _tmp1_ = NULL;
	GitgStageStatusEnumerator* _tmp2_ = NULL;
#line 144 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 146 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = self->priv->d_repository;
#line 146 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = options;
#line 146 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = gitg_stage_status_enumerator_new (_tmp0_, _tmp1_);
#line 146 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	result = _tmp2_;
#line 146 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return result;
#line 2322 "gitg-stage.c"
}


static void gitg_stage_with_index (GitgStage* self, GitgStageWithIndexFunc func, void* func_target, GError** error) {
	GError * _inner_error_ = NULL;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (self != NULL);
#line 2330 "gitg-stage.c"
	{
#line 153 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_rec_mutex_lock (&self->priv->__lock_d_index_mutex);
#line 2334 "gitg-stage.c"
		{
			GgitIndex* _tmp0_ = NULL;
			GitgRepository* _tmp1_ = NULL;
			GgitIndex* _tmp2_ = NULL;
			GitgStageWithIndexFunc _tmp3_ = NULL;
			void* _tmp3__target = NULL;
#line 155 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp1_ = self->priv->d_repository;
#line 155 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp2_ = ggit_repository_get_index ((GgitRepository*) _tmp1_, &_inner_error_);
#line 155 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp0_ = _tmp2_;
#line 155 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2349 "gitg-stage.c"
				goto __finally93;
			}
#line 155 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp3_ = func;
#line 155 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp3__target = func_target;
#line 155 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp3_ (_tmp0_, _tmp3__target, &_inner_error_);
#line 155 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 155 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_g_object_unref0 (_tmp0_);
#line 2362 "gitg-stage.c"
				goto __finally93;
			}
#line 153 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (_tmp0_);
#line 2367 "gitg-stage.c"
		}
		__finally93:
		{
#line 153 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_rec_mutex_unlock (&self->priv->__lock_d_index_mutex);
#line 2373 "gitg-stage.c"
		}
#line 153 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 153 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_propagate_error (error, _inner_error_);
#line 153 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return;
#line 2381 "gitg-stage.c"
		}
	}
}


static void gitg_stage_thread_index_data_free (gpointer _data) {
	GitgStageThreadIndexData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageThreadIndexData, _data_);
#line 2394 "gitg-stage.c"
}


static void gitg_stage_thread_index (GitgStage* self, GitgStageWithIndexFunc func, void* func_target, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageThreadIndexData* _data_;
	GitgStage* _tmp0_ = NULL;
	GitgStageWithIndexFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageThreadIndexData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_thread_index);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_thread_index_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = func;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1__target = func_target;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->func = _tmp1_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->func_target = _tmp1__target;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index_co (_data_);
#line 2423 "gitg-stage.c"
}


static void gitg_stage_thread_index_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GitgStageThreadIndexData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 2433 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2437 "gitg-stage.c"
}


static Block23Data* block23_data_ref (Block23Data* _data23_) {
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_atomic_int_inc (&_data23_->_ref_count_);
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return _data23_;
#line 2446 "gitg-stage.c"
}


static void block23_data_unref (void * _userdata_) {
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
#line 2455 "gitg-stage.c"
		GitgStage* self;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self = _data23_->self;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self);
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_slice_free (Block23Data, _data23_);
#line 2463 "gitg-stage.c"
	}
}


static void __lambda5_ (Block23Data* _data23_, GError** error) {
	GitgStage* self;
	GitgStageWithIndexFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GError * _inner_error_ = NULL;
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = _data23_->self;
#line 162 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _data23_->func;
#line 162 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0__target = _data23_->func_target;
#line 162 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_with_index (self, _tmp0_, _tmp0__target, &_inner_error_);
#line 162 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 162 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 162 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 2487 "gitg-stage.c"
	}
}


static void ___lambda5__gitg_async_thread_func (gpointer self, GError** error) {
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__lambda5_ (self, error);
#line 2495 "gitg-stage.c"
}


static void gitg_stage_thread_index_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageThreadIndexData* _data_;
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index_co (_data_);
#line 2509 "gitg-stage.c"
}


static gboolean gitg_stage_thread_index_co (GitgStageThreadIndexData* _data_) {
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 2518 "gitg-stage.c"
		goto _state_0;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 2522 "gitg-stage.c"
		goto _state_1;
		default:
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 2527 "gitg-stage.c"
	}
	_state_0:
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data23_ = g_slice_new0 (Block23Data);
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data23_->_ref_count_ = 1;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data23_->self = g_object_ref (_data_->self);
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0__target = NULL;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->func;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0__target = _data_->func_target;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data23_->func = _data_->_tmp0_;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data23_->func_target = _data_->_tmp0__target;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data23_->_async_data_ = _data_;
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_async_thread (___lambda5__gitg_async_thread_func, _data_->_data23_, gitg_stage_thread_index_ready, _data_);
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 2556 "gitg-stage.c"
	_state_1:
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error_);
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block23_data_unref (_data_->_data23_);
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data23_ = NULL;
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2574 "gitg-stage.c"
		} else {
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2578 "gitg-stage.c"
		}
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 2584 "gitg-stage.c"
	}
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block23_data_unref (_data_->_data23_);
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data23_ = NULL;
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2594 "gitg-stage.c"
	} else {
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2598 "gitg-stage.c"
	}
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 2604 "gitg-stage.c"
}


static gchar* gitg_stage_message_with_sign_off (GitgStage* self, const gchar* message, GgitSignature* committer) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GgitSignature* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GgitSignature* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 166 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 166 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (message != NULL, NULL);
#line 166 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (committer != NULL, NULL);
#line 169 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = message;
#line 169 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = committer;
#line 169 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = ggit_signature_get_name (_tmp1_);
#line 169 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = committer;
#line 169 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = ggit_signature_get_email (_tmp3_);
#line 169 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp5_ = g_strdup_printf ("%s\nSigned-off-by: %s <%s>\n", _tmp0_, _tmp2_, _tmp4_);
#line 169 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	result = _tmp5_;
#line 169 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return result;
#line 2638 "gitg-stage.c"
}


static gchar* gitg_stage_convert_message_to_encoding (GitgStage* self, GgitConfig* conf, const gchar* message, gchar** encoding) {
	gchar* _vala_encoding = NULL;
	gchar* result = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
#line 174 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 174 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (conf != NULL, NULL);
#line 174 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (message != NULL, NULL);
#line 178 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_vala_encoding);
#line 178 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_vala_encoding = NULL;
#line 2661 "gitg-stage.c"
	{
		const gchar* _tmp0_ = NULL;
		GgitConfig* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 182 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp1_ = conf;
#line 182 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp2_ = ggit_config_get_string (_tmp1_, "i18n.commitencoding", &_inner_error_);
#line 182 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp0_ = _tmp2_;
#line 182 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2675 "gitg-stage.c"
			goto __catch94_g_error;
		}
#line 182 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp3_ = g_strdup (_tmp0_);
#line 182 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (_vala_encoding);
#line 182 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_vala_encoding = _tmp3_;
#line 2684 "gitg-stage.c"
	}
	goto __finally94;
	__catch94_g_error:
	{
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_clear_error (&_inner_error_);
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = NULL;
#line 186 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (_vala_encoding);
#line 186 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_vala_encoding = NULL;
#line 187 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp4_ = message;
#line 187 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 187 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		result = _tmp5_;
#line 187 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (encoding) {
#line 187 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			*encoding = _vala_encoding;
#line 2709 "gitg-stage.c"
		} else {
#line 187 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (_vala_encoding);
#line 2713 "gitg-stage.c"
		}
#line 187 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return result;
#line 2717 "gitg-stage.c"
	}
	__finally94:
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_clear_error (&_inner_error_);
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return NULL;
#line 2728 "gitg-stage.c"
	}
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp8_ = _vala_encoding;
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_tmp8_ != NULL) {
#line 2734 "gitg-stage.c"
		const gchar* _tmp9_ = NULL;
#line 191 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp9_ = _vala_encoding;
#line 191 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp7_ = g_strcmp0 (_tmp9_, "") != 0;
#line 2740 "gitg-stage.c"
	} else {
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp7_ = FALSE;
#line 2744 "gitg-stage.c"
	}
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_tmp7_) {
#line 2748 "gitg-stage.c"
		const gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp10_ = _vala_encoding;
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp11_ = g_ascii_strcasecmp (_tmp10_, "UTF-8");
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp6_ = _tmp11_ != 0;
#line 2757 "gitg-stage.c"
	} else {
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp6_ = FALSE;
#line 2761 "gitg-stage.c"
	}
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_tmp6_) {
#line 2765 "gitg-stage.c"
		{
			gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp13_ = message;
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp14_ = _vala_encoding;
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp15_ = g_convert (_tmp13_, (gssize) -1, _tmp14_, "UTF-8", NULL, NULL, &_inner_error_);
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp12_ = _tmp15_;
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2782 "gitg-stage.c"
				goto __catch95_g_error;
			}
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp16_ = _tmp12_;
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp12_ = NULL;
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			result = _tmp16_;
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (_tmp12_);
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (encoding) {
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				*encoding = _vala_encoding;
#line 2797 "gitg-stage.c"
			} else {
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_g_free0 (_vala_encoding);
#line 2801 "gitg-stage.c"
			}
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return result;
#line 2805 "gitg-stage.c"
		}
		goto __finally95;
		__catch95_g_error:
		{
#line 194 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_clear_error (&_inner_error_);
#line 194 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_inner_error_ = NULL;
#line 200 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (_vala_encoding);
#line 200 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_vala_encoding = NULL;
#line 2818 "gitg-stage.c"
		}
		__finally95:
#line 194 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 194 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 194 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_clear_error (&_inner_error_);
#line 194 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return NULL;
#line 2829 "gitg-stage.c"
		}
	} else {
#line 205 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (_vala_encoding);
#line 205 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_vala_encoding = NULL;
#line 2836 "gitg-stage.c"
	}
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp17_ = message;
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp18_ = g_strdup (_tmp17_);
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	result = _tmp18_;
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (encoding) {
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		*encoding = _vala_encoding;
#line 2848 "gitg-stage.c"
	} else {
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (_vala_encoding);
#line 2852 "gitg-stage.c"
	}
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return result;
#line 2856 "gitg-stage.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1412 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1413 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = self;
#line 1413 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 2868 "gitg-stage.c"
}


static void gitg_stage_setup_commit_hook_environment (GitgStage* self, GitgHook* hook, GgitSignature* author) {
	GFile* wd = NULL;
	GitgRepository* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* gd = NULL;
	GitgRepository* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GitgHook* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* gitdir = NULL;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GitgHook* _tmp9_ = NULL;
	GeeHashMap* _tmp10_ = NULL;
	GeeHashMap* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GitgHook* _tmp13_ = NULL;
	GeeHashMap* _tmp14_ = NULL;
	GeeHashMap* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	GitgHook* _tmp19_ = NULL;
	GeeHashMap* _tmp20_ = NULL;
	GeeHashMap* _tmp21_ = NULL;
	GgitSignature* _tmp22_ = NULL;
#line 211 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (self != NULL);
#line 211 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (hook != NULL);
#line 214 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = self->priv->d_repository;
#line 214 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _tmp0_);
#line 214 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	wd = _tmp1_;
#line 215 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = self->priv->d_repository;
#line 215 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = ggit_repository_get_location ((GgitRepository*) _tmp2_);
#line 215 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gd = _tmp3_;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = hook;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp5_ = wd;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_hook_set_working_directory (_tmp4_, _tmp5_);
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp6_ = wd;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp7_ = gd;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp8_ = g_file_get_relative_path (_tmp6_, _tmp7_);
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitdir = _tmp8_;
#line 221 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp9_ = hook;
#line 221 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp10_ = gitg_hook_get_environment (_tmp9_);
#line 221 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp11_ = _tmp10_;
#line 221 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp12_ = gitdir;
#line 221 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, "GIT_DIR", _tmp12_);
#line 222 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp13_ = hook;
#line 222 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp14_ = gitg_hook_get_environment (_tmp13_);
#line 222 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp15_ = _tmp14_;
#line 222 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp16_ = gitdir;
#line 222 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp17_ = g_build_filename (_tmp16_, "index", NULL);
#line 222 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp18_ = _tmp17_;
#line 222 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, "GIT_INDEX_FILE", _tmp18_);
#line 222 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_tmp18_);
#line 223 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp19_ = hook;
#line 223 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp20_ = gitg_hook_get_environment (_tmp19_);
#line 223 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp21_ = _tmp20_;
#line 223 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, "GIT_PREFIX", ".");
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp22_ = author;
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_tmp22_ != NULL) {
#line 2967 "gitg-stage.c"
		GitgHook* _tmp23_ = NULL;
		GeeHashMap* _tmp24_ = NULL;
		GeeHashMap* _tmp25_ = NULL;
		GgitSignature* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		GitgHook* _tmp28_ = NULL;
		GeeHashMap* _tmp29_ = NULL;
		GeeHashMap* _tmp30_ = NULL;
		GgitSignature* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		GDateTime* date = NULL;
		GgitSignature* _tmp33_ = NULL;
		GDateTime* _tmp34_ = NULL;
		gint64 un = 0LL;
		GDateTime* _tmp35_ = NULL;
		gint64 _tmp36_ = 0LL;
		gchar* tz = NULL;
		GDateTime* _tmp37_ = NULL;
		GgitSignature* _tmp38_ = NULL;
		GTimeZone* _tmp39_ = NULL;
		GTimeZone* _tmp40_ = NULL;
		GDateTime* _tmp41_ = NULL;
		GDateTime* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		GitgHook* _tmp45_ = NULL;
		GeeHashMap* _tmp46_ = NULL;
		GeeHashMap* _tmp47_ = NULL;
		gint64 _tmp48_ = 0LL;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		const gchar* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp23_ = hook;
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp24_ = gitg_hook_get_environment (_tmp23_);
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp25_ = _tmp24_;
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp26_ = author;
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp27_ = ggit_signature_get_name (_tmp26_);
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp25_, "GIT_AUTHOR_NAME", _tmp27_);
#line 228 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp28_ = hook;
#line 228 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp29_ = gitg_hook_get_environment (_tmp28_);
#line 228 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp30_ = _tmp29_;
#line 228 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp31_ = author;
#line 228 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp32_ = ggit_signature_get_email (_tmp31_);
#line 228 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp30_, "GIT_AUTHOR_EMAIL", _tmp32_);
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp33_ = author;
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp34_ = ggit_signature_get_time (_tmp33_);
#line 230 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		date = _tmp34_;
#line 232 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp35_ = date;
#line 232 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp36_ = g_date_time_to_unix (_tmp35_);
#line 232 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		un = _tmp36_;
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp37_ = date;
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp38_ = author;
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp39_ = ggit_signature_get_time_zone (_tmp38_);
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp40_ = _tmp39_;
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp41_ = g_date_time_to_timezone (_tmp37_, _tmp40_);
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp42_ = _tmp41_;
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp43_ = g_date_time_format (_tmp42_, "%z");
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp44_ = _tmp43_;
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_date_time_unref0 (_tmp42_);
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_time_zone_unref0 (_tmp40_);
#line 233 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		tz = _tmp44_;
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp45_ = hook;
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp46_ = gitg_hook_get_environment (_tmp45_);
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp47_ = _tmp46_;
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp48_ = un;
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp49_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp48_);
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp50_ = _tmp49_;
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp51_ = tz;
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp52_ = string_to_string (_tmp51_);
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp53_ = g_strconcat ("@", _tmp50_, " ", _tmp52_, NULL);
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp54_ = _tmp53_;
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp47_, "GIT_AUTHOR_DATE", _tmp54_);
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (_tmp54_);
#line 235 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (_tmp50_);
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (tz);
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_date_time_unref0 (date);
#line 3091 "gitg-stage.c"
	}
#line 211 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (gitdir);
#line 211 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (gd);
#line 211 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (wd);
#line 3099 "gitg-stage.c"
}


static void gitg_stage_pre_commit_hook_data_free (gpointer _data) {
	GitgStagePreCommitHookData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStagePreCommitHookData, _data_);
#line 3110 "gitg-stage.c"
}


void gitg_stage_pre_commit_hook (GitgStage* self, GgitSignature* author, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStagePreCommitHookData* _data_;
	GitgStage* _tmp0_ = NULL;
	GgitSignature* _tmp1_ = NULL;
	GgitSignature* _tmp2_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStagePreCommitHookData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_pre_commit_hook);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_pre_commit_hook_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = author;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->author);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->author = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_pre_commit_hook_co (_data_);
#line 3139 "gitg-stage.c"
}


void gitg_stage_pre_commit_hook_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GitgStagePreCommitHookData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 3149 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3153 "gitg-stage.c"
}


static Block24Data* block24_data_ref (Block24Data* _data24_) {
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_atomic_int_inc (&_data24_->_ref_count_);
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return _data24_;
#line 3162 "gitg-stage.c"
}


static void block24_data_unref (void * _userdata_) {
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
#line 3171 "gitg-stage.c"
		GitgStage* self;
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self = _data24_->self;
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (_data24_->errormsg);
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data24_->author);
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self);
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_slice_free (Block24Data, _data24_);
#line 3183 "gitg-stage.c"
	}
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 1054 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = separator;
#line 1054 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp0_ == NULL) {
#line 1055 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		separator = "";
#line 3201 "gitg-stage.c"
	}
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = str_array;
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3__length1 = str_array_length1;
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = TRUE;
#line 3211 "gitg-stage.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = str_array;
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4__length1 = str_array_length1;
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp4__length1 > 0;
#line 3221 "gitg-stage.c"
	}
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp2_) {
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 3227 "gitg-stage.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = str_array;
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6__length1 = str_array_length1;
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (_tmp6__length1 == -1) {
#line 3238 "gitg-stage.c"
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp7_ = str_array;
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp7__length1 = str_array_length1;
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp8_ = _tmp7_[0];
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp5_ = _tmp8_ != NULL;
#line 3250 "gitg-stage.c"
		} else {
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 3254 "gitg-stage.c"
		}
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = _tmp5_;
#line 3258 "gitg-stage.c"
	}
#line 1057 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 3262 "gitg-stage.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
#line 1059 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 3285 "gitg-stage.c"
		{
			gboolean _tmp9_ = FALSE;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			i = 0;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp9_ = TRUE;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 3294 "gitg-stage.c"
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (!_tmp9_) {
#line 3307 "gitg-stage.c"
					gint _tmp10_ = 0;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp10_ = i;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					i = _tmp10_ + 1;
#line 3313 "gitg-stage.c"
				}
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp9_ = FALSE;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp13_ = str_array;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp13__length1 = str_array_length1;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (_tmp13__length1 != -1) {
#line 3323 "gitg-stage.c"
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp14_ = i;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp15_ = str_array;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp15__length1 = str_array_length1;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp14_ < _tmp15__length1;
#line 3335 "gitg-stage.c"
				} else {
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp12_ = FALSE;
#line 3339 "gitg-stage.c"
				}
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (_tmp12_) {
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp11_ = TRUE;
#line 3345 "gitg-stage.c"
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp17_ = str_array;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp17__length1 = str_array_length1;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					if (_tmp17__length1 == -1) {
#line 3356 "gitg-stage.c"
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp18_ = str_array;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp18__length1 = str_array_length1;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp19_ = i;
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp20_ = _tmp18_[_tmp19_];
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp16_ = _tmp20_ != NULL;
#line 3371 "gitg-stage.c"
					} else {
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp16_ = FALSE;
#line 3375 "gitg-stage.c"
					}
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp11_ = _tmp16_;
#line 3379 "gitg-stage.c"
				}
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (!_tmp11_) {
#line 1060 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					break;
#line 3385 "gitg-stage.c"
				}
#line 1061 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp22_ = str_array;
#line 1061 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp22__length1 = str_array_length1;
#line 1061 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp23_ = i;
#line 1061 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp24_ = _tmp22_[_tmp23_];
#line 1061 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (_tmp24_ != NULL) {
#line 3397 "gitg-stage.c"
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
#line 1061 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp25_ = str_array;
#line 1061 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp25__length1 = str_array_length1;
#line 1061 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp26_ = i;
#line 1061 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp27_ = _tmp25_[_tmp26_];
#line 1061 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp28_ = strlen ((const gchar*) _tmp27_);
#line 1061 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp29_ = _tmp28_;
#line 1061 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp21_ = _tmp29_;
#line 3418 "gitg-stage.c"
				} else {
#line 1061 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp21_ = 0;
#line 3422 "gitg-stage.c"
				}
#line 1061 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp30_ = len;
#line 1061 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				len = _tmp30_ + _tmp21_;
#line 3428 "gitg-stage.c"
			}
		}
#line 1063 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp31_ = i;
#line 1063 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (_tmp31_ == 0) {
#line 3435 "gitg-stage.c"
			gchar* _tmp32_ = NULL;
#line 1064 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp32_ = g_strdup ("");
#line 1064 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			result = _tmp32_;
#line 1064 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			return result;
#line 3443 "gitg-stage.c"
		}
#line 1066 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp33_ = i;
#line 1066 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp33_;
#line 1066 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp34_ = str_array_length1;
#line 1067 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp35_ = len;
#line 1067 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp36_ = separator;
#line 1067 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp37_ = strlen ((const gchar*) _tmp36_);
#line 1067 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp38_ = _tmp37_;
#line 1067 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp39_ = i;
#line 1067 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp40_ = len;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp41_ = g_malloc (_tmp40_);
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		res = _tmp41_;
#line 1070 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp42_ = res;
#line 1070 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp43_ = str_array;
#line 1070 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp43__length1 = str_array_length1;
#line 1070 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp44_ = _tmp43_[0];
#line 1070 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
#line 1070 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		ptr = _tmp45_;
#line 3481 "gitg-stage.c"
		{
			gboolean _tmp46_ = FALSE;
#line 1071 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			i = 1;
#line 1071 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp46_ = TRUE;
#line 1071 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 3490 "gitg-stage.c"
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
#line 1071 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (!_tmp46_) {
#line 3506 "gitg-stage.c"
					gint _tmp47_ = 0;
#line 1071 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp47_ = i;
#line 1071 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					i = _tmp47_ + 1;
#line 3512 "gitg-stage.c"
				}
#line 1071 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp46_ = FALSE;
#line 1071 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp48_ = i;
#line 1071 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp49_ = str_array;
#line 1071 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp49__length1 = str_array_length1;
#line 1071 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (!(_tmp48_ < _tmp49__length1)) {
#line 1071 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					break;
#line 3526 "gitg-stage.c"
				}
#line 1072 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp50_ = ptr;
#line 1072 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp51_ = separator;
#line 1072 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
#line 1072 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				ptr = _tmp52_;
#line 1073 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp54_ = str_array;
#line 1073 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp54__length1 = str_array_length1;
#line 1073 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp55_ = i;
#line 1073 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp56_ = _tmp54_[_tmp55_];
#line 1073 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (_tmp56_ != NULL) {
#line 3546 "gitg-stage.c"
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
#line 1073 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp57_ = str_array;
#line 1073 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp57__length1 = str_array_length1;
#line 1073 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp58_ = i;
#line 1073 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp59_ = _tmp57_[_tmp58_];
#line 1073 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp53_ = (const gchar*) _tmp59_;
#line 3561 "gitg-stage.c"
				} else {
#line 1073 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp53_ = "";
#line 3565 "gitg-stage.c"
				}
#line 1073 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp60_ = ptr;
#line 1073 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
#line 1073 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				ptr = _tmp61_;
#line 3573 "gitg-stage.c"
			}
		}
#line 1076 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp62_ = res;
#line 1076 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		res = NULL;
#line 1076 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp62_;
#line 1076 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 3584 "gitg-stage.c"
	} else {
		gchar* _tmp63_ = NULL;
#line 1078 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp63_ = g_strdup ("");
#line 1078 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp63_;
#line 1078 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 3593 "gitg-stage.c"
	}
}


static void ___lambda15_ (Block24Data* _data24_, GError** error) {
	GitgStage* self;
	GitgHook* hook = NULL;
	GitgHook* _tmp0_ = NULL;
	GgitSignature* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 245 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = _data24_->self;
#line 247 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = gitg_hook_new ("pre-commit");
#line 247 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	hook = _tmp0_;
#line 249 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = _data24_->author;
#line 249 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_setup_commit_hook_environment (self, hook, _tmp1_);
#line 3614 "gitg-stage.c"
	{
		gint status = 0;
		GitgRepository* _tmp2_ = NULL;
		gint _tmp3_ = 0;
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp2_ = self->priv->d_repository;
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp3_ = gitg_hook_run_sync (hook, (GgitRepository*) _tmp2_, &_inner_error_);
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		status = _tmp3_;
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (_inner_error_->domain == G_SPAWN_ERROR) {
#line 3629 "gitg-stage.c"
				goto __catch97_g_spawn_error;
			}
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (hook);
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_clear_error (&_inner_error_);
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return;
#line 3640 "gitg-stage.c"
		}
#line 255 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (status != 0) {
#line 3644 "gitg-stage.c"
			gchar** _tmp4_ = NULL;
			gint _tmp4__length1 = 0;
			gchar** _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
			gchar** _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			gchar* _tmp7_ = NULL;
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp4_ = gitg_hook_get_output (hook, &_tmp4__length1);
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp5_ = _tmp4_;
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp5__length1 = _tmp4__length1;
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp6_ = _tmp5_;
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp6__length1 = _tmp5__length1;
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp7_ = _vala_g_strjoinv ("\n", _tmp6_, _tmp5__length1);
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (_data24_->errormsg);
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data24_->errormsg = _tmp7_;
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
#line 3670 "gitg-stage.c"
		}
	}
	goto __finally97;
	__catch97_g_spawn_error:
	{
		GError* e = NULL;
#line 251 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		e = _inner_error_;
#line 251 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = NULL;
#line 251 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_error_free0 (e);
#line 3683 "gitg-stage.c"
	}
	__finally97:
#line 251 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 251 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 251 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (hook);
#line 251 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 3694 "gitg-stage.c"
	}
#line 245 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (hook);
#line 3698 "gitg-stage.c"
}


static void ____lambda15__gitg_async_thread_func (gpointer self, GError** error) {
#line 245 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	___lambda15_ (self, error);
#line 3705 "gitg-stage.c"
}


static void gitg_stage_pre_commit_hook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStagePreCommitHookData* _data_;
#line 245 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 245 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 245 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 245 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_pre_commit_hook_co (_data_);
#line 3719 "gitg-stage.c"
}


static gboolean gitg_stage_pre_commit_hook_co (GitgStagePreCommitHookData* _data_) {
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 3728 "gitg-stage.c"
		goto _state_0;
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 3732 "gitg-stage.c"
		goto _state_1;
		default:
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 3737 "gitg-stage.c"
	}
	_state_0:
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data24_ = g_slice_new0 (Block24Data);
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data24_->_ref_count_ = 1;
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data24_->self = g_object_ref (_data_->self);
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->author;
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_data24_->author);
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data24_->author = _data_->_tmp0_;
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data24_->_async_data_ = _data_;
#line 241 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data24_->errormsg = NULL;
#line 3758 "gitg-stage.c"
	{
#line 245 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_state_ = 1;
#line 245 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		gitg_async_thread (____lambda15__gitg_async_thread_func, _data_->_data24_, gitg_stage_pre_commit_hook_ready, _data_);
#line 245 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 3766 "gitg-stage.c"
		_state_1:
#line 245 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error_);
#line 245 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 3772 "gitg-stage.c"
			goto __catch96_g_error;
		}
	}
	goto __finally96;
	__catch96_g_error:
	{
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_clear_error (&_data_->_inner_error_);
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_inner_error_ = NULL;
#line 3783 "gitg-stage.c"
	}
	__finally96:
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_inner_error_->domain == GITG_STAGE_ERROR) {
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_error_free (_data_->_inner_error_);
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			block24_data_unref (_data_->_data24_);
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_data24_ = NULL;
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (_data_->_state_ == 0) {
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3802 "gitg-stage.c"
			} else {
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3806 "gitg-stage.c"
			}
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_object_unref (_data_->_async_result);
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return FALSE;
#line 3812 "gitg-stage.c"
		} else {
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			block24_data_unref (_data_->_data24_);
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_data24_ = NULL;
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_clear_error (&_data_->_inner_error_);
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return FALSE;
#line 3824 "gitg-stage.c"
		}
	}
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = NULL;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = _data_->_data24_->errormsg;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_tmp1_ != NULL) {
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp2_ = NULL;
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp2_ = _data_->_data24_->errormsg;
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp3_ = NULL;
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp3_ = g_error_new_literal (GITG_STAGE_ERROR, GITG_STAGE_ERROR_PRE_COMMIT_HOOK_FAILED, _data_->_tmp2_);
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_inner_error_ = _data_->_tmp3_;
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_inner_error_->domain == GITG_STAGE_ERROR) {
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_error_free (_data_->_inner_error_);
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			block24_data_unref (_data_->_data24_);
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_data24_ = NULL;
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (_data_->_state_ == 0) {
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3857 "gitg-stage.c"
			} else {
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3861 "gitg-stage.c"
			}
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_object_unref (_data_->_async_result);
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return FALSE;
#line 3867 "gitg-stage.c"
		} else {
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			block24_data_unref (_data_->_data24_);
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_data24_ = NULL;
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_clear_error (&_data_->_inner_error_);
#line 266 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return FALSE;
#line 3879 "gitg-stage.c"
		}
	}
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block24_data_unref (_data_->_data24_);
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data24_ = NULL;
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3890 "gitg-stage.c"
	} else {
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3894 "gitg-stage.c"
	}
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 3900 "gitg-stage.c"
}


static Block25Data* block25_data_ref (Block25Data* _data25_) {
#line 270 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_atomic_int_inc (&_data25_->_ref_count_);
#line 270 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return _data25_;
#line 3909 "gitg-stage.c"
}


static void block25_data_unref (void * _userdata_) {
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
#line 270 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
#line 3918 "gitg-stage.c"
		GitgStage* self;
#line 270 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self = _data25_->self;
#line 270 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self);
#line 270 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_slice_free (Block25Data, _data25_);
#line 3926 "gitg-stage.c"
	}
}


static gint ___lambda16_ (Block25Data* _data25_, const gchar* path, GgitStatusFlags flags) {
	GitgStage* self;
	gint result = 0;
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = _data25_->self;
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (path != NULL, 0);
#line 280 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data25_->has_changes = TRUE;
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	result = -1;
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return result;
#line 3944 "gitg-stage.c"
}


static gint ____lambda16__ggit_status_callback (const gchar* path, GgitStatusFlags status_flags, gpointer self) {
	gint result;
	result = ___lambda16_ (self, path, status_flags);
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return result;
#line 3953 "gitg-stage.c"
}


static void _vala_GgitStatusOptions_free (GgitStatusOptions* self) {
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_boxed_free (ggit_status_options_get_type (), self);
#line 3960 "gitg-stage.c"
}


static gboolean gitg_stage_has_index_changes (GitgStage* self) {
	gboolean result = FALSE;
	Block25Data* _data25_;
	GgitStatusShow show = 0;
	GgitStatusOptions* options = NULL;
	GgitStatusOptions* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 270 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 270 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data25_ = g_slice_new0 (Block25Data);
#line 270 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data25_->_ref_count_ = 1;
#line 270 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data25_->self = g_object_ref (self);
#line 272 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	show = GGIT_STATUS_SHOW_INDEX_ONLY;
#line 274 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = ggit_status_options_new (0, show, NULL);
#line 274 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	options = _tmp0_;
#line 275 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data25_->has_changes = FALSE;
#line 3987 "gitg-stage.c"
	{
		GitgRepository* _tmp1_ = NULL;
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp1_ = self->priv->d_repository;
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		ggit_repository_file_status_foreach ((GgitRepository*) _tmp1_, options, ____lambda16__ggit_status_callback, _data25_, &_inner_error_);
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3996 "gitg-stage.c"
			goto __catch98_g_error;
		}
	}
	goto __finally98;
	__catch98_g_error:
	{
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_clear_error (&_inner_error_);
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = NULL;
#line 4007 "gitg-stage.c"
	}
	__finally98:
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4012 "gitg-stage.c"
		gboolean _tmp2_ = FALSE;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitStatusOptions_free0 (options);
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block25_data_unref (_data25_);
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data25_ = NULL;
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_clear_error (&_inner_error_);
#line 277 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return _tmp2_;
#line 4026 "gitg-stage.c"
	}
#line 285 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	result = _data25_->has_changes;
#line 285 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitStatusOptions_free0 (options);
#line 285 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block25_data_unref (_data25_);
#line 285 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data25_ = NULL;
#line 285 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return result;
#line 4038 "gitg-stage.c"
}


static gchar* gitg_stage_commit_msg_hook (GitgStage* self, const gchar* message, GgitSignature* author, GgitSignature* committer, GError** error) {
	gchar* result = NULL;
	GitgHook* hook = NULL;
	GitgHook* _tmp0_ = NULL;
	GitgHook* _tmp1_ = NULL;
	GitgRepository* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GitgHook* _tmp6_ = NULL;
	GgitSignature* _tmp7_ = NULL;
	GFile* msgfile = NULL;
	GitgRepository* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	GitgHook* _tmp19_ = NULL;
	GFile* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gint status = 0;
	gint _tmp29_ = 0;
	GError * _inner_error_ = NULL;
#line 288 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 288 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (message != NULL, NULL);
#line 288 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (author != NULL, NULL);
#line 288 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (committer != NULL, NULL);
#line 292 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = gitg_hook_new ("commit-msg");
#line 292 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	hook = _tmp0_;
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = hook;
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = self->priv->d_repository;
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = gitg_hook_exists_in (_tmp1_, (GgitRepository*) _tmp2_);
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (!_tmp3_) {
#line 4084 "gitg-stage.c"
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp4_ = message;
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		result = _tmp5_;
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (hook);
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return result;
#line 4097 "gitg-stage.c"
	}
#line 299 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp6_ = hook;
#line 299 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp7_ = author;
#line 299 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_setup_commit_hook_environment (self, _tmp6_, _tmp7_);
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp8_ = self->priv->d_repository;
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp9_ = ggit_repository_get_location ((GgitRepository*) _tmp8_);
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp10_ = _tmp9_;
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp11_ = g_file_get_child (_tmp10_, "COMMIT_EDITMSG");
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp12_ = _tmp11_;
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_tmp10_);
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	msgfile = _tmp12_;
#line 4119 "gitg-stage.c"
	{
		GFile* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp13_ = msgfile;
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp14_ = g_file_get_path (_tmp13_);
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp15_ = _tmp14_;
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp16_ = message;
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_file_set_contents (_tmp15_, _tmp16_, (gssize) -1, &_inner_error_);
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (_tmp15_);
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4139 "gitg-stage.c"
			goto __catch99_g_error;
		}
	}
	goto __finally99;
	__catch99_g_error:
	{
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
#line 303 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_clear_error (&_inner_error_);
#line 303 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = NULL;
#line 307 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp17_ = message;
#line 307 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp18_ = g_strdup (_tmp17_);
#line 307 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		result = _tmp18_;
#line 307 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (msgfile);
#line 307 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (hook);
#line 307 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return result;
#line 4164 "gitg-stage.c"
	}
	__finally99:
#line 303 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 303 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 303 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (msgfile);
#line 303 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (hook);
#line 303 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return NULL;
#line 4177 "gitg-stage.c"
	}
#line 309 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp19_ = hook;
#line 309 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp20_ = msgfile;
#line 309 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp21_ = g_file_get_path (_tmp20_);
#line 309 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp22_ = _tmp21_;
#line 309 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_hook_add_argument (_tmp19_, _tmp22_);
#line 309 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_tmp22_);
#line 4191 "gitg-stage.c"
	{
		gint _tmp23_ = 0;
		GitgHook* _tmp24_ = NULL;
		GitgRepository* _tmp25_ = NULL;
		gint _tmp26_ = 0;
#line 315 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp24_ = hook;
#line 315 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp25_ = self->priv->d_repository;
#line 315 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp26_ = gitg_hook_run_sync (_tmp24_, (GgitRepository*) _tmp25_, &_inner_error_);
#line 315 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp23_ = _tmp26_;
#line 315 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4207 "gitg-stage.c"
			goto __catch100_g_error;
		}
#line 315 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		status = _tmp23_;
#line 4212 "gitg-stage.c"
	}
	goto __finally100;
	__catch100_g_error:
	{
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
#line 313 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_clear_error (&_inner_error_);
#line 313 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = NULL;
#line 317 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp27_ = message;
#line 317 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp28_ = g_strdup (_tmp27_);
#line 317 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		result = _tmp28_;
#line 317 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (msgfile);
#line 317 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (hook);
#line 317 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return result;
#line 4235 "gitg-stage.c"
	}
	__finally100:
#line 313 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 313 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 313 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (msgfile);
#line 313 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (hook);
#line 313 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return NULL;
#line 4248 "gitg-stage.c"
	}
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp29_ = status;
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_tmp29_ != 0) {
#line 4254 "gitg-stage.c"
		GitgHook* _tmp30_ = NULL;
		gchar** _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		gchar** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		gchar** _tmp33_ = NULL;
		gint _tmp33__length1 = 0;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		GError* _tmp36_ = NULL;
		GError* _tmp37_ = NULL;
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp30_ = hook;
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp31_ = gitg_hook_get_output (_tmp30_, &_tmp31__length1);
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp32_ = _tmp31_;
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp32__length1 = _tmp31__length1;
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp33_ = _tmp32_;
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp33__length1 = _tmp32__length1;
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp34_ = _vala_g_strjoinv ("\n", _tmp33_, _tmp32__length1);
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp35_ = _tmp34_;
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp36_ = g_error_new_literal (GITG_STAGE_ERROR, GITG_STAGE_ERROR_COMMIT_MSG_HOOK_FAILED, _tmp35_);
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp37_ = _tmp36_;
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (_tmp35_);
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp33_ = (_vala_array_free (_tmp33_, _tmp33__length1, (GDestroyNotify) g_free), NULL);
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = _tmp37_;
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (msgfile);
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (hook);
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return NULL;
#line 4300 "gitg-stage.c"
	}
	{
		gchar* newmessage = NULL;
		GFile* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
#line 329 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp38_ = msgfile;
#line 329 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp39_ = g_file_get_path (_tmp38_);
#line 329 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp40_ = _tmp39_;
#line 329 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_file_get_contents (_tmp40_, &_tmp41_, NULL, &_inner_error_);
#line 329 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (newmessage);
#line 329 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		newmessage = _tmp41_;
#line 329 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (_tmp40_);
#line 329 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 329 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (newmessage);
#line 4326 "gitg-stage.c"
			goto __catch101_g_error;
		}
#line 330 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		result = newmessage;
#line 4331 "gitg-stage.c"
		{
			GFile* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
#line 338 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp42_ = msgfile;
#line 338 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp43_ = g_file_get_path (_tmp42_);
#line 338 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp44_ = _tmp43_;
#line 338 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_remove (_tmp44_);
#line 338 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (_tmp44_);
#line 4346 "gitg-stage.c"
		}
#line 330 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (msgfile);
#line 330 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (hook);
#line 330 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return result;
#line 4354 "gitg-stage.c"
	}
	goto __finally101;
	__catch101_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp45_ = NULL;
		GError* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		GError* _tmp50_ = NULL;
		GError* _tmp51_ = NULL;
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		e = _inner_error_;
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = NULL;
#line 334 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp45_ = _ ("Could not read commit message after running commit-msg hook: %s");
#line 334 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp46_ = e;
#line 334 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp47_ = _tmp46_->message;
#line 334 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp48_ = g_strdup_printf (_tmp45_, _tmp47_);
#line 334 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp49_ = _tmp48_;
#line 334 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp50_ = g_error_new_literal (GITG_STAGE_ERROR, GITG_STAGE_ERROR_COMMIT_MSG_HOOK_FAILED, _tmp49_);
#line 334 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp51_ = _tmp50_;
#line 334 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (_tmp49_);
#line 334 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = _tmp51_;
#line 334 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_error_free0 (e);
#line 4391 "gitg-stage.c"
		goto __finally101;
	}
	__finally101:
	{
		GFile* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
#line 338 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp52_ = msgfile;
#line 338 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp53_ = g_file_get_path (_tmp52_);
#line 338 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp54_ = _tmp53_;
#line 338 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_remove (_tmp54_);
#line 338 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (_tmp54_);
#line 4409 "gitg-stage.c"
	}
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_propagate_error (error, _inner_error_);
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (msgfile);
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (hook);
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return NULL;
#line 4419 "gitg-stage.c"
}


static Block26Data* block26_data_ref (Block26Data* _data26_) {
#line 342 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_atomic_int_inc (&_data26_->_ref_count_);
#line 342 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return _data26_;
#line 4428 "gitg-stage.c"
}


static void block26_data_unref (void * _userdata_) {
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
#line 342 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
#line 4437 "gitg-stage.c"
		GitgStage* self;
#line 342 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self = _data26_->self;
#line 342 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data26_->hook);
#line 342 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self);
#line 342 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_slice_free (Block26Data, _data26_);
#line 4447 "gitg-stage.c"
	}
}


static void __lambda17_ (Block26Data* _data26_, GObject* obj, GAsyncResult* res) {
	GitgStage* self;
	GError * _inner_error_ = NULL;
#line 348 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = _data26_->self;
#line 348 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (res != NULL);
#line 4459 "gitg-stage.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 351 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp0_ = res;
#line 351 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		gitg_hook_run_finish (_data26_->hook, _tmp0_, &_inner_error_);
#line 351 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4468 "gitg-stage.c"
			goto __catch102_g_error;
		}
	}
	goto __finally102;
	__catch102_g_error:
	{
#line 349 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_clear_error (&_inner_error_);
#line 349 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = NULL;
#line 4479 "gitg-stage.c"
	}
	__finally102:
#line 349 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 349 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 349 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_clear_error (&_inner_error_);
#line 349 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 4490 "gitg-stage.c"
	}
}


static void ___lambda17__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 348 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__lambda17_ (self, source_object, res);
#line 348 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block26_data_unref (self);
#line 4500 "gitg-stage.c"
}


static void gitg_stage_post_commit_hook (GitgStage* self, GgitSignature* author) {
	Block26Data* _data26_;
	GitgHook* _tmp0_ = NULL;
	GgitSignature* _tmp1_ = NULL;
	GitgRepository* _tmp2_ = NULL;
#line 342 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (self != NULL);
#line 342 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (author != NULL);
#line 342 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data26_ = g_slice_new0 (Block26Data);
#line 342 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data26_->_ref_count_ = 1;
#line 342 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data26_->self = g_object_ref (self);
#line 344 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = gitg_hook_new ("post-commit");
#line 344 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data26_->hook = _tmp0_;
#line 346 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = author;
#line 346 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_setup_commit_hook_environment (self, _data26_->hook, _tmp1_);
#line 348 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = self->priv->d_repository;
#line 348 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_hook_run (_data26_->hook, (GgitRepository*) _tmp2_, ___lambda17__gasync_ready_callback, block26_data_ref (_data26_));
#line 342 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block26_data_unref (_data26_);
#line 342 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data26_ = NULL;
#line 4535 "gitg-stage.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 987 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 987 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 988 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 988 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 988 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 988 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 990 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 990 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 4562 "gitg-stage.c"
		gchar* _tmp4_ = NULL;
#line 991 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 991 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 991 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 4570 "gitg-stage.c"
	} else {
#line 993 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = -1;
#line 993 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 4576 "gitg-stage.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1328 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1329 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1329 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1329 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1330 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1330 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 4610 "gitg-stage.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1331 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1331 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1331 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 4619 "gitg-stage.c"
	}
#line 1333 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1333 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 4625 "gitg-stage.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1334 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1334 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1334 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 4634 "gitg-stage.c"
	}
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 4640 "gitg-stage.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 4649 "gitg-stage.c"
	} else {
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 4653 "gitg-stage.c"
	}
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 4661 "gitg-stage.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 4670 "gitg-stage.c"
	} else {
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 4674 "gitg-stage.c"
	}
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 4696 "gitg-stage.c"
}


static gchar* gitg_stage_get_subject (GitgStage* self, const gchar* message) {
	gchar* result = NULL;
	gint nlpos = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 356 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 356 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_val_if_fail (message != NULL, NULL);
#line 358 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = message;
#line 358 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = string_index_of (_tmp0_, "\n", 0);
#line 358 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	nlpos = _tmp1_;
#line 360 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = nlpos;
#line 360 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_tmp2_ == -1) {
#line 4720 "gitg-stage.c"
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 362 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp3_ = message;
#line 362 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 362 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		result = _tmp4_;
#line 362 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return result;
#line 4731 "gitg-stage.c"
	} else {
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gchar* _tmp7_ = NULL;
#line 366 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp5_ = message;
#line 366 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp6_ = nlpos;
#line 366 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp7_ = string_slice (_tmp5_, (glong) 0, (glong) _tmp6_);
#line 366 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		result = _tmp7_;
#line 366 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return result;
#line 4746 "gitg-stage.c"
	}
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 4754 "gitg-stage.c"
}


static void gitg_stage_commit_index_data_free (gpointer _data) {
	GitgStageCommitIndexData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->reference);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_data_->message);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->author);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->committer);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (_data_->result);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageCommitIndexData, _data_);
#line 4775 "gitg-stage.c"
}


void gitg_stage_commit_index (GitgStage* self, GgitIndex* index, GgitRef* reference, const gchar* message, GgitSignature* author, GgitSignature* committer, GgitOId** parents, int parents_length1, GitgStageCommitOptions options, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageCommitIndexData* _data_;
	GitgStage* _tmp0_ = NULL;
	GgitIndex* _tmp1_ = NULL;
	GgitIndex* _tmp2_ = NULL;
	GgitRef* _tmp3_ = NULL;
	GgitRef* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GgitSignature* _tmp7_ = NULL;
	GgitSignature* _tmp8_ = NULL;
	GgitSignature* _tmp9_ = NULL;
	GgitSignature* _tmp10_ = NULL;
	GgitOId** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GitgStageCommitOptions _tmp12_ = 0;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageCommitIndexData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_commit_index);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_commit_index_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = index;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->index);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->index = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = reference;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->reference);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->reference = _tmp4_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp5_ = message;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_data_->message);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->message = _tmp6_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp7_ = author;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->author);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->author = _tmp8_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp9_ = committer;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->committer);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->committer = _tmp10_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp11_ = parents;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp11__length1 = parents_length1;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->parents = _tmp11_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->parents_length1 = _tmp11__length1;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp12_ = options;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->options = _tmp12_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_commit_index_co (_data_);
#line 4859 "gitg-stage.c"
}


GgitOId* gitg_stage_commit_index_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GgitOId* result;
	GitgStageCommitIndexData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return NULL;
#line 4870 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	result = _data_->result;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->result = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return result;
#line 4880 "gitg-stage.c"
}


static Block27Data* block27_data_ref (Block27Data* _data27_) {
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_atomic_int_inc (&_data27_->_ref_count_);
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return _data27_;
#line 4889 "gitg-stage.c"
}


static void block27_data_unref (void * _userdata_) {
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
#line 4898 "gitg-stage.c"
		GitgStage* self;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self = _data27_->self;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (_data27_->treeoid);
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data27_->index);
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self);
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_slice_free (Block27Data, _data27_);
#line 4910 "gitg-stage.c"
	}
}


static void __lambda18_ (Block27Data* _data27_, GError** error) {
	GitgStage* self;
	GgitOId* _tmp0_ = NULL;
	GgitIndex* _tmp1_ = NULL;
	GitgRepository* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
	GgitOId* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = _data27_->self;
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = _data27_->index;
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = self->priv->d_repository;
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = ggit_index_write_tree_to (_tmp1_, (GgitRepository*) _tmp2_, &_inner_error_);
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _tmp3_;
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 4939 "gitg-stage.c"
	}
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = _tmp0_;
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = NULL;
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (_data27_->treeoid);
#line 381 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data27_->treeoid = _tmp4_;
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (_tmp0_);
#line 4951 "gitg-stage.c"
}


static void ___lambda18__gitg_async_thread_func (gpointer self, GError** error) {
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__lambda18_ (self, error);
#line 4958 "gitg-stage.c"
}


static void gitg_stage_commit_index_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageCommitIndexData* _data_;
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_commit_index_co (_data_);
#line 4972 "gitg-stage.c"
}


static gboolean gitg_stage_commit_index_co (GitgStageCommitIndexData* _data_) {
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 4981 "gitg-stage.c"
		goto _state_0;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 4985 "gitg-stage.c"
		goto _state_1;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 2:
#line 4989 "gitg-stage.c"
		goto _state_2;
		default:
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 4994 "gitg-stage.c"
	}
	_state_0:
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data27_ = g_slice_new0 (Block27Data);
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data27_->_ref_count_ = 1;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data27_->self = g_object_ref (_data_->self);
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->index;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_data27_->index);
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data27_->index = _data_->_tmp0_;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data27_->_async_data_ = _data_;
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data27_->treeoid = NULL;
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_async_thread (___lambda18__gitg_async_thread_func, _data_->_data27_, gitg_stage_commit_index_ready, _data_);
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 5021 "gitg-stage.c"
	_state_1:
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error_);
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block27_data_unref (_data_->_data27_);
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data27_ = NULL;
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 5039 "gitg-stage.c"
		} else {
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 5043 "gitg-stage.c"
		}
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 380 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 5049 "gitg-stage.c"
	}
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = NULL;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = _data_->_data27_->treeoid;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = NULL;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = _data_->reference;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = NULL;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = _data_->message;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = NULL;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = _data_->author;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp6_ = NULL;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp6_ = _data_->committer;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7_ = NULL;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7__length1 = 0;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7_ = _data_->parents;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7__length1 = _data_->parents_length1;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp8_ = 0;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp8_ = _data_->options;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 2;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_commit_tree (_data_->self, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, _data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp7__length1, _data_->_tmp8_, gitg_stage_commit_index_ready, _data_);
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 5089 "gitg-stage.c"
	_state_2:
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp9_ = NULL;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp9_ = gitg_stage_commit_tree_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = _data_->_tmp9_;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block27_data_unref (_data_->_data27_);
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data27_ = NULL;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 5111 "gitg-stage.c"
		} else {
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 5115 "gitg-stage.c"
		}
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 5121 "gitg-stage.c"
	}
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp10_ = NULL;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp10_ = _data_->_tmp1_;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = NULL;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->result = _data_->_tmp10_;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (_data_->_tmp1_);
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block27_data_unref (_data_->_data27_);
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data27_ = NULL;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 5141 "gitg-stage.c"
	} else {
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 5145 "gitg-stage.c"
	}
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (_data_->_tmp1_);
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block27_data_unref (_data_->_data27_);
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data27_ = NULL;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 5161 "gitg-stage.c"
	} else {
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 5165 "gitg-stage.c"
	}
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 5171 "gitg-stage.c"
}


static void gitg_stage_commit_tree_data_free (gpointer _data) {
	GitgStageCommitTreeData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (_data_->result);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageCommitTreeData, _data_);
#line 5184 "gitg-stage.c"
}


static GgitOId* _vala_GgitOId_copy (GgitOId* self) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return g_boxed_copy (ggit_oid_get_type (), self);
#line 5191 "gitg-stage.c"
}


static gpointer __vala_GgitOId_copy0 (gpointer self) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return self ? _vala_GgitOId_copy (self) : NULL;
#line 5198 "gitg-stage.c"
}


void gitg_stage_commit_tree (GitgStage* self, GgitOId* treeoid, GgitRef* reference, const gchar* message, GgitSignature* author, GgitSignature* committer, GgitOId** parents, int parents_length1, GitgStageCommitOptions options, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageCommitTreeData* _data_;
	GitgStage* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	GgitRef* _tmp3_ = NULL;
	GgitRef* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GgitSignature* _tmp7_ = NULL;
	GgitSignature* _tmp8_ = NULL;
	GgitSignature* _tmp9_ = NULL;
	GgitSignature* _tmp10_ = NULL;
	GgitOId** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GitgStageCommitOptions _tmp12_ = 0;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageCommitTreeData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_commit_tree);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_commit_tree_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = treeoid;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = __vala_GgitOId_copy0 (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (_data_->treeoid);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->treeoid = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = reference;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->reference);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->reference = _tmp4_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp5_ = message;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_data_->message);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->message = _tmp6_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp7_ = author;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->author);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->author = _tmp8_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp9_ = committer;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->committer);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->committer = _tmp10_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp11_ = parents;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp11__length1 = parents_length1;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->parents = _tmp11_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->parents_length1 = _tmp11__length1;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp12_ = options;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->options = _tmp12_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_commit_tree_co (_data_);
#line 5282 "gitg-stage.c"
}


GgitOId* gitg_stage_commit_tree_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GgitOId* result;
	GitgStageCommitTreeData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return NULL;
#line 5293 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	result = _data_->result;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->result = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return result;
#line 5303 "gitg-stage.c"
}


static Block28Data* block28_data_ref (Block28Data* _data28_) {
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_atomic_int_inc (&_data28_->_ref_count_);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return _data28_;
#line 5312 "gitg-stage.c"
}


static void block28_data_unref (void * _userdata_) {
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
#line 5321 "gitg-stage.c"
		GitgStage* self;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self = _data28_->self;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (_data28_->ret);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (_data28_->treeoid);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data28_->reference);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (_data28_->message);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data28_->author);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data28_->committer);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_slice_free (Block28Data, _data28_);
#line 5341 "gitg-stage.c"
	}
}


static GgitOId** _vala_array_dup21 (GgitOId** self, int length) {
	GgitOId** result;
	int i;
#line 445 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	result = g_new0 (GgitOId*, length + 1);
#line 445 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	for (i = 0; i < length; i++) {
#line 5353 "gitg-stage.c"
		GgitOId* _tmp0_ = NULL;
#line 445 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp0_ = __vala_GgitOId_copy0 (self[i]);
#line 445 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		result[i] = _tmp0_;
#line 5359 "gitg-stage.c"
	}
#line 445 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return result;
#line 5363 "gitg-stage.c"
}


static void __lambda19_ (Block28Data* _data28_, GError** error) {
	GitgStage* self;
	gboolean skip_hooks = FALSE;
	GitgStageCommitOptions _tmp0_ = 0;
	gboolean amend = FALSE;
	GitgStageCommitOptions _tmp1_ = 0;
	GgitConfig* _tmp2_ = NULL;
	GitgRepository* _tmp3_ = NULL;
	GgitConfig* _tmp4_ = NULL;
	GgitConfig* conf = NULL;
	GgitConfig* _tmp5_ = NULL;
	GgitConfig* _tmp6_ = NULL;
	GgitConfig* _tmp7_ = NULL;
	GgitConfig* _tmp8_ = NULL;
	gchar* emsg = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GitgStageCommitOptions _tmp11_ = 0;
	gchar* encoding = NULL;
	GgitConfig* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	GgitOId* refoid = NULL;
	gboolean _tmp32_ = FALSE;
	gboolean always_update = FALSE;
	gchar* reflogmsg = NULL;
	gchar* _tmp73_ = NULL;
	gboolean _tmp74_ = FALSE;
	const gchar* _tmp77_ = NULL;
	const gchar* _tmp78_ = NULL;
	gchar* _tmp79_ = NULL;
	gchar* _tmp80_ = NULL;
	gchar* _tmp81_ = NULL;
	gchar* _tmp82_ = NULL;
	gchar* _tmp83_ = NULL;
	GgitRef* _tmp94_ = NULL;
	GgitRefType _tmp95_ = 0;
	GgitRef* _tmp108_ = NULL;
	const gchar* _tmp109_ = NULL;
	GgitSignature* _tmp110_ = NULL;
	GError * _inner_error_ = NULL;
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = _data28_->self;
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _data28_->options;
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	skip_hooks = (_tmp0_ & GITG_STAGE_COMMIT_OPTIONS_SKIP_HOOKS) != 0;
#line 399 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = _data28_->options;
#line 399 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	amend = (_tmp1_ & GITG_STAGE_COMMIT_OPTIONS_AMEND) != 0;
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = self->priv->d_repository;
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = ggit_repository_get_config ((GgitRepository*) _tmp3_, &_inner_error_);
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = _tmp4_;
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 5432 "gitg-stage.c"
	}
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp5_ = _tmp2_;
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = NULL;
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp6_ = _tmp5_;
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp7_ = ggit_config_snapshot (_tmp6_, &_inner_error_);
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp8_ = _tmp7_;
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_tmp6_);
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	conf = _tmp8_;
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_tmp2_);
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 5456 "gitg-stage.c"
	}
#line 404 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp9_ = _data28_->message;
#line 404 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp10_ = g_strdup (_tmp9_);
#line 404 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	emsg = _tmp10_;
#line 406 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp11_ = _data28_->options;
#line 406 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if ((_tmp11_ & GITG_STAGE_COMMIT_OPTIONS_SIGN_OFF) != 0) {
#line 5468 "gitg-stage.c"
		const gchar* _tmp12_ = NULL;
		GgitSignature* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp12_ = emsg;
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp13_ = _data28_->committer;
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp14_ = gitg_stage_message_with_sign_off (self, _tmp12_, _tmp13_);
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (emsg);
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		emsg = _tmp14_;
#line 5482 "gitg-stage.c"
	}
#line 413 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp15_ = conf;
#line 413 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp16_ = emsg;
#line 413 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp18_ = gitg_stage_convert_message_to_encoding (self, _tmp15_, _tmp16_, &_tmp17_);
#line 413 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (encoding);
#line 413 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	encoding = _tmp17_;
#line 413 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (emsg);
#line 413 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	emsg = _tmp18_;
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp19_ = skip_hooks;
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (!_tmp19_) {
#line 5502 "gitg-stage.c"
		gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		GgitSignature* _tmp22_ = NULL;
		GgitSignature* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp21_ = emsg;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp22_ = _data28_->author;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp23_ = _data28_->committer;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp24_ = gitg_stage_commit_msg_hook (self, _tmp21_, _tmp22_, _tmp23_, &_inner_error_);
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp20_ = _tmp24_;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_propagate_error (error, _inner_error_);
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (encoding);
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (emsg);
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (conf);
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (_tmp2_);
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return;
#line 5533 "gitg-stage.c"
		}
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp25_ = _tmp20_;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp20_ = NULL;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (emsg);
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		emsg = _tmp25_;
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (_tmp20_);
#line 5545 "gitg-stage.c"
	}
#line 420 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	refoid = NULL;
#line 5549 "gitg-stage.c"
	{
		GgitRef* _tmp26_ = NULL;
		GgitRef* _tmp27_ = NULL;
		GgitRef* _tmp28_ = NULL;
		GgitRef* _tmp29_ = NULL;
		GgitRef* _tmp30_ = NULL;
		GgitOId* _tmp31_ = NULL;
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp27_ = _data28_->reference;
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp28_ = ggit_ref_resolve (_tmp27_, &_inner_error_);
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp26_ = _tmp28_;
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5565 "gitg-stage.c"
			goto __catch103_g_error;
		}
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp29_ = _tmp26_;
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp26_ = NULL;
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp30_ = _tmp29_;
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp31_ = ggit_ref_get_target (_tmp30_);
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (refoid);
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		refoid = _tmp31_;
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_tmp30_);
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_tmp26_);
#line 5584 "gitg-stage.c"
	}
	goto __finally103;
	__catch103_g_error:
	{
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_clear_error (&_inner_error_);
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = NULL;
#line 5593 "gitg-stage.c"
	}
	__finally103:
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (refoid);
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (encoding);
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (emsg);
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (conf);
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_tmp2_);
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 5612 "gitg-stage.c"
	}
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp32_ = amend;
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (!_tmp32_) {
#line 5618 "gitg-stage.c"
		GgitOId** pars = NULL;
		gint pars_length1 = 0;
		gint _pars_size_ = 0;
		GgitOId** _tmp33_ = NULL;
		gint _tmp33__length1 = 0;
		GgitOId* _tmp41_ = NULL;
		GitgRepository* _tmp42_ = NULL;
		GgitRef* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		GgitSignature* _tmp45_ = NULL;
		GgitSignature* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		GgitOId* _tmp49_ = NULL;
		GgitOId** _tmp50_ = NULL;
		gint _tmp50__length1 = 0;
		GgitOId* _tmp51_ = NULL;
		GgitOId* _tmp52_ = NULL;
#line 432 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp33_ = _data28_->parents;
#line 432 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp33__length1 = _data28_->parents_length1;
#line 432 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_tmp33_ == NULL) {
#line 5643 "gitg-stage.c"
			GgitOId* _tmp34_ = NULL;
#line 434 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp34_ = refoid;
#line 434 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (_tmp34_ == NULL) {
#line 5649 "gitg-stage.c"
				GgitOId** _tmp35_ = NULL;
#line 436 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp35_ = g_new0 (GgitOId*, 0 + 1);
#line 436 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
#line 436 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				pars = _tmp35_;
#line 436 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				pars_length1 = 0;
#line 436 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_pars_size_ = pars_length1;
#line 5661 "gitg-stage.c"
			} else {
				GgitOId* _tmp36_ = NULL;
				GgitOId* _tmp37_ = NULL;
				GgitOId** _tmp38_ = NULL;
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp36_ = refoid;
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp37_ = __vala_GgitOId_copy0 (_tmp36_);
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp38_ = g_new0 (GgitOId*, 1 + 1);
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp38_[0] = _tmp37_;
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				pars = _tmp38_;
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				pars_length1 = 1;
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_pars_size_ = pars_length1;
#line 5682 "gitg-stage.c"
			}
		} else {
			GgitOId** _tmp39_ = NULL;
			gint _tmp39__length1 = 0;
			GgitOId** _tmp40_ = NULL;
			gint _tmp40__length1 = 0;
#line 445 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp39_ = _data28_->parents;
#line 445 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp39__length1 = _data28_->parents_length1;
#line 445 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp40_ = (_tmp39_ != NULL) ? _vala_array_dup21 (_tmp39_, _tmp39__length1) : ((gpointer) _tmp39_);
#line 445 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp40__length1 = _tmp39__length1;
#line 445 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
#line 445 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			pars = _tmp40_;
#line 445 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			pars_length1 = _tmp40__length1;
#line 445 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_pars_size_ = pars_length1;
#line 5705 "gitg-stage.c"
		}
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp42_ = self->priv->d_repository;
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp43_ = _data28_->reference;
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp44_ = ggit_ref_get_name (_tmp43_);
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp45_ = _data28_->author;
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp46_ = _data28_->committer;
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp47_ = encoding;
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp48_ = emsg;
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp49_ = _data28_->treeoid;
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp50_ = pars;
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp50__length1 = pars_length1;
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp51_ = ggit_repository_create_commit_from_ids ((GgitRepository*) _tmp42_, _tmp44_, _tmp45_, _tmp46_, _tmp47_, _tmp48_, _tmp49_, _tmp50_, _tmp50__length1, &_inner_error_);
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp41_ = _tmp51_;
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_propagate_error (error, _inner_error_);
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			__vala_GgitOId_free0 (refoid);
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (encoding);
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (emsg);
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (conf);
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (_tmp2_);
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return;
#line 5749 "gitg-stage.c"
		}
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp52_ = _tmp41_;
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp41_ = NULL;
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (_data28_->ret);
#line 448 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data28_->ret = _tmp52_;
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (_tmp41_);
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
#line 5763 "gitg-stage.c"
	} else {
		GgitCommit* refcommit = NULL;
		GitgRepository* _tmp53_ = NULL;
		GgitOId* _tmp54_ = NULL;
		gpointer _tmp55_ = NULL;
		GgitTree* tree = NULL;
		GitgRepository* _tmp56_ = NULL;
		GgitOId* _tmp57_ = NULL;
		gpointer _tmp58_ = NULL;
		GgitOId* _tmp59_ = NULL;
		GgitCommit* _tmp60_ = NULL;
		GgitRef* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
		GgitSignature* _tmp63_ = NULL;
		GgitSignature* _tmp64_ = NULL;
		const gchar* _tmp65_ = NULL;
		const gchar* _tmp66_ = NULL;
		GgitTree* _tmp67_ = NULL;
		GgitOId* _tmp68_ = NULL;
		GgitOId* _tmp69_ = NULL;
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp53_ = self->priv->d_repository;
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp54_ = refoid;
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp55_ = gitg_repository_lookup (_tmp53_, ggit_commit_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp54_, &_inner_error_);
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		refcommit = (GgitCommit*) _tmp55_;
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_propagate_error (error, _inner_error_);
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			__vala_GgitOId_free0 (refoid);
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (encoding);
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (emsg);
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (conf);
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (_tmp2_);
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return;
#line 5808 "gitg-stage.c"
		}
#line 459 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp56_ = self->priv->d_repository;
#line 459 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp57_ = _data28_->treeoid;
#line 459 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp58_ = gitg_repository_lookup (_tmp56_, ggit_tree_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp57_, &_inner_error_);
#line 459 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		tree = (GgitTree*) _tmp58_;
#line 459 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 459 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_propagate_error (error, _inner_error_);
#line 459 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (refcommit);
#line 459 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			__vala_GgitOId_free0 (refoid);
#line 459 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (encoding);
#line 459 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (emsg);
#line 459 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (conf);
#line 459 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (_tmp2_);
#line 459 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return;
#line 5836 "gitg-stage.c"
		}
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp60_ = refcommit;
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp61_ = _data28_->reference;
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp62_ = ggit_ref_get_name (_tmp61_);
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp63_ = _data28_->author;
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp64_ = _data28_->committer;
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp65_ = encoding;
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp66_ = emsg;
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp67_ = tree;
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp68_ = ggit_commit_amend (_tmp60_, _tmp62_, _tmp63_, _tmp64_, _tmp65_, _tmp66_, _tmp67_, &_inner_error_);
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp59_ = _tmp68_;
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_propagate_error (error, _inner_error_);
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (tree);
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (refcommit);
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			__vala_GgitOId_free0 (refoid);
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (encoding);
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (emsg);
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (conf);
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (_tmp2_);
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return;
#line 5878 "gitg-stage.c"
		}
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp69_ = _tmp59_;
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp59_ = NULL;
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (_data28_->ret);
#line 461 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data28_->ret = _tmp69_;
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (_tmp59_);
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (tree);
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (refcommit);
#line 5894 "gitg-stage.c"
	}
#line 469 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	always_update = FALSE;
#line 5898 "gitg-stage.c"
	{
		gboolean _tmp70_ = FALSE;
		GgitConfig* _tmp71_ = NULL;
		gboolean _tmp72_ = FALSE;
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp71_ = conf;
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp72_ = ggit_config_get_bool (_tmp71_, "core.logAllRefUpdates", &_inner_error_);
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp70_ = _tmp72_;
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5911 "gitg-stage.c"
			goto __catch104_g_error;
		}
#line 473 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		always_update = _tmp70_;
#line 5916 "gitg-stage.c"
	}
	goto __finally104;
	__catch104_g_error:
	{
#line 471 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_clear_error (&_inner_error_);
#line 471 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = NULL;
#line 5925 "gitg-stage.c"
	}
	__finally104:
#line 471 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 471 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 471 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (refoid);
#line 471 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (encoding);
#line 471 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (emsg);
#line 471 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (conf);
#line 471 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_tmp2_);
#line 471 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 5944 "gitg-stage.c"
	}
#line 476 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp73_ = g_strdup ("commit");
#line 476 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	reflogmsg = _tmp73_;
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp74_ = amend;
#line 478 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_tmp74_) {
#line 5954 "gitg-stage.c"
		const gchar* _tmp75_ = NULL;
		gchar* _tmp76_ = NULL;
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp75_ = reflogmsg;
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp76_ = g_strconcat (_tmp75_, " (amend)", NULL);
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (reflogmsg);
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		reflogmsg = _tmp76_;
#line 5965 "gitg-stage.c"
	}
#line 483 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp77_ = reflogmsg;
#line 483 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp78_ = _data28_->message;
#line 483 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp79_ = gitg_stage_get_subject (self, _tmp78_);
#line 483 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp80_ = _tmp79_;
#line 483 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp81_ = g_strconcat (": ", _tmp80_, NULL);
#line 483 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp82_ = _tmp81_;
#line 483 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp83_ = g_strconcat (_tmp77_, _tmp82_, NULL);
#line 483 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (reflogmsg);
#line 483 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	reflogmsg = _tmp83_;
#line 483 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_tmp82_);
#line 483 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_tmp80_);
#line 5989 "gitg-stage.c"
	{
		gboolean _tmp84_ = FALSE;
		gboolean _tmp85_ = FALSE;
#line 488 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp85_ = always_update;
#line 488 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_tmp85_) {
#line 488 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp84_ = TRUE;
#line 5999 "gitg-stage.c"
		} else {
			GgitRef* _tmp86_ = NULL;
			gboolean _tmp87_ = FALSE;
#line 488 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp86_ = _data28_->reference;
#line 488 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp87_ = ggit_ref_has_log (_tmp86_);
#line 488 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp84_ = _tmp87_;
#line 6009 "gitg-stage.c"
		}
#line 488 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_tmp84_) {
#line 6013 "gitg-stage.c"
			GgitReflog* reflog = NULL;
			GgitRef* _tmp88_ = NULL;
			GgitReflog* _tmp89_ = NULL;
			GgitReflog* _tmp90_ = NULL;
			GgitSignature* _tmp91_ = NULL;
			const gchar* _tmp92_ = NULL;
			GgitReflog* _tmp93_ = NULL;
#line 490 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp88_ = _data28_->reference;
#line 490 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp89_ = ggit_ref_get_log (_tmp88_, &_inner_error_);
#line 490 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			reflog = _tmp89_;
#line 490 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6029 "gitg-stage.c"
				goto __catch105_g_error;
			}
#line 491 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp90_ = reflog;
#line 491 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp91_ = _data28_->committer;
#line 491 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp92_ = reflogmsg;
#line 491 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			ggit_reflog_append (_tmp90_, _data28_->ret, _tmp91_, _tmp92_, &_inner_error_);
#line 491 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 491 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_ggit_reflog_unref0 (reflog);
#line 6044 "gitg-stage.c"
				goto __catch105_g_error;
			}
#line 492 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp93_ = reflog;
#line 492 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			ggit_reflog_write (_tmp93_, &_inner_error_);
#line 492 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 492 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_ggit_reflog_unref0 (reflog);
#line 6055 "gitg-stage.c"
				goto __catch105_g_error;
			}
#line 488 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_ggit_reflog_unref0 (reflog);
#line 6060 "gitg-stage.c"
		}
	}
	goto __finally105;
	__catch105_g_error:
	{
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_clear_error (&_inner_error_);
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = NULL;
#line 6070 "gitg-stage.c"
	}
	__finally105:
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (reflogmsg);
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (refoid);
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (encoding);
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (emsg);
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (conf);
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_tmp2_);
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 6091 "gitg-stage.c"
	}
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp94_ = _data28_->reference;
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp95_ = ggit_ref_get_reference_type (_tmp94_);
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_tmp95_ == GGIT_REF_SYMBOLIC) {
#line 6099 "gitg-stage.c"
		{
			GgitRef* resolved = NULL;
			GgitRef* _tmp96_ = NULL;
			GgitRef* _tmp97_ = NULL;
			gboolean _tmp98_ = FALSE;
			gboolean _tmp99_ = FALSE;
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp96_ = _data28_->reference;
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp97_ = ggit_ref_resolve (_tmp96_, &_inner_error_);
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			resolved = _tmp97_;
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6114 "gitg-stage.c"
				goto __catch106_g_error;
			}
#line 503 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp99_ = always_update;
#line 503 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (_tmp99_) {
#line 503 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp98_ = TRUE;
#line 6123 "gitg-stage.c"
			} else {
				GgitRef* _tmp100_ = NULL;
				gboolean _tmp101_ = FALSE;
#line 503 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp100_ = resolved;
#line 503 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp101_ = ggit_ref_has_log (_tmp100_);
#line 503 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp98_ = _tmp101_;
#line 6133 "gitg-stage.c"
			}
#line 503 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (_tmp98_) {
#line 6137 "gitg-stage.c"
				GgitReflog* reflog = NULL;
				GgitRef* _tmp102_ = NULL;
				GgitReflog* _tmp103_ = NULL;
				GgitReflog* _tmp104_ = NULL;
				GgitSignature* _tmp105_ = NULL;
				const gchar* _tmp106_ = NULL;
				GgitReflog* _tmp107_ = NULL;
#line 505 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp102_ = resolved;
#line 505 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp103_ = ggit_ref_get_log (_tmp102_, &_inner_error_);
#line 505 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				reflog = _tmp103_;
#line 505 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 505 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_g_object_unref0 (resolved);
#line 6155 "gitg-stage.c"
					goto __catch106_g_error;
				}
#line 507 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp104_ = reflog;
#line 507 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp105_ = _data28_->committer;
#line 507 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp106_ = reflogmsg;
#line 507 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				ggit_reflog_append (_tmp104_, _data28_->ret, _tmp105_, _tmp106_, &_inner_error_);
#line 507 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 507 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_ggit_reflog_unref0 (reflog);
#line 507 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_g_object_unref0 (resolved);
#line 6172 "gitg-stage.c"
					goto __catch106_g_error;
				}
#line 508 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp107_ = reflog;
#line 508 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				ggit_reflog_write (_tmp107_, &_inner_error_);
#line 508 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 508 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_ggit_reflog_unref0 (reflog);
#line 508 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_g_object_unref0 (resolved);
#line 6185 "gitg-stage.c"
					goto __catch106_g_error;
				}
#line 503 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_ggit_reflog_unref0 (reflog);
#line 6190 "gitg-stage.c"
			}
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (resolved);
#line 6194 "gitg-stage.c"
		}
		goto __finally106;
		__catch106_g_error:
		{
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_clear_error (&_inner_error_);
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_inner_error_ = NULL;
#line 6203 "gitg-stage.c"
		}
		__finally106:
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_propagate_error (error, _inner_error_);
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (reflogmsg);
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			__vala_GgitOId_free0 (refoid);
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (encoding);
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_free0 (emsg);
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (conf);
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (_tmp2_);
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return;
#line 6224 "gitg-stage.c"
		}
	}
#line 513 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp108_ = _data28_->reference;
#line 513 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp109_ = ggit_ref_get_name (_tmp108_);
#line 513 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_strcmp0 (_tmp109_, "HEAD") == 0) {
#line 515 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self->priv->d_head_tree);
#line 515 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self->priv->d_head_tree = NULL;
#line 6237 "gitg-stage.c"
	}
#line 519 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp110_ = _data28_->author;
#line 519 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_post_commit_hook (self, _tmp110_);
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (reflogmsg);
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (refoid);
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (encoding);
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (emsg);
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (conf);
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_tmp2_);
#line 6255 "gitg-stage.c"
}


static void ___lambda19__gitg_async_thread_func (gpointer self, GError** error) {
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__lambda19_ (self, error);
#line 6262 "gitg-stage.c"
}


static void gitg_stage_commit_tree_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageCommitTreeData* _data_;
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_commit_tree_co (_data_);
#line 6276 "gitg-stage.c"
}


static gboolean gitg_stage_commit_tree_co (GitgStageCommitTreeData* _data_) {
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 6285 "gitg-stage.c"
		goto _state_0;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 6289 "gitg-stage.c"
		goto _state_1;
		default:
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 6294 "gitg-stage.c"
	}
	_state_0:
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data28_ = g_slice_new0 (Block28Data);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data28_->_ref_count_ = 1;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data28_->self = g_object_ref (_data_->self);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->treeoid;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (_data_->_data28_->treeoid);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data28_->treeoid = _data_->_tmp0_;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = NULL;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = _data_->reference;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_data28_->reference);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data28_->reference = _data_->_tmp1_;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = NULL;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = _data_->message;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_data_->_data28_->message);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data28_->message = _data_->_tmp2_;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = NULL;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = _data_->author;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_data28_->author);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data28_->author = _data_->_tmp3_;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = NULL;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = _data_->committer;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_data28_->committer);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data28_->committer = _data_->_tmp4_;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = NULL;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5__length1 = 0;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = _data_->parents;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5__length1 = _data_->parents_length1;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data28_->parents = _data_->_tmp5_;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data28_->parents_length1 = _data_->_tmp5__length1;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp6_ = 0;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp6_ = _data_->options;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data28_->options = _data_->_tmp6_;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data28_->_async_data_ = _data_;
#line 395 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data28_->ret = NULL;
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_async_thread (___lambda19__gitg_async_thread_func, _data_->_data28_, gitg_stage_commit_tree_ready, _data_);
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 6371 "gitg-stage.c"
	_state_1:
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error_);
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block28_data_unref (_data_->_data28_);
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data28_ = NULL;
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6389 "gitg-stage.c"
		} else {
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 6393 "gitg-stage.c"
		}
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 397 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 6399 "gitg-stage.c"
	}
#line 522 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7_ = NULL;
#line 522 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7_ = __vala_GgitOId_copy0 (_data_->_data28_->ret);
#line 522 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->result = _data_->_tmp7_;
#line 522 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block28_data_unref (_data_->_data28_);
#line 522 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data28_ = NULL;
#line 522 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 522 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6415 "gitg-stage.c"
	} else {
#line 522 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 6419 "gitg-stage.c"
	}
#line 522 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 522 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block28_data_unref (_data_->_data28_);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data28_ = NULL;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6433 "gitg-stage.c"
	} else {
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 6437 "gitg-stage.c"
	}
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 6443 "gitg-stage.c"
}


static void gitg_stage_commit_data_free (gpointer _data) {
	GitgStageCommitData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_data_->message);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->author);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->committer);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (_data_->result);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageCommitData, _data_);
#line 6462 "gitg-stage.c"
}


void gitg_stage_commit (GitgStage* self, const gchar* message, GgitSignature* author, GgitSignature* committer, GitgStageCommitOptions options, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageCommitData* _data_;
	GitgStage* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GgitSignature* _tmp3_ = NULL;
	GgitSignature* _tmp4_ = NULL;
	GgitSignature* _tmp5_ = NULL;
	GgitSignature* _tmp6_ = NULL;
	GitgStageCommitOptions _tmp7_ = 0;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageCommitData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_commit);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_commit_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = message;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_data_->message);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->message = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = author;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->author);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->author = _tmp4_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp5_ = committer;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->committer);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->committer = _tmp6_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp7_ = options;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->options = _tmp7_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_commit_co (_data_);
#line 6516 "gitg-stage.c"
}


GgitOId* gitg_stage_commit_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GgitOId* result;
	GitgStageCommitData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return NULL;
#line 6527 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	result = _data_->result;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->result = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return result;
#line 6537 "gitg-stage.c"
}


static Block29Data* block29_data_ref (Block29Data* _data29_) {
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_atomic_int_inc (&_data29_->_ref_count_);
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return _data29_;
#line 6546 "gitg-stage.c"
}


static void block29_data_unref (void * _userdata_) {
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
#line 6555 "gitg-stage.c"
		GitgStage* self;
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self = _data29_->self;
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data29_->index);
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self);
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_slice_free (Block29Data, _data29_);
#line 6565 "gitg-stage.c"
	}
}


static void ____lambda20_ (Block29Data* _data29_, GError** error) {
	GitgStage* self;
	GgitIndex* _tmp0_ = NULL;
	GitgRepository* _tmp1_ = NULL;
	GgitIndex* _tmp2_ = NULL;
	GgitIndex* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 537 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = _data29_->self;
#line 538 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = self->priv->d_repository;
#line 538 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = ggit_repository_get_index ((GgitRepository*) _tmp1_, &_inner_error_);
#line 538 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _tmp2_;
#line 538 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 538 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 538 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 6591 "gitg-stage.c"
	}
#line 538 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = _tmp0_;
#line 538 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = NULL;
#line 538 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data29_->index);
#line 538 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data29_->index = _tmp3_;
#line 537 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_tmp0_);
#line 6603 "gitg-stage.c"
}


static void _____lambda20__gitg_async_thread_func (gpointer self, GError** error) {
#line 537 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	____lambda20_ (self, error);
#line 6610 "gitg-stage.c"
}


static void gitg_stage_commit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageCommitData* _data_;
#line 537 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 537 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 537 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 537 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_commit_co (_data_);
#line 6624 "gitg-stage.c"
}


static gboolean gitg_stage_commit_co (GitgStageCommitData* _data_) {
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 6633 "gitg-stage.c"
		goto _state_0;
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 6637 "gitg-stage.c"
		goto _state_1;
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 2:
#line 6641 "gitg-stage.c"
		goto _state_2;
		default:
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 6646 "gitg-stage.c"
	}
	_state_0:
#line 530 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = 0;
#line 530 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->options;
#line 530 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->amend = (_data_->_tmp0_ & GITG_STAGE_COMMIT_OPTIONS_AMEND) != 0;
#line 531 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->ret = NULL;
#line 6657 "gitg-stage.c"
	{
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_rec_mutex_lock (&_data_->self->priv->__lock_d_index_mutex);
#line 6661 "gitg-stage.c"
		{
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_data29_ = g_slice_new0 (Block29Data);
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_data29_->_ref_count_ = 1;
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_data29_->self = g_object_ref (_data_->self);
#line 535 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_data29_->index = NULL;
#line 537 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_state_ = 1;
#line 537 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			gitg_async_thread (_____lambda20__gitg_async_thread_func, _data_->_data29_, gitg_stage_commit_ready, _data_);
#line 537 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return FALSE;
#line 6677 "gitg-stage.c"
			_state_1:
#line 537 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error_);
#line 537 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 537 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				block29_data_unref (_data_->_data29_);
#line 537 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_data_->_data29_ = NULL;
#line 6687 "gitg-stage.c"
				goto __finally107;
			}
#line 541 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp2_ = FALSE;
#line 541 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp2_ = _data_->amend;
#line 541 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (!_data_->_tmp2_) {
#line 541 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_data_->_tmp3_ = FALSE;
#line 541 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_data_->_tmp3_ = gitg_stage_has_index_changes (_data_->self);
#line 541 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_data_->_tmp1_ = !_data_->_tmp3_;
#line 6702 "gitg-stage.c"
			} else {
#line 541 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_data_->_tmp1_ = FALSE;
#line 6706 "gitg-stage.c"
			}
#line 541 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (_data_->_tmp1_) {
#line 543 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_data_->_tmp4_ = NULL;
#line 543 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_data_->_tmp4_ = g_error_new_literal (GITG_STAGE_ERROR, GITG_STAGE_ERROR_NOTHING_TO_COMMIT, "Nothing to commit");
#line 543 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_data_->_inner_error_ = _data_->_tmp4_;
#line 543 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				block29_data_unref (_data_->_data29_);
#line 543 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_data_->_data29_ = NULL;
#line 6720 "gitg-stage.c"
				goto __finally107;
			}
#line 547 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp6_ = NULL;
#line 547 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp6_ = _data_->self->priv->d_repository;
#line 547 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp7_ = NULL;
#line 547 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp7_ = gitg_repository_lookup_reference (_data_->_tmp6_, "HEAD", &_data_->_inner_error_);
#line 547 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp5_ = _data_->_tmp7_;
#line 547 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 547 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				block29_data_unref (_data_->_data29_);
#line 547 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_data_->_data29_ = NULL;
#line 6739 "gitg-stage.c"
				goto __finally107;
			}
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp9_ = NULL;
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp9_ = _data_->_data29_->index;
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp10_ = NULL;
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp10_ = _data_->message;
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp11_ = NULL;
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp11_ = _data_->author;
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp12_ = NULL;
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp12_ = _data_->committer;
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp13_ = 0;
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp13_ = _data_->options;
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_state_ = 2;
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			gitg_stage_commit_index (_data_->self, _data_->_tmp9_, (GgitRef*) _data_->_tmp5_, _data_->_tmp10_, _data_->_tmp11_, _data_->_tmp12_, NULL, 0, _data_->_tmp13_, gitg_stage_commit_ready, _data_);
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return FALSE;
#line 6768 "gitg-stage.c"
			_state_2:
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp14_ = NULL;
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp14_ = gitg_stage_commit_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp8_ = _data_->_tmp14_;
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_g_object_unref0 (_data_->_tmp5_);
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				block29_data_unref (_data_->_data29_);
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_data_->_data29_ = NULL;
#line 6784 "gitg-stage.c"
				goto __finally107;
			}
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp15_ = NULL;
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp15_ = _data_->_tmp8_;
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_tmp8_ = NULL;
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			__vala_GgitOId_free0 (_data_->ret);
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->ret = _data_->_tmp15_;
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			__vala_GgitOId_free0 (_data_->_tmp8_);
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (_data_->_tmp5_);
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			block29_data_unref (_data_->_data29_);
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->_data29_ = NULL;
#line 6805 "gitg-stage.c"
		}
		__finally107:
		{
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_rec_mutex_unlock (&_data_->self->priv->__lock_d_index_mutex);
#line 6811 "gitg-stage.c"
		}
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_error_free (_data_->_inner_error_);
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			__vala_GgitOId_free0 (_data_->ret);
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (_data_->_state_ == 0) {
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6825 "gitg-stage.c"
			} else {
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 6829 "gitg-stage.c"
			}
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_object_unref (_data_->_async_result);
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return FALSE;
#line 6835 "gitg-stage.c"
		}
	}
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->result = _data_->ret;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6844 "gitg-stage.c"
	} else {
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 6848 "gitg-stage.c"
	}
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (_data_->ret);
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6860 "gitg-stage.c"
	} else {
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 6864 "gitg-stage.c"
	}
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 525 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 6870 "gitg-stage.c"
}


static void gitg_stage_revert_data_free (gpointer _data) {
	GitgStageRevertData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageRevertData, _data_);
#line 6881 "gitg-stage.c"
}


void gitg_stage_revert (GitgStage* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageRevertData* _data_;
	GitgStage* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageRevertData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_revert);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_revert_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = file;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->file);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->file = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_revert_co (_data_);
#line 6910 "gitg-stage.c"
}


void gitg_stage_revert_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GitgStageRevertData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 6920 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 6924 "gitg-stage.c"
}


/**
 * Revert working directory changes.
 *
 * @param file the file to revert.
 *
 * Revert a file to the version currently recorded in HEAD. This will delete
 * any modifications done in the current working directory to this file,
 * so use with care! Note that this only affects the working directory,
 * not the index.
 */
static Block30Data* block30_data_ref (Block30Data* _data30_) {
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_atomic_int_inc (&_data30_->_ref_count_);
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return _data30_;
#line 6943 "gitg-stage.c"
}


static void block30_data_unref (void * _userdata_) {
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
#line 6952 "gitg-stage.c"
		GitgStage* self;
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self = _data30_->self;
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data30_->tree);
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data30_->file);
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self);
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_slice_free (Block30Data, _data30_);
#line 6964 "gitg-stage.c"
	}
}


static void gitg_stage_revert_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageRevertData* _data_;
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_revert_co (_data_);
#line 6979 "gitg-stage.c"
}


static void __lambda21_ (Block30Data* _data30_, GgitIndex* index, GError** error) {
	GitgStage* self;
	GFile* wd = NULL;
	GitgRepository* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* path = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GgitTreeEntry* entry = NULL;
	GgitTree* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GgitTreeEntry* _tmp7_ = NULL;
	GgitOId* id = NULL;
	GgitTreeEntry* _tmp8_ = NULL;
	GgitOId* _tmp9_ = NULL;
	GgitBlob* blob = NULL;
	GitgRepository* _tmp10_ = NULL;
	GgitOId* _tmp11_ = NULL;
	gpointer _tmp12_ = NULL;
	GFileOutputStream* stream = NULL;
	GFile* _tmp13_ = NULL;
	GFileOutputStream* _tmp14_ = NULL;
	GFileOutputStream* _tmp15_ = NULL;
	GgitBlob* _tmp16_ = NULL;
	gsize _tmp17_;
	guint8* _tmp18_ = NULL;
	GFileOutputStream* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = _data30_->self;
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (index != NULL);
#line 574 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = self->priv->d_repository;
#line 574 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _tmp0_);
#line 574 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	wd = _tmp1_;
#line 575 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = wd;
#line 575 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = _data30_->file;
#line 575 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = g_file_get_relative_path (_tmp2_, _tmp3_);
#line 575 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	path = _tmp4_;
#line 578 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp5_ = _data30_->tree;
#line 578 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp6_ = path;
#line 578 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp7_ = ggit_tree_get_by_path (_tmp5_, _tmp6_, &_inner_error_);
#line 578 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	entry = _tmp7_;
#line 578 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 578 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 578 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (path);
#line 578 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (wd);
#line 578 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 7048 "gitg-stage.c"
	}
#line 579 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp8_ = entry;
#line 579 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp9_ = ggit_tree_entry_get_id (_tmp8_);
#line 579 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	id = _tmp9_;
#line 582 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp10_ = self->priv->d_repository;
#line 582 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp11_ = id;
#line 582 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp12_ = gitg_repository_lookup (_tmp10_, ggit_blob_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp11_, &_inner_error_);
#line 582 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	blob = (GgitBlob*) _tmp12_;
#line 582 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 582 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 582 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (id);
#line 582 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_tree_entry_unref0 (entry);
#line 582 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (path);
#line 582 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (wd);
#line 582 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 7078 "gitg-stage.c"
	}
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp13_ = _data30_->file;
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp14_ = g_file_replace (_tmp13_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	stream = _tmp14_;
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (blob);
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (id);
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_tree_entry_unref0 (entry);
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (path);
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (wd);
#line 584 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 7102 "gitg-stage.c"
	}
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp15_ = stream;
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp16_ = blob;
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp18_ = ggit_blob_get_raw_content (_tmp16_, &_tmp17_);
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_output_stream_write_all ((GOutputStream*) _tmp15_, _tmp18_, (gsize) _tmp17_, NULL, NULL, &_inner_error_);
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (stream);
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (blob);
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (id);
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_tree_entry_unref0 (entry);
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (path);
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (wd);
#line 586 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 7130 "gitg-stage.c"
	}
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp19_ = stream;
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_output_stream_close ((GOutputStream*) _tmp19_, NULL, &_inner_error_);
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (stream);
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (blob);
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (id);
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_tree_entry_unref0 (entry);
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (path);
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (wd);
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 7154 "gitg-stage.c"
	}
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (stream);
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (blob);
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (id);
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_ggit_tree_entry_unref0 (entry);
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (path);
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (wd);
#line 7168 "gitg-stage.c"
}


static void ___lambda21__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error) {
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__lambda21_ (self, index, error);
#line 7175 "gitg-stage.c"
}


static gboolean gitg_stage_revert_co (GitgStageRevertData* _data_) {
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 7184 "gitg-stage.c"
		goto _state_0;
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 7188 "gitg-stage.c"
		goto _state_1;
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 2:
#line 7192 "gitg-stage.c"
		goto _state_2;
		default:
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 7197 "gitg-stage.c"
	}
	_state_0:
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data30_ = g_slice_new0 (Block30Data);
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data30_->_ref_count_ = 1;
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data30_->self = g_object_ref (_data_->self);
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->file;
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_data30_->file);
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data30_->file = _data_->_tmp0_;
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data30_->_async_data_ = _data_;
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_get_head_tree (_data_->self, gitg_stage_revert_ready, _data_);
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 7222 "gitg-stage.c"
	_state_1:
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = NULL;
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = gitg_stage_get_head_tree_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data30_->tree = _data_->_tmp1_;
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block30_data_unref (_data_->_data30_);
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data30_ = NULL;
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 7244 "gitg-stage.c"
		} else {
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 7248 "gitg-stage.c"
		}
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 570 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 7254 "gitg-stage.c"
	}
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 2;
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index (_data_->self, ___lambda21__gitg_stage_with_index_func, _data_->_data30_, gitg_stage_revert_ready, _data_);
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 7262 "gitg-stage.c"
	_state_2:
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block30_data_unref (_data_->_data30_);
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data30_ = NULL;
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 7280 "gitg-stage.c"
		} else {
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 7284 "gitg-stage.c"
		}
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 7290 "gitg-stage.c"
	}
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block30_data_unref (_data_->_data30_);
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data30_ = NULL;
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 7300 "gitg-stage.c"
	} else {
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 7304 "gitg-stage.c"
	}
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 568 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 7310 "gitg-stage.c"
}


static void gitg_stage_revert_path_data_free (gpointer _data) {
	GitgStageRevertPathData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_data_->path);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageRevertPathData, _data_);
#line 7323 "gitg-stage.c"
}


void gitg_stage_revert_path (GitgStage* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageRevertPathData* _data_;
	GitgStage* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageRevertPathData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_revert_path);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_revert_path_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = path;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_data_->path);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->path = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_revert_path_co (_data_);
#line 7352 "gitg-stage.c"
}


void gitg_stage_revert_path_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GitgStageRevertPathData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 7362 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 7366 "gitg-stage.c"
}


/**
 * Revert working directory changes.
 *
 * @param path path relative to the working directory.
 *
 * Revert a path to the version currently recorded in HEAD. This will delete
 * any modifications done in the current working directory to this file,
 * so use with care! Note that this only affects the working directory,
 * not the index.
 */
static void gitg_stage_revert_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageRevertPathData* _data_;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_revert_path_co (_data_);
#line 7390 "gitg-stage.c"
}


static gboolean gitg_stage_revert_path_co (GitgStageRevertPathData* _data_) {
#line 601 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 601 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 7399 "gitg-stage.c"
		goto _state_0;
#line 601 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 7403 "gitg-stage.c"
		goto _state_1;
		default:
#line 601 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 7408 "gitg-stage.c"
	}
	_state_0:
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->self->priv->d_repository;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = NULL;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _data_->_tmp0_);
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = NULL;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = NULL;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = _data_->path;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = NULL;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = g_file_resolve_relative_path (_data_->_tmp2_, _data_->_tmp3_);
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = NULL;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_revert (_data_->self, _data_->_tmp5_, gitg_stage_revert_path_ready, _data_);
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 7441 "gitg-stage.c"
	_state_1:
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_revert_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp5_);
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp2_);
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 7459 "gitg-stage.c"
		} else {
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 7463 "gitg-stage.c"
		}
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 7469 "gitg-stage.c"
	}
#line 601 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 601 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 7475 "gitg-stage.c"
	} else {
#line 601 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 7479 "gitg-stage.c"
	}
#line 601 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 601 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 7485 "gitg-stage.c"
}


static void gitg_stage_revert_patch_data_free (gpointer _data) {
	GitgStageRevertPatchData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageRevertPatchData, _data_);
#line 7496 "gitg-stage.c"
}


static gpointer _gitg_patch_set_ref0 (gpointer self) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return self ? gitg_patch_set_ref (self) : NULL;
#line 7503 "gitg-stage.c"
}


void gitg_stage_revert_patch (GitgStage* self, GitgPatchSet* patch, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageRevertPatchData* _data_;
	GitgStage* _tmp0_ = NULL;
	GitgPatchSet* _tmp1_ = NULL;
	GitgPatchSet* _tmp2_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageRevertPatchData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_revert_patch);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_revert_patch_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = patch;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = _gitg_patch_set_ref0 (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_gitg_patch_set_unref0 (_data_->patch);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->patch = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_revert_patch_co (_data_);
#line 7532 "gitg-stage.c"
}


void gitg_stage_revert_patch_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GitgStageRevertPatchData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 7542 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 7546 "gitg-stage.c"
}


/**
 * Revert a patch in the working directory.
 *
 * @param patch the patch to revert.
 *
 * Revert a provided patch from the working directory. The patch should
 * contain changes of the file in the current working directory to the contents
 * of the index (i.e. as obtained from diff_workdir)
 */
static Block31Data* block31_data_ref (Block31Data* _data31_) {
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_atomic_int_inc (&_data31_->_ref_count_);
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return _data31_;
#line 7564 "gitg-stage.c"
}


static void block31_data_unref (void * _userdata_) {
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
#line 7573 "gitg-stage.c"
		GitgStage* self;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self = _data31_->self;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data31_->workdirf_stream);
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data31_->workdirf);
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_gitg_patch_set_unref0 (_data31_->patch);
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self);
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_slice_free (Block31Data, _data31_);
#line 7587 "gitg-stage.c"
	}
}


static void gitg_stage_revert_patch_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageRevertPatchData* _data_;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_revert_patch_co (_data_);
#line 7602 "gitg-stage.c"
}


static void __lambda22_ (Block31Data* _data31_, GgitIndex* index, GError** error) {
	GitgStage* self;
	GgitIndexEntries* entries = NULL;
	GgitIndex* _tmp0_ = NULL;
	GgitIndexEntries* _tmp1_ = NULL;
	GgitIndexEntry* entry = NULL;
	GgitIndexEntries* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GgitIndexEntry* _tmp4_ = NULL;
	GgitIndexEntry* _tmp5_ = NULL;
	GgitBlob* index_blob = NULL;
	GitgRepository* _tmp9_ = NULL;
	GgitIndexEntry* _tmp10_ = NULL;
	GgitOId* _tmp11_ = NULL;
	GgitOId* _tmp12_ = NULL;
	gpointer _tmp13_ = NULL;
	GgitBlob* _tmp14_ = NULL;
	guchar* index_content = NULL;
	GgitBlob* _tmp15_ = NULL;
	gsize _tmp16_;
	guint8* _tmp17_ = NULL;
	gint index_content_length1 = 0;
	gint _index_content_size_ = 0;
	GMemoryInputStream* index_stream = NULL;
	guchar* _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	GBytes* _tmp19_ = NULL;
	GBytes* _tmp20_ = NULL;
	GMemoryInputStream* _tmp21_ = NULL;
	GMemoryInputStream* _tmp22_ = NULL;
	GitgPatchSet* reversed = NULL;
	GitgPatchSet* _tmp23_ = NULL;
	GitgPatchSet* _tmp24_ = NULL;
	GFileIOStream* out_stream = NULL;
	GFile* outf = NULL;
	GFileInputStream* _tmp41_ = NULL;
	GMemoryInputStream* _tmp42_ = NULL;
	GFileIOStream* _tmp43_ = NULL;
	GError * _inner_error_ = NULL;
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = _data31_->self;
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (index != NULL);
#line 622 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = index;
#line 622 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = ggit_index_get_entries (_tmp0_);
#line 622 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	entries = _tmp1_;
#line 623 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = entries;
#line 623 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = _data31_->workdirf;
#line 623 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = ggit_index_entries_get_by_path (_tmp2_, _tmp3_, 0);
#line 623 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	entry = _tmp4_;
#line 625 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp5_ = entry;
#line 625 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_tmp5_ == NULL) {
#line 7667 "gitg-stage.c"
		GitgPatchSet* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
#line 627 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp6_ = _data31_->patch;
#line 627 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp7_ = _tmp6_->filename;
#line 627 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp8_ = g_error_new_literal (GITG_STAGE_ERROR, GITG_STAGE_ERROR_INDEX_ENTRY_NOT_FOUND, _tmp7_);
#line 627 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = _tmp8_;
#line 627 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 627 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 627 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 627 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 7687 "gitg-stage.c"
	}
#line 630 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp9_ = self->priv->d_repository;
#line 630 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp10_ = entry;
#line 630 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp11_ = ggit_index_entry_get_id (_tmp10_);
#line 630 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp12_ = _tmp11_;
#line 630 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp13_ = gitg_repository_lookup (_tmp9_, ggit_blob_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp12_, &_inner_error_);
#line 630 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp14_ = (GgitBlob*) _tmp13_;
#line 630 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (_tmp12_);
#line 630 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	index_blob = _tmp14_;
#line 630 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 630 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 630 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 630 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 630 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 7715 "gitg-stage.c"
	}
#line 631 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp15_ = index_blob;
#line 631 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp17_ = ggit_blob_get_raw_content (_tmp15_, &_tmp16_);
#line 631 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	index_content = _tmp17_;
#line 631 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	index_content_length1 = _tmp16_;
#line 631 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_index_content_size_ = index_content_length1;
#line 633 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp18_ = index_content;
#line 633 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp18__length1 = index_content_length1;
#line 633 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp19_ = g_bytes_new (_tmp18_, _tmp18__length1);
#line 633 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp20_ = _tmp19_;
#line 633 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp21_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp20_);
#line 633 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp22_ = _tmp21_;
#line 633 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_bytes_unref0 (_tmp20_);
#line 633 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	index_stream = _tmp22_;
#line 634 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp23_ = _data31_->patch;
#line 634 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp24_ = gitg_patch_set_reversed (_tmp23_);
#line 634 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	reversed = _tmp24_;
#line 636 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	out_stream = NULL;
#line 637 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	outf = NULL;
#line 7753 "gitg-stage.c"
	{
		GFile* _tmp25_ = NULL;
		GFileIOStream* _tmp26_ = NULL;
		GFile* _tmp27_ = NULL;
		GFile* _tmp28_ = NULL;
		GFileInputStream* _tmp29_ = NULL;
		GMemoryInputStream* _tmp30_ = NULL;
		GFileIOStream* _tmp31_ = NULL;
		GOutputStream* _tmp32_ = NULL;
		GOutputStream* _tmp33_ = NULL;
		GitgPatchSet* _tmp34_ = NULL;
#line 641 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp27_ = g_file_new_tmp (NULL, &_tmp26_, &_inner_error_);
#line 641 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (out_stream);
#line 641 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		out_stream = _tmp26_;
#line 641 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp25_ = _tmp27_;
#line 641 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7775 "gitg-stage.c"
			goto __catch108_g_error;
		}
#line 641 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp28_ = _tmp25_;
#line 641 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp25_ = NULL;
#line 641 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (outf);
#line 641 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		outf = _tmp28_;
#line 643 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp29_ = _data31_->workdirf_stream;
#line 643 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp30_ = index_stream;
#line 643 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp31_ = out_stream;
#line 643 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp32_ = g_io_stream_get_output_stream ((GIOStream*) _tmp31_);
#line 643 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp33_ = _tmp32_;
#line 643 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp34_ = reversed;
#line 643 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		gitg_stage_apply_patch_stream (self, (GInputStream*) _tmp29_, (GInputStream*) _tmp30_, _tmp33_, _tmp34_, &_inner_error_);
#line 643 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 643 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (_tmp25_);
#line 7804 "gitg-stage.c"
			goto __catch108_g_error;
		}
#line 639 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_tmp25_);
#line 7809 "gitg-stage.c"
	}
	goto __finally108;
	__catch108_g_error:
	{
		GError* e = NULL;
		GFileInputStream* _tmp35_ = NULL;
		GMemoryInputStream* _tmp36_ = NULL;
		GFile* _tmp37_ = NULL;
		GError* _tmp39_ = NULL;
		GError* _tmp40_ = NULL;
#line 639 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		e = _inner_error_;
#line 639 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = NULL;
#line 650 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp35_ = _data31_->workdirf_stream;
#line 650 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_input_stream_close ((GInputStream*) _tmp35_, NULL, &_inner_error_);
#line 650 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 650 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_error_free0 (e);
#line 7832 "gitg-stage.c"
			goto __finally108;
		}
#line 651 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp36_ = index_stream;
#line 651 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_input_stream_close ((GInputStream*) _tmp36_, NULL, &_inner_error_);
#line 651 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 651 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_error_free0 (e);
#line 7843 "gitg-stage.c"
			goto __finally108;
		}
#line 653 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp37_ = outf;
#line 653 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_tmp37_ != NULL) {
#line 7850 "gitg-stage.c"
			{
				GFile* _tmp38_ = NULL;
#line 657 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp38_ = outf;
#line 657 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				g_file_delete (_tmp38_, NULL, &_inner_error_);
#line 657 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7859 "gitg-stage.c"
					goto __catch109_g_error;
				}
			}
			goto __finally109;
			__catch109_g_error:
			{
#line 655 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				g_clear_error (&_inner_error_);
#line 655 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_inner_error_ = NULL;
#line 7870 "gitg-stage.c"
			}
			__finally109:
#line 655 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 655 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_g_error_free0 (e);
#line 655 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_g_error_free0 (e);
#line 655 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_g_object_unref0 (outf);
#line 655 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_g_object_unref0 (out_stream);
#line 655 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_gitg_patch_set_unref0 (reversed);
#line 655 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_g_object_unref0 (index_stream);
#line 655 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_g_object_unref0 (index_blob);
#line 655 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_ggit_index_entry_unref0 (entry);
#line 655 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_ggit_index_entries_unref0 (entries);
#line 655 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 655 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				g_clear_error (&_inner_error_);
#line 655 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				return;
#line 7899 "gitg-stage.c"
			}
		}
#line 661 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp39_ = e;
#line 661 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp40_ = _g_error_copy0 (_tmp39_);
#line 661 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = _tmp40_;
#line 661 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_error_free0 (e);
#line 7910 "gitg-stage.c"
		goto __finally108;
	}
	__finally108:
#line 639 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 639 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 639 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (outf);
#line 639 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (out_stream);
#line 639 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_gitg_patch_set_unref0 (reversed);
#line 639 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (index_stream);
#line 639 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (index_blob);
#line 639 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 639 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 639 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 7934 "gitg-stage.c"
	}
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp41_ = _data31_->workdirf_stream;
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_input_stream_close ((GInputStream*) _tmp41_, NULL, &_inner_error_);
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (outf);
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (out_stream);
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_gitg_patch_set_unref0 (reversed);
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (index_stream);
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (index_blob);
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 664 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 7960 "gitg-stage.c"
	}
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp42_ = index_stream;
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_input_stream_close ((GInputStream*) _tmp42_, NULL, &_inner_error_);
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (outf);
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (out_stream);
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_gitg_patch_set_unref0 (reversed);
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (index_stream);
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (index_blob);
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 665 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 7986 "gitg-stage.c"
	}
#line 667 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp43_ = out_stream;
#line 667 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_tmp43_ != NULL) {
#line 7992 "gitg-stage.c"
		GFileIOStream* _tmp44_ = NULL;
#line 669 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp44_ = out_stream;
#line 669 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_io_stream_close ((GIOStream*) _tmp44_, NULL, &_inner_error_);
#line 669 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 669 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_propagate_error (error, _inner_error_);
#line 669 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (outf);
#line 669 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (out_stream);
#line 669 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_gitg_patch_set_unref0 (reversed);
#line 669 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (index_stream);
#line 669 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (index_blob);
#line 669 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_ggit_index_entry_unref0 (entry);
#line 669 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_ggit_index_entries_unref0 (entries);
#line 669 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return;
#line 8018 "gitg-stage.c"
		}
	}
	{
		GFileOutputStream* repl = NULL;
		GFile* _tmp45_ = NULL;
		GFileOutputStream* _tmp46_ = NULL;
		GFileInputStream* _tmp47_ = NULL;
		GFile* _tmp48_ = NULL;
		GFileInputStream* _tmp49_ = NULL;
		GFileOutputStream* _tmp50_ = NULL;
#line 675 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp45_ = _data31_->workdirf;
#line 675 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp46_ = g_file_replace (_tmp45_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 675 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		repl = _tmp46_;
#line 675 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8037 "gitg-stage.c"
			goto __catch110_g_error;
		}
#line 679 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp48_ = outf;
#line 679 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp49_ = g_file_read (_tmp48_, NULL, &_inner_error_);
#line 679 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp47_ = _tmp49_;
#line 679 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 679 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (repl);
#line 8050 "gitg-stage.c"
			goto __catch110_g_error;
		}
#line 679 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp50_ = repl;
#line 679 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_output_stream_splice ((GOutputStream*) _tmp50_, (GInputStream*) _tmp47_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, NULL, &_inner_error_);
#line 679 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 679 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (_tmp47_);
#line 679 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (repl);
#line 8063 "gitg-stage.c"
			goto __catch110_g_error;
		}
#line 673 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_tmp47_);
#line 673 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (repl);
#line 8070 "gitg-stage.c"
	}
	goto __finally110;
	__catch110_g_error:
	{
		GError* e = NULL;
		GError* _tmp52_ = NULL;
		GError* _tmp53_ = NULL;
#line 673 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		e = _inner_error_;
#line 673 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = NULL;
#line 8082 "gitg-stage.c"
		{
			GFile* _tmp51_ = NULL;
#line 687 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_tmp51_ = outf;
#line 687 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_file_delete (_tmp51_, NULL, &_inner_error_);
#line 687 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8091 "gitg-stage.c"
				goto __catch111_g_error;
			}
		}
		goto __finally111;
		__catch111_g_error:
		{
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_clear_error (&_inner_error_);
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_inner_error_ = NULL;
#line 8102 "gitg-stage.c"
		}
		__finally111:
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_error_free0 (e);
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_error_free0 (e);
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (outf);
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (out_stream);
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_gitg_patch_set_unref0 (reversed);
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (index_stream);
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (index_blob);
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_ggit_index_entry_unref0 (entry);
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_ggit_index_entries_unref0 (entries);
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_clear_error (&_inner_error_);
#line 685 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return;
#line 8131 "gitg-stage.c"
		}
#line 690 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp52_ = e;
#line 690 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp53_ = _g_error_copy0 (_tmp52_);
#line 690 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = _tmp53_;
#line 690 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_error_free0 (e);
#line 8141 "gitg-stage.c"
		goto __finally110;
	}
	__finally110:
#line 673 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 673 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 673 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (outf);
#line 673 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (out_stream);
#line 673 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_gitg_patch_set_unref0 (reversed);
#line 673 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (index_stream);
#line 673 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (index_blob);
#line 673 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 673 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 673 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 8165 "gitg-stage.c"
	}
	{
		GFile* _tmp54_ = NULL;
#line 695 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp54_ = outf;
#line 695 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_file_delete (_tmp54_, NULL, &_inner_error_);
#line 695 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8175 "gitg-stage.c"
			goto __catch112_g_error;
		}
	}
	goto __finally112;
	__catch112_g_error:
	{
#line 693 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_clear_error (&_inner_error_);
#line 693 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = NULL;
#line 8186 "gitg-stage.c"
	}
	__finally112:
#line 693 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 693 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 693 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (outf);
#line 693 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (out_stream);
#line 693 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_gitg_patch_set_unref0 (reversed);
#line 693 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (index_stream);
#line 693 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (index_blob);
#line 693 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 693 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 693 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 8209 "gitg-stage.c"
	}
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (outf);
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (out_stream);
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_gitg_patch_set_unref0 (reversed);
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (index_stream);
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (index_blob);
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_ggit_index_entry_unref0 (entry);
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_ggit_index_entries_unref0 (entries);
#line 8225 "gitg-stage.c"
}


static void ___lambda22__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error) {
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__lambda22_ (self, index, error);
#line 8232 "gitg-stage.c"
}


static gboolean gitg_stage_revert_patch_co (GitgStageRevertPatchData* _data_) {
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 8241 "gitg-stage.c"
		goto _state_0;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 8245 "gitg-stage.c"
		goto _state_1;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 2:
#line 8249 "gitg-stage.c"
		goto _state_2;
		default:
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 8254 "gitg-stage.c"
	}
	_state_0:
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data31_ = g_slice_new0 (Block31Data);
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data31_->_ref_count_ = 1;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data31_->self = g_object_ref (_data_->self);
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->patch;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_gitg_patch_set_unref0 (_data_->_data31_->patch);
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data31_->patch = _data_->_tmp0_;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data31_->_async_data_ = _data_;
#line 618 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = NULL;
#line 618 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = _data_->self->priv->d_repository;
#line 618 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = NULL;
#line 618 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = ggit_repository_get_workdir ((GgitRepository*) _data_->_tmp1_);
#line 618 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = NULL;
#line 618 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 618 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = NULL;
#line 618 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = _data_->_data31_->patch;
#line 618 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = NULL;
#line 618 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = _data_->_tmp4_->filename;
#line 618 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp6_ = NULL;
#line 618 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp6_ = g_file_resolve_relative_path (_data_->_tmp3_, _data_->_tmp5_);
#line 618 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7_ = NULL;
#line 618 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7_ = _data_->_tmp6_;
#line 618 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp3_);
#line 618 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data31_->workdirf = _data_->_tmp7_;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp8_ = NULL;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp8_ = _data_->_data31_->workdirf;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_file_read_async (_data_->_tmp8_, G_PRIORITY_DEFAULT, NULL, gitg_stage_revert_patch_ready, _data_);
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 8315 "gitg-stage.c"
	_state_1:
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp9_ = NULL;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp9_ = g_file_read_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error_);
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data31_->workdirf_stream = _data_->_tmp9_;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block31_data_unref (_data_->_data31_);
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data31_ = NULL;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 8337 "gitg-stage.c"
		} else {
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 8341 "gitg-stage.c"
		}
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 8347 "gitg-stage.c"
	}
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 2;
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index (_data_->self, ___lambda22__gitg_stage_with_index_func, _data_->_data31_, gitg_stage_revert_patch_ready, _data_);
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 8355 "gitg-stage.c"
	_state_2:
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block31_data_unref (_data_->_data31_);
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data31_ = NULL;
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 8373 "gitg-stage.c"
		} else {
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 8377 "gitg-stage.c"
		}
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 8383 "gitg-stage.c"
	}
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block31_data_unref (_data_->_data31_);
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data31_ = NULL;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 8393 "gitg-stage.c"
	} else {
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 8397 "gitg-stage.c"
	}
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 8403 "gitg-stage.c"
}


static void gitg_stage_delete_data_free (gpointer _data) {
	GitgStageDeleteData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageDeleteData, _data_);
#line 8414 "gitg-stage.c"
}


void gitg_stage_delete (GitgStage* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageDeleteData* _data_;
	GitgStage* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageDeleteData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_delete);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_delete_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = file;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->file);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->file = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_delete_co (_data_);
#line 8443 "gitg-stage.c"
}


void gitg_stage_delete_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GitgStageDeleteData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 8453 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 8457 "gitg-stage.c"
}


/**
 * Delete a file from the index.
 *
 * @param file the file to delete.
 *
 * Delete the file from the index.
 */
static Block32Data* block32_data_ref (Block32Data* _data32_) {
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_atomic_int_inc (&_data32_->_ref_count_);
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return _data32_;
#line 8473 "gitg-stage.c"
}


static void block32_data_unref (void * _userdata_) {
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
#line 8482 "gitg-stage.c"
		GitgStage* self;
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self = _data32_->self;
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data32_->file);
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self);
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_slice_free (Block32Data, _data32_);
#line 8492 "gitg-stage.c"
	}
}


static void __lambda23_ (Block32Data* _data32_, GgitIndex* index, GError** error) {
	GitgStage* self;
	GgitIndex* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GgitIndex* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = _data32_->self;
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (index != NULL);
#line 710 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = index;
#line 710 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = _data32_->file;
#line 710 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	ggit_index_remove (_tmp0_, _tmp1_, 0, &_inner_error_);
#line 710 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 710 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 710 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 8519 "gitg-stage.c"
	}
#line 711 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = index;
#line 711 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	ggit_index_write (_tmp2_, &_inner_error_);
#line 711 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 711 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 711 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 8531 "gitg-stage.c"
	}
}


static void ___lambda23__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error) {
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__lambda23_ (self, index, error);
#line 8539 "gitg-stage.c"
}


static void gitg_stage_delete_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageDeleteData* _data_;
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_delete_co (_data_);
#line 8553 "gitg-stage.c"
}


static gboolean gitg_stage_delete_co (GitgStageDeleteData* _data_) {
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 8562 "gitg-stage.c"
		goto _state_0;
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 8566 "gitg-stage.c"
		goto _state_1;
		default:
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 8571 "gitg-stage.c"
	}
	_state_0:
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data32_ = g_slice_new0 (Block32Data);
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data32_->_ref_count_ = 1;
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data32_->self = g_object_ref (_data_->self);
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->file;
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_data32_->file);
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data32_->file = _data_->_tmp0_;
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data32_->_async_data_ = _data_;
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index (_data_->self, ___lambda23__gitg_stage_with_index_func, _data_->_data32_, gitg_stage_delete_ready, _data_);
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 8596 "gitg-stage.c"
	_state_1:
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block32_data_unref (_data_->_data32_);
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data32_ = NULL;
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 8614 "gitg-stage.c"
		} else {
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 8618 "gitg-stage.c"
		}
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 709 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 8624 "gitg-stage.c"
	}
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block32_data_unref (_data_->_data32_);
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data32_ = NULL;
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 8634 "gitg-stage.c"
	} else {
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 8638 "gitg-stage.c"
	}
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 707 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 8644 "gitg-stage.c"
}


static void gitg_stage_delete_path_data_free (gpointer _data) {
	GitgStageDeletePathData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_data_->path);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageDeletePathData, _data_);
#line 8657 "gitg-stage.c"
}


void gitg_stage_delete_path (GitgStage* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageDeletePathData* _data_;
	GitgStage* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageDeletePathData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_delete_path);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_delete_path_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = path;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_data_->path);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->path = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_delete_path_co (_data_);
#line 8686 "gitg-stage.c"
}


void gitg_stage_delete_path_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GitgStageDeletePathData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 8696 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 8700 "gitg-stage.c"
}


/**
 * Delete a relative path from the index.
 *
 * @param path path relative to the working directory.
 *
 * Delete the relative path from the index.
 */
static void gitg_stage_delete_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageDeletePathData* _data_;
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_delete_path_co (_data_);
#line 8721 "gitg-stage.c"
}


static gboolean gitg_stage_delete_path_co (GitgStageDeletePathData* _data_) {
#line 722 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 722 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 8730 "gitg-stage.c"
		goto _state_0;
#line 722 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 8734 "gitg-stage.c"
		goto _state_1;
		default:
#line 722 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 8739 "gitg-stage.c"
	}
	_state_0:
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->self->priv->d_repository;
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = NULL;
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _data_->_tmp0_);
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = NULL;
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = NULL;
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = _data_->path;
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = NULL;
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = g_file_resolve_relative_path (_data_->_tmp2_, _data_->_tmp3_);
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = NULL;
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_delete (_data_->self, _data_->_tmp5_, gitg_stage_delete_path_ready, _data_);
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 8772 "gitg-stage.c"
	_state_1:
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_delete_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp5_);
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp2_);
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 8790 "gitg-stage.c"
		} else {
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 8794 "gitg-stage.c"
		}
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 724 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 8800 "gitg-stage.c"
	}
#line 722 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 722 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 8806 "gitg-stage.c"
	} else {
#line 722 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 8810 "gitg-stage.c"
	}
#line 722 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 722 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 8816 "gitg-stage.c"
}


static void gitg_stage_stage_data_free (gpointer _data) {
	GitgStageStageData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageStageData, _data_);
#line 8827 "gitg-stage.c"
}


void gitg_stage_stage (GitgStage* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageStageData* _data_;
	GitgStage* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageStageData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_stage);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_stage_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = file;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->file);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->file = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_stage_co (_data_);
#line 8856 "gitg-stage.c"
}


void gitg_stage_stage_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GitgStageStageData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 8866 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 8870 "gitg-stage.c"
}


/**
 * Stage a file to the index.
 *
 * @param file the file to stage.
 *
 * Stage the file to the index. This will record the state of the file in
 * the working directory to the index.
 */
static Block33Data* block33_data_ref (Block33Data* _data33_) {
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_atomic_int_inc (&_data33_->_ref_count_);
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return _data33_;
#line 8887 "gitg-stage.c"
}


static void block33_data_unref (void * _userdata_) {
	Block33Data* _data33_;
	_data33_ = (Block33Data*) _userdata_;
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_atomic_int_dec_and_test (&_data33_->_ref_count_)) {
#line 8896 "gitg-stage.c"
		GitgStage* self;
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self = _data33_->self;
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data33_->file);
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self);
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_slice_free (Block33Data, _data33_);
#line 8906 "gitg-stage.c"
	}
}


static void __lambda24_ (Block33Data* _data33_, GgitIndex* index, GError** error) {
	GitgStage* self;
	GgitIndex* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GgitIndex* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = _data33_->self;
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (index != NULL);
#line 738 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = index;
#line 738 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = _data33_->file;
#line 738 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	ggit_index_add_file (_tmp0_, _tmp1_, &_inner_error_);
#line 738 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 738 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 738 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 8933 "gitg-stage.c"
	}
#line 739 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = index;
#line 739 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	ggit_index_write (_tmp2_, &_inner_error_);
#line 739 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 739 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 739 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 8945 "gitg-stage.c"
	}
}


static void ___lambda24__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error) {
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__lambda24_ (self, index, error);
#line 8953 "gitg-stage.c"
}


static void gitg_stage_stage_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageStageData* _data_;
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_stage_co (_data_);
#line 8967 "gitg-stage.c"
}


static gboolean gitg_stage_stage_co (GitgStageStageData* _data_) {
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 8976 "gitg-stage.c"
		goto _state_0;
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 8980 "gitg-stage.c"
		goto _state_1;
		default:
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 8985 "gitg-stage.c"
	}
	_state_0:
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data33_ = g_slice_new0 (Block33Data);
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data33_->_ref_count_ = 1;
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data33_->self = g_object_ref (_data_->self);
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->file;
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_data33_->file);
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data33_->file = _data_->_tmp0_;
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data33_->_async_data_ = _data_;
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index (_data_->self, ___lambda24__gitg_stage_with_index_func, _data_->_data33_, gitg_stage_stage_ready, _data_);
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 9010 "gitg-stage.c"
	_state_1:
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block33_data_unref (_data_->_data33_);
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data33_ = NULL;
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 9028 "gitg-stage.c"
		} else {
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 9032 "gitg-stage.c"
		}
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 737 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 9038 "gitg-stage.c"
	}
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block33_data_unref (_data_->_data33_);
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data33_ = NULL;
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 9048 "gitg-stage.c"
	} else {
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 9052 "gitg-stage.c"
	}
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 735 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 9058 "gitg-stage.c"
}


static void gitg_stage_stage_path_data_free (gpointer _data) {
	GitgStageStagePathData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_data_->path);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageStagePathData, _data_);
#line 9071 "gitg-stage.c"
}


void gitg_stage_stage_path (GitgStage* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageStagePathData* _data_;
	GitgStage* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageStagePathData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_stage_path);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_stage_path_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = path;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_data_->path);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->path = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_stage_path_co (_data_);
#line 9100 "gitg-stage.c"
}


void gitg_stage_stage_path_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GitgStageStagePathData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 9110 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 9114 "gitg-stage.c"
}


/**
 * Stage a path to the index.
 *
 * @param path path relative to the working directory.
 *
 * Stage a relative path to the index. This will record the state of the file in
 * the working directory to the index.
 */
static void gitg_stage_stage_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageStagePathData* _data_;
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_stage_path_co (_data_);
#line 9136 "gitg-stage.c"
}


static gboolean gitg_stage_stage_path_co (GitgStageStagePathData* _data_) {
#line 751 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 751 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 9145 "gitg-stage.c"
		goto _state_0;
#line 751 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 9149 "gitg-stage.c"
		goto _state_1;
		default:
#line 751 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 9154 "gitg-stage.c"
	}
	_state_0:
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->self->priv->d_repository;
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = NULL;
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _data_->_tmp0_);
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = NULL;
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = NULL;
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = _data_->path;
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = NULL;
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = g_file_resolve_relative_path (_data_->_tmp2_, _data_->_tmp3_);
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = NULL;
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_stage (_data_->self, _data_->_tmp5_, gitg_stage_stage_path_ready, _data_);
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 9187 "gitg-stage.c"
	_state_1:
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_stage_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp5_);
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp2_);
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 9205 "gitg-stage.c"
		} else {
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 9209 "gitg-stage.c"
		}
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 753 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 9215 "gitg-stage.c"
	}
#line 751 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 751 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 9221 "gitg-stage.c"
	} else {
#line 751 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 9225 "gitg-stage.c"
	}
#line 751 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 751 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 9231 "gitg-stage.c"
}


static void gitg_stage_stage_commit_data_free (gpointer _data) {
	GitgStageStageCommitData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageStageCommitData, _data_);
#line 9242 "gitg-stage.c"
}


void gitg_stage_stage_commit (GitgStage* self, const gchar* path, GgitCommit* commit, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageStageCommitData* _data_;
	GitgStage* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GgitCommit* _tmp3_ = NULL;
	GgitCommit* _tmp4_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageStageCommitData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_stage_commit);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_stage_commit_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = path;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_data_->path);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->path = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = commit;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->commit);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->commit = _tmp4_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_stage_commit_co (_data_);
#line 9281 "gitg-stage.c"
}


void gitg_stage_stage_commit_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GitgStageStageCommitData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 9291 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 9295 "gitg-stage.c"
}


/**
 * Stage a commit to the index.
 *
 * @param path path relative to the working directory.
 * @param id the id of the commit object to stage at the given path.
 *
 * Stage a commit to the index with a relative path. This will record the
 * given commit id for file pointed to at path in the index.
 */
static Block34Data* block34_data_ref (Block34Data* _data34_) {
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_atomic_int_inc (&_data34_->_ref_count_);
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return _data34_;
#line 9313 "gitg-stage.c"
}


static void block34_data_unref (void * _userdata_) {
	Block34Data* _data34_;
	_data34_ = (Block34Data*) _userdata_;
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_atomic_int_dec_and_test (&_data34_->_ref_count_)) {
#line 9322 "gitg-stage.c"
		GitgStage* self;
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self = _data34_->self;
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (_data34_->path);
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data34_->commit);
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self);
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_slice_free (Block34Data, _data34_);
#line 9334 "gitg-stage.c"
	}
}


static void __lambda25_ (Block34Data* _data34_, GgitIndex* index, GError** error) {
	GitgStage* self;
	GgitIndexEntry* entry = NULL;
	GitgRepository* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GgitCommit* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
	GgitOId* _tmp4_ = NULL;
	GgitIndexEntry* _tmp5_ = NULL;
	GgitIndexEntry* _tmp6_ = NULL;
	GgitIndexEntry* _tmp7_ = NULL;
	GgitCommit* _tmp8_ = NULL;
	GgitIndex* _tmp9_ = NULL;
	GgitIndexEntry* _tmp10_ = NULL;
	GgitIndex* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = _data34_->self;
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (index != NULL);
#line 768 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = self->priv->d_repository;
#line 768 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = _data34_->path;
#line 768 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = _data34_->commit;
#line 768 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = ggit_object_get_id ((GgitObject*) _tmp2_);
#line 768 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = _tmp3_;
#line 768 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp5_ = ggit_repository_create_index_entry_for_path ((GgitRepository*) _tmp0_, _tmp1_, _tmp4_, &_inner_error_);
#line 768 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp6_ = _tmp5_;
#line 768 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (_tmp4_);
#line 768 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	entry = _tmp6_;
#line 768 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 768 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 768 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 9383 "gitg-stage.c"
	}
#line 769 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp7_ = entry;
#line 769 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp8_ = _data34_->commit;
#line 769 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	ggit_index_entry_set_commit (_tmp7_, _tmp8_);
#line 771 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp9_ = index;
#line 771 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp10_ = entry;
#line 771 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	ggit_index_add (_tmp9_, _tmp10_, &_inner_error_);
#line 771 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 771 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 771 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 771 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 9405 "gitg-stage.c"
	}
#line 772 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp11_ = index;
#line 772 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	ggit_index_write (_tmp11_, &_inner_error_);
#line 772 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 772 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 772 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 772 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 9419 "gitg-stage.c"
	}
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_ggit_index_entry_unref0 (entry);
#line 9423 "gitg-stage.c"
}


static void ___lambda25__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error) {
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__lambda25_ (self, index, error);
#line 9430 "gitg-stage.c"
}


static void gitg_stage_stage_commit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageStageCommitData* _data_;
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_stage_commit_co (_data_);
#line 9444 "gitg-stage.c"
}


static gboolean gitg_stage_stage_commit_co (GitgStageStageCommitData* _data_) {
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 9453 "gitg-stage.c"
		goto _state_0;
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 9457 "gitg-stage.c"
		goto _state_1;
		default:
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 9462 "gitg-stage.c"
	}
	_state_0:
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data34_ = g_slice_new0 (Block34Data);
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data34_->_ref_count_ = 1;
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data34_->self = g_object_ref (_data_->self);
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->path;
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_data_->_data34_->path);
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data34_->path = _data_->_tmp0_;
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = NULL;
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = _data_->commit;
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_data34_->commit);
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data34_->commit = _data_->_tmp1_;
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data34_->_async_data_ = _data_;
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index (_data_->self, ___lambda25__gitg_stage_with_index_func, _data_->_data34_, gitg_stage_stage_commit_ready, _data_);
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 9495 "gitg-stage.c"
	_state_1:
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block34_data_unref (_data_->_data34_);
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data34_ = NULL;
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 9513 "gitg-stage.c"
		} else {
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 9517 "gitg-stage.c"
		}
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 767 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 9523 "gitg-stage.c"
	}
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block34_data_unref (_data_->_data34_);
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data34_ = NULL;
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 9533 "gitg-stage.c"
	} else {
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 9537 "gitg-stage.c"
	}
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 765 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 9543 "gitg-stage.c"
}


static void gitg_stage_copy_stream (GitgStage* self, GOutputStream* dest, GInputStream* src, gsize* pos, gsize index, gsize length, GError** error) {
	gsize _tmp0_ = 0UL;
	guint8* buf = NULL;
	gsize _tmp1_ = 0UL;
	guint8* _tmp2_ = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	gsize _tmp3_ = 0UL;
	gsize _tmp4_ = 0UL;
	GInputStream* _tmp8_ = NULL;
	guint8* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	GOutputStream* _tmp10_ = NULL;
	guint8* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gsize _tmp12_ = 0UL;
	gsize _tmp13_ = 0UL;
	GError * _inner_error_ = NULL;
#line 776 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (self != NULL);
#line 776 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (dest != NULL);
#line 776 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (src != NULL);
#line 778 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = length;
#line 778 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_tmp0_ == ((gsize) 0)) {
#line 780 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 9577 "gitg-stage.c"
	}
#line 783 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = length;
#line 783 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = g_new0 (guint8, _tmp1_);
#line 783 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	buf = _tmp2_;
#line 783 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	buf_length1 = _tmp1_;
#line 783 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_buf_size_ = buf_length1;
#line 785 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = *pos;
#line 785 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = index;
#line 785 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_tmp3_ != _tmp4_) {
#line 9595 "gitg-stage.c"
		GInputStream* _tmp5_ = NULL;
		gsize _tmp6_ = 0UL;
		gsize _tmp7_ = 0UL;
#line 787 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp5_ = src;
#line 787 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp6_ = index;
#line 787 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_seekable_seek (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_seekable_get_type (), GSeekable), (gint64) _tmp6_, G_SEEK_SET, NULL, &_inner_error_);
#line 787 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 787 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_propagate_error (error, _inner_error_);
#line 787 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			buf = (g_free (buf), NULL);
#line 787 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return;
#line 9613 "gitg-stage.c"
		}
#line 788 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp7_ = index;
#line 788 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		*pos = _tmp7_;
#line 9619 "gitg-stage.c"
	}
#line 791 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp8_ = src;
#line 791 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp9_ = buf;
#line 791 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp9__length1 = buf_length1;
#line 791 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_input_stream_read_all (_tmp8_, _tmp9_, (gsize) _tmp9__length1, NULL, NULL, &_inner_error_);
#line 791 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 791 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 791 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		buf = (g_free (buf), NULL);
#line 791 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 9637 "gitg-stage.c"
	}
#line 792 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp10_ = dest;
#line 792 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp11_ = buf;
#line 792 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp11__length1 = buf_length1;
#line 792 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_output_stream_write_all (_tmp10_, _tmp11_, (gsize) _tmp11__length1, NULL, NULL, &_inner_error_);
#line 792 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 792 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 792 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		buf = (g_free (buf), NULL);
#line 792 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 9655 "gitg-stage.c"
	}
#line 794 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp12_ = *pos;
#line 794 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp13_ = length;
#line 794 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	*pos = _tmp12_ + _tmp13_;
#line 776 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	buf = (g_free (buf), NULL);
#line 9665 "gitg-stage.c"
}


static void gitg_stage_apply_patch (GitgStage* self, GgitIndex* index, GInputStream* old_stream, GInputStream* new_stream, GitgPatchSet* patch, GError** error) {
	GgitBlobOutputStream* patched_stream = NULL;
	GitgRepository* _tmp0_ = NULL;
	GgitBlobOutputStream* _tmp1_ = NULL;
	GInputStream* _tmp2_ = NULL;
	GInputStream* _tmp3_ = NULL;
	GgitBlobOutputStream* _tmp4_ = NULL;
	GitgPatchSet* _tmp5_ = NULL;
	GgitBlobOutputStream* _tmp6_ = NULL;
	GgitOId* new_id = NULL;
	GgitBlobOutputStream* _tmp7_ = NULL;
	GgitOId* _tmp8_ = NULL;
	GgitIndexEntry* new_entry = NULL;
	GitgRepository* _tmp9_ = NULL;
	GitgPatchSet* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GgitOId* _tmp12_ = NULL;
	GgitIndexEntry* _tmp13_ = NULL;
	GgitIndex* _tmp14_ = NULL;
	GgitIndexEntry* _tmp15_ = NULL;
	GgitIndex* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
#line 797 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (self != NULL);
#line 797 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (index != NULL);
#line 797 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (old_stream != NULL);
#line 797 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (new_stream != NULL);
#line 797 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (patch != NULL);
#line 802 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = self->priv->d_repository;
#line 802 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = ggit_repository_create_blob ((GgitRepository*) _tmp0_);
#line 802 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	patched_stream = _tmp1_;
#line 804 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = old_stream;
#line 804 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = new_stream;
#line 804 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = patched_stream;
#line 804 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp5_ = patch;
#line 804 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_apply_patch_stream (self, _tmp2_, _tmp3_, (GOutputStream*) _tmp4_, _tmp5_, &_inner_error_);
#line 804 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 804 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 804 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (patched_stream);
#line 804 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 9725 "gitg-stage.c"
	}
#line 806 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp6_ = patched_stream;
#line 806 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_output_stream_close ((GOutputStream*) _tmp6_, NULL, &_inner_error_);
#line 806 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 806 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 806 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (patched_stream);
#line 806 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 9739 "gitg-stage.c"
	}
#line 807 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp7_ = patched_stream;
#line 807 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp8_ = ggit_blob_output_stream_get_id (_tmp7_, &_inner_error_);
#line 807 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	new_id = _tmp8_;
#line 807 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 807 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 807 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (patched_stream);
#line 807 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 9755 "gitg-stage.c"
	}
#line 809 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp9_ = self->priv->d_repository;
#line 809 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp10_ = patch;
#line 809 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp11_ = _tmp10_->filename;
#line 809 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp12_ = new_id;
#line 809 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp13_ = ggit_repository_create_index_entry_for_path ((GgitRepository*) _tmp9_, _tmp11_, _tmp12_, &_inner_error_);
#line 809 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	new_entry = _tmp13_;
#line 809 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 809 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 809 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (new_id);
#line 809 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (patched_stream);
#line 809 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 9779 "gitg-stage.c"
	}
#line 812 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp14_ = index;
#line 812 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp15_ = new_entry;
#line 812 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	ggit_index_add (_tmp14_, _tmp15_, &_inner_error_);
#line 812 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 812 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 812 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (new_entry);
#line 812 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (new_id);
#line 812 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (patched_stream);
#line 812 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 9799 "gitg-stage.c"
	}
#line 813 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp16_ = index;
#line 813 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	ggit_index_write (_tmp16_, &_inner_error_);
#line 813 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 813 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 813 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (new_entry);
#line 813 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (new_id);
#line 813 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (patched_stream);
#line 813 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 9817 "gitg-stage.c"
	}
#line 797 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_ggit_index_entry_unref0 (new_entry);
#line 797 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (new_id);
#line 797 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (patched_stream);
#line 9825 "gitg-stage.c"
}


static void gitg_stage_apply_patch_stream (GitgStage* self, GInputStream* old_stream, GInputStream* new_stream, GOutputStream* patched_stream, GitgPatchSet* patch, GError** error) {
	gsize old_ptr = 0UL;
	gsize new_ptr = 0UL;
	GitgPatchSet* _tmp0_ = NULL;
	GitgPatchSetPatch* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GOutputStream* _tmp22_ = NULL;
	GInputStream* _tmp23_ = NULL;
	GError * _inner_error_ = NULL;
#line 816 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (self != NULL);
#line 816 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (old_stream != NULL);
#line 816 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (new_stream != NULL);
#line 816 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (patched_stream != NULL);
#line 816 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (patch != NULL);
#line 821 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	old_ptr = (gsize) 0;
#line 822 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	new_ptr = (gsize) 0;
#line 826 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = patch;
#line 826 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = _tmp0_->patches;
#line 826 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1__length1 = _tmp0_->patches_length1;
#line 9858 "gitg-stage.c"
	{
		GitgPatchSetPatch* p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
#line 826 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		p_collection = _tmp1_;
#line 826 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		p_collection_length1 = _tmp1__length1;
#line 826 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		for (p_it = 0; p_it < _tmp1__length1; p_it = p_it + 1) {
#line 9870 "gitg-stage.c"
			GitgPatchSetPatch p = {0};
#line 826 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			p = p_collection[p_it];
#line 9874 "gitg-stage.c"
			{
				GOutputStream* _tmp2_ = NULL;
				GInputStream* _tmp3_ = NULL;
				gsize _tmp4_ = 0UL;
				GitgPatchSetPatch _tmp5_ = {0};
				gsize _tmp6_ = 0UL;
				gsize _tmp7_ = 0UL;
				GitgPatchSetPatch _tmp8_ = {0};
				GitgPatchSetType _tmp9_ = 0;
#line 829 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp2_ = patched_stream;
#line 829 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp3_ = old_stream;
#line 829 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp4_ = old_ptr;
#line 829 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp5_ = p;
#line 829 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp6_ = _tmp5_.old_offset;
#line 829 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp7_ = old_ptr;
#line 829 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				gitg_stage_copy_stream (self, _tmp2_, _tmp3_, &old_ptr, _tmp4_, _tmp6_ - _tmp7_, &_inner_error_);
#line 829 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 829 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					g_propagate_error (error, _inner_error_);
#line 829 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					return;
#line 9904 "gitg-stage.c"
				}
#line 835 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp8_ = p;
#line 835 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_tmp9_ = _tmp8_.type;
#line 835 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				if (_tmp9_ == GITG_PATCH_SET_TYPE_REMOVE) {
#line 9912 "gitg-stage.c"
					GInputStream* _tmp10_ = NULL;
					GitgPatchSetPatch _tmp11_ = {0};
					gsize _tmp12_ = 0UL;
					gsize _tmp13_ = 0UL;
					GitgPatchSetPatch _tmp14_ = {0};
					gsize _tmp15_ = 0UL;
#line 838 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_tmp10_ = old_stream;
#line 838 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_tmp11_ = p;
#line 838 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_tmp12_ = _tmp11_.length;
#line 838 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					g_seekable_seek (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_seekable_get_type (), GSeekable), (gint64) _tmp12_, G_SEEK_CUR, NULL, &_inner_error_);
#line 838 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 838 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
						g_propagate_error (error, _inner_error_);
#line 838 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
						return;
#line 9933 "gitg-stage.c"
					}
#line 839 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_tmp13_ = old_ptr;
#line 839 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_tmp14_ = p;
#line 839 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_tmp15_ = _tmp14_.length;
#line 839 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					old_ptr = _tmp13_ + _tmp15_;
#line 9943 "gitg-stage.c"
				} else {
					GOutputStream* _tmp16_ = NULL;
					GInputStream* _tmp17_ = NULL;
					GitgPatchSetPatch _tmp18_ = {0};
					gsize _tmp19_ = 0UL;
					GitgPatchSetPatch _tmp20_ = {0};
					gsize _tmp21_ = 0UL;
#line 844 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_tmp16_ = patched_stream;
#line 844 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_tmp17_ = new_stream;
#line 844 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_tmp18_ = p;
#line 844 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_tmp19_ = _tmp18_.new_offset;
#line 844 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_tmp20_ = p;
#line 844 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_tmp21_ = _tmp20_.length;
#line 844 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					gitg_stage_copy_stream (self, _tmp16_, _tmp17_, &new_ptr, _tmp19_, _tmp21_, &_inner_error_);
#line 844 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 844 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
						g_propagate_error (error, _inner_error_);
#line 844 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
						return;
#line 9971 "gitg-stage.c"
					}
				}
			}
		}
	}
#line 853 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp22_ = patched_stream;
#line 853 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp23_ = old_stream;
#line 853 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_output_stream_splice (_tmp22_, _tmp23_, G_OUTPUT_STREAM_SPLICE_NONE, NULL, &_inner_error_);
#line 853 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 853 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 853 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 9989 "gitg-stage.c"
	}
}


static void gitg_stage_stage_patch_data_free (gpointer _data) {
	GitgStageStagePatchData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageStagePatchData, _data_);
#line 10001 "gitg-stage.c"
}


void gitg_stage_stage_patch (GitgStage* self, GitgPatchSet* patch, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageStagePatchData* _data_;
	GitgStage* _tmp0_ = NULL;
	GitgPatchSet* _tmp1_ = NULL;
	GitgPatchSet* _tmp2_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageStagePatchData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_stage_patch);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_stage_patch_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = patch;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = _gitg_patch_set_ref0 (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_gitg_patch_set_unref0 (_data_->patch);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->patch = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_stage_patch_co (_data_);
#line 10030 "gitg-stage.c"
}


void gitg_stage_stage_patch_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GitgStageStagePatchData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 10040 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 10044 "gitg-stage.c"
}


/**
 * Stage a patch to the index.
 *
 * @param patch the patch to stage.
 *
 * Stage a provided patch to the index. The patch should contain changes
 * of the file in the current working directory to the contents of the
 * index (i.e. as obtained from diff_workdir)
 */
static Block35Data* block35_data_ref (Block35Data* _data35_) {
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_atomic_int_inc (&_data35_->_ref_count_);
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return _data35_;
#line 10062 "gitg-stage.c"
}


static void block35_data_unref (void * _userdata_) {
	Block35Data* _data35_;
	_data35_ = (Block35Data*) _userdata_;
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
#line 10071 "gitg-stage.c"
		GitgStage* self;
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self = _data35_->self;
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data35_->new_stream);
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data35_->newf);
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_gitg_patch_set_unref0 (_data35_->patch);
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self);
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_slice_free (Block35Data, _data35_);
#line 10085 "gitg-stage.c"
	}
}


static void gitg_stage_stage_patch_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageStagePatchData* _data_;
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_stage_patch_co (_data_);
#line 10100 "gitg-stage.c"
}


static void __lambda26_ (Block35Data* _data35_, GgitIndex* index, GError** error) {
	GitgStage* self;
	GgitIndexEntries* entries = NULL;
	GgitIndex* _tmp0_ = NULL;
	GgitIndexEntries* _tmp1_ = NULL;
	GgitIndexEntry* entry = NULL;
	GgitIndexEntries* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GgitIndexEntry* _tmp4_ = NULL;
	GgitIndexEntry* _tmp5_ = NULL;
	GgitBlob* old_blob = NULL;
	GitgRepository* _tmp9_ = NULL;
	GgitIndexEntry* _tmp10_ = NULL;
	GgitOId* _tmp11_ = NULL;
	GgitOId* _tmp12_ = NULL;
	gpointer _tmp13_ = NULL;
	GgitBlob* _tmp14_ = NULL;
	guchar* old_content = NULL;
	GgitBlob* _tmp15_ = NULL;
	gsize _tmp16_;
	guint8* _tmp17_ = NULL;
	gint old_content_length1 = 0;
	gint _old_content_size_ = 0;
	GMemoryInputStream* old_stream = NULL;
	guchar* _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	GBytes* _tmp19_ = NULL;
	GBytes* _tmp20_ = NULL;
	GMemoryInputStream* _tmp21_ = NULL;
	GMemoryInputStream* _tmp22_ = NULL;
	GgitIndex* _tmp23_ = NULL;
	GMemoryInputStream* _tmp24_ = NULL;
	GFileInputStream* _tmp25_ = NULL;
	GitgPatchSet* _tmp26_ = NULL;
	GFileInputStream* _tmp27_ = NULL;
	GMemoryInputStream* _tmp28_ = NULL;
	GError * _inner_error_ = NULL;
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = _data35_->self;
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (index != NULL);
#line 872 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = index;
#line 872 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = ggit_index_get_entries (_tmp0_);
#line 872 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	entries = _tmp1_;
#line 873 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = entries;
#line 873 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = _data35_->newf;
#line 873 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = ggit_index_entries_get_by_path (_tmp2_, _tmp3_, 0);
#line 873 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	entry = _tmp4_;
#line 875 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp5_ = entry;
#line 875 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_tmp5_ == NULL) {
#line 10163 "gitg-stage.c"
		GitgPatchSet* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
#line 877 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp6_ = _data35_->patch;
#line 877 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp7_ = _tmp6_->filename;
#line 877 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp8_ = g_error_new_literal (GITG_STAGE_ERROR, GITG_STAGE_ERROR_INDEX_ENTRY_NOT_FOUND, _tmp7_);
#line 877 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = _tmp8_;
#line 877 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 877 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 877 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 877 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 10183 "gitg-stage.c"
	}
#line 880 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp9_ = self->priv->d_repository;
#line 880 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp10_ = entry;
#line 880 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp11_ = ggit_index_entry_get_id (_tmp10_);
#line 880 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp12_ = _tmp11_;
#line 880 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp13_ = gitg_repository_lookup (_tmp9_, ggit_blob_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp12_, &_inner_error_);
#line 880 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp14_ = (GgitBlob*) _tmp13_;
#line 880 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (_tmp12_);
#line 880 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	old_blob = _tmp14_;
#line 880 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 880 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 880 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 880 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 880 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 10211 "gitg-stage.c"
	}
#line 881 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp15_ = old_blob;
#line 881 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp17_ = ggit_blob_get_raw_content (_tmp15_, &_tmp16_);
#line 881 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	old_content = _tmp17_;
#line 881 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	old_content_length1 = _tmp16_;
#line 881 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_old_content_size_ = old_content_length1;
#line 883 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp18_ = old_content;
#line 883 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp18__length1 = old_content_length1;
#line 883 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp19_ = g_bytes_new (_tmp18_, _tmp18__length1);
#line 883 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp20_ = _tmp19_;
#line 883 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp21_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp20_);
#line 883 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp22_ = _tmp21_;
#line 883 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_bytes_unref0 (_tmp20_);
#line 883 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	old_stream = _tmp22_;
#line 885 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp23_ = index;
#line 885 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp24_ = old_stream;
#line 885 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp25_ = _data35_->new_stream;
#line 885 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp26_ = _data35_->patch;
#line 885 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_apply_patch (self, _tmp23_, (GInputStream*) _tmp24_, (GInputStream*) _tmp25_, _tmp26_, &_inner_error_);
#line 885 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 885 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 885 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (old_stream);
#line 885 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (old_blob);
#line 885 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 885 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 885 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 10263 "gitg-stage.c"
	}
#line 887 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp27_ = _data35_->new_stream;
#line 887 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_input_stream_close ((GInputStream*) _tmp27_, NULL, &_inner_error_);
#line 887 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 887 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 887 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (old_stream);
#line 887 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (old_blob);
#line 887 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 887 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 887 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 10283 "gitg-stage.c"
	}
#line 888 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp28_ = old_stream;
#line 888 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_input_stream_close ((GInputStream*) _tmp28_, NULL, &_inner_error_);
#line 888 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 888 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 888 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (old_stream);
#line 888 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (old_blob);
#line 888 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 888 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 888 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 10303 "gitg-stage.c"
	}
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (old_stream);
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (old_blob);
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_ggit_index_entry_unref0 (entry);
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_ggit_index_entries_unref0 (entries);
#line 10313 "gitg-stage.c"
}


static void ___lambda26__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error) {
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__lambda26_ (self, index, error);
#line 10320 "gitg-stage.c"
}


static gboolean gitg_stage_stage_patch_co (GitgStageStagePatchData* _data_) {
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 10329 "gitg-stage.c"
		goto _state_0;
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 10333 "gitg-stage.c"
		goto _state_1;
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 2:
#line 10337 "gitg-stage.c"
		goto _state_2;
		default:
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 10342 "gitg-stage.c"
	}
	_state_0:
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data35_ = g_slice_new0 (Block35Data);
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data35_->_ref_count_ = 1;
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data35_->self = g_object_ref (_data_->self);
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->patch;
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_gitg_patch_set_unref0 (_data_->_data35_->patch);
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data35_->patch = _data_->_tmp0_;
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data35_->_async_data_ = _data_;
#line 868 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = NULL;
#line 868 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = _data_->self->priv->d_repository;
#line 868 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = NULL;
#line 868 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = ggit_repository_get_workdir ((GgitRepository*) _data_->_tmp1_);
#line 868 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = NULL;
#line 868 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 868 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = NULL;
#line 868 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = _data_->_data35_->patch;
#line 868 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = NULL;
#line 868 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = _data_->_tmp4_->filename;
#line 868 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp6_ = NULL;
#line 868 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp6_ = g_file_resolve_relative_path (_data_->_tmp3_, _data_->_tmp5_);
#line 868 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7_ = NULL;
#line 868 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7_ = _data_->_tmp6_;
#line 868 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp3_);
#line 868 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data35_->newf = _data_->_tmp7_;
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp8_ = NULL;
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp8_ = _data_->_data35_->newf;
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_file_read_async (_data_->_tmp8_, G_PRIORITY_DEFAULT, NULL, gitg_stage_stage_patch_ready, _data_);
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 10403 "gitg-stage.c"
	_state_1:
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp9_ = NULL;
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp9_ = g_file_read_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error_);
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data35_->new_stream = _data_->_tmp9_;
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block35_data_unref (_data_->_data35_);
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data35_ = NULL;
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 10425 "gitg-stage.c"
		} else {
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 10429 "gitg-stage.c"
		}
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 869 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 10435 "gitg-stage.c"
	}
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 2;
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index (_data_->self, ___lambda26__gitg_stage_with_index_func, _data_->_data35_, gitg_stage_stage_patch_ready, _data_);
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 10443 "gitg-stage.c"
	_state_2:
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block35_data_unref (_data_->_data35_);
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data35_ = NULL;
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 10461 "gitg-stage.c"
		} else {
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 10465 "gitg-stage.c"
		}
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 871 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 10471 "gitg-stage.c"
	}
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block35_data_unref (_data_->_data35_);
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data35_ = NULL;
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 10481 "gitg-stage.c"
	} else {
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 10485 "gitg-stage.c"
	}
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 865 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 10491 "gitg-stage.c"
}


static void gitg_stage_unstage_data_free (gpointer _data) {
	GitgStageUnstageData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageUnstageData, _data_);
#line 10502 "gitg-stage.c"
}


void gitg_stage_unstage (GitgStage* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageUnstageData* _data_;
	GitgStage* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageUnstageData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_unstage);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_unstage_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = file;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->file);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->file = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_unstage_co (_data_);
#line 10531 "gitg-stage.c"
}


void gitg_stage_unstage_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GitgStageUnstageData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 10541 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 10545 "gitg-stage.c"
}


/**
 * Unstage a file from the index.
 *
 * @param file the file to unstage.
 *
 * Unstage changes in the specified file from the index. This will record
 * the state of the file in HEAD to the index.
 */
static Block36Data* block36_data_ref (Block36Data* _data36_) {
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_atomic_int_inc (&_data36_->_ref_count_);
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return _data36_;
#line 10562 "gitg-stage.c"
}


static void block36_data_unref (void * _userdata_) {
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
#line 10571 "gitg-stage.c"
		GitgStage* self;
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self = _data36_->self;
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data36_->tree);
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data36_->file);
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self);
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_slice_free (Block36Data, _data36_);
#line 10583 "gitg-stage.c"
	}
}


static void gitg_stage_unstage_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageUnstageData* _data_;
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_unstage_co (_data_);
#line 10598 "gitg-stage.c"
}


static void __lambda27_ (Block36Data* _data36_, GgitIndex* index, GError** error) {
	GitgStage* self;
	GFile* wd = NULL;
	GitgRepository* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* path = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GgitTreeEntry* entry = NULL;
	GgitTree* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GgitTreeEntry* _tmp7_ = NULL;
	GgitOId* id = NULL;
	GgitTreeEntry* _tmp8_ = NULL;
	GgitOId* _tmp9_ = NULL;
	GgitIndexEntry* ientry = NULL;
	GitgRepository* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GgitOId* _tmp12_ = NULL;
	GgitIndexEntry* _tmp13_ = NULL;
	GgitIndexEntry* _tmp14_ = NULL;
	GgitTreeEntry* _tmp15_ = NULL;
	GgitFileMode _tmp16_ = 0;
	GgitIndex* _tmp17_ = NULL;
	GgitIndexEntry* _tmp18_ = NULL;
	GgitIndex* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = _data36_->self;
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (index != NULL);
#line 906 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = self->priv->d_repository;
#line 906 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _tmp0_);
#line 906 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	wd = _tmp1_;
#line 907 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = wd;
#line 907 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = _data36_->file;
#line 907 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = g_file_get_relative_path (_tmp2_, _tmp3_);
#line 907 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	path = _tmp4_;
#line 910 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp5_ = _data36_->tree;
#line 910 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp6_ = path;
#line 910 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp7_ = ggit_tree_get_by_path (_tmp5_, _tmp6_, &_inner_error_);
#line 910 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	entry = _tmp7_;
#line 910 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 910 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 910 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (path);
#line 910 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (wd);
#line 910 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 10666 "gitg-stage.c"
	}
#line 911 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp8_ = entry;
#line 911 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp9_ = ggit_tree_entry_get_id (_tmp8_);
#line 911 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	id = _tmp9_;
#line 915 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp10_ = self->priv->d_repository;
#line 915 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp11_ = path;
#line 915 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp12_ = id;
#line 915 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp13_ = ggit_repository_create_index_entry_for_path ((GgitRepository*) _tmp10_, _tmp11_, _tmp12_, &_inner_error_);
#line 915 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	ientry = _tmp13_;
#line 915 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 915 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 915 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (id);
#line 915 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_tree_entry_unref0 (entry);
#line 915 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (path);
#line 915 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (wd);
#line 915 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 10698 "gitg-stage.c"
	}
#line 918 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp14_ = ientry;
#line 918 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp15_ = entry;
#line 918 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp16_ = ggit_tree_entry_get_file_mode (_tmp15_);
#line 918 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	ggit_index_entry_set_mode (_tmp14_, (guint) _tmp16_);
#line 920 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp17_ = index;
#line 920 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp18_ = ientry;
#line 920 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	ggit_index_add (_tmp17_, _tmp18_, &_inner_error_);
#line 920 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 920 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 920 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (ientry);
#line 920 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (id);
#line 920 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_tree_entry_unref0 (entry);
#line 920 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (path);
#line 920 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (wd);
#line 920 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 10730 "gitg-stage.c"
	}
#line 921 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp19_ = index;
#line 921 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	ggit_index_write (_tmp19_, &_inner_error_);
#line 921 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 921 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 921 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (ientry);
#line 921 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		__vala_GgitOId_free0 (id);
#line 921 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_tree_entry_unref0 (entry);
#line 921 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_free0 (path);
#line 921 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (wd);
#line 921 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 10752 "gitg-stage.c"
	}
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_ggit_index_entry_unref0 (ientry);
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (id);
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_ggit_tree_entry_unref0 (entry);
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (path);
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (wd);
#line 10764 "gitg-stage.c"
}


static void ___lambda27__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error) {
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__lambda27_ (self, index, error);
#line 10771 "gitg-stage.c"
}


static gboolean gitg_stage_unstage_co (GitgStageUnstageData* _data_) {
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 10780 "gitg-stage.c"
		goto _state_0;
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 10784 "gitg-stage.c"
		goto _state_1;
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 2:
#line 10788 "gitg-stage.c"
		goto _state_2;
		default:
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 10793 "gitg-stage.c"
	}
	_state_0:
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data36_ = g_slice_new0 (Block36Data);
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data36_->_ref_count_ = 1;
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data36_->self = g_object_ref (_data_->self);
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->file;
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_data36_->file);
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data36_->file = _data_->_tmp0_;
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data36_->_async_data_ = _data_;
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_get_head_tree (_data_->self, gitg_stage_unstage_ready, _data_);
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 10818 "gitg-stage.c"
	_state_1:
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = NULL;
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = gitg_stage_get_head_tree_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data36_->tree = _data_->_tmp1_;
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block36_data_unref (_data_->_data36_);
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data36_ = NULL;
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 10840 "gitg-stage.c"
		} else {
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 10844 "gitg-stage.c"
		}
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 902 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 10850 "gitg-stage.c"
	}
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 2;
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index (_data_->self, ___lambda27__gitg_stage_with_index_func, _data_->_data36_, gitg_stage_unstage_ready, _data_);
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 10858 "gitg-stage.c"
	_state_2:
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block36_data_unref (_data_->_data36_);
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data36_ = NULL;
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 10876 "gitg-stage.c"
		} else {
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 10880 "gitg-stage.c"
		}
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 904 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 10886 "gitg-stage.c"
	}
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block36_data_unref (_data_->_data36_);
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data36_ = NULL;
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 10896 "gitg-stage.c"
	} else {
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 10900 "gitg-stage.c"
	}
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 900 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 10906 "gitg-stage.c"
}


static void gitg_stage_unstage_path_data_free (gpointer _data) {
	GitgStageUnstagePathData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_data_->path);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageUnstagePathData, _data_);
#line 10919 "gitg-stage.c"
}


void gitg_stage_unstage_path (GitgStage* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageUnstagePathData* _data_;
	GitgStage* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageUnstagePathData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_unstage_path);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_unstage_path_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = path;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_free0 (_data_->path);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->path = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_unstage_path_co (_data_);
#line 10948 "gitg-stage.c"
}


void gitg_stage_unstage_path_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GitgStageUnstagePathData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 10958 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 10962 "gitg-stage.c"
}


/**
 * Unstage a path from the index.
 *
 * @param path path relative to the working directory.
 *
 * Unstage changes in the specified relative path from the index. This will record
 * the state of the file in HEAD to the index.
 */
static void gitg_stage_unstage_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageUnstagePathData* _data_;
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_unstage_path_co (_data_);
#line 10984 "gitg-stage.c"
}


static gboolean gitg_stage_unstage_path_co (GitgStageUnstagePathData* _data_) {
#line 933 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 933 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 10993 "gitg-stage.c"
		goto _state_0;
#line 933 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 10997 "gitg-stage.c"
		goto _state_1;
		default:
#line 933 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 11002 "gitg-stage.c"
	}
	_state_0:
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->self->priv->d_repository;
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = NULL;
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _data_->_tmp0_);
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = NULL;
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = NULL;
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = _data_->path;
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = NULL;
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = g_file_resolve_relative_path (_data_->_tmp2_, _data_->_tmp3_);
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = NULL;
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_unstage (_data_->self, _data_->_tmp5_, gitg_stage_unstage_path_ready, _data_);
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 11035 "gitg-stage.c"
	_state_1:
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_unstage_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp5_);
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp2_);
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 11053 "gitg-stage.c"
		} else {
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 11057 "gitg-stage.c"
		}
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 935 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 11063 "gitg-stage.c"
	}
#line 933 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 933 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 11069 "gitg-stage.c"
	} else {
#line 933 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 11073 "gitg-stage.c"
	}
#line 933 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 933 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 11079 "gitg-stage.c"
}


static void gitg_stage_unstage_patch_data_free (gpointer _data) {
	GitgStageUnstagePatchData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageUnstagePatchData, _data_);
#line 11090 "gitg-stage.c"
}


void gitg_stage_unstage_patch (GitgStage* self, GitgPatchSet* patch, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageUnstagePatchData* _data_;
	GitgStage* _tmp0_ = NULL;
	GitgPatchSet* _tmp1_ = NULL;
	GitgPatchSet* _tmp2_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageUnstagePatchData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_unstage_patch);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_unstage_patch_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = patch;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = _gitg_patch_set_ref0 (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_gitg_patch_set_unref0 (_data_->patch);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->patch = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_unstage_patch_co (_data_);
#line 11119 "gitg-stage.c"
}


void gitg_stage_unstage_patch_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GitgStageUnstagePatchData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 11129 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 11133 "gitg-stage.c"
}


/**
 * Unstage a patch from the index.
 *
 * @param patch the patch to unstage.
 *
 * Unstage a provided patch from the index. The patch should contain changes
 * of the file in the index to the file in HEAD.
 */
static Block37Data* block37_data_ref (Block37Data* _data37_) {
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_atomic_int_inc (&_data37_->_ref_count_);
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return _data37_;
#line 11150 "gitg-stage.c"
}


static void block37_data_unref (void * _userdata_) {
	Block37Data* _data37_;
	_data37_ = (Block37Data*) _userdata_;
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
#line 11159 "gitg-stage.c"
		GitgStage* self;
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		self = _data37_->self;
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data37_->tree);
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data37_->file);
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_gitg_patch_set_unref0 (_data37_->patch);
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (self);
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_slice_free (Block37Data, _data37_);
#line 11173 "gitg-stage.c"
	}
}


static void gitg_stage_unstage_patch_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageUnstagePatchData* _data_;
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_unstage_patch_co (_data_);
#line 11188 "gitg-stage.c"
}


static void __lambda28_ (Block37Data* _data37_, GgitIndex* index, GError** error) {
	GitgStage* self;
	GgitIndexEntries* entries = NULL;
	GgitIndex* _tmp0_ = NULL;
	GgitIndexEntries* _tmp1_ = NULL;
	GgitIndexEntry* entry = NULL;
	GgitIndexEntries* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GgitIndexEntry* _tmp4_ = NULL;
	GgitIndexEntry* _tmp5_ = NULL;
	GgitTreeEntry* head_entry = NULL;
	GgitTree* _tmp9_ = NULL;
	GitgPatchSet* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GgitTreeEntry* _tmp12_ = NULL;
	GgitBlob* head_blob = NULL;
	GitgRepository* _tmp13_ = NULL;
	GgitTreeEntry* _tmp14_ = NULL;
	GgitOId* _tmp15_ = NULL;
	GgitOId* _tmp16_ = NULL;
	gpointer _tmp17_ = NULL;
	GgitBlob* _tmp18_ = NULL;
	GgitBlob* index_blob = NULL;
	GitgRepository* _tmp19_ = NULL;
	GgitIndexEntry* _tmp20_ = NULL;
	GgitOId* _tmp21_ = NULL;
	GgitOId* _tmp22_ = NULL;
	gpointer _tmp23_ = NULL;
	GgitBlob* _tmp24_ = NULL;
	guchar* head_content = NULL;
	GgitBlob* _tmp25_ = NULL;
	gsize _tmp26_;
	guint8* _tmp27_ = NULL;
	gint head_content_length1 = 0;
	gint _head_content_size_ = 0;
	guchar* index_content = NULL;
	GgitBlob* _tmp28_ = NULL;
	gsize _tmp29_;
	guint8* _tmp30_ = NULL;
	gint index_content_length1 = 0;
	gint _index_content_size_ = 0;
	GMemoryInputStream* head_stream = NULL;
	guchar* _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	GBytes* _tmp32_ = NULL;
	GBytes* _tmp33_ = NULL;
	GMemoryInputStream* _tmp34_ = NULL;
	GMemoryInputStream* _tmp35_ = NULL;
	GMemoryInputStream* index_stream = NULL;
	guchar* _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	GBytes* _tmp37_ = NULL;
	GBytes* _tmp38_ = NULL;
	GMemoryInputStream* _tmp39_ = NULL;
	GMemoryInputStream* _tmp40_ = NULL;
	GitgPatchSet* reversed = NULL;
	GitgPatchSet* _tmp41_ = NULL;
	GitgPatchSet* _tmp42_ = NULL;
	GgitIndex* _tmp43_ = NULL;
	GMemoryInputStream* _tmp44_ = NULL;
	GMemoryInputStream* _tmp45_ = NULL;
	GitgPatchSet* _tmp46_ = NULL;
	GMemoryInputStream* _tmp47_ = NULL;
	GMemoryInputStream* _tmp48_ = NULL;
	GError * _inner_error_ = NULL;
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = _data37_->self;
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_return_if_fail (index != NULL);
#line 952 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = index;
#line 952 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = ggit_index_get_entries (_tmp0_);
#line 952 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	entries = _tmp1_;
#line 953 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = entries;
#line 953 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = _data37_->file;
#line 953 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = ggit_index_entries_get_by_path (_tmp2_, _tmp3_, 0);
#line 953 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	entry = _tmp4_;
#line 955 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp5_ = entry;
#line 955 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_tmp5_ == NULL) {
#line 11279 "gitg-stage.c"
		GitgPatchSet* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
#line 957 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp6_ = _data37_->patch;
#line 957 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp7_ = _tmp6_->filename;
#line 957 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_tmp8_ = g_error_new_literal (GITG_STAGE_ERROR, GITG_STAGE_ERROR_INDEX_ENTRY_NOT_FOUND, _tmp7_);
#line 957 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_inner_error_ = _tmp8_;
#line 957 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 957 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 957 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 957 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 11299 "gitg-stage.c"
	}
#line 960 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp9_ = _data37_->tree;
#line 960 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp10_ = _data37_->patch;
#line 960 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp11_ = _tmp10_->filename;
#line 960 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp12_ = ggit_tree_get_by_path (_tmp9_, _tmp11_, &_inner_error_);
#line 960 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	head_entry = _tmp12_;
#line 960 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 960 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 960 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 960 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 960 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 11321 "gitg-stage.c"
	}
#line 961 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp13_ = self->priv->d_repository;
#line 961 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp14_ = head_entry;
#line 961 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp15_ = ggit_tree_entry_get_id (_tmp14_);
#line 961 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp16_ = _tmp15_;
#line 961 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp17_ = gitg_repository_lookup (_tmp13_, ggit_blob_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp16_, &_inner_error_);
#line 961 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp18_ = (GgitBlob*) _tmp17_;
#line 961 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (_tmp16_);
#line 961 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	head_blob = _tmp18_;
#line 961 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 961 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 961 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_tree_entry_unref0 (head_entry);
#line 961 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 961 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 961 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 11351 "gitg-stage.c"
	}
#line 962 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp19_ = self->priv->d_repository;
#line 962 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp20_ = entry;
#line 962 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp21_ = ggit_index_entry_get_id (_tmp20_);
#line 962 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp22_ = _tmp21_;
#line 962 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp23_ = gitg_repository_lookup (_tmp19_, ggit_blob_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp22_, &_inner_error_);
#line 962 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp24_ = (GgitBlob*) _tmp23_;
#line 962 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__vala_GgitOId_free0 (_tmp22_);
#line 962 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	index_blob = _tmp24_;
#line 962 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 962 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 962 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (head_blob);
#line 962 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_tree_entry_unref0 (head_entry);
#line 962 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 962 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 962 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 11383 "gitg-stage.c"
	}
#line 964 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp25_ = head_blob;
#line 964 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp27_ = ggit_blob_get_raw_content (_tmp25_, &_tmp26_);
#line 964 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	head_content = _tmp27_;
#line 964 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	head_content_length1 = _tmp26_;
#line 964 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_head_content_size_ = head_content_length1;
#line 965 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp28_ = index_blob;
#line 965 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp30_ = ggit_blob_get_raw_content (_tmp28_, &_tmp29_);
#line 965 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	index_content = _tmp30_;
#line 965 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	index_content_length1 = _tmp29_;
#line 965 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_index_content_size_ = index_content_length1;
#line 967 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp31_ = head_content;
#line 967 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp31__length1 = head_content_length1;
#line 967 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp32_ = g_bytes_new (_tmp31_, _tmp31__length1);
#line 967 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp33_ = _tmp32_;
#line 967 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp34_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp33_);
#line 967 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp35_ = _tmp34_;
#line 967 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_bytes_unref0 (_tmp33_);
#line 967 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	head_stream = _tmp35_;
#line 968 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp36_ = index_content;
#line 968 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp36__length1 = index_content_length1;
#line 968 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp37_ = g_bytes_new (_tmp36_, _tmp36__length1);
#line 968 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp38_ = _tmp37_;
#line 968 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp39_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp38_);
#line 968 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp40_ = _tmp39_;
#line 968 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_bytes_unref0 (_tmp38_);
#line 968 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	index_stream = _tmp40_;
#line 970 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp41_ = _data37_->patch;
#line 970 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp42_ = gitg_patch_set_reversed (_tmp41_);
#line 970 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	reversed = _tmp42_;
#line 972 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp43_ = index;
#line 972 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp44_ = index_stream;
#line 972 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp45_ = head_stream;
#line 972 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp46_ = reversed;
#line 972 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_apply_patch (self, _tmp43_, (GInputStream*) _tmp44_, (GInputStream*) _tmp45_, _tmp46_, &_inner_error_);
#line 972 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 972 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 972 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_gitg_patch_set_unref0 (reversed);
#line 972 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (index_stream);
#line 972 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (head_stream);
#line 972 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (index_blob);
#line 972 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (head_blob);
#line 972 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_tree_entry_unref0 (head_entry);
#line 972 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 972 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 972 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 11475 "gitg-stage.c"
	}
#line 974 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp47_ = head_stream;
#line 974 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_input_stream_close ((GInputStream*) _tmp47_, NULL, &_inner_error_);
#line 974 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 974 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 974 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_gitg_patch_set_unref0 (reversed);
#line 974 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (index_stream);
#line 974 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (head_stream);
#line 974 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (index_blob);
#line 974 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (head_blob);
#line 974 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_tree_entry_unref0 (head_entry);
#line 974 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 974 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 974 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 11503 "gitg-stage.c"
	}
#line 975 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp48_ = index_stream;
#line 975 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_input_stream_close ((GInputStream*) _tmp48_, NULL, &_inner_error_);
#line 975 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 975 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_propagate_error (error, _inner_error_);
#line 975 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_gitg_patch_set_unref0 (reversed);
#line 975 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (index_stream);
#line 975 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (head_stream);
#line 975 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (index_blob);
#line 975 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (head_blob);
#line 975 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_tree_entry_unref0 (head_entry);
#line 975 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entry_unref0 (entry);
#line 975 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_ggit_index_entries_unref0 (entries);
#line 975 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return;
#line 11531 "gitg-stage.c"
	}
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_gitg_patch_set_unref0 (reversed);
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (index_stream);
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (head_stream);
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (index_blob);
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (head_blob);
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_ggit_tree_entry_unref0 (head_entry);
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_ggit_index_entry_unref0 (entry);
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_ggit_index_entries_unref0 (entries);
#line 11549 "gitg-stage.c"
}


static void ___lambda28__gitg_stage_with_index_func (GgitIndex* index, gpointer self, GError** error) {
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	__lambda28_ (self, index, error);
#line 11556 "gitg-stage.c"
}


static gboolean gitg_stage_unstage_patch_co (GitgStageUnstagePatchData* _data_) {
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 11565 "gitg-stage.c"
		goto _state_0;
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 11569 "gitg-stage.c"
		goto _state_1;
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 2:
#line 11573 "gitg-stage.c"
		goto _state_2;
		default:
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 11578 "gitg-stage.c"
	}
	_state_0:
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data37_ = g_slice_new0 (Block37Data);
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data37_->_ref_count_ = 1;
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data37_->self = g_object_ref (_data_->self);
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->patch;
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_gitg_patch_set_unref0 (_data_->_data37_->patch);
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data37_->patch = _data_->_tmp0_;
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data37_->_async_data_ = _data_;
#line 948 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = NULL;
#line 948 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = _data_->self->priv->d_repository;
#line 948 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = NULL;
#line 948 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = ggit_repository_get_workdir ((GgitRepository*) _data_->_tmp1_);
#line 948 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = NULL;
#line 948 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 948 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = NULL;
#line 948 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = _data_->_data37_->patch;
#line 948 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = NULL;
#line 948 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = _data_->_tmp4_->filename;
#line 948 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp6_ = NULL;
#line 948 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp6_ = g_file_resolve_relative_path (_data_->_tmp3_, _data_->_tmp5_);
#line 948 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7_ = NULL;
#line 948 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7_ = _data_->_tmp6_;
#line 948 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp3_);
#line 948 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data37_->file = _data_->_tmp7_;
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_get_head_tree (_data_->self, gitg_stage_unstage_patch_ready, _data_);
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 11635 "gitg-stage.c"
	_state_1:
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp8_ = NULL;
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp8_ = gitg_stage_get_head_tree_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data37_->tree = _data_->_tmp8_;
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block37_data_unref (_data_->_data37_);
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data37_ = NULL;
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 11657 "gitg-stage.c"
		} else {
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 11661 "gitg-stage.c"
		}
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 949 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 11667 "gitg-stage.c"
	}
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 2;
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index (_data_->self, ___lambda28__gitg_stage_with_index_func, _data_->_data37_, gitg_stage_unstage_patch_ready, _data_);
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 11675 "gitg-stage.c"
	_state_2:
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		block37_data_unref (_data_->_data37_);
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_data37_ = NULL;
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 11693 "gitg-stage.c"
		} else {
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 11697 "gitg-stage.c"
		}
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 951 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 11703 "gitg-stage.c"
	}
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	block37_data_unref (_data_->_data37_);
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_data37_ = NULL;
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 11713 "gitg-stage.c"
	} else {
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 11717 "gitg-stage.c"
	}
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 946 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 11723 "gitg-stage.c"
}


static void gitg_stage_diff_index_all_data_free (gpointer _data) {
	GitgStageDiffIndexAllData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->defopts);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->result);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageDiffIndexAllData, _data_);
#line 11738 "gitg-stage.c"
}


void gitg_stage_diff_index_all (GitgStage* self, GitgStageStatusItem** files, int files_length1, GgitDiffOptions* defopts, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageDiffIndexAllData* _data_;
	GitgStage* _tmp0_ = NULL;
	GitgStageStatusItem** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GgitDiffOptions* _tmp2_ = NULL;
	GgitDiffOptions* _tmp3_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageDiffIndexAllData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_diff_index_all);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_diff_index_all_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = files;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1__length1 = files_length1;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->files = _tmp1_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->files_length1 = _tmp1__length1;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = defopts;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->defopts);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->defopts = _tmp3_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_diff_index_all_co (_data_);
#line 11777 "gitg-stage.c"
}


GgitDiff* gitg_stage_diff_index_all_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GgitDiff* result;
	GitgStageDiffIndexAllData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return NULL;
#line 11788 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	result = _data_->result;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->result = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return result;
#line 11798 "gitg-stage.c"
}


static void gitg_stage_diff_index_all_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageDiffIndexAllData* _data_;
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_diff_index_all_co (_data_);
#line 11812 "gitg-stage.c"
}


static gboolean gitg_stage_diff_index_all_co (GitgStageDiffIndexAllData* _data_) {
#line 979 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 979 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 11821 "gitg-stage.c"
		goto _state_0;
#line 979 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 11825 "gitg-stage.c"
		goto _state_1;
		default:
#line 979 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 11830 "gitg-stage.c"
	}
	_state_0:
#line 982 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 982 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = ggit_diff_options_new ();
#line 982 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->opts = _data_->_tmp0_;
#line 984 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = NULL;
#line 984 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = _data_->opts;
#line 984 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	ggit_diff_options_set_flags (_data_->_tmp1_, (GGIT_DIFF_INCLUDE_UNTRACKED | GGIT_DIFF_DISABLE_PATHSPEC_MATCH) | GGIT_DIFF_RECURSE_UNTRACKED_DIRS);
#line 989 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = NULL;
#line 989 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2__length1 = 0;
#line 989 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = _data_->files;
#line 989 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2__length1 = _data_->files_length1;
#line 989 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_tmp2_ != NULL) {
#line 991 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp3_ = NULL;
#line 991 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp3__length1 = 0;
#line 991 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp3_ = _data_->files;
#line 991 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp3__length1 = _data_->files_length1;
#line 991 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp4_ = NULL;
#line 991 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp4_ = g_new0 (gchar*, _data_->_tmp3__length1 + 1);
#line 991 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->pspec_length1 = 0;
#line 991 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_pspec_size_ = 0;
#line 991 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->pspec = _data_->_tmp4_;
#line 991 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->pspec_length1 = _data_->_tmp3__length1;
#line 991 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_pspec_size_ = _data_->pspec_length1;
#line 11877 "gitg-stage.c"
		{
#line 993 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->i = 0;
#line 11881 "gitg-stage.c"
			{
#line 993 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_data_->_tmp5_ = TRUE;
#line 993 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				while (TRUE) {
#line 993 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					if (!_data_->_tmp5_) {
#line 993 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
						_data_->_tmp6_ = 0;
#line 993 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
						_data_->_tmp6_ = _data_->i;
#line 993 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
						_data_->i = _data_->_tmp6_ + 1;
#line 11895 "gitg-stage.c"
					}
#line 993 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp5_ = FALSE;
#line 993 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp7_ = 0;
#line 993 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp7_ = _data_->i;
#line 993 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp8_ = NULL;
#line 993 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp8__length1 = 0;
#line 993 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp8_ = _data_->files;
#line 993 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp8__length1 = _data_->files_length1;
#line 993 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					if (!(_data_->_tmp7_ < _data_->_tmp8__length1)) {
#line 993 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
						break;
#line 11915 "gitg-stage.c"
					}
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp9_ = NULL;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp9__length1 = 0;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp9_ = _data_->pspec;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp9__length1 = _data_->pspec_length1;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp10_ = 0;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp10_ = _data_->i;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp11_ = NULL;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp11__length1 = 0;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp11_ = _data_->files;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp11__length1 = _data_->files_length1;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp12_ = 0;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp12_ = _data_->i;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp13_ = NULL;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp13_ = _data_->_tmp11_[_data_->_tmp12_];
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp14_ = NULL;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp14_ = gitg_stage_status_item_get_path (_data_->_tmp13_);
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp15_ = NULL;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp15_ = _data_->_tmp14_;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_g_free0 (_data_->_tmp9_[_data_->_tmp10_]);
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp9_[_data_->_tmp10_] = _data_->_tmp15_;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp16_ = NULL;
#line 995 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp16_ = _data_->_tmp9_[_data_->_tmp10_];
#line 11961 "gitg-stage.c"
				}
			}
		}
#line 998 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp17_ = NULL;
#line 998 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp17_ = _data_->opts;
#line 998 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp18_ = NULL;
#line 998 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp18__length1 = 0;
#line 998 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp18_ = _data_->pspec;
#line 998 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp18__length1 = _data_->pspec_length1;
#line 998 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		ggit_diff_options_set_pathspec (_data_->_tmp17_, _data_->_tmp18_);
#line 989 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->pspec = (_vala_array_free (_data_->pspec, _data_->pspec_length1, (GDestroyNotify) g_free), NULL);
#line 11981 "gitg-stage.c"
	}
#line 1001 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp19_ = NULL;
#line 1001 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp19_ = _data_->defopts;
#line 1001 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_tmp19_ != NULL) {
#line 1003 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp20_ = NULL;
#line 1003 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp20_ = _data_->opts;
#line 1003 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp21_ = NULL;
#line 1003 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp21_ = _data_->opts;
#line 1003 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp22_ = 0;
#line 1003 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp22_ = ggit_diff_options_get_flags (_data_->_tmp21_);
#line 1003 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp23_ = 0;
#line 1003 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp23_ = _data_->_tmp22_;
#line 1003 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp24_ = NULL;
#line 1003 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp24_ = _data_->defopts;
#line 1003 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp25_ = 0;
#line 1003 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp25_ = ggit_diff_options_get_flags (_data_->_tmp24_);
#line 1003 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp26_ = 0;
#line 1003 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp26_ = _data_->_tmp25_;
#line 1003 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		ggit_diff_options_set_flags (_data_->_tmp21_, _data_->_tmp23_ | _data_->_tmp26_);
#line 1005 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp27_ = NULL;
#line 1005 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp27_ = _data_->opts;
#line 1005 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp28_ = NULL;
#line 1005 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp28_ = _data_->defopts;
#line 1005 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp29_ = 0;
#line 1005 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp29_ = ggit_diff_options_get_n_context_lines (_data_->_tmp28_);
#line 1005 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp30_ = 0;
#line 1005 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp30_ = _data_->_tmp29_;
#line 1005 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		ggit_diff_options_set_n_context_lines (_data_->_tmp27_, _data_->_tmp30_);
#line 1006 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp31_ = NULL;
#line 1006 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp31_ = _data_->opts;
#line 1006 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp32_ = NULL;
#line 1006 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp32_ = _data_->defopts;
#line 1006 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp33_ = 0;
#line 1006 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp33_ = ggit_diff_options_get_n_interhunk_lines (_data_->_tmp32_);
#line 1006 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp34_ = 0;
#line 1006 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp34_ = _data_->_tmp33_;
#line 1006 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		ggit_diff_options_set_n_interhunk_lines (_data_->_tmp31_, _data_->_tmp34_);
#line 1008 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp35_ = NULL;
#line 1008 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp35_ = _data_->opts;
#line 1008 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp36_ = NULL;
#line 1008 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp36_ = _data_->defopts;
#line 1008 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp37_ = NULL;
#line 1008 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp37_ = ggit_diff_options_get_old_prefix (_data_->_tmp36_);
#line 1008 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp38_ = NULL;
#line 1008 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp38_ = _data_->_tmp37_;
#line 1008 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		ggit_diff_options_set_old_prefix (_data_->_tmp35_, _data_->_tmp38_);
#line 1009 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp39_ = NULL;
#line 1009 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp39_ = _data_->opts;
#line 1009 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp40_ = NULL;
#line 1009 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp40_ = _data_->defopts;
#line 1009 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp41_ = NULL;
#line 1009 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp41_ = ggit_diff_options_get_new_prefix (_data_->_tmp40_);
#line 1009 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp42_ = NULL;
#line 1009 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp42_ = _data_->_tmp41_;
#line 1009 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		ggit_diff_options_set_new_prefix (_data_->_tmp39_, _data_->_tmp42_);
#line 12091 "gitg-stage.c"
	}
#line 1012 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->tree = NULL;
#line 1014 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp44_ = NULL;
#line 1014 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp44_ = _data_->self->priv->d_repository;
#line 1014 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp45_ = FALSE;
#line 1014 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp45_ = ggit_repository_is_empty ((GgitRepository*) _data_->_tmp44_, &_data_->_inner_error_);
#line 1014 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp43_ = _data_->_tmp45_;
#line 1014 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1014 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 1014 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 1014 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data_->tree);
#line 1014 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data_->opts);
#line 1014 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 1014 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 12119 "gitg-stage.c"
		} else {
#line 1014 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 12123 "gitg-stage.c"
		}
#line 1014 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 1014 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 12129 "gitg-stage.c"
	}
#line 1014 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (!_data_->_tmp43_) {
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_state_ = 1;
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		gitg_stage_get_head_tree (_data_->self, gitg_stage_diff_index_all_ready, _data_);
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 12139 "gitg-stage.c"
		_state_1:
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp47_ = NULL;
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp47_ = gitg_stage_get_head_tree_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp46_ = _data_->_tmp47_;
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_error_free (_data_->_inner_error_);
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (_data_->tree);
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_g_object_unref0 (_data_->opts);
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			if (_data_->_state_ == 0) {
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 12161 "gitg-stage.c"
			} else {
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 12165 "gitg-stage.c"
			}
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_object_unref (_data_->_async_result);
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			return FALSE;
#line 12171 "gitg-stage.c"
		}
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp48_ = NULL;
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp48_ = _data_->_tmp46_;
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp46_ = NULL;
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data_->tree);
#line 1016 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->tree = _data_->_tmp48_;
#line 1014 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data_->_tmp46_);
#line 12185 "gitg-stage.c"
	}
#line 1021 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp50_ = NULL;
#line 1021 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp50_ = _data_->self->priv->d_repository;
#line 1021 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp51_ = NULL;
#line 1021 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp51_ = ggit_repository_get_index ((GgitRepository*) _data_->_tmp50_, &_data_->_inner_error_);
#line 1021 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp49_ = _data_->_tmp51_;
#line 1021 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1021 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 1021 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 1021 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data_->tree);
#line 1021 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data_->opts);
#line 1021 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 1021 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 12211 "gitg-stage.c"
		} else {
#line 1021 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 12215 "gitg-stage.c"
		}
#line 1021 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 1021 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 12221 "gitg-stage.c"
	}
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp53_ = NULL;
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp53_ = _data_->self->priv->d_repository;
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp54_ = NULL;
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp54_ = _data_->tree;
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp55_ = NULL;
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp55_ = _data_->opts;
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp56_ = NULL;
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp56_ = ggit_diff_new_tree_to_index ((GgitRepository*) _data_->_tmp53_, _data_->_tmp54_, _data_->_tmp49_, _data_->_tmp55_, &_data_->_inner_error_);
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp52_ = _data_->_tmp56_;
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data_->_tmp49_);
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data_->tree);
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data_->opts);
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 12257 "gitg-stage.c"
		} else {
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 12261 "gitg-stage.c"
		}
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 12267 "gitg-stage.c"
	}
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp57_ = NULL;
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp57_ = _data_->_tmp52_;
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp52_ = NULL;
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->result = _data_->_tmp57_;
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp52_);
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp49_);
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->tree);
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->opts);
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 12289 "gitg-stage.c"
	} else {
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 12293 "gitg-stage.c"
	}
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 1019 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 979 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp52_);
#line 979 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp49_);
#line 979 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->tree);
#line 979 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->opts);
#line 979 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 979 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 12311 "gitg-stage.c"
	} else {
#line 979 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 12315 "gitg-stage.c"
	}
#line 979 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 979 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 12321 "gitg-stage.c"
}


static void gitg_stage_diff_index_data_free (gpointer _data) {
	GitgStageDiffIndexData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->f);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->defopts);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->result);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageDiffIndexData, _data_);
#line 12338 "gitg-stage.c"
}


void gitg_stage_diff_index (GitgStage* self, GitgStageStatusItem* f, GgitDiffOptions* defopts, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageDiffIndexData* _data_;
	GitgStage* _tmp0_ = NULL;
	GitgStageStatusItem* _tmp1_ = NULL;
	GitgStageStatusItem* _tmp2_ = NULL;
	GgitDiffOptions* _tmp3_ = NULL;
	GgitDiffOptions* _tmp4_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageDiffIndexData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_diff_index);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_diff_index_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = f;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->f);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->f = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = defopts;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->defopts);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->defopts = _tmp4_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_diff_index_co (_data_);
#line 12377 "gitg-stage.c"
}


GgitDiff* gitg_stage_diff_index_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GgitDiff* result;
	GitgStageDiffIndexData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return NULL;
#line 12388 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	result = _data_->result;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->result = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return result;
#line 12398 "gitg-stage.c"
}


static void gitg_stage_diff_index_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageDiffIndexData* _data_;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_diff_index_co (_data_);
#line 12412 "gitg-stage.c"
}


static gboolean gitg_stage_diff_index_co (GitgStageDiffIndexData* _data_) {
#line 1025 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 1025 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 12421 "gitg-stage.c"
		goto _state_0;
#line 1025 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 12425 "gitg-stage.c"
		goto _state_1;
		default:
#line 1025 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 12430 "gitg-stage.c"
	}
	_state_0:
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = NULL;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = _data_->f;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = NULL;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = NULL;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = g_new0 (GitgStageStatusItem*, 1 + 1);
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_[0] = _data_->_tmp2_;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = NULL;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4__length1 = 0;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4__length1 = 1;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = NULL;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = _data_->defopts;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_diff_index_all (_data_->self, _data_->_tmp4_, 1, _data_->_tmp5_, gitg_stage_diff_index_ready, _data_);
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 12465 "gitg-stage.c"
	_state_1:
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp6_ = NULL;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp6_ = gitg_stage_diff_index_all_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7_ = NULL;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7_ = _data_->_tmp6_;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = (_vala_array_free (_data_->_tmp4_, _data_->_tmp4__length1, (GDestroyNotify) g_object_unref), NULL);
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->_tmp7_;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 12489 "gitg-stage.c"
		} else {
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 12493 "gitg-stage.c"
		}
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 12499 "gitg-stage.c"
	}
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp8_ = NULL;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp8_ = _data_->_tmp0_;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->result = _data_->_tmp8_;
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp0_);
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 12515 "gitg-stage.c"
	} else {
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 12519 "gitg-stage.c"
	}
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 1028 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 1025 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp0_);
#line 1025 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 1025 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 12531 "gitg-stage.c"
	} else {
#line 1025 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 12535 "gitg-stage.c"
	}
#line 1025 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 1025 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 12541 "gitg-stage.c"
}


static void gitg_stage_diff_workdir_all_data_free (gpointer _data) {
	GitgStageDiffWorkdirAllData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->defopts);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->result);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageDiffWorkdirAllData, _data_);
#line 12556 "gitg-stage.c"
}


void gitg_stage_diff_workdir_all (GitgStage* self, GitgStageStatusItem** files, int files_length1, GgitDiffOptions* defopts, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageDiffWorkdirAllData* _data_;
	GitgStage* _tmp0_ = NULL;
	GitgStageStatusItem** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GgitDiffOptions* _tmp2_ = NULL;
	GgitDiffOptions* _tmp3_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageDiffWorkdirAllData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_diff_workdir_all);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_diff_workdir_all_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = files;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1__length1 = files_length1;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->files = _tmp1_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->files_length1 = _tmp1__length1;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = defopts;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->defopts);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->defopts = _tmp3_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_diff_workdir_all_co (_data_);
#line 12595 "gitg-stage.c"
}


GgitDiff* gitg_stage_diff_workdir_all_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GgitDiff* result;
	GitgStageDiffWorkdirAllData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return NULL;
#line 12606 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	result = _data_->result;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->result = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return result;
#line 12616 "gitg-stage.c"
}


static gboolean gitg_stage_diff_workdir_all_co (GitgStageDiffWorkdirAllData* _data_) {
#line 1031 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 1031 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 12625 "gitg-stage.c"
		goto _state_0;
		default:
#line 1031 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 12630 "gitg-stage.c"
	}
	_state_0:
#line 1034 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 1034 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = ggit_diff_options_new ();
#line 1034 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->opts = _data_->_tmp0_;
#line 1036 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = NULL;
#line 1036 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = _data_->opts;
#line 1036 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	ggit_diff_options_set_flags (_data_->_tmp1_, ((GGIT_DIFF_INCLUDE_UNTRACKED | GGIT_DIFF_DISABLE_PATHSPEC_MATCH) | GGIT_DIFF_RECURSE_UNTRACKED_DIRS) | GGIT_DIFF_SHOW_UNTRACKED_CONTENT);
#line 1041 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = NULL;
#line 1041 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2__length1 = 0;
#line 1041 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = _data_->files;
#line 1041 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2__length1 = _data_->files_length1;
#line 1041 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_tmp2_ != NULL) {
#line 1043 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp3_ = NULL;
#line 1043 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp3__length1 = 0;
#line 1043 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp3_ = _data_->files;
#line 1043 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp3__length1 = _data_->files_length1;
#line 1043 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp4_ = NULL;
#line 1043 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp4_ = g_new0 (gchar*, _data_->_tmp3__length1 + 1);
#line 1043 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->pspec_length1 = 0;
#line 1043 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_pspec_size_ = 0;
#line 1043 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->pspec = _data_->_tmp4_;
#line 1043 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->pspec_length1 = _data_->_tmp3__length1;
#line 1043 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_pspec_size_ = _data_->pspec_length1;
#line 12677 "gitg-stage.c"
		{
#line 1045 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			_data_->i = 0;
#line 12681 "gitg-stage.c"
			{
#line 1045 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				_data_->_tmp5_ = TRUE;
#line 1045 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
				while (TRUE) {
#line 1045 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					if (!_data_->_tmp5_) {
#line 1045 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
						_data_->_tmp6_ = 0;
#line 1045 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
						_data_->_tmp6_ = _data_->i;
#line 1045 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
						_data_->i = _data_->_tmp6_ + 1;
#line 12695 "gitg-stage.c"
					}
#line 1045 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp5_ = FALSE;
#line 1045 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp7_ = 0;
#line 1045 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp7_ = _data_->i;
#line 1045 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp8_ = NULL;
#line 1045 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp8__length1 = 0;
#line 1045 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp8_ = _data_->files;
#line 1045 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp8__length1 = _data_->files_length1;
#line 1045 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					if (!(_data_->_tmp7_ < _data_->_tmp8__length1)) {
#line 1045 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
						break;
#line 12715 "gitg-stage.c"
					}
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp9_ = NULL;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp9__length1 = 0;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp9_ = _data_->pspec;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp9__length1 = _data_->pspec_length1;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp10_ = 0;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp10_ = _data_->i;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp11_ = NULL;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp11__length1 = 0;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp11_ = _data_->files;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp11__length1 = _data_->files_length1;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp12_ = 0;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp12_ = _data_->i;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp13_ = NULL;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp13_ = _data_->_tmp11_[_data_->_tmp12_];
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp14_ = NULL;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp14_ = gitg_stage_status_item_get_path (_data_->_tmp13_);
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp15_ = NULL;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp15_ = _data_->_tmp14_;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_g_free0 (_data_->_tmp9_[_data_->_tmp10_]);
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp9_[_data_->_tmp10_] = _data_->_tmp15_;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp16_ = NULL;
#line 1047 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
					_data_->_tmp16_ = _data_->_tmp9_[_data_->_tmp10_];
#line 12761 "gitg-stage.c"
				}
			}
		}
#line 1050 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp17_ = NULL;
#line 1050 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp17_ = _data_->opts;
#line 1050 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp18_ = NULL;
#line 1050 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp18__length1 = 0;
#line 1050 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp18_ = _data_->pspec;
#line 1050 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp18__length1 = _data_->pspec_length1;
#line 1050 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		ggit_diff_options_set_pathspec (_data_->_tmp17_, _data_->_tmp18_);
#line 1041 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->pspec = (_vala_array_free (_data_->pspec, _data_->pspec_length1, (GDestroyNotify) g_free), NULL);
#line 12781 "gitg-stage.c"
	}
#line 1053 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp19_ = NULL;
#line 1053 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp19_ = _data_->defopts;
#line 1053 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_tmp19_ != NULL) {
#line 1055 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp20_ = NULL;
#line 1055 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp20_ = _data_->opts;
#line 1055 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp21_ = NULL;
#line 1055 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp21_ = _data_->opts;
#line 1055 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp22_ = 0;
#line 1055 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp22_ = ggit_diff_options_get_flags (_data_->_tmp21_);
#line 1055 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp23_ = 0;
#line 1055 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp23_ = _data_->_tmp22_;
#line 1055 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp24_ = NULL;
#line 1055 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp24_ = _data_->defopts;
#line 1055 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp25_ = 0;
#line 1055 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp25_ = ggit_diff_options_get_flags (_data_->_tmp24_);
#line 1055 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp26_ = 0;
#line 1055 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp26_ = _data_->_tmp25_;
#line 1055 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		ggit_diff_options_set_flags (_data_->_tmp21_, _data_->_tmp23_ | _data_->_tmp26_);
#line 1057 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp27_ = NULL;
#line 1057 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp27_ = _data_->opts;
#line 1057 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp28_ = NULL;
#line 1057 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp28_ = _data_->defopts;
#line 1057 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp29_ = 0;
#line 1057 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp29_ = ggit_diff_options_get_n_context_lines (_data_->_tmp28_);
#line 1057 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp30_ = 0;
#line 1057 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp30_ = _data_->_tmp29_;
#line 1057 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		ggit_diff_options_set_n_context_lines (_data_->_tmp27_, _data_->_tmp30_);
#line 1058 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp31_ = NULL;
#line 1058 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp31_ = _data_->opts;
#line 1058 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp32_ = NULL;
#line 1058 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp32_ = _data_->defopts;
#line 1058 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp33_ = 0;
#line 1058 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp33_ = ggit_diff_options_get_n_interhunk_lines (_data_->_tmp32_);
#line 1058 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp34_ = 0;
#line 1058 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp34_ = _data_->_tmp33_;
#line 1058 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		ggit_diff_options_set_n_interhunk_lines (_data_->_tmp31_, _data_->_tmp34_);
#line 1060 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp35_ = NULL;
#line 1060 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp35_ = _data_->opts;
#line 1060 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp36_ = NULL;
#line 1060 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp36_ = _data_->defopts;
#line 1060 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp37_ = NULL;
#line 1060 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp37_ = ggit_diff_options_get_old_prefix (_data_->_tmp36_);
#line 1060 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp38_ = NULL;
#line 1060 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp38_ = _data_->_tmp37_;
#line 1060 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		ggit_diff_options_set_old_prefix (_data_->_tmp35_, _data_->_tmp38_);
#line 1061 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp39_ = NULL;
#line 1061 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp39_ = _data_->opts;
#line 1061 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp40_ = NULL;
#line 1061 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp40_ = _data_->defopts;
#line 1061 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp41_ = NULL;
#line 1061 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp41_ = ggit_diff_options_get_new_prefix (_data_->_tmp40_);
#line 1061 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp42_ = NULL;
#line 1061 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_data_->_tmp42_ = _data_->_tmp41_;
#line 1061 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		ggit_diff_options_set_new_prefix (_data_->_tmp39_, _data_->_tmp42_);
#line 12891 "gitg-stage.c"
	}
#line 1065 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp44_ = NULL;
#line 1065 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp44_ = _data_->self->priv->d_repository;
#line 1065 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp45_ = NULL;
#line 1065 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp45_ = ggit_repository_get_index ((GgitRepository*) _data_->_tmp44_, &_data_->_inner_error_);
#line 1065 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp43_ = _data_->_tmp45_;
#line 1065 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1065 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 1065 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 1065 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data_->opts);
#line 1065 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 1065 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 12915 "gitg-stage.c"
		} else {
#line 1065 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 12919 "gitg-stage.c"
		}
#line 1065 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 1065 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 12925 "gitg-stage.c"
	}
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp47_ = NULL;
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp47_ = _data_->self->priv->d_repository;
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp48_ = NULL;
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp48_ = _data_->opts;
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp49_ = NULL;
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp49_ = ggit_diff_new_index_to_workdir ((GgitRepository*) _data_->_tmp47_, _data_->_tmp43_, _data_->_tmp48_, &_data_->_inner_error_);
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp46_ = _data_->_tmp49_;
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data_->_tmp43_);
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		_g_object_unref0 (_data_->opts);
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 12955 "gitg-stage.c"
		} else {
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 12959 "gitg-stage.c"
		}
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 12965 "gitg-stage.c"
	}
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp50_ = NULL;
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp50_ = _data_->_tmp46_;
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp46_ = NULL;
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->result = _data_->_tmp50_;
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp46_);
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp43_);
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->opts);
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 12985 "gitg-stage.c"
	} else {
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 12989 "gitg-stage.c"
	}
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 1064 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 1031 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp46_);
#line 1031 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp43_);
#line 1031 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->opts);
#line 1031 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 1031 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 13005 "gitg-stage.c"
	} else {
#line 1031 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 13009 "gitg-stage.c"
	}
#line 1031 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 1031 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 13015 "gitg-stage.c"
}


static void gitg_stage_diff_workdir_data_free (gpointer _data) {
	GitgStageDiffWorkdirData* _data_;
	_data_ = _data;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->f);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->defopts);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->result);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_slice_free (GitgStageDiffWorkdirData, _data_);
#line 13032 "gitg-stage.c"
}


void gitg_stage_diff_workdir (GitgStage* self, GitgStageStatusItem* f, GgitDiffOptions* defopts, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgStageDiffWorkdirData* _data_;
	GitgStage* _tmp0_ = NULL;
	GitgStageStatusItem* _tmp1_ = NULL;
	GitgStageStatusItem* _tmp2_ = NULL;
	GgitDiffOptions* _tmp3_ = NULL;
	GgitDiffOptions* _tmp4_ = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_slice_new0 (GitgStageDiffWorkdirData);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_stage_diff_workdir);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_stage_diff_workdir_data_free);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->self = _tmp0_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp1_ = f;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->f);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->f = _tmp2_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp3_ = defopts;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->defopts);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->defopts = _tmp4_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_diff_workdir_co (_data_);
#line 13071 "gitg-stage.c"
}


GgitDiff* gitg_stage_diff_workdir_finish (GitgStage* self, GAsyncResult* _res_, GError** error) {
	GgitDiff* result;
	GitgStageDiffWorkdirData* _data_;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return NULL;
#line 13082 "gitg-stage.c"
	}
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	result = _data_->result;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->result = NULL;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return result;
#line 13092 "gitg-stage.c"
}


static void gitg_stage_diff_workdir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgStageDiffWorkdirData* _data_;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_ = _user_data_;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_source_object_ = source_object;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_res_ = _res_;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_diff_workdir_co (_data_);
#line 13106 "gitg-stage.c"
}


static gboolean gitg_stage_diff_workdir_co (GitgStageDiffWorkdirData* _data_) {
#line 1069 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	switch (_data_->_state_) {
#line 1069 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 0:
#line 13115 "gitg-stage.c"
		goto _state_0;
#line 1069 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		case 1:
#line 13119 "gitg-stage.c"
		goto _state_1;
		default:
#line 1069 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_assert_not_reached ();
#line 13124 "gitg-stage.c"
	}
	_state_0:
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = NULL;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp1_ = _data_->f;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = NULL;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = NULL;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_ = g_new0 (GitgStageStatusItem*, 1 + 1);
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp3_[0] = _data_->_tmp2_;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = NULL;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4__length1 = 0;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4__length1 = 1;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = NULL;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp5_ = _data_->defopts;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_state_ = 1;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_diff_workdir_all (_data_->self, _data_->_tmp4_, 1, _data_->_tmp5_, gitg_stage_diff_workdir_ready, _data_);
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 13159 "gitg-stage.c"
	_state_1:
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp6_ = NULL;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp6_ = gitg_stage_diff_workdir_all_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7_ = NULL;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp7_ = _data_->_tmp6_;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp4_ = (_vala_array_free (_data_->_tmp4_, _data_->_tmp4__length1, (GDestroyNotify) g_object_unref), NULL);
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = _data_->_tmp7_;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_error_free (_data_->_inner_error_);
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		if (_data_->_state_ == 0) {
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 13183 "gitg-stage.c"
		} else {
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 13187 "gitg-stage.c"
		}
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_object_unref (_data_->_async_result);
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		return FALSE;
#line 13193 "gitg-stage.c"
	}
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp8_ = NULL;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp8_ = _data_->_tmp0_;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->_tmp0_ = NULL;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_data_->result = _data_->_tmp8_;
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp0_);
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 13209 "gitg-stage.c"
	} else {
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 13213 "gitg-stage.c"
	}
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 1072 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 1069 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (_data_->_tmp0_);
#line 1069 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	if (_data_->_state_ == 0) {
#line 1069 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 13225 "gitg-stage.c"
	} else {
#line 1069 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 13229 "gitg-stage.c"
	}
#line 1069 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_object_unref (_data_->_async_result);
#line 1069 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	return FALSE;
#line 13235 "gitg-stage.c"
}


static void gitg_stage_class_init (GitgStageClass * klass) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	gitg_stage_parent_class = g_type_class_peek_parent (klass);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_type_class_add_private (klass, sizeof (GitgStagePrivate));
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_stage_finalize;
#line 13246 "gitg-stage.c"
}


static void gitg_stage_instance_init (GitgStage * self) {
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self->priv = GITG_STAGE_GET_PRIVATE (self);
#line 96 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_rec_mutex_init (&self->priv->__lock_d_index_mutex);
#line 13255 "gitg-stage.c"
}


static void gitg_stage_finalize (GObject* obj) {
	GitgStage * self;
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_STAGE, GitgStage);
#line 96 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	g_rec_mutex_clear (&self->priv->__lock_d_index_mutex);
#line 96 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_vala_clear_GMutex (&self->priv->d_index_mutex);
#line 97 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	_g_object_unref0 (self->priv->d_head_tree);
#line 93 "/home/jesse/dev/gitg/libgitg/gitg-stage.vala"
	G_OBJECT_CLASS (gitg_stage_parent_class)->finalize (obj);
#line 13271 "gitg-stage.c"
}


GType gitg_stage_get_type (void) {
	static volatile gsize gitg_stage_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_stage_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgStageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_stage_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgStage), 0, (GInstanceInitFunc) gitg_stage_instance_init, NULL };
		GType gitg_stage_type_id;
		gitg_stage_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgStage", &g_define_type_info, 0);
		g_once_init_leave (&gitg_stage_type_id__volatile, gitg_stage_type_id);
	}
	return gitg_stage_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_clear_GMutex (GMutex * mutex) {
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}


static void _vala_clear_GRecMutex (GRecMutex * mutex) {
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}


static void _vala_clear_GRWLock (GRWLock * mutex) {
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}


static void _vala_clear_GCond (GCond * mutex) {
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}



