/* test-cherry-pick-commit.c generated by valac 0.35.5.2-9e6c0, the Vala compiler
 * generated from test-cherry-pick-commit.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "libgitg/libgitg.h"
#include "libgitg-ext/libgitg-ext.h"
#include <stdlib.h>
#include <string.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <gitg-assert.h>
#include <gee.h>
#include <gtk/gtk.h>


#define GITG_TEST_TYPE_TEST (gitg_test_test_get_type ())
#define GITG_TEST_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_TEST, GitgTestTest))
#define GITG_TEST_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_TEST, GitgTestTestClass))
#define GITG_TEST_IS_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_TEST))
#define GITG_TEST_IS_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_TEST))
#define GITG_TEST_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_TEST, GitgTestTestClass))

typedef struct _GitgTestTest GitgTestTest;
typedef struct _GitgTestTestClass GitgTestTestClass;
typedef struct _GitgTestTestPrivate GitgTestTestPrivate;

#define GITG_TEST_TYPE_REPOSITORY (gitg_test_repository_get_type ())
#define GITG_TEST_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepository))
#define GITG_TEST_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))
#define GITG_TEST_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))

typedef struct _GitgTestRepository GitgTestRepository;
typedef struct _GitgTestRepositoryClass GitgTestRepositoryClass;
typedef struct _GitgTestRepositoryPrivate GitgTestRepositoryPrivate;

#define GITG_TEST_TYPE_APPLICATION (gitg_test_application_get_type ())
#define GITG_TEST_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_APPLICATION, GitgTestApplication))
#define GITG_TEST_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_APPLICATION, GitgTestApplicationClass))
#define GITG_TEST_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_APPLICATION))
#define GITG_TEST_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_APPLICATION))
#define GITG_TEST_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_APPLICATION, GitgTestApplicationClass))

typedef struct _GitgTestApplication GitgTestApplication;
typedef struct _GitgTestApplicationClass GitgTestApplicationClass;
typedef struct _GitgTestApplicationPrivate GitgTestApplicationPrivate;

#define GITG_TEST_TYPE_CHERRY_PICK_COMMIT (gitg_test_cherry_pick_commit_get_type ())
#define GITG_TEST_CHERRY_PICK_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_CHERRY_PICK_COMMIT, GitgTestCherryPickCommit))
#define GITG_TEST_CHERRY_PICK_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_CHERRY_PICK_COMMIT, GitgTestCherryPickCommitClass))
#define GITG_TEST_IS_CHERRY_PICK_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_CHERRY_PICK_COMMIT))
#define GITG_TEST_IS_CHERRY_PICK_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_CHERRY_PICK_COMMIT))
#define GITG_TEST_CHERRY_PICK_COMMIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_CHERRY_PICK_COMMIT, GitgTestCherryPickCommitClass))

typedef struct _GitgTestCherryPickCommit GitgTestCherryPickCommit;
typedef struct _GitgTestCherryPickCommitClass GitgTestCherryPickCommitClass;
typedef struct _GitgTestCherryPickCommitPrivate GitgTestCherryPickCommitPrivate;

#define GITG_TEST_TYPE_REF_ACTION_INTERFACE (gitg_test_ref_action_interface_get_type ())
#define GITG_TEST_REF_ACTION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_REF_ACTION_INTERFACE, GitgTestRefActionInterface))
#define GITG_TEST_REF_ACTION_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_REF_ACTION_INTERFACE, GitgTestRefActionInterfaceClass))
#define GITG_TEST_IS_REF_ACTION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_REF_ACTION_INTERFACE))
#define GITG_TEST_IS_REF_ACTION_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_REF_ACTION_INTERFACE))
#define GITG_TEST_REF_ACTION_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_REF_ACTION_INTERFACE, GitgTestRefActionInterfaceClass))

typedef struct _GitgTestRefActionInterface GitgTestRefActionInterface;
typedef struct _GitgTestRefActionInterfaceClass GitgTestRefActionInterfaceClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TYPE_COMMIT_ACTION_CHERRY_PICK (gitg_commit_action_cherry_pick_get_type ())
#define GITG_COMMIT_ACTION_CHERRY_PICK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COMMIT_ACTION_CHERRY_PICK, GitgCommitActionCherryPick))
#define GITG_COMMIT_ACTION_CHERRY_PICK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COMMIT_ACTION_CHERRY_PICK, GitgCommitActionCherryPickClass))
#define GITG_IS_COMMIT_ACTION_CHERRY_PICK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COMMIT_ACTION_CHERRY_PICK))
#define GITG_IS_COMMIT_ACTION_CHERRY_PICK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COMMIT_ACTION_CHERRY_PICK))
#define GITG_COMMIT_ACTION_CHERRY_PICK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COMMIT_ACTION_CHERRY_PICK, GitgCommitActionCherryPickClass))

typedef struct _GitgCommitActionCherryPick GitgCommitActionCherryPick;
typedef struct _GitgCommitActionCherryPickClass GitgCommitActionCherryPickClass;
typedef struct _Block13Data Block13Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

#define GITG_TYPE_SIMPLE_NOTIFICATION (gitg_simple_notification_get_type ())
#define GITG_SIMPLE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotification))
#define GITG_SIMPLE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotificationClass))
#define GITG_IS_SIMPLE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_SIMPLE_NOTIFICATION))
#define GITG_IS_SIMPLE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_SIMPLE_NOTIFICATION))
#define GITG_SIMPLE_NOTIFICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotificationClass))

typedef struct _GitgSimpleNotification GitgSimpleNotification;
typedef struct _GitgSimpleNotificationClass GitgSimpleNotificationClass;

#define GITG_SIMPLE_NOTIFICATION_TYPE_STATUS (gitg_simple_notification_status_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block14Data Block14Data;
typedef struct _Block15Data Block15Data;
typedef struct _Block16Data Block16Data;
typedef struct _Block17Data Block17Data;
typedef struct _Block18Data Block18Data;
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;
enum  {
	GITG_TEST_CHERRY_PICK_COMMIT_TEST_CHERRY_PICK_SIMPLE_SIGNAL,
	GITG_TEST_CHERRY_PICK_COMMIT_TEST_CHERRY_PICK_NOT_HEAD_SIGNAL,
	GITG_TEST_CHERRY_PICK_COMMIT_TEST_CHERRY_PICK_NOT_HEAD_WOULD_HAVE_CONFLICTED_SIGNAL,
	GITG_TEST_CHERRY_PICK_COMMIT_TEST_CHERRY_PICK_THEIRS_CONFLICTS_NO_CHECKOUT_SIGNAL,
	GITG_TEST_CHERRY_PICK_COMMIT_TEST_MERGE_THEIRS_CONFLICTS_CHECKOUT_SIGNAL,
	GITG_TEST_CHERRY_PICK_COMMIT_TEST_CHERRY_PICK_THEIRS_DIRTY_STASH_SIGNAL,
	GITG_TEST_CHERRY_PICK_COMMIT_TEST_CHERRY_PICK_THEIRS_NOT_MASTER_CONFLICTS_CHECKOUT_SIGNAL,
	GITG_TEST_CHERRY_PICK_COMMIT_TEST_CHERRY_PICK_THEIRS_NOT_MASTER_CONFLICTS_CHECKOUT_DIRTY_SIGNAL,
	GITG_TEST_CHERRY_PICK_COMMIT_TEST_CHERRY_PICK_THEIRS_NOT_MASTER_CONFLICTS_CHECKOUT_DIRTY_NO_STASH_SIGNAL,
	GITG_TEST_CHERRY_PICK_COMMIT_LAST_SIGNAL
};
static guint gitg_test_cherry_pick_commit_signals[GITG_TEST_CHERRY_PICK_COMMIT_LAST_SIGNAL] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GitgTestTest {
	GObject parent_instance;
	GitgTestTestPrivate * priv;
};

struct _GitgTestTestClass {
	GObjectClass parent_class;
	void (*set_up) (GitgTestTest* self);
	void (*tear_down) (GitgTestTest* self);
};

struct _GitgTestRepository {
	GitgTestTest parent_instance;
	GitgTestRepositoryPrivate * priv;
	GitgRepository* d_repository;
};

struct _GitgTestRepositoryClass {
	GitgTestTestClass parent_class;
};

struct _GitgTestApplication {
	GitgTestRepository parent_instance;
	GitgTestApplicationPrivate * priv;
};

struct _GitgTestApplicationClass {
	GitgTestRepositoryClass parent_class;
};

struct _GitgTestCherryPickCommit {
	GitgTestApplication parent_instance;
	GitgTestCherryPickCommitPrivate * priv;
};

struct _GitgTestCherryPickCommitClass {
	GitgTestApplicationClass parent_class;
	void (*test_cherry_pick_simple) (GitgTestCherryPickCommit* self);
	void (*test_cherry_pick_not_head) (GitgTestCherryPickCommit* self);
	void (*test_cherry_pick_not_head_would_have_conflicted) (GitgTestCherryPickCommit* self);
	void (*test_cherry_pick_theirs_conflicts_no_checkout) (GitgTestCherryPickCommit* self);
	void (*test_merge_theirs_conflicts_checkout) (GitgTestCherryPickCommit* self);
	void (*test_cherry_pick_theirs_dirty_stash) (GitgTestCherryPickCommit* self);
	void (*test_cherry_pick_theirs_not_master_conflicts_checkout) (GitgTestCherryPickCommit* self);
	void (*test_cherry_pick_theirs_not_master_conflicts_checkout_dirty) (GitgTestCherryPickCommit* self);
	void (*test_cherry_pick_theirs_not_master_conflicts_checkout_dirty_no_stash) (GitgTestCherryPickCommit* self);
};

struct _GitgTestCherryPickCommitPrivate {
	GitgBranch* ours;
	GitgBranch* theirs;
	GitgCommit* theirs_commit;
	GitgBranch* master;
	GitgCommit* master_commit;
	GitgBranch* not_master;
	GitgTestRefActionInterface* action_interface;
};

struct _Block13Data {
	int _ref_count_;
	GitgTestCherryPickCommit* self;
	GMainLoop* loop;
	GitgCommitActionCherryPick* action;
};

typedef enum  {
	GITG_SIMPLE_NOTIFICATION_STATUS_NONE,
	GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS,
	GITG_SIMPLE_NOTIFICATION_STATUS_ERROR
} GitgSimpleNotificationStatus;

struct _Block14Data {
	int _ref_count_;
	GitgTestCherryPickCommit* self;
	GMainLoop* loop;
	GitgCommitActionCherryPick* action;
};

struct _Block15Data {
	int _ref_count_;
	GitgTestCherryPickCommit* self;
	GMainLoop* loop;
	GitgCommitActionCherryPick* action;
};

struct _Block16Data {
	int _ref_count_;
	GitgTestCherryPickCommit* self;
	GMainLoop* loop;
	GitgCommitActionCherryPick* action;
};

struct _Block17Data {
	int _ref_count_;
	GitgTestCherryPickCommit* self;
	GMainLoop* loop;
	GitgCommitActionCherryPick* action;
};

struct _Block18Data {
	int _ref_count_;
	GitgTestCherryPickCommit* self;
	GMainLoop* loop;
	GitgCommitActionCherryPick* action;
	gchar** messages;
	gint messages_length1;
	gint _messages_size_;
	GgitOId** oids;
	gint oids_length1;
	gint _oids_size_;
};

struct _Block19Data {
	int _ref_count_;
	GitgTestCherryPickCommit* self;
	GMainLoop* loop;
	GitgCommitActionCherryPick* action;
};

struct _Block20Data {
	int _ref_count_;
	GitgTestCherryPickCommit* self;
	GMainLoop* loop;
	GitgCommitActionCherryPick* action;
	gchar** messages;
	gint messages_length1;
	gint _messages_size_;
	GgitOId** oids;
	gint oids_length1;
	gint _oids_size_;
};

struct _Block21Data {
	int _ref_count_;
	GitgTestCherryPickCommit* self;
	GMainLoop* loop;
	GitgCommitActionCherryPick* action;
};


static gpointer gitg_test_cherry_pick_commit_parent_class = NULL;

GType gitg_test_test_get_type (void) G_GNUC_CONST;
GType gitg_test_repository_get_type (void) G_GNUC_CONST;
GType gitg_test_application_get_type (void) G_GNUC_CONST;
GType gitg_test_cherry_pick_commit_get_type (void) G_GNUC_CONST;
GType gitg_test_ref_action_interface_get_type (void) G_GNUC_CONST;
#define GITG_TEST_CHERRY_PICK_COMMIT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TEST_TYPE_CHERRY_PICK_COMMIT, GitgTestCherryPickCommitPrivate))
enum  {
	GITG_TEST_CHERRY_PICK_COMMIT_DUMMY_PROPERTY
};
static void gitg_test_cherry_pick_commit_real_set_up (GitgTestTest* base);
void gitg_test_test_set_up (GitgTestTest* self);
void gitg_test_repository_commit (GitgTestRepository* self, const gchar* filename, ...);
GitgBranch* gitg_test_repository_create_branch (GitgTestRepository* self, const gchar* name);
void gitg_test_repository_checkout_branch (GitgTestRepository* self, const gchar* name);
GitgBranch* gitg_test_repository_lookup_branch (GitgTestRepository* self, const gchar* name);
GitgTestRefActionInterface* gitg_test_ref_action_interface_new (GitgExtApplication* application);
GitgTestRefActionInterface* gitg_test_ref_action_interface_construct (GType object_type, GitgExtApplication* application);
GitgTestCherryPickCommit* gitg_test_cherry_pick_commit_new (void);
GitgTestCherryPickCommit* gitg_test_cherry_pick_commit_construct (GType object_type);
GitgTestApplication* gitg_test_application_new (void);
GitgTestApplication* gitg_test_application_construct (GType object_type);
static void gitg_test_cherry_pick_commit_real_test_cherry_pick_simple (GitgTestCherryPickCommit* self);
GType gitg_commit_action_cherry_pick_get_type (void) G_GNUC_CONST;
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
GitgCommitActionCherryPick* gitg_commit_action_cherry_pick_new (GitgExtApplication* application, GitgExtRefActionInterface* action_interface, GitgCommit* commit);
GitgCommitActionCherryPick* gitg_commit_action_cherry_pick_construct (GType object_type, GitgExtApplication* application, GitgExtRefActionInterface* action_interface, GitgCommit* commit);
void gitg_commit_action_cherry_pick_cherry_pick (GitgCommitActionCherryPick* self, GitgRef* destination, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_commit_action_cherry_pick_cherry_pick_finish (GitgCommitActionCherryPick* self, GAsyncResult* _res_);
static void __lambda32_ (Block13Data* _data13_, GObject* obj, GAsyncResult* res);
static void ___lambda32__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
GType gitg_simple_notification_get_type (void) G_GNUC_CONST;
GeeArrayList* gitg_test_application_get_simple_notifications (GitgTestApplication* self);
const gchar* gitg_simple_notification_get_title (GitgSimpleNotification* self);
const gchar* gitg_simple_notification_get_message (GitgSimpleNotification* self);
GType gitg_simple_notification_status_get_type (void) G_GNUC_CONST;
GitgSimpleNotificationStatus gitg_simple_notification_get_status (GitgSimpleNotification* self);
void gitg_test_repository_assert_file_contents (GitgTestRepository* self, const gchar* filename, const gchar* expected_contents);
GitgCommit* gitg_test_repository_lookup_commit (GitgTestRepository* self, const gchar* name);
static void _vala_GgitOId_free (GgitOId* self);
static void gitg_test_cherry_pick_commit_real_test_cherry_pick_not_head (GitgTestCherryPickCommit* self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void __lambda33_ (Block14Data* _data14_, GObject* obj, GAsyncResult* res);
static void ___lambda33__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gboolean gitg_test_repository_file_exists (GitgTestRepository* self, const gchar* filename);
static void gitg_test_cherry_pick_commit_real_test_cherry_pick_not_head_would_have_conflicted (GitgTestCherryPickCommit* self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static void __lambda34_ (Block15Data* _data15_, GObject* obj, GAsyncResult* res);
static void ___lambda34__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_cherry_pick_commit_real_test_cherry_pick_theirs_conflicts_no_checkout (GitgTestCherryPickCommit* self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
GitgTestApplication* gitg_test_application_expect_user_query (GitgTestApplication* self, GitgExtUserQuery* query, GtkResponseType response);
static void __lambda35_ (Block16Data* _data16_, GObject* obj, GAsyncResult* res);
static void ___lambda35__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_cherry_pick_commit_real_test_merge_theirs_conflicts_checkout (GitgTestCherryPickCommit* self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void __lambda36_ (Block17Data* _data17_, GObject* obj, GAsyncResult* res);
static void ___lambda36__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_cherry_pick_commit_real_test_cherry_pick_theirs_dirty_stash (GitgTestCherryPickCommit* self);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
void gitg_test_repository_write_file (GitgTestRepository* self, const gchar* filename, const gchar* contents);
static void __lambda37_ (Block18Data* _data18_, GObject* obj, GAsyncResult* res);
static void ___lambda37__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gint __lambda38_ (Block18Data* _data18_, gsize index, const gchar* message, GgitOId* oid);
static void _vala_array_add5 (gchar** * array, int* length, int* size, gchar* value);
static GgitOId* _vala_GgitOId_copy (GgitOId* self);
static void _vala_array_add6 (GgitOId** * array, int* length, int* size, GgitOId* value);
static gint ___lambda38__ggit_stash_callback (gsize index, const gchar* message, GgitOId* stash_oid, gpointer self);
static void gitg_test_cherry_pick_commit_real_test_cherry_pick_theirs_not_master_conflicts_checkout (GitgTestCherryPickCommit* self);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static void __lambda39_ (Block19Data* _data19_, GObject* obj, GAsyncResult* res);
static void ___lambda39__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_cherry_pick_commit_real_test_cherry_pick_theirs_not_master_conflicts_checkout_dirty (GitgTestCherryPickCommit* self);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static void __lambda40_ (Block20Data* _data20_, GObject* obj, GAsyncResult* res);
static void ___lambda40__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gint __lambda41_ (Block20Data* _data20_, gsize index, const gchar* message, GgitOId* oid);
static void _vala_array_add7 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add8 (GgitOId** * array, int* length, int* size, GgitOId* value);
static gint ___lambda41__ggit_stash_callback (gsize index, const gchar* message, GgitOId* stash_oid, gpointer self);
static void gitg_test_cherry_pick_commit_real_test_cherry_pick_theirs_not_master_conflicts_checkout_dirty_no_stash (GitgTestCherryPickCommit* self);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static void __lambda42_ (Block21Data* _data21_, GObject* obj, GAsyncResult* res);
static void ___lambda42__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gint __lambda43_ (GitgTestCherryPickCommit* self, gsize index, const gchar* message, GgitOId* oid);
static gint ___lambda43__ggit_stash_callback (gsize index, const gchar* message, GgitOId* stash_oid, gpointer self);
static void gitg_test_cherry_pick_commit_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void gitg_test_cherry_pick_commit_real_set_up (GitgTestTest* base) {
	GitgTestCherryPickCommit * self;
	GitgBranch* _tmp0_;
	GitgBranch* _tmp1_;
	GitgBranch* _tmp2_;
	GgitObject* _tmp3_;
	GitgBranch* _tmp4_;
	GgitObject* _tmp5_;
	GgitObject* _tmp6_;
	GitgCommit* _tmp7_;
	GitgBranch* _tmp8_;
	GitgBranch* _tmp9_;
	GgitObject* _tmp10_;
	GitgBranch* _tmp11_;
	GgitObject* _tmp12_;
	GgitObject* _tmp13_;
	GitgCommit* _tmp14_;
	GitgTestRefActionInterface* _tmp15_;
	GError * _inner_error_ = NULL;
#line 36 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self = (GitgTestCherryPickCommit*) base;
#line 38 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	GITG_TEST_TEST_CLASS (gitg_test_cherry_pick_commit_parent_class)->set_up ((GitgTestTest*) G_TYPE_CHECK_INSTANCE_CAST (self, GITG_TEST_TYPE_APPLICATION, GitgTestApplication));
#line 40 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "a", "a file\n", NULL);
#line 41 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = gitg_test_repository_create_branch ((GitgTestRepository*) self, "theirs");
#line 41 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp1_ = _tmp0_;
#line 41 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp1_);
#line 43 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "b", "b file\n", NULL);
#line 45 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_checkout_branch ((GitgTestRepository*) self, "theirs");
#line 46 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "c", "c file\n", NULL);
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp2_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "theirs");
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->theirs);
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self->priv->theirs = _tmp2_;
#line 49 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp4_ = self->priv->theirs;
#line 49 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp5_ = ggit_ref_lookup ((GgitRef*) _tmp4_, &_inner_error_);
#line 49 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp3_ = _tmp5_;
#line 49 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 49 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 49 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_clear_error (&_inner_error_);
#line 49 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		return;
#line 442 "test-cherry-pick-commit.c"
	}
#line 49 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp6_ = _tmp3_;
#line 49 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp3_ = NULL;
#line 49 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, GITG_TYPE_COMMIT) ? ((GitgCommit*) _tmp6_) : NULL;
#line 49 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if (_tmp7_ == NULL) {
#line 49 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (_tmp6_);
#line 454 "test-cherry-pick-commit.c"
	}
#line 49 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->theirs_commit);
#line 49 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self->priv->theirs_commit = _tmp7_;
#line 51 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_checkout_branch ((GitgTestRepository*) self, "master");
#line 52 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp8_ = gitg_test_repository_create_branch ((GitgTestRepository*) self, "not_master");
#line 52 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->not_master);
#line 52 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self->priv->not_master = _tmp8_;
#line 54 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp9_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "master");
#line 54 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->master);
#line 54 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self->priv->master = _tmp9_;
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp11_ = self->priv->master;
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp12_ = ggit_ref_lookup ((GgitRef*) _tmp11_, &_inner_error_);
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp10_ = _tmp12_;
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (_tmp3_);
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_clear_error (&_inner_error_);
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		return;
#line 490 "test-cherry-pick-commit.c"
	}
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp13_ = _tmp10_;
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp10_ = NULL;
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp14_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, GITG_TYPE_COMMIT) ? ((GitgCommit*) _tmp13_) : NULL;
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if (_tmp14_ == NULL) {
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (_tmp13_);
#line 502 "test-cherry-pick-commit.c"
	}
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->master_commit);
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self->priv->master_commit = _tmp14_;
#line 57 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp15_ = gitg_test_ref_action_interface_new ((GitgExtApplication*) self);
#line 57 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->action_interface);
#line 57 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self->priv->action_interface = _tmp15_;
#line 36 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp10_);
#line 36 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp3_);
#line 518 "test-cherry-pick-commit.c"
}


GitgTestCherryPickCommit* gitg_test_cherry_pick_commit_construct (GType object_type) {
	GitgTestCherryPickCommit * self = NULL;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self = (GitgTestCherryPickCommit*) gitg_test_application_construct (object_type);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return self;
#line 528 "test-cherry-pick-commit.c"
}


GitgTestCherryPickCommit* gitg_test_cherry_pick_commit_new (void) {
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return gitg_test_cherry_pick_commit_construct (GITG_TEST_TYPE_CHERRY_PICK_COMMIT);
#line 535 "test-cherry-pick-commit.c"
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_atomic_int_inc (&_data13_->_ref_count_);
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return _data13_;
#line 544 "test-cherry-pick-commit.c"
}


static void block13_data_unref (void * _userdata_) {
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
#line 553 "test-cherry-pick-commit.c"
		GitgTestCherryPickCommit* self;
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		self = _data13_->self;
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (_data13_->action);
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_main_loop_unref0 (_data13_->loop);
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (self);
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_slice_free (Block13Data, _data13_);
#line 565 "test-cherry-pick-commit.c"
	}
}


static void __lambda32_ (Block13Data* _data13_, GObject* obj, GAsyncResult* res) {
	GitgTestCherryPickCommit* self;
	GAsyncResult* _tmp0_;
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self = _data13_->self;
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_return_if_fail (res != NULL);
#line 66 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = res;
#line 66 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick_finish (_data13_->action, _tmp0_);
#line 67 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_quit (_data13_->loop);
#line 583 "test-cherry-pick-commit.c"
}


static void ___lambda32__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	__lambda32_ (self, source_object, res);
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block13_data_unref (self);
#line 592 "test-cherry-pick-commit.c"
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 84 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 599 "test-cherry-pick-commit.c"
}


static void gitg_test_cherry_pick_commit_real_test_cherry_pick_simple (GitgTestCherryPickCommit* self) {
	Block13Data* _data13_;
	GMainLoop* _tmp0_;
	GitgTestRefActionInterface* _tmp1_;
	GitgCommit* _tmp2_;
	GitgCommitActionCherryPick* _tmp3_;
	GitgBranch* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	gpointer _tmp13_;
	GitgSimpleNotification* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	GeeArrayList* _tmp19_;
	gpointer _tmp20_;
	GitgSimpleNotification* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GeeArrayList* _tmp24_;
	GeeArrayList* _tmp25_;
	GeeArrayList* _tmp26_;
	gpointer _tmp27_;
	GitgSimpleNotification* _tmp28_;
	GitgSimpleNotificationStatus _tmp29_;
	GitgSimpleNotificationStatus _tmp30_;
	GitgCommit* commit;
	GitgCommit* _tmp31_;
	const gchar* _tmp32_;
	GgitOId* _tmp33_;
	GgitOId* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GgitSignature* _tmp37_;
	GgitSignature* _tmp38_;
	GDateTime* _tmp39_;
	GDateTime* _tmp40_;
	gint64 _tmp41_;
	GgitSignature* _tmp42_;
	GgitSignature* _tmp43_;
	GDateTime* _tmp44_;
	GDateTime* _tmp45_;
	gint64 _tmp46_;
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data13_ = g_slice_new0 (Block13Data);
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data13_->_ref_count_ = 1;
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data13_->self = g_object_ref (self);
#line 62 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 62 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data13_->loop = _tmp0_;
#line 63 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp1_ = self->priv->action_interface;
#line 63 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp2_ = self->priv->theirs_commit;
#line 63 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp3_ = gitg_commit_action_cherry_pick_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp1_, _tmp2_);
#line 63 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data13_->action = _tmp3_;
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp4_ = self->priv->master;
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick (_data13_->action, (GitgRef*) _tmp4_, ___lambda32__gasync_ready_callback, block13_data_ref (_data13_));
#line 70 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_run (_data13_->loop);
#line 72 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp5_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 72 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp6_ = _tmp5_;
#line 72 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp7_ = _tmp6_;
#line 72 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp7_);
#line 72 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp9_ = _tmp8_;
#line 72 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq (_tmp9_, 1);
#line 72 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp7_);
#line 73 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp10_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 73 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp11_ = _tmp10_;
#line 73 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp12_ = _tmp11_;
#line 73 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, 0);
#line 73 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp14_ = (GitgSimpleNotification*) _tmp13_;
#line 73 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp15_ = gitg_simple_notification_get_title (_tmp14_);
#line 73 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp16_ = _tmp15_;
#line 73 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp16_, "Cherry pick '72af7c' onto 'master'");
#line 73 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp14_);
#line 73 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp12_);
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp17_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp18_ = _tmp17_;
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp19_ = _tmp18_;
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, 0);
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp21_ = (GitgSimpleNotification*) _tmp20_;
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp22_ = gitg_simple_notification_get_message (_tmp21_);
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp23_ = _tmp22_;
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp23_, "Successfully cherry picked");
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp21_);
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp19_);
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp24_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp25_ = _tmp24_;
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp26_ = _tmp25_;
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, 0);
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp28_ = (GitgSimpleNotification*) _tmp27_;
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp29_ = gitg_simple_notification_get_status (_tmp28_);
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp30_ = _tmp29_;
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp30_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp28_);
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp26_);
#line 77 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 78 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file\n");
#line 79 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "c", "c file\n");
#line 81 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp31_ = gitg_test_repository_lookup_commit ((GitgTestRepository*) self, "master");
#line 81 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	commit = _tmp31_;
#line 83 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp32_ = ggit_commit_get_message ((GgitCommit*) commit);
#line 83 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp32_, "commit c");
#line 84 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp33_ = ggit_object_get_id ((GgitObject*) commit);
#line 84 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp34_ = _tmp33_;
#line 84 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp35_ = ggit_oid_to_string (_tmp34_);
#line 84 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp36_ = _tmp35_;
#line 84 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp36_, "87aef9f8f4320a9d997d194614d175254c24adc7");
#line 84 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_free0 (_tmp36_);
#line 84 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	__vala_GgitOId_free0 (_tmp34_);
#line 85 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp37_ = ggit_commit_get_author ((GgitCommit*) commit);
#line 85 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp38_ = _tmp37_;
#line 85 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp39_ = ggit_signature_get_time (_tmp38_);
#line 85 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp40_ = _tmp39_;
#line 85 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp41_ = g_date_time_to_unix (_tmp40_);
#line 85 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp41_, 2);
#line 85 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_date_time_unref0 (_tmp40_);
#line 85 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp38_);
#line 86 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp42_ = ggit_commit_get_committer ((GgitCommit*) commit);
#line 86 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp43_ = _tmp42_;
#line 86 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp44_ = ggit_signature_get_time (_tmp43_);
#line 86 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp45_ = _tmp44_;
#line 86 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp46_ = g_date_time_to_unix (_tmp45_);
#line 86 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp46_, 3);
#line 86 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_date_time_unref0 (_tmp45_);
#line 86 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp43_);
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (commit);
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block13_data_unref (_data13_);
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data13_ = NULL;
#line 817 "test-cherry-pick-commit.c"
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_atomic_int_inc (&_data14_->_ref_count_);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return _data14_;
#line 826 "test-cherry-pick-commit.c"
}


static void block14_data_unref (void * _userdata_) {
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
#line 835 "test-cherry-pick-commit.c"
		GitgTestCherryPickCommit* self;
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		self = _data14_->self;
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (_data14_->action);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_main_loop_unref0 (_data14_->loop);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (self);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_slice_free (Block14Data, _data14_);
#line 847 "test-cherry-pick-commit.c"
	}
}


static void __lambda33_ (Block14Data* _data14_, GObject* obj, GAsyncResult* res) {
	GitgTestCherryPickCommit* self;
	GAsyncResult* _tmp0_;
#line 95 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self = _data14_->self;
#line 95 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_return_if_fail (res != NULL);
#line 96 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = res;
#line 96 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick_finish (_data14_->action, _tmp0_);
#line 97 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_quit (_data14_->loop);
#line 865 "test-cherry-pick-commit.c"
}


static void ___lambda33__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 95 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	__lambda33_ (self, source_object, res);
#line 95 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block14_data_unref (self);
#line 874 "test-cherry-pick-commit.c"
}


static void gitg_test_cherry_pick_commit_real_test_cherry_pick_not_head (GitgTestCherryPickCommit* self) {
	Block14Data* _data14_;
	GMainLoop* _tmp0_;
	GitgTestRefActionInterface* _tmp1_;
	GitgCommit* _tmp2_;
	GitgCommitActionCherryPick* _tmp3_;
	GitgBranch* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	gpointer _tmp13_;
	GitgSimpleNotification* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	GeeArrayList* _tmp19_;
	gpointer _tmp20_;
	GitgSimpleNotification* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GeeArrayList* _tmp24_;
	GeeArrayList* _tmp25_;
	GeeArrayList* _tmp26_;
	gpointer _tmp27_;
	GitgSimpleNotification* _tmp28_;
	GitgSimpleNotificationStatus _tmp29_;
	GitgSimpleNotificationStatus _tmp30_;
	gboolean _tmp31_;
	GitgCommit* commit;
	GitgCommit* _tmp32_;
	const gchar* _tmp33_;
	GgitOId* _tmp34_;
	GgitOId* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GgitSignature* _tmp38_;
	GgitSignature* _tmp39_;
	GDateTime* _tmp40_;
	GDateTime* _tmp41_;
	gint64 _tmp42_;
	GgitSignature* _tmp43_;
	GgitSignature* _tmp44_;
	GDateTime* _tmp45_;
	GDateTime* _tmp46_;
	gint64 _tmp47_;
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data14_ = g_slice_new0 (Block14Data);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data14_->_ref_count_ = 1;
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data14_->self = g_object_ref (self);
#line 91 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 91 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data14_->loop = _tmp0_;
#line 93 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp1_ = self->priv->action_interface;
#line 93 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp2_ = self->priv->theirs_commit;
#line 93 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp3_ = gitg_commit_action_cherry_pick_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp1_, _tmp2_);
#line 93 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data14_->action = _tmp3_;
#line 95 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp4_ = self->priv->not_master;
#line 95 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick (_data14_->action, (GitgRef*) _tmp4_, ___lambda33__gasync_ready_callback, block14_data_ref (_data14_));
#line 100 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_run (_data14_->loop);
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp5_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp6_ = _tmp5_;
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp7_ = _tmp6_;
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp7_);
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp9_ = _tmp8_;
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq (_tmp9_, 1);
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp7_);
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp10_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp11_ = _tmp10_;
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp12_ = _tmp11_;
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, 0);
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp14_ = (GitgSimpleNotification*) _tmp13_;
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp15_ = gitg_simple_notification_get_title (_tmp14_);
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp16_ = _tmp15_;
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp16_, "Cherry pick '72af7c' onto 'not_master'");
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp14_);
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp12_);
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp17_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp18_ = _tmp17_;
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp19_ = _tmp18_;
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, 0);
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp21_ = (GitgSimpleNotification*) _tmp20_;
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp22_ = gitg_simple_notification_get_message (_tmp21_);
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp23_ = _tmp22_;
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp23_, "Successfully cherry picked");
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp21_);
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp19_);
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp24_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp25_ = _tmp24_;
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp26_ = _tmp25_;
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, 0);
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp28_ = (GitgSimpleNotification*) _tmp27_;
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp29_ = gitg_simple_notification_get_status (_tmp28_);
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp30_ = _tmp29_;
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp30_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp28_);
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp26_);
#line 107 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 108 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file\n");
#line 109 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp31_ = gitg_test_repository_file_exists ((GitgTestRepository*) self, "c");
#line 109 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_vala_assert (!_tmp31_, "!file_exists(\"c\")");
#line 111 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp32_ = gitg_test_repository_lookup_commit ((GitgTestRepository*) self, "not_master");
#line 111 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	commit = _tmp32_;
#line 113 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp33_ = ggit_commit_get_message ((GgitCommit*) commit);
#line 113 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp33_, "commit c");
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp34_ = ggit_object_get_id ((GgitObject*) commit);
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp35_ = _tmp34_;
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp36_ = ggit_oid_to_string (_tmp35_);
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp37_ = _tmp36_;
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp37_, "87aef9f8f4320a9d997d194614d175254c24adc7");
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_free0 (_tmp37_);
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	__vala_GgitOId_free0 (_tmp35_);
#line 115 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp38_ = ggit_commit_get_author ((GgitCommit*) commit);
#line 115 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp39_ = _tmp38_;
#line 115 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp40_ = ggit_signature_get_time (_tmp39_);
#line 115 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp41_ = _tmp40_;
#line 115 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp42_ = g_date_time_to_unix (_tmp41_);
#line 115 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp42_, 2);
#line 115 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_date_time_unref0 (_tmp41_);
#line 115 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp39_);
#line 116 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp43_ = ggit_commit_get_committer ((GgitCommit*) commit);
#line 116 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp44_ = _tmp43_;
#line 116 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp45_ = ggit_signature_get_time (_tmp44_);
#line 116 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp46_ = _tmp45_;
#line 116 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp47_ = g_date_time_to_unix (_tmp46_);
#line 116 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp47_, 3);
#line 116 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_date_time_unref0 (_tmp46_);
#line 116 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp44_);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (commit);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block14_data_unref (_data14_);
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data14_ = NULL;
#line 1095 "test-cherry-pick-commit.c"
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_atomic_int_inc (&_data15_->_ref_count_);
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return _data15_;
#line 1104 "test-cherry-pick-commit.c"
}


static void block15_data_unref (void * _userdata_) {
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
#line 1113 "test-cherry-pick-commit.c"
		GitgTestCherryPickCommit* self;
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		self = _data15_->self;
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (_data15_->action);
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_main_loop_unref0 (_data15_->loop);
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (self);
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_slice_free (Block15Data, _data15_);
#line 1125 "test-cherry-pick-commit.c"
	}
}


static void __lambda34_ (Block15Data* _data15_, GObject* obj, GAsyncResult* res) {
	GitgTestCherryPickCommit* self;
	GAsyncResult* _tmp0_;
#line 127 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self = _data15_->self;
#line 127 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_return_if_fail (res != NULL);
#line 128 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = res;
#line 128 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick_finish (_data15_->action, _tmp0_);
#line 129 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_quit (_data15_->loop);
#line 1143 "test-cherry-pick-commit.c"
}


static void ___lambda34__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 127 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	__lambda34_ (self, source_object, res);
#line 127 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block15_data_unref (self);
#line 1152 "test-cherry-pick-commit.c"
}


static void gitg_test_cherry_pick_commit_real_test_cherry_pick_not_head_would_have_conflicted (GitgTestCherryPickCommit* self) {
	Block15Data* _data15_;
	GMainLoop* _tmp0_;
	GitgTestRefActionInterface* _tmp1_;
	GitgCommit* _tmp2_;
	GitgCommitActionCherryPick* _tmp3_;
	GitgBranch* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	gpointer _tmp13_;
	GitgSimpleNotification* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	GeeArrayList* _tmp19_;
	gpointer _tmp20_;
	GitgSimpleNotification* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GeeArrayList* _tmp24_;
	GeeArrayList* _tmp25_;
	GeeArrayList* _tmp26_;
	gpointer _tmp27_;
	GitgSimpleNotification* _tmp28_;
	GitgSimpleNotificationStatus _tmp29_;
	GitgSimpleNotificationStatus _tmp30_;
	GitgCommit* commit;
	GitgCommit* _tmp31_;
	const gchar* _tmp32_;
	GgitOId* _tmp33_;
	GgitOId* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GgitSignature* _tmp37_;
	GgitSignature* _tmp38_;
	GDateTime* _tmp39_;
	GDateTime* _tmp40_;
	gint64 _tmp41_;
	GgitSignature* _tmp42_;
	GgitSignature* _tmp43_;
	GDateTime* _tmp44_;
	GDateTime* _tmp45_;
	gint64 _tmp46_;
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data15_ = g_slice_new0 (Block15Data);
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data15_->_ref_count_ = 1;
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data15_->self = g_object_ref (self);
#line 121 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 121 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data15_->loop = _tmp0_;
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "c", "c file other content\n", NULL);
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp1_ = self->priv->action_interface;
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp2_ = self->priv->theirs_commit;
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp3_ = gitg_commit_action_cherry_pick_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp1_, _tmp2_);
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data15_->action = _tmp3_;
#line 127 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp4_ = self->priv->not_master;
#line 127 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick (_data15_->action, (GitgRef*) _tmp4_, ___lambda34__gasync_ready_callback, block15_data_ref (_data15_));
#line 132 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_run (_data15_->loop);
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp5_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp6_ = _tmp5_;
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp7_ = _tmp6_;
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp7_);
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp9_ = _tmp8_;
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq (_tmp9_, 1);
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp7_);
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp10_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp11_ = _tmp10_;
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp12_ = _tmp11_;
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, 0);
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp14_ = (GitgSimpleNotification*) _tmp13_;
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp15_ = gitg_simple_notification_get_title (_tmp14_);
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp16_ = _tmp15_;
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp16_, "Cherry pick '72af7c' onto 'not_master'");
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp14_);
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp12_);
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp17_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp18_ = _tmp17_;
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp19_ = _tmp18_;
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, 0);
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp21_ = (GitgSimpleNotification*) _tmp20_;
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp22_ = gitg_simple_notification_get_message (_tmp21_);
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp23_ = _tmp22_;
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp23_, "Successfully cherry picked");
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp21_);
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp19_);
#line 137 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp24_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 137 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp25_ = _tmp24_;
#line 137 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp26_ = _tmp25_;
#line 137 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, 0);
#line 137 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp28_ = (GitgSimpleNotification*) _tmp27_;
#line 137 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp29_ = gitg_simple_notification_get_status (_tmp28_);
#line 137 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp30_ = _tmp29_;
#line 137 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp30_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 137 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp28_);
#line 137 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp26_);
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 140 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file\n");
#line 141 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "c", "c file other content\n");
#line 143 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp31_ = gitg_test_repository_lookup_commit ((GitgTestRepository*) self, "not_master");
#line 143 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	commit = _tmp31_;
#line 145 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp32_ = ggit_commit_get_message ((GgitCommit*) commit);
#line 145 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp32_, "commit c");
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp33_ = ggit_object_get_id ((GgitObject*) commit);
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp34_ = _tmp33_;
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp35_ = ggit_oid_to_string (_tmp34_);
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp36_ = _tmp35_;
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp36_, "e9e99c25e6061b42b6d48d143e028d1806f85745");
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_free0 (_tmp36_);
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	__vala_GgitOId_free0 (_tmp34_);
#line 147 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp37_ = ggit_commit_get_author ((GgitCommit*) commit);
#line 147 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp38_ = _tmp37_;
#line 147 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp39_ = ggit_signature_get_time (_tmp38_);
#line 147 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp40_ = _tmp39_;
#line 147 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp41_ = g_date_time_to_unix (_tmp40_);
#line 147 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp41_, 2);
#line 147 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_date_time_unref0 (_tmp40_);
#line 147 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp38_);
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp42_ = ggit_commit_get_committer ((GgitCommit*) commit);
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp43_ = _tmp42_;
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp44_ = ggit_signature_get_time (_tmp43_);
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp45_ = _tmp44_;
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp46_ = g_date_time_to_unix (_tmp45_);
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp46_, 4);
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_date_time_unref0 (_tmp45_);
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp43_);
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (commit);
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block15_data_unref (_data15_);
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data15_ = NULL;
#line 1372 "test-cherry-pick-commit.c"
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_atomic_int_inc (&_data16_->_ref_count_);
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return _data16_;
#line 1381 "test-cherry-pick-commit.c"
}


static void block16_data_unref (void * _userdata_) {
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
#line 1390 "test-cherry-pick-commit.c"
		GitgTestCherryPickCommit* self;
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		self = _data16_->self;
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (_data16_->action);
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_main_loop_unref0 (_data16_->loop);
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (self);
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_slice_free (Block16Data, _data16_);
#line 1402 "test-cherry-pick-commit.c"
	}
}


static void __lambda35_ (Block16Data* _data16_, GObject* obj, GAsyncResult* res) {
	GitgTestCherryPickCommit* self;
	GAsyncResult* _tmp0_;
#line 169 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self = _data16_->self;
#line 169 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_return_if_fail (res != NULL);
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = res;
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick_finish (_data16_->action, _tmp0_);
#line 171 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_quit (_data16_->loop);
#line 1420 "test-cherry-pick-commit.c"
}


static void ___lambda35__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 169 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	__lambda35_ (self, source_object, res);
#line 169 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block16_data_unref (self);
#line 1429 "test-cherry-pick-commit.c"
}


static void gitg_test_cherry_pick_commit_real_test_cherry_pick_theirs_conflicts_no_checkout (GitgTestCherryPickCommit* self) {
	Block16Data* _data16_;
	GMainLoop* _tmp0_;
	GitgBranch* _tmp1_;
	GitgTestRefActionInterface* _tmp2_;
	GitgCommit* _tmp3_;
	GitgCommitActionCherryPick* _tmp4_;
	GitgExtUserQuery* _tmp5_;
	GitgExtUserQuery* _tmp6_;
	GitgTestApplication* _tmp7_;
	GitgTestApplication* _tmp8_;
	GitgBranch* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp16_;
	GeeArrayList* _tmp17_;
	gpointer _tmp18_;
	GitgSimpleNotification* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GeeArrayList* _tmp22_;
	GeeArrayList* _tmp23_;
	GeeArrayList* _tmp24_;
	gpointer _tmp25_;
	GitgSimpleNotification* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	GeeArrayList* _tmp29_;
	GeeArrayList* _tmp30_;
	GeeArrayList* _tmp31_;
	gpointer _tmp32_;
	GitgSimpleNotification* _tmp33_;
	GitgSimpleNotificationStatus _tmp34_;
	GitgSimpleNotificationStatus _tmp35_;
	GitgCommit* commit;
	GitgCommit* _tmp36_;
	const gchar* _tmp37_;
	GgitOId* _tmp38_;
	GgitOId* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GgitSignature* _tmp42_;
	GgitSignature* _tmp43_;
	GDateTime* _tmp44_;
	GDateTime* _tmp45_;
	gint64 _tmp46_;
	GgitSignature* _tmp47_;
	GgitSignature* _tmp48_;
	GDateTime* _tmp49_;
	GDateTime* _tmp50_;
	gint64 _tmp51_;
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data16_ = g_slice_new0 (Block16Data);
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data16_->_ref_count_ = 1;
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data16_->self = g_object_ref (self);
#line 153 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 153 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data16_->loop = _tmp0_;
#line 155 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "c", "c file other content\n", NULL);
#line 156 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp1_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "master");
#line 156 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->master);
#line 156 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self->priv->master = _tmp1_;
#line 158 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp2_ = self->priv->action_interface;
#line 158 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp3_ = self->priv->theirs_commit;
#line 158 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp4_ = gitg_commit_action_cherry_pick_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp2_, _tmp3_);
#line 158 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data16_->action = _tmp4_;
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp5_ = gitg_ext_user_query_new_full ("Cherry pick has conflicts", "The cherry pick of '72af7c' onto 'master' has caused conflicts, would " \
"you like to checkout branch 'master' with the cherry pick to your work" \
"ing directory to resolve the conflicts?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Checkout", GTK_RESPONSE_OK, NULL);
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp6_ = _tmp5_;
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp7_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp6_, GTK_RESPONSE_CANCEL);
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp8_ = _tmp7_;
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp8_);
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp6_);
#line 169 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp9_ = self->priv->master;
#line 169 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick (_data16_->action, (GitgRef*) _tmp9_, ___lambda35__gasync_ready_callback, block16_data_ref (_data16_));
#line 174 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_run (_data16_->loop);
#line 176 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp10_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 176 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp11_ = _tmp10_;
#line 176 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp12_ = _tmp11_;
#line 176 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp13_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp12_);
#line 176 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp14_ = _tmp13_;
#line 176 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq (_tmp14_, 1);
#line 176 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp12_);
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp15_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp16_ = _tmp15_;
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp17_ = _tmp16_;
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, 0);
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp19_ = (GitgSimpleNotification*) _tmp18_;
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp20_ = gitg_simple_notification_get_title (_tmp19_);
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp21_ = _tmp20_;
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp21_, "Cherry pick '72af7c' onto 'master'");
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp19_);
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp17_);
#line 178 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp22_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 178 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp23_ = _tmp22_;
#line 178 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp24_ = _tmp23_;
#line 178 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, 0);
#line 178 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp26_ = (GitgSimpleNotification*) _tmp25_;
#line 178 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp27_ = gitg_simple_notification_get_message (_tmp26_);
#line 178 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp28_ = _tmp27_;
#line 178 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp28_, "Cherry pick failed with conflicts");
#line 178 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp26_);
#line 178 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp24_);
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp29_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp30_ = _tmp29_;
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp31_ = _tmp30_;
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, 0);
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp33_ = (GitgSimpleNotification*) _tmp32_;
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp34_ = gitg_simple_notification_get_status (_tmp33_);
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp35_ = _tmp34_;
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp35_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_ERROR);
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp33_);
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp31_);
#line 181 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 182 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file\n");
#line 183 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "c", "c file other content\n");
#line 185 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp36_ = gitg_test_repository_lookup_commit ((GitgTestRepository*) self, "master");
#line 185 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	commit = _tmp36_;
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp37_ = ggit_commit_get_message ((GgitCommit*) commit);
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp37_, "commit c");
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp38_ = ggit_object_get_id ((GgitObject*) commit);
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp39_ = _tmp38_;
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp40_ = ggit_oid_to_string (_tmp39_);
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp41_ = _tmp40_;
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp41_, "e1219dd5fbcf8fb5b17bbd3db7a9fa88e98d6651");
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_free0 (_tmp41_);
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	__vala_GgitOId_free0 (_tmp39_);
#line 189 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp42_ = ggit_commit_get_author ((GgitCommit*) commit);
#line 189 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp43_ = _tmp42_;
#line 189 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp44_ = ggit_signature_get_time (_tmp43_);
#line 189 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp45_ = _tmp44_;
#line 189 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp46_ = g_date_time_to_unix (_tmp45_);
#line 189 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp46_, 3);
#line 189 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_date_time_unref0 (_tmp45_);
#line 189 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp43_);
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp47_ = ggit_commit_get_committer ((GgitCommit*) commit);
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp48_ = _tmp47_;
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp49_ = ggit_signature_get_time (_tmp48_);
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp50_ = _tmp49_;
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp51_ = g_date_time_to_unix (_tmp50_);
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp51_, 3);
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_date_time_unref0 (_tmp50_);
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp48_);
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (commit);
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block16_data_unref (_data16_);
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data16_ = NULL;
#line 1672 "test-cherry-pick-commit.c"
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_atomic_int_inc (&_data17_->_ref_count_);
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return _data17_;
#line 1681 "test-cherry-pick-commit.c"
}


static void block17_data_unref (void * _userdata_) {
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
#line 1690 "test-cherry-pick-commit.c"
		GitgTestCherryPickCommit* self;
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		self = _data17_->self;
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (_data17_->action);
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_main_loop_unref0 (_data17_->loop);
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (self);
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_slice_free (Block17Data, _data17_);
#line 1702 "test-cherry-pick-commit.c"
	}
}


static void __lambda36_ (Block17Data* _data17_, GObject* obj, GAsyncResult* res) {
	GitgTestCherryPickCommit* self;
	GAsyncResult* _tmp0_;
#line 211 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self = _data17_->self;
#line 211 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_return_if_fail (res != NULL);
#line 212 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = res;
#line 212 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick_finish (_data17_->action, _tmp0_);
#line 213 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_quit (_data17_->loop);
#line 1720 "test-cherry-pick-commit.c"
}


static void ___lambda36__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 211 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	__lambda36_ (self, source_object, res);
#line 211 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block17_data_unref (self);
#line 1729 "test-cherry-pick-commit.c"
}


static void gitg_test_cherry_pick_commit_real_test_merge_theirs_conflicts_checkout (GitgTestCherryPickCommit* self) {
	Block17Data* _data17_;
	GMainLoop* _tmp0_;
	GitgBranch* _tmp1_;
	GitgTestRefActionInterface* _tmp2_;
	GitgCommit* _tmp3_;
	GitgCommitActionCherryPick* _tmp4_;
	GitgExtUserQuery* _tmp5_;
	GitgExtUserQuery* _tmp6_;
	GitgTestApplication* _tmp7_;
	GitgTestApplication* _tmp8_;
	GitgBranch* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp16_;
	GeeArrayList* _tmp17_;
	gpointer _tmp18_;
	GitgSimpleNotification* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GeeArrayList* _tmp22_;
	GeeArrayList* _tmp23_;
	GeeArrayList* _tmp24_;
	gpointer _tmp25_;
	GitgSimpleNotification* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	GeeArrayList* _tmp29_;
	GeeArrayList* _tmp30_;
	GeeArrayList* _tmp31_;
	gpointer _tmp32_;
	GitgSimpleNotification* _tmp33_;
	GitgSimpleNotificationStatus _tmp34_;
	GitgSimpleNotificationStatus _tmp35_;
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data17_ = g_slice_new0 (Block17Data);
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data17_->_ref_count_ = 1;
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data17_->self = g_object_ref (self);
#line 195 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 195 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data17_->loop = _tmp0_;
#line 197 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "c", "c file other content\n", NULL);
#line 198 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp1_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "master");
#line 198 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->master);
#line 198 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self->priv->master = _tmp1_;
#line 200 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp2_ = self->priv->action_interface;
#line 200 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp3_ = self->priv->theirs_commit;
#line 200 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp4_ = gitg_commit_action_cherry_pick_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp2_, _tmp3_);
#line 200 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data17_->action = _tmp4_;
#line 202 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp5_ = gitg_ext_user_query_new_full ("Cherry pick has conflicts", "The cherry pick of '72af7c' onto 'master' has caused conflicts, would " \
"you like to checkout branch 'master' with the cherry pick to your work" \
"ing directory to resolve the conflicts?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Checkout", GTK_RESPONSE_OK, NULL);
#line 202 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp6_ = _tmp5_;
#line 202 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp7_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp6_, GTK_RESPONSE_OK);
#line 202 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp8_ = _tmp7_;
#line 202 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp8_);
#line 202 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp6_);
#line 211 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp9_ = self->priv->master;
#line 211 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick (_data17_->action, (GitgRef*) _tmp9_, ___lambda36__gasync_ready_callback, block17_data_ref (_data17_));
#line 216 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_run (_data17_->loop);
#line 218 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp10_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 218 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp11_ = _tmp10_;
#line 218 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp12_ = _tmp11_;
#line 218 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp13_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp12_);
#line 218 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp14_ = _tmp13_;
#line 218 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq (_tmp14_, 1);
#line 218 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp12_);
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp15_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp16_ = _tmp15_;
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp17_ = _tmp16_;
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, 0);
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp19_ = (GitgSimpleNotification*) _tmp18_;
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp20_ = gitg_simple_notification_get_title (_tmp19_);
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp21_ = _tmp20_;
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp21_, "Cherry pick '72af7c' onto 'master'");
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp19_);
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp17_);
#line 220 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp22_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 220 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp23_ = _tmp22_;
#line 220 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp24_ = _tmp23_;
#line 220 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, 0);
#line 220 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp26_ = (GitgSimpleNotification*) _tmp25_;
#line 220 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp27_ = gitg_simple_notification_get_message (_tmp26_);
#line 220 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp28_ = _tmp27_;
#line 220 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp28_, "Cherry pick finished with conflicts in working directory");
#line 220 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp26_);
#line 220 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp24_);
#line 221 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp29_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 221 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp30_ = _tmp29_;
#line 221 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp31_ = _tmp30_;
#line 221 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, 0);
#line 221 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp33_ = (GitgSimpleNotification*) _tmp32_;
#line 221 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp34_ = gitg_simple_notification_get_status (_tmp33_);
#line 221 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp35_ = _tmp34_;
#line 221 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp35_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 221 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp33_);
#line 221 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp31_);
#line 223 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file\n");
#line 225 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "c", "<<<<<<< ours\n" \
"c file other content\n" \
"=======\n" \
"c file\n" \
">>>>>>> theirs\n");
#line 227 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, ".git/CHERRY_PICK_HEAD", "72af7ccf47852d832b06c7244de8ae9ded639024\n");
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block17_data_unref (_data17_);
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data17_ = NULL;
#line 1901 "test-cherry-pick-commit.c"
}


static Block18Data* block18_data_ref (Block18Data* _data18_) {
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_atomic_int_inc (&_data18_->_ref_count_);
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return _data18_;
#line 1910 "test-cherry-pick-commit.c"
}


static void block18_data_unref (void * _userdata_) {
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
#line 1919 "test-cherry-pick-commit.c"
		GitgTestCherryPickCommit* self;
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		self = _data18_->self;
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_data18_->oids = (_vala_array_free (_data18_->oids, _data18_->oids_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_data18_->messages = (_vala_array_free (_data18_->messages, _data18_->messages_length1, (GDestroyNotify) g_free), NULL);
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (_data18_->action);
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_main_loop_unref0 (_data18_->loop);
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (self);
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_slice_free (Block18Data, _data18_);
#line 1935 "test-cherry-pick-commit.c"
	}
}


static void __lambda37_ (Block18Data* _data18_, GObject* obj, GAsyncResult* res) {
	GitgTestCherryPickCommit* self;
	GAsyncResult* _tmp0_;
#line 247 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self = _data18_->self;
#line 247 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_return_if_fail (res != NULL);
#line 248 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = res;
#line 248 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick_finish (_data18_->action, _tmp0_);
#line 249 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_quit (_data18_->loop);
#line 1953 "test-cherry-pick-commit.c"
}


static void ___lambda37__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 247 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	__lambda37_ (self, source_object, res);
#line 247 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block18_data_unref (self);
#line 1962 "test-cherry-pick-commit.c"
}


static void _vala_array_add5 (gchar** * array, int* length, int* size, gchar* value) {
#line 267 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if ((*length) == (*size)) {
#line 267 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 267 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1973 "test-cherry-pick-commit.c"
	}
#line 267 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	(*array)[(*length)++] = value;
#line 267 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	(*array)[*length] = NULL;
#line 1979 "test-cherry-pick-commit.c"
}


static GgitOId* _vala_GgitOId_copy (GgitOId* self) {
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return g_boxed_copy (ggit_oid_get_type (), self);
#line 1986 "test-cherry-pick-commit.c"
}


static gpointer __vala_GgitOId_copy0 (gpointer self) {
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return self ? _vala_GgitOId_copy (self) : NULL;
#line 1993 "test-cherry-pick-commit.c"
}


static void _vala_array_add6 (GgitOId** * array, int* length, int* size, GgitOId* value) {
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if ((*length) == (*size)) {
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		*array = g_renew (GgitOId*, *array, (*size) + 1);
#line 2004 "test-cherry-pick-commit.c"
	}
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	(*array)[(*length)++] = value;
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	(*array)[*length] = NULL;
#line 2010 "test-cherry-pick-commit.c"
}


static gint __lambda38_ (Block18Data* _data18_, gsize index, const gchar* message, GgitOId* oid) {
	GitgTestCherryPickCommit* self;
	gint result = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GgitOId* _tmp2_;
	GgitOId* _tmp3_;
#line 266 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self = _data18_->self;
#line 266 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_return_val_if_fail (message != NULL, 0);
#line 266 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_return_val_if_fail (oid != NULL, 0);
#line 267 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = message;
#line 267 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 267 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_vala_array_add5 (&_data18_->messages, &_data18_->messages_length1, &_data18_->_messages_size_, _tmp1_);
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp2_ = oid;
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp3_ = __vala_GgitOId_copy0 (_tmp2_);
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_vala_array_add6 (&_data18_->oids, &_data18_->oids_length1, &_data18_->_oids_size_, _tmp3_);
#line 270 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	result = 0;
#line 270 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return result;
#line 2043 "test-cherry-pick-commit.c"
}


static gint ___lambda38__ggit_stash_callback (gsize index, const gchar* message, GgitOId* stash_oid, gpointer self) {
	gint result;
	result = __lambda38_ (self, index, message, stash_oid);
#line 266 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return result;
#line 2052 "test-cherry-pick-commit.c"
}


static void gitg_test_cherry_pick_commit_real_test_cherry_pick_theirs_dirty_stash (GitgTestCherryPickCommit* self) {
	Block18Data* _data18_;
	GMainLoop* _tmp0_;
	GitgTestRefActionInterface* _tmp1_;
	GitgCommit* _tmp2_;
	GitgCommitActionCherryPick* _tmp3_;
	GitgExtUserQuery* _tmp4_;
	GitgExtUserQuery* _tmp5_;
	GitgTestApplication* _tmp6_;
	GitgTestApplication* _tmp7_;
	GitgBranch* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp16_;
	gpointer _tmp17_;
	GitgSimpleNotification* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GeeArrayList* _tmp21_;
	GeeArrayList* _tmp22_;
	GeeArrayList* _tmp23_;
	gpointer _tmp24_;
	GitgSimpleNotification* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	GeeArrayList* _tmp28_;
	GeeArrayList* _tmp29_;
	GeeArrayList* _tmp30_;
	gpointer _tmp31_;
	GitgSimpleNotification* _tmp32_;
	GitgSimpleNotificationStatus _tmp33_;
	GitgSimpleNotificationStatus _tmp34_;
	gchar** _tmp35_;
	GgitOId** _tmp36_;
	GitgRepository* _tmp37_;
	const gchar* _tmp38_;
	GgitOId* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GitgCommit* commit;
	GitgCommit* _tmp42_;
	GitgCommit* _tmp43_;
	const gchar* _tmp44_;
	GitgCommit* _tmp45_;
	GgitOId* _tmp46_;
	GgitOId* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	GitgCommit* _tmp50_;
	GgitSignature* _tmp51_;
	GgitSignature* _tmp52_;
	GDateTime* _tmp53_;
	GDateTime* _tmp54_;
	gint64 _tmp55_;
	GitgCommit* _tmp56_;
	GgitSignature* _tmp57_;
	GgitSignature* _tmp58_;
	GDateTime* _tmp59_;
	GDateTime* _tmp60_;
	gint64 _tmp61_;
	GError * _inner_error_ = NULL;
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data18_ = g_slice_new0 (Block18Data);
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data18_->_ref_count_ = 1;
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data18_->self = g_object_ref (self);
#line 232 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 232 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data18_->loop = _tmp0_;
#line 234 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_write_file ((GitgTestRepository*) self, "b", "b file other content\n");
#line 236 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp1_ = self->priv->action_interface;
#line 236 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp2_ = self->priv->theirs_commit;
#line 236 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp3_ = gitg_commit_action_cherry_pick_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp1_, _tmp2_);
#line 236 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data18_->action = _tmp3_;
#line 238 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp4_ = gitg_ext_user_query_new_full ("Unstaged changes", "You appear to have unstaged changes in your working directory. Would y" \
"ou like to stash the changes before the checkout?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Stash changes", GTK_RESPONSE_OK, NULL);
#line 238 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp5_ = _tmp4_;
#line 238 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp6_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp5_, GTK_RESPONSE_OK);
#line 238 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp7_ = _tmp6_;
#line 238 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp7_);
#line 238 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp5_);
#line 247 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp8_ = self->priv->master;
#line 247 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick (_data18_->action, (GitgRef*) _tmp8_, ___lambda37__gasync_ready_callback, block18_data_ref (_data18_));
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_run (_data18_->loop);
#line 254 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp9_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 254 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp10_ = _tmp9_;
#line 254 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp11_ = _tmp10_;
#line 254 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp12_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp11_);
#line 254 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp13_ = _tmp12_;
#line 254 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq (_tmp13_, 1);
#line 254 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp11_);
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp14_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp15_ = _tmp14_;
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp16_ = _tmp15_;
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, 0);
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp18_ = (GitgSimpleNotification*) _tmp17_;
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp19_ = gitg_simple_notification_get_title (_tmp18_);
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp20_ = _tmp19_;
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp20_, "Cherry pick '72af7c' onto 'master'");
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp18_);
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp16_);
#line 256 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp21_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 256 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp22_ = _tmp21_;
#line 256 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp23_ = _tmp22_;
#line 256 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, 0);
#line 256 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp25_ = (GitgSimpleNotification*) _tmp24_;
#line 256 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp26_ = gitg_simple_notification_get_message (_tmp25_);
#line 256 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp27_ = _tmp26_;
#line 256 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp27_, "Successfully cherry picked");
#line 256 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp25_);
#line 256 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp23_);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp28_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp29_ = _tmp28_;
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp30_ = _tmp29_;
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, 0);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp32_ = (GitgSimpleNotification*) _tmp31_;
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp33_ = gitg_simple_notification_get_status (_tmp32_);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp34_ = _tmp33_;
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp34_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp32_);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp30_);
#line 259 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 260 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file\n");
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "c", "c file\n");
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp35_ = g_new0 (gchar*, 0 + 1);
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data18_->messages = _tmp35_;
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data18_->messages_length1 = 0;
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data18_->_messages_size_ = _data18_->messages_length1;
#line 264 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp36_ = g_new0 (GgitOId*, 0 + 1);
#line 264 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data18_->oids = _tmp36_;
#line 264 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data18_->oids_length1 = 0;
#line 264 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data18_->_oids_size_ = _data18_->oids_length1;
#line 266 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp37_ = ((GitgTestRepository*) self)->d_repository;
#line 266 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	ggit_repository_stash_foreach ((GgitRepository*) _tmp37_, ___lambda38__ggit_stash_callback, _data18_, &_inner_error_);
#line 266 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 266 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		block18_data_unref (_data18_);
#line 266 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_data18_ = NULL;
#line 266 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 266 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_clear_error (&_inner_error_);
#line 266 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		return;
#line 2272 "test-cherry-pick-commit.c"
	}
#line 273 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq (_data18_->messages_length1, 1);
#line 274 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp38_ = _data18_->messages[0];
#line 274 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp38_, "On master: WIP on HEAD: 50ac9b commit b");
#line 275 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp39_ = _data18_->oids[0];
#line 275 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp40_ = ggit_oid_to_string (_tmp39_);
#line 275 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp41_ = _tmp40_;
#line 275 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp41_, "aaf63a72d8c0d5799ccfcf1623daef228968382f");
#line 275 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_free0 (_tmp41_);
#line 277 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp42_ = gitg_test_repository_lookup_commit ((GitgTestRepository*) self, "master");
#line 277 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	commit = _tmp42_;
#line 279 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp43_ = commit;
#line 279 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp44_ = ggit_commit_get_message ((GgitCommit*) _tmp43_);
#line 279 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp44_, "commit c");
#line 280 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp45_ = commit;
#line 280 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp46_ = ggit_object_get_id ((GgitObject*) _tmp45_);
#line 280 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp47_ = _tmp46_;
#line 280 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp48_ = ggit_oid_to_string (_tmp47_);
#line 280 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp49_ = _tmp48_;
#line 280 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp49_, "87aef9f8f4320a9d997d194614d175254c24adc7");
#line 280 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_free0 (_tmp49_);
#line 280 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	__vala_GgitOId_free0 (_tmp47_);
#line 281 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp50_ = commit;
#line 281 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp51_ = ggit_commit_get_author ((GgitCommit*) _tmp50_);
#line 281 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp52_ = _tmp51_;
#line 281 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp53_ = ggit_signature_get_time (_tmp52_);
#line 281 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp54_ = _tmp53_;
#line 281 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp55_ = g_date_time_to_unix (_tmp54_);
#line 281 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp55_, 2);
#line 281 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_date_time_unref0 (_tmp54_);
#line 281 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp52_);
#line 282 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp56_ = commit;
#line 282 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp57_ = ggit_commit_get_committer ((GgitCommit*) _tmp56_);
#line 282 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp58_ = _tmp57_;
#line 282 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp59_ = ggit_signature_get_time (_tmp58_);
#line 282 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp60_ = _tmp59_;
#line 282 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp61_ = g_date_time_to_unix (_tmp60_);
#line 282 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp61_, 3);
#line 282 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_date_time_unref0 (_tmp60_);
#line 282 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp58_);
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (commit);
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block18_data_unref (_data18_);
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data18_ = NULL;
#line 2358 "test-cherry-pick-commit.c"
}


static Block19Data* block19_data_ref (Block19Data* _data19_) {
#line 285 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_atomic_int_inc (&_data19_->_ref_count_);
#line 285 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return _data19_;
#line 2367 "test-cherry-pick-commit.c"
}


static void block19_data_unref (void * _userdata_) {
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
#line 285 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
#line 2376 "test-cherry-pick-commit.c"
		GitgTestCherryPickCommit* self;
#line 285 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		self = _data19_->self;
#line 285 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (_data19_->action);
#line 285 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_main_loop_unref0 (_data19_->loop);
#line 285 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (self);
#line 285 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_slice_free (Block19Data, _data19_);
#line 2388 "test-cherry-pick-commit.c"
	}
}


static void __lambda39_ (Block19Data* _data19_, GObject* obj, GAsyncResult* res) {
	GitgTestCherryPickCommit* self;
	GAsyncResult* _tmp0_;
#line 315 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self = _data19_->self;
#line 315 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_return_if_fail (res != NULL);
#line 316 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = res;
#line 316 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick_finish (_data19_->action, _tmp0_);
#line 317 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_quit (_data19_->loop);
#line 2406 "test-cherry-pick-commit.c"
}


static void ___lambda39__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 315 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	__lambda39_ (self, source_object, res);
#line 315 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block19_data_unref (self);
#line 2415 "test-cherry-pick-commit.c"
}


static void gitg_test_cherry_pick_commit_real_test_cherry_pick_theirs_not_master_conflicts_checkout (GitgTestCherryPickCommit* self) {
	Block19Data* _data19_;
	GMainLoop* _tmp0_;
	GitgBranch* _tmp1_;
	GitgTestRefActionInterface* _tmp2_;
	GitgCommit* _tmp3_;
	GitgCommitActionCherryPick* _tmp4_;
	GitgExtUserQuery* _tmp5_;
	GitgExtUserQuery* _tmp6_;
	GitgTestApplication* _tmp7_;
	GitgTestApplication* _tmp8_;
	GitgExtUserQuery* _tmp9_;
	GitgExtUserQuery* _tmp10_;
	GitgTestApplication* _tmp11_;
	GitgTestApplication* _tmp12_;
	GitgBranch* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GeeArrayList* _tmp19_;
	GeeArrayList* _tmp20_;
	GeeArrayList* _tmp21_;
	gpointer _tmp22_;
	GitgSimpleNotification* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	GeeArrayList* _tmp26_;
	GeeArrayList* _tmp27_;
	GeeArrayList* _tmp28_;
	gpointer _tmp29_;
	GitgSimpleNotification* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GeeArrayList* _tmp33_;
	GeeArrayList* _tmp34_;
	GeeArrayList* _tmp35_;
	gpointer _tmp36_;
	GitgSimpleNotification* _tmp37_;
	GitgSimpleNotificationStatus _tmp38_;
	GitgSimpleNotificationStatus _tmp39_;
	GeeArrayList* _tmp40_;
	GeeArrayList* _tmp41_;
	GeeArrayList* _tmp42_;
	gpointer _tmp43_;
	GitgSimpleNotification* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	GeeArrayList* _tmp47_;
	GeeArrayList* _tmp48_;
	GeeArrayList* _tmp49_;
	gpointer _tmp50_;
	GitgSimpleNotification* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	GeeArrayList* _tmp54_;
	GeeArrayList* _tmp55_;
	GeeArrayList* _tmp56_;
	gpointer _tmp57_;
	GitgSimpleNotification* _tmp58_;
	GitgSimpleNotificationStatus _tmp59_;
	GitgSimpleNotificationStatus _tmp60_;
	GitgBranch* _tmp61_;
	GitgBranch* _tmp62_;
	const gchar* _tmp63_;
#line 285 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data19_ = g_slice_new0 (Block19Data);
#line 285 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data19_->_ref_count_ = 1;
#line 285 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data19_->self = g_object_ref (self);
#line 287 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 287 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data19_->loop = _tmp0_;
#line 289 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_checkout_branch ((GitgTestRepository*) self, "not_master");
#line 290 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "c", "c file other content\n", NULL);
#line 292 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp1_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "not_master");
#line 292 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->not_master);
#line 292 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self->priv->not_master = _tmp1_;
#line 293 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_checkout_branch ((GitgTestRepository*) self, "master");
#line 295 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp2_ = self->priv->action_interface;
#line 295 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp3_ = self->priv->theirs_commit;
#line 295 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp4_ = gitg_commit_action_cherry_pick_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp2_, _tmp3_);
#line 295 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data19_->action = _tmp4_;
#line 297 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp5_ = gitg_ext_user_query_new_full ("Cherry pick has conflicts", "The cherry-pick of '72af7c' onto 'not_master' has caused conflicts, wo" \
"uld you like to checkout the cherry pick to your working directory to " \
"resolve the conflicts?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Checkout", GTK_RESPONSE_OK, NULL);
#line 297 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp6_ = _tmp5_;
#line 297 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp7_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp6_, GTK_RESPONSE_OK);
#line 297 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp8_ = _tmp7_;
#line 297 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp8_);
#line 297 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp6_);
#line 306 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp9_ = gitg_ext_user_query_new_full ("Unstaged changes", "You appear to have unstaged changes in your working directory. Would y" \
"ou like to stash the changes before the checkout?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Stash changes", GTK_RESPONSE_OK, NULL);
#line 306 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp10_ = _tmp9_;
#line 306 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp11_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp10_, GTK_RESPONSE_OK);
#line 306 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp12_ = _tmp11_;
#line 306 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp12_);
#line 306 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp10_);
#line 315 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp13_ = self->priv->not_master;
#line 315 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick (_data19_->action, (GitgRef*) _tmp13_, ___lambda39__gasync_ready_callback, block19_data_ref (_data19_));
#line 320 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_run (_data19_->loop);
#line 322 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp14_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 322 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp15_ = _tmp14_;
#line 322 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp16_ = _tmp15_;
#line 322 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp17_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp16_);
#line 322 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp18_ = _tmp17_;
#line 322 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq (_tmp18_, 2);
#line 322 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp16_);
#line 324 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp19_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 324 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp20_ = _tmp19_;
#line 324 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp21_ = _tmp20_;
#line 324 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, 0);
#line 324 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp23_ = (GitgSimpleNotification*) _tmp22_;
#line 324 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp24_ = gitg_simple_notification_get_title (_tmp23_);
#line 324 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp25_ = _tmp24_;
#line 324 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp25_, "Cherry pick '72af7c' onto 'not_master'");
#line 324 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp23_);
#line 324 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp21_);
#line 325 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp26_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 325 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp27_ = _tmp26_;
#line 325 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp28_ = _tmp27_;
#line 325 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, 0);
#line 325 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp30_ = (GitgSimpleNotification*) _tmp29_;
#line 325 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp31_ = gitg_simple_notification_get_message (_tmp30_);
#line 325 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp32_ = _tmp31_;
#line 325 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp32_, "Cherry pick finished with conflicts in working directory");
#line 325 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp30_);
#line 325 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp28_);
#line 326 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp33_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 326 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp34_ = _tmp33_;
#line 326 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp35_ = _tmp34_;
#line 326 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, 0);
#line 326 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp37_ = (GitgSimpleNotification*) _tmp36_;
#line 326 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp38_ = gitg_simple_notification_get_status (_tmp37_);
#line 326 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp39_ = _tmp38_;
#line 326 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp39_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 326 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp37_);
#line 326 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp35_);
#line 328 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp40_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 328 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp41_ = _tmp40_;
#line 328 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp42_ = _tmp41_;
#line 328 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, 1);
#line 328 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp44_ = (GitgSimpleNotification*) _tmp43_;
#line 328 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp45_ = gitg_simple_notification_get_title (_tmp44_);
#line 328 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp46_ = _tmp45_;
#line 328 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp46_, "Checkout 'not_master'");
#line 328 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp44_);
#line 328 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp42_);
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp47_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp48_ = _tmp47_;
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp49_ = _tmp48_;
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp50_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, 1);
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp51_ = (GitgSimpleNotification*) _tmp50_;
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp52_ = gitg_simple_notification_get_message (_tmp51_);
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp53_ = _tmp52_;
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp53_, "Successfully checked out branch to working directory");
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp51_);
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp49_);
#line 330 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp54_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 330 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp55_ = _tmp54_;
#line 330 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp56_ = _tmp55_;
#line 330 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp57_ = gee_abstract_list_get ((GeeAbstractList*) _tmp56_, 1);
#line 330 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp58_ = (GitgSimpleNotification*) _tmp57_;
#line 330 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp59_ = gitg_simple_notification_get_status (_tmp58_);
#line 330 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp60_ = _tmp59_;
#line 330 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp60_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 330 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp58_);
#line 330 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp56_);
#line 332 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp61_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "HEAD");
#line 332 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp62_ = _tmp61_;
#line 332 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp63_ = ggit_ref_get_name ((GgitRef*) _tmp62_);
#line 332 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp63_, "refs/heads/not_master");
#line 332 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp62_);
#line 334 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 335 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file\n");
#line 336 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "c", "<<<<<<< ours\n" \
"c file other content\n" \
"=======\n" \
"c file\n" \
">>>>>>> theirs\n");
#line 338 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, ".git/CHERRY_PICK_HEAD", "72af7ccf47852d832b06c7244de8ae9ded639024\n");
#line 285 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block19_data_unref (_data19_);
#line 285 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data19_ = NULL;
#line 2701 "test-cherry-pick-commit.c"
}


static Block20Data* block20_data_ref (Block20Data* _data20_) {
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_atomic_int_inc (&_data20_->_ref_count_);
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return _data20_;
#line 2710 "test-cherry-pick-commit.c"
}


static void block20_data_unref (void * _userdata_) {
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
#line 2719 "test-cherry-pick-commit.c"
		GitgTestCherryPickCommit* self;
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		self = _data20_->self;
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_data20_->oids = (_vala_array_free (_data20_->oids, _data20_->oids_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_data20_->messages = (_vala_array_free (_data20_->messages, _data20_->messages_length1, (GDestroyNotify) g_free), NULL);
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (_data20_->action);
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_main_loop_unref0 (_data20_->loop);
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (self);
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_slice_free (Block20Data, _data20_);
#line 2735 "test-cherry-pick-commit.c"
	}
}


static void __lambda40_ (Block20Data* _data20_, GObject* obj, GAsyncResult* res) {
	GitgTestCherryPickCommit* self;
	GAsyncResult* _tmp0_;
#line 373 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self = _data20_->self;
#line 373 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_return_if_fail (res != NULL);
#line 374 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = res;
#line 374 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick_finish (_data20_->action, _tmp0_);
#line 375 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_quit (_data20_->loop);
#line 2753 "test-cherry-pick-commit.c"
}


static void ___lambda40__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 373 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	__lambda40_ (self, source_object, res);
#line 373 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block20_data_unref (self);
#line 2762 "test-cherry-pick-commit.c"
}


static void _vala_array_add7 (gchar** * array, int* length, int* size, gchar* value) {
#line 402 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if ((*length) == (*size)) {
#line 402 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 402 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 2773 "test-cherry-pick-commit.c"
	}
#line 402 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	(*array)[(*length)++] = value;
#line 402 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	(*array)[*length] = NULL;
#line 2779 "test-cherry-pick-commit.c"
}


static void _vala_array_add8 (GgitOId** * array, int* length, int* size, GgitOId* value) {
#line 403 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if ((*length) == (*size)) {
#line 403 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 403 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		*array = g_renew (GgitOId*, *array, (*size) + 1);
#line 2790 "test-cherry-pick-commit.c"
	}
#line 403 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	(*array)[(*length)++] = value;
#line 403 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	(*array)[*length] = NULL;
#line 2796 "test-cherry-pick-commit.c"
}


static gint __lambda41_ (Block20Data* _data20_, gsize index, const gchar* message, GgitOId* oid) {
	GitgTestCherryPickCommit* self;
	gint result = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GgitOId* _tmp2_;
	GgitOId* _tmp3_;
#line 401 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self = _data20_->self;
#line 401 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_return_val_if_fail (message != NULL, 0);
#line 401 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_return_val_if_fail (oid != NULL, 0);
#line 402 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = message;
#line 402 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 402 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_vala_array_add7 (&_data20_->messages, &_data20_->messages_length1, &_data20_->_messages_size_, _tmp1_);
#line 403 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp2_ = oid;
#line 403 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp3_ = __vala_GgitOId_copy0 (_tmp2_);
#line 403 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_vala_array_add8 (&_data20_->oids, &_data20_->oids_length1, &_data20_->_oids_size_, _tmp3_);
#line 405 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	result = 0;
#line 405 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return result;
#line 2829 "test-cherry-pick-commit.c"
}


static gint ___lambda41__ggit_stash_callback (gsize index, const gchar* message, GgitOId* stash_oid, gpointer self) {
	gint result;
	result = __lambda41_ (self, index, message, stash_oid);
#line 401 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return result;
#line 2838 "test-cherry-pick-commit.c"
}


static void gitg_test_cherry_pick_commit_real_test_cherry_pick_theirs_not_master_conflicts_checkout_dirty (GitgTestCherryPickCommit* self) {
	Block20Data* _data20_;
	GMainLoop* _tmp0_;
	GitgBranch* _tmp1_;
	GitgTestRefActionInterface* _tmp2_;
	GitgCommit* _tmp3_;
	GitgCommitActionCherryPick* _tmp4_;
	GitgExtUserQuery* _tmp5_;
	GitgExtUserQuery* _tmp6_;
	GitgTestApplication* _tmp7_;
	GitgTestApplication* _tmp8_;
	GitgExtUserQuery* _tmp9_;
	GitgExtUserQuery* _tmp10_;
	GitgTestApplication* _tmp11_;
	GitgTestApplication* _tmp12_;
	GitgBranch* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GeeArrayList* _tmp19_;
	GeeArrayList* _tmp20_;
	GeeArrayList* _tmp21_;
	gpointer _tmp22_;
	GitgSimpleNotification* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	GeeArrayList* _tmp26_;
	GeeArrayList* _tmp27_;
	GeeArrayList* _tmp28_;
	gpointer _tmp29_;
	GitgSimpleNotification* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GeeArrayList* _tmp33_;
	GeeArrayList* _tmp34_;
	GeeArrayList* _tmp35_;
	gpointer _tmp36_;
	GitgSimpleNotification* _tmp37_;
	GitgSimpleNotificationStatus _tmp38_;
	GitgSimpleNotificationStatus _tmp39_;
	GeeArrayList* _tmp40_;
	GeeArrayList* _tmp41_;
	GeeArrayList* _tmp42_;
	gpointer _tmp43_;
	GitgSimpleNotification* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	GeeArrayList* _tmp47_;
	GeeArrayList* _tmp48_;
	GeeArrayList* _tmp49_;
	gpointer _tmp50_;
	GitgSimpleNotification* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	GeeArrayList* _tmp54_;
	GeeArrayList* _tmp55_;
	GeeArrayList* _tmp56_;
	gpointer _tmp57_;
	GitgSimpleNotification* _tmp58_;
	GitgSimpleNotificationStatus _tmp59_;
	GitgSimpleNotificationStatus _tmp60_;
	GitgBranch* _tmp61_;
	GitgBranch* _tmp62_;
	const gchar* _tmp63_;
	gchar** _tmp64_;
	GgitOId** _tmp65_;
	GitgRepository* _tmp66_;
	const gchar* _tmp67_;
	GgitOId* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	GError * _inner_error_ = NULL;
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data20_ = g_slice_new0 (Block20Data);
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data20_->_ref_count_ = 1;
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data20_->self = g_object_ref (self);
#line 343 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 343 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data20_->loop = _tmp0_;
#line 345 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_checkout_branch ((GitgTestRepository*) self, "not_master");
#line 346 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "c", "c file other content\n", NULL);
#line 348 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp1_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "not_master");
#line 348 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->not_master);
#line 348 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self->priv->not_master = _tmp1_;
#line 349 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_checkout_branch ((GitgTestRepository*) self, "master");
#line 351 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_write_file ((GitgTestRepository*) self, "b", "b file other content\n");
#line 353 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp2_ = self->priv->action_interface;
#line 353 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp3_ = self->priv->theirs_commit;
#line 353 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp4_ = gitg_commit_action_cherry_pick_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp2_, _tmp3_);
#line 353 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data20_->action = _tmp4_;
#line 355 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp5_ = gitg_ext_user_query_new_full ("Cherry pick has conflicts", "The cherry-pick of '72af7c' onto 'not_master' has caused conflicts, wo" \
"uld you like to checkout the cherry pick to your working directory to " \
"resolve the conflicts?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Checkout", GTK_RESPONSE_OK, NULL);
#line 355 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp6_ = _tmp5_;
#line 355 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp7_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp6_, GTK_RESPONSE_OK);
#line 355 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp8_ = _tmp7_;
#line 355 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp8_);
#line 355 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp6_);
#line 364 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp9_ = gitg_ext_user_query_new_full ("Unstaged changes", "You appear to have unstaged changes in your working directory. Would y" \
"ou like to stash the changes before the checkout?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Stash changes", GTK_RESPONSE_OK, NULL);
#line 364 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp10_ = _tmp9_;
#line 364 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp11_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp10_, GTK_RESPONSE_OK);
#line 364 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp12_ = _tmp11_;
#line 364 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp12_);
#line 364 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp10_);
#line 373 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp13_ = self->priv->not_master;
#line 373 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick (_data20_->action, (GitgRef*) _tmp13_, ___lambda40__gasync_ready_callback, block20_data_ref (_data20_));
#line 378 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_run (_data20_->loop);
#line 380 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp14_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 380 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp15_ = _tmp14_;
#line 380 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp16_ = _tmp15_;
#line 380 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp17_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp16_);
#line 380 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp18_ = _tmp17_;
#line 380 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq (_tmp18_, 2);
#line 380 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp16_);
#line 382 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp19_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 382 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp20_ = _tmp19_;
#line 382 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp21_ = _tmp20_;
#line 382 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, 0);
#line 382 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp23_ = (GitgSimpleNotification*) _tmp22_;
#line 382 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp24_ = gitg_simple_notification_get_title (_tmp23_);
#line 382 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp25_ = _tmp24_;
#line 382 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp25_, "Cherry pick '72af7c' onto 'not_master'");
#line 382 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp23_);
#line 382 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp21_);
#line 383 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp26_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 383 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp27_ = _tmp26_;
#line 383 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp28_ = _tmp27_;
#line 383 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, 0);
#line 383 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp30_ = (GitgSimpleNotification*) _tmp29_;
#line 383 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp31_ = gitg_simple_notification_get_message (_tmp30_);
#line 383 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp32_ = _tmp31_;
#line 383 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp32_, "Cherry pick finished with conflicts in working directory");
#line 383 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp30_);
#line 383 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp28_);
#line 384 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp33_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 384 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp34_ = _tmp33_;
#line 384 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp35_ = _tmp34_;
#line 384 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, 0);
#line 384 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp37_ = (GitgSimpleNotification*) _tmp36_;
#line 384 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp38_ = gitg_simple_notification_get_status (_tmp37_);
#line 384 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp39_ = _tmp38_;
#line 384 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp39_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 384 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp37_);
#line 384 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp35_);
#line 386 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp40_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 386 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp41_ = _tmp40_;
#line 386 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp42_ = _tmp41_;
#line 386 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, 1);
#line 386 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp44_ = (GitgSimpleNotification*) _tmp43_;
#line 386 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp45_ = gitg_simple_notification_get_title (_tmp44_);
#line 386 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp46_ = _tmp45_;
#line 386 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp46_, "Checkout 'not_master'");
#line 386 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp44_);
#line 386 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp42_);
#line 387 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp47_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 387 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp48_ = _tmp47_;
#line 387 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp49_ = _tmp48_;
#line 387 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp50_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, 1);
#line 387 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp51_ = (GitgSimpleNotification*) _tmp50_;
#line 387 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp52_ = gitg_simple_notification_get_message (_tmp51_);
#line 387 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp53_ = _tmp52_;
#line 387 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp53_, "Successfully checked out branch to working directory");
#line 387 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp51_);
#line 387 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp49_);
#line 388 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp54_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 388 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp55_ = _tmp54_;
#line 388 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp56_ = _tmp55_;
#line 388 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp57_ = gee_abstract_list_get ((GeeAbstractList*) _tmp56_, 1);
#line 388 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp58_ = (GitgSimpleNotification*) _tmp57_;
#line 388 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp59_ = gitg_simple_notification_get_status (_tmp58_);
#line 388 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp60_ = _tmp59_;
#line 388 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp60_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 388 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp58_);
#line 388 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp56_);
#line 390 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp61_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "HEAD");
#line 390 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp62_ = _tmp61_;
#line 390 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp63_ = ggit_ref_get_name ((GgitRef*) _tmp62_);
#line 390 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp63_, "refs/heads/not_master");
#line 390 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp62_);
#line 392 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 393 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file\n");
#line 394 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "c", "<<<<<<< ours\n" \
"c file other content\n" \
"=======\n" \
"c file\n" \
">>>>>>> theirs\n");
#line 396 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, ".git/CHERRY_PICK_HEAD", "72af7ccf47852d832b06c7244de8ae9ded639024\n");
#line 398 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp64_ = g_new0 (gchar*, 0 + 1);
#line 398 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data20_->messages = _tmp64_;
#line 398 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data20_->messages_length1 = 0;
#line 398 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data20_->_messages_size_ = _data20_->messages_length1;
#line 399 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp65_ = g_new0 (GgitOId*, 0 + 1);
#line 399 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data20_->oids = _tmp65_;
#line 399 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data20_->oids_length1 = 0;
#line 399 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data20_->_oids_size_ = _data20_->oids_length1;
#line 401 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp66_ = ((GitgTestRepository*) self)->d_repository;
#line 401 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	ggit_repository_stash_foreach ((GgitRepository*) _tmp66_, ___lambda41__ggit_stash_callback, _data20_, &_inner_error_);
#line 401 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 401 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		block20_data_unref (_data20_);
#line 401 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_data20_ = NULL;
#line 401 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 401 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_clear_error (&_inner_error_);
#line 401 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		return;
#line 3162 "test-cherry-pick-commit.c"
	}
#line 408 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq (_data20_->messages_length1, 1);
#line 409 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp67_ = _data20_->messages[0];
#line 409 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp67_, "On master: WIP on HEAD");
#line 410 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp68_ = _data20_->oids[0];
#line 410 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp69_ = ggit_oid_to_string (_tmp68_);
#line 410 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp70_ = _tmp69_;
#line 410 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp70_, "147b7b7b6ad2f9c90f4c93f3bfda78c78ec2dcde");
#line 410 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_free0 (_tmp70_);
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block20_data_unref (_data20_);
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data20_ = NULL;
#line 3184 "test-cherry-pick-commit.c"
}


static Block21Data* block21_data_ref (Block21Data* _data21_) {
#line 413 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_atomic_int_inc (&_data21_->_ref_count_);
#line 413 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return _data21_;
#line 3193 "test-cherry-pick-commit.c"
}


static void block21_data_unref (void * _userdata_) {
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
#line 413 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
#line 3202 "test-cherry-pick-commit.c"
		GitgTestCherryPickCommit* self;
#line 413 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		self = _data21_->self;
#line 413 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (_data21_->action);
#line 413 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_main_loop_unref0 (_data21_->loop);
#line 413 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_g_object_unref0 (self);
#line 413 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_slice_free (Block21Data, _data21_);
#line 3214 "test-cherry-pick-commit.c"
	}
}


static void __lambda42_ (Block21Data* _data21_, GObject* obj, GAsyncResult* res) {
	GitgTestCherryPickCommit* self;
	GAsyncResult* _tmp0_;
#line 445 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self = _data21_->self;
#line 445 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_return_if_fail (res != NULL);
#line 446 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = res;
#line 446 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick_finish (_data21_->action, _tmp0_);
#line 447 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_quit (_data21_->loop);
#line 3232 "test-cherry-pick-commit.c"
}


static void ___lambda42__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 445 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	__lambda42_ (self, source_object, res);
#line 445 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block21_data_unref (self);
#line 3241 "test-cherry-pick-commit.c"
}


static gint __lambda43_ (GitgTestCherryPickCommit* self, gsize index, const gchar* message, GgitOId* oid) {
	gint result = 0;
#line 469 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_return_val_if_fail (message != NULL, 0);
#line 469 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_return_val_if_fail (oid != NULL, 0);
#line 470 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_vala_assert (FALSE, "false");
#line 471 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	result = 0;
#line 471 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return result;
#line 3257 "test-cherry-pick-commit.c"
}


static gint ___lambda43__ggit_stash_callback (gsize index, const gchar* message, GgitOId* stash_oid, gpointer self) {
	gint result;
	result = __lambda43_ ((GitgTestCherryPickCommit*) self, index, message, stash_oid);
#line 469 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	return result;
#line 3266 "test-cherry-pick-commit.c"
}


static void gitg_test_cherry_pick_commit_real_test_cherry_pick_theirs_not_master_conflicts_checkout_dirty_no_stash (GitgTestCherryPickCommit* self) {
	Block21Data* _data21_;
	GMainLoop* _tmp0_;
	GitgBranch* _tmp1_;
	GitgTestRefActionInterface* _tmp2_;
	GitgCommit* _tmp3_;
	GitgCommitActionCherryPick* _tmp4_;
	GitgExtUserQuery* _tmp5_;
	GitgExtUserQuery* _tmp6_;
	GitgTestApplication* _tmp7_;
	GitgTestApplication* _tmp8_;
	GitgExtUserQuery* _tmp9_;
	GitgExtUserQuery* _tmp10_;
	GitgTestApplication* _tmp11_;
	GitgTestApplication* _tmp12_;
	GitgBranch* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GeeArrayList* _tmp19_;
	GeeArrayList* _tmp20_;
	GeeArrayList* _tmp21_;
	gpointer _tmp22_;
	GitgSimpleNotification* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	GeeArrayList* _tmp26_;
	GeeArrayList* _tmp27_;
	GeeArrayList* _tmp28_;
	gpointer _tmp29_;
	GitgSimpleNotification* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GeeArrayList* _tmp33_;
	GeeArrayList* _tmp34_;
	GeeArrayList* _tmp35_;
	gpointer _tmp36_;
	GitgSimpleNotification* _tmp37_;
	GitgSimpleNotificationStatus _tmp38_;
	GitgSimpleNotificationStatus _tmp39_;
	GitgBranch* _tmp40_;
	GitgBranch* _tmp41_;
	const gchar* _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	gboolean _tmp47_;
	GitgRepository* _tmp48_;
	GError * _inner_error_ = NULL;
#line 413 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data21_ = g_slice_new0 (Block21Data);
#line 413 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data21_->_ref_count_ = 1;
#line 413 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data21_->self = g_object_ref (self);
#line 415 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 415 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data21_->loop = _tmp0_;
#line 417 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_checkout_branch ((GitgTestRepository*) self, "not_master");
#line 418 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "c", "c file other content\n", NULL);
#line 420 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp1_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "not_master");
#line 420 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->not_master);
#line 420 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self->priv->not_master = _tmp1_;
#line 421 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_checkout_branch ((GitgTestRepository*) self, "master");
#line 423 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_write_file ((GitgTestRepository*) self, "b", "b file other content\n");
#line 425 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp2_ = self->priv->action_interface;
#line 425 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp3_ = self->priv->theirs_commit;
#line 425 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp4_ = gitg_commit_action_cherry_pick_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp2_, _tmp3_);
#line 425 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data21_->action = _tmp4_;
#line 427 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp5_ = gitg_ext_user_query_new_full ("Cherry pick has conflicts", "The cherry-pick of '72af7c' onto 'not_master' has caused conflicts, wo" \
"uld you like to checkout the cherry pick to your working directory to " \
"resolve the conflicts?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Checkout", GTK_RESPONSE_OK, NULL);
#line 427 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp6_ = _tmp5_;
#line 427 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp7_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp6_, GTK_RESPONSE_OK);
#line 427 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp8_ = _tmp7_;
#line 427 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp8_);
#line 427 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp6_);
#line 436 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp9_ = gitg_ext_user_query_new_full ("Unstaged changes", "You appear to have unstaged changes in your working directory. Would y" \
"ou like to stash the changes before the checkout?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Stash changes", GTK_RESPONSE_OK, NULL);
#line 436 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp10_ = _tmp9_;
#line 436 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp11_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp10_, GTK_RESPONSE_CANCEL);
#line 436 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp12_ = _tmp11_;
#line 436 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp12_);
#line 436 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp10_);
#line 445 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp13_ = self->priv->not_master;
#line 445 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_commit_action_cherry_pick_cherry_pick (_data21_->action, (GitgRef*) _tmp13_, ___lambda42__gasync_ready_callback, block21_data_ref (_data21_));
#line 450 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_main_loop_run (_data21_->loop);
#line 452 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp14_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 452 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp15_ = _tmp14_;
#line 452 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp16_ = _tmp15_;
#line 452 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp17_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp16_);
#line 452 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp18_ = _tmp17_;
#line 452 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq (_tmp18_, 1);
#line 452 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp16_);
#line 454 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp19_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 454 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp20_ = _tmp19_;
#line 454 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp21_ = _tmp20_;
#line 454 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, 0);
#line 454 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp23_ = (GitgSimpleNotification*) _tmp22_;
#line 454 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp24_ = gitg_simple_notification_get_title (_tmp23_);
#line 454 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp25_ = _tmp24_;
#line 454 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp25_, "Cherry pick '72af7c' onto 'not_master'");
#line 454 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp23_);
#line 454 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp21_);
#line 455 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp26_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 455 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp27_ = _tmp26_;
#line 455 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp28_ = _tmp27_;
#line 455 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, 0);
#line 455 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp30_ = (GitgSimpleNotification*) _tmp29_;
#line 455 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp31_ = gitg_simple_notification_get_message (_tmp30_);
#line 455 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp32_ = _tmp31_;
#line 455 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp32_, "Failed with conflicts");
#line 455 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp30_);
#line 455 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp28_);
#line 456 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp33_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 456 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp34_ = _tmp33_;
#line 456 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp35_ = _tmp34_;
#line 456 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, 0);
#line 456 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp37_ = (GitgSimpleNotification*) _tmp36_;
#line 456 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp38_ = gitg_simple_notification_get_status (_tmp37_);
#line 456 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp39_ = _tmp38_;
#line 456 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp39_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_ERROR);
#line 456 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp37_);
#line 456 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp35_);
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp40_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "HEAD");
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp41_ = _tmp40_;
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp42_ = ggit_ref_get_name ((GgitRef*) _tmp41_);
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_assert_assert_streq (_tmp42_, "refs/heads/master");
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (_tmp41_);
#line 460 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 461 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file other content\n");
#line 462 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp43_ = gitg_test_repository_file_exists ((GitgTestRepository*) self, "c");
#line 462 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_vala_assert (!_tmp43_, "!file_exists(\"c\")");
#line 464 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp44_ = gitg_test_repository_file_exists ((GitgTestRepository*) self, ".git/ORIG_HEAD");
#line 464 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_vala_assert (!_tmp44_, "!file_exists(\".git/ORIG_HEAD\")");
#line 465 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp45_ = gitg_test_repository_file_exists ((GitgTestRepository*) self, ".git/MERGE_HEAD");
#line 465 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_vala_assert (!_tmp45_, "!file_exists(\".git/MERGE_HEAD\")");
#line 466 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp46_ = gitg_test_repository_file_exists ((GitgTestRepository*) self, ".git/MERGE_MODE");
#line 466 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_vala_assert (!_tmp46_, "!file_exists(\".git/MERGE_MODE\")");
#line 467 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp47_ = gitg_test_repository_file_exists ((GitgTestRepository*) self, ".git/MERGE_MSG");
#line 467 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_vala_assert (!_tmp47_, "!file_exists(\".git/MERGE_MSG\")");
#line 469 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_tmp48_ = ((GitgTestRepository*) self)->d_repository;
#line 469 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	ggit_repository_stash_foreach ((GgitRepository*) _tmp48_, ___lambda43__ggit_stash_callback, self, &_inner_error_);
#line 469 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 469 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		block21_data_unref (_data21_);
#line 469 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		_data21_ = NULL;
#line 469 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 469 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		g_clear_error (&_inner_error_);
#line 469 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
		return;
#line 3508 "test-cherry-pick-commit.c"
	}
#line 413 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	block21_data_unref (_data21_);
#line 413 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_data21_ = NULL;
#line 3514 "test-cherry-pick-commit.c"
}


static void gitg_test_cherry_pick_commit_class_init (GitgTestCherryPickCommitClass * klass) {
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_cherry_pick_commit_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	g_type_class_add_private (klass, sizeof (GitgTestCherryPickCommitPrivate));
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	((GitgTestTestClass *) klass)->set_up = gitg_test_cherry_pick_commit_real_set_up;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	((GitgTestCherryPickCommitClass *) klass)->test_cherry_pick_simple = gitg_test_cherry_pick_commit_real_test_cherry_pick_simple;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	((GitgTestCherryPickCommitClass *) klass)->test_cherry_pick_not_head = gitg_test_cherry_pick_commit_real_test_cherry_pick_not_head;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	((GitgTestCherryPickCommitClass *) klass)->test_cherry_pick_not_head_would_have_conflicted = gitg_test_cherry_pick_commit_real_test_cherry_pick_not_head_would_have_conflicted;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	((GitgTestCherryPickCommitClass *) klass)->test_cherry_pick_theirs_conflicts_no_checkout = gitg_test_cherry_pick_commit_real_test_cherry_pick_theirs_conflicts_no_checkout;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	((GitgTestCherryPickCommitClass *) klass)->test_merge_theirs_conflicts_checkout = gitg_test_cherry_pick_commit_real_test_merge_theirs_conflicts_checkout;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	((GitgTestCherryPickCommitClass *) klass)->test_cherry_pick_theirs_dirty_stash = gitg_test_cherry_pick_commit_real_test_cherry_pick_theirs_dirty_stash;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	((GitgTestCherryPickCommitClass *) klass)->test_cherry_pick_theirs_not_master_conflicts_checkout = gitg_test_cherry_pick_commit_real_test_cherry_pick_theirs_not_master_conflicts_checkout;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	((GitgTestCherryPickCommitClass *) klass)->test_cherry_pick_theirs_not_master_conflicts_checkout_dirty = gitg_test_cherry_pick_commit_real_test_cherry_pick_theirs_not_master_conflicts_checkout_dirty;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	((GitgTestCherryPickCommitClass *) klass)->test_cherry_pick_theirs_not_master_conflicts_checkout_dirty_no_stash = gitg_test_cherry_pick_commit_real_test_cherry_pick_theirs_not_master_conflicts_checkout_dirty_no_stash;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_test_cherry_pick_commit_finalize;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_cherry_pick_commit_signals[GITG_TEST_CHERRY_PICK_COMMIT_TEST_CHERRY_PICK_SIMPLE_SIGNAL] = g_signal_new ("test_cherry_pick_simple", GITG_TEST_TYPE_CHERRY_PICK_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCherryPickCommitClass, test_cherry_pick_simple), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_cherry_pick_commit_signals[GITG_TEST_CHERRY_PICK_COMMIT_TEST_CHERRY_PICK_NOT_HEAD_SIGNAL] = g_signal_new ("test_cherry_pick_not_head", GITG_TEST_TYPE_CHERRY_PICK_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCherryPickCommitClass, test_cherry_pick_not_head), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_cherry_pick_commit_signals[GITG_TEST_CHERRY_PICK_COMMIT_TEST_CHERRY_PICK_NOT_HEAD_WOULD_HAVE_CONFLICTED_SIGNAL] = g_signal_new ("test_cherry_pick_not_head_would_have_conflicted", GITG_TEST_TYPE_CHERRY_PICK_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCherryPickCommitClass, test_cherry_pick_not_head_would_have_conflicted), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_cherry_pick_commit_signals[GITG_TEST_CHERRY_PICK_COMMIT_TEST_CHERRY_PICK_THEIRS_CONFLICTS_NO_CHECKOUT_SIGNAL] = g_signal_new ("test_cherry_pick_theirs_conflicts_no_checkout", GITG_TEST_TYPE_CHERRY_PICK_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCherryPickCommitClass, test_cherry_pick_theirs_conflicts_no_checkout), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_cherry_pick_commit_signals[GITG_TEST_CHERRY_PICK_COMMIT_TEST_MERGE_THEIRS_CONFLICTS_CHECKOUT_SIGNAL] = g_signal_new ("test_merge_theirs_conflicts_checkout", GITG_TEST_TYPE_CHERRY_PICK_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCherryPickCommitClass, test_merge_theirs_conflicts_checkout), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_cherry_pick_commit_signals[GITG_TEST_CHERRY_PICK_COMMIT_TEST_CHERRY_PICK_THEIRS_DIRTY_STASH_SIGNAL] = g_signal_new ("test_cherry_pick_theirs_dirty_stash", GITG_TEST_TYPE_CHERRY_PICK_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCherryPickCommitClass, test_cherry_pick_theirs_dirty_stash), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_cherry_pick_commit_signals[GITG_TEST_CHERRY_PICK_COMMIT_TEST_CHERRY_PICK_THEIRS_NOT_MASTER_CONFLICTS_CHECKOUT_SIGNAL] = g_signal_new ("test_cherry_pick_theirs_not_master_conflicts_checkout", GITG_TEST_TYPE_CHERRY_PICK_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCherryPickCommitClass, test_cherry_pick_theirs_not_master_conflicts_checkout), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_cherry_pick_commit_signals[GITG_TEST_CHERRY_PICK_COMMIT_TEST_CHERRY_PICK_THEIRS_NOT_MASTER_CONFLICTS_CHECKOUT_DIRTY_SIGNAL] = g_signal_new ("test_cherry_pick_theirs_not_master_conflicts_checkout_dirty", GITG_TEST_TYPE_CHERRY_PICK_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCherryPickCommitClass, test_cherry_pick_theirs_not_master_conflicts_checkout_dirty), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	gitg_test_cherry_pick_commit_signals[GITG_TEST_CHERRY_PICK_COMMIT_TEST_CHERRY_PICK_THEIRS_NOT_MASTER_CONFLICTS_CHECKOUT_DIRTY_NO_STASH_SIGNAL] = g_signal_new ("test_cherry_pick_theirs_not_master_conflicts_checkout_dirty_no_stash", GITG_TEST_TYPE_CHERRY_PICK_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCherryPickCommitClass, test_cherry_pick_theirs_not_master_conflicts_checkout_dirty_no_stash), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3563 "test-cherry-pick-commit.c"
}


static void gitg_test_cherry_pick_commit_instance_init (GitgTestCherryPickCommit * self) {
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self->priv = GITG_TEST_CHERRY_PICK_COMMIT_GET_PRIVATE (self);
#line 3570 "test-cherry-pick-commit.c"
}


static void gitg_test_cherry_pick_commit_finalize (GObject * obj) {
	GitgTestCherryPickCommit * self;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TEST_TYPE_CHERRY_PICK_COMMIT, GitgTestCherryPickCommit);
#line 24 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->ours);
#line 26 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->theirs);
#line 27 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->theirs_commit);
#line 29 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->master);
#line 30 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->master_commit);
#line 32 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->not_master);
#line 34 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	_g_object_unref0 (self->priv->action_interface);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/gitg/test-cherry-pick-commit.vala"
	G_OBJECT_CLASS (gitg_test_cherry_pick_commit_parent_class)->finalize (obj);
#line 3594 "test-cherry-pick-commit.c"
}


GType gitg_test_cherry_pick_commit_get_type (void) {
	static volatile gsize gitg_test_cherry_pick_commit_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_test_cherry_pick_commit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgTestCherryPickCommitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_test_cherry_pick_commit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgTestCherryPickCommit), 0, (GInstanceInitFunc) gitg_test_cherry_pick_commit_instance_init, NULL };
		GType gitg_test_cherry_pick_commit_type_id;
		gitg_test_cherry_pick_commit_type_id = g_type_register_static (GITG_TEST_TYPE_APPLICATION, "GitgTestCherryPickCommit", &g_define_type_info, 0);
		g_once_init_leave (&gitg_test_cherry_pick_commit_type_id__volatile, gitg_test_cherry_pick_commit_type_id);
	}
	return gitg_test_cherry_pick_commit_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



