/* nibbles-view.c generated by valac 0.32.0.61-f103e, the Vala compiler
 * generated from nibbles-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <clutter-gtk/clutter-gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <canberra-gtk.h>
#include <canberra.h>


#define TYPE_WORM_ACTOR (worm_actor_get_type ())
#define WORM_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_ACTOR, WormActor))
#define WORM_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_ACTOR, WormActorClass))
#define IS_WORM_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_ACTOR))
#define IS_WORM_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_ACTOR))
#define WORM_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_ACTOR, WormActorClass))

typedef struct _WormActor WormActor;
typedef struct _WormActorClass WormActorClass;
typedef struct _WormActorPrivate WormActorPrivate;

#define TYPE_BONUS_TEXTURE (bonus_texture_get_type ())
#define BONUS_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS_TEXTURE, BonusTexture))
#define BONUS_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS_TEXTURE, BonusTextureClass))
#define IS_BONUS_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS_TEXTURE))
#define IS_BONUS_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS_TEXTURE))
#define BONUS_TEXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS_TEXTURE, BonusTextureClass))

typedef struct _BonusTexture BonusTexture;
typedef struct _BonusTextureClass BonusTextureClass;
typedef struct _BonusTexturePrivate BonusTexturePrivate;

#define TYPE_WARP_TEXTURE (warp_texture_get_type ())
#define WARP_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_TEXTURE, WarpTexture))
#define WARP_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_TEXTURE, WarpTextureClass))
#define IS_WARP_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_TEXTURE))
#define IS_WARP_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_TEXTURE))
#define WARP_TEXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_TEXTURE, WarpTextureClass))

typedef struct _WarpTexture WarpTexture;
typedef struct _WarpTextureClass WarpTextureClass;
typedef struct _WarpTexturePrivate WarpTexturePrivate;

#define TYPE_NIBBLES_VIEW (nibbles_view_get_type ())
#define NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_VIEW, NibblesView))
#define NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_VIEW, NibblesViewClass))
#define IS_NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_VIEW))
#define IS_NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_VIEW))
#define NIBBLES_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_VIEW, NibblesViewClass))

typedef struct _NibblesView NibblesView;
typedef struct _NibblesViewClass NibblesViewClass;
typedef struct _NibblesViewPrivate NibblesViewPrivate;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_BONUS (bonus_get_type ())
#define BONUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS, Bonus))
#define BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS, BonusClass))
#define IS_BONUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS))
#define IS_BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS))
#define BONUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS, BonusClass))

typedef struct _Bonus Bonus;
typedef struct _BonusClass BonusClass;

#define TYPE_WARP (warp_get_type ())
#define WARP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP, Warp))
#define WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP, WarpClass))
#define IS_WARP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP))
#define IS_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP))
#define WARP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP, WarpClass))

typedef struct _Warp Warp;
typedef struct _WarpClass WarpClass;

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

#define TYPE_BONI (boni_get_type ())
#define BONI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONI, Boni))
#define BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONI, BoniClass))
#define IS_BONI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONI))
#define IS_BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONI))
#define BONI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONI, BoniClass))

typedef struct _Boni Boni;
typedef struct _BoniClass BoniClass;

#define TYPE_WARP_MANAGER (warp_manager_get_type ())
#define WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_MANAGER, WarpManager))
#define WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_MANAGER, WarpManagerClass))
#define IS_WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_MANAGER))
#define IS_WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_MANAGER))
#define WARP_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_MANAGER, WarpManagerClass))

typedef struct _WarpManager WarpManager;
typedef struct _WarpManagerClass WarpManagerClass;
typedef struct _WarpManagerPrivate WarpManagerPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _NibblesGamePrivate NibblesGamePrivate;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block6Data Block6Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _WormPrivate WormPrivate;

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;
#define _position_free0(var) ((var == NULL) ? NULL : (var = (position_free (var), NULL)))

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;
#define _worm_properties_free0(var) ((var == NULL) ? NULL : (var = (worm_properties_free (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _BoniPrivate BoniPrivate;
typedef struct _BonusPrivate BonusPrivate;

#define TYPE_BONUS_TYPE (bonus_type_get_type ())
typedef struct _WarpPrivate WarpPrivate;

struct _WormActor {
	ClutterActor parent_instance;
	WormActorPrivate * priv;
};

struct _WormActorClass {
	ClutterActorClass parent_class;
};

struct _BonusTexture {
	GtkClutterTexture parent_instance;
	BonusTexturePrivate * priv;
};

struct _BonusTextureClass {
	GtkClutterTextureClass parent_class;
};

struct _WarpTexture {
	GtkClutterTexture parent_instance;
	WarpTexturePrivate * priv;
};

struct _WarpTextureClass {
	GtkClutterTextureClass parent_class;
};

struct _NibblesView {
	GtkClutterEmbed parent_instance;
	NibblesViewPrivate * priv;
	gboolean is_muted;
};

struct _NibblesViewClass {
	GtkClutterEmbedClass parent_class;
};

struct _NibblesViewPrivate {
	GdkPixbuf* wall_pixmaps[11];
	GdkPixbuf* worm_pixmaps[6];
	GdkPixbuf* boni_pixmaps[9];
	ClutterStage* stage;
	ClutterActor* level;
	ClutterActor* _name_labels;
	GeeHashMap* worm_actors;
	GeeHashMap* bonus_actors;
	GeeHashMap* warp_actors;
	NibblesGame* _game;
};

struct _WarpManager {
	GObject parent_instance;
	WarpManagerPrivate * priv;
	GeeLinkedList* warps;
};

struct _WarpManagerClass {
	GObjectClass parent_class;
};

struct _NibblesGame {
	GObject parent_instance;
	NibblesGamePrivate * priv;
	gint* board;
	gint board_length1;
	gint board_length2;
};

struct _NibblesGameClass {
	GObjectClass parent_class;
};

typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

struct _Block6Data {
	int _ref_count_;
	NibblesView* self;
	Worm* worm;
};

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _Position {
	gint x;
	gint y;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _Block7Data {
	int _ref_count_;
	NibblesView* self;
	Worm* worm;
};

struct _Boni {
	GObject parent_instance;
	BoniPrivate * priv;
	GeeLinkedList* bonuses;
	gint missed;
	gint numleft;
	gint numboni;
	gint numbonuses;
};

struct _BoniClass {
	GObjectClass parent_class;
};

typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_WARP
} BonusType;

struct _Bonus {
	GObject parent_instance;
	BonusPrivate * priv;
	gint x;
	gint y;
	BonusType type;
	gboolean fake;
	gint countdown;
};

struct _BonusClass {
	GObjectClass parent_class;
};

struct _Warp {
	GObject parent_instance;
	WarpPrivate * priv;
	gint x;
	gint y;
	gint wx;
	gint wy;
};

struct _WarpClass {
	GObjectClass parent_class;
};


static gpointer worm_actor_parent_class = NULL;
static gpointer bonus_texture_parent_class = NULL;
static gpointer warp_texture_parent_class = NULL;
static gpointer nibbles_view_parent_class = NULL;
extern gchar** nibbles_view_color_lookup;
extern gint nibbles_view_color_lookup_length1;
gchar** nibbles_view_color_lookup = NULL;
gint nibbles_view_color_lookup_length1 = 0;

GType worm_actor_get_type (void) G_GNUC_CONST;
enum  {
	WORM_ACTOR_DUMMY_PROPERTY
};
static void worm_actor_real_show (ClutterActor* base);
#define NIBBLES_GAME_GAMEDELAY 35
static void worm_actor_real_hide (ClutterActor* base);
WormActor* worm_actor_new (void);
WormActor* worm_actor_construct (GType object_type);
GType bonus_texture_get_type (void) G_GNUC_CONST;
enum  {
	BONUS_TEXTURE_DUMMY_PROPERTY
};
#define BONUS_TEXTURE_SIZE_MULTIPLIER ((gfloat) 2)
static void bonus_texture_real_show (ClutterActor* base);
void bonus_texture_set_size (BonusTexture* self, gfloat width, gfloat height);
BonusTexture* bonus_texture_new (void);
BonusTexture* bonus_texture_construct (GType object_type);
GType warp_texture_get_type (void) G_GNUC_CONST;
enum  {
	WARP_TEXTURE_DUMMY_PROPERTY
};
#define WARP_TEXTURE_SIZE_MULTIPLIER ((gfloat) 2)
static void warp_texture_real_show (ClutterActor* base);
static void warp_texture_real_hide (ClutterActor* base);
void warp_texture_set_size (WarpTexture* self, gfloat width, gfloat height);
WarpTexture* warp_texture_new (void);
WarpTexture* warp_texture_construct (GType object_type);
GType nibbles_view_get_type (void) G_GNUC_CONST;
GType worm_get_type (void) G_GNUC_CONST;
GType bonus_get_type (void) G_GNUC_CONST;
GType warp_get_type (void) G_GNUC_CONST;
GType nibbles_game_get_type (void) G_GNUC_CONST;
#define NIBBLES_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NIBBLES_VIEW, NibblesViewPrivate))
enum  {
	NIBBLES_VIEW_DUMMY_PROPERTY,
	NIBBLES_VIEW_NAME_LABELS,
	NIBBLES_VIEW_GAME
};
#define NIBBLES_VIEW_NUM_COLORS 6
NibblesView* nibbles_view_new (NibblesGame* game);
NibblesView* nibbles_view_construct (GType object_type, NibblesGame* game);
void nibbles_view_set_game (NibblesView* self, NibblesGame* value);
#define NIBBLES_GAME_MINIMUM_TILE_SIZE 7
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
static void nibbles_view_load_pixmap (NibblesView* self);
void nibbles_view_new_level (NibblesView* self, gint level);
NibblesGame* nibbles_view_get_game (NibblesView* self);
GType boni_get_type (void) G_GNUC_CONST;
Boni* nibbles_game_get_boni (NibblesGame* self);
void boni_reset (Boni* self, gint numworms);
gint nibbles_game_get_numworms (NibblesGame* self);
GType warp_manager_get_type (void) G_GNUC_CONST;
WarpManager* nibbles_game_get_warp_manager (NibblesGame* self);
#define NIBBLES_GAME_EMPTYCHAR 'a'
GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
GType worm_direction_get_type (void) G_GNUC_CONST;
void worm_set_start (Worm* self, gint xhead, gint yhead, WormDirection direction);
static void nibbles_view_load_level (NibblesView* self);
gint nibbles_game_get_tile_size (NibblesGame* self);
void warp_manager_add_warp (WarpManager* self, gint* board, int board_length1, int board_length2, gint x, gint y, gint wx, gint wy);
GdkPixbuf* nibbles_view_load_pixmap_file (NibblesView* self, const gchar* pixmap, gint xsize, gint ysize);
void nibbles_view_connect_worm_signals (NibblesView* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void nibbles_view_worm_added_cb (NibblesView* self, Worm* worm);
static void _nibbles_view_worm_added_cb_worm_added (Worm* _sender, gpointer self);
static void nibbles_view_worm_finish_added_cb (NibblesView* self, Worm* worm);
static void _nibbles_view_worm_finish_added_cb_worm_finish_added (Worm* _sender, gpointer self);
static void nibbles_view_worm_moved_cb (NibblesView* self, Worm* worm);
static void _nibbles_view_worm_moved_cb_worm_moved (Worm* _sender, gpointer self);
static void nibbles_view_worm_rescaled_cb (NibblesView* self, Worm* worm, gint tile_size);
static void _nibbles_view_worm_rescaled_cb_worm_rescaled (Worm* _sender, gint tile_size, gpointer self);
static void nibbles_view_worm_died_cb (NibblesView* self, Worm* worm);
static void _nibbles_view_worm_died_cb_worm_died (Worm* _sender, gpointer self);
static void nibbles_view_worm_tail_reduced_cb (NibblesView* self, Worm* worm, gint erase_size);
static void _nibbles_view_worm_tail_reduced_cb_worm_tail_reduced (Worm* _sender, gint erase_size, gpointer self);
static void nibbles_view_worm_reversed_cb (NibblesView* self, Worm* worm);
static void _nibbles_view_worm_reversed_cb_worm_reversed (Worm* _sender, gpointer self);
static void ____lambda6_ (Block6Data* _data6_);
gboolean worm_get_is_materialized (Worm* self);
static void _____lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void nibbles_view_board_rescale (NibblesView* self, gint tile_size);
ClutterActor* nibbles_view_get_name_labels (NibblesView* self);
gint worm_get_id (Worm* self);
gint worm_get_length (Worm* self);
GType position_get_type (void) G_GNUC_CONST;
Position* position_dup (const Position* self);
void position_free (Position* self);
GeeLinkedList* worm_get_list (Worm* self);
void worm_get_head (Worm* self, Position* result);
static void nibbles_view_animate_end_game_cb (NibblesView* self);
void nibbles_view_create_name_labels (NibblesView* self);
static void nibbles_view_set_name_labels (NibblesView* self, ClutterActor* value);
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
gchar* nibbles_view_colorval_name (gint colorval);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
void worm_dematerialize (Worm* self, gint* board, int board_length1, int board_length2, gint rounds);
static gboolean __lambda5_ (Block7Data* _data7_);
static gboolean ___lambda5__gsource_func (gpointer self);
static void nibbles_view_play_sound (NibblesView* self, const gchar* name);
static void nibbles_view_bonus_added_cb (NibblesView* self);
GType bonus_type_get_type (void) G_GNUC_CONST;
static void nibbles_view_bonus_removed_cb (NibblesView* self, Bonus* bonus);
static void nibbles_view_bonus_applied_cb (NibblesView* self, Bonus* bonus, Worm* worm);
void nibbles_view_boni_rescale (NibblesView* self, gint tile_size);
static void nibbles_view_warp_added_cb (NibblesView* self, Warp* warp);
void nibbles_view_warps_rescale (NibblesView* self, gint tile_size);
static void _nibbles_view_bonus_added_cb_boni_bonus_added (Boni* _sender, gpointer self);
static void _nibbles_view_bonus_removed_cb_boni_bonus_removed (Boni* _sender, Bonus* bonus, gpointer self);
static void _nibbles_view_bonus_applied_cb_nibbles_game_bonus_applied (NibblesGame* _sender, Bonus* bonus, Worm* worm, gpointer self);
static void _nibbles_view_warp_added_cb_warp_manager_warp_added (WarpManager* _sender, Warp* warp, gpointer self);
static void _nibbles_view_animate_end_game_cb_nibbles_game_animate_end_game (NibblesGame* _sender, gpointer self);
static void nibbles_view_finalize (GObject* obj);
static void _vala_nibbles_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_nibbles_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void worm_actor_real_show (ClutterActor* base) {
	WormActor * self;
#line 21 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self = (WormActor*) base;
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	CLUTTER_ACTOR_CLASS (worm_actor_parent_class)->show (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor));
#line 25 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, 3.0, 3.0);
#line 28 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_save_easing_state ((ClutterActor*) self);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_CIRC);
#line 30 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 26));
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, 1.0, 1.0);
#line 32 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
#line 33 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0xff);
#line 34 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_restore_easing_state ((ClutterActor*) self);
#line 500 "nibbles-view.c"
}


static void worm_actor_real_hide (ClutterActor* base) {
	WormActor * self;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self = (WormActor*) base;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_save_easing_state ((ClutterActor*) self);
#line 40 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_IN_QUAD);
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 15));
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, (gdouble) 0.4f, (gdouble) 0.4f);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_restore_easing_state ((ClutterActor*) self);
#line 520 "nibbles-view.c"
}


WormActor* worm_actor_construct (GType object_type) {
	WormActor * self = NULL;
#line 19 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self = (WormActor*) g_object_new (object_type, NULL);
#line 19 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	return self;
#line 530 "nibbles-view.c"
}


WormActor* worm_actor_new (void) {
#line 19 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	return worm_actor_construct (TYPE_WORM_ACTOR);
#line 537 "nibbles-view.c"
}


static void worm_actor_class_init (WormActorClass * klass) {
#line 19 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	worm_actor_parent_class = g_type_class_peek_parent (klass);
#line 19 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	((ClutterActorClass *) klass)->show = worm_actor_real_show;
#line 19 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	((ClutterActorClass *) klass)->hide = worm_actor_real_hide;
#line 548 "nibbles-view.c"
}


static void worm_actor_instance_init (WormActor * self) {
}


GType worm_actor_get_type (void) {
	static volatile gsize worm_actor_type_id__volatile = 0;
	if (g_once_init_enter (&worm_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WormActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) worm_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WormActor), 0, (GInstanceInitFunc) worm_actor_instance_init, NULL };
		GType worm_actor_type_id;
		worm_actor_type_id = g_type_register_static (clutter_actor_get_type (), "WormActor", &g_define_type_info, 0);
		g_once_init_leave (&worm_actor_type_id__volatile, worm_actor_type_id);
	}
	return worm_actor_type_id__volatile;
}


static void bonus_texture_real_show (ClutterActor* base) {
	BonusTexture * self;
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self = (BonusTexture*) base;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	CLUTTER_ACTOR_CLASS (bonus_texture_parent_class)->show ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_clutter_texture_get_type (), GtkClutterTexture));
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, 3.0, 3.0);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_save_easing_state ((ClutterActor*) self);
#line 60 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_BOUNCE);
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 20));
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, 1.0, 1.0);
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0xff);
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_restore_easing_state ((ClutterActor*) self);
#line 592 "nibbles-view.c"
}


void bonus_texture_set_size (BonusTexture* self, gfloat width, gfloat height) {
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = width;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = height;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_size ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_clutter_texture_get_type (), GtkClutterTexture), BONUS_TEXTURE_SIZE_MULTIPLIER * _tmp0_, BONUS_TEXTURE_SIZE_MULTIPLIER * _tmp1_);
#line 607 "nibbles-view.c"
}


BonusTexture* bonus_texture_construct (GType object_type) {
	BonusTexture * self = NULL;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self = (BonusTexture*) g_object_new (object_type, NULL);
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	return self;
#line 617 "nibbles-view.c"
}


BonusTexture* bonus_texture_new (void) {
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	return bonus_texture_construct (TYPE_BONUS_TEXTURE);
#line 624 "nibbles-view.c"
}


static void bonus_texture_class_init (BonusTextureClass * klass) {
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	bonus_texture_parent_class = g_type_class_peek_parent (klass);
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	((ClutterActorClass *) klass)->show = bonus_texture_real_show;
#line 633 "nibbles-view.c"
}


static void bonus_texture_instance_init (BonusTexture * self) {
}


GType bonus_texture_get_type (void) {
	static volatile gsize bonus_texture_type_id__volatile = 0;
	if (g_once_init_enter (&bonus_texture_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BonusTextureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bonus_texture_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BonusTexture), 0, (GInstanceInitFunc) bonus_texture_instance_init, NULL };
		GType bonus_texture_type_id;
		bonus_texture_type_id = g_type_register_static (gtk_clutter_texture_get_type (), "BonusTexture", &g_define_type_info, 0);
		g_once_init_leave (&bonus_texture_type_id__volatile, bonus_texture_type_id);
	}
	return bonus_texture_type_id__volatile;
}


static void warp_texture_real_show (ClutterActor* base) {
	WarpTexture * self;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self = (WarpTexture*) base;
#line 80 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	CLUTTER_ACTOR_CLASS (warp_texture_parent_class)->show ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_clutter_texture_get_type (), GtkClutterTexture));
#line 82 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, 3.0, 3.0);
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_save_easing_state ((ClutterActor*) self);
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_CIRC);
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 15));
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, 1.0, 1.0);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0xff);
#line 91 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_restore_easing_state ((ClutterActor*) self);
#line 677 "nibbles-view.c"
}


static void warp_texture_real_hide (ClutterActor* base) {
	WarpTexture * self;
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self = (WarpTexture*) base;
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_save_easing_state ((ClutterActor*) self);
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_IN_QUAD);
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 15));
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, (gdouble) 0.4f, (gdouble) 0.4f);
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_restore_easing_state ((ClutterActor*) self);
#line 699 "nibbles-view.c"
}


void warp_texture_set_size (WarpTexture* self, gfloat width, gfloat height) {
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = width;
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = height;
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_size ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_clutter_texture_get_type (), GtkClutterTexture), WARP_TEXTURE_SIZE_MULTIPLIER * _tmp0_, WARP_TEXTURE_SIZE_MULTIPLIER * _tmp1_);
#line 714 "nibbles-view.c"
}


WarpTexture* warp_texture_construct (GType object_type) {
	WarpTexture * self = NULL;
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self = (WarpTexture*) g_object_new (object_type, NULL);
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	return self;
#line 724 "nibbles-view.c"
}


WarpTexture* warp_texture_new (void) {
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	return warp_texture_construct (TYPE_WARP_TEXTURE);
#line 731 "nibbles-view.c"
}


static void warp_texture_class_init (WarpTextureClass * klass) {
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	warp_texture_parent_class = g_type_class_peek_parent (klass);
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	((ClutterActorClass *) klass)->show = warp_texture_real_show;
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	((ClutterActorClass *) klass)->hide = warp_texture_real_hide;
#line 742 "nibbles-view.c"
}


static void warp_texture_instance_init (WarpTexture * self) {
}


GType warp_texture_get_type (void) {
	static volatile gsize warp_texture_type_id__volatile = 0;
	if (g_once_init_enter (&warp_texture_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WarpTextureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) warp_texture_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WarpTexture), 0, (GInstanceInitFunc) warp_texture_instance_init, NULL };
		GType warp_texture_type_id;
		warp_texture_type_id = g_type_register_static (gtk_clutter_texture_get_type (), "WarpTexture", &g_define_type_info, 0);
		g_once_init_leave (&warp_texture_type_id__volatile, warp_texture_type_id);
	}
	return warp_texture_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 765 "nibbles-view.c"
}


NibblesView* nibbles_view_construct (GType object_type, NibblesGame* game) {
	NibblesView * self = NULL;
	NibblesGame* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
	ClutterStage* _tmp2_ = NULL;
	ClutterColor stage_color = {0};
	ClutterColor _tmp3_ = {0};
	ClutterStage* _tmp4_ = NULL;
	ClutterColor _tmp5_ = {0};
	GeeHashMap* _tmp6_ = NULL;
	GeeHashMap* _tmp7_ = NULL;
	GeeHashMap* _tmp8_ = NULL;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self = (NibblesView*) g_object_new (object_type, NULL);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = game;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_set_game (self, _tmp0_);
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = gtk_clutter_embed_get_stage ((GtkClutterEmbed*) self);
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, clutter_stage_get_type (), ClutterStage));
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (self->priv->stage);
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self->priv->stage = _tmp2_;
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_.red = (guint8) 0x00;
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_.green = (guint8) 0x00;
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_.blue = (guint8) 0x00;
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_.alpha = (guint8) 0xff;
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	stage_color = _tmp3_;
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = self->priv->stage;
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp5_ = stage_color;
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_background_color ((ClutterActor*) _tmp4_, &_tmp5_);
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, NIBBLES_GAME_MINIMUM_TILE_SIZE * NIBBLES_GAME_WIDTH, NIBBLES_GAME_MINIMUM_TILE_SIZE * NIBBLES_GAME_HEIGHT);
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_ = gee_hash_map_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, g_object_unref, TYPE_WORM_ACTOR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (self->priv->worm_actors);
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self->priv->worm_actors = _tmp6_;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp7_ = gee_hash_map_new (TYPE_BONUS, (GBoxedCopyFunc) g_object_ref, g_object_unref, TYPE_BONUS_TEXTURE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (self->priv->bonus_actors);
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self->priv->bonus_actors = _tmp7_;
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp8_ = gee_hash_map_new (TYPE_WARP, (GBoxedCopyFunc) g_object_ref, g_object_unref, TYPE_WARP_TEXTURE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (self->priv->warp_actors);
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self->priv->warp_actors = _tmp8_;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_load_pixmap (self);
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	return self;
#line 837 "nibbles-view.c"
}


NibblesView* nibbles_view_new (NibblesGame* game) {
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	return nibbles_view_construct (TYPE_NIBBLES_VIEW, game);
#line 844 "nibbles-view.c"
}


static gchar* g_file_stream_read_line (FILE* self) {
	gchar* result = NULL;
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp7_ = NULL;
#line 3443 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 3445 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	ret = NULL;
#line 3446 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	while (TRUE) {
#line 859 "nibbles-view.c"
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		GString* _tmp2_ = NULL;
		gint _tmp4_ = 0;
		GString* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 3446 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = fgetc (self);
#line 3446 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		c = _tmp0_;
#line 3446 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = c;
#line 3446 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		if (!(_tmp1_ != EOF)) {
#line 3446 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
			break;
#line 876 "nibbles-view.c"
		}
#line 3447 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = ret;
#line 3447 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		if (_tmp2_ == NULL) {
#line 882 "nibbles-view.c"
			GString* _tmp3_ = NULL;
#line 3448 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp3_ = g_string_new ("");
#line 3448 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_string_free0 (ret);
#line 3448 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
			ret = _tmp3_;
#line 890 "nibbles-view.c"
		}
#line 3450 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = c;
#line 3450 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		if (_tmp4_ == ((gint) '\n')) {
#line 3451 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
			break;
#line 898 "nibbles-view.c"
		}
#line 3453 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = ret;
#line 3453 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = c;
#line 3453 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		g_string_append_c ((GString*) _tmp5_, (gchar) _tmp6_);
#line 906 "nibbles-view.c"
	}
#line 3455 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp7_ = ret;
#line 3455 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp7_ == NULL) {
#line 3456 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		result = NULL;
#line 3456 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_string_free0 (ret);
#line 3456 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 918 "nibbles-view.c"
	} else {
		GString* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 3458 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = ret;
#line 3458 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp9_ = ((GString*) _tmp8_)->str;
#line 3458 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp10_ = g_strdup (_tmp9_);
#line 3458 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp10_;
#line 3458 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_string_free0 (ret);
#line 3458 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 935 "nibbles-view.c"
	}
#line 3443 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	_g_string_free0 (ret);
#line 939 "nibbles-view.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 1086 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1087 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1087 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1087 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1087 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 957 "nibbles-view.c"
}


void nibbles_view_new_level (NibblesView* self, gint level) {
	gchar* level_name = NULL;
	gchar* filename = NULL;
	gchar* tmpboard = NULL;
	gint count = 0;
	gint _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	FILE* file = NULL;
	const gchar* _tmp4_ = NULL;
	FILE* _tmp5_ = NULL;
	FILE* _tmp6_ = NULL;
	GeeHashMap* _tmp19_ = NULL;
	GeeHashMap* _tmp31_ = NULL;
	GeeHashMap* _tmp43_ = NULL;
	NibblesGame* _tmp44_ = NULL;
	NibblesGame* _tmp45_ = NULL;
	Boni* _tmp46_ = NULL;
	Boni* _tmp47_ = NULL;
	NibblesGame* _tmp48_ = NULL;
	NibblesGame* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	NibblesGame* _tmp52_ = NULL;
	NibblesGame* _tmp53_ = NULL;
	WarpManager* _tmp54_ = NULL;
	WarpManager* _tmp55_ = NULL;
	GeeLinkedList* _tmp56_ = NULL;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 191 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	count = 0;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = level;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = g_strdup_printf ("level%03d.gnl", _tmp0_);
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_free0 (level_name);
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	level_name = _tmp1_;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp2_ = level_name;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_ = g_build_filename (PKGDATADIR, "levels", _tmp2_, NULL, NULL);
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_free0 (filename);
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	filename = _tmp3_;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = filename;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp5_ = g_fopen (_tmp4_, "r");
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_fclose0 (file);
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	file = _tmp5_;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_ = file;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	if (_tmp6_ == NULL) {
#line 1022 "nibbles-view.c"
		const gchar* _tmp7_ = NULL;
#line 198 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp7_ = filename;
#line 198 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_error ("nibbles-view.vala:198: Nibbles couldn't find pixmap file: %s", _tmp7_);
#line 1028 "nibbles-view.c"
	}
	{
		GeeIterator* _actor_it = NULL;
		GeeHashMap* _tmp8_ = NULL;
		GeeCollection* _tmp9_ = NULL;
		GeeCollection* _tmp10_ = NULL;
		GeeCollection* _tmp11_ = NULL;
		GeeIterator* _tmp12_ = NULL;
		GeeIterator* _tmp13_ = NULL;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp8_ = self->priv->worm_actors;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp9_ = gee_abstract_map_get_values ((GeeMap*) _tmp8_);
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp10_ = _tmp9_;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp11_ = _tmp10_;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp13_ = _tmp12_;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (_tmp11_);
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_actor_it = _tmp13_;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		while (TRUE) {
#line 1056 "nibbles-view.c"
			GeeIterator* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
			WormActor* actor = NULL;
			GeeIterator* _tmp16_ = NULL;
			gpointer _tmp17_ = NULL;
			WormActor* _tmp18_ = NULL;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp14_ = _actor_it;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp15_ = gee_iterator_next (_tmp14_);
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			if (!_tmp15_) {
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				break;
#line 1071 "nibbles-view.c"
			}
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp16_ = _actor_it;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp17_ = gee_iterator_get (_tmp16_);
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			actor = (WormActor*) _tmp17_;
#line 201 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp18_ = actor;
#line 201 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			clutter_actor_destroy ((ClutterActor*) _tmp18_);
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_object_unref0 (actor);
#line 1085 "nibbles-view.c"
		}
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (_actor_it);
#line 1089 "nibbles-view.c"
	}
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp19_ = self->priv->worm_actors;
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp19_);
#line 1095 "nibbles-view.c"
	{
		GeeIterator* _actor_it = NULL;
		GeeHashMap* _tmp20_ = NULL;
		GeeCollection* _tmp21_ = NULL;
		GeeCollection* _tmp22_ = NULL;
		GeeCollection* _tmp23_ = NULL;
		GeeIterator* _tmp24_ = NULL;
		GeeIterator* _tmp25_ = NULL;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp20_ = self->priv->bonus_actors;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp21_ = gee_abstract_map_get_values ((GeeMap*) _tmp20_);
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp22_ = _tmp21_;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp23_ = _tmp22_;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp24_ = gee_iterable_iterator ((GeeIterable*) _tmp23_);
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp25_ = _tmp24_;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (_tmp23_);
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_actor_it = _tmp25_;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		while (TRUE) {
#line 1122 "nibbles-view.c"
			GeeIterator* _tmp26_ = NULL;
			gboolean _tmp27_ = FALSE;
			BonusTexture* actor = NULL;
			GeeIterator* _tmp28_ = NULL;
			gpointer _tmp29_ = NULL;
			BonusTexture* _tmp30_ = NULL;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp26_ = _actor_it;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp27_ = gee_iterator_next (_tmp26_);
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			if (!_tmp27_) {
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				break;
#line 1137 "nibbles-view.c"
			}
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp28_ = _actor_it;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp29_ = gee_iterator_get (_tmp28_);
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			actor = (BonusTexture*) _tmp29_;
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp30_ = actor;
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			clutter_actor_destroy ((ClutterActor*) _tmp30_);
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_object_unref0 (actor);
#line 1151 "nibbles-view.c"
		}
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (_actor_it);
#line 1155 "nibbles-view.c"
	}
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp31_ = self->priv->bonus_actors;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp31_);
#line 1161 "nibbles-view.c"
	{
		GeeIterator* _actor_it = NULL;
		GeeHashMap* _tmp32_ = NULL;
		GeeCollection* _tmp33_ = NULL;
		GeeCollection* _tmp34_ = NULL;
		GeeCollection* _tmp35_ = NULL;
		GeeIterator* _tmp36_ = NULL;
		GeeIterator* _tmp37_ = NULL;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp32_ = self->priv->warp_actors;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp33_ = gee_abstract_map_get_values ((GeeMap*) _tmp32_);
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp34_ = _tmp33_;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp35_ = _tmp34_;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp36_ = gee_iterable_iterator ((GeeIterable*) _tmp35_);
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp37_ = _tmp36_;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (_tmp35_);
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_actor_it = _tmp37_;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		while (TRUE) {
#line 1188 "nibbles-view.c"
			GeeIterator* _tmp38_ = NULL;
			gboolean _tmp39_ = FALSE;
			WarpTexture* actor = NULL;
			GeeIterator* _tmp40_ = NULL;
			gpointer _tmp41_ = NULL;
			WarpTexture* _tmp42_ = NULL;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp38_ = _actor_it;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp39_ = gee_iterator_next (_tmp38_);
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			if (!_tmp39_) {
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				break;
#line 1203 "nibbles-view.c"
			}
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp40_ = _actor_it;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp41_ = gee_iterator_get (_tmp40_);
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			actor = (WarpTexture*) _tmp41_;
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp42_ = actor;
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			clutter_actor_destroy ((ClutterActor*) _tmp42_);
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_object_unref0 (actor);
#line 1217 "nibbles-view.c"
		}
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (_actor_it);
#line 1221 "nibbles-view.c"
	}
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp43_ = self->priv->warp_actors;
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp43_);
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp44_ = nibbles_view_get_game (self);
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp45_ = _tmp44_;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp46_ = nibbles_game_get_boni (_tmp45_);
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp47_ = _tmp46_;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp48_ = nibbles_view_get_game (self);
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp49_ = _tmp48_;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp50_ = nibbles_game_get_numworms (_tmp49_);
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp51_ = _tmp50_;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	boni_reset (_tmp47_, _tmp51_);
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp52_ = nibbles_view_get_game (self);
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp53_ = _tmp52_;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp54_ = nibbles_game_get_warp_manager (_tmp53_);
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp55_ = _tmp54_;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp56_ = _tmp55_->warps;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp56_);
#line 1257 "nibbles-view.c"
	{
		gint i = 0;
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		i = 0;
#line 1262 "nibbles-view.c"
		{
			gboolean _tmp57_ = FALSE;
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp57_ = TRUE;
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			while (TRUE) {
#line 1269 "nibbles-view.c"
				gint _tmp59_ = 0;
				FILE* _tmp60_ = NULL;
				gchar* _tmp61_ = NULL;
				const gchar* _tmp62_ = NULL;
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (!_tmp57_) {
#line 1276 "nibbles-view.c"
					gint _tmp58_ = 0;
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp58_ = i;
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					i = _tmp58_ + 1;
#line 1282 "nibbles-view.c"
				}
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp57_ = FALSE;
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp59_ = i;
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (!(_tmp59_ < NIBBLES_GAME_HEIGHT)) {
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					break;
#line 1292 "nibbles-view.c"
				}
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp60_ = file;
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp61_ = g_file_stream_read_line (_tmp60_);
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_g_free0 (tmpboard);
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				tmpboard = _tmp61_;
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp62_ = tmpboard;
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (_tmp62_ == NULL) {
#line 1306 "nibbles-view.c"
					const gchar* _tmp63_ = NULL;
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp63_ = filename;
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					g_error ("nibbles-view.vala:218: Level file appears to be damaged: %s", _tmp63_);
#line 1312 "nibbles-view.c"
				}
				{
					gint j = 0;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					j = 0;
#line 1318 "nibbles-view.c"
					{
						gboolean _tmp64_ = FALSE;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
						_tmp64_ = TRUE;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
						while (TRUE) {
#line 1325 "nibbles-view.c"
							gint _tmp66_ = 0;
							NibblesGame* _tmp67_ = NULL;
							NibblesGame* _tmp68_ = NULL;
							gint* _tmp69_ = NULL;
							gint _tmp69__length1 = 0;
							gint _tmp69__length2 = 0;
							gint _tmp70_ = 0;
							gint _tmp71_ = 0;
							const gchar* _tmp72_ = NULL;
							gint _tmp73_ = 0;
							gchar _tmp74_ = '\0';
							gint _tmp75_ = 0;
							NibblesGame* _tmp76_ = NULL;
							NibblesGame* _tmp77_ = NULL;
							gint* _tmp78_ = NULL;
							gint _tmp78__length1 = 0;
							gint _tmp78__length2 = 0;
							gint _tmp79_ = 0;
							gint _tmp80_ = 0;
							gint _tmp81_ = 0;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							if (!_tmp64_) {
#line 1348 "nibbles-view.c"
								gint _tmp65_ = 0;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp65_ = j;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								j = _tmp65_ + 1;
#line 1354 "nibbles-view.c"
							}
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp64_ = FALSE;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp66_ = j;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							if (!(_tmp66_ < NIBBLES_GAME_WIDTH)) {
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								break;
#line 1364 "nibbles-view.c"
							}
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp67_ = nibbles_view_get_game (self);
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp68_ = _tmp67_;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp69_ = _tmp68_->board;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp69__length1 = _tmp68_->board_length1;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp69__length2 = _tmp68_->board_length2;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp70_ = j;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp71_ = i;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp72_ = tmpboard;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp73_ = j;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp74_ = string_get (_tmp72_, (glong) _tmp73_);
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp69_[(_tmp70_ * _tmp69__length2) + _tmp71_] = (gint) _tmp74_;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp75_ = _tmp69_[(_tmp70_ * _tmp69__length2) + _tmp71_];
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp76_ = nibbles_view_get_game (self);
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp77_ = _tmp76_;
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp78_ = _tmp77_->board;
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp78__length1 = _tmp77_->board_length1;
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp78__length2 = _tmp77_->board_length2;
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp79_ = j;
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp80_ = i;
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp81_ = _tmp78_[(_tmp79_ * _tmp78__length2) + _tmp80_];
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							switch (_tmp81_) {
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								case 'm':
#line 1410 "nibbles-view.c"
								{
									NibblesGame* _tmp82_ = NULL;
									NibblesGame* _tmp83_ = NULL;
									gint* _tmp84_ = NULL;
									gint _tmp84__length1 = 0;
									gint _tmp84__length2 = 0;
									gint _tmp85_ = 0;
									gint _tmp86_ = 0;
									gint _tmp87_ = 0;
									gint _tmp88_ = 0;
									NibblesGame* _tmp89_ = NULL;
									NibblesGame* _tmp90_ = NULL;
									gint _tmp91_ = 0;
									gint _tmp92_ = 0;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp82_ = nibbles_view_get_game (self);
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp83_ = _tmp82_;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp84_ = _tmp83_->board;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp84__length1 = _tmp83_->board_length1;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp84__length2 = _tmp83_->board_length2;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp85_ = j;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp86_ = i;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp84_[(_tmp85_ * _tmp84__length2) + _tmp86_] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp87_ = _tmp84_[(_tmp85_ * _tmp84__length2) + _tmp86_];
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp88_ = count;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp89_ = nibbles_view_get_game (self);
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp90_ = _tmp89_;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp91_ = nibbles_game_get_numworms (_tmp90_);
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp92_ = _tmp91_;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									if (_tmp88_ < _tmp92_) {
#line 1455 "nibbles-view.c"
										NibblesGame* _tmp93_ = NULL;
										NibblesGame* _tmp94_ = NULL;
										GeeLinkedList* _tmp95_ = NULL;
										GeeLinkedList* _tmp96_ = NULL;
										gint _tmp97_ = 0;
										gpointer _tmp98_ = NULL;
										Worm* _tmp99_ = NULL;
										gint _tmp100_ = 0;
										gint _tmp101_ = 0;
										WormActor* actors = NULL;
										WormActor* _tmp102_ = NULL;
										ClutterStage* _tmp103_ = NULL;
										WormActor* _tmp104_ = NULL;
										GeeHashMap* _tmp105_ = NULL;
										NibblesGame* _tmp106_ = NULL;
										NibblesGame* _tmp107_ = NULL;
										GeeLinkedList* _tmp108_ = NULL;
										GeeLinkedList* _tmp109_ = NULL;
										gint _tmp110_ = 0;
										gpointer _tmp111_ = NULL;
										Worm* _tmp112_ = NULL;
										WormActor* _tmp113_ = NULL;
										gint _tmp114_ = 0;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp93_ = nibbles_view_get_game (self);
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp94_ = _tmp93_;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp95_ = nibbles_game_get_worms (_tmp94_);
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp96_ = _tmp95_;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp97_ = count;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp98_ = gee_abstract_list_get ((GeeAbstractList*) _tmp96_, _tmp97_);
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp99_ = (Worm*) _tmp98_;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp100_ = j;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp101_ = i;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										worm_set_start (_tmp99_, _tmp100_, _tmp101_, WORM_DIRECTION_UP);
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (_tmp99_);
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp102_ = worm_actor_new ();
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										g_object_ref_sink (_tmp102_);
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										actors = _tmp102_;
#line 232 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp103_ = self->priv->stage;
#line 232 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp104_ = actors;
#line 232 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										clutter_actor_add_child ((ClutterActor*) _tmp103_, (ClutterActor*) _tmp104_);
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp105_ = self->priv->worm_actors;
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp106_ = nibbles_view_get_game (self);
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp107_ = _tmp106_;
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp108_ = nibbles_game_get_worms (_tmp107_);
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp109_ = _tmp108_;
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp110_ = count;
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp111_ = gee_abstract_list_get ((GeeAbstractList*) _tmp109_, _tmp110_);
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp112_ = (Worm*) _tmp111_;
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp113_ = actors;
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										gee_abstract_map_set ((GeeAbstractMap*) _tmp105_, _tmp112_, _tmp113_);
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (_tmp112_);
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp114_ = count;
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										count = _tmp114_ + 1;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (actors);
#line 1541 "nibbles-view.c"
									}
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									break;
#line 1545 "nibbles-view.c"
								}
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								case 'n':
#line 1549 "nibbles-view.c"
								{
									NibblesGame* _tmp115_ = NULL;
									NibblesGame* _tmp116_ = NULL;
									gint* _tmp117_ = NULL;
									gint _tmp117__length1 = 0;
									gint _tmp117__length2 = 0;
									gint _tmp118_ = 0;
									gint _tmp119_ = 0;
									gint _tmp120_ = 0;
									gint _tmp121_ = 0;
									NibblesGame* _tmp122_ = NULL;
									NibblesGame* _tmp123_ = NULL;
									gint _tmp124_ = 0;
									gint _tmp125_ = 0;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp115_ = nibbles_view_get_game (self);
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp116_ = _tmp115_;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp117_ = _tmp116_->board;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp117__length1 = _tmp116_->board_length1;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp117__length2 = _tmp116_->board_length2;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp118_ = j;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp119_ = i;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp117_[(_tmp118_ * _tmp117__length2) + _tmp119_] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp120_ = _tmp117_[(_tmp118_ * _tmp117__length2) + _tmp119_];
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp121_ = count;
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp122_ = nibbles_view_get_game (self);
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp123_ = _tmp122_;
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp124_ = nibbles_game_get_numworms (_tmp123_);
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp125_ = _tmp124_;
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									if (_tmp121_ < _tmp125_) {
#line 1594 "nibbles-view.c"
										NibblesGame* _tmp126_ = NULL;
										NibblesGame* _tmp127_ = NULL;
										GeeLinkedList* _tmp128_ = NULL;
										GeeLinkedList* _tmp129_ = NULL;
										gint _tmp130_ = 0;
										gpointer _tmp131_ = NULL;
										Worm* _tmp132_ = NULL;
										gint _tmp133_ = 0;
										gint _tmp134_ = 0;
										WormActor* actors = NULL;
										WormActor* _tmp135_ = NULL;
										ClutterStage* _tmp136_ = NULL;
										WormActor* _tmp137_ = NULL;
										GeeHashMap* _tmp138_ = NULL;
										NibblesGame* _tmp139_ = NULL;
										NibblesGame* _tmp140_ = NULL;
										GeeLinkedList* _tmp141_ = NULL;
										GeeLinkedList* _tmp142_ = NULL;
										gint _tmp143_ = 0;
										gpointer _tmp144_ = NULL;
										Worm* _tmp145_ = NULL;
										WormActor* _tmp146_ = NULL;
										gint _tmp147_ = 0;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp126_ = nibbles_view_get_game (self);
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp127_ = _tmp126_;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp128_ = nibbles_game_get_worms (_tmp127_);
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp129_ = _tmp128_;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp130_ = count;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp131_ = gee_abstract_list_get ((GeeAbstractList*) _tmp129_, _tmp130_);
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp132_ = (Worm*) _tmp131_;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp133_ = j;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp134_ = i;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										worm_set_start (_tmp132_, _tmp133_, _tmp134_, WORM_DIRECTION_LEFT);
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (_tmp132_);
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp135_ = worm_actor_new ();
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										g_object_ref_sink (_tmp135_);
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										actors = _tmp135_;
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp136_ = self->priv->stage;
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp137_ = actors;
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										clutter_actor_add_child ((ClutterActor*) _tmp136_, (ClutterActor*) _tmp137_);
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp138_ = self->priv->worm_actors;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp139_ = nibbles_view_get_game (self);
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp140_ = _tmp139_;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp141_ = nibbles_game_get_worms (_tmp140_);
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp142_ = _tmp141_;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp143_ = count;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp144_ = gee_abstract_list_get ((GeeAbstractList*) _tmp142_, _tmp143_);
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp145_ = (Worm*) _tmp144_;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp146_ = actors;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										gee_abstract_map_set ((GeeAbstractMap*) _tmp138_, _tmp145_, _tmp146_);
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (_tmp145_);
#line 246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp147_ = count;
#line 246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										count = _tmp147_ + 1;
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (actors);
#line 1680 "nibbles-view.c"
									}
#line 248 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									break;
#line 1684 "nibbles-view.c"
								}
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								case 'o':
#line 1688 "nibbles-view.c"
								{
									NibblesGame* _tmp148_ = NULL;
									NibblesGame* _tmp149_ = NULL;
									gint* _tmp150_ = NULL;
									gint _tmp150__length1 = 0;
									gint _tmp150__length2 = 0;
									gint _tmp151_ = 0;
									gint _tmp152_ = 0;
									gint _tmp153_ = 0;
									gint _tmp154_ = 0;
									NibblesGame* _tmp155_ = NULL;
									NibblesGame* _tmp156_ = NULL;
									gint _tmp157_ = 0;
									gint _tmp158_ = 0;
#line 250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp148_ = nibbles_view_get_game (self);
#line 250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp149_ = _tmp148_;
#line 250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp150_ = _tmp149_->board;
#line 250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp150__length1 = _tmp149_->board_length1;
#line 250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp150__length2 = _tmp149_->board_length2;
#line 250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp151_ = j;
#line 250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp152_ = i;
#line 250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp150_[(_tmp151_ * _tmp150__length2) + _tmp152_] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp153_ = _tmp150_[(_tmp151_ * _tmp150__length2) + _tmp152_];
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp154_ = count;
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp155_ = nibbles_view_get_game (self);
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp156_ = _tmp155_;
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp157_ = nibbles_game_get_numworms (_tmp156_);
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp158_ = _tmp157_;
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									if (_tmp154_ < _tmp158_) {
#line 1733 "nibbles-view.c"
										NibblesGame* _tmp159_ = NULL;
										NibblesGame* _tmp160_ = NULL;
										GeeLinkedList* _tmp161_ = NULL;
										GeeLinkedList* _tmp162_ = NULL;
										gint _tmp163_ = 0;
										gpointer _tmp164_ = NULL;
										Worm* _tmp165_ = NULL;
										gint _tmp166_ = 0;
										gint _tmp167_ = 0;
										WormActor* actors = NULL;
										WormActor* _tmp168_ = NULL;
										ClutterStage* _tmp169_ = NULL;
										WormActor* _tmp170_ = NULL;
										GeeHashMap* _tmp171_ = NULL;
										NibblesGame* _tmp172_ = NULL;
										NibblesGame* _tmp173_ = NULL;
										GeeLinkedList* _tmp174_ = NULL;
										GeeLinkedList* _tmp175_ = NULL;
										gint _tmp176_ = 0;
										gpointer _tmp177_ = NULL;
										Worm* _tmp178_ = NULL;
										WormActor* _tmp179_ = NULL;
										gint _tmp180_ = 0;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp159_ = nibbles_view_get_game (self);
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp160_ = _tmp159_;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp161_ = nibbles_game_get_worms (_tmp160_);
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp162_ = _tmp161_;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp163_ = count;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp164_ = gee_abstract_list_get ((GeeAbstractList*) _tmp162_, _tmp163_);
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp165_ = (Worm*) _tmp164_;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp166_ = j;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp167_ = i;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										worm_set_start (_tmp165_, _tmp166_, _tmp167_, WORM_DIRECTION_DOWN);
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (_tmp165_);
#line 255 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp168_ = worm_actor_new ();
#line 255 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										g_object_ref_sink (_tmp168_);
#line 255 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										actors = _tmp168_;
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp169_ = self->priv->stage;
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp170_ = actors;
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										clutter_actor_add_child ((ClutterActor*) _tmp169_, (ClutterActor*) _tmp170_);
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp171_ = self->priv->worm_actors;
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp172_ = nibbles_view_get_game (self);
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp173_ = _tmp172_;
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp174_ = nibbles_game_get_worms (_tmp173_);
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp175_ = _tmp174_;
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp176_ = count;
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp177_ = gee_abstract_list_get ((GeeAbstractList*) _tmp175_, _tmp176_);
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp178_ = (Worm*) _tmp177_;
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp179_ = actors;
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										gee_abstract_map_set ((GeeAbstractMap*) _tmp171_, _tmp178_, _tmp179_);
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (_tmp178_);
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp180_ = count;
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										count = _tmp180_ + 1;
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (actors);
#line 1819 "nibbles-view.c"
									}
#line 260 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									break;
#line 1823 "nibbles-view.c"
								}
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								case 'p':
#line 1827 "nibbles-view.c"
								{
									NibblesGame* _tmp181_ = NULL;
									NibblesGame* _tmp182_ = NULL;
									gint* _tmp183_ = NULL;
									gint _tmp183__length1 = 0;
									gint _tmp183__length2 = 0;
									gint _tmp184_ = 0;
									gint _tmp185_ = 0;
									gint _tmp186_ = 0;
									gint _tmp187_ = 0;
									NibblesGame* _tmp188_ = NULL;
									NibblesGame* _tmp189_ = NULL;
									gint _tmp190_ = 0;
									gint _tmp191_ = 0;
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp181_ = nibbles_view_get_game (self);
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp182_ = _tmp181_;
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp183_ = _tmp182_->board;
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp183__length1 = _tmp182_->board_length1;
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp183__length2 = _tmp182_->board_length2;
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp184_ = j;
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp185_ = i;
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp183_[(_tmp184_ * _tmp183__length2) + _tmp185_] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp186_ = _tmp183_[(_tmp184_ * _tmp183__length2) + _tmp185_];
#line 263 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp187_ = count;
#line 263 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp188_ = nibbles_view_get_game (self);
#line 263 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp189_ = _tmp188_;
#line 263 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp190_ = nibbles_game_get_numworms (_tmp189_);
#line 263 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									_tmp191_ = _tmp190_;
#line 263 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									if (_tmp187_ < _tmp191_) {
#line 1872 "nibbles-view.c"
										NibblesGame* _tmp192_ = NULL;
										NibblesGame* _tmp193_ = NULL;
										GeeLinkedList* _tmp194_ = NULL;
										GeeLinkedList* _tmp195_ = NULL;
										gint _tmp196_ = 0;
										gpointer _tmp197_ = NULL;
										Worm* _tmp198_ = NULL;
										gint _tmp199_ = 0;
										gint _tmp200_ = 0;
										WormActor* actors = NULL;
										WormActor* _tmp201_ = NULL;
										ClutterStage* _tmp202_ = NULL;
										WormActor* _tmp203_ = NULL;
										GeeHashMap* _tmp204_ = NULL;
										NibblesGame* _tmp205_ = NULL;
										NibblesGame* _tmp206_ = NULL;
										GeeLinkedList* _tmp207_ = NULL;
										GeeLinkedList* _tmp208_ = NULL;
										gint _tmp209_ = 0;
										gpointer _tmp210_ = NULL;
										Worm* _tmp211_ = NULL;
										WormActor* _tmp212_ = NULL;
										gint _tmp213_ = 0;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp192_ = nibbles_view_get_game (self);
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp193_ = _tmp192_;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp194_ = nibbles_game_get_worms (_tmp193_);
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp195_ = _tmp194_;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp196_ = count;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp197_ = gee_abstract_list_get ((GeeAbstractList*) _tmp195_, _tmp196_);
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp198_ = (Worm*) _tmp197_;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp199_ = j;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp200_ = i;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										worm_set_start (_tmp198_, _tmp199_, _tmp200_, WORM_DIRECTION_RIGHT);
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (_tmp198_);
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp201_ = worm_actor_new ();
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										g_object_ref_sink (_tmp201_);
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										actors = _tmp201_;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp202_ = self->priv->stage;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp203_ = actors;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										clutter_actor_add_child ((ClutterActor*) _tmp202_, (ClutterActor*) _tmp203_);
#line 269 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp204_ = self->priv->worm_actors;
#line 269 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp205_ = nibbles_view_get_game (self);
#line 269 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp206_ = _tmp205_;
#line 269 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp207_ = nibbles_game_get_worms (_tmp206_);
#line 269 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp208_ = _tmp207_;
#line 269 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp209_ = count;
#line 269 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp210_ = gee_abstract_list_get ((GeeAbstractList*) _tmp208_, _tmp209_);
#line 269 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp211_ = (Worm*) _tmp210_;
#line 269 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp212_ = actors;
#line 269 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										gee_abstract_map_set ((GeeAbstractMap*) _tmp204_, _tmp211_, _tmp212_);
#line 269 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (_tmp211_);
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp213_ = count;
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										count = _tmp213_ + 1;
#line 263 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (actors);
#line 1958 "nibbles-view.c"
									}
#line 272 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									break;
#line 1962 "nibbles-view.c"
								}
								default:
								{
#line 274 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									break;
#line 1968 "nibbles-view.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_load_level (self);
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_fclose0 (file);
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_free0 (tmpboard);
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_free0 (filename);
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_free0 (level_name);
#line 1987 "nibbles-view.c"
}


static void nibbles_view_load_level (NibblesView* self) {
	gint x_pos = 0;
	gint y_pos = 0;
	GtkClutterTexture* tmp = NULL;
	gboolean is_wall = FALSE;
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp4_ = NULL;
	ClutterStage* _tmp112_ = NULL;
	ClutterActor* _tmp113_ = NULL;
	ClutterActor* _tmp114_ = NULL;
	ClutterActor* _tmp115_ = NULL;
	ClutterActor* _tmp116_ = NULL;
	ClutterActor* _tmp117_ = NULL;
	ClutterActor* _tmp118_ = NULL;
	ClutterActor* _tmp119_ = NULL;
	ClutterActor* _tmp120_ = NULL;
	ClutterActor* _tmp121_ = NULL;
	ClutterActor* _tmp122_ = NULL;
	GError * _inner_error_ = NULL;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 285 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	tmp = NULL;
#line 286 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	is_wall = TRUE;
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = self->priv->level;
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	if (_tmp0_ != NULL) {
#line 2020 "nibbles-view.c"
		ClutterActor* _tmp1_ = NULL;
		ClutterStage* _tmp2_ = NULL;
		ClutterActor* _tmp3_ = NULL;
#line 290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp1_ = self->priv->level;
#line 290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		clutter_actor_remove_all_children (_tmp1_);
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp2_ = self->priv->stage;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp3_ = self->priv->level;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		clutter_actor_remove_child ((ClutterActor*) _tmp2_, _tmp3_);
#line 2034 "nibbles-view.c"
	}
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = clutter_actor_new ();
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_object_ref_sink (_tmp4_);
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (self->priv->level);
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self->priv->level = _tmp4_;
#line 2044 "nibbles-view.c"
	{
		gint i = 0;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		i = 0;
#line 2049 "nibbles-view.c"
		{
			gboolean _tmp5_ = FALSE;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp5_ = TRUE;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			while (TRUE) {
#line 2056 "nibbles-view.c"
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				NibblesGame* _tmp9_ = NULL;
				NibblesGame* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (!_tmp5_) {
#line 2065 "nibbles-view.c"
					gint _tmp6_ = 0;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp6_ = i;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					i = _tmp6_ + 1;
#line 2071 "nibbles-view.c"
				}
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp5_ = FALSE;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp7_ = i;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (!(_tmp7_ < NIBBLES_GAME_HEIGHT)) {
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					break;
#line 2081 "nibbles-view.c"
				}
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp8_ = i;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp9_ = nibbles_view_get_game (self);
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp10_ = _tmp9_;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp11_ = nibbles_game_get_tile_size (_tmp10_);
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp12_ = _tmp11_;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				y_pos = _tmp8_ * _tmp12_;
#line 2095 "nibbles-view.c"
				{
					gint j = 0;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					j = 0;
#line 2100 "nibbles-view.c"
					{
						gboolean _tmp13_ = FALSE;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
						_tmp13_ = TRUE;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
						while (TRUE) {
#line 2107 "nibbles-view.c"
							gint _tmp15_ = 0;
							gboolean _tmp92_ = FALSE;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							if (!_tmp13_) {
#line 2112 "nibbles-view.c"
								gint _tmp14_ = 0;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp14_ = j;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								j = _tmp14_ + 1;
#line 2118 "nibbles-view.c"
							}
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp13_ = FALSE;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp15_ = j;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							if (!(_tmp15_ < NIBBLES_GAME_WIDTH)) {
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								break;
#line 2128 "nibbles-view.c"
							}
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							is_wall = TRUE;
#line 2132 "nibbles-view.c"
							{
								NibblesGame* _tmp16_ = NULL;
								NibblesGame* _tmp17_ = NULL;
								gint* _tmp18_ = NULL;
								gint _tmp18__length1 = 0;
								gint _tmp18__length2 = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp16_ = nibbles_view_get_game (self);
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp17_ = _tmp16_;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp18_ = _tmp17_->board;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp18__length1 = _tmp17_->board_length1;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp18__length2 = _tmp17_->board_length2;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp19_ = j;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp20_ = i;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								switch (_tmp21_) {
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'a':
#line 2162 "nibbles-view.c"
									{
#line 308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										is_wall = FALSE;
#line 309 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										break;
#line 2168 "nibbles-view.c"
									}
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'b':
#line 2172 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp22_ = NULL;
										GtkClutterTexture* _tmp23_ = NULL;
										GdkPixbuf* _tmp24_ = NULL;
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp22_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										g_object_ref_sink (_tmp22_);
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										tmp = _tmp22_;
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp23_ = tmp;
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp24_ = self->priv->wall_pixmaps[0];
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp23_, _tmp24_, &_inner_error_);
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2193 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 313 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										break;
#line 2198 "nibbles-view.c"
									}
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'c':
#line 2202 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp25_ = NULL;
										GtkClutterTexture* _tmp26_ = NULL;
										GdkPixbuf* _tmp27_ = NULL;
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp25_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										g_object_ref_sink (_tmp25_);
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										tmp = _tmp25_;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp26_ = tmp;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp27_ = self->priv->wall_pixmaps[1];
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp26_, _tmp27_, &_inner_error_);
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2223 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 317 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										break;
#line 2228 "nibbles-view.c"
									}
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'd':
#line 2232 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp28_ = NULL;
										GtkClutterTexture* _tmp29_ = NULL;
										GdkPixbuf* _tmp30_ = NULL;
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp28_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										g_object_ref_sink (_tmp28_);
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										tmp = _tmp28_;
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp29_ = tmp;
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp30_ = self->priv->wall_pixmaps[2];
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp29_, _tmp30_, &_inner_error_);
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2253 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 321 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										break;
#line 2258 "nibbles-view.c"
									}
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'e':
#line 2262 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp31_ = NULL;
										GtkClutterTexture* _tmp32_ = NULL;
										GdkPixbuf* _tmp33_ = NULL;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp31_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										g_object_ref_sink (_tmp31_);
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										tmp = _tmp31_;
#line 324 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp32_ = tmp;
#line 324 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp33_ = self->priv->wall_pixmaps[3];
#line 324 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp32_, _tmp33_, &_inner_error_);
#line 324 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2283 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										break;
#line 2288 "nibbles-view.c"
									}
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'f':
#line 2292 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp34_ = NULL;
										GtkClutterTexture* _tmp35_ = NULL;
										GdkPixbuf* _tmp36_ = NULL;
#line 327 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp34_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 327 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										g_object_ref_sink (_tmp34_);
#line 327 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 327 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										tmp = _tmp34_;
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp35_ = tmp;
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp36_ = self->priv->wall_pixmaps[4];
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp35_, _tmp36_, &_inner_error_);
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2313 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 329 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										break;
#line 2318 "nibbles-view.c"
									}
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'g':
#line 2322 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp37_ = NULL;
										GtkClutterTexture* _tmp38_ = NULL;
										GdkPixbuf* _tmp39_ = NULL;
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp37_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										g_object_ref_sink (_tmp37_);
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										tmp = _tmp37_;
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp38_ = tmp;
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp39_ = self->priv->wall_pixmaps[5];
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp38_, _tmp39_, &_inner_error_);
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2343 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										break;
#line 2348 "nibbles-view.c"
									}
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'h':
#line 2352 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp40_ = NULL;
										GtkClutterTexture* _tmp41_ = NULL;
										GdkPixbuf* _tmp42_ = NULL;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp40_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										g_object_ref_sink (_tmp40_);
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										tmp = _tmp40_;
#line 336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp41_ = tmp;
#line 336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp42_ = self->priv->wall_pixmaps[6];
#line 336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp41_, _tmp42_, &_inner_error_);
#line 336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2373 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										break;
#line 2378 "nibbles-view.c"
									}
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'i':
#line 2382 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp43_ = NULL;
										GtkClutterTexture* _tmp44_ = NULL;
										GdkPixbuf* _tmp45_ = NULL;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp43_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										g_object_ref_sink (_tmp43_);
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										tmp = _tmp43_;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp44_ = tmp;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp45_ = self->priv->wall_pixmaps[7];
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp44_, _tmp45_, &_inner_error_);
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2403 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 341 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										break;
#line 2408 "nibbles-view.c"
									}
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'j':
#line 2412 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp46_ = NULL;
										GtkClutterTexture* _tmp47_ = NULL;
										GdkPixbuf* _tmp48_ = NULL;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp46_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										g_object_ref_sink (_tmp46_);
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										tmp = _tmp46_;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp47_ = tmp;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp48_ = self->priv->wall_pixmaps[8];
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp47_, _tmp48_, &_inner_error_);
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2433 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										break;
#line 2438 "nibbles-view.c"
									}
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'k':
#line 2442 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp49_ = NULL;
										GtkClutterTexture* _tmp50_ = NULL;
										GdkPixbuf* _tmp51_ = NULL;
#line 347 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp49_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 347 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										g_object_ref_sink (_tmp49_);
#line 347 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 347 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										tmp = _tmp49_;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp50_ = tmp;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp51_ = self->priv->wall_pixmaps[9];
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp50_, _tmp51_, &_inner_error_);
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2463 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										break;
#line 2468 "nibbles-view.c"
									}
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'l':
#line 2472 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp52_ = NULL;
										GtkClutterTexture* _tmp53_ = NULL;
										GdkPixbuf* _tmp54_ = NULL;
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp52_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										g_object_ref_sink (_tmp52_);
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										tmp = _tmp52_;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp53_ = tmp;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp54_ = self->priv->wall_pixmaps[10];
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp53_, _tmp54_, &_inner_error_);
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2493 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										break;
#line 2498 "nibbles-view.c"
									}
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'Q':
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'R':
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'S':
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'T':
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'U':
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'V':
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'W':
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'X':
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'Y':
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'Z':
#line 2520 "nibbles-view.c"
									{
										NibblesGame* _tmp55_ = NULL;
										NibblesGame* _tmp56_ = NULL;
										WarpManager* _tmp57_ = NULL;
										WarpManager* _tmp58_ = NULL;
										NibblesGame* _tmp59_ = NULL;
										NibblesGame* _tmp60_ = NULL;
										gint* _tmp61_ = NULL;
										gint _tmp61__length1 = 0;
										gint _tmp61__length2 = 0;
										gint _tmp62_ = 0;
										gint _tmp63_ = 0;
										NibblesGame* _tmp64_ = NULL;
										NibblesGame* _tmp65_ = NULL;
										gint* _tmp66_ = NULL;
										gint _tmp66__length1 = 0;
										gint _tmp66__length2 = 0;
										gint _tmp67_ = 0;
										gint _tmp68_ = 0;
										gint _tmp69_ = 0;
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										is_wall = FALSE;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp55_ = nibbles_view_get_game (self);
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp56_ = _tmp55_;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp57_ = nibbles_game_get_warp_manager (_tmp56_);
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp58_ = _tmp57_;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp59_ = nibbles_view_get_game (self);
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp60_ = _tmp59_;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp61_ = _tmp60_->board;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp61__length1 = _tmp60_->board_length1;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp61__length2 = _tmp60_->board_length2;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp62_ = j;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp63_ = i;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp64_ = nibbles_view_get_game (self);
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp65_ = _tmp64_;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp66_ = _tmp65_->board;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp66__length1 = _tmp65_->board_length1;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp66__length2 = _tmp65_->board_length2;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp67_ = j;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp68_ = i;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp69_ = _tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_];
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										warp_manager_add_warp (_tmp58_, _tmp61_, _tmp61__length1, _tmp61__length2, _tmp62_ - 1, _tmp63_ - 1, -_tmp69_, 0);
#line 366 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										break;
#line 2585 "nibbles-view.c"
									}
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'r':
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 's':
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 't':
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'u':
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'v':
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'w':
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'x':
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'y':
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
									case 'z':
#line 2605 "nibbles-view.c"
									{
										NibblesGame* _tmp70_ = NULL;
										NibblesGame* _tmp71_ = NULL;
										WarpManager* _tmp72_ = NULL;
										WarpManager* _tmp73_ = NULL;
										NibblesGame* _tmp74_ = NULL;
										NibblesGame* _tmp75_ = NULL;
										gint* _tmp76_ = NULL;
										gint _tmp76__length1 = 0;
										gint _tmp76__length2 = 0;
										NibblesGame* _tmp77_ = NULL;
										NibblesGame* _tmp78_ = NULL;
										gint* _tmp79_ = NULL;
										gint _tmp79__length1 = 0;
										gint _tmp79__length2 = 0;
										gint _tmp80_ = 0;
										gint _tmp81_ = 0;
										gint _tmp82_ = 0;
										gint _tmp83_ = 0;
										gint _tmp84_ = 0;
										NibblesGame* _tmp85_ = NULL;
										NibblesGame* _tmp86_ = NULL;
										gint* _tmp87_ = NULL;
										gint _tmp87__length1 = 0;
										gint _tmp87__length2 = 0;
										gint _tmp88_ = 0;
										gint _tmp89_ = 0;
										gint _tmp90_ = 0;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										is_wall = FALSE;
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp70_ = nibbles_view_get_game (self);
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp71_ = _tmp70_;
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp72_ = nibbles_game_get_warp_manager (_tmp71_);
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp73_ = _tmp72_;
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp74_ = nibbles_view_get_game (self);
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp75_ = _tmp74_;
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp76_ = _tmp75_->board;
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp76__length1 = _tmp75_->board_length1;
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp76__length2 = _tmp75_->board_length2;
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp77_ = nibbles_view_get_game (self);
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp78_ = _tmp77_;
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp79_ = _tmp78_->board;
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp79__length1 = _tmp78_->board_length1;
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp79__length2 = _tmp78_->board_length2;
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp80_ = j;
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp81_ = i;
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp82_ = _tmp79_[(_tmp80_ * _tmp79__length2) + _tmp81_];
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp83_ = j;
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp84_ = i;
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										warp_manager_add_warp (_tmp73_, _tmp76_, _tmp76__length1, _tmp76__length2, -((_tmp82_ - 'a') + 'A'), 0, _tmp83_, _tmp84_);
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp85_ = nibbles_view_get_game (self);
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp86_ = _tmp85_;
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp87_ = _tmp86_->board;
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp87__length1 = _tmp86_->board_length1;
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp87__length2 = _tmp86_->board_length2;
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp88_ = j;
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp89_ = i;
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp87_[(_tmp88_ * _tmp87__length2) + _tmp89_] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										_tmp90_ = _tmp87_[(_tmp88_ * _tmp87__length2) + _tmp89_];
#line 379 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										break;
#line 2696 "nibbles-view.c"
									}
									default:
									{
#line 381 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										is_wall = FALSE;
#line 382 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
										break;
#line 2704 "nibbles-view.c"
									}
								}
							}
							goto __finally2;
							__catch2_g_error:
							{
								GError* e = NULL;
								const gchar* _tmp91_ = NULL;
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								e = _inner_error_;
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_inner_error_ = NULL;
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp91_ = e->message;
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								g_error ("nibbles-view.vala:387: Error loading level: %s", _tmp91_);
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_g_error_free0 (e);
#line 2723 "nibbles-view.c"
							}
							__finally2:
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_g_object_unref0 (tmp);
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								g_clear_error (&_inner_error_);
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								return;
#line 2736 "nibbles-view.c"
							}
#line 390 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							_tmp92_ = is_wall;
#line 390 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
							if (_tmp92_) {
#line 2742 "nibbles-view.c"
								gint _tmp93_ = 0;
								NibblesGame* _tmp94_ = NULL;
								NibblesGame* _tmp95_ = NULL;
								gint _tmp96_ = 0;
								gint _tmp97_ = 0;
								GtkClutterTexture* _tmp98_ = NULL;
								NibblesGame* _tmp99_ = NULL;
								NibblesGame* _tmp100_ = NULL;
								gint _tmp101_ = 0;
								gint _tmp102_ = 0;
								NibblesGame* _tmp103_ = NULL;
								NibblesGame* _tmp104_ = NULL;
								gint _tmp105_ = 0;
								gint _tmp106_ = 0;
								GtkClutterTexture* _tmp107_ = NULL;
								gint _tmp108_ = 0;
								gint _tmp109_ = 0;
								ClutterActor* _tmp110_ = NULL;
								GtkClutterTexture* _tmp111_ = NULL;
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp93_ = j;
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp94_ = nibbles_view_get_game (self);
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp95_ = _tmp94_;
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp96_ = nibbles_game_get_tile_size (_tmp95_);
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp97_ = _tmp96_;
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								x_pos = _tmp93_ * _tmp97_;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp98_ = tmp;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp99_ = nibbles_view_get_game (self);
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp100_ = _tmp99_;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp101_ = nibbles_game_get_tile_size (_tmp100_);
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp102_ = _tmp101_;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp103_ = nibbles_view_get_game (self);
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp104_ = _tmp103_;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp105_ = nibbles_game_get_tile_size (_tmp104_);
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp106_ = _tmp105_;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								clutter_actor_set_size ((ClutterActor*) _tmp98_, (gfloat) _tmp102_, (gfloat) _tmp106_);
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp107_ = tmp;
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp108_ = x_pos;
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp109_ = y_pos;
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								clutter_actor_set_position ((ClutterActor*) _tmp107_, (gfloat) _tmp108_, (gfloat) _tmp109_);
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp110_ = self->priv->level;
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								_tmp111_ = tmp;
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
								clutter_actor_add_child (_tmp110_, (ClutterActor*) _tmp111_);
#line 2808 "nibbles-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp112_ = self->priv->stage;
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp113_ = self->priv->level;
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_add_child ((ClutterActor*) _tmp112_, _tmp113_);
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp114_ = self->priv->level;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_opacity (_tmp114_, (guint8) 0);
#line 403 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp115_ = self->priv->level;
#line 403 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_scale (_tmp115_, 0.2, 0.2);
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp116_ = self->priv->level;
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_save_easing_state (_tmp116_);
#line 406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp117_ = self->priv->level;
#line 406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_mode (_tmp117_, CLUTTER_EASE_OUT_BOUNCE);
#line 407 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp118_ = self->priv->level;
#line 407 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_duration (_tmp118_, (guint) (NIBBLES_GAME_GAMEDELAY * NIBBLES_GAME_GAMEDELAY));
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp119_ = self->priv->level;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_scale (_tmp119_, 1.0, 1.0);
#line 409 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp120_ = self->priv->level;
#line 409 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_pivot_point (_tmp120_, 0.5f, 0.5f);
#line 410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp121_ = self->priv->level;
#line 410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_opacity (_tmp121_, (guint8) 0xff);
#line 411 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp122_ = self->priv->level;
#line 411 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_restore_easing_state (_tmp122_);
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (tmp);
#line 2860 "nibbles-view.c"
}


GdkPixbuf* nibbles_view_load_pixmap_file (NibblesView* self, const gchar* pixmap, gint xsize, gint ysize) {
	GdkPixbuf* result = NULL;
	gchar* filename = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GdkPixbuf* image = NULL;
	GError * _inner_error_ = NULL;
#line 418 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 418 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_val_if_fail (pixmap != NULL, NULL);
#line 420 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = pixmap;
#line 420 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = g_build_filename (PKGDATADIR, "pixmaps", _tmp0_, NULL, NULL);
#line 420 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	filename = _tmp1_;
#line 421 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	if (filename == NULL) {
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_error ("nibbles-view.vala:422: Nibbles couldn't find pixmap file: %s", filename);
#line 2885 "nibbles-view.c"
	}
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	image = NULL;
#line 2889 "nibbles-view.c"
	{
		GdkPixbuf* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		GdkPixbuf* _tmp5_ = NULL;
		GdkPixbuf* _tmp6_ = NULL;
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp3_ = xsize;
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp4_ = ysize;
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp5_ = gdk_pixbuf_new_from_file_at_scale (filename, _tmp3_, _tmp4_, TRUE, &_inner_error_);
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp2_ = _tmp5_;
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2906 "nibbles-view.c"
			goto __catch3_g_error;
		}
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp6_ = _tmp2_;
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp2_ = NULL;
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (image);
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		image = _tmp6_;
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (_tmp2_);
#line 2919 "nibbles-view.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		e = _inner_error_;
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_inner_error_ = NULL;
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp7_ = e;
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp8_ = _tmp7_->message;
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_warning ("nibbles-view.vala:431: Failed to load pixmap file: %s", _tmp8_);
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_error_free0 (e);
#line 2939 "nibbles-view.c"
	}
	__finally3:
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (image);
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_free0 (filename);
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_clear_error (&_inner_error_);
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		return NULL;
#line 2954 "nibbles-view.c"
	}
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	result = image;
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_free0 (filename);
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	return result;
#line 2962 "nibbles-view.c"
}


static void nibbles_view_load_pixmap (NibblesView* self) {
	gchar** bonus_files = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint bonus_files_length1 = 0;
	gint _bonus_files_size_ = 0;
	gchar** small_files = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gint small_files_length1 = 0;
	gint _small_files_size_ = 0;
	gchar** worm_files = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar** _tmp25_ = NULL;
	gint worm_files_length1 = 0;
	gint _worm_files_size_ = 0;
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = g_strdup ("bonus1.svg");
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = g_strdup ("bonus2.svg");
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp2_ = g_strdup ("bonus3.svg");
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_ = g_strdup ("life.svg");
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = g_strdup ("diamond.svg");
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp5_ = g_strdup ("questionmark.svg");
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_ = g_new0 (gchar*, 6 + 1);
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_[0] = _tmp0_;
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_[1] = _tmp1_;
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_[2] = _tmp2_;
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_[3] = _tmp3_;
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_[4] = _tmp4_;
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_[5] = _tmp5_;
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	bonus_files = _tmp6_;
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	bonus_files_length1 = 6;
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_bonus_files_size_ = bonus_files_length1;
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp7_ = g_strdup ("wall-straight-up.svg");
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp8_ = g_strdup ("wall-straight-side.svg");
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp9_ = g_strdup ("wall-corner-bottom-left.svg");
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp10_ = g_strdup ("wall-corner-bottom-right.svg");
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp11_ = g_strdup ("wall-corner-top-left.svg");
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp12_ = g_strdup ("wall-corner-top-right.svg");
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp13_ = g_strdup ("wall-tee-up.svg");
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp14_ = g_strdup ("wall-tee-right.svg");
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp15_ = g_strdup ("wall-tee-left.svg");
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp16_ = g_strdup ("wall-tee-down.svg");
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp17_ = g_strdup ("wall-cross.svg");
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp18_ = g_new0 (gchar*, 11 + 1);
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp18_[0] = _tmp7_;
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp18_[1] = _tmp8_;
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp18_[2] = _tmp9_;
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp18_[3] = _tmp10_;
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp18_[4] = _tmp11_;
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp18_[5] = _tmp12_;
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp18_[6] = _tmp13_;
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp18_[7] = _tmp14_;
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp18_[8] = _tmp15_;
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp18_[9] = _tmp16_;
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp18_[10] = _tmp17_;
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	small_files = _tmp18_;
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	small_files_length1 = 11;
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_small_files_size_ = small_files_length1;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp19_ = g_strdup ("snake-red.svg");
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp20_ = g_strdup ("snake-green.svg");
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp21_ = g_strdup ("snake-blue.svg");
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp22_ = g_strdup ("snake-yellow.svg");
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp23_ = g_strdup ("snake-cyan.svg");
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp24_ = g_strdup ("snake-magenta.svg");
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp25_ = g_new0 (gchar*, 6 + 1);
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp25_[0] = _tmp19_;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp25_[1] = _tmp20_;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp25_[2] = _tmp21_;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp25_[3] = _tmp22_;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp25_[4] = _tmp23_;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp25_[5] = _tmp24_;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	worm_files = _tmp25_;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	worm_files_length1 = 6;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_worm_files_size_ = worm_files_length1;
#line 3120 "nibbles-view.c"
	{
		gint i = 0;
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		i = 0;
#line 3125 "nibbles-view.c"
		{
			gboolean _tmp26_ = FALSE;
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp26_ = TRUE;
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			while (TRUE) {
#line 3132 "nibbles-view.c"
				gint _tmp28_ = 0;
				gchar** _tmp29_ = NULL;
				gint _tmp29__length1 = 0;
				gint _tmp30_ = 0;
				gchar** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gint _tmp32_ = 0;
				const gchar* _tmp33_ = NULL;
				NibblesGame* _tmp34_ = NULL;
				NibblesGame* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				NibblesGame* _tmp38_ = NULL;
				NibblesGame* _tmp39_ = NULL;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
				GdkPixbuf* _tmp42_ = NULL;
				GdkPixbuf* _tmp43_ = NULL;
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (!_tmp26_) {
#line 3153 "nibbles-view.c"
					gint _tmp27_ = 0;
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp27_ = i;
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					i = _tmp27_ + 1;
#line 3159 "nibbles-view.c"
				}
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp26_ = FALSE;
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp28_ = i;
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp29_ = bonus_files;
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp29__length1 = bonus_files_length1;
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (!(_tmp28_ < _tmp29__length1)) {
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					break;
#line 3173 "nibbles-view.c"
				}
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp30_ = i;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp31_ = bonus_files;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp31__length1 = bonus_files_length1;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp32_ = i;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp33_ = _tmp31_[_tmp32_];
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp34_ = nibbles_view_get_game (self);
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp35_ = _tmp34_;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp36_ = nibbles_game_get_tile_size (_tmp35_);
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp37_ = _tmp36_;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp38_ = nibbles_view_get_game (self);
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp39_ = _tmp38_;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp40_ = nibbles_game_get_tile_size (_tmp39_);
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp41_ = _tmp40_;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp42_ = nibbles_view_load_pixmap_file (self, _tmp33_, 2 * _tmp37_, 2 * _tmp41_);
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_g_object_unref0 (self->priv->boni_pixmaps[_tmp30_]);
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				self->priv->boni_pixmaps[_tmp30_] = _tmp42_;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp43_ = self->priv->boni_pixmaps[_tmp30_];
#line 3209 "nibbles-view.c"
			}
		}
	}
	{
		gint i = 0;
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		i = 0;
#line 3217 "nibbles-view.c"
		{
			gboolean _tmp44_ = FALSE;
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp44_ = TRUE;
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			while (TRUE) {
#line 3224 "nibbles-view.c"
				gint _tmp46_ = 0;
				gchar** _tmp47_ = NULL;
				gint _tmp47__length1 = 0;
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				gint _tmp50_ = 0;
				const gchar* _tmp51_ = NULL;
				NibblesGame* _tmp52_ = NULL;
				NibblesGame* _tmp53_ = NULL;
				gint _tmp54_ = 0;
				gint _tmp55_ = 0;
				NibblesGame* _tmp56_ = NULL;
				NibblesGame* _tmp57_ = NULL;
				gint _tmp58_ = 0;
				gint _tmp59_ = 0;
				GdkPixbuf* _tmp60_ = NULL;
				GdkPixbuf* _tmp61_ = NULL;
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (!_tmp44_) {
#line 3245 "nibbles-view.c"
					gint _tmp45_ = 0;
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp45_ = i;
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					i = _tmp45_ + 1;
#line 3251 "nibbles-view.c"
				}
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp44_ = FALSE;
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp46_ = i;
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp47_ = small_files;
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp47__length1 = small_files_length1;
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (!(_tmp46_ < _tmp47__length1)) {
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					break;
#line 3265 "nibbles-view.c"
				}
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp48_ = i;
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp49_ = small_files;
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp49__length1 = small_files_length1;
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp50_ = i;
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp51_ = _tmp49_[_tmp50_];
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp52_ = nibbles_view_get_game (self);
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp53_ = _tmp52_;
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp54_ = nibbles_game_get_tile_size (_tmp53_);
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp55_ = _tmp54_;
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp56_ = nibbles_view_get_game (self);
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp57_ = _tmp56_;
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp58_ = nibbles_game_get_tile_size (_tmp57_);
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp59_ = _tmp58_;
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp60_ = nibbles_view_load_pixmap_file (self, _tmp51_, 2 * _tmp55_, 2 * _tmp59_);
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_g_object_unref0 (self->priv->wall_pixmaps[_tmp48_]);
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				self->priv->wall_pixmaps[_tmp48_] = _tmp60_;
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp61_ = self->priv->wall_pixmaps[_tmp48_];
#line 3301 "nibbles-view.c"
			}
		}
	}
	{
		gint i = 0;
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		i = 0;
#line 3309 "nibbles-view.c"
		{
			gboolean _tmp62_ = FALSE;
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp62_ = TRUE;
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			while (TRUE) {
#line 3316 "nibbles-view.c"
				gint _tmp64_ = 0;
				gchar** _tmp65_ = NULL;
				gint _tmp65__length1 = 0;
				gint _tmp66_ = 0;
				gchar** _tmp67_ = NULL;
				gint _tmp67__length1 = 0;
				gint _tmp68_ = 0;
				const gchar* _tmp69_ = NULL;
				NibblesGame* _tmp70_ = NULL;
				NibblesGame* _tmp71_ = NULL;
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
				NibblesGame* _tmp74_ = NULL;
				NibblesGame* _tmp75_ = NULL;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				GdkPixbuf* _tmp78_ = NULL;
				GdkPixbuf* _tmp79_ = NULL;
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (!_tmp62_) {
#line 3337 "nibbles-view.c"
					gint _tmp63_ = 0;
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp63_ = i;
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					i = _tmp63_ + 1;
#line 3343 "nibbles-view.c"
				}
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp62_ = FALSE;
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp64_ = i;
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp65_ = worm_files;
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp65__length1 = worm_files_length1;
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (!(_tmp64_ < _tmp65__length1)) {
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					break;
#line 3357 "nibbles-view.c"
				}
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp66_ = i;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp67_ = worm_files;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp67__length1 = worm_files_length1;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp68_ = i;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp69_ = _tmp67_[_tmp68_];
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp70_ = nibbles_view_get_game (self);
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp71_ = _tmp70_;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp72_ = nibbles_game_get_tile_size (_tmp71_);
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp73_ = _tmp72_;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp74_ = nibbles_view_get_game (self);
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp75_ = _tmp74_;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp76_ = nibbles_game_get_tile_size (_tmp75_);
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp77_ = _tmp76_;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp78_ = nibbles_view_load_pixmap_file (self, _tmp69_, _tmp73_, _tmp77_);
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_g_object_unref0 (self->priv->worm_pixmaps[_tmp66_]);
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				self->priv->worm_pixmaps[_tmp66_] = _tmp78_;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp79_ = self->priv->worm_pixmaps[_tmp66_];
#line 3393 "nibbles-view.c"
			}
		}
	}
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	worm_files = (_vala_array_free (worm_files, worm_files_length1, (GDestroyNotify) g_free), NULL);
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	small_files = (_vala_array_free (small_files, small_files_length1, (GDestroyNotify) g_free), NULL);
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	bonus_files = (_vala_array_free (bonus_files, bonus_files_length1, (GDestroyNotify) g_free), NULL);
#line 3403 "nibbles-view.c"
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	return _data6_;
#line 3412 "nibbles-view.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 3421 "nibbles-view.c"
		NibblesView* self;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		self = _data6_->self;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (_data6_->worm);
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (self);
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_slice_free (Block6Data, _data6_);
#line 3431 "nibbles-view.c"
	}
}


static void _nibbles_view_worm_added_cb_worm_added (Worm* _sender, gpointer self) {
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_worm_added_cb ((NibblesView*) self, _sender);
#line 3439 "nibbles-view.c"
}


static void _nibbles_view_worm_finish_added_cb_worm_finish_added (Worm* _sender, gpointer self) {
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_worm_finish_added_cb ((NibblesView*) self, _sender);
#line 3446 "nibbles-view.c"
}


static void _nibbles_view_worm_moved_cb_worm_moved (Worm* _sender, gpointer self) {
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_worm_moved_cb ((NibblesView*) self, _sender);
#line 3453 "nibbles-view.c"
}


static void _nibbles_view_worm_rescaled_cb_worm_rescaled (Worm* _sender, gint tile_size, gpointer self) {
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_worm_rescaled_cb ((NibblesView*) self, _sender, tile_size);
#line 3460 "nibbles-view.c"
}


static void _nibbles_view_worm_died_cb_worm_died (Worm* _sender, gpointer self) {
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_worm_died_cb ((NibblesView*) self, _sender);
#line 3467 "nibbles-view.c"
}


static void _nibbles_view_worm_tail_reduced_cb_worm_tail_reduced (Worm* _sender, gint erase_size, gpointer self) {
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_worm_tail_reduced_cb ((NibblesView*) self, _sender, erase_size);
#line 3474 "nibbles-view.c"
}


static void _nibbles_view_worm_reversed_cb_worm_reversed (Worm* _sender, gpointer self) {
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_worm_reversed_cb ((NibblesView*) self, _sender);
#line 3481 "nibbles-view.c"
}


static void ____lambda6_ (Block6Data* _data6_) {
	NibblesView* self;
	guint8 opacity = 0U;
	gint _tmp0_ = 0;
	Worm* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	WormActor* actors = NULL;
	GeeHashMap* _tmp4_ = NULL;
	Worm* _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self = _data6_->self;
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = _data6_->worm;
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp2_ = worm_get_is_materialized (_tmp1_);
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_ = _tmp2_;
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	if (_tmp3_) {
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp0_ = 0xff;
#line 3508 "nibbles-view.c"
	} else {
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp0_ = 0x50;
#line 3512 "nibbles-view.c"
	}
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	opacity = (guint8) _tmp0_;
#line 508 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = self->priv->worm_actors;
#line 508 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp5_ = _data6_->worm;
#line 508 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
#line 508 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	actors = (WormActor*) _tmp6_;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_save_easing_state ((ClutterActor*) actors);
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) actors, (guint) (NIBBLES_GAME_GAMEDELAY * 10));
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) actors, opacity);
#line 513 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_restore_easing_state ((ClutterActor*) actors);
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (actors);
#line 3534 "nibbles-view.c"
}


static void _____lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	____lambda6_ (self);
#line 3541 "nibbles-view.c"
}


void nibbles_view_connect_worm_signals (NibblesView* self) {
#line 493 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 3548 "nibbles-view.c"
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp0_ = NULL;
		NibblesGame* _tmp1_ = NULL;
		GeeLinkedList* _tmp2_ = NULL;
		GeeLinkedList* _tmp3_ = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _worm_index = 0;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp0_ = nibbles_view_get_game (self);
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp1_ = _tmp0_;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp2_ = nibbles_game_get_worms (_tmp1_);
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp3_ = _tmp2_;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_worm_list = _tmp4_;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp5_ = _worm_list;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp7_ = _tmp6_;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_worm_size = _tmp7_;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_worm_index = -1;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		while (TRUE) {
#line 3585 "nibbles-view.c"
			Block6Data* _data6_;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			GeeLinkedList* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gpointer _tmp13_ = NULL;
			Worm* _tmp14_ = NULL;
			Worm* _tmp15_ = NULL;
			Worm* _tmp16_ = NULL;
			Worm* _tmp17_ = NULL;
			Worm* _tmp18_ = NULL;
			Worm* _tmp19_ = NULL;
			Worm* _tmp20_ = NULL;
			Worm* _tmp21_ = NULL;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_data6_ = g_slice_new0 (Block6Data);
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_data6_->_ref_count_ = 1;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_data6_->self = g_object_ref (self);
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp8_ = _worm_index;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_worm_index = _tmp8_ + 1;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp9_ = _worm_index;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp10_ = _worm_size;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				block6_data_unref (_data6_);
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_data6_ = NULL;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				break;
#line 3623 "nibbles-view.c"
			}
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp11_ = _worm_list;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp12_ = _worm_index;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_data6_->worm = (Worm*) _tmp13_;
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp14_ = _data6_->worm;
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			g_signal_connect_object (_tmp14_, "added", (GCallback) _nibbles_view_worm_added_cb_worm_added, self, 0);
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp15_ = _data6_->worm;
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			g_signal_connect_object (_tmp15_, "finish-added", (GCallback) _nibbles_view_worm_finish_added_cb_worm_finish_added, self, 0);
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp16_ = _data6_->worm;
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			g_signal_connect_object (_tmp16_, "moved", (GCallback) _nibbles_view_worm_moved_cb_worm_moved, self, 0);
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp17_ = _data6_->worm;
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			g_signal_connect_object (_tmp17_, "rescaled", (GCallback) _nibbles_view_worm_rescaled_cb_worm_rescaled, self, 0);
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp18_ = _data6_->worm;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			g_signal_connect_object (_tmp18_, "died", (GCallback) _nibbles_view_worm_died_cb_worm_died, self, 0);
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp19_ = _data6_->worm;
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			g_signal_connect_object (_tmp19_, "tail-reduced", (GCallback) _nibbles_view_worm_tail_reduced_cb_worm_tail_reduced, self, 0);
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp20_ = _data6_->worm;
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			g_signal_connect_object (_tmp20_, "reversed", (GCallback) _nibbles_view_worm_reversed_cb_worm_reversed, self, 0);
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp21_ = _data6_->worm;
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			g_signal_connect_data ((GObject*) _tmp21_, "notify::is-materialized", (GCallback) _____lambda6__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			block6_data_unref (_data6_);
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_data6_ = NULL;
#line 3669 "nibbles-view.c"
		}
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (_worm_list);
#line 3673 "nibbles-view.c"
	}
}


void nibbles_view_board_rescale (NibblesView* self, gint tile_size) {
	gint board_width = 0;
	gint board_height = 0;
	gfloat x_pos = 0.0F;
	gfloat y_pos = 0.0F;
	ClutterActor* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ClutterActor* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	ClutterActor* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
#line 518 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 523 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = self->priv->level;
#line 523 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	if (_tmp0_ == NULL) {
#line 524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		return;
#line 3699 "nibbles-view.c"
	}
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = tile_size;
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	board_width = NIBBLES_GAME_WIDTH * _tmp1_;
#line 527 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp2_ = tile_size;
#line 527 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	board_height = NIBBLES_GAME_HEIGHT * _tmp2_;
#line 529 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_ = self->priv->level;
#line 529 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = clutter_actor_get_children (_tmp3_);
#line 3713 "nibbles-view.c"
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
#line 529 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		actor_collection = _tmp4_;
#line 529 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
#line 3721 "nibbles-view.c"
			ClutterActor* actor = NULL;
#line 529 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			actor = (ClutterActor*) actor_it->data;
#line 3725 "nibbles-view.c"
			{
				ClutterActor* _tmp5_ = NULL;
				gfloat _tmp6_ = 0.0F;
				gfloat _tmp7_ = 0.0F;
				ClutterActor* _tmp8_ = NULL;
				gfloat _tmp9_ = 0.0F;
				NibblesGame* _tmp10_ = NULL;
				NibblesGame* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gfloat _tmp15_ = 0.0F;
				NibblesGame* _tmp16_ = NULL;
				NibblesGame* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				ClutterActor* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp5_ = actor;
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_get_position (_tmp5_, &_tmp6_, &_tmp7_);
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				x_pos = _tmp6_;
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				y_pos = _tmp7_;
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp8_ = actor;
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp9_ = x_pos;
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp10_ = nibbles_view_get_game (self);
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp11_ = _tmp10_;
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp12_ = nibbles_game_get_tile_size (_tmp11_);
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp13_ = _tmp12_;
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp14_ = tile_size;
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp15_ = y_pos;
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp16_ = nibbles_view_get_game (self);
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp17_ = _tmp16_;
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp18_ = nibbles_game_get_tile_size (_tmp17_);
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp19_ = _tmp18_;
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp20_ = tile_size;
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_set_position (_tmp8_, (_tmp9_ / _tmp13_) * _tmp14_, (_tmp15_ / _tmp19_) * _tmp20_);
#line 534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp21_ = actor;
#line 534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp22_ = tile_size;
#line 534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp23_ = tile_size;
#line 534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_set_size (_tmp21_, (gfloat) _tmp22_, (gfloat) _tmp23_);
#line 3790 "nibbles-view.c"
			}
		}
#line 529 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_list_free0 (actor_collection);
#line 3795 "nibbles-view.c"
	}
#line 537 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp24_ = self->priv->_name_labels;
#line 537 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_object_get (_tmp24_, "visible", &_tmp25_, NULL);
#line 537 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp26_ = _tmp25_;
#line 537 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	if (!_tmp26_) {
#line 538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		return;
#line 3807 "nibbles-view.c"
	}
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp27_ = NULL;
		NibblesGame* _tmp28_ = NULL;
		GeeLinkedList* _tmp29_ = NULL;
		GeeLinkedList* _tmp30_ = NULL;
		GeeLinkedList* _tmp31_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gint _worm_index = 0;
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp27_ = nibbles_view_get_game (self);
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp28_ = _tmp27_;
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp29_ = nibbles_game_get_worms (_tmp28_);
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp30_ = _tmp29_;
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp31_ = _g_object_ref0 (_tmp30_);
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_worm_list = _tmp31_;
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp32_ = _worm_list;
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp33_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp32_);
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp34_ = _tmp33_;
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_worm_size = _tmp34_;
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_worm_index = -1;
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		while (TRUE) {
#line 3845 "nibbles-view.c"
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			gpointer _tmp40_ = NULL;
			ClutterActor* actor = NULL;
			ClutterActor* _tmp41_ = NULL;
			Worm* _tmp42_ = NULL;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			ClutterActor* _tmp45_ = NULL;
			ClutterActor* _tmp46_ = NULL;
			gint middle = 0;
			Worm* _tmp47_ = NULL;
			gint _tmp48_ = 0;
			gint _tmp49_ = 0;
			gboolean _tmp50_ = FALSE;
			Worm* _tmp51_ = NULL;
			WormDirection _tmp52_ = 0;
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp35_ = _worm_index;
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_worm_index = _tmp35_ + 1;
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp36_ = _worm_index;
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp37_ = _worm_size;
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			if (!(_tmp36_ < _tmp37_)) {
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				break;
#line 3879 "nibbles-view.c"
			}
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp38_ = _worm_list;
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp39_ = _worm_index;
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp38_, _tmp39_);
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			worm = (Worm*) _tmp40_;
#line 542 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp41_ = self->priv->_name_labels;
#line 542 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp42_ = worm;
#line 542 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp43_ = worm_get_id (_tmp42_);
#line 542 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp44_ = _tmp43_;
#line 542 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp45_ = clutter_actor_get_child_at_index (_tmp41_, _tmp44_);
#line 542 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp46_ = _g_object_ref0 (_tmp45_);
#line 542 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			actor = _tmp46_;
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp47_ = worm;
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp48_ = worm_get_length (_tmp47_);
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp49_ = _tmp48_;
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			middle = _tmp49_ / 2;
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp51_ = worm;
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp52_ = _tmp51_->direction;
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			if (_tmp52_ == WORM_DIRECTION_UP) {
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp50_ = TRUE;
#line 3919 "nibbles-view.c"
			} else {
				Worm* _tmp53_ = NULL;
				WormDirection _tmp54_ = 0;
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp53_ = worm;
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp54_ = _tmp53_->direction;
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp50_ = _tmp54_ == WORM_DIRECTION_DOWN;
#line 3929 "nibbles-view.c"
			}
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			if (_tmp50_) {
#line 3933 "nibbles-view.c"
				ClutterActor* _tmp55_ = NULL;
				Worm* _tmp56_ = NULL;
				GeeLinkedList* _tmp57_ = NULL;
				GeeLinkedList* _tmp58_ = NULL;
				gint _tmp59_ = 0;
				gpointer _tmp60_ = NULL;
				Position* _tmp61_ = NULL;
				gint _tmp62_ = 0;
				gint _tmp63_ = 0;
				ClutterActor* _tmp64_ = NULL;
				gfloat _tmp65_ = 0.0F;
				gfloat _tmp66_ = 0.0F;
				gint _tmp67_ = 0;
				ClutterActor* _tmp68_ = NULL;
				Worm* _tmp69_ = NULL;
				GeeLinkedList* _tmp70_ = NULL;
				GeeLinkedList* _tmp71_ = NULL;
				gint _tmp72_ = 0;
				gpointer _tmp73_ = NULL;
				Position* _tmp74_ = NULL;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp55_ = actor;
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp56_ = worm;
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp57_ = worm_get_list (_tmp56_);
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp58_ = _tmp57_;
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp59_ = middle;
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp60_ = gee_abstract_list_get ((GeeAbstractList*) _tmp58_, _tmp59_);
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp61_ = (Position*) _tmp60_;
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp62_ = (*_tmp61_).x;
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp63_ = tile_size;
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp64_ = actor;
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp65_ = clutter_actor_get_width (_tmp64_);
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp66_ = _tmp65_;
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp67_ = tile_size;
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_set_x (_tmp55_, ((_tmp62_ * _tmp63_) - (_tmp66_ / 2)) + (_tmp67_ / 2));
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_position_free0 (_tmp61_);
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp68_ = actor;
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp69_ = worm;
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp70_ = worm_get_list (_tmp69_);
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp71_ = _tmp70_;
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp72_ = middle;
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp73_ = gee_abstract_list_get ((GeeAbstractList*) _tmp71_, _tmp72_);
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp74_ = (Position*) _tmp73_;
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp75_ = (*_tmp74_).y;
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp76_ = tile_size;
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp77_ = tile_size;
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_set_y (_tmp68_, (gfloat) ((_tmp75_ * _tmp76_) - (5 * _tmp77_)));
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_position_free0 (_tmp74_);
#line 4011 "nibbles-view.c"
			} else {
				gboolean _tmp78_ = FALSE;
				Worm* _tmp79_ = NULL;
				WormDirection _tmp80_ = 0;
#line 550 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp79_ = worm;
#line 550 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp80_ = _tmp79_->direction;
#line 550 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (_tmp80_ == WORM_DIRECTION_LEFT) {
#line 550 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp78_ = TRUE;
#line 4024 "nibbles-view.c"
				} else {
					Worm* _tmp81_ = NULL;
					WormDirection _tmp82_ = 0;
#line 550 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp81_ = worm;
#line 550 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp82_ = _tmp81_->direction;
#line 550 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp78_ = _tmp82_ == WORM_DIRECTION_RIGHT;
#line 4034 "nibbles-view.c"
				}
#line 550 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (_tmp78_) {
#line 4038 "nibbles-view.c"
					ClutterActor* _tmp83_ = NULL;
					Worm* _tmp84_ = NULL;
					GeeLinkedList* _tmp85_ = NULL;
					GeeLinkedList* _tmp86_ = NULL;
					gint _tmp87_ = 0;
					gpointer _tmp88_ = NULL;
					Position* _tmp89_ = NULL;
					gint _tmp90_ = 0;
					gint _tmp91_ = 0;
					ClutterActor* _tmp92_ = NULL;
					gfloat _tmp93_ = 0.0F;
					gfloat _tmp94_ = 0.0F;
					gint _tmp95_ = 0;
					ClutterActor* _tmp96_ = NULL;
					Worm* _tmp97_ = NULL;
					Position _tmp98_ = {0};
					Position _tmp99_ = {0};
					gint _tmp100_ = 0;
					gint _tmp101_ = 0;
					gint _tmp102_ = 0;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp83_ = actor;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp84_ = worm;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp85_ = worm_get_list (_tmp84_);
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp86_ = _tmp85_;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp87_ = middle;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp88_ = gee_abstract_list_get ((GeeAbstractList*) _tmp86_, _tmp87_);
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp89_ = (Position*) _tmp88_;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp90_ = (*_tmp89_).x;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp91_ = tile_size;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp92_ = actor;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp93_ = clutter_actor_get_width (_tmp92_);
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp94_ = _tmp93_;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp95_ = tile_size;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					clutter_actor_set_x (_tmp83_, ((_tmp90_ * _tmp91_) - (_tmp94_ / 2)) + (_tmp95_ / 2));
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_position_free0 (_tmp89_);
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp96_ = actor;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp97_ = worm;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					worm_get_head (_tmp97_, &_tmp98_);
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp99_ = _tmp98_;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp100_ = _tmp99_.y;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp101_ = tile_size;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp102_ = tile_size;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					clutter_actor_set_y (_tmp96_, (gfloat) ((_tmp100_ * _tmp101_) - (3 * _tmp102_)));
#line 4105 "nibbles-view.c"
				}
			}
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_object_unref0 (actor);
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_object_unref0 (worm);
#line 4112 "nibbles-view.c"
		}
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (_worm_list);
#line 4116 "nibbles-view.c"
	}
}


static void nibbles_view_animate_end_game_cb (NibblesView* self) {
	ClutterActor* _tmp37_ = NULL;
	ClutterActor* _tmp38_ = NULL;
	ClutterActor* _tmp39_ = NULL;
	ClutterActor* _tmp40_ = NULL;
	ClutterActor* _tmp41_ = NULL;
	ClutterActor* _tmp42_ = NULL;
	ClutterActor* _tmp43_ = NULL;
#line 558 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 4131 "nibbles-view.c"
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp0_ = NULL;
		NibblesGame* _tmp1_ = NULL;
		GeeLinkedList* _tmp2_ = NULL;
		GeeLinkedList* _tmp3_ = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _worm_index = 0;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp0_ = nibbles_view_get_game (self);
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp1_ = _tmp0_;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp2_ = nibbles_game_get_worms (_tmp1_);
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp3_ = _tmp2_;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_worm_list = _tmp4_;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp5_ = _worm_list;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp7_ = _tmp6_;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_worm_size = _tmp7_;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_worm_index = -1;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		while (TRUE) {
#line 4168 "nibbles-view.c"
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gpointer _tmp13_ = NULL;
			GeeHashMap* _tmp14_ = NULL;
			Worm* _tmp15_ = NULL;
			gpointer _tmp16_ = NULL;
			WormActor* _tmp17_ = NULL;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp8_ = _worm_index;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_worm_index = _tmp8_ + 1;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp9_ = _worm_index;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp10_ = _worm_size;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				break;
#line 4192 "nibbles-view.c"
			}
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp11_ = _worm_list;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp12_ = _worm_index;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			worm = (Worm*) _tmp13_;
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp14_ = self->priv->worm_actors;
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp15_ = worm;
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, _tmp15_);
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp17_ = (WormActor*) _tmp16_;
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			clutter_actor_hide ((ClutterActor*) _tmp17_);
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_object_unref0 (_tmp17_);
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_object_unref0 (worm);
#line 4216 "nibbles-view.c"
		}
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (_worm_list);
#line 4220 "nibbles-view.c"
	}
	{
		GeeLinkedList* _warp_list = NULL;
		NibblesGame* _tmp18_ = NULL;
		NibblesGame* _tmp19_ = NULL;
		WarpManager* _tmp20_ = NULL;
		WarpManager* _tmp21_ = NULL;
		GeeLinkedList* _tmp22_ = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		gint _warp_size = 0;
		GeeLinkedList* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		gint _warp_index = 0;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp18_ = nibbles_view_get_game (self);
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp19_ = _tmp18_;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp20_ = nibbles_game_get_warp_manager (_tmp19_);
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp21_ = _tmp20_;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp22_ = _tmp21_->warps;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp23_ = _g_object_ref0 (_tmp22_);
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_warp_list = _tmp23_;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp24_ = _warp_list;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp25_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp24_);
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp26_ = _tmp25_;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_warp_size = _tmp26_;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_warp_index = -1;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		while (TRUE) {
#line 4261 "nibbles-view.c"
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			Warp* warp = NULL;
			GeeLinkedList* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			gpointer _tmp32_ = NULL;
			GeeHashMap* _tmp33_ = NULL;
			Warp* _tmp34_ = NULL;
			gpointer _tmp35_ = NULL;
			WarpTexture* _tmp36_ = NULL;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp27_ = _warp_index;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_warp_index = _tmp27_ + 1;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp28_ = _warp_index;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp29_ = _warp_size;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			if (!(_tmp28_ < _tmp29_)) {
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				break;
#line 4285 "nibbles-view.c"
			}
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp30_ = _warp_list;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp31_ = _warp_index;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _tmp31_);
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			warp = (Warp*) _tmp32_;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp33_ = self->priv->warp_actors;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp34_ = warp;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp35_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp33_, _tmp34_);
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp36_ = (WarpTexture*) _tmp35_;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			clutter_actor_hide ((ClutterActor*) _tmp36_);
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_object_unref0 (_tmp36_);
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_object_unref0 (warp);
#line 4309 "nibbles-view.c"
		}
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (_warp_list);
#line 4313 "nibbles-view.c"
	}
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp37_ = self->priv->level;
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_save_easing_state (_tmp37_);
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp38_ = self->priv->level;
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_mode (_tmp38_, CLUTTER_EASE_IN_QUAD);
#line 568 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp39_ = self->priv->level;
#line 568 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_duration (_tmp39_, (guint) (NIBBLES_GAME_GAMEDELAY * 20));
#line 569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp40_ = self->priv->level;
#line 569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_scale (_tmp40_, (gdouble) 0.4f, (gdouble) 0.4f);
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp41_ = self->priv->level;
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_pivot_point (_tmp41_, 0.5f, 0.5f);
#line 571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp42_ = self->priv->level;
#line 571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_opacity (_tmp42_, (guint8) 0);
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp43_ = self->priv->level;
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_restore_easing_state (_tmp43_);
#line 4343 "nibbles-view.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1412 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1413 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	result = self;
#line 1413 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 4355 "nibbles-view.c"
}


void nibbles_view_create_name_labels (NibblesView* self) {
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
	ClutterActor* _tmp124_ = NULL;
	ClutterActor* _tmp125_ = NULL;
#line 575 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 577 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = clutter_actor_new ();
#line 577 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_object_ref_sink (_tmp0_);
#line 577 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = _tmp0_;
#line 577 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_set_name_labels (self, _tmp1_);
#line 577 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (_tmp1_);
#line 4376 "nibbles-view.c"
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp2_ = NULL;
		NibblesGame* _tmp3_ = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		GeeLinkedList* _tmp5_ = NULL;
		GeeLinkedList* _tmp6_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _worm_index = 0;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp2_ = nibbles_view_get_game (self);
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp3_ = _tmp2_;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp4_ = nibbles_game_get_worms (_tmp3_);
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp5_ = _tmp4_;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_worm_list = _tmp6_;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp7_ = _worm_list;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp7_);
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp9_ = _tmp8_;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_worm_size = _tmp9_;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_worm_index = -1;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		while (TRUE) {
#line 4413 "nibbles-view.c"
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gpointer _tmp15_ = NULL;
			gint color = 0;
			NibblesGame* _tmp16_ = NULL;
			NibblesGame* _tmp17_ = NULL;
			GeeHashMap* _tmp18_ = NULL;
			GeeHashMap* _tmp19_ = NULL;
			Worm* _tmp20_ = NULL;
			gpointer _tmp21_ = NULL;
			WormProperties* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			gchar* player_id = NULL;
			const gchar* _tmp25_ = NULL;
			Worm* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gchar* _tmp29_ = NULL;
			ClutterText* label = NULL;
			const gchar* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			ClutterText* _tmp34_ = NULL;
			ClutterText* _tmp35_ = NULL;
			ClutterText* _tmp36_ = NULL;
			ClutterText* _tmp37_ = NULL;
			gint _tmp38_ = 0;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			ClutterColor _tmp41_ = {0};
			gint middle = 0;
			Worm* _tmp42_ = NULL;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			gboolean _tmp45_ = FALSE;
			Worm* _tmp46_ = NULL;
			WormDirection _tmp47_ = 0;
			ClutterActor* _tmp122_ = NULL;
			ClutterText* _tmp123_ = NULL;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp10_ = _worm_index;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_worm_index = _tmp10_ + 1;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp11_ = _worm_index;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp12_ = _worm_size;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			if (!(_tmp11_ < _tmp12_)) {
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				break;
#line 4471 "nibbles-view.c"
			}
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp13_ = _worm_list;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp14_ = _worm_index;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _tmp14_);
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			worm = (Worm*) _tmp15_;
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp16_ = nibbles_view_get_game (self);
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp17_ = _tmp16_;
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp18_ = nibbles_game_get_worm_props (_tmp17_);
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp19_ = _tmp18_;
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp20_ = worm;
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, _tmp20_);
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp22_ = (WormProperties*) _tmp21_;
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp23_ = (*_tmp22_).color;
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp24_ = _tmp23_;
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_worm_properties_free0 (_tmp22_);
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			color = _tmp24_;
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp25_ = _ ("Player %d");
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp26_ = worm;
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp27_ = worm_get_id (_tmp26_);
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp28_ = _tmp27_;
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp29_ = g_strdup_printf (_tmp25_, _tmp28_ + 1);
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			player_id = _tmp29_;
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp30_ = player_id;
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp31_ = string_to_string (_tmp30_);
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp32_ = g_strconcat ("<b>", _tmp31_, "</b>", NULL);
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp33_ = _tmp32_;
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp34_ = (ClutterText*) clutter_text_new_with_text ("Monospace 10", _tmp33_);
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			g_object_ref_sink (_tmp34_);
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp35_ = _tmp34_;
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_free0 (_tmp33_);
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			label = _tmp35_;
#line 585 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp36_ = label;
#line 585 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			clutter_text_set_use_markup (_tmp36_, TRUE);
#line 586 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp37_ = label;
#line 586 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp38_ = color;
#line 586 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp39_ = nibbles_view_colorval_name (_tmp38_);
#line 586 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp40_ = _tmp39_;
#line 586 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			clutter_color_from_string (&_tmp41_, _tmp40_);
#line 586 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			clutter_text_set_color (_tmp37_, &_tmp41_);
#line 586 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_free0 (_tmp40_);
#line 588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp42_ = worm;
#line 588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp43_ = worm_get_length (_tmp42_);
#line 588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp44_ = _tmp43_;
#line 588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			middle = _tmp44_ / 2;
#line 589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp46_ = worm;
#line 589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp47_ = _tmp46_->direction;
#line 589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			if (_tmp47_ == WORM_DIRECTION_UP) {
#line 589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp45_ = TRUE;
#line 4567 "nibbles-view.c"
			} else {
				Worm* _tmp48_ = NULL;
				WormDirection _tmp49_ = 0;
#line 589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp48_ = worm;
#line 589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp49_ = _tmp48_->direction;
#line 589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp45_ = _tmp49_ == WORM_DIRECTION_DOWN;
#line 4577 "nibbles-view.c"
			}
#line 589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			if (_tmp45_) {
#line 4581 "nibbles-view.c"
				ClutterText* _tmp50_ = NULL;
				Worm* _tmp51_ = NULL;
				GeeLinkedList* _tmp52_ = NULL;
				GeeLinkedList* _tmp53_ = NULL;
				gint _tmp54_ = 0;
				gpointer _tmp55_ = NULL;
				Position* _tmp56_ = NULL;
				gint _tmp57_ = 0;
				NibblesGame* _tmp58_ = NULL;
				NibblesGame* _tmp59_ = NULL;
				gint _tmp60_ = 0;
				gint _tmp61_ = 0;
				ClutterText* _tmp62_ = NULL;
				gfloat _tmp63_ = 0.0F;
				gfloat _tmp64_ = 0.0F;
				NibblesGame* _tmp65_ = NULL;
				NibblesGame* _tmp66_ = NULL;
				gint _tmp67_ = 0;
				gint _tmp68_ = 0;
				ClutterText* _tmp69_ = NULL;
				Worm* _tmp70_ = NULL;
				GeeLinkedList* _tmp71_ = NULL;
				GeeLinkedList* _tmp72_ = NULL;
				gint _tmp73_ = 0;
				gpointer _tmp74_ = NULL;
				Position* _tmp75_ = NULL;
				gint _tmp76_ = 0;
				NibblesGame* _tmp77_ = NULL;
				NibblesGame* _tmp78_ = NULL;
				gint _tmp79_ = 0;
				gint _tmp80_ = 0;
				NibblesGame* _tmp81_ = NULL;
				NibblesGame* _tmp82_ = NULL;
				gint _tmp83_ = 0;
				gint _tmp84_ = 0;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp50_ = label;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp51_ = worm;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp52_ = worm_get_list (_tmp51_);
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp53_ = _tmp52_;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp54_ = middle;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp55_ = gee_abstract_list_get ((GeeAbstractList*) _tmp53_, _tmp54_);
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp56_ = (Position*) _tmp55_;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp57_ = (*_tmp56_).x;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp58_ = nibbles_view_get_game (self);
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp59_ = _tmp58_;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp60_ = nibbles_game_get_tile_size (_tmp59_);
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp61_ = _tmp60_;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp62_ = label;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp63_ = clutter_actor_get_width ((ClutterActor*) _tmp62_);
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp64_ = _tmp63_;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp65_ = nibbles_view_get_game (self);
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp66_ = _tmp65_;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp67_ = nibbles_game_get_tile_size (_tmp66_);
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp68_ = _tmp67_;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_set_x ((ClutterActor*) _tmp50_, ((_tmp57_ * _tmp61_) - (_tmp64_ / 2)) + (_tmp68_ / 2));
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_position_free0 (_tmp56_);
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp69_ = label;
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp70_ = worm;
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp71_ = worm_get_list (_tmp70_);
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp72_ = _tmp71_;
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp73_ = middle;
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp74_ = gee_abstract_list_get ((GeeAbstractList*) _tmp72_, _tmp73_);
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp75_ = (Position*) _tmp74_;
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp76_ = (*_tmp75_).y;
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp77_ = nibbles_view_get_game (self);
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp78_ = _tmp77_;
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp79_ = nibbles_game_get_tile_size (_tmp78_);
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp80_ = _tmp79_;
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp81_ = nibbles_view_get_game (self);
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp82_ = _tmp81_;
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp83_ = nibbles_game_get_tile_size (_tmp82_);
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp84_ = _tmp83_;
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_set_y ((ClutterActor*) _tmp69_, (gfloat) ((_tmp76_ * _tmp80_) - (5 * _tmp84_)));
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_position_free0 (_tmp75_);
#line 4695 "nibbles-view.c"
			} else {
				gboolean _tmp85_ = FALSE;
				Worm* _tmp86_ = NULL;
				WormDirection _tmp87_ = 0;
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp86_ = worm;
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp87_ = _tmp86_->direction;
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (_tmp87_ == WORM_DIRECTION_LEFT) {
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp85_ = TRUE;
#line 4708 "nibbles-view.c"
				} else {
					Worm* _tmp88_ = NULL;
					WormDirection _tmp89_ = 0;
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp88_ = worm;
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp89_ = _tmp88_->direction;
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp85_ = _tmp89_ == WORM_DIRECTION_RIGHT;
#line 4718 "nibbles-view.c"
				}
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (_tmp85_) {
#line 4722 "nibbles-view.c"
					ClutterText* _tmp90_ = NULL;
					Worm* _tmp91_ = NULL;
					GeeLinkedList* _tmp92_ = NULL;
					GeeLinkedList* _tmp93_ = NULL;
					gint _tmp94_ = 0;
					gpointer _tmp95_ = NULL;
					Position* _tmp96_ = NULL;
					gint _tmp97_ = 0;
					NibblesGame* _tmp98_ = NULL;
					NibblesGame* _tmp99_ = NULL;
					gint _tmp100_ = 0;
					gint _tmp101_ = 0;
					ClutterText* _tmp102_ = NULL;
					gfloat _tmp103_ = 0.0F;
					gfloat _tmp104_ = 0.0F;
					NibblesGame* _tmp105_ = NULL;
					NibblesGame* _tmp106_ = NULL;
					gint _tmp107_ = 0;
					gint _tmp108_ = 0;
					ClutterText* _tmp109_ = NULL;
					Worm* _tmp110_ = NULL;
					Position _tmp111_ = {0};
					Position _tmp112_ = {0};
					gint _tmp113_ = 0;
					NibblesGame* _tmp114_ = NULL;
					NibblesGame* _tmp115_ = NULL;
					gint _tmp116_ = 0;
					gint _tmp117_ = 0;
					NibblesGame* _tmp118_ = NULL;
					NibblesGame* _tmp119_ = NULL;
					gint _tmp120_ = 0;
					gint _tmp121_ = 0;
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp90_ = label;
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp91_ = worm;
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp92_ = worm_get_list (_tmp91_);
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp93_ = _tmp92_;
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp94_ = middle;
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp95_ = gee_abstract_list_get ((GeeAbstractList*) _tmp93_, _tmp94_);
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp96_ = (Position*) _tmp95_;
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp97_ = (*_tmp96_).x;
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp98_ = nibbles_view_get_game (self);
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp99_ = _tmp98_;
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp100_ = nibbles_game_get_tile_size (_tmp99_);
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp101_ = _tmp100_;
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp102_ = label;
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp103_ = clutter_actor_get_width ((ClutterActor*) _tmp102_);
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp104_ = _tmp103_;
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp105_ = nibbles_view_get_game (self);
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp106_ = _tmp105_;
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp107_ = nibbles_game_get_tile_size (_tmp106_);
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp108_ = _tmp107_;
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					clutter_actor_set_x ((ClutterActor*) _tmp90_, ((_tmp97_ * _tmp101_) - (_tmp104_ / 2)) + (_tmp108_ / 2));
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_position_free0 (_tmp96_);
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp109_ = label;
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp110_ = worm;
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					worm_get_head (_tmp110_, &_tmp111_);
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp112_ = _tmp111_;
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp113_ = _tmp112_.y;
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp114_ = nibbles_view_get_game (self);
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp115_ = _tmp114_;
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp116_ = nibbles_game_get_tile_size (_tmp115_);
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp117_ = _tmp116_;
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp118_ = nibbles_view_get_game (self);
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp119_ = _tmp118_;
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp120_ = nibbles_game_get_tile_size (_tmp119_);
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp121_ = _tmp120_;
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					clutter_actor_set_y ((ClutterActor*) _tmp109_, (gfloat) ((_tmp113_ * _tmp117_) - (3 * _tmp121_)));
#line 4825 "nibbles-view.c"
				}
			}
#line 599 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp122_ = self->priv->_name_labels;
#line 599 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp123_ = label;
#line 599 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			clutter_container_add ((ClutterContainer*) _tmp122_, (ClutterActor*) _tmp123_, NULL);
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_object_unref0 (label);
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_free0 (player_id);
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_object_unref0 (worm);
#line 4840 "nibbles-view.c"
		}
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (_worm_list);
#line 4844 "nibbles-view.c"
	}
#line 602 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp124_ = self->priv->level;
#line 602 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp125_ = self->priv->_name_labels;
#line 602 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_add_child (_tmp124_, _tmp125_);
#line 4852 "nibbles-view.c"
}


static void nibbles_view_worm_added_cb (NibblesView* self, Worm* worm) {
	GtkClutterTexture* actor = NULL;
	GtkClutterTexture* _tmp0_ = NULL;
	NibblesGame* _tmp12_ = NULL;
	NibblesGame* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	NibblesGame* _tmp16_ = NULL;
	NibblesGame* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	Worm* _tmp20_ = NULL;
	GeeLinkedList* _tmp21_ = NULL;
	GeeLinkedList* _tmp22_ = NULL;
	gpointer _tmp23_ = NULL;
	Position* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	NibblesGame* _tmp26_ = NULL;
	NibblesGame* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	Worm* _tmp30_ = NULL;
	GeeLinkedList* _tmp31_ = NULL;
	GeeLinkedList* _tmp32_ = NULL;
	gpointer _tmp33_ = NULL;
	Position* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	NibblesGame* _tmp36_ = NULL;
	NibblesGame* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	WormActor* actors = NULL;
	GeeHashMap* _tmp40_ = NULL;
	Worm* _tmp41_ = NULL;
	gpointer _tmp42_ = NULL;
	GError * _inner_error_ = NULL;
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (worm != NULL);
#line 611 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 611 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_object_ref_sink (_tmp0_);
#line 611 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	actor = _tmp0_;
#line 4902 "nibbles-view.c"
	{
		NibblesGame* _tmp1_ = NULL;
		NibblesGame* _tmp2_ = NULL;
		GeeHashMap* _tmp3_ = NULL;
		GeeHashMap* _tmp4_ = NULL;
		Worm* _tmp5_ = NULL;
		gpointer _tmp6_ = NULL;
		WormProperties* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		GdkPixbuf* _tmp9_ = NULL;
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp1_ = nibbles_view_get_game (self);
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp2_ = _tmp1_;
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp3_ = nibbles_game_get_worm_props (_tmp2_);
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp4_ = _tmp3_;
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp5_ = worm;
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp7_ = (WormProperties*) _tmp6_;
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp8_ = (*_tmp7_).color;
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp9_ = self->priv->worm_pixmaps[_tmp8_];
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		gtk_clutter_texture_set_from_pixbuf (actor, _tmp9_, &_inner_error_);
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_worm_properties_free0 (_tmp7_);
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
#line 4939 "nibbles-view.c"
				goto __catch4_clutter_texture_error;
			}
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_clutter_texture_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_ = NULL;
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		e = _inner_error_;
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_inner_error_ = NULL;
#line 618 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp10_ = e->message;
#line 618 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_error ("nibbles-view.vala:618: Nibbles failed to set texture: %s", _tmp10_);
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_error_free0 (e);
#line 4960 "nibbles-view.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_ = NULL;
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		e = _inner_error_;
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_inner_error_ = NULL;
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp11_ = e->message;
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_error ("nibbles-view.vala:622: Nibbles failed to set texture: %s", _tmp11_);
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_error_free0 (e);
#line 4977 "nibbles-view.c"
	}
	__finally4:
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (actor);
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_clear_error (&_inner_error_);
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		return;
#line 4990 "nibbles-view.c"
	}
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp12_ = nibbles_view_get_game (self);
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp13_ = _tmp12_;
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp14_ = nibbles_game_get_tile_size (_tmp13_);
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp15_ = _tmp14_;
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp16_ = nibbles_view_get_game (self);
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp17_ = _tmp16_;
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp18_ = nibbles_game_get_tile_size (_tmp17_);
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp19_ = _tmp18_;
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_size ((ClutterActor*) actor, (gfloat) _tmp15_, (gfloat) _tmp19_);
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp20_ = worm;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp21_ = worm_get_list (_tmp20_);
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp22_ = _tmp21_;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp23_ = gee_linked_list_first (_tmp22_);
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp24_ = (Position*) _tmp23_;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp25_ = (*_tmp24_).x;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp26_ = nibbles_view_get_game (self);
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp27_ = _tmp26_;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp28_ = nibbles_game_get_tile_size (_tmp27_);
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp29_ = _tmp28_;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp30_ = worm;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp31_ = worm_get_list (_tmp30_);
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp32_ = _tmp31_;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp33_ = gee_linked_list_first (_tmp32_);
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp34_ = (Position*) _tmp33_;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp35_ = (*_tmp34_).y;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp36_ = nibbles_view_get_game (self);
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp37_ = _tmp36_;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp38_ = nibbles_game_get_tile_size (_tmp37_);
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp39_ = _tmp38_;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_position ((ClutterActor*) actor, (gfloat) (_tmp25_ * _tmp29_), (gfloat) (_tmp35_ * _tmp39_));
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_position_free0 (_tmp34_);
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_position_free0 (_tmp24_);
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp40_ = self->priv->worm_actors;
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp41_ = worm;
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp42_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp40_, _tmp41_);
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	actors = (WormActor*) _tmp42_;
#line 628 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_add_child ((ClutterActor*) actors, (ClutterActor*) actor);
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (actors);
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (actor);
#line 5070 "nibbles-view.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	return _data7_;
#line 5079 "nibbles-view.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 5088 "nibbles-view.c"
		NibblesView* self;
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		self = _data7_->self;
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (_data7_->worm);
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (self);
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_slice_free (Block7Data, _data7_);
#line 5098 "nibbles-view.c"
	}
}


static gboolean __lambda5_ (Block7Data* _data7_) {
	NibblesView* self;
	gboolean result = FALSE;
	Worm* _tmp0_ = NULL;
#line 648 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self = _data7_->self;
#line 649 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = _data7_->worm;
#line 649 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_->is_stopped = FALSE;
#line 650 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	result = G_SOURCE_REMOVE;
#line 650 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	return result;
#line 5117 "nibbles-view.c"
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ (self);
#line 648 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	return result;
#line 5126 "nibbles-view.c"
}


static void nibbles_view_worm_finish_added_cb (NibblesView* self, Worm* worm) {
	Block7Data* _data7_;
	Worm* _tmp0_ = NULL;
	Worm* _tmp1_ = NULL;
	WormActor* actors = NULL;
	GeeHashMap* _tmp2_ = NULL;
	Worm* _tmp3_ = NULL;
	gpointer _tmp4_ = NULL;
	Worm* _tmp5_ = NULL;
	NibblesGame* _tmp6_ = NULL;
	NibblesGame* _tmp7_ = NULL;
	gint* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp8__length2 = 0;
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (worm != NULL);
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_data7_ = g_slice_new0 (Block7Data);
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_data7_->_ref_count_ = 1;
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_data7_->self = g_object_ref (self);
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = worm;
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (_data7_->worm);
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_data7_->worm = _tmp1_;
#line 633 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp2_ = self->priv->worm_actors;
#line 633 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_ = _data7_->worm;
#line 633 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, _tmp3_);
#line 633 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	actors = (WormActor*) _tmp4_;
#line 635 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) actors, (guint8) 0);
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) actors, 3.0, 3.0);
#line 638 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_save_easing_state ((ClutterActor*) actors);
#line 639 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_mode ((ClutterActor*) actors, CLUTTER_EASE_OUT);
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) actors, (guint) (NIBBLES_GAME_GAMEDELAY * 20));
#line 641 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) actors, 1.0, 1.0);
#line 642 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_pivot_point ((ClutterActor*) actors, 0.5f, 0.5f);
#line 643 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) actors, (guint8) 0xff);
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_restore_easing_state ((ClutterActor*) actors);
#line 646 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp5_ = _data7_->worm;
#line 646 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_ = nibbles_view_get_game (self);
#line 646 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp7_ = _tmp6_;
#line 646 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp8_ = _tmp7_->board;
#line 646 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp8__length1 = _tmp7_->board_length1;
#line 646 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp8__length2 = _tmp7_->board_length2;
#line 646 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	worm_dematerialize (_tmp5_, _tmp8_, _tmp8__length1, _tmp8__length2, 3);
#line 648 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (NIBBLES_GAME_GAMEDELAY * 27), ___lambda5__gsource_func, block7_data_ref (_data7_), block7_data_unref);
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (actors);
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	block7_data_unref (_data7_);
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_data7_ = NULL;
#line 5210 "nibbles-view.c"
}


static void nibbles_view_worm_moved_cb (NibblesView* self, Worm* worm) {
	WormActor* actors = NULL;
	GeeHashMap* _tmp0_ = NULL;
	Worm* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	ClutterActor* tail_actor = NULL;
	ClutterActor* _tmp3_ = NULL;
	ClutterActor* _tmp4_ = NULL;
	ClutterActor* _tmp5_ = NULL;
	Worm* _tmp6_ = NULL;
#line 654 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 654 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (worm != NULL);
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = self->priv->worm_actors;
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = worm;
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	actors = (WormActor*) _tmp2_;
#line 658 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_ = clutter_actor_get_first_child ((ClutterActor*) actors);
#line 658 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = _tmp3_;
#line 658 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 658 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	tail_actor = _tmp5_;
#line 659 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_remove_child ((ClutterActor*) actors, tail_actor);
#line 660 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_ = worm;
#line 660 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_worm_added_cb (self, _tmp6_);
#line 654 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (tail_actor);
#line 654 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (actors);
#line 5254 "nibbles-view.c"
}


static void nibbles_view_worm_rescaled_cb (NibblesView* self, Worm* worm, gint tile_size) {
	gfloat x_pos = 0.0F;
	gfloat y_pos = 0.0F;
	WormActor* actors = NULL;
	GeeHashMap* _tmp0_ = NULL;
	Worm* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	WormActor* _tmp3_ = NULL;
	WormActor* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
#line 663 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 663 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (worm != NULL);
#line 666 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = self->priv->worm_actors;
#line 666 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = worm;
#line 666 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 666 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	actors = (WormActor*) _tmp2_;
#line 667 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_ = actors;
#line 667 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	if (_tmp3_ == NULL) {
#line 668 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (actors);
#line 668 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		return;
#line 5288 "nibbles-view.c"
	}
#line 670 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = actors;
#line 670 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp5_ = clutter_actor_get_children ((ClutterActor*) _tmp4_);
#line 5294 "nibbles-view.c"
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
#line 670 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		actor_collection = _tmp5_;
#line 670 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
#line 5302 "nibbles-view.c"
			ClutterActor* actor = NULL;
#line 670 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			actor = (ClutterActor*) actor_it->data;
#line 5306 "nibbles-view.c"
			{
				ClutterActor* _tmp6_ = NULL;
				gfloat _tmp7_ = 0.0F;
				gfloat _tmp8_ = 0.0F;
				ClutterActor* _tmp9_ = NULL;
				gfloat _tmp10_ = 0.0F;
				NibblesGame* _tmp11_ = NULL;
				NibblesGame* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gfloat _tmp16_ = 0.0F;
				NibblesGame* _tmp17_ = NULL;
				NibblesGame* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				ClutterActor* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp6_ = actor;
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_get_position (_tmp6_, &_tmp7_, &_tmp8_);
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				x_pos = _tmp7_;
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				y_pos = _tmp8_;
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp9_ = actor;
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp10_ = x_pos;
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp11_ = nibbles_view_get_game (self);
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp12_ = _tmp11_;
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp13_ = nibbles_game_get_tile_size (_tmp12_);
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp14_ = _tmp13_;
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp15_ = tile_size;
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp16_ = y_pos;
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp17_ = nibbles_view_get_game (self);
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp18_ = _tmp17_;
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp19_ = nibbles_game_get_tile_size (_tmp18_);
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp20_ = _tmp19_;
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp21_ = tile_size;
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_set_position (_tmp9_, (_tmp10_ / _tmp14_) * _tmp15_, (_tmp16_ / _tmp20_) * _tmp21_);
#line 675 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp22_ = actor;
#line 675 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp23_ = tile_size;
#line 675 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp24_ = tile_size;
#line 675 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_set_size (_tmp22_, (gfloat) _tmp23_, (gfloat) _tmp24_);
#line 5371 "nibbles-view.c"
			}
		}
#line 670 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_list_free0 (actor_collection);
#line 5376 "nibbles-view.c"
	}
#line 663 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (actors);
#line 5380 "nibbles-view.c"
}


static void nibbles_view_worm_died_cb (NibblesView* self, Worm* worm) {
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	ClutterActor* group = NULL;
	ClutterActor* _tmp0_ = NULL;
	WormActor* actors = NULL;
	GeeHashMap* _tmp1_ = NULL;
	Worm* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	WormActor* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	WormActor* _tmp38_ = NULL;
	ClutterActor* _tmp39_ = NULL;
	ClutterActor* _tmp40_ = NULL;
	ClutterActor* _tmp41_ = NULL;
	ClutterActor* _tmp42_ = NULL;
	ClutterActor* _tmp43_ = NULL;
	ClutterActor* _tmp44_ = NULL;
	ClutterActor* _tmp45_ = NULL;
	ClutterActor* _tmp46_ = NULL;
	ClutterActor* _tmp47_ = NULL;
	GError * _inner_error_ = NULL;
#line 679 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 679 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (worm != NULL);
#line 682 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = clutter_actor_new ();
#line 682 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_object_ref_sink (_tmp0_);
#line 682 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	group = _tmp0_;
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = self->priv->worm_actors;
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp2_ = worm;
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	actors = (WormActor*) _tmp3_;
#line 684 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = actors;
#line 684 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp5_ = clutter_actor_get_children ((ClutterActor*) _tmp4_);
#line 5428 "nibbles-view.c"
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
#line 684 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		actor_collection = _tmp5_;
#line 684 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
#line 5436 "nibbles-view.c"
			ClutterActor* actor = NULL;
#line 684 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			actor = (ClutterActor*) actor_it->data;
#line 5440 "nibbles-view.c"
			{
				GtkClutterTexture* texture = NULL;
				GtkClutterTexture* _tmp6_ = NULL;
				gint color = 0;
				NibblesGame* _tmp7_ = NULL;
				NibblesGame* _tmp8_ = NULL;
				GeeHashMap* _tmp9_ = NULL;
				GeeHashMap* _tmp10_ = NULL;
				Worm* _tmp11_ = NULL;
				gpointer _tmp12_ = NULL;
				WormProperties* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				ClutterActor* _tmp21_ = NULL;
				gfloat _tmp22_ = 0.0F;
				gfloat _tmp23_ = 0.0F;
				GtkClutterTexture* _tmp24_ = NULL;
				gfloat _tmp25_ = 0.0F;
				gfloat _tmp26_ = 0.0F;
				GtkClutterTexture* _tmp27_ = NULL;
				NibblesGame* _tmp28_ = NULL;
				NibblesGame* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				NibblesGame* _tmp32_ = NULL;
				NibblesGame* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				ClutterActor* _tmp36_ = NULL;
				GtkClutterTexture* _tmp37_ = NULL;
#line 686 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp6_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 686 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				g_object_ref_sink (_tmp6_);
#line 686 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				texture = _tmp6_;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp7_ = nibbles_view_get_game (self);
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp8_ = _tmp7_;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp9_ = nibbles_game_get_worm_props (_tmp8_);
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp10_ = _tmp9_;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp11_ = worm;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp11_);
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp13_ = (WormProperties*) _tmp12_;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp14_ = (*_tmp13_).color;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp15_ = _tmp14_;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_worm_properties_free0 (_tmp13_);
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				color = _tmp15_;
#line 5499 "nibbles-view.c"
				{
					GtkClutterTexture* _tmp16_ = NULL;
					gint _tmp17_ = 0;
					GdkPixbuf* _tmp18_ = NULL;
#line 690 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp16_ = texture;
#line 690 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp17_ = color;
#line 690 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp18_ = self->priv->worm_pixmaps[_tmp17_];
#line 690 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					gtk_clutter_texture_set_from_pixbuf (_tmp16_, _tmp18_, &_inner_error_);
#line 690 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 690 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
						if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
#line 5516 "nibbles-view.c"
							goto __catch5_clutter_texture_error;
						}
						goto __catch5_g_error;
					}
				}
				goto __finally5;
				__catch5_clutter_texture_error:
				{
					GError* e = NULL;
					const gchar* _tmp19_ = NULL;
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					e = _inner_error_;
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_inner_error_ = NULL;
#line 694 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp19_ = e->message;
#line 694 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					g_error ("nibbles-view.vala:694: Nibbles failed to set texture: %s", _tmp19_);
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_g_error_free0 (e);
#line 5537 "nibbles-view.c"
				}
				goto __finally5;
				__catch5_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp20_ = NULL;
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					e = _inner_error_;
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_inner_error_ = NULL;
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp20_ = e->message;
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					g_error ("nibbles-view.vala:698: Nibbles failed to set texture: %s", _tmp20_);
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_g_error_free0 (e);
#line 5554 "nibbles-view.c"
				}
				__finally5:
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_g_object_unref0 (texture);
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_g_list_free0 (actor_collection);
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_g_object_unref0 (actors);
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_g_object_unref0 (group);
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					g_clear_error (&_inner_error_);
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					return;
#line 5573 "nibbles-view.c"
				}
#line 701 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp21_ = actor;
#line 701 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_get_position (_tmp21_, &_tmp22_, &_tmp23_);
#line 701 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				x = _tmp22_;
#line 701 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				y = _tmp23_;
#line 703 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp24_ = texture;
#line 703 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp25_ = x;
#line 703 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp26_ = y;
#line 703 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_set_position ((ClutterActor*) _tmp24_, _tmp25_, _tmp26_);
#line 704 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp27_ = texture;
#line 704 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp28_ = nibbles_view_get_game (self);
#line 704 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp29_ = _tmp28_;
#line 704 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp30_ = nibbles_game_get_tile_size (_tmp29_);
#line 704 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp31_ = _tmp30_;
#line 704 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp32_ = nibbles_view_get_game (self);
#line 704 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp33_ = _tmp32_;
#line 704 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp34_ = nibbles_game_get_tile_size (_tmp33_);
#line 704 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp35_ = _tmp34_;
#line 704 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_set_size ((ClutterActor*) _tmp27_, (gfloat) _tmp31_, (gfloat) _tmp35_);
#line 705 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp36_ = group;
#line 705 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp37_ = texture;
#line 705 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_add_child (_tmp36_, (ClutterActor*) _tmp37_);
#line 684 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_g_object_unref0 (texture);
#line 5619 "nibbles-view.c"
			}
		}
#line 684 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_list_free0 (actor_collection);
#line 5624 "nibbles-view.c"
	}
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp38_ = actors;
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_remove_all_children ((ClutterActor*) _tmp38_);
#line 710 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp39_ = self->priv->level;
#line 710 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp40_ = group;
#line 710 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_add_child (_tmp39_, _tmp40_);
#line 712 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp41_ = group;
#line 712 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_save_easing_state (_tmp41_);
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp42_ = group;
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_mode (_tmp42_, CLUTTER_EASE_OUT_QUAD);
#line 714 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp43_ = group;
#line 714 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_duration (_tmp43_, (guint) (NIBBLES_GAME_GAMEDELAY * 9));
#line 715 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp44_ = group;
#line 715 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_scale (_tmp44_, (gdouble) 2.0f, (gdouble) 2.0f);
#line 716 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp45_ = group;
#line 716 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_pivot_point (_tmp45_, 0.5f, 0.5f);
#line 717 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp46_ = group;
#line 717 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_opacity (_tmp46_, (guint8) 0);
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp47_ = group;
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_restore_easing_state (_tmp47_);
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_play_sound (self, "crash");
#line 679 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (actors);
#line 679 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (group);
#line 5670 "nibbles-view.c"
}


static void nibbles_view_worm_tail_reduced_cb (NibblesView* self, Worm* worm, gint erase_size) {
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	ClutterActor* group = NULL;
	ClutterActor* _tmp0_ = NULL;
	WormActor* worm_actors = NULL;
	GeeHashMap* _tmp1_ = NULL;
	Worm* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	gint color = 0;
	NibblesGame* _tmp4_ = NULL;
	NibblesGame* _tmp5_ = NULL;
	GeeHashMap* _tmp6_ = NULL;
	GeeHashMap* _tmp7_ = NULL;
	Worm* _tmp8_ = NULL;
	gpointer _tmp9_ = NULL;
	WormProperties* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	ClutterActor* _tmp46_ = NULL;
	ClutterActor* _tmp47_ = NULL;
	ClutterActor* _tmp48_ = NULL;
	ClutterActor* _tmp49_ = NULL;
	ClutterActor* _tmp50_ = NULL;
	ClutterActor* _tmp51_ = NULL;
	ClutterActor* _tmp52_ = NULL;
	GError * _inner_error_ = NULL;
#line 723 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 723 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (worm != NULL);
#line 726 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = clutter_actor_new ();
#line 726 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_object_ref_sink (_tmp0_);
#line 726 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	group = _tmp0_;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = self->priv->worm_actors;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp2_ = worm;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	worm_actors = (WormActor*) _tmp3_;
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = nibbles_view_get_game (self);
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp5_ = _tmp4_;
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_ = nibbles_game_get_worm_props (_tmp5_);
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp7_ = _tmp6_;
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp8_ = worm;
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, _tmp8_);
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp10_ = (WormProperties*) _tmp9_;
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp11_ = (*_tmp10_).color;
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp12_ = _tmp11_;
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_worm_properties_free0 (_tmp10_);
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	color = _tmp12_;
#line 5741 "nibbles-view.c"
	{
		gint i = 0;
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		i = 0;
#line 5746 "nibbles-view.c"
		{
			gboolean _tmp13_ = FALSE;
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp13_ = TRUE;
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			while (TRUE) {
#line 5753 "nibbles-view.c"
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				GtkClutterTexture* texture = NULL;
				GtkClutterTexture* _tmp17_ = NULL;
				WormActor* _tmp23_ = NULL;
				ClutterActor* _tmp24_ = NULL;
				ClutterActor* _tmp25_ = NULL;
				gfloat _tmp26_ = 0.0F;
				gfloat _tmp27_ = 0.0F;
				WormActor* _tmp28_ = NULL;
				WormActor* _tmp29_ = NULL;
				ClutterActor* _tmp30_ = NULL;
				ClutterActor* _tmp31_ = NULL;
				GtkClutterTexture* _tmp32_ = NULL;
				gfloat _tmp33_ = 0.0F;
				gfloat _tmp34_ = 0.0F;
				GtkClutterTexture* _tmp35_ = NULL;
				NibblesGame* _tmp36_ = NULL;
				NibblesGame* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				NibblesGame* _tmp40_ = NULL;
				NibblesGame* _tmp41_ = NULL;
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				ClutterActor* _tmp44_ = NULL;
				GtkClutterTexture* _tmp45_ = NULL;
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (!_tmp13_) {
#line 5783 "nibbles-view.c"
					gint _tmp14_ = 0;
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp14_ = i;
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					i = _tmp14_ + 1;
#line 5789 "nibbles-view.c"
				}
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp13_ = FALSE;
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp15_ = i;
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp16_ = erase_size;
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (!(_tmp15_ < _tmp16_)) {
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					break;
#line 5801 "nibbles-view.c"
				}
#line 731 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp17_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 731 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				g_object_ref_sink (_tmp17_);
#line 731 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				texture = _tmp17_;
#line 5809 "nibbles-view.c"
				{
					GtkClutterTexture* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					GdkPixbuf* _tmp20_ = NULL;
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp18_ = texture;
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp19_ = color;
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp20_ = self->priv->worm_pixmaps[_tmp19_];
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					gtk_clutter_texture_set_from_pixbuf (_tmp18_, _tmp20_, &_inner_error_);
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
						if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
#line 5826 "nibbles-view.c"
							goto __catch6_clutter_texture_error;
						}
						goto __catch6_g_error;
					}
				}
				goto __finally6;
				__catch6_clutter_texture_error:
				{
					GError* e = NULL;
					const gchar* _tmp21_ = NULL;
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					e = _inner_error_;
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_inner_error_ = NULL;
#line 738 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp21_ = e->message;
#line 738 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					g_error ("nibbles-view.vala:738: Nibbles failed to set texture: %s", _tmp21_);
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_g_error_free0 (e);
#line 5847 "nibbles-view.c"
				}
				goto __finally6;
				__catch6_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp22_ = NULL;
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					e = _inner_error_;
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_inner_error_ = NULL;
#line 742 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_tmp22_ = e->message;
#line 742 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					g_error ("nibbles-view.vala:742: Nibbles failed to set texture: %s", _tmp22_);
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_g_error_free0 (e);
#line 5864 "nibbles-view.c"
				}
				__finally6:
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_g_object_unref0 (texture);
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_g_object_unref0 (worm_actors);
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					_g_object_unref0 (group);
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					g_clear_error (&_inner_error_);
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
					return;
#line 5881 "nibbles-view.c"
				}
#line 745 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp23_ = worm_actors;
#line 745 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp24_ = clutter_actor_get_first_child ((ClutterActor*) _tmp23_);
#line 745 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp25_ = _tmp24_;
#line 745 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_get_position (_tmp25_, &_tmp26_, &_tmp27_);
#line 745 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				x = _tmp26_;
#line 745 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				y = _tmp27_;
#line 746 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp28_ = worm_actors;
#line 746 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp29_ = worm_actors;
#line 746 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp30_ = clutter_actor_get_first_child ((ClutterActor*) _tmp29_);
#line 746 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp31_ = _tmp30_;
#line 746 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_remove_child ((ClutterActor*) _tmp28_, _tmp31_);
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp32_ = texture;
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp33_ = x;
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp34_ = y;
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_set_position ((ClutterActor*) _tmp32_, _tmp33_, _tmp34_);
#line 749 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp35_ = texture;
#line 749 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp36_ = nibbles_view_get_game (self);
#line 749 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp37_ = _tmp36_;
#line 749 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp38_ = nibbles_game_get_tile_size (_tmp37_);
#line 749 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp39_ = _tmp38_;
#line 749 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp40_ = nibbles_view_get_game (self);
#line 749 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp41_ = _tmp40_;
#line 749 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp42_ = nibbles_game_get_tile_size (_tmp41_);
#line 749 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp43_ = _tmp42_;
#line 749 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_set_size ((ClutterActor*) _tmp35_, (gfloat) _tmp39_, (gfloat) _tmp43_);
#line 750 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp44_ = group;
#line 750 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp45_ = texture;
#line 750 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_add_child (_tmp44_, (ClutterActor*) _tmp45_);
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_g_object_unref0 (texture);
#line 5941 "nibbles-view.c"
			}
		}
	}
#line 752 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp46_ = self->priv->level;
#line 752 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp47_ = group;
#line 752 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_add_child (_tmp46_, _tmp47_);
#line 754 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp48_ = group;
#line 754 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_save_easing_state (_tmp48_);
#line 755 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp49_ = group;
#line 755 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_mode (_tmp49_, CLUTTER_EASE_OUT_EXPO);
#line 756 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp50_ = group;
#line 756 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_duration (_tmp50_, (guint) (NIBBLES_GAME_GAMEDELAY * 25));
#line 757 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp51_ = group;
#line 757 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_opacity (_tmp51_, (guint8) 0);
#line 758 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp52_ = group;
#line 758 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_restore_easing_state (_tmp52_);
#line 723 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (worm_actors);
#line 723 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (group);
#line 5975 "nibbles-view.c"
}


static void nibbles_view_worm_reversed_cb (NibblesView* self, Worm* worm) {
	WormActor* actors = NULL;
	GeeHashMap* _tmp0_ = NULL;
	Worm* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	gint count = 0;
	WormActor* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
#line 761 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 761 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (worm != NULL);
#line 763 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = self->priv->worm_actors;
#line 763 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = worm;
#line 763 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 763 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	actors = (WormActor*) _tmp2_;
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	count = 0;
#line 766 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_ = actors;
#line 766 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = clutter_actor_get_children ((ClutterActor*) _tmp3_);
#line 6005 "nibbles-view.c"
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
#line 766 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		actor_collection = _tmp4_;
#line 766 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
#line 6013 "nibbles-view.c"
			ClutterActor* actor = NULL;
#line 766 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			actor = (ClutterActor*) actor_it->data;
#line 6017 "nibbles-view.c"
			{
				ClutterActor* _tmp5_ = NULL;
				Worm* _tmp6_ = NULL;
				GeeLinkedList* _tmp7_ = NULL;
				GeeLinkedList* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gpointer _tmp10_ = NULL;
				Position* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				NibblesGame* _tmp13_ = NULL;
				NibblesGame* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				Worm* _tmp17_ = NULL;
				GeeLinkedList* _tmp18_ = NULL;
				GeeLinkedList* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gpointer _tmp21_ = NULL;
				Position* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				NibblesGame* _tmp24_ = NULL;
				NibblesGame* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				gint _tmp28_ = 0;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp5_ = actor;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp6_ = worm;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp7_ = worm_get_list (_tmp6_);
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp8_ = _tmp7_;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp9_ = count;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp11_ = (Position*) _tmp10_;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp12_ = (*_tmp11_).x;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp13_ = nibbles_view_get_game (self);
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp14_ = _tmp13_;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp15_ = nibbles_game_get_tile_size (_tmp14_);
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp16_ = _tmp15_;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp17_ = worm;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp18_ = worm_get_list (_tmp17_);
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp19_ = _tmp18_;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp20_ = count;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _tmp20_);
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp22_ = (Position*) _tmp21_;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp23_ = (*_tmp22_).y;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp24_ = nibbles_view_get_game (self);
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp25_ = _tmp24_;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp26_ = nibbles_game_get_tile_size (_tmp25_);
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp27_ = _tmp26_;
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				clutter_actor_set_position (_tmp5_, (gfloat) (_tmp12_ * _tmp16_), (gfloat) (_tmp23_ * _tmp27_));
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_position_free0 (_tmp22_);
#line 768 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_position_free0 (_tmp11_);
#line 769 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				_tmp28_ = count;
#line 769 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				count = _tmp28_ + 1;
#line 6099 "nibbles-view.c"
			}
		}
#line 766 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_list_free0 (actor_collection);
#line 6104 "nibbles-view.c"
	}
#line 761 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (actors);
#line 6108 "nibbles-view.c"
}


static void nibbles_view_bonus_added_cb (NibblesView* self) {
	Bonus* bonus = NULL;
	NibblesGame* _tmp0_ = NULL;
	NibblesGame* _tmp1_ = NULL;
	Boni* _tmp2_ = NULL;
	Boni* _tmp3_ = NULL;
	GeeLinkedList* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	BonusTexture* actor = NULL;
	BonusTexture* _tmp6_ = NULL;
	NibblesGame* _tmp11_ = NULL;
	NibblesGame* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	NibblesGame* _tmp15_ = NULL;
	NibblesGame* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	NibblesGame* _tmp20_ = NULL;
	NibblesGame* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	NibblesGame* _tmp25_ = NULL;
	NibblesGame* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	ClutterActor* _tmp29_ = NULL;
	BonusType _tmp30_ = 0;
	GeeHashMap* _tmp31_ = NULL;
	GError * _inner_error_ = NULL;
#line 777 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 780 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = nibbles_view_get_game (self);
#line 780 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = _tmp0_;
#line 780 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp2_ = nibbles_game_get_boni (_tmp1_);
#line 780 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_ = _tmp2_;
#line 780 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = _tmp3_->bonuses;
#line 780 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp5_ = gee_linked_list_last (_tmp4_);
#line 780 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	bonus = (Bonus*) _tmp5_;
#line 781 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_ = bonus_texture_new ();
#line 781 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_object_ref_sink (_tmp6_);
#line 781 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	actor = _tmp6_;
#line 6166 "nibbles-view.c"
	{
		BonusType _tmp7_ = 0;
		GdkPixbuf* _tmp8_ = NULL;
#line 784 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp7_ = bonus->type;
#line 784 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp8_ = self->priv->boni_pixmaps[_tmp7_];
#line 784 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		gtk_clutter_texture_set_from_pixbuf ((GtkClutterTexture*) actor, _tmp8_, &_inner_error_);
#line 784 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 784 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
#line 6180 "nibbles-view.c"
				goto __catch7_clutter_texture_error;
			}
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_clutter_texture_error:
	{
		GError* e = NULL;
		const gchar* _tmp9_ = NULL;
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		e = _inner_error_;
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_inner_error_ = NULL;
#line 788 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp9_ = e->message;
#line 788 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_error ("nibbles-view.vala:788: Nibbles failed to set texture: %s", _tmp9_);
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_error_free0 (e);
#line 6201 "nibbles-view.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_ = NULL;
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		e = _inner_error_;
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_inner_error_ = NULL;
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp10_ = e->message;
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_error ("nibbles-view.vala:792: Nibbles failed to set texture: %s", _tmp10_);
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_error_free0 (e);
#line 6218 "nibbles-view.c"
	}
	__finally7:
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (actor);
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (bonus);
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_clear_error (&_inner_error_);
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		return;
#line 6233 "nibbles-view.c"
	}
#line 795 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp11_ = nibbles_view_get_game (self);
#line 795 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp12_ = _tmp11_;
#line 795 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp13_ = nibbles_game_get_tile_size (_tmp12_);
#line 795 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp14_ = _tmp13_;
#line 795 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp15_ = nibbles_view_get_game (self);
#line 795 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp16_ = _tmp15_;
#line 795 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp17_ = nibbles_game_get_tile_size (_tmp16_);
#line 795 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp18_ = _tmp17_;
#line 795 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	bonus_texture_set_size (actor, (gfloat) _tmp14_, (gfloat) _tmp18_);
#line 796 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp19_ = bonus->x;
#line 796 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp20_ = nibbles_view_get_game (self);
#line 796 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp21_ = _tmp20_;
#line 796 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp22_ = nibbles_game_get_tile_size (_tmp21_);
#line 796 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp23_ = _tmp22_;
#line 796 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp24_ = bonus->y;
#line 796 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp25_ = nibbles_view_get_game (self);
#line 796 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp26_ = _tmp25_;
#line 796 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp27_ = nibbles_game_get_tile_size (_tmp26_);
#line 796 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp28_ = _tmp27_;
#line 796 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_position ((ClutterActor*) actor, (gfloat) (_tmp19_ * _tmp23_), (gfloat) (_tmp24_ * _tmp28_));
#line 798 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp29_ = self->priv->level;
#line 798 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_add_child (_tmp29_, (ClutterActor*) actor);
#line 799 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp30_ = bonus->type;
#line 799 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	if (_tmp30_ != BONUS_TYPE_REGULAR) {
#line 800 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		nibbles_view_play_sound (self, "appear");
#line 6285 "nibbles-view.c"
	}
#line 802 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp31_ = self->priv->bonus_actors;
#line 802 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp31_, bonus, actor);
#line 777 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (actor);
#line 777 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (bonus);
#line 6295 "nibbles-view.c"
}


static void nibbles_view_bonus_removed_cb (NibblesView* self, Bonus* bonus) {
	BonusTexture* bonus_actor = NULL;
	GeeHashMap* _tmp0_ = NULL;
	Bonus* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	Bonus* _tmp4_ = NULL;
	ClutterActor* _tmp5_ = NULL;
#line 805 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 805 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (bonus != NULL);
#line 807 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = self->priv->bonus_actors;
#line 807 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = bonus;
#line 807 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 807 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	bonus_actor = (BonusTexture*) _tmp2_;
#line 808 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_ = self->priv->bonus_actors;
#line 808 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = bonus;
#line 808 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, _tmp4_, NULL);
#line 809 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_hide ((ClutterActor*) bonus_actor);
#line 810 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp5_ = self->priv->level;
#line 810 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_remove_child (_tmp5_, (ClutterActor*) bonus_actor);
#line 805 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (bonus_actor);
#line 6333 "nibbles-view.c"
}


static void nibbles_view_bonus_applied_cb (NibblesView* self, Bonus* bonus, Worm* worm) {
	WormActor* actors = NULL;
	GeeHashMap* _tmp0_ = NULL;
	Worm* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	ClutterActor* actor = NULL;
	WormActor* _tmp3_ = NULL;
	ClutterActor* _tmp4_ = NULL;
	ClutterActor* _tmp5_ = NULL;
	ClutterActor* _tmp6_ = NULL;
	ClutterActor* _tmp7_ = NULL;
	ClutterActor* _tmp8_ = NULL;
	ClutterActor* _tmp9_ = NULL;
	ClutterActor* _tmp10_ = NULL;
	ClutterActor* _tmp11_ = NULL;
	ClutterActor* _tmp12_ = NULL;
	Bonus* _tmp13_ = NULL;
	BonusType _tmp14_ = 0;
#line 813 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 813 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (bonus != NULL);
#line 813 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (worm != NULL);
#line 815 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = self->priv->worm_actors;
#line 815 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = worm;
#line 815 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 815 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	actors = (WormActor*) _tmp2_;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_ = actors;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = clutter_actor_get_last_child ((ClutterActor*) _tmp3_);
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp5_ = _tmp4_;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	actor = _tmp6_;
#line 818 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp7_ = actor;
#line 818 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_save_easing_state (_tmp7_);
#line 819 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp8_ = actor;
#line 819 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_mode (_tmp8_, CLUTTER_EASE_OUT_QUINT);
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp9_ = actor;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_easing_duration (_tmp9_, (guint) (NIBBLES_GAME_GAMEDELAY * 15));
#line 821 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp10_ = actor;
#line 821 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_scale (_tmp10_, (gdouble) 1.45f, (gdouble) 1.45f);
#line 822 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp11_ = actor;
#line 822 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_pivot_point (_tmp11_, 0.5f, 0.5f);
#line 823 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp12_ = actor;
#line 823 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_restore_easing_state (_tmp12_);
#line 825 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp13_ = bonus;
#line 825 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp14_ = _tmp13_->type;
#line 825 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	switch (_tmp14_) {
#line 825 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		case BONUS_TYPE_REGULAR:
#line 6411 "nibbles-view.c"
		{
#line 828 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			nibbles_view_play_sound (self, "gobble");
#line 829 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			break;
#line 6417 "nibbles-view.c"
		}
#line 825 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		case BONUS_TYPE_DOUBLE:
#line 6421 "nibbles-view.c"
		{
#line 831 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			nibbles_view_play_sound (self, "bonus");
#line 832 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			break;
#line 6427 "nibbles-view.c"
		}
#line 825 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		case BONUS_TYPE_HALF:
#line 6431 "nibbles-view.c"
		{
#line 834 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			nibbles_view_play_sound (self, "bonus");
#line 835 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			break;
#line 6437 "nibbles-view.c"
		}
#line 825 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		case BONUS_TYPE_LIFE:
#line 6441 "nibbles-view.c"
		{
#line 837 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			nibbles_view_play_sound (self, "life");
#line 838 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			break;
#line 6447 "nibbles-view.c"
		}
#line 825 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		case BONUS_TYPE_REVERSE:
#line 6451 "nibbles-view.c"
		{
#line 840 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			nibbles_view_play_sound (self, "reverse");
#line 841 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			break;
#line 6457 "nibbles-view.c"
		}
		default:
		{
#line 843 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			g_assert_not_reached ();
#line 6463 "nibbles-view.c"
		}
	}
#line 813 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (actor);
#line 813 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (actors);
#line 6470 "nibbles-view.c"
}


void nibbles_view_boni_rescale (NibblesView* self, gint tile_size) {
#line 847 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 6477 "nibbles-view.c"
	{
		GeeLinkedList* _bonus_list = NULL;
		NibblesGame* _tmp0_ = NULL;
		NibblesGame* _tmp1_ = NULL;
		Boni* _tmp2_ = NULL;
		Boni* _tmp3_ = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		GeeLinkedList* _tmp5_ = NULL;
		gint _bonus_size = 0;
		GeeLinkedList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _bonus_index = 0;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp0_ = nibbles_view_get_game (self);
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp1_ = _tmp0_;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp2_ = nibbles_game_get_boni (_tmp1_);
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp3_ = _tmp2_;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp4_ = _tmp3_->bonuses;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_bonus_list = _tmp5_;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp6_ = _bonus_list;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp8_ = _tmp7_;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_bonus_size = _tmp8_;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_bonus_index = -1;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		while (TRUE) {
#line 6517 "nibbles-view.c"
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			Bonus* bonus = NULL;
			GeeLinkedList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gpointer _tmp14_ = NULL;
			BonusTexture* actor = NULL;
			GeeHashMap* _tmp15_ = NULL;
			Bonus* _tmp16_ = NULL;
			gpointer _tmp17_ = NULL;
			BonusTexture* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp9_ = _bonus_index;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_bonus_index = _tmp9_ + 1;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp10_ = _bonus_index;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp11_ = _bonus_size;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				break;
#line 6544 "nibbles-view.c"
			}
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp12_ = _bonus_list;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp13_ = _bonus_index;
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			bonus = (Bonus*) _tmp14_;
#line 851 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp15_ = self->priv->bonus_actors;
#line 851 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp16_ = bonus;
#line 851 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp16_);
#line 851 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			actor = (BonusTexture*) _tmp17_;
#line 852 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp18_ = actor;
#line 852 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp19_ = tile_size;
#line 852 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp20_ = tile_size;
#line 852 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			bonus_texture_set_size (_tmp18_, (gfloat) _tmp19_, (gfloat) _tmp20_);
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_object_unref0 (actor);
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_object_unref0 (bonus);
#line 6574 "nibbles-view.c"
		}
#line 849 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (_bonus_list);
#line 6578 "nibbles-view.c"
	}
}


static void nibbles_view_warp_added_cb (NibblesView* self, Warp* warp) {
	WarpTexture* actor = NULL;
	WarpTexture* _tmp0_ = NULL;
	NibblesGame* _tmp4_ = NULL;
	NibblesGame* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	NibblesGame* _tmp8_ = NULL;
	NibblesGame* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	Warp* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	NibblesGame* _tmp14_ = NULL;
	NibblesGame* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	Warp* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	NibblesGame* _tmp20_ = NULL;
	NibblesGame* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	ClutterActor* _tmp24_ = NULL;
	GeeHashMap* _tmp25_ = NULL;
	Warp* _tmp26_ = NULL;
	GError * _inner_error_ = NULL;
#line 860 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 860 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (warp != NULL);
#line 862 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = warp_texture_new ();
#line 862 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_object_ref_sink (_tmp0_);
#line 862 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	actor = _tmp0_;
#line 6620 "nibbles-view.c"
	{
		GdkPixbuf* _tmp1_ = NULL;
#line 865 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp1_ = self->priv->boni_pixmaps[BONUS_TYPE_WARP];
#line 865 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		gtk_clutter_texture_set_from_pixbuf ((GtkClutterTexture*) actor, _tmp1_, &_inner_error_);
#line 865 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 865 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
#line 6631 "nibbles-view.c"
				goto __catch8_clutter_texture_error;
			}
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_clutter_texture_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_ = NULL;
#line 863 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		e = _inner_error_;
#line 863 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_inner_error_ = NULL;
#line 869 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp2_ = e->message;
#line 869 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_error ("nibbles-view.vala:869: Nibbles failed to set texture: %s", _tmp2_);
#line 863 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_error_free0 (e);
#line 6652 "nibbles-view.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
#line 863 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		e = _inner_error_;
#line 863 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_inner_error_ = NULL;
#line 873 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp3_ = e->message;
#line 873 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_error ("nibbles-view.vala:873: Nibbles failed to set texture: %s", _tmp3_);
#line 863 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_error_free0 (e);
#line 6669 "nibbles-view.c"
	}
	__finally8:
#line 863 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 863 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (actor);
#line 863 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 863 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_clear_error (&_inner_error_);
#line 863 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		return;
#line 6682 "nibbles-view.c"
	}
#line 876 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = nibbles_view_get_game (self);
#line 876 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp5_ = _tmp4_;
#line 876 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_ = nibbles_game_get_tile_size (_tmp5_);
#line 876 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp7_ = _tmp6_;
#line 876 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp8_ = nibbles_view_get_game (self);
#line 876 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp9_ = _tmp8_;
#line 876 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp10_ = nibbles_game_get_tile_size (_tmp9_);
#line 876 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp11_ = _tmp10_;
#line 876 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	warp_texture_set_size (actor, (gfloat) _tmp7_, (gfloat) _tmp11_);
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp12_ = warp;
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp13_ = _tmp12_->x;
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp14_ = nibbles_view_get_game (self);
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp15_ = _tmp14_;
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp16_ = nibbles_game_get_tile_size (_tmp15_);
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp17_ = _tmp16_;
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp18_ = warp;
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp19_ = _tmp18_->y;
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp20_ = nibbles_view_get_game (self);
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp21_ = _tmp20_;
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp22_ = nibbles_game_get_tile_size (_tmp21_);
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp23_ = _tmp22_;
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_set_position ((ClutterActor*) actor, (gfloat) (_tmp13_ * _tmp17_), (gfloat) (_tmp19_ * _tmp23_));
#line 879 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp24_ = self->priv->level;
#line 879 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	clutter_actor_add_child (_tmp24_, (ClutterActor*) actor);
#line 881 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp25_ = self->priv->warp_actors;
#line 881 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp26_ = warp;
#line 881 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp25_, _tmp26_, actor);
#line 860 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (actor);
#line 6740 "nibbles-view.c"
}


void nibbles_view_warps_rescale (NibblesView* self, gint tile_size) {
#line 884 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 6747 "nibbles-view.c"
	{
		GeeLinkedList* _warp_list = NULL;
		NibblesGame* _tmp0_ = NULL;
		NibblesGame* _tmp1_ = NULL;
		WarpManager* _tmp2_ = NULL;
		WarpManager* _tmp3_ = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		GeeLinkedList* _tmp5_ = NULL;
		gint _warp_size = 0;
		GeeLinkedList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _warp_index = 0;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp0_ = nibbles_view_get_game (self);
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp1_ = _tmp0_;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp2_ = nibbles_game_get_warp_manager (_tmp1_);
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp3_ = _tmp2_;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp4_ = _tmp3_->warps;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_warp_list = _tmp5_;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp6_ = _warp_list;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp8_ = _tmp7_;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_warp_size = _tmp8_;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_warp_index = -1;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		while (TRUE) {
#line 6787 "nibbles-view.c"
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			Warp* warp = NULL;
			GeeLinkedList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gpointer _tmp14_ = NULL;
			WarpTexture* actor = NULL;
			GeeHashMap* _tmp15_ = NULL;
			Warp* _tmp16_ = NULL;
			gpointer _tmp17_ = NULL;
			WarpTexture* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp9_ = _warp_index;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_warp_index = _tmp9_ + 1;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp10_ = _warp_index;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp11_ = _warp_size;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
				break;
#line 6814 "nibbles-view.c"
			}
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp12_ = _warp_list;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp13_ = _warp_index;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			warp = (Warp*) _tmp14_;
#line 888 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp15_ = self->priv->warp_actors;
#line 888 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp16_ = warp;
#line 888 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp16_);
#line 888 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			actor = (WarpTexture*) _tmp17_;
#line 889 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp18_ = actor;
#line 889 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp19_ = tile_size;
#line 889 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_tmp20_ = tile_size;
#line 889 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			warp_texture_set_size (_tmp18_, (gfloat) _tmp19_, (gfloat) _tmp20_);
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_object_unref0 (actor);
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
			_g_object_unref0 (warp);
#line 6844 "nibbles-view.c"
		}
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_g_object_unref0 (_warp_list);
#line 6848 "nibbles-view.c"
	}
}


static void nibbles_view_play_sound (NibblesView* self, const gchar* name) {
	gboolean _tmp0_ = FALSE;
	gchar* filename = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* path = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
#line 897 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 897 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (name != NULL);
#line 899 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = self->is_muted;
#line 899 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	if (_tmp0_) {
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		return;
#line 6874 "nibbles-view.c"
	}
#line 902 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = name;
#line 902 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp2_ = string_to_string (_tmp1_);
#line 902 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_ = g_strconcat (_tmp2_, ".ogg", NULL);
#line 902 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	filename = _tmp3_;
#line 903 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = filename;
#line 903 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp5_ = g_build_filename (SOUND_DIRECTORY, _tmp4_, NULL, NULL);
#line 903 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	path = _tmp5_;
#line 905 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_ = name;
#line 905 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp7_ = path;
#line 905 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	ca_gtk_play_for_widget ((GtkWidget*) self, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp6_, CA_PROP_MEDIA_FILENAME, _tmp7_, NULL);
#line 897 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_free0 (path);
#line 897 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_free0 (filename);
#line 6900 "nibbles-view.c"
}


gchar* nibbles_view_colorval_name (gint colorval) {
	gchar* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 912 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = nibbles_view_color_lookup;
#line 912 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0__length1 = nibbles_view_color_lookup_length1;
#line 912 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = colorval;
#line 912 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp2_ = _tmp0_[_tmp1_];
#line 912 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_ = _ (_tmp2_);
#line 912 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 912 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	result = _tmp4_;
#line 912 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	return result;
#line 6928 "nibbles-view.c"
}


ClutterActor* nibbles_view_get_name_labels (NibblesView* self) {
	ClutterActor* result;
	ClutterActor* _tmp0_ = NULL;
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = self->priv->_name_labels;
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	result = _tmp0_;
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	return result;
#line 6943 "nibbles-view.c"
}


static void nibbles_view_set_name_labels (NibblesView* self, ClutterActor* value) {
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = value;
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (self->priv->_name_labels);
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self->priv->_name_labels = _tmp1_;
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_object_notify ((GObject *) self, "name-labels");
#line 6962 "nibbles-view.c"
}


NibblesGame* nibbles_view_get_game (NibblesView* self) {
	NibblesGame* result;
	NibblesGame* _tmp0_ = NULL;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = self->priv->_game;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	result = _tmp0_;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	return result;
#line 6977 "nibbles-view.c"
}


static void _nibbles_view_bonus_added_cb_boni_bonus_added (Boni* _sender, gpointer self) {
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_bonus_added_cb ((NibblesView*) self);
#line 6984 "nibbles-view.c"
}


static void _nibbles_view_bonus_removed_cb_boni_bonus_removed (Boni* _sender, Bonus* bonus, gpointer self) {
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_bonus_removed_cb ((NibblesView*) self, bonus);
#line 6991 "nibbles-view.c"
}


static void _nibbles_view_bonus_applied_cb_nibbles_game_bonus_applied (NibblesGame* _sender, Bonus* bonus, Worm* worm, gpointer self) {
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_bonus_applied_cb ((NibblesView*) self, bonus, worm);
#line 6998 "nibbles-view.c"
}


static void _nibbles_view_warp_added_cb_warp_manager_warp_added (WarpManager* _sender, Warp* warp, gpointer self) {
#line 146 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_warp_added_cb ((NibblesView*) self, warp);
#line 7005 "nibbles-view.c"
}


static void _nibbles_view_animate_end_game_cb_nibbles_game_animate_end_game (NibblesGame* _sender, gpointer self) {
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_animate_end_game_cb ((NibblesView*) self);
#line 7012 "nibbles-view.c"
}


void nibbles_view_set_game (NibblesView* self, NibblesGame* value) {
	NibblesGame* _tmp0_ = NULL;
	NibblesGame* _tmp2_ = NULL;
	NibblesGame* _tmp3_ = NULL;
	NibblesGame* _tmp4_ = NULL;
	Boni* _tmp5_ = NULL;
	Boni* _tmp6_ = NULL;
	NibblesGame* _tmp7_ = NULL;
	Boni* _tmp8_ = NULL;
	Boni* _tmp9_ = NULL;
	NibblesGame* _tmp10_ = NULL;
	NibblesGame* _tmp11_ = NULL;
	WarpManager* _tmp12_ = NULL;
	WarpManager* _tmp13_ = NULL;
	NibblesGame* _tmp14_ = NULL;
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = self->priv->_game;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	if (_tmp0_ != NULL) {
#line 7037 "nibbles-view.c"
		NibblesGame* _tmp1_ = NULL;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		_tmp1_ = self->priv->_game;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
#line 7043 "nibbles-view.c"
	}
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp2_ = value;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self->priv->_game = _tmp3_;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp4_ = self->priv->_game;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp5_ = nibbles_game_get_boni (_tmp4_);
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp6_ = _tmp5_;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_signal_connect_object (_tmp6_, "bonus-added", (GCallback) _nibbles_view_bonus_added_cb_boni_bonus_added, self, 0);
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp7_ = self->priv->_game;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp8_ = nibbles_game_get_boni (_tmp7_);
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp9_ = _tmp8_;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_signal_connect_object (_tmp9_, "bonus-removed", (GCallback) _nibbles_view_bonus_removed_cb_boni_bonus_removed, self, 0);
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp10_ = self->priv->_game;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_signal_connect_object (_tmp10_, "bonus-applied", (GCallback) _nibbles_view_bonus_applied_cb_nibbles_game_bonus_applied, self, 0);
#line 146 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp11_ = self->priv->_game;
#line 146 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp12_ = nibbles_game_get_warp_manager (_tmp11_);
#line 146 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp13_ = _tmp12_;
#line 146 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_signal_connect_object (_tmp13_, "warp-added", (GCallback) _nibbles_view_warp_added_cb_warp_manager_warp_added, self, 0);
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp14_ = self->priv->_game;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_signal_connect_object (_tmp14_, "animate-end-game", (GCallback) _nibbles_view_animate_end_game_cb_nibbles_game_animate_end_game, self, 0);
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_object_notify ((GObject *) self, "game");
#line 7087 "nibbles-view.c"
}


static void nibbles_view_class_init (NibblesViewClass * klass) {
	gchar** _tmp0_ = NULL;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_parent_class = g_type_class_peek_parent (klass);
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_type_class_add_private (klass, sizeof (NibblesViewPrivate));
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_nibbles_view_get_property;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_nibbles_view_set_property;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	G_OBJECT_CLASS (klass)->finalize = nibbles_view_finalize;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_VIEW_NAME_LABELS, g_param_spec_object ("name-labels", "name-labels", "name-labels", clutter_actor_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_VIEW_GAME, g_param_spec_object ("game", "game", "game", TYPE_NIBBLES_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_ = g_new0 (gchar*, 6 + 1);
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_[0] = "red";
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_[1] = "green";
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_[2] = "blue";
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_[3] = "yellow";
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_[4] = "cyan";
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_tmp0_[5] = "purple";
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_color_lookup = _tmp0_;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	nibbles_view_color_lookup_length1 = 6;
#line 7125 "nibbles-view.c"
}


static void nibbles_view_instance_init (NibblesView * self) {
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self->priv = NIBBLES_VIEW_GET_PRIVATE (self);
#line 7132 "nibbles-view.c"
}


static void nibbles_view_finalize (GObject* obj) {
	NibblesView * self;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_VIEW, NibblesView);
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_vala_array_destroy (self->priv->wall_pixmaps, 11, (GDestroyNotify) g_object_unref);
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_vala_array_destroy (self->priv->worm_pixmaps, 6, (GDestroyNotify) g_object_unref);
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_vala_array_destroy (self->priv->boni_pixmaps, 9, (GDestroyNotify) g_object_unref);
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (self->priv->stage);
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (self->priv->level);
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (self->priv->_name_labels);
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (self->priv->worm_actors);
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (self->priv->bonus_actors);
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (self->priv->warp_actors);
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	G_OBJECT_CLASS (nibbles_view_parent_class)->finalize (obj);
#line 7162 "nibbles-view.c"
}


GType nibbles_view_get_type (void) {
	static volatile gsize nibbles_view_type_id__volatile = 0;
	if (g_once_init_enter (&nibbles_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NibblesViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesView), 0, (GInstanceInitFunc) nibbles_view_instance_init, NULL };
		GType nibbles_view_type_id;
		nibbles_view_type_id = g_type_register_static (gtk_clutter_embed_get_type (), "NibblesView", &g_define_type_info, 0);
		g_once_init_leave (&nibbles_view_type_id__volatile, nibbles_view_type_id);
	}
	return nibbles_view_type_id__volatile;
}


static void _vala_nibbles_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NibblesView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_VIEW, NibblesView);
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	switch (property_id) {
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		case NIBBLES_VIEW_NAME_LABELS:
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_value_set_object (value, nibbles_view_get_name_labels (self));
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		break;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		case NIBBLES_VIEW_GAME:
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		g_value_set_object (value, nibbles_view_get_game (self));
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		break;
#line 7195 "nibbles-view.c"
		default:
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		break;
#line 7201 "nibbles-view.c"
	}
}


static void _vala_nibbles_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NibblesView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_VIEW, NibblesView);
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
	switch (property_id) {
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		case NIBBLES_VIEW_NAME_LABELS:
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		nibbles_view_set_name_labels (self, g_value_get_object (value));
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		break;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		case NIBBLES_VIEW_GAME:
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		nibbles_view_set_game (self, g_value_get_object (value));
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		break;
#line 7223 "nibbles-view.c"
		default:
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-view.vala"
		break;
#line 7229 "nibbles-view.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



