/* gnome-nibbles.c generated by valac 0.32.0.61-f103e, the Vala compiler
 * generated from gnome-nibbles.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <clutter-gtk/clutter-gtk.h>
#include <libgnome-games-support.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <pango/pango.h>


#define TYPE_NIBBLES (nibbles_get_type ())
#define NIBBLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES, Nibbles))
#define NIBBLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES, NibblesClass))
#define IS_NIBBLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES))
#define IS_NIBBLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES))
#define NIBBLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES, NibblesClass))

typedef struct _Nibbles Nibbles;
typedef struct _NibblesClass NibblesClass;
typedef struct _NibblesPrivate NibblesPrivate;

#define TYPE_SCOREBOARD (scoreboard_get_type ())
#define SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCOREBOARD, Scoreboard))
#define SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCOREBOARD, ScoreboardClass))
#define IS_SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCOREBOARD))
#define IS_SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCOREBOARD))
#define SCOREBOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCOREBOARD, ScoreboardClass))

typedef struct _Scoreboard Scoreboard;
typedef struct _ScoreboardClass ScoreboardClass;

#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;

#define TYPE_NIBBLES_VIEW (nibbles_view_get_type ())
#define NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_VIEW, NibblesView))
#define NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_VIEW, NibblesViewClass))
#define IS_NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_VIEW))
#define IS_NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_VIEW))
#define NIBBLES_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_VIEW, NibblesViewClass))

typedef struct _NibblesView NibblesView;
typedef struct _NibblesViewClass NibblesViewClass;

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _NibblesViewPrivate NibblesViewPrivate;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;
#define _worm_properties_free0(var) ((var == NULL) ? NULL : (var = (worm_properties_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _WormPrivate WormPrivate;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())

#define TYPE_CONTROLS_GRID (controls_grid_get_type ())
#define CONTROLS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTROLS_GRID, ControlsGrid))
#define CONTROLS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTROLS_GRID, ControlsGridClass))
#define IS_CONTROLS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTROLS_GRID))
#define IS_CONTROLS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTROLS_GRID))
#define CONTROLS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTROLS_GRID, ControlsGridClass))

typedef struct _ControlsGrid ControlsGrid;
typedef struct _ControlsGridClass ControlsGridClass;
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _ScoreboardPrivate ScoreboardPrivate;

#define TYPE_PLAYER_SCORE_BOX (player_score_box_get_type ())
#define PLAYER_SCORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_SCORE_BOX, PlayerScoreBox))
#define PLAYER_SCORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxClass))
#define IS_PLAYER_SCORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_SCORE_BOX))
#define IS_PLAYER_SCORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_SCORE_BOX))
#define PLAYER_SCORE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxClass))

typedef struct _PlayerScoreBox PlayerScoreBox;
typedef struct _PlayerScoreBoxClass PlayerScoreBoxClass;
typedef struct _PlayerScoreBoxPrivate PlayerScoreBoxPrivate;
typedef struct _ControlsGridPrivate ControlsGridPrivate;

struct _Nibbles {
	GtkApplication parent_instance;
	NibblesPrivate * priv;
};

struct _NibblesClass {
	GtkApplicationClass parent_class;
};

struct _NibblesPrivate {
	GSettings* settings;
	GeeArrayList* worm_settings;
	GtkApplicationWindow* window;
	gboolean is_maximized;
	gboolean is_tiled;
	gint window_width;
	gint window_height;
	GtkStack* main_stack;
	GtkOverlay* overlay;
	GtkHeaderBar* headerbar;
	GtkButton* new_game_button;
	GtkButton* pause_button;
	GeeLinkedList* number_of_players_buttons;
	GeeLinkedList* number_of_ai_buttons;
	GtkButton* next_button;
	GtkButton* start_button;
	GtkBox* grids_box;
	GdkPixbuf* arrow_pixbuf;
	GdkPixbuf* arrow_key_pixbuf;
	GtkStack* statusbar_stack;
	GtkLabel* countdown;
	Scoreboard* scoreboard;
	GdkPixbuf* scoreboard_life;
	PreferencesDialog* preferences_dialog;
	NibblesView* view;
	GtkBox* game_box;
	GamesGridFrame* frame;
	NibblesGame* game;
	GamesScoresContext* scores_context;
	GeeLinkedList* scorecats;
	GSimpleAction* new_game_action;
	GSimpleAction* pause_action;
	GSimpleAction* back_action;
	guint countdown_id;
	gint seconds;
};

struct _NibblesView {
	GtkClutterEmbed parent_instance;
	NibblesViewPrivate * priv;
	gboolean is_muted;
};

struct _NibblesViewClass {
	GtkClutterEmbedClass parent_class;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _Block1Data {
	int _ref_count_;
	Nibbles* self;
	GtkMessageDialog* dialog;
};

typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	Nibbles* self;
	glong lowest_high_score;
	gint score;
	gint level_reached;
};

struct _Block3Data {
	int _ref_count_;
	Nibbles* self;
	GtkLabel* label;
	GtkButton* button;
};

struct _Block4Data {
	int _ref_count_;
	Nibbles* self;
	gboolean should_unpause;
};

struct _Block5Data {
	int _ref_count_;
	Nibbles* self;
	GtkLabel* game_over_label;
	GtkLabel* msg_label;
	GtkLabel* score_label;
	GtkLabel* points_left_label;
	GtkButton* button;
};

struct _Scoreboard {
	GtkBox parent_instance;
	ScoreboardPrivate * priv;
};

struct _ScoreboardClass {
	GtkBoxClass parent_class;
};

struct _ScoreboardPrivate {
	GeeHashMap* boxes;
};

struct _PlayerScoreBox {
	GtkBox parent_instance;
	PlayerScoreBoxPrivate * priv;
};

struct _PlayerScoreBoxClass {
	GtkBoxClass parent_class;
};

struct _PlayerScoreBoxPrivate {
	GtkLabel* name_label;
	GtkLabel* score_label;
	GtkGrid* lives_grid;
	GeeLinkedList* life_images;
};

struct _ControlsGrid {
	GtkGrid parent_instance;
	ControlsGridPrivate * priv;
};

struct _ControlsGridClass {
	GtkGridClass parent_class;
};

struct _ControlsGridPrivate {
	GtkLabel* name_label;
	GtkImage* arrow_up;
	GtkImage* arrow_down;
	GtkImage* arrow_left;
	GtkImage* arrow_right;
	GtkOverlay* move_up;
	GtkLabel* move_up_label;
	GtkOverlay* move_down;
	GtkLabel* move_down_label;
	GtkOverlay* move_left;
	GtkLabel* move_left_label;
	GtkOverlay* move_right;
	GtkLabel* move_right_label;
};


static gpointer nibbles_parent_class = NULL;
static gpointer scoreboard_parent_class = NULL;
static gpointer player_score_box_parent_class = NULL;
static gpointer controls_grid_parent_class = NULL;

GType nibbles_get_type (void) G_GNUC_CONST;
GType scoreboard_get_type (void) G_GNUC_CONST;
GType preferences_dialog_get_type (void) G_GNUC_CONST;
GType nibbles_view_get_type (void) G_GNUC_CONST;
GType nibbles_game_get_type (void) G_GNUC_CONST;
#define NIBBLES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NIBBLES, NibblesPrivate))
enum  {
	NIBBLES_DUMMY_PROPERTY
};
#define NIBBLES_COUNTDOWN_TIME 3
static void nibbles_start_game_cb (Nibbles* self);
static void _nibbles_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_new_game_cb (Nibbles* self);
static void _nibbles_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_pause_cb (Nibbles* self);
static void _nibbles_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_preferences_cb (Nibbles* self);
static void _nibbles_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_scores_cb (Nibbles* self);
static void _nibbles_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_help_cb (Nibbles* self);
static void _nibbles_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_about_cb (Nibbles* self);
static void _nibbles_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_show_new_game_screen_cb (Nibbles* self);
static void _nibbles_show_new_game_screen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_show_controls_screen_cb (Nibbles* self);
static void _nibbles_show_controls_screen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_back_cb (Nibbles* self);
static void _nibbles_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Nibbles* nibbles_new (void);
Nibbles* nibbles_construct (GType object_type);
static gint nibbles_real_handle_local_options (GApplication* base, GVariantDict* options);
static void nibbles_real_startup (GApplication* base);
static void nibbles_settings_changed_cb (Nibbles* self, const gchar* key);
static void _nibbles_settings_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
#define NIBBLES_GAME_MAX_WORMS 6
static void nibbles_worm_settings_changed_cb (Nibbles* self, GSettings* changed_worm_settings, const gchar* key);
static void _nibbles_worm_settings_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void nibbles_size_allocate_cb (Nibbles* self, GtkAllocation* allocation);
static void _nibbles_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean nibbles_window_state_event_cb (Nibbles* self, GdkEventWindowState* event);
static gboolean _nibbles_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static gboolean nibbles_key_press_event_cb (Nibbles* self, GtkWidget* widget, GdkEventKey* event);
static gboolean _nibbles_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
#define NIBBLES_GAME_MAX_HUMANS 4
static void nibbles_change_number_of_players_cb (Nibbles* self, GtkToggleButton* button);
static void _nibbles_change_number_of_players_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
#define NIBBLES_GAME_MAX_AI 5
static void nibbles_change_number_of_ai_cb (Nibbles* self, GtkToggleButton* button);
static void _nibbles_change_number_of_ai_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
NibblesGame* nibbles_game_new (GSettings* settings);
NibblesGame* nibbles_game_construct (GType object_type, GSettings* settings);
static void nibbles_log_score_cb (Nibbles* self, gint score, gint level_reached);
static void _nibbles_log_score_cb_nibbles_game_log_score (NibblesGame* _sender, gint score, gint level_reached, gpointer self);
static void nibbles_level_completed_cb (Nibbles* self);
static void _nibbles_level_completed_cb_nibbles_game_level_completed (NibblesGame* _sender, gpointer self);
static void __lambda13_ (Nibbles* self);
gboolean nibbles_game_get_is_paused (NibblesGame* self);
static void ___lambda13__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
NibblesView* nibbles_view_new (NibblesGame* game);
NibblesView* nibbles_view_construct (GType object_type, NibblesGame* game);
static gboolean nibbles_configure_event_cb (Nibbles* self, GdkEventConfigure* event);
static gboolean _nibbles_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
Scoreboard* scoreboard_new (void);
Scoreboard* scoreboard_construct (GType object_type);
GdkPixbuf* nibbles_view_load_pixmap_file (NibblesView* self, const gchar* pixmap, gint xsize, gint ysize);
gint nibbles_game_get_tile_size (NibblesGame* self);
void nibbles_game_set_numhumans (NibblesGame* self, gint value);
void nibbles_game_set_numai (NibblesGame* self, gint value);
static void nibbles_show_first_run_screen (Nibbles* self);
static void nibbles_create_scores (Nibbles* self);
static void nibbles_real_activate (GApplication* base);
static void nibbles_real_shutdown (GApplication* base);
void nibbles_game_save_properties (NibblesGame* self, GSettings* settings);
static gboolean nibbles_countdown_cb (Nibbles* self);
ClutterActor* nibbles_view_get_name_labels (NibblesView* self);
void nibbles_game_add_bonus (NibblesGame* self, gboolean regular);
void nibbles_game_start (NibblesGame* self);
gboolean nibbles_game_handle_keypress (NibblesGame* self, guint keyval);
void nibbles_view_board_rescale (NibblesView* self, gint tile_size);
void nibbles_view_boni_rescale (NibblesView* self, gint tile_size);
void nibbles_view_warps_rescale (NibblesView* self, gint tile_size);
GType worm_get_type (void) G_GNUC_CONST;
GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
void nibbles_game_set_tile_size (NibblesGame* self, gint value);
void nibbles_game_reset (NibblesGame* self);
void nibbles_view_new_level (NibblesView* self, gint level);
gint nibbles_game_get_current_level (NibblesGame* self);
void nibbles_view_connect_worm_signals (NibblesView* self);
void scoreboard_clear (Scoreboard* self);
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
void scoreboard_register (Scoreboard* self, Worm* worm, const gchar* color_name, GdkPixbuf* life_pixbuf);
gchar* nibbles_view_colorval_name (gint colorval);
void scoreboard_update (Scoreboard* self);
static void _scoreboard_update_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void nibbles_game_add_worms (NibblesGame* self);
void nibbles_view_create_name_labels (NibblesView* self);
static void nibbles_show_game_view (Nibbles* self);
static void nibbles_start_game_with_countdown (Nibbles* self);
static gboolean _nibbles_countdown_cb_gsource_func (gpointer self);
static void nibbles_restart_game (Nibbles* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
gboolean nibbles_game_get_is_running (NibblesGame* self);
void nibbles_game_stop (NibblesGame* self);
static void __lambda7_ (Block1Data* _data1_, gint response_id);
static void ___lambda7__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void nibbles_game_pause (NibblesGame* self);
void nibbles_game_unpause (NibblesGame* self);
void nibbles_game_set_speed (NibblesGame* self, gint value);
void nibbles_game_set_fakes (NibblesGame* self, gboolean value);
gint nibbles_game_get_numworms (NibblesGame* self);
gint nibbles_game_get_numhumans (NibblesGame* self);
gint nibbles_game_get_numai (NibblesGame* self);
void nibbles_game_create_worms (NibblesGame* self);
void nibbles_game_load_worm_properties (NibblesGame* self, GeeArrayList* worm_settings);
GType worm_direction_get_type (void) G_GNUC_CONST;
GType controls_grid_get_type (void) G_GNUC_CONST;
gint worm_get_id (Worm* self);
ControlsGrid* controls_grid_new (gint worm_id, WormProperties* worm_props, GdkPixbuf* arrow, GdkPixbuf* arrow_key);
ControlsGrid* controls_grid_construct (GType object_type, gint worm_id, WormProperties* worm_props, GdkPixbuf* arrow, GdkPixbuf* arrow_key);
static GamesScoresCategory* nibbles_category_request (Nibbles* self, const gchar* key);
static gchar* nibbles_get_new_scores_key (Nibbles* self, const gchar* old_key);
static GamesScoresCategory* _nibbles_category_request_games_scores_context_category_request_func (const gchar* category_key, gpointer self);
static gchar* _nibbles_get_new_scores_key_games_scores_directory_importer_category_convert_func (const gchar* old_key, gpointer self);
static GamesScoresCategory* nibbles_get_scores_category (Nibbles* self, gint speed, gboolean fakes);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
gint nibbles_game_get_speed (NibblesGame* self);
gboolean nibbles_game_get_fakes (NibblesGame* self);
static void nibbles_game_over (Nibbles* self, gint score, glong lowest_high_score, gint level_reached);
gint nibbles_game_get_start_level (NibblesGame* self);
static void __lambda10_ (Block2Data* _data2_, GObject* object, GAsyncResult* _result_);
static void ___lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
#define NIBBLES_GAME_MAX_LEVEL 26
static void __lambda11_ (Block3Data* _data3_);
static void ___lambda11__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean __lambda12_ (Block3Data* _data3_);
static gboolean ___lambda12__gsource_func (gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
PreferencesDialog* preferences_dialog_new (GtkApplicationWindow* window, GSettings* settings, GeeArrayList* worm_settings);
PreferencesDialog* preferences_dialog_construct (GType object_type, GtkApplicationWindow* window, GSettings* settings, GeeArrayList* worm_settings);
static void __lambda8_ (Block4Data* _data4_);
static void ___lambda8__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda9_ (Block5Data* _data5_);
static void ___lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self);
gint nibbles_main (gchar** args, int args_length1);
static void nibbles_finalize (GObject* obj);
GType player_score_box_get_type (void) G_GNUC_CONST;
#define SCOREBOARD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SCOREBOARD, ScoreboardPrivate))
enum  {
	SCOREBOARD_DUMMY_PROPERTY
};
gint worm_get_score (Worm* self);
gint worm_get_lives (Worm* self);
PlayerScoreBox* player_score_box_new (const gchar* name, PangoColor* color, gint score, gint lives_left, GdkPixbuf* life_pixbuf);
PlayerScoreBox* player_score_box_construct (GType object_type, const gchar* name, PangoColor* color, gint score, gint lives_left, GdkPixbuf* life_pixbuf);
void player_score_box_update (PlayerScoreBox* self, gint score, gint lives_left);
static void scoreboard_finalize (GObject* obj);
#define PLAYER_SCORE_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxPrivate))
enum  {
	PLAYER_SCORE_BOX_DUMMY_PROPERTY
};
#define WORM_MAX_LIVES 12
#define WORM_STARTING_LIVES 6
void player_score_box_update_score (PlayerScoreBox* self, gint score);
void player_score_box_update_lives (PlayerScoreBox* self, gint lives_left);
static void player_score_box_finalize (GObject* obj);
#define CONTROLS_GRID_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONTROLS_GRID, ControlsGridPrivate))
enum  {
	CONTROLS_GRID_DUMMY_PROPERTY
};
static void controls_grid_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry NIBBLES_action_entries[8] = {{"start-game", _nibbles_start_game_cb_gsimple_action_activate_callback}, {"new-game", _nibbles_new_game_cb_gsimple_action_activate_callback}, {"pause", _nibbles_pause_cb_gsimple_action_activate_callback}, {"preferences", _nibbles_preferences_cb_gsimple_action_activate_callback}, {"scores", _nibbles_scores_cb_gsimple_action_activate_callback}, {"help", _nibbles_help_cb_gsimple_action_activate_callback}, {"about", _nibbles_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GActionEntry NIBBLES_menu_entries[3] = {{"show-new-game-screen", _nibbles_show_new_game_screen_cb_gsimple_action_activate_callback}, {"show-controls-screen", _nibbles_show_controls_screen_cb_gsimple_action_activate_callback}, {"back", _nibbles_back_cb_gsimple_action_activate_callback}};
static const GOptionEntry NIBBLES_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Show release version", NULL}, {NULL}};

static void _nibbles_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_start_game_cb ((Nibbles*) self);
#line 524 "gnome-nibbles.c"
}


static void _nibbles_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_new_game_cb ((Nibbles*) self);
#line 531 "gnome-nibbles.c"
}


static void _nibbles_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_pause_cb ((Nibbles*) self);
#line 538 "gnome-nibbles.c"
}


static void _nibbles_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_preferences_cb ((Nibbles*) self);
#line 545 "gnome-nibbles.c"
}


static void _nibbles_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_scores_cb ((Nibbles*) self);
#line 552 "gnome-nibbles.c"
}


static void _nibbles_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_help_cb ((Nibbles*) self);
#line 559 "gnome-nibbles.c"
}


static void _nibbles_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_about_cb ((Nibbles*) self);
#line 566 "gnome-nibbles.c"
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_application_quit ((GApplication*) self);
#line 573 "gnome-nibbles.c"
}


static void _nibbles_show_new_game_screen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_show_new_game_screen_cb ((Nibbles*) self);
#line 580 "gnome-nibbles.c"
}


static void _nibbles_show_controls_screen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_show_controls_screen_cb ((Nibbles*) self);
#line 587 "gnome-nibbles.c"
}


static void _nibbles_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_back_cb ((Nibbles*) self);
#line 594 "gnome-nibbles.c"
}


Nibbles* nibbles_construct (GType object_type) {
	Nibbles * self = NULL;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = (Nibbles*) g_object_new (object_type, "application-id", "org.gnome.nibbles", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_application_add_main_option_entries ((GApplication*) self, NIBBLES_option_entries);
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return self;
#line 606 "gnome-nibbles.c"
}


Nibbles* nibbles_new (void) {
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return nibbles_construct (TYPE_NIBBLES);
#line 613 "gnome-nibbles.c"
}


static gint nibbles_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Nibbles * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = (Nibbles*) base;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = options;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp1_) {
#line 632 "gnome-nibbles.c"
		FILE* _tmp2_ = NULL;
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp2_ = stderr;
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		fprintf (_tmp2_, "gnome-nibbles %s\n", VERSION);
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		result = EXIT_SUCCESS;
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		return result;
#line 642 "gnome-nibbles.c"
	}
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	result = -1;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return result;
#line 648 "gnome-nibbles.c"
}


static void _nibbles_settings_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_settings_changed_cb ((Nibbles*) self, key);
#line 655 "gnome-nibbles.c"
}


static void _nibbles_worm_settings_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_worm_settings_changed_cb ((Nibbles*) self, _sender, key);
#line 662 "gnome-nibbles.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return self ? g_object_ref (self) : NULL;
#line 669 "gnome-nibbles.c"
}


static void _nibbles_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_size_allocate_cb ((Nibbles*) self, allocation);
#line 676 "gnome-nibbles.c"
}


static gboolean _nibbles_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = nibbles_window_state_event_cb ((Nibbles*) self, event);
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return result;
#line 685 "gnome-nibbles.c"
}


static gboolean _nibbles_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = nibbles_key_press_event_cb ((Nibbles*) self, _sender, event);
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return result;
#line 694 "gnome-nibbles.c"
}


static void _nibbles_change_number_of_players_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_change_number_of_players_cb ((Nibbles*) self, _sender);
#line 701 "gnome-nibbles.c"
}


static void _nibbles_change_number_of_ai_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
#line 196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_change_number_of_ai_cb ((Nibbles*) self, _sender);
#line 708 "gnome-nibbles.c"
}


static void _nibbles_log_score_cb_nibbles_game_log_score (NibblesGame* _sender, gint score, gint level_reached, gpointer self) {
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_log_score_cb ((Nibbles*) self, score, level_reached);
#line 715 "gnome-nibbles.c"
}


static void _nibbles_level_completed_cb_nibbles_game_level_completed (NibblesGame* _sender, gpointer self) {
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_level_completed_cb ((Nibbles*) self);
#line 722 "gnome-nibbles.c"
}


static void __lambda13_ (Nibbles* self) {
	NibblesGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = nibbles_game_get_is_paused (_tmp0_);
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp2_) {
#line 738 "gnome-nibbles.c"
		GtkStack* _tmp3_ = NULL;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp3_ = self->priv->statusbar_stack;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_stack_set_visible_child_name (_tmp3_, "paused");
#line 744 "gnome-nibbles.c"
	} else {
		GtkStack* _tmp4_ = NULL;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp4_ = self->priv->statusbar_stack;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_stack_set_visible_child_name (_tmp4_, "scoreboard");
#line 751 "gnome-nibbles.c"
	}
}


static void ___lambda13__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	__lambda13_ ((Nibbles*) self);
#line 759 "gnome-nibbles.c"
}


static gboolean _nibbles_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = nibbles_configure_event_cb ((Nibbles*) self, event);
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return result;
#line 768 "gnome-nibbles.c"
}


static void nibbles_real_startup (GApplication* base) {
	Nibbles * self;
	gchar** argv = NULL;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	const gchar* _tmp0_ = NULL;
	GtkSettings* _tmp1_ = NULL;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp2_ = NULL;
	GtkCssProvider* _tmp3_ = NULL;
	GdkScreen* _tmp4_ = NULL;
	GtkCssProvider* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	GeeArrayList* _tmp8_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gchar** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	gchar* _tmp25_ = NULL;
	gchar** _tmp26_ = NULL;
	gchar** _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	gchar* _tmp28_ = NULL;
	gchar** _tmp29_ = NULL;
	gchar** _tmp30_ = NULL;
	gint _tmp30__length1 = 0;
	GAction* _tmp31_ = NULL;
	GSimpleAction* _tmp32_ = NULL;
	GAction* _tmp33_ = NULL;
	GSimpleAction* _tmp34_ = NULL;
	GAction* _tmp35_ = NULL;
	GSimpleAction* _tmp36_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp37_ = NULL;
	GtkBuilder* _tmp38_ = NULL;
	GObject* _tmp39_ = NULL;
	GtkApplicationWindow* _tmp40_ = NULL;
	GtkApplicationWindow* _tmp41_ = NULL;
	GtkApplicationWindow* _tmp42_ = NULL;
	GtkApplicationWindow* _tmp43_ = NULL;
	GtkApplicationWindow* _tmp44_ = NULL;
	GSettings* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	GSettings* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	GSettings* _tmp49_ = NULL;
	gboolean _tmp50_ = FALSE;
	GtkBuilder* _tmp52_ = NULL;
	GObject* _tmp53_ = NULL;
	GtkHeaderBar* _tmp54_ = NULL;
	GtkBuilder* _tmp55_ = NULL;
	GObject* _tmp56_ = NULL;
	GtkOverlay* _tmp57_ = NULL;
	GtkBuilder* _tmp58_ = NULL;
	GObject* _tmp59_ = NULL;
	GtkButton* _tmp60_ = NULL;
	GtkBuilder* _tmp61_ = NULL;
	GObject* _tmp62_ = NULL;
	GtkButton* _tmp63_ = NULL;
	GtkBuilder* _tmp64_ = NULL;
	GObject* _tmp65_ = NULL;
	GtkStack* _tmp66_ = NULL;
	GtkBuilder* _tmp67_ = NULL;
	GObject* _tmp68_ = NULL;
	GtkBox* _tmp69_ = NULL;
	GtkBuilder* _tmp70_ = NULL;
	GObject* _tmp71_ = NULL;
	GtkStack* _tmp72_ = NULL;
	GtkBuilder* _tmp73_ = NULL;
	GObject* _tmp74_ = NULL;
	GtkLabel* _tmp75_ = NULL;
	GeeLinkedList* _tmp76_ = NULL;
	GeeLinkedList* _tmp90_ = NULL;
	GtkBuilder* _tmp104_ = NULL;
	GObject* _tmp105_ = NULL;
	GtkButton* _tmp106_ = NULL;
	GtkBuilder* _tmp107_ = NULL;
	GObject* _tmp108_ = NULL;
	GtkButton* _tmp109_ = NULL;
	GtkBuilder* _tmp110_ = NULL;
	GObject* _tmp111_ = NULL;
	GtkBox* _tmp112_ = NULL;
	GtkApplicationWindow* _tmp113_ = NULL;
	GtkHeaderBar* _tmp114_ = NULL;
	GtkApplicationWindow* _tmp115_ = NULL;
	GSettings* _tmp116_ = NULL;
	NibblesGame* _tmp117_ = NULL;
	NibblesGame* _tmp118_ = NULL;
	NibblesGame* _tmp119_ = NULL;
	NibblesGame* _tmp120_ = NULL;
	NibblesGame* _tmp121_ = NULL;
	NibblesView* _tmp122_ = NULL;
	NibblesView* _tmp123_ = NULL;
	NibblesView* _tmp124_ = NULL;
	GSettings* _tmp125_ = NULL;
	gboolean _tmp126_ = FALSE;
	NibblesView* _tmp127_ = NULL;
	GamesGridFrame* _tmp128_ = NULL;
	GtkBox* _tmp129_ = NULL;
	GamesGridFrame* _tmp130_ = NULL;
	Scoreboard* _tmp131_ = NULL;
	NibblesView* _tmp132_ = NULL;
	NibblesGame* _tmp133_ = NULL;
	gint _tmp134_ = 0;
	gint _tmp135_ = 0;
	NibblesGame* _tmp136_ = NULL;
	gint _tmp137_ = 0;
	gint _tmp138_ = 0;
	GdkPixbuf* _tmp139_ = NULL;
	Scoreboard* _tmp140_ = NULL;
	GtkStack* _tmp141_ = NULL;
	Scoreboard* _tmp142_ = NULL;
	GamesGridFrame* _tmp143_ = NULL;
	NibblesView* _tmp144_ = NULL;
	GamesGridFrame* _tmp145_ = NULL;
	NibblesGame* _tmp146_ = NULL;
	GSettings* _tmp147_ = NULL;
	gint _tmp148_ = 0;
	NibblesGame* _tmp149_ = NULL;
	GSettings* _tmp150_ = NULL;
	gint _tmp151_ = 0;
	NibblesView* _tmp152_ = NULL;
	NibblesGame* _tmp153_ = NULL;
	gint _tmp154_ = 0;
	gint _tmp155_ = 0;
	NibblesGame* _tmp156_ = NULL;
	gint _tmp157_ = 0;
	gint _tmp158_ = 0;
	GdkPixbuf* _tmp159_ = NULL;
	NibblesView* _tmp160_ = NULL;
	NibblesGame* _tmp161_ = NULL;
	gint _tmp162_ = 0;
	gint _tmp163_ = 0;
	NibblesGame* _tmp164_ = NULL;
	gint _tmp165_ = 0;
	gint _tmp166_ = 0;
	GdkPixbuf* _tmp167_ = NULL;
	gboolean first_run = FALSE;
	GSettings* _tmp168_ = NULL;
	gboolean _tmp169_ = FALSE;
	gboolean _tmp170_ = FALSE;
	GtkApplicationWindow* _tmp171_ = NULL;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = (Nibbles*) base;
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	G_APPLICATION_CLASS (nibbles_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	argv = NULL;
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	argv_length1 = 0;
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_argv_size_ = argv_length1;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_clutter_init (&argv_length1, &argv);
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_set_prgname ("org.gnome.Nibbles");
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = _ ("Nibbles");
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_set_application_name (_tmp0_);
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_window_set_default_icon_name ("gnome-nibbles");
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = gtk_settings_get_default ();
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_object_set ((GObject*) _tmp1_, "gtk-application-prefer-dark-theme", TRUE, NULL);
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = gtk_css_provider_new ();
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	css_provider = _tmp2_;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = css_provider;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_css_provider_load_from_resource (_tmp3_, "/org/gnome/nibbles/ui/nibbles.css");
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = gdk_screen_get_default ();
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = css_provider;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_style_context_add_provider_for_screen (_tmp4_, (GtkStyleProvider*) _tmp5_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_action_map_add_action_entries ((GActionMap*) self, NIBBLES_action_entries, G_N_ELEMENTS (NIBBLES_action_entries), self);
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_action_map_add_action_entries ((GActionMap*) self, NIBBLES_menu_entries, G_N_ELEMENTS (NIBBLES_menu_entries), self);
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = g_settings_new ("org.gnome.nibbles");
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->settings);
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->settings = _tmp6_;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp7_ = self->priv->settings;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_signal_connect_object (_tmp7_, "changed", (GCallback) _nibbles_settings_changed_cb_g_settings_changed, self, 0);
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp8_ = gee_array_list_new (G_TYPE_SETTINGS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->worm_settings);
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->worm_settings = _tmp8_;
#line 973 "gnome-nibbles.c"
	{
		gint i = 0;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		i = 0;
#line 978 "gnome-nibbles.c"
		{
			gboolean _tmp9_ = FALSE;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp9_ = TRUE;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			while (TRUE) {
#line 985 "gnome-nibbles.c"
				gint _tmp11_ = 0;
				gchar* name = NULL;
				gint _tmp12_ = 0;
				gchar* _tmp13_ = NULL;
				GeeArrayList* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				GSettings* _tmp16_ = NULL;
				GSettings* _tmp17_ = NULL;
				GeeArrayList* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gpointer _tmp20_ = NULL;
				GSettings* _tmp21_ = NULL;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!_tmp9_) {
#line 1000 "gnome-nibbles.c"
					gint _tmp10_ = 0;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_tmp10_ = i;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					i = _tmp10_ + 1;
#line 1006 "gnome-nibbles.c"
				}
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp9_ = FALSE;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp11_ = i;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!(_tmp11_ < NIBBLES_GAME_MAX_WORMS)) {
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					break;
#line 1016 "gnome-nibbles.c"
				}
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp12_ = i;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp13_ = g_strdup_printf ("org.gnome.nibbles.worm%d", _tmp12_);
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				name = _tmp13_;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp14_ = self->priv->worm_settings;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp15_ = name;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp16_ = g_settings_new (_tmp15_);
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp17_ = _tmp16_;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp17_);
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_object_unref0 (_tmp17_);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp18_ = self->priv->worm_settings;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp19_ = i;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp19_);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp21_ = (GSettings*) _tmp20_;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				g_signal_connect_object (_tmp21_, "changed", (GCallback) _nibbles_worm_settings_changed_cb_g_settings_changed, self, 0);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_object_unref0 (_tmp21_);
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_free0 (name);
#line 1050 "gnome-nibbles.c"
			}
		}
	}
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp22_ = g_strdup ("<Primary>q");
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp23_ = g_new0 (gchar*, 1 + 1);
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp23_[0] = _tmp22_;
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp24_ = _tmp23_;
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp24__length1 = 1;
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp24_);
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp25_ = g_strdup ("Escape");
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp26_ = g_new0 (gchar*, 1 + 1);
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp26_[0] = _tmp25_;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp27_ = _tmp26_;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp27__length1 = 1;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.back", _tmp27_);
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp28_ = g_strdup ("F1");
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp29_ = g_new0 (gchar*, 1 + 1);
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp29_[0] = _tmp28_;
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp30_ = _tmp29_;
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp30__length1 = 1;
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp30_);
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp31_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, g_simple_action_get_type (), GSimpleAction));
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->new_game_action);
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->new_game_action = _tmp32_;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp33_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, g_simple_action_get_type (), GSimpleAction));
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->pause_action);
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->pause_action = _tmp34_;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp35_ = g_action_map_lookup_action ((GActionMap*) self, "back");
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, g_simple_action_get_type (), GSimpleAction));
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->back_action);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->back_action = _tmp36_;
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp37_ = gtk_builder_new_from_resource ("/org/gnome/nibbles/ui/nibbles.ui");
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	builder = _tmp37_;
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp38_ = builder;
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp39_ = gtk_builder_get_object (_tmp38_, "nibbles-window");
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, gtk_application_window_get_type ()) ? ((GtkApplicationWindow*) _tmp39_) : NULL);
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->window);
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->window = _tmp40_;
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp41_ = self->priv->window;
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_signal_connect_object ((GtkWidget*) _tmp41_, "size-allocate", (GCallback) _nibbles_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp42_ = self->priv->window;
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_signal_connect_object ((GtkWidget*) _tmp42_, "window-state-event", (GCallback) _nibbles_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp43_ = self->priv->window;
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_signal_connect_object ((GtkWidget*) _tmp43_, "key-press-event", (GCallback) _nibbles_key_press_event_cb_gtk_widget_key_press_event, self, 0);
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp44_ = self->priv->window;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp45_ = self->priv->settings;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp46_ = g_settings_get_int (_tmp45_, "window-width");
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp47_ = self->priv->settings;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp48_ = g_settings_get_int (_tmp47_, "window-height");
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_window_set_default_size ((GtkWindow*) _tmp44_, _tmp46_, _tmp48_);
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp49_ = self->priv->settings;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp50_ = g_settings_get_boolean (_tmp49_, "window-is-maximized");
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp50_) {
#line 1164 "gnome-nibbles.c"
		GtkApplicationWindow* _tmp51_ = NULL;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp51_ = self->priv->window;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_window_maximize ((GtkWindow*) _tmp51_);
#line 1170 "gnome-nibbles.c"
	}
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp52_ = builder;
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp53_ = gtk_builder_get_object (_tmp52_, "headerbar");
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_header_bar_get_type (), GtkHeaderBar));
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->headerbar = _tmp54_;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp55_ = builder;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp56_ = gtk_builder_get_object (_tmp55_, "main_overlay");
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_overlay_get_type (), GtkOverlay));
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->overlay);
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->overlay = _tmp57_;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp58_ = builder;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp59_ = gtk_builder_get_object (_tmp58_, "new_game_button");
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_button_get_type (), GtkButton));
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->new_game_button);
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->new_game_button = _tmp60_;
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp61_ = builder;
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp62_ = gtk_builder_get_object (_tmp61_, "pause_button");
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp63_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_button_get_type (), GtkButton));
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->pause_button);
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->pause_button = _tmp63_;
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp64_ = builder;
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp65_ = gtk_builder_get_object (_tmp64_, "main_stack");
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, gtk_stack_get_type (), GtkStack));
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->main_stack = _tmp66_;
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp67_ = builder;
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp68_ = gtk_builder_get_object (_tmp67_, "game_box");
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp69_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, gtk_box_get_type (), GtkBox));
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->game_box);
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->game_box = _tmp69_;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp70_ = builder;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp71_ = gtk_builder_get_object (_tmp70_, "statusbar_stack");
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp72_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, gtk_stack_get_type (), GtkStack));
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->statusbar_stack);
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->statusbar_stack = _tmp72_;
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp73_ = builder;
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp74_ = gtk_builder_get_object (_tmp73_, "countdown");
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp75_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, gtk_label_get_type (), GtkLabel));
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->countdown);
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->countdown = _tmp75_;
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp76_ = gee_linked_list_new (gtk_toggle_button_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->number_of_players_buttons);
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->number_of_players_buttons = _tmp76_;
#line 1258 "gnome-nibbles.c"
	{
		gint i = 0;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		i = 0;
#line 1263 "gnome-nibbles.c"
		{
			gboolean _tmp77_ = FALSE;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp77_ = TRUE;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			while (TRUE) {
#line 1270 "gnome-nibbles.c"
				gint _tmp79_ = 0;
				GtkToggleButton* button = NULL;
				GtkBuilder* _tmp80_ = NULL;
				gint _tmp81_ = 0;
				gchar* _tmp82_ = NULL;
				gchar* _tmp83_ = NULL;
				GObject* _tmp84_ = NULL;
				GtkToggleButton* _tmp85_ = NULL;
				GtkToggleButton* _tmp86_ = NULL;
				GtkToggleButton* _tmp87_ = NULL;
				GeeLinkedList* _tmp88_ = NULL;
				GtkToggleButton* _tmp89_ = NULL;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!_tmp77_) {
#line 1285 "gnome-nibbles.c"
					gint _tmp78_ = 0;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_tmp78_ = i;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					i = _tmp78_ + 1;
#line 1291 "gnome-nibbles.c"
				}
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp77_ = FALSE;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp79_ = i;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!(_tmp79_ < NIBBLES_GAME_MAX_HUMANS)) {
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					break;
#line 1301 "gnome-nibbles.c"
				}
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp80_ = builder;
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp81_ = i;
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp82_ = g_strdup_printf ("players%d", _tmp81_ + 1);
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp83_ = _tmp82_;
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp84_ = gtk_builder_get_object (_tmp80_, _tmp83_);
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp85_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp86_ = _tmp85_;
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_free0 (_tmp83_);
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				button = _tmp86_;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp87_ = button;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				g_signal_connect_object (_tmp87_, "toggled", (GCallback) _nibbles_change_number_of_players_cb_gtk_toggle_button_toggled, self, 0);
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp88_ = self->priv->number_of_players_buttons;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp89_ = button;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp88_, _tmp89_);
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_object_unref0 (button);
#line 1333 "gnome-nibbles.c"
			}
		}
	}
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp90_ = gee_linked_list_new (gtk_toggle_button_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->number_of_ai_buttons);
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->number_of_ai_buttons = _tmp90_;
#line 1343 "gnome-nibbles.c"
	{
		gint i = 0;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		i = 0;
#line 1348 "gnome-nibbles.c"
		{
			gboolean _tmp91_ = FALSE;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp91_ = TRUE;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			while (TRUE) {
#line 1355 "gnome-nibbles.c"
				gint _tmp93_ = 0;
				GtkToggleButton* button = NULL;
				GtkBuilder* _tmp94_ = NULL;
				gint _tmp95_ = 0;
				gchar* _tmp96_ = NULL;
				gchar* _tmp97_ = NULL;
				GObject* _tmp98_ = NULL;
				GtkToggleButton* _tmp99_ = NULL;
				GtkToggleButton* _tmp100_ = NULL;
				GtkToggleButton* _tmp101_ = NULL;
				GeeLinkedList* _tmp102_ = NULL;
				GtkToggleButton* _tmp103_ = NULL;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!_tmp91_) {
#line 1370 "gnome-nibbles.c"
					gint _tmp92_ = 0;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_tmp92_ = i;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					i = _tmp92_ + 1;
#line 1376 "gnome-nibbles.c"
				}
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp91_ = FALSE;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp93_ = i;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!(_tmp93_ <= NIBBLES_GAME_MAX_AI)) {
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					break;
#line 1386 "gnome-nibbles.c"
				}
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp94_ = builder;
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp95_ = i;
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp96_ = g_strdup_printf ("ai%d", _tmp95_);
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp97_ = _tmp96_;
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp98_ = gtk_builder_get_object (_tmp94_, _tmp97_);
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp99_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp100_ = _tmp99_;
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_free0 (_tmp97_);
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				button = _tmp100_;
#line 196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp101_ = button;
#line 196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				g_signal_connect_object (_tmp101_, "toggled", (GCallback) _nibbles_change_number_of_ai_cb_gtk_toggle_button_toggled, self, 0);
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp102_ = self->priv->number_of_ai_buttons;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp103_ = button;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp102_, _tmp103_);
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_object_unref0 (button);
#line 1418 "gnome-nibbles.c"
			}
		}
	}
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp104_ = builder;
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp105_ = gtk_builder_get_object (_tmp104_, "next_button");
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp106_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp105_, gtk_button_get_type (), GtkButton));
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->next_button);
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->next_button = _tmp106_;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp107_ = builder;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp108_ = gtk_builder_get_object (_tmp107_, "start_button");
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp109_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp108_, gtk_button_get_type (), GtkButton));
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->start_button);
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->start_button = _tmp109_;
#line 201 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp110_ = builder;
#line 201 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp111_ = gtk_builder_get_object (_tmp110_, "grids_box");
#line 201 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp112_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, gtk_box_get_type (), GtkBox));
#line 201 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->grids_box);
#line 201 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->grids_box = _tmp112_;
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp113_ = self->priv->window;
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp114_ = self->priv->headerbar;
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_window_set_titlebar ((GtkWindow*) _tmp113_, (GtkWidget*) _tmp114_);
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp115_ = self->priv->window;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp115_);
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp116_ = self->priv->settings;
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp117_ = nibbles_game_new (_tmp116_);
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->game);
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->game = _tmp117_;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp118_ = self->priv->game;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_signal_connect_object (_tmp118_, "log-score", (GCallback) _nibbles_log_score_cb_nibbles_game_log_score, self, 0);
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp119_ = self->priv->game;
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_signal_connect_object (_tmp119_, "level-completed", (GCallback) _nibbles_level_completed_cb_nibbles_game_level_completed, self, 0);
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp120_ = self->priv->game;
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_signal_connect_object ((GObject*) _tmp120_, "notify::is-paused", (GCallback) ___lambda13__g_object_notify, self, 0);
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp121_ = self->priv->game;
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp122_ = nibbles_view_new (_tmp121_);
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_object_ref_sink (_tmp122_);
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->view);
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->view = _tmp122_;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp123_ = self->priv->view;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_signal_connect_object ((GtkWidget*) _tmp123_, "configure-event", (GCallback) _nibbles_configure_event_cb_gtk_widget_configure_event, self, 0);
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp124_ = self->priv->view;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp125_ = self->priv->settings;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp126_ = g_settings_get_boolean (_tmp125_, "sound");
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp124_->is_muted = !_tmp126_;
#line 221 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp127_ = self->priv->view;
#line 221 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp127_);
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp128_ = games_grid_frame_new (NIBBLES_GAME_WIDTH, NIBBLES_GAME_HEIGHT);
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_object_ref_sink (_tmp128_);
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->frame);
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->frame = _tmp128_;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp129_ = self->priv->game_box;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp130_ = self->priv->frame;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_box_pack_start (_tmp129_, (GtkWidget*) _tmp130_, TRUE, TRUE, (guint) 0);
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp131_ = scoreboard_new ();
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_object_ref_sink (_tmp131_);
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scoreboard);
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->scoreboard = _tmp131_;
#line 228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp132_ = self->priv->view;
#line 228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp133_ = self->priv->game;
#line 228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp134_ = nibbles_game_get_tile_size (_tmp133_);
#line 228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp135_ = _tmp134_;
#line 228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp136_ = self->priv->game;
#line 228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp137_ = nibbles_game_get_tile_size (_tmp136_);
#line 228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp138_ = _tmp137_;
#line 228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp139_ = nibbles_view_load_pixmap_file (_tmp132_, "scoreboard-life.svg", 2 * _tmp135_, 2 * _tmp138_);
#line 228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scoreboard_life);
#line 228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->scoreboard_life = _tmp139_;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp140_ = self->priv->scoreboard;
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp140_);
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp141_ = self->priv->statusbar_stack;
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp142_ = self->priv->scoreboard;
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_stack_add_named (_tmp141_, (GtkWidget*) _tmp142_, "scoreboard");
#line 232 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp143_ = self->priv->frame;
#line 232 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp144_ = self->priv->view;
#line 232 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_container_add ((GtkContainer*) _tmp143_, (GtkWidget*) _tmp144_);
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp145_ = self->priv->frame;
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp145_);
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp146_ = self->priv->game;
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp147_ = self->priv->settings;
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp148_ = g_settings_get_int (_tmp147_, "players");
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_game_set_numhumans (_tmp146_, _tmp148_);
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp149_ = self->priv->game;
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp150_ = self->priv->settings;
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp151_ = g_settings_get_int (_tmp150_, "ai");
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_game_set_numai (_tmp149_, _tmp151_);
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp152_ = self->priv->view;
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp153_ = self->priv->game;
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp154_ = nibbles_game_get_tile_size (_tmp153_);
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp155_ = _tmp154_;
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp156_ = self->priv->game;
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp157_ = nibbles_game_get_tile_size (_tmp156_);
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp158_ = _tmp157_;
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp159_ = nibbles_view_load_pixmap_file (_tmp152_, "arrow.svg", 5 * _tmp155_, 5 * _tmp158_);
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_pixbuf);
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->arrow_pixbuf = _tmp159_;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp160_ = self->priv->view;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp161_ = self->priv->game;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp162_ = nibbles_game_get_tile_size (_tmp161_);
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp163_ = _tmp162_;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp164_ = self->priv->game;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp165_ = nibbles_game_get_tile_size (_tmp164_);
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp166_ = _tmp165_;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp167_ = nibbles_view_load_pixmap_file (_tmp160_, "arrow-key.svg", 5 * _tmp163_, 5 * _tmp166_);
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_key_pixbuf);
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->arrow_key_pixbuf = _tmp167_;
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp168_ = self->priv->settings;
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp169_ = g_settings_get_boolean (_tmp168_, "first-run");
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	first_run = _tmp169_;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp170_ = first_run;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp170_) {
#line 246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		nibbles_show_first_run_screen (self);
#line 1638 "gnome-nibbles.c"
	} else {
#line 248 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		nibbles_show_new_game_screen_cb (self);
#line 1642 "gnome-nibbles.c"
	}
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_create_scores (self);
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp171_ = self->priv->window;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp171_);
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (builder);
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (css_provider);
#line 1654 "gnome-nibbles.c"
}


static void nibbles_real_activate (GApplication* base) {
	Nibbles * self;
	GtkApplicationWindow* _tmp0_ = NULL;
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = (Nibbles*) base;
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	G_APPLICATION_CLASS (nibbles_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 260 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->window;
#line 260 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 1669 "gnome-nibbles.c"
}


static void nibbles_real_shutdown (GApplication* base) {
	Nibbles * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	NibblesGame* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
#line 263 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = (Nibbles*) base;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->settings;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = self->priv->window_width;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
#line 266 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = self->priv->settings;
#line 266 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = self->priv->window_height;
#line 266 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = self->priv->settings;
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = self->priv->is_maximized;
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = self->priv->game;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp7_ = self->priv->settings;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_game_save_properties (_tmp6_, _tmp7_);
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	G_APPLICATION_CLASS (nibbles_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 1711 "gnome-nibbles.c"
}


static gboolean nibbles_countdown_cb (Nibbles* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkLabel* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->seconds;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->seconds = _tmp0_ - 1;
#line 277 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = self->priv->seconds;
#line 277 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp1_ == 0) {
#line 1733 "gnome-nibbles.c"
		GtkStack* _tmp2_ = NULL;
		NibblesView* _tmp3_ = NULL;
		ClutterActor* _tmp4_ = NULL;
		ClutterActor* _tmp5_ = NULL;
		NibblesGame* _tmp6_ = NULL;
		NibblesGame* _tmp7_ = NULL;
		GSimpleAction* _tmp8_ = NULL;
		GSimpleAction* _tmp9_ = NULL;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp2_ = self->priv->statusbar_stack;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_stack_set_visible_child_name (_tmp2_, "scoreboard");
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp3_ = self->priv->view;
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp4_ = nibbles_view_get_name_labels (_tmp3_);
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp5_ = _tmp4_;
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		clutter_actor_hide (_tmp5_);
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp6_ = self->priv->game;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		nibbles_game_add_bonus (_tmp6_, TRUE);
#line 283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp7_ = self->priv->game;
#line 283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		nibbles_game_start (_tmp7_);
#line 285 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp8_ = self->priv->pause_action;
#line 285 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_simple_action_set_enabled (_tmp8_, TRUE);
#line 286 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp9_ = self->priv->back_action;
#line 286 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_simple_action_set_enabled (_tmp9_, TRUE);
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		self->priv->countdown_id = (guint) 0;
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		result = G_SOURCE_REMOVE;
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		return result;
#line 1776 "gnome-nibbles.c"
	}
#line 292 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp10_ = self->priv->countdown;
#line 292 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp11_ = self->priv->seconds;
#line 292 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp12_ = g_strdup_printf ("%i", _tmp11_);
#line 292 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp13_ = _tmp12_;
#line 292 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_label_set_label (_tmp10_, _tmp13_);
#line 292 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp13_);
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	result = G_SOURCE_CONTINUE;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return result;
#line 1794 "gnome-nibbles.c"
}


static gboolean nibbles_key_press_event_cb (Nibbles* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	NibblesGame* _tmp0_ = NULL;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gboolean _tmp3_ = FALSE;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 307 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 307 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = event;
#line 307 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = _tmp1_->keyval;
#line 307 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = nibbles_game_handle_keypress (_tmp0_, _tmp2_);
#line 307 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	result = _tmp3_;
#line 307 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return result;
#line 1822 "gnome-nibbles.c"
}


static void nibbles_size_allocate_cb (Nibbles* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkApplicationWindow* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (allocation != NULL);
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = self->priv->is_maximized;
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp1_) {
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp0_ = TRUE;
#line 1842 "gnome-nibbles.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp2_ = self->priv->is_tiled;
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp0_ = _tmp2_;
#line 1849 "gnome-nibbles.c"
	}
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp0_) {
#line 313 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		return;
#line 1855 "gnome-nibbles.c"
	}
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = self->priv->window;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_window_get_size ((GtkWindow*) _tmp3_, &_tmp4_, &_tmp5_);
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->window_width = _tmp4_;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->window_height = _tmp5_;
#line 1865 "gnome-nibbles.c"
}


static gboolean nibbles_window_state_event_cb (Nibbles* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
#line 317 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 317 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = event;
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1885 "gnome-nibbles.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp2_ = event;
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1894 "gnome-nibbles.c"
	}
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = event;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 1902 "gnome-nibbles.c"
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp6_ = event;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
#line 1911 "gnome-nibbles.c"
	}
#line 324 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	result = FALSE;
#line 324 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return result;
#line 1917 "gnome-nibbles.c"
}


static gboolean nibbles_configure_event_cb (Nibbles* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gint tile_size = 0;
	gint ts_x = 0;
	gint ts_y = 0;
	GdkEventConfigure* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GdkEventConfigure* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GdkEventConfigure* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp8_ = 0;
	GdkEventConfigure* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gboolean _tmp15_ = FALSE;
	gint _tmp16_ = 0;
	NibblesGame* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
#line 327 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 327 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = event;
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = _tmp0_->width;
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	ts_x = _tmp1_ / NIBBLES_GAME_WIDTH;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = event;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = _tmp2_->height;
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	ts_y = _tmp3_ / NIBBLES_GAME_HEIGHT;
#line 336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = ts_x;
#line 336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = event;
#line 336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = _tmp5_->width;
#line 336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if ((_tmp4_ * NIBBLES_GAME_WIDTH) > _tmp6_) {
#line 1969 "gnome-nibbles.c"
		gint _tmp7_ = 0;
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp7_ = ts_x;
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		ts_x = _tmp7_ - 1;
#line 1975 "gnome-nibbles.c"
	}
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp8_ = ts_y;
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp9_ = event;
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp10_ = _tmp9_->height;
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if ((_tmp8_ * NIBBLES_GAME_HEIGHT) > _tmp10_) {
#line 1985 "gnome-nibbles.c"
		gint _tmp11_ = 0;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp11_ = ts_y;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		ts_y = _tmp11_ - 1;
#line 1991 "gnome-nibbles.c"
	}
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp12_ = ts_x;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp13_ = ts_y;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp14_ = MIN (_tmp12_, _tmp13_);
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	tile_size = _tmp14_;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp16_ = tile_size;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp16_ == 0) {
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp15_ = TRUE;
#line 2007 "gnome-nibbles.c"
	} else {
		NibblesGame* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp17_ = self->priv->game;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp18_ = nibbles_game_get_tile_size (_tmp17_);
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp19_ = _tmp18_;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp15_ = _tmp19_ == 0;
#line 2020 "gnome-nibbles.c"
	}
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp15_) {
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		result = TRUE;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		return result;
#line 2028 "gnome-nibbles.c"
	}
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp20_ = self->priv->game;
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp21_ = nibbles_game_get_tile_size (_tmp20_);
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp22_ = _tmp21_;
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp23_ = tile_size;
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp22_ != _tmp23_) {
#line 2040 "gnome-nibbles.c"
		NibblesView* _tmp24_ = NULL;
		ClutterActor* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		NibblesView* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		NibblesView* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		NibblesView* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		NibblesGame* _tmp49_ = NULL;
		gint _tmp50_ = 0;
#line 347 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp24_ = self->priv->view;
#line 347 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp25_ = gtk_clutter_embed_get_stage ((GtkClutterEmbed*) _tmp24_);
#line 347 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp26_ = tile_size;
#line 347 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp27_ = tile_size;
#line 347 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		clutter_actor_set_size (_tmp25_, (gfloat) (_tmp26_ * NIBBLES_GAME_WIDTH), (gfloat) (_tmp27_ * NIBBLES_GAME_HEIGHT));
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp28_ = self->priv->view;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp29_ = tile_size;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		nibbles_view_board_rescale (_tmp28_, _tmp29_);
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp30_ = self->priv->view;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp31_ = tile_size;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		nibbles_view_boni_rescale (_tmp30_, _tmp31_);
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp32_ = self->priv->view;
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp33_ = tile_size;
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		nibbles_view_warps_rescale (_tmp32_, _tmp33_);
#line 2081 "gnome-nibbles.c"
		{
			GeeLinkedList* _worm_list = NULL;
			NibblesGame* _tmp34_ = NULL;
			GeeLinkedList* _tmp35_ = NULL;
			GeeLinkedList* _tmp36_ = NULL;
			GeeLinkedList* _tmp37_ = NULL;
			gint _worm_size = 0;
			GeeLinkedList* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			gint _worm_index = 0;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp34_ = self->priv->game;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp35_ = nibbles_game_get_worms (_tmp34_);
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp36_ = _tmp35_;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp37_ = _g_object_ref0 (_tmp36_);
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_worm_list = _tmp37_;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp38_ = _worm_list;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp39_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp38_);
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp40_ = _tmp39_;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_worm_size = _tmp40_;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_worm_index = -1;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			while (TRUE) {
#line 2115 "gnome-nibbles.c"
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				Worm* worm = NULL;
				GeeLinkedList* _tmp44_ = NULL;
				gint _tmp45_ = 0;
				gpointer _tmp46_ = NULL;
				Worm* _tmp47_ = NULL;
				gint _tmp48_ = 0;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp41_ = _worm_index;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_worm_index = _tmp41_ + 1;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp42_ = _worm_index;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp43_ = _worm_size;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!(_tmp42_ < _tmp43_)) {
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					break;
#line 2137 "gnome-nibbles.c"
				}
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp44_ = _worm_list;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp45_ = _worm_index;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp44_, _tmp45_);
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				worm = (Worm*) _tmp46_;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp47_ = worm;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp48_ = tile_size;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				g_signal_emit_by_name (_tmp47_, "rescaled", _tmp48_);
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_object_unref0 (worm);
#line 2155 "gnome-nibbles.c"
			}
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_object_unref0 (_worm_list);
#line 2159 "gnome-nibbles.c"
		}
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp49_ = self->priv->game;
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp50_ = tile_size;
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		nibbles_game_set_tile_size (_tmp49_, _tmp50_);
#line 2167 "gnome-nibbles.c"
	}
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	result = FALSE;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return result;
#line 2173 "gnome-nibbles.c"
}


static void _scoreboard_update_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	scoreboard_update ((Scoreboard*) self);
#line 2180 "gnome-nibbles.c"
}


static void nibbles_start_game_cb (Nibbles* self) {
	GSettings* _tmp0_ = NULL;
	NibblesGame* _tmp1_ = NULL;
	NibblesView* _tmp2_ = NULL;
	NibblesGame* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	NibblesView* _tmp6_ = NULL;
	Scoreboard* _tmp7_ = NULL;
	NibblesGame* _tmp39_ = NULL;
	NibblesView* _tmp40_ = NULL;
#line 361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->settings;
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_settings_set_boolean (_tmp0_, "first-run", FALSE);
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = self->priv->game;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_game_reset (_tmp1_);
#line 367 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = self->priv->view;
#line 367 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = self->priv->game;
#line 367 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = nibbles_game_get_current_level (_tmp3_);
#line 367 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = _tmp4_;
#line 367 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_view_new_level (_tmp2_, _tmp5_);
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = self->priv->view;
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_view_connect_worm_signals (_tmp6_);
#line 370 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp7_ = self->priv->scoreboard;
#line 370 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	scoreboard_clear (_tmp7_);
#line 2223 "gnome-nibbles.c"
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		GeeLinkedList* _tmp10_ = NULL;
		GeeLinkedList* _tmp11_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _worm_index = 0;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp8_ = self->priv->game;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp9_ = nibbles_game_get_worms (_tmp8_);
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp10_ = _tmp9_;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp11_ = _g_object_ref0 (_tmp10_);
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_worm_list = _tmp11_;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp12_ = _worm_list;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp13_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp12_);
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp14_ = _tmp13_;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_worm_size = _tmp14_;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_worm_index = -1;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		while (TRUE) {
#line 2257 "gnome-nibbles.c"
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gpointer _tmp20_ = NULL;
			gint color = 0;
			NibblesGame* _tmp21_ = NULL;
			GeeHashMap* _tmp22_ = NULL;
			GeeHashMap* _tmp23_ = NULL;
			Worm* _tmp24_ = NULL;
			gpointer _tmp25_ = NULL;
			WormProperties* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			Scoreboard* _tmp29_ = NULL;
			Worm* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			GdkPixbuf* _tmp34_ = NULL;
			Worm* _tmp35_ = NULL;
			Scoreboard* _tmp36_ = NULL;
			Worm* _tmp37_ = NULL;
			Scoreboard* _tmp38_ = NULL;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp15_ = _worm_index;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_worm_index = _tmp15_ + 1;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp16_ = _worm_index;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp17_ = _worm_size;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			if (!(_tmp16_ < _tmp17_)) {
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 2296 "gnome-nibbles.c"
			}
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp18_ = _worm_list;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp19_ = _worm_index;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp19_);
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			worm = (Worm*) _tmp20_;
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp21_ = self->priv->game;
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp22_ = nibbles_game_get_worm_props (_tmp21_);
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp23_ = _tmp22_;
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp24_ = worm;
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp25_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, _tmp24_);
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp26_ = (WormProperties*) _tmp25_;
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp27_ = (*_tmp26_).color;
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp28_ = _tmp27_;
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_worm_properties_free0 (_tmp26_);
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			color = _tmp28_;
#line 374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp29_ = self->priv->scoreboard;
#line 374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp30_ = worm;
#line 374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp31_ = color;
#line 374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp32_ = nibbles_view_colorval_name (_tmp31_);
#line 374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp33_ = _tmp32_;
#line 374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp34_ = self->priv->scoreboard_life;
#line 374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			scoreboard_register (_tmp29_, _tmp30_, _tmp33_, _tmp34_);
#line 374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_free0 (_tmp33_);
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp35_ = worm;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp36_ = self->priv->scoreboard;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			g_signal_connect_object ((GObject*) _tmp35_, "notify::lives", (GCallback) _scoreboard_update_g_object_notify, _tmp36_, 0);
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp37_ = worm;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp38_ = self->priv->scoreboard;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			g_signal_connect_object ((GObject*) _tmp37_, "notify::score", (GCallback) _scoreboard_update_g_object_notify, _tmp38_, 0);
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_object_unref0 (worm);
#line 2356 "gnome-nibbles.c"
		}
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_worm_list);
#line 2360 "gnome-nibbles.c"
	}
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp39_ = self->priv->game;
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_game_add_worms (_tmp39_);
#line 380 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp40_ = self->priv->view;
#line 380 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_view_create_name_labels (_tmp40_);
#line 382 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_show_game_view (self);
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_start_game_with_countdown (self);
#line 2374 "gnome-nibbles.c"
}


static gboolean _nibbles_countdown_cb_gsource_func (gpointer self) {
	gboolean result;
	result = nibbles_countdown_cb ((Nibbles*) self);
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return result;
#line 2383 "gnome-nibbles.c"
}


static void nibbles_start_game_with_countdown (Nibbles* self) {
	GtkStack* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	NibblesView* _tmp2_ = NULL;
	ClutterActor* _tmp3_ = NULL;
	ClutterActor* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->statusbar_stack;
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "countdown");
#line 391 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = self->priv->new_game_action;
#line 391 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp1_, TRUE);
#line 393 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->seconds = NIBBLES_COUNTDOWN_TIME;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = self->priv->view;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = nibbles_view_get_name_labels (_tmp2_);
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = _tmp3_;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	clutter_actor_show (_tmp4_);
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = self->priv->countdown;
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = g_strdup_printf ("%i", NIBBLES_COUNTDOWN_TIME);
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp7_ = _tmp6_;
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_label_set_label (_tmp5_, _tmp7_);
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp7_);
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp8_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _nibbles_countdown_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->countdown_id = _tmp8_;
#line 2431 "gnome-nibbles.c"
}


static void nibbles_restart_game (Nibbles* self) {
	NibblesView* _tmp0_ = NULL;
	NibblesGame* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	NibblesGame* _tmp4_ = NULL;
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->view;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = self->priv->game;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = nibbles_game_get_current_level (_tmp1_);
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = _tmp2_;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_view_new_level (_tmp0_, _tmp3_);
#line 404 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = self->priv->game;
#line 404 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_game_add_worms (_tmp4_);
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_start_game_with_countdown (self);
#line 2459 "gnome-nibbles.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return _data1_;
#line 2468 "gnome-nibbles.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 2477 "gnome-nibbles.c"
		Nibbles* self;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		self = _data1_->self;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_data1_->dialog);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (self);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_slice_free (Block1Data, _data1_);
#line 2487 "gnome-nibbles.c"
	}
}


static void __lambda7_ (Block1Data* _data1_, gint response_id) {
	Nibbles* self;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = _data1_->self;
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = response_id;
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 430 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		nibbles_show_new_game_screen_cb (self);
#line 2506 "gnome-nibbles.c"
	}
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = response_id;
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp3_ == ((gint) GTK_RESPONSE_CANCEL)) {
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp2_ = TRUE;
#line 2514 "gnome-nibbles.c"
	} else {
		gint _tmp4_ = 0;
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp4_ = response_id;
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp2_ = _tmp4_ == ((gint) GTK_RESPONSE_DELETE_EVENT);
#line 2521 "gnome-nibbles.c"
	}
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp2_) {
#line 2525 "gnome-nibbles.c"
		NibblesGame* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
#line 432 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp5_ = self->priv->game;
#line 432 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp6_ = nibbles_game_get_is_paused (_tmp5_);
#line 432 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp7_ = _tmp6_;
#line 432 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp1_ = !_tmp7_;
#line 2537 "gnome-nibbles.c"
	} else {
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp1_ = FALSE;
#line 2541 "gnome-nibbles.c"
	}
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp1_) {
#line 2545 "gnome-nibbles.c"
		gint _tmp8_ = 0;
		NibblesView* _tmp11_ = NULL;
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp8_ = self->priv->seconds;
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		if (_tmp8_ == 0) {
#line 2552 "gnome-nibbles.c"
			NibblesGame* _tmp9_ = NULL;
#line 435 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp9_ = self->priv->game;
#line 435 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			nibbles_game_start (_tmp9_);
#line 2558 "gnome-nibbles.c"
		} else {
			guint _tmp10_ = 0U;
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp10_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _nibbles_countdown_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			self->priv->countdown_id = _tmp10_;
#line 2565 "gnome-nibbles.c"
		}
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp11_ = self->priv->view;
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp11_);
#line 2571 "gnome-nibbles.c"
	}
#line 442 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _data1_->dialog);
#line 2575 "gnome-nibbles.c"
}


static void ___lambda7__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	__lambda7_ (self, response_id);
#line 2582 "gnome-nibbles.c"
}


static void nibbles_new_game_cb (Nibbles* self) {
	Block1Data* _data1_;
	guint _tmp0_ = 0U;
	NibblesGame* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GtkApplicationWindow* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkMessageDialog* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkButton* button = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkButton* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data1_->_ref_count_ = 1;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data1_->self = g_object_ref (self);
#line 410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->countdown_id;
#line 410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 2612 "gnome-nibbles.c"
		guint _tmp1_ = 0U;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp1_ = self->priv->countdown_id;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_source_remove (_tmp1_);
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		self->priv->countdown_id = (guint) 0;
#line 2620 "gnome-nibbles.c"
	}
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = self->priv->game;
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = nibbles_game_get_is_running (_tmp2_);
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = _tmp3_;
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp4_) {
#line 2630 "gnome-nibbles.c"
		NibblesGame* _tmp5_ = NULL;
#line 417 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp5_ = self->priv->game;
#line 417 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		nibbles_game_stop (_tmp5_);
#line 2636 "gnome-nibbles.c"
	}
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = self->priv->window;
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp7_ = _ ("Are you sure you want to start a new game?");
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp8_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp6_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK_CANCEL, _tmp7_);
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_object_ref_sink (_tmp8_);
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data1_->dialog = _tmp8_;
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp9_ = _ ("If you start a new game, the current one will be lost.");
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_object_set (_data1_->dialog, "secondary-text", _tmp9_, NULL);
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp10_ = gtk_dialog_get_widget_for_response ((GtkDialog*) _data1_->dialog, (gint) GTK_RESPONSE_OK);
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_button_get_type (), GtkButton));
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	button = _tmp11_;
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp12_ = _ ("_New Game");
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_button_set_label (button, _tmp12_);
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_signal_connect_data ((GtkDialog*) _data1_->dialog, "response", (GCallback) ___lambda7__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 445 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _data1_->dialog);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (button);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	block1_data_unref (_data1_);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data1_ = NULL;
#line 2672 "gnome-nibbles.c"
}


static void nibbles_pause_cb (Nibbles* self) {
	NibblesGame* _tmp0_ = NULL;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 450 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 450 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp0_ != NULL) {
#line 2684 "gnome-nibbles.c"
		NibblesGame* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
#line 452 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp1_ = self->priv->game;
#line 452 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp2_ = nibbles_game_get_is_running (_tmp1_);
#line 452 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp3_ = _tmp2_;
#line 452 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		if (_tmp3_) {
#line 2696 "gnome-nibbles.c"
			NibblesGame* _tmp4_ = NULL;
			GtkButton* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp4_ = self->priv->game;
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			nibbles_game_pause (_tmp4_);
#line 455 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp5_ = self->priv->pause_button;
#line 455 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp6_ = _ ("_Resume");
#line 455 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			gtk_button_set_label (_tmp5_, _tmp6_);
#line 2710 "gnome-nibbles.c"
		} else {
			NibblesGame* _tmp7_ = NULL;
			GtkButton* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			NibblesView* _tmp10_ = NULL;
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp7_ = self->priv->game;
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			nibbles_game_unpause (_tmp7_);
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp8_ = self->priv->pause_button;
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp9_ = _ ("_Pause");
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			gtk_button_set_label (_tmp8_, _tmp9_);
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp10_ = self->priv->view;
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
#line 2730 "gnome-nibbles.c"
		}
	}
}


static void nibbles_settings_changed_cb (Nibbles* self, const gchar* key) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 472 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp2_label0 = 0;
#line 472 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp2_label1 = 0;
#line 472 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp2_label2 = 0;
#line 470 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 470 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (key != NULL);
#line 472 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = key;
#line 472 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = _tmp0_;
#line 472 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 472 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("speed")))) {
#line 472 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 2760 "gnome-nibbles.c"
			default:
			{
				NibblesGame* _tmp4_ = NULL;
				GSettings* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gint _tmp7_ = 0;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp4_ = self->priv->game;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp5_ = self->priv->settings;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp6_ = key;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp7_ = g_settings_get_int (_tmp5_, _tmp6_);
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				nibbles_game_set_speed (_tmp4_, _tmp7_);
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 2779 "gnome-nibbles.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("sound")))) {
#line 472 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 2785 "gnome-nibbles.c"
			default:
			{
				NibblesView* _tmp8_ = NULL;
				GSettings* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
#line 478 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp8_ = self->priv->view;
#line 478 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp9_ = self->priv->settings;
#line 478 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp10_ = key;
#line 478 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp11_ = g_settings_get_boolean (_tmp9_, _tmp10_);
#line 478 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp8_->is_muted = !_tmp11_;
#line 479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 2804 "gnome-nibbles.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("fakes")))) {
#line 472 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 2810 "gnome-nibbles.c"
			default:
			{
				NibblesGame* _tmp12_ = NULL;
				GSettings* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp12_ = self->priv->game;
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp13_ = self->priv->settings;
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp14_ = key;
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp15_ = g_settings_get_boolean (_tmp13_, _tmp14_);
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				nibbles_game_set_fakes (_tmp12_, _tmp15_);
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 2829 "gnome-nibbles.c"
			}
		}
	}
}


static void nibbles_worm_settings_changed_cb (Nibbles* self, GSettings* changed_worm_settings, const gchar* key) {
	NibblesGame* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint id = 0;
	GeeArrayList* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	NibblesGame* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	Worm* worm = NULL;
	NibblesGame* _tmp12_ = NULL;
	GeeLinkedList* _tmp13_ = NULL;
	GeeLinkedList* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gpointer _tmp16_ = NULL;
	WormProperties* properties = NULL;
	NibblesGame* _tmp17_ = NULL;
	GeeHashMap* _tmp18_ = NULL;
	GeeHashMap* _tmp19_ = NULL;
	Worm* _tmp20_ = NULL;
	gpointer _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GQuark _tmp25_ = 0U;
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp24_label0 = 0;
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp24_label1 = 0;
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp24_label2 = 0;
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp24_label3 = 0;
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp24_label4 = 0;
#line 2875 "gnome-nibbles.c"
	NibblesGame* _tmp41_ = NULL;
	GeeHashMap* _tmp42_ = NULL;
	GeeHashMap* _tmp43_ = NULL;
	Worm* _tmp44_ = NULL;
	WormProperties* _tmp45_ = NULL;
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (changed_worm_settings != NULL);
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (key != NULL);
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = nibbles_game_get_worm_props (_tmp0_);
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = gee_abstract_map_get_size ((GeeMap*) _tmp2_);
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = _tmp3_;
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp4_ == 0) {
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		return;
#line 2901 "gnome-nibbles.c"
	}
#line 492 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = self->priv->worm_settings;
#line 492 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = changed_worm_settings;
#line 492 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp7_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp5_, _tmp6_);
#line 492 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	id = _tmp7_;
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp8_ = id;
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp9_ = self->priv->game;
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp10_ = nibbles_game_get_numworms (_tmp9_);
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp11_ = _tmp10_;
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp8_ >= _tmp11_) {
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		return;
#line 2923 "gnome-nibbles.c"
	}
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp12_ = self->priv->game;
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp13_ = nibbles_game_get_worms (_tmp12_);
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp14_ = _tmp13_;
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp15_ = id;
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _tmp15_);
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	worm = (Worm*) _tmp16_;
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp17_ = self->priv->game;
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp18_ = nibbles_game_get_worm_props (_tmp17_);
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp19_ = _tmp18_;
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp20_ = worm;
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, _tmp20_);
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	properties = (WormProperties*) _tmp21_;
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp22_ = key;
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp23_ = _tmp22_;
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp25_ = (NULL == _tmp23_) ? 0 : g_quark_from_string (_tmp23_);
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp25_ == ((0 != _tmp24_label0) ? _tmp24_label0 : (_tmp24_label0 = g_quark_from_static_string ("color")))) {
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 2959 "gnome-nibbles.c"
			default:
			{
				WormProperties* _tmp26_ = NULL;
				GSettings* _tmp27_ = NULL;
				gint _tmp28_ = 0;
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp26_ = properties;
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp27_ = changed_worm_settings;
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp28_ = g_settings_get_enum (_tmp27_, "color");
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				(*_tmp26_).color = _tmp28_;
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 2975 "gnome-nibbles.c"
			}
		}
	} else if (_tmp25_ == ((0 != _tmp24_label1) ? _tmp24_label1 : (_tmp24_label1 = g_quark_from_static_string ("key-up")))) {
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 2981 "gnome-nibbles.c"
			default:
			{
				WormProperties* _tmp29_ = NULL;
				GSettings* _tmp30_ = NULL;
				gint _tmp31_ = 0;
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp29_ = properties;
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp30_ = changed_worm_settings;
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp31_ = g_settings_get_int (_tmp30_, "key-up");
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				(*_tmp29_).up = (guint) _tmp31_;
#line 507 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 2997 "gnome-nibbles.c"
			}
		}
	} else if (_tmp25_ == ((0 != _tmp24_label2) ? _tmp24_label2 : (_tmp24_label2 = g_quark_from_static_string ("key-down")))) {
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 3003 "gnome-nibbles.c"
			default:
			{
				WormProperties* _tmp32_ = NULL;
				GSettings* _tmp33_ = NULL;
				gint _tmp34_ = 0;
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp32_ = properties;
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp33_ = changed_worm_settings;
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp34_ = g_settings_get_int (_tmp33_, "key-down");
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				(*_tmp32_).down = (guint) _tmp34_;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 3019 "gnome-nibbles.c"
			}
		}
	} else if (_tmp25_ == ((0 != _tmp24_label3) ? _tmp24_label3 : (_tmp24_label3 = g_quark_from_static_string ("key-left")))) {
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 3025 "gnome-nibbles.c"
			default:
			{
				WormProperties* _tmp35_ = NULL;
				GSettings* _tmp36_ = NULL;
				gint _tmp37_ = 0;
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp35_ = properties;
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp36_ = changed_worm_settings;
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp37_ = g_settings_get_int (_tmp36_, "key-left");
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				(*_tmp35_).left = (guint) _tmp37_;
#line 513 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 3041 "gnome-nibbles.c"
			}
		}
	} else if (_tmp25_ == ((0 != _tmp24_label4) ? _tmp24_label4 : (_tmp24_label4 = g_quark_from_static_string ("key-right")))) {
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 3047 "gnome-nibbles.c"
			default:
			{
				WormProperties* _tmp38_ = NULL;
				GSettings* _tmp39_ = NULL;
				gint _tmp40_ = 0;
#line 515 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp38_ = properties;
#line 515 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp39_ = changed_worm_settings;
#line 515 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp40_ = g_settings_get_int (_tmp39_, "key-right");
#line 515 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				(*_tmp38_).right = (guint) _tmp40_;
#line 516 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 3063 "gnome-nibbles.c"
			}
		}
	}
#line 519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp41_ = self->priv->game;
#line 519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp42_ = nibbles_game_get_worm_props (_tmp41_);
#line 519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp43_ = _tmp42_;
#line 519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp44_ = worm;
#line 519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp45_ = properties;
#line 519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp43_, _tmp44_, _tmp45_);
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_worm_properties_free0 (properties);
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (worm);
#line 3083 "gnome-nibbles.c"
}


static void nibbles_show_first_run_screen (Nibbles* self) {
	GtkStack* _tmp0_ = NULL;
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->main_stack;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "first_run");
#line 3095 "gnome-nibbles.c"
}


static void nibbles_show_new_game_screen_cb (Nibbles* self) {
	guint _tmp0_ = 0U;
	NibblesGame* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GtkHeaderBar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GSimpleAction* _tmp8_ = NULL;
	GSimpleAction* _tmp9_ = NULL;
	GSimpleAction* _tmp10_ = NULL;
	GtkButton* _tmp11_ = NULL;
	GtkButton* _tmp12_ = NULL;
	GeeLinkedList* _tmp13_ = NULL;
	NibblesGame* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gpointer _tmp17_ = NULL;
	GtkToggleButton* _tmp18_ = NULL;
	GeeLinkedList* _tmp19_ = NULL;
	NibblesGame* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gpointer _tmp23_ = NULL;
	GtkToggleButton* _tmp24_ = NULL;
	GtkApplicationWindow* _tmp25_ = NULL;
	GtkButton* _tmp26_ = NULL;
	GtkStack* _tmp27_ = NULL;
	GtkStack* _tmp28_ = NULL;
	GtkStack* _tmp29_ = NULL;
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 533 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->countdown_id;
#line 533 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 3134 "gnome-nibbles.c"
		guint _tmp1_ = 0U;
#line 535 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp1_ = self->priv->countdown_id;
#line 535 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_source_remove (_tmp1_);
#line 536 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		self->priv->countdown_id = (guint) 0;
#line 3142 "gnome-nibbles.c"
	}
#line 539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = self->priv->game;
#line 539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = nibbles_game_get_is_running (_tmp2_);
#line 539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = _tmp3_;
#line 539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp4_) {
#line 3152 "gnome-nibbles.c"
		NibblesGame* _tmp5_ = NULL;
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp5_ = self->priv->game;
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		nibbles_game_stop (_tmp5_);
#line 3158 "gnome-nibbles.c"
	}
#line 542 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = self->priv->headerbar;
#line 542 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp7_ = _ ("Nibbles");
#line 542 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_header_bar_set_title (_tmp6_, _tmp7_);
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp8_ = self->priv->new_game_action;
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp8_, FALSE);
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp9_ = self->priv->pause_action;
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp9_, FALSE);
#line 546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp10_ = self->priv->back_action;
#line 546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp10_, TRUE);
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp11_ = self->priv->new_game_button;
#line 548 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_hide ((GtkWidget*) _tmp11_);
#line 549 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp12_ = self->priv->pause_button;
#line 549 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_hide ((GtkWidget*) _tmp12_);
#line 551 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp13_ = self->priv->number_of_players_buttons;
#line 551 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp14_ = self->priv->game;
#line 551 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp15_ = nibbles_game_get_numhumans (_tmp14_);
#line 551 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp16_ = _tmp15_;
#line 551 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _tmp16_ - 1);
#line 551 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp18_ = (GtkToggleButton*) _tmp17_;
#line 551 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_toggle_button_set_active (_tmp18_, TRUE);
#line 551 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp18_);
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp19_ = self->priv->number_of_ai_buttons;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp20_ = self->priv->game;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp21_ = nibbles_game_get_numai (_tmp20_);
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp22_ = _tmp21_;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _tmp22_);
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp24_ = (GtkToggleButton*) _tmp23_;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_toggle_button_set_active (_tmp24_, TRUE);
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp24_);
#line 554 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp25_ = self->priv->window;
#line 554 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp26_ = self->priv->next_button;
#line 554 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_window_set_default ((GtkWindow*) _tmp25_, (GtkWidget*) _tmp26_);
#line 556 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp27_ = self->priv->main_stack;
#line 556 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp27_, GTK_STACK_TRANSITION_TYPE_NONE);
#line 557 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp28_ = self->priv->main_stack;
#line 557 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_stack_set_visible_child_name (_tmp28_, "number_of_players");
#line 558 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp29_ = self->priv->main_stack;
#line 558 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp29_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
#line 3236 "gnome-nibbles.c"
}


static void nibbles_show_controls_screen_cb (Nibbles* self) {
	NibblesGame* _tmp42_ = NULL;
	NibblesGame* _tmp43_ = NULL;
	GeeArrayList* _tmp44_ = NULL;
	GtkBox* _tmp45_ = NULL;
	GList* _tmp46_ = NULL;
	GtkApplicationWindow* _tmp79_ = NULL;
	GtkButton* _tmp80_ = NULL;
	GtkStack* _tmp81_ = NULL;
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 3251 "gnome-nibbles.c"
	{
		GeeLinkedList* _button_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _button_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _button_index = 0;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp0_ = self->priv->number_of_players_buttons;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_button_list = _tmp1_;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp2_ = _button_list;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp4_ = _tmp3_;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_button_size = _tmp4_;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_button_index = -1;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		while (TRUE) {
#line 3279 "gnome-nibbles.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GtkToggleButton* button = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GtkToggleButton* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp5_ = _button_index;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_button_index = _tmp5_ + 1;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp6_ = _button_index;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp7_ = _button_size;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 3301 "gnome-nibbles.c"
			}
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp8_ = _button_list;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp9_ = _button_index;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			button = (GtkToggleButton*) _tmp10_;
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp11_ = button;
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp12_ = gtk_toggle_button_get_active (_tmp11_);
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			if (_tmp12_) {
#line 3317 "gnome-nibbles.c"
				gint numhumans = 0;
				GtkToggleButton* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				NibblesGame* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				GSettings* _tmp17_ = NULL;
				NibblesGame* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
#line 568 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				numhumans = -1;
#line 569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp13_ = button;
#line 569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp14_ = gtk_button_get_label ((GtkButton*) _tmp13_);
#line 569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				sscanf (_tmp14_, "_%d", &numhumans);
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp15_ = self->priv->game;
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp16_ = numhumans;
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				nibbles_game_set_numhumans (_tmp15_, _tmp16_);
#line 573 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp17_ = self->priv->settings;
#line 573 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp18_ = self->priv->game;
#line 573 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp19_ = nibbles_game_get_numhumans (_tmp18_);
#line 573 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp20_ = _tmp19_;
#line 573 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				g_settings_set_int (_tmp17_, "players", _tmp20_);
#line 574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_object_unref0 (button);
#line 574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 3355 "gnome-nibbles.c"
			}
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_object_unref0 (button);
#line 3359 "gnome-nibbles.c"
		}
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_button_list);
#line 3363 "gnome-nibbles.c"
	}
	{
		GeeLinkedList* _button_list = NULL;
		GeeLinkedList* _tmp21_ = NULL;
		GeeLinkedList* _tmp22_ = NULL;
		gint _button_size = 0;
		GeeLinkedList* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gint _button_index = 0;
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp21_ = self->priv->number_of_ai_buttons;
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp22_ = _g_object_ref0 (_tmp21_);
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_button_list = _tmp22_;
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp23_ = _button_list;
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp24_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp23_);
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp25_ = _tmp24_;
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_button_size = _tmp25_;
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_button_index = -1;
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		while (TRUE) {
#line 3392 "gnome-nibbles.c"
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			GtkToggleButton* button = NULL;
			GeeLinkedList* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gpointer _tmp31_ = NULL;
			GtkToggleButton* _tmp32_ = NULL;
			gboolean _tmp33_ = FALSE;
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp26_ = _button_index;
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_button_index = _tmp26_ + 1;
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp27_ = _button_index;
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp28_ = _button_size;
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			if (!(_tmp27_ < _tmp28_)) {
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 3414 "gnome-nibbles.c"
			}
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp29_ = _button_list;
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp30_ = _button_index;
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _tmp30_);
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			button = (GtkToggleButton*) _tmp31_;
#line 581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp32_ = button;
#line 581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp33_ = gtk_toggle_button_get_active (_tmp32_);
#line 581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			if (_tmp33_) {
#line 3430 "gnome-nibbles.c"
				gint numai = 0;
				GtkToggleButton* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				NibblesGame* _tmp36_ = NULL;
				gint _tmp37_ = 0;
				GSettings* _tmp38_ = NULL;
				NibblesGame* _tmp39_ = NULL;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				numai = -1;
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp34_ = button;
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp35_ = gtk_button_get_label ((GtkButton*) _tmp34_);
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				sscanf (_tmp35_, "_%d", &numai);
#line 585 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp36_ = self->priv->game;
#line 585 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp37_ = numai;
#line 585 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				nibbles_game_set_numai (_tmp36_, _tmp37_);
#line 588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp38_ = self->priv->settings;
#line 588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp39_ = self->priv->game;
#line 588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp40_ = nibbles_game_get_numai (_tmp39_);
#line 588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp41_ = _tmp40_;
#line 588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				g_settings_set_int (_tmp38_, "ai", _tmp41_);
#line 589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_object_unref0 (button);
#line 589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 3468 "gnome-nibbles.c"
			}
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_object_unref0 (button);
#line 3472 "gnome-nibbles.c"
		}
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_button_list);
#line 3476 "gnome-nibbles.c"
	}
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp42_ = self->priv->game;
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_game_create_worms (_tmp42_);
#line 595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp43_ = self->priv->game;
#line 595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp44_ = self->priv->worm_settings;
#line 595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_game_load_worm_properties (_tmp43_, _tmp44_);
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp45_ = self->priv->grids_box;
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp46_ = gtk_container_get_children ((GtkContainer*) _tmp45_);
#line 3492 "gnome-nibbles.c"
	{
		GList* grid_collection = NULL;
		GList* grid_it = NULL;
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		grid_collection = _tmp46_;
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		for (grid_it = grid_collection; grid_it != NULL; grid_it = grid_it->next) {
#line 3500 "gnome-nibbles.c"
			GtkWidget* grid = NULL;
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			grid = (GtkWidget*) grid_it->data;
#line 3504 "gnome-nibbles.c"
			{
				GtkWidget* _tmp47_ = NULL;
#line 598 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp47_ = grid;
#line 598 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				gtk_widget_destroy (_tmp47_);
#line 3511 "gnome-nibbles.c"
			}
		}
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_list_free0 (grid_collection);
#line 3516 "gnome-nibbles.c"
	}
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp48_ = NULL;
		GeeLinkedList* _tmp49_ = NULL;
		GeeLinkedList* _tmp50_ = NULL;
		GeeLinkedList* _tmp51_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp52_ = NULL;
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		gint _worm_index = 0;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp48_ = self->priv->game;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp49_ = nibbles_game_get_worms (_tmp48_);
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp50_ = _tmp49_;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp51_ = _g_object_ref0 (_tmp50_);
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_worm_list = _tmp51_;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp52_ = _worm_list;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp53_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp52_);
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp54_ = _tmp53_;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_worm_size = _tmp54_;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_worm_index = -1;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		while (TRUE) {
#line 3551 "gnome-nibbles.c"
			gint _tmp55_ = 0;
			gint _tmp56_ = 0;
			gint _tmp57_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp58_ = NULL;
			gint _tmp59_ = 0;
			gpointer _tmp60_ = NULL;
			Worm* _tmp61_ = NULL;
			gboolean _tmp62_ = FALSE;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp55_ = _worm_index;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_worm_index = _tmp55_ + 1;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp56_ = _worm_index;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp57_ = _worm_size;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			if (!(_tmp56_ < _tmp57_)) {
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 3573 "gnome-nibbles.c"
			}
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp58_ = _worm_list;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp59_ = _worm_index;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp60_ = gee_abstract_list_get ((GeeAbstractList*) _tmp58_, _tmp59_);
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			worm = (Worm*) _tmp60_;
#line 602 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp61_ = worm;
#line 602 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp62_ = _tmp61_->is_human;
#line 602 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			if (_tmp62_) {
#line 3589 "gnome-nibbles.c"
				ControlsGrid* grid = NULL;
				Worm* _tmp63_ = NULL;
				gint _tmp64_ = 0;
				gint _tmp65_ = 0;
				NibblesGame* _tmp66_ = NULL;
				GeeHashMap* _tmp67_ = NULL;
				GeeHashMap* _tmp68_ = NULL;
				Worm* _tmp69_ = NULL;
				gpointer _tmp70_ = NULL;
				WormProperties* _tmp71_ = NULL;
				GdkPixbuf* _tmp72_ = NULL;
				GdkPixbuf* _tmp73_ = NULL;
				WormProperties _tmp74_ = {0};
				ControlsGrid* _tmp75_ = NULL;
				ControlsGrid* _tmp76_ = NULL;
				GtkBox* _tmp77_ = NULL;
				ControlsGrid* _tmp78_ = NULL;
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp63_ = worm;
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp64_ = worm_get_id (_tmp63_);
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp65_ = _tmp64_;
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp66_ = self->priv->game;
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp67_ = nibbles_game_get_worm_props (_tmp66_);
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp68_ = _tmp67_;
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp69_ = worm;
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp70_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp68_, _tmp69_);
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp71_ = (WormProperties*) _tmp70_;
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp72_ = self->priv->arrow_pixbuf;
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp73_ = self->priv->arrow_key_pixbuf;
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp74_ = *_tmp71_;
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp75_ = controls_grid_new (_tmp65_, &_tmp74_, _tmp72_, _tmp73_);
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				g_object_ref_sink (_tmp75_);
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp76_ = _tmp75_;
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_worm_properties_free0 (_tmp71_);
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				grid = _tmp76_;
#line 605 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp77_ = self->priv->grids_box;
#line 605 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp78_ = grid;
#line 605 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				gtk_container_add ((GtkContainer*) _tmp77_, (GtkWidget*) _tmp78_);
#line 602 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_object_unref0 (grid);
#line 3649 "gnome-nibbles.c"
			}
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_object_unref0 (worm);
#line 3653 "gnome-nibbles.c"
		}
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_worm_list);
#line 3657 "gnome-nibbles.c"
	}
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp79_ = self->priv->window;
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp80_ = self->priv->start_button;
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_window_set_default ((GtkWindow*) _tmp79_, (GtkWidget*) _tmp80_);
#line 611 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp81_ = self->priv->main_stack;
#line 611 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_stack_set_visible_child_name (_tmp81_, "controls");
#line 3669 "gnome-nibbles.c"
}


static void nibbles_show_game_view (Nibbles* self) {
	GtkStack* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GtkHeaderBar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	NibblesGame* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GtkStack* _tmp11_ = NULL;
	GtkStack* _tmp12_ = NULL;
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 620 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->main_stack;
#line 620 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp0_, GTK_STACK_TRANSITION_TYPE_NONE);
#line 621 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = self->priv->new_game_button;
#line 621 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp1_);
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = self->priv->pause_button;
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp2_);
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = self->priv->back_action;
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp3_, FALSE);
#line 626 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = self->priv->headerbar;
#line 626 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = _ ("Level %d");
#line 626 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = self->priv->game;
#line 626 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp7_ = nibbles_game_get_current_level (_tmp6_);
#line 626 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp8_ = _tmp7_;
#line 626 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp9_ = g_strdup_printf (_tmp5_, _tmp8_);
#line 626 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp10_ = _tmp9_;
#line 626 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_header_bar_set_title (_tmp4_, _tmp10_);
#line 626 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp10_);
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp11_ = self->priv->main_stack;
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_stack_set_visible_child_name (_tmp11_, "game_box");
#line 629 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp12_ = self->priv->main_stack;
#line 629 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp12_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
#line 3731 "gnome-nibbles.c"
}


static void nibbles_back_cb (Nibbles* self) {
	GtkStack* _tmp0_ = NULL;
	gchar* child_name = NULL;
	GtkStack* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GQuark _tmp7_ = 0U;
#line 637 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp6_label0 = 0;
#line 637 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp6_label1 = 0;
#line 637 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp6_label2 = 0;
#line 637 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp6_label3 = 0;
#line 3752 "gnome-nibbles.c"
	GtkStack* _tmp9_ = NULL;
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 634 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->main_stack;
#line 634 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp0_, GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN);
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = self->priv->main_stack;
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	child_name = _tmp3_;
#line 637 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = child_name;
#line 637 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = _tmp4_;
#line 637 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
#line 637 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("first_run")))) {
#line 637 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 3778 "gnome-nibbles.c"
			default:
			{
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 3783 "gnome-nibbles.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("number_of_players")))) {
#line 637 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 3789 "gnome-nibbles.c"
			default:
			{
#line 642 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 3794 "gnome-nibbles.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("controls")))) {
#line 637 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 3800 "gnome-nibbles.c"
			default:
			{
				GtkStack* _tmp8_ = NULL;
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp8_ = self->priv->main_stack;
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				gtk_stack_set_visible_child_name (_tmp8_, "number_of_players");
#line 645 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 3810 "gnome-nibbles.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("game_box")))) {
#line 637 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 3816 "gnome-nibbles.c"
			default:
			{
#line 647 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				nibbles_new_game_cb (self);
#line 648 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 3823 "gnome-nibbles.c"
			}
		}
	}
#line 651 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp9_ = self->priv->main_stack;
#line 651 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp9_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (child_name);
#line 3833 "gnome-nibbles.c"
}


static void nibbles_change_number_of_players_cb (Nibbles* self, GtkToggleButton* button) {
	GtkToggleButton* _tmp18_ = NULL;
	gint numhumans = 0;
	GtkToggleButton* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gint min_ai = 0;
	gint _tmp21_ = 0;
	gint max_ai = 0;
	gint _tmp22_ = 0;
	gint _tmp51_ = 0;
	GeeLinkedList* _tmp55_ = NULL;
	gint _tmp56_ = 0;
	gpointer _tmp57_ = NULL;
	GtkToggleButton* _tmp58_ = NULL;
#line 654 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 654 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (button != NULL);
#line 3855 "gnome-nibbles.c"
	{
		GeeLinkedList* _other_button_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _other_button_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _other_button_index = 0;
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp0_ = self->priv->number_of_players_buttons;
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_other_button_list = _tmp1_;
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp2_ = _other_button_list;
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp4_ = _tmp3_;
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_other_button_size = _tmp4_;
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_other_button_index = -1;
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		while (TRUE) {
#line 3883 "gnome-nibbles.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GtkToggleButton* other_button = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GtkToggleButton* _tmp11_ = NULL;
			GtkToggleButton* _tmp12_ = NULL;
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp5_ = _other_button_index;
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_other_button_index = _tmp5_ + 1;
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp6_ = _other_button_index;
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp7_ = _other_button_size;
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 3905 "gnome-nibbles.c"
			}
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp8_ = _other_button_list;
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp9_ = _other_button_index;
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			other_button = (GtkToggleButton*) _tmp10_;
#line 658 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp11_ = button;
#line 658 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp12_ = other_button;
#line 658 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			if (_tmp11_ != _tmp12_) {
#line 3921 "gnome-nibbles.c"
				GtkToggleButton* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
#line 660 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp13_ = other_button;
#line 660 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp14_ = gtk_toggle_button_get_active (_tmp13_);
#line 660 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (_tmp14_) {
#line 3930 "gnome-nibbles.c"
					GtkToggleButton* _tmp15_ = NULL;
					GtkToggleButton* _tmp16_ = NULL;
					GtkToggleButton* _tmp17_ = NULL;
#line 665 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_tmp15_ = other_button;
#line 665 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					g_signal_handlers_block_matched (_tmp15_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
#line 666 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_tmp16_ = other_button;
#line 666 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					gtk_toggle_button_set_active (_tmp16_, FALSE);
#line 667 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_tmp17_ = other_button;
#line 667 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					g_signal_handlers_unblock_matched (_tmp17_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
#line 668 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_g_object_unref0 (other_button);
#line 668 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					break;
#line 3950 "gnome-nibbles.c"
				}
			}
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_object_unref0 (other_button);
#line 3955 "gnome-nibbles.c"
		}
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_other_button_list);
#line 3959 "gnome-nibbles.c"
	}
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp18_ = button;
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_toggle_button_set_active (_tmp18_, TRUE);
#line 674 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	numhumans = -1;
#line 675 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp19_ = button;
#line 675 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp20_ = gtk_button_get_label ((GtkButton*) _tmp19_);
#line 675 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	sscanf (_tmp20_, "_%d", &numhumans);
#line 677 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp21_ = numhumans;
#line 677 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	min_ai = 4 - _tmp21_;
#line 678 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp22_ = numhumans;
#line 678 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	max_ai = NIBBLES_GAME_MAX_WORMS - _tmp22_;
#line 3981 "gnome-nibbles.c"
	{
		gint i = 0;
#line 679 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		i = 0;
#line 3986 "gnome-nibbles.c"
		{
			gboolean _tmp23_ = FALSE;
#line 679 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp23_ = TRUE;
#line 679 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			while (TRUE) {
#line 3993 "gnome-nibbles.c"
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				GeeLinkedList* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				gpointer _tmp29_ = NULL;
				GtkToggleButton* _tmp30_ = NULL;
#line 679 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!_tmp23_) {
#line 4002 "gnome-nibbles.c"
					gint _tmp24_ = 0;
#line 679 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_tmp24_ = i;
#line 679 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					i = _tmp24_ + 1;
#line 4008 "gnome-nibbles.c"
				}
#line 679 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp23_ = FALSE;
#line 679 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp25_ = i;
#line 679 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp26_ = min_ai;
#line 679 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!(_tmp25_ < _tmp26_)) {
#line 679 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					break;
#line 4020 "gnome-nibbles.c"
				}
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp27_ = self->priv->number_of_ai_buttons;
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp28_ = i;
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _tmp28_);
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp30_ = (GtkToggleButton*) _tmp29_;
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				gtk_widget_hide ((GtkWidget*) _tmp30_);
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_object_unref0 (_tmp30_);
#line 4034 "gnome-nibbles.c"
			}
		}
	}
	{
		gint i = 0;
		gint _tmp31_ = 0;
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp31_ = min_ai;
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		i = _tmp31_;
#line 4045 "gnome-nibbles.c"
		{
			gboolean _tmp32_ = FALSE;
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp32_ = TRUE;
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			while (TRUE) {
#line 4052 "gnome-nibbles.c"
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				GeeLinkedList* _tmp36_ = NULL;
				gint _tmp37_ = 0;
				gpointer _tmp38_ = NULL;
				GtkToggleButton* _tmp39_ = NULL;
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!_tmp32_) {
#line 4061 "gnome-nibbles.c"
					gint _tmp33_ = 0;
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_tmp33_ = i;
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					i = _tmp33_ + 1;
#line 4067 "gnome-nibbles.c"
				}
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp32_ = FALSE;
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp34_ = i;
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp35_ = max_ai;
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!(_tmp34_ <= _tmp35_)) {
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					break;
#line 4079 "gnome-nibbles.c"
				}
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp36_ = self->priv->number_of_ai_buttons;
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp37_ = i;
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, _tmp37_);
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp39_ = (GtkToggleButton*) _tmp38_;
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				gtk_widget_show ((GtkWidget*) _tmp39_);
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_object_unref0 (_tmp39_);
#line 4093 "gnome-nibbles.c"
			}
		}
	}
	{
		gint i = 0;
		gint _tmp40_ = 0;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp40_ = max_ai;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		i = _tmp40_ + 1;
#line 4104 "gnome-nibbles.c"
		{
			gboolean _tmp41_ = FALSE;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp41_ = TRUE;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			while (TRUE) {
#line 4111 "gnome-nibbles.c"
				gint _tmp43_ = 0;
				GeeLinkedList* _tmp44_ = NULL;
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
				GeeLinkedList* _tmp47_ = NULL;
				gint _tmp48_ = 0;
				gpointer _tmp49_ = NULL;
				GtkToggleButton* _tmp50_ = NULL;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!_tmp41_) {
#line 4122 "gnome-nibbles.c"
					gint _tmp42_ = 0;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_tmp42_ = i;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					i = _tmp42_ + 1;
#line 4128 "gnome-nibbles.c"
				}
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp41_ = FALSE;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp43_ = i;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp44_ = self->priv->number_of_ai_buttons;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp45_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp44_);
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp46_ = _tmp45_;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!(_tmp43_ < _tmp46_)) {
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					break;
#line 4144 "gnome-nibbles.c"
				}
#line 689 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp47_ = self->priv->number_of_ai_buttons;
#line 689 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp48_ = i;
#line 689 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, _tmp48_);
#line 689 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp50_ = (GtkToggleButton*) _tmp49_;
#line 689 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				gtk_widget_hide ((GtkWidget*) _tmp50_);
#line 689 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_object_unref0 (_tmp50_);
#line 4158 "gnome-nibbles.c"
			}
		}
	}
#line 692 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp51_ = numhumans;
#line 692 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp51_ == 4) {
#line 4166 "gnome-nibbles.c"
		GeeLinkedList* _tmp52_ = NULL;
		gpointer _tmp53_ = NULL;
		GtkToggleButton* _tmp54_ = NULL;
#line 694 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp52_ = self->priv->number_of_ai_buttons;
#line 694 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp53_ = gee_abstract_list_get ((GeeAbstractList*) _tmp52_, 0);
#line 694 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp54_ = (GtkToggleButton*) _tmp53_;
#line 694 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_widget_show ((GtkWidget*) _tmp54_);
#line 694 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_tmp54_);
#line 4180 "gnome-nibbles.c"
	}
#line 697 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp55_ = self->priv->number_of_ai_buttons;
#line 697 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp56_ = min_ai;
#line 697 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp57_ = gee_abstract_list_get ((GeeAbstractList*) _tmp55_, _tmp56_);
#line 697 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp58_ = (GtkToggleButton*) _tmp57_;
#line 697 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_toggle_button_set_active (_tmp58_, TRUE);
#line 697 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp58_);
#line 4194 "gnome-nibbles.c"
}


static void nibbles_change_number_of_ai_cb (Nibbles* self, GtkToggleButton* button) {
	GtkToggleButton* _tmp18_ = NULL;
#line 700 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 700 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (button != NULL);
#line 4204 "gnome-nibbles.c"
	{
		GeeLinkedList* _other_button_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _other_button_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _other_button_index = 0;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp0_ = self->priv->number_of_ai_buttons;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_other_button_list = _tmp1_;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp2_ = _other_button_list;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp4_ = _tmp3_;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_other_button_size = _tmp4_;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_other_button_index = -1;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		while (TRUE) {
#line 4232 "gnome-nibbles.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GtkToggleButton* other_button = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GtkToggleButton* _tmp11_ = NULL;
			GtkToggleButton* _tmp12_ = NULL;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp5_ = _other_button_index;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_other_button_index = _tmp5_ + 1;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp6_ = _other_button_index;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp7_ = _other_button_size;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 4254 "gnome-nibbles.c"
			}
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp8_ = _other_button_list;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp9_ = _other_button_index;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			other_button = (GtkToggleButton*) _tmp10_;
#line 704 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp11_ = button;
#line 704 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp12_ = other_button;
#line 704 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			if (_tmp11_ != _tmp12_) {
#line 4270 "gnome-nibbles.c"
				GtkToggleButton* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
#line 706 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp13_ = other_button;
#line 706 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp14_ = gtk_toggle_button_get_active (_tmp13_);
#line 706 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (_tmp14_) {
#line 4279 "gnome-nibbles.c"
					GtkToggleButton* _tmp15_ = NULL;
					GtkToggleButton* _tmp16_ = NULL;
					GtkToggleButton* _tmp17_ = NULL;
#line 711 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_tmp15_ = other_button;
#line 711 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					g_signal_handlers_block_matched (_tmp15_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
#line 712 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_tmp16_ = other_button;
#line 712 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					gtk_toggle_button_set_active (_tmp16_, FALSE);
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_tmp17_ = other_button;
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					g_signal_handlers_unblock_matched (_tmp17_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
#line 714 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_g_object_unref0 (other_button);
#line 714 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					break;
#line 4299 "gnome-nibbles.c"
				}
			}
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_object_unref0 (other_button);
#line 4304 "gnome-nibbles.c"
		}
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_other_button_list);
#line 4308 "gnome-nibbles.c"
	}
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp18_ = button;
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_toggle_button_set_active (_tmp18_, TRUE);
#line 4314 "gnome-nibbles.c"
}


static GamesScoresCategory* nibbles_category_request (Nibbles* self, const gchar* key) {
	GamesScoresCategory* result = NULL;
#line 725 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 725 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 4324 "gnome-nibbles.c"
	{
		GeeLinkedList* _cat_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _cat_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _cat_index = 0;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp0_ = self->priv->scorecats;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_cat_list = _tmp1_;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp2_ = _cat_list;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp4_ = _tmp3_;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_cat_size = _tmp4_;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_cat_index = -1;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		while (TRUE) {
#line 4352 "gnome-nibbles.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GamesScoresCategory* cat = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			GamesScoresCategory* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp5_ = _cat_index;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_cat_index = _tmp5_ + 1;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp6_ = _cat_index;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp7_ = _cat_size;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 4376 "gnome-nibbles.c"
			}
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp8_ = _cat_list;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp9_ = _cat_index;
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			cat = (GamesScoresCategory*) _tmp10_;
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp11_ = key;
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp12_ = cat;
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp13_ = games_scores_category_get_key (_tmp12_);
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp14_ = _tmp13_;
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			if (g_strcmp0 (_tmp11_, _tmp14_) == 0) {
#line 730 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				result = cat;
#line 730 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_object_unref0 (_cat_list);
#line 730 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				return result;
#line 4402 "gnome-nibbles.c"
			}
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_object_unref0 (cat);
#line 4406 "gnome-nibbles.c"
		}
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_cat_list);
#line 4410 "gnome-nibbles.c"
	}
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	result = NULL;
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return result;
#line 4416 "gnome-nibbles.c"
}


static gchar* nibbles_get_new_scores_key (Nibbles* self, const gchar* old_key) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp2_label0 = 0;
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp2_label1 = 0;
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp2_label2 = 0;
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp2_label3 = 0;
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp2_label4 = 0;
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp2_label5 = 0;
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp2_label6 = 0;
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static GQuark _tmp2_label7 = 0;
#line 735 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 735 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (old_key != NULL, NULL);
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = old_key;
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = _tmp0_;
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("1.0")))) {
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 4455 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp4_ = NULL;
#line 740 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp4_ = g_strdup ("fast");
#line 740 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				result = _tmp4_;
#line 740 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				return result;
#line 4465 "gnome-nibbles.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("2.0")))) {
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 4471 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp5_ = NULL;
#line 742 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp5_ = g_strdup ("medium");
#line 742 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				result = _tmp5_;
#line 742 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				return result;
#line 4481 "gnome-nibbles.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("3.0")))) {
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 4487 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp6_ = NULL;
#line 744 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp6_ = g_strdup ("slow");
#line 744 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				result = _tmp6_;
#line 744 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				return result;
#line 4497 "gnome-nibbles.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("4.0")))) {
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 4503 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp7_ = NULL;
#line 746 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp7_ = g_strdup ("beginner");
#line 746 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				result = _tmp7_;
#line 746 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				return result;
#line 4513 "gnome-nibbles.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("1.1")))) {
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 4519 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp8_ = NULL;
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp8_ = g_strdup ("fast-fakes");
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				result = _tmp8_;
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				return result;
#line 4529 "gnome-nibbles.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("2.1")))) {
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 4535 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp9_ = NULL;
#line 750 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp9_ = g_strdup ("medium-fakes");
#line 750 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				result = _tmp9_;
#line 750 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				return result;
#line 4545 "gnome-nibbles.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("3.1")))) {
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 4551 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp10_ = NULL;
#line 752 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp10_ = g_strdup ("slow-fakes");
#line 752 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				result = _tmp10_;
#line 752 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				return result;
#line 4561 "gnome-nibbles.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("4.1")))) {
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		switch (0) {
#line 4567 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp11_ = NULL;
#line 754 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp11_ = g_strdup ("beginner-fakes");
#line 754 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				result = _tmp11_;
#line 754 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				return result;
#line 4577 "gnome-nibbles.c"
			}
		}
	}
#line 756 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	result = NULL;
#line 756 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return result;
#line 4585 "gnome-nibbles.c"
}


static GamesScoresCategory* _nibbles_category_request_games_scores_context_category_request_func (const gchar* category_key, gpointer self) {
	GamesScoresCategory* result;
	result = nibbles_category_request ((Nibbles*) self, category_key);
#line 779 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return result;
#line 4594 "gnome-nibbles.c"
}


static gchar* _nibbles_get_new_scores_key_games_scores_directory_importer_category_convert_func (const gchar* old_key, gpointer self) {
	gchar* result;
	result = nibbles_get_new_scores_key ((Nibbles*) self, old_key);
#line 779 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return result;
#line 4603 "gnome-nibbles.c"
}


static void nibbles_create_scores (Nibbles* self) {
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GamesScoresCategory* _tmp3_ = NULL;
	GamesScoresCategory* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GamesScoresCategory* _tmp7_ = NULL;
	GamesScoresCategory* _tmp8_ = NULL;
	GeeLinkedList* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GamesScoresCategory* _tmp11_ = NULL;
	GamesScoresCategory* _tmp12_ = NULL;
	GeeLinkedList* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GamesScoresCategory* _tmp15_ = NULL;
	GamesScoresCategory* _tmp16_ = NULL;
	GeeLinkedList* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GamesScoresCategory* _tmp19_ = NULL;
	GamesScoresCategory* _tmp20_ = NULL;
	GeeLinkedList* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	GamesScoresCategory* _tmp23_ = NULL;
	GamesScoresCategory* _tmp24_ = NULL;
	GeeLinkedList* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GamesScoresCategory* _tmp27_ = NULL;
	GamesScoresCategory* _tmp28_ = NULL;
	GeeLinkedList* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	GamesScoresCategory* _tmp31_ = NULL;
	GamesScoresCategory* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	GtkApplicationWindow* _tmp34_ = NULL;
	GamesScoresDirectoryImporter* _tmp35_ = NULL;
	GamesScoresDirectoryImporter* _tmp36_ = NULL;
	GamesScoresContext* _tmp37_ = NULL;
#line 759 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 761 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = gee_linked_list_new (GAMES_SCORES_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 761 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scorecats);
#line 761 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->scorecats = _tmp0_;
#line 763 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = self->priv->scorecats;
#line 763 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = _ ("Beginner");
#line 763 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = games_scores_category_new ("beginner", _tmp2_);
#line 763 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = _tmp3_;
#line 763 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp4_);
#line 763 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp4_);
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = self->priv->scorecats;
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = _ ("Slow");
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp7_ = games_scores_category_new ("slow", _tmp6_);
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp8_ = _tmp7_;
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp8_);
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp8_);
#line 767 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp9_ = self->priv->scorecats;
#line 767 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp10_ = _ ("Medium");
#line 767 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp11_ = games_scores_category_new ("medium", _tmp10_);
#line 767 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp12_ = _tmp11_;
#line 767 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp12_);
#line 767 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp12_);
#line 769 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp13_ = self->priv->scorecats;
#line 769 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp14_ = _ ("Fast");
#line 769 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp15_ = games_scores_category_new ("fast", _tmp14_);
#line 769 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp16_ = _tmp15_;
#line 769 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp16_);
#line 769 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp16_);
#line 771 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp17_ = self->priv->scorecats;
#line 771 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp18_ = _ ("Beginner with Fakes");
#line 771 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp19_ = games_scores_category_new ("beginner-fakes", _tmp18_);
#line 771 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp20_ = _tmp19_;
#line 771 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp20_);
#line 771 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp20_);
#line 773 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp21_ = self->priv->scorecats;
#line 773 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp22_ = _ ("Slow with Fakes");
#line 773 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp23_ = games_scores_category_new ("slow-fakes", _tmp22_);
#line 773 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp24_ = _tmp23_;
#line 773 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp24_);
#line 773 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp24_);
#line 775 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp25_ = self->priv->scorecats;
#line 775 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp26_ = _ ("Medium with Fakes");
#line 775 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp27_ = games_scores_category_new ("medium-fakes", _tmp26_);
#line 775 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp28_ = _tmp27_;
#line 775 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp28_);
#line 775 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp28_);
#line 777 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp29_ = self->priv->scorecats;
#line 777 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp30_ = _ ("Fast with Fakes");
#line 777 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp31_ = games_scores_category_new ("fast-fakes", _tmp30_);
#line 777 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp32_ = _tmp31_;
#line 777 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, _tmp32_);
#line 777 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp32_);
#line 779 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp33_ = _ ("Difficulty Level:");
#line 779 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp34_ = self->priv->window;
#line 779 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp35_ = games_scores_directory_importer_new_with_convert_func (_nibbles_get_new_scores_key_games_scores_directory_importer_category_convert_func, self);
#line 779 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp36_ = _tmp35_;
#line 779 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp37_ = games_scores_context_new_with_importer ("gnome-nibbles", _tmp33_, (GtkWindow*) _tmp34_, _nibbles_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, (GamesScoresImporter*) _tmp36_);
#line 779 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scores_context);
#line 779 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->scores_context = _tmp37_;
#line 779 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp36_);
#line 4766 "gnome-nibbles.c"
}


static GamesScoresCategory* nibbles_get_scores_category (Nibbles* self, gint speed, gboolean fakes) {
	GamesScoresCategory* result = NULL;
	gchar* key = NULL;
	gint _tmp0_ = 0;
	gboolean _tmp5_ = FALSE;
	GeeLinkedList* _tmp23_ = NULL;
	gpointer _tmp24_ = NULL;
#line 789 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 791 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	key = NULL;
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = speed;
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	switch (_tmp0_) {
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		case 1:
#line 4787 "gnome-nibbles.c"
		{
			gchar* _tmp1_ = NULL;
#line 795 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp1_ = g_strdup ("fast");
#line 795 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_free0 (key);
#line 795 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			key = _tmp1_;
#line 796 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			break;
#line 4798 "gnome-nibbles.c"
		}
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		case 2:
#line 4802 "gnome-nibbles.c"
		{
			gchar* _tmp2_ = NULL;
#line 798 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp2_ = g_strdup ("medium");
#line 798 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_free0 (key);
#line 798 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			key = _tmp2_;
#line 799 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			break;
#line 4813 "gnome-nibbles.c"
		}
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		case 3:
#line 4817 "gnome-nibbles.c"
		{
			gchar* _tmp3_ = NULL;
#line 801 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp3_ = g_strdup ("slow");
#line 801 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_free0 (key);
#line 801 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			key = _tmp3_;
#line 802 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			break;
#line 4828 "gnome-nibbles.c"
		}
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		case 4:
#line 4832 "gnome-nibbles.c"
		{
			gchar* _tmp4_ = NULL;
#line 804 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp4_ = g_strdup ("beginner");
#line 804 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_free0 (key);
#line 804 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			key = _tmp4_;
#line 805 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			break;
#line 4843 "gnome-nibbles.c"
		}
		default:
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		break;
#line 4848 "gnome-nibbles.c"
	}
#line 808 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = fakes;
#line 808 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp5_) {
#line 4854 "gnome-nibbles.c"
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 809 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp6_ = key;
#line 809 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp7_ = g_strconcat (_tmp6_, "-fakes", NULL);
#line 809 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_free0 (key);
#line 809 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		key = _tmp7_;
#line 4865 "gnome-nibbles.c"
	}
	{
		GeeLinkedList* _cat_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _cat_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _cat_index = 0;
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp8_ = self->priv->scorecats;
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_cat_list = _tmp9_;
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp10_ = _cat_list;
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp12_ = _tmp11_;
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_cat_size = _tmp12_;
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_cat_index = -1;
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		while (TRUE) {
#line 4894 "gnome-nibbles.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			GamesScoresCategory* cat = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			GamesScoresCategory* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp13_ = _cat_index;
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_cat_index = _tmp13_ + 1;
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp14_ = _cat_index;
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp15_ = _cat_size;
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			if (!(_tmp14_ < _tmp15_)) {
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 4918 "gnome-nibbles.c"
			}
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp16_ = _cat_list;
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp17_ = _cat_index;
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			cat = (GamesScoresCategory*) _tmp18_;
#line 813 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp19_ = key;
#line 813 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp20_ = cat;
#line 813 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp21_ = games_scores_category_get_key (_tmp20_);
#line 813 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp22_ = _tmp21_;
#line 813 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			if (g_strcmp0 (_tmp19_, _tmp22_) == 0) {
#line 814 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				result = cat;
#line 814 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_object_unref0 (_cat_list);
#line 814 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_free0 (key);
#line 814 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				return result;
#line 4946 "gnome-nibbles.c"
			}
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_object_unref0 (cat);
#line 4950 "gnome-nibbles.c"
		}
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_cat_list);
#line 4954 "gnome-nibbles.c"
	}
#line 817 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp23_ = self->priv->scorecats;
#line 817 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp24_ = gee_linked_list_first (_tmp23_);
#line 817 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	result = (GamesScoresCategory*) _tmp24_;
#line 817 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (key);
#line 817 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return result;
#line 4966 "gnome-nibbles.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return _data2_;
#line 4975 "gnome-nibbles.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 4984 "gnome-nibbles.c"
		Nibbles* self;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		self = _data2_->self;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (self);
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_slice_free (Block2Data, _data2_);
#line 4992 "gnome-nibbles.c"
	}
}


static void __lambda10_ (Block2Data* _data2_, GObject* object, GAsyncResult* _result_) {
	Nibbles* self;
	gint _tmp4_ = 0;
	glong _tmp5_ = 0L;
	gint _tmp6_ = 0;
	GError * _inner_error_ = NULL;
#line 844 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = _data2_->self;
#line 844 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (_result_ != NULL);
#line 5007 "gnome-nibbles.c"
	{
		GamesScoresContext* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
#line 847 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp0_ = self->priv->scores_context;
#line 847 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp1_ = _result_;
#line 847 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		games_scores_context_add_score_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 847 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5019 "gnome-nibbles.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		e = _inner_error_;
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_inner_error_ = NULL;
#line 851 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp2_ = e;
#line 851 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp3_ = _tmp2_->message;
#line 851 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_warning ("gnome-nibbles.vala:851: Failed to add score: %s", _tmp3_);
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_error_free0 (e);
#line 5041 "gnome-nibbles.c"
	}
	__finally0:
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_clear_error (&_inner_error_);
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		return;
#line 5052 "gnome-nibbles.c"
	}
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = _data2_->score;
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = _data2_->lowest_high_score;
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = _data2_->level_reached;
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_game_over (self, _tmp4_, _tmp5_, _tmp6_);
#line 5062 "gnome-nibbles.c"
}


static void ___lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 841 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	__lambda10_ (self, source_object, res);
#line 841 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	block2_data_unref (self);
#line 5071 "gnome-nibbles.c"
}


static void nibbles_log_score_cb (Nibbles* self, gint score, gint level_reached) {
	Block2Data* _data2_;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GSimpleAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GeeList* scores = NULL;
	GamesScoresContext* _tmp4_ = NULL;
	NibblesGame* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	NibblesGame* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	GamesScoresCategory* _tmp11_ = NULL;
	GamesScoresCategory* _tmp12_ = NULL;
	GeeList* _tmp13_ = NULL;
	GeeList* _tmp14_ = NULL;
	glong _tmp15_ = 0L;
	GeeList* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	NibblesGame* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	NibblesGame* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	GamesScoresContext* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	NibblesGame* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	NibblesGame* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	GamesScoresCategory* _tmp44_ = NULL;
	GamesScoresCategory* _tmp45_ = NULL;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data2_->_ref_count_ = 1;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data2_->self = g_object_ref (self);
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = score;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data2_->score = _tmp0_;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = level_reached;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data2_->level_reached = _tmp1_;
#line 823 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = self->priv->new_game_action;
#line 823 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp2_, FALSE);
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = self->priv->pause_action;
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp3_, FALSE);
#line 826 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = self->priv->scores_context;
#line 826 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = self->priv->game;
#line 826 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = nibbles_game_get_speed (_tmp5_);
#line 826 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp7_ = _tmp6_;
#line 826 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp8_ = self->priv->game;
#line 826 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp9_ = nibbles_game_get_fakes (_tmp8_);
#line 826 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp10_ = _tmp9_;
#line 826 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp11_ = nibbles_get_scores_category (self, _tmp7_, _tmp10_);
#line 826 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp12_ = _tmp11_;
#line 826 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp13_ = games_scores_context_get_high_scores (_tmp4_, _tmp12_, 10);
#line 826 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp14_ = _tmp13_;
#line 826 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp12_);
#line 826 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	scores = _tmp14_;
#line 827 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp16_ = scores;
#line 827 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
#line 827 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp18_ = _tmp17_;
#line 827 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp18_ == 10) {
#line 5171 "gnome-nibbles.c"
		GeeList* _tmp19_ = NULL;
		gpointer _tmp20_ = NULL;
		GamesScoresScore* _tmp21_ = NULL;
		glong _tmp22_ = 0L;
		glong _tmp23_ = 0L;
#line 827 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp19_ = scores;
#line 827 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp20_ = gee_list_last (_tmp19_);
#line 827 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp21_ = (GamesScoresScore*) _tmp20_;
#line 827 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp22_ = games_scores_score_get_score (_tmp21_);
#line 827 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp23_ = _tmp22_;
#line 827 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp15_ = _tmp23_;
#line 827 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_tmp21_);
#line 5191 "gnome-nibbles.c"
	} else {
#line 827 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp15_ = (glong) -1;
#line 5195 "gnome-nibbles.c"
	}
#line 827 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data2_->lowest_high_score = _tmp15_;
#line 829 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp24_ = self->priv->game;
#line 829 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp25_ = nibbles_game_get_numhumans (_tmp24_);
#line 829 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp26_ = _tmp25_;
#line 829 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp26_ != 1) {
#line 5207 "gnome-nibbles.c"
		gint _tmp27_ = 0;
		glong _tmp28_ = 0L;
		gint _tmp29_ = 0;
#line 831 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp27_ = _data2_->score;
#line 831 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp28_ = _data2_->lowest_high_score;
#line 831 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp29_ = _data2_->level_reached;
#line 831 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		nibbles_game_over (self, _tmp27_, _tmp28_, _tmp29_);
#line 832 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (scores);
#line 832 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		block2_data_unref (_data2_);
#line 832 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_data2_ = NULL;
#line 832 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		return;
#line 5227 "gnome-nibbles.c"
	}
#line 835 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp30_ = self->priv->game;
#line 835 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp31_ = nibbles_game_get_start_level (_tmp30_);
#line 835 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp32_ = _tmp31_;
#line 835 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp32_ != 1) {
#line 5237 "gnome-nibbles.c"
		gint _tmp33_ = 0;
		glong _tmp34_ = 0L;
		gint _tmp35_ = 0;
#line 837 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp33_ = _data2_->score;
#line 837 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp34_ = _data2_->lowest_high_score;
#line 837 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp35_ = _data2_->level_reached;
#line 837 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		nibbles_game_over (self, _tmp33_, _tmp34_, _tmp35_);
#line 838 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (scores);
#line 838 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		block2_data_unref (_data2_);
#line 838 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_data2_ = NULL;
#line 838 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		return;
#line 5257 "gnome-nibbles.c"
	}
#line 841 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp36_ = self->priv->scores_context;
#line 841 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp37_ = _data2_->score;
#line 841 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp38_ = self->priv->game;
#line 841 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp39_ = nibbles_game_get_speed (_tmp38_);
#line 841 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp40_ = _tmp39_;
#line 841 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp41_ = self->priv->game;
#line 841 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp42_ = nibbles_game_get_fakes (_tmp41_);
#line 841 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp43_ = _tmp42_;
#line 841 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp44_ = nibbles_get_scores_category (self, _tmp40_, _tmp43_);
#line 841 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp45_ = _tmp44_;
#line 841 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	games_scores_context_add_score (_tmp36_, (glong) _tmp37_, _tmp45_, NULL, ___lambda10__gasync_ready_callback, block2_data_ref (_data2_));
#line 841 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp45_);
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (scores);
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	block2_data_unref (_data2_);
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data2_ = NULL;
#line 5289 "gnome-nibbles.c"
}


static void nibbles_scores_cb (Nibbles* self) {
	gboolean should_unpause = FALSE;
	NibblesGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GamesScoresContext* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 858 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 860 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	should_unpause = FALSE;
#line 861 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 861 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
#line 861 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 861 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp2_) {
#line 5312 "gnome-nibbles.c"
		GSimpleAction* _tmp3_ = NULL;
#line 863 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp3_ = self->priv->pause_action;
#line 863 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_signal_emit_by_name (_tmp3_, "activate", NULL);
#line 864 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		should_unpause = TRUE;
#line 5320 "gnome-nibbles.c"
	}
#line 867 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = self->priv->scores_context;
#line 867 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	games_scores_context_run_dialog (_tmp4_);
#line 870 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = should_unpause;
#line 870 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp5_) {
#line 5330 "gnome-nibbles.c"
		GSimpleAction* _tmp6_ = NULL;
#line 871 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp6_ = self->priv->pause_action;
#line 871 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_signal_emit_by_name (_tmp6_, "activate", NULL);
#line 5336 "gnome-nibbles.c"
	}
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return _data3_;
#line 5346 "gnome-nibbles.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 5355 "gnome-nibbles.c"
		Nibbles* self;
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		self = _data3_->self;
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_data3_->button);
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_data3_->label);
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (self);
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_slice_free (Block3Data, _data3_);
#line 5367 "gnome-nibbles.c"
	}
}


static void __lambda11_ (Block3Data* _data3_) {
	Nibbles* self;
	GtkLabel* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkHeaderBar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	NibblesGame* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 896 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = _data3_->self;
#line 897 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = _data3_->label;
#line 897 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 898 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = _data3_->button;
#line 898 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = self->priv->headerbar;
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = _ ("Level %d");
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = self->priv->game;
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = nibbles_game_get_current_level (_tmp4_);
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = _tmp5_;
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp7_ = g_strdup_printf (_tmp3_, _tmp6_);
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp8_ = _tmp7_;
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_header_bar_set_title (_tmp2_, _tmp8_);
#line 900 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp8_);
#line 902 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_restart_game (self);
#line 5413 "gnome-nibbles.c"
}


static void ___lambda11__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 896 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	__lambda11_ (self);
#line 5420 "gnome-nibbles.c"
}


static gboolean __lambda12_ (Block3Data* _data3_) {
	Nibbles* self;
	gboolean result = FALSE;
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
#line 910 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = _data3_->self;
#line 911 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = _data3_->button;
#line 911 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 912 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = _data3_->button;
#line 912 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
#line 914 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	result = G_SOURCE_REMOVE;
#line 914 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return result;
#line 5443 "gnome-nibbles.c"
}


static gboolean ___lambda12__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda12_ (self);
#line 910 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return result;
#line 5452 "gnome-nibbles.c"
}


static void nibbles_level_completed_cb (Nibbles* self) {
	Block3Data* _data3_;
	NibblesGame* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSimpleAction* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	NibblesGame* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkStyleContext* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GtkButton* _tmp20_ = NULL;
	GtkButton* _tmp21_ = NULL;
	GtkButton* _tmp22_ = NULL;
	GtkButton* _tmp23_ = NULL;
	GtkButton* _tmp24_ = NULL;
	GtkButton* _tmp25_ = NULL;
	GtkStyleContext* _tmp26_ = NULL;
	GtkButton* _tmp27_ = NULL;
	GtkOverlay* _tmp28_ = NULL;
	GtkLabel* _tmp29_ = NULL;
	GtkOverlay* _tmp30_ = NULL;
	GtkButton* _tmp31_ = NULL;
	GtkOverlay* _tmp32_ = NULL;
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data3_->_ref_count_ = 1;
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data3_->self = g_object_ref (self);
#line 876 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 876 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = nibbles_game_get_current_level (_tmp0_);
#line 876 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 876 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp2_ == NIBBLES_GAME_MAX_LEVEL) {
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		block3_data_unref (_data3_);
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_data3_ = NULL;
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		return;
#line 5513 "gnome-nibbles.c"
	}
#line 879 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = self->priv->new_game_action;
#line 879 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp3_, FALSE);
#line 880 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = self->priv->pause_action;
#line 880 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp4_, FALSE);
#line 883 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = _ ("Level %d Completed!");
#line 883 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = self->priv->game;
#line 883 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp7_ = nibbles_game_get_current_level (_tmp6_);
#line 883 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp8_ = _tmp7_;
#line 883 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp9_ = g_strdup_printf (_tmp5_, _tmp8_);
#line 883 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp10_ = _tmp9_;
#line 883 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp11_ = (GtkLabel*) gtk_label_new (_tmp10_);
#line 883 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_object_ref_sink (_tmp11_);
#line 883 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp12_ = _tmp11_;
#line 883 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp10_);
#line 883 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data3_->label = _tmp12_;
#line 884 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp13_ = _data3_->label;
#line 884 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_CENTER);
#line 885 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp14_ = _data3_->label;
#line 885 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp14_, GTK_ALIGN_START);
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp15_ = _data3_->label;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp15_, 150);
#line 887 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp16_ = _data3_->label;
#line 887 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
#line 887 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_style_context_add_class (_tmp17_, "menu-title");
#line 888 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp18_ = _data3_->label;
#line 888 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp18_);
#line 890 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp19_ = _ ("_Next Level");
#line 890 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp20_ = (GtkButton*) gtk_button_new_with_label (_tmp19_);
#line 890 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_object_ref_sink (_tmp20_);
#line 890 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data3_->button = _tmp20_;
#line 891 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp21_ = _data3_->button;
#line 891 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_button_set_use_underline (_tmp21_, TRUE);
#line 892 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp22_ = _data3_->button;
#line 892 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp22_, GTK_ALIGN_CENTER);
#line 893 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp23_ = _data3_->button;
#line 893 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp23_, GTK_ALIGN_END);
#line 894 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp24_ = _data3_->button;
#line 894 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp24_, 100);
#line 895 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp25_ = _data3_->button;
#line 895 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
#line 895 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_style_context_add_class (_tmp26_, "suggested-action");
#line 896 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp27_ = _data3_->button;
#line 896 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_signal_connect_data (_tmp27_, "clicked", (GCallback) ___lambda11__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 905 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp28_ = self->priv->overlay;
#line 905 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp29_ = _data3_->label;
#line 905 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_overlay_add_overlay (_tmp28_, (GtkWidget*) _tmp29_);
#line 906 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp30_ = self->priv->overlay;
#line 906 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp31_ = _data3_->button;
#line 906 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_overlay_add_overlay (_tmp30_, (GtkWidget*) _tmp31_);
#line 908 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp32_ = self->priv->overlay;
#line 908 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp32_);
#line 910 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda12__gsource_func, block3_data_ref (_data3_), block3_data_unref);
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	block3_data_unref (_data3_);
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data3_ = NULL;
#line 5623 "gnome-nibbles.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 918 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 918 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return _data4_;
#line 5632 "gnome-nibbles.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 918 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 5641 "gnome-nibbles.c"
		Nibbles* self;
#line 918 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		self = _data4_->self;
#line 918 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (self);
#line 918 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_slice_free (Block4Data, _data4_);
#line 5649 "gnome-nibbles.c"
	}
}


static void __lambda8_ (Block4Data* _data4_) {
	Nibbles* self;
	gboolean _tmp0_ = FALSE;
#line 939 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = _data4_->self;
#line 940 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 940 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->preferences_dialog = NULL;
#line 942 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = _data4_->should_unpause;
#line 942 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp0_) {
#line 5667 "gnome-nibbles.c"
		GSimpleAction* _tmp1_ = NULL;
#line 943 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp1_ = self->priv->pause_action;
#line 943 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_signal_emit_by_name (_tmp1_, "activate", NULL);
#line 5673 "gnome-nibbles.c"
	}
}


static void ___lambda8__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
#line 939 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	__lambda8_ (self);
#line 5681 "gnome-nibbles.c"
}


static void nibbles_preferences_cb (Nibbles* self) {
	Block4Data* _data4_;
	NibblesGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	PreferencesDialog* _tmp4_ = NULL;
	GtkApplicationWindow* _tmp8_ = NULL;
	GSettings* _tmp9_ = NULL;
	GeeArrayList* _tmp10_ = NULL;
	PreferencesDialog* _tmp11_ = NULL;
	PreferencesDialog* _tmp12_ = NULL;
	PreferencesDialog* _tmp13_ = NULL;
#line 918 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 918 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 918 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data4_->_ref_count_ = 1;
#line 918 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data4_->self = g_object_ref (self);
#line 920 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data4_->should_unpause = FALSE;
#line 921 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 921 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
#line 921 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 921 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp2_) {
#line 5715 "gnome-nibbles.c"
		GSimpleAction* _tmp3_ = NULL;
#line 923 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp3_ = self->priv->pause_action;
#line 923 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_signal_emit_by_name (_tmp3_, "activate", NULL);
#line 924 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_data4_->should_unpause = TRUE;
#line 5723 "gnome-nibbles.c"
	}
#line 927 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = self->priv->preferences_dialog;
#line 927 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp4_ != NULL) {
#line 5729 "gnome-nibbles.c"
		PreferencesDialog* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 929 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp5_ = self->priv->preferences_dialog;
#line 929 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_window_present ((GtkWindow*) _tmp5_);
#line 931 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp6_ = _data4_->should_unpause;
#line 931 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		if (_tmp6_) {
#line 5740 "gnome-nibbles.c"
			GSimpleAction* _tmp7_ = NULL;
#line 932 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp7_ = self->priv->pause_action;
#line 932 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			g_signal_emit_by_name (_tmp7_, "activate", NULL);
#line 5746 "gnome-nibbles.c"
		}
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		block4_data_unref (_data4_);
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_data4_ = NULL;
#line 934 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		return;
#line 5754 "gnome-nibbles.c"
	}
#line 937 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp8_ = self->priv->window;
#line 937 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp9_ = self->priv->settings;
#line 937 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp10_ = self->priv->worm_settings;
#line 937 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp11_ = preferences_dialog_new (_tmp8_, _tmp9_, _tmp10_);
#line 937 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_object_ref_sink (_tmp11_);
#line 937 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 937 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->preferences_dialog = _tmp11_;
#line 939 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp12_ = self->priv->preferences_dialog;
#line 939 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_signal_connect_data ((GtkWidget*) _tmp12_, "destroy", (GCallback) ___lambda8__gtk_widget_destroy, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
#line 946 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp13_ = self->priv->preferences_dialog;
#line 946 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_dialog_run ((GtkDialog*) _tmp13_);
#line 918 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	block4_data_unref (_data4_);
#line 918 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data4_ = NULL;
#line 5782 "gnome-nibbles.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return _data5_;
#line 5791 "gnome-nibbles.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 5800 "gnome-nibbles.c"
		Nibbles* self;
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		self = _data5_->self;
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_data5_->button);
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_data5_->points_left_label);
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_data5_->score_label);
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_data5_->msg_label);
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_data5_->game_over_label);
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (self);
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_slice_free (Block5Data, _data5_);
#line 5818 "gnome-nibbles.c"
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1412 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1413 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	result = self;
#line 1413 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 5831 "gnome-nibbles.c"
}


static void __lambda9_ (Block5Data* _data5_) {
	Nibbles* self;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
	GSimpleAction* _tmp6_ = NULL;
#line 990 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = _data5_->self;
#line 991 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = _data5_->game_over_label;
#line 991 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 992 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = _data5_->score_label;
#line 992 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
#line 993 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = _data5_->points_left_label;
#line 993 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp2_);
#line 994 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = _data5_->button;
#line 994 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
#line 995 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = _data5_->msg_label;
#line 995 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
#line 997 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = self->priv->new_game_action;
#line 997 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp5_, TRUE);
#line 998 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = self->priv->pause_action;
#line 998 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp6_, TRUE);
#line 1000 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_show_new_game_screen_cb (self);
#line 5876 "gnome-nibbles.c"
}


static void ___lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 990 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	__lambda9_ (self);
#line 5883 "gnome-nibbles.c"
}


static void nibbles_game_over (Nibbles* self, gint score, glong lowest_high_score, gint level_reached) {
	Block5Data* _data5_;
	gboolean is_high_score = FALSE;
	gint _tmp0_ = 0;
	glong _tmp1_ = 0L;
	gboolean is_game_won = FALSE;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkStyleContext* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	GtkLabel* _tmp20_ = NULL;
	GtkStyleContext* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	gchar* score_string = NULL;
	gint _tmp23_ = 0;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GtkLabel* _tmp33_ = NULL;
	GtkLabel* _tmp34_ = NULL;
	GtkLabel* _tmp35_ = NULL;
	GtkLabel* _tmp36_ = NULL;
	GtkLabel* _tmp37_ = NULL;
	GtkLabel* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	GtkLabel* _tmp40_ = NULL;
	glong points_left = 0L;
	glong _tmp41_ = 0L;
	gint _tmp42_ = 0;
	const gchar* _tmp43_ = NULL;
	glong _tmp44_ = 0L;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	GtkLabel* _tmp47_ = NULL;
	GtkLabel* _tmp48_ = NULL;
	GtkLabel* _tmp49_ = NULL;
	GtkLabel* _tmp50_ = NULL;
	GtkLabel* _tmp51_ = NULL;
	gint _tmp52_ = 0;
	GtkLabel* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	GtkButton* _tmp55_ = NULL;
	GtkButton* _tmp56_ = NULL;
	GtkButton* _tmp57_ = NULL;
	GtkButton* _tmp58_ = NULL;
	GtkButton* _tmp59_ = NULL;
	GtkButton* _tmp60_ = NULL;
	GtkStyleContext* _tmp61_ = NULL;
	GtkButton* _tmp62_ = NULL;
	GtkButton* _tmp63_ = NULL;
	GtkOverlay* _tmp64_ = NULL;
	GtkLabel* _tmp65_ = NULL;
	gboolean _tmp66_ = FALSE;
	NibblesGame* _tmp69_ = NULL;
	gint _tmp70_ = 0;
	gint _tmp71_ = 0;
	gboolean _tmp74_ = FALSE;
	NibblesGame* _tmp75_ = NULL;
	gint _tmp76_ = 0;
	gint _tmp77_ = 0;
	GtkOverlay* _tmp81_ = NULL;
	GtkButton* _tmp82_ = NULL;
	GtkButton* _tmp83_ = NULL;
	GtkOverlay* _tmp84_ = NULL;
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data5_->_ref_count_ = 1;
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data5_->self = g_object_ref (self);
#line 951 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = score;
#line 951 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = lowest_high_score;
#line 951 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	is_high_score = ((glong) _tmp0_) > _tmp1_;
#line 952 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = level_reached;
#line 952 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	is_game_won = _tmp2_ == (NIBBLES_GAME_MAX_LEVEL + 1);
#line 954 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = is_game_won;
#line 954 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp4_) {
#line 5991 "gnome-nibbles.c"
		const gchar* _tmp5_ = NULL;
#line 954 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp5_ = _ ("Congratulations!");
#line 954 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp3_ = _tmp5_;
#line 5997 "gnome-nibbles.c"
	} else {
		const gchar* _tmp6_ = NULL;
#line 954 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp6_ = _ ("Game Over!");
#line 954 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp3_ = _tmp6_;
#line 6004 "gnome-nibbles.c"
	}
#line 954 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp7_ = (GtkLabel*) gtk_label_new (_tmp3_);
#line 954 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_object_ref_sink (_tmp7_);
#line 954 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data5_->game_over_label = _tmp7_;
#line 955 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp8_ = _data5_->game_over_label;
#line 955 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_CENTER);
#line 956 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp9_ = _data5_->game_over_label;
#line 956 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp9_, GTK_ALIGN_START);
#line 957 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp10_ = _data5_->game_over_label;
#line 957 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp10_, 150);
#line 958 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp11_ = _data5_->game_over_label;
#line 958 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) _tmp11_);
#line 958 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_style_context_add_class (_tmp12_, "menu-title");
#line 959 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp13_ = _data5_->game_over_label;
#line 959 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp13_);
#line 961 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp14_ = _ ("You have completed the game.");
#line 961 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp15_ = (GtkLabel*) gtk_label_new (_tmp14_);
#line 961 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_object_ref_sink (_tmp15_);
#line 961 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data5_->msg_label = _tmp15_;
#line 962 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp16_ = _data5_->msg_label;
#line 962 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp16_, GTK_ALIGN_CENTER);
#line 963 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp17_ = _data5_->msg_label;
#line 963 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_START);
#line 964 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp18_ = _data5_->msg_label;
#line 964 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp19_ = self->priv->window_height;
#line 964 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp18_, _tmp19_ / 3);
#line 965 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp20_ = _data5_->msg_label;
#line 965 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) _tmp20_);
#line 965 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_style_context_add_class (_tmp21_, "menu-title");
#line 966 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp22_ = _data5_->msg_label;
#line 966 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp22_);
#line 968 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp23_ = score;
#line 968 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp24_ = ngettext ("%d Point", "%d Points", (gulong) _tmp23_);
#line 968 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp25_ = g_strdup (_tmp24_);
#line 968 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	score_string = _tmp25_;
#line 969 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp26_ = score_string;
#line 969 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp27_ = score;
#line 969 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp28_ = g_strdup_printf (_tmp26_, _tmp27_);
#line 969 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (score_string);
#line 969 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	score_string = _tmp28_;
#line 970 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp29_ = score_string;
#line 970 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp30_ = string_to_string (_tmp29_);
#line 970 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp31_ = g_strconcat ("<b>", _tmp30_, "</b>", NULL);
#line 970 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp32_ = _tmp31_;
#line 970 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp33_ = (GtkLabel*) gtk_label_new (_tmp32_);
#line 970 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_object_ref_sink (_tmp33_);
#line 970 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp34_ = _tmp33_;
#line 970 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp32_);
#line 970 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data5_->score_label = _tmp34_;
#line 971 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp35_ = _data5_->score_label;
#line 971 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_label_set_use_markup (_tmp35_, TRUE);
#line 972 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp36_ = _data5_->score_label;
#line 972 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp36_, GTK_ALIGN_CENTER);
#line 973 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp37_ = _data5_->score_label;
#line 973 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp37_, GTK_ALIGN_START);
#line 974 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp38_ = _data5_->score_label;
#line 974 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp39_ = self->priv->window_height;
#line 974 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp38_, (_tmp39_ / 3) + 80);
#line 975 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp40_ = _data5_->score_label;
#line 975 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp40_);
#line 977 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp41_ = lowest_high_score;
#line 977 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp42_ = score;
#line 977 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	points_left = _tmp41_ - _tmp42_;
#line 978 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp43_ = _ ("(%d more points to reach the leaderboard)");
#line 978 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp44_ = points_left;
#line 978 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp45_ = g_strdup_printf (_tmp43_, _tmp44_);
#line 978 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp46_ = _tmp45_;
#line 978 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp47_ = (GtkLabel*) gtk_label_new (_tmp46_);
#line 978 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_object_ref_sink (_tmp47_);
#line 978 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp48_ = _tmp47_;
#line 978 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp46_);
#line 978 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data5_->points_left_label = _tmp48_;
#line 979 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp49_ = _data5_->points_left_label;
#line 979 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp49_, GTK_ALIGN_CENTER);
#line 980 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp50_ = _data5_->points_left_label;
#line 980 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp50_, GTK_ALIGN_START);
#line 981 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp51_ = _data5_->points_left_label;
#line 981 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp52_ = self->priv->window_height;
#line 981 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp51_, (_tmp52_ / 3) + 100);
#line 982 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp53_ = _data5_->points_left_label;
#line 982 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp53_);
#line 984 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp54_ = _ ("_Play Again");
#line 984 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp55_ = (GtkButton*) gtk_button_new_with_label (_tmp54_);
#line 984 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_object_ref_sink (_tmp55_);
#line 984 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data5_->button = _tmp55_;
#line 985 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp56_ = _data5_->button;
#line 985 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_button_set_use_underline (_tmp56_, TRUE);
#line 986 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp57_ = _data5_->button;
#line 986 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp57_, GTK_ALIGN_CENTER);
#line 987 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp58_ = _data5_->button;
#line 987 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp58_, GTK_ALIGN_END);
#line 988 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp59_ = _data5_->button;
#line 988 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp59_, 100);
#line 989 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp60_ = _data5_->button;
#line 989 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp61_ = gtk_widget_get_style_context ((GtkWidget*) _tmp60_);
#line 989 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_style_context_add_class (_tmp61_, "suggested-action");
#line 990 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp62_ = _data5_->button;
#line 990 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_signal_connect_data (_tmp62_, "clicked", (GCallback) ___lambda9__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
#line 1002 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp63_ = _data5_->button;
#line 1002 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp63_);
#line 1004 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp64_ = self->priv->overlay;
#line 1004 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp65_ = _data5_->game_over_label;
#line 1004 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_overlay_add_overlay (_tmp64_, (GtkWidget*) _tmp65_);
#line 1005 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp66_ = is_game_won;
#line 1005 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp66_) {
#line 6214 "gnome-nibbles.c"
		GtkOverlay* _tmp67_ = NULL;
		GtkLabel* _tmp68_ = NULL;
#line 1006 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp67_ = self->priv->overlay;
#line 1006 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp68_ = _data5_->msg_label;
#line 1006 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp67_, (GtkWidget*) _tmp68_);
#line 6223 "gnome-nibbles.c"
	}
#line 1007 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp69_ = self->priv->game;
#line 1007 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp70_ = nibbles_game_get_numhumans (_tmp69_);
#line 1007 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp71_ = _tmp70_;
#line 1007 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp71_ == 1) {
#line 6233 "gnome-nibbles.c"
		GtkOverlay* _tmp72_ = NULL;
		GtkLabel* _tmp73_ = NULL;
#line 1008 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp72_ = self->priv->overlay;
#line 1008 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp73_ = _data5_->score_label;
#line 1008 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp72_, (GtkWidget*) _tmp73_);
#line 6242 "gnome-nibbles.c"
	}
#line 1009 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp75_ = self->priv->game;
#line 1009 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp76_ = nibbles_game_get_numhumans (_tmp75_);
#line 1009 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp77_ = _tmp76_;
#line 1009 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp77_ == 1) {
#line 6252 "gnome-nibbles.c"
		gboolean _tmp78_ = FALSE;
#line 1009 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp78_ = is_high_score;
#line 1009 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp74_ = !_tmp78_;
#line 6258 "gnome-nibbles.c"
	} else {
#line 1009 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp74_ = FALSE;
#line 6262 "gnome-nibbles.c"
	}
#line 1009 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (_tmp74_) {
#line 6266 "gnome-nibbles.c"
		GtkOverlay* _tmp79_ = NULL;
		GtkLabel* _tmp80_ = NULL;
#line 1010 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp79_ = self->priv->overlay;
#line 1010 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp80_ = _data5_->points_left_label;
#line 1010 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp79_, (GtkWidget*) _tmp80_);
#line 6275 "gnome-nibbles.c"
	}
#line 1011 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp81_ = self->priv->overlay;
#line 1011 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp82_ = _data5_->button;
#line 1011 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_overlay_add_overlay (_tmp81_, (GtkWidget*) _tmp82_);
#line 1013 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp83_ = _data5_->button;
#line 1013 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp83_);
#line 1015 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp84_ = self->priv->overlay;
#line 1015 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp84_);
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (score_string);
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	block5_data_unref (_data5_);
#line 949 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_data5_ = NULL;
#line 6297 "gnome-nibbles.c"
}


static void nibbles_help_cb (Nibbles* self) {
	GError * _inner_error_ = NULL;
#line 1018 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 6305 "gnome-nibbles.c"
	{
		GtkApplicationWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 1022 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp0_ = self->priv->window;
#line 1022 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 1022 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 1022 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_show_uri (_tmp1_, "help:gnome-nibbles", _tmp2_, &_inner_error_);
#line 1022 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6320 "gnome-nibbles.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 1020 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		e = _inner_error_;
#line 1020 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_inner_error_ = NULL;
#line 1026 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp3_ = e;
#line 1026 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp4_ = _tmp3_->message;
#line 1026 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_warning ("gnome-nibbles.vala:1026: Unable to open help: %s", _tmp4_);
#line 1020 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_error_free0 (e);
#line 6342 "gnome-nibbles.c"
	}
	__finally1:
#line 1020 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1020 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1020 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_clear_error (&_inner_error_);
#line 1020 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		return;
#line 6353 "gnome-nibbles.c"
	}
}


static void nibbles_about_cb (Nibbles* self) {
#line 1032 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static const gchar* authors[] = {"Sean MacIsaac", "Ian Peters", "Andreas Røsdal", "Guillaume Beland", "Iulian-Gabriel Radu", NULL};
#line 1039 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static const gchar* documenters[] = {"Kevin Breit", NULL};
#line 1042 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	static const gchar* artists[] = {"Allan Day", NULL};
#line 6365 "gnome-nibbles.c"
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 1030 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 1045 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->window;
#line 1045 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = _ ("Nibbles");
#line 1045 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = _ ("A worm game for GNOME");
#line 1045 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = _ ("translator-credits");
#line 1045 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp0_, "program-name", _tmp1_, "logo-icon-name", "gnome-nibbles", "version", VERSION, "comments", _tmp2_, "copyright", "Copyright © 1999–2008 Sean MacIsaac, Ian Peters, Andreas Røsdal\n" "Copyright © 2009 Guillaume Beland\n" "Copyright © 2015 Iulian-Gabriel Radu", "license-type", GTK_LICENSE_GPL_3_0, "authors", authors, "documenters", documenters, "artists", artists, "translator-credits", _tmp3_, "website", "https://wiki.gnome.org/Apps/Nibbles/", NULL);
#line 6382 "gnome-nibbles.c"
}


gint nibbles_main (gchar** args, int args_length1) {
	gint result = 0;
	Nibbles* _tmp0_ = NULL;
	Nibbles* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 1065 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	setlocale (LC_ALL, "");
#line 1066 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 1067 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 1068 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	textdomain (GETTEXT_PACKAGE);
#line 1070 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = nibbles_new ();
#line 1070 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = _tmp0_;
#line 1070 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = args;
#line 1070 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2__length1 = args_length1;
#line 1070 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = g_application_run ((GApplication*) _tmp1_, _tmp2__length1, _tmp2_);
#line 1070 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = _tmp3_;
#line 1070 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp1_);
#line 1070 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	result = _tmp4_;
#line 1070 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return result;
#line 6420 "gnome-nibbles.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 1063 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return nibbles_main (argv, argc);
#line 6430 "gnome-nibbles.c"
}


static void nibbles_class_init (NibblesClass * klass) {
#line 19 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	nibbles_parent_class = g_type_class_peek_parent (klass);
#line 19 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_type_class_add_private (klass, sizeof (NibblesPrivate));
#line 19 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	((GApplicationClass *) klass)->handle_local_options = nibbles_real_handle_local_options;
#line 19 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	((GApplicationClass *) klass)->startup = nibbles_real_startup;
#line 19 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	((GApplicationClass *) klass)->activate = nibbles_real_activate;
#line 19 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	((GApplicationClass *) klass)->shutdown = nibbles_real_shutdown;
#line 19 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	G_OBJECT_CLASS (klass)->finalize = nibbles_finalize;
#line 6449 "gnome-nibbles.c"
}


static void nibbles_instance_init (Nibbles * self) {
#line 19 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv = NIBBLES_GET_PRIVATE (self);
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->preferences_dialog = NULL;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->game = NULL;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->countdown_id = (guint) 0;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->seconds = 0;
#line 6464 "gnome-nibbles.c"
}


static void nibbles_finalize (GObject* obj) {
	Nibbles * self;
#line 19 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES, Nibbles);
#line 22 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->settings);
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->worm_settings);
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->window);
#line 32 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 33 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->overlay);
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->new_game_button);
#line 38 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->pause_button);
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->number_of_players_buttons);
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->number_of_ai_buttons);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->next_button);
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->start_button);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->grids_box);
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_pixbuf);
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_key_pixbuf);
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->statusbar_stack);
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->countdown);
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scoreboard);
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scoreboard_life);
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 60 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->view);
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->game_box);
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->frame);
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->game);
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scores_context);
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scorecats);
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->new_game_action);
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->pause_action);
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->back_action);
#line 19 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	G_OBJECT_CLASS (nibbles_parent_class)->finalize (obj);
#line 6532 "gnome-nibbles.c"
}


GType nibbles_get_type (void) {
	static volatile gsize nibbles_type_id__volatile = 0;
	if (g_once_init_enter (&nibbles_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NibblesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Nibbles), 0, (GInstanceInitFunc) nibbles_instance_init, NULL };
		GType nibbles_type_id;
		nibbles_type_id = g_type_register_static (gtk_application_get_type (), "Nibbles", &g_define_type_info, 0);
		g_once_init_leave (&nibbles_type_id__volatile, nibbles_type_id);
	}
	return nibbles_type_id__volatile;
}


Scoreboard* scoreboard_construct (GType object_type) {
	Scoreboard * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
#line 1079 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = (Scoreboard*) g_object_new (object_type, NULL);
#line 1081 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = gee_hash_map_new (TYPE_PLAYER_SCORE_BOX, (GBoxedCopyFunc) g_object_ref, g_object_unref, TYPE_WORM, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 1081 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->boxes);
#line 1081 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->boxes = _tmp0_;
#line 1079 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return self;
#line 6561 "gnome-nibbles.c"
}


Scoreboard* scoreboard_new (void) {
#line 1079 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return scoreboard_construct (TYPE_SCOREBOARD);
#line 6568 "gnome-nibbles.c"
}


void scoreboard_register (Scoreboard* self, Worm* worm, const gchar* color_name, GdkPixbuf* life_pixbuf) {
	PangoColor color = {0};
	const gchar* _tmp0_ = NULL;
	PlayerScoreBox* box = NULL;
	const gchar* _tmp1_ = NULL;
	Worm* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	PangoColor _tmp7_ = {0};
	Worm* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	Worm* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GdkPixbuf* _tmp14_ = NULL;
	PlayerScoreBox* _tmp15_ = NULL;
	PlayerScoreBox* _tmp16_ = NULL;
	GeeHashMap* _tmp17_ = NULL;
	Worm* _tmp18_ = NULL;
#line 1084 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 1084 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (worm != NULL);
#line 1084 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (color_name != NULL);
#line 1084 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (life_pixbuf != NULL);
#line 1086 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	memset (&color, 0, sizeof (PangoColor));
#line 1087 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = color_name;
#line 1087 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	pango_color_parse (&color, _tmp0_);
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = _ ("Player %d");
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = worm;
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = worm_get_id (_tmp2_);
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = _tmp3_;
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = g_strdup_printf (_tmp1_, _tmp4_ + 1);
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = _tmp5_;
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp7_ = color;
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp8_ = worm;
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp9_ = worm_get_score (_tmp8_);
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp10_ = _tmp9_;
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp11_ = worm;
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp12_ = worm_get_lives (_tmp11_);
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp13_ = _tmp12_;
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp14_ = life_pixbuf;
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp15_ = player_score_box_new (_tmp6_, &_tmp7_, _tmp10_, _tmp13_, _tmp14_);
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_object_ref_sink (_tmp15_);
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp16_ = _tmp15_;
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp6_);
#line 1092 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	box = _tmp16_;
#line 1093 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp17_ = self->priv->boxes;
#line 1093 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp18_ = worm;
#line 1093 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, box, _tmp18_);
#line 1094 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
#line 1084 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (box);
#line 6656 "gnome-nibbles.c"
}


void scoreboard_update (Scoreboard* self) {
#line 1097 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 6663 "gnome-nibbles.c"
	{
		GeeIterator* _entry_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp0_ = self->priv->boxes;
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp1_ = gee_abstract_map_get_entries ((GeeMap*) _tmp0_);
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp2_ = _tmp1_;
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp3_ = _tmp2_;
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp5_ = _tmp4_;
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_tmp3_);
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_entry_it = _tmp5_;
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		while (TRUE) {
#line 6690 "gnome-nibbles.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			PlayerScoreBox* box = NULL;
			GeeMapEntry* _tmp10_ = NULL;
			gconstpointer _tmp11_ = NULL;
			PlayerScoreBox* _tmp12_ = NULL;
			PlayerScoreBox* _tmp13_ = NULL;
			Worm* worm = NULL;
			GeeMapEntry* _tmp14_ = NULL;
			gconstpointer _tmp15_ = NULL;
			Worm* _tmp16_ = NULL;
			Worm* _tmp17_ = NULL;
			PlayerScoreBox* _tmp18_ = NULL;
			Worm* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			Worm* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp6_ = _entry_it;
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			if (!_tmp7_) {
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 6721 "gnome-nibbles.c"
			}
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp8_ = _entry_it;
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			entry = (GeeMapEntry*) _tmp9_;
#line 1101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp10_ = entry;
#line 1101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp11_ = gee_map_entry_get_key (_tmp10_);
#line 1101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp12_ = _tmp11_;
#line 1101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp13_ = _g_object_ref0 ((PlayerScoreBox*) _tmp12_);
#line 1101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			box = _tmp13_;
#line 1102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp14_ = entry;
#line 1102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp15_ = gee_map_entry_get_value (_tmp14_);
#line 1102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp16_ = _tmp15_;
#line 1102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp17_ = _g_object_ref0 ((Worm*) _tmp16_);
#line 1102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			worm = _tmp17_;
#line 1104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp18_ = box;
#line 1104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp19_ = worm;
#line 1104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp20_ = worm_get_score (_tmp19_);
#line 1104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp21_ = _tmp20_;
#line 1104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp22_ = worm;
#line 1104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp23_ = worm_get_lives (_tmp22_);
#line 1104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp24_ = _tmp23_;
#line 1104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			player_score_box_update (_tmp18_, _tmp21_, _tmp24_);
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_object_unref0 (worm);
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_object_unref0 (box);
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_object_unref0 (entry);
#line 6771 "gnome-nibbles.c"
		}
#line 1099 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_entry_it);
#line 6775 "gnome-nibbles.c"
	}
}


void scoreboard_clear (Scoreboard* self) {
	GeeHashMap* _tmp15_ = NULL;
#line 1108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 6784 "gnome-nibbles.c"
	{
		GeeIterator* _entry_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp0_ = self->priv->boxes;
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp1_ = gee_abstract_map_get_entries ((GeeMap*) _tmp0_);
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp2_ = _tmp1_;
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp3_ = _tmp2_;
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp5_ = _tmp4_;
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_tmp3_);
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_entry_it = _tmp5_;
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		while (TRUE) {
#line 6811 "gnome-nibbles.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			PlayerScoreBox* box = NULL;
			GeeMapEntry* _tmp10_ = NULL;
			gconstpointer _tmp11_ = NULL;
			PlayerScoreBox* _tmp12_ = NULL;
			PlayerScoreBox* _tmp13_ = NULL;
			PlayerScoreBox* _tmp14_ = NULL;
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp6_ = _entry_it;
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			if (!_tmp7_) {
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				break;
#line 6831 "gnome-nibbles.c"
			}
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp8_ = _entry_it;
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			entry = (GeeMapEntry*) _tmp9_;
#line 1112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp10_ = entry;
#line 1112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp11_ = gee_map_entry_get_key (_tmp10_);
#line 1112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp12_ = _tmp11_;
#line 1112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp13_ = _g_object_ref0 ((PlayerScoreBox*) _tmp12_);
#line 1112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			box = _tmp13_;
#line 1113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp14_ = box;
#line 1113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			gtk_widget_destroy ((GtkWidget*) _tmp14_);
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_object_unref0 (box);
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_g_object_unref0 (entry);
#line 6857 "gnome-nibbles.c"
		}
#line 1110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_entry_it);
#line 6861 "gnome-nibbles.c"
	}
#line 1115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp15_ = self->priv->boxes;
#line 1115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp15_);
#line 6867 "gnome-nibbles.c"
}


static void scoreboard_class_init (ScoreboardClass * klass) {
	gint Scoreboard_private_offset;
#line 1075 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	scoreboard_parent_class = g_type_class_peek_parent (klass);
#line 1075 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_type_class_add_private (klass, sizeof (ScoreboardPrivate));
#line 1075 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	G_OBJECT_CLASS (klass)->finalize = scoreboard_finalize;
#line 1075 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	Scoreboard_private_offset = g_type_class_get_instance_private_offset (klass);
#line 1075 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/scoreboard.ui");
#line 6883 "gnome-nibbles.c"
}


static void scoreboard_instance_init (Scoreboard * self) {
#line 1075 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv = SCOREBOARD_GET_PRIVATE (self);
#line 1075 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 6892 "gnome-nibbles.c"
}


static void scoreboard_finalize (GObject* obj) {
	Scoreboard * self;
#line 1075 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCOREBOARD, Scoreboard);
#line 1077 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->boxes);
#line 1075 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	G_OBJECT_CLASS (scoreboard_parent_class)->finalize (obj);
#line 6904 "gnome-nibbles.c"
}


GType scoreboard_get_type (void) {
	static volatile gsize scoreboard_type_id__volatile = 0;
	if (g_once_init_enter (&scoreboard_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ScoreboardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scoreboard_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Scoreboard), 0, (GInstanceInitFunc) scoreboard_instance_init, NULL };
		GType scoreboard_type_id;
		scoreboard_type_id = g_type_register_static (gtk_box_get_type (), "Scoreboard", &g_define_type_info, 0);
		g_once_init_leave (&scoreboard_type_id__volatile, scoreboard_type_id);
	}
	return scoreboard_type_id__volatile;
}


PlayerScoreBox* player_score_box_construct (GType object_type, const gchar* name, PangoColor* color, gint score, gint lives_left, GdkPixbuf* life_pixbuf) {
	PlayerScoreBox * self = NULL;
	GtkLabel* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GeeLinkedList* _tmp16_ = NULL;
#line 1131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 1131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (color != NULL, NULL);
#line 1131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (life_pixbuf != NULL, NULL);
#line 1131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = (PlayerScoreBox*) g_object_new (object_type, NULL);
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->name_label;
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = pango_color_to_string (color);
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = g_strconcat ("<span color=\"", _tmp2_, NULL);
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = _tmp3_;
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = g_strconcat (_tmp4_, "\">", NULL);
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = _tmp5_;
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp7_ = name;
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp8_ = g_strconcat (_tmp6_, _tmp7_, NULL);
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp9_ = _tmp8_;
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp10_ = g_strconcat (_tmp9_, "</span>", NULL);
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp11_ = _tmp10_;
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_label_set_markup (_tmp0_, _tmp11_);
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp11_);
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp9_);
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp6_);
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp4_);
#line 1133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp2_);
#line 1134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp12_ = self->priv->score_label;
#line 1134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp13_ = score;
#line 1134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp14_ = g_strdup_printf ("%i", _tmp13_);
#line 1134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp15_ = _tmp14_;
#line 1134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_label_set_label (_tmp12_, _tmp15_);
#line 1134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp15_);
#line 1136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp16_ = gee_linked_list_new (gtk_image_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 1136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->life_images);
#line 1136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv->life_images = _tmp16_;
#line 7001 "gnome-nibbles.c"
	{
		gint i = 0;
#line 1138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		i = 0;
#line 7006 "gnome-nibbles.c"
		{
			gboolean _tmp17_ = FALSE;
#line 1138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp17_ = TRUE;
#line 1138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			while (TRUE) {
#line 7013 "gnome-nibbles.c"
				gint _tmp19_ = 0;
				GtkImage* life = NULL;
				GdkPixbuf* _tmp20_ = NULL;
				GtkImage* _tmp21_ = NULL;
				GtkImage* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				GeeLinkedList* _tmp25_ = NULL;
				GtkImage* _tmp26_ = NULL;
				GtkGrid* _tmp27_ = NULL;
				GtkImage* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
#line 1138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!_tmp17_) {
#line 7028 "gnome-nibbles.c"
					gint _tmp18_ = 0;
#line 1138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_tmp18_ = i;
#line 1138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					i = _tmp18_ + 1;
#line 7034 "gnome-nibbles.c"
				}
#line 1138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp17_ = FALSE;
#line 1138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp19_ = i;
#line 1138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!(_tmp19_ < WORM_MAX_LIVES)) {
#line 1138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					break;
#line 7044 "gnome-nibbles.c"
				}
#line 1140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp20_ = life_pixbuf;
#line 1140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp21_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp20_);
#line 1140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				g_object_ref_sink (_tmp21_);
#line 1140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				life = _tmp21_;
#line 1141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp22_ = life;
#line 1141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				gtk_widget_show ((GtkWidget*) _tmp22_);
#line 1143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp23_ = i;
#line 1143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (_tmp23_ >= WORM_STARTING_LIVES) {
#line 7062 "gnome-nibbles.c"
					GtkImage* _tmp24_ = NULL;
#line 1144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_tmp24_ = life;
#line 1144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					gtk_widget_set_opacity ((GtkWidget*) _tmp24_, (gdouble) 0);
#line 7068 "gnome-nibbles.c"
				}
#line 1146 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp25_ = self->priv->life_images;
#line 1146 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp26_ = life;
#line 1146 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp26_);
#line 1147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp27_ = self->priv->lives_grid;
#line 1147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp28_ = life;
#line 1147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp29_ = i;
#line 1147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp30_ = i;
#line 1147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				gtk_grid_attach (_tmp27_, (GtkWidget*) _tmp28_, _tmp29_ % 6, _tmp30_ / 6, 1, 1);
#line 1138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_object_unref0 (life);
#line 7088 "gnome-nibbles.c"
			}
		}
	}
#line 1131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return self;
#line 7094 "gnome-nibbles.c"
}


PlayerScoreBox* player_score_box_new (const gchar* name, PangoColor* color, gint score, gint lives_left, GdkPixbuf* life_pixbuf) {
#line 1131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return player_score_box_construct (TYPE_PLAYER_SCORE_BOX, name, color, score, lives_left, life_pixbuf);
#line 7101 "gnome-nibbles.c"
}


void player_score_box_update (PlayerScoreBox* self, gint score, gint lives_left) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 1151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 1153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = score;
#line 1153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	player_score_box_update_score (self, _tmp0_);
#line 1154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = lives_left;
#line 1154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	player_score_box_update_lives (self, _tmp1_);
#line 7118 "gnome-nibbles.c"
}


void player_score_box_update_score (PlayerScoreBox* self, gint score) {
	GtkLabel* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 1159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = self->priv->score_label;
#line 1159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = score;
#line 1159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = g_strdup_printf ("%i", _tmp1_);
#line 1159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = _tmp2_;
#line 1159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_label_set_label (_tmp0_, _tmp3_);
#line 1159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp3_);
#line 7141 "gnome-nibbles.c"
}


void player_score_box_update_lives (PlayerScoreBox* self, gint lives_left) {
#line 1162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 7148 "gnome-nibbles.c"
	{
		gint i = 0;
		GeeLinkedList* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
#line 1165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp0_ = self->priv->life_images;
#line 1165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
#line 1165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp2_ = _tmp1_;
#line 1165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		i = _tmp2_ - 1;
#line 7162 "gnome-nibbles.c"
		{
			gboolean _tmp3_ = FALSE;
#line 1165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp3_ = TRUE;
#line 1165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			while (TRUE) {
#line 7169 "gnome-nibbles.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				GeeLinkedList* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gpointer _tmp9_ = NULL;
				GtkImage* _tmp10_ = NULL;
#line 1165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!_tmp3_) {
#line 7178 "gnome-nibbles.c"
					gint _tmp4_ = 0;
#line 1165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_tmp4_ = i;
#line 1165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					i = _tmp4_ - 1;
#line 7184 "gnome-nibbles.c"
				}
#line 1165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp3_ = FALSE;
#line 1165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp5_ = i;
#line 1165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp6_ = lives_left;
#line 1165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!(_tmp5_ >= _tmp6_)) {
#line 1165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					break;
#line 7196 "gnome-nibbles.c"
				}
#line 1166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp7_ = self->priv->life_images;
#line 1166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp8_ = i;
#line 1166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp8_);
#line 1166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp10_ = (GtkImage*) _tmp9_;
#line 1166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				gtk_widget_set_opacity ((GtkWidget*) _tmp10_, (gdouble) 0);
#line 1166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_object_unref0 (_tmp10_);
#line 7210 "gnome-nibbles.c"
			}
		}
	}
	{
		gint i = 0;
#line 1169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		i = 0;
#line 7218 "gnome-nibbles.c"
		{
			gboolean _tmp11_ = FALSE;
#line 1169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			_tmp11_ = TRUE;
#line 1169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
			while (TRUE) {
#line 7225 "gnome-nibbles.c"
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				GeeLinkedList* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gpointer _tmp17_ = NULL;
				GtkImage* _tmp18_ = NULL;
#line 1169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!_tmp11_) {
#line 7234 "gnome-nibbles.c"
					gint _tmp12_ = 0;
#line 1169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					_tmp12_ = i;
#line 1169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					i = _tmp12_ + 1;
#line 7240 "gnome-nibbles.c"
				}
#line 1169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp11_ = FALSE;
#line 1169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp13_ = i;
#line 1169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp14_ = lives_left;
#line 1169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				if (!(_tmp13_ < _tmp14_)) {
#line 1169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
					break;
#line 7252 "gnome-nibbles.c"
				}
#line 1170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp15_ = self->priv->life_images;
#line 1170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp16_ = i;
#line 1170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
#line 1170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_tmp18_ = (GtkImage*) _tmp17_;
#line 1170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				gtk_widget_set_opacity ((GtkWidget*) _tmp18_, (gdouble) 1);
#line 1170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
				_g_object_unref0 (_tmp18_);
#line 7266 "gnome-nibbles.c"
			}
		}
	}
}


static void player_score_box_class_init (PlayerScoreBoxClass * klass) {
	gint PlayerScoreBox_private_offset;
#line 1120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	player_score_box_parent_class = g_type_class_peek_parent (klass);
#line 1120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_type_class_add_private (klass, sizeof (PlayerScoreBoxPrivate));
#line 1120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	G_OBJECT_CLASS (klass)->finalize = player_score_box_finalize;
#line 1120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	PlayerScoreBox_private_offset = g_type_class_get_instance_private_offset (klass);
#line 1120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/player-score-box.ui");
#line 1120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, name_label));
#line 1120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "score_label", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, score_label));
#line 1120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "lives_grid", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, lives_grid));
#line 7291 "gnome-nibbles.c"
}


static void player_score_box_instance_init (PlayerScoreBox * self) {
#line 1120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv = PLAYER_SCORE_BOX_GET_PRIVATE (self);
#line 1120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 7300 "gnome-nibbles.c"
}


static void player_score_box_finalize (GObject* obj) {
	PlayerScoreBox * self;
#line 1120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PLAYER_SCORE_BOX, PlayerScoreBox);
#line 1123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->name_label);
#line 1125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->score_label);
#line 1127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->lives_grid);
#line 1129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->life_images);
#line 1120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	G_OBJECT_CLASS (player_score_box_parent_class)->finalize (obj);
#line 7318 "gnome-nibbles.c"
}


GType player_score_box_get_type (void) {
	static volatile gsize player_score_box_type_id__volatile = 0;
	if (g_once_init_enter (&player_score_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PlayerScoreBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) player_score_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlayerScoreBox), 0, (GInstanceInitFunc) player_score_box_instance_init, NULL };
		GType player_score_box_type_id;
		player_score_box_type_id = g_type_register_static (gtk_box_get_type (), "PlayerScoreBox", &g_define_type_info, 0);
		g_once_init_leave (&player_score_box_type_id__volatile, player_score_box_type_id);
	}
	return player_score_box_type_id__volatile;
}


ControlsGrid* controls_grid_construct (GType object_type, gint worm_id, WormProperties* worm_props, GdkPixbuf* arrow, GdkPixbuf* arrow_key) {
	ControlsGrid * self = NULL;
	PangoColor color = {0};
	WormProperties _tmp0_ = {0};
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* player_id = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GtkImage* _tmp15_ = NULL;
	GdkPixbuf* _tmp16_ = NULL;
	GdkPixbuf* _tmp17_ = NULL;
	GdkPixbuf* _tmp18_ = NULL;
	GtkImage* _tmp19_ = NULL;
	GdkPixbuf* _tmp20_ = NULL;
	GdkPixbuf* _tmp21_ = NULL;
	GdkPixbuf* _tmp22_ = NULL;
	GtkImage* _tmp23_ = NULL;
	GdkPixbuf* _tmp24_ = NULL;
	GdkPixbuf* _tmp25_ = NULL;
	GdkPixbuf* _tmp26_ = NULL;
	GtkImage* _tmp27_ = NULL;
	GdkPixbuf* _tmp28_ = NULL;
	GdkPixbuf* _tmp29_ = NULL;
	GdkPixbuf* _tmp30_ = NULL;
	gchar* upper_key = NULL;
	WormProperties _tmp31_ = {0};
	guint _tmp32_ = 0U;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	WormProperties _tmp48_ = {0};
	guint _tmp49_ = 0U;
	const gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	WormProperties _tmp65_ = {0};
	guint _tmp66_ = 0U;
	const gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
	const gchar* _tmp69_ = NULL;
	WormProperties _tmp82_ = {0};
	guint _tmp83_ = 0U;
	const gchar* _tmp84_ = NULL;
	gchar* _tmp85_ = NULL;
	const gchar* _tmp86_ = NULL;
#line 1204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (worm_props != NULL, NULL);
#line 1204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (arrow != NULL, NULL);
#line 1204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_return_val_if_fail (arrow_key != NULL, NULL);
#line 1204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = (ControlsGrid*) g_object_new (object_type, NULL);
#line 1206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	memset (&color, 0, sizeof (PangoColor));
#line 1207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp0_ = *worm_props;
#line 1207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp1_ = _tmp0_.color;
#line 1207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp2_ = nibbles_view_colorval_name (_tmp1_);
#line 1207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp3_ = _tmp2_;
#line 1207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	pango_color_parse (&color, _tmp3_);
#line 1207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp3_);
#line 1210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp4_ = _ ("Player %d");
#line 1210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp5_ = worm_id;
#line 1210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp6_ = g_strdup_printf (_tmp4_, _tmp5_ + 1);
#line 1210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	player_id = _tmp6_;
#line 1211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp7_ = self->priv->name_label;
#line 1211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp8_ = pango_color_to_string (&color);
#line 1211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp9_ = _tmp8_;
#line 1211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp10_ = string_to_string (_tmp9_);
#line 1211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp11_ = player_id;
#line 1211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp12_ = string_to_string (_tmp11_);
#line 1211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp13_ = g_strconcat ("<b><span font-family=\"Sans\" color=\"", _tmp10_, "\">", _tmp12_, "</span></b>", NULL);
#line 1211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp14_ = _tmp13_;
#line 1211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_label_set_markup (_tmp7_, _tmp14_);
#line 1211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp14_);
#line 1211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (_tmp9_);
#line 1213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp15_ = self->priv->arrow_up;
#line 1213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp16_ = arrow;
#line 1213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp17_ = gdk_pixbuf_rotate_simple (_tmp16_, GDK_PIXBUF_ROTATE_NONE);
#line 1213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp18_ = _tmp17_;
#line 1213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_image_set_from_pixbuf (_tmp15_, _tmp18_);
#line 1213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp18_);
#line 1214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp19_ = self->priv->arrow_down;
#line 1214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp20_ = arrow;
#line 1214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp21_ = gdk_pixbuf_rotate_simple (_tmp20_, GDK_PIXBUF_ROTATE_UPSIDEDOWN);
#line 1214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp22_ = _tmp21_;
#line 1214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_image_set_from_pixbuf (_tmp19_, _tmp22_);
#line 1214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp22_);
#line 1215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp23_ = self->priv->arrow_left;
#line 1215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp24_ = arrow;
#line 1215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp25_ = gdk_pixbuf_rotate_simple (_tmp24_, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
#line 1215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp26_ = _tmp25_;
#line 1215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_image_set_from_pixbuf (_tmp23_, _tmp26_);
#line 1215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp26_);
#line 1216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp27_ = self->priv->arrow_right;
#line 1216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp28_ = arrow;
#line 1216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp29_ = gdk_pixbuf_rotate_simple (_tmp28_, GDK_PIXBUF_ROTATE_CLOCKWISE);
#line 1216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp30_ = _tmp29_;
#line 1216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_image_set_from_pixbuf (_tmp27_, _tmp30_);
#line 1216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (_tmp30_);
#line 1219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp31_ = *worm_props;
#line 1219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp32_ = _tmp31_.up;
#line 1219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp33_ = gdk_keyval_name (_tmp32_);
#line 1219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp34_ = g_utf8_strup (_tmp33_, (gssize) -1);
#line 1219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (upper_key);
#line 1219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	upper_key = _tmp34_;
#line 1220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp35_ = upper_key;
#line 1220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (g_strcmp0 (_tmp35_, "UP") == 0) {
#line 7506 "gnome-nibbles.c"
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp36_ = NULL;
		GdkPixbuf* _tmp37_ = NULL;
		GtkOverlay* _tmp38_ = NULL;
		GdkPixbuf* _tmp39_ = NULL;
		GtkImage* _tmp40_ = NULL;
		GtkImage* _tmp41_ = NULL;
		GtkOverlay* _tmp42_ = NULL;
#line 1222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp36_ = arrow_key;
#line 1222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp37_ = gdk_pixbuf_rotate_simple (_tmp36_, GDK_PIXBUF_ROTATE_NONE);
#line 1222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		rotated_pixbuf = _tmp37_;
#line 1223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp38_ = self->priv->move_up;
#line 1223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp39_ = rotated_pixbuf;
#line 1223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp40_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp39_);
#line 1223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_object_ref_sink (_tmp40_);
#line 1223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp41_ = _tmp40_;
#line 1223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp38_, (GtkWidget*) _tmp41_);
#line 1223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_tmp41_);
#line 1224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp42_ = self->priv->move_up;
#line 1224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp42_);
#line 1220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (rotated_pixbuf);
#line 7541 "gnome-nibbles.c"
	} else {
		GtkLabel* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
#line 1227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp43_ = self->priv->move_up_label;
#line 1227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp44_ = upper_key;
#line 1227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp45_ = string_to_string (_tmp44_);
#line 1227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp46_ = g_strconcat ("<b>", _tmp45_, "</b>", NULL);
#line 1227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp47_ = _tmp46_;
#line 1227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_label_set_markup (_tmp43_, _tmp47_);
#line 1227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_free0 (_tmp47_);
#line 7562 "gnome-nibbles.c"
	}
#line 1229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp48_ = *worm_props;
#line 1229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp49_ = _tmp48_.down;
#line 1229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp50_ = gdk_keyval_name (_tmp49_);
#line 1229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp51_ = g_utf8_strup (_tmp50_, (gssize) -1);
#line 1229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (upper_key);
#line 1229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	upper_key = _tmp51_;
#line 1230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp52_ = upper_key;
#line 1230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (g_strcmp0 (_tmp52_, "DOWN") == 0) {
#line 7580 "gnome-nibbles.c"
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp53_ = NULL;
		GdkPixbuf* _tmp54_ = NULL;
		GtkOverlay* _tmp55_ = NULL;
		GdkPixbuf* _tmp56_ = NULL;
		GtkImage* _tmp57_ = NULL;
		GtkImage* _tmp58_ = NULL;
		GtkOverlay* _tmp59_ = NULL;
#line 1232 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp53_ = arrow_key;
#line 1232 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp54_ = gdk_pixbuf_rotate_simple (_tmp53_, GDK_PIXBUF_ROTATE_UPSIDEDOWN);
#line 1232 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		rotated_pixbuf = _tmp54_;
#line 1233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp55_ = self->priv->move_down;
#line 1233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp56_ = rotated_pixbuf;
#line 1233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp57_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp56_);
#line 1233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_object_ref_sink (_tmp57_);
#line 1233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp58_ = _tmp57_;
#line 1233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp55_, (GtkWidget*) _tmp58_);
#line 1233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_tmp58_);
#line 1234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp59_ = self->priv->move_down;
#line 1234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp59_);
#line 1230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (rotated_pixbuf);
#line 7615 "gnome-nibbles.c"
	} else {
		GtkLabel* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
#line 1237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp60_ = self->priv->move_down_label;
#line 1237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp61_ = upper_key;
#line 1237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp62_ = string_to_string (_tmp61_);
#line 1237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp63_ = g_strconcat ("<b>", _tmp62_, "</b>", NULL);
#line 1237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp64_ = _tmp63_;
#line 1237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_label_set_markup (_tmp60_, _tmp64_);
#line 1237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_free0 (_tmp64_);
#line 7636 "gnome-nibbles.c"
	}
#line 1239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp65_ = *worm_props;
#line 1239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp66_ = _tmp65_.left;
#line 1239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp67_ = gdk_keyval_name (_tmp66_);
#line 1239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp68_ = g_utf8_strup (_tmp67_, (gssize) -1);
#line 1239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (upper_key);
#line 1239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	upper_key = _tmp68_;
#line 1240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp69_ = upper_key;
#line 1240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (g_strcmp0 (_tmp69_, "LEFT") == 0) {
#line 7654 "gnome-nibbles.c"
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp70_ = NULL;
		GdkPixbuf* _tmp71_ = NULL;
		GtkOverlay* _tmp72_ = NULL;
		GdkPixbuf* _tmp73_ = NULL;
		GtkImage* _tmp74_ = NULL;
		GtkImage* _tmp75_ = NULL;
		GtkOverlay* _tmp76_ = NULL;
#line 1242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp70_ = arrow_key;
#line 1242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp71_ = gdk_pixbuf_rotate_simple (_tmp70_, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
#line 1242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		rotated_pixbuf = _tmp71_;
#line 1243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp72_ = self->priv->move_left;
#line 1243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp73_ = rotated_pixbuf;
#line 1243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp74_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp73_);
#line 1243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_object_ref_sink (_tmp74_);
#line 1243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp75_ = _tmp74_;
#line 1243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp72_, (GtkWidget*) _tmp75_);
#line 1243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_tmp75_);
#line 1244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp76_ = self->priv->move_left;
#line 1244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp76_);
#line 1240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (rotated_pixbuf);
#line 7689 "gnome-nibbles.c"
	} else {
		GtkLabel* _tmp77_ = NULL;
		const gchar* _tmp78_ = NULL;
		const gchar* _tmp79_ = NULL;
		gchar* _tmp80_ = NULL;
		gchar* _tmp81_ = NULL;
#line 1247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp77_ = self->priv->move_left_label;
#line 1247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp78_ = upper_key;
#line 1247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp79_ = string_to_string (_tmp78_);
#line 1247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp80_ = g_strconcat ("<b>", _tmp79_, "</b>", NULL);
#line 1247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp81_ = _tmp80_;
#line 1247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_label_set_markup (_tmp77_, _tmp81_);
#line 1247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_free0 (_tmp81_);
#line 7710 "gnome-nibbles.c"
	}
#line 1249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp82_ = *worm_props;
#line 1249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp83_ = _tmp82_.right;
#line 1249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp84_ = gdk_keyval_name (_tmp83_);
#line 1249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp85_ = g_utf8_strup (_tmp84_, (gssize) -1);
#line 1249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (upper_key);
#line 1249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	upper_key = _tmp85_;
#line 1250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_tmp86_ = upper_key;
#line 1250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	if (g_strcmp0 (_tmp86_, "RIGHT") == 0) {
#line 7728 "gnome-nibbles.c"
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp87_ = NULL;
		GdkPixbuf* _tmp88_ = NULL;
		GtkOverlay* _tmp89_ = NULL;
		GdkPixbuf* _tmp90_ = NULL;
		GtkImage* _tmp91_ = NULL;
		GtkImage* _tmp92_ = NULL;
		GtkOverlay* _tmp93_ = NULL;
#line 1252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp87_ = arrow_key;
#line 1252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp88_ = gdk_pixbuf_rotate_simple (_tmp87_, GDK_PIXBUF_ROTATE_CLOCKWISE);
#line 1252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		rotated_pixbuf = _tmp88_;
#line 1253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp89_ = self->priv->move_right;
#line 1253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp90_ = rotated_pixbuf;
#line 1253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp91_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp90_);
#line 1253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		g_object_ref_sink (_tmp91_);
#line 1253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp92_ = _tmp91_;
#line 1253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp89_, (GtkWidget*) _tmp92_);
#line 1253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (_tmp92_);
#line 1254 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp93_ = self->priv->move_right;
#line 1254 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp93_);
#line 1250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_object_unref0 (rotated_pixbuf);
#line 7763 "gnome-nibbles.c"
	} else {
		GtkLabel* _tmp94_ = NULL;
		const gchar* _tmp95_ = NULL;
		const gchar* _tmp96_ = NULL;
		gchar* _tmp97_ = NULL;
		gchar* _tmp98_ = NULL;
#line 1257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp94_ = self->priv->move_right_label;
#line 1257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp95_ = upper_key;
#line 1257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp96_ = string_to_string (_tmp95_);
#line 1257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp97_ = g_strconcat ("<b>", _tmp96_, "</b>", NULL);
#line 1257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_tmp98_ = _tmp97_;
#line 1257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		gtk_label_set_markup (_tmp94_, _tmp98_);
#line 1257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
		_g_free0 (_tmp98_);
#line 7784 "gnome-nibbles.c"
	}
#line 1204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (upper_key);
#line 1204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_free0 (player_id);
#line 1204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return self;
#line 7792 "gnome-nibbles.c"
}


ControlsGrid* controls_grid_new (gint worm_id, WormProperties* worm_props, GdkPixbuf* arrow, GdkPixbuf* arrow_key) {
#line 1204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	return controls_grid_construct (TYPE_CONTROLS_GRID, worm_id, worm_props, arrow, arrow_key);
#line 7799 "gnome-nibbles.c"
}


static void controls_grid_class_init (ControlsGridClass * klass) {
	gint ControlsGrid_private_offset;
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	controls_grid_parent_class = g_type_class_peek_parent (klass);
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	g_type_class_add_private (klass, sizeof (ControlsGridPrivate));
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	G_OBJECT_CLASS (klass)->finalize = controls_grid_finalize;
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	ControlsGrid_private_offset = g_type_class_get_instance_private_offset (klass);
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/controls-grid.ui");
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, name_label));
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_up", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_up));
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_down", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_down));
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_left", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_left));
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_right", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_right));
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_up", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_up));
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_up_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_up_label));
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_down", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_down));
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_down_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_down_label));
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_left", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_left));
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_left_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_left_label));
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_right", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_right));
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_right_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_right_label));
#line 7841 "gnome-nibbles.c"
}


static void controls_grid_instance_init (ControlsGrid * self) {
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self->priv = CONTROLS_GRID_GET_PRIVATE (self);
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 7850 "gnome-nibbles.c"
}


static void controls_grid_finalize (GObject* obj) {
	ControlsGrid * self;
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONTROLS_GRID, ControlsGrid);
#line 1178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->name_label);
#line 1180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_up);
#line 1182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_down);
#line 1184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_left);
#line 1186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_right);
#line 1188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_up);
#line 1190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_up_label);
#line 1192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_down);
#line 1194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_down_label);
#line 1196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_left);
#line 1198 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_left_label);
#line 1200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_right);
#line 1202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_right_label);
#line 1175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/gnome-nibbles.vala"
	G_OBJECT_CLASS (controls_grid_parent_class)->finalize (obj);
#line 7886 "gnome-nibbles.c"
}


GType controls_grid_get_type (void) {
	static volatile gsize controls_grid_type_id__volatile = 0;
	if (g_once_init_enter (&controls_grid_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ControlsGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) controls_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ControlsGrid), 0, (GInstanceInitFunc) controls_grid_instance_init, NULL };
		GType controls_grid_type_id;
		controls_grid_type_id = g_type_register_static (gtk_grid_get_type (), "ControlsGrid", &g_define_type_info, 0);
		g_once_init_leave (&controls_grid_type_id__volatile, controls_grid_type_id);
	}
	return controls_grid_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



