/* game.c generated by valac 0.30.0, the Vala compiler
 * generated from game.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <math.h>


#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
typedef struct _TilePrivate TilePrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

struct _Tile {
	GObject parent_instance;
	TilePrivate * priv;
	gint grid_x;
	gint grid_y;
	gint color;
	gboolean visited;
};

struct _TileClass {
	GObjectClass parent_class;
};

struct _TilePrivate {
	gboolean _closed;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GamePrivate {
	Tile** tiles;
	gint tiles_length1;
	gint tiles_length2;
	gboolean is_started;
	gint _score;
	gint _color_num;
	gint _rows;
	gint _columns;
};


static gpointer tile_parent_class = NULL;
static gpointer game_parent_class = NULL;

GType tile_get_type (void) G_GNUC_CONST;
#define TILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TILE, TilePrivate))
enum  {
	TILE_DUMMY_PROPERTY,
	TILE_CLOSED
};
Tile* tile_new (gint x, gint y, gint c);
Tile* tile_construct (GType object_type, gint x, gint y, gint c);
void tile_update_position (Tile* self, gint new_x, gint new_y);
gboolean tile_get_closed (Tile* self);
void tile_set_closed (Tile* self, gboolean value);
static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void tile_finalize (GObject* obj);
static void _vala_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType game_get_type (void) G_GNUC_CONST;
#define GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME, GamePrivate))
enum  {
	GAME_DUMMY_PROPERTY,
	GAME_SCORE,
	GAME_COLOR_NUM,
	GAME_ROWS,
	GAME_COLUMNS
};
Game* game_new (gint rows, gint columns, gint color_num);
Game* game_construct (GType object_type, gint rows, gint columns, gint color_num);
static GList* _game_connected_tiles (Game* self, Tile* li);
gint game_get_rows (Game* self);
gint game_get_columns (Game* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GList* game_connected_tiles (Game* self, Tile* li);
Tile* game_get_tile (Game* self, gint x, gint y);
gboolean game_remove_connected_tiles (Game* self, Tile* tile);
void game_increment_score_from_tiles (Game* self, gint n_tiles);
gboolean game_has_completed (Game* self);
gboolean game_has_won (Game* self);
void game_increment_score (Game* self, gint increment);
void game_reset_visit (Game* self);
gint game_get_score (Game* self);
void game_set_score (Game* self, gint value);
gint game_get_color_num (Game* self);
void game_set_color_num (Game* self, gint value);
void game_set_rows (Game* self, gint value);
void game_set_columns (Game* self, gint value);
static void game_finalize (GObject* obj);
static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


Tile* tile_construct (GType object_type, gint x, gint y, gint c) {
	Tile * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = (Tile*) g_object_new (object_type, NULL);
	_tmp0_ = x;
	self->grid_x = _tmp0_;
	_tmp1_ = y;
	self->grid_y = _tmp1_;
	_tmp2_ = c;
	self->color = _tmp2_;
	return self;
}


Tile* tile_new (gint x, gint y, gint c) {
	return tile_construct (TYPE_TILE, x, y, c);
}


void tile_update_position (Tile* self, gint new_x, gint new_y) {
	gint old_x = 0;
	gint _tmp0_ = 0;
	gint old_y = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->grid_x;
	old_x = _tmp0_;
	_tmp1_ = self->grid_y;
	old_y = _tmp1_;
	_tmp3_ = new_x;
	_tmp4_ = old_x;
	if (_tmp3_ != _tmp4_) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp5_ = new_y;
		_tmp6_ = old_y;
		_tmp2_ = _tmp5_ != _tmp6_;
	}
	if (_tmp2_) {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp7_ = new_x;
		self->grid_x = _tmp7_;
		_tmp8_ = new_y;
		self->grid_y = _tmp8_;
		_tmp9_ = tile_get_closed (self);
		_tmp10_ = _tmp9_;
		if (!_tmp10_) {
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			_tmp11_ = old_x;
			_tmp12_ = old_y;
			_tmp13_ = new_x;
			_tmp14_ = new_y;
			g_signal_emit_by_name (self, "move", _tmp11_, _tmp12_, _tmp13_, _tmp14_);
		}
	}
}


gboolean tile_get_closed (Tile* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_closed;
	result = _tmp0_;
	return result;
}


void tile_set_closed (Tile* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_closed = _tmp0_;
	_tmp1_ = self->priv->_closed;
	if (_tmp1_) {
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		_tmp2_ = self->grid_x;
		_tmp3_ = self->grid_y;
		g_signal_emit_by_name (self, "close", _tmp2_, _tmp3_);
	}
	g_object_notify ((GObject *) self, "closed");
}


static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT_INT_INT) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void tile_class_init (TileClass * klass) {
	tile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TilePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tile_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tile_set_property;
	G_OBJECT_CLASS (klass)->finalize = tile_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TILE_CLOSED, g_param_spec_boolean ("closed", "closed", "closed", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("move", TYPE_TILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_INT_INT, G_TYPE_NONE, 4, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
	g_signal_new ("close", TYPE_TILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
}


static void tile_instance_init (Tile * self) {
	self->priv = TILE_GET_PRIVATE (self);
	self->priv->_closed = FALSE;
	self->visited = FALSE;
}


static void tile_finalize (GObject* obj) {
	Tile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TILE, Tile);
	G_OBJECT_CLASS (tile_parent_class)->finalize (obj);
}


/**
 *  This is the model layer of a tile.
 */
GType tile_get_type (void) {
	static volatile gsize tile_type_id__volatile = 0;
	if (g_once_init_enter (&tile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Tile), 0, (GInstanceInitFunc) tile_instance_init, NULL };
		GType tile_type_id;
		tile_type_id = g_type_register_static (G_TYPE_OBJECT, "Tile", &g_define_type_info, 0);
		g_once_init_leave (&tile_type_id__volatile, tile_type_id);
	}
	return tile_type_id__volatile;
}


static void _vala_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Tile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TILE, Tile);
	switch (property_id) {
		case TILE_CLOSED:
		g_value_set_boolean (value, tile_get_closed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Tile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TILE, Tile);
	switch (property_id) {
		case TILE_CLOSED:
		tile_set_closed (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


Game* game_construct (GType object_type, gint rows, gint columns, gint color_num) {
	Game * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	Tile** _tmp5_ = NULL;
	self = (Game*) g_object_new (object_type, NULL);
	_tmp0_ = rows;
	self->priv->_rows = _tmp0_;
	_tmp1_ = columns;
	self->priv->_columns = _tmp1_;
	_tmp2_ = color_num;
	self->priv->_color_num = _tmp2_;
	_tmp3_ = rows;
	_tmp4_ = columns;
	_tmp5_ = g_new0 (Tile*, (_tmp3_ * _tmp4_) + 1);
	self->priv->tiles = (_vala_array_free (self->priv->tiles, self->priv->tiles_length1 * self->priv->tiles_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->tiles = _tmp5_;
	self->priv->tiles_length1 = _tmp3_;
	self->priv->tiles_length2 = _tmp4_;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				if (!_tmp6_) {
					gint _tmp7_ = 0;
					_tmp7_ = x;
					x = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = x;
				_tmp9_ = columns;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint c = 0;
							gdouble _tmp14_ = 0.0;
							gint _tmp15_ = 0;
							gdouble _tmp16_ = 0.0;
							Tile** _tmp17_ = NULL;
							gint _tmp17__length1 = 0;
							gint _tmp17__length2 = 0;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							Tile* _tmp23_ = NULL;
							Tile* _tmp24_ = NULL;
							if (!_tmp10_) {
								gint _tmp11_ = 0;
								_tmp11_ = y;
								y = _tmp11_ + 1;
							}
							_tmp10_ = FALSE;
							_tmp12_ = y;
							_tmp13_ = rows;
							if (!(_tmp12_ < _tmp13_)) {
								break;
							}
							_tmp14_ = g_random_double ();
							_tmp15_ = color_num;
							_tmp16_ = floor (_tmp14_ * _tmp15_);
							c = (gint) _tmp16_;
							_tmp17_ = self->priv->tiles;
							_tmp17__length1 = self->priv->tiles_length1;
							_tmp17__length2 = self->priv->tiles_length2;
							_tmp18_ = y;
							_tmp19_ = x;
							_tmp20_ = x;
							_tmp21_ = y;
							_tmp22_ = c;
							_tmp23_ = tile_new (_tmp20_, _tmp21_, _tmp22_);
							_g_object_unref0 (_tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_]);
							_tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_] = _tmp23_;
							_tmp24_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
						}
					}
				}
			}
		}
	}
	self->priv->is_started = FALSE;
	return self;
}


Game* game_new (gint rows, gint columns, gint color_num) {
	return game_construct (TYPE_GAME, rows, columns, color_num);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GList* _game_connected_tiles (Game* self, Tile* li) {
	GList* result = NULL;
	GList* cl = NULL;
	gboolean _tmp0_ = FALSE;
	Tile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gint x = 0;
	Tile* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint y = 0;
	Tile* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	Tile* _tmp10_ = NULL;
	Tile* _tmp11_ = NULL;
	Tile* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gint _tmp35_ = 0;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	gint _tmp54_ = 0;
	gint _tmp55_ = 0;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp73_ = FALSE;
	gint _tmp74_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	cl = NULL;
	_tmp1_ = li;
	_tmp2_ = _tmp1_->visited;
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		Tile* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = li;
		_tmp4_ = tile_get_closed (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	}
	if (_tmp0_) {
		result = cl;
		return result;
	}
	_tmp6_ = li;
	_tmp7_ = _tmp6_->grid_x;
	x = _tmp7_;
	_tmp8_ = li;
	_tmp9_ = _tmp8_->grid_y;
	y = _tmp9_;
	_tmp10_ = li;
	_tmp10_->visited = TRUE;
	_tmp11_ = li;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	cl = g_list_append (cl, _tmp12_);
	_tmp15_ = y;
	_tmp16_ = self->priv->_rows;
	if ((_tmp15_ + 1) < _tmp16_) {
		Tile** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		gint _tmp17__length2 = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		Tile* _tmp20_ = NULL;
		_tmp17_ = self->priv->tiles;
		_tmp17__length1 = self->priv->tiles_length1;
		_tmp17__length2 = self->priv->tiles_length2;
		_tmp18_ = y;
		_tmp19_ = x;
		_tmp20_ = _tmp17_[((_tmp18_ + 1) * _tmp17__length2) + _tmp19_];
		_tmp14_ = _tmp20_ != NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		Tile* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		Tile** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		gint _tmp23__length2 = 0;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		Tile* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		_tmp21_ = li;
		_tmp22_ = _tmp21_->color;
		_tmp23_ = self->priv->tiles;
		_tmp23__length1 = self->priv->tiles_length1;
		_tmp23__length2 = self->priv->tiles_length2;
		_tmp24_ = y;
		_tmp25_ = x;
		_tmp26_ = _tmp23_[((_tmp24_ + 1) * _tmp23__length2) + _tmp25_];
		_tmp27_ = _tmp26_->color;
		_tmp13_ = _tmp22_ == _tmp27_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		Tile** _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		gint _tmp28__length2 = 0;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		Tile* _tmp31_ = NULL;
		GList* _tmp32_ = NULL;
		_tmp28_ = self->priv->tiles;
		_tmp28__length1 = self->priv->tiles_length1;
		_tmp28__length2 = self->priv->tiles_length2;
		_tmp29_ = y;
		_tmp30_ = x;
		_tmp31_ = _tmp28_[((_tmp29_ + 1) * _tmp28__length2) + _tmp30_];
		_tmp32_ = _game_connected_tiles (self, _tmp31_);
		cl = g_list_concat (cl, _tmp32_);
	}
	_tmp35_ = y;
	if ((_tmp35_ - 1) >= 0) {
		Tile** _tmp36_ = NULL;
		gint _tmp36__length1 = 0;
		gint _tmp36__length2 = 0;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		Tile* _tmp39_ = NULL;
		_tmp36_ = self->priv->tiles;
		_tmp36__length1 = self->priv->tiles_length1;
		_tmp36__length2 = self->priv->tiles_length2;
		_tmp37_ = y;
		_tmp38_ = x;
		_tmp39_ = _tmp36_[((_tmp37_ - 1) * _tmp36__length2) + _tmp38_];
		_tmp34_ = _tmp39_ != NULL;
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		Tile* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		Tile** _tmp42_ = NULL;
		gint _tmp42__length1 = 0;
		gint _tmp42__length2 = 0;
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		Tile* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		_tmp40_ = li;
		_tmp41_ = _tmp40_->color;
		_tmp42_ = self->priv->tiles;
		_tmp42__length1 = self->priv->tiles_length1;
		_tmp42__length2 = self->priv->tiles_length2;
		_tmp43_ = y;
		_tmp44_ = x;
		_tmp45_ = _tmp42_[((_tmp43_ - 1) * _tmp42__length2) + _tmp44_];
		_tmp46_ = _tmp45_->color;
		_tmp33_ = _tmp41_ == _tmp46_;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		Tile** _tmp47_ = NULL;
		gint _tmp47__length1 = 0;
		gint _tmp47__length2 = 0;
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
		Tile* _tmp50_ = NULL;
		GList* _tmp51_ = NULL;
		_tmp47_ = self->priv->tiles;
		_tmp47__length1 = self->priv->tiles_length1;
		_tmp47__length2 = self->priv->tiles_length2;
		_tmp48_ = y;
		_tmp49_ = x;
		_tmp50_ = _tmp47_[((_tmp48_ - 1) * _tmp47__length2) + _tmp49_];
		_tmp51_ = _game_connected_tiles (self, _tmp50_);
		cl = g_list_concat (cl, _tmp51_);
	}
	_tmp54_ = x;
	_tmp55_ = self->priv->_columns;
	if ((_tmp54_ + 1) < _tmp55_) {
		Tile** _tmp56_ = NULL;
		gint _tmp56__length1 = 0;
		gint _tmp56__length2 = 0;
		gint _tmp57_ = 0;
		gint _tmp58_ = 0;
		Tile* _tmp59_ = NULL;
		_tmp56_ = self->priv->tiles;
		_tmp56__length1 = self->priv->tiles_length1;
		_tmp56__length2 = self->priv->tiles_length2;
		_tmp57_ = y;
		_tmp58_ = x;
		_tmp59_ = _tmp56_[(_tmp57_ * _tmp56__length2) + (_tmp58_ + 1)];
		_tmp53_ = _tmp59_ != NULL;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		Tile* _tmp60_ = NULL;
		gint _tmp61_ = 0;
		Tile** _tmp62_ = NULL;
		gint _tmp62__length1 = 0;
		gint _tmp62__length2 = 0;
		gint _tmp63_ = 0;
		gint _tmp64_ = 0;
		Tile* _tmp65_ = NULL;
		gint _tmp66_ = 0;
		_tmp60_ = li;
		_tmp61_ = _tmp60_->color;
		_tmp62_ = self->priv->tiles;
		_tmp62__length1 = self->priv->tiles_length1;
		_tmp62__length2 = self->priv->tiles_length2;
		_tmp63_ = y;
		_tmp64_ = x;
		_tmp65_ = _tmp62_[(_tmp63_ * _tmp62__length2) + (_tmp64_ + 1)];
		_tmp66_ = _tmp65_->color;
		_tmp52_ = _tmp61_ == _tmp66_;
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		Tile** _tmp67_ = NULL;
		gint _tmp67__length1 = 0;
		gint _tmp67__length2 = 0;
		gint _tmp68_ = 0;
		gint _tmp69_ = 0;
		Tile* _tmp70_ = NULL;
		GList* _tmp71_ = NULL;
		_tmp67_ = self->priv->tiles;
		_tmp67__length1 = self->priv->tiles_length1;
		_tmp67__length2 = self->priv->tiles_length2;
		_tmp68_ = y;
		_tmp69_ = x;
		_tmp70_ = _tmp67_[(_tmp68_ * _tmp67__length2) + (_tmp69_ + 1)];
		_tmp71_ = _game_connected_tiles (self, _tmp70_);
		cl = g_list_concat (cl, _tmp71_);
	}
	_tmp74_ = x;
	if ((_tmp74_ - 1) >= 0) {
		Tile** _tmp75_ = NULL;
		gint _tmp75__length1 = 0;
		gint _tmp75__length2 = 0;
		gint _tmp76_ = 0;
		gint _tmp77_ = 0;
		Tile* _tmp78_ = NULL;
		_tmp75_ = self->priv->tiles;
		_tmp75__length1 = self->priv->tiles_length1;
		_tmp75__length2 = self->priv->tiles_length2;
		_tmp76_ = y;
		_tmp77_ = x;
		_tmp78_ = _tmp75_[(_tmp76_ * _tmp75__length2) + (_tmp77_ - 1)];
		_tmp73_ = _tmp78_ != NULL;
	} else {
		_tmp73_ = FALSE;
	}
	if (_tmp73_) {
		Tile* _tmp79_ = NULL;
		gint _tmp80_ = 0;
		Tile** _tmp81_ = NULL;
		gint _tmp81__length1 = 0;
		gint _tmp81__length2 = 0;
		gint _tmp82_ = 0;
		gint _tmp83_ = 0;
		Tile* _tmp84_ = NULL;
		gint _tmp85_ = 0;
		_tmp79_ = li;
		_tmp80_ = _tmp79_->color;
		_tmp81_ = self->priv->tiles;
		_tmp81__length1 = self->priv->tiles_length1;
		_tmp81__length2 = self->priv->tiles_length2;
		_tmp82_ = y;
		_tmp83_ = x;
		_tmp84_ = _tmp81_[(_tmp82_ * _tmp81__length2) + (_tmp83_ - 1)];
		_tmp85_ = _tmp84_->color;
		_tmp72_ = _tmp80_ == _tmp85_;
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		Tile** _tmp86_ = NULL;
		gint _tmp86__length1 = 0;
		gint _tmp86__length2 = 0;
		gint _tmp87_ = 0;
		gint _tmp88_ = 0;
		Tile* _tmp89_ = NULL;
		GList* _tmp90_ = NULL;
		_tmp86_ = self->priv->tiles;
		_tmp86__length1 = self->priv->tiles_length1;
		_tmp86__length2 = self->priv->tiles_length2;
		_tmp87_ = y;
		_tmp88_ = x;
		_tmp89_ = _tmp86_[(_tmp87_ * _tmp86__length2) + (_tmp88_ - 1)];
		_tmp90_ = _game_connected_tiles (self, _tmp89_);
		cl = g_list_concat (cl, _tmp90_);
	}
	result = cl;
	return result;
}


GList* game_connected_tiles (Game* self, Tile* li) {
	GList* result = NULL;
	Tile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	GList* cl = NULL;
	Tile* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (li != NULL, NULL);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	{
		Tile** l_collection = NULL;
		gint l_collection_length1 = 0;
		gint l_collection_length2 = 0;
		gint l_it = 0;
		l_collection = _tmp0_;
		l_collection_length1 = _tmp0__length1 * _tmp0__length2;
		for (l_it = 0; l_it < (_tmp0__length1 * _tmp0__length2); l_it = l_it + 1) {
			Tile* _tmp1_ = NULL;
			Tile* l = NULL;
			_tmp1_ = _g_object_ref0 (l_collection[l_it]);
			l = _tmp1_;
			{
				Tile* _tmp2_ = NULL;
				_tmp2_ = l;
				if (_tmp2_ != NULL) {
					Tile* _tmp3_ = NULL;
					_tmp3_ = l;
					_tmp3_->visited = FALSE;
				}
				_g_object_unref0 (l);
			}
		}
	}
	_tmp4_ = li;
	_tmp5_ = _game_connected_tiles (self, _tmp4_);
	cl = _tmp5_;
	_tmp6_ = cl;
	_tmp7_ = g_list_length (_tmp6_);
	if (_tmp7_ < ((guint) 2)) {
		__g_list_free__g_object_unref0_0 (cl);
		cl = NULL;
	}
	result = cl;
	return result;
}


Tile* game_get_tile (Game* self, gint x, gint y) {
	Tile* result = NULL;
	Tile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Tile* _tmp3_ = NULL;
	Tile* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	_tmp1_ = y;
	_tmp2_ = x;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}


gboolean game_remove_connected_tiles (Game* self, Tile* tile) {
	gboolean result = FALSE;
	GList* cl = NULL;
	Tile* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	gint new_x = 0;
	GList* _tmp70_ = NULL;
	guint _tmp71_ = 0U;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp73_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tile != NULL, FALSE);
	_tmp0_ = tile;
	_tmp1_ = game_connected_tiles (self, _tmp0_);
	cl = _tmp1_;
	_tmp2_ = cl;
	if (_tmp2_ == NULL) {
		result = FALSE;
		__g_list_free__g_object_unref0_0 (cl);
		return result;
	}
	_tmp3_ = cl;
	{
		GList* l_collection = NULL;
		GList* l_it = NULL;
		l_collection = _tmp3_;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			Tile* _tmp4_ = NULL;
			Tile* l = NULL;
			_tmp4_ = _g_object_ref0 ((Tile*) l_it->data);
			l = _tmp4_;
			{
				Tile* _tmp5_ = NULL;
				_tmp5_ = l;
				tile_set_closed (_tmp5_, TRUE);
				_g_object_unref0 (l);
			}
		}
	}
	new_x = 0;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				GList* not_closed_tiles = NULL;
				GList* closed_tiles = NULL;
				GList* _tmp27_ = NULL;
				gboolean has_empty_col = FALSE;
				gboolean _tmp56_ = FALSE;
				if (!_tmp6_) {
					gint _tmp7_ = 0;
					_tmp7_ = x;
					x = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = x;
				_tmp9_ = self->priv->_columns;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				not_closed_tiles = NULL;
				closed_tiles = NULL;
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							Tile* li = NULL;
							Tile** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							Tile* _tmp17_ = NULL;
							Tile* _tmp18_ = NULL;
							Tile* _tmp19_ = NULL;
							Tile* _tmp20_ = NULL;
							gboolean _tmp21_ = FALSE;
							gboolean _tmp22_ = FALSE;
							if (!_tmp10_) {
								gint _tmp11_ = 0;
								_tmp11_ = y;
								y = _tmp11_ + 1;
							}
							_tmp10_ = FALSE;
							_tmp12_ = y;
							_tmp13_ = self->priv->_rows;
							if (!(_tmp12_ < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->tiles;
							_tmp14__length1 = self->priv->tiles_length1;
							_tmp14__length2 = self->priv->tiles_length2;
							_tmp15_ = y;
							_tmp16_ = x;
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
							_tmp18_ = _g_object_ref0 (_tmp17_);
							li = _tmp18_;
							_tmp19_ = li;
							if (_tmp19_ == NULL) {
								_g_object_unref0 (li);
								break;
							}
							_tmp20_ = li;
							_tmp21_ = tile_get_closed (_tmp20_);
							_tmp22_ = _tmp21_;
							if (_tmp22_) {
								Tile* _tmp23_ = NULL;
								Tile* _tmp24_ = NULL;
								_tmp23_ = li;
								_tmp24_ = _g_object_ref0 (_tmp23_);
								closed_tiles = g_list_append (closed_tiles, _tmp24_);
							} else {
								Tile* _tmp25_ = NULL;
								Tile* _tmp26_ = NULL;
								_tmp25_ = li;
								_tmp26_ = _g_object_ref0 (_tmp25_);
								not_closed_tiles = g_list_append (not_closed_tiles, _tmp26_);
							}
							_g_object_unref0 (li);
						}
					}
				}
				_tmp27_ = closed_tiles;
				closed_tiles = NULL;
				not_closed_tiles = g_list_concat (not_closed_tiles, _tmp27_);
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp28_ = FALSE;
						_tmp28_ = TRUE;
						while (TRUE) {
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							Tile** _tmp32_ = NULL;
							gint _tmp32__length1 = 0;
							gint _tmp32__length2 = 0;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							GList* _tmp35_ = NULL;
							gint _tmp36_ = 0;
							gconstpointer _tmp37_ = NULL;
							Tile* _tmp38_ = NULL;
							Tile* _tmp39_ = NULL;
							if (!_tmp28_) {
								gint _tmp29_ = 0;
								_tmp29_ = y;
								y = _tmp29_ + 1;
							}
							_tmp28_ = FALSE;
							_tmp30_ = y;
							_tmp31_ = self->priv->_rows;
							if (!(_tmp30_ < _tmp31_)) {
								break;
							}
							_tmp32_ = self->priv->tiles;
							_tmp32__length1 = self->priv->tiles_length1;
							_tmp32__length2 = self->priv->tiles_length2;
							_tmp33_ = y;
							_tmp34_ = new_x;
							_tmp35_ = not_closed_tiles;
							_tmp36_ = y;
							_tmp37_ = g_list_nth_data (_tmp35_, (guint) _tmp36_);
							_tmp38_ = _g_object_ref0 ((Tile*) _tmp37_);
							_g_object_unref0 (_tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_]);
							_tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_] = _tmp38_;
							_tmp39_ = _tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_];
						}
					}
				}
				has_empty_col = TRUE;
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp40_ = FALSE;
						_tmp40_ = TRUE;
						while (TRUE) {
							gint _tmp42_ = 0;
							gint _tmp43_ = 0;
							Tile* l = NULL;
							Tile** _tmp44_ = NULL;
							gint _tmp44__length1 = 0;
							gint _tmp44__length2 = 0;
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
							Tile* _tmp47_ = NULL;
							Tile* _tmp48_ = NULL;
							Tile* _tmp49_ = NULL;
							Tile* _tmp50_ = NULL;
							gint _tmp51_ = 0;
							gint _tmp52_ = 0;
							Tile* _tmp53_ = NULL;
							gboolean _tmp54_ = FALSE;
							gboolean _tmp55_ = FALSE;
							if (!_tmp40_) {
								gint _tmp41_ = 0;
								_tmp41_ = y;
								y = _tmp41_ + 1;
							}
							_tmp40_ = FALSE;
							_tmp42_ = y;
							_tmp43_ = self->priv->_rows;
							if (!(_tmp42_ < _tmp43_)) {
								break;
							}
							_tmp44_ = self->priv->tiles;
							_tmp44__length1 = self->priv->tiles_length1;
							_tmp44__length2 = self->priv->tiles_length2;
							_tmp45_ = y;
							_tmp46_ = new_x;
							_tmp47_ = _tmp44_[(_tmp45_ * _tmp44__length2) + _tmp46_];
							_tmp48_ = _g_object_ref0 (_tmp47_);
							l = _tmp48_;
							_tmp49_ = l;
							if (_tmp49_ == NULL) {
								_g_object_unref0 (l);
								break;
							}
							_tmp50_ = l;
							_tmp51_ = new_x;
							_tmp52_ = y;
							tile_update_position (_tmp50_, _tmp51_, _tmp52_);
							_tmp53_ = l;
							_tmp54_ = tile_get_closed (_tmp53_);
							_tmp55_ = _tmp54_;
							if (!_tmp55_) {
								has_empty_col = FALSE;
							}
							_g_object_unref0 (l);
						}
					}
				}
				_tmp56_ = has_empty_col;
				if (!_tmp56_) {
					gint _tmp57_ = 0;
					_tmp57_ = new_x;
					new_x = _tmp57_ + 1;
				}
				__g_list_free__g_object_unref0_0 (closed_tiles);
				__g_list_free__g_object_unref0_0 (not_closed_tiles);
			}
		}
	}
	{
		gboolean _tmp58_ = FALSE;
		_tmp58_ = TRUE;
		while (TRUE) {
			gint _tmp60_ = 0;
			gint _tmp61_ = 0;
			if (!_tmp58_) {
				gint _tmp59_ = 0;
				_tmp59_ = new_x;
				new_x = _tmp59_ + 1;
			}
			_tmp58_ = FALSE;
			_tmp60_ = new_x;
			_tmp61_ = self->priv->_columns;
			if (!(_tmp60_ < _tmp61_)) {
				break;
			}
			{
				gint y = 0;
				y = 0;
				{
					gboolean _tmp62_ = FALSE;
					_tmp62_ = TRUE;
					while (TRUE) {
						gint _tmp64_ = 0;
						gint _tmp65_ = 0;
						Tile** _tmp66_ = NULL;
						gint _tmp66__length1 = 0;
						gint _tmp66__length2 = 0;
						gint _tmp67_ = 0;
						gint _tmp68_ = 0;
						Tile* _tmp69_ = NULL;
						if (!_tmp62_) {
							gint _tmp63_ = 0;
							_tmp63_ = y;
							y = _tmp63_ + 1;
						}
						_tmp62_ = FALSE;
						_tmp64_ = y;
						_tmp65_ = self->priv->_rows;
						if (!(_tmp64_ < _tmp65_)) {
							break;
						}
						_tmp66_ = self->priv->tiles;
						_tmp66__length1 = self->priv->tiles_length1;
						_tmp66__length2 = self->priv->tiles_length2;
						_tmp67_ = y;
						_tmp68_ = new_x;
						_g_object_unref0 (_tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_]);
						_tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_] = NULL;
						_tmp69_ = _tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_];
					}
				}
			}
		}
	}
	_tmp70_ = cl;
	_tmp71_ = g_list_length (_tmp70_);
	game_increment_score_from_tiles (self, (gint) _tmp71_);
	_tmp72_ = self->priv->is_started;
	if (!_tmp72_) {
		self->priv->is_started = TRUE;
		g_signal_emit_by_name (self, "started");
	}
	_tmp73_ = game_has_completed (self);
	if (_tmp73_) {
		gboolean _tmp74_ = FALSE;
		_tmp74_ = game_has_won (self);
		if (_tmp74_) {
			game_increment_score (self, 1000);
		}
		g_signal_emit_by_name (self, "complete");
	}
	result = FALSE;
	__g_list_free__g_object_unref0_0 (cl);
	return result;
}


void game_reset_visit (Game* self) {
	Tile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	{
		Tile** l_collection = NULL;
		gint l_collection_length1 = 0;
		gint l_collection_length2 = 0;
		gint l_it = 0;
		l_collection = _tmp0_;
		l_collection_length1 = _tmp0__length1 * _tmp0__length2;
		for (l_it = 0; l_it < (_tmp0__length1 * _tmp0__length2); l_it = l_it + 1) {
			Tile* _tmp1_ = NULL;
			Tile* l = NULL;
			_tmp1_ = _g_object_ref0 (l_collection[l_it]);
			l = _tmp1_;
			{
				Tile* _tmp2_ = NULL;
				_tmp2_ = l;
				if (_tmp2_ != NULL) {
					Tile* _tmp3_ = NULL;
					_tmp3_ = l;
					_tmp3_->visited = FALSE;
				}
				_g_object_unref0 (l);
			}
		}
	}
}


gboolean game_has_completed (Game* self) {
	gboolean result = FALSE;
	Tile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	{
		Tile** l_collection = NULL;
		gint l_collection_length1 = 0;
		gint l_collection_length2 = 0;
		gint l_it = 0;
		l_collection = _tmp0_;
		l_collection_length1 = _tmp0__length1 * _tmp0__length2;
		for (l_it = 0; l_it < (_tmp0__length1 * _tmp0__length2); l_it = l_it + 1) {
			Tile* _tmp1_ = NULL;
			Tile* l = NULL;
			_tmp1_ = _g_object_ref0 (l_collection[l_it]);
			l = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				Tile* _tmp4_ = NULL;
				_tmp4_ = l;
				if (_tmp4_ != NULL) {
					Tile* _tmp5_ = NULL;
					gboolean _tmp6_ = FALSE;
					gboolean _tmp7_ = FALSE;
					_tmp5_ = l;
					_tmp6_ = tile_get_closed (_tmp5_);
					_tmp7_ = _tmp6_;
					_tmp3_ = !_tmp7_;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					Tile* _tmp8_ = NULL;
					GList* _tmp9_ = NULL;
					GList* _tmp10_ = NULL;
					guint _tmp11_ = 0U;
					_tmp8_ = l;
					_tmp9_ = game_connected_tiles (self, _tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = g_list_length (_tmp10_);
					_tmp2_ = _tmp11_ > ((guint) 1);
					__g_list_free__g_object_unref0_0 (_tmp10_);
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					result = FALSE;
					_g_object_unref0 (l);
					return result;
				}
				_g_object_unref0 (l);
			}
		}
	}
	result = TRUE;
	return result;
}


gboolean game_has_won (Game* self) {
	gboolean result = FALSE;
	Tile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	{
		Tile** l_collection = NULL;
		gint l_collection_length1 = 0;
		gint l_collection_length2 = 0;
		gint l_it = 0;
		l_collection = _tmp0_;
		l_collection_length1 = _tmp0__length1 * _tmp0__length2;
		for (l_it = 0; l_it < (_tmp0__length1 * _tmp0__length2); l_it = l_it + 1) {
			Tile* _tmp1_ = NULL;
			Tile* l = NULL;
			_tmp1_ = _g_object_ref0 (l_collection[l_it]);
			l = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				Tile* _tmp3_ = NULL;
				_tmp3_ = l;
				if (_tmp3_ != NULL) {
					Tile* _tmp4_ = NULL;
					gboolean _tmp5_ = FALSE;
					gboolean _tmp6_ = FALSE;
					_tmp4_ = l;
					_tmp5_ = tile_get_closed (_tmp4_);
					_tmp6_ = _tmp5_;
					_tmp2_ = !_tmp6_;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					result = FALSE;
					_g_object_unref0 (l);
					return result;
				}
				_g_object_unref0 (l);
			}
		}
	}
	result = TRUE;
	return result;
}


void game_increment_score_from_tiles (Game* self, gint n_tiles) {
	gint points_awarded = 0;
	gint _tmp0_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	points_awarded = 0;
	_tmp0_ = n_tiles;
	if (_tmp0_ >= 3) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		_tmp1_ = n_tiles;
		_tmp2_ = n_tiles;
		points_awarded = (_tmp1_ - 2) * (_tmp2_ - 2);
	}
	_tmp3_ = points_awarded;
	game_increment_score (self, _tmp3_);
}


void game_increment_score (Game* self, gint increment) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_score;
	_tmp1_ = increment;
	game_set_score (self, _tmp0_ + _tmp1_);
	_tmp2_ = increment;
	g_signal_emit_by_name (self, "update-score", _tmp2_);
}


gint game_get_score (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_score;
	result = _tmp0_;
	return result;
}


void game_set_score (Game* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_score = _tmp0_;
	g_object_notify ((GObject *) self, "score");
}


gint game_get_color_num (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_color_num;
	result = _tmp0_;
	return result;
}


void game_set_color_num (Game* self, gint value) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ < 2) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp2_ = 0;
		_tmp2_ = value;
		_tmp0_ = _tmp2_ > 4;
	}
	if (_tmp0_) {
		self->priv->_color_num = 3;
	} else {
		gint _tmp3_ = 0;
		_tmp3_ = value;
		self->priv->_color_num = _tmp3_;
	}
	g_object_notify ((GObject *) self, "color-num");
}


gint game_get_rows (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rows;
	result = _tmp0_;
	return result;
}


void game_set_rows (Game* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_rows = _tmp0_;
	g_object_notify ((GObject *) self, "rows");
}


gint game_get_columns (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_columns;
	result = _tmp0_;
	return result;
}


void game_set_columns (Game* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_columns = _tmp0_;
	g_object_notify ((GObject *) self, "columns");
}


static void game_class_init (GameClass * klass) {
	game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SCORE, g_param_spec_int ("score", "score", "score", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_COLOR_NUM, g_param_spec_int ("color-num", "color-num", "color-num", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_ROWS, g_param_spec_int ("rows", "rows", "rows", G_MININT, G_MAXINT, 8, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_COLUMNS, g_param_spec_int ("columns", "columns", "columns", G_MININT, G_MAXINT, 8, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("update_score", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	g_signal_new ("complete", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("started", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void game_instance_init (Game * self) {
	self->priv = GAME_GET_PRIVATE (self);
	self->priv->is_started = FALSE;
	self->priv->_score = 0;
	self->priv->_color_num = 3;
	self->priv->_rows = 8;
	self->priv->_columns = 8;
}


static void game_finalize (GObject* obj) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	self->priv->tiles = (_vala_array_free (self->priv->tiles, self->priv->tiles_length1 * self->priv->tiles_length2, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
}


/**
 *  This is the model layer of the whole game. All game logic goes here. This class tries not to
 *  bring in any visual stuff to comply the separation of view-model idea.
 */
GType game_get_type (void) {
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SCORE:
		g_value_set_int (value, game_get_score (self));
		break;
		case GAME_COLOR_NUM:
		g_value_set_int (value, game_get_color_num (self));
		break;
		case GAME_ROWS:
		g_value_set_int (value, game_get_rows (self));
		break;
		case GAME_COLUMNS:
		g_value_set_int (value, game_get_columns (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SCORE:
		game_set_score (self, g_value_get_int (value));
		break;
		case GAME_COLOR_NUM:
		game_set_color_num (self, g_value_get_int (value));
		break;
		case GAME_ROWS:
		game_set_rows (self, g_value_get_int (value));
		break;
		case GAME_COLUMNS:
		game_set_columns (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



