/* gitg-diff-view.c generated by valac 0.30.0.38-a55d, the Vala compiler
 * generated from gitg-diff-view.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtksourceview/gtksource.h>
#include <cairo.h>


#define GITG_TYPE_DIFF_VIEW (gitg_diff_view_get_type ())
#define GITG_DIFF_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW, GitgDiffView))
#define GITG_DIFF_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW, GitgDiffViewClass))
#define GITG_IS_DIFF_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW))
#define GITG_IS_DIFF_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW))
#define GITG_DIFF_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW, GitgDiffViewClass))

typedef struct _GitgDiffView GitgDiffView;
typedef struct _GitgDiffViewClass GitgDiffViewClass;
typedef struct _GitgDiffViewPrivate GitgDiffViewPrivate;

#define GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS (gitg_diff_view_commit_details_get_type ())
#define GITG_DIFF_VIEW_COMMIT_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetails))
#define GITG_DIFF_VIEW_COMMIT_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetailsClass))
#define GITG_IS_DIFF_VIEW_COMMIT_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS))
#define GITG_IS_DIFF_VIEW_COMMIT_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS))
#define GITG_DIFF_VIEW_COMMIT_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetailsClass))

typedef struct _GitgDiffViewCommitDetails GitgDiffViewCommitDetails;
typedef struct _GitgDiffViewCommitDetailsClass GitgDiffViewCommitDetailsClass;

#define GITG_TYPE_DIFF_VIEW_OPTIONS (gitg_diff_view_options_get_type ())
#define GITG_DIFF_VIEW_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_OPTIONS, GitgDiffViewOptions))
#define GITG_DIFF_VIEW_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_OPTIONS, GitgDiffViewOptionsClass))
#define GITG_IS_DIFF_VIEW_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_OPTIONS))
#define GITG_IS_DIFF_VIEW_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_OPTIONS))
#define GITG_DIFF_VIEW_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_OPTIONS, GitgDiffViewOptionsClass))

typedef struct _GitgDiffViewOptions GitgDiffViewOptions;
typedef struct _GitgDiffViewOptionsClass GitgDiffViewOptionsClass;

#define GITG_TYPE_COMMIT (gitg_commit_get_type ())
#define GITG_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COMMIT, GitgCommit))
#define GITG_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COMMIT, GitgCommitClass))
#define GITG_IS_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COMMIT))
#define GITG_IS_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COMMIT))
#define GITG_COMMIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COMMIT, GitgCommitClass))

typedef struct _GitgCommit GitgCommit;
typedef struct _GitgCommitClass GitgCommitClass;

#define GITG_TYPE_REPOSITORY (gitg_repository_get_type ())
#define GITG_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY, GitgRepository))
#define GITG_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY, GitgRepositoryClass))
#define GITG_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY))
#define GITG_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY))
#define GITG_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY, GitgRepositoryClass))

typedef struct _GitgRepository GitgRepository;
typedef struct _GitgRepositoryClass GitgRepositoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TYPE_DIFF_VIEW_FILE (gitg_diff_view_file_get_type ())
#define GITG_DIFF_VIEW_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFile))
#define GITG_DIFF_VIEW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFileClass))
#define GITG_IS_DIFF_VIEW_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE))
#define GITG_IS_DIFF_VIEW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE))
#define GITG_DIFF_VIEW_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFileClass))

typedef struct _GitgDiffViewFile GitgDiffViewFile;
typedef struct _GitgDiffViewFileClass GitgDiffViewFileClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))

#define GITG_TYPE_DIFF_SELECTABLE (gitg_diff_selectable_get_type ())
#define GITG_DIFF_SELECTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_SELECTABLE, GitgDiffSelectable))
#define GITG_IS_DIFF_SELECTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_SELECTABLE))
#define GITG_DIFF_SELECTABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_DIFF_SELECTABLE, GitgDiffSelectableIface))

typedef struct _GitgDiffSelectable GitgDiffSelectable;
typedef struct _GitgDiffSelectableIface GitgDiffSelectableIface;

#define GITG_TYPE_PATCH_SET (gitg_patch_set_get_type ())
#define GITG_PATCH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PATCH_SET, GitgPatchSet))
#define GITG_PATCH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PATCH_SET, GitgPatchSetClass))
#define GITG_IS_PATCH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PATCH_SET))
#define GITG_IS_PATCH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PATCH_SET))
#define GITG_PATCH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PATCH_SET, GitgPatchSetClass))

typedef struct _GitgPatchSet GitgPatchSet;
typedef struct _GitgPatchSetClass GitgPatchSetClass;

#define GITG_TYPE_DIFF_VIEW_FILE_RENDERER (gitg_diff_view_file_renderer_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER, GitgDiffViewFileRenderer))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER))
#define GITG_DIFF_VIEW_FILE_RENDERER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER, GitgDiffViewFileRendererIface))

typedef struct _GitgDiffViewFileRenderer GitgDiffViewFileRenderer;
typedef struct _GitgDiffViewFileRendererIface GitgDiffViewFileRendererIface;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block6Data Block6Data;
#define _ggit_diff_hunk_unref0(var) ((var == NULL) ? NULL : (var = (ggit_diff_hunk_unref (var), NULL)))

#define GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT (gitg_diff_view_file_renderer_text_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT, GitgDiffViewFileRendererText))
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT, GitgDiffViewFileRendererTextClass))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT))
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT, GitgDiffViewFileRendererTextClass))

typedef struct _GitgDiffViewFileRendererText GitgDiffViewFileRendererText;
typedef struct _GitgDiffViewFileRendererTextClass GitgDiffViewFileRendererTextClass;
typedef struct _GitgPatchSetPrivate GitgPatchSetPrivate;

#define GITG_PATCH_SET_TYPE_PATCH (gitg_patch_set_patch_get_type ())

#define GITG_PATCH_SET_TYPE_TYPE (gitg_patch_set_type_get_type ())
typedef struct _GitgPatchSetPatch GitgPatchSetPatch;
#define _gitg_patch_set_unref0(var) ((var == NULL) ? NULL : (var = (gitg_patch_set_unref (var), NULL)))

struct _GitgDiffView {
	GtkGrid parent_instance;
	GitgDiffViewPrivate * priv;
};

struct _GitgDiffViewClass {
	GtkGridClass parent_class;
	void (*options_changed) (GitgDiffView* self);
};

struct _GitgDiffViewPrivate {
	GitgDiffViewCommitDetails* d_commit_details;
	GtkScrolledWindow* d_scrolledwindow;
	GtkGrid* d_grid_files;
	GtkEventBox* d_event_box;
	GtkRevealer* d_revealer_options;
	GitgDiffViewOptions* d_diff_view_options;
	GgitDiff* d_diff;
	GitgCommit* d_commit;
	GgitDiffOptions* d_options;
	GCancellable* d_cancellable;
	gulong d_expanded_notify;
	gulong d_parent_commit_notify;
	gboolean d_changes_inline;
	guint d_reveal_options_timeout;
	guint d_unreveal_options_timeout;
	gboolean _has_selection;
	gboolean _wrap_lines;
	gboolean _staged;
	gboolean _unstaged;
	gboolean _show_parents;
	gboolean _default_collapse_all;
	gboolean _use_gravatar;
	gint _tab_width;
	gboolean _handle_selection;
	gboolean _highlight;
	GitgRepository* _repository;
	gboolean _new_is_workdir;
};

struct _GitgDiffSelectableIface {
	GTypeInterface parent_iface;
	gboolean (*get_has_selection) (GitgDiffSelectable* self);
	gboolean (*get_can_select) (GitgDiffSelectable* self);
	void (*set_can_select) (GitgDiffSelectable* self, gboolean value);
	GitgPatchSet* (*get_selection) (GitgDiffSelectable* self);
};

struct _GitgDiffViewFileRendererIface {
	GTypeInterface parent_iface;
	void (*add_hunk) (GitgDiffViewFileRenderer* self, GgitDiffHunk* hunk, GeeArrayList* lines);
};

typedef void (*GitgDiffViewAnon) (void* user_data);
struct _Block6Data {
	int _ref_count_;
	GitgDiffView* self;
	GeeArrayList* files;
	GitgDiffViewFile* current_file;
	GgitDiffHunk* current_hunk;
	GeeArrayList* current_lines;
	gint maxlines;
	GitgDiffViewAnon add_hunk;
	gpointer add_hunk_target;
	GDestroyNotify add_hunk_target_destroy_notify;
	GitgDiffViewAnon add_file;
	gpointer add_file_target;
	GDestroyNotify add_file_target_destroy_notify;
	GCancellable* cancellable;
};

typedef enum  {
	GITG_PATCH_SET_TYPE_ADD = 'a',
	GITG_PATCH_SET_TYPE_REMOVE = 'r'
} GitgPatchSetType;

struct _GitgPatchSetPatch {
	GitgPatchSetType type;
	gsize old_offset;
	gsize new_offset;
	gsize length;
};

struct _GitgPatchSet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgPatchSetPrivate * priv;
	gchar* filename;
	GitgPatchSetPatch* patches;
	gint patches_length1;
};

struct _GitgPatchSetClass {
	GTypeClass parent_class;
	void (*finalize) (GitgPatchSet *self);
};


static gpointer gitg_diff_view_parent_class = NULL;

GType gitg_diff_view_get_type (void) G_GNUC_CONST;
GType gitg_diff_view_commit_details_get_type (void) G_GNUC_CONST;
GType gitg_diff_view_options_get_type (void) G_GNUC_CONST;
GType gitg_commit_get_type (void) G_GNUC_CONST;
GType gitg_repository_get_type (void) G_GNUC_CONST;
#define GITG_DIFF_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_DIFF_VIEW, GitgDiffViewPrivate))
enum  {
	GITG_DIFF_VIEW_DUMMY_PROPERTY,
	GITG_DIFF_VIEW_OPTIONS,
	GITG_DIFF_VIEW_HAS_SELECTION,
	GITG_DIFF_VIEW_DIFF,
	GITG_DIFF_VIEW_COMMIT,
	GITG_DIFF_VIEW_WRAP_LINES,
	GITG_DIFF_VIEW_STAGED,
	GITG_DIFF_VIEW_UNSTAGED,
	GITG_DIFF_VIEW_SHOW_PARENTS,
	GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL,
	GITG_DIFF_VIEW_USE_GRAVATAR,
	GITG_DIFF_VIEW_TAB_WIDTH,
	GITG_DIFF_VIEW_HANDLE_SELECTION,
	GITG_DIFF_VIEW_HIGHLIGHT,
	GITG_DIFF_VIEW_REPOSITORY,
	GITG_DIFF_VIEW_NEW_IS_WORKDIR,
	GITG_DIFF_VIEW_IGNORE_WHITESPACE,
	GITG_DIFF_VIEW_CHANGES_INLINE,
	GITG_DIFF_VIEW_CONTEXT_LINES
};
static gboolean gitg_diff_view_flag_get (GitgDiffView* self, GgitDiffOption f);
GgitDiffOptions* gitg_diff_view_get_options (GitgDiffView* self);
static void gitg_diff_view_flag_set (GitgDiffView* self, GgitDiffOption f, gboolean val);
static void gitg_diff_view_real_constructed (GObject* base);
static void gitg_diff_view_update_expanded_files (GitgDiffView* self);
static void _gitg_diff_view_update_expanded_files_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gitg_diff_view_parent_commit_changed (GitgDiffView* self);
static void _gitg_diff_view_parent_commit_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean gitg_diff_view_motion_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventMotion* event);
static gboolean _gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
void gitg_diff_view_options_set_view (GitgDiffViewOptions* self, GitgDiffView* value);
static void gitg_diff_view_update (GitgDiffView* self, gboolean preserve_expanded);
gboolean gitg_diff_view_commit_details_get_expanded (GitgDiffViewCommitDetails* self);
GType gitg_diff_view_file_get_type (void) G_GNUC_CONST;
void gitg_diff_view_file_set_expanded (GitgDiffViewFile* self, gboolean value);
void gitg_diff_view_commit_details_set_commit (GitgDiffViewCommitDetails* self, GgitCommit* value);
GgitCommit* gitg_diff_view_commit_details_get_parent_commit (GitgDiffViewCommitDetails* self);
static void _vala_GgitOId_free (GgitOId* self);
GgitDiff* gitg_commit_get_diff (GitgCommit* self, GgitDiffOptions* options, gint parent);
static void gitg_diff_view_update_diff (GitgDiffView* self, GgitDiff* diff, gboolean preserve_expanded, GCancellable* cancellable);
static void gitg_diff_view_auto_change_expanded (GitgDiffView* self, gboolean expanded);
void gitg_diff_view_commit_details_set_expanded (GitgDiffViewCommitDetails* self, gboolean value);
static void gitg_diff_view_on_selection_changed (GitgDiffView* self);
gpointer gitg_patch_set_ref (gpointer instance);
void gitg_patch_set_unref (gpointer instance);
GParamSpec* gitg_param_spec_patch_set (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gitg_value_set_patch_set (GValue* value, gpointer v_object);
void gitg_value_take_patch_set (GValue* value, gpointer v_object);
gpointer gitg_value_get_patch_set (const GValue* value);
GType gitg_patch_set_get_type (void) G_GNUC_CONST;
GType gitg_diff_selectable_get_type (void) G_GNUC_CONST;
GType gitg_diff_view_file_renderer_get_type (void) G_GNUC_CONST;
GitgDiffViewFileRenderer* gitg_diff_view_file_get_renderer (GitgDiffViewFile* self);
gboolean gitg_diff_selectable_get_has_selection (GitgDiffSelectable* self);
gboolean gitg_diff_view_get_has_selection (GitgDiffView* self);
static void gitg_diff_view_set_has_selection (GitgDiffView* self, gboolean value);
static gchar* gitg_diff_view_primary_path (GitgDiffView* self, GitgDiffViewFile* f);
GgitDiffDelta* gitg_diff_view_file_get_delta (GitgDiffViewFile* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda53_ (Block6Data* _data6_);
void gitg_diff_view_file_add_hunk (GitgDiffViewFile* self, GgitDiffHunk* hunk, GeeArrayList* lines);
static void ___lambda53__gitg_diff_view_anon (gpointer self);
static void __lambda54_ (Block6Data* _data6_);
static void _gitg_diff_view_on_selection_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ___lambda54__gitg_diff_view_anon (gpointer self);
static gint ___lambda55_ (Block6Data* _data6_, GgitDiffDelta* delta, gfloat progress);
GitgRepository* gitg_diff_view_get_repository (GitgDiffView* self);
gboolean gitg_diff_view_get_new_is_workdir (GitgDiffView* self);
gboolean gitg_diff_view_get_handle_selection (GitgDiffView* self);
GitgDiffViewFile* gitg_diff_view_file_new_text (GitgRepository* repository, GgitDiffDelta* delta, gboolean new_is_workdir, gboolean handle_selection);
GitgDiffViewFile* gitg_diff_view_file_construct_text (GType object_type, GitgRepository* repository, GgitDiffDelta* delta, gboolean new_is_workdir, gboolean handle_selection);
static gint ____lambda55__ggit_diff_file_callback (GgitDiffDelta* delta, gfloat progress, gpointer self);
static gint ___lambda56_ (Block6Data* _data6_, GgitDiffDelta* delta, GgitDiffBinary* binary);
static gint ____lambda56__ggit_diff_binary_callback (GgitDiffDelta* delta, GgitDiffBinary* binary, gpointer self);
static gint ___lambda57_ (Block6Data* _data6_, GgitDiffDelta* delta, GgitDiffHunk* hunk);
static gint ____lambda57__ggit_diff_hunk_callback (GgitDiffDelta* delta, GgitDiffHunk* hunk, gpointer self);
static gint ___lambda58_ (Block6Data* _data6_, GgitDiffDelta* delta, GgitDiffHunk* hunk, GgitDiffLine* line);
static gint ____lambda58__ggit_diff_line_callback (GgitDiffDelta* delta, GgitDiffHunk* hunk, GgitDiffLine* line, gpointer self);
gboolean gitg_diff_view_file_get_expanded (GitgDiffViewFile* self);
gboolean gitg_diff_view_get_default_collapse_all (GitgDiffView* self);
void gitg_diff_view_commit_details_set_expander_visible (GitgDiffViewCommitDetails* self, gboolean value);
GType gitg_diff_view_file_renderer_text_get_type (void) G_GNUC_CONST;
void gitg_diff_view_file_renderer_text_set_maxlines (GitgDiffViewFileRendererText* self, gint value);
static void gitg_diff_view_auto_update_expanded (GitgDiffView* self);
static void _gitg_diff_view_auto_update_expanded_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gitg_diff_view_update_hide_show_options (GitgDiffView* self, GdkWindow* window, gint ex, gint ey);
static gboolean ___lambda59_ (GitgDiffView* self);
static gboolean ____lambda59__gsource_func (gpointer self);
static gboolean _____lambda60_ (GitgDiffView* self);
static gboolean ______lambda60__gsource_func (gpointer self);
static gboolean gitg_diff_view_leave_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventCrossing* event);
static gboolean _gitg_diff_view_leave_notify_event_on_event_box_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean gitg_diff_view_enter_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventCrossing* event);
static gboolean _gitg_diff_view_enter_notify_event_on_event_box_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
GitgDiffView* gitg_diff_view_new (void);
GitgDiffView* gitg_diff_view_construct (GType object_type);
GgitDiff* gitg_diff_view_get_diff (GitgDiffView* self);
void gitg_diff_view_set_diff (GitgDiffView* self, GgitDiff* value);
GitgCommit* gitg_diff_view_get_commit (GitgDiffView* self);
void gitg_diff_view_set_commit (GitgDiffView* self, GitgCommit* value);
gboolean gitg_diff_view_get_wrap_lines (GitgDiffView* self);
void gitg_diff_view_set_wrap_lines (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_staged (GitgDiffView* self);
void gitg_diff_view_set_staged (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_unstaged (GitgDiffView* self);
void gitg_diff_view_set_unstaged (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_show_parents (GitgDiffView* self);
void gitg_diff_view_set_show_parents (GitgDiffView* self, gboolean value);
void gitg_diff_view_set_default_collapse_all (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_use_gravatar (GitgDiffView* self);
void gitg_diff_view_set_use_gravatar (GitgDiffView* self, gboolean value);
gint gitg_diff_view_get_tab_width (GitgDiffView* self);
void gitg_diff_view_set_tab_width (GitgDiffView* self, gint value);
void gitg_diff_view_set_handle_selection (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_highlight (GitgDiffView* self);
void gitg_diff_view_set_highlight (GitgDiffView* self, gboolean value);
void gitg_diff_view_set_repository (GitgDiffView* self, GitgRepository* value);
void gitg_diff_view_set_new_is_workdir (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_ignore_whitespace (GitgDiffView* self);
void gitg_diff_view_set_ignore_whitespace (GitgDiffView* self, gboolean value);
gboolean gitg_diff_view_get_changes_inline (GitgDiffView* self);
void gitg_diff_view_set_changes_inline (GitgDiffView* self, gboolean value);
gint gitg_diff_view_get_context_lines (GitgDiffView* self);
void gitg_diff_view_set_context_lines (GitgDiffView* self, gint value);
GitgPatchSet** gitg_diff_view_get_selection (GitgDiffView* self, int* result_length1);
GitgPatchSet* gitg_diff_selectable_get_selection (GitgDiffSelectable* self);
GType gitg_patch_set_patch_get_type (void) G_GNUC_CONST;
GType gitg_patch_set_type_get_type (void) G_GNUC_CONST;
GitgPatchSetPatch* gitg_patch_set_patch_dup (const GitgPatchSetPatch* self);
void gitg_patch_set_patch_free (GitgPatchSetPatch* self);
static void _vala_array_add4 (GitgPatchSet*** array, int* length, int* size, GitgPatchSet* value);
static void gitg_diff_view_real_options_changed (GitgDiffView* self);
static void gitg_diff_view_finalize (GObject* obj);
static void _vala_gitg_diff_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_diff_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gboolean gitg_diff_view_flag_get (GitgDiffView* self, GgitDiffOption f) {
	gboolean result = FALSE;
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp1_ = NULL;
	GgitDiffOption _tmp2_ = 0;
	GgitDiffOption _tmp3_ = 0;
	GgitDiffOption _tmp4_ = 0;
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_get_options (self);
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_;
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = ggit_diff_options_get_flags (_tmp1_);
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_;
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = f;
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = (_tmp3_ & _tmp4_) != 0;
#line 122 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 419 "gitg-diff-view.c"
}


static void gitg_diff_view_flag_set (GitgDiffView* self, GgitDiffOption f, gboolean val) {
	GgitDiffOption flags = 0;
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp1_ = NULL;
	GgitDiffOption _tmp2_ = 0;
	GgitDiffOption _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	GgitDiffOption _tmp9_ = 0;
	GgitDiffOptions* _tmp10_ = NULL;
	GgitDiffOptions* _tmp11_ = NULL;
	GgitDiffOption _tmp12_ = 0;
	GgitDiffOption _tmp13_ = 0;
#line 125 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_get_options (self);
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_;
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = ggit_diff_options_get_flags (_tmp1_);
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_;
#line 127 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	flags = _tmp3_;
#line 129 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = val;
#line 129 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp4_) {
#line 451 "gitg-diff-view.c"
		GgitDiffOption _tmp5_ = 0;
		GgitDiffOption _tmp6_ = 0;
#line 131 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp5_ = flags;
#line 131 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp6_ = f;
#line 131 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		flags = _tmp5_ | _tmp6_;
#line 460 "gitg-diff-view.c"
	} else {
		GgitDiffOption _tmp7_ = 0;
		GgitDiffOption _tmp8_ = 0;
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = flags;
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = f;
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		flags = _tmp7_ & (~_tmp8_);
#line 470 "gitg-diff-view.c"
	}
#line 138 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = flags;
#line 138 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp10_ = gitg_diff_view_get_options (self);
#line 138 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp11_ = _tmp10_;
#line 138 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp12_ = ggit_diff_options_get_flags (_tmp11_);
#line 138 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp13_ = _tmp12_;
#line 138 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp9_ != _tmp13_) {
#line 484 "gitg-diff-view.c"
		GgitDiffOptions* _tmp14_ = NULL;
		GgitDiffOptions* _tmp15_ = NULL;
		GgitDiffOption _tmp16_ = 0;
#line 140 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp14_ = gitg_diff_view_get_options (self);
#line 140 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = _tmp14_;
#line 140 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = flags;
#line 140 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		ggit_diff_options_set_flags (_tmp15_, _tmp16_);
#line 141 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_signal_emit_by_name (self, "options-changed");
#line 498 "gitg-diff-view.c"
	}
}


static void _gitg_diff_view_update_expanded_files_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 186 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update_expanded_files ((GitgDiffView*) self);
#line 506 "gitg-diff-view.c"
}


static void _gitg_diff_view_parent_commit_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 187 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_parent_commit_changed ((GitgDiffView*) self);
#line 513 "gitg-diff-view.c"
}


static gboolean _gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = gitg_diff_view_motion_notify_event_on_event_box ((GitgDiffView*) self, _sender, event);
#line 191 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 522 "gitg-diff-view.c"
}


static void gitg_diff_view_real_constructed (GObject* base) {
	GitgDiffView * self;
	GitgDiffViewCommitDetails* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	GitgDiffViewCommitDetails* _tmp2_ = NULL;
	gulong _tmp3_ = 0UL;
	GitgDiffViewCommitDetails* _tmp4_ = NULL;
	GtkEventBox* _tmp5_ = NULL;
	GitgDiffViewOptions* _tmp6_ = NULL;
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self = (GitgDiffView*) base;
#line 186 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit_details;
#line 186 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = g_signal_connect_object ((GObject*) _tmp0_, "notify::expanded", (GCallback) _gitg_diff_view_update_expanded_files_g_object_notify, self, 0);
#line 186 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_expanded_notify = _tmp1_;
#line 187 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = self->priv->d_commit_details;
#line 187 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = g_signal_connect_object ((GObject*) _tmp2_, "notify::parent-commit", (GCallback) _gitg_diff_view_parent_commit_changed_g_object_notify, self, 0);
#line 187 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_parent_commit_notify = _tmp3_;
#line 189 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = self->priv->d_commit_details;
#line 189 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_bind_property_with_closures ((GObject*) self, "use-gravatar", (GObject*) _tmp4_, "use-gravatar", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 191 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = self->priv->d_event_box;
#line 191 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp5_, "motion-notify-event", (GCallback) _gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event, self, 0);
#line 192 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = self->priv->d_diff_view_options;
#line 192 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_options_set_view (_tmp6_, self);
#line 561 "gitg-diff-view.c"
}


static void gitg_diff_view_parent_commit_changed (GitgDiffView* self) {
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 197 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update (self, FALSE);
#line 570 "gitg-diff-view.c"
}


static void gitg_diff_view_update_expanded_files (GitgDiffView* self) {
	gboolean expanded = FALSE;
	GitgDiffViewCommitDetails* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkGrid* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
#line 200 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit_details;
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = gitg_diff_view_commit_details_get_expanded (_tmp0_);
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = _tmp1_;
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	expanded = _tmp2_;
#line 204 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = self->priv->d_grid_files;
#line 204 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = gtk_container_get_children ((GtkContainer*) _tmp3_);
#line 595 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 204 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp4_;
#line 204 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 603 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 204 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 607 "gitg-diff-view.c"
			{
				GtkWidget* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
#line 206 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp5_ = file;
#line 206 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp6_ = expanded;
#line 206 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				gitg_diff_view_file_set_expanded (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp5_) : NULL, _tmp6_);
#line 617 "gitg-diff-view.c"
			}
		}
#line 204 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_list_free0 (file_collection);
#line 622 "gitg-diff-view.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 630 "gitg-diff-view.c"
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 245 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 637 "gitg-diff-view.c"
}


static void gitg_diff_view_update (GitgDiffView* self, gboolean preserve_expanded) {
	gboolean _tmp0_ = FALSE;
	GgitDiff* _tmp1_ = NULL;
	GitgDiffViewCommitDetails* _tmp5_ = NULL;
	GtkScrolledWindow* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
	GitgCommit* _tmp9_ = NULL;
	GgitDiff* _tmp47_ = NULL;
#line 210 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 214 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = self->priv->d_diff;
#line 214 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ == NULL) {
#line 656 "gitg-diff-view.c"
		GitgCommit* _tmp2_ = NULL;
#line 214 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = self->priv->d_commit;
#line 214 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 662 "gitg-diff-view.c"
	} else {
#line 214 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 666 "gitg-diff-view.c"
	}
#line 214 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 670 "gitg-diff-view.c"
		GitgDiffViewCommitDetails* _tmp3_ = NULL;
		GtkScrolledWindow* _tmp4_ = NULL;
#line 216 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = self->priv->d_commit_details;
#line 216 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 217 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp4_ = self->priv->d_scrolledwindow;
#line 217 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp4_);
#line 218 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		return;
#line 683 "gitg-diff-view.c"
	}
#line 221 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = self->priv->d_commit_details;
#line 221 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp5_);
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = self->priv->d_scrolledwindow;
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp6_);
#line 225 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = self->priv->d_cancellable;
#line 225 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_cancellable_cancel (_tmp7_);
#line 226 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = g_cancellable_new ();
#line 226 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_cancellable);
#line 226 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_cancellable = _tmp8_;
#line 228 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = self->priv->d_commit;
#line 228 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp9_ != NULL) {
#line 707 "gitg-diff-view.c"
		GitgDiffViewCommitDetails* _tmp10_ = NULL;
		gulong _tmp11_ = 0UL;
		GitgDiffViewCommitDetails* _tmp12_ = NULL;
		GitgCommit* _tmp13_ = NULL;
		GitgDiffViewCommitDetails* _tmp14_ = NULL;
		gulong _tmp15_ = 0UL;
		gint parent = 0;
		GgitCommitParents* parents = NULL;
		GitgCommit* _tmp16_ = NULL;
		GgitCommitParents* _tmp17_ = NULL;
		GgitCommit* parent_commit = NULL;
		GitgDiffViewCommitDetails* _tmp18_ = NULL;
		GgitCommit* _tmp19_ = NULL;
		GgitCommit* _tmp20_ = NULL;
		GgitCommit* _tmp21_ = NULL;
		GgitCommit* _tmp22_ = NULL;
		GitgCommit* _tmp39_ = NULL;
		GgitDiffOptions* _tmp40_ = NULL;
		GgitDiffOptions* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		GgitDiff* _tmp43_ = NULL;
		GitgDiffViewCommitDetails* _tmp44_ = NULL;
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = self->priv->d_commit_details;
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = self->priv->d_parent_commit_notify;
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_signal_handler_block (_tmp10_, _tmp11_);
#line 231 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp12_ = self->priv->d_commit_details;
#line 231 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp13_ = self->priv->d_commit;
#line 231 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_commit_details_set_commit (_tmp12_, (GgitCommit*) _tmp13_);
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp14_ = self->priv->d_commit_details;
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = self->priv->d_parent_commit_notify;
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_signal_handler_unblock (_tmp14_, _tmp15_);
#line 234 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		parent = 0;
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = self->priv->d_commit;
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp17_ = ggit_commit_get_parents ((GgitCommit*) _tmp16_);
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		parents = _tmp17_;
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp18_ = self->priv->d_commit_details;
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp19_ = gitg_diff_view_commit_details_get_parent_commit (_tmp18_);
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp20_ = _tmp19_;
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp21_ = _g_object_ref0 (_tmp20_);
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		parent_commit = _tmp21_;
#line 239 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp22_ = parent_commit;
#line 239 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		if (_tmp22_ != NULL) {
#line 770 "gitg-diff-view.c"
			{
				gint i = 0;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				i = 0;
#line 775 "gitg-diff-view.c"
				{
					gboolean _tmp23_ = FALSE;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp23_ = TRUE;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					while (TRUE) {
#line 782 "gitg-diff-view.c"
						gint _tmp25_ = 0;
						GgitCommitParents* _tmp26_ = NULL;
						guint _tmp27_ = 0U;
						guint _tmp28_ = 0U;
						GgitOId* id = NULL;
						GgitCommitParents* _tmp29_ = NULL;
						gint _tmp30_ = 0;
						GgitOId* _tmp31_ = NULL;
						GgitOId* _tmp32_ = NULL;
						GgitCommit* _tmp33_ = NULL;
						GgitOId* _tmp34_ = NULL;
						GgitOId* _tmp35_ = NULL;
						gboolean _tmp36_ = FALSE;
						gboolean _tmp37_ = FALSE;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						if (!_tmp23_) {
#line 799 "gitg-diff-view.c"
							gint _tmp24_ = 0;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
							_tmp24_ = i;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
							i = _tmp24_ + 1;
#line 805 "gitg-diff-view.c"
						}
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp23_ = FALSE;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp25_ = i;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp26_ = parents;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp27_ = ggit_commit_parents_get_size (_tmp26_);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp28_ = _tmp27_;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						if (!(((guint) _tmp25_) < _tmp28_)) {
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
							break;
#line 821 "gitg-diff-view.c"
						}
#line 243 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp29_ = parents;
#line 243 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp30_ = i;
#line 243 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp31_ = ggit_commit_parents_get_id (_tmp29_, (guint) _tmp30_);
#line 243 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						id = _tmp31_;
#line 245 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp32_ = id;
#line 245 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp33_ = parent_commit;
#line 245 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp34_ = ggit_object_get_id ((GgitObject*) _tmp33_);
#line 245 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp35_ = _tmp34_;
#line 245 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp36_ = ggit_oid_equal (_tmp32_, _tmp35_);
#line 245 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp37_ = _tmp36_;
#line 245 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						__vala_GgitOId_free0 (_tmp35_);
#line 245 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						if (_tmp37_) {
#line 847 "gitg-diff-view.c"
							gint _tmp38_ = 0;
#line 247 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
							_tmp38_ = i;
#line 247 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
							parent = _tmp38_;
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
							__vala_GgitOId_free0 (id);
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
							break;
#line 857 "gitg-diff-view.c"
						}
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						__vala_GgitOId_free0 (id);
#line 861 "gitg-diff-view.c"
					}
				}
			}
		}
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp39_ = self->priv->d_commit;
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp40_ = gitg_diff_view_get_options (self);
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp41_ = _tmp40_;
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp42_ = parent;
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp43_ = gitg_commit_get_diff (_tmp39_, _tmp41_, _tmp42_);
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_diff);
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_diff = _tmp43_;
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp44_ = self->priv->d_commit_details;
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_show ((GtkWidget*) _tmp44_);
#line 228 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (parent_commit);
#line 228 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (parents);
#line 888 "gitg-diff-view.c"
	} else {
		GitgDiffViewCommitDetails* _tmp45_ = NULL;
		GitgDiffViewCommitDetails* _tmp46_ = NULL;
#line 258 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp45_ = self->priv->d_commit_details;
#line 258 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_commit_details_set_commit (_tmp45_, NULL);
#line 259 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp46_ = self->priv->d_commit_details;
#line 259 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp46_);
#line 900 "gitg-diff-view.c"
	}
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp47_ = self->priv->d_diff;
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp47_ != NULL) {
#line 906 "gitg-diff-view.c"
		GgitDiff* _tmp48_ = NULL;
		gboolean _tmp49_ = FALSE;
		GCancellable* _tmp50_ = NULL;
#line 264 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp48_ = self->priv->d_diff;
#line 264 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp49_ = preserve_expanded;
#line 264 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp50_ = self->priv->d_cancellable;
#line 264 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_update_diff (self, _tmp48_, _tmp49_, _tmp50_);
#line 918 "gitg-diff-view.c"
	}
}


static void gitg_diff_view_auto_change_expanded (GitgDiffView* self, gboolean expanded) {
	GitgDiffViewCommitDetails* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	GitgDiffViewCommitDetails* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GitgDiffViewCommitDetails* _tmp4_ = NULL;
	gulong _tmp5_ = 0UL;
#line 270 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 272 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit_details;
#line 272 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = self->priv->d_expanded_notify;
#line 272 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_signal_handler_block (_tmp0_, _tmp1_);
#line 273 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = self->priv->d_commit_details;
#line 273 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = expanded;
#line 273 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_commit_details_set_expanded (_tmp2_, _tmp3_);
#line 274 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = self->priv->d_commit_details;
#line 274 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = self->priv->d_expanded_notify;
#line 274 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_signal_handler_unblock (_tmp4_, _tmp5_);
#line 950 "gitg-diff-view.c"
}


static void gitg_diff_view_on_selection_changed (GitgDiffView* self) {
	gboolean something_selected = FALSE;
	GtkGrid* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
#line 277 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 279 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	something_selected = FALSE;
#line 281 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_grid_files;
#line 281 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
#line 968 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 281 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp1_;
#line 281 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 976 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 281 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 980 "gitg-diff-view.c"
			{
				GitgDiffSelectable* selectable = NULL;
				GtkWidget* _tmp2_ = NULL;
				GitgDiffViewFileRenderer* _tmp3_ = NULL;
				GitgDiffViewFileRenderer* _tmp4_ = NULL;
				GitgDiffSelectable* _tmp5_ = NULL;
				GitgDiffSelectable* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
#line 283 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp2_ = file;
#line 283 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp3_ = gitg_diff_view_file_get_renderer (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp2_) : NULL);
#line 283 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp4_ = _tmp3_;
#line 283 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GITG_TYPE_DIFF_SELECTABLE) ? ((GitgDiffSelectable*) _tmp4_) : NULL;
#line 283 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp5_ == NULL) {
#line 283 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_g_object_unref0 (_tmp4_);
#line 1002 "gitg-diff-view.c"
				}
#line 283 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				selectable = _tmp5_;
#line 285 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp6_ = selectable;
#line 285 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp7_ = gitg_diff_selectable_get_has_selection (_tmp6_);
#line 285 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp8_ = _tmp7_;
#line 285 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp8_) {
#line 287 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					something_selected = TRUE;
#line 288 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_g_object_unref0 (selectable);
#line 288 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					break;
#line 1020 "gitg-diff-view.c"
				}
#line 281 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (selectable);
#line 1024 "gitg-diff-view.c"
			}
		}
#line 281 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_list_free0 (file_collection);
#line 1029 "gitg-diff-view.c"
	}
#line 292 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = self->priv->_has_selection;
#line 292 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp10_ = something_selected;
#line 292 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp9_ != _tmp10_) {
#line 1037 "gitg-diff-view.c"
		gboolean _tmp11_ = FALSE;
#line 294 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = something_selected;
#line 294 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_has_selection (self, _tmp11_);
#line 1043 "gitg-diff-view.c"
	}
}


static gchar* gitg_diff_view_primary_path (GitgDiffView* self, GitgDiffViewFile* f) {
	gchar* result = NULL;
	gchar* path = NULL;
	GitgDiffViewFile* _tmp0_ = NULL;
	GgitDiffDelta* _tmp1_ = NULL;
	GgitDiffDelta* _tmp2_ = NULL;
	GgitDiffFile* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
#line 298 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 298 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (f != NULL, NULL);
#line 300 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = f;
#line 300 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = gitg_diff_view_file_get_delta (_tmp0_);
#line 300 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = _tmp1_;
#line 300 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = ggit_diff_delta_get_old_file (_tmp2_);
#line 300 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = ggit_diff_file_get_path (_tmp3_);
#line 300 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 300 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	path = _tmp5_;
#line 302 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = path;
#line 302 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp6_ == NULL) {
#line 1080 "gitg-diff-view.c"
		GitgDiffViewFile* _tmp7_ = NULL;
		GgitDiffDelta* _tmp8_ = NULL;
		GgitDiffDelta* _tmp9_ = NULL;
		GgitDiffFile* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 304 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = f;
#line 304 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = gitg_diff_view_file_get_delta (_tmp7_);
#line 304 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp9_ = _tmp8_;
#line 304 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = ggit_diff_delta_get_new_file (_tmp9_);
#line 304 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp11_ = ggit_diff_file_get_path (_tmp10_);
#line 304 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp12_ = g_strdup (_tmp11_);
#line 304 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_free0 (path);
#line 304 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		path = _tmp12_;
#line 1103 "gitg-diff-view.c"
	}
#line 307 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = path;
#line 307 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1109 "gitg-diff-view.c"
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return _data6_;
#line 1118 "gitg-diff-view.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 1127 "gitg-diff-view.c"
		GitgDiffView* self;
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		self = _data6_->self;
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		(_data6_->add_file_target_destroy_notify == NULL) ? NULL : (_data6_->add_file_target_destroy_notify (_data6_->add_file_target), NULL);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_data6_->add_file = NULL;
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_data6_->add_file_target = NULL;
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_data6_->add_file_target_destroy_notify = NULL;
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		(_data6_->add_hunk_target_destroy_notify == NULL) ? NULL : (_data6_->add_hunk_target_destroy_notify (_data6_->add_hunk_target), NULL);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_data6_->add_hunk = NULL;
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_data6_->add_hunk_target = NULL;
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_data6_->add_hunk_target_destroy_notify = NULL;
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->current_lines);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_hunk_unref0 (_data6_->current_hunk);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->current_file);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->files);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->cancellable);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_slice_free (Block6Data, _data6_);
#line 1161 "gitg-diff-view.c"
	}
}


static void __lambda53_ (Block6Data* _data6_) {
	GitgDiffView* self;
#line 320 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self = _data6_->self;
#line 321 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_data6_->current_hunk != NULL) {
#line 323 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_file_add_hunk (_data6_->current_file, _data6_->current_hunk, _data6_->current_lines);
#line 325 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->current_lines);
#line 325 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_data6_->current_lines = NULL;
#line 326 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_ggit_diff_hunk_unref0 (_data6_->current_hunk);
#line 326 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_data6_->current_hunk = NULL;
#line 1182 "gitg-diff-view.c"
	}
}


static void ___lambda53__gitg_diff_view_anon (gpointer self) {
#line 320 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	__lambda53_ (self);
#line 1190 "gitg-diff-view.c"
}


static void _gitg_diff_view_on_selection_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 336 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_on_selection_changed ((GitgDiffView*) self);
#line 1197 "gitg-diff-view.c"
}


static void __lambda54_ (Block6Data* _data6_) {
	GitgDiffView* self;
#line 330 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self = _data6_->self;
#line 331 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_hunk (_data6_->add_hunk_target);
#line 333 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_data6_->current_file != NULL) {
#line 335 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gtk_widget_show ((GtkWidget*) _data6_->current_file);
#line 336 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_signal_connect_object ((GObject*) _data6_->current_file, "notify::has-selection", (GCallback) _gitg_diff_view_on_selection_changed_g_object_notify, self, 0);
#line 338 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _data6_->files, _data6_->current_file);
#line 340 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (_data6_->current_file);
#line 340 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_data6_->current_file = NULL;
#line 1219 "gitg-diff-view.c"
	}
}


static void ___lambda54__gitg_diff_view_anon (gpointer self) {
#line 330 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	__lambda54_ (self);
#line 1227 "gitg-diff-view.c"
}


static gint ___lambda55_ (Block6Data* _data6_, GgitDiffDelta* delta, gfloat progress) {
	GitgDiffView* self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
	GitgRepository* _tmp4_ = NULL;
	GgitDiffDelta* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GitgDiffViewFile* _tmp8_ = NULL;
	GitgDiffViewFileRenderer* _tmp9_ = NULL;
	GitgDiffViewFileRenderer* _tmp10_ = NULL;
	GitgDiffViewFileRenderer* _tmp11_ = NULL;
#line 347 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self = _data6_->self;
#line 347 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, 0);
#line 348 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _data6_->cancellable;
#line 348 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ != NULL) {
#line 1252 "gitg-diff-view.c"
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 348 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _data6_->cancellable;
#line 348 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 348 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp3_;
#line 1261 "gitg-diff-view.c"
	} else {
#line 348 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 1265 "gitg-diff-view.c"
	}
#line 348 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 350 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		result = 1;
#line 350 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 1273 "gitg-diff-view.c"
	}
#line 353 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_file (_data6_->add_file_target);
#line 355 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = self->priv->_repository;
#line 355 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = delta;
#line 355 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = self->priv->_new_is_workdir;
#line 355 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = self->priv->_handle_selection;
#line 355 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = gitg_diff_view_file_new_text (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 355 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_ref_sink (_tmp8_);
#line 355 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (_data6_->current_file);
#line 355 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->current_file = _tmp8_;
#line 356 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = gitg_diff_view_file_get_renderer (_data6_->current_file);
#line 356 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp10_ = _tmp9_;
#line 356 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp11_ = _tmp10_;
#line 356 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_bind_property_with_closures ((GObject*) self, "highlight", (GObject*) _tmp11_, "highlight", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 356 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (_tmp11_);
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = 0;
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1307 "gitg-diff-view.c"
}


static gint ____lambda55__ggit_diff_file_callback (GgitDiffDelta* delta, gfloat progress, gpointer self) {
	gint result;
	result = ___lambda55_ (self, delta, progress);
#line 346 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1316 "gitg-diff-view.c"
}


static gint ___lambda56_ (Block6Data* _data6_, GgitDiffDelta* delta, GgitDiffBinary* binary) {
	GitgDiffView* self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
#line 361 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self = _data6_->self;
#line 361 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, 0);
#line 361 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (binary != NULL, 0);
#line 363 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _data6_->cancellable;
#line 363 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ != NULL) {
#line 1335 "gitg-diff-view.c"
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 363 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _data6_->cancellable;
#line 363 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 363 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp3_;
#line 1344 "gitg-diff-view.c"
	} else {
#line 363 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 1348 "gitg-diff-view.c"
	}
#line 363 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 365 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		result = 1;
#line 365 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 1356 "gitg-diff-view.c"
	}
#line 368 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = 0;
#line 368 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1362 "gitg-diff-view.c"
}


static gint ____lambda56__ggit_diff_binary_callback (GgitDiffDelta* delta, GgitDiffBinary* binary, gpointer self) {
	gint result;
	result = ___lambda56_ (self, delta, binary);
#line 346 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1371 "gitg-diff-view.c"
}


static gpointer _ggit_diff_hunk_ref0 (gpointer self) {
#line 382 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return self ? ggit_diff_hunk_ref (self) : NULL;
#line 1378 "gitg-diff-view.c"
}


static gint ___lambda57_ (Block6Data* _data6_, GgitDiffDelta* delta, GgitDiffHunk* hunk) {
	GitgDiffView* self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
	GgitDiffHunk* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GgitDiffHunk* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GgitDiffHunk* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GgitDiffHunk* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GgitDiffHunk* _tmp14_ = NULL;
	GgitDiffHunk* _tmp15_ = NULL;
	GeeArrayList* _tmp16_ = NULL;
#line 371 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self = _data6_->self;
#line 371 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, 0);
#line 371 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (hunk != NULL, 0);
#line 372 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _data6_->cancellable;
#line 372 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ != NULL) {
#line 1410 "gitg-diff-view.c"
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 372 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _data6_->cancellable;
#line 372 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 372 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp3_;
#line 1419 "gitg-diff-view.c"
	} else {
#line 372 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 1423 "gitg-diff-view.c"
	}
#line 372 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 374 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		result = 1;
#line 374 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 1431 "gitg-diff-view.c"
	}
#line 377 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = hunk;
#line 377 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = ggit_diff_hunk_get_old_start (_tmp4_);
#line 377 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = hunk;
#line 377 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = ggit_diff_hunk_get_old_lines (_tmp6_);
#line 377 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = MAX (_data6_->maxlines, _tmp5_ + _tmp7_);
#line 377 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->maxlines = _tmp8_;
#line 378 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp9_ = hunk;
#line 378 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp10_ = ggit_diff_hunk_get_new_start (_tmp9_);
#line 378 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp11_ = hunk;
#line 378 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp12_ = ggit_diff_hunk_get_new_lines (_tmp11_);
#line 378 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp13_ = MAX (_data6_->maxlines, _tmp10_ + _tmp12_);
#line 378 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->maxlines = _tmp13_;
#line 380 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_hunk (_data6_->add_hunk_target);
#line 382 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp14_ = hunk;
#line 382 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp15_ = _ggit_diff_hunk_ref0 (_tmp14_);
#line 382 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_ggit_diff_hunk_unref0 (_data6_->current_hunk);
#line 382 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->current_hunk = _tmp15_;
#line 383 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp16_ = gee_array_list_new (ggit_diff_line_get_type (), (GBoxedCopyFunc) ggit_diff_line_ref, ggit_diff_line_unref, NULL, NULL, NULL);
#line 383 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (_data6_->current_lines);
#line 383 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->current_lines = _tmp16_;
#line 385 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = 0;
#line 385 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1477 "gitg-diff-view.c"
}


static gint ____lambda57__ggit_diff_hunk_callback (GgitDiffDelta* delta, GgitDiffHunk* hunk, gpointer self) {
	gint result;
	result = ___lambda57_ (self, delta, hunk);
#line 346 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1486 "gitg-diff-view.c"
}


static gint ___lambda58_ (Block6Data* _data6_, GgitDiffDelta* delta, GgitDiffHunk* hunk, GgitDiffLine* line) {
	GitgDiffView* self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
	GgitDiffDelta* _tmp4_ = NULL;
	GgitDiffFlag _tmp5_ = 0;
#line 388 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self = _data6_->self;
#line 388 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (delta != NULL, 0);
#line 388 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (hunk != NULL, 0);
#line 388 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (line != NULL, 0);
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _data6_->cancellable;
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp1_ != NULL) {
#line 1509 "gitg-diff-view.c"
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = _data6_->cancellable;
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = _tmp3_;
#line 1518 "gitg-diff-view.c"
	} else {
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp0_ = FALSE;
#line 1522 "gitg-diff-view.c"
	}
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_) {
#line 391 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		result = 1;
#line 391 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		return result;
#line 1530 "gitg-diff-view.c"
	}
#line 394 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = delta;
#line 394 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = ggit_diff_delta_get_flags (_tmp4_);
#line 394 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if ((_tmp5_ & GGIT_DIFF_FLAG_BINARY) == 0) {
#line 1538 "gitg-diff-view.c"
		GgitDiffLine* _tmp6_ = NULL;
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp6_ = line;
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _data6_->current_lines, _tmp6_);
#line 1544 "gitg-diff-view.c"
	}
#line 399 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = 0;
#line 399 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1550 "gitg-diff-view.c"
}


static gint ____lambda58__ggit_diff_line_callback (GgitDiffDelta* delta, GgitDiffHunk* hunk, GgitDiffLine* line, gpointer self) {
	gint result;
	result = ___lambda58_ (self, delta, hunk, line);
#line 346 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 1559 "gitg-diff-view.c"
}


static void _gitg_diff_view_auto_update_expanded_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 454 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_auto_update_expanded ((GitgDiffView*) self);
#line 1566 "gitg-diff-view.c"
}


static void gitg_diff_view_update_diff (GitgDiffView* self, GgitDiff* diff, gboolean preserve_expanded, GCancellable* cancellable) {
	Block6Data* _data6_;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GList* file_widgets = NULL;
	GtkGrid* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GeeHashSet* was_expanded = NULL;
	GeeHashSet* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	gboolean _tmp21_ = FALSE;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	GitgDiffViewCommitDetails* _tmp25_ = NULL;
	GitgDiffViewCommitDetails* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GError * _inner_error_ = NULL;
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (diff != NULL);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->_ref_count_ = 1;
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->self = g_object_ref (self);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = cancellable;
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (_data6_->cancellable);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->cancellable = _tmp1_;
#line 312 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = gee_array_list_new (GITG_TYPE_DIFF_VIEW_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 312 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->files = _tmp2_;
#line 314 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->current_file = NULL;
#line 315 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->current_hunk = NULL;
#line 316 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->current_lines = NULL;
#line 318 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->maxlines = 0;
#line 320 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_hunk = ___lambda53__gitg_diff_view_anon;
#line 320 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_hunk_target = block6_data_ref (_data6_);
#line 320 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_hunk_target_destroy_notify = block6_data_unref;
#line 330 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_file = ___lambda54__gitg_diff_view_anon;
#line 330 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_file_target = block6_data_ref (_data6_);
#line 330 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_file_target_destroy_notify = block6_data_unref;
#line 1631 "gitg-diff-view.c"
	{
		GgitDiff* _tmp3_ = NULL;
#line 346 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = diff;
#line 346 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		ggit_diff_foreach (_tmp3_, ____lambda55__ggit_diff_file_callback, ____lambda56__ggit_diff_binary_callback, ____lambda57__ggit_diff_hunk_callback, ____lambda58__ggit_diff_line_callback, _data6_, &_inner_error_);
#line 346 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1640 "gitg-diff-view.c"
			goto __catch31_g_error;
		}
	}
	goto __finally31;
	__catch31_g_error:
	{
#line 344 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_clear_error (&_inner_error_);
#line 344 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_inner_error_ = NULL;
#line 1651 "gitg-diff-view.c"
	}
	__finally31:
#line 344 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 344 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		block6_data_unref (_data6_);
#line 344 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_data6_ = NULL;
#line 344 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 344 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_clear_error (&_inner_error_);
#line 344 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		return;
#line 1666 "gitg-diff-view.c"
	}
#line 404 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_hunk (_data6_->add_hunk_target);
#line 405 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_->add_file (_data6_->add_file_target);
#line 407 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = self->priv->d_grid_files;
#line 407 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = gtk_container_get_children ((GtkContainer*) _tmp4_);
#line 407 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	file_widgets = _tmp5_;
#line 408 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 408 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	was_expanded = _tmp6_;
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = file_widgets;
#line 1684 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp7_;
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 1692 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 1696 "gitg-diff-view.c"
			{
				GitgDiffViewFile* f = NULL;
				GtkWidget* _tmp8_ = NULL;
				GitgDiffViewFile* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				GitgDiffViewFile* _tmp20_ = NULL;
#line 412 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp8_ = file;
#line 412 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp8_) : NULL);
#line 412 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				f = _tmp9_;
#line 414 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp11_ = preserve_expanded;
#line 414 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp11_) {
#line 1714 "gitg-diff-view.c"
					GitgDiffViewFile* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					gboolean _tmp14_ = FALSE;
#line 414 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp12_ = f;
#line 414 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp13_ = gitg_diff_view_file_get_expanded (_tmp12_);
#line 414 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp14_ = _tmp13_;
#line 414 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp10_ = _tmp14_;
#line 1726 "gitg-diff-view.c"
				} else {
#line 414 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp10_ = FALSE;
#line 1730 "gitg-diff-view.c"
				}
#line 414 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp10_) {
#line 1734 "gitg-diff-view.c"
					gchar* path = NULL;
					GitgDiffViewFile* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
#line 416 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp15_ = f;
#line 416 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp16_ = gitg_diff_view_primary_path (self, _tmp15_);
#line 416 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					path = _tmp16_;
#line 418 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp17_ = path;
#line 418 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					if (_tmp17_ != NULL) {
#line 1749 "gitg-diff-view.c"
						GeeHashSet* _tmp18_ = NULL;
						const gchar* _tmp19_ = NULL;
#line 420 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp18_ = was_expanded;
#line 420 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp19_ = path;
#line 420 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
#line 1758 "gitg-diff-view.c"
					}
#line 414 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_g_free0 (path);
#line 1762 "gitg-diff-view.c"
				}
#line 424 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp20_ = f;
#line 424 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				gtk_widget_destroy ((GtkWidget*) _tmp20_);
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (f);
#line 1770 "gitg-diff-view.c"
			}
		}
	}
#line 427 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp22_ = gee_abstract_collection_get_size ((GeeCollection*) _data6_->files);
#line 427 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp23_ = _tmp22_;
#line 427 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp23_ <= 1) {
#line 427 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp21_ = TRUE;
#line 1782 "gitg-diff-view.c"
	} else {
		gboolean _tmp24_ = FALSE;
#line 427 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp24_ = self->priv->_default_collapse_all;
#line 427 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp21_ = !_tmp24_;
#line 1789 "gitg-diff-view.c"
	}
#line 427 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp25_ = self->priv->d_commit_details;
#line 427 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_commit_details_set_expanded (_tmp25_, _tmp21_);
#line 428 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp26_ = self->priv->d_commit_details;
#line 428 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp27_ = gee_abstract_collection_get_size ((GeeCollection*) _data6_->files);
#line 428 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp28_ = _tmp27_;
#line 428 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_commit_details_set_expander_visible (_tmp26_, _tmp28_ > 1);
#line 1803 "gitg-diff-view.c"
	{
		gint i = 0;
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		i = 0;
#line 1808 "gitg-diff-view.c"
		{
			gboolean _tmp29_ = FALSE;
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			_tmp29_ = TRUE;
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			while (TRUE) {
#line 1815 "gitg-diff-view.c"
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
				GitgDiffViewFile* file = NULL;
				gint _tmp34_ = 0;
				gpointer _tmp35_ = NULL;
				gchar* path = NULL;
				GitgDiffViewFile* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				gboolean _tmp38_ = FALSE;
				GitgDiffViewCommitDetails* _tmp39_ = NULL;
				gboolean _tmp40_ = FALSE;
				gboolean _tmp41_ = FALSE;
				GitgDiffViewFile* _tmp47_ = NULL;
				GitgDiffViewFileRendererText* renderer_text = NULL;
				GitgDiffViewFile* _tmp48_ = NULL;
				GitgDiffViewFileRenderer* _tmp49_ = NULL;
				GitgDiffViewFileRenderer* _tmp50_ = NULL;
				GitgDiffViewFileRendererText* _tmp51_ = NULL;
				GitgDiffViewFileRendererText* _tmp52_ = NULL;
				gint _tmp56_ = 0;
				gint _tmp57_ = 0;
				gint _tmp58_ = 0;
				GtkGrid* _tmp60_ = NULL;
				GitgDiffViewFile* _tmp61_ = NULL;
				GitgDiffViewFile* _tmp62_ = NULL;
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (!_tmp29_) {
#line 1844 "gitg-diff-view.c"
					gint _tmp30_ = 0;
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp30_ = i;
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					i = _tmp30_ + 1;
#line 1850 "gitg-diff-view.c"
				}
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp29_ = FALSE;
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp31_ = i;
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp32_ = gee_abstract_collection_get_size ((GeeCollection*) _data6_->files);
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp33_ = _tmp32_;
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (!(_tmp31_ < _tmp33_)) {
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					break;
#line 1864 "gitg-diff-view.c"
				}
#line 432 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp34_ = i;
#line 432 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _data6_->files, _tmp34_);
#line 432 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				file = (GitgDiffViewFile*) _tmp35_;
#line 433 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp36_ = file;
#line 433 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp37_ = gitg_diff_view_primary_path (self, _tmp36_);
#line 433 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				path = _tmp37_;
#line 435 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp39_ = self->priv->d_commit_details;
#line 435 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp40_ = gitg_diff_view_commit_details_get_expanded (_tmp39_);
#line 435 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp41_ = _tmp40_;
#line 435 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp41_) {
#line 435 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp38_ = TRUE;
#line 1888 "gitg-diff-view.c"
				} else {
					gboolean _tmp42_ = FALSE;
					const gchar* _tmp43_ = NULL;
#line 435 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp43_ = path;
#line 435 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					if (_tmp43_ != NULL) {
#line 1896 "gitg-diff-view.c"
						GeeHashSet* _tmp44_ = NULL;
						const gchar* _tmp45_ = NULL;
						gboolean _tmp46_ = FALSE;
#line 435 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp44_ = was_expanded;
#line 435 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp45_ = path;
#line 435 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp46_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp44_, _tmp45_);
#line 435 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp42_ = _tmp46_;
#line 1908 "gitg-diff-view.c"
					} else {
#line 435 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
						_tmp42_ = FALSE;
#line 1912 "gitg-diff-view.c"
					}
#line 435 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp38_ = _tmp42_;
#line 1916 "gitg-diff-view.c"
				}
#line 435 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp47_ = file;
#line 435 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				gitg_diff_view_file_set_expanded (_tmp47_, _tmp38_);
#line 437 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp48_ = file;
#line 437 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp49_ = gitg_diff_view_file_get_renderer (_tmp48_);
#line 437 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp50_ = _tmp49_;
#line 437 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp51_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT) ? ((GitgDiffViewFileRendererText*) _tmp50_) : NULL;
#line 437 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp51_ == NULL) {
#line 437 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_g_object_unref0 (_tmp50_);
#line 1934 "gitg-diff-view.c"
				}
#line 437 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				renderer_text = _tmp51_;
#line 439 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp52_ = renderer_text;
#line 439 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp52_ != NULL) {
#line 1942 "gitg-diff-view.c"
					GitgDiffViewFileRendererText* _tmp53_ = NULL;
					GitgDiffViewFileRendererText* _tmp54_ = NULL;
					GitgDiffViewFileRendererText* _tmp55_ = NULL;
#line 441 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp53_ = renderer_text;
#line 441 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					gitg_diff_view_file_renderer_text_set_maxlines (_tmp53_, _data6_->maxlines);
#line 443 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp54_ = renderer_text;
#line 443 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					g_object_bind_property_with_closures ((GObject*) self, "wrap-lines", (GObject*) _tmp54_, "wrap-lines", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 444 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp55_ = renderer_text;
#line 444 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					g_object_bind_property_with_closures ((GObject*) self, "tab-width", (GObject*) _tmp55_, "tab-width", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 1958 "gitg-diff-view.c"
				}
#line 447 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp56_ = i;
#line 447 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp57_ = gee_abstract_collection_get_size ((GeeCollection*) _data6_->files);
#line 447 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp58_ = _tmp57_;
#line 447 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp56_ == (_tmp58_ - 1)) {
#line 1968 "gitg-diff-view.c"
					GitgDiffViewFile* _tmp59_ = NULL;
#line 449 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp59_ = file;
#line 449 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					gtk_widget_set_vexpand ((GtkWidget*) _tmp59_, TRUE);
#line 1974 "gitg-diff-view.c"
				}
#line 452 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp60_ = self->priv->d_grid_files;
#line 452 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp61_ = file;
#line 452 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				gtk_container_add ((GtkContainer*) _tmp60_, (GtkWidget*) _tmp61_);
#line 454 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp62_ = file;
#line 454 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				g_signal_connect_object ((GObject*) _tmp62_, "notify::expanded", (GCallback) _gitg_diff_view_auto_update_expanded_g_object_notify, self, 0);
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (renderer_text);
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_g_free0 (path);
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (file);
#line 1992 "gitg-diff-view.c"
			}
		}
	}
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (was_expanded);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_list_free0 (file_widgets);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	block6_data_unref (_data6_);
#line 310 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_data6_ = NULL;
#line 2004 "gitg-diff-view.c"
}


static void gitg_diff_view_auto_update_expanded (GitgDiffView* self) {
	GtkGrid* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
#line 458 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 460 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_grid_files;
#line 460 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
#line 2017 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 460 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp1_;
#line 460 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 2025 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 460 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 2029 "gitg-diff-view.c"
			{
				GtkWidget* _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
#line 462 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp2_ = file;
#line 462 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp3_ = gitg_diff_view_file_get_expanded (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp2_) : NULL);
#line 462 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp4_ = _tmp3_;
#line 462 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (!_tmp4_) {
#line 464 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					gitg_diff_view_auto_change_expanded (self, FALSE);
#line 465 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_g_list_free0 (file_collection);
#line 465 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					return;
#line 2048 "gitg-diff-view.c"
				}
			}
		}
#line 460 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_list_free0 (file_collection);
#line 2054 "gitg-diff-view.c"
	}
#line 469 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_auto_change_expanded (self, TRUE);
#line 2058 "gitg-diff-view.c"
}


static gboolean ___lambda59_ (GitgDiffView* self) {
	gboolean result = FALSE;
	GtkRevealer* _tmp0_ = NULL;
#line 521 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_reveal_options_timeout = (guint) 0;
#line 522 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_revealer_options;
#line 522 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
#line 523 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 523 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2075 "gitg-diff-view.c"
}


static gboolean ____lambda59__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda59_ ((GitgDiffView*) self);
#line 520 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2084 "gitg-diff-view.c"
}


static gboolean _____lambda60_ (GitgDiffView* self) {
	gboolean result = FALSE;
	GtkRevealer* _tmp0_ = NULL;
#line 539 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->d_unreveal_options_timeout = (guint) 0;
#line 540 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_revealer_options;
#line 540 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
#line 541 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 541 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2101 "gitg-diff-view.c"
}


static gboolean ______lambda60__gsource_func (gpointer self) {
	gboolean result;
	result = _____lambda60_ ((GitgDiffView*) self);
#line 538 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2110 "gitg-diff-view.c"
}


static void gitg_diff_view_update_hide_show_options (GitgDiffView* self, GdkWindow* window, gint ex, gint ey) {
	void* data = NULL;
	GdkWindow* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	GtkWidget* w = NULL;
	void* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	gint x = 0;
	gint y = 0;
	GtkWidget* _tmp5_ = NULL;
	GtkEventBox* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GtkAllocation alloc = {0};
	GtkAllocation revealer_alloc = {0};
	GtkEventBox* _tmp11_ = NULL;
	GtkAllocation _tmp12_ = {0};
	GtkRevealer* _tmp13_ = NULL;
	GtkAllocation _tmp14_ = {0};
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	GtkRevealer* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
#line 492 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 492 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (window != NULL);
#line 495 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = window;
#line 495 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gdk_window_get_user_data (_tmp0_, &_tmp1_);
#line 495 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	data = _tmp1_;
#line 497 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = data;
#line 497 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp2_) : NULL);
#line 497 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	w = _tmp3_;
#line 499 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = w;
#line 499 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp4_ == NULL) {
#line 501 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (w);
#line 501 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		return;
#line 2165 "gitg-diff-view.c"
	}
#line 505 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = w;
#line 505 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp6_ = self->priv->d_event_box;
#line 505 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp7_ = ex;
#line 505 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp8_ = ey;
#line 505 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_translate_coordinates (_tmp5_, (GtkWidget*) _tmp6_, _tmp7_, _tmp8_, &_tmp9_, &_tmp10_);
#line 505 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	x = _tmp9_;
#line 505 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	y = _tmp10_;
#line 509 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp11_ = self->priv->d_event_box;
#line 509 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_get_allocation ((GtkWidget*) _tmp11_, &_tmp12_);
#line 509 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	alloc = _tmp12_;
#line 510 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp13_ = self->priv->d_revealer_options;
#line 510 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_get_allocation ((GtkWidget*) _tmp13_, &_tmp14_);
#line 510 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	revealer_alloc = _tmp14_;
#line 512 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp17_ = self->priv->d_revealer_options;
#line 512 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp18_ = gtk_revealer_get_reveal_child (_tmp17_);
#line 512 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp19_ = _tmp18_;
#line 512 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (!_tmp19_) {
#line 2201 "gitg-diff-view.c"
		gint _tmp20_ = 0;
		GtkAllocation _tmp21_ = {0};
		gint _tmp22_ = 0;
#line 512 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp20_ = y;
#line 512 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp21_ = alloc;
#line 512 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp22_ = _tmp21_.height;
#line 512 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = _tmp20_ >= (_tmp22_ - 18);
#line 2213 "gitg-diff-view.c"
	} else {
#line 512 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp16_ = FALSE;
#line 2217 "gitg-diff-view.c"
	}
#line 512 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp16_) {
#line 2221 "gitg-diff-view.c"
		guint _tmp23_ = 0U;
#line 512 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp23_ = self->priv->d_reveal_options_timeout;
#line 512 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = _tmp23_ == ((guint) 0);
#line 2227 "gitg-diff-view.c"
	} else {
#line 512 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp15_ = FALSE;
#line 2231 "gitg-diff-view.c"
	}
#line 512 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp15_) {
#line 2235 "gitg-diff-view.c"
		guint _tmp24_ = 0U;
		guint _tmp26_ = 0U;
#line 514 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp24_ = self->priv->d_unreveal_options_timeout;
#line 514 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		if (_tmp24_ != ((guint) 0)) {
#line 2242 "gitg-diff-view.c"
			guint _tmp25_ = 0U;
#line 516 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			_tmp25_ = self->priv->d_unreveal_options_timeout;
#line 516 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			g_source_remove (_tmp25_);
#line 517 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			self->priv->d_unreveal_options_timeout = (guint) 0;
#line 2250 "gitg-diff-view.c"
		}
#line 520 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp26_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, ____lambda59__gsource_func, g_object_ref (self), g_object_unref);
#line 520 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_reveal_options_timeout = _tmp26_;
#line 2256 "gitg-diff-view.c"
	} else {
		GtkRevealer* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
#line 526 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp27_ = self->priv->d_revealer_options;
#line 526 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp28_ = gtk_revealer_get_reveal_child (_tmp27_);
#line 526 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp29_ = _tmp28_;
#line 526 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		if (_tmp29_) {
#line 2269 "gitg-diff-view.c"
			gboolean above = FALSE;
			gint _tmp30_ = 0;
			GtkAllocation _tmp31_ = {0};
			gint _tmp32_ = 0;
			GtkAllocation _tmp33_ = {0};
			gint _tmp34_ = 0;
			gboolean _tmp35_ = FALSE;
			gboolean _tmp36_ = FALSE;
#line 528 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			_tmp30_ = y;
#line 528 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			_tmp31_ = alloc;
#line 528 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			_tmp32_ = _tmp31_.height;
#line 528 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			_tmp33_ = revealer_alloc;
#line 528 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			_tmp34_ = _tmp33_.height;
#line 528 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			above = _tmp30_ <= ((_tmp32_ - 6) - _tmp34_);
#line 530 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			_tmp36_ = above;
#line 530 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			if (_tmp36_) {
#line 2294 "gitg-diff-view.c"
				guint _tmp37_ = 0U;
#line 530 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp37_ = self->priv->d_unreveal_options_timeout;
#line 530 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp35_ = _tmp37_ == ((guint) 0);
#line 2300 "gitg-diff-view.c"
			} else {
#line 530 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp35_ = FALSE;
#line 2304 "gitg-diff-view.c"
			}
#line 530 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			if (_tmp35_) {
#line 2308 "gitg-diff-view.c"
				guint _tmp38_ = 0U;
				guint _tmp40_ = 0U;
#line 532 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp38_ = self->priv->d_reveal_options_timeout;
#line 532 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp38_ != ((guint) 0)) {
#line 2315 "gitg-diff-view.c"
					guint _tmp39_ = 0U;
#line 534 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp39_ = self->priv->d_reveal_options_timeout;
#line 534 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					g_source_remove (_tmp39_);
#line 535 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					self->priv->d_reveal_options_timeout = (guint) 0;
#line 2323 "gitg-diff-view.c"
				}
#line 538 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp40_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, ______lambda60__gsource_func, g_object_ref (self), g_object_unref);
#line 538 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				self->priv->d_unreveal_options_timeout = _tmp40_;
#line 2329 "gitg-diff-view.c"
			} else {
				gboolean _tmp41_ = FALSE;
				gboolean _tmp42_ = FALSE;
#line 544 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp42_ = above;
#line 544 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (!_tmp42_) {
#line 2337 "gitg-diff-view.c"
					guint _tmp43_ = 0U;
#line 544 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp43_ = self->priv->d_unreveal_options_timeout;
#line 544 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp41_ = _tmp43_ != ((guint) 0);
#line 2343 "gitg-diff-view.c"
				} else {
#line 544 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp41_ = FALSE;
#line 2347 "gitg-diff-view.c"
				}
#line 544 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp41_) {
#line 2351 "gitg-diff-view.c"
					guint _tmp44_ = 0U;
#line 546 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp44_ = self->priv->d_unreveal_options_timeout;
#line 546 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					g_source_remove (_tmp44_);
#line 547 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					self->priv->d_unreveal_options_timeout = (guint) 0;
#line 2359 "gitg-diff-view.c"
				}
			}
		}
	}
#line 492 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (w);
#line 2366 "gitg-diff-view.c"
}


static gboolean gitg_diff_view_leave_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventCrossing* event) {
	gboolean result = FALSE;
	GdkEventCrossing* _tmp0_ = NULL;
	GdkWindow* _tmp1_ = NULL;
	GdkEventCrossing* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GdkEventCrossing* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
#line 553 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 553 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 553 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 555 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = event;
#line 555 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_->window;
#line 555 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = event;
#line 555 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_->x;
#line 555 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = event;
#line 555 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = _tmp4_->y;
#line 555 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update_hide_show_options (self, _tmp1_, (gint) _tmp3_, (gint) _tmp5_);
#line 556 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 556 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2402 "gitg-diff-view.c"
}


static gboolean _gitg_diff_view_leave_notify_event_on_event_box_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = gitg_diff_view_leave_notify_event_on_event_box ((GitgDiffView*) self, _sender, event);
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2411 "gitg-diff-view.c"
}


static gboolean gitg_diff_view_enter_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventCrossing* event) {
	gboolean result = FALSE;
	GdkEventCrossing* _tmp0_ = NULL;
	GdkWindow* _tmp1_ = NULL;
	GdkEventCrossing* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GdkEventCrossing* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
#line 560 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 560 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 560 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 562 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = event;
#line 562 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_->window;
#line 562 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = event;
#line 562 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_->x;
#line 562 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = event;
#line 562 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = _tmp4_->y;
#line 562 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update_hide_show_options (self, _tmp1_, (gint) _tmp3_, (gint) _tmp5_);
#line 563 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 563 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2447 "gitg-diff-view.c"
}


static gboolean _gitg_diff_view_enter_notify_event_on_event_box_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = gitg_diff_view_enter_notify_event_on_event_box ((GitgDiffView*) self, _sender, event);
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2456 "gitg-diff-view.c"
}


static gboolean gitg_diff_view_motion_notify_event_on_event_box (GitgDiffView* self, GtkWidget* widget, GdkEventMotion* event) {
	gboolean result = FALSE;
	GdkEventMotion* _tmp0_ = NULL;
	GdkWindow* _tmp1_ = NULL;
	GdkEventMotion* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GdkEventMotion* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
#line 567 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 567 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 567 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 569 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = event;
#line 569 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_->window;
#line 569 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = event;
#line 569 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_->x;
#line 569 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = event;
#line 569 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp5_ = _tmp4_->y;
#line 569 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update_hide_show_options (self, _tmp1_, (gint) _tmp3_, (gint) _tmp5_);
#line 570 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = FALSE;
#line 570 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2492 "gitg-diff-view.c"
}


GitgDiffView* gitg_diff_view_construct (GType object_type) {
	GitgDiffView * self = NULL;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self = (GitgDiffView*) g_object_new (object_type, NULL);
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return self;
#line 2502 "gitg-diff-view.c"
}


GitgDiffView* gitg_diff_view_new (void) {
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return gitg_diff_view_construct (GITG_TYPE_DIFF_VIEW);
#line 2509 "gitg-diff-view.c"
}


GgitDiffOptions* gitg_diff_view_get_options (GitgDiffView* self) {
	GgitDiffOptions* result;
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp2_ = NULL;
#line 54 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_options;
#line 56 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ == NULL) {
#line 2523 "gitg-diff-view.c"
		GgitDiffOptions* _tmp1_ = NULL;
#line 58 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp1_ = ggit_diff_options_new ();
#line 58 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_options);
#line 58 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_options = _tmp1_;
#line 2531 "gitg-diff-view.c"
	}
#line 61 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = self->priv->d_options;
#line 61 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp2_;
#line 61 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2539 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_has_selection (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_has_selection;
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2554 "gitg-diff-view.c"
}


static void gitg_diff_view_set_has_selection (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_has_selection = _tmp0_;
#line 67 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "has-selection");
#line 2568 "gitg-diff-view.c"
}


GgitDiff* gitg_diff_view_get_diff (GitgDiffView* self) {
	GgitDiff* result;
	GgitDiff* _tmp0_ = NULL;
#line 72 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 72 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_diff;
#line 72 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 72 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2583 "gitg-diff-view.c"
}


void gitg_diff_view_set_diff (GitgDiffView* self, GgitDiff* value) {
	GgitDiff* _tmp0_ = NULL;
	GgitDiff* _tmp1_ = NULL;
#line 73 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 75 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_diff;
#line 75 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = value;
#line 75 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != _tmp1_) {
#line 2598 "gitg-diff-view.c"
		GgitDiff* _tmp2_ = NULL;
		GgitDiff* _tmp3_ = NULL;
#line 77 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = value;
#line 77 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 77 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_diff);
#line 77 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_diff = _tmp3_;
#line 78 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_commit);
#line 78 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_commit = NULL;
#line 2613 "gitg-diff-view.c"
	}
#line 81 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update (self, FALSE);
#line 73 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "diff");
#line 2619 "gitg-diff-view.c"
}


GitgCommit* gitg_diff_view_get_commit (GitgDiffView* self) {
	GitgCommit* result;
	GitgCommit* _tmp0_ = NULL;
#line 87 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 87 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit;
#line 87 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 87 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2634 "gitg-diff-view.c"
}


void gitg_diff_view_set_commit (GitgDiffView* self, GitgCommit* value) {
	GitgCommit* _tmp0_ = NULL;
	GitgCommit* _tmp1_ = NULL;
#line 88 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 90 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit;
#line 90 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = value;
#line 90 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != _tmp1_) {
#line 2649 "gitg-diff-view.c"
		GitgCommit* _tmp2_ = NULL;
		GitgCommit* _tmp3_ = NULL;
#line 92 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = value;
#line 92 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 92 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_commit);
#line 92 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_commit = _tmp3_;
#line 93 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_object_unref0 (self->priv->d_diff);
#line 93 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_diff = NULL;
#line 2664 "gitg-diff-view.c"
	}
#line 96 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_update (self, FALSE);
#line 88 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "commit");
#line 2670 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_wrap_lines (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_wrap_lines;
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2685 "gitg-diff-view.c"
}


void gitg_diff_view_set_wrap_lines (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_wrap_lines = _tmp0_;
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "wrap-lines");
#line 2699 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_staged (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_staged;
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2714 "gitg-diff-view.c"
}


void gitg_diff_view_set_staged (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_staged = _tmp0_;
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "staged");
#line 2728 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_unstaged (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_unstaged;
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2743 "gitg-diff-view.c"
}


void gitg_diff_view_set_unstaged (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_unstaged = _tmp0_;
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "unstaged");
#line 2757 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_show_parents (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 111 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 111 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_show_parents;
#line 111 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 111 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2772 "gitg-diff-view.c"
}


void gitg_diff_view_set_show_parents (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 111 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 111 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 111 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_show_parents = _tmp0_;
#line 111 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "show-parents");
#line 2786 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_default_collapse_all (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 112 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 112 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_default_collapse_all;
#line 112 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 112 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2801 "gitg-diff-view.c"
}


void gitg_diff_view_set_default_collapse_all (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 112 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 112 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 112 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_default_collapse_all = _tmp0_;
#line 112 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "default-collapse-all");
#line 2815 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_use_gravatar (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 113 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 113 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_use_gravatar;
#line 113 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 113 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2830 "gitg-diff-view.c"
}


void gitg_diff_view_set_use_gravatar (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 113 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 113 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 113 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_use_gravatar = _tmp0_;
#line 113 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "use-gravatar");
#line 2844 "gitg-diff-view.c"
}


gint gitg_diff_view_get_tab_width (GitgDiffView* self) {
	gint result;
	gint _tmp0_ = 0;
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_tab_width;
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2859 "gitg-diff-view.c"
}


void gitg_diff_view_set_tab_width (GitgDiffView* self, gint value) {
	gint _tmp0_ = 0;
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_tab_width = _tmp0_;
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "tab-width");
#line 2873 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_handle_selection (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 115 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 115 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_handle_selection;
#line 115 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 115 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2888 "gitg-diff-view.c"
}


void gitg_diff_view_set_handle_selection (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 115 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 115 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 115 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_handle_selection = _tmp0_;
#line 115 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "handle-selection");
#line 2902 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_highlight (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_highlight;
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2917 "gitg-diff-view.c"
}


void gitg_diff_view_set_highlight (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_highlight = _tmp0_;
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "highlight");
#line 2931 "gitg-diff-view.c"
}


GitgRepository* gitg_diff_view_get_repository (GitgDiffView* self) {
	GitgRepository* result;
	GitgRepository* _tmp0_ = NULL;
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_repository;
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2946 "gitg-diff-view.c"
}


void gitg_diff_view_set_repository (GitgDiffView* self, GitgRepository* value) {
	GitgRepository* _tmp0_ = NULL;
	GitgRepository* _tmp1_ = NULL;
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->_repository);
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_repository = _tmp1_;
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "repository");
#line 2965 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_new_is_workdir (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->_new_is_workdir;
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 2980 "gitg-diff-view.c"
}


void gitg_diff_view_set_new_is_workdir (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_new_is_workdir = _tmp0_;
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "new-is-workdir");
#line 2994 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_ignore_whitespace (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 147 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 147 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_flag_get (self, GGIT_DIFF_IGNORE_WHITESPACE);
#line 147 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 147 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3009 "gitg-diff-view.c"
}


void gitg_diff_view_set_ignore_whitespace (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = value;
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_flag_set (self, GGIT_DIFF_IGNORE_WHITESPACE, _tmp0_);
#line 148 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "ignore-whitespace");
#line 3023 "gitg-diff-view.c"
}


gboolean gitg_diff_view_get_changes_inline (GitgDiffView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_changes_inline;
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp0_;
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3038 "gitg-diff-view.c"
}


void gitg_diff_view_set_changes_inline (GitgDiffView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 154 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 156 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_changes_inline;
#line 156 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = value;
#line 156 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != _tmp1_) {
#line 3053 "gitg-diff-view.c"
		gboolean _tmp2_ = FALSE;
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp2_ = value;
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		self->priv->d_changes_inline = _tmp2_;
#line 3059 "gitg-diff-view.c"
	}
#line 154 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "changes-inline");
#line 3063 "gitg-diff-view.c"
}


gint gitg_diff_view_get_context_lines (GitgDiffView* self) {
	gint result;
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_get_options (self);
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_;
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = ggit_diff_options_get_n_context_lines (_tmp1_);
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_;
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp3_;
#line 168 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3087 "gitg-diff-view.c"
}


void gitg_diff_view_set_context_lines (GitgDiffView* self, gint value) {
	GgitDiffOptions* _tmp0_ = NULL;
	GgitDiffOptions* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 170 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_if_fail (self != NULL);
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = gitg_diff_view_get_options (self);
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = _tmp0_;
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = ggit_diff_options_get_n_context_lines (_tmp1_);
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp3_ = _tmp2_;
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp4_ = value;
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp3_ != _tmp4_) {
#line 3111 "gitg-diff-view.c"
		GgitDiffOptions* _tmp5_ = NULL;
		GgitDiffOptions* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		GgitDiffOptions* _tmp8_ = NULL;
		GgitDiffOptions* _tmp9_ = NULL;
		gint _tmp10_ = 0;
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp5_ = gitg_diff_view_get_options (self);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp6_ = _tmp5_;
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp7_ = value;
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		ggit_diff_options_set_n_context_lines (_tmp6_, _tmp7_);
#line 175 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp8_ = gitg_diff_view_get_options (self);
#line 175 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp9_ = _tmp8_;
#line 175 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_tmp10_ = value;
#line 175 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		ggit_diff_options_set_n_interhunk_lines (_tmp9_, _tmp10_);
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_signal_emit_by_name (self, "options-changed");
#line 3136 "gitg-diff-view.c"
	}
#line 170 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_notify ((GObject *) self, "context-lines");
#line 3140 "gitg-diff-view.c"
}


static void _vala_array_add4 (GitgPatchSet*** array, int* length, int* size, GitgPatchSet* value) {
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if ((*length) == (*size)) {
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		*array = g_renew (GitgPatchSet*, *array, (*size) + 1);
#line 3151 "gitg-diff-view.c"
	}
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	(*array)[(*length)++] = value;
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	(*array)[*length] = NULL;
#line 3157 "gitg-diff-view.c"
}


GitgPatchSet** gitg_diff_view_get_selection (GitgDiffView* self, int* result_length1) {
	GitgPatchSet** result;
	GitgPatchSet** ret = NULL;
	GitgPatchSet** _tmp0_ = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	GtkGrid* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GitgPatchSet** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
#line 474 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 476 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = g_new0 (GitgPatchSet*, 0 + 1);
#line 476 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	ret = _tmp0_;
#line 476 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	ret_length1 = 0;
#line 476 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_ret_size_ = ret_length1;
#line 478 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp1_ = self->priv->d_grid_files;
#line 478 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
#line 3185 "gitg-diff-view.c"
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
#line 478 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		file_collection = _tmp2_;
#line 478 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 3193 "gitg-diff-view.c"
			GtkWidget* file = NULL;
#line 478 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
			file = (GtkWidget*) file_it->data;
#line 3197 "gitg-diff-view.c"
			{
				GitgDiffSelectable* sel = NULL;
				GtkWidget* _tmp3_ = NULL;
				GitgDiffViewFileRenderer* _tmp4_ = NULL;
				GitgDiffViewFileRenderer* _tmp5_ = NULL;
				GitgDiffSelectable* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				GitgDiffSelectable* _tmp9_ = NULL;
#line 480 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp3_ = file;
#line 480 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp4_ = gitg_diff_view_file_get_renderer (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GITG_TYPE_DIFF_VIEW_FILE) ? ((GitgDiffViewFile*) _tmp3_) : NULL);
#line 480 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp5_ = _tmp4_;
#line 480 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GITG_TYPE_DIFF_SELECTABLE) ? ((GitgDiffSelectable*) _tmp5_) : NULL;
#line 480 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp6_ == NULL) {
#line 480 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_g_object_unref0 (_tmp5_);
#line 3219 "gitg-diff-view.c"
				}
#line 480 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				sel = _tmp6_;
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_tmp9_ = sel;
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp9_ != NULL) {
#line 3227 "gitg-diff-view.c"
					GitgDiffSelectable* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp10_ = sel;
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp11_ = gitg_diff_selectable_get_has_selection (_tmp10_);
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp12_ = _tmp11_;
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp8_ = _tmp12_;
#line 3239 "gitg-diff-view.c"
				} else {
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp8_ = FALSE;
#line 3243 "gitg-diff-view.c"
				}
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp8_) {
#line 3247 "gitg-diff-view.c"
					GitgDiffSelectable* _tmp13_ = NULL;
					GitgPatchSet* _tmp14_ = NULL;
					GitgPatchSet* _tmp15_ = NULL;
					GitgPatchSet* _tmp16_ = NULL;
					GitgPatchSetPatch* _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp13_ = sel;
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp14_ = gitg_diff_selectable_get_selection (_tmp13_);
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp15_ = _tmp14_;
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp16_ = _tmp15_;
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp17_ = _tmp16_->patches;
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp17__length1 = _tmp16_->patches_length1;
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp7_ = _tmp17__length1 != 0;
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_gitg_patch_set_unref0 (_tmp16_);
#line 3270 "gitg-diff-view.c"
				} else {
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp7_ = FALSE;
#line 3274 "gitg-diff-view.c"
				}
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				if (_tmp7_) {
#line 3278 "gitg-diff-view.c"
					GitgPatchSet** _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					GitgDiffSelectable* _tmp19_ = NULL;
					GitgPatchSet* _tmp20_ = NULL;
					GitgPatchSet* _tmp21_ = NULL;
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp18_ = ret;
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp18__length1 = ret_length1;
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp19_ = sel;
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp20_ = gitg_diff_selectable_get_selection (_tmp19_);
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_tmp21_ = _tmp20_;
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
					_vala_array_add4 (&ret, &ret_length1, &_ret_size_, _tmp21_);
#line 3296 "gitg-diff-view.c"
				}
#line 478 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
				_g_object_unref0 (sel);
#line 3300 "gitg-diff-view.c"
			}
		}
#line 478 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		_g_list_free0 (file_collection);
#line 3305 "gitg-diff-view.c"
	}
#line 488 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp22_ = ret;
#line 488 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp22__length1 = ret_length1;
#line 488 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (result_length1) {
#line 488 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		*result_length1 = _tmp22__length1;
#line 3315 "gitg-diff-view.c"
	}
#line 488 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	result = _tmp22_;
#line 488 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	return result;
#line 3321 "gitg-diff-view.c"
}


static void gitg_diff_view_real_options_changed (GitgDiffView* self) {
	GitgCommit* _tmp0_ = NULL;
#line 102 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_tmp0_ = self->priv->d_commit;
#line 102 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	if (_tmp0_ != NULL) {
#line 104 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_update (self, TRUE);
#line 3333 "gitg-diff-view.c"
	}
}


static void gitg_diff_view_class_init (GitgDiffViewClass * klass) {
	gint GitgDiffView_private_offset;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gitg_diff_view_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_type_class_add_private (klass, sizeof (GitgDiffViewPrivate));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	((GObjectClass *) klass)->constructed = gitg_diff_view_real_constructed;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	((GitgDiffViewClass *) klass)->options_changed = gitg_diff_view_real_options_changed;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_diff_view_get_property;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_diff_view_set_property;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_diff_view_finalize;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_OPTIONS, g_param_spec_object ("options", "options", "options", ggit_diff_options_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_HAS_SELECTION, g_param_spec_boolean ("has-selection", "has-selection", "has-selection", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_DIFF, g_param_spec_object ("diff", "diff", "diff", ggit_diff_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_COMMIT, g_param_spec_object ("commit", "commit", "commit", GITG_TYPE_COMMIT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_WRAP_LINES, g_param_spec_boolean ("wrap-lines", "wrap-lines", "wrap-lines", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_STAGED, g_param_spec_boolean ("staged", "staged", "staged", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_UNSTAGED, g_param_spec_boolean ("unstaged", "unstaged", "unstaged", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_SHOW_PARENTS, g_param_spec_boolean ("show-parents", "show-parents", "show-parents", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL, g_param_spec_boolean ("default-collapse-all", "default-collapse-all", "default-collapse-all", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_USE_GRAVATAR, g_param_spec_boolean ("use-gravatar", "use-gravatar", "use-gravatar", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_TAB_WIDTH, g_param_spec_int ("tab-width", "tab-width", "tab-width", G_MININT, G_MAXINT, 4, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_HANDLE_SELECTION, g_param_spec_boolean ("handle-selection", "handle-selection", "handle-selection", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_HIGHLIGHT, g_param_spec_boolean ("highlight", "highlight", "highlight", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_REPOSITORY, g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_NEW_IS_WORKDIR, g_param_spec_boolean ("new-is-workdir", "new-is-workdir", "new-is-workdir", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_IGNORE_WHITESPACE, g_param_spec_boolean ("ignore-whitespace", "ignore-whitespace", "ignore-whitespace", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_CHANGES_INLINE, g_param_spec_boolean ("changes-inline", "changes-inline", "changes-inline", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_CONTEXT_LINES, g_param_spec_int ("context-lines", "context-lines", "context-lines", G_MININT, G_MAXINT, 3, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	GitgDiffView_private_offset = g_type_class_get_instance_private_offset (klass);
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-diff-view.ui");
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_signal_new ("options_changed", GITG_TYPE_DIFF_VIEW, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgDiffViewClass, options_changed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "commit_details", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_commit_details));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scrolledwindow", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_scrolledwindow));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid_files", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_grid_files));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "event_box", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_event_box));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "revealer_options", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_revealer_options));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "diff_view_options", FALSE, GitgDiffView_private_offset + G_STRUCT_OFFSET (GitgDiffViewPrivate, d_diff_view_options));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "leave_notify_event_on_event_box", G_CALLBACK(_gitg_diff_view_leave_notify_event_on_event_box_gtk_widget_leave_notify_event));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "enter_notify_event_on_event_box", G_CALLBACK(_gitg_diff_view_enter_notify_event_on_event_box_gtk_widget_enter_notify_event));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "motion_notify_event_on_event_box", G_CALLBACK(_gitg_diff_view_motion_notify_event_on_event_box_gtk_widget_motion_notify_event));
#line 3414 "gitg-diff-view.c"
}


static void gitg_diff_view_instance_init (GitgDiffView * self) {
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv = GITG_DIFF_VIEW_GET_PRIVATE (self);
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_wrap_lines = TRUE;
#line 109 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_staged = FALSE;
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_unstaged = FALSE;
#line 111 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_show_parents = FALSE;
#line 112 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_default_collapse_all = TRUE;
#line 113 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_use_gravatar = TRUE;
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_tab_width = 4;
#line 115 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_handle_selection = FALSE;
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self->priv->_highlight = TRUE;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_type_ensure (GITG_TYPE_DIFF_VIEW_OPTIONS);
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	g_type_ensure (GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS);
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 3445 "gitg-diff-view.c"
}


static void gitg_diff_view_finalize (GObject* obj) {
	GitgDiffView * self;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_VIEW, GitgDiffView);
#line 24 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_commit_details);
#line 27 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_scrolledwindow);
#line 30 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_grid_files);
#line 33 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_event_box);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_revealer_options);
#line 39 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_diff_view_options);
#line 41 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_diff);
#line 42 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_commit);
#line 43 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_options);
#line 44 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->d_cancellable);
#line 117 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	_g_object_unref0 (self->priv->_repository);
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	G_OBJECT_CLASS (gitg_diff_view_parent_class)->finalize (obj);
#line 3477 "gitg-diff-view.c"
}


GType gitg_diff_view_get_type (void) {
	static volatile gsize gitg_diff_view_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_diff_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgDiffViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_diff_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDiffView), 0, (GInstanceInitFunc) gitg_diff_view_instance_init, NULL };
		GType gitg_diff_view_type_id;
		gitg_diff_view_type_id = g_type_register_static (gtk_grid_get_type (), "GitgDiffView", &g_define_type_info, 0);
		g_once_init_leave (&gitg_diff_view_type_id__volatile, gitg_diff_view_type_id);
	}
	return gitg_diff_view_type_id__volatile;
}


static void _vala_gitg_diff_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgDiffView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW, GitgDiffView);
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	switch (property_id) {
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_OPTIONS:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_object (value, gitg_diff_view_get_options (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HAS_SELECTION:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_has_selection (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_DIFF:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_object (value, gitg_diff_view_get_diff (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_COMMIT:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_object (value, gitg_diff_view_get_commit (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_WRAP_LINES:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_wrap_lines (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_STAGED:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_staged (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_UNSTAGED:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_unstaged (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_SHOW_PARENTS:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_show_parents (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_default_collapse_all (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_USE_GRAVATAR:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_use_gravatar (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_TAB_WIDTH:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_int (value, gitg_diff_view_get_tab_width (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HANDLE_SELECTION:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_handle_selection (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HIGHLIGHT:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_highlight (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_REPOSITORY:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_object (value, gitg_diff_view_get_repository (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_NEW_IS_WORKDIR:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_new_is_workdir (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_IGNORE_WHITESPACE:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_ignore_whitespace (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_CHANGES_INLINE:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_boolean (value, gitg_diff_view_get_changes_inline (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_CONTEXT_LINES:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		g_value_set_int (value, gitg_diff_view_get_context_lines (self));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 3606 "gitg-diff-view.c"
		default:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 3612 "gitg-diff-view.c"
	}
}


static void _vala_gitg_diff_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgDiffView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW, GitgDiffView);
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
	switch (property_id) {
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HAS_SELECTION:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_has_selection (self, g_value_get_boolean (value));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_DIFF:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_diff (self, g_value_get_object (value));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_COMMIT:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_commit (self, g_value_get_object (value));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_WRAP_LINES:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_wrap_lines (self, g_value_get_boolean (value));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_STAGED:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_staged (self, g_value_get_boolean (value));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_UNSTAGED:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_unstaged (self, g_value_get_boolean (value));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_SHOW_PARENTS:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_show_parents (self, g_value_get_boolean (value));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_DEFAULT_COLLAPSE_ALL:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_default_collapse_all (self, g_value_get_boolean (value));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_USE_GRAVATAR:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_use_gravatar (self, g_value_get_boolean (value));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_TAB_WIDTH:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_tab_width (self, g_value_get_int (value));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HANDLE_SELECTION:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_handle_selection (self, g_value_get_boolean (value));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_HIGHLIGHT:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_highlight (self, g_value_get_boolean (value));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_REPOSITORY:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_repository (self, g_value_get_object (value));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_NEW_IS_WORKDIR:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_new_is_workdir (self, g_value_get_boolean (value));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_IGNORE_WHITESPACE:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_ignore_whitespace (self, g_value_get_boolean (value));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_CHANGES_INLINE:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_changes_inline (self, g_value_get_boolean (value));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		case GITG_DIFF_VIEW_CONTEXT_LINES:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		gitg_diff_view_set_context_lines (self, g_value_get_int (value));
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 3724 "gitg-diff-view.c"
		default:
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-diff-view.vala"
		break;
#line 3730 "gitg-diff-view.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



