/* nibbles-game.c generated by valac 0.30.0.7-cbd7, the Vala compiler
 * generated from nibbles-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* This is a fairly literal translation of the LGPLv2+ original by*/
/* Sean MacIsaac, Ian Peters, Guillaume Béland.*/

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <time.h>
#include <string.h>


#define TYPE_GAME_STATUS (game_status_get_type ())

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
typedef struct _NibblesGamePrivate NibblesGamePrivate;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_BONI (boni_get_type ())
#define BONI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONI, Boni))
#define BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONI, BoniClass))
#define IS_BONI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONI))
#define IS_BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONI))
#define BONI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONI, BoniClass))

typedef struct _Boni Boni;
typedef struct _BoniClass BoniClass;

#define TYPE_WARP_MANAGER (warp_manager_get_type ())
#define WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_MANAGER, WarpManager))
#define WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_MANAGER, WarpManagerClass))
#define IS_WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_MANAGER))
#define IS_WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_MANAGER))
#define WARP_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_MANAGER, WarpManagerClass))

typedef struct _WarpManager WarpManager;
typedef struct _WarpManagerClass WarpManagerClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _WormPrivate WormPrivate;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())
typedef struct _BoniPrivate BoniPrivate;

#define TYPE_BONUS (bonus_get_type ())
#define BONUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS, Bonus))
#define BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS, BonusClass))
#define IS_BONUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS))
#define IS_BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS))
#define BONUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS, BonusClass))

typedef struct _Bonus Bonus;
typedef struct _BonusClass BonusClass;
typedef struct _BonusPrivate BonusPrivate;

#define TYPE_BONUS_TYPE (bonus_type_get_type ())

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;

#define TYPE_WARP (warp_get_type ())
#define WARP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP, Warp))
#define WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP, WarpClass))
#define IS_WARP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP))
#define IS_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP))
#define WARP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP, WarpClass))

typedef struct _Warp Warp;
typedef struct _WarpClass WarpClass;

typedef enum  {
	GAME_STATUS_GAMEOVER,
	GAME_STATUS_VICTORY,
	GAME_STATUS_NEWROUND
} GameStatus;

struct _NibblesGame {
	GObject parent_instance;
	NibblesGamePrivate * priv;
	gint* board;
	gint board_length1;
	gint board_length2;
};

struct _NibblesGameClass {
	GObjectClass parent_class;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _NibblesGamePrivate {
	gint _start_level;
	gint _current_level;
	gint _speed;
	gint _tile_size;
	gint _numhumans;
	gint numai;
	gint _numworms;
	GeeLinkedList* _worms;
	Boni* _boni;
	WarpManager* _warp_manager;
	GeeHashMap* _worm_props;
	gboolean _is_running;
	gboolean _is_paused;
	guint main_id;
	guint add_bonus_id;
	gboolean _fakes;
};

typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _Boni {
	GObject parent_instance;
	BoniPrivate * priv;
	GeeLinkedList* bonuses;
	gint missed;
	gint numleft;
	gint numboni;
	gint numbonuses;
};

struct _BoniClass {
	GObjectClass parent_class;
};

typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_CUT,
	BONUS_TYPE_SWITCH,
	BONUS_TYPE_WARP
} BonusType;

struct _Bonus {
	GObject parent_instance;
	BonusPrivate * priv;
	gint x;
	gint y;
	BonusType type;
	gboolean fake;
	gint countdown;
};

struct _BonusClass {
	GObjectClass parent_class;
};

struct _Position {
	gint x;
	gint y;
};


static gpointer nibbles_game_parent_class = NULL;

GType game_status_get_type (void) G_GNUC_CONST;
GType nibbles_game_get_type (void) G_GNUC_CONST;
GType worm_get_type (void) G_GNUC_CONST;
GType boni_get_type (void) G_GNUC_CONST;
GType warp_manager_get_type (void) G_GNUC_CONST;
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
#define NIBBLES_GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NIBBLES_GAME, NibblesGamePrivate))
enum  {
	NIBBLES_GAME_DUMMY_PROPERTY,
	NIBBLES_GAME_START_LEVEL,
	NIBBLES_GAME_CURRENT_LEVEL,
	NIBBLES_GAME_SPEED,
	NIBBLES_GAME_TILE_SIZE,
	NIBBLES_GAME_NUMHUMANS,
	NIBBLES_GAME_NUMWORMS,
	NIBBLES_GAME_WORMS,
	NIBBLES_GAME_BONI,
	NIBBLES_GAME_WARP_MANAGER,
	NIBBLES_GAME_WORM_PROPS,
	NIBBLES_GAME_IS_RUNNING,
	NIBBLES_GAME_IS_PAUSED,
	NIBBLES_GAME_FAKES
};
#define NIBBLES_GAME_MINIMUM_TILE_SIZE 7
#define NIBBLES_GAME_GAMEDELAY 35
#define NIBBLES_GAME_BONUSDELAY 100
#define NIBBLES_GAME_MAX_HUMANS 4
#define NIBBLES_GAME_MAX_AI 5
#define NIBBLES_GAME_MAX_WORMS 6
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
#define NIBBLES_GAME_CAPACITY (NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT)
#define NIBBLES_GAME_EMPTYCHAR 'a'
#define NIBBLES_GAME_WORMCHAR 'w'
#define NIBBLES_GAME_WARPCHAR 'W'
#define NIBBLES_GAME_MAX_LEVEL 26
NibblesGame* nibbles_game_new (GSettings* settings);
NibblesGame* nibbles_game_construct (GType object_type, GSettings* settings);
gint nibbles_game_get_numworms (NibblesGame* self);
Boni* boni_new (gint numworms);
Boni* boni_construct (GType object_type, gint numworms);
static void nibbles_game_set_boni (NibblesGame* self, Boni* value);
WarpManager* warp_manager_new (void);
WarpManager* warp_manager_construct (GType object_type);
static void nibbles_game_set_warp_manager (NibblesGame* self, WarpManager* value);
static void nibbles_game_set_worms (NibblesGame* self, GeeLinkedList* value);
static void nibbles_game_set_worm_props (NibblesGame* self, GeeHashMap* value);
static void nibbles_game_set_is_paused (NibblesGame* self, gboolean value);
void nibbles_game_load_properties (NibblesGame* self, GSettings* settings);
gint nibbles_game_get_start_level (NibblesGame* self);
static void nibbles_game_set_current_level (NibblesGame* self, gint value);
void nibbles_game_start (NibblesGame* self);
static void nibbles_game_set_is_running (NibblesGame* self, gboolean value);
gint nibbles_game_get_speed (NibblesGame* self);
gboolean nibbles_game_main_loop_cb (NibblesGame* self);
static gboolean _nibbles_game_main_loop_cb_gsource_func (gpointer self);
gboolean nibbles_game_add_bonus_cb (NibblesGame* self);
static gboolean _nibbles_game_add_bonus_cb_gsource_func (gpointer self);
void nibbles_game_stop (NibblesGame* self);
void nibbles_game_pause (NibblesGame* self);
void nibbles_game_unpause (NibblesGame* self);
void nibbles_game_reset (NibblesGame* self);
static void nibbles_game_end (NibblesGame* self);
GameStatus* nibbles_game_get_game_status (NibblesGame* self);
static gboolean _game_status_equal (const GameStatus* s1, const GameStatus* s2);
GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
gint worm_get_score (Worm* self);
Worm* nibbles_game_get_winner (NibblesGame* self);
gint nibbles_game_get_current_level (NibblesGame* self);
void nibbles_game_move_worms (NibblesGame* self);
void nibbles_game_create_worms (NibblesGame* self);
gint nibbles_game_get_numhumans (NibblesGame* self);
static void nibbles_game_set_numworms (NibblesGame* self, gint value);
Worm* worm_new (gint id);
Worm* worm_construct (GType object_type, gint id);
void nibbles_game_bonus_found_cb (NibblesGame* self, Worm* worm);
static void _nibbles_game_bonus_found_cb_worm_bonus_found (Worm* _sender, gpointer self);
void nibbles_game_warp_found_cb (NibblesGame* self, Worm* worm);
static void _nibbles_game_warp_found_cb_worm_warp_found (Worm* _sender, gpointer self);
GType worm_direction_get_type (void) G_GNUC_CONST;
void nibbles_game_add_worms (NibblesGame* self);
void worm_spawn (Worm* self, gint* board, int board_length1, int board_length2);
Boni* nibbles_game_get_boni (NibblesGame* self);
GType bonus_get_type (void) G_GNUC_CONST;
#define BONI_MAX_MISSED 2
void worm_set_score (Worm* self, gint value);
GType bonus_type_get_type (void) G_GNUC_CONST;
void boni_remove_bonus (Boni* self, gint* board, int board_length1, int board_length2, Bonus* bonus);
void nibbles_game_add_bonus (NibblesGame* self, gboolean regular);
GType position_get_type (void) G_GNUC_CONST;
Position* position_dup (const Position* self);
void position_free (Position* self);
GeeLinkedList* worm_get_list (Worm* self);
void worm_ai_move (Worm* self, gint* board, int board_length1, int board_length2, gint numworms, GeeLinkedList* worms);
gboolean worm_will_collide_with_head (Worm* self, Worm* other_worm);
gboolean worm_can_move_to (Worm* self, gint* board, int board_length1, int board_length2, gint numworms);
void worm_move (Worm* self, gint* board, int board_length1, int board_length2);
gint worm_get_lives (Worm* self);
void worm_reset (Worm* self, gint* board, int board_length1, int board_length2);
static void nibbles_game_reverse_worms (NibblesGame* self, Worm* worm);
void worm_reverse (Worm* self, gint* board, int board_length1, int board_length2);
gboolean nibbles_game_get_fakes (NibblesGame* self);
void boni_add_bonus (Boni* self, gint* board, int board_length1, int board_length2, gint x, gint y, BonusType type, gboolean fake, gint countdown);
void nibbles_game_apply_bonus (NibblesGame* self, Bonus* bonus, Worm* worm);
void worm_get_head (Worm* self, Position* result);
#define WORM_GROW_FACTOR 4
gint worm_get_length (Worm* self);
void worm_reduce_tail (Worm* self, gint* board, int board_length1, int board_length2, gint erase_size);
void worm_add_life (Worm* self);
Bonus* boni_get_bonus (Boni* self, gint* board, int board_length1, int board_length2, gint x, gint y);
GType warp_get_type (void) G_GNUC_CONST;
WarpManager* nibbles_game_get_warp_manager (NibblesGame* self);
Warp* warp_manager_get_warp (WarpManager* self, gint x, gint y);
void worm_warp (Worm* self, Warp* warp);
static GameStatus* _game_status_dup (GameStatus* self);
void nibbles_game_set_tile_size (NibblesGame* self, gint value);
static void nibbles_game_set_start_level (NibblesGame* self, gint value);
void nibbles_game_save_properties (NibblesGame* self, GSettings* settings);
gint nibbles_game_get_tile_size (NibblesGame* self);
void nibbles_game_load_worm_properties (NibblesGame* self, GeeArrayList* worm_settings);
GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
gint nibbles_view_colorval_from_name (const gchar* name);
gint worm_get_id (Worm* self);
gboolean nibbles_game_handle_keypress (NibblesGame* self, guint keyval);
gboolean nibbles_game_get_is_running (NibblesGame* self);
gboolean worm_handle_keypress (Worm* self, guint keyval, GeeHashMap* worm_props);
static void nibbles_game_set_speed (NibblesGame* self, gint value);
void nibbles_game_set_numhumans (NibblesGame* self, gint value);
gboolean nibbles_game_get_is_paused (NibblesGame* self);
static void nibbles_game_set_fakes (NibblesGame* self, gboolean value);
static void nibbles_game_finalize (GObject* obj);
static void _vala_nibbles_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_nibbles_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType game_status_get_type (void) {
	static volatile gsize game_status_type_id__volatile = 0;
	if (g_once_init_enter (&game_status_type_id__volatile)) {
		static const GEnumValue values[] = {{GAME_STATUS_GAMEOVER, "GAME_STATUS_GAMEOVER", "gameover"}, {GAME_STATUS_VICTORY, "GAME_STATUS_VICTORY", "victory"}, {GAME_STATUS_NEWROUND, "GAME_STATUS_NEWROUND", "newround"}, {0, NULL, NULL}};
		GType game_status_type_id;
		game_status_type_id = g_enum_register_static ("GameStatus", values);
		g_once_init_leave (&game_status_type_id__volatile, game_status_type_id);
	}
	return game_status_type_id__volatile;
}


NibblesGame* nibbles_game_construct (GType object_type, GSettings* settings) {
	NibblesGame * self = NULL;
	gint _tmp0_ = 0;
	Boni* _tmp1_ = NULL;
	Boni* _tmp2_ = NULL;
	WarpManager* _tmp3_ = NULL;
	WarpManager* _tmp4_ = NULL;
	gint* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	GeeHashMap* _tmp8_ = NULL;
	GeeHashMap* _tmp9_ = NULL;
	time_t _tmp10_ = 0;
	GSettings* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (NibblesGame*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->_numworms;
	_tmp1_ = boni_new (_tmp0_);
	_tmp2_ = _tmp1_;
	nibbles_game_set_boni (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = warp_manager_new ();
	_tmp4_ = _tmp3_;
	nibbles_game_set_warp_manager (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = g_new0 (gint, NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT);
	self->board = (g_free (self->board), NULL);
	self->board = _tmp5_;
	self->board_length1 = NIBBLES_GAME_WIDTH;
	self->board_length2 = NIBBLES_GAME_HEIGHT;
	_tmp6_ = gee_linked_list_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_tmp7_ = _tmp6_;
	nibbles_game_set_worms (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = gee_hash_map_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, g_object_unref, TYPE_WORM_PROPERTIES, (GBoxedCopyFunc) worm_properties_dup, worm_properties_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp9_ = _tmp8_;
	nibbles_game_set_worm_props (self, _tmp9_);
	_g_object_unref0 (_tmp9_);
	nibbles_game_set_is_paused (self, FALSE);
	_tmp10_ = time (NULL);
	g_random_set_seed ((guint32) _tmp10_);
	_tmp11_ = settings;
	nibbles_game_load_properties (self, _tmp11_);
	_tmp12_ = self->priv->_start_level;
	nibbles_game_set_current_level (self, _tmp12_);
	return self;
}


NibblesGame* nibbles_game_new (GSettings* settings) {
	return nibbles_game_construct (TYPE_NIBBLES_GAME, settings);
}


static gboolean _nibbles_game_main_loop_cb_gsource_func (gpointer self) {
	gboolean result;
	result = nibbles_game_main_loop_cb ((NibblesGame*) self);
	return result;
}


static gboolean _nibbles_game_add_bonus_cb_gsource_func (gpointer self) {
	gboolean result;
	result = nibbles_game_add_bonus_cb ((NibblesGame*) self);
	return result;
}


void nibbles_game_start (NibblesGame* self) {
	gint _tmp0_ = 0;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	gint _tmp3_ = 0;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	g_return_if_fail (self != NULL);
	nibbles_game_set_is_running (self, TRUE);
	_tmp0_ = self->priv->_speed;
	_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (NIBBLES_GAME_GAMEDELAY * _tmp0_), _nibbles_game_main_loop_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->main_id = _tmp1_;
	_tmp2_ = self->priv->main_id;
	g_source_set_name_by_id (_tmp2_, "[Nibbles] main_loop_cb");
	_tmp3_ = self->priv->_speed;
	_tmp4_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (NIBBLES_GAME_BONUSDELAY * _tmp3_), _nibbles_game_add_bonus_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->add_bonus_id = _tmp4_;
	_tmp5_ = self->priv->add_bonus_id;
	g_source_set_name_by_id (_tmp5_, "[Nibbles] add_bonus_cb");
}


void nibbles_game_stop (NibblesGame* self) {
	guint _tmp0_ = 0U;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	nibbles_game_set_is_running (self, FALSE);
	_tmp0_ = self->priv->main_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->main_id;
		g_source_remove (_tmp1_);
		self->priv->main_id = (guint) 0;
	}
	_tmp2_ = self->priv->add_bonus_id;
	if (_tmp2_ != ((guint) 0)) {
		guint _tmp3_ = 0U;
		_tmp3_ = self->priv->add_bonus_id;
		g_source_remove (_tmp3_);
		self->priv->add_bonus_id = (guint) 0;
	}
}


void nibbles_game_pause (NibblesGame* self) {
	g_return_if_fail (self != NULL);
	nibbles_game_set_is_paused (self, TRUE);
	nibbles_game_stop (self);
}


void nibbles_game_unpause (NibblesGame* self) {
	g_return_if_fail (self != NULL);
	nibbles_game_set_is_paused (self, FALSE);
	nibbles_game_start (self);
}


void nibbles_game_reset (NibblesGame* self) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_start_level;
	nibbles_game_set_current_level (self, _tmp0_);
}


static void nibbles_game_end (NibblesGame* self) {
	g_return_if_fail (self != NULL);
	nibbles_game_stop (self);
	g_signal_emit_by_name (self, "animate-end-game");
}


static gboolean _game_status_equal (const GameStatus* s1, const GameStatus* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


gboolean nibbles_game_main_loop_cb (NibblesGame* self) {
	gboolean result = FALSE;
	GameStatus* status = NULL;
	GameStatus* _tmp0_ = NULL;
	GameStatus* _tmp1_ = NULL;
	GameStatus _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = nibbles_game_get_game_status (self);
	status = _tmp0_;
	_tmp1_ = status;
	_tmp2_ = GAME_STATUS_GAMEOVER;
	if (_game_status_equal (_tmp1_, &_tmp2_) == TRUE) {
		GeeLinkedList* _tmp3_ = NULL;
		gpointer _tmp4_ = NULL;
		Worm* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		nibbles_game_end (self);
		_tmp3_ = self->priv->_worms;
		_tmp4_ = gee_linked_list_first (_tmp3_);
		_tmp5_ = (Worm*) _tmp4_;
		_tmp6_ = worm_get_score (_tmp5_);
		_tmp7_ = _tmp6_;
		g_signal_emit_by_name (self, "log-score", _tmp7_);
		_g_object_unref0 (_tmp5_);
		result = G_SOURCE_REMOVE;
		_g_free0 (status);
		return result;
	} else {
		GameStatus* _tmp8_ = NULL;
		GameStatus _tmp9_ = 0;
		_tmp8_ = status;
		_tmp9_ = GAME_STATUS_VICTORY;
		if (_game_status_equal (_tmp8_, &_tmp9_) == TRUE) {
			Worm* winner = NULL;
			Worm* _tmp10_ = NULL;
			Worm* _tmp11_ = NULL;
			Worm* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			nibbles_game_end (self);
			_tmp10_ = nibbles_game_get_winner (self);
			winner = _tmp10_;
			_tmp11_ = winner;
			if (_tmp11_ == NULL) {
				result = G_SOURCE_REMOVE;
				_g_object_unref0 (winner);
				_g_free0 (status);
				return result;
			}
			_tmp12_ = winner;
			_tmp13_ = worm_get_score (_tmp12_);
			_tmp14_ = _tmp13_;
			g_signal_emit_by_name (self, "log-score", _tmp14_);
			result = G_SOURCE_REMOVE;
			_g_object_unref0 (winner);
			_g_free0 (status);
			return result;
		} else {
			GameStatus* _tmp15_ = NULL;
			GameStatus _tmp16_ = 0;
			_tmp15_ = status;
			_tmp16_ = GAME_STATUS_NEWROUND;
			if (_game_status_equal (_tmp15_, &_tmp16_) == TRUE) {
				gint _tmp17_ = 0;
				nibbles_game_stop (self);
				g_signal_emit_by_name (self, "animate-end-game");
				g_signal_emit_by_name (self, "level-completed");
				_tmp17_ = self->priv->_current_level;
				if (_tmp17_ < NIBBLES_GAME_MAX_LEVEL) {
					gint _tmp18_ = 0;
					_tmp18_ = self->priv->_current_level;
					nibbles_game_set_current_level (self, _tmp18_ + 1);
				}
				result = G_SOURCE_REMOVE;
				_g_free0 (status);
				return result;
			}
		}
	}
	nibbles_game_move_worms (self);
	result = G_SOURCE_CONTINUE;
	_g_free0 (status);
	return result;
}


static void _nibbles_game_bonus_found_cb_worm_bonus_found (Worm* _sender, gpointer self) {
	nibbles_game_bonus_found_cb ((NibblesGame*) self, _sender);
}


static void _nibbles_game_warp_found_cb_worm_warp_found (Worm* _sender, gpointer self) {
	nibbles_game_warp_found_cb ((NibblesGame*) self, _sender);
}


void nibbles_game_create_worms (NibblesGame* self) {
	GeeLinkedList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_worms;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->numai;
	_tmp2_ = self->priv->_numhumans;
	nibbles_game_set_numworms (self, _tmp1_ + _tmp2_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				Worm* worm = NULL;
				gint _tmp7_ = 0;
				Worm* _tmp8_ = NULL;
				Worm* _tmp9_ = NULL;
				Worm* _tmp10_ = NULL;
				Worm* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				GeeLinkedList* _tmp14_ = NULL;
				Worm* _tmp15_ = NULL;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->_numworms;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = i;
				_tmp8_ = worm_new (_tmp7_);
				worm = _tmp8_;
				_tmp9_ = worm;
				g_signal_connect_object (_tmp9_, "bonus-found", (GCallback) _nibbles_game_bonus_found_cb_worm_bonus_found, self, 0);
				_tmp10_ = worm;
				g_signal_connect_object (_tmp10_, "warp-found", (GCallback) _nibbles_game_warp_found_cb_worm_warp_found, self, 0);
				_tmp11_ = worm;
				_tmp12_ = i;
				_tmp13_ = self->priv->_numhumans;
				_tmp11_->is_human = _tmp12_ < _tmp13_;
				_tmp14_ = self->priv->_worms;
				_tmp15_ = worm;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
				_g_object_unref0 (worm);
			}
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void nibbles_game_add_worms (NibblesGame* self) {
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_worm_list = _tmp1_;
		_tmp2_ = _worm_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_worm_size = _tmp4_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Worm* _tmp11_ = NULL;
			Worm* _tmp12_ = NULL;
			gint* _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			gint _tmp13__length2 = 0;
			_tmp5_ = _worm_index;
			_worm_index = _tmp5_ + 1;
			_tmp6_ = _worm_index;
			_tmp7_ = _worm_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _worm_list;
			_tmp9_ = _worm_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			worm = (Worm*) _tmp10_;
			_tmp11_ = worm;
			g_signal_emit_by_name (_tmp11_, "added");
			_tmp12_ = worm;
			_tmp13_ = self->board;
			_tmp13__length1 = self->board_length1;
			_tmp13__length2 = self->board_length2;
			worm_spawn (_tmp12_, _tmp13_, _tmp13__length1, _tmp13__length2);
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
}


void nibbles_game_move_worms (NibblesGame* self) {
	Boni* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GeeLinkedList* found = NULL;
	GeeLinkedList* _tmp19_ = NULL;
	Boni* _tmp51_ = NULL;
	GeeLinkedList* _tmp52_ = NULL;
	GeeLinkedList* _tmp53_ = NULL;
	GeeLinkedList* dead_worms = NULL;
	GeeLinkedList* _tmp54_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_boni;
	_tmp1_ = _tmp0_->missed;
	if (_tmp1_ > BONI_MAX_MISSED) {
		{
			GeeLinkedList* _worm_list = NULL;
			GeeLinkedList* _tmp2_ = NULL;
			GeeLinkedList* _tmp3_ = NULL;
			gint _worm_size = 0;
			GeeLinkedList* _tmp4_ = NULL;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _worm_index = 0;
			_tmp2_ = self->priv->_worms;
			_tmp3_ = _g_object_ref0 (_tmp2_);
			_worm_list = _tmp3_;
			_tmp4_ = _worm_list;
			_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_worm_size = _tmp6_;
			_worm_index = -1;
			while (TRUE) {
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				Worm* worm = NULL;
				GeeLinkedList* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gpointer _tmp12_ = NULL;
				Worm* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				_tmp7_ = _worm_index;
				_worm_index = _tmp7_ + 1;
				_tmp8_ = _worm_index;
				_tmp9_ = _worm_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _worm_list;
				_tmp11_ = _worm_index;
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
				worm = (Worm*) _tmp12_;
				_tmp13_ = worm;
				_tmp14_ = worm_get_score (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ > 0) {
					Worm* _tmp16_ = NULL;
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					_tmp16_ = worm;
					_tmp17_ = worm_get_score (_tmp16_);
					_tmp18_ = _tmp17_;
					worm_set_score (_tmp16_, _tmp18_ - 1);
				}
				_g_object_unref0 (worm);
			}
			_g_object_unref0 (_worm_list);
		}
	}
	_tmp19_ = gee_linked_list_new (TYPE_BONUS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	found = _tmp19_;
	{
		GeeLinkedList* _bonus_list = NULL;
		Boni* _tmp20_ = NULL;
		GeeLinkedList* _tmp21_ = NULL;
		GeeLinkedList* _tmp22_ = NULL;
		gint _bonus_size = 0;
		GeeLinkedList* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gint _bonus_index = 0;
		_tmp20_ = self->priv->_boni;
		_tmp21_ = _tmp20_->bonuses;
		_tmp22_ = _g_object_ref0 (_tmp21_);
		_bonus_list = _tmp22_;
		_tmp23_ = _bonus_list;
		_tmp24_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_bonus_size = _tmp25_;
		_bonus_index = -1;
		while (TRUE) {
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			Bonus* bonus = NULL;
			GeeLinkedList* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gpointer _tmp31_ = NULL;
			Bonus* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			_tmp26_ = _bonus_index;
			_bonus_index = _tmp26_ + 1;
			_tmp27_ = _bonus_index;
			_tmp28_ = _bonus_size;
			if (!(_tmp27_ < _tmp28_)) {
				break;
			}
			_tmp29_ = _bonus_list;
			_tmp30_ = _bonus_index;
			_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _tmp30_);
			bonus = (Bonus*) _tmp31_;
			_tmp32_ = bonus;
			_tmp33_ = _tmp32_->countdown;
			_tmp32_->countdown = _tmp33_ - 1;
			if (_tmp33_ == 0) {
				gboolean _tmp34_ = FALSE;
				Bonus* _tmp35_ = NULL;
				BonusType _tmp36_ = 0;
				_tmp35_ = bonus;
				_tmp36_ = _tmp35_->type;
				if (_tmp36_ == BONUS_TYPE_REGULAR) {
					Bonus* _tmp37_ = NULL;
					gboolean _tmp38_ = FALSE;
					_tmp37_ = bonus;
					_tmp38_ = _tmp37_->fake;
					_tmp34_ = !_tmp38_;
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					GeeLinkedList* _tmp39_ = NULL;
					Bonus* _tmp40_ = NULL;
					Boni* _tmp41_ = NULL;
					gint* _tmp42_ = NULL;
					gint _tmp42__length1 = 0;
					gint _tmp42__length2 = 0;
					Bonus* _tmp43_ = NULL;
					Boni* _tmp44_ = NULL;
					gint _tmp45_ = 0;
					_tmp39_ = found;
					_tmp40_ = bonus;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp40_);
					_tmp41_ = self->priv->_boni;
					_tmp42_ = self->board;
					_tmp42__length1 = self->board_length1;
					_tmp42__length2 = self->board_length2;
					_tmp43_ = bonus;
					boni_remove_bonus (_tmp41_, _tmp42_, _tmp42__length1, _tmp42__length2, _tmp43_);
					_tmp44_ = self->priv->_boni;
					_tmp45_ = _tmp44_->missed;
					_tmp44_->missed = _tmp45_ + 1;
					nibbles_game_add_bonus (self, TRUE);
				} else {
					GeeLinkedList* _tmp46_ = NULL;
					Bonus* _tmp47_ = NULL;
					Boni* _tmp48_ = NULL;
					gint* _tmp49_ = NULL;
					gint _tmp49__length1 = 0;
					gint _tmp49__length2 = 0;
					Bonus* _tmp50_ = NULL;
					_tmp46_ = found;
					_tmp47_ = bonus;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, _tmp47_);
					_tmp48_ = self->priv->_boni;
					_tmp49_ = self->board;
					_tmp49__length1 = self->board_length1;
					_tmp49__length2 = self->board_length2;
					_tmp50_ = bonus;
					boni_remove_bonus (_tmp48_, _tmp49_, _tmp49__length1, _tmp49__length2, _tmp50_);
				}
			}
			_g_object_unref0 (bonus);
		}
		_g_object_unref0 (_bonus_list);
	}
	_tmp51_ = self->priv->_boni;
	_tmp52_ = _tmp51_->bonuses;
	_tmp53_ = found;
	gee_collection_remove_all ((GeeCollection*) _tmp52_, (GeeCollection*) _tmp53_);
	_tmp54_ = gee_linked_list_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	dead_worms = _tmp54_;
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp55_ = NULL;
		GeeLinkedList* _tmp56_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp57_ = NULL;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
		gint _worm_index = 0;
		_tmp55_ = self->priv->_worms;
		_tmp56_ = _g_object_ref0 (_tmp55_);
		_worm_list = _tmp56_;
		_tmp57_ = _worm_list;
		_tmp58_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_worm_size = _tmp59_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp60_ = 0;
			gint _tmp61_ = 0;
			gint _tmp62_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp63_ = NULL;
			gint _tmp64_ = 0;
			gpointer _tmp65_ = NULL;
			Worm* _tmp66_ = NULL;
			gboolean _tmp67_ = FALSE;
			Worm* _tmp68_ = NULL;
			GeeLinkedList* _tmp69_ = NULL;
			GeeLinkedList* _tmp70_ = NULL;
			gboolean _tmp71_ = FALSE;
			gboolean _tmp72_ = FALSE;
			Worm* _tmp73_ = NULL;
			gboolean _tmp74_ = FALSE;
			Worm* _tmp109_ = NULL;
			gint* _tmp110_ = NULL;
			gint _tmp110__length1 = 0;
			gint _tmp110__length2 = 0;
			gint _tmp111_ = 0;
			gboolean _tmp112_ = FALSE;
			Worm* _tmp115_ = NULL;
			gint* _tmp116_ = NULL;
			gint _tmp116__length1 = 0;
			gint _tmp116__length2 = 0;
			_tmp60_ = _worm_index;
			_worm_index = _tmp60_ + 1;
			_tmp61_ = _worm_index;
			_tmp62_ = _worm_size;
			if (!(_tmp61_ < _tmp62_)) {
				break;
			}
			_tmp63_ = _worm_list;
			_tmp64_ = _worm_index;
			_tmp65_ = gee_abstract_list_get ((GeeAbstractList*) _tmp63_, _tmp64_);
			worm = (Worm*) _tmp65_;
			_tmp66_ = worm;
			_tmp67_ = _tmp66_->is_stopped;
			if (_tmp67_) {
				_g_object_unref0 (worm);
				continue;
			}
			_tmp68_ = worm;
			_tmp69_ = worm_get_list (_tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = gee_collection_get_is_empty ((GeeCollection*) _tmp70_);
			_tmp72_ = _tmp71_;
			if (_tmp72_) {
				_g_object_unref0 (worm);
				continue;
			}
			_tmp73_ = worm;
			_tmp74_ = _tmp73_->is_human;
			if (!_tmp74_) {
				Worm* _tmp75_ = NULL;
				gint* _tmp76_ = NULL;
				gint _tmp76__length1 = 0;
				gint _tmp76__length2 = 0;
				gint _tmp77_ = 0;
				GeeLinkedList* _tmp78_ = NULL;
				_tmp75_ = worm;
				_tmp76_ = self->board;
				_tmp76__length1 = self->board_length1;
				_tmp76__length2 = self->board_length2;
				_tmp77_ = self->priv->_numworms;
				_tmp78_ = self->priv->_worms;
				worm_ai_move (_tmp75_, _tmp76_, _tmp76__length1, _tmp76__length2, _tmp77_, _tmp78_);
			}
			{
				GeeLinkedList* _other_worm_list = NULL;
				GeeLinkedList* _tmp79_ = NULL;
				GeeLinkedList* _tmp80_ = NULL;
				gint _other_worm_size = 0;
				GeeLinkedList* _tmp81_ = NULL;
				gint _tmp82_ = 0;
				gint _tmp83_ = 0;
				gint _other_worm_index = 0;
				_tmp79_ = self->priv->_worms;
				_tmp80_ = _g_object_ref0 (_tmp79_);
				_other_worm_list = _tmp80_;
				_tmp81_ = _other_worm_list;
				_tmp82_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp81_);
				_tmp83_ = _tmp82_;
				_other_worm_size = _tmp83_;
				_other_worm_index = -1;
				while (TRUE) {
					gint _tmp84_ = 0;
					gint _tmp85_ = 0;
					gint _tmp86_ = 0;
					Worm* other_worm = NULL;
					GeeLinkedList* _tmp87_ = NULL;
					gint _tmp88_ = 0;
					gpointer _tmp89_ = NULL;
					gboolean _tmp90_ = FALSE;
					gboolean _tmp91_ = FALSE;
					Worm* _tmp92_ = NULL;
					Worm* _tmp93_ = NULL;
					_tmp84_ = _other_worm_index;
					_other_worm_index = _tmp84_ + 1;
					_tmp85_ = _other_worm_index;
					_tmp86_ = _other_worm_size;
					if (!(_tmp85_ < _tmp86_)) {
						break;
					}
					_tmp87_ = _other_worm_list;
					_tmp88_ = _other_worm_index;
					_tmp89_ = gee_abstract_list_get ((GeeAbstractList*) _tmp87_, _tmp88_);
					other_worm = (Worm*) _tmp89_;
					_tmp92_ = worm;
					_tmp93_ = other_worm;
					if (_tmp92_ != _tmp93_) {
						Worm* _tmp94_ = NULL;
						gboolean _tmp95_ = FALSE;
						_tmp94_ = other_worm;
						_tmp95_ = _tmp94_->is_stopped;
						_tmp91_ = !_tmp95_;
					} else {
						_tmp91_ = FALSE;
					}
					if (_tmp91_) {
						Worm* _tmp96_ = NULL;
						Worm* _tmp97_ = NULL;
						gboolean _tmp98_ = FALSE;
						_tmp96_ = worm;
						_tmp97_ = other_worm;
						_tmp98_ = worm_will_collide_with_head (_tmp96_, _tmp97_);
						_tmp90_ = _tmp98_;
					} else {
						_tmp90_ = FALSE;
					}
					if (_tmp90_) {
						GeeLinkedList* _tmp99_ = NULL;
						Worm* _tmp100_ = NULL;
						gboolean _tmp101_ = FALSE;
						GeeLinkedList* _tmp104_ = NULL;
						Worm* _tmp105_ = NULL;
						gboolean _tmp106_ = FALSE;
						_tmp99_ = dead_worms;
						_tmp100_ = worm;
						_tmp101_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp99_, _tmp100_);
						if (!_tmp101_) {
							GeeLinkedList* _tmp102_ = NULL;
							Worm* _tmp103_ = NULL;
							_tmp102_ = dead_worms;
							_tmp103_ = worm;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp102_, _tmp103_);
						}
						_tmp104_ = dead_worms;
						_tmp105_ = other_worm;
						_tmp106_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp104_, _tmp105_);
						if (!_tmp106_) {
							GeeLinkedList* _tmp107_ = NULL;
							Worm* _tmp108_ = NULL;
							_tmp107_ = dead_worms;
							_tmp108_ = other_worm;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp107_, _tmp108_);
						}
						_g_object_unref0 (other_worm);
						continue;
					}
					_g_object_unref0 (other_worm);
				}
				_g_object_unref0 (_other_worm_list);
			}
			_tmp109_ = worm;
			_tmp110_ = self->board;
			_tmp110__length1 = self->board_length1;
			_tmp110__length2 = self->board_length2;
			_tmp111_ = self->priv->_numworms;
			_tmp112_ = worm_can_move_to (_tmp109_, _tmp110_, _tmp110__length1, _tmp110__length2, _tmp111_);
			if (!_tmp112_) {
				GeeLinkedList* _tmp113_ = NULL;
				Worm* _tmp114_ = NULL;
				_tmp113_ = dead_worms;
				_tmp114_ = worm;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp113_, _tmp114_);
				_g_object_unref0 (worm);
				continue;
			}
			_tmp115_ = worm;
			_tmp116_ = self->board;
			_tmp116__length1 = self->board_length1;
			_tmp116__length2 = self->board_length2;
			worm_move (_tmp115_, _tmp116_, _tmp116__length1, _tmp116__length2);
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp117_ = NULL;
		GeeLinkedList* _tmp118_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp119_ = NULL;
		gint _tmp120_ = 0;
		gint _tmp121_ = 0;
		gint _worm_index = 0;
		_tmp117_ = dead_worms;
		_tmp118_ = _g_object_ref0 (_tmp117_);
		_worm_list = _tmp118_;
		_tmp119_ = _worm_list;
		_tmp120_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp119_);
		_tmp121_ = _tmp120_;
		_worm_size = _tmp121_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp122_ = 0;
			gint _tmp123_ = 0;
			gint _tmp124_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp125_ = NULL;
			gint _tmp126_ = 0;
			gpointer _tmp127_ = NULL;
			gint _tmp128_ = 0;
			Worm* _tmp133_ = NULL;
			gint _tmp134_ = 0;
			gint _tmp135_ = 0;
			_tmp122_ = _worm_index;
			_worm_index = _tmp122_ + 1;
			_tmp123_ = _worm_index;
			_tmp124_ = _worm_size;
			if (!(_tmp123_ < _tmp124_)) {
				break;
			}
			_tmp125_ = _worm_list;
			_tmp126_ = _worm_index;
			_tmp127_ = gee_abstract_list_get ((GeeAbstractList*) _tmp125_, _tmp126_);
			worm = (Worm*) _tmp127_;
			_tmp128_ = self->priv->_numworms;
			if (_tmp128_ > 1) {
				Worm* _tmp129_ = NULL;
				Worm* _tmp130_ = NULL;
				gint _tmp131_ = 0;
				gint _tmp132_ = 0;
				_tmp129_ = worm;
				_tmp130_ = worm;
				_tmp131_ = worm_get_score (_tmp130_);
				_tmp132_ = _tmp131_;
				worm_set_score (_tmp129_, (_tmp132_ * 7) / 10);
			}
			_tmp133_ = worm;
			_tmp134_ = worm_get_lives (_tmp133_);
			_tmp135_ = _tmp134_;
			if (_tmp135_ > 0) {
				Worm* _tmp136_ = NULL;
				gint* _tmp137_ = NULL;
				gint _tmp137__length1 = 0;
				gint _tmp137__length2 = 0;
				_tmp136_ = worm;
				_tmp137_ = self->board;
				_tmp137__length1 = self->board_length1;
				_tmp137__length2 = self->board_length2;
				worm_reset (_tmp136_, _tmp137_, _tmp137__length1, _tmp137__length2);
			}
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	_g_object_unref0 (dead_worms);
	_g_object_unref0 (found);
}


static void nibbles_game_reverse_worms (NibblesGame* self, Worm* worm) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	{
		GeeLinkedList* _other_worm_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _other_worm_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _other_worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_other_worm_list = _tmp1_;
		_tmp2_ = _other_worm_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_other_worm_size = _tmp4_;
		_other_worm_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Worm* other_worm = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Worm* _tmp11_ = NULL;
			Worm* _tmp12_ = NULL;
			_tmp5_ = _other_worm_index;
			_other_worm_index = _tmp5_ + 1;
			_tmp6_ = _other_worm_index;
			_tmp7_ = _other_worm_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _other_worm_list;
			_tmp9_ = _other_worm_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			other_worm = (Worm*) _tmp10_;
			_tmp11_ = worm;
			_tmp12_ = other_worm;
			if (_tmp11_ != _tmp12_) {
				Worm* _tmp13_ = NULL;
				gint* _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				gint _tmp14__length2 = 0;
				_tmp13_ = other_worm;
				_tmp14_ = self->board;
				_tmp14__length1 = self->board_length1;
				_tmp14__length2 = self->board_length2;
				worm_reverse (_tmp13_, _tmp14_, _tmp14__length1, _tmp14__length2);
			}
			_g_object_unref0 (other_worm);
		}
		_g_object_unref0 (_other_worm_list);
	}
}


void nibbles_game_add_bonus (NibblesGame* self, gboolean regular) {
	gboolean good = FALSE;
	gint x = 0;
	gint y = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp22_ = FALSE;
	g_return_if_fail (self != NULL);
	good = FALSE;
	x = 0;
	y = 0;
	_tmp0_ = regular;
	if (!_tmp0_) {
		gint32 _tmp1_ = 0;
		_tmp1_ = g_random_int_range ((gint32) 0, (gint32) 50);
		if (_tmp1_ != ((gint32) 0)) {
			return;
		}
	}
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			gint32 _tmp4_ = 0;
			gint32 _tmp5_ = 0;
			gint* _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			gint _tmp6__length2 = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint* _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			gint _tmp10__length2 = 0;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint* _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gint _tmp14__length2 = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			gint* _tmp18_ = NULL;
			gint _tmp18__length1 = 0;
			gint _tmp18__length2 = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			if (!_tmp2_) {
				gboolean _tmp3_ = FALSE;
				_tmp3_ = good;
				if (!(!_tmp3_)) {
					break;
				}
			}
			_tmp2_ = FALSE;
			good = TRUE;
			_tmp4_ = g_random_int_range ((gint32) 0, (gint32) (NIBBLES_GAME_WIDTH - 1));
			x = (gint) _tmp4_;
			_tmp5_ = g_random_int_range ((gint32) 0, (gint32) (NIBBLES_GAME_HEIGHT - 1));
			y = (gint) _tmp5_;
			_tmp6_ = self->board;
			_tmp6__length1 = self->board_length1;
			_tmp6__length2 = self->board_length2;
			_tmp7_ = x;
			_tmp8_ = y;
			_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
			if (_tmp9_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				good = FALSE;
			}
			_tmp10_ = self->board;
			_tmp10__length1 = self->board_length1;
			_tmp10__length2 = self->board_length2;
			_tmp11_ = x;
			_tmp12_ = y;
			_tmp13_ = _tmp10_[((_tmp11_ + 1) * _tmp10__length2) + _tmp12_];
			if (_tmp13_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				good = FALSE;
			}
			_tmp14_ = self->board;
			_tmp14__length1 = self->board_length1;
			_tmp14__length2 = self->board_length2;
			_tmp15_ = x;
			_tmp16_ = y;
			_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + (_tmp16_ + 1)];
			if (_tmp17_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				good = FALSE;
			}
			_tmp18_ = self->board;
			_tmp18__length1 = self->board_length1;
			_tmp18__length2 = self->board_length2;
			_tmp19_ = x;
			_tmp20_ = y;
			_tmp21_ = _tmp18_[((_tmp19_ + 1) * _tmp18__length2) + (_tmp20_ + 1)];
			if (_tmp21_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				good = FALSE;
			}
		}
	}
	_tmp22_ = regular;
	if (_tmp22_) {
		gboolean _tmp23_ = FALSE;
		gint32 _tmp24_ = 0;
		Boni* _tmp49_ = NULL;
		gint* _tmp50_ = NULL;
		gint _tmp50__length1 = 0;
		gint _tmp50__length2 = 0;
		gint _tmp51_ = 0;
		gint _tmp52_ = 0;
		_tmp24_ = g_random_int_range ((gint32) 0, (gint32) 7);
		if (_tmp24_ == ((gint32) 0)) {
			gboolean _tmp25_ = FALSE;
			_tmp25_ = self->priv->_fakes;
			_tmp23_ = _tmp25_;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			Boni* _tmp26_ = NULL;
			gint* _tmp27_ = NULL;
			gint _tmp27__length1 = 0;
			gint _tmp27__length2 = 0;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			_tmp26_ = self->priv->_boni;
			_tmp27_ = self->board;
			_tmp27__length1 = self->board_length1;
			_tmp27__length2 = self->board_length2;
			_tmp28_ = x;
			_tmp29_ = y;
			boni_add_bonus (_tmp26_, _tmp27_, _tmp27__length1, _tmp27__length2, _tmp28_, _tmp29_, BONUS_TYPE_REGULAR, TRUE, 300);
		}
		good = FALSE;
		while (TRUE) {
			gboolean _tmp30_ = FALSE;
			gint32 _tmp31_ = 0;
			gint32 _tmp32_ = 0;
			gint* _tmp33_ = NULL;
			gint _tmp33__length1 = 0;
			gint _tmp33__length2 = 0;
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			gint* _tmp37_ = NULL;
			gint _tmp37__length1 = 0;
			gint _tmp37__length2 = 0;
			gint _tmp38_ = 0;
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			gint* _tmp41_ = NULL;
			gint _tmp41__length1 = 0;
			gint _tmp41__length2 = 0;
			gint _tmp42_ = 0;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			gint* _tmp45_ = NULL;
			gint _tmp45__length1 = 0;
			gint _tmp45__length2 = 0;
			gint _tmp46_ = 0;
			gint _tmp47_ = 0;
			gint _tmp48_ = 0;
			_tmp30_ = good;
			if (!(!_tmp30_)) {
				break;
			}
			good = TRUE;
			_tmp31_ = g_random_int_range ((gint32) 0, (gint32) (NIBBLES_GAME_WIDTH - 1));
			x = (gint) _tmp31_;
			_tmp32_ = g_random_int_range ((gint32) 0, (gint32) (NIBBLES_GAME_HEIGHT - 1));
			y = (gint) _tmp32_;
			_tmp33_ = self->board;
			_tmp33__length1 = self->board_length1;
			_tmp33__length2 = self->board_length2;
			_tmp34_ = x;
			_tmp35_ = y;
			_tmp36_ = _tmp33_[(_tmp34_ * _tmp33__length2) + _tmp35_];
			if (_tmp36_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				good = FALSE;
			}
			_tmp37_ = self->board;
			_tmp37__length1 = self->board_length1;
			_tmp37__length2 = self->board_length2;
			_tmp38_ = x;
			_tmp39_ = y;
			_tmp40_ = _tmp37_[((_tmp38_ + 1) * _tmp37__length2) + _tmp39_];
			if (_tmp40_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				good = FALSE;
			}
			_tmp41_ = self->board;
			_tmp41__length1 = self->board_length1;
			_tmp41__length2 = self->board_length2;
			_tmp42_ = x;
			_tmp43_ = y;
			_tmp44_ = _tmp41_[(_tmp42_ * _tmp41__length2) + (_tmp43_ + 1)];
			if (_tmp44_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				good = FALSE;
			}
			_tmp45_ = self->board;
			_tmp45__length1 = self->board_length1;
			_tmp45__length2 = self->board_length2;
			_tmp46_ = x;
			_tmp47_ = y;
			_tmp48_ = _tmp45_[((_tmp46_ + 1) * _tmp45__length2) + (_tmp47_ + 1)];
			if (_tmp48_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				good = FALSE;
			}
		}
		_tmp49_ = self->priv->_boni;
		_tmp50_ = self->board;
		_tmp50__length1 = self->board_length1;
		_tmp50__length2 = self->board_length2;
		_tmp51_ = x;
		_tmp52_ = y;
		boni_add_bonus (_tmp49_, _tmp50_, _tmp50__length1, _tmp50__length2, _tmp51_, _tmp52_, BONUS_TYPE_REGULAR, FALSE, 300);
	} else {
		Boni* _tmp53_ = NULL;
		gint _tmp54_ = 0;
		_tmp53_ = self->priv->_boni;
		_tmp54_ = _tmp53_->missed;
		if (_tmp54_ <= BONI_MAX_MISSED) {
			gint32 _tmp55_ = 0;
			gboolean _tmp56_ = FALSE;
			gboolean _tmp57_ = FALSE;
			gint32 _tmp59_ = 0;
			_tmp55_ = g_random_int_range ((gint32) 0, (gint32) 7);
			if (_tmp55_ != ((gint32) 0)) {
				good = FALSE;
			} else {
				good = TRUE;
			}
			_tmp57_ = good;
			if (_tmp57_) {
				gboolean _tmp58_ = FALSE;
				_tmp58_ = self->priv->_fakes;
				_tmp56_ = !_tmp58_;
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				return;
			}
			_tmp59_ = g_random_int_range ((gint32) 0, (gint32) 21);
			switch (_tmp59_) {
				case 0:
				case 1:
				case 2:
				case 3:
				case 4:
				case 5:
				case 6:
				case 7:
				case 8:
				case 9:
				{
					Boni* _tmp60_ = NULL;
					gint* _tmp61_ = NULL;
					gint _tmp61__length1 = 0;
					gint _tmp61__length2 = 0;
					gint _tmp62_ = 0;
					gint _tmp63_ = 0;
					gboolean _tmp64_ = FALSE;
					_tmp60_ = self->priv->_boni;
					_tmp61_ = self->board;
					_tmp61__length1 = self->board_length1;
					_tmp61__length2 = self->board_length2;
					_tmp62_ = x;
					_tmp63_ = y;
					_tmp64_ = good;
					boni_add_bonus (_tmp60_, _tmp61_, _tmp61__length1, _tmp61__length2, _tmp62_, _tmp63_, BONUS_TYPE_HALF, _tmp64_, 200);
					break;
				}
				case 10:
				case 11:
				case 12:
				case 13:
				case 14:
				{
					Boni* _tmp65_ = NULL;
					gint* _tmp66_ = NULL;
					gint _tmp66__length1 = 0;
					gint _tmp66__length2 = 0;
					gint _tmp67_ = 0;
					gint _tmp68_ = 0;
					gboolean _tmp69_ = FALSE;
					_tmp65_ = self->priv->_boni;
					_tmp66_ = self->board;
					_tmp66__length1 = self->board_length1;
					_tmp66__length2 = self->board_length2;
					_tmp67_ = x;
					_tmp68_ = y;
					_tmp69_ = good;
					boni_add_bonus (_tmp65_, _tmp66_, _tmp66__length1, _tmp66__length2, _tmp67_, _tmp68_, BONUS_TYPE_DOUBLE, _tmp69_, 150);
					break;
				}
				case 15:
				{
					Boni* _tmp70_ = NULL;
					gint* _tmp71_ = NULL;
					gint _tmp71__length1 = 0;
					gint _tmp71__length2 = 0;
					gint _tmp72_ = 0;
					gint _tmp73_ = 0;
					gboolean _tmp74_ = FALSE;
					_tmp70_ = self->priv->_boni;
					_tmp71_ = self->board;
					_tmp71__length1 = self->board_length1;
					_tmp71__length2 = self->board_length2;
					_tmp72_ = x;
					_tmp73_ = y;
					_tmp74_ = good;
					boni_add_bonus (_tmp70_, _tmp71_, _tmp71__length1, _tmp71__length2, _tmp72_, _tmp73_, BONUS_TYPE_LIFE, _tmp74_, 100);
					break;
				}
				case 16:
				case 17:
				case 18:
				case 19:
				case 20:
				{
					gint _tmp75_ = 0;
					_tmp75_ = self->priv->_numworms;
					if (_tmp75_ > 1) {
						Boni* _tmp76_ = NULL;
						gint* _tmp77_ = NULL;
						gint _tmp77__length1 = 0;
						gint _tmp77__length2 = 0;
						gint _tmp78_ = 0;
						gint _tmp79_ = 0;
						gboolean _tmp80_ = FALSE;
						_tmp76_ = self->priv->_boni;
						_tmp77_ = self->board;
						_tmp77__length1 = self->board_length1;
						_tmp77__length2 = self->board_length2;
						_tmp78_ = x;
						_tmp79_ = y;
						_tmp80_ = good;
						boni_add_bonus (_tmp76_, _tmp77_, _tmp77__length1, _tmp77__length2, _tmp78_, _tmp79_, BONUS_TYPE_REVERSE, _tmp80_, 150);
					}
					break;
				}
				default:
				break;
			}
		}
	}
}


void nibbles_game_apply_bonus (NibblesGame* self, Bonus* bonus, Worm* worm) {
	Bonus* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp3__length2 = 0;
	Worm* _tmp4_ = NULL;
	Position _tmp5_ = {0};
	Position _tmp6_ = {0};
	gint _tmp7_ = 0;
	Worm* _tmp8_ = NULL;
	Position _tmp9_ = {0};
	Position _tmp10_ = {0};
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bonus != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = bonus;
	_tmp1_ = _tmp0_->fake;
	if (_tmp1_) {
		Worm* _tmp2_ = NULL;
		_tmp2_ = worm;
		nibbles_game_reverse_worms (self, _tmp2_);
		return;
	}
	_tmp3_ = self->board;
	_tmp3__length1 = self->board_length1;
	_tmp3__length2 = self->board_length2;
	_tmp4_ = worm;
	worm_get_head (_tmp4_, &_tmp5_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_.x;
	_tmp8_ = worm;
	worm_get_head (_tmp8_, &_tmp9_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_.y;
	_tmp12_ = _tmp3_[(_tmp7_ * _tmp3__length2) + _tmp11_];
	switch (_tmp12_ - 'A') {
		case BONUS_TYPE_REGULAR:
		{
			Boni* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			Worm* _tmp15_ = NULL;
			Worm* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			Boni* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			Boni* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			Worm* _tmp22_ = NULL;
			Worm* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			Boni* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			Boni* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			_tmp13_ = self->priv->_boni;
			_tmp14_ = _tmp13_->numleft;
			_tmp13_->numleft = _tmp14_ - 1;
			_tmp15_ = worm;
			_tmp16_ = worm;
			_tmp17_ = _tmp16_->change;
			_tmp18_ = self->priv->_boni;
			_tmp19_ = _tmp18_->numboni;
			_tmp20_ = self->priv->_boni;
			_tmp21_ = _tmp20_->numleft;
			_tmp16_->change = _tmp17_ + ((_tmp19_ - _tmp21_) * WORM_GROW_FACTOR);
			_tmp22_ = worm;
			_tmp23_ = worm;
			_tmp24_ = worm_get_score (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = self->priv->_boni;
			_tmp27_ = _tmp26_->numboni;
			_tmp28_ = self->priv->_boni;
			_tmp29_ = _tmp28_->numleft;
			_tmp30_ = self->priv->_current_level;
			worm_set_score (_tmp23_, _tmp25_ + ((_tmp27_ - _tmp29_) * _tmp30_));
			break;
		}
		case BONUS_TYPE_DOUBLE:
		{
			Worm* _tmp31_ = NULL;
			Worm* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			gint _tmp34_ = 0;
			Worm* _tmp35_ = NULL;
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			Worm* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			Worm* _tmp41_ = NULL;
			Worm* _tmp42_ = NULL;
			gint _tmp43_ = 0;
			Worm* _tmp44_ = NULL;
			gint _tmp45_ = 0;
			gint _tmp46_ = 0;
			Worm* _tmp47_ = NULL;
			gint _tmp48_ = 0;
			_tmp31_ = worm;
			_tmp32_ = worm;
			_tmp33_ = worm_get_score (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = worm;
			_tmp36_ = worm_get_length (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = worm;
			_tmp39_ = _tmp38_->change;
			_tmp40_ = self->priv->_current_level;
			worm_set_score (_tmp32_, _tmp34_ + ((_tmp37_ + _tmp39_) * _tmp40_));
			_tmp41_ = worm;
			_tmp42_ = worm;
			_tmp43_ = _tmp42_->change;
			_tmp44_ = worm;
			_tmp45_ = worm_get_length (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = worm;
			_tmp48_ = _tmp47_->change;
			_tmp42_->change = _tmp43_ + (_tmp46_ + _tmp48_);
			break;
		}
		case BONUS_TYPE_HALF:
		{
			Worm* _tmp49_ = NULL;
			gint _tmp50_ = 0;
			gint _tmp51_ = 0;
			Worm* _tmp52_ = NULL;
			gint _tmp53_ = 0;
			_tmp49_ = worm;
			_tmp50_ = worm_get_length (_tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = worm;
			_tmp53_ = _tmp52_->change;
			if ((_tmp51_ + _tmp53_) > 2) {
				Worm* _tmp54_ = NULL;
				Worm* _tmp55_ = NULL;
				gint _tmp56_ = 0;
				gint _tmp57_ = 0;
				Worm* _tmp58_ = NULL;
				gint _tmp59_ = 0;
				gint _tmp60_ = 0;
				Worm* _tmp61_ = NULL;
				gint _tmp62_ = 0;
				gint _tmp63_ = 0;
				Worm* _tmp64_ = NULL;
				gint* _tmp65_ = NULL;
				gint _tmp65__length1 = 0;
				gint _tmp65__length2 = 0;
				Worm* _tmp66_ = NULL;
				gint _tmp67_ = 0;
				gint _tmp68_ = 0;
				Worm* _tmp69_ = NULL;
				gint _tmp70_ = 0;
				Worm* _tmp71_ = NULL;
				Worm* _tmp72_ = NULL;
				gint _tmp73_ = 0;
				Worm* _tmp74_ = NULL;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				Worm* _tmp77_ = NULL;
				gint _tmp78_ = 0;
				_tmp54_ = worm;
				_tmp55_ = worm;
				_tmp56_ = worm_get_score (_tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = worm;
				_tmp59_ = worm_get_length (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = worm;
				_tmp62_ = _tmp61_->change;
				_tmp63_ = self->priv->_current_level;
				worm_set_score (_tmp55_, _tmp57_ + ((_tmp60_ + (_tmp62_ / 2)) * _tmp63_));
				_tmp64_ = worm;
				_tmp65_ = self->board;
				_tmp65__length1 = self->board_length1;
				_tmp65__length2 = self->board_length2;
				_tmp66_ = worm;
				_tmp67_ = worm_get_length (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = worm;
				_tmp70_ = _tmp69_->change;
				worm_reduce_tail (_tmp64_, _tmp65_, _tmp65__length1, _tmp65__length2, (_tmp68_ + _tmp70_) / 2);
				_tmp71_ = worm;
				_tmp72_ = worm;
				_tmp73_ = _tmp72_->change;
				_tmp74_ = worm;
				_tmp75_ = worm_get_length (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = worm;
				_tmp78_ = _tmp77_->change;
				_tmp72_->change = _tmp73_ - ((_tmp76_ + _tmp78_) / 2);
			}
			break;
		}
		case BONUS_TYPE_LIFE:
		{
			Worm* _tmp79_ = NULL;
			_tmp79_ = worm;
			worm_add_life (_tmp79_);
			break;
		}
		case BONUS_TYPE_REVERSE:
		{
			Worm* _tmp80_ = NULL;
			_tmp80_ = worm;
			nibbles_game_reverse_worms (self, _tmp80_);
			break;
		}
		default:
		break;
	}
}


gboolean nibbles_game_add_bonus_cb (NibblesGame* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	nibbles_game_add_bonus (self, FALSE);
	result = G_SOURCE_CONTINUE;
	return result;
}


void nibbles_game_bonus_found_cb (NibblesGame* self, Worm* worm) {
	Bonus* bonus = NULL;
	Boni* _tmp0_ = NULL;
	gint* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp1__length2 = 0;
	Worm* _tmp2_ = NULL;
	Position _tmp3_ = {0};
	Position _tmp4_ = {0};
	gint _tmp5_ = 0;
	Worm* _tmp6_ = NULL;
	Position _tmp7_ = {0};
	Position _tmp8_ = {0};
	gint _tmp9_ = 0;
	Bonus* _tmp10_ = NULL;
	Bonus* _tmp11_ = NULL;
	Bonus* _tmp12_ = NULL;
	Worm* _tmp13_ = NULL;
	Worm* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gint* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp16__length2 = 0;
	Worm* _tmp17_ = NULL;
	Position _tmp18_ = {0};
	Position _tmp19_ = {0};
	gint _tmp20_ = 0;
	Worm* _tmp21_ = NULL;
	Position _tmp22_ = {0};
	Position _tmp23_ = {0};
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = self->priv->_boni;
	_tmp1_ = self->board;
	_tmp1__length1 = self->board_length1;
	_tmp1__length2 = self->board_length2;
	_tmp2_ = worm;
	worm_get_head (_tmp2_, &_tmp3_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_.x;
	_tmp6_ = worm;
	worm_get_head (_tmp6_, &_tmp7_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_.y;
	_tmp10_ = boni_get_bonus (_tmp0_, _tmp1_, _tmp1__length1, _tmp1__length2, _tmp5_, _tmp9_);
	bonus = _tmp10_;
	_tmp11_ = bonus;
	if (_tmp11_ == NULL) {
		_g_object_unref0 (bonus);
		return;
	}
	_tmp12_ = bonus;
	_tmp13_ = worm;
	nibbles_game_apply_bonus (self, _tmp12_, _tmp13_);
	_tmp14_ = worm;
	g_signal_emit_by_name (self, "bonus-applied", _tmp14_);
	_tmp16_ = self->board;
	_tmp16__length1 = self->board_length1;
	_tmp16__length2 = self->board_length2;
	_tmp17_ = worm;
	worm_get_head (_tmp17_, &_tmp18_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_.x;
	_tmp21_ = worm;
	worm_get_head (_tmp21_, &_tmp22_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_.y;
	_tmp25_ = _tmp16_[(_tmp20_ * _tmp16__length2) + _tmp24_];
	if (_tmp25_ == ((gint) (BONUS_TYPE_REGULAR + 'A'))) {
		Bonus* _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		_tmp26_ = bonus;
		_tmp27_ = _tmp26_->fake;
		_tmp15_ = !_tmp27_;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		Boni* _tmp28_ = NULL;
		gint* _tmp29_ = NULL;
		gint _tmp29__length1 = 0;
		gint _tmp29__length2 = 0;
		Bonus* _tmp30_ = NULL;
		Boni* _tmp31_ = NULL;
		GeeLinkedList* _tmp32_ = NULL;
		Bonus* _tmp33_ = NULL;
		Boni* _tmp34_ = NULL;
		gint _tmp35_ = 0;
		_tmp28_ = self->priv->_boni;
		_tmp29_ = self->board;
		_tmp29__length1 = self->board_length1;
		_tmp29__length2 = self->board_length2;
		_tmp30_ = bonus;
		boni_remove_bonus (_tmp28_, _tmp29_, _tmp29__length1, _tmp29__length2, _tmp30_);
		_tmp31_ = self->priv->_boni;
		_tmp32_ = _tmp31_->bonuses;
		_tmp33_ = bonus;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp32_, _tmp33_);
		_tmp34_ = self->priv->_boni;
		_tmp35_ = _tmp34_->numleft;
		if (_tmp35_ != 0) {
			nibbles_game_add_bonus (self, TRUE);
		}
	} else {
		Boni* _tmp36_ = NULL;
		gint* _tmp37_ = NULL;
		gint _tmp37__length1 = 0;
		gint _tmp37__length2 = 0;
		Bonus* _tmp38_ = NULL;
		Boni* _tmp39_ = NULL;
		GeeLinkedList* _tmp40_ = NULL;
		Bonus* _tmp41_ = NULL;
		_tmp36_ = self->priv->_boni;
		_tmp37_ = self->board;
		_tmp37__length1 = self->board_length1;
		_tmp37__length2 = self->board_length2;
		_tmp38_ = bonus;
		boni_remove_bonus (_tmp36_, _tmp37_, _tmp37__length1, _tmp37__length2, _tmp38_);
		_tmp39_ = self->priv->_boni;
		_tmp40_ = _tmp39_->bonuses;
		_tmp41_ = bonus;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp40_, _tmp41_);
	}
	_g_object_unref0 (bonus);
}


void nibbles_game_warp_found_cb (NibblesGame* self, Worm* worm) {
	Warp* warp = NULL;
	WarpManager* _tmp0_ = NULL;
	Worm* _tmp1_ = NULL;
	Position _tmp2_ = {0};
	Position _tmp3_ = {0};
	gint _tmp4_ = 0;
	Worm* _tmp5_ = NULL;
	Position _tmp6_ = {0};
	Position _tmp7_ = {0};
	gint _tmp8_ = 0;
	Warp* _tmp9_ = NULL;
	Warp* _tmp10_ = NULL;
	Worm* _tmp11_ = NULL;
	Warp* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = self->priv->_warp_manager;
	_tmp1_ = worm;
	worm_get_head (_tmp1_, &_tmp2_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_.x;
	_tmp5_ = worm;
	worm_get_head (_tmp5_, &_tmp6_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_.y;
	_tmp9_ = warp_manager_get_warp (_tmp0_, _tmp4_, _tmp8_);
	warp = _tmp9_;
	_tmp10_ = warp;
	if (_tmp10_ == NULL) {
		_g_object_unref0 (warp);
		return;
	}
	_tmp11_ = worm;
	_tmp12_ = warp;
	worm_warp (_tmp11_, _tmp12_);
	_g_object_unref0 (warp);
}


static GameStatus* _game_status_dup (GameStatus* self) {
	GameStatus* dup;
	dup = g_new0 (GameStatus, 1);
	memcpy (dup, self, sizeof (GameStatus));
	return dup;
}


static gpointer __game_status_dup0 (gpointer self) {
	return self ? _game_status_dup (self) : NULL;
}


GameStatus* nibbles_game_get_game_status (NibblesGame* self) {
	GameStatus* result = NULL;
	gint worms_left = 0;
	gboolean _tmp23_ = FALSE;
	gint _tmp24_ = 0;
	Boni* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	worms_left = 0;
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_worm_list = _tmp1_;
		_tmp2_ = _worm_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_worm_size = _tmp4_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Worm* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			_tmp5_ = _worm_index;
			_worm_index = _tmp5_ + 1;
			_tmp6_ = _worm_index;
			_tmp7_ = _worm_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _worm_list;
			_tmp9_ = _worm_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			worm = (Worm*) _tmp10_;
			_tmp11_ = worm;
			_tmp12_ = worm_get_lives (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ > 0) {
				gint _tmp14_ = 0;
				_tmp14_ = worms_left;
				worms_left = _tmp14_ + 1;
			} else {
				gboolean _tmp15_ = FALSE;
				Worm* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
				_tmp16_ = worm;
				_tmp17_ = _tmp16_->is_human;
				if (_tmp17_) {
					Worm* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					_tmp18_ = worm;
					_tmp19_ = worm_get_lives (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp15_ = _tmp20_ <= 0;
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					GameStatus _tmp21_ = 0;
					GameStatus* _tmp22_ = NULL;
					_tmp21_ = GAME_STATUS_GAMEOVER;
					_tmp22_ = __game_status_dup0 (&_tmp21_);
					result = _tmp22_;
					_g_object_unref0 (worm);
					_g_object_unref0 (_worm_list);
					return result;
				}
			}
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	_tmp24_ = worms_left;
	if (_tmp24_ == 1) {
		gint _tmp25_ = 0;
		_tmp25_ = self->priv->_numworms;
		_tmp23_ = _tmp25_ > 1;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		GameStatus _tmp26_ = 0;
		GameStatus* _tmp27_ = NULL;
		_tmp26_ = GAME_STATUS_VICTORY;
		_tmp27_ = __game_status_dup0 (&_tmp26_);
		result = _tmp27_;
		return result;
	} else {
		gint _tmp28_ = 0;
		_tmp28_ = worms_left;
		if (_tmp28_ == 0) {
			GameStatus _tmp29_ = 0;
			GameStatus* _tmp30_ = NULL;
			_tmp29_ = GAME_STATUS_GAMEOVER;
			_tmp30_ = __game_status_dup0 (&_tmp29_);
			result = _tmp30_;
			return result;
		}
	}
	_tmp31_ = self->priv->_boni;
	_tmp32_ = _tmp31_->numleft;
	if (_tmp32_ == 0) {
		GameStatus _tmp33_ = 0;
		GameStatus* _tmp34_ = NULL;
		_tmp33_ = GAME_STATUS_NEWROUND;
		_tmp34_ = __game_status_dup0 (&_tmp33_);
		result = _tmp34_;
		return result;
	}
	result = NULL;
	return result;
}


Worm* nibbles_game_get_winner (NibblesGame* self) {
	Worm* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_worm_list = _tmp1_;
		_tmp2_ = _worm_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_worm_size = _tmp4_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Worm* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			_tmp5_ = _worm_index;
			_worm_index = _tmp5_ + 1;
			_tmp6_ = _worm_index;
			_tmp7_ = _worm_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _worm_list;
			_tmp9_ = _worm_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			worm = (Worm*) _tmp10_;
			_tmp11_ = worm;
			_tmp12_ = worm_get_lives (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ > 0) {
				result = worm;
				_g_object_unref0 (_worm_list);
				return result;
			}
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	result = NULL;
	return result;
}


void nibbles_game_load_properties (NibblesGame* self, GSettings* settings) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	_tmp0_ = settings;
	_tmp1_ = g_settings_get_int (_tmp0_, "tile-size");
	nibbles_game_set_tile_size (self, _tmp1_);
	_tmp2_ = settings;
	_tmp3_ = g_settings_get_int (_tmp2_, "start-level");
	nibbles_game_set_start_level (self, _tmp3_);
}


void nibbles_game_save_properties (NibblesGame* self, GSettings* settings) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	_tmp0_ = settings;
	_tmp1_ = self->priv->_tile_size;
	g_settings_set_int (_tmp0_, "tile-size", _tmp1_);
	_tmp2_ = settings;
	_tmp3_ = self->priv->_start_level;
	g_settings_set_int (_tmp2_, "start-level", _tmp3_);
}


void nibbles_game_load_worm_properties (NibblesGame* self, GeeArrayList* worm_settings) {
	GeeHashMap* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm_settings != NULL);
	_tmp0_ = self->priv->_worm_props;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		GeeLinkedList* _tmp2_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _worm_index = 0;
		_tmp1_ = self->priv->_worms;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_worm_list = _tmp2_;
		_tmp3_ = _worm_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_worm_size = _tmp5_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			WormProperties properties = {0};
			GeeArrayList* _tmp12_ = NULL;
			Worm* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gpointer _tmp16_ = NULL;
			GSettings* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			GeeArrayList* _tmp21_ = NULL;
			Worm* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			gpointer _tmp25_ = NULL;
			GSettings* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			GeeArrayList* _tmp28_ = NULL;
			Worm* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			gpointer _tmp32_ = NULL;
			GSettings* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			GeeArrayList* _tmp35_ = NULL;
			Worm* _tmp36_ = NULL;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			gpointer _tmp39_ = NULL;
			GSettings* _tmp40_ = NULL;
			gint _tmp41_ = 0;
			GeeArrayList* _tmp42_ = NULL;
			Worm* _tmp43_ = NULL;
			gint _tmp44_ = 0;
			gint _tmp45_ = 0;
			gpointer _tmp46_ = NULL;
			GSettings* _tmp47_ = NULL;
			gint _tmp48_ = 0;
			GeeHashMap* _tmp49_ = NULL;
			Worm* _tmp50_ = NULL;
			WormProperties _tmp51_ = {0};
			_tmp6_ = _worm_index;
			_worm_index = _tmp6_ + 1;
			_tmp7_ = _worm_index;
			_tmp8_ = _worm_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _worm_list;
			_tmp10_ = _worm_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			worm = (Worm*) _tmp11_;
			memset (&properties, 0, sizeof (WormProperties));
			_tmp12_ = worm_settings;
			_tmp13_ = worm;
			_tmp14_ = worm_get_id (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp15_);
			_tmp17_ = (GSettings*) _tmp16_;
			_tmp18_ = g_settings_get_string (_tmp17_, "color");
			_tmp19_ = _tmp18_;
			_tmp20_ = nibbles_view_colorval_from_name (_tmp19_);
			properties.color = _tmp20_;
			_g_free0 (_tmp19_);
			_g_object_unref0 (_tmp17_);
			_tmp21_ = worm_settings;
			_tmp22_ = worm;
			_tmp23_ = worm_get_id (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _tmp24_);
			_tmp26_ = (GSettings*) _tmp25_;
			_tmp27_ = g_settings_get_int (_tmp26_, "key-up");
			properties.up = (guint) _tmp27_;
			_g_object_unref0 (_tmp26_);
			_tmp28_ = worm_settings;
			_tmp29_ = worm;
			_tmp30_ = worm_get_id (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp31_);
			_tmp33_ = (GSettings*) _tmp32_;
			_tmp34_ = g_settings_get_int (_tmp33_, "key-down");
			properties.down = (guint) _tmp34_;
			_g_object_unref0 (_tmp33_);
			_tmp35_ = worm_settings;
			_tmp36_ = worm;
			_tmp37_ = worm_get_id (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, _tmp38_);
			_tmp40_ = (GSettings*) _tmp39_;
			_tmp41_ = g_settings_get_int (_tmp40_, "key-left");
			properties.left = (guint) _tmp41_;
			_g_object_unref0 (_tmp40_);
			_tmp42_ = worm_settings;
			_tmp43_ = worm;
			_tmp44_ = worm_get_id (_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, _tmp45_);
			_tmp47_ = (GSettings*) _tmp46_;
			_tmp48_ = g_settings_get_int (_tmp47_, "key-right");
			properties.right = (guint) _tmp48_;
			_g_object_unref0 (_tmp47_);
			_tmp49_ = self->priv->_worm_props;
			_tmp50_ = worm;
			_tmp51_ = properties;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp49_, _tmp50_, &_tmp51_);
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
}


gboolean nibbles_game_handle_keypress (NibblesGame* self, guint keyval) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_running;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		GeeLinkedList* _tmp2_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _worm_index = 0;
		_tmp1_ = self->priv->_worms;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_worm_list = _tmp2_;
		_tmp3_ = _worm_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_worm_size = _tmp5_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			Worm* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			_tmp6_ = _worm_index;
			_worm_index = _tmp6_ + 1;
			_tmp7_ = _worm_index;
			_tmp8_ = _worm_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _worm_list;
			_tmp10_ = _worm_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			worm = (Worm*) _tmp11_;
			_tmp12_ = worm;
			_tmp13_ = _tmp12_->is_human;
			if (_tmp13_) {
				Worm* _tmp14_ = NULL;
				guint _tmp15_ = 0U;
				GeeHashMap* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
				_tmp14_ = worm;
				_tmp15_ = keyval;
				_tmp16_ = self->priv->_worm_props;
				_tmp17_ = worm_handle_keypress (_tmp14_, _tmp15_, _tmp16_);
				if (_tmp17_) {
					result = TRUE;
					_g_object_unref0 (worm);
					_g_object_unref0 (_worm_list);
					return result;
				}
			}
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	result = FALSE;
	return result;
}


gint nibbles_game_get_start_level (NibblesGame* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_start_level;
	result = _tmp0_;
	return result;
}


static void nibbles_game_set_start_level (NibblesGame* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_start_level = _tmp0_;
	g_object_notify ((GObject *) self, "start-level");
}


gint nibbles_game_get_current_level (NibblesGame* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_current_level;
	result = _tmp0_;
	return result;
}


static void nibbles_game_set_current_level (NibblesGame* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_current_level = _tmp0_;
	g_object_notify ((GObject *) self, "current-level");
}


gint nibbles_game_get_speed (NibblesGame* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_speed;
	result = _tmp0_;
	return result;
}


static void nibbles_game_set_speed (NibblesGame* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_speed = _tmp0_;
	g_object_notify ((GObject *) self, "speed");
}


gint nibbles_game_get_tile_size (NibblesGame* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_tile_size;
	result = _tmp0_;
	return result;
}


void nibbles_game_set_tile_size (NibblesGame* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_tile_size = _tmp0_;
	g_object_notify ((GObject *) self, "tile-size");
}


gint nibbles_game_get_numhumans (NibblesGame* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_numhumans;
	result = _tmp0_;
	return result;
}


void nibbles_game_set_numhumans (NibblesGame* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_numhumans = _tmp0_;
	g_object_notify ((GObject *) self, "numhumans");
}


gint nibbles_game_get_numworms (NibblesGame* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_numworms;
	result = _tmp0_;
	return result;
}


static void nibbles_game_set_numworms (NibblesGame* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_numworms = _tmp0_;
	g_object_notify ((GObject *) self, "numworms");
}


GeeLinkedList* nibbles_game_get_worms (NibblesGame* self) {
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_worms;
	result = _tmp0_;
	return result;
}


static void nibbles_game_set_worms (NibblesGame* self, GeeLinkedList* value) {
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_worms);
	self->priv->_worms = _tmp1_;
	g_object_notify ((GObject *) self, "worms");
}


Boni* nibbles_game_get_boni (NibblesGame* self) {
	Boni* result;
	Boni* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_boni;
	result = _tmp0_;
	return result;
}


static void nibbles_game_set_boni (NibblesGame* self, Boni* value) {
	Boni* _tmp0_ = NULL;
	Boni* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_boni);
	self->priv->_boni = _tmp1_;
	g_object_notify ((GObject *) self, "boni");
}


WarpManager* nibbles_game_get_warp_manager (NibblesGame* self) {
	WarpManager* result;
	WarpManager* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_warp_manager;
	result = _tmp0_;
	return result;
}


static void nibbles_game_set_warp_manager (NibblesGame* self, WarpManager* value) {
	WarpManager* _tmp0_ = NULL;
	WarpManager* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_warp_manager);
	self->priv->_warp_manager = _tmp1_;
	g_object_notify ((GObject *) self, "warp-manager");
}


GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self) {
	GeeHashMap* result;
	GeeHashMap* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_worm_props;
	result = _tmp0_;
	return result;
}


static void nibbles_game_set_worm_props (NibblesGame* self, GeeHashMap* value) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_worm_props);
	self->priv->_worm_props = _tmp1_;
	g_object_notify ((GObject *) self, "worm-props");
}


gboolean nibbles_game_get_is_running (NibblesGame* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_running;
	result = _tmp0_;
	return result;
}


static void nibbles_game_set_is_running (NibblesGame* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_running = _tmp0_;
	g_object_notify ((GObject *) self, "is-running");
}


gboolean nibbles_game_get_is_paused (NibblesGame* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_paused;
	result = _tmp0_;
	return result;
}


static void nibbles_game_set_is_paused (NibblesGame* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_paused = _tmp0_;
	g_object_notify ((GObject *) self, "is-paused");
}


gboolean nibbles_game_get_fakes (NibblesGame* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_fakes;
	result = _tmp0_;
	return result;
}


static void nibbles_game_set_fakes (NibblesGame* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_fakes = _tmp0_;
	g_object_notify ((GObject *) self, "fakes");
}


static void nibbles_game_class_init (NibblesGameClass * klass) {
	nibbles_game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NibblesGamePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_nibbles_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_nibbles_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = nibbles_game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_START_LEVEL, g_param_spec_int ("start-level", "start-level", "start-level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_CURRENT_LEVEL, g_param_spec_int ("current-level", "current-level", "current-level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_SPEED, g_param_spec_int ("speed", "speed", "speed", G_MININT, G_MAXINT, 2, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_TILE_SIZE, g_param_spec_int ("tile-size", "tile-size", "tile-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_NUMHUMANS, g_param_spec_int ("numhumans", "numhumans", "numhumans", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_NUMWORMS, g_param_spec_int ("numworms", "numworms", "numworms", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WORMS, g_param_spec_object ("worms", "worms", "worms", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_BONI, g_param_spec_object ("boni", "boni", "boni", TYPE_BONI, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WARP_MANAGER, g_param_spec_object ("warp-manager", "warp-manager", "warp-manager", TYPE_WARP_MANAGER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WORM_PROPS, g_param_spec_object ("worm-props", "worm-props", "worm-props", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_IS_RUNNING, g_param_spec_boolean ("is-running", "is-running", "is-running", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_IS_PAUSED, g_param_spec_boolean ("is-paused", "is-paused", "is-paused", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_FAKES, g_param_spec_boolean ("fakes", "fakes", "fakes", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("worm_moved", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_WORM);
	g_signal_new ("bonus_applied", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_WORM);
	g_signal_new ("log_score", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	g_signal_new ("animate_end_game", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("level_completed", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void nibbles_game_instance_init (NibblesGame * self) {
	self->priv = NIBBLES_GAME_GET_PRIVATE (self);
	self->priv->_speed = 2;
	self->priv->numai = 3;
	self->priv->_is_running = FALSE;
	self->priv->main_id = (guint) 0;
	self->priv->add_bonus_id = (guint) 0;
	self->priv->_fakes = FALSE;
}


static void nibbles_game_finalize (GObject* obj) {
	NibblesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_GAME, NibblesGame);
	self->board = (g_free (self->board), NULL);
	_g_object_unref0 (self->priv->_worms);
	_g_object_unref0 (self->priv->_boni);
	_g_object_unref0 (self->priv->_warp_manager);
	_g_object_unref0 (self->priv->_worm_props);
	G_OBJECT_CLASS (nibbles_game_parent_class)->finalize (obj);
}


GType nibbles_game_get_type (void) {
	static volatile gsize nibbles_game_type_id__volatile = 0;
	if (g_once_init_enter (&nibbles_game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NibblesGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesGame), 0, (GInstanceInitFunc) nibbles_game_instance_init, NULL };
		GType nibbles_game_type_id;
		nibbles_game_type_id = g_type_register_static (G_TYPE_OBJECT, "NibblesGame", &g_define_type_info, 0);
		g_once_init_leave (&nibbles_game_type_id__volatile, nibbles_game_type_id);
	}
	return nibbles_game_type_id__volatile;
}


static void _vala_nibbles_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NibblesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_GAME, NibblesGame);
	switch (property_id) {
		case NIBBLES_GAME_START_LEVEL:
		g_value_set_int (value, nibbles_game_get_start_level (self));
		break;
		case NIBBLES_GAME_CURRENT_LEVEL:
		g_value_set_int (value, nibbles_game_get_current_level (self));
		break;
		case NIBBLES_GAME_SPEED:
		g_value_set_int (value, nibbles_game_get_speed (self));
		break;
		case NIBBLES_GAME_TILE_SIZE:
		g_value_set_int (value, nibbles_game_get_tile_size (self));
		break;
		case NIBBLES_GAME_NUMHUMANS:
		g_value_set_int (value, nibbles_game_get_numhumans (self));
		break;
		case NIBBLES_GAME_NUMWORMS:
		g_value_set_int (value, nibbles_game_get_numworms (self));
		break;
		case NIBBLES_GAME_WORMS:
		g_value_set_object (value, nibbles_game_get_worms (self));
		break;
		case NIBBLES_GAME_BONI:
		g_value_set_object (value, nibbles_game_get_boni (self));
		break;
		case NIBBLES_GAME_WARP_MANAGER:
		g_value_set_object (value, nibbles_game_get_warp_manager (self));
		break;
		case NIBBLES_GAME_WORM_PROPS:
		g_value_set_object (value, nibbles_game_get_worm_props (self));
		break;
		case NIBBLES_GAME_IS_RUNNING:
		g_value_set_boolean (value, nibbles_game_get_is_running (self));
		break;
		case NIBBLES_GAME_IS_PAUSED:
		g_value_set_boolean (value, nibbles_game_get_is_paused (self));
		break;
		case NIBBLES_GAME_FAKES:
		g_value_set_boolean (value, nibbles_game_get_fakes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_nibbles_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NibblesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_GAME, NibblesGame);
	switch (property_id) {
		case NIBBLES_GAME_START_LEVEL:
		nibbles_game_set_start_level (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_CURRENT_LEVEL:
		nibbles_game_set_current_level (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_SPEED:
		nibbles_game_set_speed (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_TILE_SIZE:
		nibbles_game_set_tile_size (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_NUMHUMANS:
		nibbles_game_set_numhumans (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_NUMWORMS:
		nibbles_game_set_numworms (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_WORMS:
		nibbles_game_set_worms (self, g_value_get_object (value));
		break;
		case NIBBLES_GAME_BONI:
		nibbles_game_set_boni (self, g_value_get_object (value));
		break;
		case NIBBLES_GAME_WARP_MANAGER:
		nibbles_game_set_warp_manager (self, g_value_get_object (value));
		break;
		case NIBBLES_GAME_WORM_PROPS:
		nibbles_game_set_worm_props (self, g_value_get_object (value));
		break;
		case NIBBLES_GAME_IS_RUNNING:
		nibbles_game_set_is_running (self, g_value_get_boolean (value));
		break;
		case NIBBLES_GAME_IS_PAUSED:
		nibbles_game_set_is_paused (self, g_value_get_boolean (value));
		break;
		case NIBBLES_GAME_FAKES:
		nibbles_game_set_fakes (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



