/* rygel-http-byte-seek-response.c generated by valac 0.30.0.3-b11d, the Vala compiler
 * generated from rygel-http-byte-seek-response.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;
typedef struct _RygelHTTPResponseElementPrivate RygelHTTPResponseElementPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK_RESPONSE (rygel_http_byte_seek_response_get_type ())
#define RYGEL_HTTP_BYTE_SEEK_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_RESPONSE, RygelHTTPByteSeekResponse))
#define RYGEL_HTTP_BYTE_SEEK_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_RESPONSE, RygelHTTPByteSeekResponseClass))
#define RYGEL_IS_HTTP_BYTE_SEEK_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_RESPONSE))
#define RYGEL_IS_HTTP_BYTE_SEEK_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_RESPONSE))
#define RYGEL_HTTP_BYTE_SEEK_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_RESPONSE, RygelHTTPByteSeekResponseClass))

typedef struct _RygelHTTPByteSeekResponse RygelHTTPByteSeekResponse;
typedef struct _RygelHTTPByteSeekResponseClass RygelHTTPByteSeekResponseClass;
typedef struct _RygelHTTPByteSeekResponsePrivate RygelHTTPByteSeekResponsePrivate;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST (rygel_http_byte_seek_request_get_type ())
#define RYGEL_HTTP_BYTE_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest))
#define RYGEL_HTTP_BYTE_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequestClass))
#define RYGEL_IS_HTTP_BYTE_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST))
#define RYGEL_IS_HTTP_BYTE_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST))
#define RYGEL_HTTP_BYTE_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequestClass))

typedef struct _RygelHTTPByteSeekRequest RygelHTTPByteSeekRequest;
typedef struct _RygelHTTPByteSeekRequestClass RygelHTTPByteSeekRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

struct _RygelHTTPResponseElement {
	GObject parent_instance;
	RygelHTTPResponseElementPrivate * priv;
};

struct _RygelHTTPResponseElementClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPResponseElement* self, RygelHTTPRequest* request);
	gchar* (*to_string) (RygelHTTPResponseElement* self);
};

struct _RygelHTTPByteSeekResponse {
	RygelHTTPResponseElement parent_instance;
	RygelHTTPByteSeekResponsePrivate * priv;
};

struct _RygelHTTPByteSeekResponseClass {
	RygelHTTPResponseElementClass parent_class;
};

struct _RygelHTTPByteSeekResponsePrivate {
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _range_length;
	gint64 _total_size;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_http_byte_seek_response_parent_class = NULL;

GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_byte_seek_response_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_BYTE_SEEK_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_BYTE_SEEK_RESPONSE, RygelHTTPByteSeekResponsePrivate))
enum  {
	RYGEL_HTTP_BYTE_SEEK_RESPONSE_DUMMY_PROPERTY,
	RYGEL_HTTP_BYTE_SEEK_RESPONSE_START_BYTE,
	RYGEL_HTTP_BYTE_SEEK_RESPONSE_END_BYTE,
	RYGEL_HTTP_BYTE_SEEK_RESPONSE_RANGE_LENGTH,
	RYGEL_HTTP_BYTE_SEEK_RESPONSE_TOTAL_SIZE
};
RygelHTTPByteSeekResponse* rygel_http_byte_seek_response_new (gint64 start_byte, gint64 end_byte, gint64 total_size);
RygelHTTPByteSeekResponse* rygel_http_byte_seek_response_construct (GType object_type, gint64 start_byte, gint64 end_byte, gint64 total_size);
RygelHTTPResponseElement* rygel_http_response_element_construct (GType object_type);
void rygel_http_byte_seek_response_set_start_byte (RygelHTTPByteSeekResponse* self, gint64 value);
void rygel_http_byte_seek_response_set_end_byte (RygelHTTPByteSeekResponse* self, gint64 value);
static void rygel_http_byte_seek_response_set_range_length (RygelHTTPByteSeekResponse* self, gint64 value);
void rygel_http_byte_seek_response_set_total_size (RygelHTTPByteSeekResponse* self, gint64 value);
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_http_byte_seek_request_get_type (void) G_GNUC_CONST;
RygelHTTPByteSeekResponse* rygel_http_byte_seek_response_new_from_request (RygelHTTPByteSeekRequest* request);
RygelHTTPByteSeekResponse* rygel_http_byte_seek_response_construct_from_request (GType object_type, RygelHTTPByteSeekRequest* request);
gint64 rygel_http_byte_seek_request_get_start_byte (RygelHTTPByteSeekRequest* self);
gint64 rygel_http_byte_seek_request_get_end_byte (RygelHTTPByteSeekRequest* self);
gint64 rygel_http_byte_seek_request_get_range_length (RygelHTTPByteSeekRequest* self);
gint64 rygel_http_byte_seek_request_get_total_size (RygelHTTPByteSeekRequest* self);
static void rygel_http_byte_seek_response_real_add_response_headers (RygelHTTPResponseElement* base, RygelHTTPRequest* request);
gint64 rygel_http_byte_seek_response_get_end_byte (RygelHTTPByteSeekResponse* self);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
gint64 rygel_http_byte_seek_response_get_start_byte (RygelHTTPByteSeekResponse* self);
gint64 rygel_http_byte_seek_response_get_total_size (RygelHTTPByteSeekResponse* self);
gint64 rygel_http_byte_seek_response_get_range_length (RygelHTTPByteSeekResponse* self);
static gchar* rygel_http_byte_seek_response_real_to_string (RygelHTTPResponseElement* base);
static void rygel_http_byte_seek_response_finalize (GObject* obj);
static void _vala_rygel_http_byte_seek_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_byte_seek_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


RygelHTTPByteSeekResponse* rygel_http_byte_seek_response_construct (GType object_type, gint64 start_byte, gint64 end_byte, gint64 total_size) {
	RygelHTTPByteSeekResponse * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	self = (RygelHTTPByteSeekResponse*) rygel_http_response_element_construct (object_type);
	_tmp0_ = start_byte;
	rygel_http_byte_seek_response_set_start_byte (self, _tmp0_);
	_tmp1_ = end_byte;
	rygel_http_byte_seek_response_set_end_byte (self, _tmp1_);
	_tmp2_ = end_byte;
	_tmp3_ = start_byte;
	rygel_http_byte_seek_response_set_range_length (self, (_tmp2_ - _tmp3_) + 1);
	_tmp4_ = total_size;
	rygel_http_byte_seek_response_set_total_size (self, _tmp4_);
	return self;
}


RygelHTTPByteSeekResponse* rygel_http_byte_seek_response_new (gint64 start_byte, gint64 end_byte, gint64 total_size) {
	return rygel_http_byte_seek_response_construct (RYGEL_TYPE_HTTP_BYTE_SEEK_RESPONSE, start_byte, end_byte, total_size);
}


RygelHTTPByteSeekResponse* rygel_http_byte_seek_response_construct_from_request (GType object_type, RygelHTTPByteSeekRequest* request) {
	RygelHTTPByteSeekResponse * self = NULL;
	RygelHTTPByteSeekRequest* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	RygelHTTPByteSeekRequest* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	RygelHTTPByteSeekRequest* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp8_ = 0LL;
	RygelHTTPByteSeekRequest* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gint64 _tmp11_ = 0LL;
	g_return_val_if_fail (request != NULL, NULL);
	self = (RygelHTTPByteSeekResponse*) rygel_http_response_element_construct (object_type);
	_tmp0_ = request;
	_tmp1_ = rygel_http_byte_seek_request_get_start_byte (_tmp0_);
	_tmp2_ = _tmp1_;
	rygel_http_byte_seek_response_set_start_byte (self, _tmp2_);
	_tmp3_ = request;
	_tmp4_ = rygel_http_byte_seek_request_get_end_byte (_tmp3_);
	_tmp5_ = _tmp4_;
	rygel_http_byte_seek_response_set_end_byte (self, _tmp5_);
	_tmp6_ = request;
	_tmp7_ = rygel_http_byte_seek_request_get_range_length (_tmp6_);
	_tmp8_ = _tmp7_;
	rygel_http_byte_seek_response_set_range_length (self, _tmp8_);
	_tmp9_ = request;
	_tmp10_ = rygel_http_byte_seek_request_get_total_size (_tmp9_);
	_tmp11_ = _tmp10_;
	rygel_http_byte_seek_response_set_total_size (self, _tmp11_);
	return self;
}


RygelHTTPByteSeekResponse* rygel_http_byte_seek_response_new_from_request (RygelHTTPByteSeekRequest* request) {
	return rygel_http_byte_seek_response_construct_from_request (RYGEL_TYPE_HTTP_BYTE_SEEK_RESPONSE, request);
}


static void rygel_http_byte_seek_response_real_add_response_headers (RygelHTTPResponseElement* base, RygelHTTPRequest* request) {
	RygelHTTPByteSeekResponse * self;
	gint64 _tmp0_ = 0LL;
	self = (RygelHTTPByteSeekResponse*) base;
	g_return_if_fail (request != NULL);
	_tmp0_ = self->priv->_end_byte;
	if (_tmp0_ != ((gint64) -1)) {
		RygelHTTPRequest* _tmp1_ = NULL;
		SoupMessage* _tmp2_ = NULL;
		SoupMessageHeaders* _tmp3_ = NULL;
		gint64 _tmp4_ = 0LL;
		gint64 _tmp5_ = 0LL;
		gint64 _tmp6_ = 0LL;
		RygelHTTPRequest* _tmp7_ = NULL;
		SoupMessage* _tmp8_ = NULL;
		SoupMessageHeaders* _tmp9_ = NULL;
		RygelHTTPRequest* _tmp10_ = NULL;
		SoupMessage* _tmp11_ = NULL;
		SoupMessageHeaders* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
		_tmp1_ = request;
		_tmp2_ = _tmp1_->msg;
		_tmp3_ = _tmp2_->response_headers;
		_tmp4_ = self->priv->_start_byte;
		_tmp5_ = self->priv->_end_byte;
		_tmp6_ = self->priv->_total_size;
		soup_message_headers_set_content_range (_tmp3_, _tmp4_, _tmp5_, _tmp6_);
		_tmp7_ = request;
		_tmp8_ = _tmp7_->msg;
		_tmp9_ = _tmp8_->response_headers;
		soup_message_headers_append (_tmp9_, "Accept-Ranges", "bytes");
		_tmp10_ = request;
		_tmp11_ = _tmp10_->msg;
		_tmp12_ = _tmp11_->response_headers;
		_tmp13_ = self->priv->_range_length;
		soup_message_headers_set_content_length (_tmp12_, _tmp13_);
	}
}


static gchar* rygel_http_byte_seek_response_real_to_string (RygelHTTPResponseElement* base) {
	RygelHTTPByteSeekResponse * self;
	gchar* result = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gchar* _tmp4_ = NULL;
	self = (RygelHTTPByteSeekResponse*) base;
	_tmp0_ = self->priv->_start_byte;
	_tmp1_ = self->priv->_end_byte;
	_tmp2_ = self->priv->_total_size;
	_tmp3_ = self->priv->_range_length;
	_tmp4_ = g_strdup_printf ("HTTPByteSeekResponse(bytes=%lld-%lld/%lld (%lld bytes))", _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


gint64 rygel_http_byte_seek_response_get_start_byte (RygelHTTPByteSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_start_byte;
	result = _tmp0_;
	return result;
}


void rygel_http_byte_seek_response_set_start_byte (RygelHTTPByteSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_start_byte = _tmp0_;
	g_object_notify ((GObject *) self, "start-byte");
}


gint64 rygel_http_byte_seek_response_get_end_byte (RygelHTTPByteSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_end_byte;
	result = _tmp0_;
	return result;
}


void rygel_http_byte_seek_response_set_end_byte (RygelHTTPByteSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_end_byte = _tmp0_;
	g_object_notify ((GObject *) self, "end-byte");
}


gint64 rygel_http_byte_seek_response_get_range_length (RygelHTTPByteSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_range_length;
	result = _tmp0_;
	return result;
}


static void rygel_http_byte_seek_response_set_range_length (RygelHTTPByteSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_range_length = _tmp0_;
	g_object_notify ((GObject *) self, "range-length");
}


gint64 rygel_http_byte_seek_response_get_total_size (RygelHTTPByteSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_total_size;
	result = _tmp0_;
	return result;
}


void rygel_http_byte_seek_response_set_total_size (RygelHTTPByteSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_total_size = _tmp0_;
	g_object_notify ((GObject *) self, "total-size");
}


static void rygel_http_byte_seek_response_class_init (RygelHTTPByteSeekResponseClass * klass) {
	rygel_http_byte_seek_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPByteSeekResponsePrivate));
	((RygelHTTPResponseElementClass *) klass)->add_response_headers = rygel_http_byte_seek_response_real_add_response_headers;
	((RygelHTTPResponseElementClass *) klass)->to_string = rygel_http_byte_seek_response_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_byte_seek_response_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_byte_seek_response_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_byte_seek_response_finalize;
	/**
	     * The start of the range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_RESPONSE_START_BYTE, g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The end of the range in bytes (inclusive)
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_RESPONSE_END_BYTE, g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The length of the range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_RESPONSE_RANGE_LENGTH, g_param_spec_int64 ("range-length", "range-length", "range-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The length of the resource in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_RESPONSE_TOTAL_SIZE, g_param_spec_int64 ("total-size", "total-size", "total-size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_http_byte_seek_response_instance_init (RygelHTTPByteSeekResponse * self) {
	self->priv = RYGEL_HTTP_BYTE_SEEK_RESPONSE_GET_PRIVATE (self);
}


static void rygel_http_byte_seek_response_finalize (GObject* obj) {
	RygelHTTPByteSeekResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_BYTE_SEEK_RESPONSE, RygelHTTPByteSeekResponse);
	G_OBJECT_CLASS (rygel_http_byte_seek_response_parent_class)->finalize (obj);
}


GType rygel_http_byte_seek_response_get_type (void) {
	static volatile gsize rygel_http_byte_seek_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeekResponse), 0, (GInstanceInitFunc) rygel_http_byte_seek_response_instance_init, NULL };
		GType rygel_http_byte_seek_response_type_id;
		rygel_http_byte_seek_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, "RygelHTTPByteSeekResponse", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_byte_seek_response_type_id__volatile, rygel_http_byte_seek_response_type_id);
	}
	return rygel_http_byte_seek_response_type_id__volatile;
}


static void _vala_rygel_http_byte_seek_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPByteSeekResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_BYTE_SEEK_RESPONSE, RygelHTTPByteSeekResponse);
	switch (property_id) {
		case RYGEL_HTTP_BYTE_SEEK_RESPONSE_START_BYTE:
		g_value_set_int64 (value, rygel_http_byte_seek_response_get_start_byte (self));
		break;
		case RYGEL_HTTP_BYTE_SEEK_RESPONSE_END_BYTE:
		g_value_set_int64 (value, rygel_http_byte_seek_response_get_end_byte (self));
		break;
		case RYGEL_HTTP_BYTE_SEEK_RESPONSE_RANGE_LENGTH:
		g_value_set_int64 (value, rygel_http_byte_seek_response_get_range_length (self));
		break;
		case RYGEL_HTTP_BYTE_SEEK_RESPONSE_TOTAL_SIZE:
		g_value_set_int64 (value, rygel_http_byte_seek_response_get_total_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_byte_seek_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPByteSeekResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_BYTE_SEEK_RESPONSE, RygelHTTPByteSeekResponse);
	switch (property_id) {
		case RYGEL_HTTP_BYTE_SEEK_RESPONSE_START_BYTE:
		rygel_http_byte_seek_response_set_start_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_BYTE_SEEK_RESPONSE_END_BYTE:
		rygel_http_byte_seek_response_set_end_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_BYTE_SEEK_RESPONSE_RANGE_LENGTH:
		rygel_http_byte_seek_response_set_range_length (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_BYTE_SEEK_RESPONSE_TOTAL_SIZE:
		rygel_http_byte_seek_response_set_total_size (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



